// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use Cancellable;
use Error;
use Icon;
use InputStream;
use ffi;
#[cfg(feature = "futures")]
use futures_core;
use glib::GString;
use glib::object::IsA;
use glib::translate::*;
use glib_ffi;
use gobject_ffi;
#[cfg(feature = "futures")]
use std::boxed::Box as Box_;
use std::fmt;
use std::ptr;

glib_wrapper! {
    pub struct LoadableIcon(Interface<ffi::GLoadableIcon>) @requires Icon;

    match fn {
        get_type => || ffi::g_loadable_icon_get_type(),
    }
}

pub const NONE_LOADABLE_ICON: Option<&LoadableIcon> = None;

pub trait LoadableIconExt: 'static {
    fn load<'a, P: IsA<Cancellable> + 'a, Q: Into<Option<&'a P>>>(&self, size: i32, cancellable: Q) -> Result<(InputStream, GString), Error>;

    fn load_async<'a, P: IsA<Cancellable> + 'a, Q: Into<Option<&'a P>>, R: FnOnce(Result<(InputStream, GString), Error>) + Send + 'static>(&self, size: i32, cancellable: Q, callback: R);

    #[cfg(feature = "futures")]
    fn load_async_future(&self, size: i32) -> Box_<futures_core::Future<Item = (Self, (InputStream, GString)), Error = (Self, Error)>> where Self: Sized + Clone;
}

impl<O: IsA<LoadableIcon>> LoadableIconExt for O {
    fn load<'a, P: IsA<Cancellable> + 'a, Q: Into<Option<&'a P>>>(&self, size: i32, cancellable: Q) -> Result<(InputStream, GString), Error> {
        let cancellable = cancellable.into();
        unsafe {
            let mut type_ = ptr::null_mut();
            let mut error = ptr::null_mut();
            let ret = ffi::g_loadable_icon_load(self.as_ref().to_glib_none().0, size, &mut type_, cancellable.map(|p| p.as_ref()).to_glib_none().0, &mut error);
            if error.is_null() { Ok((from_glib_full(ret), from_glib_full(type_))) } else { Err(from_glib_full(error)) }
        }
    }

    fn load_async<'a, P: IsA<Cancellable> + 'a, Q: Into<Option<&'a P>>, R: FnOnce(Result<(InputStream, GString), Error>) + Send + 'static>(&self, size: i32, cancellable: Q, callback: R) {
        let cancellable = cancellable.into();
        let user_data: Box<R> = Box::new(callback);
        unsafe extern "C" fn load_async_trampoline<R: FnOnce(Result<(InputStream, GString), Error>) + Send + 'static>(_source_object: *mut gobject_ffi::GObject, res: *mut ffi::GAsyncResult, user_data: glib_ffi::gpointer) {
            let mut error = ptr::null_mut();
            let mut type_ = ptr::null_mut();
            let ret = ffi::g_loadable_icon_load_finish(_source_object as *mut _, res, &mut type_, &mut error);
            let result = if error.is_null() { Ok((from_glib_full(ret), from_glib_full(type_))) } else { Err(from_glib_full(error)) };
            let callback: Box<R> = Box::from_raw(user_data as *mut _);
            callback(result);
        }
        let callback = load_async_trampoline::<R>;
        unsafe {
            ffi::g_loadable_icon_load_async(self.as_ref().to_glib_none().0, size, cancellable.map(|p| p.as_ref()).to_glib_none().0, Some(callback), Box::into_raw(user_data) as *mut _);
        }
    }

    #[cfg(feature = "futures")]
    fn load_async_future(&self, size: i32) -> Box_<futures_core::Future<Item = (Self, (InputStream, GString)), Error = (Self, Error)>> where Self: Sized + Clone {
        use GioFuture;
        use fragile::Fragile;

        GioFuture::new(self, move |obj, send| {
            let cancellable = Cancellable::new();
            let send = Fragile::new(send);
            let obj_clone = Fragile::new(obj.clone());
            obj.load_async(
                 size,
                 Some(&cancellable),
                 move |res| {
                     let obj = obj_clone.into_inner();
                     let res = res.map(|v| (obj.clone(), v)).map_err(|v| (obj.clone(), v));
                     let _ = send.into_inner().send(res);
                 },
            );

            cancellable
        })
    }
}

impl fmt::Display for LoadableIcon {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "LoadableIcon")
    }
}
