// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use Cancellable;
use DataStreamByteOrder;
use Error;
use FilterOutputStream;
use OutputStream;
use Seekable;
use ffi;
use glib::object::Cast;
use glib::object::IsA;
use glib::signal::SignalHandlerId;
use glib::signal::connect_raw;
use glib::translate::*;
use glib_ffi;
use std::boxed::Box as Box_;
use std::fmt;
use std::mem::transmute;
use std::ptr;

glib_wrapper! {
    pub struct DataOutputStream(Object<ffi::GDataOutputStream, ffi::GDataOutputStreamClass, DataOutputStreamClass>) @extends FilterOutputStream, OutputStream, @implements Seekable;

    match fn {
        get_type => || ffi::g_data_output_stream_get_type(),
    }
}

impl DataOutputStream {
    pub fn new<P: IsA<OutputStream>>(base_stream: &P) -> DataOutputStream {
        unsafe {
            from_glib_full(ffi::g_data_output_stream_new(base_stream.as_ref().to_glib_none().0))
        }
    }
}

pub const NONE_DATA_OUTPUT_STREAM: Option<&DataOutputStream> = None;

pub trait DataOutputStreamExt: 'static {
    fn get_byte_order(&self) -> DataStreamByteOrder;

    fn put_byte<'a, P: IsA<Cancellable> + 'a, Q: Into<Option<&'a P>>>(&self, data: u8, cancellable: Q) -> Result<(), Error>;

    fn put_int16<'a, P: IsA<Cancellable> + 'a, Q: Into<Option<&'a P>>>(&self, data: i16, cancellable: Q) -> Result<(), Error>;

    fn put_int32<'a, P: IsA<Cancellable> + 'a, Q: Into<Option<&'a P>>>(&self, data: i32, cancellable: Q) -> Result<(), Error>;

    fn put_int64<'a, P: IsA<Cancellable> + 'a, Q: Into<Option<&'a P>>>(&self, data: i64, cancellable: Q) -> Result<(), Error>;

    fn put_string<'a, P: IsA<Cancellable> + 'a, Q: Into<Option<&'a P>>>(&self, str: &str, cancellable: Q) -> Result<(), Error>;

    fn put_uint16<'a, P: IsA<Cancellable> + 'a, Q: Into<Option<&'a P>>>(&self, data: u16, cancellable: Q) -> Result<(), Error>;

    fn put_uint32<'a, P: IsA<Cancellable> + 'a, Q: Into<Option<&'a P>>>(&self, data: u32, cancellable: Q) -> Result<(), Error>;

    fn put_uint64<'a, P: IsA<Cancellable> + 'a, Q: Into<Option<&'a P>>>(&self, data: u64, cancellable: Q) -> Result<(), Error>;

    fn set_byte_order(&self, order: DataStreamByteOrder);

    fn connect_property_byte_order_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;
}

impl<O: IsA<DataOutputStream>> DataOutputStreamExt for O {
    fn get_byte_order(&self) -> DataStreamByteOrder {
        unsafe {
            from_glib(ffi::g_data_output_stream_get_byte_order(self.as_ref().to_glib_none().0))
        }
    }

    fn put_byte<'a, P: IsA<Cancellable> + 'a, Q: Into<Option<&'a P>>>(&self, data: u8, cancellable: Q) -> Result<(), Error> {
        let cancellable = cancellable.into();
        unsafe {
            let mut error = ptr::null_mut();
            let _ = ffi::g_data_output_stream_put_byte(self.as_ref().to_glib_none().0, data, cancellable.map(|p| p.as_ref()).to_glib_none().0, &mut error);
            if error.is_null() { Ok(()) } else { Err(from_glib_full(error)) }
        }
    }

    fn put_int16<'a, P: IsA<Cancellable> + 'a, Q: Into<Option<&'a P>>>(&self, data: i16, cancellable: Q) -> Result<(), Error> {
        let cancellable = cancellable.into();
        unsafe {
            let mut error = ptr::null_mut();
            let _ = ffi::g_data_output_stream_put_int16(self.as_ref().to_glib_none().0, data, cancellable.map(|p| p.as_ref()).to_glib_none().0, &mut error);
            if error.is_null() { Ok(()) } else { Err(from_glib_full(error)) }
        }
    }

    fn put_int32<'a, P: IsA<Cancellable> + 'a, Q: Into<Option<&'a P>>>(&self, data: i32, cancellable: Q) -> Result<(), Error> {
        let cancellable = cancellable.into();
        unsafe {
            let mut error = ptr::null_mut();
            let _ = ffi::g_data_output_stream_put_int32(self.as_ref().to_glib_none().0, data, cancellable.map(|p| p.as_ref()).to_glib_none().0, &mut error);
            if error.is_null() { Ok(()) } else { Err(from_glib_full(error)) }
        }
    }

    fn put_int64<'a, P: IsA<Cancellable> + 'a, Q: Into<Option<&'a P>>>(&self, data: i64, cancellable: Q) -> Result<(), Error> {
        let cancellable = cancellable.into();
        unsafe {
            let mut error = ptr::null_mut();
            let _ = ffi::g_data_output_stream_put_int64(self.as_ref().to_glib_none().0, data, cancellable.map(|p| p.as_ref()).to_glib_none().0, &mut error);
            if error.is_null() { Ok(()) } else { Err(from_glib_full(error)) }
        }
    }

    fn put_string<'a, P: IsA<Cancellable> + 'a, Q: Into<Option<&'a P>>>(&self, str: &str, cancellable: Q) -> Result<(), Error> {
        let cancellable = cancellable.into();
        unsafe {
            let mut error = ptr::null_mut();
            let _ = ffi::g_data_output_stream_put_string(self.as_ref().to_glib_none().0, str.to_glib_none().0, cancellable.map(|p| p.as_ref()).to_glib_none().0, &mut error);
            if error.is_null() { Ok(()) } else { Err(from_glib_full(error)) }
        }
    }

    fn put_uint16<'a, P: IsA<Cancellable> + 'a, Q: Into<Option<&'a P>>>(&self, data: u16, cancellable: Q) -> Result<(), Error> {
        let cancellable = cancellable.into();
        unsafe {
            let mut error = ptr::null_mut();
            let _ = ffi::g_data_output_stream_put_uint16(self.as_ref().to_glib_none().0, data, cancellable.map(|p| p.as_ref()).to_glib_none().0, &mut error);
            if error.is_null() { Ok(()) } else { Err(from_glib_full(error)) }
        }
    }

    fn put_uint32<'a, P: IsA<Cancellable> + 'a, Q: Into<Option<&'a P>>>(&self, data: u32, cancellable: Q) -> Result<(), Error> {
        let cancellable = cancellable.into();
        unsafe {
            let mut error = ptr::null_mut();
            let _ = ffi::g_data_output_stream_put_uint32(self.as_ref().to_glib_none().0, data, cancellable.map(|p| p.as_ref()).to_glib_none().0, &mut error);
            if error.is_null() { Ok(()) } else { Err(from_glib_full(error)) }
        }
    }

    fn put_uint64<'a, P: IsA<Cancellable> + 'a, Q: Into<Option<&'a P>>>(&self, data: u64, cancellable: Q) -> Result<(), Error> {
        let cancellable = cancellable.into();
        unsafe {
            let mut error = ptr::null_mut();
            let _ = ffi::g_data_output_stream_put_uint64(self.as_ref().to_glib_none().0, data, cancellable.map(|p| p.as_ref()).to_glib_none().0, &mut error);
            if error.is_null() { Ok(()) } else { Err(from_glib_full(error)) }
        }
    }

    fn set_byte_order(&self, order: DataStreamByteOrder) {
        unsafe {
            ffi::g_data_output_stream_set_byte_order(self.as_ref().to_glib_none().0, order.to_glib());
        }
    }

    fn connect_property_byte_order_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::byte-order\0".as_ptr() as *const _,
                Some(transmute(notify_byte_order_trampoline::<Self, F> as usize)), Box_::into_raw(f))
        }
    }
}

unsafe extern "C" fn notify_byte_order_trampoline<P, F: Fn(&P) + 'static>(this: *mut ffi::GDataOutputStream, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<DataOutputStream> {
    let f: &F = transmute(f);
    f(&DataOutputStream::from_glib_borrow(this).unsafe_cast())
}

impl fmt::Display for DataOutputStream {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "DataOutputStream")
    }
}
