// Generated by gmmproc 2.61.1 -- DO NOT MODIFY!
#ifndef _GDKMM_SURFACE_H
#define _GDKMM_SURFACE_H

#include <gdkmmconfig.h>


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* Copyright(C) 1998-2010 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License or(at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


#include <glibmm/object.h>
#include <gdkmm/drag.h>
#include <gdkmm/types.h>
#include <cairomm/region.h>
#include <cairomm/pattern.h>
#include <gdkmm/device.h>
#include <gdkmm/event.h>
#include <gdkmm/rectangle.h>
#include <gdkmm/rgba.h>
#include <cairomm/context.h>
#include <gdk/gdk.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Gdk
{ class Surface_Class; } // namespace Gdk
#endif //DOXYGEN_SHOULD_SKIP_THIS

namespace Gdk
{

/** @addtogroup gdkmmEnums gdkmm Enums and Flags */

/** 
 *  @var WMDecoration ALL
 * All decorations should be applied.
 * 
 *  @var WMDecoration BORDER
 * A frame should be drawn around the surface.
 * 
 *  @var WMDecoration RESIZEH
 * The frame should have resize handles.
 * 
 *  @var WMDecoration TITLE
 * A titlebar should be placed above the surface.
 * 
 *  @var WMDecoration MENU
 * A button for opening a menu should be included.
 * 
 *  @var WMDecoration MINIMIZE
 * A minimize button should be included.
 * 
 *  @var WMDecoration MAXIMIZE
 * A maximize button should be included.
 * 
 *  @enum WMDecoration
 * 
 * These are hints originally defined by the Motif toolkit.
 * The window manager can use them when determining how to decorate
 * the surface. The hint must be set before mapping the surface.
 *
 * @ingroup gdkmmEnums
 * @par Bitwise operators:
 * <tt>WMDecoration operator|(WMDecoration, WMDecoration)</tt><br>
 * <tt>WMDecoration operator&(WMDecoration, WMDecoration)</tt><br>
 * <tt>WMDecoration operator^(WMDecoration, WMDecoration)</tt><br>
 * <tt>WMDecoration operator~(WMDecoration)</tt><br>
 * <tt>WMDecoration& operator|=(WMDecoration&, WMDecoration)</tt><br>
 * <tt>WMDecoration& operator&=(WMDecoration&, WMDecoration)</tt><br>
 * <tt>WMDecoration& operator^=(WMDecoration&, WMDecoration)</tt><br>
 */
enum class WMDecoration
{
  ALL = 1 << 0,
  BORDER = 1 << 1,
  RESIZEH = 1 << 2,
  TITLE = 1 << 3,
  MENU = 1 << 4,
  MINIMIZE = 1 << 5,
  MAXIMIZE = 1 << 6
};

/** @ingroup gdkmmEnums */
inline WMDecoration operator|(WMDecoration lhs, WMDecoration rhs)
  { return static_cast<WMDecoration>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup gdkmmEnums */
inline WMDecoration operator&(WMDecoration lhs, WMDecoration rhs)
  { return static_cast<WMDecoration>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup gdkmmEnums */
inline WMDecoration operator^(WMDecoration lhs, WMDecoration rhs)
  { return static_cast<WMDecoration>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup gdkmmEnums */
inline WMDecoration operator~(WMDecoration flags)
  { return static_cast<WMDecoration>(~static_cast<unsigned>(flags)); }

/** @ingroup gdkmmEnums */
inline WMDecoration& operator|=(WMDecoration& lhs, WMDecoration rhs)
  { return (lhs = static_cast<WMDecoration>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup gdkmmEnums */
inline WMDecoration& operator&=(WMDecoration& lhs, WMDecoration rhs)
  { return (lhs = static_cast<WMDecoration>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup gdkmmEnums */
inline WMDecoration& operator^=(WMDecoration& lhs, WMDecoration rhs)
  { return (lhs = static_cast<WMDecoration>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }


} // namespace Gdk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gdk::WMDecoration> : public Glib::Value_Flags<Gdk::WMDecoration>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gdk
{

/** 
 *  @var WMFunction ALL
 * All functions should be offered.
 * 
 *  @var WMFunction RESIZE
 * The surface should be resizable.
 * 
 *  @var WMFunction MOVE
 * The surface should be movable.
 * 
 *  @var WMFunction MINIMIZE
 * The surface should be minimizable.
 * 
 *  @var WMFunction MAXIMIZE
 * The surface should be maximizable.
 * 
 *  @var WMFunction CLOSE
 * The surface should be closable.
 * 
 *  @enum WMFunction
 * 
 * These are hints originally defined by the Motif toolkit. The window manager
 * can use them when determining the functions to offer for the surface. The
 * hint must be set before mapping the surface.
 *
 * @ingroup gdkmmEnums
 * @par Bitwise operators:
 * <tt>WMFunction operator|(WMFunction, WMFunction)</tt><br>
 * <tt>WMFunction operator&(WMFunction, WMFunction)</tt><br>
 * <tt>WMFunction operator^(WMFunction, WMFunction)</tt><br>
 * <tt>WMFunction operator~(WMFunction)</tt><br>
 * <tt>WMFunction& operator|=(WMFunction&, WMFunction)</tt><br>
 * <tt>WMFunction& operator&=(WMFunction&, WMFunction)</tt><br>
 * <tt>WMFunction& operator^=(WMFunction&, WMFunction)</tt><br>
 */
enum class WMFunction
{
  ALL = 1 << 0,
  RESIZE = 1 << 1,
  MOVE = 1 << 2,
  MINIMIZE = 1 << 3,
  MAXIMIZE = 1 << 4,
  CLOSE = 1 << 5
};

/** @ingroup gdkmmEnums */
inline WMFunction operator|(WMFunction lhs, WMFunction rhs)
  { return static_cast<WMFunction>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup gdkmmEnums */
inline WMFunction operator&(WMFunction lhs, WMFunction rhs)
  { return static_cast<WMFunction>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup gdkmmEnums */
inline WMFunction operator^(WMFunction lhs, WMFunction rhs)
  { return static_cast<WMFunction>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup gdkmmEnums */
inline WMFunction operator~(WMFunction flags)
  { return static_cast<WMFunction>(~static_cast<unsigned>(flags)); }

/** @ingroup gdkmmEnums */
inline WMFunction& operator|=(WMFunction& lhs, WMFunction rhs)
  { return (lhs = static_cast<WMFunction>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup gdkmmEnums */
inline WMFunction& operator&=(WMFunction& lhs, WMFunction rhs)
  { return (lhs = static_cast<WMFunction>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup gdkmmEnums */
inline WMFunction& operator^=(WMFunction& lhs, WMFunction rhs)
  { return (lhs = static_cast<WMFunction>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }


} // namespace Gdk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gdk::WMFunction> : public Glib::Value_Flags<Gdk::WMFunction>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gdk
{

/** 
 *  @var SurfaceEdge NORTH_WEST
 * The top left corner.
 * 
 *  @var SurfaceEdge NORTH
 * The top edge.
 * 
 *  @var SurfaceEdge NORTH_EAST
 * The top right corner.
 * 
 *  @var SurfaceEdge WEST
 * The left edge.
 * 
 *  @var SurfaceEdge EAST
 * The right edge.
 * 
 *  @var SurfaceEdge SOUTH_WEST
 * The lower left corner.
 * 
 *  @var SurfaceEdge SOUTH
 * The lower edge.
 * 
 *  @var SurfaceEdge SOUTH_EAST
 * The lower right corner.
 * 
 *  @enum SurfaceEdge
 * 
 * Determines a surface edge or corner.
 *
 * @ingroup gdkmmEnums
 */
enum class SurfaceEdge
{
  NORTH_WEST,
  NORTH,
  NORTH_EAST,
  WEST,
  EAST,
  SOUTH_WEST,
  SOUTH,
  SOUTH_EAST
};


} // namespace Gdk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gdk::SurfaceEdge> : public Glib::Value_Enum<Gdk::SurfaceEdge>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gdk
{

/** 
 *  @var Gravity NORTH_WEST
 * The reference point is at the top left corner.
 * 
 *  @var Gravity NORTH
 * The reference point is in the middle of the top edge.
 * 
 *  @var Gravity NORTH_EAST
 * The reference point is at the top right corner.
 * 
 *  @var Gravity WEST
 * The reference point is at the middle of the left edge.
 * 
 *  @var Gravity CENTER
 * The reference point is at the center of the surface.
 * 
 *  @var Gravity EAST
 * The reference point is at the middle of the right edge.
 * 
 *  @var Gravity SOUTH_WEST
 * The reference point is at the lower left corner.
 * 
 *  @var Gravity SOUTH
 * The reference point is at the middle of the lower edge.
 * 
 *  @var Gravity SOUTH_EAST
 * The reference point is at the lower right corner.
 * 
 *  @var Gravity STATIC
 * The reference point is at the top left corner of the
 * surface itself, ignoring window manager decorations.
 * 
 *  @enum Gravity
 * 
 * Defines the reference point of a surface and the meaning of coordinates
 * passed to gtk_window_move(). See gtk_window_move() and the "implementation
 * notes" section of the
 * [Extended Window Manager Hints](http://www.freedesktop.org/Standards/wm-spec)
 * specification for more details.
 *
 * @ingroup gdkmmEnums
 */
enum class Gravity
{
  NORTH_WEST = 1,
  NORTH,
  NORTH_EAST,
  WEST,
  CENTER,
  EAST,
  SOUTH_WEST,
  SOUTH,
  SOUTH_EAST,
  STATIC
};


} // namespace Gdk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gdk::Gravity> : public Glib::Value_Enum<Gdk::Gravity>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gdk
{

/** 
 *  @var AnchorHints FLIP_X
 * Allow flipping anchors horizontally.
 * 
 *  @var AnchorHints FLIP_Y
 * Allow flipping anchors vertically.
 * 
 *  @var AnchorHints SLIDE_X
 * Allow sliding surface horizontally.
 * 
 *  @var AnchorHints SLIDE_Y
 * Allow sliding surface vertically.
 * 
 *  @var AnchorHints RESIZE_X
 * Allow resizing surface horizontally.
 * 
 *  @var AnchorHints RESIZE_Y
 * Allow resizing surface vertically.
 * 
 *  @var AnchorHints FLIP
 * Allow flipping anchors on both axes.
 * 
 *  @var AnchorHints SLIDE
 * Allow sliding surface on both axes.
 * 
 *  @var AnchorHints RESIZE
 * Allow resizing surface on both axes.
 * 
 *  @enum AnchorHints
 * 
 * Positioning hints for aligning a surface relative to a rectangle.
 * 
 * These hints determine how the surface should be positioned in the case that
 * the surface would fall off-screen if placed in its ideal position.
 * 
 * For example, Gdk::AnchorHints::FLIP_X will replace Gdk::Gravity::NORTH_WEST with
 * Gdk::Gravity::NORTH_EAST and vice versa if the surface extends beyond the left
 * or right edges of the monitor.
 * 
 * If Gdk::AnchorHints::SLIDE_X is set, the surface can be shifted horizontally to fit
 * on-screen. If Gdk::AnchorHints::RESIZE_X is set, the surface can be shrunken
 * horizontally to fit.
 * 
 * In general, when multiple flags are set, flipping should take precedence over
 * sliding, which should take precedence over resizing.
 *
 * @ingroup gdkmmEnums
 * @par Bitwise operators:
 * <tt>AnchorHints operator|(AnchorHints, AnchorHints)</tt><br>
 * <tt>AnchorHints operator&(AnchorHints, AnchorHints)</tt><br>
 * <tt>AnchorHints operator^(AnchorHints, AnchorHints)</tt><br>
 * <tt>AnchorHints operator~(AnchorHints)</tt><br>
 * <tt>AnchorHints& operator|=(AnchorHints&, AnchorHints)</tt><br>
 * <tt>AnchorHints& operator&=(AnchorHints&, AnchorHints)</tt><br>
 * <tt>AnchorHints& operator^=(AnchorHints&, AnchorHints)</tt><br>
 */
enum class AnchorHints
{
  FLIP_X = 1 << 0,
  FLIP_Y = 1 << 1,
  SLIDE_X = 1 << 2,
  SLIDE_Y = 1 << 3,
  RESIZE_X = 1 << 4,
  RESIZE_Y = 1 << 5,
  FLIP = 0x3,
  SLIDE = 0xC,
  RESIZE = 0x30
};

/** @ingroup gdkmmEnums */
inline AnchorHints operator|(AnchorHints lhs, AnchorHints rhs)
  { return static_cast<AnchorHints>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup gdkmmEnums */
inline AnchorHints operator&(AnchorHints lhs, AnchorHints rhs)
  { return static_cast<AnchorHints>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup gdkmmEnums */
inline AnchorHints operator^(AnchorHints lhs, AnchorHints rhs)
  { return static_cast<AnchorHints>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup gdkmmEnums */
inline AnchorHints operator~(AnchorHints flags)
  { return static_cast<AnchorHints>(~static_cast<unsigned>(flags)); }

/** @ingroup gdkmmEnums */
inline AnchorHints& operator|=(AnchorHints& lhs, AnchorHints rhs)
  { return (lhs = static_cast<AnchorHints>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup gdkmmEnums */
inline AnchorHints& operator&=(AnchorHints& lhs, AnchorHints rhs)
  { return (lhs = static_cast<AnchorHints>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup gdkmmEnums */
inline AnchorHints& operator^=(AnchorHints& lhs, AnchorHints rhs)
  { return (lhs = static_cast<AnchorHints>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }


} // namespace Gdk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gdk::AnchorHints> : public Glib::Value_Flags<Gdk::AnchorHints>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gdk
{

/** 
 *  @var FullscreenMode ON_CURRENT_MONITOR
 * Fullscreen on current monitor only.
 * 
 *  @var FullscreenMode ON_ALL_MONITORS
 * Span across all monitors when fullscreen.
 * 
 *  @enum FullscreenMode
 * 
 * Indicates which monitor (in a multi-head setup) a surface should span over
 * when in fullscreen mode.
 *
 * @ingroup gdkmmEnums
 */
enum class FullscreenMode
{
  ON_CURRENT_MONITOR,
  ON_ALL_MONITORS
};


} // namespace Gdk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gdk::FullscreenMode> : public Glib::Value_Enum<Gdk::FullscreenMode>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gdk
{


class ContentProvider;
class Cursor;
class CairoContext;
class GLContext;
class DrawContext;
class FrameClock;
class Monitor;

/** A Gdk::Surface is a rectangular region on the screen. It's a low-level object, used to implement high-level objects such
 * as Gtk::Widget and Gtk::Window on the GTK+ level. A Gtk::Window is a toplevel window, the thing a user might think of as
 * a "window" with a titlebar and so on; a Gtk::Window may contain many Gdk::Surfaces. For example, each Gtk::Button has a
 * Gdk::Surface associated with it.
 */

class Surface : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  using CppObjectType = Surface;
  using CppClassType = Surface_Class;
  using BaseObjectType = GdkSurface;
  using BaseClassType = GdkSurfaceClass;

  // noncopyable
  Surface(const Surface&) = delete;
  Surface& operator=(const Surface&) = delete;

private:  friend class Surface_Class;
  static CppClassType surface_class_;

protected:
  explicit Surface(const Glib::ConstructParams& construct_params);
  explicit Surface(GdkSurface* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  Surface(Surface&& src) noexcept;
  Surface& operator=(Surface&& src) noexcept;

  ~Surface() noexcept override;

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GdkSurface*       gobj()       { return reinterpret_cast<GdkSurface*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GdkSurface* gobj() const { return reinterpret_cast<GdkSurface*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GdkSurface* gobj_copy();

private:

  
public:
  /** 
   *  @var Type TOPLEVEL
   * Toplevel window (used to implement Gtk::Window).
   * 
   *  @var Type CHILD
   * Child surface (used to implement e.g. Gtk::Entry).
   * 
   *  @var Type TEMP
   * Override redirect temporary surface (used to implement Gtk::Menu).
   * 
   *  @enum Type
   * 
   * Describes the kind of surface.
   *
   * @ingroup gdkmmEnums
   */
  enum class Type
  {
    TOPLEVEL,
    CHILD,
    TEMP
  };


  /** 
   *  @var State WITHDRAWN
   * The surface is not shown.
   * 
   *  @var State ICONIFIED
   * The surface is minimized.
   * 
   *  @var State MAXIMIZED
   * The surface is maximized.
   * 
   *  @var State STICKY
   * The surface is sticky.
   * 
   *  @var State FULLSCREEN
   * The surface is maximized without decorations.
   * 
   *  @var State ABOVE
   * The surface is kept above other surfaces.
   * 
   *  @var State BELOW
   * The surface is kept below other surfaces.
   * 
   *  @var State FOCUSED
   * The surface is presented as focused (with active decorations).
   * 
   *  @var State TILED
   * The surface is in a tiled state.
   * 
   *  @var State TOP_TILED
   * Whether the top edge is tiled.
   * 
   *  @var State TOP_RESIZABLE
   * Whether the top edge is resizable.
   * 
   *  @var State RIGHT_TILED
   * Whether the right edge is tiled.
   * 
   *  @var State RIGHT_RESIZABLE
   * Whether the right edge is resizable.
   * 
   *  @var State BOTTOM_TILED
   * Whether the bottom edge is tiled.
   * 
   *  @var State BOTTOM_RESIZABLE
   * Whether the bottom edge is resizable.
   * 
   *  @var State LEFT_TILED
   * Whether the left edge is tiled.
   * 
   *  @var State LEFT_RESIZABLE
   * Whether the left edge is resizable.
   * 
   *  @enum State
   * 
   * Specifies the state of a toplevel surface.
   * 
   * On platforms that support information about individual edges, the Gdk::Surface::State::TILED
   * state will be set whenever any of the individual tiled states is set. On platforms
   * that lack that support, the tiled state will give an indication of tiledness without
   * any of the per-edge states being set.
   *
   * @ingroup gdkmmEnums
   * @par Bitwise operators:
   * <tt>Surface::State operator|(Surface::State, Surface::State)</tt><br>
   * <tt>Surface::State operator&(Surface::State, Surface::State)</tt><br>
   * <tt>Surface::State operator^(Surface::State, Surface::State)</tt><br>
   * <tt>Surface::State operator~(Surface::State)</tt><br>
   * <tt>Surface::State& operator|=(Surface::State&, Surface::State)</tt><br>
   * <tt>Surface::State& operator&=(Surface::State&, Surface::State)</tt><br>
   * <tt>Surface::State& operator^=(Surface::State&, Surface::State)</tt><br>
   */
  enum class State
  {
    WITHDRAWN = 1 << 0,
    ICONIFIED = 1 << 1,
    MAXIMIZED = 1 << 2,
    STICKY = 1 << 3,
    FULLSCREEN = 1 << 4,
    ABOVE = 1 << 5,
    BELOW = 1 << 6,
    FOCUSED = 1 << 7,
    TILED = 1 << 8,
    TOP_TILED = 1 << 9,
    TOP_RESIZABLE = 1 << 10,
    RIGHT_TILED = 1 << 11,
    RIGHT_RESIZABLE = 1 << 12,
    BOTTOM_TILED = 1 << 13,
    BOTTOM_RESIZABLE = 1 << 14,
    LEFT_TILED = 1 << 15,
    LEFT_RESIZABLE = 1 << 16
  };


  /** 
   *  @var Hints POS
   * Indicates that the program has positioned the surface.
   * 
   *  @var Hints MIN_SIZE
   * Min size fields are set.
   * 
   *  @var Hints MAX_SIZE
   * Max size fields are set.
   * 
   *  @var Hints BASE_SIZE
   * Base size fields are set.
   * 
   *  @var Hints ASPECT
   * Aspect ratio fields are set.
   * 
   *  @var Hints RESIZE_INC
   * Resize increment fields are set.
   * 
   *  @var Hints WIN_GRAVITY
   * Surface gravity field is set.
   * 
   *  @var Hints USER_POS
   * Indicates that the surface’s position was explicitly set
   * by the user.
   * 
   *  @var Hints USER_SIZE
   * Indicates that the surface’s size was explicitly set by
   * the user.
   * 
   *  @enum Hints
   * 
   * Used to indicate which fields of a Gdk::Geometry struct should be paid
   * attention to. Also, the presence/absence of @a GDK_HINT_POS,
   *  @a GDK_HINT_USER_POS, and @a GDK_HINT_USER_SIZE is significant, though they don't
   * directly refer to Gdk::Geometry fields. @a GDK_HINT_USER_POS will be set
   * automatically by Gtk::Window if you call gtk_window_move().
   *  @a GDK_HINT_USER_POS and @a GDK_HINT_USER_SIZE should be set if the user
   * specified a size/position using a --geometry command-line argument;
   * gtk_window_parse_geometry() automatically sets these flags.
   *
   * @ingroup gdkmmEnums
   * @par Bitwise operators:
   * <tt>Surface::Hints operator|(Surface::Hints, Surface::Hints)</tt><br>
   * <tt>Surface::Hints operator&(Surface::Hints, Surface::Hints)</tt><br>
   * <tt>Surface::Hints operator^(Surface::Hints, Surface::Hints)</tt><br>
   * <tt>Surface::Hints operator~(Surface::Hints)</tt><br>
   * <tt>Surface::Hints& operator|=(Surface::Hints&, Surface::Hints)</tt><br>
   * <tt>Surface::Hints& operator&=(Surface::Hints&, Surface::Hints)</tt><br>
   * <tt>Surface::Hints& operator^=(Surface::Hints&, Surface::Hints)</tt><br>
   */
  enum class Hints
  {
    POS = 1 << 0,
    MIN_SIZE = 1 << 1,
    MAX_SIZE = 1 << 2,
    BASE_SIZE = 1 << 3,
    ASPECT = 1 << 4,
    RESIZE_INC = 1 << 5,
    WIN_GRAVITY = 1 << 6,
    USER_POS = 1 << 7,
    USER_SIZE = 1 << 8
  };


  /** 
   *  @var TypeHint NORMAL
   * Normal toplevel window.
   * 
   *  @var TypeHint DIALOG
   * Dialog window.
   * 
   *  @var TypeHint MENU
   * Window used to implement a menu; GTK uses
   * this hint only for torn-off menus, see Gtk::TearoffMenuItem.
   * 
   *  @var TypeHint TOOLBAR
   * Window used to implement toolbars.
   * 
   *  @var TypeHint SPLASHSCREEN
   * Window used to display a splash
   * screen during application startup.
   * 
   *  @var TypeHint UTILITY
   * Utility windows which are not detached
   * toolbars or dialogs.
   * 
   *  @var TypeHint DOCK
   * Used for creating dock or panel windows.
   * 
   *  @var TypeHint DESKTOP
   * Used for creating the desktop background
   * window.
   * 
   *  @var TypeHint DROPDOWN_MENU
   * A menu that belongs to a menubar.
   * 
   *  @var TypeHint POPUP_MENU
   * A menu that does not belong to a menubar,
   * e.g. a context menu.
   * 
   *  @var TypeHint TOOLTIP
   * A tooltip.
   * 
   *  @var TypeHint NOTIFICATION
   * A notification - typically a “bubble”
   * that belongs to a status icon.
   * 
   *  @var TypeHint COMBO
   * A popup from a combo box.
   * 
   *  @var TypeHint DND
   * A window that is used to implement a DND cursor.
   * 
   *  @enum TypeHint
   * 
   * These are hints for the window manager that indicate what type of function
   * the window has. The window manager can use this when determining decoration
   * and behaviour of the window. The hint must be set before mapping the window.
   * 
   * See the [Extended Window Manager Hints](http://www.freedesktop.org/Standards/wm-spec)
   * specification for more details about window types.
   *
   * @ingroup gdkmmEnums
   */
  enum class TypeHint
  {
    NORMAL,
    DIALOG,
    MENU,
    TOOLBAR,
    SPLASHSCREEN,
    UTILITY,
    DOCK,
    DESKTOP,
    DROPDOWN_MENU,
    POPUP_MENU,
    TOOLTIP,
    NOTIFICATION,
    COMBO,
    DND
  };


  // _WRAP_CREATE() would not be very useful here.
  // The gdk_surface_new_*() functions do more than call g_object_new().
  // And we can't make one hand-coded constructor for each gdk_surface_new_*()
  // function, because some of them have identical prototypes.
  
  /** Creates a new toplevel surface. The surface will be managed by the surface
   * manager.
   * 
   * @param display The display to create the surface on.
   * @param width Width of new surface.
   * @param height Height of new surface.
   * @return The new Gdk::Surface.
   */
  static Glib::RefPtr<Surface> create_toplevel(const Glib::RefPtr<Display>& display, int width, int height);
  
  /** Creates a new toplevel popup surface. The surface will bypass surface
   * management.
   * 
   * @param display The display to create the surface on.
   * @param position Position of the surface on screen.
   * @return The new Gdk::Surface.
   */
  static Glib::RefPtr<Surface> create_popup(const Glib::RefPtr<Display>& display, const Rectangle& position);
  //TODO: Wrap or ignore? The documentation says: You most likely do not want to use this function.
  //_WRAP_METHOD(static Glib::RefPtr<Surface> create_temp(const Glib::RefPtr<Display>& display), gdk_surface_new_temp)
  
  /** Creates a new client-side child surface.
   * 
   * @param parent The parent surface.
   * @param position Placement of the surface inside @a parent.
   * @return The new Gdk::Surface.
   */
  static Glib::RefPtr<Surface> create_child(const Glib::RefPtr<Surface>& parent, const Rectangle& position);

  
  /** Gets the type of the surface. See Gdk::Surface::Type.
   * 
   * @return Type of surface.
   */
  Type get_surface_type() const;

  
  /** Gets the Gdk::Display associated with a Gdk::Surface.
   * 
   * @return The Gdk::Display associated with @a surface.
   */
  Glib::RefPtr<Display> get_display();
  
  /** Gets the Gdk::Display associated with a Gdk::Surface.
   * 
   * @return The Gdk::Display associated with @a surface.
   */
  Glib::RefPtr<const Display> get_display() const;

  
  /** Like show_unraised(), but also raises the surface to the
   * top of the surface stack (moves the surface to the front of the
   * Z-order).
   * 
   * This function maps a surface so it’s visible onscreen. Its opposite
   * is hide().
   * 
   * When implementing a Gtk::Widget, you should call this function on the widget's
   * Gdk::Surface as part of the “map” method.
   */
  void show();
  
  /** For toplevel surfaces, withdraws them, so they will no longer be
   * known to the window manager; for all surfaces, unmaps them, so
   * they won’t be displayed. Normally done automatically as
   * part of gtk_widget_hide().
   */
  void hide();
  
  /** Shows a Gdk::Surface onscreen, but does not modify its stacking
   * order. In contrast, show() will raise the surface
   * to the top of the surface stack.
   * 
   * On the X11 platform, in Xlib terms, this function calls
   * XMapWindow() (it also updates some internal GDK state, which means
   * that you can’t really use XMapWindow() directly on a GDK surface).
   */
  void show_unraised();
  
  /** Repositions a surface relative to its parent surface.
   * For toplevel surfaces, window managers may ignore or modify the move;
   * you should probably use gtk_window_move() on a Gtk::Window widget
   * anyway, instead of using GDK functions. For child surfaces,
   * the move will reliably succeed.
   * 
   * If you’re also planning to resize the surface, use move_resize()
   * to both move and resize simultaneously, for a nicer visual effect.
   * 
   * @param x X coordinate relative to surface’s parent.
   * @param y Y coordinate relative to surface’s parent.
   */
  void move(int x, int y);
  
  /** Resizes @a surface; for toplevel surfaces, asks the window manager to resize
   * the surface. The window manager may not allow the resize. When using GTK,
   * use gtk_window_resize() instead of this low-level GDK function.
   * 
   * Surfaces may not be resized below 1x1.
   * 
   * If you’re also planning to move the surface, use move_resize()
   * to both move and resize simultaneously, for a nicer visual effect.
   * 
   * @param width New width of the surface.
   * @param height New height of the surface.
   */
  void resize(int width, int height);
  
  /** Equivalent to calling move() and resize(),
   * except that both operations are performed at once, avoiding strange
   * visual effects. (i.e. the user may be able to see the surface first
   * move, then resize, if you don’t use move_resize().)
   * 
   * @param x New X position relative to surface’s parent.
   * @param y New Y position relative to surface’s parent.
   * @param width New width.
   * @param height New height.
   */
  void move_resize(int x, int y, int width, int height);
  
  /** Moves @a surface to @a rect, aligning their anchor points.
   * 
   *  @a rect is relative to the top-left corner of the surface that @a surface is
   * transient for. @a rect_anchor and @a surface_anchor determine anchor points on
   *  @a rect and @a surface to pin together. @a rect's anchor point can optionally be
   * offset by @a rect_anchor_dx and @a rect_anchor_dy, which is equivalent to
   * offsetting the position of @a surface.
   * 
   *  @a anchor_hints determines how @a surface will be moved if the anchor points cause
   * it to move off-screen. For example, Gdk::AnchorHints::FLIP_X will replace
   * Gdk::Gravity::NORTH_WEST with Gdk::Gravity::NORTH_EAST and vice versa if
   *  @a surface extends beyond the left or right edges of the monitor.
   * 
   * Connect to the Gdk::Surface::signal_moved_to_rect() signal to find out how it was
   * actually positioned.
   * 
   * @param rect The destination Gdk::Rectangle to align @a surface with.
   * @param rect_anchor The point on @a rect to align with @a surface's anchor point.
   * @param surface_anchor The point on @a surface to align with @a rect's anchor point.
   * @param anchor_hints Positioning hints to use when limited on space.
   * @param rect_anchor_dx Horizontal offset to shift @a surface, i.e. @a rect's anchor
   * point.
   * @param rect_anchor_dy Vertical offset to shift @a surface, i.e. @a rect's anchor point.
   */
  void move_to_rect(const Rectangle& rect, Gravity rect_anchor, Gravity surface_anchor, AnchorHints anchor_hints, int rect_anchor_dx, int rect_anchor_dy);

  
  /** Raises @a surface to the top of the Z-order (stacking order), so that
   * other surfaces with the same parent surface appear below @a surface.
   * This is true whether or not the surfaces are visible.
   * 
   * If @a surface is a toplevel, the window manager may choose to deny the
   * request to move the surface in the Z-order, raise() only
   * requests the restack, does not guarantee it.
   */
  void raise();
  
  /** Lowers @a surface to the bottom of the Z-order (stacking order), so that
   * other surfaces with the same parent surface appear above @a surface.
   * This is true whether or not the other surfaces are visible.
   * 
   * If @a surface is a toplevel, the window manager may choose to deny the
   * request to move the surface in the Z-order, lower() only
   * requests the restack, does not guarantee it.
   * 
   * Note that show() raises the surface again, so don’t call this
   * function before show(). (Try show_unraised().)
   */
  void lower();

  
  /** Changes the position of  @a surface in the Z-order (stacking order), so that
   * it is above @a sibling (if @a above is <tt>true</tt>) or below @a sibling (if @a above is
   * <tt>false</tt>).
   * 
   * If @a sibling is <tt>nullptr</tt>, then this either raises (if @a above is <tt>true</tt>) or
   * lowers the surface.
   * 
   * If @a surface is a toplevel, the window manager may choose to deny the
   * request to move the surface in the Z-order, restack() only
   * requests the restack, does not guarantee it.
   * 
   * @param sibling A Gdk::Surface that is a sibling of @a surface, or <tt>nullptr</tt>.
   * @param above A boolean.
   */
  void restack(const Glib::RefPtr<Surface>& sibling, bool above);

  /** Changes the position of this surface in the Z-order (stacking order). This
   * either raises (if @a above is true) or lowers the surface.
   *
   * If this is a toplevel, the window manager may choose to deny the
   * request to move the surface in the Z-order. restack() only
   * requests the restack but does not guarantee it.
   *
   * @param above Whether to raise or lower the surface.
   *
   * @newin{2,18}
   */
  void restack(bool above);

  
  /** Sets keyboard focus to @a surface. In most cases, gtk_window_present_with_time()
   * should be used on a Gtk::Window, rather than calling this function.
   * 
   * @param timestamp Timestamp of the event triggering the surface focus.
   */
  void focus(guint32 timestamp);

  
  /** Like gdk_surface_shape_combine_region(), but the shape applies
   * only to event handling. Mouse events which happen while
   * the pointer position corresponds to an unset bit in the
   * mask will be passed on the surface below @a surface.
   * 
   * An input shape is typically used with RGBA surfaces.
   * The alpha channel of the surface defines which pixels are
   * invisible and allows for nicely antialiased borders,
   * and the input shape controls where the surface is
   * “clickable”.
   * 
   * On the X11 platform, this requires version 1.1 of the
   * shape extension.
   * 
   * On the Win32 platform, this functionality is not present and the
   * function does nothing.
   * 
   * @param shape_region Region of surface to be non-transparent.
   * @param offset_x X position of @a shape_region in @a surface coordinates.
   * @param offset_y Y position of @a shape_region in @a surface coordinates.
   */
  void input_shape_combine_region(const ::Cairo::RefPtr< ::Cairo::Region>& shape_region, int offset_x, int offset_y);
  
  /** Sets the input shape mask of @a surface to the union of input shape masks
   * for all children of @a surface, ignoring the input shape mask of @a surface
   * itself. Contrast with merge_child_input_shapes() which includes
   * the input shape mask of @a surface in the masks to be merged.
   */
  void set_child_input_shapes();
  
  /** Merges the input shape masks for any child surfaces into the
   * input shape mask for @a surface. i.e. the union of all input masks
   * for @a surface and its children will become the new input mask
   * for @a surface. See input_shape_combine_region().
   * 
   * This function is distinct from set_child_input_shapes()
   * because it includes @a surface’s input shape mask in the set of
   * shapes to be merged.
   */
  void merge_child_input_shapes();

  
  /** Sets whether input to the surface is passed through to the surface
   * below.
   * 
   * The default value of this is <tt>false</tt>, which means that pointer
   * events that happen inside the surface are send first to the surface,
   * but if the event is not selected by the event mask then the event
   * is sent to the parent surface, and so on up the hierarchy.
   * 
   * If @a pass_through is <tt>true</tt> then such pointer events happen as if the
   * surface wasn't there at all, and thus will be sent first to any
   * surfaces below @a surface. This is useful if the surface is used in a
   * transparent fashion. In the terminology of the web this would be called
   * "pointer-events: none".
   * 
   * Note that a surface with @a pass_through <tt>true</tt> can still have a subsurface
   * without pass through, so you can get events on a subset of a surface. And in
   * that cases you would get the in-between related events such as the pointer
   * enter/leave events on its way to the destination surface.
   * 
   * @param pass_through A boolean.
   */
  void set_pass_through(bool pass_through =  true);
  
  /** Returns whether input to the surface is passed through to the surface
   * below.
   * 
   * See set_pass_through() for details
   */
  bool get_pass_through() const;

  
  /** Checks whether the surface has been mapped (with show() or
   * show_unraised()).
   * 
   * @return <tt>true</tt> if the surface is mapped.
   */
  bool is_visible() const;
  
  /** Check if the surface and all ancestors of the surface are
   * mapped. (This is not necessarily "viewable" in the X sense, since
   * we only check as far as we have GDK surface parents, not to the root
   * surface.)
   * 
   * @return <tt>true</tt> if the surface is viewable.
   */
  bool is_viewable() const;
  
  /** Determines whether or not the surface is an input only surface.
   * 
   * @return <tt>true</tt> if @a surface is input only.
   */
  bool is_input_only() const;
  
  /** Gets the bitwise OR of the currently active surface state flags,
   * from the Gdk::Surface::State enumeration.
   * 
   * @return Surface state bitfield.
   */
  State get_state() const;
  
  /** Checks whether the surface has a native surface or not.
   * 
   * @return <tt>true</tt> if the @a surface has a native surface, <tt>false</tt> otherwise.
   */
  bool has_native() const;
  
  /** The application can use this call to provide a hint to the surface
   * manager about the functionality of a surface. The window manager
   * can use this information when determining the decoration and behaviour
   * of the surface.
   * 
   * The hint must be set before the surface is mapped.
   * 
   * @param hint A hint of the function this surface will have.
   */
  void set_type_hint(TypeHint hint);
  
  /** This function returns the type hint set for a surface.
   * 
   * @return The type hint set for @a surface.
   */
  TypeHint get_type_hint();
  
  /** Determines whether or not the window manager is hinted that @a surface
   * has modal behaviour.
   * 
   * @return Whether or not the surface has the modal hint set.
   */
  bool get_modal_hint() const;
  
  /** The application can use this hint to tell the window manager
   * that a certain surface has modal behaviour. The window manager
   * can use this information to handle modal surfaces in a special
   * way.
   * 
   * You should only use this on surfaces for which you have
   * previously called set_transient_for()
   * 
   * @param modal <tt>true</tt> if the surface is modal, <tt>false</tt> otherwise.
   */
  void set_modal_hint(bool modal =  true);
  
  /** Sets the geometry hints for @a surface. Hints flagged in @a geom_mask
   * are set, hints not flagged in @a geom_mask are unset.
   * To unset all hints, use a @a geom_mask of 0 and a @a geometry of <tt>nullptr</tt>.
   * 
   * This function provides hints to the surfaceing system about
   * acceptable sizes for a toplevel surface. The purpose of
   * this is to constrain user resizing, but the windowing system
   * will typically  (but is not required to) also constrain the
   * current size of the surface to the provided values and
   * constrain programatic resizing via resize() or
   * move_resize().
   * 
   * Note that on X11, this effect has no effect on surfaces
   * of type Gdk::Surface::Type::TEMP since these surfaces are not resizable
   * by the user.
   * 
   * Since you can’t count on the windowing system doing the
   * constraints for programmatic resizes, you should generally
   * call constrain_size() yourself to determine
   * appropriate sizes.
   * 
   * @param geometry Geometry hints.
   * @param geom_mask Bitmask indicating fields of @a geometry to pay attention to.
   */
  void set_geometry_hints(const Geometry& geometry, Hints geom_mask);
  
  /** Sets the title of a toplevel surface, to be displayed in the titlebar.
   * If you haven’t explicitly set the icon name for the surface
   * (using set_icon_name()), the icon name will be set to
   *  @a title as well. @a title must be in UTF-8 encoding (as with all
   * user-readable strings in GDK and GTK). @a title may not be <tt>nullptr</tt>.
   * 
   * @param title Title of @a surface.
   */
  void set_title(const Glib::ustring& title);
  
  /** When using GTK, typically you should use gtk_window_set_startup_id()
   * instead of this low-level function.
   * 
   * @param startup_id A string with startup-notification identifier.
   */
  void set_startup_id(const Glib::ustring& startup_id);
  
  /** Indicates to the window manager that @a surface is a transient dialog
   * associated with the application surface @a parent. This allows the
   * window manager to do things like center @a surface on @a parent and
   * keep @a surface above @a parent.
   * 
   * See gtk_window_set_transient_for() if you’re using Gtk::Window or
   * Gtk::Dialog.
   * 
   * @param parent Another toplevel Gdk::Surface.
   */
  void set_transient_for(const Glib::RefPtr<Surface>& parent);

  
  /** Sets the default mouse pointer for a Gdk::Surface.
   * 
   * Note that @a cursor must be for the same display as @a surface.
   * 
   * Use Gdk::Cursor::new_from_name() or Gdk::Cursor::new_from_texture() to
   * create the cursor. To make the cursor invisible, use Gdk::Cursor::Type::BLANK_CURSOR.
   * Passing <tt>nullptr</tt> for the @a cursor argument to set_cursor() means
   * that @a surface will use the cursor of its parent surface. Most surfaces
   * should use this default.
   * 
   * @param cursor A cursor.
   */
  void set_cursor(const Glib::RefPtr<Cursor>& cursor);

  /** Use the parent surface's cursor.
   * For top-level windows this means that it will use the default cursor for the ROOT window.
   */
  void set_cursor();

  
  /** Sets a specific Gdk::Cursor for a given device when it gets inside @a surface.
   * Use gdk_cursor_new_fromm_name() or Gdk::Cursor::new_from_texture() to create
   * the cursor. To make the cursor invisible, use Gdk::Cursor::Type::BLANK_CURSOR. Passing
   * <tt>nullptr</tt> for the @a cursor argument to set_cursor() means that
   *  @a surface will use the cursor of its parent surface. Most surfaces should
   * use this default.
   * 
   * @param device A master, pointer Gdk::Device.
   * @param cursor A Gdk::Cursor.
   */
  void set_device_cursor(const Glib::RefPtr<Device>& device, const Glib::RefPtr<Cursor>& cursor);

  
  /** Retrieves a Gdk::Cursor pointer for the @a device currently set on the
   * specified Gdk::Surface, or <tt>nullptr</tt>.  If the return value is <tt>nullptr</tt> then
   * there is no custom cursor set on the specified surface, and it is
   * using the cursor for its parent surface.
   * 
   * @param device A master, pointer Gdk::Device.
   * @return A Gdk::Cursor, or <tt>nullptr</tt>. The
   * returned object is owned by the Gdk::Surface and should not be
   * unreferenced directly. Use set_cursor() to unset the
   * cursor of the surface.
   */
  Glib::RefPtr<Cursor> get_device_cursor(const Glib::RefPtr<Device>& device);
  
  /** Retrieves a Gdk::Cursor pointer for the @a device currently set on the
   * specified Gdk::Surface, or <tt>nullptr</tt>.  If the return value is <tt>nullptr</tt> then
   * there is no custom cursor set on the specified surface, and it is
   * using the cursor for its parent surface.
   * 
   * @param device A master, pointer Gdk::Device.
   * @return A Gdk::Cursor, or <tt>nullptr</tt>. The
   * returned object is owned by the Gdk::Surface and should not be
   * unreferenced directly. Use set_cursor() to unset the
   * cursor of the surface.
   */
  Glib::RefPtr<const Cursor> get_device_cursor(const Glib::RefPtr<const Device>& device) const;


  /** Retrieves a Gdk::Cursor pointer for the cursor currently set on the
   * specified Gdk::Surface, or <tt>nullptr</tt>.  If the return value is <tt>nullptr</tt> then
   * there is no custom cursor set on the specified surface, and it is
   * using the cursor for its parent surface.
   * 
   * @return A Gdk::Cursor, or <tt>nullptr</tt>. The
   * returned object is owned by the Gdk::Surface and should not be
   * unreferenced directly. Use set_cursor() to unset the
   * cursor of the surface.
   */
  Glib::RefPtr<Cursor> get_cursor();
  
  /** Retrieves a Gdk::Cursor pointer for the cursor currently set on the
   * specified Gdk::Surface, or <tt>nullptr</tt>.  If the return value is <tt>nullptr</tt> then
   * there is no custom cursor set on the specified surface, and it is
   * using the cursor for its parent surface.
   * 
   * @return A Gdk::Cursor, or <tt>nullptr</tt>. The
   * returned object is owned by the Gdk::Surface and should not be
   * unreferenced directly. Use set_cursor() to unset the
   * cursor of the surface.
   */
  Glib::RefPtr<const Cursor> get_cursor() const;

  
  /** Any of the return location arguments to this function may be <tt>nullptr</tt>,
   * if you aren’t interested in getting the value of that field.
   * 
   * The X and Y coordinates returned are relative to the parent surface
   * of @a surface, which for toplevels usually means relative to the
   * surface decorations (titlebar, etc.) rather than relative to the
   * root window (screen-size background window).
   * 
   * On the X11 platform, the geometry is obtained from the X server,
   * so reflects the latest position of @a surface; this may be out-of-sync
   * with the position of @a surface delivered in the most-recently-processed
   * Gdk::EventConfigure. get_position() in contrast gets the
   * position from the most recent configure event.
   * 
   * @note If @a surface is not a toplevel, it is much better
   * to call get_position(), get_width() and
   * get_height() instead, because it avoids the roundtrip to
   * the X server and because these functions support the full 32-bit
   * coordinate space, whereas get_geometry() is restricted to
   * the 16-bit coordinates of X11.
   * 
   * @param x Return location for X coordinate of surface (relative to its parent).
   * @param y Return location for Y coordinate of surface (relative to its parent).
   * @param width Return location for width of surface.
   * @param height Return location for height of surface.
   */
  void get_geometry(int& x, int& y, int& width, int& height) const;
  
  /** Returns the width of the given @a surface.
   * 
   * On the X11 platform the returned size is the size reported in the
   * most-recently-processed configure event, rather than the current
   * size on the X server.
   * 
   * @return The width of @a surface.
   */
  int get_width() const;
  
  /** Returns the height of the given @a surface.
   * 
   * On the X11 platform the returned size is the size reported in the
   * most-recently-processed configure event, rather than the current
   * size on the X server.
   * 
   * @return The height of @a surface.
   */
  int get_height() const;

  
  /** Obtains the position of the surface as reported in the
   * most-recently-processed Gdk::EventConfigure. Contrast with
   * get_geometry() which queries the X server for the
   * current surface position, regardless of which events have been
   * received or processed.
   * 
   * The position coordinates are relative to the surface’s parent surface.
   * 
   * @param x X coordinate of surface.
   * @param y Y coordinate of surface.
   */
  void get_position(int& x, int& y) const;
  
  /** Obtains the position of a surface in root window coordinates.
   * (Compare with get_position() and
   * get_geometry() which return the position of a surface
   * relative to its parent surface.)
   * 
   * @param x Return location for X coordinate.
   * @param y Return location for Y coordinate.
   * @return Not meaningful, ignore.
   */
  int get_origin(int& x, int& y) const;
  
  /** Obtains the position of a surface position in root
   * window coordinates. This is similar to
   * get_origin() but allows you to pass
   * in any position in the surface, not just the origin.
   * 
   * @param x X coordinate in surface.
   * @param y Y coordinate in surface.
   * @param root_x Return location for X coordinate.
   * @param root_y Return location for Y coordinate.
   */
  void get_root_coords(int x, int y, int& root_x, int& root_y);
  
  /** Transforms surface coordinates from a child surface to its parent
   * surface. Calling this function is equivalent to adding the return
   * values of get_position() to the child coordinates.
   * 
   * See also: coords_from_parent()
   * 
   * @param x X coordinate in child’s coordinate system.
   * @param y Y coordinate in child’s coordinate system.
   * @param parent_x Return location for X coordinate
   * in parent’s coordinate system, or <tt>nullptr</tt>.
   * @param parent_y Return location for Y coordinate
   * in parent’s coordinate system, or <tt>nullptr</tt>.
   */
  void coords_to_parent(double x, double y, double& parent_x, double& parent_y);
  
  /** Transforms surface coordinates from a parent surface to a child
   * surface.
   * 
   * Calling this function is equivalent to subtracting the return
   * values of get_position() from the parent coordinates.
   * 
   * See also: coords_to_parent()
   * 
   * @param parent_x X coordinate in parent’s coordinate system.
   * @param parent_y Y coordinate in parent’s coordinate system.
   * @param x Return location for X coordinate in child’s coordinate system.
   * @param y Return location for Y coordinate in child’s coordinate system.
   */
  void coords_from_parent(double parent_x, double parent_y, double& x, double& y);

  
  /** Obtains the top-left corner of the window manager frame in root
   * surface coordinates.
   * 
   * @param x Return location for X position of surface frame.
   * @param y Return location for Y position of surface frame.
   */
  void get_root_origin(int& x, int& y) const;

  
  /** Obtains the bounding box of the surface, including window manager
   * titlebar/borders if any. The frame position is given in root window
   * coordinates. To get the position of the surface itself (rather than
   * the frame) in root window coordinates, use get_origin().
   * 
   * @param rect Rectangle to fill with bounding box of the surface frame.
   */
  void get_frame_extents(Rectangle& rect) const;

  
  /** Returns the internal scale factor that maps from surface coordiantes
   * to the actual device pixels. On traditional systems this is 1, but
   * on very high density outputs this can be a higher value (often 2).
   * 
   * A higher value means that drawing is automatically scaled up to
   * a higher resolution, so any code doing drawing will automatically look
   * nicer. However, if you are supplying pixel-based data the scale
   * value can be used to determine whether to use a pixel resource
   * with higher resolution data.
   * 
   * The scale of a surface may change during runtime, if this happens
   * a configure event will be sent to the toplevel surface.
   * 
   * @return The scale factor.
   */
  int get_scale_factor() const;
  
  /** Obtains the parent of @a surface, as known to GDK. Does not query the
   * X server; thus this returns the parent as passed to gdk_surface_new(),
   * not the actual parent. This should never matter unless you’re using
   * Xlib calls mixed with GDK calls on the X11 platform. It may also
   * matter for toplevel windows, because the window manager may choose
   * to reparent them.
   * 
   * @return Parent of @a surface.
   */
  Glib::RefPtr<Surface> get_parent();
  
  /** Obtains the parent of @a surface, as known to GDK. Does not query the
   * X server; thus this returns the parent as passed to gdk_surface_new(),
   * not the actual parent. This should never matter unless you’re using
   * Xlib calls mixed with GDK calls on the X11 platform. It may also
   * matter for toplevel windows, because the window manager may choose
   * to reparent them.
   * 
   * @return Parent of @a surface.
   */
  Glib::RefPtr<const Surface> get_parent() const;
  
  /** Gets the toplevel surface that’s an ancestor of @a surface.
   * 
   * Any surface type but Gdk::Surface::Type::CHILD is considered a
   * toplevel surface, as is a Gdk::Surface::Type::CHILD surface that
   * has a root surface as parent.
   * 
   * @return The toplevel surface containing @a surface.
   */
  Glib::RefPtr<Surface> get_toplevel();
  
  /** Gets the toplevel surface that’s an ancestor of @a surface.
   * 
   * Any surface type but Gdk::Surface::Type::CHILD is considered a
   * toplevel surface, as is a Gdk::Surface::Type::CHILD surface that
   * has a root surface as parent.
   * 
   * @return The toplevel surface containing @a surface.
   */
  Glib::RefPtr<const Surface> get_toplevel() const;

  
  /** Obtains the current device position in doubles and modifier state.
   * The position is given in coordinates relative to the upper left
   * corner of @a surface.
   * 
   * @param device Pointer Gdk::Device to query to.
   * @param x Return location for the X coordinate of @a device, or <tt>nullptr</tt>.
   * @param y Return location for the Y coordinate of @a device, or <tt>nullptr</tt>.
   * @param mask Return location for the modifier mask, or <tt>nullptr</tt>.
   * @return The surface underneath @a device
   * (as with Gdk::Device::get_surface_at_position()), or <tt>nullptr</tt> if the
   * surface is not known to GDK.
   */
  Glib::RefPtr<Surface> get_device_position(const Glib::RefPtr<const Device>& device, double& x, double& y, ModifierType& mask) const;

 
  /** Gets the list of children of @a surface known to GDK.
   * This function only returns children created via GDK,
   * so for example it’s useless when used with the root window;
   * it only returns surfaces an application created itself.
   * 
   * The returned list must be freed, but the elements in the
   * list need not be.
   * 
   * @return List of child surfaces inside @a surface.
   */
  std::vector< Glib::RefPtr<Surface> > get_children();
 

  /** Gets the list of children of @a surface known to GDK.
   * This function only returns children created via GDK,
   * so for example it’s useless when used with the root window;
   * it only returns surfaces an application created itself.
   * 
   * The returned list must be freed, but the elements in the
   * list need not be.
   * 
   * @return List of child surfaces inside @a surface.
   */
  std::vector< Glib::RefPtr<const Surface> > get_children() const;
   //gdk_surface_peek_children() is the same as gdk_surface_get_children() with different memory mangement of the list.

 
  /** Sets a list of icons for the surface. One of these will be used
   * to represent the surface when it has been iconified. The icon is
   * usually shown in an icon box or some sort of task bar. Which icon
   * size is shown depends on the window manager. The window manager
   * can scale the icon  but setting several size icons can give better
   * image quality since the window manager may only need to scale the
   * icon by a small amount or not at all.
   * 
   * Note that some platforms don't support surface icons.
   * 
   * @param textures A list of image surfaces, of different sizes.
   */
  void set_icon_list(const std::vector<Glib::RefPtr<Texture>>& textures);
  void unset_icon();
  
  /** Surfaces may have a name used while minimized, distinct from the
   * name they display in their titlebar. Most of the time this is a bad
   * idea from a user interface standpoint. But you can set such a name
   * with this function, if you like.
   * 
   * After calling this with a non-<tt>nullptr</tt> @a name, calls to set_title()
   * will not update the icon title.
   * 
   * Using <tt>nullptr</tt> for @a name unsets the icon title; further calls to
   * set_title() will again update the icon title as well.
   * 
   * Note that some platforms don't support surface icons.
   * 
   * @param name Name of surface while iconified (minimized).
   */
  void set_icon_name(const Glib::ustring& name);

  
  /** “Decorations” are the features the window manager adds to a toplevel Gdk::Surface.
   * This function sets the traditional Motif window manager hints that tell the
   * window manager which decorations you would like your surface to have.
   * Usually you should use gtk_window_set_decorated() on a Gtk::Window instead of
   * using the GDK function directly.
   * 
   * The @a decorations argument is the logical OR of the fields in
   * the Gdk::WMDecoration enumeration. If Gdk::WMDecoration::ALL is included in the
   * mask, the other bits indicate which decorations should be turned off.
   * If Gdk::WMDecoration::ALL is not included, then the other bits indicate
   * which decorations should be turned on.
   * 
   * Most window managers honor a decorations hint of 0 to disable all decorations,
   * but very few honor all possible combinations of bits.
   * 
   * @param decorations Decoration hint mask.
   */
  void set_decorations(WMDecoration decorations);
  
  /** Returns the decorations set on the GdkSurface with
   * set_decorations().
   * 
   * @param decorations The surface decorations will be written here.
   * @return <tt>true</tt> if the surface has decorations set, <tt>false</tt> otherwise.
   */
  bool get_decorations(WMDecoration& decorations) const;
  
  /** Sets hints about the window management functions to make available
   * via buttons on the window frame.
   * 
   * On the X backend, this function sets the traditional Motif window
   * manager hint for this purpose. However, few window managers do
   * anything reliable or interesting with this hint. Many ignore it
   * entirely.
   * 
   * The @a functions argument is the logical OR of values from the
   * Gdk::WMFunction enumeration. If the bitmask includes Gdk::WMFunction::ALL,
   * then the other bits indicate which functions to disable; if
   * it doesn’t include Gdk::WMFunction::ALL, it indicates which functions to
   * enable.
   * 
   * @param functions Bitmask of operations to allow on @a surface.
   */
  void set_functions(WMFunction functions);

   
  /** Create a new surface that is as compatible as possible with the
   * given @a surface. For example the new surface will have the same
   * fallback resolution and font options as @a surface. Generally, the new
   * surface will also use the same backend as @a surface, unless that is
   * not possible for some reason. The type of the returned surface may
   * be examined with cairo_surface_get_type().
   * 
   * Initially the surface contents are all 0 (transparent if contents
   * have transparency, black otherwise.)
   * 
   * @param content The content for the new surface.
   * @param width Width of the new surface.
   * @param height Height of the new surface.
   * @return A pointer to the newly allocated surface. The caller
   * owns the surface and should call cairo_surface_destroy() when done
   * with it.
   * 
   * This function always returns a valid pointer, but it will return a
   * pointer to a “nil” surface if @a other is already in an error state
   * or any other error occurs.
   */
  ::Cairo::RefPtr< ::Cairo::Surface> create_similar_surface(::Cairo::Content content, int width, int height);

  
  /** Emits a short beep associated to @a surface in the appropriate
   * display, if supported. Otherwise, emits a short beep on
   * the display just as Gdk::Display::beep().
   */
  void beep();

  
  /** Asks to iconify (minimize) @a surface. The window manager may choose
   * to ignore the request, but normally will honor it. Using
   * gtk_window_iconify() is preferred, if you have a Gtk::Window widget.
   * 
   * This function only makes sense when @a surface is a toplevel surface.
   */
  void iconify();
  
  /** Attempt to deiconify (unminimize) @a surface. On X11 the window manager may
   * choose to ignore the request to deiconify. When using GTK,
   * use gtk_window_deiconify() instead of the Gdk::Surface variant. Or better yet,
   * you probably want to use gtk_window_present_with_time(), which raises the surface, focuses it,
   * unminimizes it, and puts it on the current desktop.
   */
  void deiconify();
  
  /** “Pins” a surface such that it’s on all workspaces and does not scroll
   * with viewports, for window managers that have scrollable viewports.
   * (When using Gtk::Window, gtk_window_stick() may be more useful.)
   * 
   * On the X11 platform, this function depends on window manager
   * support, so may have no effect with many window managers. However,
   * GDK will do the best it can to convince the window manager to stick
   * the surface. For window managers that don’t support this operation,
   * there’s nothing you can do to force it to happen.
   */
  void stick();
  
  /** Reverse operation for stick(); see stick(),
   * and gtk_window_unstick().
   */
  void unstick();
  
  /** Maximizes the surface. If the surface was already maximized, then
   * this function does nothing.
   * 
   * On X11, asks the window manager to maximize @a surface, if the window
   * manager supports this operation. Not all window managers support
   * this, and some deliberately ignore it or don’t have a concept of
   * “maximized”; so you can’t rely on the maximization actually
   * happening. But it will happen with most standard window managers,
   * and GDK makes a best effort to get it to happen.
   * 
   * On Windows, reliably maximizes the surface.
   */
  void maximize();
  
  /** Unmaximizes the surface. If the surface wasn’t maximized, then this
   * function does nothing.
   * 
   * On X11, asks the window manager to unmaximize @a surface, if the
   * window manager supports this operation. Not all window managers
   * support this, and some deliberately ignore it or don’t have a
   * concept of “maximized”; so you can’t rely on the unmaximization
   * actually happening. But it will happen with most standard window
   * managers, and GDK makes a best effort to get it to happen.
   * 
   * On Windows, reliably unmaximizes the surface.
   */
  void unmaximize();
  
  /** Registers a surface as a potential drop destination.
   */
  void register_dnd();

  
  /** Begins a surface resize operation (for a toplevel surface).
   * 
   * This function assumes that the drag is controlled by the
   * client pointer device, use begin_resize_drag_for_device()
   * to begin a drag with a different device.
   * 
   * @param edge The edge or corner from which the drag is started.
   * @param button The button being used to drag, or 0 for a keyboard-initiated drag.
   * @param root_x Surface X coordinate of mouse click that began the drag.
   * @param root_y Surface Y coordinate of mouse click that began the drag.
   * @param timestamp Timestamp of mouse click that began the drag (use Gdk::Event::get_time()).
   */
  void begin_resize_drag(SurfaceEdge edge, int button, int root_x, int root_y, guint32 timestamp);

  
  /** Begins a surface resize operation (for a toplevel surface).
   * You might use this function to implement a “window resize grip,”
   * 
   * @param edge The edge or corner from which the drag is started.
   * @param device The device used for the operation.
   * @param button The button being used to drag, or 0 for a keyboard-initiated drag.
   * @param root_x Surface X coordinate of mouse click that began the drag.
   * @param root_y Surface Y coordinate of mouse click that began the drag.
   * @param timestamp Timestamp of mouse click that began the drag (use Gdk::Event::get_time()).
   */
  void resize_drag(SurfaceEdge edge, const Glib::RefPtr<Device>& device, int button, int root_x, int root_y, guint32 timestamp);

  
  /** Begins a surface move operation (for a toplevel surface).
   * 
   * This function assumes that the drag is controlled by the
   * client pointer device, use begin_move_drag_for_device()
   * to begin a drag with a different device.
   * 
   * @param button The button being used to drag, or 0 for a keyboard-initiated drag.
   * @param root_x Surface X coordinate of mouse click that began the drag.
   * @param root_y Surface Y coordinate of mouse click that began the drag.
   * @param timestamp Timestamp of mouse click that began the drag.
   */
  void begin_move_drag(int button, int root_x, int root_y, guint32 timestamp);

  
  /** Begins a surface move operation (for a toplevel surface).
   * 
   * @param device The device used for the operation.
   * @param button The button being used to drag, or 0 for a keyboard-initiated drag.
   * @param root_x Surface X coordinate of mouse click that began the drag.
   * @param root_y Surface Y coordinate of mouse click that began the drag.
   * @param timestamp Timestamp of mouse click that began the drag.
   */
  void begin_move_drag(const Glib::RefPtr<Device>& device, int button, int root_x, int root_y, guint32 timestamp);

  
  /** Starts a drag and creates a new drag context for it.
   * 
   * This function is called by the drag source.
   * 
   * @param device The device that controls this drag.
   * @param content The offered content.
   * @param actions The actions supported by this drag.
   * @param dx The x offset to @a device's position where the drag nominally started.
   * @param dy The y offset to @a device's position where the drag nominally started.
   * @return A newly created Gdk::Drag or
   * <tt>nullptr</tt> on error.
   */
  Glib::RefPtr<Drag> drag_begin_from_point(const Glib::RefPtr<Device>& device, const Glib::RefPtr<ContentProvider>& content, DragAction actions, int dx, int dy);

  
  /** Forces an expose event for @a surface to be scheduled.
   * 
   * If the invalid area of @a surface is empty, an expose event will
   * still be emitted. Its invalid region will be empty.
   * 
   * This function is useful for implementations that track invalid
   * regions on their own.
   */
  void queue_expose();

  
  /** Temporarily freezes a surface such that it won’t receive expose
   * events.  The surface will begin receiving expose events again when
   * thaw_updates() is called. If freeze_updates()
   * has been called more than once, thaw_updates() must be called
   * an equal number of times to begin processing exposes.
   */
  void freeze_updates();
  
  /** Thaws a surface frozen with freeze_updates().
   */
  void thaw_updates();

  
  /** Constrains a desired width and height according to a
   * set of geometry hints (such as minimum and maximum size).
   * 
   * @param geometry A Gdk::Geometry structure.
   * @param flags A mask indicating what portions of @a geometry are set.
   * @param width Desired width of surface.
   * @param height Desired height of the surface.
   * @param new_width Location to store resulting width.
   * @param new_height Location to store resulting height.
   */
  static void constrain_size(const Geometry& geometry, Hints flags, int width, int height, int& new_width, int& new_height);

  
  /** Moves the surface into fullscreen mode. This means the
   * surface covers the entire screen and is above any panels
   * or task bars.
   * 
   * If the surface was already fullscreen, then this function does nothing.
   * 
   * On X11, asks the window manager to put @a surface in a fullscreen
   * state, if the window manager supports this operation. Not all
   * window managers support this, and some deliberately ignore it or
   * don’t have a concept of “fullscreen”; so you can’t rely on the
   * fullscreenification actually happening. But it will happen with
   * most standard window managers, and GDK makes a best effort to get
   * it to happen.
   */
  void fullscreen();
  
  /** Moves the surface into fullscreen mode on the given monitor. This means
   * the surface covers the entire screen and is above any panels or task bars.
   * 
   * If the surface was already fullscreen, then this function does nothing.
   * 
   * @param monitor Which monitor to display fullscreen on.
   */
  void fullscreen_on_monitor(const Glib::RefPtr<Monitor>& monitor);
  
  /** Specifies whether the @a surface should span over all monitors (in a multi-head
   * setup) or only the current monitor when in fullscreen mode.
   * 
   * The @a mode argument is from the Gdk::FullscreenMode enumeration.
   * If Gdk::FullscreenMode::ON_ALL_MONITORS is specified, the fullscreen @a surface will
   * span over all monitors of the display.
   * 
   * On X11, searches through the list of monitors display the ones
   * which delimit the 4 edges of the entire display and will ask the window
   * manager to span the @a surface over these monitors.
   * 
   * If the XINERAMA extension is not available or not usable, this function
   * has no effect.
   * 
   * Not all window managers support this, so you can’t rely on the fullscreen
   * surface to span over the multiple monitors when Gdk::FullscreenMode::ON_ALL_MONITORS
   * is specified.
   * 
   * @param mode Fullscreen mode.
   */
  void set_fullscreen_mode(FullscreenMode mode);
  
  /** Obtains the Gdk::FullscreenMode of the @a surface.
   * 
   * @return The Gdk::FullscreenMode applied to the surface when fullscreen.
   */
  FullscreenMode get_fullscreen_mode() const;
  
  /** Moves the surface out of fullscreen mode. If the surface was not
   * fullscreen, does nothing.
   * 
   * On X11, asks the window manager to move @a surface out of the fullscreen
   * state, if the window manager supports this operation. Not all
   * window managers support this, and some deliberately ignore it or
   * don’t have a concept of “fullscreen”; so you can’t rely on the
   * unfullscreenification actually happening. But it will happen with
   * most standard window managers, and GDK makes a best effort to get
   * it to happen.
   */
  void unfullscreen();

  
  /** Set if @a surface must be kept above other surfaces. If the
   * surface was already above, then this function does nothing.
   * 
   * On X11, asks the window manager to keep @a surface above, if the window
   * manager supports this operation. Not all window managers support
   * this, and some deliberately ignore it or don’t have a concept of
   * “keep above”; so you can’t rely on the surface being kept above.
   * But it will happen with most standard window managers,
   * and GDK makes a best effort to get it to happen.
   * 
   * @param setting Whether to keep @a surface above other surfaces.
   */
  void set_keep_above(bool setting =  true);
  
  /** Set if @a surface must be kept below other surfaces. If the
   * surface was already below, then this function does nothing.
   * 
   * On X11, asks the window manager to keep @a surface below, if the window
   * manager supports this operation. Not all window managers support
   * this, and some deliberately ignore it or don’t have a concept of
   * “keep below”; so you can’t rely on the surface being kept below.
   * But it will happen with most standard window managers,
   * and GDK makes a best effort to get it to happen.
   * 
   * @param setting Whether to keep @a surface below other surfaces.
   */
  void set_keep_below(bool setting =  true);

  
  /** Set @a surface to render as partially transparent,
   * with opacity 0 being fully transparent and 1 fully opaque. (Values
   * of the opacity parameter are clamped to the [0,1] range.) 
   * 
   * For toplevel surfaces this depends on support from the windowing system
   * that may not always be there. For instance, On X11, this works only on
   * X screens with a compositing manager running. On Wayland, there is no
   * per-surface opacity value that the compositor would apply. Instead, use
   * `gdk_surface_set_opaque_region (surface, <tt>nullptr</tt>)` to tell the compositor
   * that the entire surface is (potentially) non-opaque, and draw your content
   * with alpha, or use gtk_widget_set_opacity() to set an overall opacity
   * for your widgets.
   * 
   * Support for non-toplevel surfaces was added in 3.8.
   * 
   * @param opacity Opacity.
   */
  void set_opacity(double opacity);

  
  /** Determines whether or not the desktop environment shuld be hinted that
   * the surface does not want to receive input focus.
   * 
   * @return Whether or not the surface should receive input focus.
   */
  bool get_accept_focus() const;
  
  /** Setting @a accept_focus to <tt>false</tt> hints the desktop environment that the
   * surface doesn’t want to receive input focus.
   * 
   * On X, it is the responsibility of the window manager to interpret this
   * hint. ICCCM-compliant window manager usually respect it.
   * 
   * @param accept_focus <tt>true</tt> if the surface should receive input focus.
   */
  void set_accept_focus(bool accept_focus =  true);

  
  /** Determines whether or not the desktop environment should be hinted that the
   * surface does not want to receive input focus when it is mapped.
   * 
   * @return Whether or not the surface wants to receive input focus when
   * it is mapped.
   */
  bool get_focus_on_map() const;
  
  /** Setting @a focus_on_map to <tt>false</tt> hints the desktop environment that the
   * surface doesn’t want to receive input focus when it is mapped.
   * focus_on_map should be turned off for surfaces that aren’t triggered
   * interactively (such as popups from network activity).
   * 
   * On X, it is the responsibility of the window manager to interpret
   * this hint. %Window managers following the freedesktop.org window
   * manager extension specification should respect it.
   * 
   * @param focus_on_map <tt>true</tt> if the surface should receive input focus when mapped.
   */
  void set_focus_on_map(bool focus_on_map);

  
  /** This function will enable multidevice features in @a surface.
   * 
   * Multidevice aware surfaces will need to handle properly multiple,
   * per device enter/leave events, device grabs and grab ownerships.
   * 
   * @param support_multidevice <tt>true</tt> to enable multidevice support in @a surface.
   */
  void set_support_multidevice(bool support_multidevice =  true);
  
  /** Returns <tt>true</tt> if the surface is aware of the existence of multiple
   * devices.
   * 
   * @return <tt>true</tt> if the surface handles multidevice features.
   */
  bool get_support_multidevice();

  
  /** Gets the frame clock for the surface. The frame clock for a surface
   * never changes unless the surface is reparented to a new toplevel
   * surface.
   * 
   * @newin{3,24}
   * 
   * @return The frame clock.
   */
  Glib::RefPtr<FrameClock> get_frame_clock();
  
  /** Gets the frame clock for the surface. The frame clock for a surface
   * never changes unless the surface is reparented to a new toplevel
   * surface.
   * 
   * @newin{3,24}
   * 
   * @return The frame clock.
   */
  Glib::RefPtr<const FrameClock> get_frame_clock() const;

  
  /** For optimisation purposes, compositing window managers may
   * like to not draw obscured regions of surfaces, or turn off blending
   * during for these regions. With RGB windows with no transparency,
   * this is just the shape of the window, but with ARGB32 windows, the
   * compositor does not know what regions of the window are transparent
   * or not.
   * 
   * This function only works for toplevel surfaces.
   * 
   * GTK will update this property automatically if
   * the @a surface background is opaque, as we know where the opaque regions
   * are. If your surface background is not opaque, please update this
   * property in your Gtk::Widget::signal_style_updated() handler.
   * 
   * @param region A region, or <tt>nullptr</tt>.
   */
  void set_opaque_region(const ::Cairo::RefPtr<const ::Cairo::Region>& region);

  
  /** Newer GTK windows using client-side decorations use extra geometry
   * around their frames for effects like shadows and invisible borders.
   * %Window managers that want to maximize windows or snap to edges need
   * to know where the extents of the actual frame lie, so that users
   * don’t feel like windows are snapping against random invisible edges.
   * 
   * Note that this property is automatically updated by GTK, so this
   * function should only be used by applications which do not use GTK
   * to create toplevel surfaces.
   * 
   * @param left The left extent.
   * @param right The right extent.
   * @param top The top extent.
   * @param bottom The bottom extent.
   */
  void set_shadow_width(int left, int right, int top, int bottom);

  
  /** Asks the windowing system to show the window menu. The window menu
   * is the menu shown when right-clicking the titlebar on traditional
   * windows managed by the window manager. This is useful for windows
   * using client-side decorations, activating it with a right-click
   * on the window decorations.
   * 
   * @param event A Gdk::Event to show the menu for.
   * @return <tt>true</tt> if the window menu was shown and <tt>false</tt> otherwise.
   */
  bool show_window_menu(const Glib::RefPtr<const Event>& event);

  
  /** Creates a new GLContext matching the framebuffer format to the visual of the
   * Surface. The context is disconnected from any particular surface.
   *
   * If the creation of the GLContext failed an error will be thrown.
   *
   * Before using the returned GLContext, you will need to call
   * GLContext::make_current() or GLContext::realize().
   *
   * @newin{3,18}
   *
   * @return GLContext The newly created context.
   *
   * @throws GLError On missing GL implementation or extension required for context creation.
   */
  Glib::RefPtr<Gdk::GLContext> create_gl_context();

  
  /** Creates a new Gdk::CairoContext for rendering on @a surface.
   * 
   * @return The newly created Gdk::CairoContext.
   */
  Glib::RefPtr<Gdk::CairoContext> create_cairo_context();

  // no_default_handler because the wrapped C signals have no default handlers.
 

  /**
   * @par Slot Prototype:
   * <tt>void on_my_%moved_to_rect(const Gdk::Rectangle& flipped_rect, const Gdk::Rectangle& final_rect, bool flipped_x, bool flipped_y)</tt>
   *
   * Flags: Run First
   *
   * Emitted when the position of @a surface is finalized after being moved to a
   * destination rectangle.
   * 
   *  @a surface might be flipped over the destination rectangle in order to keep
   * it on-screen, in which case @a flipped_x and @a flipped_y will be set to <tt>true</tt>
   * accordingly.
   * 
   *  @a flipped_rect is the ideal position of @a surface after any possible
   * flipping, but before any possible sliding. @a final_rect is @a flipped_rect,
   * but possibly translated in the case that flipping is still ineffective in
   * keeping @a surface on-screen.
   * Stability: Private
   * 
   * @param flipped_rect The position of @a surface after any possible
   * flipping or <tt>nullptr</tt> if the backend can't obtain it.
   * @param final_rect The final position of @a surface or <tt>nullptr</tt> if the
   * backend can't obtain it.
   * @param flipped_x <tt>true</tt> if the anchors were flipped horizontally.
   * @param flipped_y <tt>true</tt> if the anchors were flipped vertically.
   */

  Glib::SignalProxy<void(const Gdk::Rectangle&, const Gdk::Rectangle&, bool, bool)> signal_moved_to_rect();

  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%size_changed(int width, int height)</tt>
   *
   * Flags: Run First
   *
   * Emitted when the size of @a surface is changed.
   * 
   * @param width The new width.
   * @param height The new height.
   */

  Glib::SignalProxy<void(int, int)> signal_size_changed();

 
  /**
   * @par Slot Prototype:
   * <tt>bool on_my_%render(const ::Cairo::RefPtr<const ::Cairo::Region>& expose_region)</tt>
   *
   * Flags: Run Last
   *
   * Emitted when part of the surface needs to be redrawn.
   * 
   * @param expose_region The region that needs to be redrawn.
   * @return <tt>true</tt> to indicate that the signal has been handled.
   */

  Glib::SignalProxy<bool(const ::Cairo::RefPtr<const ::Cairo::Region>&)> signal_render();

 
  /**
   * @par Slot Prototype:
   * <tt>bool on_my_%event(const Glib::RefPtr<const Event>& event)</tt>
   *
   * Flags: Run Last
   *
   * Emitted when GDK receives an input event for @a surface.
   * 
   * @param event An input event.
   * @return <tt>true</tt> to indicate that the event has been handled.
   */

  Glib::SignalProxy<bool(const Glib::RefPtr<const Event>&)> signal_event();


  /** The mouse pointer for a Gdk::Surface. See Gdk::Surface::set_cursor() and
   * Gdk::Surface::get_cursor() for details.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<Cursor> > property_cursor() ;

/** The mouse pointer for a Gdk::Surface. See Gdk::Surface::set_cursor() and
   * Gdk::Surface::get_cursor() for details.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Cursor> > property_cursor() const;

  /** The Gdk::Display connection of the surface. See Gdk::Surface::get_display()
   * for details.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Display> > property_display() const;


  /** Frame Clock.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<FrameClock> > property_frame_clock() const;


  /** State.
   *
   * Default value: Gdk::Surface::State::WITHDRAWN
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< State > property_state() const;


  /** Mapped.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_mapped() const;


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Gdk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gdk::Surface::Type> : public Glib::Value_Enum<Gdk::Surface::Type>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gdk
{

/** @ingroup gdkmmEnums */
inline Surface::State operator|(Surface::State lhs, Surface::State rhs)
  { return static_cast<Surface::State>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup gdkmmEnums */
inline Surface::State operator&(Surface::State lhs, Surface::State rhs)
  { return static_cast<Surface::State>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup gdkmmEnums */
inline Surface::State operator^(Surface::State lhs, Surface::State rhs)
  { return static_cast<Surface::State>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup gdkmmEnums */
inline Surface::State operator~(Surface::State flags)
  { return static_cast<Surface::State>(~static_cast<unsigned>(flags)); }

/** @ingroup gdkmmEnums */
inline Surface::State& operator|=(Surface::State& lhs, Surface::State rhs)
  { return (lhs = static_cast<Surface::State>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup gdkmmEnums */
inline Surface::State& operator&=(Surface::State& lhs, Surface::State rhs)
  { return (lhs = static_cast<Surface::State>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup gdkmmEnums */
inline Surface::State& operator^=(Surface::State& lhs, Surface::State rhs)
  { return (lhs = static_cast<Surface::State>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }
} // namespace Gdk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gdk::Surface::State> : public Glib::Value_Flags<Gdk::Surface::State>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gdk
{

/** @ingroup gdkmmEnums */
inline Surface::Hints operator|(Surface::Hints lhs, Surface::Hints rhs)
  { return static_cast<Surface::Hints>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup gdkmmEnums */
inline Surface::Hints operator&(Surface::Hints lhs, Surface::Hints rhs)
  { return static_cast<Surface::Hints>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup gdkmmEnums */
inline Surface::Hints operator^(Surface::Hints lhs, Surface::Hints rhs)
  { return static_cast<Surface::Hints>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup gdkmmEnums */
inline Surface::Hints operator~(Surface::Hints flags)
  { return static_cast<Surface::Hints>(~static_cast<unsigned>(flags)); }

/** @ingroup gdkmmEnums */
inline Surface::Hints& operator|=(Surface::Hints& lhs, Surface::Hints rhs)
  { return (lhs = static_cast<Surface::Hints>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup gdkmmEnums */
inline Surface::Hints& operator&=(Surface::Hints& lhs, Surface::Hints rhs)
  { return (lhs = static_cast<Surface::Hints>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup gdkmmEnums */
inline Surface::Hints& operator^=(Surface::Hints& lhs, Surface::Hints rhs)
  { return (lhs = static_cast<Surface::Hints>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }
} // namespace Gdk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gdk::Surface::Hints> : public Glib::Value_Flags<Gdk::Surface::Hints>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gdk::Surface::TypeHint> : public Glib::Value_Enum<Gdk::Surface::TypeHint>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Glib
{
  /** A Glib::wrap() method for this object.
   *
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gdk::Surface
   */
  Glib::RefPtr<Gdk::Surface> wrap(GdkSurface* object, bool take_copy = false);
}


#endif /* _GDKMM_SURFACE_H */

