// Generated by gmmproc 2.58.0 -- DO NOT MODIFY!
#ifndef _GDKMM_DEVICE_H
#define _GDKMM_DEVICE_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* Copyright (C) 2002-2004 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <vector>

//#include <gdkmm/window.h>
#include <gdkmm/cursor.h>
#include <gdkmm/event.h>
#include <gdkmm/timecoord.h>
#include <gdk/gdk.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
using GdkDevice = struct _GdkDevice;
using GdkDeviceClass = struct _GdkDeviceClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Gdk
{ class Device_Class; } // namespace Gdk
#endif //DOXYGEN_SHOULD_SKIP_THIS

namespace Gdk
{

/** @addtogroup gdkmmEnums gdkmm Enums and Flags */

/** 
 *  @var EventMask EXPOSURE_MASK
 * Receive expose events.
 * 
 *  @var EventMask POINTER_MOTION_MASK
 * Receive all pointer motion events.
 * 
 *  @var EventMask POINTER_MOTION_HINT_MASK
 * Deprecated. see the explanation above.
 * 
 *  @var EventMask BUTTON_MOTION_MASK
 * Receive pointer motion events while any button is pressed.
 * 
 *  @var EventMask BUTTON1_MOTION_MASK
 * Receive pointer motion events while 1 button is pressed.
 * 
 *  @var EventMask BUTTON2_MOTION_MASK
 * Receive pointer motion events while 2 button is pressed.
 * 
 *  @var EventMask BUTTON3_MOTION_MASK
 * Receive pointer motion events while 3 button is pressed.
 * 
 *  @var EventMask BUTTON_PRESS_MASK
 * Receive button press events.
 * 
 *  @var EventMask BUTTON_RELEASE_MASK
 * Receive button release events.
 * 
 *  @var EventMask KEY_PRESS_MASK
 * Receive key press events.
 * 
 *  @var EventMask KEY_RELEASE_MASK
 * Receive key release events.
 * 
 *  @var EventMask ENTER_NOTIFY_MASK
 * Receive window enter events.
 * 
 *  @var EventMask LEAVE_NOTIFY_MASK
 * Receive window leave events.
 * 
 *  @var EventMask FOCUS_CHANGE_MASK
 * Receive focus change events.
 * 
 *  @var EventMask STRUCTURE_MASK
 * Receive events about window configuration change.
 * 
 *  @var EventMask PROPERTY_CHANGE_MASK
 * Receive property change events.
 * 
 *  @var EventMask VISIBILITY_NOTIFY_MASK
 * Receive visibility change events.
 * 
 *  @var EventMask PROXIMITY_IN_MASK
 * Receive proximity in events.
 * 
 *  @var EventMask PROXIMITY_OUT_MASK
 * Receive proximity out events.
 * 
 *  @var EventMask SUBSTRUCTURE_MASK
 * Receive events about window configuration changes of
 * child windows.
 * 
 *  @var EventMask SCROLL_MASK
 * Receive scroll events.
 * 
 *  @var EventMask TOUCH_MASK
 * Receive touch events. @newin{3,4}
 * 
 *  @var EventMask SMOOTH_SCROLL_MASK
 * Receive smooth scrolling events. Since 3.4
 *    @a GDK_TOUCHPAD_GESTURE_MASK: receive touchpad gesture events. @newin{3,18}
 * 
 *  @var EventMask TABLET_PAD_MASK
 * Receive tablet pad events. @newin{3,22}
 * 
 *  @var EventMask ALL_EVENTS_MASK
 * The combination of all the above event masks.
 * 
 *  @enum EventMask
 * 
 * A set of bit-flags to indicate which events a window is to receive.
 * Most of these masks map onto one or more of the Gdk::EventType event types
 * above.
 * 
 * See the [input handling overview][chap-input-handling] for details of
 * [event masks][event-masks] and [event propagation][event-propagation].
 * 
 * Gdk::POINTER_MOTION_HINT_MASK is deprecated. It is a special mask
 * to reduce the number of Gdk::MOTION_NOTIFY events received. When using
 * Gdk::POINTER_MOTION_HINT_MASK, fewer Gdk::MOTION_NOTIFY events will
 * be sent, some of which are marked as a hint (the is_hint member is
 * <tt>true</tt>). To receive more motion events after a motion hint event,
 * the application needs to asks for more, by calling
 * Gdk::Event::request_motions().
 * 
 * Since GTK 3.8, motion events are already compressed by default, independent
 * of this mechanism. This compression can be disabled with
 * Gdk::Window::set_event_compression(). See the documentation of that function
 * for details.
 * 
 * If Gdk::TOUCH_MASK is enabled, the window will receive touch events
 * from touch-enabled devices. Those will come as sequences of Gdk::EventTouch
 * with type Gdk::TOUCH_UPDATE, enclosed by two events with
 * type Gdk::TOUCH_BEGIN and Gdk::TOUCH_END (or Gdk::TOUCH_CANCEL).
 * Gdk::Event::get_event_sequence() returns the event sequence for these
 * events, so different sequences may be distinguished.
 *
 * @ingroup gdkmmEnums
 * @par Bitwise operators:
 * <tt>%EventMask operator|(EventMask, EventMask)</tt><br>
 * <tt>%EventMask operator&(EventMask, EventMask)</tt><br>
 * <tt>%EventMask operator^(EventMask, EventMask)</tt><br>
 * <tt>%EventMask operator~(EventMask)</tt><br>
 * <tt>%EventMask& operator|=(EventMask&, EventMask)</tt><br>
 * <tt>%EventMask& operator&=(EventMask&, EventMask)</tt><br>
 * <tt>%EventMask& operator^=(EventMask&, EventMask)</tt><br>
 */
enum EventMask
{
  EXPOSURE_MASK = 1 << 1,
  POINTER_MOTION_MASK = 1 << 2,
  POINTER_MOTION_HINT_MASK = 1 << 3,
  BUTTON_MOTION_MASK = 1 << 4,
  BUTTON1_MOTION_MASK = 1 << 5,
  BUTTON2_MOTION_MASK = 1 << 6,
  BUTTON3_MOTION_MASK = 1 << 7,
  BUTTON_PRESS_MASK = 1 << 8,
  BUTTON_RELEASE_MASK = 1 << 9,
  KEY_PRESS_MASK = 1 << 10,
  KEY_RELEASE_MASK = 1 << 11,
  ENTER_NOTIFY_MASK = 1 << 12,
  LEAVE_NOTIFY_MASK = 1 << 13,
  FOCUS_CHANGE_MASK = 1 << 14,
  STRUCTURE_MASK = 1 << 15,
  PROPERTY_CHANGE_MASK = 1 << 16,
  VISIBILITY_NOTIFY_MASK = 1 << 17,
  PROXIMITY_IN_MASK = 1 << 18,
  PROXIMITY_OUT_MASK = 1 << 19,
  SUBSTRUCTURE_MASK = 1 << 20,
  SCROLL_MASK = 1 << 21,
  TOUCH_MASK = 1 << 22,
  SMOOTH_SCROLL_MASK = 1 << 23,
  TOUCHPAD_GESTURE_MASK = 1 << 24,
  TABLET_PAD_MASK = 1 << 25,
  ALL_EVENTS_MASK = 0xFFFFFE
};

/** @ingroup gdkmmEnums */
inline EventMask operator|(EventMask lhs, EventMask rhs)
  { return static_cast<EventMask>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup gdkmmEnums */
inline EventMask operator&(EventMask lhs, EventMask rhs)
  { return static_cast<EventMask>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup gdkmmEnums */
inline EventMask operator^(EventMask lhs, EventMask rhs)
  { return static_cast<EventMask>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup gdkmmEnums */
inline EventMask operator~(EventMask flags)
  { return static_cast<EventMask>(~static_cast<unsigned>(flags)); }

/** @ingroup gdkmmEnums */
inline EventMask& operator|=(EventMask& lhs, EventMask rhs)
  { return (lhs = static_cast<EventMask>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup gdkmmEnums */
inline EventMask& operator&=(EventMask& lhs, EventMask rhs)
  { return (lhs = static_cast<EventMask>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup gdkmmEnums */
inline EventMask& operator^=(EventMask& lhs, EventMask rhs)
  { return (lhs = static_cast<EventMask>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace Gdk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gdk::EventMask> : public Glib::Value_Flags<Gdk::EventMask>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gdk
{

/** 
 *  @var InputMode MODE_DISABLED
 * The device is disabled and will not report any events.
 * 
 *  @var InputMode MODE_SCREEN
 * The device is enabled. The device’s coordinate space
 * maps to the entire screen.
 * 
 *  @var InputMode MODE_WINDOW
 * The device is enabled. The device’s coordinate space
 * is mapped to a single window. The manner in which this window
 * is chosen is undefined, but it will typically be the same
 * way in which the focus window for key events is determined.
 * 
 *  @enum InputMode
 * 
 * An enumeration that describes the mode of an input device.
 *
 * @ingroup gdkmmEnums
 */
enum InputMode
{
  MODE_DISABLED,
  MODE_SCREEN,
  MODE_WINDOW
};

} // namespace Gdk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gdk::InputMode> : public Glib::Value_Enum<Gdk::InputMode>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gdk
{

/** 
 *  @var InputSource SOURCE_MOUSE
 * The device is a mouse. (This will be reported for the core
 * pointer, even if it is something else, such as a trackball.).
 * 
 *  @var InputSource SOURCE_PEN
 * The device is a stylus of a graphics tablet or similar device.
 * 
 *  @var InputSource SOURCE_ERASER
 * The device is an eraser. Typically, this would be the other end
 * of a stylus on a graphics tablet.
 * 
 *  @var InputSource SOURCE_CURSOR
 * The device is a graphics tablet “puck” or similar device.
 * 
 *  @var InputSource SOURCE_KEYBOARD
 * The device is a keyboard.
 * 
 *  @var InputSource SOURCE_TOUCHSCREEN
 * The device is a direct-input touch device, such
 * as a touchscreen or tablet. This device type has been added in 3.4.
 * 
 *  @var InputSource SOURCE_TOUCHPAD
 * The device is an indirect touch device, such
 * as a touchpad. This device type has been added in 3.4.
 * 
 *  @var InputSource SOURCE_TRACKPOINT
 * The device is a trackpoint. This device type has been
 * added in 3.22.
 * 
 *  @var InputSource SOURCE_TABLET_PAD
 * The device is a "pad", a collection of buttons,
 * rings and strips found in drawing tablets. This device type has been
 * added in 3.22.
 * 
 *  @enum InputSource
 * 
 * An enumeration describing the type of an input device in general terms.
 *
 * @ingroup gdkmmEnums
 */
enum InputSource
{
  SOURCE_MOUSE,
  SOURCE_PEN,
  SOURCE_ERASER,
  SOURCE_CURSOR,
  SOURCE_KEYBOARD,
  SOURCE_TOUCHSCREEN,
  SOURCE_TOUCHPAD,
  SOURCE_TRACKPOINT,
  SOURCE_TABLET_PAD
};

} // namespace Gdk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gdk::InputSource> : public Glib::Value_Enum<Gdk::InputSource>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gdk
{

/** 
 *  @var DeviceType DEVICE_TYPE_MASTER
 * Device is a master (or virtual) device. There will
 * be an associated focus indicator on the screen.
 * 
 *  @var DeviceType DEVICE_TYPE_SLAVE
 * Device is a slave (or physical) device.
 * 
 *  @var DeviceType DEVICE_TYPE_FLOATING
 * Device is a physical device, currently not attached to
 * any virtual device.
 * 
 *  @enum DeviceType
 * 
 * Indicates the device type. See [above][GdkDeviceManager.description]
 * for more information about the meaning of these device types.
 *
 * @ingroup gdkmmEnums
 */
enum DeviceType
{
  DEVICE_TYPE_MASTER,
  DEVICE_TYPE_SLAVE,
  DEVICE_TYPE_FLOATING
};

} // namespace Gdk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gdk::DeviceType> : public Glib::Value_Enum<Gdk::DeviceType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gdk
{

/** 
 *  @var GrabOwnership OWNERSHIP_NONE
 * All other devices’ events are allowed.
 * 
 *  @var GrabOwnership OWNERSHIP_WINDOW
 * Other devices’ events are blocked for the grab window.
 * 
 *  @var GrabOwnership OWNERSHIP_APPLICATION
 * Other devices’ events are blocked for the whole application.
 * 
 *  @enum GrabOwnership
 * 
 * Defines how device grabs interact with other devices.
 *
 * @ingroup gdkmmEnums
 */
enum GrabOwnership
{
  OWNERSHIP_NONE,
  OWNERSHIP_WINDOW,
  OWNERSHIP_APPLICATION
};

} // namespace Gdk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gdk::GrabOwnership> : public Glib::Value_Enum<Gdk::GrabOwnership>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gdk
{

/** 
 *  @var GrabStatus GRAB_SUCCESS
 * The resource was successfully grabbed.
 * 
 *  @var GrabStatus GRAB_ALREADY_GRABBED
 * The resource is actively grabbed by another client.
 * 
 *  @var GrabStatus GRAB_INVALID_TIME
 * The resource was grabbed more recently than the
 * specified time.
 * 
 *  @var GrabStatus GRAB_NOT_VIEWABLE
 * The grab window or the @a confine_to window are not
 * viewable.
 * 
 *  @var GrabStatus GRAB_FROZEN
 * The resource is frozen by an active grab of another client.
 * 
 *  @var GrabStatus GRAB_FAILED
 * The grab failed for some other reason. @newin{3,16}
 * 
 *  @enum GrabStatus
 * 
 * Returned by Gdk::Device::grab(), gdk_pointer_grab() and gdk_keyboard_grab() to
 * indicate success or the reason for the failure of the grab attempt.
 *
 * @ingroup gdkmmEnums
 */
enum GrabStatus
{
  GRAB_SUCCESS,
  GRAB_ALREADY_GRABBED,
  GRAB_INVALID_TIME,
  GRAB_NOT_VIEWABLE,
  GRAB_FROZEN,
  GRAB_FAILED
};

} // namespace Gdk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gdk::GrabStatus> : public Glib::Value_Enum<Gdk::GrabStatus>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gdk
{


class Display;
class Seat;
class Window;

/** A Gdk::Device instance contains a detailed description of an extended input device.
 */

class Device : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  using CppObjectType = Device;
  using CppClassType = Device_Class;
  using BaseObjectType = GdkDevice;
  using BaseClassType = GdkDeviceClass;

  // noncopyable
  Device(const Device&) = delete;
  Device& operator=(const Device&) = delete;

private:  friend class Device_Class;
  static CppClassType device_class_;

protected:
  explicit Device(const Glib::ConstructParams& construct_params);
  explicit Device(GdkDevice* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  Device(Device&& src) noexcept;
  Device& operator=(Device&& src) noexcept;

  ~Device() noexcept override;

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GdkDevice*       gobj()       { return reinterpret_cast<GdkDevice*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GdkDevice* gobj() const { return reinterpret_cast<GdkDevice*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GdkDevice* gobj_copy();

private:


protected:
  Device();

public:

  
  /** Determines the name of the device.
   * 
   * @newin{2,20}
   * 
   * @return A name.
   */
  Glib::ustring get_name() const;
  
  /** Determines whether the pointer follows device motion.
   * This is not meaningful for keyboard devices, which don't have a pointer.
   * 
   * @newin{2,20}
   * 
   * @return <tt>true</tt> if the pointer follows device motion.
   */
  bool get_has_cursor() const;

  
  /** Determines the type of the device.
   * 
   * @newin{2,20}
   * 
   * @return A Gdk::InputSource.
   */
  InputSource get_source() const;
  
  /** Determines the mode of the device.
   * 
   * @newin{2,20}
   * 
   * @return A Gdk::InputSource.
   */
  InputMode get_mode() const;
  
  /** Sets a the mode of an input device. The mode controls if the
   * device is active and whether the device’s range is mapped to the
   * entire screen or to a single window.
   * 
   * @note This is only meaningful for floating devices, master devices (and
   * slaves connected to these) drive the pointer cursor, which is not limited
   * by the input mode.
   * 
   * @param mode The input mode.
   * @return <tt>true</tt> if the mode was successfully changed.
   */
  bool set_mode(InputMode mode);
  
  /** Returns the number of keys the device currently has.
   * 
   * @newin{2,24}
   * 
   * @return The number of keys.
   */
  int get_n_keys() const;
  
  /** If @a index has a valid keyval, this function will return <tt>true</tt>
   * and fill in @a keyval and @a modifiers with the keyval settings.
   * 
   * @newin{2,20}
   * 
   * @param index The index of the macro button to get.
   * @param keyval Return value for the keyval.
   * @param modifiers Return value for modifiers.
   * @return <tt>true</tt> if keyval is set for @a index.
   */
  bool get_key(guint index_, guint& keyval, ModifierType& modifiers) const;
  
  /** Specifies the X key event to generate when a macro button of a device
   * is pressed.
   * 
   * @param index The index of the macro button to set.
   * @param keyval The keyval to generate.
   * @param modifiers The modifiers to set.
   */
  void set_key(guint index_, guint keyval, ModifierType modifiers);
  
  /** Returns the axis use for @a index.
   * 
   * @newin{2,20}
   * 
   * @param index The index of the axis.
   * @return A Gdk::AxisUse specifying how the axis is used.
   */
  AxisUse get_axis_use(guint index_) const;
  
  /** Specifies how an axis of a device is used.
   * 
   * @param index The index of the axis.
   * @param use Specifies how the axis is used.
   */
  void set_axis_use(guint index_, AxisUse use);
  
  /** Gets the current state of a pointer device relative to @a window. As a slave
   * device’s coordinates are those of its master pointer, this
   * function may not be called on devices of type Gdk::DEVICE_TYPE_SLAVE,
   * unless there is an ongoing grab on them. See grab().
   * 
   * @param window A Gdk::Window.
   * @param axes An array of doubles to store the values of
   * the axes of @a device in, or <tt>nullptr</tt>.
   * @param mask Location to store the modifiers, or <tt>nullptr</tt>.
   */
  void get_state(const Glib::RefPtr<Window>& window, double& axes, ModifierType& mask);

  /** Obtains the motion history for a device.
   * Given a starting and ending timestamp, this will return all events
   * in the motion history for the device in the given range of time.
   * Some windowing systems do not support motion history, in which case, false will be returned.
   * (This is not distinguishable from the case where motion history is supported and no events were found.)
   *
   * @param window The window with respect to which which the event coordinates will be reported.
   * @param start Starting timestamp for range of events to return.
   * @param stop Ending timestamp for the range of events to return.
   * @result A vector of TimeCoord.
   */
  std::vector<TimeCoord> get_history(const Glib::RefPtr<Window>& window, guint32 start, guint32 stop) const;
  

  /** If the device if of type Gdk::DEVICE_TYPE_MASTER, it will return
   * the list of slave devices attached to it, otherwise it will return
   * <tt>nullptr</tt>
   * 
   * @return The list of slave devices, or <tt>nullptr</tt>.
   */
  std::vector<Glib::RefPtr<Gdk::Device> > list_slave_devices();
  //TODO:_WRAP_METHOD(std::vector<Glib::RefPtr<const Gdk::Device> > list_slave_devices() const, gdk_device_list_slave_devices, constversion)

  
  /** Returns the number of axes the device currently has.
   * 
   * @newin{3,0}
   * 
   * @return The number of axes.
   */
  int get_n_axes() const;

  /** Returns the labels for the axes that the device currently has.
   * @newin{3,4}
   */
  std::vector<std::string> list_axes() const;
  

  //TODO: Use a string instead of a GdkAtom:
  
  /** Interprets an array of double as axis values for a given device,
   * and locates the value in the array for a given axis label, as returned
   * by list_axes()
   * 
   * @newin{3,0}
   * 
   * @param axes Pointer to an array of axes.
   * @param axis_label Gdk::Atom with the axis label.
   * @param value Location to store the found value.
   * @return <tt>true</tt> if the given axis use was found, otherwise <tt>false</tt>.
   */
  bool get_axis_value(double& axes, GdkAtom axis_label, double& value) const;

  
  /** Interprets an array of double as axis values for a given device,
   * and locates the value in the array for a given axis use.
   * 
   * @param axes Pointer to an array of axes.
   * @param use The use to look for.
   * @param value Location to store the found value.
   * @return <tt>true</tt> if the given axis use was found, otherwise <tt>false</tt>.
   */
  bool get_axis(double& axes, AxisUse use, double& value) const;

  
  /** Returns the Gdk::Display to which @a device pertains.
   * 
   * @newin{3,0}
   * 
   * @return A Gdk::Display. This memory is owned
   * by GTK+, and must not be freed or unreffed.
   */
  Glib::RefPtr<Display> get_display();
  
  /** Returns the Gdk::Display to which @a device pertains.
   * 
   * @newin{3,0}
   * 
   * @return A Gdk::Display. This memory is owned
   * by GTK+, and must not be freed or unreffed.
   */
  Glib::RefPtr<const Display> get_display() const;

  
  /** Returns the associated device to @a device, if @a device is of type
   * Gdk::DEVICE_TYPE_MASTER, it will return the paired pointer or
   * keyboard.
   * 
   * If @a device is of type Gdk::DEVICE_TYPE_SLAVE, it will return
   * the master device to which @a device is attached to.
   * 
   * If @a device is of type Gdk::DEVICE_TYPE_FLOATING, <tt>nullptr</tt> will be
   * returned, as there is no associated device.
   * 
   * @newin{3,0}
   * 
   * @return The associated device, or
   * <tt>nullptr</tt>.
   */
  Glib::RefPtr<Device> get_associated_device();
  
  /** Returns the associated device to @a device, if @a device is of type
   * Gdk::DEVICE_TYPE_MASTER, it will return the paired pointer or
   * keyboard.
   * 
   * If @a device is of type Gdk::DEVICE_TYPE_SLAVE, it will return
   * the master device to which @a device is attached to.
   * 
   * If @a device is of type Gdk::DEVICE_TYPE_FLOATING, <tt>nullptr</tt> will be
   * returned, as there is no associated device.
   * 
   * @newin{3,0}
   * 
   * @return The associated device, or
   * <tt>nullptr</tt>.
   */
  Glib::RefPtr<const Device> get_associated_device() const;

  
  /** Returns the device type for @a device.
   * 
   * @newin{3,0}
   * 
   * @return The Gdk::DeviceType for @a device.
   */
  DeviceType get_device_type() const;

  
#ifndef GDKMM_DISABLE_DEPRECATED

  /** Grabs the device so that all events coming from this device are passed to
   * this application until the device is ungrabbed with ungrab(),
   * or the window becomes unviewable. This overrides any previous grab on the device
   * by this client.
   * 
   * Note that @a device and @a window need to be on the same display.
   * 
   * Device grabs are used for operations which need complete control over the
   * given device events (either pointer or keyboard). For example in GTK+ this
   * is used for Drag and Drop operations, popup menus and such.
   * 
   * Note that if the event mask of an X window has selected both button press
   * and button release events, then a button press event will cause an automatic
   * pointer grab until the button is released. X does this automatically since
   * most applications expect to receive button press and release events in pairs.
   * It is equivalent to a pointer grab on the window with @a owner_events set to
   * <tt>true</tt>.
   * 
   * If you set up anything at the time you take the grab that needs to be
   * cleaned up when the grab ends, you should handle the Gdk::EventGrabBroken
   * events that are emitted when the grab ends unvoluntarily.
   * 
   * @newin{3,0}
   * 
   * Deprecated: 3.20. Use Gdk::Seat::grab() instead.
   * 
   * @deprecated Use Gdk::Seat::grab() instead.
   * 
   * @param window The Gdk::Window which will own the grab (the grab window).
   * @param grab_ownership Specifies the grab ownership.
   * @param owner_events If <tt>false</tt> then all device events are reported with respect to
   *  @a window and are only reported if selected by @a event_mask. If
   * <tt>true</tt> then pointer events for this application are reported
   * as normal, but pointer events outside this application are
   * reported with respect to @a window and only if selected by
   *  @a event_mask. In either mode, unreported events are discarded.
   * @param event_mask Specifies the event mask, which is used in accordance with
   *  @a owner_events.
   * @param cursor The cursor to display while the grab is active if the device is
   * a pointer. If this is <tt>nullptr</tt> then the normal cursors are used for
   *  @a window and its descendants, and the cursor for @a window is used
   * elsewhere.
   * @param time The timestamp of the event which led to this pointer grab. This
   * usually comes from the Gdk::Event struct, though Gdk::CURRENT_TIME
   * can be used if the time isn’t known.
   * @return Gdk::GRAB_SUCCESS if the grab was successful.
   */
  GrabStatus grab(const Glib::RefPtr<Window>& window, GrabOwnership grab_ownership, bool owner_events, EventMask event_mask, const Glib::RefPtr<Cursor>& cursor, guint32 time_);
#endif // GDKMM_DISABLE_DEPRECATED


#ifndef GDKMM_DISABLE_DEPRECATED

  /** See the grab() method which takes more parameters.
   *
   * @deprecated Use Gdk::Seat::grab() instead.
   */
  GrabStatus grab(const Glib::RefPtr<Window>& window, GrabOwnership grab_ownership, bool owner_events, EventMask event_mask, guint32 time_);
#endif // GDKMM_DISABLE_DEPRECATED


#ifndef GDKMM_DISABLE_DEPRECATED

  /** Release any grab on @a device.
   * 
   * @newin{3,0}
   * 
   * Deprecated: 3.20. Use Gdk::Seat::ungrab() instead.
   * 
   * @deprecated Use Gdk::Seat::ungrab() instead.
   * 
   * @param time A timestap (e.g. Gdk::CURRENT_TIME).
   */
  void ungrab(guint32 time_);
#endif // GDKMM_DISABLE_DEPRECATED


  /** Warps @a device in @a display to the point @a x, @a y on
   * the screen @a screen, unless the device is confined
   * to a window by a grab, in which case it will be moved
   * as far as allowed by the grab. Warping the pointer
   * creates events as if the user had moved the mouse
   * instantaneously to the destination.
   * 
   * Note that the pointer should normally be under the
   * control of the user. This function was added to cover
   * some rare use cases like keyboard navigation support
   * for the color picker in the Gtk::ColorSelectionDialog.
   * 
   * @newin{3,0}
   * 
   * @param screen The screen to warp @a device to.
   * @param x The X coordinate of the destination.
   * @param y The Y coordinate of the destination.
   */
  void warp(const Glib::RefPtr<Screen>& screen, int x, int y);

  /** Gets the current location of the device.
   * As a slave device coordinates are those of its master pointer,
   * this function may not be called on devices of type GDK_DEVICE_TYPE_SLAVE,
   * unless there is an ongoing grab on them. See grab().
   *
   * @param x This will contain the root window X coordinate of the device.
   * @param y This will contain the root window X coordinate of the device.
   */
  void get_position(int& x, int& y) const;

  /** Gets the current location of device.
   * As a slave device coordinates are those of its master pointer,
   * this function may not be called on devices of type GDK_DEVICE_TYPE_SLAVE,
   * unless there is an ongoing grab on them. See grab().
   *
   * @param screen This will contain the screen that the device is on.
   * @param x This will contain the root window X coordinate of the device.
   * @param y This will contain the root window X coordinate of the device.
   */
  void get_position(Glib::RefPtr<Screen>& screen, int& x, int& y) const;
  

  /** Gets the current location of the device in double precision.
   * As a slave device coordinates are those of its master pointer,
   * this function may not be called on devices of type GDK_DEVICE_TYPE_SLAVE,
   * unless there is an ongoing grab on them. See grab().
   *
   * @param x This will contain the root window X coordinate of the device.
   * @param y This will contain the root window X coordinate of the device.
   *
   * @newin{3,10}
   */
  void get_position(double& x, double& y) const;

   /** Gets the current location of the device in double precision.
   * As a slave device coordinates are those of its master pointer,
   * this function may not be called on devices of type GDK_DEVICE_TYPE_SLAVE,
   * unless there is an ongoing grab on them. See grab().
   *
   * @param screen This will contain the screen that the device is on.
   * @param x This will contain the root window X coordinate of the device.
   * @param y This will contain the root window X coordinate of the device.
   *
   * @newin{3,10}
   */
  void get_position(Glib::RefPtr<Screen>& screen, double& x, double& y) const;
  

  /** Obtains the window underneath @a device, returning the location of the device in @a win_x and @a win_y. Returns
   * <tt>nullptr</tt> if the window tree under @a device is not known to GDK (for example, belongs to another application).
   * 
   * As a slave device coordinates are those of its master pointer, This
   * function may not be called on devices of type Gdk::DEVICE_TYPE_SLAVE,
   * unless there is an ongoing grab on them, see grab().
   * 
   * @newin{3,0}
   * 
   * @param win_x Return location for the X coordinate of the device location,
   * relative to the window origin, or <tt>nullptr</tt>.
   * @param win_y Return location for the Y coordinate of the device location,
   * relative to the window origin, or <tt>nullptr</tt>.
   * @return The Gdk::Window under the
   * device position, or <tt>nullptr</tt>.
   */
  Glib::RefPtr<Window> get_window_at_position(int& win_x, int& win_y);
  
  /** Obtains the window underneath @a device, returning the location of the device in @a win_x and @a win_y. Returns
   * <tt>nullptr</tt> if the window tree under @a device is not known to GDK (for example, belongs to another application).
   * 
   * As a slave device coordinates are those of its master pointer, This
   * function may not be called on devices of type Gdk::DEVICE_TYPE_SLAVE,
   * unless there is an ongoing grab on them, see grab().
   * 
   * @newin{3,0}
   * 
   * @param win_x Return location for the X coordinate of the device location,
   * relative to the window origin, or <tt>nullptr</tt>.
   * @param win_y Return location for the Y coordinate of the device location,
   * relative to the window origin, or <tt>nullptr</tt>.
   * @return The Gdk::Window under the
   * device position, or <tt>nullptr</tt>.
   */
  Glib::RefPtr<const Window> get_window_at_position(int& win_x, int& win_y) const;

  //TODO: Would this be ambiguous? Test it.
  //_WRAP_METHOD(Glib::RefPtr<Window> get_window_at_position(double& win_x, double& win_y), gdk_device_get_window_at_position_double, refreturn)
  //_WRAP_METHOD(Glib::RefPtr<const Window> get_window_at_position(double& win_x, double& win_y) const, gdk_device_get_window_at_position_double, refreturn, constversion)

  /** Obtains the window underneath the device.
   * Returns an empty RefPtr if the window tree under the device is not known to GDK (for example, belongs to another application).
   *
   * As a slave device coordinates are those of its master pointer, This
   * function may not be called on devices of type Gdk::DEVICE_TYPE_SLAVE,
   * unless there is an ongoing grab on them. See grab().
   *
   * @newin{3,0}
   *
   * @return The Gdk::Window under the device position.
   */
  Glib::RefPtr<Window> get_window_at_position();

  /** Obtains the window underneath the device.
   * Returns an empty RefPtr if the window tree under the device is not known to GDK (for example, belongs to another application).
   *
   * As a slave device coordinates are those of its master pointer, This
   * function may not be called on devices of type Gdk::DEVICE_TYPE_SLAVE,
   * unless there is an ongoing grab on them. See grab().
   *
   * @newin{3,0}
   *
   * @return The Gdk::Window under the device position.
   */
  Glib::RefPtr<const Window> get_window_at_position() const;

  
  /** Gets information about which window the given pointer device is in, based on events
   * that have been received so far from the display server. If another application
   * has a pointer grab, or this application has a grab with owner_events = <tt>false</tt>,
   * <tt>nullptr</tt> may be returned even if the pointer is physically over one of this
   * application's windows.
   * 
   * @newin{3,12}
   * 
   * @return The last window the device.
   */
  Glib::RefPtr<Window> get_last_event_window();
  
  /** Gets information about which window the given pointer device is in, based on events
   * that have been received so far from the display server. If another application
   * has a pointer grab, or this application has a grab with owner_events = <tt>false</tt>,
   * <tt>nullptr</tt> may be returned even if the pointer is physically over one of this
   * application's windows.
   * 
   * @newin{3,12}
   * 
   * @return The last window the device.
   */
  Glib::RefPtr<const Window> get_last_event_window() const;

  
  /** Returns the vendor ID of this device, or <tt>nullptr</tt> if this information couldn't
   * be obtained. This ID is retrieved from the device, and is thus constant for
   * it.
   * 
   * This function, together with get_product_id(), can be used to eg.
   * compose Settings paths to store settings for this device.
   * 
   * 
   * [C example ellipted]
   * 
   * @newin{3,16}
   * 
   * @return The vendor ID, or <tt>nullptr</tt>.
   */
  Glib::ustring get_vendor_id() const;
  
  /** Returns the product ID of this device, or <tt>nullptr</tt> if this information couldn't
   * be obtained. This ID is retrieved from the device, and is thus constant for
   * it. See get_vendor_id() for more information.
   * 
   * @newin{3,16}
   * 
   * @return The product ID, or <tt>nullptr</tt>.
   */
  Glib::ustring get_product_id();

  
  /** Returns the Gdk::Seat the device belongs to.
   * 
   * @newin{3,20}
   * 
   * @return A Gdk::Seat. This memory is owned by GTK+ and
   * must not be freed.
   */
  Glib::RefPtr<Seat> get_seat();
  
  /** Returns the Gdk::Seat the device belongs to.
   * 
   * @newin{3,20}
   * 
   * @return A Gdk::Seat. This memory is owned by GTK+ and
   * must not be freed.
   */
  Glib::RefPtr<const Seat> get_seat() const;

  
  /** Returns the axes currently available on the device.
   * 
   * @newin{3,22}
   */
  AxisFlags get_axes() const;

  // We use no_default_handler because _GdkDeviceClass is private.
  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%changed()</tt>
   *
   * Flags: Run Last
   *
   * The signal_changed() signal is emitted either when the Gdk::Device
   * has changed the number of either axes or keys. For example
   * In X this will normally happen when the slave device routing
   * events through the master device changes (for example, user
   * switches from the USB mouse to a tablet), in that case the
   * master device will change to reflect the new slave device
   * axes and keys.
   * 
   * @newin{3,22}
   */

  Glib::SignalProxy< void > signal_changed();


  //TODO: Wrap or ignore the "device-manager" and "tool" properties and the
  // "tool-changed" signal. GdkDeviceManager is not recommended for use in new code.
  // GdkDeviceTool is not fully documented. It's not clear if it's meant to
  // be used outside gtk+.
  /** The Gdk::Display the Gdk::Device pertains to.
   * 
   * @newin{3,22}
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Display> > property_display() const;


  /** The device name.
   * 
   * @newin{3,22}
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::ustring > property_name() const;


  /** Device role in the device manager.
   * 
   * @newin{3,22}
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< DeviceType > property_type() const;


  /** Associated pointer or keyboard with this device, if any. Devices of type Gdk::DEVICE_TYPE_MASTER
   * always come in keyboard/pointer pairs. Other device types will have a <tt>nullptr</tt> associated device.
   * 
   * @newin{3,22}
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Device> > property_associated_device() const;


  /** Source type for the device.
   * 
   * @newin{3,22}
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< InputSource > property_input_source() const;


  /** Input mode for the device.
   *
   * @newin{3,22}
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< InputMode > property_input_mode() ;

/** Input mode for the device.
   *
   * @newin{3,22}
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< InputMode > property_input_mode() const;

  /** Whether the device is represented by a cursor on the screen. Devices of type
   * Gdk::DEVICE_TYPE_MASTER will have <tt>true</tt> here.
   * 
   * @newin{3,22}
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_has_cursor() const;


  /** Number of axes in the device.
   * 
   * @newin{3,22}
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< guint > property_n_axes() const;


  /** Vendor ID of this device, see Gdk::Device::get_vendor_id().
   * 
   * @newin{3,22}
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::ustring > property_vendor_id() const;


  /** Product ID of this device, see Gdk::Device::get_product_id().
   * 
   * @newin{3,22}
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::ustring > property_product_id() const;


  /** Gdk::Seat of this device.
   * 
   * @newin{3,22}
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<Seat> > property_seat() ;

/** Gdk::Seat of this device.
   * 
   * @newin{3,22}
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Seat> > property_seat() const;

  /** The maximal number of concurrent touches on a touch device.
   * Will be 0 if the device is not a touch device or if the number
   * of touches is unknown.
   * 
   * @newin{3,22}
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< guint > property_num_touches() const;


  /** The axes currently available for this device.
   * 
   * @newin{3,22}
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< AxisFlags > property_axes() const;


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Gdk


namespace Glib
{
  /** A Glib::wrap() method for this object.
   *
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gdk::Device
   */
  Glib::RefPtr<Gdk::Device> wrap(GdkDevice* object, bool take_copy = false);
}


#endif /* _GDKMM_DEVICE_H */

