// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use Cancellable;
use Error;
use ffi;
#[cfg(feature = "futures")]
use futures_core;
use glib;
use glib::object::IsA;
use glib::translate::*;
use glib_ffi;
use gobject_ffi;
#[cfg(feature = "futures")]
use std::boxed::Box as Box_;
use std::mem;
use std::ptr;

glib_wrapper! {
    pub struct ProxyResolver(Object<ffi::GProxyResolver, ffi::GProxyResolverInterface>);

    match fn {
        get_type => || ffi::g_proxy_resolver_get_type(),
    }
}

impl ProxyResolver {
    pub fn get_default() -> Option<ProxyResolver> {
        unsafe {
            from_glib_none(ffi::g_proxy_resolver_get_default())
        }
    }
}

pub trait ProxyResolverExt: Sized {
    fn is_supported(&self) -> bool;

    fn lookup<'a, P: Into<Option<&'a Cancellable>>>(&self, uri: &str, cancellable: P) -> Result<Vec<String>, Error>;

    fn lookup_async<'a, P: Into<Option<&'a Cancellable>>, Q: FnOnce(Result<Vec<String>, Error>) + Send + 'static>(&self, uri: &str, cancellable: P, callback: Q);

    #[cfg(feature = "futures")]
    fn lookup_async_future(&self, uri: &str) -> Box_<futures_core::Future<Item = (Self, Vec<String>), Error = (Self, Error)>>;
}

impl<O: IsA<ProxyResolver> + IsA<glib::object::Object> + Clone + 'static> ProxyResolverExt for O {
    fn is_supported(&self) -> bool {
        unsafe {
            from_glib(ffi::g_proxy_resolver_is_supported(self.to_glib_none().0))
        }
    }

    fn lookup<'a, P: Into<Option<&'a Cancellable>>>(&self, uri: &str, cancellable: P) -> Result<Vec<String>, Error> {
        let cancellable = cancellable.into();
        let cancellable = cancellable.to_glib_none();
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::g_proxy_resolver_lookup(self.to_glib_none().0, uri.to_glib_none().0, cancellable.0, &mut error);
            if error.is_null() { Ok(FromGlibPtrContainer::from_glib_full(ret)) } else { Err(from_glib_full(error)) }
        }
    }

    fn lookup_async<'a, P: Into<Option<&'a Cancellable>>, Q: FnOnce(Result<Vec<String>, Error>) + Send + 'static>(&self, uri: &str, cancellable: P, callback: Q) {
        let cancellable = cancellable.into();
        let cancellable = cancellable.to_glib_none();
        let user_data: Box<Box<Q>> = Box::new(Box::new(callback));
        unsafe extern "C" fn lookup_async_trampoline<Q: FnOnce(Result<Vec<String>, Error>) + Send + 'static>(_source_object: *mut gobject_ffi::GObject, res: *mut ffi::GAsyncResult, user_data: glib_ffi::gpointer)
        {
            let mut error = ptr::null_mut();
            let ret = ffi::g_proxy_resolver_lookup_finish(_source_object as *mut _, res, &mut error);
            let result = if error.is_null() { Ok(FromGlibPtrContainer::from_glib_full(ret)) } else { Err(from_glib_full(error)) };
            let callback: Box<Box<Q>> = Box::from_raw(user_data as *mut _);
            callback(result);
        }
        let callback = lookup_async_trampoline::<Q>;
        unsafe {
            ffi::g_proxy_resolver_lookup_async(self.to_glib_none().0, uri.to_glib_none().0, cancellable.0, Some(callback), Box::into_raw(user_data) as *mut _);
        }
    }

    #[cfg(feature = "futures")]
    fn lookup_async_future(&self, uri: &str) -> Box_<futures_core::Future<Item = (Self, Vec<String>), Error = (Self, Error)>> {
        use GioFuture;
        use fragile::Fragile;

        let uri = String::from(uri);
        GioFuture::new(self, move |obj, send| {
            let cancellable = Cancellable::new();
            let send = Fragile::new(send);
            let obj_clone = Fragile::new(obj.clone());
            obj.lookup_async(
                 &uri,
                 Some(&cancellable),
                 move |res| {
                     let obj = obj_clone.into_inner();
                     let res = res.map(|v| (obj.clone(), v)).map_err(|v| (obj.clone(), v));
                     let _ = send.into_inner().send(res);
                 },
            );

            cancellable
        })
    }
}
