// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use Cancellable;
use Error;
use Icon;
use InputStream;
use ffi;
#[cfg(feature = "futures")]
use futures_core;
use glib;
use glib::object::IsA;
use glib::translate::*;
use glib_ffi;
use gobject_ffi;
#[cfg(feature = "futures")]
use std::boxed::Box as Box_;
use std::mem;
use std::ptr;

glib_wrapper! {
    pub struct LoadableIcon(Object<ffi::GLoadableIcon, ffi::GLoadableIconIface>): Icon;

    match fn {
        get_type => || ffi::g_loadable_icon_get_type(),
    }
}

pub trait LoadableIconExt: Sized {
    fn load<'a, P: Into<Option<&'a Cancellable>>>(&self, size: i32, cancellable: P) -> Result<(InputStream, String), Error>;

    fn load_async<'a, P: Into<Option<&'a Cancellable>>, Q: FnOnce(Result<(InputStream, String), Error>) + Send + 'static>(&self, size: i32, cancellable: P, callback: Q);

    #[cfg(feature = "futures")]
    fn load_async_future(&self, size: i32) -> Box_<futures_core::Future<Item = (Self, (InputStream, String)), Error = (Self, Error)>>;
}

impl<O: IsA<LoadableIcon> + IsA<glib::object::Object> + Clone + 'static> LoadableIconExt for O {
    fn load<'a, P: Into<Option<&'a Cancellable>>>(&self, size: i32, cancellable: P) -> Result<(InputStream, String), Error> {
        let cancellable = cancellable.into();
        let cancellable = cancellable.to_glib_none();
        unsafe {
            let mut type_ = ptr::null_mut();
            let mut error = ptr::null_mut();
            let ret = ffi::g_loadable_icon_load(self.to_glib_none().0, size, &mut type_, cancellable.0, &mut error);
            if error.is_null() { Ok((from_glib_full(ret), from_glib_full(type_))) } else { Err(from_glib_full(error)) }
        }
    }

    fn load_async<'a, P: Into<Option<&'a Cancellable>>, Q: FnOnce(Result<(InputStream, String), Error>) + Send + 'static>(&self, size: i32, cancellable: P, callback: Q) {
        let cancellable = cancellable.into();
        let cancellable = cancellable.to_glib_none();
        let user_data: Box<Box<Q>> = Box::new(Box::new(callback));
        unsafe extern "C" fn load_async_trampoline<Q: FnOnce(Result<(InputStream, String), Error>) + Send + 'static>(_source_object: *mut gobject_ffi::GObject, res: *mut ffi::GAsyncResult, user_data: glib_ffi::gpointer)
        {
            let mut error = ptr::null_mut();
            let mut type_ = ptr::null_mut();
            let ret = ffi::g_loadable_icon_load_finish(_source_object as *mut _, res, &mut type_, &mut error);
            let result = if error.is_null() { Ok((from_glib_full(ret), from_glib_full(type_))) } else { Err(from_glib_full(error)) };
            let callback: Box<Box<Q>> = Box::from_raw(user_data as *mut _);
            callback(result);
        }
        let callback = load_async_trampoline::<Q>;
        unsafe {
            ffi::g_loadable_icon_load_async(self.to_glib_none().0, size, cancellable.0, Some(callback), Box::into_raw(user_data) as *mut _);
        }
    }

    #[cfg(feature = "futures")]
    fn load_async_future(&self, size: i32) -> Box_<futures_core::Future<Item = (Self, (InputStream, String)), Error = (Self, Error)>> {
        use GioFuture;
        use fragile::Fragile;

        GioFuture::new(self, move |obj, send| {
            let cancellable = Cancellable::new();
            let send = Fragile::new(send);
            let obj_clone = Fragile::new(obj.clone());
            obj.load_async(
                 size,
                 Some(&cancellable),
                 move |res| {
                     let obj = obj_clone.into_inner();
                     let res = res.map(|v| (obj.clone(), v)).map_err(|v| (obj.clone(), v));
                     let _ = send.into_inner().send(res);
                 },
            );

            cancellable
        })
    }
}
