// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use Converter;
use FileInfo;
use ZlibCompressorFormat;
use ffi;
use glib;
use glib::StaticType;
use glib::Value;
use glib::object::Downcast;
use glib::object::IsA;
use glib::signal::SignalHandlerId;
use glib::signal::connect;
use glib::translate::*;
use glib_ffi;
use gobject_ffi;
use std::boxed::Box as Box_;
use std::mem;
use std::mem::transmute;
use std::ptr;

glib_wrapper! {
    pub struct ZlibDecompressor(Object<ffi::GZlibDecompressor, ffi::GZlibDecompressorClass>): Converter;

    match fn {
        get_type => || ffi::g_zlib_decompressor_get_type(),
    }
}

impl ZlibDecompressor {
    pub fn new(format: ZlibCompressorFormat) -> ZlibDecompressor {
        unsafe {
            from_glib_full(ffi::g_zlib_decompressor_new(format.to_glib()))
        }
    }
}

pub trait ZlibDecompressorExt {
    fn get_file_info(&self) -> Option<FileInfo>;

    fn get_property_format(&self) -> ZlibCompressorFormat;

    fn connect_property_file_info_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_format_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;
}

impl<O: IsA<ZlibDecompressor> + IsA<glib::object::Object>> ZlibDecompressorExt for O {
    fn get_file_info(&self) -> Option<FileInfo> {
        unsafe {
            from_glib_none(ffi::g_zlib_decompressor_get_file_info(self.to_glib_none().0))
        }
    }

    fn get_property_format(&self) -> ZlibCompressorFormat {
        unsafe {
            let mut value = Value::from_type(<ZlibCompressorFormat as StaticType>::static_type());
            gobject_ffi::g_object_get_property(self.to_glib_none().0, "format".to_glib_none().0, value.to_glib_none_mut().0);
            value.get().unwrap()
        }
    }

    fn connect_property_file_info_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::file-info",
                transmute(notify_file_info_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_format_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::format",
                transmute(notify_format_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }
}

unsafe extern "C" fn notify_file_info_trampoline<P>(this: *mut ffi::GZlibDecompressor, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<ZlibDecompressor> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&ZlibDecompressor::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_format_trampoline<P>(this: *mut ffi::GZlibDecompressor, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<ZlibDecompressor> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&ZlibDecompressor::from_glib_borrow(this).downcast_unchecked())
}
