/* rygel-rendering-control.c generated by valac 0.40.8, the Vala compiler
 * generated from rygel-rendering-control.vala, do not modify */

/*
 * Copyright (C) 2008 OpenedHand Ltd.
 * Copyright (C) 2009 Nokia Corporation.
 *
 * Author: Jorn Baayen <jorn@openedhand.com>
 *         Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


#include <glib.h>
#include <glib-object.h>
#include <libgupnp/gupnp.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <rygel-core.h>
#include <glib/gi18n-lib.h>


#define RYGEL_TYPE_RENDERING_CONTROL (rygel_rendering_control_get_type ())
#define RYGEL_RENDERING_CONTROL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_RENDERING_CONTROL, RygelRenderingControl))
#define RYGEL_RENDERING_CONTROL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_RENDERING_CONTROL, RygelRenderingControlClass))
#define RYGEL_IS_RENDERING_CONTROL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_RENDERING_CONTROL))
#define RYGEL_IS_RENDERING_CONTROL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_RENDERING_CONTROL))
#define RYGEL_RENDERING_CONTROL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_RENDERING_CONTROL, RygelRenderingControlClass))

typedef struct _RygelRenderingControl RygelRenderingControl;
typedef struct _RygelRenderingControlClass RygelRenderingControlClass;
typedef struct _RygelRenderingControlPrivate RygelRenderingControlPrivate;

#define RYGEL_TYPE_CHANGE_LOG (rygel_change_log_get_type ())
#define RYGEL_CHANGE_LOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CHANGE_LOG, RygelChangeLog))
#define RYGEL_CHANGE_LOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CHANGE_LOG, RygelChangeLogClass))
#define RYGEL_IS_CHANGE_LOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CHANGE_LOG))
#define RYGEL_IS_CHANGE_LOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CHANGE_LOG))
#define RYGEL_CHANGE_LOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CHANGE_LOG, RygelChangeLogClass))

typedef struct _RygelChangeLog RygelChangeLog;
typedef struct _RygelChangeLogClass RygelChangeLogClass;

#define RYGEL_TYPE_MEDIA_PLAYER (rygel_media_player_get_type ())
#define RYGEL_MEDIA_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_PLAYER, RygelMediaPlayer))
#define RYGEL_IS_MEDIA_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_PLAYER))
#define RYGEL_MEDIA_PLAYER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_MEDIA_PLAYER, RygelMediaPlayerIface))

typedef struct _RygelMediaPlayer RygelMediaPlayer;
typedef struct _RygelMediaPlayerIface RygelMediaPlayerIface;
enum  {
	RYGEL_RENDERING_CONTROL_0_PROPERTY,
	RYGEL_RENDERING_CONTROL_MUTE_PROPERTY,
	RYGEL_RENDERING_CONTROL_VOLUME_PROPERTY,
	RYGEL_RENDERING_CONTROL_NUM_PROPERTIES
};
static GParamSpec* rygel_rendering_control_properties[RYGEL_RENDERING_CONTROL_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_MEDIA_RENDERER_PLUGIN (rygel_media_renderer_plugin_get_type ())
#define RYGEL_MEDIA_RENDERER_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_RENDERER_PLUGIN, RygelMediaRendererPlugin))
#define RYGEL_MEDIA_RENDERER_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_RENDERER_PLUGIN, RygelMediaRendererPluginClass))
#define RYGEL_IS_MEDIA_RENDERER_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_RENDERER_PLUGIN))
#define RYGEL_IS_MEDIA_RENDERER_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_RENDERER_PLUGIN))
#define RYGEL_MEDIA_RENDERER_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_RENDERER_PLUGIN, RygelMediaRendererPluginClass))

typedef struct _RygelMediaRendererPlugin RygelMediaRendererPlugin;
typedef struct _RygelMediaRendererPluginClass RygelMediaRendererPluginClass;

struct _RygelRenderingControl {
	GUPnPService parent_instance;
	RygelRenderingControlPrivate * priv;
};

struct _RygelRenderingControlClass {
	GUPnPServiceClass parent_class;
};

struct _RygelMediaPlayerIface {
	GTypeInterface parent_iface;
	gboolean (*seek) (RygelMediaPlayer* self, gint64 time);
	gboolean (*seek_bytes) (RygelMediaPlayer* self, gint64 bytes);
	gchar** (*get_protocols) (RygelMediaPlayer* self, int* result_length1);
	gchar** (*get_mime_types) (RygelMediaPlayer* self, int* result_length1);
	gchar* (*get_playback_state) (RygelMediaPlayer* self);
	void (*set_playback_state) (RygelMediaPlayer* self, const gchar* value);
	gchar** (*get_allowed_playback_speeds) (RygelMediaPlayer* self, int* result_length1);
	gchar* (*get_playback_speed) (RygelMediaPlayer* self);
	void (*set_playback_speed) (RygelMediaPlayer* self, const gchar* value);
	gchar* (*get_uri) (RygelMediaPlayer* self);
	void (*set_uri) (RygelMediaPlayer* self, const gchar* value);
	gdouble (*get_volume) (RygelMediaPlayer* self);
	void (*set_volume) (RygelMediaPlayer* self, gdouble value);
	gint64 (*get_duration) (RygelMediaPlayer* self);
	gint64 (*get_size) (RygelMediaPlayer* self);
	gchar* (*get_metadata) (RygelMediaPlayer* self);
	void (*set_metadata) (RygelMediaPlayer* self, const gchar* value);
	gchar* (*get_mime_type) (RygelMediaPlayer* self);
	void (*set_mime_type) (RygelMediaPlayer* self, const gchar* value);
	gboolean (*get_can_seek) (RygelMediaPlayer* self);
	gboolean (*get_can_seek_bytes) (RygelMediaPlayer* self);
	gchar* (*get_content_features) (RygelMediaPlayer* self);
	void (*set_content_features) (RygelMediaPlayer* self, const gchar* value);
	gint64 (*get_position) (RygelMediaPlayer* self);
	gint64 (*get_byte_position) (RygelMediaPlayer* self);
	gchar* (*get_user_agent) (RygelMediaPlayer* self);
	void (*set_user_agent) (RygelMediaPlayer* self, const gchar* value);
};

struct _RygelRenderingControlPrivate {
	gboolean _mute;
	guint _volume;
	gchar* preset_name_list;
	RygelChangeLog* changelog;
	RygelMediaPlayer* player;
};


static gpointer rygel_rendering_control_parent_class = NULL;

GType rygel_rendering_control_get_type (void) G_GNUC_CONST;
GType rygel_change_log_get_type (void) G_GNUC_CONST;
GType rygel_media_player_get_type (void) G_GNUC_CONST;
#define RYGEL_RENDERING_CONTROL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_RENDERING_CONTROL, RygelRenderingControlPrivate))
#define RYGEL_RENDERING_CONTROL_UPNP_ID "urn:upnp-org:serviceId:RenderingControl"
#define RYGEL_RENDERING_CONTROL_UPNP_TYPE "urn:schemas-upnp-org:service:RenderingControl:2"
#define RYGEL_RENDERING_CONTROL_DESCRIPTION_PATH "xml/RenderingControl2.xml"
#define RYGEL_RENDERING_CONTROL_LAST_CHANGE_NS "urn:schemas-upnp-org:metadata-1-0/RCS/"
static void rygel_rendering_control_real_constructed (GObject* base);
RygelChangeLog* rygel_change_log_new (GUPnPService* service,
                                      const gchar* service_ns);
RygelChangeLog* rygel_change_log_construct (GType object_type,
                                            GUPnPService* service,
                                            const gchar* service_ns);
static RygelMediaPlayer* rygel_rendering_control_get_player (RygelRenderingControl* self);
static void rygel_rendering_control_query_last_change_cb (RygelRenderingControl* self,
                                                   GUPnPService* service,
                                                   const gchar* variable,
                                                   GValue* value);
static void _rygel_rendering_control_query_last_change_cb_gupnp_service_query_variable (GUPnPService* _sender,
                                                                                 const gchar* variable,
                                                                                 GValue* value,
                                                                                 gpointer self);
static void rygel_rendering_control_list_presets_cb (RygelRenderingControl* self,
                                              GUPnPService* service,
                                              GUPnPServiceAction* action);
static void _rygel_rendering_control_list_presets_cb_gupnp_service_action_invoked (GUPnPService* _sender,
                                                                            GUPnPServiceAction* action,
                                                                            gpointer self);
static void rygel_rendering_control_select_preset_cb (RygelRenderingControl* self,
                                               GUPnPService* service,
                                               GUPnPServiceAction* action);
static void _rygel_rendering_control_select_preset_cb_gupnp_service_action_invoked (GUPnPService* _sender,
                                                                             GUPnPServiceAction* action,
                                                                             gpointer self);
static void rygel_rendering_control_get_mute_cb (RygelRenderingControl* self,
                                          GUPnPService* service,
                                          GUPnPServiceAction* action);
static void _rygel_rendering_control_get_mute_cb_gupnp_service_action_invoked (GUPnPService* _sender,
                                                                        GUPnPServiceAction* action,
                                                                        gpointer self);
static void rygel_rendering_control_set_mute_cb (RygelRenderingControl* self,
                                          GUPnPService* service,
                                          GUPnPServiceAction* action);
static void _rygel_rendering_control_set_mute_cb_gupnp_service_action_invoked (GUPnPService* _sender,
                                                                        GUPnPServiceAction* action,
                                                                        gpointer self);
static void rygel_rendering_control_get_volume_cb (RygelRenderingControl* self,
                                            GUPnPService* service,
                                            GUPnPServiceAction* action);
static void _rygel_rendering_control_get_volume_cb_gupnp_service_action_invoked (GUPnPService* _sender,
                                                                          GUPnPServiceAction* action,
                                                                          gpointer self);
static void rygel_rendering_control_set_volume_cb (RygelRenderingControl* self,
                                            GUPnPService* service,
                                            GUPnPServiceAction* action);
static void _rygel_rendering_control_set_volume_cb_gupnp_service_action_invoked (GUPnPService* _sender,
                                                                          GUPnPServiceAction* action,
                                                                          gpointer self);
static void rygel_rendering_control_notify_volume_cb (RygelRenderingControl* self,
                                               GObject* player,
                                               GParamSpec* p);
static void _rygel_rendering_control_notify_volume_cb_g_object_notify (GObject* _sender,
                                                                GParamSpec* pspec,
                                                                gpointer self);
gdouble rygel_media_player_get_volume (RygelMediaPlayer* self);
guint rygel_volume_to_percentage (gdouble volume);
gboolean rygel_rendering_control_get_mute (RygelRenderingControl* self);
void rygel_change_log_log_with_channel (RygelChangeLog* self,
                                        const gchar* variable,
                                        const gchar* value,
                                        const gchar* channel);
guint rygel_rendering_control_get_volume (RygelRenderingControl* self);
gchar* rygel_change_log_finish (RygelChangeLog* self);
GType rygel_media_renderer_plugin_get_type (void) G_GNUC_CONST;
RygelMediaPlayer* rygel_media_renderer_plugin_get_player (RygelMediaRendererPlugin* self);
static gboolean rygel_rendering_control_check_instance_id (RygelRenderingControl* self,
                                                    GUPnPServiceAction* action);
static gboolean rygel_rendering_control_check_channel (RygelRenderingControl* self,
                                                GUPnPServiceAction* action);
void rygel_rendering_control_set_mute (RygelRenderingControl* self,
                                       gboolean value);
void rygel_rendering_control_set_volume (RygelRenderingControl* self,
                                         guint value);
RygelRenderingControl* rygel_rendering_control_new (void);
RygelRenderingControl* rygel_rendering_control_construct (GType object_type);
void rygel_media_player_set_volume (RygelMediaPlayer* self,
                                    gdouble value);
gdouble rygel_volume_from_percentage (guint percentage);
static void rygel_rendering_control_finalize (GObject * obj);
static void _vala_rygel_rendering_control_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec);
static void _vala_rygel_rendering_control_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec);


static void
_rygel_rendering_control_query_last_change_cb_gupnp_service_query_variable (GUPnPService* _sender,
                                                                            const gchar* variable,
                                                                            GValue* value,
                                                                            gpointer self)
{
	rygel_rendering_control_query_last_change_cb ((RygelRenderingControl*) self, _sender, variable, value);
}


static void
_rygel_rendering_control_list_presets_cb_gupnp_service_action_invoked (GUPnPService* _sender,
                                                                       GUPnPServiceAction* action,
                                                                       gpointer self)
{
	rygel_rendering_control_list_presets_cb ((RygelRenderingControl*) self, _sender, action);
}


static void
_rygel_rendering_control_select_preset_cb_gupnp_service_action_invoked (GUPnPService* _sender,
                                                                        GUPnPServiceAction* action,
                                                                        gpointer self)
{
	rygel_rendering_control_select_preset_cb ((RygelRenderingControl*) self, _sender, action);
}


static void
_rygel_rendering_control_get_mute_cb_gupnp_service_action_invoked (GUPnPService* _sender,
                                                                   GUPnPServiceAction* action,
                                                                   gpointer self)
{
	rygel_rendering_control_get_mute_cb ((RygelRenderingControl*) self, _sender, action);
}


static void
_rygel_rendering_control_set_mute_cb_gupnp_service_action_invoked (GUPnPService* _sender,
                                                                   GUPnPServiceAction* action,
                                                                   gpointer self)
{
	rygel_rendering_control_set_mute_cb ((RygelRenderingControl*) self, _sender, action);
}


static void
_rygel_rendering_control_get_volume_cb_gupnp_service_action_invoked (GUPnPService* _sender,
                                                                     GUPnPServiceAction* action,
                                                                     gpointer self)
{
	rygel_rendering_control_get_volume_cb ((RygelRenderingControl*) self, _sender, action);
}


static void
_rygel_rendering_control_set_volume_cb_gupnp_service_action_invoked (GUPnPService* _sender,
                                                                     GUPnPServiceAction* action,
                                                                     gpointer self)
{
	rygel_rendering_control_set_volume_cb ((RygelRenderingControl*) self, _sender, action);
}


static void
_rygel_rendering_control_notify_volume_cb_g_object_notify (GObject* _sender,
                                                           GParamSpec* pspec,
                                                           gpointer self)
{
	rygel_rendering_control_notify_volume_cb ((RygelRenderingControl*) self, _sender, pspec);
}


static void
rygel_rendering_control_real_constructed (GObject* base)
{
	RygelRenderingControl * self;
	RygelChangeLog* _tmp0_;
	RygelMediaPlayer* _tmp1_;
	RygelMediaPlayer* _tmp2_;
	RygelMediaPlayer* _tmp3_;
	gdouble _tmp4_;
	gdouble _tmp5_;
	RygelMediaPlayer* _tmp6_;
	gdouble _tmp7_;
	gdouble _tmp8_;
	self = (RygelRenderingControl*) base;
	G_OBJECT_CLASS (rygel_rendering_control_parent_class)->constructed ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, gupnp_service_get_type (), GUPnPService));
	_tmp0_ = rygel_change_log_new ((GUPnPService*) self, RYGEL_RENDERING_CONTROL_LAST_CHANGE_NS);
	_g_object_unref0 (self->priv->changelog);
	self->priv->changelog = _tmp0_;
	_tmp1_ = rygel_rendering_control_get_player (self);
	_g_object_unref0 (self->priv->player);
	self->priv->player = _tmp1_;
	g_signal_connect_object ((GUPnPService*) self, "query-variable::LastChange", (GCallback) _rygel_rendering_control_query_last_change_cb_gupnp_service_query_variable, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::ListPresets", (GCallback) _rygel_rendering_control_list_presets_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::SelectPreset", (GCallback) _rygel_rendering_control_select_preset_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetMute", (GCallback) _rygel_rendering_control_get_mute_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::SetMute", (GCallback) _rygel_rendering_control_set_mute_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetVolume", (GCallback) _rygel_rendering_control_get_volume_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::SetVolume", (GCallback) _rygel_rendering_control_set_volume_cb_gupnp_service_action_invoked, self, 0);
	_tmp2_ = self->priv->player;
	g_signal_connect_object ((GObject*) _tmp2_, "notify::volume", (GCallback) _rygel_rendering_control_notify_volume_cb_g_object_notify, self, 0);
	_tmp3_ = self->priv->player;
	_tmp4_ = rygel_media_player_get_volume (_tmp3_);
	_tmp5_ = _tmp4_;
	self->priv->_mute = _tmp5_ == ((gdouble) 0);
	_tmp6_ = self->priv->player;
	_tmp7_ = rygel_media_player_get_volume (_tmp6_);
	_tmp8_ = _tmp7_;
	self->priv->_volume = rygel_volume_to_percentage (_tmp8_);
}


static void
rygel_rendering_control_query_last_change_cb (RygelRenderingControl* self,
                                              GUPnPService* service,
                                              const gchar* variable,
                                              GValue* value)
{
	RygelChangeLog* log = NULL;
	RygelChangeLog* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_;
	gboolean _tmp3_;
	RygelChangeLog* _tmp4_;
	RygelChangeLog* _tmp5_;
	guint _tmp6_;
	guint _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	RygelChangeLog* _tmp10_;
	const gchar* _tmp11_;
	RygelChangeLog* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (service != NULL);
	g_return_if_fail (variable != NULL);
	g_return_if_fail (value != NULL);
	_tmp0_ = rygel_change_log_new (NULL, RYGEL_RENDERING_CONTROL_LAST_CHANGE_NS);
	log = _tmp0_;
	_tmp2_ = rygel_rendering_control_get_mute (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		_tmp1_ = "1";
	} else {
		_tmp1_ = "0";
	}
	_tmp4_ = log;
	rygel_change_log_log_with_channel (_tmp4_, "Mute", _tmp1_, "Master");
	_tmp5_ = log;
	_tmp6_ = rygel_rendering_control_get_volume (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strdup_printf ("%u", _tmp7_);
	_tmp9_ = _tmp8_;
	rygel_change_log_log_with_channel (_tmp5_, "Volume", _tmp9_, "Master");
	_g_free0 (_tmp9_);
	_tmp10_ = log;
	_tmp11_ = self->priv->preset_name_list;
	rygel_change_log_log_with_channel (_tmp10_, "PresetNameList", _tmp11_, "Master");
	g_value_init (value, G_TYPE_STRING);
	_tmp12_ = log;
	_tmp13_ = rygel_change_log_finish (_tmp12_);
	_tmp14_ = _tmp13_;
	g_value_set_string (value, _tmp14_);
	_g_free0 (_tmp14_);
	_g_object_unref0 (log);
}


static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}


static RygelMediaPlayer*
rygel_rendering_control_get_player (RygelRenderingControl* self)
{
	RygelMediaPlayer* result = NULL;
	RygelMediaRendererPlugin* plugin = NULL;
	GUPnPRootDevice* _tmp0_;
	GUPnPRootDevice* _tmp1_;
	GUPnPRootDevice* _tmp2_;
	GUPnPResourceFactory* _tmp3_;
	GUPnPResourceFactory* _tmp4_;
	RygelMediaRendererPlugin* _tmp5_;
	RygelMediaRendererPlugin* _tmp6_;
	RygelMediaPlayer* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	g_object_get ((GUPnPService*) self, "root-device", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = gupnp_device_info_get_resource_factory ((GUPnPDeviceInfo*) _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, RYGEL_TYPE_MEDIA_RENDERER_PLUGIN) ? ((RygelMediaRendererPlugin*) _tmp4_) : NULL);
	_tmp6_ = _tmp5_;
	_g_object_unref0 (_tmp2_);
	plugin = _tmp6_;
	_tmp7_ = rygel_media_renderer_plugin_get_player (plugin);
	result = _tmp7_;
	_g_object_unref0 (plugin);
	return result;
}


static gboolean
int64_try_parse (const gchar* str,
                 gint64* _result_,
                 const gchar* * unparsed)
{
	gint64 _vala_result = 0LL;
	const gchar* _vala_unparsed = NULL;
	gboolean result = FALSE;
	gchar* endptr = NULL;
	gchar* _tmp0_ = NULL;
	gint64 _tmp1_;
	gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	g_return_val_if_fail (str != NULL, FALSE);
	_tmp1_ = g_ascii_strtoll (str, &_tmp0_, (guint) 0);
	endptr = _tmp0_;
	_vala_result = _tmp1_;
	_tmp2_ = endptr;
	_tmp3_ = strlen (str);
	_tmp4_ = _tmp3_;
	if (_tmp2_ == (((gchar*) str) + _tmp4_)) {
		_vala_unparsed = "";
		result = TRUE;
		if (_result_) {
			*_result_ = _vala_result;
		}
		if (unparsed) {
			*unparsed = _vala_unparsed;
		}
		return result;
	} else {
		gchar* _tmp5_;
		_tmp5_ = endptr;
		_vala_unparsed = (const gchar*) _tmp5_;
		result = FALSE;
		if (_result_) {
			*_result_ = _vala_result;
		}
		if (unparsed) {
			*unparsed = _vala_unparsed;
		}
		return result;
	}
	if (_result_) {
		*_result_ = _vala_result;
	}
	if (unparsed) {
		*unparsed = _vala_unparsed;
	}
}


static gboolean
rygel_rendering_control_check_instance_id (RygelRenderingControl* self,
                                           GUPnPServiceAction* action)
{
	gboolean result = FALSE;
	gchar* instance_id_string = NULL;
	gint64 instance_id = 0LL;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	gint64 _tmp5_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (action != NULL, FALSE);
	instance_id = (gint64) -1;
	gupnp_service_action_get (action, "InstanceID", G_TYPE_STRING, &instance_id_string, NULL);
	_tmp1_ = instance_id_string;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp2_;
		gint64 _tmp3_ = 0LL;
		gboolean _tmp4_;
		_tmp2_ = instance_id_string;
		_tmp4_ = int64_try_parse (_tmp2_, &_tmp3_, NULL);
		instance_id = _tmp3_;
		_tmp0_ = !_tmp4_;
	}
	if (_tmp0_) {
		gupnp_service_action_return_error (action, (guint) 402, _ ("Invalid argument"));
		result = FALSE;
		_g_free0 (instance_id_string);
		return result;
	}
	_tmp5_ = instance_id;
	if (_tmp5_ != ((gint64) 0)) {
		gupnp_service_action_return_error (action, (guint) 702, _ ("Invalid InstanceID"));
		result = FALSE;
		_g_free0 (instance_id_string);
		return result;
	}
	result = TRUE;
	_g_free0 (instance_id_string);
	return result;
}


static void
rygel_rendering_control_list_presets_cb (RygelRenderingControl* self,
                                         GUPnPService* service,
                                         GUPnPServiceAction* action)
{
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (service != NULL);
	g_return_if_fail (action != NULL);
	if (!rygel_rendering_control_check_instance_id (self, action)) {
		return;
	}
	_tmp0_ = self->priv->preset_name_list;
	gupnp_service_action_set (action, "CurrentPresetNameList", G_TYPE_STRING, _tmp0_, NULL);
	gupnp_service_action_return (action);
}


static void
rygel_rendering_control_select_preset_cb (RygelRenderingControl* self,
                                          GUPnPService* service,
                                          GUPnPServiceAction* action)
{
	gchar* preset_name = NULL;
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (service != NULL);
	g_return_if_fail (action != NULL);
	if (!rygel_rendering_control_check_instance_id (self, action)) {
		return;
	}
	gupnp_service_action_get (action, "PresetName", G_TYPE_STRING, &preset_name, NULL);
	_tmp0_ = preset_name;
	if (g_strcmp0 (_tmp0_, "") != 0) {
		gupnp_service_action_return_error (action, (guint) 701, _ ("Invalid Name"));
		_g_free0 (preset_name);
		return;
	}
	gupnp_service_action_return (action);
	_g_free0 (preset_name);
}


static gboolean
rygel_rendering_control_check_channel (RygelRenderingControl* self,
                                       GUPnPServiceAction* action)
{
	gboolean result = FALSE;
	gchar* channel = NULL;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (action != NULL, FALSE);
	gupnp_service_action_get (action, "Channel", G_TYPE_STRING, &channel, NULL);
	_tmp0_ = channel;
	if (g_strcmp0 (_tmp0_, "Master") != 0) {
		gupnp_service_action_return_error (action, (guint) 703, _ ("Invalid Channel"));
		result = FALSE;
		_g_free0 (channel);
		return result;
	}
	result = TRUE;
	_g_free0 (channel);
	return result;
}


static void
rygel_rendering_control_get_mute_cb (RygelRenderingControl* self,
                                     GUPnPService* service,
                                     GUPnPServiceAction* action)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (service != NULL);
	g_return_if_fail (action != NULL);
	if (!rygel_rendering_control_check_instance_id (self, action)) {
		return;
	}
	if (!rygel_rendering_control_check_channel (self, action)) {
		return;
	}
	_tmp0_ = rygel_rendering_control_get_mute (self);
	_tmp1_ = _tmp0_;
	gupnp_service_action_set (action, "CurrentMute", G_TYPE_BOOLEAN, _tmp1_, NULL);
	gupnp_service_action_return (action);
}


static void
rygel_rendering_control_set_mute_cb (RygelRenderingControl* self,
                                     GUPnPService* service,
                                     GUPnPServiceAction* action)
{
	gchar* mute_str = NULL;
	const gchar* _tmp0_;
	gboolean mute = FALSE;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (service != NULL);
	g_return_if_fail (action != NULL);
	if (!rygel_rendering_control_check_instance_id (self, action)) {
		return;
	}
	if (!rygel_rendering_control_check_channel (self, action)) {
		return;
	}
	gupnp_service_action_get (action, "DesiredMute", G_TYPE_STRING, &mute_str, NULL);
	_tmp0_ = mute_str;
	if (g_str_has_prefix (_tmp0_, "-")) {
		gupnp_service_action_return_error (action, (guint) 501, _ ("Action Failed"));
		_g_free0 (mute_str);
		return;
	}
	gupnp_service_action_get (action, "DesiredMute", G_TYPE_BOOLEAN, &mute, NULL);
	_tmp1_ = mute;
	rygel_rendering_control_set_mute (self, _tmp1_);
	gupnp_service_action_return (action);
	_g_free0 (mute_str);
}


static void
rygel_rendering_control_get_volume_cb (RygelRenderingControl* self,
                                       GUPnPService* service,
                                       GUPnPServiceAction* action)
{
	guint _tmp0_;
	guint _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (service != NULL);
	g_return_if_fail (action != NULL);
	if (!rygel_rendering_control_check_instance_id (self, action)) {
		return;
	}
	if (!rygel_rendering_control_check_channel (self, action)) {
		return;
	}
	_tmp0_ = rygel_rendering_control_get_volume (self);
	_tmp1_ = _tmp0_;
	gupnp_service_action_set (action, "CurrentVolume", G_TYPE_UINT, _tmp1_, NULL);
	gupnp_service_action_return (action);
}


static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gboolean result = FALSE;
	gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}


static void
rygel_rendering_control_set_volume_cb (RygelRenderingControl* self,
                                       GUPnPService* service,
                                       GUPnPServiceAction* action)
{
	gchar* volume_str = NULL;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	guint volume = 0U;
	guint _tmp3_;
	guint _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (service != NULL);
	g_return_if_fail (action != NULL);
	if (!rygel_rendering_control_check_instance_id (self, action)) {
		return;
	}
	if (!rygel_rendering_control_check_channel (self, action)) {
		return;
	}
	gupnp_service_action_get (action, "DesiredVolume", G_TYPE_STRING, &volume_str, NULL);
	_tmp1_ = volume_str;
	if (string_contains (_tmp1_, ".")) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp2_;
		_tmp2_ = volume_str;
		_tmp0_ = string_contains (_tmp2_, ",");
	}
	if (_tmp0_) {
		gupnp_service_action_return_error (action, (guint) 501, _ ("Action Failed"));
		_g_free0 (volume_str);
		return;
	}
	gupnp_service_action_get (action, "DesiredVolume", G_TYPE_UINT, &volume, NULL);
	_tmp3_ = volume;
	if (_tmp3_ > ((guint) 100)) {
		gupnp_service_action_return_error (action, (guint) 501, _ ("Action Failed"));
		_g_free0 (volume_str);
		return;
	}
	_tmp4_ = volume;
	rygel_rendering_control_set_volume (self, _tmp4_);
	gupnp_service_action_return (action);
	_g_free0 (volume_str);
}


static void
rygel_rendering_control_notify_volume_cb (RygelRenderingControl* self,
                                          GObject* player,
                                          GParamSpec* p)
{
	RygelMediaPlayer* _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_;
	RygelChangeLog* _tmp9_;
	guint _tmp10_;
	guint _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (player != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = self->priv->player;
	_tmp1_ = rygel_media_player_get_volume (_tmp0_);
	_tmp2_ = _tmp1_;
	self->priv->_volume = rygel_volume_to_percentage (_tmp2_);
	_tmp4_ = self->priv->_mute;
	if (_tmp4_) {
		RygelMediaPlayer* _tmp5_;
		gdouble _tmp6_;
		gdouble _tmp7_;
		_tmp5_ = self->priv->player;
		_tmp6_ = rygel_media_player_get_volume (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp3_ = _tmp7_ > ((gdouble) 0);
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		RygelChangeLog* _tmp8_;
		self->priv->_mute = FALSE;
		_tmp8_ = self->priv->changelog;
		rygel_change_log_log_with_channel (_tmp8_, "Mute", "0", "Master");
	}
	_tmp9_ = self->priv->changelog;
	_tmp10_ = rygel_rendering_control_get_volume (self);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_strdup_printf ("%u", _tmp11_);
	_tmp13_ = _tmp12_;
	rygel_change_log_log_with_channel (_tmp9_, "Volume", _tmp13_, "Master");
	_g_free0 (_tmp13_);
}


RygelRenderingControl*
rygel_rendering_control_construct (GType object_type)
{
	RygelRenderingControl * self = NULL;
	self = (RygelRenderingControl*) g_object_new (object_type, NULL);
	return self;
}


RygelRenderingControl*
rygel_rendering_control_new (void)
{
	return rygel_rendering_control_construct (RYGEL_TYPE_RENDERING_CONTROL);
}


gboolean
rygel_rendering_control_get_mute (RygelRenderingControl* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_mute;
	result = _tmp0_;
	return result;
}


void
rygel_rendering_control_set_mute (RygelRenderingControl* self,
                                  gboolean value)
{
	gboolean _tmp0_;
	const gchar* _tmp5_ = NULL;
	gboolean _tmp6_;
	gboolean _tmp7_;
	RygelChangeLog* _tmp8_;
	g_return_if_fail (self != NULL);
	self->priv->_mute = value;
	_tmp0_ = self->priv->_mute;
	if (_tmp0_) {
		RygelMediaPlayer* _tmp1_;
		_tmp1_ = self->priv->player;
		rygel_media_player_set_volume (_tmp1_, (gdouble) 0);
	} else {
		RygelMediaPlayer* _tmp2_;
		guint _tmp3_;
		guint _tmp4_;
		_tmp2_ = self->priv->player;
		_tmp3_ = rygel_rendering_control_get_volume (self);
		_tmp4_ = _tmp3_;
		rygel_media_player_set_volume (_tmp2_, rygel_volume_from_percentage (_tmp4_));
	}
	_tmp6_ = rygel_rendering_control_get_mute (self);
	_tmp7_ = _tmp6_;
	if (_tmp7_) {
		_tmp5_ = "1";
	} else {
		_tmp5_ = "0";
	}
	_tmp8_ = self->priv->changelog;
	rygel_change_log_log_with_channel (_tmp8_, "Mute", _tmp5_, "Master");
	g_object_notify_by_pspec ((GObject *) self, rygel_rendering_control_properties[RYGEL_RENDERING_CONTROL_MUTE_PROPERTY]);
}


guint
rygel_rendering_control_get_volume (RygelRenderingControl* self)
{
	guint result;
	guint _tmp0_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->_volume;
	result = _tmp0_;
	return result;
}


void
rygel_rendering_control_set_volume (RygelRenderingControl* self,
                                    guint value)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	RygelChangeLog* _tmp5_;
	guint _tmp6_;
	guint _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	g_return_if_fail (self != NULL);
	self->priv->_volume = value;
	_tmp0_ = rygel_rendering_control_get_mute (self);
	_tmp1_ = _tmp0_;
	if (!_tmp1_) {
		RygelMediaPlayer* _tmp2_;
		guint _tmp3_;
		guint _tmp4_;
		_tmp2_ = self->priv->player;
		_tmp3_ = rygel_rendering_control_get_volume (self);
		_tmp4_ = _tmp3_;
		rygel_media_player_set_volume (_tmp2_, rygel_volume_from_percentage (_tmp4_));
	}
	_tmp5_ = self->priv->changelog;
	_tmp6_ = rygel_rendering_control_get_volume (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strdup_printf ("%u", _tmp7_);
	_tmp9_ = _tmp8_;
	rygel_change_log_log_with_channel (_tmp5_, "Volume", _tmp9_, "Master");
	_g_free0 (_tmp9_);
	g_object_notify_by_pspec ((GObject *) self, rygel_rendering_control_properties[RYGEL_RENDERING_CONTROL_VOLUME_PROPERTY]);
}


static void
rygel_rendering_control_class_init (RygelRenderingControlClass * klass)
{
	rygel_rendering_control_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelRenderingControlPrivate));
	((GObjectClass *) klass)->constructed = (void (*) (GObject *)) rygel_rendering_control_real_constructed;
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_rendering_control_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_rendering_control_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_rendering_control_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_RENDERING_CONTROL_MUTE_PROPERTY, rygel_rendering_control_properties[RYGEL_RENDERING_CONTROL_MUTE_PROPERTY] = g_param_spec_boolean ("mute", "mute", "mute", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_RENDERING_CONTROL_VOLUME_PROPERTY, rygel_rendering_control_properties[RYGEL_RENDERING_CONTROL_VOLUME_PROPERTY] = g_param_spec_uint ("volume", "volume", "volume", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void
rygel_rendering_control_instance_init (RygelRenderingControl * self)
{
	gchar* _tmp0_;
	self->priv = RYGEL_RENDERING_CONTROL_GET_PRIVATE (self);
	self->priv->_mute = FALSE;
	self->priv->_volume = (guint) 0;
	_tmp0_ = g_strdup ("FactoryDefaults");
	self->priv->preset_name_list = _tmp0_;
}


static void
rygel_rendering_control_finalize (GObject * obj)
{
	RygelRenderingControl * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_RENDERING_CONTROL, RygelRenderingControl);
	_g_free0 (self->priv->preset_name_list);
	_g_object_unref0 (self->priv->changelog);
	_g_object_unref0 (self->priv->player);
	G_OBJECT_CLASS (rygel_rendering_control_parent_class)->finalize (obj);
}


GType
rygel_rendering_control_get_type (void)
{
	static volatile gsize rygel_rendering_control_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_rendering_control_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelRenderingControlClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_rendering_control_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelRenderingControl), 0, (GInstanceInitFunc) rygel_rendering_control_instance_init, NULL };
		GType rygel_rendering_control_type_id;
		rygel_rendering_control_type_id = g_type_register_static (gupnp_service_get_type (), "RygelRenderingControl", &g_define_type_info, 0);
		g_once_init_leave (&rygel_rendering_control_type_id__volatile, rygel_rendering_control_type_id);
	}
	return rygel_rendering_control_type_id__volatile;
}


static void
_vala_rygel_rendering_control_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec)
{
	RygelRenderingControl * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_RENDERING_CONTROL, RygelRenderingControl);
	switch (property_id) {
		case RYGEL_RENDERING_CONTROL_MUTE_PROPERTY:
		g_value_set_boolean (value, rygel_rendering_control_get_mute (self));
		break;
		case RYGEL_RENDERING_CONTROL_VOLUME_PROPERTY:
		g_value_set_uint (value, rygel_rendering_control_get_volume (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void
_vala_rygel_rendering_control_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec)
{
	RygelRenderingControl * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_RENDERING_CONTROL, RygelRenderingControl);
	switch (property_id) {
		case RYGEL_RENDERING_CONTROL_MUTE_PROPERTY:
		rygel_rendering_control_set_mute (self, g_value_get_boolean (value));
		break;
		case RYGEL_RENDERING_CONTROL_VOLUME_PROPERTY:
		rygel_rendering_control_set_volume (self, g_value_get_uint (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



