/* gdk-2.0.vapi generated by vapigen, do not modify. */

[CCode (gir_namespace = "Gdk", gir_version = "2.0")]
namespace Gdk {
	namespace Selection {
		[CCode (cheader_filename = "gdk/gdk.h")]
		public static void convert (Gdk.Window requestor, Gdk.Atom selection, Gdk.Atom target, uint32 time_);
		[CCode (cheader_filename = "gdk/gdk.h")]
		public static unowned Gdk.Window owner_get (Gdk.Atom selection);
		[CCode (cheader_filename = "gdk/gdk.h")]
		public static unowned Gdk.Window owner_get_for_display (Gdk.Display display, Gdk.Atom selection);
		[CCode (cheader_filename = "gdk/gdk.h")]
		public static bool owner_set (Gdk.Window owner, Gdk.Atom selection, uint32 time_, bool send_event);
		[CCode (cheader_filename = "gdk/gdk.h")]
		public static bool owner_set_for_display (Gdk.Display display, Gdk.Window owner, Gdk.Atom selection, uint32 time_, bool send_event);
		[CCode (cheader_filename = "gdk/gdk.h")]
		public static int property_get (Gdk.Window requestor, uchar[] data, out Gdk.Atom prop_type, int prop_format);
		[CCode (cheader_filename = "gdk/gdk.h")]
		public static void send_notify (Gdk.NativeWindow requestor, Gdk.Atom selection, Gdk.Atom target, Gdk.Atom property, uint32 time_);
		[CCode (cheader_filename = "gdk/gdk.h")]
		public static void send_notify_for_display (Gdk.Display display, Gdk.NativeWindow requestor, Gdk.Atom selection, Gdk.Atom target, Gdk.Atom property, uint32 time_);
	}
	[CCode (cheader_filename = "gdk/gdk.h")]
	public class AppLaunchContext : GLib.AppLaunchContext {
		[CCode (has_construct_function = false)]
		public AppLaunchContext ();
		public void set_desktop (int desktop);
		public void set_display (Gdk.Display display);
		public void set_icon (GLib.Icon icon);
		public void set_icon_name (string icon_name);
		public void set_screen (Gdk.Screen screen);
		public void set_timestamp (uint32 timestamp);
	}
	[CCode (cheader_filename = "gdk/gdk.h", ref_function = "g_object_ref", unref_function = "g_object_unref")]
	public class Bitmap {
		public weak GLib.Object parent_instance;
		[Deprecated (since = "2.22")]
		public static Gdk.Bitmap create_from_data (Gdk.Drawable drawable, string data, int width, int height);
	}
	[CCode (cheader_filename = "gdk/gdk.h")]
	public class Colormap : GLib.Object {
		public Gdk.Color colors;
		public int size;
		public weak Gdk.Visual visual;
		public void* windowing_data;
		[CCode (has_construct_function = false)]
		public Colormap (Gdk.Visual visual, bool allocate);
		public bool alloc_color (Gdk.Color color, bool writeable, bool best_match);
		public int alloc_colors (Gdk.Color[] colors, bool writeable, bool best_match, bool success);
		public void change (int ncolors);
		public void free_colors (Gdk.Color[] colors);
		public unowned Gdk.Screen get_screen ();
		public static unowned Gdk.Colormap get_system ();
		public unowned Gdk.Visual get_visual ();
		public void query_color (ulong pixel, out Gdk.Color _result);
	}
	[CCode (cheader_filename = "gdk/gdk.h", ref_function = "gdk_cursor_ref", unref_function = "gdk_cursor_unref")]
	[Compact]
	public class Cursor {
		public uint ref_count;
		public Gdk.CursorType type;
		[CCode (has_construct_function = false)]
		public Cursor (Gdk.CursorType cursor_type);
		[CCode (has_construct_function = false)]
		public Cursor.for_display (Gdk.Display display, Gdk.CursorType cursor_type);
		[CCode (has_construct_function = false)]
		public Cursor.from_name (Gdk.Display display, string name);
		[CCode (has_construct_function = false)]
		public Cursor.from_pixbuf (Gdk.Display display, Gdk.Pixbuf pixbuf, int x, int y);
		[CCode (has_construct_function = false)]
		public Cursor.from_pixmap (Gdk.Pixmap source, Gdk.Pixmap mask, Gdk.Color fg, Gdk.Color bg, int x, int y);
		public Gdk.CursorType get_cursor_type ();
		public unowned Gdk.Display get_display ();
		public unowned Gdk.Pixbuf get_image ();
	}
	[CCode (cheader_filename = "gdk/gdk.h")]
	public class Device : GLib.Object {
		[CCode (array_length = false)]
		public weak Gdk.DeviceAxis[] axes;
		public bool has_cursor;
		[CCode (array_length = false)]
		public weak Gdk.DeviceKey[] keys;
		public Gdk.InputMode mode;
		public weak string name;
		public int num_axes;
		public int num_keys;
		public Gdk.InputSource source;
		[CCode (has_construct_function = false)]
		protected Device ();
		public static void free_history (Gdk.TimeCoord[] events);
		public bool get_axis ([CCode (array_length = false)] double[] axes, Gdk.AxisUse use, out double value);
		public Gdk.AxisUse get_axis_use (uint index);
		public static unowned Gdk.Device get_core_pointer ();
		public bool get_has_cursor ();
		public bool get_history (Gdk.Window window, uint32 start, uint32 stop, out Gdk.TimeCoord[] events);
		public void get_key (uint index, out uint keyval, out Gdk.ModifierType modifiers);
		public Gdk.InputMode get_mode ();
		public int get_n_axes ();
		public unowned string get_name ();
		public Gdk.InputSource get_source ();
		public void get_state (Gdk.Window window, [CCode (array_length = false)] double[] axes, out Gdk.ModifierType mask);
		public void set_axis_use (uint index_, Gdk.AxisUse use);
		public void set_key (uint index_, uint keyval, Gdk.ModifierType modifiers);
		public bool set_mode (Gdk.InputMode mode);
		public void set_source (Gdk.InputSource source);
	}
	[CCode (cheader_filename = "gdk/gdk.h")]
	public class Display : GLib.Object {
		[CCode (array_length = false)]
		public weak uint32[] button_click_time;
		[CCode (array_length = false)]
		public weak int[] button_number;
		[CCode (array_length = false)]
		public weak Gdk.Window[] button_window;
		[CCode (array_length = false)]
		public weak int[] button_x;
		[CCode (array_length = false)]
		public weak int[] button_y;
		public weak Gdk.Device core_pointer;
		public uint double_click_distance;
		public uint double_click_time;
		public uint ignore_core_events;
		public weak Gdk.KeyboardGrabInfo keyboard_grab;
		public uint32 last_event_time;
		public weak GLib.List pointer_grabs;
		public weak Gdk.DisplayPointerHooks pointer_hooks;
		public weak Gdk.PointerWindowInfo pointer_info;
		public weak GLib.List queued_events;
		public weak GLib.List queued_tail;
		[CCode (has_construct_function = false)]
		protected Display ();
		public void add_client_message_filter (Gdk.Atom message_type, Gdk.FilterFunc func);
		public void beep ();
		public void close ();
		public void flush ();
		public unowned Gdk.Device get_core_pointer ();
		public static unowned Gdk.Display get_default ();
		public uint get_default_cursor_size ();
		public unowned Gdk.Window get_default_group ();
		public virtual unowned Gdk.Screen get_default_screen ();
		[NoWrapper]
		public virtual unowned string get_display_name ();
		public Gdk.Event get_event ();
		public void get_maximal_cursor_size (out uint width, out uint height);
		public virtual int get_n_screens ();
		public unowned string get_name ();
		public void get_pointer (out unowned Gdk.Screen screen, out int x, out int y, out Gdk.ModifierType mask);
		public virtual unowned Gdk.Screen get_screen (int screen_num);
		public unowned Gdk.Window get_window_at_pointer (int win_x, int win_y);
		public bool is_closed ();
		public void keyboard_ungrab (uint32 time_);
		public unowned GLib.List<Gdk.Device> list_devices ();
		public static unowned Gdk.Display open (string display_name);
		public static unowned Gdk.Display open_default_libgtk_only ();
		public Gdk.Event peek_event ();
		public bool pointer_is_grabbed ();
		public void pointer_ungrab (uint32 time_);
		public void put_event (Gdk.Event event);
		public bool request_selection_notification (Gdk.Atom selection);
		public void set_double_click_distance (uint distance);
		public void set_double_click_time (uint msec);
		public unowned Gdk.DisplayPointerHooks set_pointer_hooks (Gdk.DisplayPointerHooks new_hooks);
		public void store_clipboard (Gdk.Window clipboard_window, uint32 time_, Gdk.Atom[] targets);
		public bool supports_clipboard_persistence ();
		public bool supports_composite ();
		public bool supports_cursor_alpha ();
		public bool supports_cursor_color ();
		public bool supports_input_shapes ();
		public bool supports_selection_notification ();
		public bool supports_shapes ();
		public void sync ();
		public void warp_pointer (Gdk.Screen screen, int x, int y);
		public virtual signal void closed (bool is_error);
	}
	[CCode (cheader_filename = "gdk/gdk.h")]
	public class DisplayManager : GLib.Object {
		[CCode (has_construct_function = false)]
		protected DisplayManager ();
		public static unowned Gdk.DisplayManager @get ();
		public unowned Gdk.Display get_default_display ();
		public GLib.SList<weak Gdk.Display> list_displays ();
		public void set_default_display (Gdk.Display display);
		public Gdk.Display default_display { get; set; }
		public virtual signal void display_opened (Gdk.Display display);
	}
	[CCode (cheader_filename = "gdk/gdk.h")]
	[Compact]
	public class DisplayPointerHooks {
		public weak GLib.Callback get_pointer;
		public weak GLib.Callback window_at_pointer;
		public weak GLib.Callback window_get_pointer;
	}
	[CCode (cheader_filename = "gdk/gdk.h")]
	public class DragContext : GLib.Object {
		public Gdk.DragAction action;
		public Gdk.DragAction actions;
		public weak Gdk.Window dest_window;
		public bool is_source;
		public Gdk.DragProtocol protocol;
		public weak Gdk.Window source_window;
		public uint32 start_time;
		public Gdk.DragAction suggested_action;
		public weak GLib.List<Gdk.Atom> targets;
		public void* windowing_data;
		[CCode (has_construct_function = false)]
		public DragContext ();
		public Gdk.DragAction get_actions ();
		public Gdk.DragAction get_selected_action ();
		public unowned Gdk.Window get_source_window ();
		public Gdk.DragAction get_suggested_action ();
		public unowned GLib.List list_targets ();
	}
	[CCode (cheader_filename = "gdk/gdk.h")]
	public class Drawable : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Drawable ();
		[Deprecated (since = "2.22")]
		public unowned Gdk.Image copy_to_image (Gdk.Image image, int src_x, int src_y, int dest_x, int dest_y, int width, int height);
		[NoWrapper]
		public virtual unowned Cairo.Surface create_cairo_surface (int width, int height);
		[NoWrapper]
		public virtual unowned Gdk.GC create_gc (Gdk.GCValues values, Gdk.GCValuesMask mask);
		[CCode (cname = "gdk_draw_arc")]
		public virtual void draw_arc (Gdk.GC gc, bool filled, int x, int y, int width, int height, int angle1, int angle2);
		[CCode (cname = "gdk_draw_drawable")]
		public virtual void draw_drawable (Gdk.GC gc, Gdk.Drawable src, int xsrc, int ysrc, int xdest, int ydest, int width, int height);
		[CCode (cname = "gdk_draw_glyphs")]
		public virtual void draw_glyphs (Gdk.GC gc, Pango.Font font, int x, int y, Pango.GlyphString glyphs);
		[CCode (cname = "gdk_draw_glyphs_transformed")]
		public virtual void draw_glyphs_transformed (Gdk.GC gc, Pango.Matrix matrix, Pango.Font font, int x, int y, Pango.GlyphString glyphs);
		[CCode (cname = "gdk_draw_image")]
		public virtual void draw_image (Gdk.GC gc, Gdk.Image image, int xsrc, int ysrc, int xdest, int ydest, int width, int height);
		[CCode (cname = "gdk_draw_lines")]
		public virtual void draw_lines (Gdk.GC gc, Gdk.Point[] points);
		[CCode (cname = "gdk_draw_pixbuf")]
		public virtual void draw_pixbuf (Gdk.GC? gc, Gdk.Pixbuf pixbuf, int src_x, int src_y, int dest_x, int dest_y, int width, int height, Gdk.RgbDither dither, int x_dither, int y_dither);
		[CCode (cname = "gdk_draw_points")]
		public virtual void draw_points (Gdk.GC gc, Gdk.Point[] points);
		[CCode (cname = "gdk_draw_polygon")]
		public virtual void draw_polygon (Gdk.GC gc, bool filled, Gdk.Point[] points);
		[CCode (cname = "gdk_draw_rectangle")]
		public virtual void draw_rectangle (Gdk.GC gc, bool filled, int x, int y, int width, int height);
		[CCode (cname = "gdk_draw_segments")]
		public virtual void draw_segments (Gdk.GC gc, Gdk.Segment[] segs);
		[CCode (cname = "gdk_draw_text")]
		public virtual void draw_text (Gdk.Font font, Gdk.GC gc, int x, int y, string text, int text_length);
		[CCode (cname = "gdk_draw_text_wc")]
		public virtual void draw_text_wc (Gdk.Font font, Gdk.GC gc, int x, int y, Gdk.WChar text, int text_length);
		[CCode (cname = "gdk_draw_trapezoids")]
		public virtual void draw_trapezoids (Gdk.GC gc, Gdk.Trapezoid[] trapezoids);
		public virtual unowned Gdk.Region get_clip_region ();
		public virtual unowned Gdk.Colormap get_colormap ();
		[NoWrapper]
		public virtual unowned Gdk.Drawable get_composite_drawable (int x, int y, int width, int height, int composite_x_offset, int composite_y_offset);
		public virtual int get_depth ();
		public unowned Gdk.Display get_display ();
		public virtual unowned Gdk.Image get_image (int x, int y, int width, int height);
		public virtual unowned Gdk.Screen get_screen ();
		public virtual void get_size (out int width, out int height);
		[NoWrapper]
		public virtual unowned Gdk.Drawable get_source_drawable ();
		public virtual unowned Gdk.Region get_visible_region ();
		public virtual unowned Gdk.Visual get_visual ();
		[NoWrapper]
		public virtual unowned Cairo.Surface ref_cairo_surface ();
		[NoWrapper]
		public virtual void set_cairo_clip (Cairo.Context cr);
		public virtual void set_colormap (Gdk.Colormap colormap);
	}
	[CCode (cheader_filename = "gdk/gdk.h", copy_function = "gdk_event_copy")]
	[Compact]
	public class Event {
		public Gdk.EventAny any;
		public Gdk.EventButton button;
		public Gdk.EventClient client;
		public Gdk.EventConfigure configure;
		public Gdk.EventCrossing crossing;
		public Gdk.EventDND dnd;
		public Gdk.EventExpose expose;
		public Gdk.EventFocus focus_change;
		public Gdk.EventGrabBroken grab_broken;
		public Gdk.EventKey key;
		public Gdk.EventMotion motion;
		public Gdk.EventNoExpose no_expose;
		public Gdk.EventOwnerChange owner_change;
		public Gdk.EventProperty property;
		public Gdk.EventProximity proximity;
		public Gdk.EventScroll scroll;
		public Gdk.EventSelection selection;
		public Gdk.EventSetting setting;
		public Gdk.EventType type;
		public Gdk.EventVisibility visibility;
		public Gdk.EventWindowState window_state;
		[CCode (has_construct_function = false)]
		public Event (Gdk.EventType type);
		public Gdk.Event copy ();
		public static unowned Gdk.Event @get ();
		public bool get_axis (Gdk.AxisUse axis_use, out double value);
		public bool get_coords (out double x_win, out double y_win);
		public bool get_root_coords (out double x_root, out double y_root);
		public unowned Gdk.Screen get_screen ();
		public bool get_state (out Gdk.ModifierType state);
		public uint32 get_time ();
		public static void handler_set (owned Gdk.EventFunc func);
		public static unowned Gdk.Event peek ();
		public void put ();
		public static void request_motions (Gdk.EventMotion event);
		public bool send_client_message (Gdk.NativeWindow winid);
		public static bool send_client_message_for_display (Gdk.Display display, Gdk.Event event, Gdk.NativeWindow winid);
		public void send_clientmessage_toall ();
		public void set_screen (Gdk.Screen screen);
	}
	[CCode (cheader_filename = "gdk/gdk.h", ref_function = "gdk_font_ref", unref_function = "gdk_font_unref")]
	[Compact]
	public class Font {
		public int ascent;
		public int descent;
		public Gdk.FontType type;
		public bool equal (Gdk.Font fontb);
		public static unowned Gdk.Font from_description_for_display (Gdk.Display display, Pango.FontDescription font_desc);
		public int id ();
		public static unowned Gdk.Font load_for_display (Gdk.Display display, string font_name);
	}
	[CCode (cheader_filename = "gdk/gdk.h")]
	[Deprecated (since = "2.22")]
	public class GC : GLib.Object {
		public int clip_x_origin;
		public int clip_y_origin;
		public weak Gdk.Colormap colormap;
		public int ts_x_origin;
		public int ts_y_origin;
		[CCode (has_construct_function = false)]
		public GC (Gdk.Drawable drawable);
		public void copy (Gdk.GC src_gc);
		public unowned Gdk.Colormap get_colormap ();
		public unowned Gdk.Screen get_screen ();
		public virtual void get_values (out Gdk.GCValues values);
		public void offset (int x_offset, int y_offset);
		public void set_background (Gdk.Color color);
		public void set_clip_mask (Gdk.Bitmap mask);
		public void set_clip_origin (int x, int y);
		public void set_clip_rectangle (Gdk.Rectangle rectangle);
		public void set_clip_region (Gdk.Region region);
		public void set_colormap (Gdk.Colormap colormap);
		public virtual void set_dashes (int dash_offset, char[] dash_list, int n);
		public void set_exposures (bool exposures);
		public void set_fill (Gdk.Fill fill);
		public void set_foreground (Gdk.Color color);
		public void set_function (Gdk.Function function);
		public void set_line_attributes (int line_width, Gdk.LineStyle line_style, Gdk.CapStyle cap_style, Gdk.JoinStyle join_style);
		public void set_rgb_bg_color (Gdk.Color color);
		public void set_rgb_fg_color (Gdk.Color color);
		public void set_stipple (Gdk.Pixmap stipple);
		public void set_subwindow (Gdk.SubwindowMode mode);
		public void set_tile (Gdk.Pixmap tile);
		public void set_ts_origin (int x, int y);
		public virtual void set_values (Gdk.GCValues values, Gdk.GCValuesMask values_mask);
		[CCode (has_construct_function = false)]
		public GC.with_values (Gdk.Drawable drawable, Gdk.GCValues values, Gdk.GCValuesMask values_mask);
	}
	[CCode (cheader_filename = "gdk/gdk.h")]
	[Deprecated (since = "2.22")]
	public class Image : GLib.Object {
		public uint16 bits_per_pixel;
		public uint16 bpl;
		public uint16 bpp;
		public Gdk.ByteOrder byte_order;
		public weak Gdk.Colormap colormap;
		public uint16 depth;
		public int height;
		public void* mem;
		public Gdk.ImageType type;
		public weak Gdk.Visual visual;
		public int width;
		public void* windowing_data;
		[CCode (has_construct_function = false)]
		public Image (Gdk.ImageType type, Gdk.Visual visual, int width, int height);
		public uint16 get_bits_per_pixel ();
		public Gdk.ByteOrder get_byte_order ();
		public uint16 get_bytes_per_line ();
		public uint16 get_bytes_per_pixel ();
		public unowned Gdk.Colormap get_colormap ();
		public uint16 get_depth ();
		public int get_height ();
		public Gdk.ImageType get_image_type ();
		public uint32 get_pixel (int x, int y);
		public unowned Gdk.Visual get_visual ();
		public int get_width ();
		public void put_pixel (int x, int y, uint32 pixel);
		public void set_colormap (Gdk.Colormap colormap);
	}
	[CCode (cheader_filename = "gdk/gdk.h")]
	[Compact]
	public class KeyboardGrabInfo {
		public weak Gdk.Window native_window;
		public bool owner_events;
		public ulong serial;
		public uint32 time;
		public weak Gdk.Window window;
		public static bool libgtk_only (Gdk.Display display, out unowned Gdk.Window grab_window, bool owner_events);
	}
	[CCode (cheader_filename = "gdk/gdk.h")]
	public class Keymap : GLib.Object {
		public weak Gdk.Display display;
		[CCode (has_construct_function = false)]
		protected Keymap ();
		public void add_virtual_modifiers (Gdk.ModifierType state);
		public bool get_caps_lock_state ();
		public static unowned Gdk.Keymap get_default ();
		public Pango.Direction get_direction ();
		public bool get_entries_for_keycode (uint hardware_keycode, [CCode (array_length = false)] out Gdk.KeymapKey[] keys, [CCode (array_length = false)] out uint[] keyvals, out int n_entries);
		public bool get_entries_for_keyval (uint keyval, out unowned Gdk.KeymapKey[] keys);
		public static unowned Gdk.Keymap get_for_display (Gdk.Display display);
		public bool have_bidi_layouts ();
		public uint lookup_key (Gdk.KeymapKey key);
		public bool map_virtual_modifiers (Gdk.ModifierType state);
		public bool translate_keyboard_state (uint hardware_keycode, Gdk.ModifierType state, int group, uint keyval, int effective_group, int level, Gdk.ModifierType consumed_modifiers);
		public virtual signal void direction_changed ();
		public virtual signal void keys_changed ();
		public virtual signal void state_changed ();
	}
	[CCode (cheader_filename = "gdk/gdk.h")]
	public class PangoRenderer : Pango.Renderer {
		[CCode (has_construct_function = false, type = "PangoRenderer*")]
		public PangoRenderer (Gdk.Screen screen);
		public static unowned Pango.Renderer get_default (Gdk.Screen screen);
		public void set_drawable (Gdk.Drawable drawable);
		public void set_gc (Gdk.GC gc);
		public void set_override_color (Pango.RenderPart part, Gdk.Color color);
		public void set_stipple (Pango.RenderPart part, Gdk.Bitmap stipple);
		[NoAccessorMethod]
		public Gdk.Screen screen { owned get; construct; }
	}
	[CCode (cheader_filename = "gdk/gdk.h")]
	public class Pixmap : Gdk.Drawable {
		[CCode (has_construct_function = false)]
		public Pixmap (Gdk.Drawable? drawable, int width, int height, int depth);
		[Deprecated (since = "2.22")]
		public static unowned Gdk.Pixmap colormap_create_from_xpm (Gdk.Drawable drawable, Gdk.Colormap colormap, out unowned Gdk.Bitmap mask, Gdk.Color transparent_color, string filename);
		[Deprecated (since = "2.22")]
		public static unowned Gdk.Pixmap colormap_create_from_xpm_d (Gdk.Drawable drawable, Gdk.Colormap colormap, out unowned Gdk.Bitmap mask, Gdk.Color transparent_color, string data);
		[Deprecated (since = "2.22")]
		public static unowned Gdk.Pixmap create_from_data (Gdk.Drawable drawable, string data, int width, int height, int depth, Gdk.Color fg, Gdk.Color bg);
		[Deprecated (since = "2.22")]
		public static unowned Gdk.Pixmap create_from_xpm (Gdk.Drawable drawable, out unowned Gdk.Bitmap mask, Gdk.Color transparent_color, string filename);
		[Deprecated (since = "2.22")]
		public static unowned Gdk.Pixmap create_from_xpm_d (Gdk.Drawable drawable, out unowned Gdk.Bitmap mask, Gdk.Color transparent_color, string data);
		public static unowned Gdk.Pixmap foreign_new (Gdk.NativeWindow anid);
		public static unowned Gdk.Pixmap foreign_new_for_display (Gdk.Display display, Gdk.NativeWindow anid);
		public static unowned Gdk.Pixmap foreign_new_for_screen (Gdk.Screen screen, Gdk.NativeWindow anid, int width, int height, int depth);
		public static unowned Gdk.Pixmap lookup (Gdk.NativeWindow anid);
		public static unowned Gdk.Pixmap lookup_for_display (Gdk.Display display, Gdk.NativeWindow anid);
	}
	[CCode (cheader_filename = "gdk/gdk.h")]
	[Compact]
	public class PointerHooks {
		public weak GLib.Callback get_pointer;
		public weak GLib.Callback window_at_pointer;
	}
	[CCode (cheader_filename = "gdk/gdk.h")]
	[Compact]
	public class PointerWindowInfo {
		public uint32 button;
		public ulong motion_hint_serial;
		public uint32 state;
		public weak Gdk.Window toplevel_under_pointer;
		public double toplevel_x;
		public double toplevel_y;
		public weak Gdk.Window window_under_pointer;
	}
	[CCode (cheader_filename = "gdk/gdk.h", copy_function = "gdk_region_copy", free_function = "gdk_region_destroy")]
	[Compact]
	public class Region {
		[CCode (has_construct_function = false)]
		public Region ();
		public Gdk.Region copy ();
		public bool empty ();
		public bool equal (Gdk.Region region2);
		public void get_clipbox (out Gdk.Rectangle rectangle);
		public void get_rectangles (out Gdk.Rectangle[] rectangles);
		public void intersect (Gdk.Region source2);
		public void offset (int dx, int dy);
		public bool point_in (int x, int y);
		public static Gdk.Region polygon (Gdk.Point[] points, Gdk.FillRule fill_rule);
		public bool rect_equal (Gdk.Rectangle rectangle);
		public Gdk.OverlapType rect_in (Gdk.Rectangle rectangle);
		public static Gdk.Region rectangle (Gdk.Rectangle rectangle);
		public void shrink (int dx, int dy);
		public void spans_intersect_foreach (Gdk.Span[] spans, bool sorted, Gdk.SpanFunc function, void* data);
		public void subtract (Gdk.Region source2);
		public void union (Gdk.Region source2);
		public void union_with_rect (Gdk.Rectangle rect);
		public void xor (Gdk.Region source2);
	}
	[CCode (cheader_filename = "gdk/gdk.h")]
	public class Screen : GLib.Object {
		public uint closed;
		[CCode (array_length = false)]
		public weak Gdk.GC[] exposure_gcs;
		[CCode (array_length = false)]
		public weak Gdk.GC[] normal_gcs;
		[CCode (array_length = false)]
		public weak Gdk.GC[] subwindow_gcs;
		[CCode (has_construct_function = false)]
		protected Screen ();
		public void broadcast_client_message (Gdk.Event event);
		public unowned Gdk.Window get_active_window ();
		public static unowned Gdk.Screen get_default ();
		public unowned Gdk.Colormap get_default_colormap ();
		public unowned Gdk.Display get_display ();
		public unowned Cairo.FontOptions get_font_options ();
		public int get_height ();
		public int get_height_mm ();
		public int get_monitor_at_point (int x, int y);
		public int get_monitor_at_window (Gdk.Window window);
		public void get_monitor_geometry (int monitor_num, out Gdk.Rectangle dest);
		public int get_monitor_height_mm (int monitor_num);
		public unowned string get_monitor_plug_name (int monitor_num);
		public int get_monitor_width_mm (int monitor_num);
		public int get_n_monitors ();
		public int get_number ();
		public int get_primary_monitor ();
		public double get_resolution ();
		public unowned Gdk.Colormap get_rgb_colormap ();
		public unowned Gdk.Visual get_rgb_visual ();
		public unowned Gdk.Colormap get_rgba_colormap ();
		public unowned Gdk.Visual get_rgba_visual ();
		public unowned Gdk.Window get_root_window ();
		public bool get_setting (string name, GLib.Value value);
		public unowned Gdk.Colormap get_system_colormap ();
		public unowned Gdk.Visual get_system_visual ();
		public GLib.List<weak Gdk.Window> get_toplevel_windows ();
		public int get_width ();
		public int get_width_mm ();
		public GLib.List<Gdk.Window>? get_window_stack ();
		public static int height ();
		public static int height_mm ();
		public bool is_composited ();
		public GLib.List<weak Gdk.Visual> list_visuals ();
		public unowned string make_display_name ();
		public void set_default_colormap (Gdk.Colormap colormap);
		public void set_font_options (Cairo.FontOptions options);
		public void set_resolution (double dpi);
		public static int width ();
		public static int width_mm ();
		public void* font_options { get; set; }
		public double resolution { get; set; }
		public virtual signal void composited_changed ();
		public virtual signal void monitors_changed ();
		public virtual signal void size_changed ();
	}
	[CCode (cheader_filename = "gdk/gdk.h")]
	public class Visual : GLib.Object {
		public int bits_per_rgb;
		public uint32 blue_mask;
		public int blue_prec;
		public int blue_shift;
		public Gdk.ByteOrder byte_order;
		public int colormap_size;
		public int depth;
		public uint32 green_mask;
		public int green_prec;
		public int green_shift;
		public uint32 red_mask;
		public int red_prec;
		public int red_shift;
		public Gdk.VisualType type;
		[CCode (has_construct_function = false)]
		protected Visual ();
		public static unowned Gdk.Visual get_best ();
		public static int get_best_depth ();
		public static Gdk.VisualType get_best_type ();
		public static unowned Gdk.Visual get_best_with_both (int depth, Gdk.VisualType visual_type);
		public static unowned Gdk.Visual get_best_with_depth (int depth);
		public static unowned Gdk.Visual get_best_with_type (Gdk.VisualType visual_type);
		public int get_bits_per_rgb ();
		public void get_blue_pixel_details (uint32 mask, int shift, int precision);
		public Gdk.ByteOrder get_byte_order ();
		public int get_colormap_size ();
		public int get_depth ();
		public void get_green_pixel_details (uint32 mask, int shift, int precision);
		public void get_red_pixel_details (uint32 mask, int shift, int precision);
		public unowned Gdk.Screen get_screen ();
		public static unowned Gdk.Visual get_system ();
		public Gdk.VisualType get_visual_type ();
	}
	[CCode (cheader_filename = "gdk/gdk.h")]
	public class Window : Gdk.Drawable {
		[CCode (has_construct_function = false)]
		public Window (Gdk.Window? parent, Gdk.WindowAttr attributes, int attributes_mask);
		public void add_filter (Gdk.FilterFunc function);
		public static unowned Gdk.Window at_pointer (out int win_x, out int win_y);
		public void beep ();
		public void begin_move_drag (int button, int root_x, int root_y, uint32 timestamp);
		public void begin_paint_rect (Gdk.Rectangle rectangle);
		public void begin_paint_region (Gdk.Region region);
		public void begin_resize_drag (Gdk.WindowEdge edge, int button, int root_x, int root_y, uint32 timestamp);
		public void clear ();
		public void clear_area (int x, int y, int width, int height);
		public void clear_area_e (int x, int y, int width, int height);
		public void configure_finished ();
		public static void constrain_size (Gdk.Geometry geometry, uint flags, int width, int height, out int new_width, out int new_height);
		public void coords_from_parent (double parent_x, double parent_y, double x, double y);
		public void coords_to_parent (double x, double y, double parent_x, double parent_y);
		public Cairo.Surface create_similar_surface (Cairo.Content content, int width, int height);
		public void deiconify ();
		public void destroy ();
		public void enable_synchronized_configure ();
		public void end_paint ();
		public bool ensure_native ();
		public void flush ();
		public void focus (uint32 timestamp);
		public static unowned Gdk.Window foreign_new (Gdk.NativeWindow anid);
		public static unowned Gdk.Window foreign_new_for_display (Gdk.Display display, Gdk.NativeWindow anid);
		public void freeze_toplevel_updates_libgtk_only ();
		public void freeze_updates ();
		public void fullscreen ();
		public void geometry_changed ();
		public bool get_accept_focus ();
		public unowned Cairo.Pattern get_background_pattern ();
		public GLib.List<weak Gdk.Window> get_children ();
		public bool get_composited ();
		public unowned Gdk.Cursor? get_cursor ();
		public bool get_decorations (out Gdk.WMDecoration decorations);
		public bool get_deskrelative_origin (out int x, out int y);
		public unowned Gdk.Window get_effective_parent ();
		public unowned Gdk.Window get_effective_toplevel ();
		public Gdk.EventMask get_events ();
		public bool get_focus_on_map ();
		public void get_frame_extents (out Gdk.Rectangle rect);
		public void get_geometry (out int x, out int y, out int width, out int height, out int depth);
		public unowned Gdk.Window get_group ();
		public void get_internal_paint_info (out unowned Gdk.Drawable real_drawable, out int x_offset, out int y_offset);
		public bool get_modal_hint ();
		public int get_origin (out int x, out int y);
		public unowned Gdk.Window get_parent ();
		public unowned Gdk.Window get_pointer (out int x, out int y, out Gdk.ModifierType mask);
		public void get_position (out int x, out int y);
		public void get_root_coords (int x, int y, out int root_x, out int root_y);
		public void get_root_origin (out int x, out int y);
		public Gdk.WindowState get_state ();
		public unowned Gdk.Window get_toplevel ();
		public Gdk.WindowTypeHint get_type_hint ();
		public unowned Gdk.Region get_update_area ();
		public void get_user_data (void* data);
		public Gdk.WindowType get_window_type ();
		public bool has_native ();
		public void hide ();
		public void iconify ();
		public void input_shape_combine_mask (Gdk.Bitmap? mask, int x, int y);
		public void input_shape_combine_region (Gdk.Region shape_region, int offset_x, int offset_y);
		public void invalidate_maybe_recurse (Gdk.Region region, GLib.Callback child_func);
		public void invalidate_rect (Gdk.Rectangle? rect, bool invalidate_children);
		public void invalidate_region (Gdk.Region region, bool invalidate_children);
		public bool is_destroyed ();
		public bool is_input_only ();
		public bool is_shaped ();
		public bool is_viewable ();
		public bool is_visible ();
		public static unowned Gdk.Window lookup (Gdk.NativeWindow anid);
		public static unowned Gdk.Window lookup_for_display (Gdk.Display display, Gdk.NativeWindow anid);
		public void lower ();
		public void maximize ();
		public void merge_child_input_shapes ();
		public void merge_child_shapes ();
		public void move (int x, int y);
		public void move_region (Gdk.Region region, int dx, int dy);
		public void move_resize (int x, int y, int width, int height);
		public unowned GLib.List<Gdk.Window> peek_children ();
		public static void process_all_updates ();
		public void process_updates (bool update_children);
		public void raise ();
		public void register_dnd ();
		public void remove_filter (Gdk.FilterFunc function);
		public void remove_redirection ();
		public void reparent (Gdk.Window new_parent, int x, int y);
		public void resize (int width, int height);
		public void restack (Gdk.Window sibling, bool above);
		public void scroll (int dx, int dy);
		public void set_accept_focus (bool accept_focus);
		public void set_back_pixmap (Gdk.Pixmap? pixmap, bool parent_relative);
		public void set_background (Gdk.Color color);
		public void set_child_input_shapes ();
		public void set_child_shapes ();
		public void set_composited (bool composited);
		public void set_cursor (Gdk.Cursor? cursor);
		public static void set_debug_updates (bool setting);
		public void set_decorations (Gdk.WMDecoration decorations);
		public void set_events (Gdk.EventMask event_mask);
		public void set_focus_on_map (bool focus_on_map);
		public void set_functions (Gdk.WMFunction functions);
		public void set_geometry_hints (Gdk.Geometry geometry, Gdk.WindowHints geom_mask);
		public void set_group (Gdk.Window leader);
		public void set_icon (Gdk.Window icon_window, Gdk.Pixmap pixmap, Gdk.Bitmap mask);
		public void set_icon_list (GLib.List<Gdk.Pixbuf> pixbufs);
		public void set_icon_name (string name);
		public void set_keep_above (bool setting);
		public void set_keep_below (bool setting);
		public void set_modal_hint (bool modal);
		public void set_opacity (double opacity);
		public void set_override_redirect (bool override_redirect);
		public void set_role (string role);
		public void set_skip_pager_hint (bool skips_pager);
		public void set_skip_taskbar_hint (bool skips_taskbar);
		public void set_startup_id (string startup_id);
		public bool set_static_gravities (bool use_static);
		public void set_title (string title);
		public void set_transient_for (Gdk.Window parent);
		public void set_type_hint (Gdk.WindowTypeHint hint);
		public void set_urgency_hint (bool urgent);
		public void set_user_data (void* user_data);
		public void shape_combine_mask (Gdk.Bitmap mask, int x, int y);
		public void shape_combine_region (Gdk.Region shape_region, int offset_x, int offset_y);
		public void show ();
		public void show_unraised ();
		public void stick ();
		public void thaw_toplevel_updates_libgtk_only ();
		public void thaw_updates ();
		public void unfullscreen ();
		public void unmaximize ();
		public void unstick ();
		public void withdraw ();
		public Gdk.Cursor cursor { get; set; }
		public virtual signal void from_embedder (double p0, double p1, void* p2, void* p3);
		public virtual signal unowned Gdk.Window pick_embedded_child (double p0, double p1);
		public virtual signal void to_embedder (double p0, double p1, void* p2, void* p3);
	}
	[CCode (cheader_filename = "gdk/gdk.h")]
	[SimpleType]
	public struct Atom {
		[CCode (cname = "GDK_NONE")]
		public static Gdk.Atom NONE;
		public static Gdk.Atom intern (string atom_name, bool only_if_exists);
		public static Gdk.Atom intern_static_string (string atom_name);
		public string name ();
	}
	[CCode (cheader_filename = "gdk/gdk.h")]
	public struct Color {
		public uint32 pixel;
		public uint16 red;
		public uint16 green;
		public uint16 blue;
		public Gdk.Color copy ();
		public bool equal (Gdk.Color colorb);
		public void free ();
		public uint hash ();
		public static bool parse (string spec, out Gdk.Color color);
		public string to_string ();
	}
	[CCode (cheader_filename = "gdk/gdk.h")]
	public struct DeviceAxis {
		public Gdk.AxisUse use;
		public double min;
		public double max;
	}
	[CCode (cheader_filename = "gdk/gdk.h")]
	public struct DeviceKey {
		public uint keyval;
		public Gdk.ModifierType modifiers;
	}
	[CCode (cheader_filename = "gdk/gdk.h", has_type_id = false)]
	public struct EventAny {
		public Gdk.EventType type;
		public weak Gdk.Window window;
		public char send_event;
	}
	[CCode (cheader_filename = "gdk/gdk.h", has_type_id = false)]
	public struct EventButton {
		public Gdk.EventType type;
		public weak Gdk.Window window;
		public char send_event;
		public uint32 time;
		public double x;
		public double y;
		[CCode (array_length = false)]
		public weak double[] axes;
		public Gdk.ModifierType state;
		public uint button;
		public weak Gdk.Device device;
		public double x_root;
		public double y_root;
	}
	[CCode (cheader_filename = "gdk/gdk.h", has_type_id = false)]
	public struct EventClient {
		public Gdk.EventType type;
		public weak Gdk.Window window;
		public char send_event;
		public Gdk.Atom message_type;
		public ushort data_format;
		public void* data;
	}
	[CCode (cheader_filename = "gdk/gdk.h", has_type_id = false)]
	public struct EventConfigure {
		public Gdk.EventType type;
		public weak Gdk.Window window;
		public char send_event;
		public int x;
		public int y;
		public int width;
		public int height;
	}
	[CCode (cheader_filename = "gdk/gdk.h", has_type_id = false)]
	public struct EventCrossing {
		public Gdk.EventType type;
		public weak Gdk.Window window;
		public char send_event;
		public weak Gdk.Window subwindow;
		public uint32 time;
		public double x;
		public double y;
		public double x_root;
		public double y_root;
		public Gdk.CrossingMode mode;
		public Gdk.NotifyType detail;
		public bool focus;
		public Gdk.ModifierType state;
	}
	[CCode (cheader_filename = "gdk/gdk.h", has_type_id = false)]
	public struct EventDND {
		public Gdk.EventType type;
		public weak Gdk.Window window;
		public char send_event;
		public weak Gdk.DragContext context;
		public uint32 time;
		public short x_root;
		public short y_root;
	}
	[CCode (cheader_filename = "gdk/gdk.h", has_type_id = false)]
	public struct EventExpose {
		public Gdk.EventType type;
		public weak Gdk.Window window;
		public char send_event;
		public Gdk.Rectangle area;
		public weak Gdk.Region region;
		public int count;
	}
	[CCode (cheader_filename = "gdk/gdk.h", has_type_id = false)]
	public struct EventFocus {
		public Gdk.EventType type;
		public weak Gdk.Window window;
		public char send_event;
		public int16 @in;
	}
	[CCode (cheader_filename = "gdk/gdk.h", has_type_id = false)]
	public struct EventGrabBroken {
		public Gdk.EventType type;
		public weak Gdk.Window window;
		public char send_event;
		public bool keyboard;
		public bool implicit;
		public weak Gdk.Window grab_window;
	}
	[CCode (cheader_filename = "gdk/gdk.h", has_type_id = false)]
	public struct EventKey {
		public Gdk.EventType type;
		public weak Gdk.Window window;
		public char send_event;
		public uint32 time;
		public Gdk.ModifierType state;
		public uint keyval;
		public int length;
		[CCode (cname = "string")]
		public weak string str;
		public uint16 hardware_keycode;
		public uchar group;
		public uint is_modifier;
	}
	[CCode (cheader_filename = "gdk/gdk.h", has_type_id = false)]
	public struct EventMotion {
		public Gdk.EventType type;
		public weak Gdk.Window window;
		public char send_event;
		public uint32 time;
		public double x;
		public double y;
		[CCode (array_length = false)]
		public weak double[] axes;
		public Gdk.ModifierType state;
		public bool is_hint;
		public weak Gdk.Device device;
		public double x_root;
		public double y_root;
	}
	[CCode (cheader_filename = "gdk/gdk.h", has_type_id = false)]
	public struct EventNoExpose {
		public Gdk.EventType type;
		public weak Gdk.Window window;
		public char send_event;
	}
	[CCode (cheader_filename = "gdk/gdk.h", has_type_id = false)]
	public struct EventOwnerChange {
		public Gdk.EventType type;
		public weak Gdk.Window window;
		public char send_event;
		public Gdk.NativeWindow owner;
		public Gdk.OwnerChange reason;
		public Gdk.Atom selection;
		public uint32 time;
		public uint32 selection_time;
	}
	[CCode (cheader_filename = "gdk/gdk.h", has_type_id = false)]
	public struct EventProperty {
		public Gdk.EventType type;
		public weak Gdk.Window window;
		public char send_event;
		public Gdk.Atom atom;
		public uint32 time;
		public Gdk.PropertyState state;
	}
	[CCode (cheader_filename = "gdk/gdk.h", has_type_id = false)]
	public struct EventProximity {
		public Gdk.EventType type;
		public weak Gdk.Window window;
		public char send_event;
		public uint32 time;
		public weak Gdk.Device device;
	}
	[CCode (cheader_filename = "gdk/gdk.h", has_type_id = false)]
	public struct EventScroll {
		public Gdk.EventType type;
		public weak Gdk.Window window;
		public char send_event;
		public uint32 time;
		public double x;
		public double y;
		public Gdk.ModifierType state;
		public Gdk.ScrollDirection direction;
		public weak Gdk.Device device;
		public double x_root;
		public double y_root;
	}
	[CCode (cheader_filename = "gdk/gdk.h", has_type_id = false)]
	public struct EventSelection {
		public Gdk.EventType type;
		public weak Gdk.Window window;
		public char send_event;
		public Gdk.Atom selection;
		public Gdk.Atom target;
		public Gdk.Atom property;
		public uint32 time;
		public Gdk.NativeWindow requestor;
	}
	[CCode (cheader_filename = "gdk/gdk.h", has_type_id = false)]
	public struct EventSetting {
		public Gdk.EventType type;
		public weak Gdk.Window window;
		public char send_event;
		public Gdk.SettingAction action;
		public weak string name;
	}
	[CCode (cheader_filename = "gdk/gdk.h", has_type_id = false)]
	public struct EventVisibility {
		public Gdk.EventType type;
		public weak Gdk.Window window;
		public char send_event;
		public Gdk.VisibilityState state;
	}
	[CCode (cheader_filename = "gdk/gdk.h", has_type_id = false)]
	public struct EventWindowState {
		public Gdk.EventType type;
		public weak Gdk.Window window;
		public char send_event;
		public Gdk.WindowState changed_mask;
		public Gdk.WindowState new_window_state;
	}
	[CCode (cheader_filename = "gdk/gdk.h")]
	public struct GCValues {
		public Gdk.Color foreground;
		public Gdk.Color background;
		public weak Gdk.Font font;
		public Gdk.Function function;
		public Gdk.Fill fill;
		public weak Gdk.Pixmap tile;
		public weak Gdk.Pixmap stipple;
		public weak Gdk.Pixmap clip_mask;
		public Gdk.SubwindowMode subwindow_mode;
		public int ts_x_origin;
		public int ts_y_origin;
		public int clip_x_origin;
		public int clip_y_origin;
		public int graphics_exposures;
		public int line_width;
		public Gdk.LineStyle line_style;
		public Gdk.CapStyle cap_style;
		public Gdk.JoinStyle join_style;
	}
	[CCode (cheader_filename = "gdk/gdk.h")]
	public struct Geometry {
		public int min_width;
		public int min_height;
		public int max_width;
		public int max_height;
		public int base_width;
		public int base_height;
		public int width_inc;
		public int height_inc;
		public double min_aspect;
		public double max_aspect;
		public Gdk.Gravity win_gravity;
	}
	[CCode (cheader_filename = "gdk/gdk.h")]
	public struct KeymapKey {
		public uint keycode;
		public int group;
		public int level;
	}
	[CCode (cheader_filename = "gdk/gdk.h")]
	[SimpleType]
	public struct NativeWindow {
	}
	[CCode (cheader_filename = "gdk/gdk.h")]
	public struct PangoAttrEmbossColor {
		public weak Pango.Attribute attr;
		public Pango.Color color;
		[CCode (has_construct_function = false)]
		public PangoAttrEmbossColor (Gdk.Color color);
	}
	[CCode (cheader_filename = "gdk/gdk.h")]
	public struct PangoAttrEmbossed {
		public weak Pango.Attribute attr;
		public bool embossed;
		[CCode (has_construct_function = false)]
		public PangoAttrEmbossed (bool embossed);
	}
	[CCode (cheader_filename = "gdk/gdk.h")]
	public struct PangoAttrStipple {
		public weak Pango.Attribute attr;
		public weak Gdk.Bitmap stipple;
		[CCode (has_construct_function = false)]
		public PangoAttrStipple (Gdk.Bitmap stipple);
	}
	[CCode (cheader_filename = "gdk/gdk.h")]
	public struct Point {
		public int x;
		public int y;
	}
	[CCode (cheader_filename = "gdk/gdk.h")]
	public struct Rectangle {
		public int x;
		public int y;
		public int width;
		public int height;
		public bool intersect (Gdk.Rectangle src2, out Gdk.Rectangle dest);
		public void union (Gdk.Rectangle src2, out Gdk.Rectangle dest);
	}
	[CCode (cheader_filename = "gdk/gdk.h")]
	[Deprecated (since = "2.22")]
	public struct RgbCmap {
		[CCode (array_length = false)]
		public weak uint32[] colors;
		public int n_colors;
		public weak GLib.SList info_list;
		[CCode (has_construct_function = false)]
		[Deprecated (since = "2.22")]
		public RgbCmap (uint32[] colors);
		[Deprecated (since = "2.22")]
		public void free ();
	}
	[CCode (cheader_filename = "gdk/gdk.h")]
	public struct Segment {
		public int x1;
		public int y1;
		public int x2;
		public int y2;
	}
	[CCode (cheader_filename = "gdk/gdk.h")]
	public struct Span {
		public int x;
		public int y;
		public int width;
	}
	[CCode (cheader_filename = "gdk/gdk.h")]
	public struct TimeCoord {
		public uint32 time;
		[CCode (array_length = false)]
		public weak double[] axes;
	}
	[CCode (cheader_filename = "gdk/gdk.h")]
	public struct Trapezoid {
		public double y1;
		public double x11;
		public double x21;
		public double y2;
		public double x12;
		public double x22;
	}
	[CCode (cheader_filename = "gdk/gdk.h")]
	public struct WChar {
	}
	[CCode (cheader_filename = "gdk/gdk.h")]
	public struct WindowAttr {
		public weak string title;
		public int event_mask;
		public int x;
		public int y;
		public int width;
		public int height;
		public Gdk.WindowClass wclass;
		public weak Gdk.Visual visual;
		public weak Gdk.Colormap colormap;
		public Gdk.WindowType window_type;
		public weak Gdk.Cursor cursor;
		public weak string wmclass_name;
		public weak string wmclass_class;
		public bool override_redirect;
		public Gdk.WindowTypeHint type_hint;
	}
	[CCode (cheader_filename = "gdk/gdk.h")]
	public struct WindowRedirect {
		public static void to_drawable (Gdk.Window window, Gdk.Drawable drawable, int src_x, int src_y, int dest_x, int dest_y, int width, int height);
	}
	[CCode (cheader_filename = "gdk/gdk.h")]
	public struct XEvent {
	}
	[CCode (cheader_filename = "gdk/gdk.h", cprefix = "GDK_AXIS_")]
	public enum AxisUse {
		IGNORE,
		X,
		Y,
		PRESSURE,
		XTILT,
		YTILT,
		WHEEL,
		LAST
	}
	[CCode (cheader_filename = "gdk/gdk.h", cprefix = "GDK_")]
	public enum ByteOrder {
		LSB_FIRST,
		MSB_FIRST
	}
	[CCode (cheader_filename = "gdk/gdk.h", cprefix = "GDK_CAP_")]
	public enum CapStyle {
		NOT_LAST,
		BUTT,
		ROUND,
		PROJECTING
	}
	[CCode (cheader_filename = "gdk/gdk.h", cprefix = "GDK_CROSSING_")]
	public enum CrossingMode {
		NORMAL,
		GRAB,
		UNGRAB,
		GTK_GRAB,
		GTK_UNGRAB,
		STATE_CHANGED
	}
	[CCode (cheader_filename = "gdk/gdk.h", cprefix = "GDK_")]
	public enum CursorType {
		X_CURSOR,
		ARROW,
		BASED_ARROW_DOWN,
		BASED_ARROW_UP,
		BOAT,
		BOGOSITY,
		BOTTOM_LEFT_CORNER,
		BOTTOM_RIGHT_CORNER,
		BOTTOM_SIDE,
		BOTTOM_TEE,
		BOX_SPIRAL,
		CENTER_PTR,
		CIRCLE,
		CLOCK,
		COFFEE_MUG,
		CROSS,
		CROSS_REVERSE,
		CROSSHAIR,
		DIAMOND_CROSS,
		DOT,
		DOTBOX,
		DOUBLE_ARROW,
		DRAFT_LARGE,
		DRAFT_SMALL,
		DRAPED_BOX,
		EXCHANGE,
		FLEUR,
		GOBBLER,
		GUMBY,
		HAND1,
		HAND2,
		HEART,
		ICON,
		IRON_CROSS,
		LEFT_PTR,
		LEFT_SIDE,
		LEFT_TEE,
		LEFTBUTTON,
		LL_ANGLE,
		LR_ANGLE,
		MAN,
		MIDDLEBUTTON,
		MOUSE,
		PENCIL,
		PIRATE,
		PLUS,
		QUESTION_ARROW,
		RIGHT_PTR,
		RIGHT_SIDE,
		RIGHT_TEE,
		RIGHTBUTTON,
		RTL_LOGO,
		SAILBOAT,
		SB_DOWN_ARROW,
		SB_H_DOUBLE_ARROW,
		SB_LEFT_ARROW,
		SB_RIGHT_ARROW,
		SB_UP_ARROW,
		SB_V_DOUBLE_ARROW,
		SHUTTLE,
		SIZING,
		SPIDER,
		SPRAYCAN,
		STAR,
		TARGET,
		TCROSS,
		TOP_LEFT_ARROW,
		TOP_LEFT_CORNER,
		TOP_RIGHT_CORNER,
		TOP_SIDE,
		TOP_TEE,
		TREK,
		UL_ANGLE,
		UMBRELLA,
		UR_ANGLE,
		WATCH,
		XTERM,
		LAST_CURSOR,
		BLANK_CURSOR,
		CURSOR_IS_PIXMAP
	}
	[CCode (cheader_filename = "gdk/gdk.h", cprefix = "GDK_ACTION_")]
	[Flags]
	public enum DragAction {
		DEFAULT,
		COPY,
		MOVE,
		LINK,
		PRIVATE,
		ASK
	}
	[CCode (cheader_filename = "gdk/gdk.h", cprefix = "GDK_DRAG_PROTO_")]
	public enum DragProtocol {
		MOTIF,
		XDND,
		ROOTWIN,
		NONE,
		WIN32_DROPFILES,
		OLE2,
		LOCAL
	}
	[CCode (cheader_filename = "gdk/gdk.h", cprefix = "GDK_")]
	[Flags]
	public enum EventMask {
		EXPOSURE_MASK,
		POINTER_MOTION_MASK,
		POINTER_MOTION_HINT_MASK,
		BUTTON_MOTION_MASK,
		BUTTON1_MOTION_MASK,
		BUTTON2_MOTION_MASK,
		BUTTON3_MOTION_MASK,
		BUTTON_PRESS_MASK,
		BUTTON_RELEASE_MASK,
		KEY_PRESS_MASK,
		KEY_RELEASE_MASK,
		ENTER_NOTIFY_MASK,
		LEAVE_NOTIFY_MASK,
		FOCUS_CHANGE_MASK,
		STRUCTURE_MASK,
		PROPERTY_CHANGE_MASK,
		VISIBILITY_NOTIFY_MASK,
		PROXIMITY_IN_MASK,
		PROXIMITY_OUT_MASK,
		SUBSTRUCTURE_MASK,
		SCROLL_MASK,
		ALL_EVENTS_MASK
	}
	[CCode (cheader_filename = "gdk/gdk.h", cprefix = "GDK_")]
	public enum EventType {
		NOTHING,
		DELETE,
		DESTROY,
		EXPOSE,
		MOTION_NOTIFY,
		BUTTON_PRESS,
		@2BUTTON_PRESS,
		@3BUTTON_PRESS,
		BUTTON_RELEASE,
		KEY_PRESS,
		KEY_RELEASE,
		ENTER_NOTIFY,
		LEAVE_NOTIFY,
		FOCUS_CHANGE,
		CONFIGURE,
		MAP,
		UNMAP,
		PROPERTY_NOTIFY,
		SELECTION_CLEAR,
		SELECTION_REQUEST,
		SELECTION_NOTIFY,
		PROXIMITY_IN,
		PROXIMITY_OUT,
		DRAG_ENTER,
		DRAG_LEAVE,
		DRAG_MOTION,
		DRAG_STATUS,
		DROP_START,
		DROP_FINISHED,
		CLIENT_EVENT,
		VISIBILITY_NOTIFY,
		NO_EXPOSE,
		SCROLL,
		WINDOW_STATE,
		SETTING,
		OWNER_CHANGE,
		GRAB_BROKEN,
		DAMAGE,
		EVENT_LAST
	}
	[CCode (cheader_filename = "gdk/gdk.h", cprefix = "GDK_EXTENSION_EVENTS_")]
	public enum ExtensionMode {
		NONE,
		ALL,
		CURSOR
	}
	[CCode (cheader_filename = "gdk/gdk.h", cprefix = "GDK_")]
	public enum Fill {
		SOLID,
		TILED,
		STIPPLED,
		OPAQUE_STIPPLED
	}
	[CCode (cheader_filename = "gdk/gdk.h", cprefix = "GDK_")]
	public enum FillRule {
		EVEN_ODD_RULE,
		WINDING_RULE
	}
	[CCode (cheader_filename = "gdk/gdk.h", cprefix = "GDK_FILTER_")]
	public enum FilterReturn {
		CONTINUE,
		TRANSLATE,
		REMOVE
	}
	[CCode (cheader_filename = "gdk/gdk.h", cprefix = "GDK_FONT_")]
	public enum FontType {
		FONT,
		FONTSET
	}
	[CCode (cheader_filename = "gdk/gdk.h", cprefix = "GDK_")]
	public enum Function {
		COPY,
		INVERT,
		XOR,
		CLEAR,
		AND,
		AND_REVERSE,
		AND_INVERT,
		NOOP,
		OR,
		EQUIV,
		OR_REVERSE,
		COPY_INVERT,
		OR_INVERT,
		NAND,
		NOR,
		SET
	}
	[CCode (cheader_filename = "gdk/gdk.h", cprefix = "GDK_GC_")]
	[Flags]
	public enum GCValuesMask {
		FOREGROUND,
		BACKGROUND,
		FONT,
		FUNCTION,
		FILL,
		TILE,
		STIPPLE,
		CLIP_MASK,
		SUBWINDOW,
		TS_X_ORIGIN,
		TS_Y_ORIGIN,
		CLIP_X_ORIGIN,
		CLIP_Y_ORIGIN,
		EXPOSURES,
		LINE_WIDTH,
		LINE_STYLE,
		CAP_STYLE,
		JOIN_STYLE
	}
	[CCode (cheader_filename = "gdk/gdk.h", cprefix = "GDK_GRAB_")]
	public enum GrabStatus {
		SUCCESS,
		ALREADY_GRABBED,
		INVALID_TIME,
		NOT_VIEWABLE,
		FROZEN
	}
	[CCode (cheader_filename = "gdk/gdk.h", cprefix = "GDK_GRAVITY_")]
	public enum Gravity {
		NORTH_WEST,
		NORTH,
		NORTH_EAST,
		WEST,
		CENTER,
		EAST,
		SOUTH_WEST,
		SOUTH,
		SOUTH_EAST,
		STATIC
	}
	[CCode (cheader_filename = "gdk/gdk.h", cprefix = "GDK_IMAGE_")]
	public enum ImageType {
		NORMAL,
		SHARED,
		FASTEST
	}
	[CCode (cheader_filename = "gdk/gdk.h", cprefix = "GDK_INPUT_")]
	[Flags]
	public enum InputCondition {
		READ,
		WRITE,
		EXCEPTION
	}
	[CCode (cheader_filename = "gdk/gdk.h", cprefix = "GDK_MODE_")]
	public enum InputMode {
		DISABLED,
		SCREEN,
		WINDOW
	}
	[CCode (cheader_filename = "gdk/gdk.h", cprefix = "GDK_SOURCE_")]
	public enum InputSource {
		MOUSE,
		PEN,
		ERASER,
		CURSOR
	}
	[CCode (cheader_filename = "gdk/gdk.h", cprefix = "GDK_JOIN_")]
	public enum JoinStyle {
		MITER,
		ROUND,
		BEVEL
	}
	[CCode (cheader_filename = "gdk/gdk.h", cprefix = "GDK_LINE_")]
	public enum LineStyle {
		SOLID,
		ON_OFF_DASH,
		DOUBLE_DASH
	}
	[CCode (cheader_filename = "gdk/gdk.h", cprefix = "GDK_")]
	[Flags]
	public enum ModifierType {
		SHIFT_MASK,
		LOCK_MASK,
		CONTROL_MASK,
		MOD1_MASK,
		MOD2_MASK,
		MOD3_MASK,
		MOD4_MASK,
		MOD5_MASK,
		BUTTON1_MASK,
		BUTTON2_MASK,
		BUTTON3_MASK,
		BUTTON4_MASK,
		BUTTON5_MASK,
		SUPER_MASK,
		HYPER_MASK,
		META_MASK,
		RELEASE_MASK,
		MODIFIER_MASK
	}
	[CCode (cheader_filename = "gdk/gdk.h", cprefix = "GDK_NOTIFY_")]
	public enum NotifyType {
		ANCESTOR,
		VIRTUAL,
		INFERIOR,
		NONLINEAR,
		NONLINEAR_VIRTUAL,
		UNKNOWN
	}
	[CCode (cheader_filename = "gdk/gdk.h", cprefix = "GDK_OVERLAP_RECTANGLE_")]
	public enum OverlapType {
		IN,
		OUT,
		PART
	}
	[CCode (cheader_filename = "gdk/gdk.h", cprefix = "GDK_OWNER_CHANGE_")]
	public enum OwnerChange {
		NEW_OWNER,
		DESTROY,
		CLOSE
	}
	[CCode (cheader_filename = "gdk/gdk.h", cprefix = "GDK_PROP_MODE_")]
	public enum PropMode {
		REPLACE,
		PREPEND,
		APPEND
	}
	[CCode (cheader_filename = "gdk/gdk.h", cprefix = "GDK_PROPERTY_")]
	public enum PropertyState {
		NEW_VALUE,
		DELETE
	}
	[CCode (cheader_filename = "gdk/gdk.h", cprefix = "GDK_RGB_DITHER_")]
	public enum RgbDither {
		NONE,
		NORMAL,
		MAX
	}
	[CCode (cheader_filename = "gdk/gdk.h", cprefix = "GDK_SCROLL_")]
	public enum ScrollDirection {
		UP,
		DOWN,
		LEFT,
		RIGHT
	}
	[CCode (cheader_filename = "gdk/gdk.h", cprefix = "GDK_SETTING_ACTION_")]
	public enum SettingAction {
		NEW,
		CHANGED,
		DELETED
	}
	[CCode (cheader_filename = "gdk/gdk.h", cprefix = "GDK_")]
	public enum Status {
		OK,
		ERROR,
		ERROR_PARAM,
		ERROR_FILE,
		ERROR_MEM
	}
	[CCode (cheader_filename = "gdk/gdk.h", cprefix = "GDK_")]
	public enum SubwindowMode {
		CLIP_BY_CHILDREN,
		INCLUDE_INFERIORS
	}
	[CCode (cheader_filename = "gdk/gdk.h", cprefix = "GDK_VISIBILITY_")]
	public enum VisibilityState {
		UNOBSCURED,
		PARTIAL,
		FULLY_OBSCURED
	}
	[CCode (cheader_filename = "gdk/gdk.h", cprefix = "GDK_VISUAL_")]
	public enum VisualType {
		STATIC_GRAY,
		GRAYSCALE,
		STATIC_COLOR,
		PSEUDO_COLOR,
		TRUE_COLOR,
		DIRECT_COLOR
	}
	[CCode (cheader_filename = "gdk/gdk.h", cprefix = "GDK_DECOR_")]
	[Flags]
	public enum WMDecoration {
		ALL,
		BORDER,
		RESIZEH,
		TITLE,
		MENU,
		MINIMIZE,
		MAXIMIZE
	}
	[CCode (cheader_filename = "gdk/gdk.h", cprefix = "GDK_FUNC_")]
	[Flags]
	public enum WMFunction {
		ALL,
		RESIZE,
		MOVE,
		MINIMIZE,
		MAXIMIZE,
		CLOSE
	}
	[CCode (cheader_filename = "gdk/gdk.h", cprefix = "GDK_WA_")]
	[Flags]
	public enum WindowAttributesType {
		TITLE,
		X,
		Y,
		CURSOR,
		COLORMAP,
		VISUAL,
		WMCLASS,
		NOREDIR,
		TYPE_HINT
	}
	[CCode (cheader_filename = "gdk/gdk.h", cprefix = "GDK_")]
	public enum WindowClass {
		INPUT_OUTPUT,
		INPUT_ONLY
	}
	[CCode (cheader_filename = "gdk/gdk.h", cprefix = "GDK_WINDOW_EDGE_")]
	public enum WindowEdge {
		NORTH_WEST,
		NORTH,
		NORTH_EAST,
		WEST,
		EAST,
		SOUTH_WEST,
		SOUTH,
		SOUTH_EAST
	}
	[CCode (cheader_filename = "gdk/gdk.h", cprefix = "GDK_HINT_")]
	[Flags]
	public enum WindowHints {
		POS,
		MIN_SIZE,
		MAX_SIZE,
		BASE_SIZE,
		ASPECT,
		RESIZE_INC,
		WIN_GRAVITY,
		USER_POS,
		USER_SIZE
	}
	[CCode (cheader_filename = "gdk/gdk.h", cprefix = "GDK_WINDOW_STATE_")]
	[Flags]
	public enum WindowState {
		WITHDRAWN,
		ICONIFIED,
		MAXIMIZED,
		STICKY,
		FULLSCREEN,
		ABOVE,
		BELOW
	}
	[CCode (cheader_filename = "gdk/gdk.h", cprefix = "GDK_WINDOW_")]
	public enum WindowType {
		ROOT,
		TOPLEVEL,
		CHILD,
		DIALOG,
		TEMP,
		FOREIGN,
		OFFSCREEN
	}
	[CCode (cheader_filename = "gdk/gdk.h", cprefix = "GDK_WINDOW_TYPE_HINT_")]
	public enum WindowTypeHint {
		NORMAL,
		DIALOG,
		MENU,
		TOOLBAR,
		SPLASHSCREEN,
		UTILITY,
		DOCK,
		DESKTOP,
		DROPDOWN_MENU,
		POPUP_MENU,
		TOOLTIP,
		NOTIFICATION,
		COMBO,
		DND
	}
	[CCode (cheader_filename = "gdk/gdk.h")]
	public delegate void EventFunc (Gdk.Event event);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public delegate Gdk.FilterReturn FilterFunc (Gdk.XEvent xevent, Gdk.Event event);
	[CCode (cheader_filename = "gdk/gdk.h", has_target = false)]
	public delegate void InputFunction (void* data, int source, Gdk.InputCondition condition);
	[CCode (cheader_filename = "gdk/gdk.h")]
	[Deprecated (since = "2.22")]
	public delegate void SpanFunc (Gdk.Span span);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public const int CURRENT_TIME;
	[CCode (cheader_filename = "gdk/gdk.h")]
	public const int MAX_TIMECOORD_AXES;
	[CCode (cheader_filename = "gdk/gdk.h")]
	public const int PARENT_RELATIVE;
	[CCode (cheader_filename = "gdk/gdk.h")]
	public const int PRIORITY_REDRAW;
	[CCode (cheader_filename = "gdk/gdk.h")]
	public const Gdk.Atom SELECTION_CLIPBOARD;
	[CCode (cheader_filename = "gdk/gdk.h")]
	public const Gdk.Atom SELECTION_PRIMARY;
	[CCode (cheader_filename = "gdk/gdk.h")]
	public const Gdk.Atom SELECTION_SECONDARY;
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static void add_client_message_filter (Gdk.Atom message_type, Gdk.FilterFunc func);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static void add_option_entries_libgtk_only (GLib.OptionGroup group);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static void beep ();
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static Cairo.Context cairo_create (Gdk.Drawable drawable);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static void cairo_rectangle (Cairo.Context cr, Gdk.Rectangle rectangle);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static void cairo_region (Cairo.Context cr, Gdk.Region region);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static void cairo_reset_clip (Cairo.Context cr, Gdk.Drawable drawable);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static void cairo_set_source_color (Cairo.Context cr, Gdk.Color color);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static void cairo_set_source_pixbuf (Cairo.Context cr, Gdk.Pixbuf pixbuf, double pixbuf_x, double pixbuf_y);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static void cairo_set_source_pixmap (Cairo.Context cr, Gdk.Pixmap pixmap, double pixmap_x, double pixmap_y);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static int colors_alloc (Gdk.Colormap colormap, bool contiguous, ulong planes, int nplanes, ulong pixels, int npixels);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static void colors_free (Gdk.Colormap colormap, ulong pixels, int npixels, ulong planes);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static unowned GLib.List<Gdk.Device> devices_list ();
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static void drag_abort (Gdk.DragContext context, uint32 time_);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static unowned Gdk.DragContext drag_begin (Gdk.Window window, GLib.List<Gdk.Atom> targets);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static void drag_drop (Gdk.DragContext context, uint32 time_);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static bool drag_drop_succeeded (Gdk.DragContext context);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static void drag_find_window (Gdk.DragContext context, Gdk.Window drag_window, int x_root, int y_root, out unowned Gdk.Window dest_window, Gdk.DragProtocol protocol);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static void drag_find_window_for_screen (Gdk.DragContext context, Gdk.Window drag_window, Gdk.Screen screen, int x_root, int y_root, out unowned Gdk.Window dest_window, Gdk.DragProtocol protocol);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static Gdk.NativeWindow drag_get_protocol (Gdk.NativeWindow xid, Gdk.DragProtocol protocol);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static Gdk.NativeWindow drag_get_protocol_for_display (Gdk.Display display, Gdk.NativeWindow xid, Gdk.DragProtocol protocol);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static Gdk.Atom drag_get_selection (Gdk.DragContext context);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static bool drag_motion (Gdk.DragContext context, Gdk.Window dest_window, Gdk.DragProtocol protocol, int x_root, int y_root, Gdk.DragAction suggested_action, Gdk.DragAction possible_actions, uint32 time_);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static void drag_status (Gdk.DragContext context, Gdk.DragAction action, uint32 time_);
	[CCode (cheader_filename = "gdk/gdk.h")]
	[Deprecated (since = "2.22")]
	public static void draw_arc (Gdk.Drawable drawable, Gdk.GC gc, bool filled, int x, int y, int width, int height, int angle1, int angle2);
	[CCode (cheader_filename = "gdk/gdk.h")]
	[Deprecated (since = "2.22")]
	public static void draw_drawable (Gdk.Drawable drawable, Gdk.GC gc, Gdk.Drawable src, int xsrc, int ysrc, int xdest, int ydest, int width, int height);
	[CCode (cheader_filename = "gdk/gdk.h")]
	[Deprecated (since = "2.22")]
	public static void draw_glyphs (Gdk.Drawable drawable, Gdk.GC gc, Pango.Font font, int x, int y, Pango.GlyphString glyphs);
	[CCode (cheader_filename = "gdk/gdk.h")]
	[Deprecated (since = "2.22")]
	public static void draw_glyphs_transformed (Gdk.Drawable drawable, Gdk.GC gc, Pango.Matrix matrix, Pango.Font font, int x, int y, Pango.GlyphString glyphs);
	[CCode (cheader_filename = "gdk/gdk.h")]
	[Deprecated (since = "2.22")]
	public static void draw_gray_image (Gdk.Drawable drawable, Gdk.GC gc, int x, int y, int width, int height, Gdk.RgbDither dith, [CCode (array_length = false)] uchar[] buf, int rowstride);
	[CCode (cheader_filename = "gdk/gdk.h")]
	[Deprecated (since = "2.22")]
	public static void draw_image (Gdk.Drawable drawable, Gdk.GC gc, Gdk.Image image, int xsrc, int ysrc, int xdest, int ydest, int width, int height);
	[CCode (cheader_filename = "gdk/gdk.h")]
	[Deprecated (since = "2.22")]
	public static void draw_indexed_image (Gdk.Drawable drawable, Gdk.GC gc, int x, int y, int width, int height, Gdk.RgbDither dith, [CCode (array_length = false)] uchar[] buf, int rowstride, Gdk.RgbCmap cmap);
	[CCode (cheader_filename = "gdk/gdk.h")]
	[Deprecated (since = "2.22")]
	public static void draw_layout (Gdk.Drawable drawable, Gdk.GC gc, int x, int y, Pango.Layout layout);
	[CCode (cheader_filename = "gdk/gdk.h")]
	[Deprecated (since = "2.22")]
	public static void draw_layout_line (Gdk.Drawable drawable, Gdk.GC gc, int x, int y, Pango.LayoutLine line);
	[CCode (cheader_filename = "gdk/gdk.h")]
	[Deprecated (since = "2.22")]
	public static void draw_layout_line_with_colors (Gdk.Drawable drawable, Gdk.GC gc, int x, int y, Pango.LayoutLine line, Gdk.Color foreground, Gdk.Color background);
	[CCode (cheader_filename = "gdk/gdk.h")]
	[Deprecated (since = "2.22")]
	public static void draw_layout_with_colors (Gdk.Drawable drawable, Gdk.GC gc, int x, int y, Pango.Layout layout, Gdk.Color foreground, Gdk.Color background);
	[CCode (cheader_filename = "gdk/gdk.h")]
	[Deprecated (since = "2.22")]
	public static void draw_line (Gdk.Drawable drawable, Gdk.GC gc, int x1_, int y1_, int x2_, int y2_);
	[CCode (cheader_filename = "gdk/gdk.h")]
	[Deprecated (since = "2.22")]
	public static void draw_lines (Gdk.Drawable drawable, Gdk.GC gc, Gdk.Point[] points);
	[CCode (cheader_filename = "gdk/gdk.h")]
	[Deprecated (since = "2.22")]
	public static void draw_pixbuf (Gdk.Drawable drawable, Gdk.GC gc, Gdk.Pixbuf pixbuf, int src_x, int src_y, int dest_x, int dest_y, int width, int height, Gdk.RgbDither dither, int x_dither, int y_dither);
	[CCode (cheader_filename = "gdk/gdk.h")]
	[Deprecated (since = "2.22")]
	public static void draw_point (Gdk.Drawable drawable, Gdk.GC gc, int x, int y);
	[CCode (cheader_filename = "gdk/gdk.h")]
	[Deprecated (since = "2.22")]
	public static void draw_points (Gdk.Drawable drawable, Gdk.GC gc, Gdk.Point[] points);
	[CCode (cheader_filename = "gdk/gdk.h")]
	[Deprecated (since = "2.22")]
	public static void draw_polygon (Gdk.Drawable drawable, Gdk.GC gc, bool filled, Gdk.Point[] points);
	[CCode (cheader_filename = "gdk/gdk.h")]
	[Deprecated (since = "2.22")]
	public static void draw_rectangle (Gdk.Drawable drawable, Gdk.GC gc, bool filled, int x, int y, int width, int height);
	[CCode (cheader_filename = "gdk/gdk.h")]
	[Deprecated (since = "2.22")]
	public static void draw_rgb_32_image (Gdk.Drawable drawable, Gdk.GC gc, int x, int y, int width, int height, Gdk.RgbDither dith, [CCode (array_length = false)] uchar[] buf, int rowstride);
	[CCode (cheader_filename = "gdk/gdk.h")]
	[Deprecated (since = "2.22")]
	public static void draw_rgb_32_image_dithalign (Gdk.Drawable drawable, Gdk.GC gc, int x, int y, int width, int height, Gdk.RgbDither dith, [CCode (array_length = false)] uchar[] buf, int rowstride, int xdith, int ydith);
	[CCode (cheader_filename = "gdk/gdk.h")]
	[Deprecated (since = "2.22")]
	public static void draw_rgb_image (Gdk.Drawable drawable, Gdk.GC gc, int x, int y, int width, int height, Gdk.RgbDither dith, [CCode (array_length = false)] uchar[] rgb_buf, int rowstride);
	[CCode (cheader_filename = "gdk/gdk.h")]
	[Deprecated (since = "2.22")]
	public static void draw_rgb_image_dithalign (Gdk.Drawable drawable, Gdk.GC gc, int x, int y, int width, int height, Gdk.RgbDither dith, [CCode (array_length = false)] uchar[] rgb_buf, int rowstride, int xdith, int ydith);
	[CCode (cheader_filename = "gdk/gdk.h")]
	[Deprecated (since = "2.22")]
	public static void draw_segments (Gdk.Drawable drawable, Gdk.GC gc, Gdk.Segment[] segs);
	[CCode (cheader_filename = "gdk/gdk.h")]
	[Deprecated (since = "2.22")]
	public static void draw_text (Gdk.Drawable drawable, Gdk.Font font, Gdk.GC gc, int x, int y, string text, int text_length);
	[CCode (cheader_filename = "gdk/gdk.h")]
	[Deprecated (since = "2.22")]
	public static void draw_text_wc (Gdk.Drawable drawable, Gdk.Font font, Gdk.GC gc, int x, int y, Gdk.WChar text, int text_length);
	[CCode (cheader_filename = "gdk/gdk.h")]
	[Deprecated (since = "2.22")]
	public static void draw_trapezoids (Gdk.Drawable drawable, Gdk.GC gc, Gdk.Trapezoid[] trapezoids);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static void drop_finish (Gdk.DragContext context, bool success, uint32 time_);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static void drop_reply (Gdk.DragContext context, bool ok, uint32 time_);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static int error_trap_pop ();
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static void error_trap_push ();
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static bool events_pending ();
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static void flush ();
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static unowned Gdk.Font fontset_load_for_display (Gdk.Display display, string fontset_name);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static void free_compound_text (uchar[] ctext);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static void free_text_list (string list);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static unowned Gdk.Window get_default_root_window ();
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static unowned string get_display ();
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static unowned string get_display_arg_name ();
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static unowned string get_program_class ();
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static bool get_show_events ();
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static void init ([CCode (array_length_pos = 0.9)] ref unowned string[] argv);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static bool init_check ([CCode (array_length_pos = 0.9)] ref unowned string[] argv);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static void input_set_extension_events (Gdk.Window window, int mask, Gdk.ExtensionMode mode);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static Gdk.GrabStatus keyboard_grab (Gdk.Window window, bool owner_events, uint32 time_);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static void keyboard_ungrab (uint32 time_);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static void keyval_convert_case (uint symbol, uint lower, uint upper);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static uint keyval_from_name (string keyval_name);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static bool keyval_is_lower (uint keyval);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static bool keyval_is_upper (uint keyval);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static unowned string keyval_name (uint keyval);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static uint keyval_to_lower (uint keyval);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static uint32 keyval_to_unicode (uint keyval);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static uint keyval_to_upper (uint keyval);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static GLib.List<weak Gdk.Visual> list_visuals ();
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static void notify_startup_complete ();
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static void notify_startup_complete_with_id (string startup_id);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static unowned Gdk.Window? offscreen_window_get_embedder (Gdk.Window window);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static unowned Gdk.Pixmap? offscreen_window_get_pixmap (Gdk.Window window);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static void offscreen_window_set_embedder (Gdk.Window window, Gdk.Window embedder);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static unowned Pango.Context pango_context_get ();
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static unowned Pango.Context pango_context_get_for_screen (Gdk.Screen screen);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static unowned Gdk.Region pango_layout_get_clip_region (Pango.Layout layout, int x_origin, int y_origin, int index_ranges, int n_ranges);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static unowned Gdk.Region pango_layout_line_get_clip_region (Pango.LayoutLine line, int x_origin, int y_origin, int index_ranges, int n_ranges);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static void parse_args (int argc, string argv);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static unowned Gdk.Pixbuf pixbuf_get_from_drawable (Gdk.Pixbuf? dest, Gdk.Drawable src, Gdk.Colormap? cmap, int src_x, int src_y, int dest_x, int dest_y, int width, int height);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static unowned Gdk.Pixbuf pixbuf_get_from_image (Gdk.Pixbuf? dest, Gdk.Image src, Gdk.Colormap? cmap, int src_x, int src_y, int dest_x, int dest_y, int width, int height);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static void pixbuf_render_pixmap_and_mask (Gdk.Pixbuf pixbuf, out unowned Gdk.Pixmap pixmap_return, out unowned Gdk.Bitmap mask_return, int alpha_threshold);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static void pixbuf_render_pixmap_and_mask_for_colormap (Gdk.Pixbuf pixbuf, Gdk.Colormap colormap, out unowned Gdk.Pixmap pixmap_return, out unowned Gdk.Bitmap mask_return, int alpha_threshold);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static void pixbuf_render_threshold_alpha (Gdk.Pixbuf pixbuf, Gdk.Bitmap bitmap, int src_x, int src_y, int dest_x, int dest_y, int width, int height, int alpha_threshold);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static Gdk.GrabStatus pointer_grab (Gdk.Window window, bool owner_events, Gdk.EventMask event_mask, Gdk.Window? confine_to, Gdk.Cursor? cursor, uint32 time_);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static bool pointer_grab_info_libgtk_only (Gdk.Display display, out unowned Gdk.Window grab_window, bool owner_events);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static bool pointer_is_grabbed ();
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static void pointer_ungrab (uint32 time_);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static void pre_parse_libgtk_only ();
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static void property_change (Gdk.Window window, Gdk.Atom property, Gdk.Atom type, int format, Gdk.PropMode mode, [CCode (array_length = false)] uchar[] data, int nelements);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static void property_delete (Gdk.Window window, Gdk.Atom property);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static bool property_get (Gdk.Window window, Gdk.Atom property, Gdk.Atom type, ulong offset, ulong length, int pdelete, out Gdk.Atom actual_property_type, out int actual_format, [CCode (array_length_pos = 8.9)] out uchar[] data);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static void query_depths (int depths, int count);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static void query_visual_types (out Gdk.VisualType visual_types, int count);
	[CCode (cheader_filename = "gdk/gdk.h")]
	[Deprecated (since = "2.22")]
	public static bool rgb_colormap_ditherable (Gdk.Colormap cmap);
	[CCode (cheader_filename = "gdk/gdk.h")]
	[Deprecated (since = "2.22")]
	public static bool rgb_ditherable ();
	[CCode (cheader_filename = "gdk/gdk.h")]
	[Deprecated (since = "2.22")]
	public static void rgb_find_color (Gdk.Colormap colormap, ref Gdk.Color color);
	[CCode (cheader_filename = "gdk/gdk.h")]
	[Deprecated (since = "2.22")]
	public static unowned Gdk.Colormap rgb_get_colormap ();
	[CCode (cheader_filename = "gdk/gdk.h")]
	[Deprecated (since = "2.22")]
	public static unowned Gdk.Visual rgb_get_visual ();
	[CCode (cheader_filename = "gdk/gdk.h")]
	[Deprecated (since = "2.22")]
	public static void rgb_set_install (bool install);
	[CCode (cheader_filename = "gdk/gdk.h")]
	[Deprecated (since = "2.22")]
	public static void rgb_set_min_colors (int min_colors);
	[CCode (cheader_filename = "gdk/gdk.h")]
	[Deprecated (since = "2.22")]
	public static void rgb_set_verbose (bool verbose);
	[CCode (cheader_filename = "gdk/gdk.h")]
	[Deprecated (replacement = "Selection.convert", since = "vala-0.12")]
	public static void selection_convert (Gdk.Window requestor, Gdk.Atom selection, Gdk.Atom target, uint32 time_);
	[CCode (cheader_filename = "gdk/gdk.h")]
	[Deprecated (replacement = "Selection.owner_get", since = "vala-0.12")]
	public static unowned Gdk.Window selection_owner_get (Gdk.Atom selection);
	[CCode (cheader_filename = "gdk/gdk.h")]
	[Deprecated (replacement = "Selection.owner_get_for_display", since = "vala-0.12")]
	public static unowned Gdk.Window selection_owner_get_for_display (Gdk.Display display, Gdk.Atom selection);
	[CCode (cheader_filename = "gdk/gdk.h")]
	[Deprecated (replacement = "Selection.owner_set", since = "vala-0.12")]
	public static bool selection_owner_set (Gdk.Window owner, Gdk.Atom selection, uint32 time_, bool send_event);
	[CCode (cheader_filename = "gdk/gdk.h")]
	[Deprecated (replacement = "Selection.owner_set_for_display", since = "vala-0.12")]
	public static bool selection_owner_set_for_display (Gdk.Display display, Gdk.Window owner, Gdk.Atom selection, uint32 time_, bool send_event);
	[CCode (cheader_filename = "gdk/gdk.h")]
	[Deprecated (replacement = "Selection.property_get", since = "vala-0.12")]
	public static int selection_property_get (Gdk.Window requestor, uchar[] data, out Gdk.Atom prop_type, int prop_format);
	[CCode (cheader_filename = "gdk/gdk.h")]
	[Deprecated (replacement = "Selection.send_notify", since = "vala-0.12")]
	public static void selection_send_notify (Gdk.NativeWindow requestor, Gdk.Atom selection, Gdk.Atom target, Gdk.Atom property, uint32 time_);
	[CCode (cheader_filename = "gdk/gdk.h")]
	[Deprecated (replacement = "Selection.send_notify_for_display", since = "vala-0.12")]
	public static void selection_send_notify_for_display (Gdk.Display display, Gdk.NativeWindow requestor, Gdk.Atom selection, Gdk.Atom target, Gdk.Atom property, uint32 time_);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static void set_double_click_time (uint msec);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static unowned string set_locale ();
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static unowned Gdk.PointerHooks set_pointer_hooks (Gdk.PointerHooks new_hooks);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static void set_program_class (string program_class);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static void set_show_events (bool show_events);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static void set_sm_client_id (string sm_client_id);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static bool setting_get (string name, GLib.Value value);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static bool spawn_command_line_on_screen (Gdk.Screen screen, string command_line) throws GLib.Error;
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static bool spawn_on_screen (Gdk.Screen screen, string? working_directory, [CCode (array_length = false)] string[] argv, [CCode (array_length = false)] string[]? envp, GLib.SpawnFlags flags, GLib.SpawnChildSetupFunc? child_setup, out int child_pid) throws GLib.Error;
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static bool spawn_on_screen_with_pipes (Gdk.Screen screen, string? working_directory, [CCode (array_length = false)] string[] argv, [CCode (array_length = false)] string[] envp, GLib.SpawnFlags flags, GLib.SpawnChildSetupFunc? child_setup, out int child_pid, out int standard_input, out int standard_output, out int standard_error) throws GLib.Error;
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static int string_to_compound_text (string str, out Gdk.Atom encoding, int format, uchar[] ctext, int length);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static int string_to_compound_text_for_display (Gdk.Display display, string str, out Gdk.Atom encoding, int format, uchar[] ctext, int length);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static void test_render_sync (Gdk.Window window);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static bool test_simulate_button (Gdk.Window window, int x, int y, uint button, Gdk.ModifierType modifiers, Gdk.EventType button_pressrelease);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static bool test_simulate_key (Gdk.Window window, int x, int y, uint keyval, Gdk.ModifierType modifiers, Gdk.EventType key_pressrelease);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static int text_property_to_text_list (Gdk.Atom encoding, int format, uchar[] text, int length, string list);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static int text_property_to_text_list_for_display (Gdk.Display display, Gdk.Atom encoding, int format, uchar[] text, int length, string list);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static int text_property_to_utf8_list (Gdk.Atom encoding, int format, uchar[] text, int length, string list);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static int text_property_to_utf8_list_for_display (Gdk.Display display, Gdk.Atom encoding, int format, uchar[] text, int length, string list);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static uint threads_add_idle (GLib.SourceFunc function);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static uint threads_add_idle_full (int priority, owned GLib.SourceFunc function);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static uint threads_add_timeout (uint interval, GLib.SourceFunc function);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static uint threads_add_timeout_full (int priority, uint interval, owned GLib.SourceFunc function);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static uint threads_add_timeout_seconds (uint interval, GLib.SourceFunc function);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static uint threads_add_timeout_seconds_full (int priority, uint interval, owned GLib.SourceFunc function);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static void threads_enter ();
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static void threads_init ();
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static void threads_leave ();
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static void threads_set_lock_functions (GLib.Callback enter_fn, GLib.Callback leave_fn);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static uint unicode_to_keyval (uint32 wc);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static bool utf8_to_compound_text (string str, out Gdk.Atom encoding, int format, uchar[] ctext, int length);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static bool utf8_to_compound_text_for_display (Gdk.Display display, string str, out Gdk.Atom encoding, int format, uchar[] ctext, int length);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static unowned string utf8_to_string_target (string str);
}
