/* valascanner.c generated by valac, the Vala compiler
 * generated from valascanner.vala, do not modify */

/* valascanner.vala
 *
 * Copyright (C) 2008-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 * 	Jukka-Pekka Iivonen <jp0409@jippii.fi>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gobject/gvaluecollector.h>


#define VALA_TYPE_SCANNER (vala_scanner_get_type ())
#define VALA_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SCANNER, ValaScanner))
#define VALA_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SCANNER, ValaScannerClass))
#define VALA_IS_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SCANNER))
#define VALA_IS_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SCANNER))
#define VALA_SCANNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SCANNER, ValaScannerClass))

typedef struct _ValaScanner ValaScanner;
typedef struct _ValaScannerClass ValaScannerClass;
typedef struct _ValaScannerPrivate ValaScannerPrivate;

#define VALA_TYPE_SOURCE_FILE (vala_source_file_get_type ())
#define VALA_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_FILE, ValaSourceFile))
#define VALA_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_FILE, ValaSourceFileClass))
#define VALA_IS_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_FILE))
#define VALA_IS_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_FILE))
#define VALA_SOURCE_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_FILE, ValaSourceFileClass))

typedef struct _ValaSourceFile ValaSourceFile;
typedef struct _ValaSourceFileClass ValaSourceFileClass;

#define VALA_TYPE_TOKEN_TYPE (vala_token_type_get_type ())

#define VALA_TYPE_COMMENT (vala_comment_get_type ())
#define VALA_COMMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_COMMENT, ValaComment))
#define VALA_COMMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_COMMENT, ValaCommentClass))
#define VALA_IS_COMMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_COMMENT))
#define VALA_IS_COMMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_COMMENT))
#define VALA_COMMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_COMMENT, ValaCommentClass))

typedef struct _ValaComment ValaComment;
typedef struct _ValaCommentClass ValaCommentClass;

#define VALA_SCANNER_TYPE_CONDITIONAL (vala_scanner_conditional_get_type ())
typedef struct _ValaScannerConditional ValaScannerConditional;

#define VALA_SCANNER_TYPE_STATE (vala_scanner_state_get_type ())
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _vala_comment_unref0(var) ((var == NULL) ? NULL : (var = (vala_comment_unref (var), NULL)))

#define VALA_TYPE_SOURCE_LOCATION (vala_source_location_get_type ())
typedef struct _ValaSourceLocation ValaSourceLocation;

#define VALA_TYPE_SOURCE_REFERENCE (vala_source_reference_get_type ())
#define VALA_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReference))
#define VALA_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))
#define VALA_IS_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_IS_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_SOURCE_REFERENCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))

typedef struct _ValaSourceReference ValaSourceReference;
typedef struct _ValaSourceReferenceClass ValaSourceReferenceClass;
#define _vala_source_reference_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_reference_unref (var), NULL)))

#define VALA_TYPE_CODE_CONTEXT (vala_code_context_get_type ())
#define VALA_CODE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_CONTEXT, ValaCodeContext))
#define VALA_CODE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_CONTEXT, ValaCodeContextClass))
#define VALA_IS_CODE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_CONTEXT))
#define VALA_IS_CODE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_CONTEXT))
#define VALA_CODE_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_CONTEXT, ValaCodeContextClass))

typedef struct _ValaCodeContext ValaCodeContext;
typedef struct _ValaCodeContextClass ValaCodeContextClass;

#define VALA_TYPE_PROFILE (vala_profile_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ValaParamSpecScanner ValaParamSpecScanner;

struct _ValaScanner {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaScannerPrivate * priv;
};

struct _ValaScannerClass {
	GTypeClass parent_class;
	void (*finalize) (ValaScanner *self);
};

typedef enum  {
	VALA_TOKEN_TYPE_NONE,
	VALA_TOKEN_TYPE_ABSTRACT,
	VALA_TOKEN_TYPE_AS,
	VALA_TOKEN_TYPE_ASSIGN,
	VALA_TOKEN_TYPE_ASSIGN_ADD,
	VALA_TOKEN_TYPE_ASSIGN_BITWISE_AND,
	VALA_TOKEN_TYPE_ASSIGN_BITWISE_OR,
	VALA_TOKEN_TYPE_ASSIGN_BITWISE_XOR,
	VALA_TOKEN_TYPE_ASSIGN_DIV,
	VALA_TOKEN_TYPE_ASSIGN_MUL,
	VALA_TOKEN_TYPE_ASSIGN_PERCENT,
	VALA_TOKEN_TYPE_ASSIGN_SHIFT_LEFT,
	VALA_TOKEN_TYPE_ASSIGN_SUB,
	VALA_TOKEN_TYPE_ASYNC,
	VALA_TOKEN_TYPE_BASE,
	VALA_TOKEN_TYPE_BITWISE_AND,
	VALA_TOKEN_TYPE_BITWISE_OR,
	VALA_TOKEN_TYPE_BREAK,
	VALA_TOKEN_TYPE_CARRET,
	VALA_TOKEN_TYPE_CASE,
	VALA_TOKEN_TYPE_CATCH,
	VALA_TOKEN_TYPE_CHARACTER_LITERAL,
	VALA_TOKEN_TYPE_CLASS,
	VALA_TOKEN_TYPE_CLOSE_BRACE,
	VALA_TOKEN_TYPE_CLOSE_BRACKET,
	VALA_TOKEN_TYPE_CLOSE_PARENS,
	VALA_TOKEN_TYPE_CLOSE_REGEX_LITERAL,
	VALA_TOKEN_TYPE_CLOSE_TEMPLATE,
	VALA_TOKEN_TYPE_COLON,
	VALA_TOKEN_TYPE_COMMA,
	VALA_TOKEN_TYPE_CONST,
	VALA_TOKEN_TYPE_CONSTRUCT,
	VALA_TOKEN_TYPE_CONTINUE,
	VALA_TOKEN_TYPE_DEFAULT,
	VALA_TOKEN_TYPE_DELEGATE,
	VALA_TOKEN_TYPE_DELETE,
	VALA_TOKEN_TYPE_DIV,
	VALA_TOKEN_TYPE_DO,
	VALA_TOKEN_TYPE_DOUBLE_COLON,
	VALA_TOKEN_TYPE_DOT,
	VALA_TOKEN_TYPE_DYNAMIC,
	VALA_TOKEN_TYPE_ELLIPSIS,
	VALA_TOKEN_TYPE_ELSE,
	VALA_TOKEN_TYPE_ENUM,
	VALA_TOKEN_TYPE_ENSURES,
	VALA_TOKEN_TYPE_ERRORDOMAIN,
	VALA_TOKEN_TYPE_EOF,
	VALA_TOKEN_TYPE_EXTERN,
	VALA_TOKEN_TYPE_FALSE,
	VALA_TOKEN_TYPE_FINALLY,
	VALA_TOKEN_TYPE_FOR,
	VALA_TOKEN_TYPE_FOREACH,
	VALA_TOKEN_TYPE_GET,
	VALA_TOKEN_TYPE_HASH,
	VALA_TOKEN_TYPE_IDENTIFIER,
	VALA_TOKEN_TYPE_IF,
	VALA_TOKEN_TYPE_IN,
	VALA_TOKEN_TYPE_INLINE,
	VALA_TOKEN_TYPE_INTEGER_LITERAL,
	VALA_TOKEN_TYPE_INTERFACE,
	VALA_TOKEN_TYPE_INTERNAL,
	VALA_TOKEN_TYPE_INTERR,
	VALA_TOKEN_TYPE_IS,
	VALA_TOKEN_TYPE_LAMBDA,
	VALA_TOKEN_TYPE_LOCK,
	VALA_TOKEN_TYPE_MINUS,
	VALA_TOKEN_TYPE_NAMESPACE,
	VALA_TOKEN_TYPE_NEW,
	VALA_TOKEN_TYPE_NULL,
	VALA_TOKEN_TYPE_OUT,
	VALA_TOKEN_TYPE_OP_AND,
	VALA_TOKEN_TYPE_OP_COALESCING,
	VALA_TOKEN_TYPE_OP_DEC,
	VALA_TOKEN_TYPE_OP_EQ,
	VALA_TOKEN_TYPE_OP_GE,
	VALA_TOKEN_TYPE_OP_GT,
	VALA_TOKEN_TYPE_OP_INC,
	VALA_TOKEN_TYPE_OP_LE,
	VALA_TOKEN_TYPE_OP_LT,
	VALA_TOKEN_TYPE_OP_NE,
	VALA_TOKEN_TYPE_OP_NEG,
	VALA_TOKEN_TYPE_OP_OR,
	VALA_TOKEN_TYPE_OP_PTR,
	VALA_TOKEN_TYPE_OP_SHIFT_LEFT,
	VALA_TOKEN_TYPE_OPEN_BRACE,
	VALA_TOKEN_TYPE_OPEN_BRACKET,
	VALA_TOKEN_TYPE_OPEN_PARENS,
	VALA_TOKEN_TYPE_OPEN_REGEX_LITERAL,
	VALA_TOKEN_TYPE_OPEN_TEMPLATE,
	VALA_TOKEN_TYPE_OVERRIDE,
	VALA_TOKEN_TYPE_OWNED,
	VALA_TOKEN_TYPE_PARAMS,
	VALA_TOKEN_TYPE_PERCENT,
	VALA_TOKEN_TYPE_PLUS,
	VALA_TOKEN_TYPE_PRIVATE,
	VALA_TOKEN_TYPE_PROTECTED,
	VALA_TOKEN_TYPE_PUBLIC,
	VALA_TOKEN_TYPE_REAL_LITERAL,
	VALA_TOKEN_TYPE_REF,
	VALA_TOKEN_TYPE_REGEX_LITERAL,
	VALA_TOKEN_TYPE_REQUIRES,
	VALA_TOKEN_TYPE_RETURN,
	VALA_TOKEN_TYPE_SEALED,
	VALA_TOKEN_TYPE_SEMICOLON,
	VALA_TOKEN_TYPE_SET,
	VALA_TOKEN_TYPE_SIGNAL,
	VALA_TOKEN_TYPE_SIZEOF,
	VALA_TOKEN_TYPE_STAR,
	VALA_TOKEN_TYPE_STATIC,
	VALA_TOKEN_TYPE_STRING_LITERAL,
	VALA_TOKEN_TYPE_STRUCT,
	VALA_TOKEN_TYPE_SWITCH,
	VALA_TOKEN_TYPE_TEMPLATE_STRING_LITERAL,
	VALA_TOKEN_TYPE_THIS,
	VALA_TOKEN_TYPE_THROW,
	VALA_TOKEN_TYPE_THROWS,
	VALA_TOKEN_TYPE_TILDE,
	VALA_TOKEN_TYPE_TRUE,
	VALA_TOKEN_TYPE_TRY,
	VALA_TOKEN_TYPE_TYPEOF,
	VALA_TOKEN_TYPE_UNOWNED,
	VALA_TOKEN_TYPE_USING,
	VALA_TOKEN_TYPE_VAR,
	VALA_TOKEN_TYPE_VERBATIM_STRING_LITERAL,
	VALA_TOKEN_TYPE_VIRTUAL,
	VALA_TOKEN_TYPE_VOID,
	VALA_TOKEN_TYPE_VOLATILE,
	VALA_TOKEN_TYPE_WEAK,
	VALA_TOKEN_TYPE_WHILE,
	VALA_TOKEN_TYPE_YIELD
} ValaTokenType;

struct _ValaScannerConditional {
	gboolean matched;
	gboolean else_found;
	gboolean skip_section;
};

typedef enum  {
	VALA_SCANNER_STATE_PARENS,
	VALA_SCANNER_STATE_BRACE,
	VALA_SCANNER_STATE_BRACKET,
	VALA_SCANNER_STATE_TEMPLATE,
	VALA_SCANNER_STATE_TEMPLATE_PART,
	VALA_SCANNER_STATE_REGEX_LITERAL
} ValaScannerState;

struct _ValaScannerPrivate {
	ValaSourceFile* _source_file;
	ValaTokenType previous;
	gchar* current;
	gchar* end;
	gint line;
	gint column;
	ValaComment* _comment;
	ValaScannerConditional* conditional_stack;
	gint conditional_stack_length1;
	gint _conditional_stack_size_;
	ValaScannerState* state_stack;
	gint state_stack_length1;
	gint _state_stack_size_;
};

struct _ValaSourceLocation {
	gchar* pos;
	gint line;
	gint column;
};

typedef enum  {
	VALA_PROFILE_POSIX,
	VALA_PROFILE_GOBJECT,
	VALA_PROFILE_DOVA
} ValaProfile;

struct _ValaParamSpecScanner {
	GParamSpec parent_instance;
};


static gpointer vala_scanner_parent_class = NULL;

gpointer vala_scanner_ref (gpointer instance);
void vala_scanner_unref (gpointer instance);
GParamSpec* vala_param_spec_scanner (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_scanner (GValue* value, gpointer v_object);
void vala_value_take_scanner (GValue* value, gpointer v_object);
gpointer vala_value_get_scanner (const GValue* value);
GType vala_scanner_get_type (void) G_GNUC_CONST;
gpointer vala_source_file_ref (gpointer instance);
void vala_source_file_unref (gpointer instance);
GParamSpec* vala_param_spec_source_file (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_file (GValue* value, gpointer v_object);
void vala_value_take_source_file (GValue* value, gpointer v_object);
gpointer vala_value_get_source_file (const GValue* value);
GType vala_source_file_get_type (void) G_GNUC_CONST;
GType vala_token_type_get_type (void) G_GNUC_CONST;
gpointer vala_comment_ref (gpointer instance);
void vala_comment_unref (gpointer instance);
GParamSpec* vala_param_spec_comment (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_comment (GValue* value, gpointer v_object);
void vala_value_take_comment (GValue* value, gpointer v_object);
gpointer vala_value_get_comment (const GValue* value);
GType vala_comment_get_type (void) G_GNUC_CONST;
static GType vala_scanner_conditional_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static ValaScannerConditional* vala_scanner_conditional_dup (const ValaScannerConditional* self);
static void vala_scanner_conditional_free (ValaScannerConditional* self);
static GType vala_scanner_state_get_type (void) G_GNUC_UNUSED;
#define VALA_SCANNER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_SCANNER, ValaScannerPrivate))
enum  {
	VALA_SCANNER_DUMMY_PROPERTY
};
ValaScanner* vala_scanner_new (ValaSourceFile* source_file);
ValaScanner* vala_scanner_construct (GType object_type, ValaSourceFile* source_file);
static void vala_scanner_set_source_file (ValaScanner* self, ValaSourceFile* value);
gchar* vala_source_file_get_mapped_contents (ValaSourceFile* self);
gsize vala_source_file_get_mapped_length (ValaSourceFile* self);
GType vala_source_location_get_type (void) G_GNUC_CONST;
ValaSourceLocation* vala_source_location_dup (const ValaSourceLocation* self);
void vala_source_location_free (ValaSourceLocation* self);
void vala_scanner_seek (ValaScanner* self, ValaSourceLocation* location);
static gboolean vala_scanner_in_template (ValaScanner* self);
static gboolean vala_scanner_in_template_part (ValaScanner* self);
static gboolean vala_scanner_in_regex_literal (ValaScanner* self);
static gboolean vala_scanner_is_ident_char (ValaScanner* self, gchar c);
ValaTokenType vala_scanner_read_regex_token (ValaScanner* self, ValaSourceLocation* token_begin, ValaSourceLocation* token_end);
void vala_source_location_init (ValaSourceLocation *self, gchar* _pos, gint _line, gint _column);
gpointer vala_source_reference_ref (gpointer instance);
void vala_source_reference_unref (gpointer instance);
GParamSpec* vala_param_spec_source_reference (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_reference (GValue* value, gpointer v_object);
void vala_value_take_source_reference (GValue* value, gpointer v_object);
gpointer vala_value_get_source_reference (const GValue* value);
GType vala_source_reference_get_type (void) G_GNUC_CONST;
void vala_report_error (ValaSourceReference* source, const gchar* message);
ValaSourceFile* vala_scanner_get_source_file (ValaScanner* self);
ValaSourceReference* vala_source_reference_new (ValaSourceFile* _file, gint _first_line, gint _first_column, gint _last_line, gint _last_column);
ValaSourceReference* vala_source_reference_construct (GType object_type, ValaSourceFile* _file, gint _first_line, gint _first_column, gint _last_line, gint _last_column);
ValaTokenType vala_scanner_read_token (ValaScanner* self, ValaSourceLocation* token_begin, ValaSourceLocation* token_end);
ValaTokenType vala_scanner_get_identifier_or_keyword (gchar* begin, gint len);
static gboolean vala_scanner_matches (gchar* begin, const gchar* keyword);
static ValaTokenType vala_scanner_read_number (ValaScanner* self);
ValaTokenType vala_scanner_read_template_token (ValaScanner* self, ValaSourceLocation* token_begin, ValaSourceLocation* token_end);
static void _vala_array_add13 (ValaScannerState** array, int* length, int* size, ValaScannerState value);
static void _vala_array_add14 (ValaScannerState** array, int* length, int* size, ValaScannerState value);
static void _vala_array_add15 (ValaScannerState** array, int* length, int* size, ValaScannerState value);
static void _vala_array_add16 (ValaScannerState** array, int* length, int* size, ValaScannerState value);
static void vala_scanner_space (ValaScanner* self);
gpointer vala_code_context_ref (gpointer instance);
void vala_code_context_unref (gpointer instance);
GParamSpec* vala_param_spec_code_context (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_context (GValue* value, gpointer v_object);
void vala_value_take_code_context (GValue* value, gpointer v_object);
gpointer vala_value_get_code_context (const GValue* value);
GType vala_code_context_get_type (void) G_GNUC_CONST;
ValaCodeContext* vala_source_file_get_context (ValaSourceFile* self);
GType vala_profile_get_type (void) G_GNUC_CONST;
ValaProfile vala_code_context_get_profile (ValaCodeContext* self);
static void _vala_array_add17 (ValaScannerState** array, int* length, int* size, ValaScannerState value);
static void _vala_array_add18 (ValaScannerState** array, int* length, int* size, ValaScannerState value);
static void _vala_array_add19 (ValaScannerState** array, int* length, int* size, ValaScannerState value);
static void _vala_array_add20 (ValaScannerState** array, int* length, int* size, ValaScannerState value);
static void _vala_array_add21 (ValaScannerState** array, int* length, int* size, ValaScannerState value);
static void _vala_array_add22 (ValaScannerState** array, int* length, int* size, ValaScannerState value);
static gboolean vala_scanner_pp_whitespace (ValaScanner* self);
static void vala_scanner_pp_directive (ValaScanner* self);
static void vala_scanner_parse_pp_if (ValaScanner* self);
static void vala_scanner_parse_pp_elif (ValaScanner* self);
static void vala_scanner_parse_pp_else (ValaScanner* self);
static void vala_scanner_parse_pp_endif (ValaScanner* self);
static void vala_scanner_pp_eol (ValaScanner* self);
static gboolean vala_scanner_parse_pp_expression (ValaScanner* self);
static void _vala_array_add23 (ValaScannerConditional** array, int* length, int* size, const ValaScannerConditional* value);
static gboolean vala_scanner_parse_pp_symbol (ValaScanner* self);
gboolean vala_code_context_is_defined (ValaCodeContext* self, const gchar* define);
static gboolean vala_scanner_parse_pp_primary_expression (ValaScanner* self);
static gboolean vala_scanner_parse_pp_unary_expression (ValaScanner* self);
static gboolean vala_scanner_parse_pp_equality_expression (ValaScanner* self);
static gboolean vala_scanner_parse_pp_and_expression (ValaScanner* self);
static gboolean vala_scanner_parse_pp_or_expression (ValaScanner* self);
static gboolean vala_scanner_whitespace (ValaScanner* self);
static gboolean vala_scanner_comment (ValaScanner* self, gboolean file_comment);
static void vala_scanner_push_comment (ValaScanner* self, const gchar* comment_item, ValaSourceReference* source_reference, gboolean file_comment);
void vala_scanner_parse_file_comments (ValaScanner* self);
void vala_source_file_add_comment (ValaSourceFile* self, ValaComment* comment);
ValaComment* vala_comment_new (const gchar* comment, ValaSourceReference* _source_reference);
ValaComment* vala_comment_construct (GType object_type, const gchar* comment, ValaSourceReference* _source_reference);
ValaComment* vala_scanner_pop_comment (ValaScanner* self);
static void vala_scanner_finalize (ValaScanner* obj);


static GType vala_scanner_state_get_type (void) {
	static volatile gsize vala_scanner_state_type_id__volatile = 0;
	if (g_once_init_enter (&vala_scanner_state_type_id__volatile)) {
		static const GEnumValue values[] = {{VALA_SCANNER_STATE_PARENS, "VALA_SCANNER_STATE_PARENS", "parens"}, {VALA_SCANNER_STATE_BRACE, "VALA_SCANNER_STATE_BRACE", "brace"}, {VALA_SCANNER_STATE_BRACKET, "VALA_SCANNER_STATE_BRACKET", "bracket"}, {VALA_SCANNER_STATE_TEMPLATE, "VALA_SCANNER_STATE_TEMPLATE", "template"}, {VALA_SCANNER_STATE_TEMPLATE_PART, "VALA_SCANNER_STATE_TEMPLATE_PART", "template-part"}, {VALA_SCANNER_STATE_REGEX_LITERAL, "VALA_SCANNER_STATE_REGEX_LITERAL", "regex-literal"}, {0, NULL, NULL}};
		GType vala_scanner_state_type_id;
		vala_scanner_state_type_id = g_enum_register_static ("ValaScannerState", values);
		g_once_init_leave (&vala_scanner_state_type_id__volatile, vala_scanner_state_type_id);
	}
	return vala_scanner_state_type_id__volatile;
}


ValaScanner* vala_scanner_construct (GType object_type, ValaSourceFile* source_file) {
	ValaScanner* self = NULL;
	ValaSourceFile* _tmp0_;
	ValaSourceFile* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* begin;
	ValaSourceFile* _tmp3_;
	gsize _tmp4_ = 0UL;
	g_return_val_if_fail (source_file != NULL, NULL);
	self = (ValaScanner*) g_type_create_instance (object_type);
	_tmp0_ = source_file;
	vala_scanner_set_source_file (self, _tmp0_);
	_tmp1_ = source_file;
	_tmp2_ = vala_source_file_get_mapped_contents (_tmp1_);
	begin = _tmp2_;
	_tmp3_ = source_file;
	_tmp4_ = vala_source_file_get_mapped_length (_tmp3_);
	self->priv->end = begin + _tmp4_;
	self->priv->current = begin;
	self->priv->line = 1;
	self->priv->column = 1;
	return self;
}


ValaScanner* vala_scanner_new (ValaSourceFile* source_file) {
	return vala_scanner_construct (VALA_TYPE_SCANNER, source_file);
}


void vala_scanner_seek (ValaScanner* self, ValaSourceLocation* location) {
	ValaSourceLocation _tmp0_;
	gchar* _tmp1_;
	ValaSourceLocation _tmp2_;
	gint _tmp3_;
	ValaSourceLocation _tmp4_;
	gint _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (location != NULL);
	_tmp0_ = *location;
	_tmp1_ = _tmp0_.pos;
	self->priv->current = _tmp1_;
	_tmp2_ = *location;
	_tmp3_ = _tmp2_.line;
	self->priv->line = _tmp3_;
	_tmp4_ = *location;
	_tmp5_ = _tmp4_.column;
	self->priv->column = _tmp5_;
	self->priv->conditional_stack = (g_free (self->priv->conditional_stack), NULL);
	self->priv->conditional_stack = NULL;
	self->priv->conditional_stack_length1 = 0;
	self->priv->_conditional_stack_size_ = self->priv->conditional_stack_length1;
	self->priv->state_stack = (g_free (self->priv->state_stack), NULL);
	self->priv->state_stack = NULL;
	self->priv->state_stack_length1 = 0;
	self->priv->_state_stack_size_ = self->priv->state_stack_length1;
}


static gboolean vala_scanner_in_template (ValaScanner* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	ValaScannerState* _tmp1_;
	gint _tmp1__length1;
	gboolean _tmp5_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->state_stack;
	_tmp1__length1 = self->priv->state_stack_length1;
	if (_tmp1__length1 > 0) {
		ValaScannerState* _tmp2_;
		gint _tmp2__length1;
		ValaScannerState* _tmp3_;
		gint _tmp3__length1;
		ValaScannerState _tmp4_;
		_tmp2_ = self->priv->state_stack;
		_tmp2__length1 = self->priv->state_stack_length1;
		_tmp3_ = self->priv->state_stack;
		_tmp3__length1 = self->priv->state_stack_length1;
		_tmp4_ = _tmp2_[_tmp3__length1 - 1];
		_tmp0_ = _tmp4_ == VALA_SCANNER_STATE_TEMPLATE;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp5_ = _tmp0_;
	result = _tmp5_;
	return result;
}


static gboolean vala_scanner_in_template_part (ValaScanner* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	ValaScannerState* _tmp1_;
	gint _tmp1__length1;
	gboolean _tmp5_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->state_stack;
	_tmp1__length1 = self->priv->state_stack_length1;
	if (_tmp1__length1 > 0) {
		ValaScannerState* _tmp2_;
		gint _tmp2__length1;
		ValaScannerState* _tmp3_;
		gint _tmp3__length1;
		ValaScannerState _tmp4_;
		_tmp2_ = self->priv->state_stack;
		_tmp2__length1 = self->priv->state_stack_length1;
		_tmp3_ = self->priv->state_stack;
		_tmp3__length1 = self->priv->state_stack_length1;
		_tmp4_ = _tmp2_[_tmp3__length1 - 1];
		_tmp0_ = _tmp4_ == VALA_SCANNER_STATE_TEMPLATE_PART;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp5_ = _tmp0_;
	result = _tmp5_;
	return result;
}


static gboolean vala_scanner_in_regex_literal (ValaScanner* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	ValaScannerState* _tmp1_;
	gint _tmp1__length1;
	gboolean _tmp5_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->state_stack;
	_tmp1__length1 = self->priv->state_stack_length1;
	if (_tmp1__length1 > 0) {
		ValaScannerState* _tmp2_;
		gint _tmp2__length1;
		ValaScannerState* _tmp3_;
		gint _tmp3__length1;
		ValaScannerState _tmp4_;
		_tmp2_ = self->priv->state_stack;
		_tmp2__length1 = self->priv->state_stack_length1;
		_tmp3_ = self->priv->state_stack;
		_tmp3__length1 = self->priv->state_stack_length1;
		_tmp4_ = _tmp2_[_tmp3__length1 - 1];
		_tmp0_ = _tmp4_ == VALA_SCANNER_STATE_REGEX_LITERAL;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp5_ = _tmp0_;
	result = _tmp5_;
	return result;
}


static gboolean vala_scanner_is_ident_char (ValaScanner* self, gchar c) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gchar _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp4_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = c;
	_tmp2_ = g_ascii_isalnum (_tmp1_);
	if (_tmp2_) {
		_tmp0_ = TRUE;
	} else {
		gchar _tmp3_;
		_tmp3_ = c;
		_tmp0_ = _tmp3_ == '_';
	}
	_tmp4_ = _tmp0_;
	result = _tmp4_;
	return result;
}


ValaTokenType vala_scanner_read_regex_token (ValaScanner* self, ValaSourceLocation* token_begin, ValaSourceLocation* token_end) {
	ValaSourceLocation _vala_token_begin = {0};
	ValaSourceLocation _vala_token_end = {0};
	ValaTokenType result = 0;
	ValaTokenType type = 0;
	gchar* _tmp0_;
	gchar* begin;
	gchar* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	ValaSourceLocation _tmp4_ = {0};
	gint token_length_in_chars;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gint _tmp145_;
	gchar* _tmp151_;
	gint _tmp152_;
	gint _tmp153_;
	ValaSourceLocation _tmp154_ = {0};
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->current;
	begin = _tmp0_;
	_tmp1_ = begin;
	_tmp2_ = self->priv->line;
	_tmp3_ = self->priv->column;
	vala_source_location_init (&_tmp4_, _tmp1_, _tmp2_, _tmp3_);
	_vala_token_begin = _tmp4_;
	token_length_in_chars = -1;
	_tmp5_ = self->priv->current;
	_tmp6_ = self->priv->end;
	if (_tmp5_ >= _tmp6_) {
		type = VALA_TOKEN_TYPE_EOF;
	} else {
		gchar* _tmp7_;
		gchar _tmp8_;
		_tmp7_ = self->priv->current;
		_tmp8_ = _tmp7_[0];
		switch (_tmp8_) {
			case '/':
			{
				gchar* _tmp9_;
				gint _tmp10_;
				gboolean fl_i;
				gboolean fl_s;
				gboolean fl_m;
				gboolean fl_x;
				type = VALA_TOKEN_TYPE_CLOSE_REGEX_LITERAL;
				_tmp9_ = self->priv->current;
				self->priv->current = _tmp9_ + 1;
				_tmp10_ = self->priv->state_stack_length1;
				self->priv->state_stack_length1 = _tmp10_ - 1;
				fl_i = FALSE;
				fl_s = FALSE;
				fl_m = FALSE;
				fl_x = FALSE;
				while (TRUE) {
					gboolean _tmp11_ = FALSE;
					gboolean _tmp12_ = FALSE;
					gboolean _tmp13_ = FALSE;
					gchar* _tmp14_;
					gchar _tmp15_;
					gboolean _tmp18_;
					gboolean _tmp21_;
					gboolean _tmp24_;
					gchar* _tmp25_;
					gchar _tmp26_;
					gchar* _tmp67_;
					gint _tmp68_;
					_tmp14_ = self->priv->current;
					_tmp15_ = _tmp14_[0];
					if (_tmp15_ == 'i') {
						_tmp13_ = TRUE;
					} else {
						gchar* _tmp16_;
						gchar _tmp17_;
						_tmp16_ = self->priv->current;
						_tmp17_ = _tmp16_[0];
						_tmp13_ = _tmp17_ == 's';
					}
					_tmp18_ = _tmp13_;
					if (_tmp18_) {
						_tmp12_ = TRUE;
					} else {
						gchar* _tmp19_;
						gchar _tmp20_;
						_tmp19_ = self->priv->current;
						_tmp20_ = _tmp19_[0];
						_tmp12_ = _tmp20_ == 'm';
					}
					_tmp21_ = _tmp12_;
					if (_tmp21_) {
						_tmp11_ = TRUE;
					} else {
						gchar* _tmp22_;
						gchar _tmp23_;
						_tmp22_ = self->priv->current;
						_tmp23_ = _tmp22_[0];
						_tmp11_ = _tmp23_ == 'x';
					}
					_tmp24_ = _tmp11_;
					if (!_tmp24_) {
						break;
					}
					_tmp25_ = self->priv->current;
					_tmp26_ = _tmp25_[0];
					switch (_tmp26_) {
						case 'i':
						{
							gboolean _tmp27_;
							_tmp27_ = fl_i;
							if (_tmp27_) {
								ValaSourceFile* _tmp28_;
								gint _tmp29_;
								gint _tmp30_;
								gint _tmp31_;
								gint _tmp32_;
								gint _tmp33_;
								gint _tmp34_;
								ValaSourceReference* _tmp35_;
								ValaSourceReference* _tmp36_;
								_tmp28_ = self->priv->_source_file;
								_tmp29_ = self->priv->line;
								_tmp30_ = self->priv->column;
								_tmp31_ = token_length_in_chars;
								_tmp32_ = self->priv->line;
								_tmp33_ = self->priv->column;
								_tmp34_ = token_length_in_chars;
								_tmp35_ = vala_source_reference_new (_tmp28_, _tmp29_, _tmp30_ + _tmp31_, _tmp32_, _tmp33_ + _tmp34_);
								_tmp36_ = _tmp35_;
								vala_report_error (_tmp36_, "modifier 'i' used more than once");
								_vala_source_reference_unref0 (_tmp36_);
							}
							fl_i = TRUE;
							break;
						}
						case 's':
						{
							gboolean _tmp37_;
							_tmp37_ = fl_s;
							if (_tmp37_) {
								ValaSourceFile* _tmp38_;
								gint _tmp39_;
								gint _tmp40_;
								gint _tmp41_;
								gint _tmp42_;
								gint _tmp43_;
								gint _tmp44_;
								ValaSourceReference* _tmp45_;
								ValaSourceReference* _tmp46_;
								_tmp38_ = self->priv->_source_file;
								_tmp39_ = self->priv->line;
								_tmp40_ = self->priv->column;
								_tmp41_ = token_length_in_chars;
								_tmp42_ = self->priv->line;
								_tmp43_ = self->priv->column;
								_tmp44_ = token_length_in_chars;
								_tmp45_ = vala_source_reference_new (_tmp38_, _tmp39_, _tmp40_ + _tmp41_, _tmp42_, _tmp43_ + _tmp44_);
								_tmp46_ = _tmp45_;
								vala_report_error (_tmp46_, "modifier 's' used more than once");
								_vala_source_reference_unref0 (_tmp46_);
							}
							fl_s = TRUE;
							break;
						}
						case 'm':
						{
							gboolean _tmp47_;
							_tmp47_ = fl_m;
							if (_tmp47_) {
								ValaSourceFile* _tmp48_;
								gint _tmp49_;
								gint _tmp50_;
								gint _tmp51_;
								gint _tmp52_;
								gint _tmp53_;
								gint _tmp54_;
								ValaSourceReference* _tmp55_;
								ValaSourceReference* _tmp56_;
								_tmp48_ = self->priv->_source_file;
								_tmp49_ = self->priv->line;
								_tmp50_ = self->priv->column;
								_tmp51_ = token_length_in_chars;
								_tmp52_ = self->priv->line;
								_tmp53_ = self->priv->column;
								_tmp54_ = token_length_in_chars;
								_tmp55_ = vala_source_reference_new (_tmp48_, _tmp49_, _tmp50_ + _tmp51_, _tmp52_, _tmp53_ + _tmp54_);
								_tmp56_ = _tmp55_;
								vala_report_error (_tmp56_, "modifier 'm' used more than once");
								_vala_source_reference_unref0 (_tmp56_);
							}
							fl_m = TRUE;
							break;
						}
						case 'x':
						{
							gboolean _tmp57_;
							_tmp57_ = fl_x;
							if (_tmp57_) {
								ValaSourceFile* _tmp58_;
								gint _tmp59_;
								gint _tmp60_;
								gint _tmp61_;
								gint _tmp62_;
								gint _tmp63_;
								gint _tmp64_;
								ValaSourceReference* _tmp65_;
								ValaSourceReference* _tmp66_;
								_tmp58_ = self->priv->_source_file;
								_tmp59_ = self->priv->line;
								_tmp60_ = self->priv->column;
								_tmp61_ = token_length_in_chars;
								_tmp62_ = self->priv->line;
								_tmp63_ = self->priv->column;
								_tmp64_ = token_length_in_chars;
								_tmp65_ = vala_source_reference_new (_tmp58_, _tmp59_, _tmp60_ + _tmp61_, _tmp62_, _tmp63_ + _tmp64_);
								_tmp66_ = _tmp65_;
								vala_report_error (_tmp66_, "modifier 'x' used more than once");
								_vala_source_reference_unref0 (_tmp66_);
							}
							fl_x = TRUE;
							break;
						}
						default:
						break;
					}
					_tmp67_ = self->priv->current;
					self->priv->current = _tmp67_ + 1;
					_tmp68_ = token_length_in_chars;
					token_length_in_chars = _tmp68_ + 1;
				}
				break;
			}
			default:
			{
				gboolean _tmp126_ = FALSE;
				gchar* _tmp127_;
				gchar* _tmp128_;
				gboolean _tmp131_;
				type = VALA_TOKEN_TYPE_REGEX_LITERAL;
				token_length_in_chars = 0;
				while (TRUE) {
					gboolean _tmp69_ = FALSE;
					gchar* _tmp70_;
					gchar* _tmp71_;
					gboolean _tmp74_;
					gchar* _tmp75_;
					gchar _tmp76_;
					_tmp70_ = self->priv->current;
					_tmp71_ = self->priv->end;
					if (_tmp70_ < _tmp71_) {
						gchar* _tmp72_;
						gchar _tmp73_;
						_tmp72_ = self->priv->current;
						_tmp73_ = _tmp72_[0];
						_tmp69_ = _tmp73_ != '/';
					} else {
						_tmp69_ = FALSE;
					}
					_tmp74_ = _tmp69_;
					if (!_tmp74_) {
						break;
					}
					_tmp75_ = self->priv->current;
					_tmp76_ = _tmp75_[0];
					if (_tmp76_ == '\\') {
						gchar* _tmp77_;
						gint _tmp78_;
						gchar* _tmp79_;
						gchar* _tmp80_;
						gchar* _tmp81_;
						gchar _tmp82_;
						_tmp77_ = self->priv->current;
						self->priv->current = _tmp77_ + 1;
						_tmp78_ = token_length_in_chars;
						token_length_in_chars = _tmp78_ + 1;
						_tmp79_ = self->priv->current;
						_tmp80_ = self->priv->end;
						if (_tmp79_ >= _tmp80_) {
							break;
						}
						_tmp81_ = self->priv->current;
						_tmp82_ = _tmp81_[0];
						switch (_tmp82_) {
							case '\'':
							case '"':
							case '\\':
							case '/':
							case '^':
							case '$':
							case '.':
							case '[':
							case ']':
							case '{':
							case '}':
							case '(':
							case ')':
							case '?':
							case '*':
							case '+':
							case '-':
							case '#':
							case '&':
							case '~':
							case ':':
							case ';':
							case '<':
							case '>':
							case '|':
							case '%':
							case '=':
							case '@':
							case '0':
							case 'b':
							case 'B':
							case 'f':
							case 'n':
							case 'r':
							case 't':
							case 'a':
							case 'A':
							case 'p':
							case 'P':
							case 'e':
							case 'd':
							case 'D':
							case 's':
							case 'S':
							case 'w':
							case 'W':
							case 'G':
							case 'z':
							case 'Z':
							{
								gchar* _tmp83_;
								gint _tmp84_;
								_tmp83_ = self->priv->current;
								self->priv->current = _tmp83_ + 1;
								_tmp84_ = token_length_in_chars;
								token_length_in_chars = _tmp84_ + 1;
								break;
							}
							case 'x':
							{
								gchar* _tmp85_;
								gint _tmp86_;
								_tmp85_ = self->priv->current;
								self->priv->current = _tmp85_ + 1;
								_tmp86_ = token_length_in_chars;
								token_length_in_chars = _tmp86_ + 1;
								while (TRUE) {
									gboolean _tmp87_ = FALSE;
									gchar* _tmp88_;
									gchar* _tmp89_;
									gboolean _tmp93_;
									gchar* _tmp94_;
									gint _tmp95_;
									_tmp88_ = self->priv->current;
									_tmp89_ = self->priv->end;
									if (_tmp88_ < _tmp89_) {
										gchar* _tmp90_;
										gchar _tmp91_;
										gboolean _tmp92_ = FALSE;
										_tmp90_ = self->priv->current;
										_tmp91_ = _tmp90_[0];
										_tmp92_ = g_ascii_isxdigit (_tmp91_);
										_tmp87_ = _tmp92_;
									} else {
										_tmp87_ = FALSE;
									}
									_tmp93_ = _tmp87_;
									if (!_tmp93_) {
										break;
									}
									_tmp94_ = self->priv->current;
									self->priv->current = _tmp94_ + 1;
									_tmp95_ = token_length_in_chars;
									token_length_in_chars = _tmp95_ + 1;
								}
								break;
							}
							default:
							{
								ValaSourceFile* _tmp96_;
								gint _tmp97_;
								gint _tmp98_;
								gint _tmp99_;
								gint _tmp100_;
								gint _tmp101_;
								gint _tmp102_;
								ValaSourceReference* _tmp103_;
								ValaSourceReference* _tmp104_;
								_tmp96_ = self->priv->_source_file;
								_tmp97_ = self->priv->line;
								_tmp98_ = self->priv->column;
								_tmp99_ = token_length_in_chars;
								_tmp100_ = self->priv->line;
								_tmp101_ = self->priv->column;
								_tmp102_ = token_length_in_chars;
								_tmp103_ = vala_source_reference_new (_tmp96_, _tmp97_, _tmp98_ + _tmp99_, _tmp100_, _tmp101_ + _tmp102_);
								_tmp104_ = _tmp103_;
								vala_report_error (_tmp104_, "invalid escape sequence");
								_vala_source_reference_unref0 (_tmp104_);
								break;
							}
						}
					} else {
						gchar* _tmp105_;
						gchar _tmp106_;
						_tmp105_ = self->priv->current;
						_tmp106_ = _tmp105_[0];
						if (_tmp106_ == '\n') {
							break;
						} else {
							gchar* _tmp107_;
							gchar* _tmp108_;
							gchar* _tmp109_;
							gunichar _tmp110_ = 0U;
							gunichar u;
							gunichar _tmp111_;
							_tmp107_ = self->priv->current;
							_tmp108_ = self->priv->end;
							_tmp109_ = self->priv->current;
							_tmp110_ = g_utf8_get_char_validated ((const gchar*) _tmp107_, (gssize) ((glong) (_tmp108_ - _tmp109_)));
							u = _tmp110_;
							_tmp111_ = u;
							if (_tmp111_ != ((gunichar) (-1))) {
								gchar* _tmp112_;
								gunichar _tmp113_;
								gint _tmp114_ = 0;
								gint _tmp115_;
								_tmp112_ = self->priv->current;
								_tmp113_ = u;
								_tmp114_ = g_unichar_to_utf8 (_tmp113_, NULL);
								self->priv->current = _tmp112_ + _tmp114_;
								_tmp115_ = token_length_in_chars;
								token_length_in_chars = _tmp115_ + 1;
							} else {
								gchar* _tmp116_;
								ValaSourceFile* _tmp117_;
								gint _tmp118_;
								gint _tmp119_;
								gint _tmp120_;
								gint _tmp121_;
								gint _tmp122_;
								gint _tmp123_;
								ValaSourceReference* _tmp124_;
								ValaSourceReference* _tmp125_;
								_tmp116_ = self->priv->current;
								self->priv->current = _tmp116_ + 1;
								_tmp117_ = self->priv->_source_file;
								_tmp118_ = self->priv->line;
								_tmp119_ = self->priv->column;
								_tmp120_ = token_length_in_chars;
								_tmp121_ = self->priv->line;
								_tmp122_ = self->priv->column;
								_tmp123_ = token_length_in_chars;
								_tmp124_ = vala_source_reference_new (_tmp117_, _tmp118_, _tmp119_ + _tmp120_, _tmp121_, _tmp122_ + _tmp123_);
								_tmp125_ = _tmp124_;
								vala_report_error (_tmp125_, "invalid UTF-8 character");
								_vala_source_reference_unref0 (_tmp125_);
							}
						}
					}
				}
				_tmp127_ = self->priv->current;
				_tmp128_ = self->priv->end;
				if (_tmp127_ >= _tmp128_) {
					_tmp126_ = TRUE;
				} else {
					gchar* _tmp129_;
					gchar _tmp130_;
					_tmp129_ = self->priv->current;
					_tmp130_ = _tmp129_[0];
					_tmp126_ = _tmp130_ == '\n';
				}
				_tmp131_ = _tmp126_;
				if (_tmp131_) {
					ValaSourceFile* _tmp132_;
					gint _tmp133_;
					gint _tmp134_;
					gint _tmp135_;
					gint _tmp136_;
					gint _tmp137_;
					gint _tmp138_;
					ValaSourceReference* _tmp139_;
					ValaSourceReference* _tmp140_;
					gint _tmp141_;
					ValaSourceLocation _tmp142_ = {0};
					ValaSourceLocation _tmp143_ = {0};
					ValaTokenType _tmp144_ = 0;
					_tmp132_ = self->priv->_source_file;
					_tmp133_ = self->priv->line;
					_tmp134_ = self->priv->column;
					_tmp135_ = token_length_in_chars;
					_tmp136_ = self->priv->line;
					_tmp137_ = self->priv->column;
					_tmp138_ = token_length_in_chars;
					_tmp139_ = vala_source_reference_new (_tmp132_, _tmp133_, _tmp134_ + _tmp135_, _tmp136_, _tmp137_ + _tmp138_);
					_tmp140_ = _tmp139_;
					vala_report_error (_tmp140_, "syntax error, expected \"");
					_vala_source_reference_unref0 (_tmp140_);
					_tmp141_ = self->priv->state_stack_length1;
					self->priv->state_stack_length1 = _tmp141_ - 1;
					_tmp144_ = vala_scanner_read_token (self, &_tmp142_, &_tmp143_);
					_vala_token_begin = _tmp142_;
					_vala_token_end = _tmp143_;
					result = _tmp144_;
					if (token_begin) {
						*token_begin = _vala_token_begin;
					}
					if (token_end) {
						*token_end = _vala_token_end;
					}
					return result;
				}
				break;
			}
		}
	}
	_tmp145_ = token_length_in_chars;
	if (_tmp145_ < 0) {
		gint _tmp146_;
		gchar* _tmp147_;
		gchar* _tmp148_;
		_tmp146_ = self->priv->column;
		_tmp147_ = self->priv->current;
		_tmp148_ = begin;
		self->priv->column = _tmp146_ + ((gint) (_tmp147_ - _tmp148_));
	} else {
		gint _tmp149_;
		gint _tmp150_;
		_tmp149_ = self->priv->column;
		_tmp150_ = token_length_in_chars;
		self->priv->column = _tmp149_ + _tmp150_;
	}
	_tmp151_ = self->priv->current;
	_tmp152_ = self->priv->line;
	_tmp153_ = self->priv->column;
	vala_source_location_init (&_tmp154_, _tmp151_, _tmp152_, _tmp153_ - 1);
	_vala_token_end = _tmp154_;
	result = type;
	if (token_begin) {
		*token_begin = _vala_token_begin;
	}
	if (token_end) {
		*token_end = _vala_token_end;
	}
	return result;
}


ValaTokenType vala_scanner_get_identifier_or_keyword (gchar* begin, gint len) {
	ValaTokenType result = 0;
	gint _tmp0_;
	_tmp0_ = len;
	switch (_tmp0_) {
		case 2:
		{
			gchar* _tmp1_;
			gchar _tmp2_;
			_tmp1_ = begin;
			_tmp2_ = _tmp1_[0];
			switch (_tmp2_) {
				case 'a':
				{
					gchar* _tmp3_;
					gboolean _tmp4_ = FALSE;
					_tmp3_ = begin;
					_tmp4_ = vala_scanner_matches (_tmp3_, "as");
					if (_tmp4_) {
						result = VALA_TOKEN_TYPE_AS;
						return result;
					}
					break;
				}
				case 'd':
				{
					gchar* _tmp5_;
					gboolean _tmp6_ = FALSE;
					_tmp5_ = begin;
					_tmp6_ = vala_scanner_matches (_tmp5_, "do");
					if (_tmp6_) {
						result = VALA_TOKEN_TYPE_DO;
						return result;
					}
					break;
				}
				case 'i':
				{
					gchar* _tmp7_;
					gchar _tmp8_;
					_tmp7_ = begin;
					_tmp8_ = _tmp7_[1];
					switch (_tmp8_) {
						case 'f':
						{
							result = VALA_TOKEN_TYPE_IF;
							return result;
						}
						case 'n':
						{
							result = VALA_TOKEN_TYPE_IN;
							return result;
						}
						case 's':
						{
							result = VALA_TOKEN_TYPE_IS;
							return result;
						}
						default:
						break;
					}
					break;
				}
				default:
				break;
			}
			break;
		}
		case 3:
		{
			gchar* _tmp9_;
			gchar _tmp10_;
			_tmp9_ = begin;
			_tmp10_ = _tmp9_[0];
			switch (_tmp10_) {
				case 'f':
				{
					gchar* _tmp11_;
					gboolean _tmp12_ = FALSE;
					_tmp11_ = begin;
					_tmp12_ = vala_scanner_matches (_tmp11_, "for");
					if (_tmp12_) {
						result = VALA_TOKEN_TYPE_FOR;
						return result;
					}
					break;
				}
				case 'g':
				{
					gchar* _tmp13_;
					gboolean _tmp14_ = FALSE;
					_tmp13_ = begin;
					_tmp14_ = vala_scanner_matches (_tmp13_, "get");
					if (_tmp14_) {
						result = VALA_TOKEN_TYPE_GET;
						return result;
					}
					break;
				}
				case 'n':
				{
					gchar* _tmp15_;
					gboolean _tmp16_ = FALSE;
					_tmp15_ = begin;
					_tmp16_ = vala_scanner_matches (_tmp15_, "new");
					if (_tmp16_) {
						result = VALA_TOKEN_TYPE_NEW;
						return result;
					}
					break;
				}
				case 'o':
				{
					gchar* _tmp17_;
					gboolean _tmp18_ = FALSE;
					_tmp17_ = begin;
					_tmp18_ = vala_scanner_matches (_tmp17_, "out");
					if (_tmp18_) {
						result = VALA_TOKEN_TYPE_OUT;
						return result;
					}
					break;
				}
				case 'r':
				{
					gchar* _tmp19_;
					gboolean _tmp20_ = FALSE;
					_tmp19_ = begin;
					_tmp20_ = vala_scanner_matches (_tmp19_, "ref");
					if (_tmp20_) {
						result = VALA_TOKEN_TYPE_REF;
						return result;
					}
					break;
				}
				case 's':
				{
					gchar* _tmp21_;
					gboolean _tmp22_ = FALSE;
					_tmp21_ = begin;
					_tmp22_ = vala_scanner_matches (_tmp21_, "set");
					if (_tmp22_) {
						result = VALA_TOKEN_TYPE_SET;
						return result;
					}
					break;
				}
				case 't':
				{
					gchar* _tmp23_;
					gboolean _tmp24_ = FALSE;
					_tmp23_ = begin;
					_tmp24_ = vala_scanner_matches (_tmp23_, "try");
					if (_tmp24_) {
						result = VALA_TOKEN_TYPE_TRY;
						return result;
					}
					break;
				}
				case 'v':
				{
					gchar* _tmp25_;
					gboolean _tmp26_ = FALSE;
					_tmp25_ = begin;
					_tmp26_ = vala_scanner_matches (_tmp25_, "var");
					if (_tmp26_) {
						result = VALA_TOKEN_TYPE_VAR;
						return result;
					}
					break;
				}
				default:
				break;
			}
			break;
		}
		case 4:
		{
			gchar* _tmp27_;
			gchar _tmp28_;
			_tmp27_ = begin;
			_tmp28_ = _tmp27_[0];
			switch (_tmp28_) {
				case 'b':
				{
					gchar* _tmp29_;
					gboolean _tmp30_ = FALSE;
					_tmp29_ = begin;
					_tmp30_ = vala_scanner_matches (_tmp29_, "base");
					if (_tmp30_) {
						result = VALA_TOKEN_TYPE_BASE;
						return result;
					}
					break;
				}
				case 'c':
				{
					gchar* _tmp31_;
					gboolean _tmp32_ = FALSE;
					_tmp31_ = begin;
					_tmp32_ = vala_scanner_matches (_tmp31_, "case");
					if (_tmp32_) {
						result = VALA_TOKEN_TYPE_CASE;
						return result;
					}
					break;
				}
				case 'e':
				{
					gchar* _tmp33_;
					gchar _tmp34_;
					_tmp33_ = begin;
					_tmp34_ = _tmp33_[1];
					switch (_tmp34_) {
						case 'l':
						{
							gchar* _tmp35_;
							gboolean _tmp36_ = FALSE;
							_tmp35_ = begin;
							_tmp36_ = vala_scanner_matches (_tmp35_, "else");
							if (_tmp36_) {
								result = VALA_TOKEN_TYPE_ELSE;
								return result;
							}
							break;
						}
						case 'n':
						{
							gchar* _tmp37_;
							gboolean _tmp38_ = FALSE;
							_tmp37_ = begin;
							_tmp38_ = vala_scanner_matches (_tmp37_, "enum");
							if (_tmp38_) {
								result = VALA_TOKEN_TYPE_ENUM;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 'l':
				{
					gchar* _tmp39_;
					gboolean _tmp40_ = FALSE;
					_tmp39_ = begin;
					_tmp40_ = vala_scanner_matches (_tmp39_, "lock");
					if (_tmp40_) {
						result = VALA_TOKEN_TYPE_LOCK;
						return result;
					}
					break;
				}
				case 'n':
				{
					gchar* _tmp41_;
					gboolean _tmp42_ = FALSE;
					_tmp41_ = begin;
					_tmp42_ = vala_scanner_matches (_tmp41_, "null");
					if (_tmp42_) {
						result = VALA_TOKEN_TYPE_NULL;
						return result;
					}
					break;
				}
				case 't':
				{
					gchar* _tmp43_;
					gchar _tmp44_;
					_tmp43_ = begin;
					_tmp44_ = _tmp43_[1];
					switch (_tmp44_) {
						case 'h':
						{
							gchar* _tmp45_;
							gboolean _tmp46_ = FALSE;
							_tmp45_ = begin;
							_tmp46_ = vala_scanner_matches (_tmp45_, "this");
							if (_tmp46_) {
								result = VALA_TOKEN_TYPE_THIS;
								return result;
							}
							break;
						}
						case 'r':
						{
							gchar* _tmp47_;
							gboolean _tmp48_ = FALSE;
							_tmp47_ = begin;
							_tmp48_ = vala_scanner_matches (_tmp47_, "true");
							if (_tmp48_) {
								result = VALA_TOKEN_TYPE_TRUE;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 'v':
				{
					gchar* _tmp49_;
					gboolean _tmp50_ = FALSE;
					_tmp49_ = begin;
					_tmp50_ = vala_scanner_matches (_tmp49_, "void");
					if (_tmp50_) {
						result = VALA_TOKEN_TYPE_VOID;
						return result;
					}
					break;
				}
				case 'w':
				{
					gchar* _tmp51_;
					gboolean _tmp52_ = FALSE;
					_tmp51_ = begin;
					_tmp52_ = vala_scanner_matches (_tmp51_, "weak");
					if (_tmp52_) {
						result = VALA_TOKEN_TYPE_WEAK;
						return result;
					}
					break;
				}
				default:
				break;
			}
			break;
		}
		case 5:
		{
			gchar* _tmp53_;
			gchar _tmp54_;
			_tmp53_ = begin;
			_tmp54_ = _tmp53_[0];
			switch (_tmp54_) {
				case 'a':
				{
					gchar* _tmp55_;
					gboolean _tmp56_ = FALSE;
					_tmp55_ = begin;
					_tmp56_ = vala_scanner_matches (_tmp55_, "async");
					if (_tmp56_) {
						result = VALA_TOKEN_TYPE_ASYNC;
						return result;
					}
					break;
				}
				case 'b':
				{
					gchar* _tmp57_;
					gboolean _tmp58_ = FALSE;
					_tmp57_ = begin;
					_tmp58_ = vala_scanner_matches (_tmp57_, "break");
					if (_tmp58_) {
						result = VALA_TOKEN_TYPE_BREAK;
						return result;
					}
					break;
				}
				case 'c':
				{
					gchar* _tmp59_;
					gchar _tmp60_;
					_tmp59_ = begin;
					_tmp60_ = _tmp59_[1];
					switch (_tmp60_) {
						case 'a':
						{
							gchar* _tmp61_;
							gboolean _tmp62_ = FALSE;
							_tmp61_ = begin;
							_tmp62_ = vala_scanner_matches (_tmp61_, "catch");
							if (_tmp62_) {
								result = VALA_TOKEN_TYPE_CATCH;
								return result;
							}
							break;
						}
						case 'l':
						{
							gchar* _tmp63_;
							gboolean _tmp64_ = FALSE;
							_tmp63_ = begin;
							_tmp64_ = vala_scanner_matches (_tmp63_, "class");
							if (_tmp64_) {
								result = VALA_TOKEN_TYPE_CLASS;
								return result;
							}
							break;
						}
						case 'o':
						{
							gchar* _tmp65_;
							gboolean _tmp66_ = FALSE;
							_tmp65_ = begin;
							_tmp66_ = vala_scanner_matches (_tmp65_, "const");
							if (_tmp66_) {
								result = VALA_TOKEN_TYPE_CONST;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 'f':
				{
					gchar* _tmp67_;
					gboolean _tmp68_ = FALSE;
					_tmp67_ = begin;
					_tmp68_ = vala_scanner_matches (_tmp67_, "false");
					if (_tmp68_) {
						result = VALA_TOKEN_TYPE_FALSE;
						return result;
					}
					break;
				}
				case 'o':
				{
					gchar* _tmp69_;
					gboolean _tmp70_ = FALSE;
					_tmp69_ = begin;
					_tmp70_ = vala_scanner_matches (_tmp69_, "owned");
					if (_tmp70_) {
						result = VALA_TOKEN_TYPE_OWNED;
						return result;
					}
					break;
				}
				case 't':
				{
					gchar* _tmp71_;
					gboolean _tmp72_ = FALSE;
					_tmp71_ = begin;
					_tmp72_ = vala_scanner_matches (_tmp71_, "throw");
					if (_tmp72_) {
						result = VALA_TOKEN_TYPE_THROW;
						return result;
					}
					break;
				}
				case 'u':
				{
					gchar* _tmp73_;
					gboolean _tmp74_ = FALSE;
					_tmp73_ = begin;
					_tmp74_ = vala_scanner_matches (_tmp73_, "using");
					if (_tmp74_) {
						result = VALA_TOKEN_TYPE_USING;
						return result;
					}
					break;
				}
				case 'w':
				{
					gchar* _tmp75_;
					gboolean _tmp76_ = FALSE;
					_tmp75_ = begin;
					_tmp76_ = vala_scanner_matches (_tmp75_, "while");
					if (_tmp76_) {
						result = VALA_TOKEN_TYPE_WHILE;
						return result;
					}
					break;
				}
				case 'y':
				{
					gchar* _tmp77_;
					gboolean _tmp78_ = FALSE;
					_tmp77_ = begin;
					_tmp78_ = vala_scanner_matches (_tmp77_, "yield");
					if (_tmp78_) {
						result = VALA_TOKEN_TYPE_YIELD;
						return result;
					}
					break;
				}
				default:
				break;
			}
			break;
		}
		case 6:
		{
			gchar* _tmp79_;
			gchar _tmp80_;
			_tmp79_ = begin;
			_tmp80_ = _tmp79_[0];
			switch (_tmp80_) {
				case 'd':
				{
					gchar* _tmp81_;
					gboolean _tmp82_ = FALSE;
					_tmp81_ = begin;
					_tmp82_ = vala_scanner_matches (_tmp81_, "delete");
					if (_tmp82_) {
						result = VALA_TOKEN_TYPE_DELETE;
						return result;
					}
					break;
				}
				case 'e':
				{
					gchar* _tmp83_;
					gboolean _tmp84_ = FALSE;
					_tmp83_ = begin;
					_tmp84_ = vala_scanner_matches (_tmp83_, "extern");
					if (_tmp84_) {
						result = VALA_TOKEN_TYPE_EXTERN;
						return result;
					}
					break;
				}
				case 'i':
				{
					gchar* _tmp85_;
					gboolean _tmp86_ = FALSE;
					_tmp85_ = begin;
					_tmp86_ = vala_scanner_matches (_tmp85_, "inline");
					if (_tmp86_) {
						result = VALA_TOKEN_TYPE_INLINE;
						return result;
					}
					break;
				}
				case 'p':
				{
					gchar* _tmp87_;
					gchar _tmp88_;
					_tmp87_ = begin;
					_tmp88_ = _tmp87_[1];
					switch (_tmp88_) {
						case 'a':
						{
							gchar* _tmp89_;
							gboolean _tmp90_ = FALSE;
							_tmp89_ = begin;
							_tmp90_ = vala_scanner_matches (_tmp89_, "params");
							if (_tmp90_) {
								result = VALA_TOKEN_TYPE_PARAMS;
								return result;
							}
							break;
						}
						case 'u':
						{
							gchar* _tmp91_;
							gboolean _tmp92_ = FALSE;
							_tmp91_ = begin;
							_tmp92_ = vala_scanner_matches (_tmp91_, "public");
							if (_tmp92_) {
								result = VALA_TOKEN_TYPE_PUBLIC;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 'r':
				{
					gchar* _tmp93_;
					gboolean _tmp94_ = FALSE;
					_tmp93_ = begin;
					_tmp94_ = vala_scanner_matches (_tmp93_, "return");
					if (_tmp94_) {
						result = VALA_TOKEN_TYPE_RETURN;
						return result;
					}
					break;
				}
				case 's':
				{
					gchar* _tmp95_;
					gchar _tmp96_;
					_tmp95_ = begin;
					_tmp96_ = _tmp95_[1];
					switch (_tmp96_) {
						case 'e':
						{
							gchar* _tmp97_;
							gboolean _tmp98_ = FALSE;
							_tmp97_ = begin;
							_tmp98_ = vala_scanner_matches (_tmp97_, "sealed");
							if (_tmp98_) {
								result = VALA_TOKEN_TYPE_SEALED;
								return result;
							}
							break;
						}
						case 'i':
						{
							gchar* _tmp99_;
							gchar _tmp100_;
							_tmp99_ = begin;
							_tmp100_ = _tmp99_[2];
							switch (_tmp100_) {
								case 'g':
								{
									gchar* _tmp101_;
									gboolean _tmp102_ = FALSE;
									_tmp101_ = begin;
									_tmp102_ = vala_scanner_matches (_tmp101_, "signal");
									if (_tmp102_) {
										result = VALA_TOKEN_TYPE_SIGNAL;
										return result;
									}
									break;
								}
								case 'z':
								{
									gchar* _tmp103_;
									gboolean _tmp104_ = FALSE;
									_tmp103_ = begin;
									_tmp104_ = vala_scanner_matches (_tmp103_, "sizeof");
									if (_tmp104_) {
										result = VALA_TOKEN_TYPE_SIZEOF;
										return result;
									}
									break;
								}
								default:
								break;
							}
							break;
						}
						case 't':
						{
							gchar* _tmp105_;
							gchar _tmp106_;
							_tmp105_ = begin;
							_tmp106_ = _tmp105_[2];
							switch (_tmp106_) {
								case 'a':
								{
									gchar* _tmp107_;
									gboolean _tmp108_ = FALSE;
									_tmp107_ = begin;
									_tmp108_ = vala_scanner_matches (_tmp107_, "static");
									if (_tmp108_) {
										result = VALA_TOKEN_TYPE_STATIC;
										return result;
									}
									break;
								}
								case 'r':
								{
									gchar* _tmp109_;
									gboolean _tmp110_ = FALSE;
									_tmp109_ = begin;
									_tmp110_ = vala_scanner_matches (_tmp109_, "struct");
									if (_tmp110_) {
										result = VALA_TOKEN_TYPE_STRUCT;
										return result;
									}
									break;
								}
								default:
								break;
							}
							break;
						}
						case 'w':
						{
							gchar* _tmp111_;
							gboolean _tmp112_ = FALSE;
							_tmp111_ = begin;
							_tmp112_ = vala_scanner_matches (_tmp111_, "switch");
							if (_tmp112_) {
								result = VALA_TOKEN_TYPE_SWITCH;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 't':
				{
					gchar* _tmp113_;
					gchar _tmp114_;
					_tmp113_ = begin;
					_tmp114_ = _tmp113_[1];
					switch (_tmp114_) {
						case 'h':
						{
							gchar* _tmp115_;
							gboolean _tmp116_ = FALSE;
							_tmp115_ = begin;
							_tmp116_ = vala_scanner_matches (_tmp115_, "throws");
							if (_tmp116_) {
								result = VALA_TOKEN_TYPE_THROWS;
								return result;
							}
							break;
						}
						case 'y':
						{
							gchar* _tmp117_;
							gboolean _tmp118_ = FALSE;
							_tmp117_ = begin;
							_tmp118_ = vala_scanner_matches (_tmp117_, "typeof");
							if (_tmp118_) {
								result = VALA_TOKEN_TYPE_TYPEOF;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				default:
				break;
			}
			break;
		}
		case 7:
		{
			gchar* _tmp119_;
			gchar _tmp120_;
			_tmp119_ = begin;
			_tmp120_ = _tmp119_[0];
			switch (_tmp120_) {
				case 'd':
				{
					gchar* _tmp121_;
					gchar _tmp122_;
					_tmp121_ = begin;
					_tmp122_ = _tmp121_[1];
					switch (_tmp122_) {
						case 'e':
						{
							gchar* _tmp123_;
							gboolean _tmp124_ = FALSE;
							_tmp123_ = begin;
							_tmp124_ = vala_scanner_matches (_tmp123_, "default");
							if (_tmp124_) {
								result = VALA_TOKEN_TYPE_DEFAULT;
								return result;
							}
							break;
						}
						case 'y':
						{
							gchar* _tmp125_;
							gboolean _tmp126_ = FALSE;
							_tmp125_ = begin;
							_tmp126_ = vala_scanner_matches (_tmp125_, "dynamic");
							if (_tmp126_) {
								result = VALA_TOKEN_TYPE_DYNAMIC;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 'e':
				{
					gchar* _tmp127_;
					gboolean _tmp128_ = FALSE;
					_tmp127_ = begin;
					_tmp128_ = vala_scanner_matches (_tmp127_, "ensures");
					if (_tmp128_) {
						result = VALA_TOKEN_TYPE_ENSURES;
						return result;
					}
					break;
				}
				case 'f':
				{
					gchar* _tmp129_;
					gchar _tmp130_;
					_tmp129_ = begin;
					_tmp130_ = _tmp129_[1];
					switch (_tmp130_) {
						case 'i':
						{
							gchar* _tmp131_;
							gboolean _tmp132_ = FALSE;
							_tmp131_ = begin;
							_tmp132_ = vala_scanner_matches (_tmp131_, "finally");
							if (_tmp132_) {
								result = VALA_TOKEN_TYPE_FINALLY;
								return result;
							}
							break;
						}
						case 'o':
						{
							gchar* _tmp133_;
							gboolean _tmp134_ = FALSE;
							_tmp133_ = begin;
							_tmp134_ = vala_scanner_matches (_tmp133_, "foreach");
							if (_tmp134_) {
								result = VALA_TOKEN_TYPE_FOREACH;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 'p':
				{
					gchar* _tmp135_;
					gboolean _tmp136_ = FALSE;
					_tmp135_ = begin;
					_tmp136_ = vala_scanner_matches (_tmp135_, "private");
					if (_tmp136_) {
						result = VALA_TOKEN_TYPE_PRIVATE;
						return result;
					}
					break;
				}
				case 'u':
				{
					gchar* _tmp137_;
					gboolean _tmp138_ = FALSE;
					_tmp137_ = begin;
					_tmp138_ = vala_scanner_matches (_tmp137_, "unowned");
					if (_tmp138_) {
						result = VALA_TOKEN_TYPE_UNOWNED;
						return result;
					}
					break;
				}
				case 'v':
				{
					gchar* _tmp139_;
					gboolean _tmp140_ = FALSE;
					_tmp139_ = begin;
					_tmp140_ = vala_scanner_matches (_tmp139_, "virtual");
					if (_tmp140_) {
						result = VALA_TOKEN_TYPE_VIRTUAL;
						return result;
					}
					break;
				}
				default:
				break;
			}
			break;
		}
		case 8:
		{
			gchar* _tmp141_;
			gchar _tmp142_;
			_tmp141_ = begin;
			_tmp142_ = _tmp141_[0];
			switch (_tmp142_) {
				case 'a':
				{
					gchar* _tmp143_;
					gboolean _tmp144_ = FALSE;
					_tmp143_ = begin;
					_tmp144_ = vala_scanner_matches (_tmp143_, "abstract");
					if (_tmp144_) {
						result = VALA_TOKEN_TYPE_ABSTRACT;
						return result;
					}
					break;
				}
				case 'c':
				{
					gchar* _tmp145_;
					gboolean _tmp146_ = FALSE;
					_tmp145_ = begin;
					_tmp146_ = vala_scanner_matches (_tmp145_, "continue");
					if (_tmp146_) {
						result = VALA_TOKEN_TYPE_CONTINUE;
						return result;
					}
					break;
				}
				case 'd':
				{
					gchar* _tmp147_;
					gboolean _tmp148_ = FALSE;
					_tmp147_ = begin;
					_tmp148_ = vala_scanner_matches (_tmp147_, "delegate");
					if (_tmp148_) {
						result = VALA_TOKEN_TYPE_DELEGATE;
						return result;
					}
					break;
				}
				case 'i':
				{
					gchar* _tmp149_;
					gboolean _tmp150_ = FALSE;
					_tmp149_ = begin;
					_tmp150_ = vala_scanner_matches (_tmp149_, "internal");
					if (_tmp150_) {
						result = VALA_TOKEN_TYPE_INTERNAL;
						return result;
					}
					break;
				}
				case 'o':
				{
					gchar* _tmp151_;
					gboolean _tmp152_ = FALSE;
					_tmp151_ = begin;
					_tmp152_ = vala_scanner_matches (_tmp151_, "override");
					if (_tmp152_) {
						result = VALA_TOKEN_TYPE_OVERRIDE;
						return result;
					}
					break;
				}
				case 'r':
				{
					gchar* _tmp153_;
					gboolean _tmp154_ = FALSE;
					_tmp153_ = begin;
					_tmp154_ = vala_scanner_matches (_tmp153_, "requires");
					if (_tmp154_) {
						result = VALA_TOKEN_TYPE_REQUIRES;
						return result;
					}
					break;
				}
				case 'v':
				{
					gchar* _tmp155_;
					gboolean _tmp156_ = FALSE;
					_tmp155_ = begin;
					_tmp156_ = vala_scanner_matches (_tmp155_, "volatile");
					if (_tmp156_) {
						result = VALA_TOKEN_TYPE_VOLATILE;
						return result;
					}
					break;
				}
				default:
				break;
			}
			break;
		}
		case 9:
		{
			gchar* _tmp157_;
			gchar _tmp158_;
			_tmp157_ = begin;
			_tmp158_ = _tmp157_[0];
			switch (_tmp158_) {
				case 'c':
				{
					gchar* _tmp159_;
					gboolean _tmp160_ = FALSE;
					_tmp159_ = begin;
					_tmp160_ = vala_scanner_matches (_tmp159_, "construct");
					if (_tmp160_) {
						result = VALA_TOKEN_TYPE_CONSTRUCT;
						return result;
					}
					break;
				}
				case 'i':
				{
					gchar* _tmp161_;
					gboolean _tmp162_ = FALSE;
					_tmp161_ = begin;
					_tmp162_ = vala_scanner_matches (_tmp161_, "interface");
					if (_tmp162_) {
						result = VALA_TOKEN_TYPE_INTERFACE;
						return result;
					}
					break;
				}
				case 'n':
				{
					gchar* _tmp163_;
					gboolean _tmp164_ = FALSE;
					_tmp163_ = begin;
					_tmp164_ = vala_scanner_matches (_tmp163_, "namespace");
					if (_tmp164_) {
						result = VALA_TOKEN_TYPE_NAMESPACE;
						return result;
					}
					break;
				}
				case 'p':
				{
					gchar* _tmp165_;
					gboolean _tmp166_ = FALSE;
					_tmp165_ = begin;
					_tmp166_ = vala_scanner_matches (_tmp165_, "protected");
					if (_tmp166_) {
						result = VALA_TOKEN_TYPE_PROTECTED;
						return result;
					}
					break;
				}
				default:
				break;
			}
			break;
		}
		case 11:
		{
			gchar* _tmp167_;
			gboolean _tmp168_ = FALSE;
			_tmp167_ = begin;
			_tmp168_ = vala_scanner_matches (_tmp167_, "errordomain");
			if (_tmp168_) {
				result = VALA_TOKEN_TYPE_ERRORDOMAIN;
				return result;
			}
			break;
		}
		default:
		break;
	}
	result = VALA_TOKEN_TYPE_IDENTIFIER;
	return result;
}


static ValaTokenType vala_scanner_read_number (ValaScanner* self) {
	ValaTokenType result = 0;
	ValaTokenType type;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gboolean _tmp7_;
	gboolean _tmp10_;
	gboolean _tmp14_;
	gboolean _tmp32_ = FALSE;
	gboolean _tmp33_ = FALSE;
	gchar* _tmp34_;
	gchar* _tmp35_;
	gboolean _tmp38_;
	gboolean _tmp42_;
	gboolean _tmp52_ = FALSE;
	gchar* _tmp53_;
	gchar* _tmp54_;
	gboolean _tmp58_;
	gchar* _tmp79_;
	gchar* _tmp80_;
	g_return_val_if_fail (self != NULL, 0);
	type = VALA_TOKEN_TYPE_INTEGER_LITERAL;
	_tmp3_ = self->priv->current;
	_tmp4_ = self->priv->end;
	if (_tmp3_ < (_tmp4_ - 2)) {
		gchar* _tmp5_;
		gchar _tmp6_;
		_tmp5_ = self->priv->current;
		_tmp6_ = _tmp5_[0];
		_tmp2_ = _tmp6_ == '0';
	} else {
		_tmp2_ = FALSE;
	}
	_tmp7_ = _tmp2_;
	if (_tmp7_) {
		gchar* _tmp8_;
		gchar _tmp9_;
		_tmp8_ = self->priv->current;
		_tmp9_ = _tmp8_[1];
		_tmp1_ = _tmp9_ == 'x';
	} else {
		_tmp1_ = FALSE;
	}
	_tmp10_ = _tmp1_;
	if (_tmp10_) {
		gchar* _tmp11_;
		gchar _tmp12_;
		gboolean _tmp13_ = FALSE;
		_tmp11_ = self->priv->current;
		_tmp12_ = _tmp11_[2];
		_tmp13_ = g_ascii_isxdigit (_tmp12_);
		_tmp0_ = _tmp13_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp14_ = _tmp0_;
	if (_tmp14_) {
		gchar* _tmp15_;
		_tmp15_ = self->priv->current;
		self->priv->current = _tmp15_ + 2;
		while (TRUE) {
			gboolean _tmp16_ = FALSE;
			gchar* _tmp17_;
			gchar* _tmp18_;
			gboolean _tmp22_;
			gchar* _tmp23_;
			_tmp17_ = self->priv->current;
			_tmp18_ = self->priv->end;
			if (_tmp17_ < _tmp18_) {
				gchar* _tmp19_;
				gchar _tmp20_;
				gboolean _tmp21_ = FALSE;
				_tmp19_ = self->priv->current;
				_tmp20_ = _tmp19_[0];
				_tmp21_ = g_ascii_isxdigit (_tmp20_);
				_tmp16_ = _tmp21_;
			} else {
				_tmp16_ = FALSE;
			}
			_tmp22_ = _tmp16_;
			if (!_tmp22_) {
				break;
			}
			_tmp23_ = self->priv->current;
			self->priv->current = _tmp23_ + 1;
		}
	} else {
		while (TRUE) {
			gboolean _tmp24_ = FALSE;
			gchar* _tmp25_;
			gchar* _tmp26_;
			gboolean _tmp30_;
			gchar* _tmp31_;
			_tmp25_ = self->priv->current;
			_tmp26_ = self->priv->end;
			if (_tmp25_ < _tmp26_) {
				gchar* _tmp27_;
				gchar _tmp28_;
				gboolean _tmp29_ = FALSE;
				_tmp27_ = self->priv->current;
				_tmp28_ = _tmp27_[0];
				_tmp29_ = g_ascii_isdigit (_tmp28_);
				_tmp24_ = _tmp29_;
			} else {
				_tmp24_ = FALSE;
			}
			_tmp30_ = _tmp24_;
			if (!_tmp30_) {
				break;
			}
			_tmp31_ = self->priv->current;
			self->priv->current = _tmp31_ + 1;
		}
	}
	_tmp34_ = self->priv->current;
	_tmp35_ = self->priv->end;
	if (_tmp34_ < (_tmp35_ - 1)) {
		gchar* _tmp36_;
		gchar _tmp37_;
		_tmp36_ = self->priv->current;
		_tmp37_ = _tmp36_[0];
		_tmp33_ = _tmp37_ == '.';
	} else {
		_tmp33_ = FALSE;
	}
	_tmp38_ = _tmp33_;
	if (_tmp38_) {
		gchar* _tmp39_;
		gchar _tmp40_;
		gboolean _tmp41_ = FALSE;
		_tmp39_ = self->priv->current;
		_tmp40_ = _tmp39_[1];
		_tmp41_ = g_ascii_isdigit (_tmp40_);
		_tmp32_ = _tmp41_;
	} else {
		_tmp32_ = FALSE;
	}
	_tmp42_ = _tmp32_;
	if (_tmp42_) {
		gchar* _tmp43_;
		type = VALA_TOKEN_TYPE_REAL_LITERAL;
		_tmp43_ = self->priv->current;
		self->priv->current = _tmp43_ + 1;
		while (TRUE) {
			gboolean _tmp44_ = FALSE;
			gchar* _tmp45_;
			gchar* _tmp46_;
			gboolean _tmp50_;
			gchar* _tmp51_;
			_tmp45_ = self->priv->current;
			_tmp46_ = self->priv->end;
			if (_tmp45_ < _tmp46_) {
				gchar* _tmp47_;
				gchar _tmp48_;
				gboolean _tmp49_ = FALSE;
				_tmp47_ = self->priv->current;
				_tmp48_ = _tmp47_[0];
				_tmp49_ = g_ascii_isdigit (_tmp48_);
				_tmp44_ = _tmp49_;
			} else {
				_tmp44_ = FALSE;
			}
			_tmp50_ = _tmp44_;
			if (!_tmp50_) {
				break;
			}
			_tmp51_ = self->priv->current;
			self->priv->current = _tmp51_ + 1;
		}
	}
	_tmp53_ = self->priv->current;
	_tmp54_ = self->priv->end;
	if (_tmp53_ < _tmp54_) {
		gchar* _tmp55_;
		gchar _tmp56_;
		gchar _tmp57_ = '\0';
		_tmp55_ = self->priv->current;
		_tmp56_ = _tmp55_[0];
		_tmp57_ = g_ascii_tolower (_tmp56_);
		_tmp52_ = _tmp57_ == 'e';
	} else {
		_tmp52_ = FALSE;
	}
	_tmp58_ = _tmp52_;
	if (_tmp58_) {
		gchar* _tmp59_;
		gboolean _tmp60_ = FALSE;
		gchar* _tmp61_;
		gchar* _tmp62_;
		gboolean _tmp69_;
		type = VALA_TOKEN_TYPE_REAL_LITERAL;
		_tmp59_ = self->priv->current;
		self->priv->current = _tmp59_ + 1;
		_tmp61_ = self->priv->current;
		_tmp62_ = self->priv->end;
		if (_tmp61_ < _tmp62_) {
			gboolean _tmp63_ = FALSE;
			gchar* _tmp64_;
			gchar _tmp65_;
			gboolean _tmp68_;
			_tmp64_ = self->priv->current;
			_tmp65_ = _tmp64_[0];
			if (_tmp65_ == '+') {
				_tmp63_ = TRUE;
			} else {
				gchar* _tmp66_;
				gchar _tmp67_;
				_tmp66_ = self->priv->current;
				_tmp67_ = _tmp66_[0];
				_tmp63_ = _tmp67_ == '-';
			}
			_tmp68_ = _tmp63_;
			_tmp60_ = _tmp68_;
		} else {
			_tmp60_ = FALSE;
		}
		_tmp69_ = _tmp60_;
		if (_tmp69_) {
			gchar* _tmp70_;
			_tmp70_ = self->priv->current;
			self->priv->current = _tmp70_ + 1;
		}
		while (TRUE) {
			gboolean _tmp71_ = FALSE;
			gchar* _tmp72_;
			gchar* _tmp73_;
			gboolean _tmp77_;
			gchar* _tmp78_;
			_tmp72_ = self->priv->current;
			_tmp73_ = self->priv->end;
			if (_tmp72_ < _tmp73_) {
				gchar* _tmp74_;
				gchar _tmp75_;
				gboolean _tmp76_ = FALSE;
				_tmp74_ = self->priv->current;
				_tmp75_ = _tmp74_[0];
				_tmp76_ = g_ascii_isdigit (_tmp75_);
				_tmp71_ = _tmp76_;
			} else {
				_tmp71_ = FALSE;
			}
			_tmp77_ = _tmp71_;
			if (!_tmp77_) {
				break;
			}
			_tmp78_ = self->priv->current;
			self->priv->current = _tmp78_ + 1;
		}
	}
	_tmp79_ = self->priv->current;
	_tmp80_ = self->priv->end;
	if (_tmp79_ < _tmp80_) {
		ValaTokenType _tmp81_;
		gboolean real_literal;
		gchar* _tmp82_;
		gchar _tmp83_;
		gboolean _tmp113_ = FALSE;
		gboolean _tmp114_;
		gboolean _tmp118_;
		_tmp81_ = type;
		real_literal = _tmp81_ == VALA_TOKEN_TYPE_REAL_LITERAL;
		_tmp82_ = self->priv->current;
		_tmp83_ = _tmp82_[0];
		switch (_tmp83_) {
			case 'l':
			case 'L':
			{
				ValaTokenType _tmp84_;
				_tmp84_ = type;
				if (_tmp84_ == VALA_TOKEN_TYPE_INTEGER_LITERAL) {
					gchar* _tmp85_;
					gboolean _tmp86_ = FALSE;
					gchar* _tmp87_;
					gchar* _tmp88_;
					gboolean _tmp92_;
					_tmp85_ = self->priv->current;
					self->priv->current = _tmp85_ + 1;
					_tmp87_ = self->priv->current;
					_tmp88_ = self->priv->end;
					if (_tmp87_ < _tmp88_) {
						gchar* _tmp89_;
						gchar _tmp90_;
						gchar _tmp91_ = '\0';
						_tmp89_ = self->priv->current;
						_tmp90_ = _tmp89_[0];
						_tmp91_ = g_ascii_tolower (_tmp90_);
						_tmp86_ = _tmp91_ == 'l';
					} else {
						_tmp86_ = FALSE;
					}
					_tmp92_ = _tmp86_;
					if (_tmp92_) {
						gchar* _tmp93_;
						_tmp93_ = self->priv->current;
						self->priv->current = _tmp93_ + 1;
					}
				}
				break;
			}
			case 'u':
			case 'U':
			{
				ValaTokenType _tmp94_;
				_tmp94_ = type;
				if (_tmp94_ == VALA_TOKEN_TYPE_INTEGER_LITERAL) {
					gchar* _tmp95_;
					gboolean _tmp96_ = FALSE;
					gchar* _tmp97_;
					gchar* _tmp98_;
					gboolean _tmp102_;
					_tmp95_ = self->priv->current;
					self->priv->current = _tmp95_ + 1;
					_tmp97_ = self->priv->current;
					_tmp98_ = self->priv->end;
					if (_tmp97_ < _tmp98_) {
						gchar* _tmp99_;
						gchar _tmp100_;
						gchar _tmp101_ = '\0';
						_tmp99_ = self->priv->current;
						_tmp100_ = _tmp99_[0];
						_tmp101_ = g_ascii_tolower (_tmp100_);
						_tmp96_ = _tmp101_ == 'l';
					} else {
						_tmp96_ = FALSE;
					}
					_tmp102_ = _tmp96_;
					if (_tmp102_) {
						gchar* _tmp103_;
						gboolean _tmp104_ = FALSE;
						gchar* _tmp105_;
						gchar* _tmp106_;
						gboolean _tmp110_;
						_tmp103_ = self->priv->current;
						self->priv->current = _tmp103_ + 1;
						_tmp105_ = self->priv->current;
						_tmp106_ = self->priv->end;
						if (_tmp105_ < _tmp106_) {
							gchar* _tmp107_;
							gchar _tmp108_;
							gchar _tmp109_ = '\0';
							_tmp107_ = self->priv->current;
							_tmp108_ = _tmp107_[0];
							_tmp109_ = g_ascii_tolower (_tmp108_);
							_tmp104_ = _tmp109_ == 'l';
						} else {
							_tmp104_ = FALSE;
						}
						_tmp110_ = _tmp104_;
						if (_tmp110_) {
							gchar* _tmp111_;
							_tmp111_ = self->priv->current;
							self->priv->current = _tmp111_ + 1;
						}
					}
				}
				break;
			}
			case 'f':
			case 'F':
			case 'd':
			case 'D':
			{
				gchar* _tmp112_;
				type = VALA_TOKEN_TYPE_REAL_LITERAL;
				_tmp112_ = self->priv->current;
				self->priv->current = _tmp112_ + 1;
				break;
			}
			default:
			break;
		}
		_tmp114_ = real_literal;
		if (!_tmp114_) {
			gchar* _tmp115_;
			gchar _tmp116_;
			gboolean _tmp117_ = FALSE;
			_tmp115_ = self->priv->current;
			_tmp116_ = _tmp115_[0];
			_tmp117_ = vala_scanner_is_ident_char (self, _tmp116_);
			_tmp113_ = _tmp117_;
		} else {
			_tmp113_ = FALSE;
		}
		_tmp118_ = _tmp113_;
		if (_tmp118_) {
			while (TRUE) {
				gboolean _tmp119_ = FALSE;
				gchar* _tmp120_;
				gchar* _tmp121_;
				gboolean _tmp125_;
				gchar* _tmp126_;
				_tmp120_ = self->priv->current;
				_tmp121_ = self->priv->end;
				if (_tmp120_ < _tmp121_) {
					gchar* _tmp122_;
					gchar _tmp123_;
					gboolean _tmp124_ = FALSE;
					_tmp122_ = self->priv->current;
					_tmp123_ = _tmp122_[0];
					_tmp124_ = vala_scanner_is_ident_char (self, _tmp123_);
					_tmp119_ = _tmp124_;
				} else {
					_tmp119_ = FALSE;
				}
				_tmp125_ = _tmp119_;
				if (!_tmp125_) {
					break;
				}
				_tmp126_ = self->priv->current;
				self->priv->current = _tmp126_ + 1;
			}
			type = VALA_TOKEN_TYPE_IDENTIFIER;
		}
	}
	result = type;
	return result;
}


static void _vala_array_add13 (ValaScannerState** array, int* length, int* size, ValaScannerState value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaScannerState, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void _vala_array_add14 (ValaScannerState** array, int* length, int* size, ValaScannerState value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaScannerState, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void _vala_array_add15 (ValaScannerState** array, int* length, int* size, ValaScannerState value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaScannerState, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void _vala_array_add16 (ValaScannerState** array, int* length, int* size, ValaScannerState value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaScannerState, *array, *size);
	}
	(*array)[(*length)++] = value;
}


ValaTokenType vala_scanner_read_template_token (ValaScanner* self, ValaSourceLocation* token_begin, ValaSourceLocation* token_end) {
	ValaSourceLocation _vala_token_begin = {0};
	ValaSourceLocation _vala_token_end = {0};
	ValaTokenType result = 0;
	ValaTokenType type = 0;
	gchar* _tmp0_;
	gchar* begin;
	gchar* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	ValaSourceLocation _tmp4_ = {0};
	gint token_length_in_chars;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gint _tmp131_;
	gchar* _tmp137_;
	gint _tmp138_;
	gint _tmp139_;
	ValaSourceLocation _tmp140_ = {0};
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->current;
	begin = _tmp0_;
	_tmp1_ = begin;
	_tmp2_ = self->priv->line;
	_tmp3_ = self->priv->column;
	vala_source_location_init (&_tmp4_, _tmp1_, _tmp2_, _tmp3_);
	_vala_token_begin = _tmp4_;
	token_length_in_chars = -1;
	_tmp5_ = self->priv->current;
	_tmp6_ = self->priv->end;
	if (_tmp5_ >= _tmp6_) {
		type = VALA_TOKEN_TYPE_EOF;
	} else {
		gchar* _tmp7_;
		gchar _tmp8_;
		_tmp7_ = self->priv->current;
		_tmp8_ = _tmp7_[0];
		switch (_tmp8_) {
			case '"':
			{
				gchar* _tmp9_;
				gint _tmp10_;
				type = VALA_TOKEN_TYPE_CLOSE_TEMPLATE;
				_tmp9_ = self->priv->current;
				self->priv->current = _tmp9_ + 1;
				_tmp10_ = self->priv->state_stack_length1;
				self->priv->state_stack_length1 = _tmp10_ - 1;
				break;
			}
			case '$':
			{
				gchar* _tmp11_;
				gchar* _tmp12_;
				gboolean _tmp13_ = FALSE;
				gchar* _tmp14_;
				gchar _tmp15_;
				gboolean _tmp16_ = FALSE;
				gboolean _tmp19_;
				_tmp11_ = _vala_token_begin.pos;
				_vala_token_begin.pos = _tmp11_ + 1;
				_tmp12_ = self->priv->current;
				self->priv->current = _tmp12_ + 1;
				_tmp14_ = self->priv->current;
				_tmp15_ = _tmp14_[0];
				_tmp16_ = g_ascii_isalpha (_tmp15_);
				if (_tmp16_) {
					_tmp13_ = TRUE;
				} else {
					gchar* _tmp17_;
					gchar _tmp18_;
					_tmp17_ = self->priv->current;
					_tmp18_ = _tmp17_[0];
					_tmp13_ = _tmp18_ == '_';
				}
				_tmp19_ = _tmp13_;
				if (_tmp19_) {
					gint len;
					ValaScannerState* _tmp29_;
					gint _tmp29__length1;
					len = 0;
					while (TRUE) {
						gboolean _tmp20_ = FALSE;
						gchar* _tmp21_;
						gchar* _tmp22_;
						gboolean _tmp26_;
						gchar* _tmp27_;
						gint _tmp28_;
						_tmp21_ = self->priv->current;
						_tmp22_ = self->priv->end;
						if (_tmp21_ < _tmp22_) {
							gchar* _tmp23_;
							gchar _tmp24_;
							gboolean _tmp25_ = FALSE;
							_tmp23_ = self->priv->current;
							_tmp24_ = _tmp23_[0];
							_tmp25_ = vala_scanner_is_ident_char (self, _tmp24_);
							_tmp20_ = _tmp25_;
						} else {
							_tmp20_ = FALSE;
						}
						_tmp26_ = _tmp20_;
						if (!_tmp26_) {
							break;
						}
						_tmp27_ = self->priv->current;
						self->priv->current = _tmp27_ + 1;
						_tmp28_ = len;
						len = _tmp28_ + 1;
					}
					type = VALA_TOKEN_TYPE_IDENTIFIER;
					_tmp29_ = self->priv->state_stack;
					_tmp29__length1 = self->priv->state_stack_length1;
					_vala_array_add13 (&self->priv->state_stack, &self->priv->state_stack_length1, &self->priv->_state_stack_size_, VALA_SCANNER_STATE_TEMPLATE_PART);
				} else {
					gchar* _tmp30_;
					gchar _tmp31_;
					_tmp30_ = self->priv->current;
					_tmp31_ = _tmp30_[0];
					if (_tmp31_ == '(') {
						gchar* _tmp32_;
						gint _tmp33_;
						ValaScannerState* _tmp34_;
						gint _tmp34__length1;
						ValaSourceLocation _tmp35_ = {0};
						ValaSourceLocation _tmp36_ = {0};
						ValaTokenType _tmp37_ = 0;
						_tmp32_ = self->priv->current;
						self->priv->current = _tmp32_ + 1;
						_tmp33_ = self->priv->column;
						self->priv->column = _tmp33_ + 2;
						_tmp34_ = self->priv->state_stack;
						_tmp34__length1 = self->priv->state_stack_length1;
						_vala_array_add14 (&self->priv->state_stack, &self->priv->state_stack_length1, &self->priv->_state_stack_size_, VALA_SCANNER_STATE_PARENS);
						_tmp37_ = vala_scanner_read_token (self, &_tmp35_, &_tmp36_);
						_vala_token_begin = _tmp35_;
						_vala_token_end = _tmp36_;
						result = _tmp37_;
						if (token_begin) {
							*token_begin = _vala_token_begin;
						}
						if (token_end) {
							*token_end = _vala_token_end;
						}
						return result;
					} else {
						gchar* _tmp38_;
						gchar _tmp39_;
						_tmp38_ = self->priv->current;
						_tmp39_ = _tmp38_[0];
						if (_tmp39_ == '$') {
							gchar* _tmp40_;
							ValaScannerState* _tmp41_;
							gint _tmp41__length1;
							type = VALA_TOKEN_TYPE_TEMPLATE_STRING_LITERAL;
							_tmp40_ = self->priv->current;
							self->priv->current = _tmp40_ + 1;
							_tmp41_ = self->priv->state_stack;
							_tmp41__length1 = self->priv->state_stack_length1;
							_vala_array_add15 (&self->priv->state_stack, &self->priv->state_stack_length1, &self->priv->_state_stack_size_, VALA_SCANNER_STATE_TEMPLATE_PART);
						} else {
							ValaSourceFile* _tmp42_;
							gint _tmp43_;
							gint _tmp44_;
							gint _tmp45_;
							gint _tmp46_;
							ValaSourceReference* _tmp47_;
							ValaSourceReference* _tmp48_;
							ValaSourceLocation _tmp49_ = {0};
							ValaSourceLocation _tmp50_ = {0};
							ValaTokenType _tmp51_ = 0;
							_tmp42_ = self->priv->_source_file;
							_tmp43_ = self->priv->line;
							_tmp44_ = self->priv->column;
							_tmp45_ = self->priv->line;
							_tmp46_ = self->priv->column;
							_tmp47_ = vala_source_reference_new (_tmp42_, _tmp43_, _tmp44_ + 1, _tmp45_, _tmp46_ + 1);
							_tmp48_ = _tmp47_;
							vala_report_error (_tmp48_, "unexpected character");
							_vala_source_reference_unref0 (_tmp48_);
							_tmp51_ = vala_scanner_read_template_token (self, &_tmp49_, &_tmp50_);
							_vala_token_begin = _tmp49_;
							_vala_token_end = _tmp50_;
							result = _tmp51_;
							if (token_begin) {
								*token_begin = _vala_token_begin;
							}
							if (token_end) {
								*token_end = _vala_token_end;
							}
							return result;
						}
					}
				}
				break;
			}
			default:
			{
				gchar* _tmp115_;
				gchar* _tmp116_;
				ValaScannerState* _tmp130_;
				gint _tmp130__length1;
				type = VALA_TOKEN_TYPE_TEMPLATE_STRING_LITERAL;
				token_length_in_chars = 0;
				while (TRUE) {
					gboolean _tmp52_ = FALSE;
					gboolean _tmp53_ = FALSE;
					gchar* _tmp54_;
					gchar* _tmp55_;
					gboolean _tmp58_;
					gboolean _tmp61_;
					gchar* _tmp62_;
					gchar _tmp63_;
					_tmp54_ = self->priv->current;
					_tmp55_ = self->priv->end;
					if (_tmp54_ < _tmp55_) {
						gchar* _tmp56_;
						gchar _tmp57_;
						_tmp56_ = self->priv->current;
						_tmp57_ = _tmp56_[0];
						_tmp53_ = _tmp57_ != '"';
					} else {
						_tmp53_ = FALSE;
					}
					_tmp58_ = _tmp53_;
					if (_tmp58_) {
						gchar* _tmp59_;
						gchar _tmp60_;
						_tmp59_ = self->priv->current;
						_tmp60_ = _tmp59_[0];
						_tmp52_ = _tmp60_ != '$';
					} else {
						_tmp52_ = FALSE;
					}
					_tmp61_ = _tmp52_;
					if (!_tmp61_) {
						break;
					}
					_tmp62_ = self->priv->current;
					_tmp63_ = _tmp62_[0];
					if (_tmp63_ == '\\') {
						gchar* _tmp64_;
						gint _tmp65_;
						gchar* _tmp66_;
						gchar* _tmp67_;
						gchar* _tmp68_;
						gchar _tmp69_;
						_tmp64_ = self->priv->current;
						self->priv->current = _tmp64_ + 1;
						_tmp65_ = token_length_in_chars;
						token_length_in_chars = _tmp65_ + 1;
						_tmp66_ = self->priv->current;
						_tmp67_ = self->priv->end;
						if (_tmp66_ >= _tmp67_) {
							break;
						}
						_tmp68_ = self->priv->current;
						_tmp69_ = _tmp68_[0];
						switch (_tmp69_) {
							case '\'':
							case '"':
							case '\\':
							case '0':
							case 'b':
							case 'f':
							case 'n':
							case 'r':
							case 't':
							{
								gchar* _tmp70_;
								gint _tmp71_;
								_tmp70_ = self->priv->current;
								self->priv->current = _tmp70_ + 1;
								_tmp71_ = token_length_in_chars;
								token_length_in_chars = _tmp71_ + 1;
								break;
							}
							case 'x':
							{
								gchar* _tmp72_;
								gint _tmp73_;
								_tmp72_ = self->priv->current;
								self->priv->current = _tmp72_ + 1;
								_tmp73_ = token_length_in_chars;
								token_length_in_chars = _tmp73_ + 1;
								while (TRUE) {
									gboolean _tmp74_ = FALSE;
									gchar* _tmp75_;
									gchar* _tmp76_;
									gboolean _tmp80_;
									gchar* _tmp81_;
									gint _tmp82_;
									_tmp75_ = self->priv->current;
									_tmp76_ = self->priv->end;
									if (_tmp75_ < _tmp76_) {
										gchar* _tmp77_;
										gchar _tmp78_;
										gboolean _tmp79_ = FALSE;
										_tmp77_ = self->priv->current;
										_tmp78_ = _tmp77_[0];
										_tmp79_ = g_ascii_isxdigit (_tmp78_);
										_tmp74_ = _tmp79_;
									} else {
										_tmp74_ = FALSE;
									}
									_tmp80_ = _tmp74_;
									if (!_tmp80_) {
										break;
									}
									_tmp81_ = self->priv->current;
									self->priv->current = _tmp81_ + 1;
									_tmp82_ = token_length_in_chars;
									token_length_in_chars = _tmp82_ + 1;
								}
								break;
							}
							default:
							{
								ValaSourceFile* _tmp83_;
								gint _tmp84_;
								gint _tmp85_;
								gint _tmp86_;
								gint _tmp87_;
								gint _tmp88_;
								gint _tmp89_;
								ValaSourceReference* _tmp90_;
								ValaSourceReference* _tmp91_;
								_tmp83_ = self->priv->_source_file;
								_tmp84_ = self->priv->line;
								_tmp85_ = self->priv->column;
								_tmp86_ = token_length_in_chars;
								_tmp87_ = self->priv->line;
								_tmp88_ = self->priv->column;
								_tmp89_ = token_length_in_chars;
								_tmp90_ = vala_source_reference_new (_tmp83_, _tmp84_, _tmp85_ + _tmp86_, _tmp87_, _tmp88_ + _tmp89_);
								_tmp91_ = _tmp90_;
								vala_report_error (_tmp91_, "invalid escape sequence");
								_vala_source_reference_unref0 (_tmp91_);
								break;
							}
						}
					} else {
						gchar* _tmp92_;
						gchar _tmp93_;
						_tmp92_ = self->priv->current;
						_tmp93_ = _tmp92_[0];
						if (_tmp93_ == '\n') {
							gchar* _tmp94_;
							gint _tmp95_;
							_tmp94_ = self->priv->current;
							self->priv->current = _tmp94_ + 1;
							_tmp95_ = self->priv->line;
							self->priv->line = _tmp95_ + 1;
							self->priv->column = 1;
							token_length_in_chars = 1;
						} else {
							gchar* _tmp96_;
							gchar* _tmp97_;
							gchar* _tmp98_;
							gunichar _tmp99_ = 0U;
							gunichar u;
							gunichar _tmp100_;
							_tmp96_ = self->priv->current;
							_tmp97_ = self->priv->end;
							_tmp98_ = self->priv->current;
							_tmp99_ = g_utf8_get_char_validated ((const gchar*) _tmp96_, (gssize) ((glong) (_tmp97_ - _tmp98_)));
							u = _tmp99_;
							_tmp100_ = u;
							if (_tmp100_ != ((gunichar) (-1))) {
								gchar* _tmp101_;
								gunichar _tmp102_;
								gint _tmp103_ = 0;
								gint _tmp104_;
								_tmp101_ = self->priv->current;
								_tmp102_ = u;
								_tmp103_ = g_unichar_to_utf8 (_tmp102_, NULL);
								self->priv->current = _tmp101_ + _tmp103_;
								_tmp104_ = token_length_in_chars;
								token_length_in_chars = _tmp104_ + 1;
							} else {
								gchar* _tmp105_;
								ValaSourceFile* _tmp106_;
								gint _tmp107_;
								gint _tmp108_;
								gint _tmp109_;
								gint _tmp110_;
								gint _tmp111_;
								gint _tmp112_;
								ValaSourceReference* _tmp113_;
								ValaSourceReference* _tmp114_;
								_tmp105_ = self->priv->current;
								self->priv->current = _tmp105_ + 1;
								_tmp106_ = self->priv->_source_file;
								_tmp107_ = self->priv->line;
								_tmp108_ = self->priv->column;
								_tmp109_ = token_length_in_chars;
								_tmp110_ = self->priv->line;
								_tmp111_ = self->priv->column;
								_tmp112_ = token_length_in_chars;
								_tmp113_ = vala_source_reference_new (_tmp106_, _tmp107_, _tmp108_ + _tmp109_, _tmp110_, _tmp111_ + _tmp112_);
								_tmp114_ = _tmp113_;
								vala_report_error (_tmp114_, "invalid UTF-8 character");
								_vala_source_reference_unref0 (_tmp114_);
							}
						}
					}
				}
				_tmp115_ = self->priv->current;
				_tmp116_ = self->priv->end;
				if (_tmp115_ >= _tmp116_) {
					ValaSourceFile* _tmp117_;
					gint _tmp118_;
					gint _tmp119_;
					gint _tmp120_;
					gint _tmp121_;
					gint _tmp122_;
					gint _tmp123_;
					ValaSourceReference* _tmp124_;
					ValaSourceReference* _tmp125_;
					gint _tmp126_;
					ValaSourceLocation _tmp127_ = {0};
					ValaSourceLocation _tmp128_ = {0};
					ValaTokenType _tmp129_ = 0;
					_tmp117_ = self->priv->_source_file;
					_tmp118_ = self->priv->line;
					_tmp119_ = self->priv->column;
					_tmp120_ = token_length_in_chars;
					_tmp121_ = self->priv->line;
					_tmp122_ = self->priv->column;
					_tmp123_ = token_length_in_chars;
					_tmp124_ = vala_source_reference_new (_tmp117_, _tmp118_, _tmp119_ + _tmp120_, _tmp121_, _tmp122_ + _tmp123_);
					_tmp125_ = _tmp124_;
					vala_report_error (_tmp125_, "syntax error, expected \"");
					_vala_source_reference_unref0 (_tmp125_);
					_tmp126_ = self->priv->state_stack_length1;
					self->priv->state_stack_length1 = _tmp126_ - 1;
					_tmp129_ = vala_scanner_read_token (self, &_tmp127_, &_tmp128_);
					_vala_token_begin = _tmp127_;
					_vala_token_end = _tmp128_;
					result = _tmp129_;
					if (token_begin) {
						*token_begin = _vala_token_begin;
					}
					if (token_end) {
						*token_end = _vala_token_end;
					}
					return result;
				}
				_tmp130_ = self->priv->state_stack;
				_tmp130__length1 = self->priv->state_stack_length1;
				_vala_array_add16 (&self->priv->state_stack, &self->priv->state_stack_length1, &self->priv->_state_stack_size_, VALA_SCANNER_STATE_TEMPLATE_PART);
				break;
			}
		}
	}
	_tmp131_ = token_length_in_chars;
	if (_tmp131_ < 0) {
		gint _tmp132_;
		gchar* _tmp133_;
		gchar* _tmp134_;
		_tmp132_ = self->priv->column;
		_tmp133_ = self->priv->current;
		_tmp134_ = begin;
		self->priv->column = _tmp132_ + ((gint) (_tmp133_ - _tmp134_));
	} else {
		gint _tmp135_;
		gint _tmp136_;
		_tmp135_ = self->priv->column;
		_tmp136_ = token_length_in_chars;
		self->priv->column = _tmp135_ + _tmp136_;
	}
	_tmp137_ = self->priv->current;
	_tmp138_ = self->priv->line;
	_tmp139_ = self->priv->column;
	vala_source_location_init (&_tmp140_, _tmp137_, _tmp138_, _tmp139_ - 1);
	_vala_token_end = _tmp140_;
	result = type;
	if (token_begin) {
		*token_begin = _vala_token_begin;
	}
	if (token_end) {
		*token_end = _vala_token_end;
	}
	return result;
}


static void _vala_array_add17 (ValaScannerState** array, int* length, int* size, ValaScannerState value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaScannerState, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void _vala_array_add18 (ValaScannerState** array, int* length, int* size, ValaScannerState value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaScannerState, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void _vala_array_add19 (ValaScannerState** array, int* length, int* size, ValaScannerState value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaScannerState, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void _vala_array_add20 (ValaScannerState** array, int* length, int* size, ValaScannerState value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaScannerState, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void _vala_array_add21 (ValaScannerState** array, int* length, int* size, ValaScannerState value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaScannerState, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void _vala_array_add22 (ValaScannerState** array, int* length, int* size, ValaScannerState value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaScannerState, *array, *size);
	}
	(*array)[(*length)++] = value;
}


ValaTokenType vala_scanner_read_token (ValaScanner* self, ValaSourceLocation* token_begin, ValaSourceLocation* token_end) {
	ValaSourceLocation _vala_token_begin = {0};
	ValaSourceLocation _vala_token_end = {0};
	ValaTokenType result = 0;
	gboolean _tmp0_ = FALSE;
	ValaTokenType type = 0;
	gchar* _tmp18_;
	gchar* begin;
	gchar* _tmp19_;
	gint _tmp20_;
	gint _tmp21_;
	ValaSourceLocation _tmp22_ = {0};
	gint token_length_in_chars;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gint _tmp434_;
	gchar* _tmp440_;
	gint _tmp441_;
	gint _tmp442_;
	ValaSourceLocation _tmp443_ = {0};
	ValaTokenType _tmp444_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = vala_scanner_in_template (self);
	if (_tmp0_) {
		ValaSourceLocation _tmp1_ = {0};
		ValaSourceLocation _tmp2_ = {0};
		ValaTokenType _tmp3_ = 0;
		_tmp3_ = vala_scanner_read_template_token (self, &_tmp1_, &_tmp2_);
		_vala_token_begin = _tmp1_;
		_vala_token_end = _tmp2_;
		result = _tmp3_;
		if (token_begin) {
			*token_begin = _vala_token_begin;
		}
		if (token_end) {
			*token_end = _vala_token_end;
		}
		return result;
	} else {
		gboolean _tmp4_ = FALSE;
		_tmp4_ = vala_scanner_in_template_part (self);
		if (_tmp4_) {
			gint _tmp5_;
			gchar* _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			ValaSourceLocation _tmp9_ = {0};
			gchar* _tmp10_;
			gint _tmp11_;
			gint _tmp12_;
			ValaSourceLocation _tmp13_ = {0};
			_tmp5_ = self->priv->state_stack_length1;
			self->priv->state_stack_length1 = _tmp5_ - 1;
			_tmp6_ = self->priv->current;
			_tmp7_ = self->priv->line;
			_tmp8_ = self->priv->column;
			vala_source_location_init (&_tmp9_, _tmp6_, _tmp7_, _tmp8_);
			_vala_token_begin = _tmp9_;
			_tmp10_ = self->priv->current;
			_tmp11_ = self->priv->line;
			_tmp12_ = self->priv->column;
			vala_source_location_init (&_tmp13_, _tmp10_, _tmp11_, _tmp12_ - 1);
			_vala_token_end = _tmp13_;
			result = VALA_TOKEN_TYPE_COMMA;
			if (token_begin) {
				*token_begin = _vala_token_begin;
			}
			if (token_end) {
				*token_end = _vala_token_end;
			}
			return result;
		} else {
			gboolean _tmp14_ = FALSE;
			_tmp14_ = vala_scanner_in_regex_literal (self);
			if (_tmp14_) {
				ValaSourceLocation _tmp15_ = {0};
				ValaSourceLocation _tmp16_ = {0};
				ValaTokenType _tmp17_ = 0;
				_tmp17_ = vala_scanner_read_regex_token (self, &_tmp15_, &_tmp16_);
				_vala_token_begin = _tmp15_;
				_vala_token_end = _tmp16_;
				result = _tmp17_;
				if (token_begin) {
					*token_begin = _vala_token_begin;
				}
				if (token_end) {
					*token_end = _vala_token_end;
				}
				return result;
			}
		}
	}
	vala_scanner_space (self);
	_tmp18_ = self->priv->current;
	begin = _tmp18_;
	_tmp19_ = begin;
	_tmp20_ = self->priv->line;
	_tmp21_ = self->priv->column;
	vala_source_location_init (&_tmp22_, _tmp19_, _tmp20_, _tmp21_);
	_vala_token_begin = _tmp22_;
	token_length_in_chars = -1;
	_tmp23_ = self->priv->current;
	_tmp24_ = self->priv->end;
	if (_tmp23_ >= _tmp24_) {
		type = VALA_TOKEN_TYPE_EOF;
	} else {
		gboolean _tmp25_ = FALSE;
		gchar* _tmp26_;
		gchar _tmp27_;
		gboolean _tmp28_ = FALSE;
		gboolean _tmp31_;
		_tmp26_ = self->priv->current;
		_tmp27_ = _tmp26_[0];
		_tmp28_ = g_ascii_isalpha (_tmp27_);
		if (_tmp28_) {
			_tmp25_ = TRUE;
		} else {
			gchar* _tmp29_;
			gchar _tmp30_;
			_tmp29_ = self->priv->current;
			_tmp30_ = _tmp29_[0];
			_tmp25_ = _tmp30_ == '_';
		}
		_tmp31_ = _tmp25_;
		if (_tmp31_) {
			gint len;
			gchar* _tmp41_;
			gint _tmp42_;
			ValaTokenType _tmp43_ = 0;
			len = 0;
			while (TRUE) {
				gboolean _tmp32_ = FALSE;
				gchar* _tmp33_;
				gchar* _tmp34_;
				gboolean _tmp38_;
				gchar* _tmp39_;
				gint _tmp40_;
				_tmp33_ = self->priv->current;
				_tmp34_ = self->priv->end;
				if (_tmp33_ < _tmp34_) {
					gchar* _tmp35_;
					gchar _tmp36_;
					gboolean _tmp37_ = FALSE;
					_tmp35_ = self->priv->current;
					_tmp36_ = _tmp35_[0];
					_tmp37_ = vala_scanner_is_ident_char (self, _tmp36_);
					_tmp32_ = _tmp37_;
				} else {
					_tmp32_ = FALSE;
				}
				_tmp38_ = _tmp32_;
				if (!_tmp38_) {
					break;
				}
				_tmp39_ = self->priv->current;
				self->priv->current = _tmp39_ + 1;
				_tmp40_ = len;
				len = _tmp40_ + 1;
			}
			_tmp41_ = begin;
			_tmp42_ = len;
			_tmp43_ = vala_scanner_get_identifier_or_keyword (_tmp41_, _tmp42_);
			type = _tmp43_;
		} else {
			gboolean _tmp44_ = FALSE;
			gchar* _tmp45_;
			gchar _tmp46_;
			gboolean _tmp52_;
			_tmp45_ = self->priv->current;
			_tmp46_ = _tmp45_[0];
			if (_tmp46_ == '@') {
				ValaSourceFile* _tmp47_;
				ValaCodeContext* _tmp48_;
				ValaCodeContext* _tmp49_;
				ValaProfile _tmp50_;
				ValaProfile _tmp51_;
				_tmp47_ = self->priv->_source_file;
				_tmp48_ = vala_source_file_get_context (_tmp47_);
				_tmp49_ = _tmp48_;
				_tmp50_ = vala_code_context_get_profile (_tmp49_);
				_tmp51_ = _tmp50_;
				_tmp44_ = _tmp51_ != VALA_PROFILE_DOVA;
			} else {
				_tmp44_ = FALSE;
			}
			_tmp52_ = _tmp44_;
			if (_tmp52_) {
				gboolean _tmp53_ = FALSE;
				gchar* _tmp54_;
				gchar* _tmp55_;
				gboolean _tmp58_;
				_tmp54_ = self->priv->current;
				_tmp55_ = self->priv->end;
				if (_tmp54_ < (_tmp55_ - 1)) {
					gchar* _tmp56_;
					gchar _tmp57_;
					_tmp56_ = self->priv->current;
					_tmp57_ = _tmp56_[1];
					_tmp53_ = _tmp57_ == '"';
				} else {
					_tmp53_ = FALSE;
				}
				_tmp58_ = _tmp53_;
				if (_tmp58_) {
					gchar* _tmp59_;
					ValaScannerState* _tmp60_;
					gint _tmp60__length1;
					type = VALA_TOKEN_TYPE_OPEN_TEMPLATE;
					_tmp59_ = self->priv->current;
					self->priv->current = _tmp59_ + 2;
					_tmp60_ = self->priv->state_stack;
					_tmp60__length1 = self->priv->state_stack_length1;
					_vala_array_add17 (&self->priv->state_stack, &self->priv->state_stack_length1, &self->priv->_state_stack_size_, VALA_SCANNER_STATE_TEMPLATE);
				} else {
					gchar* _tmp61_;
					gchar* _tmp62_;
					gint len;
					_tmp61_ = _vala_token_begin.pos;
					_vala_token_begin.pos = _tmp61_ + 1;
					_tmp62_ = self->priv->current;
					self->priv->current = _tmp62_ + 1;
					len = 0;
					while (TRUE) {
						gboolean _tmp63_ = FALSE;
						gchar* _tmp64_;
						gchar* _tmp65_;
						gboolean _tmp69_;
						gchar* _tmp70_;
						gint _tmp71_;
						_tmp64_ = self->priv->current;
						_tmp65_ = self->priv->end;
						if (_tmp64_ < _tmp65_) {
							gchar* _tmp66_;
							gchar _tmp67_;
							gboolean _tmp68_ = FALSE;
							_tmp66_ = self->priv->current;
							_tmp67_ = _tmp66_[0];
							_tmp68_ = vala_scanner_is_ident_char (self, _tmp67_);
							_tmp63_ = _tmp68_;
						} else {
							_tmp63_ = FALSE;
						}
						_tmp69_ = _tmp63_;
						if (!_tmp69_) {
							break;
						}
						_tmp70_ = self->priv->current;
						self->priv->current = _tmp70_ + 1;
						_tmp71_ = len;
						len = _tmp71_ + 1;
					}
					type = VALA_TOKEN_TYPE_IDENTIFIER;
				}
			} else {
				gchar* _tmp72_;
				gchar _tmp73_;
				gboolean _tmp74_ = FALSE;
				_tmp72_ = self->priv->current;
				_tmp73_ = _tmp72_[0];
				_tmp74_ = g_ascii_isdigit (_tmp73_);
				if (_tmp74_) {
					ValaTokenType _tmp75_ = 0;
					_tmp75_ = vala_scanner_read_number (self);
					type = _tmp75_;
				} else {
					gchar* _tmp76_;
					gchar _tmp77_;
					_tmp76_ = self->priv->current;
					_tmp77_ = _tmp76_[0];
					switch (_tmp77_) {
						case '{':
						{
							gchar* _tmp78_;
							ValaScannerState* _tmp79_;
							gint _tmp79__length1;
							type = VALA_TOKEN_TYPE_OPEN_BRACE;
							_tmp78_ = self->priv->current;
							self->priv->current = _tmp78_ + 1;
							_tmp79_ = self->priv->state_stack;
							_tmp79__length1 = self->priv->state_stack_length1;
							_vala_array_add18 (&self->priv->state_stack, &self->priv->state_stack_length1, &self->priv->_state_stack_size_, VALA_SCANNER_STATE_BRACE);
							break;
						}
						case '}':
						{
							gchar* _tmp80_;
							ValaScannerState* _tmp81_;
							gint _tmp81__length1;
							type = VALA_TOKEN_TYPE_CLOSE_BRACE;
							_tmp80_ = self->priv->current;
							self->priv->current = _tmp80_ + 1;
							_tmp81_ = self->priv->state_stack;
							_tmp81__length1 = self->priv->state_stack_length1;
							if (_tmp81__length1 > 0) {
								gint _tmp82_;
								_tmp82_ = self->priv->state_stack_length1;
								self->priv->state_stack_length1 = _tmp82_ - 1;
							}
							break;
						}
						case '(':
						{
							gchar* _tmp83_;
							ValaScannerState* _tmp84_;
							gint _tmp84__length1;
							type = VALA_TOKEN_TYPE_OPEN_PARENS;
							_tmp83_ = self->priv->current;
							self->priv->current = _tmp83_ + 1;
							_tmp84_ = self->priv->state_stack;
							_tmp84__length1 = self->priv->state_stack_length1;
							_vala_array_add19 (&self->priv->state_stack, &self->priv->state_stack_length1, &self->priv->_state_stack_size_, VALA_SCANNER_STATE_PARENS);
							break;
						}
						case ')':
						{
							gchar* _tmp85_;
							ValaScannerState* _tmp86_;
							gint _tmp86__length1;
							gboolean _tmp88_ = FALSE;
							type = VALA_TOKEN_TYPE_CLOSE_PARENS;
							_tmp85_ = self->priv->current;
							self->priv->current = _tmp85_ + 1;
							_tmp86_ = self->priv->state_stack;
							_tmp86__length1 = self->priv->state_stack_length1;
							if (_tmp86__length1 > 0) {
								gint _tmp87_;
								_tmp87_ = self->priv->state_stack_length1;
								self->priv->state_stack_length1 = _tmp87_ - 1;
							}
							_tmp88_ = vala_scanner_in_template (self);
							if (_tmp88_) {
								type = VALA_TOKEN_TYPE_COMMA;
							}
							break;
						}
						case '[':
						{
							gchar* _tmp89_;
							ValaScannerState* _tmp90_;
							gint _tmp90__length1;
							type = VALA_TOKEN_TYPE_OPEN_BRACKET;
							_tmp89_ = self->priv->current;
							self->priv->current = _tmp89_ + 1;
							_tmp90_ = self->priv->state_stack;
							_tmp90__length1 = self->priv->state_stack_length1;
							_vala_array_add20 (&self->priv->state_stack, &self->priv->state_stack_length1, &self->priv->_state_stack_size_, VALA_SCANNER_STATE_BRACKET);
							break;
						}
						case ']':
						{
							gchar* _tmp91_;
							ValaScannerState* _tmp92_;
							gint _tmp92__length1;
							type = VALA_TOKEN_TYPE_CLOSE_BRACKET;
							_tmp91_ = self->priv->current;
							self->priv->current = _tmp91_ + 1;
							_tmp92_ = self->priv->state_stack;
							_tmp92__length1 = self->priv->state_stack_length1;
							if (_tmp92__length1 > 0) {
								gint _tmp93_;
								_tmp93_ = self->priv->state_stack_length1;
								self->priv->state_stack_length1 = _tmp93_ - 1;
							}
							break;
						}
						case '.':
						{
							gchar* _tmp94_;
							gchar* _tmp95_;
							gchar* _tmp96_;
							type = VALA_TOKEN_TYPE_DOT;
							_tmp94_ = self->priv->current;
							self->priv->current = _tmp94_ + 1;
							_tmp95_ = self->priv->current;
							_tmp96_ = self->priv->end;
							if (_tmp95_ < (_tmp96_ - 1)) {
								gboolean _tmp97_ = FALSE;
								gchar* _tmp98_;
								gchar _tmp99_;
								gboolean _tmp102_;
								_tmp98_ = self->priv->current;
								_tmp99_ = _tmp98_[0];
								if (_tmp99_ == '.') {
									gchar* _tmp100_;
									gchar _tmp101_;
									_tmp100_ = self->priv->current;
									_tmp101_ = _tmp100_[1];
									_tmp97_ = _tmp101_ == '.';
								} else {
									_tmp97_ = FALSE;
								}
								_tmp102_ = _tmp97_;
								if (_tmp102_) {
									gchar* _tmp103_;
									type = VALA_TOKEN_TYPE_ELLIPSIS;
									_tmp103_ = self->priv->current;
									self->priv->current = _tmp103_ + 2;
								}
							}
							break;
						}
						case ':':
						{
							gchar* _tmp104_;
							gboolean _tmp105_ = FALSE;
							gchar* _tmp106_;
							gchar* _tmp107_;
							gboolean _tmp110_;
							type = VALA_TOKEN_TYPE_COLON;
							_tmp104_ = self->priv->current;
							self->priv->current = _tmp104_ + 1;
							_tmp106_ = self->priv->current;
							_tmp107_ = self->priv->end;
							if (_tmp106_ < _tmp107_) {
								gchar* _tmp108_;
								gchar _tmp109_;
								_tmp108_ = self->priv->current;
								_tmp109_ = _tmp108_[0];
								_tmp105_ = _tmp109_ == ':';
							} else {
								_tmp105_ = FALSE;
							}
							_tmp110_ = _tmp105_;
							if (_tmp110_) {
								gchar* _tmp111_;
								type = VALA_TOKEN_TYPE_DOUBLE_COLON;
								_tmp111_ = self->priv->current;
								self->priv->current = _tmp111_ + 1;
							}
							break;
						}
						case ',':
						{
							gchar* _tmp112_;
							type = VALA_TOKEN_TYPE_COMMA;
							_tmp112_ = self->priv->current;
							self->priv->current = _tmp112_ + 1;
							break;
						}
						case ';':
						{
							gchar* _tmp113_;
							type = VALA_TOKEN_TYPE_SEMICOLON;
							_tmp113_ = self->priv->current;
							self->priv->current = _tmp113_ + 1;
							break;
						}
						case '#':
						{
							gchar* _tmp114_;
							type = VALA_TOKEN_TYPE_HASH;
							_tmp114_ = self->priv->current;
							self->priv->current = _tmp114_ + 1;
							break;
						}
						case '?':
						{
							gchar* _tmp115_;
							gboolean _tmp116_ = FALSE;
							gchar* _tmp117_;
							gchar* _tmp118_;
							gboolean _tmp121_;
							type = VALA_TOKEN_TYPE_INTERR;
							_tmp115_ = self->priv->current;
							self->priv->current = _tmp115_ + 1;
							_tmp117_ = self->priv->current;
							_tmp118_ = self->priv->end;
							if (_tmp117_ < _tmp118_) {
								gchar* _tmp119_;
								gchar _tmp120_;
								_tmp119_ = self->priv->current;
								_tmp120_ = _tmp119_[0];
								_tmp116_ = _tmp120_ == '?';
							} else {
								_tmp116_ = FALSE;
							}
							_tmp121_ = _tmp116_;
							if (_tmp121_) {
								gchar* _tmp122_;
								type = VALA_TOKEN_TYPE_OP_COALESCING;
								_tmp122_ = self->priv->current;
								self->priv->current = _tmp122_ + 1;
							}
							break;
						}
						case '|':
						{
							gchar* _tmp123_;
							gchar* _tmp124_;
							gchar* _tmp125_;
							type = VALA_TOKEN_TYPE_BITWISE_OR;
							_tmp123_ = self->priv->current;
							self->priv->current = _tmp123_ + 1;
							_tmp124_ = self->priv->current;
							_tmp125_ = self->priv->end;
							if (_tmp124_ < _tmp125_) {
								gchar* _tmp126_;
								gchar _tmp127_;
								_tmp126_ = self->priv->current;
								_tmp127_ = _tmp126_[0];
								switch (_tmp127_) {
									case '=':
									{
										gchar* _tmp128_;
										type = VALA_TOKEN_TYPE_ASSIGN_BITWISE_OR;
										_tmp128_ = self->priv->current;
										self->priv->current = _tmp128_ + 1;
										break;
									}
									case '|':
									{
										gchar* _tmp129_;
										type = VALA_TOKEN_TYPE_OP_OR;
										_tmp129_ = self->priv->current;
										self->priv->current = _tmp129_ + 1;
										break;
									}
									default:
									break;
								}
							}
							break;
						}
						case '&':
						{
							gchar* _tmp130_;
							gchar* _tmp131_;
							gchar* _tmp132_;
							type = VALA_TOKEN_TYPE_BITWISE_AND;
							_tmp130_ = self->priv->current;
							self->priv->current = _tmp130_ + 1;
							_tmp131_ = self->priv->current;
							_tmp132_ = self->priv->end;
							if (_tmp131_ < _tmp132_) {
								gchar* _tmp133_;
								gchar _tmp134_;
								_tmp133_ = self->priv->current;
								_tmp134_ = _tmp133_[0];
								switch (_tmp134_) {
									case '=':
									{
										gchar* _tmp135_;
										type = VALA_TOKEN_TYPE_ASSIGN_BITWISE_AND;
										_tmp135_ = self->priv->current;
										self->priv->current = _tmp135_ + 1;
										break;
									}
									case '&':
									{
										gchar* _tmp136_;
										type = VALA_TOKEN_TYPE_OP_AND;
										_tmp136_ = self->priv->current;
										self->priv->current = _tmp136_ + 1;
										break;
									}
									default:
									break;
								}
							}
							break;
						}
						case '^':
						{
							gchar* _tmp137_;
							gboolean _tmp138_ = FALSE;
							gchar* _tmp139_;
							gchar* _tmp140_;
							gboolean _tmp143_;
							type = VALA_TOKEN_TYPE_CARRET;
							_tmp137_ = self->priv->current;
							self->priv->current = _tmp137_ + 1;
							_tmp139_ = self->priv->current;
							_tmp140_ = self->priv->end;
							if (_tmp139_ < _tmp140_) {
								gchar* _tmp141_;
								gchar _tmp142_;
								_tmp141_ = self->priv->current;
								_tmp142_ = _tmp141_[0];
								_tmp138_ = _tmp142_ == '=';
							} else {
								_tmp138_ = FALSE;
							}
							_tmp143_ = _tmp138_;
							if (_tmp143_) {
								gchar* _tmp144_;
								type = VALA_TOKEN_TYPE_ASSIGN_BITWISE_XOR;
								_tmp144_ = self->priv->current;
								self->priv->current = _tmp144_ + 1;
							}
							break;
						}
						case '~':
						{
							gchar* _tmp145_;
							type = VALA_TOKEN_TYPE_TILDE;
							_tmp145_ = self->priv->current;
							self->priv->current = _tmp145_ + 1;
							break;
						}
						case '=':
						{
							gchar* _tmp146_;
							gchar* _tmp147_;
							gchar* _tmp148_;
							type = VALA_TOKEN_TYPE_ASSIGN;
							_tmp146_ = self->priv->current;
							self->priv->current = _tmp146_ + 1;
							_tmp147_ = self->priv->current;
							_tmp148_ = self->priv->end;
							if (_tmp147_ < _tmp148_) {
								gchar* _tmp149_;
								gchar _tmp150_;
								_tmp149_ = self->priv->current;
								_tmp150_ = _tmp149_[0];
								switch (_tmp150_) {
									case '=':
									{
										gchar* _tmp151_;
										type = VALA_TOKEN_TYPE_OP_EQ;
										_tmp151_ = self->priv->current;
										self->priv->current = _tmp151_ + 1;
										break;
									}
									case '>':
									{
										gchar* _tmp152_;
										type = VALA_TOKEN_TYPE_LAMBDA;
										_tmp152_ = self->priv->current;
										self->priv->current = _tmp152_ + 1;
										break;
									}
									default:
									break;
								}
							}
							break;
						}
						case '<':
						{
							gchar* _tmp153_;
							gchar* _tmp154_;
							gchar* _tmp155_;
							type = VALA_TOKEN_TYPE_OP_LT;
							_tmp153_ = self->priv->current;
							self->priv->current = _tmp153_ + 1;
							_tmp154_ = self->priv->current;
							_tmp155_ = self->priv->end;
							if (_tmp154_ < _tmp155_) {
								gchar* _tmp156_;
								gchar _tmp157_;
								_tmp156_ = self->priv->current;
								_tmp157_ = _tmp156_[0];
								switch (_tmp157_) {
									case '=':
									{
										gchar* _tmp158_;
										type = VALA_TOKEN_TYPE_OP_LE;
										_tmp158_ = self->priv->current;
										self->priv->current = _tmp158_ + 1;
										break;
									}
									case '<':
									{
										gchar* _tmp159_;
										gboolean _tmp160_ = FALSE;
										gchar* _tmp161_;
										gchar* _tmp162_;
										gboolean _tmp165_;
										type = VALA_TOKEN_TYPE_OP_SHIFT_LEFT;
										_tmp159_ = self->priv->current;
										self->priv->current = _tmp159_ + 1;
										_tmp161_ = self->priv->current;
										_tmp162_ = self->priv->end;
										if (_tmp161_ < _tmp162_) {
											gchar* _tmp163_;
											gchar _tmp164_;
											_tmp163_ = self->priv->current;
											_tmp164_ = _tmp163_[0];
											_tmp160_ = _tmp164_ == '=';
										} else {
											_tmp160_ = FALSE;
										}
										_tmp165_ = _tmp160_;
										if (_tmp165_) {
											gchar* _tmp166_;
											type = VALA_TOKEN_TYPE_ASSIGN_SHIFT_LEFT;
											_tmp166_ = self->priv->current;
											self->priv->current = _tmp166_ + 1;
										}
										break;
									}
									default:
									break;
								}
							}
							break;
						}
						case '>':
						{
							gchar* _tmp167_;
							gboolean _tmp168_ = FALSE;
							gchar* _tmp169_;
							gchar* _tmp170_;
							gboolean _tmp173_;
							type = VALA_TOKEN_TYPE_OP_GT;
							_tmp167_ = self->priv->current;
							self->priv->current = _tmp167_ + 1;
							_tmp169_ = self->priv->current;
							_tmp170_ = self->priv->end;
							if (_tmp169_ < _tmp170_) {
								gchar* _tmp171_;
								gchar _tmp172_;
								_tmp171_ = self->priv->current;
								_tmp172_ = _tmp171_[0];
								_tmp168_ = _tmp172_ == '=';
							} else {
								_tmp168_ = FALSE;
							}
							_tmp173_ = _tmp168_;
							if (_tmp173_) {
								gchar* _tmp174_;
								type = VALA_TOKEN_TYPE_OP_GE;
								_tmp174_ = self->priv->current;
								self->priv->current = _tmp174_ + 1;
							}
							break;
						}
						case '!':
						{
							gchar* _tmp175_;
							gboolean _tmp176_ = FALSE;
							gchar* _tmp177_;
							gchar* _tmp178_;
							gboolean _tmp181_;
							type = VALA_TOKEN_TYPE_OP_NEG;
							_tmp175_ = self->priv->current;
							self->priv->current = _tmp175_ + 1;
							_tmp177_ = self->priv->current;
							_tmp178_ = self->priv->end;
							if (_tmp177_ < _tmp178_) {
								gchar* _tmp179_;
								gchar _tmp180_;
								_tmp179_ = self->priv->current;
								_tmp180_ = _tmp179_[0];
								_tmp176_ = _tmp180_ == '=';
							} else {
								_tmp176_ = FALSE;
							}
							_tmp181_ = _tmp176_;
							if (_tmp181_) {
								gchar* _tmp182_;
								type = VALA_TOKEN_TYPE_OP_NE;
								_tmp182_ = self->priv->current;
								self->priv->current = _tmp182_ + 1;
							}
							break;
						}
						case '+':
						{
							gchar* _tmp183_;
							gchar* _tmp184_;
							gchar* _tmp185_;
							type = VALA_TOKEN_TYPE_PLUS;
							_tmp183_ = self->priv->current;
							self->priv->current = _tmp183_ + 1;
							_tmp184_ = self->priv->current;
							_tmp185_ = self->priv->end;
							if (_tmp184_ < _tmp185_) {
								gchar* _tmp186_;
								gchar _tmp187_;
								_tmp186_ = self->priv->current;
								_tmp187_ = _tmp186_[0];
								switch (_tmp187_) {
									case '=':
									{
										gchar* _tmp188_;
										type = VALA_TOKEN_TYPE_ASSIGN_ADD;
										_tmp188_ = self->priv->current;
										self->priv->current = _tmp188_ + 1;
										break;
									}
									case '+':
									{
										gchar* _tmp189_;
										type = VALA_TOKEN_TYPE_OP_INC;
										_tmp189_ = self->priv->current;
										self->priv->current = _tmp189_ + 1;
										break;
									}
									default:
									break;
								}
							}
							break;
						}
						case '-':
						{
							gchar* _tmp190_;
							gchar* _tmp191_;
							gchar* _tmp192_;
							type = VALA_TOKEN_TYPE_MINUS;
							_tmp190_ = self->priv->current;
							self->priv->current = _tmp190_ + 1;
							_tmp191_ = self->priv->current;
							_tmp192_ = self->priv->end;
							if (_tmp191_ < _tmp192_) {
								gchar* _tmp193_;
								gchar _tmp194_;
								_tmp193_ = self->priv->current;
								_tmp194_ = _tmp193_[0];
								switch (_tmp194_) {
									case '=':
									{
										gchar* _tmp195_;
										type = VALA_TOKEN_TYPE_ASSIGN_SUB;
										_tmp195_ = self->priv->current;
										self->priv->current = _tmp195_ + 1;
										break;
									}
									case '-':
									{
										gchar* _tmp196_;
										type = VALA_TOKEN_TYPE_OP_DEC;
										_tmp196_ = self->priv->current;
										self->priv->current = _tmp196_ + 1;
										break;
									}
									case '>':
									{
										gchar* _tmp197_;
										type = VALA_TOKEN_TYPE_OP_PTR;
										_tmp197_ = self->priv->current;
										self->priv->current = _tmp197_ + 1;
										break;
									}
									default:
									break;
								}
							}
							break;
						}
						case '*':
						{
							gchar* _tmp198_;
							gboolean _tmp199_ = FALSE;
							gchar* _tmp200_;
							gchar* _tmp201_;
							gboolean _tmp204_;
							type = VALA_TOKEN_TYPE_STAR;
							_tmp198_ = self->priv->current;
							self->priv->current = _tmp198_ + 1;
							_tmp200_ = self->priv->current;
							_tmp201_ = self->priv->end;
							if (_tmp200_ < _tmp201_) {
								gchar* _tmp202_;
								gchar _tmp203_;
								_tmp202_ = self->priv->current;
								_tmp203_ = _tmp202_[0];
								_tmp199_ = _tmp203_ == '=';
							} else {
								_tmp199_ = FALSE;
							}
							_tmp204_ = _tmp199_;
							if (_tmp204_) {
								gchar* _tmp205_;
								type = VALA_TOKEN_TYPE_ASSIGN_MUL;
								_tmp205_ = self->priv->current;
								self->priv->current = _tmp205_ + 1;
							}
							break;
						}
						case '/':
						{
							ValaTokenType _tmp206_;
							_tmp206_ = self->priv->previous;
							switch (_tmp206_) {
								case VALA_TOKEN_TYPE_ASSIGN:
								case VALA_TOKEN_TYPE_COMMA:
								case VALA_TOKEN_TYPE_MINUS:
								case VALA_TOKEN_TYPE_OP_AND:
								case VALA_TOKEN_TYPE_OP_COALESCING:
								case VALA_TOKEN_TYPE_OP_EQ:
								case VALA_TOKEN_TYPE_OP_GE:
								case VALA_TOKEN_TYPE_OP_GT:
								case VALA_TOKEN_TYPE_OP_LE:
								case VALA_TOKEN_TYPE_OP_LT:
								case VALA_TOKEN_TYPE_OP_NE:
								case VALA_TOKEN_TYPE_OP_NEG:
								case VALA_TOKEN_TYPE_OP_OR:
								case VALA_TOKEN_TYPE_OPEN_BRACE:
								case VALA_TOKEN_TYPE_OPEN_PARENS:
								case VALA_TOKEN_TYPE_PLUS:
								case VALA_TOKEN_TYPE_RETURN:
								{
									ValaScannerState* _tmp207_;
									gint _tmp207__length1;
									gchar* _tmp208_;
									type = VALA_TOKEN_TYPE_OPEN_REGEX_LITERAL;
									_tmp207_ = self->priv->state_stack;
									_tmp207__length1 = self->priv->state_stack_length1;
									_vala_array_add21 (&self->priv->state_stack, &self->priv->state_stack_length1, &self->priv->_state_stack_size_, VALA_SCANNER_STATE_REGEX_LITERAL);
									_tmp208_ = self->priv->current;
									self->priv->current = _tmp208_ + 1;
									break;
								}
								default:
								{
									gchar* _tmp209_;
									gboolean _tmp210_ = FALSE;
									gchar* _tmp211_;
									gchar* _tmp212_;
									gboolean _tmp215_;
									type = VALA_TOKEN_TYPE_DIV;
									_tmp209_ = self->priv->current;
									self->priv->current = _tmp209_ + 1;
									_tmp211_ = self->priv->current;
									_tmp212_ = self->priv->end;
									if (_tmp211_ < _tmp212_) {
										gchar* _tmp213_;
										gchar _tmp214_;
										_tmp213_ = self->priv->current;
										_tmp214_ = _tmp213_[0];
										_tmp210_ = _tmp214_ == '=';
									} else {
										_tmp210_ = FALSE;
									}
									_tmp215_ = _tmp210_;
									if (_tmp215_) {
										gchar* _tmp216_;
										type = VALA_TOKEN_TYPE_ASSIGN_DIV;
										_tmp216_ = self->priv->current;
										self->priv->current = _tmp216_ + 1;
									}
									break;
								}
							}
							break;
						}
						case '%':
						{
							gchar* _tmp217_;
							gboolean _tmp218_ = FALSE;
							gchar* _tmp219_;
							gchar* _tmp220_;
							gboolean _tmp223_;
							type = VALA_TOKEN_TYPE_PERCENT;
							_tmp217_ = self->priv->current;
							self->priv->current = _tmp217_ + 1;
							_tmp219_ = self->priv->current;
							_tmp220_ = self->priv->end;
							if (_tmp219_ < _tmp220_) {
								gchar* _tmp221_;
								gchar _tmp222_;
								_tmp221_ = self->priv->current;
								_tmp222_ = _tmp221_[0];
								_tmp218_ = _tmp222_ == '=';
							} else {
								_tmp218_ = FALSE;
							}
							_tmp223_ = _tmp218_;
							if (_tmp223_) {
								gchar* _tmp224_;
								type = VALA_TOKEN_TYPE_ASSIGN_PERCENT;
								_tmp224_ = self->priv->current;
								self->priv->current = _tmp224_ + 1;
							}
							break;
						}
						case '\'':
						case '"':
						{
							gchar* _tmp225_;
							gchar _tmp226_;
							gchar* _tmp296_;
							gchar* _tmp391_;
							gchar* _tmp392_;
							_tmp225_ = begin;
							_tmp226_ = _tmp225_[0];
							if (_tmp226_ == '\'') {
								type = VALA_TOKEN_TYPE_CHARACTER_LITERAL;
							} else {
								gboolean _tmp227_ = FALSE;
								gboolean _tmp228_ = FALSE;
								gchar* _tmp229_;
								gchar* _tmp230_;
								gboolean _tmp233_;
								gboolean _tmp236_;
								_tmp229_ = self->priv->current;
								_tmp230_ = self->priv->end;
								if (_tmp229_ < (_tmp230_ - 6)) {
									gchar* _tmp231_;
									gchar _tmp232_;
									_tmp231_ = begin;
									_tmp232_ = _tmp231_[1];
									_tmp228_ = _tmp232_ == '"';
								} else {
									_tmp228_ = FALSE;
								}
								_tmp233_ = _tmp228_;
								if (_tmp233_) {
									gchar* _tmp234_;
									gchar _tmp235_;
									_tmp234_ = begin;
									_tmp235_ = _tmp234_[2];
									_tmp227_ = _tmp235_ == '"';
								} else {
									_tmp227_ = FALSE;
								}
								_tmp236_ = _tmp227_;
								if (_tmp236_) {
									gchar* _tmp237_;
									gboolean _tmp276_ = FALSE;
									gboolean _tmp277_ = FALSE;
									gchar* _tmp278_;
									gchar _tmp279_;
									gboolean _tmp282_;
									gboolean _tmp285_;
									type = VALA_TOKEN_TYPE_VERBATIM_STRING_LITERAL;
									token_length_in_chars = 6;
									_tmp237_ = self->priv->current;
									self->priv->current = _tmp237_ + 3;
									while (TRUE) {
										gchar* _tmp238_;
										gchar* _tmp239_;
										gboolean _tmp240_ = FALSE;
										gboolean _tmp241_ = FALSE;
										gboolean _tmp242_ = FALSE;
										gchar* _tmp243_;
										gchar _tmp244_;
										gboolean _tmp247_;
										gboolean _tmp250_;
										gboolean _tmp253_;
										_tmp238_ = self->priv->current;
										_tmp239_ = self->priv->end;
										if (!(_tmp238_ < (_tmp239_ - 4))) {
											break;
										}
										_tmp243_ = self->priv->current;
										_tmp244_ = _tmp243_[0];
										if (_tmp244_ == '"') {
											gchar* _tmp245_;
											gchar _tmp246_;
											_tmp245_ = self->priv->current;
											_tmp246_ = _tmp245_[1];
											_tmp242_ = _tmp246_ == '"';
										} else {
											_tmp242_ = FALSE;
										}
										_tmp247_ = _tmp242_;
										if (_tmp247_) {
											gchar* _tmp248_;
											gchar _tmp249_;
											_tmp248_ = self->priv->current;
											_tmp249_ = _tmp248_[2];
											_tmp241_ = _tmp249_ == '"';
										} else {
											_tmp241_ = FALSE;
										}
										_tmp250_ = _tmp241_;
										if (_tmp250_) {
											gchar* _tmp251_;
											gchar _tmp252_;
											_tmp251_ = self->priv->current;
											_tmp252_ = _tmp251_[3];
											_tmp240_ = _tmp252_ != '"';
										} else {
											_tmp240_ = FALSE;
										}
										_tmp253_ = _tmp240_;
										if (_tmp253_) {
											break;
										} else {
											gchar* _tmp254_;
											gchar _tmp255_;
											_tmp254_ = self->priv->current;
											_tmp255_ = _tmp254_[0];
											if (_tmp255_ == '\n') {
												gchar* _tmp256_;
												gint _tmp257_;
												_tmp256_ = self->priv->current;
												self->priv->current = _tmp256_ + 1;
												_tmp257_ = self->priv->line;
												self->priv->line = _tmp257_ + 1;
												self->priv->column = 1;
												token_length_in_chars = 3;
											} else {
												gchar* _tmp258_;
												gchar* _tmp259_;
												gchar* _tmp260_;
												gunichar _tmp261_ = 0U;
												gunichar u;
												gunichar _tmp262_;
												_tmp258_ = self->priv->current;
												_tmp259_ = self->priv->end;
												_tmp260_ = self->priv->current;
												_tmp261_ = g_utf8_get_char_validated ((const gchar*) _tmp258_, (gssize) ((glong) (_tmp259_ - _tmp260_)));
												u = _tmp261_;
												_tmp262_ = u;
												if (_tmp262_ != ((gunichar) (-1))) {
													gchar* _tmp263_;
													gunichar _tmp264_;
													gint _tmp265_ = 0;
													gint _tmp266_;
													_tmp263_ = self->priv->current;
													_tmp264_ = u;
													_tmp265_ = g_unichar_to_utf8 (_tmp264_, NULL);
													self->priv->current = _tmp263_ + _tmp265_;
													_tmp266_ = token_length_in_chars;
													token_length_in_chars = _tmp266_ + 1;
												} else {
													ValaSourceFile* _tmp267_;
													gint _tmp268_;
													gint _tmp269_;
													gint _tmp270_;
													gint _tmp271_;
													gint _tmp272_;
													gint _tmp273_;
													ValaSourceReference* _tmp274_;
													ValaSourceReference* _tmp275_;
													_tmp267_ = self->priv->_source_file;
													_tmp268_ = self->priv->line;
													_tmp269_ = self->priv->column;
													_tmp270_ = token_length_in_chars;
													_tmp271_ = self->priv->line;
													_tmp272_ = self->priv->column;
													_tmp273_ = token_length_in_chars;
													_tmp274_ = vala_source_reference_new (_tmp267_, _tmp268_, _tmp269_ + _tmp270_, _tmp271_, _tmp272_ + _tmp273_);
													_tmp275_ = _tmp274_;
													vala_report_error (_tmp275_, "invalid UTF-8 character");
													_vala_source_reference_unref0 (_tmp275_);
												}
											}
										}
									}
									_tmp278_ = self->priv->current;
									_tmp279_ = _tmp278_[0];
									if (_tmp279_ == '"') {
										gchar* _tmp280_;
										gchar _tmp281_;
										_tmp280_ = self->priv->current;
										_tmp281_ = _tmp280_[1];
										_tmp277_ = _tmp281_ == '"';
									} else {
										_tmp277_ = FALSE;
									}
									_tmp282_ = _tmp277_;
									if (_tmp282_) {
										gchar* _tmp283_;
										gchar _tmp284_;
										_tmp283_ = self->priv->current;
										_tmp284_ = _tmp283_[2];
										_tmp276_ = _tmp284_ == '"';
									} else {
										_tmp276_ = FALSE;
									}
									_tmp285_ = _tmp276_;
									if (_tmp285_) {
										gchar* _tmp286_;
										_tmp286_ = self->priv->current;
										self->priv->current = _tmp286_ + 3;
									} else {
										ValaSourceFile* _tmp287_;
										gint _tmp288_;
										gint _tmp289_;
										gint _tmp290_;
										gint _tmp291_;
										gint _tmp292_;
										gint _tmp293_;
										ValaSourceReference* _tmp294_;
										ValaSourceReference* _tmp295_;
										_tmp287_ = self->priv->_source_file;
										_tmp288_ = self->priv->line;
										_tmp289_ = self->priv->column;
										_tmp290_ = token_length_in_chars;
										_tmp291_ = self->priv->line;
										_tmp292_ = self->priv->column;
										_tmp293_ = token_length_in_chars;
										_tmp294_ = vala_source_reference_new (_tmp287_, _tmp288_, _tmp289_ + _tmp290_, _tmp291_, _tmp292_ + _tmp293_);
										_tmp295_ = _tmp294_;
										vala_report_error (_tmp295_, "syntax error, expected \"\"\"");
										_vala_source_reference_unref0 (_tmp295_);
									}
									break;
								} else {
									type = VALA_TOKEN_TYPE_STRING_LITERAL;
								}
							}
							token_length_in_chars = 2;
							_tmp296_ = self->priv->current;
							self->priv->current = _tmp296_ + 1;
							while (TRUE) {
								gboolean _tmp297_ = FALSE;
								gchar* _tmp298_;
								gchar* _tmp299_;
								gboolean _tmp304_;
								gchar* _tmp305_;
								gchar _tmp306_;
								gboolean _tmp372_ = FALSE;
								gboolean _tmp373_ = FALSE;
								gchar* _tmp374_;
								gchar* _tmp375_;
								gboolean _tmp378_;
								gboolean _tmp381_;
								_tmp298_ = self->priv->current;
								_tmp299_ = self->priv->end;
								if (_tmp298_ < _tmp299_) {
									gchar* _tmp300_;
									gchar _tmp301_;
									gchar* _tmp302_;
									gchar _tmp303_;
									_tmp300_ = self->priv->current;
									_tmp301_ = _tmp300_[0];
									_tmp302_ = begin;
									_tmp303_ = _tmp302_[0];
									_tmp297_ = _tmp301_ != _tmp303_;
								} else {
									_tmp297_ = FALSE;
								}
								_tmp304_ = _tmp297_;
								if (!_tmp304_) {
									break;
								}
								_tmp305_ = self->priv->current;
								_tmp306_ = _tmp305_[0];
								if (_tmp306_ == '\\') {
									gchar* _tmp307_;
									gint _tmp308_;
									gchar* _tmp309_;
									gchar* _tmp310_;
									gchar* _tmp311_;
									gchar _tmp312_;
									_tmp307_ = self->priv->current;
									self->priv->current = _tmp307_ + 1;
									_tmp308_ = token_length_in_chars;
									token_length_in_chars = _tmp308_ + 1;
									_tmp309_ = self->priv->current;
									_tmp310_ = self->priv->end;
									if (_tmp309_ >= _tmp310_) {
										break;
									}
									_tmp311_ = self->priv->current;
									_tmp312_ = _tmp311_[0];
									switch (_tmp312_) {
										case '\'':
										case '"':
										case '\\':
										case '0':
										case 'b':
										case 'f':
										case 'n':
										case 'r':
										case 't':
										case '$':
										{
											gchar* _tmp313_;
											gint _tmp314_;
											_tmp313_ = self->priv->current;
											self->priv->current = _tmp313_ + 1;
											_tmp314_ = token_length_in_chars;
											token_length_in_chars = _tmp314_ + 1;
											break;
										}
										case 'x':
										{
											gchar* _tmp315_;
											gint _tmp316_;
											_tmp315_ = self->priv->current;
											self->priv->current = _tmp315_ + 1;
											_tmp316_ = token_length_in_chars;
											token_length_in_chars = _tmp316_ + 1;
											while (TRUE) {
												gboolean _tmp317_ = FALSE;
												gchar* _tmp318_;
												gchar* _tmp319_;
												gboolean _tmp323_;
												gchar* _tmp324_;
												gint _tmp325_;
												_tmp318_ = self->priv->current;
												_tmp319_ = self->priv->end;
												if (_tmp318_ < _tmp319_) {
													gchar* _tmp320_;
													gchar _tmp321_;
													gboolean _tmp322_ = FALSE;
													_tmp320_ = self->priv->current;
													_tmp321_ = _tmp320_[0];
													_tmp322_ = g_ascii_isxdigit (_tmp321_);
													_tmp317_ = _tmp322_;
												} else {
													_tmp317_ = FALSE;
												}
												_tmp323_ = _tmp317_;
												if (!_tmp323_) {
													break;
												}
												_tmp324_ = self->priv->current;
												self->priv->current = _tmp324_ + 1;
												_tmp325_ = token_length_in_chars;
												token_length_in_chars = _tmp325_ + 1;
											}
											break;
										}
										default:
										{
											ValaSourceFile* _tmp326_;
											gint _tmp327_;
											gint _tmp328_;
											gint _tmp329_;
											gint _tmp330_;
											gint _tmp331_;
											gint _tmp332_;
											ValaSourceReference* _tmp333_;
											ValaSourceReference* _tmp334_;
											_tmp326_ = self->priv->_source_file;
											_tmp327_ = self->priv->line;
											_tmp328_ = self->priv->column;
											_tmp329_ = token_length_in_chars;
											_tmp330_ = self->priv->line;
											_tmp331_ = self->priv->column;
											_tmp332_ = token_length_in_chars;
											_tmp333_ = vala_source_reference_new (_tmp326_, _tmp327_, _tmp328_ + _tmp329_, _tmp330_, _tmp331_ + _tmp332_);
											_tmp334_ = _tmp333_;
											vala_report_error (_tmp334_, "invalid escape sequence");
											_vala_source_reference_unref0 (_tmp334_);
											break;
										}
									}
								} else {
									gchar* _tmp335_;
									gchar _tmp336_;
									_tmp335_ = self->priv->current;
									_tmp336_ = _tmp335_[0];
									if (_tmp336_ == '\n') {
										gchar* _tmp337_;
										gint _tmp338_;
										_tmp337_ = self->priv->current;
										self->priv->current = _tmp337_ + 1;
										_tmp338_ = self->priv->line;
										self->priv->line = _tmp338_ + 1;
										self->priv->column = 1;
										token_length_in_chars = 1;
									} else {
										gboolean _tmp339_ = FALSE;
										gboolean _tmp340_ = FALSE;
										ValaTokenType _tmp341_;
										gboolean _tmp347_;
										gboolean _tmp350_;
										gchar* _tmp353_;
										gchar* _tmp354_;
										gchar* _tmp355_;
										gunichar _tmp356_ = 0U;
										gunichar u;
										gunichar _tmp357_;
										_tmp341_ = type;
										if (_tmp341_ == VALA_TOKEN_TYPE_STRING_LITERAL) {
											ValaSourceFile* _tmp342_;
											ValaCodeContext* _tmp343_;
											ValaCodeContext* _tmp344_;
											ValaProfile _tmp345_;
											ValaProfile _tmp346_;
											_tmp342_ = self->priv->_source_file;
											_tmp343_ = vala_source_file_get_context (_tmp342_);
											_tmp344_ = _tmp343_;
											_tmp345_ = vala_code_context_get_profile (_tmp344_);
											_tmp346_ = _tmp345_;
											_tmp340_ = _tmp346_ == VALA_PROFILE_DOVA;
										} else {
											_tmp340_ = FALSE;
										}
										_tmp347_ = _tmp340_;
										if (_tmp347_) {
											gchar* _tmp348_;
											gchar _tmp349_;
											_tmp348_ = self->priv->current;
											_tmp349_ = _tmp348_[0];
											_tmp339_ = _tmp349_ == '$';
										} else {
											_tmp339_ = FALSE;
										}
										_tmp350_ = _tmp339_;
										if (_tmp350_) {
											gchar* _tmp351_;
											ValaScannerState* _tmp352_;
											gint _tmp352__length1;
											type = VALA_TOKEN_TYPE_OPEN_TEMPLATE;
											_tmp351_ = begin;
											self->priv->current = _tmp351_;
											_tmp352_ = self->priv->state_stack;
											_tmp352__length1 = self->priv->state_stack_length1;
											_vala_array_add22 (&self->priv->state_stack, &self->priv->state_stack_length1, &self->priv->_state_stack_size_, VALA_SCANNER_STATE_TEMPLATE);
											break;
										}
										_tmp353_ = self->priv->current;
										_tmp354_ = self->priv->end;
										_tmp355_ = self->priv->current;
										_tmp356_ = g_utf8_get_char_validated ((const gchar*) _tmp353_, (gssize) ((glong) (_tmp354_ - _tmp355_)));
										u = _tmp356_;
										_tmp357_ = u;
										if (_tmp357_ != ((gunichar) (-1))) {
											gchar* _tmp358_;
											gunichar _tmp359_;
											gint _tmp360_ = 0;
											gint _tmp361_;
											_tmp358_ = self->priv->current;
											_tmp359_ = u;
											_tmp360_ = g_unichar_to_utf8 (_tmp359_, NULL);
											self->priv->current = _tmp358_ + _tmp360_;
											_tmp361_ = token_length_in_chars;
											token_length_in_chars = _tmp361_ + 1;
										} else {
											gchar* _tmp362_;
											ValaSourceFile* _tmp363_;
											gint _tmp364_;
											gint _tmp365_;
											gint _tmp366_;
											gint _tmp367_;
											gint _tmp368_;
											gint _tmp369_;
											ValaSourceReference* _tmp370_;
											ValaSourceReference* _tmp371_;
											_tmp362_ = self->priv->current;
											self->priv->current = _tmp362_ + 1;
											_tmp363_ = self->priv->_source_file;
											_tmp364_ = self->priv->line;
											_tmp365_ = self->priv->column;
											_tmp366_ = token_length_in_chars;
											_tmp367_ = self->priv->line;
											_tmp368_ = self->priv->column;
											_tmp369_ = token_length_in_chars;
											_tmp370_ = vala_source_reference_new (_tmp363_, _tmp364_, _tmp365_ + _tmp366_, _tmp367_, _tmp368_ + _tmp369_);
											_tmp371_ = _tmp370_;
											vala_report_error (_tmp371_, "invalid UTF-8 character");
											_vala_source_reference_unref0 (_tmp371_);
										}
									}
								}
								_tmp374_ = self->priv->current;
								_tmp375_ = self->priv->end;
								if (_tmp374_ < _tmp375_) {
									gchar* _tmp376_;
									gchar _tmp377_;
									_tmp376_ = begin;
									_tmp377_ = _tmp376_[0];
									_tmp373_ = _tmp377_ == '\'';
								} else {
									_tmp373_ = FALSE;
								}
								_tmp378_ = _tmp373_;
								if (_tmp378_) {
									gchar* _tmp379_;
									gchar _tmp380_;
									_tmp379_ = self->priv->current;
									_tmp380_ = _tmp379_[0];
									_tmp372_ = _tmp380_ != '\'';
								} else {
									_tmp372_ = FALSE;
								}
								_tmp381_ = _tmp372_;
								if (_tmp381_) {
									ValaSourceFile* _tmp382_;
									gint _tmp383_;
									gint _tmp384_;
									gint _tmp385_;
									gint _tmp386_;
									gint _tmp387_;
									gint _tmp388_;
									ValaSourceReference* _tmp389_;
									ValaSourceReference* _tmp390_;
									_tmp382_ = self->priv->_source_file;
									_tmp383_ = self->priv->line;
									_tmp384_ = self->priv->column;
									_tmp385_ = token_length_in_chars;
									_tmp386_ = self->priv->line;
									_tmp387_ = self->priv->column;
									_tmp388_ = token_length_in_chars;
									_tmp389_ = vala_source_reference_new (_tmp382_, _tmp383_, _tmp384_ + _tmp385_, _tmp386_, _tmp387_ + _tmp388_);
									_tmp390_ = _tmp389_;
									vala_report_error (_tmp390_, "invalid character literal");
									_vala_source_reference_unref0 (_tmp390_);
								}
							}
							_tmp391_ = self->priv->current;
							_tmp392_ = self->priv->end;
							if (_tmp391_ < _tmp392_) {
								gchar* _tmp393_;
								_tmp393_ = self->priv->current;
								self->priv->current = _tmp393_ + 1;
							} else {
								ValaSourceFile* _tmp394_;
								gint _tmp395_;
								gint _tmp396_;
								gint _tmp397_;
								gint _tmp398_;
								gint _tmp399_;
								gint _tmp400_;
								ValaSourceReference* _tmp401_;
								ValaSourceReference* _tmp402_;
								gchar* _tmp403_;
								gchar _tmp404_;
								gchar* _tmp405_ = NULL;
								gchar* _tmp406_;
								_tmp394_ = self->priv->_source_file;
								_tmp395_ = self->priv->line;
								_tmp396_ = self->priv->column;
								_tmp397_ = token_length_in_chars;
								_tmp398_ = self->priv->line;
								_tmp399_ = self->priv->column;
								_tmp400_ = token_length_in_chars;
								_tmp401_ = vala_source_reference_new (_tmp394_, _tmp395_, _tmp396_ + _tmp397_, _tmp398_, _tmp399_ + _tmp400_);
								_tmp402_ = _tmp401_;
								_tmp403_ = begin;
								_tmp404_ = _tmp403_[0];
								_tmp405_ = g_strdup_printf ("syntax error, expected %c", (gint) _tmp404_);
								_tmp406_ = _tmp405_;
								vala_report_error (_tmp402_, _tmp406_);
								_g_free0 (_tmp406_);
								_vala_source_reference_unref0 (_tmp402_);
							}
							break;
						}
						default:
						{
							gchar* _tmp407_;
							gchar* _tmp408_;
							gchar* _tmp409_;
							gunichar _tmp410_ = 0U;
							gunichar u;
							gunichar _tmp411_;
							gint _tmp430_;
							ValaSourceLocation _tmp431_ = {0};
							ValaSourceLocation _tmp432_ = {0};
							ValaTokenType _tmp433_ = 0;
							_tmp407_ = self->priv->current;
							_tmp408_ = self->priv->end;
							_tmp409_ = self->priv->current;
							_tmp410_ = g_utf8_get_char_validated ((const gchar*) _tmp407_, (gssize) ((glong) (_tmp408_ - _tmp409_)));
							u = _tmp410_;
							_tmp411_ = u;
							if (_tmp411_ != ((gunichar) (-1))) {
								gchar* _tmp412_;
								gunichar _tmp413_;
								gint _tmp414_ = 0;
								ValaSourceFile* _tmp415_;
								gint _tmp416_;
								gint _tmp417_;
								gint _tmp418_;
								gint _tmp419_;
								ValaSourceReference* _tmp420_;
								ValaSourceReference* _tmp421_;
								_tmp412_ = self->priv->current;
								_tmp413_ = u;
								_tmp414_ = g_unichar_to_utf8 (_tmp413_, NULL);
								self->priv->current = _tmp412_ + _tmp414_;
								_tmp415_ = self->priv->_source_file;
								_tmp416_ = self->priv->line;
								_tmp417_ = self->priv->column;
								_tmp418_ = self->priv->line;
								_tmp419_ = self->priv->column;
								_tmp420_ = vala_source_reference_new (_tmp415_, _tmp416_, _tmp417_, _tmp418_, _tmp419_);
								_tmp421_ = _tmp420_;
								vala_report_error (_tmp421_, "syntax error, unexpected character");
								_vala_source_reference_unref0 (_tmp421_);
							} else {
								gchar* _tmp422_;
								ValaSourceFile* _tmp423_;
								gint _tmp424_;
								gint _tmp425_;
								gint _tmp426_;
								gint _tmp427_;
								ValaSourceReference* _tmp428_;
								ValaSourceReference* _tmp429_;
								_tmp422_ = self->priv->current;
								self->priv->current = _tmp422_ + 1;
								_tmp423_ = self->priv->_source_file;
								_tmp424_ = self->priv->line;
								_tmp425_ = self->priv->column;
								_tmp426_ = self->priv->line;
								_tmp427_ = self->priv->column;
								_tmp428_ = vala_source_reference_new (_tmp423_, _tmp424_, _tmp425_, _tmp426_, _tmp427_);
								_tmp429_ = _tmp428_;
								vala_report_error (_tmp429_, "invalid UTF-8 character");
								_vala_source_reference_unref0 (_tmp429_);
							}
							_tmp430_ = self->priv->column;
							self->priv->column = _tmp430_ + 1;
							_tmp433_ = vala_scanner_read_token (self, &_tmp431_, &_tmp432_);
							_vala_token_begin = _tmp431_;
							_vala_token_end = _tmp432_;
							result = _tmp433_;
							if (token_begin) {
								*token_begin = _vala_token_begin;
							}
							if (token_end) {
								*token_end = _vala_token_end;
							}
							return result;
						}
					}
				}
			}
		}
	}
	_tmp434_ = token_length_in_chars;
	if (_tmp434_ < 0) {
		gint _tmp435_;
		gchar* _tmp436_;
		gchar* _tmp437_;
		_tmp435_ = self->priv->column;
		_tmp436_ = self->priv->current;
		_tmp437_ = begin;
		self->priv->column = _tmp435_ + ((gint) (_tmp436_ - _tmp437_));
	} else {
		gint _tmp438_;
		gint _tmp439_;
		_tmp438_ = self->priv->column;
		_tmp439_ = token_length_in_chars;
		self->priv->column = _tmp438_ + _tmp439_;
	}
	_tmp440_ = self->priv->current;
	_tmp441_ = self->priv->line;
	_tmp442_ = self->priv->column;
	vala_source_location_init (&_tmp443_, _tmp440_, _tmp441_, _tmp442_ - 1);
	_vala_token_end = _tmp443_;
	_tmp444_ = type;
	self->priv->previous = _tmp444_;
	result = type;
	if (token_begin) {
		*token_begin = _vala_token_begin;
	}
	if (token_end) {
		*token_end = _vala_token_end;
	}
	return result;
}


static gboolean vala_scanner_matches (gchar* begin, const gchar* keyword) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gchar* keyword_array;
	const gchar* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	glong len;
	g_return_val_if_fail (keyword != NULL, FALSE);
	_tmp0_ = keyword;
	keyword_array = (gchar*) _tmp0_;
	_tmp1_ = keyword;
	_tmp2_ = strlen (_tmp1_);
	_tmp3_ = _tmp2_;
	len = (glong) _tmp3_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp4_;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp5_;
				gint _tmp7_;
				glong _tmp8_;
				gchar* _tmp9_;
				gint _tmp10_;
				gchar _tmp11_;
				gchar* _tmp12_;
				gint _tmp13_;
				gchar _tmp14_;
				_tmp5_ = _tmp4_;
				if (!_tmp5_) {
					gint _tmp6_;
					_tmp6_ = i;
					i = _tmp6_ + 1;
				}
				_tmp4_ = FALSE;
				_tmp7_ = i;
				_tmp8_ = len;
				if (!(((glong) _tmp7_) < _tmp8_)) {
					break;
				}
				_tmp9_ = begin;
				_tmp10_ = i;
				_tmp11_ = _tmp9_[_tmp10_];
				_tmp12_ = keyword_array;
				_tmp13_ = i;
				_tmp14_ = _tmp12_[_tmp13_];
				if (_tmp11_ != _tmp14_) {
					result = FALSE;
					return result;
				}
			}
		}
	}
	result = TRUE;
	return result;
}


static gboolean vala_scanner_pp_whitespace (ValaScanner* self) {
	gboolean result = FALSE;
	gboolean found;
	g_return_val_if_fail (self != NULL, FALSE);
	found = FALSE;
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_ = FALSE;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gboolean _tmp7_;
		gboolean _tmp10_;
		gchar* _tmp11_;
		gint _tmp12_;
		_tmp2_ = self->priv->current;
		_tmp3_ = self->priv->end;
		if (_tmp2_ < _tmp3_) {
			gchar* _tmp4_;
			gchar _tmp5_;
			gboolean _tmp6_ = FALSE;
			_tmp4_ = self->priv->current;
			_tmp5_ = _tmp4_[0];
			_tmp6_ = g_ascii_isspace (_tmp5_);
			_tmp1_ = _tmp6_;
		} else {
			_tmp1_ = FALSE;
		}
		_tmp7_ = _tmp1_;
		if (_tmp7_) {
			gchar* _tmp8_;
			gchar _tmp9_;
			_tmp8_ = self->priv->current;
			_tmp9_ = _tmp8_[0];
			_tmp0_ = _tmp9_ != '\n';
		} else {
			_tmp0_ = FALSE;
		}
		_tmp10_ = _tmp0_;
		if (!_tmp10_) {
			break;
		}
		found = TRUE;
		_tmp11_ = self->priv->current;
		self->priv->current = _tmp11_ + 1;
		_tmp12_ = self->priv->column;
		self->priv->column = _tmp12_ + 1;
	}
	result = found;
	return result;
}


static void vala_scanner_pp_directive (ValaScanner* self) {
	gchar* _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gint _tmp5_;
	gboolean _tmp7_;
	gboolean _tmp10_;
	gboolean _tmp13_;
	gchar* _tmp21_;
	gchar* begin;
	gint len;
	gboolean _tmp32_ = FALSE;
	gint _tmp33_;
	gboolean _tmp36_;
	gboolean _tmp60_ = FALSE;
	ValaScannerConditional* _tmp61_;
	gint _tmp61__length1;
	gboolean _tmp66_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->current;
	self->priv->current = _tmp0_ + 1;
	_tmp1_ = self->priv->column;
	self->priv->column = _tmp1_ + 1;
	_tmp5_ = self->priv->line;
	if (_tmp5_ == 1) {
		gint _tmp6_;
		_tmp6_ = self->priv->column;
		_tmp4_ = _tmp6_ == 2;
	} else {
		_tmp4_ = FALSE;
	}
	_tmp7_ = _tmp4_;
	if (_tmp7_) {
		gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp8_ = self->priv->current;
		_tmp9_ = self->priv->end;
		_tmp3_ = _tmp8_ < _tmp9_;
	} else {
		_tmp3_ = FALSE;
	}
	_tmp10_ = _tmp3_;
	if (_tmp10_) {
		gchar* _tmp11_;
		gchar _tmp12_;
		_tmp11_ = self->priv->current;
		_tmp12_ = _tmp11_[0];
		_tmp2_ = _tmp12_ == '!';
	} else {
		_tmp2_ = FALSE;
	}
	_tmp13_ = _tmp2_;
	if (_tmp13_) {
		while (TRUE) {
			gboolean _tmp14_ = FALSE;
			gchar* _tmp15_;
			gchar* _tmp16_;
			gboolean _tmp19_;
			gchar* _tmp20_;
			_tmp15_ = self->priv->current;
			_tmp16_ = self->priv->end;
			if (_tmp15_ < _tmp16_) {
				gchar* _tmp17_;
				gchar _tmp18_;
				_tmp17_ = self->priv->current;
				_tmp18_ = _tmp17_[0];
				_tmp14_ = _tmp18_ != '\n';
			} else {
				_tmp14_ = FALSE;
			}
			_tmp19_ = _tmp14_;
			if (!_tmp19_) {
				break;
			}
			_tmp20_ = self->priv->current;
			self->priv->current = _tmp20_ + 1;
		}
		return;
	}
	vala_scanner_pp_whitespace (self);
	_tmp21_ = self->priv->current;
	begin = _tmp21_;
	len = 0;
	while (TRUE) {
		gboolean _tmp22_ = FALSE;
		gchar* _tmp23_;
		gchar* _tmp24_;
		gboolean _tmp28_;
		gchar* _tmp29_;
		gint _tmp30_;
		gint _tmp31_;
		_tmp23_ = self->priv->current;
		_tmp24_ = self->priv->end;
		if (_tmp23_ < _tmp24_) {
			gchar* _tmp25_;
			gchar _tmp26_;
			gboolean _tmp27_ = FALSE;
			_tmp25_ = self->priv->current;
			_tmp26_ = _tmp25_[0];
			_tmp27_ = g_ascii_isalnum (_tmp26_);
			_tmp22_ = _tmp27_;
		} else {
			_tmp22_ = FALSE;
		}
		_tmp28_ = _tmp22_;
		if (!_tmp28_) {
			break;
		}
		_tmp29_ = self->priv->current;
		self->priv->current = _tmp29_ + 1;
		_tmp30_ = self->priv->column;
		self->priv->column = _tmp30_ + 1;
		_tmp31_ = len;
		len = _tmp31_ + 1;
	}
	_tmp33_ = len;
	if (_tmp33_ == 2) {
		gchar* _tmp34_;
		gboolean _tmp35_ = FALSE;
		_tmp34_ = begin;
		_tmp35_ = vala_scanner_matches (_tmp34_, "if");
		_tmp32_ = _tmp35_;
	} else {
		_tmp32_ = FALSE;
	}
	_tmp36_ = _tmp32_;
	if (_tmp36_) {
		vala_scanner_parse_pp_if (self);
	} else {
		gboolean _tmp37_ = FALSE;
		gint _tmp38_;
		gboolean _tmp41_;
		_tmp38_ = len;
		if (_tmp38_ == 4) {
			gchar* _tmp39_;
			gboolean _tmp40_ = FALSE;
			_tmp39_ = begin;
			_tmp40_ = vala_scanner_matches (_tmp39_, "elif");
			_tmp37_ = _tmp40_;
		} else {
			_tmp37_ = FALSE;
		}
		_tmp41_ = _tmp37_;
		if (_tmp41_) {
			vala_scanner_parse_pp_elif (self);
		} else {
			gboolean _tmp42_ = FALSE;
			gint _tmp43_;
			gboolean _tmp46_;
			_tmp43_ = len;
			if (_tmp43_ == 4) {
				gchar* _tmp44_;
				gboolean _tmp45_ = FALSE;
				_tmp44_ = begin;
				_tmp45_ = vala_scanner_matches (_tmp44_, "else");
				_tmp42_ = _tmp45_;
			} else {
				_tmp42_ = FALSE;
			}
			_tmp46_ = _tmp42_;
			if (_tmp46_) {
				vala_scanner_parse_pp_else (self);
			} else {
				gboolean _tmp47_ = FALSE;
				gint _tmp48_;
				gboolean _tmp51_;
				_tmp48_ = len;
				if (_tmp48_ == 5) {
					gchar* _tmp49_;
					gboolean _tmp50_ = FALSE;
					_tmp49_ = begin;
					_tmp50_ = vala_scanner_matches (_tmp49_, "endif");
					_tmp47_ = _tmp50_;
				} else {
					_tmp47_ = FALSE;
				}
				_tmp51_ = _tmp47_;
				if (_tmp51_) {
					vala_scanner_parse_pp_endif (self);
				} else {
					ValaSourceFile* _tmp52_;
					gint _tmp53_;
					gint _tmp54_;
					gint _tmp55_;
					gint _tmp56_;
					gint _tmp57_;
					ValaSourceReference* _tmp58_;
					ValaSourceReference* _tmp59_;
					_tmp52_ = self->priv->_source_file;
					_tmp53_ = self->priv->line;
					_tmp54_ = self->priv->column;
					_tmp55_ = len;
					_tmp56_ = self->priv->line;
					_tmp57_ = self->priv->column;
					_tmp58_ = vala_source_reference_new (_tmp52_, _tmp53_, _tmp54_ - _tmp55_, _tmp56_, _tmp57_);
					_tmp59_ = _tmp58_;
					vala_report_error (_tmp59_, "syntax error, invalid preprocessing directive");
					_vala_source_reference_unref0 (_tmp59_);
				}
			}
		}
	}
	_tmp61_ = self->priv->conditional_stack;
	_tmp61__length1 = self->priv->conditional_stack_length1;
	if (_tmp61__length1 > 0) {
		ValaScannerConditional* _tmp62_;
		gint _tmp62__length1;
		ValaScannerConditional* _tmp63_;
		gint _tmp63__length1;
		ValaScannerConditional _tmp64_;
		gboolean _tmp65_;
		_tmp62_ = self->priv->conditional_stack;
		_tmp62__length1 = self->priv->conditional_stack_length1;
		_tmp63_ = self->priv->conditional_stack;
		_tmp63__length1 = self->priv->conditional_stack_length1;
		_tmp64_ = _tmp62_[_tmp63__length1 - 1];
		_tmp65_ = _tmp64_.skip_section;
		_tmp60_ = _tmp65_;
	} else {
		_tmp60_ = FALSE;
	}
	_tmp66_ = _tmp60_;
	if (_tmp66_) {
		gboolean bol;
		bol = FALSE;
		while (TRUE) {
			gchar* _tmp67_;
			gchar* _tmp68_;
			gboolean _tmp69_ = FALSE;
			gboolean _tmp70_;
			gboolean _tmp73_;
			gchar* _tmp76_;
			gchar _tmp77_;
			gchar* _tmp82_;
			gint _tmp83_;
			_tmp67_ = self->priv->current;
			_tmp68_ = self->priv->end;
			if (!(_tmp67_ < _tmp68_)) {
				break;
			}
			_tmp70_ = bol;
			if (_tmp70_) {
				gchar* _tmp71_;
				gchar _tmp72_;
				_tmp71_ = self->priv->current;
				_tmp72_ = _tmp71_[0];
				_tmp69_ = _tmp72_ == '#';
			} else {
				_tmp69_ = FALSE;
			}
			_tmp73_ = _tmp69_;
			if (_tmp73_) {
				gchar* _tmp74_;
				gint _tmp75_;
				_tmp74_ = self->priv->current;
				_tmp75_ = self->priv->column;
				self->priv->current = _tmp74_ - (_tmp75_ - 1);
				self->priv->column = 1;
				return;
			}
			_tmp76_ = self->priv->current;
			_tmp77_ = _tmp76_[0];
			if (_tmp77_ == '\n') {
				gint _tmp78_;
				_tmp78_ = self->priv->line;
				self->priv->line = _tmp78_ + 1;
				self->priv->column = 0;
				bol = TRUE;
			} else {
				gchar* _tmp79_;
				gchar _tmp80_;
				gboolean _tmp81_ = FALSE;
				_tmp79_ = self->priv->current;
				_tmp80_ = _tmp79_[0];
				_tmp81_ = g_ascii_isspace (_tmp80_);
				if (!_tmp81_) {
					bol = FALSE;
				}
			}
			_tmp82_ = self->priv->current;
			self->priv->current = _tmp82_ + 1;
			_tmp83_ = self->priv->column;
			self->priv->column = _tmp83_ + 1;
		}
	}
}


static void vala_scanner_pp_eol (ValaScanner* self) {
	gboolean _tmp0_ = FALSE;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp5_;
	g_return_if_fail (self != NULL);
	vala_scanner_pp_whitespace (self);
	_tmp1_ = self->priv->current;
	_tmp2_ = self->priv->end;
	if (_tmp1_ >= _tmp2_) {
		_tmp0_ = TRUE;
	} else {
		gchar* _tmp3_;
		gchar _tmp4_;
		_tmp3_ = self->priv->current;
		_tmp4_ = _tmp3_[0];
		_tmp0_ = _tmp4_ != '\n';
	}
	_tmp5_ = _tmp0_;
	if (_tmp5_) {
		ValaSourceFile* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		ValaSourceReference* _tmp11_;
		ValaSourceReference* _tmp12_;
		_tmp6_ = self->priv->_source_file;
		_tmp7_ = self->priv->line;
		_tmp8_ = self->priv->column;
		_tmp9_ = self->priv->line;
		_tmp10_ = self->priv->column;
		_tmp11_ = vala_source_reference_new (_tmp6_, _tmp7_, _tmp8_, _tmp9_, _tmp10_);
		_tmp12_ = _tmp11_;
		vala_report_error (_tmp12_, "syntax error, expected newline");
		_vala_source_reference_unref0 (_tmp12_);
	}
}


static void _vala_array_add23 (ValaScannerConditional** array, int* length, int* size, const ValaScannerConditional* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaScannerConditional, *array, *size);
	}
	(*array)[(*length)++] = *value;
}


static void vala_scanner_parse_pp_if (ValaScanner* self) {
	gboolean _tmp0_ = FALSE;
	gboolean condition;
	ValaScannerConditional* _tmp1_;
	gint _tmp1__length1;
	ValaScannerConditional _tmp2_ = {0};
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_;
	gboolean _tmp12_;
	g_return_if_fail (self != NULL);
	vala_scanner_pp_whitespace (self);
	_tmp0_ = vala_scanner_parse_pp_expression (self);
	condition = _tmp0_;
	vala_scanner_pp_eol (self);
	_tmp1_ = self->priv->conditional_stack;
	_tmp1__length1 = self->priv->conditional_stack_length1;
	memset (&_tmp2_, 0, sizeof (ValaScannerConditional));
	_vala_array_add23 (&self->priv->conditional_stack, &self->priv->conditional_stack_length1, &self->priv->_conditional_stack_size_, &_tmp2_);
	_tmp4_ = condition;
	if (_tmp4_) {
		gboolean _tmp5_ = FALSE;
		ValaScannerConditional* _tmp6_;
		gint _tmp6__length1;
		gboolean _tmp11_;
		_tmp6_ = self->priv->conditional_stack;
		_tmp6__length1 = self->priv->conditional_stack_length1;
		if (_tmp6__length1 == 1) {
			_tmp5_ = TRUE;
		} else {
			ValaScannerConditional* _tmp7_;
			gint _tmp7__length1;
			ValaScannerConditional* _tmp8_;
			gint _tmp8__length1;
			ValaScannerConditional _tmp9_;
			gboolean _tmp10_;
			_tmp7_ = self->priv->conditional_stack;
			_tmp7__length1 = self->priv->conditional_stack_length1;
			_tmp8_ = self->priv->conditional_stack;
			_tmp8__length1 = self->priv->conditional_stack_length1;
			_tmp9_ = _tmp7_[_tmp8__length1 - 2];
			_tmp10_ = _tmp9_.skip_section;
			_tmp5_ = !_tmp10_;
		}
		_tmp11_ = _tmp5_;
		_tmp3_ = _tmp11_;
	} else {
		_tmp3_ = FALSE;
	}
	_tmp12_ = _tmp3_;
	if (_tmp12_) {
		ValaScannerConditional* _tmp13_;
		gint _tmp13__length1;
		ValaScannerConditional* _tmp14_;
		gint _tmp14__length1;
		_tmp13_ = self->priv->conditional_stack;
		_tmp13__length1 = self->priv->conditional_stack_length1;
		_tmp14_ = self->priv->conditional_stack;
		_tmp14__length1 = self->priv->conditional_stack_length1;
		_tmp13_[_tmp14__length1 - 1].matched = TRUE;
	} else {
		ValaScannerConditional* _tmp15_;
		gint _tmp15__length1;
		ValaScannerConditional* _tmp16_;
		gint _tmp16__length1;
		_tmp15_ = self->priv->conditional_stack;
		_tmp15__length1 = self->priv->conditional_stack_length1;
		_tmp16_ = self->priv->conditional_stack;
		_tmp16__length1 = self->priv->conditional_stack_length1;
		_tmp15_[_tmp16__length1 - 1].skip_section = TRUE;
	}
}


static void vala_scanner_parse_pp_elif (ValaScanner* self) {
	gboolean _tmp0_ = FALSE;
	gboolean condition;
	gboolean _tmp1_ = FALSE;
	ValaScannerConditional* _tmp2_;
	gint _tmp2__length1;
	gboolean _tmp7_;
	gboolean _tmp15_ = FALSE;
	gboolean _tmp16_ = FALSE;
	gboolean _tmp17_;
	gboolean _tmp22_;
	gboolean _tmp30_;
	g_return_if_fail (self != NULL);
	vala_scanner_pp_whitespace (self);
	_tmp0_ = vala_scanner_parse_pp_expression (self);
	condition = _tmp0_;
	vala_scanner_pp_eol (self);
	_tmp2_ = self->priv->conditional_stack;
	_tmp2__length1 = self->priv->conditional_stack_length1;
	if (_tmp2__length1 == 0) {
		_tmp1_ = TRUE;
	} else {
		ValaScannerConditional* _tmp3_;
		gint _tmp3__length1;
		ValaScannerConditional* _tmp4_;
		gint _tmp4__length1;
		ValaScannerConditional _tmp5_;
		gboolean _tmp6_;
		_tmp3_ = self->priv->conditional_stack;
		_tmp3__length1 = self->priv->conditional_stack_length1;
		_tmp4_ = self->priv->conditional_stack;
		_tmp4__length1 = self->priv->conditional_stack_length1;
		_tmp5_ = _tmp3_[_tmp4__length1 - 1];
		_tmp6_ = _tmp5_.else_found;
		_tmp1_ = _tmp6_;
	}
	_tmp7_ = _tmp1_;
	if (_tmp7_) {
		ValaSourceFile* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		ValaSourceReference* _tmp13_;
		ValaSourceReference* _tmp14_;
		_tmp8_ = self->priv->_source_file;
		_tmp9_ = self->priv->line;
		_tmp10_ = self->priv->column;
		_tmp11_ = self->priv->line;
		_tmp12_ = self->priv->column;
		_tmp13_ = vala_source_reference_new (_tmp8_, _tmp9_, _tmp10_, _tmp11_, _tmp12_);
		_tmp14_ = _tmp13_;
		vala_report_error (_tmp14_, "syntax error, unexpected #elif");
		_vala_source_reference_unref0 (_tmp14_);
		return;
	}
	_tmp17_ = condition;
	if (_tmp17_) {
		ValaScannerConditional* _tmp18_;
		gint _tmp18__length1;
		ValaScannerConditional* _tmp19_;
		gint _tmp19__length1;
		ValaScannerConditional _tmp20_;
		gboolean _tmp21_;
		_tmp18_ = self->priv->conditional_stack;
		_tmp18__length1 = self->priv->conditional_stack_length1;
		_tmp19_ = self->priv->conditional_stack;
		_tmp19__length1 = self->priv->conditional_stack_length1;
		_tmp20_ = _tmp18_[_tmp19__length1 - 1];
		_tmp21_ = _tmp20_.matched;
		_tmp16_ = !_tmp21_;
	} else {
		_tmp16_ = FALSE;
	}
	_tmp22_ = _tmp16_;
	if (_tmp22_) {
		gboolean _tmp23_ = FALSE;
		ValaScannerConditional* _tmp24_;
		gint _tmp24__length1;
		gboolean _tmp29_;
		_tmp24_ = self->priv->conditional_stack;
		_tmp24__length1 = self->priv->conditional_stack_length1;
		if (_tmp24__length1 == 1) {
			_tmp23_ = TRUE;
		} else {
			ValaScannerConditional* _tmp25_;
			gint _tmp25__length1;
			ValaScannerConditional* _tmp26_;
			gint _tmp26__length1;
			ValaScannerConditional _tmp27_;
			gboolean _tmp28_;
			_tmp25_ = self->priv->conditional_stack;
			_tmp25__length1 = self->priv->conditional_stack_length1;
			_tmp26_ = self->priv->conditional_stack;
			_tmp26__length1 = self->priv->conditional_stack_length1;
			_tmp27_ = _tmp25_[_tmp26__length1 - 2];
			_tmp28_ = _tmp27_.skip_section;
			_tmp23_ = !_tmp28_;
		}
		_tmp29_ = _tmp23_;
		_tmp15_ = _tmp29_;
	} else {
		_tmp15_ = FALSE;
	}
	_tmp30_ = _tmp15_;
	if (_tmp30_) {
		ValaScannerConditional* _tmp31_;
		gint _tmp31__length1;
		ValaScannerConditional* _tmp32_;
		gint _tmp32__length1;
		ValaScannerConditional* _tmp33_;
		gint _tmp33__length1;
		ValaScannerConditional* _tmp34_;
		gint _tmp34__length1;
		_tmp31_ = self->priv->conditional_stack;
		_tmp31__length1 = self->priv->conditional_stack_length1;
		_tmp32_ = self->priv->conditional_stack;
		_tmp32__length1 = self->priv->conditional_stack_length1;
		_tmp31_[_tmp32__length1 - 1].matched = TRUE;
		_tmp33_ = self->priv->conditional_stack;
		_tmp33__length1 = self->priv->conditional_stack_length1;
		_tmp34_ = self->priv->conditional_stack;
		_tmp34__length1 = self->priv->conditional_stack_length1;
		_tmp33_[_tmp34__length1 - 1].skip_section = FALSE;
	} else {
		ValaScannerConditional* _tmp35_;
		gint _tmp35__length1;
		ValaScannerConditional* _tmp36_;
		gint _tmp36__length1;
		_tmp35_ = self->priv->conditional_stack;
		_tmp35__length1 = self->priv->conditional_stack_length1;
		_tmp36_ = self->priv->conditional_stack;
		_tmp36__length1 = self->priv->conditional_stack_length1;
		_tmp35_[_tmp36__length1 - 1].skip_section = TRUE;
	}
}


static void vala_scanner_parse_pp_else (ValaScanner* self) {
	gboolean _tmp0_ = FALSE;
	ValaScannerConditional* _tmp1_;
	gint _tmp1__length1;
	gboolean _tmp6_;
	gboolean _tmp14_ = FALSE;
	ValaScannerConditional* _tmp15_;
	gint _tmp15__length1;
	ValaScannerConditional* _tmp16_;
	gint _tmp16__length1;
	ValaScannerConditional _tmp17_;
	gboolean _tmp18_;
	gboolean _tmp26_;
	g_return_if_fail (self != NULL);
	vala_scanner_pp_eol (self);
	_tmp1_ = self->priv->conditional_stack;
	_tmp1__length1 = self->priv->conditional_stack_length1;
	if (_tmp1__length1 == 0) {
		_tmp0_ = TRUE;
	} else {
		ValaScannerConditional* _tmp2_;
		gint _tmp2__length1;
		ValaScannerConditional* _tmp3_;
		gint _tmp3__length1;
		ValaScannerConditional _tmp4_;
		gboolean _tmp5_;
		_tmp2_ = self->priv->conditional_stack;
		_tmp2__length1 = self->priv->conditional_stack_length1;
		_tmp3_ = self->priv->conditional_stack;
		_tmp3__length1 = self->priv->conditional_stack_length1;
		_tmp4_ = _tmp2_[_tmp3__length1 - 1];
		_tmp5_ = _tmp4_.else_found;
		_tmp0_ = _tmp5_;
	}
	_tmp6_ = _tmp0_;
	if (_tmp6_) {
		ValaSourceFile* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		ValaSourceReference* _tmp12_;
		ValaSourceReference* _tmp13_;
		_tmp7_ = self->priv->_source_file;
		_tmp8_ = self->priv->line;
		_tmp9_ = self->priv->column;
		_tmp10_ = self->priv->line;
		_tmp11_ = self->priv->column;
		_tmp12_ = vala_source_reference_new (_tmp7_, _tmp8_, _tmp9_, _tmp10_, _tmp11_);
		_tmp13_ = _tmp12_;
		vala_report_error (_tmp13_, "syntax error, unexpected #else");
		_vala_source_reference_unref0 (_tmp13_);
		return;
	}
	_tmp15_ = self->priv->conditional_stack;
	_tmp15__length1 = self->priv->conditional_stack_length1;
	_tmp16_ = self->priv->conditional_stack;
	_tmp16__length1 = self->priv->conditional_stack_length1;
	_tmp17_ = _tmp15_[_tmp16__length1 - 1];
	_tmp18_ = _tmp17_.matched;
	if (!_tmp18_) {
		gboolean _tmp19_ = FALSE;
		ValaScannerConditional* _tmp20_;
		gint _tmp20__length1;
		gboolean _tmp25_;
		_tmp20_ = self->priv->conditional_stack;
		_tmp20__length1 = self->priv->conditional_stack_length1;
		if (_tmp20__length1 == 1) {
			_tmp19_ = TRUE;
		} else {
			ValaScannerConditional* _tmp21_;
			gint _tmp21__length1;
			ValaScannerConditional* _tmp22_;
			gint _tmp22__length1;
			ValaScannerConditional _tmp23_;
			gboolean _tmp24_;
			_tmp21_ = self->priv->conditional_stack;
			_tmp21__length1 = self->priv->conditional_stack_length1;
			_tmp22_ = self->priv->conditional_stack;
			_tmp22__length1 = self->priv->conditional_stack_length1;
			_tmp23_ = _tmp21_[_tmp22__length1 - 2];
			_tmp24_ = _tmp23_.skip_section;
			_tmp19_ = !_tmp24_;
		}
		_tmp25_ = _tmp19_;
		_tmp14_ = _tmp25_;
	} else {
		_tmp14_ = FALSE;
	}
	_tmp26_ = _tmp14_;
	if (_tmp26_) {
		ValaScannerConditional* _tmp27_;
		gint _tmp27__length1;
		ValaScannerConditional* _tmp28_;
		gint _tmp28__length1;
		ValaScannerConditional* _tmp29_;
		gint _tmp29__length1;
		ValaScannerConditional* _tmp30_;
		gint _tmp30__length1;
		_tmp27_ = self->priv->conditional_stack;
		_tmp27__length1 = self->priv->conditional_stack_length1;
		_tmp28_ = self->priv->conditional_stack;
		_tmp28__length1 = self->priv->conditional_stack_length1;
		_tmp27_[_tmp28__length1 - 1].matched = TRUE;
		_tmp29_ = self->priv->conditional_stack;
		_tmp29__length1 = self->priv->conditional_stack_length1;
		_tmp30_ = self->priv->conditional_stack;
		_tmp30__length1 = self->priv->conditional_stack_length1;
		_tmp29_[_tmp30__length1 - 1].skip_section = FALSE;
	} else {
		ValaScannerConditional* _tmp31_;
		gint _tmp31__length1;
		ValaScannerConditional* _tmp32_;
		gint _tmp32__length1;
		_tmp31_ = self->priv->conditional_stack;
		_tmp31__length1 = self->priv->conditional_stack_length1;
		_tmp32_ = self->priv->conditional_stack;
		_tmp32__length1 = self->priv->conditional_stack_length1;
		_tmp31_[_tmp32__length1 - 1].skip_section = TRUE;
	}
}


static void vala_scanner_parse_pp_endif (ValaScanner* self) {
	ValaScannerConditional* _tmp0_;
	gint _tmp0__length1;
	gint _tmp8_;
	g_return_if_fail (self != NULL);
	vala_scanner_pp_eol (self);
	_tmp0_ = self->priv->conditional_stack;
	_tmp0__length1 = self->priv->conditional_stack_length1;
	if (_tmp0__length1 == 0) {
		ValaSourceFile* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		ValaSourceReference* _tmp6_;
		ValaSourceReference* _tmp7_;
		_tmp1_ = self->priv->_source_file;
		_tmp2_ = self->priv->line;
		_tmp3_ = self->priv->column;
		_tmp4_ = self->priv->line;
		_tmp5_ = self->priv->column;
		_tmp6_ = vala_source_reference_new (_tmp1_, _tmp2_, _tmp3_, _tmp4_, _tmp5_);
		_tmp7_ = _tmp6_;
		vala_report_error (_tmp7_, "syntax error, unexpected #endif");
		_vala_source_reference_unref0 (_tmp7_);
		return;
	}
	_tmp8_ = self->priv->conditional_stack_length1;
	self->priv->conditional_stack_length1 = _tmp8_ - 1;
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* end;
	gchar* _tmp3_;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	gboolean _tmp3_;
	glong _tmp9_;
	glong _tmp15_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		glong _tmp4_;
		glong _tmp5_;
		glong _tmp6_ = 0L;
		_tmp4_ = offset;
		_tmp5_ = len;
		_tmp6_ = string_strnlen ((gchar*) self, _tmp4_ + _tmp5_);
		string_length = _tmp6_;
	} else {
		gint _tmp7_;
		gint _tmp8_;
		_tmp7_ = strlen (self);
		_tmp8_ = _tmp7_;
		string_length = (glong) _tmp8_;
	}
	_tmp9_ = offset;
	if (_tmp9_ < ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		glong _tmp12_;
		_tmp10_ = string_length;
		_tmp11_ = offset;
		offset = _tmp10_ + _tmp11_;
		_tmp12_ = offset;
		g_return_val_if_fail (_tmp12_ >= ((glong) 0), NULL);
	} else {
		glong _tmp13_;
		glong _tmp14_;
		_tmp13_ = offset;
		_tmp14_ = string_length;
		g_return_val_if_fail (_tmp13_ <= _tmp14_, NULL);
	}
	_tmp15_ = len;
	if (_tmp15_ < ((glong) 0)) {
		glong _tmp16_;
		glong _tmp17_;
		_tmp16_ = string_length;
		_tmp17_ = offset;
		len = _tmp16_ - _tmp17_;
	}
	_tmp18_ = offset;
	_tmp19_ = len;
	_tmp20_ = string_length;
	g_return_val_if_fail ((_tmp18_ + _tmp19_) <= _tmp20_, NULL);
	_tmp21_ = offset;
	_tmp22_ = len;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp21_, (gsize) _tmp22_);
	result = _tmp23_;
	return result;
}


static gboolean vala_scanner_parse_pp_symbol (ValaScanner* self) {
	gboolean result = FALSE;
	gint len;
	gint _tmp10_;
	gchar* _tmp18_;
	gint _tmp19_;
	gint _tmp20_;
	gchar* _tmp21_ = NULL;
	gchar* identifier;
	gboolean defined = FALSE;
	const gchar* _tmp22_;
	g_return_val_if_fail (self != NULL, FALSE);
	len = 0;
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gchar* _tmp1_;
		gchar* _tmp2_;
		gboolean _tmp6_;
		gchar* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		_tmp1_ = self->priv->current;
		_tmp2_ = self->priv->end;
		if (_tmp1_ < _tmp2_) {
			gchar* _tmp3_;
			gchar _tmp4_;
			gboolean _tmp5_ = FALSE;
			_tmp3_ = self->priv->current;
			_tmp4_ = _tmp3_[0];
			_tmp5_ = vala_scanner_is_ident_char (self, _tmp4_);
			_tmp0_ = _tmp5_;
		} else {
			_tmp0_ = FALSE;
		}
		_tmp6_ = _tmp0_;
		if (!_tmp6_) {
			break;
		}
		_tmp7_ = self->priv->current;
		self->priv->current = _tmp7_ + 1;
		_tmp8_ = self->priv->column;
		self->priv->column = _tmp8_ + 1;
		_tmp9_ = len;
		len = _tmp9_ + 1;
	}
	_tmp10_ = len;
	if (_tmp10_ == 0) {
		ValaSourceFile* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		ValaSourceReference* _tmp16_;
		ValaSourceReference* _tmp17_;
		_tmp11_ = self->priv->_source_file;
		_tmp12_ = self->priv->line;
		_tmp13_ = self->priv->column;
		_tmp14_ = self->priv->line;
		_tmp15_ = self->priv->column;
		_tmp16_ = vala_source_reference_new (_tmp11_, _tmp12_, _tmp13_, _tmp14_, _tmp15_);
		_tmp17_ = _tmp16_;
		vala_report_error (_tmp17_, "syntax error, expected identifier");
		_vala_source_reference_unref0 (_tmp17_);
		result = FALSE;
		return result;
	}
	_tmp18_ = self->priv->current;
	_tmp19_ = len;
	_tmp20_ = len;
	_tmp21_ = string_substring ((const gchar*) (_tmp18_ - _tmp19_), (glong) 0, (glong) _tmp20_);
	identifier = _tmp21_;
	_tmp22_ = identifier;
	if (g_strcmp0 (_tmp22_, "true") == 0) {
		defined = TRUE;
	} else {
		const gchar* _tmp23_;
		_tmp23_ = identifier;
		if (g_strcmp0 (_tmp23_, "false") == 0) {
			defined = FALSE;
		} else {
			ValaSourceFile* _tmp24_;
			ValaCodeContext* _tmp25_;
			ValaCodeContext* _tmp26_;
			const gchar* _tmp27_;
			gboolean _tmp28_ = FALSE;
			_tmp24_ = self->priv->_source_file;
			_tmp25_ = vala_source_file_get_context (_tmp24_);
			_tmp26_ = _tmp25_;
			_tmp27_ = identifier;
			_tmp28_ = vala_code_context_is_defined (_tmp26_, _tmp27_);
			defined = _tmp28_;
		}
	}
	result = defined;
	_g_free0 (identifier);
	return result;
}


static gboolean vala_scanner_parse_pp_primary_expression (ValaScanner* self) {
	gboolean result = FALSE;
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->current;
	_tmp1_ = self->priv->end;
	if (_tmp0_ >= _tmp1_) {
		ValaSourceFile* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		ValaSourceReference* _tmp7_;
		ValaSourceReference* _tmp8_;
		_tmp2_ = self->priv->_source_file;
		_tmp3_ = self->priv->line;
		_tmp4_ = self->priv->column;
		_tmp5_ = self->priv->line;
		_tmp6_ = self->priv->column;
		_tmp7_ = vala_source_reference_new (_tmp2_, _tmp3_, _tmp4_, _tmp5_, _tmp6_);
		_tmp8_ = _tmp7_;
		vala_report_error (_tmp8_, "syntax error, expected identifier");
		_vala_source_reference_unref0 (_tmp8_);
	} else {
		gchar* _tmp9_;
		gchar _tmp10_;
		gboolean _tmp11_ = FALSE;
		_tmp9_ = self->priv->current;
		_tmp10_ = _tmp9_[0];
		_tmp11_ = vala_scanner_is_ident_char (self, _tmp10_);
		if (_tmp11_) {
			gboolean _tmp12_ = FALSE;
			_tmp12_ = vala_scanner_parse_pp_symbol (self);
			result = _tmp12_;
			return result;
		} else {
			gchar* _tmp13_;
			gchar _tmp14_;
			_tmp13_ = self->priv->current;
			_tmp14_ = _tmp13_[0];
			if (_tmp14_ == '(') {
				gchar* _tmp15_;
				gint _tmp16_;
				gboolean _tmp17_ = FALSE;
				gboolean _result_;
				gboolean _tmp18_ = FALSE;
				gchar* _tmp19_;
				gchar* _tmp20_;
				gboolean _tmp23_;
				_tmp15_ = self->priv->current;
				self->priv->current = _tmp15_ + 1;
				_tmp16_ = self->priv->column;
				self->priv->column = _tmp16_ + 1;
				vala_scanner_pp_whitespace (self);
				_tmp17_ = vala_scanner_parse_pp_expression (self);
				_result_ = _tmp17_;
				vala_scanner_pp_whitespace (self);
				_tmp19_ = self->priv->current;
				_tmp20_ = self->priv->end;
				if (_tmp19_ < _tmp20_) {
					gchar* _tmp21_;
					gchar _tmp22_;
					_tmp21_ = self->priv->current;
					_tmp22_ = _tmp21_[0];
					_tmp18_ = _tmp22_ == ')';
				} else {
					_tmp18_ = FALSE;
				}
				_tmp23_ = _tmp18_;
				if (_tmp23_) {
					gchar* _tmp24_;
					gint _tmp25_;
					_tmp24_ = self->priv->current;
					self->priv->current = _tmp24_ + 1;
					_tmp25_ = self->priv->column;
					self->priv->column = _tmp25_ + 1;
				} else {
					ValaSourceFile* _tmp26_;
					gint _tmp27_;
					gint _tmp28_;
					gint _tmp29_;
					gint _tmp30_;
					ValaSourceReference* _tmp31_;
					ValaSourceReference* _tmp32_;
					_tmp26_ = self->priv->_source_file;
					_tmp27_ = self->priv->line;
					_tmp28_ = self->priv->column;
					_tmp29_ = self->priv->line;
					_tmp30_ = self->priv->column;
					_tmp31_ = vala_source_reference_new (_tmp26_, _tmp27_, _tmp28_, _tmp29_, _tmp30_);
					_tmp32_ = _tmp31_;
					vala_report_error (_tmp32_, "syntax error, expected `)'");
					_vala_source_reference_unref0 (_tmp32_);
				}
				result = _result_;
				return result;
			} else {
				ValaSourceFile* _tmp33_;
				gint _tmp34_;
				gint _tmp35_;
				gint _tmp36_;
				gint _tmp37_;
				ValaSourceReference* _tmp38_;
				ValaSourceReference* _tmp39_;
				_tmp33_ = self->priv->_source_file;
				_tmp34_ = self->priv->line;
				_tmp35_ = self->priv->column;
				_tmp36_ = self->priv->line;
				_tmp37_ = self->priv->column;
				_tmp38_ = vala_source_reference_new (_tmp33_, _tmp34_, _tmp35_, _tmp36_, _tmp37_);
				_tmp39_ = _tmp38_;
				vala_report_error (_tmp39_, "syntax error, expected identifier");
				_vala_source_reference_unref0 (_tmp39_);
			}
		}
	}
	result = FALSE;
	return result;
}


static gboolean vala_scanner_parse_pp_unary_expression (ValaScanner* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp5_;
	gboolean _tmp9_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->current;
	_tmp2_ = self->priv->end;
	if (_tmp1_ < _tmp2_) {
		gchar* _tmp3_;
		gchar _tmp4_;
		_tmp3_ = self->priv->current;
		_tmp4_ = _tmp3_[0];
		_tmp0_ = _tmp4_ == '!';
	} else {
		_tmp0_ = FALSE;
	}
	_tmp5_ = _tmp0_;
	if (_tmp5_) {
		gchar* _tmp6_;
		gint _tmp7_;
		gboolean _tmp8_ = FALSE;
		_tmp6_ = self->priv->current;
		self->priv->current = _tmp6_ + 1;
		_tmp7_ = self->priv->column;
		self->priv->column = _tmp7_ + 1;
		vala_scanner_pp_whitespace (self);
		_tmp8_ = vala_scanner_parse_pp_unary_expression (self);
		result = !_tmp8_;
		return result;
	}
	_tmp9_ = vala_scanner_parse_pp_primary_expression (self);
	result = _tmp9_;
	return result;
}


static gboolean vala_scanner_parse_pp_equality_expression (ValaScanner* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean left;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_scanner_parse_pp_unary_expression (self);
	left = _tmp0_;
	vala_scanner_pp_whitespace (self);
	while (TRUE) {
		gboolean _tmp1_ = FALSE;
		gboolean _tmp2_ = FALSE;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gboolean _tmp7_;
		gboolean _tmp10_;
		_tmp3_ = self->priv->current;
		_tmp4_ = self->priv->end;
		if (_tmp3_ < (_tmp4_ - 1)) {
			gchar* _tmp5_;
			gchar _tmp6_;
			_tmp5_ = self->priv->current;
			_tmp6_ = _tmp5_[0];
			_tmp2_ = _tmp6_ == '=';
		} else {
			_tmp2_ = FALSE;
		}
		_tmp7_ = _tmp2_;
		if (_tmp7_) {
			gchar* _tmp8_;
			gchar _tmp9_;
			_tmp8_ = self->priv->current;
			_tmp9_ = _tmp8_[1];
			_tmp1_ = _tmp9_ == '=';
		} else {
			_tmp1_ = FALSE;
		}
		_tmp10_ = _tmp1_;
		if (_tmp10_) {
			gchar* _tmp11_;
			gint _tmp12_;
			gboolean _tmp13_ = FALSE;
			gboolean right;
			gboolean _tmp14_;
			gboolean _tmp15_;
			_tmp11_ = self->priv->current;
			self->priv->current = _tmp11_ + 2;
			_tmp12_ = self->priv->column;
			self->priv->column = _tmp12_ + 2;
			vala_scanner_pp_whitespace (self);
			_tmp13_ = vala_scanner_parse_pp_unary_expression (self);
			right = _tmp13_;
			_tmp14_ = left;
			_tmp15_ = right;
			left = _tmp14_ == _tmp15_;
		} else {
			gboolean _tmp16_ = FALSE;
			gboolean _tmp17_ = FALSE;
			gchar* _tmp18_;
			gchar* _tmp19_;
			gboolean _tmp22_;
			gboolean _tmp25_;
			_tmp18_ = self->priv->current;
			_tmp19_ = self->priv->end;
			if (_tmp18_ < (_tmp19_ - 1)) {
				gchar* _tmp20_;
				gchar _tmp21_;
				_tmp20_ = self->priv->current;
				_tmp21_ = _tmp20_[0];
				_tmp17_ = _tmp21_ == '!';
			} else {
				_tmp17_ = FALSE;
			}
			_tmp22_ = _tmp17_;
			if (_tmp22_) {
				gchar* _tmp23_;
				gchar _tmp24_;
				_tmp23_ = self->priv->current;
				_tmp24_ = _tmp23_[1];
				_tmp16_ = _tmp24_ == '=';
			} else {
				_tmp16_ = FALSE;
			}
			_tmp25_ = _tmp16_;
			if (_tmp25_) {
				gchar* _tmp26_;
				gint _tmp27_;
				gboolean _tmp28_ = FALSE;
				gboolean right;
				gboolean _tmp29_;
				gboolean _tmp30_;
				_tmp26_ = self->priv->current;
				self->priv->current = _tmp26_ + 2;
				_tmp27_ = self->priv->column;
				self->priv->column = _tmp27_ + 2;
				vala_scanner_pp_whitespace (self);
				_tmp28_ = vala_scanner_parse_pp_unary_expression (self);
				right = _tmp28_;
				_tmp29_ = left;
				_tmp30_ = right;
				left = _tmp29_ != _tmp30_;
			} else {
				break;
			}
		}
	}
	result = left;
	return result;
}


static gboolean vala_scanner_parse_pp_and_expression (ValaScanner* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean left;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_scanner_parse_pp_equality_expression (self);
	left = _tmp0_;
	vala_scanner_pp_whitespace (self);
	while (TRUE) {
		gboolean _tmp1_ = FALSE;
		gboolean _tmp2_ = FALSE;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gboolean _tmp7_;
		gboolean _tmp10_;
		gchar* _tmp11_;
		gint _tmp12_;
		gboolean _tmp13_ = FALSE;
		gboolean right;
		gboolean _tmp14_ = FALSE;
		gboolean _tmp15_;
		gboolean _tmp17_;
		_tmp3_ = self->priv->current;
		_tmp4_ = self->priv->end;
		if (_tmp3_ < (_tmp4_ - 1)) {
			gchar* _tmp5_;
			gchar _tmp6_;
			_tmp5_ = self->priv->current;
			_tmp6_ = _tmp5_[0];
			_tmp2_ = _tmp6_ == '&';
		} else {
			_tmp2_ = FALSE;
		}
		_tmp7_ = _tmp2_;
		if (_tmp7_) {
			gchar* _tmp8_;
			gchar _tmp9_;
			_tmp8_ = self->priv->current;
			_tmp9_ = _tmp8_[1];
			_tmp1_ = _tmp9_ == '&';
		} else {
			_tmp1_ = FALSE;
		}
		_tmp10_ = _tmp1_;
		if (!_tmp10_) {
			break;
		}
		_tmp11_ = self->priv->current;
		self->priv->current = _tmp11_ + 2;
		_tmp12_ = self->priv->column;
		self->priv->column = _tmp12_ + 2;
		vala_scanner_pp_whitespace (self);
		_tmp13_ = vala_scanner_parse_pp_equality_expression (self);
		right = _tmp13_;
		_tmp15_ = left;
		if (_tmp15_) {
			gboolean _tmp16_;
			_tmp16_ = right;
			_tmp14_ = _tmp16_;
		} else {
			_tmp14_ = FALSE;
		}
		_tmp17_ = _tmp14_;
		left = _tmp17_;
	}
	result = left;
	return result;
}


static gboolean vala_scanner_parse_pp_or_expression (ValaScanner* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean left;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_scanner_parse_pp_and_expression (self);
	left = _tmp0_;
	vala_scanner_pp_whitespace (self);
	while (TRUE) {
		gboolean _tmp1_ = FALSE;
		gboolean _tmp2_ = FALSE;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gboolean _tmp7_;
		gboolean _tmp10_;
		gchar* _tmp11_;
		gint _tmp12_;
		gboolean _tmp13_ = FALSE;
		gboolean right;
		gboolean _tmp14_ = FALSE;
		gboolean _tmp15_;
		gboolean _tmp17_;
		_tmp3_ = self->priv->current;
		_tmp4_ = self->priv->end;
		if (_tmp3_ < (_tmp4_ - 1)) {
			gchar* _tmp5_;
			gchar _tmp6_;
			_tmp5_ = self->priv->current;
			_tmp6_ = _tmp5_[0];
			_tmp2_ = _tmp6_ == '|';
		} else {
			_tmp2_ = FALSE;
		}
		_tmp7_ = _tmp2_;
		if (_tmp7_) {
			gchar* _tmp8_;
			gchar _tmp9_;
			_tmp8_ = self->priv->current;
			_tmp9_ = _tmp8_[1];
			_tmp1_ = _tmp9_ == '|';
		} else {
			_tmp1_ = FALSE;
		}
		_tmp10_ = _tmp1_;
		if (!_tmp10_) {
			break;
		}
		_tmp11_ = self->priv->current;
		self->priv->current = _tmp11_ + 2;
		_tmp12_ = self->priv->column;
		self->priv->column = _tmp12_ + 2;
		vala_scanner_pp_whitespace (self);
		_tmp13_ = vala_scanner_parse_pp_and_expression (self);
		right = _tmp13_;
		_tmp15_ = left;
		if (_tmp15_) {
			_tmp14_ = TRUE;
		} else {
			gboolean _tmp16_;
			_tmp16_ = right;
			_tmp14_ = _tmp16_;
		}
		_tmp17_ = _tmp14_;
		left = _tmp17_;
	}
	result = left;
	return result;
}


static gboolean vala_scanner_parse_pp_expression (ValaScanner* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_scanner_parse_pp_or_expression (self);
	result = _tmp0_;
	return result;
}


static gboolean vala_scanner_whitespace (ValaScanner* self) {
	gboolean result = FALSE;
	gboolean found;
	gint _tmp0_;
	gboolean bol;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_;
	gboolean _tmp18_;
	gboolean _tmp21_;
	g_return_val_if_fail (self != NULL, FALSE);
	found = FALSE;
	_tmp0_ = self->priv->column;
	bol = _tmp0_ == 1;
	while (TRUE) {
		gboolean _tmp1_ = FALSE;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gboolean _tmp7_;
		gchar* _tmp8_;
		gchar _tmp9_;
		gchar* _tmp11_;
		gint _tmp12_;
		_tmp2_ = self->priv->current;
		_tmp3_ = self->priv->end;
		if (_tmp2_ < _tmp3_) {
			gchar* _tmp4_;
			gchar _tmp5_;
			gboolean _tmp6_ = FALSE;
			_tmp4_ = self->priv->current;
			_tmp5_ = _tmp4_[0];
			_tmp6_ = g_ascii_isspace (_tmp5_);
			_tmp1_ = _tmp6_;
		} else {
			_tmp1_ = FALSE;
		}
		_tmp7_ = _tmp1_;
		if (!_tmp7_) {
			break;
		}
		_tmp8_ = self->priv->current;
		_tmp9_ = _tmp8_[0];
		if (_tmp9_ == '\n') {
			gint _tmp10_;
			_tmp10_ = self->priv->line;
			self->priv->line = _tmp10_ + 1;
			self->priv->column = 0;
			bol = TRUE;
		}
		found = TRUE;
		_tmp11_ = self->priv->current;
		self->priv->current = _tmp11_ + 1;
		_tmp12_ = self->priv->column;
		self->priv->column = _tmp12_ + 1;
	}
	_tmp15_ = bol;
	if (_tmp15_) {
		gchar* _tmp16_;
		gchar* _tmp17_;
		_tmp16_ = self->priv->current;
		_tmp17_ = self->priv->end;
		_tmp14_ = _tmp16_ < _tmp17_;
	} else {
		_tmp14_ = FALSE;
	}
	_tmp18_ = _tmp14_;
	if (_tmp18_) {
		gchar* _tmp19_;
		gchar _tmp20_;
		_tmp19_ = self->priv->current;
		_tmp20_ = _tmp19_[0];
		_tmp13_ = _tmp20_ == '#';
	} else {
		_tmp13_ = FALSE;
	}
	_tmp21_ = _tmp13_;
	if (_tmp21_) {
		vala_scanner_pp_directive (self);
		result = TRUE;
		return result;
	}
	result = found;
	return result;
}


static gboolean vala_scanner_comment (ValaScanner* self, gboolean file_comment) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gchar* _tmp3_;
	gboolean _tmp6_;
	gboolean _tmp9_;
	gboolean _tmp16_;
	gchar* _tmp17_;
	gchar _tmp18_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp3_ = self->priv->current;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp4_ = self->priv->current;
		_tmp5_ = self->priv->end;
		_tmp2_ = _tmp4_ > (_tmp5_ - 2);
	}
	_tmp6_ = _tmp2_;
	if (_tmp6_) {
		_tmp1_ = TRUE;
	} else {
		gchar* _tmp7_;
		gchar _tmp8_;
		_tmp7_ = self->priv->current;
		_tmp8_ = _tmp7_[0];
		_tmp1_ = _tmp8_ != '/';
	}
	_tmp9_ = _tmp1_;
	if (_tmp9_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp10_ = FALSE;
		gchar* _tmp11_;
		gchar _tmp12_;
		gboolean _tmp15_;
		_tmp11_ = self->priv->current;
		_tmp12_ = _tmp11_[1];
		if (_tmp12_ != '/') {
			gchar* _tmp13_;
			gchar _tmp14_;
			_tmp13_ = self->priv->current;
			_tmp14_ = _tmp13_[1];
			_tmp10_ = _tmp14_ != '*';
		} else {
			_tmp10_ = FALSE;
		}
		_tmp15_ = _tmp10_;
		_tmp0_ = _tmp15_;
	}
	_tmp16_ = _tmp0_;
	if (_tmp16_) {
		result = FALSE;
		return result;
	}
	_tmp17_ = self->priv->current;
	_tmp18_ = _tmp17_[1];
	if (_tmp18_ == '/') {
		ValaSourceReference* source_reference;
		gboolean _tmp19_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		gchar* begin;
		ValaSourceReference* _tmp35_;
		source_reference = NULL;
		_tmp19_ = file_comment;
		if (_tmp19_) {
			ValaSourceFile* _tmp20_;
			gint _tmp21_;
			gint _tmp22_;
			gint _tmp23_;
			gint _tmp24_;
			ValaSourceReference* _tmp25_;
			_tmp20_ = self->priv->_source_file;
			_tmp21_ = self->priv->line;
			_tmp22_ = self->priv->column;
			_tmp23_ = self->priv->line;
			_tmp24_ = self->priv->column;
			_tmp25_ = vala_source_reference_new (_tmp20_, _tmp21_, _tmp22_, _tmp23_, _tmp24_);
			_vala_source_reference_unref0 (source_reference);
			source_reference = _tmp25_;
		}
		_tmp26_ = self->priv->current;
		self->priv->current = _tmp26_ + 2;
		_tmp27_ = self->priv->current;
		begin = _tmp27_;
		while (TRUE) {
			gboolean _tmp28_ = FALSE;
			gchar* _tmp29_;
			gchar* _tmp30_;
			gboolean _tmp33_;
			gchar* _tmp34_;
			_tmp29_ = self->priv->current;
			_tmp30_ = self->priv->end;
			if (_tmp29_ < _tmp30_) {
				gchar* _tmp31_;
				gchar _tmp32_;
				_tmp31_ = self->priv->current;
				_tmp32_ = _tmp31_[0];
				_tmp28_ = _tmp32_ != '\n';
			} else {
				_tmp28_ = FALSE;
			}
			_tmp33_ = _tmp28_;
			if (!_tmp33_) {
				break;
			}
			_tmp34_ = self->priv->current;
			self->priv->current = _tmp34_ + 1;
		}
		_tmp35_ = source_reference;
		if (_tmp35_ != NULL) {
			gchar* _tmp36_;
			gchar* _tmp37_;
			gchar* _tmp38_;
			gchar* _tmp39_ = NULL;
			gchar* _tmp40_;
			ValaSourceReference* _tmp41_;
			gboolean _tmp42_;
			_tmp36_ = begin;
			_tmp37_ = self->priv->current;
			_tmp38_ = begin;
			_tmp39_ = string_substring ((const gchar*) _tmp36_, (glong) 0, (glong) (_tmp37_ - _tmp38_));
			_tmp40_ = _tmp39_;
			_tmp41_ = source_reference;
			_tmp42_ = file_comment;
			vala_scanner_push_comment (self, _tmp40_, _tmp41_, _tmp42_);
			_g_free0 (_tmp40_);
		}
		_vala_source_reference_unref0 (source_reference);
	} else {
		ValaSourceReference* source_reference;
		gboolean _tmp43_ = FALSE;
		gboolean _tmp44_;
		gboolean _tmp47_;
		gboolean _tmp48_ = FALSE;
		gchar* _tmp49_;
		gchar _tmp50_;
		gboolean _tmp52_;
		gchar* _tmp59_;
		gchar* _tmp60_;
		gchar* begin;
		gchar* _tmp76_;
		gchar* _tmp77_;
		ValaSourceReference* _tmp85_;
		gchar* _tmp93_;
		gint _tmp94_;
		source_reference = NULL;
		_tmp44_ = file_comment;
		if (_tmp44_) {
			gchar* _tmp45_;
			gchar _tmp46_;
			_tmp45_ = self->priv->current;
			_tmp46_ = _tmp45_[2];
			_tmp43_ = _tmp46_ == '*';
		} else {
			_tmp43_ = FALSE;
		}
		_tmp47_ = _tmp43_;
		if (_tmp47_) {
			result = FALSE;
			_vala_source_reference_unref0 (source_reference);
			return result;
		}
		_tmp49_ = self->priv->current;
		_tmp50_ = _tmp49_[2];
		if (_tmp50_ == '*') {
			_tmp48_ = TRUE;
		} else {
			gboolean _tmp51_;
			_tmp51_ = file_comment;
			_tmp48_ = _tmp51_;
		}
		_tmp52_ = _tmp48_;
		if (_tmp52_) {
			ValaSourceFile* _tmp53_;
			gint _tmp54_;
			gint _tmp55_;
			gint _tmp56_;
			gint _tmp57_;
			ValaSourceReference* _tmp58_;
			_tmp53_ = self->priv->_source_file;
			_tmp54_ = self->priv->line;
			_tmp55_ = self->priv->column;
			_tmp56_ = self->priv->line;
			_tmp57_ = self->priv->column;
			_tmp58_ = vala_source_reference_new (_tmp53_, _tmp54_, _tmp55_, _tmp56_, _tmp57_);
			_vala_source_reference_unref0 (source_reference);
			source_reference = _tmp58_;
		}
		_tmp59_ = self->priv->current;
		self->priv->current = _tmp59_ + 2;
		_tmp60_ = self->priv->current;
		begin = _tmp60_;
		while (TRUE) {
			gboolean _tmp61_ = FALSE;
			gchar* _tmp62_;
			gchar* _tmp63_;
			gboolean _tmp70_;
			gchar* _tmp71_;
			gchar _tmp72_;
			gchar* _tmp74_;
			gint _tmp75_;
			_tmp62_ = self->priv->current;
			_tmp63_ = self->priv->end;
			if (_tmp62_ < (_tmp63_ - 1)) {
				gboolean _tmp64_ = FALSE;
				gchar* _tmp65_;
				gchar _tmp66_;
				gboolean _tmp69_;
				_tmp65_ = self->priv->current;
				_tmp66_ = _tmp65_[0];
				if (_tmp66_ != '*') {
					_tmp64_ = TRUE;
				} else {
					gchar* _tmp67_;
					gchar _tmp68_;
					_tmp67_ = self->priv->current;
					_tmp68_ = _tmp67_[1];
					_tmp64_ = _tmp68_ != '/';
				}
				_tmp69_ = _tmp64_;
				_tmp61_ = _tmp69_;
			} else {
				_tmp61_ = FALSE;
			}
			_tmp70_ = _tmp61_;
			if (!_tmp70_) {
				break;
			}
			_tmp71_ = self->priv->current;
			_tmp72_ = _tmp71_[0];
			if (_tmp72_ == '\n') {
				gint _tmp73_;
				_tmp73_ = self->priv->line;
				self->priv->line = _tmp73_ + 1;
				self->priv->column = 0;
			}
			_tmp74_ = self->priv->current;
			self->priv->current = _tmp74_ + 1;
			_tmp75_ = self->priv->column;
			self->priv->column = _tmp75_ + 1;
		}
		_tmp76_ = self->priv->current;
		_tmp77_ = self->priv->end;
		if (_tmp76_ == (_tmp77_ - 1)) {
			ValaSourceFile* _tmp78_;
			gint _tmp79_;
			gint _tmp80_;
			gint _tmp81_;
			gint _tmp82_;
			ValaSourceReference* _tmp83_;
			ValaSourceReference* _tmp84_;
			_tmp78_ = self->priv->_source_file;
			_tmp79_ = self->priv->line;
			_tmp80_ = self->priv->column;
			_tmp81_ = self->priv->line;
			_tmp82_ = self->priv->column;
			_tmp83_ = vala_source_reference_new (_tmp78_, _tmp79_, _tmp80_, _tmp81_, _tmp82_);
			_tmp84_ = _tmp83_;
			vala_report_error (_tmp84_, "syntax error, expected */");
			_vala_source_reference_unref0 (_tmp84_);
			result = TRUE;
			_vala_source_reference_unref0 (source_reference);
			return result;
		}
		_tmp85_ = source_reference;
		if (_tmp85_ != NULL) {
			gchar* _tmp86_;
			gchar* _tmp87_;
			gchar* _tmp88_;
			gchar* _tmp89_ = NULL;
			gchar* _tmp90_;
			ValaSourceReference* _tmp91_;
			gboolean _tmp92_;
			_tmp86_ = begin;
			_tmp87_ = self->priv->current;
			_tmp88_ = begin;
			_tmp89_ = string_substring ((const gchar*) _tmp86_, (glong) 0, (glong) (_tmp87_ - _tmp88_));
			_tmp90_ = _tmp89_;
			_tmp91_ = source_reference;
			_tmp92_ = file_comment;
			vala_scanner_push_comment (self, _tmp90_, _tmp91_, _tmp92_);
			_g_free0 (_tmp90_);
		}
		_tmp93_ = self->priv->current;
		self->priv->current = _tmp93_ + 2;
		_tmp94_ = self->priv->column;
		self->priv->column = _tmp94_ + 2;
		_vala_source_reference_unref0 (source_reference);
	}
	result = TRUE;
	return result;
}


static void vala_scanner_space (ValaScanner* self) {
	g_return_if_fail (self != NULL);
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_ = FALSE;
		gboolean _tmp3_;
		_tmp1_ = vala_scanner_whitespace (self);
		if (_tmp1_) {
			_tmp0_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			_tmp2_ = vala_scanner_comment (self, FALSE);
			_tmp0_ = _tmp2_;
		}
		_tmp3_ = _tmp0_;
		if (!_tmp3_) {
			break;
		}
	}
}


void vala_scanner_parse_file_comments (ValaScanner* self) {
	g_return_if_fail (self != NULL);
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_ = FALSE;
		gboolean _tmp3_;
		_tmp1_ = vala_scanner_whitespace (self);
		if (_tmp1_) {
			_tmp0_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			_tmp2_ = vala_scanner_comment (self, TRUE);
			_tmp0_ = _tmp2_;
		}
		_tmp3_ = _tmp0_;
		if (!_tmp3_) {
			break;
		}
	}
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_;
	gchar _tmp1_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static void vala_scanner_push_comment (ValaScanner* self, const gchar* comment_item, ValaSourceReference* source_reference, gboolean file_comment) {
	const gchar* _tmp0_;
	gchar _tmp1_ = '\0';
	gboolean _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (comment_item != NULL);
	g_return_if_fail (source_reference != NULL);
	_tmp0_ = comment_item;
	_tmp1_ = string_get (_tmp0_, (glong) 0);
	if (_tmp1_ == '*') {
		ValaComment* _tmp2_;
		const gchar* _tmp5_;
		ValaSourceReference* _tmp6_;
		ValaComment* _tmp7_;
		_tmp2_ = self->priv->_comment;
		if (_tmp2_ != NULL) {
			ValaSourceFile* _tmp3_;
			ValaComment* _tmp4_;
			_tmp3_ = self->priv->_source_file;
			_tmp4_ = self->priv->_comment;
			vala_source_file_add_comment (_tmp3_, _tmp4_);
		}
		_tmp5_ = comment_item;
		_tmp6_ = source_reference;
		_tmp7_ = vala_comment_new (_tmp5_, _tmp6_);
		_vala_comment_unref0 (self->priv->_comment);
		self->priv->_comment = _tmp7_;
	}
	_tmp8_ = file_comment;
	if (_tmp8_) {
		ValaSourceFile* _tmp9_;
		const gchar* _tmp10_;
		ValaSourceReference* _tmp11_;
		ValaComment* _tmp12_;
		ValaComment* _tmp13_;
		_tmp9_ = self->priv->_source_file;
		_tmp10_ = comment_item;
		_tmp11_ = source_reference;
		_tmp12_ = vala_comment_new (_tmp10_, _tmp11_);
		_tmp13_ = _tmp12_;
		vala_source_file_add_comment (_tmp9_, _tmp13_);
		_vala_comment_unref0 (_tmp13_);
		_vala_comment_unref0 (self->priv->_comment);
		self->priv->_comment = NULL;
	}
}


/**
 * Clears and returns the content of the comment stack.
 *
 * @return saved comment
 */
static gpointer _vala_comment_ref0 (gpointer self) {
	return self ? vala_comment_ref (self) : NULL;
}


ValaComment* vala_scanner_pop_comment (ValaScanner* self) {
	ValaComment* result = NULL;
	ValaComment* _tmp0_;
	ValaComment* _tmp1_;
	ValaComment* _tmp2_;
	ValaComment* comment;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_comment;
	if (_tmp0_ == NULL) {
		result = NULL;
		return result;
	}
	_tmp1_ = self->priv->_comment;
	_tmp2_ = _vala_comment_ref0 (_tmp1_);
	comment = _tmp2_;
	_vala_comment_unref0 (self->priv->_comment);
	self->priv->_comment = NULL;
	result = comment;
	return result;
}


ValaSourceFile* vala_scanner_get_source_file (ValaScanner* self) {
	ValaSourceFile* result;
	ValaSourceFile* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_source_file;
	result = _tmp0_;
	return result;
}


static gpointer _vala_source_file_ref0 (gpointer self) {
	return self ? vala_source_file_ref (self) : NULL;
}


static void vala_scanner_set_source_file (ValaScanner* self, ValaSourceFile* value) {
	ValaSourceFile* _tmp0_;
	ValaSourceFile* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_source_file_ref0 (_tmp0_);
	_vala_source_file_unref0 (self->priv->_source_file);
	self->priv->_source_file = _tmp1_;
}


static ValaScannerConditional* vala_scanner_conditional_dup (const ValaScannerConditional* self) {
	ValaScannerConditional* dup;
	dup = g_new0 (ValaScannerConditional, 1);
	memcpy (dup, self, sizeof (ValaScannerConditional));
	return dup;
}


static void vala_scanner_conditional_free (ValaScannerConditional* self) {
	g_free (self);
}


static GType vala_scanner_conditional_get_type (void) {
	static volatile gsize vala_scanner_conditional_type_id__volatile = 0;
	if (g_once_init_enter (&vala_scanner_conditional_type_id__volatile)) {
		GType vala_scanner_conditional_type_id;
		vala_scanner_conditional_type_id = g_boxed_type_register_static ("ValaScannerConditional", (GBoxedCopyFunc) vala_scanner_conditional_dup, (GBoxedFreeFunc) vala_scanner_conditional_free);
		g_once_init_leave (&vala_scanner_conditional_type_id__volatile, vala_scanner_conditional_type_id);
	}
	return vala_scanner_conditional_type_id__volatile;
}


static void vala_value_scanner_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void vala_value_scanner_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		vala_scanner_unref (value->data[0].v_pointer);
	}
}


static void vala_value_scanner_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_scanner_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer vala_value_scanner_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* vala_value_scanner_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		ValaScanner* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_scanner_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* vala_value_scanner_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ValaScanner** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_scanner_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* vala_param_spec_scanner (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ValaParamSpecScanner* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_TYPE_SCANNER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer vala_value_get_scanner (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_SCANNER), NULL);
	return value->data[0].v_pointer;
}


void vala_value_set_scanner (GValue* value, gpointer v_object) {
	ValaScanner* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_SCANNER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_SCANNER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_scanner_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_scanner_unref (old);
	}
}


void vala_value_take_scanner (GValue* value, gpointer v_object) {
	ValaScanner* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_SCANNER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_SCANNER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_scanner_unref (old);
	}
}


static void vala_scanner_class_init (ValaScannerClass * klass) {
	vala_scanner_parent_class = g_type_class_peek_parent (klass);
	VALA_SCANNER_CLASS (klass)->finalize = vala_scanner_finalize;
	g_type_class_add_private (klass, sizeof (ValaScannerPrivate));
}


static void vala_scanner_instance_init (ValaScanner * self) {
	self->priv = VALA_SCANNER_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void vala_scanner_finalize (ValaScanner* obj) {
	ValaScanner * self;
	self = VALA_SCANNER (obj);
	_vala_source_file_unref0 (self->priv->_source_file);
	_vala_comment_unref0 (self->priv->_comment);
	self->priv->conditional_stack = (g_free (self->priv->conditional_stack), NULL);
	self->priv->state_stack = (g_free (self->priv->state_stack), NULL);
}


/**
 * Lexical scanner for Vala source files.
 */
GType vala_scanner_get_type (void) {
	static volatile gsize vala_scanner_type_id__volatile = 0;
	if (g_once_init_enter (&vala_scanner_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { vala_value_scanner_init, vala_value_scanner_free_value, vala_value_scanner_copy_value, vala_value_scanner_peek_pointer, "p", vala_value_scanner_collect_value, "p", vala_value_scanner_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ValaScannerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_scanner_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaScanner), 0, (GInstanceInitFunc) vala_scanner_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType vala_scanner_type_id;
		vala_scanner_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaScanner", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&vala_scanner_type_id__volatile, vala_scanner_type_id);
	}
	return vala_scanner_type_id__volatile;
}


gpointer vala_scanner_ref (gpointer instance) {
	ValaScanner* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void vala_scanner_unref (gpointer instance) {
	ValaScanner* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_SCANNER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}



