/* valaclass.c generated by valac, the Vala compiler
 * generated from valaclass.vala, do not modify */

/* valaclass.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */


#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <valagee.h>
#include <stdlib.h>
#include <string.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))

struct _ValaClassPrivate {
	ValaClass* _base_class;
	gboolean _is_abstract;
	gboolean _has_private_fields;
	gboolean _has_class_private_fields;
	gboolean* _is_compact;
	gboolean* _is_immutable;
	ValaList* base_types;
	ValaCreationMethod* _default_construction_method;
	ValaConstructor* _constructor;
	ValaConstructor* _class_constructor;
	ValaConstructor* _static_constructor;
	ValaDestructor* _static_destructor;
	ValaDestructor* _class_destructor;
	ValaDestructor* _destructor;
};


static gint ValaClass_private_offset;
static gpointer vala_class_parent_class = NULL;

static void vala_class_real_add_field (ValaSymbol* base,
                                ValaField* f);
static void vala_class_set_has_class_private_fields (ValaClass* self,
                                              gboolean value);
static void vala_class_real_add_method (ValaSymbol* base,
                                 ValaMethod* m);
static void vala_class_real_add_property (ValaSymbol* base,
                                   ValaProperty* prop);
static void vala_class_real_add_constructor (ValaSymbol* base,
                                      ValaConstructor* c);
static void vala_class_real_add_destructor (ValaSymbol* base,
                                     ValaDestructor* d);
static void vala_class_real_accept (ValaCodeNode* base,
                             ValaCodeVisitor* visitor);
static void vala_class_real_accept_children (ValaCodeNode* base,
                                      ValaCodeVisitor* visitor);
static gboolean vala_class_real_is_reference_type (ValaTypeSymbol* base);
static gboolean vala_class_real_is_subtype_of (ValaTypeSymbol* base,
                                        ValaTypeSymbol* t);
static void vala_class_real_replace_type (ValaCodeNode* base,
                                   ValaDataType* old_type,
                                   ValaDataType* new_type);
static void vala_class_get_all_prerequisites (ValaClass* self,
                                       ValaInterface* iface,
                                       ValaList* list);
static gboolean vala_class_class_is_a (ValaClass* self,
                                ValaClass* cl,
                                ValaTypeSymbol* t);
static gboolean vala_class_real_check (ValaCodeNode* base,
                                ValaCodeContext* context);
static gboolean* _bool_dup (gboolean* self);
static void vala_class_finalize (ValaCodeNode * obj);


static inline gpointer
vala_class_get_instance_private (ValaClass* self)
{
	return G_STRUCT_MEMBER_P (self, ValaClass_private_offset);
}


/**
 * Creates a new class.
 *
 * @param name             type name
 * @param source_reference reference to source code
 * @param comment          class documentation
 * @return                 newly created class
 */
ValaClass*
vala_class_construct (GType object_type,
                      const gchar* name,
                      ValaSourceReference* source_reference,
                      ValaComment* comment)
{
	ValaClass* self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (ValaClass*) vala_object_type_symbol_construct (object_type, name, source_reference, comment);
	return self;
}


ValaClass*
vala_class_new (const gchar* name,
                ValaSourceReference* source_reference,
                ValaComment* comment)
{
	return vala_class_construct (VALA_TYPE_CLASS, name, source_reference, comment);
}


/**
 * Adds the specified class or interface to the list of base types of
 * this class.
 *
 * @param type a class or interface reference
 */
void
vala_class_add_base_type (ValaClass* self,
                          ValaDataType* type)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	_tmp0_ = self->priv->base_types;
	vala_collection_add ((ValaCollection*) _tmp0_, type);
	vala_code_node_set_parent_node ((ValaCodeNode*) type, (ValaCodeNode*) self);
}


/**
 * Returns a copy of the base type list.
 *
 * @return list of base types
 */
static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}


ValaList*
vala_class_get_base_types (ValaClass* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->base_types;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Adds the specified field as a member to this class.
 *
 * @param f a field
 */
static void
vala_class_real_add_field (ValaSymbol* base,
                           ValaField* f)
{
	ValaClass * self;
	gboolean _tmp0_ = FALSE;
	ValaSymbolAccessibility _tmp1_;
	ValaSymbolAccessibility _tmp2_;
	self = (ValaClass*) base;
	g_return_if_fail (f != NULL);
	VALA_SYMBOL_CLASS (vala_class_parent_class)->add_field ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), f);
	_tmp1_ = vala_symbol_get_access ((ValaSymbol*) f);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		ValaMemberBinding _tmp3_;
		ValaMemberBinding _tmp4_;
		_tmp3_ = vala_field_get_binding (f);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		vala_class_set_has_private_fields (self, TRUE);
	} else {
		gboolean _tmp5_ = FALSE;
		ValaSymbolAccessibility _tmp6_;
		ValaSymbolAccessibility _tmp7_;
		_tmp6_ = vala_symbol_get_access ((ValaSymbol*) f);
		_tmp7_ = _tmp6_;
		if (_tmp7_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
			ValaMemberBinding _tmp8_;
			ValaMemberBinding _tmp9_;
			_tmp8_ = vala_field_get_binding (f);
			_tmp9_ = _tmp8_;
			_tmp5_ = _tmp9_ == VALA_MEMBER_BINDING_CLASS;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			vala_class_set_has_class_private_fields (self, TRUE);
		}
	}
}


/**
 * Adds the specified method as a member to this class.
 *
 * @param m a method
 */
static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


static void
vala_class_real_add_method (ValaSymbol* base,
                            ValaMethod* m)
{
	ValaClass * self;
	gboolean _tmp0_ = FALSE;
	ValaMemberBinding _tmp1_;
	ValaMemberBinding _tmp2_;
	gboolean _tmp23_ = FALSE;
	ValaDataType* _tmp24_;
	ValaDataType* _tmp25_;
	ValaDataType* _tmp69_;
	ValaDataType* _tmp70_;
	self = (ValaClass*) base;
	g_return_if_fail (m != NULL);
	_tmp1_ = vala_method_get_binding (m);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == VALA_MEMBER_BINDING_INSTANCE) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = G_TYPE_CHECK_INSTANCE_TYPE (m, VALA_TYPE_CREATION_METHOD);
	}
	if (_tmp0_) {
		ValaParameter* _tmp3_;
		ValaParameter* _tmp4_;
		ValaObjectType* _tmp11_;
		ValaObjectType* _tmp12_;
		ValaParameter* _tmp13_;
		ValaParameter* _tmp14_;
		ValaScope* _tmp15_;
		ValaScope* _tmp16_;
		ValaParameter* _tmp17_;
		ValaParameter* _tmp18_;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		ValaParameter* _tmp21_;
		ValaParameter* _tmp22_;
		_tmp3_ = vala_method_get_this_parameter (m);
		_tmp4_ = _tmp3_;
		if (_tmp4_ != NULL) {
			ValaScope* _tmp5_;
			ValaScope* _tmp6_;
			ValaParameter* _tmp7_;
			ValaParameter* _tmp8_;
			const gchar* _tmp9_;
			const gchar* _tmp10_;
			_tmp5_ = vala_symbol_get_scope ((ValaSymbol*) m);
			_tmp6_ = _tmp5_;
			_tmp7_ = vala_method_get_this_parameter (m);
			_tmp8_ = _tmp7_;
			_tmp9_ = vala_symbol_get_name ((ValaSymbol*) _tmp8_);
			_tmp10_ = _tmp9_;
			vala_scope_remove (_tmp6_, _tmp10_);
		}
		_tmp11_ = vala_object_type_symbol_get_this_type ((ValaObjectTypeSymbol*) self);
		_tmp12_ = _tmp11_;
		_tmp13_ = vala_parameter_new ("this", (ValaDataType*) _tmp12_, NULL);
		_tmp14_ = _tmp13_;
		vala_method_set_this_parameter (m, _tmp14_);
		_vala_code_node_unref0 (_tmp14_);
		_vala_code_node_unref0 (_tmp12_);
		_tmp15_ = vala_symbol_get_scope ((ValaSymbol*) m);
		_tmp16_ = _tmp15_;
		_tmp17_ = vala_method_get_this_parameter (m);
		_tmp18_ = _tmp17_;
		_tmp19_ = vala_symbol_get_name ((ValaSymbol*) _tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = vala_method_get_this_parameter (m);
		_tmp22_ = _tmp21_;
		vala_scope_add (_tmp16_, _tmp20_, (ValaSymbol*) _tmp22_);
	}
	_tmp24_ = vala_callable_get_return_type ((ValaCallable*) m);
	_tmp25_ = _tmp24_;
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp25_, VALA_TYPE_VOID_TYPE)) {
		ValaList* _tmp26_;
		ValaList* _tmp27_;
		gint _tmp28_;
		gint _tmp29_;
		_tmp26_ = vala_method_get_postconditions (m);
		_tmp27_ = _tmp26_;
		_tmp28_ = vala_collection_get_size ((ValaCollection*) _tmp27_);
		_tmp29_ = _tmp28_;
		_tmp23_ = _tmp29_ > 0;
		_vala_iterable_unref0 (_tmp27_);
	} else {
		_tmp23_ = FALSE;
	}
	if (_tmp23_) {
		ValaLocalVariable* _tmp30_;
		ValaLocalVariable* _tmp31_;
		ValaDataType* _tmp38_;
		ValaDataType* _tmp39_;
		ValaDataType* _tmp40_;
		ValaDataType* _tmp41_;
		ValaSourceReference* _tmp42_;
		ValaSourceReference* _tmp43_;
		ValaLocalVariable* _tmp44_;
		ValaLocalVariable* _tmp45_;
		ValaLocalVariable* _tmp46_;
		ValaLocalVariable* _tmp47_;
		_tmp30_ = vala_subroutine_get_result_var ((ValaSubroutine*) m);
		_tmp31_ = _tmp30_;
		if (_tmp31_ != NULL) {
			ValaScope* _tmp32_;
			ValaScope* _tmp33_;
			ValaLocalVariable* _tmp34_;
			ValaLocalVariable* _tmp35_;
			const gchar* _tmp36_;
			const gchar* _tmp37_;
			_tmp32_ = vala_symbol_get_scope ((ValaSymbol*) m);
			_tmp33_ = _tmp32_;
			_tmp34_ = vala_subroutine_get_result_var ((ValaSubroutine*) m);
			_tmp35_ = _tmp34_;
			_tmp36_ = vala_symbol_get_name ((ValaSymbol*) _tmp35_);
			_tmp37_ = _tmp36_;
			vala_scope_remove (_tmp33_, _tmp37_);
		}
		_tmp38_ = vala_callable_get_return_type ((ValaCallable*) m);
		_tmp39_ = _tmp38_;
		_tmp40_ = vala_data_type_copy (_tmp39_);
		_tmp41_ = _tmp40_;
		_tmp42_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp43_ = _tmp42_;
		_tmp44_ = vala_local_variable_new (_tmp41_, "result", NULL, _tmp43_);
		_tmp45_ = _tmp44_;
		vala_subroutine_set_result_var ((ValaSubroutine*) m, _tmp45_);
		_vala_code_node_unref0 (_tmp45_);
		_vala_code_node_unref0 (_tmp41_);
		_tmp46_ = vala_subroutine_get_result_var ((ValaSubroutine*) m);
		_tmp47_ = _tmp46_;
		vala_local_variable_set_is_result (_tmp47_, TRUE);
	}
	if (G_TYPE_CHECK_INSTANCE_TYPE (m, VALA_TYPE_CREATION_METHOD)) {
		const gchar* _tmp48_;
		const gchar* _tmp49_;
		ValaCreationMethod* cm = NULL;
		ValaCreationMethod* _tmp50_;
		gboolean _tmp51_ = FALSE;
		ValaCreationMethod* _tmp52_;
		const gchar* _tmp53_;
		const gchar* _tmp54_;
		_tmp48_ = vala_symbol_get_name ((ValaSymbol*) m);
		_tmp49_ = _tmp48_;
		if (_tmp49_ == NULL) {
			vala_class_set_default_construction_method (self, G_TYPE_CHECK_INSTANCE_CAST (m, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
			vala_symbol_set_name ((ValaSymbol*) m, ".new");
		}
		_tmp50_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (m, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
		cm = _tmp50_;
		_tmp52_ = cm;
		_tmp53_ = vala_creation_method_get_class_name (_tmp52_);
		_tmp54_ = _tmp53_;
		if (_tmp54_ != NULL) {
			ValaCreationMethod* _tmp55_;
			const gchar* _tmp56_;
			const gchar* _tmp57_;
			const gchar* _tmp58_;
			const gchar* _tmp59_;
			_tmp55_ = cm;
			_tmp56_ = vala_creation_method_get_class_name (_tmp55_);
			_tmp57_ = _tmp56_;
			_tmp58_ = vala_symbol_get_name ((ValaSymbol*) self);
			_tmp59_ = _tmp58_;
			_tmp51_ = g_strcmp0 (_tmp57_, _tmp59_) != 0;
		} else {
			_tmp51_ = FALSE;
		}
		if (_tmp51_) {
			ValaSourceReference* _tmp60_;
			ValaSourceReference* _tmp61_;
			gchar* _tmp62_;
			gchar* _tmp63_;
			ValaCreationMethod* _tmp64_;
			const gchar* _tmp65_;
			const gchar* _tmp66_;
			gchar* _tmp67_;
			gchar* _tmp68_;
			_tmp60_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
			_tmp61_ = _tmp60_;
			_tmp62_ = vala_symbol_get_full_name ((ValaSymbol*) self);
			_tmp63_ = _tmp62_;
			_tmp64_ = cm;
			_tmp65_ = vala_creation_method_get_class_name (_tmp64_);
			_tmp66_ = _tmp65_;
			_tmp67_ = g_strdup_printf ("missing return type in method `%s.%s´", _tmp63_, _tmp66_);
			_tmp68_ = _tmp67_;
			vala_report_error (_tmp61_, _tmp68_);
			_g_free0 (_tmp68_);
			_g_free0 (_tmp63_);
			vala_code_node_set_error ((ValaCodeNode*) m, TRUE);
			_vala_code_node_unref0 (cm);
			return;
		}
		_vala_code_node_unref0 (cm);
	}
	VALA_SYMBOL_CLASS (vala_class_parent_class)->add_method ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), m);
	_tmp69_ = vala_method_get_base_interface_type (m);
	_tmp70_ = _tmp69_;
	if (_tmp70_ != NULL) {
		ValaScope* _tmp71_;
		ValaScope* _tmp72_;
		const gchar* _tmp73_;
		const gchar* _tmp74_;
		ValaScope* _tmp75_;
		ValaScope* _tmp76_;
		_tmp71_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp72_ = _tmp71_;
		_tmp73_ = vala_symbol_get_name ((ValaSymbol*) m);
		_tmp74_ = _tmp73_;
		vala_scope_remove (_tmp72_, _tmp74_);
		_tmp75_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp76_ = _tmp75_;
		vala_scope_add (_tmp76_, NULL, (ValaSymbol*) m);
	}
}


/**
 * Adds the specified property as a member to this class.
 *
 * @param prop a property
 */
static void
vala_class_real_add_property (ValaSymbol* base,
                              ValaProperty* prop)
{
	ValaClass * self;
	ValaObjectType* _tmp0_;
	ValaObjectType* _tmp1_;
	ValaParameter* _tmp2_;
	ValaParameter* _tmp3_;
	ValaScope* _tmp4_;
	ValaScope* _tmp5_;
	ValaParameter* _tmp6_;
	ValaParameter* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	ValaParameter* _tmp10_;
	ValaParameter* _tmp11_;
	ValaField* _tmp12_;
	ValaField* _tmp13_;
	self = (ValaClass*) base;
	g_return_if_fail (prop != NULL);
	VALA_SYMBOL_CLASS (vala_class_parent_class)->add_property ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), prop);
	_tmp0_ = vala_object_type_symbol_get_this_type ((ValaObjectTypeSymbol*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_parameter_new ("this", (ValaDataType*) _tmp1_, NULL);
	_tmp3_ = _tmp2_;
	vala_property_set_this_parameter (prop, _tmp3_);
	_vala_code_node_unref0 (_tmp3_);
	_vala_code_node_unref0 (_tmp1_);
	_tmp4_ = vala_symbol_get_scope ((ValaSymbol*) prop);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_property_get_this_parameter (prop);
	_tmp7_ = _tmp6_;
	_tmp8_ = vala_symbol_get_name ((ValaSymbol*) _tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = vala_property_get_this_parameter (prop);
	_tmp11_ = _tmp10_;
	vala_scope_add (_tmp5_, _tmp9_, (ValaSymbol*) _tmp11_);
	_tmp12_ = vala_property_get_field (prop);
	_tmp13_ = _tmp12_;
	if (_tmp13_ != NULL) {
		ValaField* _tmp14_;
		ValaField* _tmp15_;
		_tmp14_ = vala_property_get_field (prop);
		_tmp15_ = _tmp14_;
		vala_symbol_add_field ((ValaSymbol*) self, _tmp15_);
	}
}


static void
vala_class_real_add_constructor (ValaSymbol* base,
                                 ValaConstructor* c)
{
	ValaClass * self;
	ValaMemberBinding _tmp0_;
	ValaMemberBinding _tmp1_;
	self = (ValaClass*) base;
	g_return_if_fail (c != NULL);
	_tmp0_ = vala_constructor_get_binding (c);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == VALA_MEMBER_BINDING_INSTANCE) {
		ValaConstructor* _tmp2_;
		_tmp2_ = self->priv->_constructor;
		if (_tmp2_ != NULL) {
			ValaSourceReference* _tmp3_;
			ValaSourceReference* _tmp4_;
			_tmp3_ = vala_code_node_get_source_reference ((ValaCodeNode*) c);
			_tmp4_ = _tmp3_;
			vala_report_error (_tmp4_, "class already contains a constructor");
		}
		vala_class_set_constructor (self, c);
	} else {
		ValaMemberBinding _tmp5_;
		ValaMemberBinding _tmp6_;
		_tmp5_ = vala_constructor_get_binding (c);
		_tmp6_ = _tmp5_;
		if (_tmp6_ == VALA_MEMBER_BINDING_CLASS) {
			ValaConstructor* _tmp7_;
			_tmp7_ = self->priv->_class_constructor;
			if (_tmp7_ != NULL) {
				ValaSourceReference* _tmp8_;
				ValaSourceReference* _tmp9_;
				_tmp8_ = vala_code_node_get_source_reference ((ValaCodeNode*) c);
				_tmp9_ = _tmp8_;
				vala_report_error (_tmp9_, "class already contains a class constructor");
			}
			vala_class_set_class_constructor (self, c);
		} else {
			ValaConstructor* _tmp10_;
			_tmp10_ = self->priv->_static_constructor;
			if (_tmp10_ != NULL) {
				ValaSourceReference* _tmp11_;
				ValaSourceReference* _tmp12_;
				_tmp11_ = vala_code_node_get_source_reference ((ValaCodeNode*) c);
				_tmp12_ = _tmp11_;
				vala_report_error (_tmp12_, "class already contains a static constructor");
			}
			vala_class_set_static_constructor (self, c);
		}
	}
}


static void
vala_class_real_add_destructor (ValaSymbol* base,
                                ValaDestructor* d)
{
	ValaClass * self;
	ValaMemberBinding _tmp0_;
	ValaMemberBinding _tmp1_;
	self = (ValaClass*) base;
	g_return_if_fail (d != NULL);
	_tmp0_ = vala_destructor_get_binding (d);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == VALA_MEMBER_BINDING_INSTANCE) {
		ValaDestructor* _tmp2_;
		ValaDestructor* _tmp3_;
		_tmp2_ = vala_class_get_destructor (self);
		_tmp3_ = _tmp2_;
		if (_tmp3_ != NULL) {
			ValaSourceReference* _tmp4_;
			ValaSourceReference* _tmp5_;
			_tmp4_ = vala_code_node_get_source_reference ((ValaCodeNode*) d);
			_tmp5_ = _tmp4_;
			vala_report_error (_tmp5_, "class already contains a destructor");
		}
		vala_class_set_destructor (self, d);
	} else {
		ValaMemberBinding _tmp6_;
		ValaMemberBinding _tmp7_;
		_tmp6_ = vala_destructor_get_binding (d);
		_tmp7_ = _tmp6_;
		if (_tmp7_ == VALA_MEMBER_BINDING_CLASS) {
			ValaDestructor* _tmp8_;
			_tmp8_ = self->priv->_class_destructor;
			if (_tmp8_ != NULL) {
				ValaSourceReference* _tmp9_;
				ValaSourceReference* _tmp10_;
				_tmp9_ = vala_code_node_get_source_reference ((ValaCodeNode*) d);
				_tmp10_ = _tmp9_;
				vala_report_error (_tmp10_, "class already contains a class destructor");
			}
			vala_class_set_class_destructor (self, d);
		} else {
			ValaDestructor* _tmp11_;
			_tmp11_ = self->priv->_static_destructor;
			if (_tmp11_ != NULL) {
				ValaSourceReference* _tmp12_;
				ValaSourceReference* _tmp13_;
				_tmp12_ = vala_code_node_get_source_reference ((ValaCodeNode*) d);
				_tmp13_ = _tmp12_;
				vala_report_error (_tmp13_, "class already contains a static destructor");
			}
			vala_class_set_static_destructor (self, d);
		}
	}
}


static void
vala_class_real_accept (ValaCodeNode* base,
                        ValaCodeVisitor* visitor)
{
	ValaClass * self;
	self = (ValaClass*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_class (visitor, self);
}


static void
vala_class_real_accept_children (ValaCodeNode* base,
                                 ValaCodeVisitor* visitor)
{
	ValaClass * self;
	ValaConstructor* _tmp89_;
	ValaConstructor* _tmp91_;
	ValaConstructor* _tmp93_;
	ValaDestructor* _tmp95_;
	ValaDestructor* _tmp96_;
	ValaDestructor* _tmp99_;
	ValaDestructor* _tmp101_;
	self = (ValaClass*) base;
	g_return_if_fail (visitor != NULL);
	{
		ValaList* _type_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _type_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _type_index = 0;
		_tmp0_ = self->priv->base_types;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_type_list = _tmp1_;
		_tmp2_ = _type_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_type_size = _tmp4_;
		_type_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaDataType* type = NULL;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			ValaDataType* _tmp11_;
			_tmp5_ = _type_index;
			_type_index = _tmp5_ + 1;
			_tmp6_ = _type_index;
			_tmp7_ = _type_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _type_list;
			_tmp9_ = _type_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			type = (ValaDataType*) _tmp10_;
			_tmp11_ = type;
			vala_code_node_accept ((ValaCodeNode*) _tmp11_, visitor);
			_vala_code_node_unref0 (type);
		}
		_vala_iterable_unref0 (_type_list);
	}
	{
		ValaList* _p_list = NULL;
		ValaList* _tmp12_;
		gint _p_size = 0;
		ValaList* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		gint _p_index = 0;
		_tmp12_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) self);
		_p_list = _tmp12_;
		_tmp13_ = _p_list;
		_tmp14_ = vala_collection_get_size ((ValaCollection*) _tmp13_);
		_tmp15_ = _tmp14_;
		_p_size = _tmp15_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp16_;
			gint _tmp17_;
			gint _tmp18_;
			ValaTypeParameter* p = NULL;
			ValaList* _tmp19_;
			gint _tmp20_;
			gpointer _tmp21_;
			ValaTypeParameter* _tmp22_;
			_tmp16_ = _p_index;
			_p_index = _tmp16_ + 1;
			_tmp17_ = _p_index;
			_tmp18_ = _p_size;
			if (!(_tmp17_ < _tmp18_)) {
				break;
			}
			_tmp19_ = _p_list;
			_tmp20_ = _p_index;
			_tmp21_ = vala_list_get (_tmp19_, _tmp20_);
			p = (ValaTypeParameter*) _tmp21_;
			_tmp22_ = p;
			vala_code_node_accept ((ValaCodeNode*) _tmp22_, visitor);
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	{
		ValaList* _en_list = NULL;
		ValaList* _tmp23_;
		gint _en_size = 0;
		ValaList* _tmp24_;
		gint _tmp25_;
		gint _tmp26_;
		gint _en_index = 0;
		_tmp23_ = vala_object_type_symbol_get_enums ((ValaObjectTypeSymbol*) self);
		_en_list = _tmp23_;
		_tmp24_ = _en_list;
		_tmp25_ = vala_collection_get_size ((ValaCollection*) _tmp24_);
		_tmp26_ = _tmp25_;
		_en_size = _tmp26_;
		_en_index = -1;
		while (TRUE) {
			gint _tmp27_;
			gint _tmp28_;
			gint _tmp29_;
			ValaEnum* en = NULL;
			ValaList* _tmp30_;
			gint _tmp31_;
			gpointer _tmp32_;
			ValaEnum* _tmp33_;
			_tmp27_ = _en_index;
			_en_index = _tmp27_ + 1;
			_tmp28_ = _en_index;
			_tmp29_ = _en_size;
			if (!(_tmp28_ < _tmp29_)) {
				break;
			}
			_tmp30_ = _en_list;
			_tmp31_ = _en_index;
			_tmp32_ = vala_list_get (_tmp30_, _tmp31_);
			en = (ValaEnum*) _tmp32_;
			_tmp33_ = en;
			vala_code_node_accept ((ValaCodeNode*) _tmp33_, visitor);
			_vala_code_node_unref0 (en);
		}
		_vala_iterable_unref0 (_en_list);
	}
	{
		ValaList* _f_list = NULL;
		ValaList* _tmp34_;
		gint _f_size = 0;
		ValaList* _tmp35_;
		gint _tmp36_;
		gint _tmp37_;
		gint _f_index = 0;
		_tmp34_ = vala_object_type_symbol_get_fields ((ValaObjectTypeSymbol*) self);
		_f_list = _tmp34_;
		_tmp35_ = _f_list;
		_tmp36_ = vala_collection_get_size ((ValaCollection*) _tmp35_);
		_tmp37_ = _tmp36_;
		_f_size = _tmp37_;
		_f_index = -1;
		while (TRUE) {
			gint _tmp38_;
			gint _tmp39_;
			gint _tmp40_;
			ValaField* f = NULL;
			ValaList* _tmp41_;
			gint _tmp42_;
			gpointer _tmp43_;
			ValaField* _tmp44_;
			_tmp38_ = _f_index;
			_f_index = _tmp38_ + 1;
			_tmp39_ = _f_index;
			_tmp40_ = _f_size;
			if (!(_tmp39_ < _tmp40_)) {
				break;
			}
			_tmp41_ = _f_list;
			_tmp42_ = _f_index;
			_tmp43_ = vala_list_get (_tmp41_, _tmp42_);
			f = (ValaField*) _tmp43_;
			_tmp44_ = f;
			vala_code_node_accept ((ValaCodeNode*) _tmp44_, visitor);
			_vala_code_node_unref0 (f);
		}
		_vala_iterable_unref0 (_f_list);
	}
	{
		ValaList* _c_list = NULL;
		ValaList* _tmp45_;
		gint _c_size = 0;
		ValaList* _tmp46_;
		gint _tmp47_;
		gint _tmp48_;
		gint _c_index = 0;
		_tmp45_ = vala_object_type_symbol_get_constants ((ValaObjectTypeSymbol*) self);
		_c_list = _tmp45_;
		_tmp46_ = _c_list;
		_tmp47_ = vala_collection_get_size ((ValaCollection*) _tmp46_);
		_tmp48_ = _tmp47_;
		_c_size = _tmp48_;
		_c_index = -1;
		while (TRUE) {
			gint _tmp49_;
			gint _tmp50_;
			gint _tmp51_;
			ValaConstant* c = NULL;
			ValaList* _tmp52_;
			gint _tmp53_;
			gpointer _tmp54_;
			ValaConstant* _tmp55_;
			_tmp49_ = _c_index;
			_c_index = _tmp49_ + 1;
			_tmp50_ = _c_index;
			_tmp51_ = _c_size;
			if (!(_tmp50_ < _tmp51_)) {
				break;
			}
			_tmp52_ = _c_list;
			_tmp53_ = _c_index;
			_tmp54_ = vala_list_get (_tmp52_, _tmp53_);
			c = (ValaConstant*) _tmp54_;
			_tmp55_ = c;
			vala_code_node_accept ((ValaCodeNode*) _tmp55_, visitor);
			_vala_code_node_unref0 (c);
		}
		_vala_iterable_unref0 (_c_list);
	}
	{
		ValaList* _m_list = NULL;
		ValaList* _tmp56_;
		gint _m_size = 0;
		ValaList* _tmp57_;
		gint _tmp58_;
		gint _tmp59_;
		gint _m_index = 0;
		_tmp56_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) self);
		_m_list = _tmp56_;
		_tmp57_ = _m_list;
		_tmp58_ = vala_collection_get_size ((ValaCollection*) _tmp57_);
		_tmp59_ = _tmp58_;
		_m_size = _tmp59_;
		_m_index = -1;
		while (TRUE) {
			gint _tmp60_;
			gint _tmp61_;
			gint _tmp62_;
			ValaMethod* m = NULL;
			ValaList* _tmp63_;
			gint _tmp64_;
			gpointer _tmp65_;
			ValaMethod* _tmp66_;
			_tmp60_ = _m_index;
			_m_index = _tmp60_ + 1;
			_tmp61_ = _m_index;
			_tmp62_ = _m_size;
			if (!(_tmp61_ < _tmp62_)) {
				break;
			}
			_tmp63_ = _m_list;
			_tmp64_ = _m_index;
			_tmp65_ = vala_list_get (_tmp63_, _tmp64_);
			m = (ValaMethod*) _tmp65_;
			_tmp66_ = m;
			vala_code_node_accept ((ValaCodeNode*) _tmp66_, visitor);
			_vala_code_node_unref0 (m);
		}
		_vala_iterable_unref0 (_m_list);
	}
	{
		ValaList* _prop_list = NULL;
		ValaList* _tmp67_;
		gint _prop_size = 0;
		ValaList* _tmp68_;
		gint _tmp69_;
		gint _tmp70_;
		gint _prop_index = 0;
		_tmp67_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) self);
		_prop_list = _tmp67_;
		_tmp68_ = _prop_list;
		_tmp69_ = vala_collection_get_size ((ValaCollection*) _tmp68_);
		_tmp70_ = _tmp69_;
		_prop_size = _tmp70_;
		_prop_index = -1;
		while (TRUE) {
			gint _tmp71_;
			gint _tmp72_;
			gint _tmp73_;
			ValaProperty* prop = NULL;
			ValaList* _tmp74_;
			gint _tmp75_;
			gpointer _tmp76_;
			ValaProperty* _tmp77_;
			_tmp71_ = _prop_index;
			_prop_index = _tmp71_ + 1;
			_tmp72_ = _prop_index;
			_tmp73_ = _prop_size;
			if (!(_tmp72_ < _tmp73_)) {
				break;
			}
			_tmp74_ = _prop_list;
			_tmp75_ = _prop_index;
			_tmp76_ = vala_list_get (_tmp74_, _tmp75_);
			prop = (ValaProperty*) _tmp76_;
			_tmp77_ = prop;
			vala_code_node_accept ((ValaCodeNode*) _tmp77_, visitor);
			_vala_code_node_unref0 (prop);
		}
		_vala_iterable_unref0 (_prop_list);
	}
	{
		ValaList* _sig_list = NULL;
		ValaList* _tmp78_;
		gint _sig_size = 0;
		ValaList* _tmp79_;
		gint _tmp80_;
		gint _tmp81_;
		gint _sig_index = 0;
		_tmp78_ = vala_object_type_symbol_get_signals ((ValaObjectTypeSymbol*) self);
		_sig_list = _tmp78_;
		_tmp79_ = _sig_list;
		_tmp80_ = vala_collection_get_size ((ValaCollection*) _tmp79_);
		_tmp81_ = _tmp80_;
		_sig_size = _tmp81_;
		_sig_index = -1;
		while (TRUE) {
			gint _tmp82_;
			gint _tmp83_;
			gint _tmp84_;
			ValaSignal* sig = NULL;
			ValaList* _tmp85_;
			gint _tmp86_;
			gpointer _tmp87_;
			ValaSignal* _tmp88_;
			_tmp82_ = _sig_index;
			_sig_index = _tmp82_ + 1;
			_tmp83_ = _sig_index;
			_tmp84_ = _sig_size;
			if (!(_tmp83_ < _tmp84_)) {
				break;
			}
			_tmp85_ = _sig_list;
			_tmp86_ = _sig_index;
			_tmp87_ = vala_list_get (_tmp85_, _tmp86_);
			sig = (ValaSignal*) _tmp87_;
			_tmp88_ = sig;
			vala_code_node_accept ((ValaCodeNode*) _tmp88_, visitor);
			_vala_code_node_unref0 (sig);
		}
		_vala_iterable_unref0 (_sig_list);
	}
	_tmp89_ = self->priv->_constructor;
	if (_tmp89_ != NULL) {
		ValaConstructor* _tmp90_;
		_tmp90_ = self->priv->_constructor;
		vala_code_node_accept ((ValaCodeNode*) _tmp90_, visitor);
	}
	_tmp91_ = self->priv->_class_constructor;
	if (_tmp91_ != NULL) {
		ValaConstructor* _tmp92_;
		_tmp92_ = self->priv->_class_constructor;
		vala_code_node_accept ((ValaCodeNode*) _tmp92_, visitor);
	}
	_tmp93_ = self->priv->_static_constructor;
	if (_tmp93_ != NULL) {
		ValaConstructor* _tmp94_;
		_tmp94_ = self->priv->_static_constructor;
		vala_code_node_accept ((ValaCodeNode*) _tmp94_, visitor);
	}
	_tmp95_ = vala_class_get_destructor (self);
	_tmp96_ = _tmp95_;
	if (_tmp96_ != NULL) {
		ValaDestructor* _tmp97_;
		ValaDestructor* _tmp98_;
		_tmp97_ = vala_class_get_destructor (self);
		_tmp98_ = _tmp97_;
		vala_code_node_accept ((ValaCodeNode*) _tmp98_, visitor);
	}
	_tmp99_ = self->priv->_static_destructor;
	if (_tmp99_ != NULL) {
		ValaDestructor* _tmp100_;
		_tmp100_ = self->priv->_static_destructor;
		vala_code_node_accept ((ValaCodeNode*) _tmp100_, visitor);
	}
	_tmp101_ = self->priv->_class_destructor;
	if (_tmp101_ != NULL) {
		ValaDestructor* _tmp102_;
		_tmp102_ = self->priv->_class_destructor;
		vala_code_node_accept ((ValaCodeNode*) _tmp102_, visitor);
	}
	{
		ValaList* _cl_list = NULL;
		ValaList* _tmp103_;
		gint _cl_size = 0;
		ValaList* _tmp104_;
		gint _tmp105_;
		gint _tmp106_;
		gint _cl_index = 0;
		_tmp103_ = vala_object_type_symbol_get_classes ((ValaObjectTypeSymbol*) self);
		_cl_list = _tmp103_;
		_tmp104_ = _cl_list;
		_tmp105_ = vala_collection_get_size ((ValaCollection*) _tmp104_);
		_tmp106_ = _tmp105_;
		_cl_size = _tmp106_;
		_cl_index = -1;
		while (TRUE) {
			gint _tmp107_;
			gint _tmp108_;
			gint _tmp109_;
			ValaClass* cl = NULL;
			ValaList* _tmp110_;
			gint _tmp111_;
			gpointer _tmp112_;
			ValaClass* _tmp113_;
			_tmp107_ = _cl_index;
			_cl_index = _tmp107_ + 1;
			_tmp108_ = _cl_index;
			_tmp109_ = _cl_size;
			if (!(_tmp108_ < _tmp109_)) {
				break;
			}
			_tmp110_ = _cl_list;
			_tmp111_ = _cl_index;
			_tmp112_ = vala_list_get (_tmp110_, _tmp111_);
			cl = (ValaClass*) _tmp112_;
			_tmp113_ = cl;
			vala_code_node_accept ((ValaCodeNode*) _tmp113_, visitor);
			_vala_code_node_unref0 (cl);
		}
		_vala_iterable_unref0 (_cl_list);
	}
	{
		ValaList* _st_list = NULL;
		ValaList* _tmp114_;
		gint _st_size = 0;
		ValaList* _tmp115_;
		gint _tmp116_;
		gint _tmp117_;
		gint _st_index = 0;
		_tmp114_ = vala_object_type_symbol_get_structs ((ValaObjectTypeSymbol*) self);
		_st_list = _tmp114_;
		_tmp115_ = _st_list;
		_tmp116_ = vala_collection_get_size ((ValaCollection*) _tmp115_);
		_tmp117_ = _tmp116_;
		_st_size = _tmp117_;
		_st_index = -1;
		while (TRUE) {
			gint _tmp118_;
			gint _tmp119_;
			gint _tmp120_;
			ValaStruct* st = NULL;
			ValaList* _tmp121_;
			gint _tmp122_;
			gpointer _tmp123_;
			ValaStruct* _tmp124_;
			_tmp118_ = _st_index;
			_st_index = _tmp118_ + 1;
			_tmp119_ = _st_index;
			_tmp120_ = _st_size;
			if (!(_tmp119_ < _tmp120_)) {
				break;
			}
			_tmp121_ = _st_list;
			_tmp122_ = _st_index;
			_tmp123_ = vala_list_get (_tmp121_, _tmp122_);
			st = (ValaStruct*) _tmp123_;
			_tmp124_ = st;
			vala_code_node_accept ((ValaCodeNode*) _tmp124_, visitor);
			_vala_code_node_unref0 (st);
		}
		_vala_iterable_unref0 (_st_list);
	}
	{
		ValaList* _d_list = NULL;
		ValaList* _tmp125_;
		gint _d_size = 0;
		ValaList* _tmp126_;
		gint _tmp127_;
		gint _tmp128_;
		gint _d_index = 0;
		_tmp125_ = vala_object_type_symbol_get_delegates ((ValaObjectTypeSymbol*) self);
		_d_list = _tmp125_;
		_tmp126_ = _d_list;
		_tmp127_ = vala_collection_get_size ((ValaCollection*) _tmp126_);
		_tmp128_ = _tmp127_;
		_d_size = _tmp128_;
		_d_index = -1;
		while (TRUE) {
			gint _tmp129_;
			gint _tmp130_;
			gint _tmp131_;
			ValaDelegate* d = NULL;
			ValaList* _tmp132_;
			gint _tmp133_;
			gpointer _tmp134_;
			ValaDelegate* _tmp135_;
			_tmp129_ = _d_index;
			_d_index = _tmp129_ + 1;
			_tmp130_ = _d_index;
			_tmp131_ = _d_size;
			if (!(_tmp130_ < _tmp131_)) {
				break;
			}
			_tmp132_ = _d_list;
			_tmp133_ = _d_index;
			_tmp134_ = vala_list_get (_tmp132_, _tmp133_);
			d = (ValaDelegate*) _tmp134_;
			_tmp135_ = d;
			vala_code_node_accept ((ValaCodeNode*) _tmp135_, visitor);
			_vala_code_node_unref0 (d);
		}
		_vala_iterable_unref0 (_d_list);
	}
}


static gboolean
vala_class_real_is_reference_type (ValaTypeSymbol* base)
{
	ValaClass * self;
	gboolean result = FALSE;
	self = (ValaClass*) base;
	result = TRUE;
	return result;
}


gboolean
vala_class_is_fundamental (ValaClass* self)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = vala_class_get_is_compact (self);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		ValaClass* _tmp3_;
		_tmp3_ = self->priv->_base_class;
		_tmp0_ = _tmp3_ == NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static gboolean
vala_class_real_is_subtype_of (ValaTypeSymbol* base,
                               ValaTypeSymbol* t)
{
	ValaClass * self;
	gboolean result = FALSE;
	self = (ValaClass*) base;
	g_return_val_if_fail (t != NULL, FALSE);
	if (G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol) == t) {
		result = TRUE;
		return result;
	}
	{
		ValaList* _base_type_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _base_type_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _base_type_index = 0;
		_tmp0_ = self->priv->base_types;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_base_type_list = _tmp1_;
		_tmp2_ = _base_type_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_base_type_size = _tmp4_;
		_base_type_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaDataType* base_type = NULL;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			gboolean _tmp11_ = FALSE;
			ValaDataType* _tmp12_;
			ValaTypeSymbol* _tmp13_;
			ValaTypeSymbol* _tmp14_;
			_tmp5_ = _base_type_index;
			_base_type_index = _tmp5_ + 1;
			_tmp6_ = _base_type_index;
			_tmp7_ = _base_type_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _base_type_list;
			_tmp9_ = _base_type_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			base_type = (ValaDataType*) _tmp10_;
			_tmp12_ = base_type;
			_tmp13_ = vala_data_type_get_data_type (_tmp12_);
			_tmp14_ = _tmp13_;
			if (_tmp14_ != NULL) {
				ValaDataType* _tmp15_;
				ValaTypeSymbol* _tmp16_;
				ValaTypeSymbol* _tmp17_;
				_tmp15_ = base_type;
				_tmp16_ = vala_data_type_get_data_type (_tmp15_);
				_tmp17_ = _tmp16_;
				_tmp11_ = vala_typesymbol_is_subtype_of (_tmp17_, t);
			} else {
				_tmp11_ = FALSE;
			}
			if (_tmp11_) {
				result = TRUE;
				_vala_code_node_unref0 (base_type);
				_vala_iterable_unref0 (_base_type_list);
				return result;
			}
			_vala_code_node_unref0 (base_type);
		}
		_vala_iterable_unref0 (_base_type_list);
	}
	result = FALSE;
	return result;
}


static void
vala_class_real_replace_type (ValaCodeNode* base,
                              ValaDataType* old_type,
                              ValaDataType* new_type)
{
	ValaClass * self;
	self = (ValaClass*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				ValaList* _tmp3_;
				gint _tmp4_;
				gint _tmp5_;
				ValaList* _tmp6_;
				gint _tmp7_;
				gpointer _tmp8_;
				ValaDataType* _tmp9_;
				gboolean _tmp10_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = self->priv->base_types;
				_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
				_tmp5_ = _tmp4_;
				if (!(_tmp2_ < _tmp5_)) {
					break;
				}
				_tmp6_ = self->priv->base_types;
				_tmp7_ = i;
				_tmp8_ = vala_list_get (_tmp6_, _tmp7_);
				_tmp9_ = (ValaDataType*) _tmp8_;
				_tmp10_ = _tmp9_ == old_type;
				_vala_code_node_unref0 (_tmp9_);
				if (_tmp10_) {
					ValaList* _tmp11_;
					gint _tmp12_;
					_tmp11_ = self->priv->base_types;
					_tmp12_ = i;
					vala_list_set (_tmp11_, _tmp12_, new_type);
					vala_code_node_set_parent_node ((ValaCodeNode*) new_type, (ValaCodeNode*) self);
					return;
				}
			}
		}
	}
}


static void
vala_class_get_all_prerequisites (ValaClass* self,
                                  ValaInterface* iface,
                                  ValaList* list)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (iface != NULL);
	g_return_if_fail (list != NULL);
	{
		ValaList* _prereq_list = NULL;
		ValaList* _tmp0_;
		gint _prereq_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _prereq_index = 0;
		_tmp0_ = vala_interface_get_prerequisites (iface);
		_prereq_list = _tmp0_;
		_tmp1_ = _prereq_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_prereq_size = _tmp3_;
		_prereq_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			gint _tmp6_;
			ValaDataType* prereq = NULL;
			ValaList* _tmp7_;
			gint _tmp8_;
			gpointer _tmp9_;
			ValaTypeSymbol* type = NULL;
			ValaDataType* _tmp10_;
			ValaTypeSymbol* _tmp11_;
			ValaTypeSymbol* _tmp12_;
			ValaTypeSymbol* _tmp13_;
			ValaTypeSymbol* _tmp14_;
			ValaTypeSymbol* _tmp15_;
			ValaTypeSymbol* _tmp16_;
			_tmp4_ = _prereq_index;
			_prereq_index = _tmp4_ + 1;
			_tmp5_ = _prereq_index;
			_tmp6_ = _prereq_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _prereq_list;
			_tmp8_ = _prereq_index;
			_tmp9_ = vala_list_get (_tmp7_, _tmp8_);
			prereq = (ValaDataType*) _tmp9_;
			_tmp10_ = prereq;
			_tmp11_ = vala_data_type_get_data_type (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = _vala_code_node_ref0 (_tmp12_);
			type = _tmp13_;
			_tmp14_ = type;
			if (_tmp14_ == NULL) {
				_vala_code_node_unref0 (type);
				_vala_code_node_unref0 (prereq);
				continue;
			}
			_tmp15_ = type;
			vala_collection_add ((ValaCollection*) list, _tmp15_);
			_tmp16_ = type;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, VALA_TYPE_INTERFACE)) {
				ValaTypeSymbol* _tmp17_;
				_tmp17_ = type;
				vala_class_get_all_prerequisites (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, VALA_TYPE_INTERFACE, ValaInterface), list);
			}
			_vala_code_node_unref0 (type);
			_vala_code_node_unref0 (prereq);
		}
		_vala_iterable_unref0 (_prereq_list);
	}
}


static gboolean
vala_class_class_is_a (ValaClass* self,
                       ValaClass* cl,
                       ValaTypeSymbol* t)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (cl != NULL, FALSE);
	g_return_val_if_fail (t != NULL, FALSE);
	if (G_TYPE_CHECK_INSTANCE_CAST (cl, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol) == t) {
		result = TRUE;
		return result;
	}
	{
		ValaList* _base_type_list = NULL;
		ValaList* _tmp0_;
		gint _base_type_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _base_type_index = 0;
		_tmp0_ = vala_class_get_base_types (cl);
		_base_type_list = _tmp0_;
		_tmp1_ = _base_type_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_base_type_size = _tmp3_;
		_base_type_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			gint _tmp6_;
			ValaDataType* base_type = NULL;
			ValaList* _tmp7_;
			gint _tmp8_;
			gpointer _tmp9_;
			ValaDataType* _tmp10_;
			ValaTypeSymbol* _tmp11_;
			ValaTypeSymbol* _tmp12_;
			_tmp4_ = _base_type_index;
			_base_type_index = _tmp4_ + 1;
			_tmp5_ = _base_type_index;
			_tmp6_ = _base_type_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _base_type_list;
			_tmp8_ = _base_type_index;
			_tmp9_ = vala_list_get (_tmp7_, _tmp8_);
			base_type = (ValaDataType*) _tmp9_;
			_tmp10_ = base_type;
			_tmp11_ = vala_data_type_get_data_type (_tmp10_);
			_tmp12_ = _tmp11_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, VALA_TYPE_CLASS)) {
				ValaDataType* _tmp13_;
				ValaTypeSymbol* _tmp14_;
				ValaTypeSymbol* _tmp15_;
				_tmp13_ = base_type;
				_tmp14_ = vala_data_type_get_data_type (_tmp13_);
				_tmp15_ = _tmp14_;
				if (vala_class_class_is_a (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, VALA_TYPE_CLASS, ValaClass), t)) {
					result = TRUE;
					_vala_code_node_unref0 (base_type);
					_vala_iterable_unref0 (_base_type_list);
					return result;
				}
			} else {
				ValaDataType* _tmp16_;
				ValaTypeSymbol* _tmp17_;
				ValaTypeSymbol* _tmp18_;
				_tmp16_ = base_type;
				_tmp17_ = vala_data_type_get_data_type (_tmp16_);
				_tmp18_ = _tmp17_;
				if (_tmp18_ == t) {
					result = TRUE;
					_vala_code_node_unref0 (base_type);
					_vala_iterable_unref0 (_base_type_list);
					return result;
				}
			}
			_vala_code_node_unref0 (base_type);
		}
		_vala_iterable_unref0 (_base_type_list);
	}
	result = FALSE;
	return result;
}


static gpointer
_vala_source_file_ref0 (gpointer self)
{
	return self ? vala_source_file_ref (self) : NULL;
}


static gboolean
vala_class_real_check (ValaCodeNode* base,
                       ValaCodeContext* context)
{
	ValaClass * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaSourceFile* old_source_file = NULL;
	ValaSemanticAnalyzer* _tmp4_;
	ValaSemanticAnalyzer* _tmp5_;
	ValaSourceFile* _tmp6_;
	ValaSourceFile* _tmp7_;
	ValaSourceFile* _tmp8_;
	ValaSymbol* old_symbol = NULL;
	ValaSemanticAnalyzer* _tmp9_;
	ValaSemanticAnalyzer* _tmp10_;
	ValaSymbol* _tmp11_;
	ValaSymbol* _tmp12_;
	ValaSymbol* _tmp13_;
	ValaSourceReference* _tmp14_;
	ValaSourceReference* _tmp15_;
	ValaSemanticAnalyzer* _tmp22_;
	ValaSemanticAnalyzer* _tmp23_;
	ValaConstructor* _tmp179_;
	ValaConstructor* _tmp181_;
	ValaConstructor* _tmp183_;
	ValaDestructor* _tmp185_;
	ValaDestructor* _tmp186_;
	ValaDestructor* _tmp189_;
	ValaDestructor* _tmp191_;
	gboolean _tmp226_;
	gboolean _tmp227_;
	ValaList* prerequisites = NULL;
	GEqualFunc _tmp274_;
	ValaArrayList* _tmp275_;
	ValaList* missing_prereqs = NULL;
	GEqualFunc _tmp293_;
	ValaArrayList* _tmp294_;
	ValaList* _tmp311_;
	gint _tmp312_;
	gint _tmp313_;
	ValaSourceFileType _tmp341_;
	ValaSourceFileType _tmp342_;
	ValaSemanticAnalyzer* _tmp568_;
	ValaSemanticAnalyzer* _tmp569_;
	ValaSourceFile* _tmp570_;
	ValaSemanticAnalyzer* _tmp571_;
	ValaSemanticAnalyzer* _tmp572_;
	ValaSymbol* _tmp573_;
	gboolean _tmp574_;
	gboolean _tmp575_;
	self = (ValaClass*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_code_context_get_analyzer (context);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_semantic_analyzer_get_current_source_file (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_source_file_ref0 (_tmp7_);
	old_source_file = _tmp8_;
	_tmp9_ = vala_code_context_get_analyzer (context);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_semantic_analyzer_get_current_symbol (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = _vala_code_node_ref0 (_tmp12_);
	old_symbol = _tmp13_;
	_tmp14_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp15_ = _tmp14_;
	if (_tmp15_ != NULL) {
		ValaSemanticAnalyzer* _tmp16_;
		ValaSemanticAnalyzer* _tmp17_;
		ValaSourceReference* _tmp18_;
		ValaSourceReference* _tmp19_;
		ValaSourceFile* _tmp20_;
		ValaSourceFile* _tmp21_;
		_tmp16_ = vala_code_context_get_analyzer (context);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_source_reference_get_file (_tmp19_);
		_tmp21_ = _tmp20_;
		vala_semantic_analyzer_set_current_source_file (_tmp17_, _tmp21_);
	}
	_tmp22_ = vala_code_context_get_analyzer (context);
	_tmp23_ = _tmp22_;
	vala_semantic_analyzer_set_current_symbol (_tmp23_, (ValaSymbol*) self);
	{
		ValaList* _base_type_reference_list = NULL;
		ValaList* _tmp24_;
		gint _base_type_reference_size = 0;
		ValaList* _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		gint _base_type_reference_index = 0;
		_tmp24_ = vala_class_get_base_types (self);
		_base_type_reference_list = _tmp24_;
		_tmp25_ = _base_type_reference_list;
		_tmp26_ = vala_collection_get_size ((ValaCollection*) _tmp25_);
		_tmp27_ = _tmp26_;
		_base_type_reference_size = _tmp27_;
		_base_type_reference_index = -1;
		while (TRUE) {
			gint _tmp28_;
			gint _tmp29_;
			gint _tmp30_;
			ValaDataType* base_type_reference = NULL;
			ValaList* _tmp31_;
			gint _tmp32_;
			gpointer _tmp33_;
			ValaDataType* _tmp34_;
			ValaDataType* _tmp35_;
			ValaSemanticAnalyzer* _tmp45_;
			ValaSemanticAnalyzer* _tmp46_;
			ValaDataType* _tmp47_;
			gint n_type_args = 0;
			ValaDataType* _tmp57_;
			ValaList* _tmp58_;
			ValaList* _tmp59_;
			gint _tmp60_;
			gint _tmp61_;
			gint _tmp62_;
			gint n_type_params = 0;
			ValaDataType* _tmp63_;
			ValaTypeSymbol* _tmp64_;
			ValaTypeSymbol* _tmp65_;
			ValaList* _tmp66_;
			ValaList* _tmp67_;
			gint _tmp68_;
			gint _tmp69_;
			gint _tmp70_;
			gint _tmp71_;
			gint _tmp72_;
			_tmp28_ = _base_type_reference_index;
			_base_type_reference_index = _tmp28_ + 1;
			_tmp29_ = _base_type_reference_index;
			_tmp30_ = _base_type_reference_size;
			if (!(_tmp29_ < _tmp30_)) {
				break;
			}
			_tmp31_ = _base_type_reference_list;
			_tmp32_ = _base_type_reference_index;
			_tmp33_ = vala_list_get (_tmp31_, _tmp32_);
			base_type_reference = (ValaDataType*) _tmp33_;
			_tmp34_ = base_type_reference;
			if (!vala_code_node_check ((ValaCodeNode*) _tmp34_, context)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_vala_code_node_unref0 (base_type_reference);
				_vala_iterable_unref0 (_base_type_reference_list);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp35_ = base_type_reference;
			if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp35_, VALA_TYPE_OBJECT_TYPE)) {
				ValaSourceReference* _tmp36_;
				ValaSourceReference* _tmp37_;
				ValaDataType* _tmp38_;
				gchar* _tmp39_;
				gchar* _tmp40_;
				gchar* _tmp41_;
				gchar* _tmp42_;
				gchar* _tmp43_;
				gchar* _tmp44_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp36_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp37_ = _tmp36_;
				_tmp38_ = base_type_reference;
				_tmp39_ = vala_code_node_to_string ((ValaCodeNode*) _tmp38_);
				_tmp40_ = _tmp39_;
				_tmp41_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp42_ = _tmp41_;
				_tmp43_ = g_strdup_printf ("base type `%s' of class `%s' is not an object type", _tmp40_, _tmp42_);
				_tmp44_ = _tmp43_;
				vala_report_error (_tmp37_, _tmp44_);
				_g_free0 (_tmp44_);
				_g_free0 (_tmp42_);
				_g_free0 (_tmp40_);
				result = FALSE;
				_vala_code_node_unref0 (base_type_reference);
				_vala_iterable_unref0 (_base_type_reference_list);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp45_ = vala_code_context_get_analyzer (context);
			_tmp46_ = _tmp45_;
			_tmp47_ = base_type_reference;
			if (!vala_semantic_analyzer_is_type_accessible (_tmp46_, (ValaSymbol*) self, _tmp47_)) {
				ValaSourceReference* _tmp48_;
				ValaSourceReference* _tmp49_;
				ValaDataType* _tmp50_;
				gchar* _tmp51_;
				gchar* _tmp52_;
				gchar* _tmp53_;
				gchar* _tmp54_;
				gchar* _tmp55_;
				gchar* _tmp56_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp48_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp49_ = _tmp48_;
				_tmp50_ = base_type_reference;
				_tmp51_ = vala_code_node_to_string ((ValaCodeNode*) _tmp50_);
				_tmp52_ = _tmp51_;
				_tmp53_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp54_ = _tmp53_;
				_tmp55_ = g_strdup_printf ("base type `%s' is less accessible than class `%s'", _tmp52_, _tmp54_);
				_tmp56_ = _tmp55_;
				vala_report_error (_tmp49_, _tmp56_);
				_g_free0 (_tmp56_);
				_g_free0 (_tmp54_);
				_g_free0 (_tmp52_);
				result = FALSE;
				_vala_code_node_unref0 (base_type_reference);
				_vala_iterable_unref0 (_base_type_reference_list);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp57_ = base_type_reference;
			_tmp58_ = vala_data_type_get_type_arguments (_tmp57_);
			_tmp59_ = _tmp58_;
			_tmp60_ = vala_collection_get_size ((ValaCollection*) _tmp59_);
			_tmp61_ = _tmp60_;
			_tmp62_ = _tmp61_;
			_vala_iterable_unref0 (_tmp59_);
			n_type_args = _tmp62_;
			_tmp63_ = base_type_reference;
			_tmp64_ = vala_data_type_get_data_type (_tmp63_);
			_tmp65_ = _tmp64_;
			_tmp66_ = vala_object_type_symbol_get_type_parameters (G_TYPE_CHECK_INSTANCE_CAST (_tmp65_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol));
			_tmp67_ = _tmp66_;
			_tmp68_ = vala_collection_get_size ((ValaCollection*) _tmp67_);
			_tmp69_ = _tmp68_;
			_tmp70_ = _tmp69_;
			_vala_iterable_unref0 (_tmp67_);
			n_type_params = _tmp70_;
			_tmp71_ = n_type_args;
			_tmp72_ = n_type_params;
			if (_tmp71_ < _tmp72_) {
				ValaDataType* _tmp73_;
				ValaSourceReference* _tmp74_;
				ValaSourceReference* _tmp75_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp73_ = base_type_reference;
				_tmp74_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp73_);
				_tmp75_ = _tmp74_;
				vala_report_error (_tmp75_, "too few type arguments");
				result = FALSE;
				_vala_code_node_unref0 (base_type_reference);
				_vala_iterable_unref0 (_base_type_reference_list);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			} else {
				gint _tmp76_;
				gint _tmp77_;
				_tmp76_ = n_type_args;
				_tmp77_ = n_type_params;
				if (_tmp76_ > _tmp77_) {
					ValaDataType* _tmp78_;
					ValaSourceReference* _tmp79_;
					ValaSourceReference* _tmp80_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp78_ = base_type_reference;
					_tmp79_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp78_);
					_tmp80_ = _tmp79_;
					vala_report_error (_tmp80_, "too many type arguments");
					result = FALSE;
					_vala_code_node_unref0 (base_type_reference);
					_vala_iterable_unref0 (_base_type_reference_list);
					_vala_code_node_unref0 (old_symbol);
					_vala_source_file_unref0 (old_source_file);
					return result;
				}
			}
			_vala_code_node_unref0 (base_type_reference);
		}
		_vala_iterable_unref0 (_base_type_reference_list);
	}
	{
		ValaList* _type_list = NULL;
		ValaList* _tmp81_;
		ValaList* _tmp82_;
		gint _type_size = 0;
		ValaList* _tmp83_;
		gint _tmp84_;
		gint _tmp85_;
		gint _type_index = 0;
		_tmp81_ = self->priv->base_types;
		_tmp82_ = _vala_iterable_ref0 (_tmp81_);
		_type_list = _tmp82_;
		_tmp83_ = _type_list;
		_tmp84_ = vala_collection_get_size ((ValaCollection*) _tmp83_);
		_tmp85_ = _tmp84_;
		_type_size = _tmp85_;
		_type_index = -1;
		while (TRUE) {
			gint _tmp86_;
			gint _tmp87_;
			gint _tmp88_;
			ValaDataType* type = NULL;
			ValaList* _tmp89_;
			gint _tmp90_;
			gpointer _tmp91_;
			ValaDataType* _tmp92_;
			_tmp86_ = _type_index;
			_type_index = _tmp86_ + 1;
			_tmp87_ = _type_index;
			_tmp88_ = _type_size;
			if (!(_tmp87_ < _tmp88_)) {
				break;
			}
			_tmp89_ = _type_list;
			_tmp90_ = _type_index;
			_tmp91_ = vala_list_get (_tmp89_, _tmp90_);
			type = (ValaDataType*) _tmp91_;
			_tmp92_ = type;
			vala_code_node_check ((ValaCodeNode*) _tmp92_, context);
			_vala_code_node_unref0 (type);
		}
		_vala_iterable_unref0 (_type_list);
	}
	{
		ValaList* _p_list = NULL;
		ValaList* _tmp93_;
		gint _p_size = 0;
		ValaList* _tmp94_;
		gint _tmp95_;
		gint _tmp96_;
		gint _p_index = 0;
		_tmp93_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) self);
		_p_list = _tmp93_;
		_tmp94_ = _p_list;
		_tmp95_ = vala_collection_get_size ((ValaCollection*) _tmp94_);
		_tmp96_ = _tmp95_;
		_p_size = _tmp96_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp97_;
			gint _tmp98_;
			gint _tmp99_;
			ValaTypeParameter* p = NULL;
			ValaList* _tmp100_;
			gint _tmp101_;
			gpointer _tmp102_;
			ValaTypeParameter* _tmp103_;
			_tmp97_ = _p_index;
			_p_index = _tmp97_ + 1;
			_tmp98_ = _p_index;
			_tmp99_ = _p_size;
			if (!(_tmp98_ < _tmp99_)) {
				break;
			}
			_tmp100_ = _p_list;
			_tmp101_ = _p_index;
			_tmp102_ = vala_list_get (_tmp100_, _tmp101_);
			p = (ValaTypeParameter*) _tmp102_;
			_tmp103_ = p;
			vala_code_node_check ((ValaCodeNode*) _tmp103_, context);
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	{
		ValaList* _en_list = NULL;
		ValaList* _tmp104_;
		gint _en_size = 0;
		ValaList* _tmp105_;
		gint _tmp106_;
		gint _tmp107_;
		gint _en_index = 0;
		_tmp104_ = vala_object_type_symbol_get_enums ((ValaObjectTypeSymbol*) self);
		_en_list = _tmp104_;
		_tmp105_ = _en_list;
		_tmp106_ = vala_collection_get_size ((ValaCollection*) _tmp105_);
		_tmp107_ = _tmp106_;
		_en_size = _tmp107_;
		_en_index = -1;
		while (TRUE) {
			gint _tmp108_;
			gint _tmp109_;
			gint _tmp110_;
			ValaEnum* en = NULL;
			ValaList* _tmp111_;
			gint _tmp112_;
			gpointer _tmp113_;
			ValaEnum* _tmp114_;
			_tmp108_ = _en_index;
			_en_index = _tmp108_ + 1;
			_tmp109_ = _en_index;
			_tmp110_ = _en_size;
			if (!(_tmp109_ < _tmp110_)) {
				break;
			}
			_tmp111_ = _en_list;
			_tmp112_ = _en_index;
			_tmp113_ = vala_list_get (_tmp111_, _tmp112_);
			en = (ValaEnum*) _tmp113_;
			_tmp114_ = en;
			vala_code_node_check ((ValaCodeNode*) _tmp114_, context);
			_vala_code_node_unref0 (en);
		}
		_vala_iterable_unref0 (_en_list);
	}
	{
		ValaList* _f_list = NULL;
		ValaList* _tmp115_;
		gint _f_size = 0;
		ValaList* _tmp116_;
		gint _tmp117_;
		gint _tmp118_;
		gint _f_index = 0;
		_tmp115_ = vala_object_type_symbol_get_fields ((ValaObjectTypeSymbol*) self);
		_f_list = _tmp115_;
		_tmp116_ = _f_list;
		_tmp117_ = vala_collection_get_size ((ValaCollection*) _tmp116_);
		_tmp118_ = _tmp117_;
		_f_size = _tmp118_;
		_f_index = -1;
		while (TRUE) {
			gint _tmp119_;
			gint _tmp120_;
			gint _tmp121_;
			ValaField* f = NULL;
			ValaList* _tmp122_;
			gint _tmp123_;
			gpointer _tmp124_;
			ValaField* _tmp125_;
			_tmp119_ = _f_index;
			_f_index = _tmp119_ + 1;
			_tmp120_ = _f_index;
			_tmp121_ = _f_size;
			if (!(_tmp120_ < _tmp121_)) {
				break;
			}
			_tmp122_ = _f_list;
			_tmp123_ = _f_index;
			_tmp124_ = vala_list_get (_tmp122_, _tmp123_);
			f = (ValaField*) _tmp124_;
			_tmp125_ = f;
			vala_code_node_check ((ValaCodeNode*) _tmp125_, context);
			_vala_code_node_unref0 (f);
		}
		_vala_iterable_unref0 (_f_list);
	}
	{
		ValaList* _c_list = NULL;
		ValaList* _tmp126_;
		gint _c_size = 0;
		ValaList* _tmp127_;
		gint _tmp128_;
		gint _tmp129_;
		gint _c_index = 0;
		_tmp126_ = vala_object_type_symbol_get_constants ((ValaObjectTypeSymbol*) self);
		_c_list = _tmp126_;
		_tmp127_ = _c_list;
		_tmp128_ = vala_collection_get_size ((ValaCollection*) _tmp127_);
		_tmp129_ = _tmp128_;
		_c_size = _tmp129_;
		_c_index = -1;
		while (TRUE) {
			gint _tmp130_;
			gint _tmp131_;
			gint _tmp132_;
			ValaConstant* c = NULL;
			ValaList* _tmp133_;
			gint _tmp134_;
			gpointer _tmp135_;
			ValaConstant* _tmp136_;
			_tmp130_ = _c_index;
			_c_index = _tmp130_ + 1;
			_tmp131_ = _c_index;
			_tmp132_ = _c_size;
			if (!(_tmp131_ < _tmp132_)) {
				break;
			}
			_tmp133_ = _c_list;
			_tmp134_ = _c_index;
			_tmp135_ = vala_list_get (_tmp133_, _tmp134_);
			c = (ValaConstant*) _tmp135_;
			_tmp136_ = c;
			vala_code_node_check ((ValaCodeNode*) _tmp136_, context);
			_vala_code_node_unref0 (c);
		}
		_vala_iterable_unref0 (_c_list);
	}
	{
		ValaList* _m_list = NULL;
		ValaList* _tmp137_;
		gint _m_size = 0;
		ValaList* _tmp138_;
		gint _tmp139_;
		gint _tmp140_;
		gint _m_index = 0;
		_tmp137_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) self);
		_m_list = _tmp137_;
		_tmp138_ = _m_list;
		_tmp139_ = vala_collection_get_size ((ValaCollection*) _tmp138_);
		_tmp140_ = _tmp139_;
		_m_size = _tmp140_;
		_m_index = -1;
		while (TRUE) {
			gint _tmp141_;
			gint _tmp142_;
			gint _tmp143_;
			ValaMethod* m = NULL;
			ValaList* _tmp144_;
			gint _tmp145_;
			gpointer _tmp146_;
			ValaMethod* _tmp147_;
			_tmp141_ = _m_index;
			_m_index = _tmp141_ + 1;
			_tmp142_ = _m_index;
			_tmp143_ = _m_size;
			if (!(_tmp142_ < _tmp143_)) {
				break;
			}
			_tmp144_ = _m_list;
			_tmp145_ = _m_index;
			_tmp146_ = vala_list_get (_tmp144_, _tmp145_);
			m = (ValaMethod*) _tmp146_;
			_tmp147_ = m;
			vala_code_node_check ((ValaCodeNode*) _tmp147_, context);
			_vala_code_node_unref0 (m);
		}
		_vala_iterable_unref0 (_m_list);
	}
	{
		ValaList* _prop_list = NULL;
		ValaList* _tmp148_;
		gint _prop_size = 0;
		ValaList* _tmp149_;
		gint _tmp150_;
		gint _tmp151_;
		gint _prop_index = 0;
		_tmp148_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) self);
		_prop_list = _tmp148_;
		_tmp149_ = _prop_list;
		_tmp150_ = vala_collection_get_size ((ValaCollection*) _tmp149_);
		_tmp151_ = _tmp150_;
		_prop_size = _tmp151_;
		_prop_index = -1;
		while (TRUE) {
			gint _tmp152_;
			gint _tmp153_;
			gint _tmp154_;
			ValaProperty* prop = NULL;
			ValaList* _tmp155_;
			gint _tmp156_;
			gpointer _tmp157_;
			gboolean _tmp158_ = FALSE;
			ValaProperty* _tmp159_;
			ValaAttribute* _tmp160_;
			ValaProperty* _tmp167_;
			_tmp152_ = _prop_index;
			_prop_index = _tmp152_ + 1;
			_tmp153_ = _prop_index;
			_tmp154_ = _prop_size;
			if (!(_tmp153_ < _tmp154_)) {
				break;
			}
			_tmp155_ = _prop_list;
			_tmp156_ = _prop_index;
			_tmp157_ = vala_list_get (_tmp155_, _tmp156_);
			prop = (ValaProperty*) _tmp157_;
			_tmp159_ = prop;
			_tmp160_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp159_, "NoAccessorMethod");
			if (_tmp160_ != NULL) {
				ValaSemanticAnalyzer* _tmp161_;
				ValaSemanticAnalyzer* _tmp162_;
				ValaClass* _tmp163_;
				_tmp161_ = vala_code_context_get_analyzer (context);
				_tmp162_ = _tmp161_;
				_tmp163_ = _tmp162_->object_type;
				_tmp158_ = !vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) self, (ValaTypeSymbol*) _tmp163_);
			} else {
				_tmp158_ = FALSE;
			}
			if (_tmp158_) {
				ValaProperty* _tmp164_;
				ValaSourceReference* _tmp165_;
				ValaSourceReference* _tmp166_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp164_ = prop;
				_tmp165_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp164_);
				_tmp166_ = _tmp165_;
				vala_report_error (_tmp166_, "NoAccessorMethod is only allowed for properties in classes derived fro" \
"m GLib.Object");
				result = FALSE;
				_vala_code_node_unref0 (prop);
				_vala_iterable_unref0 (_prop_list);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp167_ = prop;
			vala_code_node_check ((ValaCodeNode*) _tmp167_, context);
			_vala_code_node_unref0 (prop);
		}
		_vala_iterable_unref0 (_prop_list);
	}
	{
		ValaList* _sig_list = NULL;
		ValaList* _tmp168_;
		gint _sig_size = 0;
		ValaList* _tmp169_;
		gint _tmp170_;
		gint _tmp171_;
		gint _sig_index = 0;
		_tmp168_ = vala_object_type_symbol_get_signals ((ValaObjectTypeSymbol*) self);
		_sig_list = _tmp168_;
		_tmp169_ = _sig_list;
		_tmp170_ = vala_collection_get_size ((ValaCollection*) _tmp169_);
		_tmp171_ = _tmp170_;
		_sig_size = _tmp171_;
		_sig_index = -1;
		while (TRUE) {
			gint _tmp172_;
			gint _tmp173_;
			gint _tmp174_;
			ValaSignal* sig = NULL;
			ValaList* _tmp175_;
			gint _tmp176_;
			gpointer _tmp177_;
			ValaSignal* _tmp178_;
			_tmp172_ = _sig_index;
			_sig_index = _tmp172_ + 1;
			_tmp173_ = _sig_index;
			_tmp174_ = _sig_size;
			if (!(_tmp173_ < _tmp174_)) {
				break;
			}
			_tmp175_ = _sig_list;
			_tmp176_ = _sig_index;
			_tmp177_ = vala_list_get (_tmp175_, _tmp176_);
			sig = (ValaSignal*) _tmp177_;
			_tmp178_ = sig;
			vala_code_node_check ((ValaCodeNode*) _tmp178_, context);
			_vala_code_node_unref0 (sig);
		}
		_vala_iterable_unref0 (_sig_list);
	}
	_tmp179_ = self->priv->_constructor;
	if (_tmp179_ != NULL) {
		ValaConstructor* _tmp180_;
		_tmp180_ = self->priv->_constructor;
		vala_code_node_check ((ValaCodeNode*) _tmp180_, context);
	}
	_tmp181_ = self->priv->_class_constructor;
	if (_tmp181_ != NULL) {
		ValaConstructor* _tmp182_;
		_tmp182_ = self->priv->_class_constructor;
		vala_code_node_check ((ValaCodeNode*) _tmp182_, context);
	}
	_tmp183_ = self->priv->_static_constructor;
	if (_tmp183_ != NULL) {
		ValaConstructor* _tmp184_;
		_tmp184_ = self->priv->_static_constructor;
		vala_code_node_check ((ValaCodeNode*) _tmp184_, context);
	}
	_tmp185_ = vala_class_get_destructor (self);
	_tmp186_ = _tmp185_;
	if (_tmp186_ != NULL) {
		ValaDestructor* _tmp187_;
		ValaDestructor* _tmp188_;
		_tmp187_ = vala_class_get_destructor (self);
		_tmp188_ = _tmp187_;
		vala_code_node_check ((ValaCodeNode*) _tmp188_, context);
	}
	_tmp189_ = self->priv->_static_destructor;
	if (_tmp189_ != NULL) {
		ValaDestructor* _tmp190_;
		_tmp190_ = self->priv->_static_destructor;
		vala_code_node_check ((ValaCodeNode*) _tmp190_, context);
	}
	_tmp191_ = self->priv->_class_destructor;
	if (_tmp191_ != NULL) {
		ValaDestructor* _tmp192_;
		_tmp192_ = self->priv->_class_destructor;
		vala_code_node_check ((ValaCodeNode*) _tmp192_, context);
	}
	{
		ValaList* _cl_list = NULL;
		ValaList* _tmp193_;
		gint _cl_size = 0;
		ValaList* _tmp194_;
		gint _tmp195_;
		gint _tmp196_;
		gint _cl_index = 0;
		_tmp193_ = vala_object_type_symbol_get_classes ((ValaObjectTypeSymbol*) self);
		_cl_list = _tmp193_;
		_tmp194_ = _cl_list;
		_tmp195_ = vala_collection_get_size ((ValaCollection*) _tmp194_);
		_tmp196_ = _tmp195_;
		_cl_size = _tmp196_;
		_cl_index = -1;
		while (TRUE) {
			gint _tmp197_;
			gint _tmp198_;
			gint _tmp199_;
			ValaClass* cl = NULL;
			ValaList* _tmp200_;
			gint _tmp201_;
			gpointer _tmp202_;
			ValaClass* _tmp203_;
			_tmp197_ = _cl_index;
			_cl_index = _tmp197_ + 1;
			_tmp198_ = _cl_index;
			_tmp199_ = _cl_size;
			if (!(_tmp198_ < _tmp199_)) {
				break;
			}
			_tmp200_ = _cl_list;
			_tmp201_ = _cl_index;
			_tmp202_ = vala_list_get (_tmp200_, _tmp201_);
			cl = (ValaClass*) _tmp202_;
			_tmp203_ = cl;
			vala_code_node_check ((ValaCodeNode*) _tmp203_, context);
			_vala_code_node_unref0 (cl);
		}
		_vala_iterable_unref0 (_cl_list);
	}
	{
		ValaList* _st_list = NULL;
		ValaList* _tmp204_;
		gint _st_size = 0;
		ValaList* _tmp205_;
		gint _tmp206_;
		gint _tmp207_;
		gint _st_index = 0;
		_tmp204_ = vala_object_type_symbol_get_structs ((ValaObjectTypeSymbol*) self);
		_st_list = _tmp204_;
		_tmp205_ = _st_list;
		_tmp206_ = vala_collection_get_size ((ValaCollection*) _tmp205_);
		_tmp207_ = _tmp206_;
		_st_size = _tmp207_;
		_st_index = -1;
		while (TRUE) {
			gint _tmp208_;
			gint _tmp209_;
			gint _tmp210_;
			ValaStruct* st = NULL;
			ValaList* _tmp211_;
			gint _tmp212_;
			gpointer _tmp213_;
			ValaStruct* _tmp214_;
			_tmp208_ = _st_index;
			_st_index = _tmp208_ + 1;
			_tmp209_ = _st_index;
			_tmp210_ = _st_size;
			if (!(_tmp209_ < _tmp210_)) {
				break;
			}
			_tmp211_ = _st_list;
			_tmp212_ = _st_index;
			_tmp213_ = vala_list_get (_tmp211_, _tmp212_);
			st = (ValaStruct*) _tmp213_;
			_tmp214_ = st;
			vala_code_node_check ((ValaCodeNode*) _tmp214_, context);
			_vala_code_node_unref0 (st);
		}
		_vala_iterable_unref0 (_st_list);
	}
	{
		ValaList* _d_list = NULL;
		ValaList* _tmp215_;
		gint _d_size = 0;
		ValaList* _tmp216_;
		gint _tmp217_;
		gint _tmp218_;
		gint _d_index = 0;
		_tmp215_ = vala_object_type_symbol_get_delegates ((ValaObjectTypeSymbol*) self);
		_d_list = _tmp215_;
		_tmp216_ = _d_list;
		_tmp217_ = vala_collection_get_size ((ValaCollection*) _tmp216_);
		_tmp218_ = _tmp217_;
		_d_size = _tmp218_;
		_d_index = -1;
		while (TRUE) {
			gint _tmp219_;
			gint _tmp220_;
			gint _tmp221_;
			ValaDelegate* d = NULL;
			ValaList* _tmp222_;
			gint _tmp223_;
			gpointer _tmp224_;
			ValaDelegate* _tmp225_;
			_tmp219_ = _d_index;
			_d_index = _tmp219_ + 1;
			_tmp220_ = _d_index;
			_tmp221_ = _d_size;
			if (!(_tmp220_ < _tmp221_)) {
				break;
			}
			_tmp222_ = _d_list;
			_tmp223_ = _d_index;
			_tmp224_ = vala_list_get (_tmp222_, _tmp223_);
			d = (ValaDelegate*) _tmp224_;
			_tmp225_ = d;
			vala_code_node_check ((ValaCodeNode*) _tmp225_, context);
			_vala_code_node_unref0 (d);
		}
		_vala_iterable_unref0 (_d_list);
	}
	_tmp226_ = vala_class_get_is_compact (self);
	_tmp227_ = _tmp226_;
	if (_tmp227_) {
		gboolean _tmp247_ = FALSE;
		gboolean _tmp248_ = FALSE;
		gboolean _tmp249_ = FALSE;
		gboolean _tmp250_;
		gboolean _tmp251_;
		{
			ValaList* _base_type_list = NULL;
			ValaList* _tmp228_;
			gint _base_type_size = 0;
			ValaList* _tmp229_;
			gint _tmp230_;
			gint _tmp231_;
			gint _base_type_index = 0;
			_tmp228_ = vala_class_get_base_types (self);
			_base_type_list = _tmp228_;
			_tmp229_ = _base_type_list;
			_tmp230_ = vala_collection_get_size ((ValaCollection*) _tmp229_);
			_tmp231_ = _tmp230_;
			_base_type_size = _tmp231_;
			_base_type_index = -1;
			while (TRUE) {
				gint _tmp232_;
				gint _tmp233_;
				gint _tmp234_;
				ValaDataType* base_type = NULL;
				ValaList* _tmp235_;
				gint _tmp236_;
				gpointer _tmp237_;
				ValaDataType* _tmp238_;
				ValaTypeSymbol* _tmp239_;
				ValaTypeSymbol* _tmp240_;
				_tmp232_ = _base_type_index;
				_base_type_index = _tmp232_ + 1;
				_tmp233_ = _base_type_index;
				_tmp234_ = _base_type_size;
				if (!(_tmp233_ < _tmp234_)) {
					break;
				}
				_tmp235_ = _base_type_list;
				_tmp236_ = _base_type_index;
				_tmp237_ = vala_list_get (_tmp235_, _tmp236_);
				base_type = (ValaDataType*) _tmp237_;
				_tmp238_ = base_type;
				_tmp239_ = vala_data_type_get_data_type (_tmp238_);
				_tmp240_ = _tmp239_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp240_, VALA_TYPE_INTERFACE)) {
					ValaSourceReference* _tmp241_;
					ValaSourceReference* _tmp242_;
					gchar* _tmp243_;
					gchar* _tmp244_;
					gchar* _tmp245_;
					gchar* _tmp246_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp241_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp242_ = _tmp241_;
					_tmp243_ = vala_symbol_get_full_name ((ValaSymbol*) self);
					_tmp244_ = _tmp243_;
					_tmp245_ = g_strdup_printf ("compact classes `%s' may not implement interfaces", _tmp244_);
					_tmp246_ = _tmp245_;
					vala_report_error (_tmp242_, _tmp246_);
					_g_free0 (_tmp246_);
					_g_free0 (_tmp244_);
				}
				_vala_code_node_unref0 (base_type);
			}
			_vala_iterable_unref0 (_base_type_list);
		}
		_tmp250_ = vala_symbol_get_external ((ValaSymbol*) self);
		_tmp251_ = _tmp250_;
		if (!_tmp251_) {
			gboolean _tmp252_;
			gboolean _tmp253_;
			_tmp252_ = vala_symbol_get_external_package ((ValaSymbol*) self);
			_tmp253_ = _tmp252_;
			_tmp249_ = !_tmp253_;
		} else {
			_tmp249_ = FALSE;
		}
		if (_tmp249_) {
			ValaClass* _tmp254_;
			_tmp254_ = self->priv->_base_class;
			_tmp248_ = _tmp254_ != NULL;
		} else {
			_tmp248_ = FALSE;
		}
		if (_tmp248_) {
			ValaClass* _tmp255_;
			ValaSemanticAnalyzer* _tmp256_;
			ValaSemanticAnalyzer* _tmp257_;
			ValaClass* _tmp258_;
			_tmp255_ = self->priv->_base_class;
			_tmp256_ = vala_code_context_get_analyzer (context);
			_tmp257_ = _tmp256_;
			_tmp258_ = _tmp257_->gsource_type;
			_tmp247_ = _tmp255_ != _tmp258_;
		} else {
			_tmp247_ = FALSE;
		}
		if (_tmp247_) {
			{
				ValaList* _f_list = NULL;
				ValaList* _tmp259_;
				gint _f_size = 0;
				ValaList* _tmp260_;
				gint _tmp261_;
				gint _tmp262_;
				gint _f_index = 0;
				_tmp259_ = vala_object_type_symbol_get_fields ((ValaObjectTypeSymbol*) self);
				_f_list = _tmp259_;
				_tmp260_ = _f_list;
				_tmp261_ = vala_collection_get_size ((ValaCollection*) _tmp260_);
				_tmp262_ = _tmp261_;
				_f_size = _tmp262_;
				_f_index = -1;
				while (TRUE) {
					gint _tmp263_;
					gint _tmp264_;
					gint _tmp265_;
					ValaField* f = NULL;
					ValaList* _tmp266_;
					gint _tmp267_;
					gpointer _tmp268_;
					ValaField* _tmp269_;
					ValaMemberBinding _tmp270_;
					ValaMemberBinding _tmp271_;
					_tmp263_ = _f_index;
					_f_index = _tmp263_ + 1;
					_tmp264_ = _f_index;
					_tmp265_ = _f_size;
					if (!(_tmp264_ < _tmp265_)) {
						break;
					}
					_tmp266_ = _f_list;
					_tmp267_ = _f_index;
					_tmp268_ = vala_list_get (_tmp266_, _tmp267_);
					f = (ValaField*) _tmp268_;
					_tmp269_ = f;
					_tmp270_ = vala_field_get_binding (_tmp269_);
					_tmp271_ = _tmp270_;
					if (_tmp271_ == VALA_MEMBER_BINDING_INSTANCE) {
						ValaSourceReference* _tmp272_;
						ValaSourceReference* _tmp273_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp272_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp273_ = _tmp272_;
						vala_report_error (_tmp273_, "derived compact classes may not have instance fields");
						_vala_code_node_unref0 (f);
						break;
					}
					_vala_code_node_unref0 (f);
				}
				_vala_iterable_unref0 (_f_list);
			}
		}
	}
	_tmp274_ = g_direct_equal;
	_tmp275_ = vala_array_list_new (VALA_TYPE_TYPESYMBOL, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp274_);
	prerequisites = (ValaList*) _tmp275_;
	{
		ValaList* _base_type_list = NULL;
		ValaList* _tmp276_;
		gint _base_type_size = 0;
		ValaList* _tmp277_;
		gint _tmp278_;
		gint _tmp279_;
		gint _base_type_index = 0;
		_tmp276_ = vala_class_get_base_types (self);
		_base_type_list = _tmp276_;
		_tmp277_ = _base_type_list;
		_tmp278_ = vala_collection_get_size ((ValaCollection*) _tmp277_);
		_tmp279_ = _tmp278_;
		_base_type_size = _tmp279_;
		_base_type_index = -1;
		while (TRUE) {
			gint _tmp280_;
			gint _tmp281_;
			gint _tmp282_;
			ValaDataType* base_type = NULL;
			ValaList* _tmp283_;
			gint _tmp284_;
			gpointer _tmp285_;
			ValaDataType* _tmp286_;
			ValaTypeSymbol* _tmp287_;
			ValaTypeSymbol* _tmp288_;
			_tmp280_ = _base_type_index;
			_base_type_index = _tmp280_ + 1;
			_tmp281_ = _base_type_index;
			_tmp282_ = _base_type_size;
			if (!(_tmp281_ < _tmp282_)) {
				break;
			}
			_tmp283_ = _base_type_list;
			_tmp284_ = _base_type_index;
			_tmp285_ = vala_list_get (_tmp283_, _tmp284_);
			base_type = (ValaDataType*) _tmp285_;
			_tmp286_ = base_type;
			_tmp287_ = vala_data_type_get_data_type (_tmp286_);
			_tmp288_ = _tmp287_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp288_, VALA_TYPE_INTERFACE)) {
				ValaDataType* _tmp289_;
				ValaTypeSymbol* _tmp290_;
				ValaTypeSymbol* _tmp291_;
				ValaList* _tmp292_;
				_tmp289_ = base_type;
				_tmp290_ = vala_data_type_get_data_type (_tmp289_);
				_tmp291_ = _tmp290_;
				_tmp292_ = prerequisites;
				vala_class_get_all_prerequisites (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp291_, VALA_TYPE_INTERFACE, ValaInterface), _tmp292_);
			}
			_vala_code_node_unref0 (base_type);
		}
		_vala_iterable_unref0 (_base_type_list);
	}
	_tmp293_ = g_direct_equal;
	_tmp294_ = vala_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _tmp293_);
	missing_prereqs = (ValaList*) _tmp294_;
	{
		ValaList* _prereq_list = NULL;
		ValaList* _tmp295_;
		ValaList* _tmp296_;
		gint _prereq_size = 0;
		ValaList* _tmp297_;
		gint _tmp298_;
		gint _tmp299_;
		gint _prereq_index = 0;
		_tmp295_ = prerequisites;
		_tmp296_ = _vala_iterable_ref0 (_tmp295_);
		_prereq_list = _tmp296_;
		_tmp297_ = _prereq_list;
		_tmp298_ = vala_collection_get_size ((ValaCollection*) _tmp297_);
		_tmp299_ = _tmp298_;
		_prereq_size = _tmp299_;
		_prereq_index = -1;
		while (TRUE) {
			gint _tmp300_;
			gint _tmp301_;
			gint _tmp302_;
			ValaTypeSymbol* prereq = NULL;
			ValaList* _tmp303_;
			gint _tmp304_;
			gpointer _tmp305_;
			ValaTypeSymbol* _tmp306_;
			_tmp300_ = _prereq_index;
			_prereq_index = _tmp300_ + 1;
			_tmp301_ = _prereq_index;
			_tmp302_ = _prereq_size;
			if (!(_tmp301_ < _tmp302_)) {
				break;
			}
			_tmp303_ = _prereq_list;
			_tmp304_ = _prereq_index;
			_tmp305_ = vala_list_get (_tmp303_, _tmp304_);
			prereq = (ValaTypeSymbol*) _tmp305_;
			_tmp306_ = prereq;
			if (!vala_class_class_is_a (self, self, _tmp306_)) {
				ValaList* _tmp307_;
				ValaTypeSymbol* _tmp308_;
				gchar* _tmp309_;
				gchar* _tmp310_;
				_tmp307_ = missing_prereqs;
				_tmp308_ = prereq;
				_tmp309_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp308_);
				_tmp310_ = _tmp309_;
				vala_list_insert (_tmp307_, 0, _tmp310_);
				_g_free0 (_tmp310_);
			}
			_vala_code_node_unref0 (prereq);
		}
		_vala_iterable_unref0 (_prereq_list);
	}
	_tmp311_ = missing_prereqs;
	_tmp312_ = vala_collection_get_size ((ValaCollection*) _tmp311_);
	_tmp313_ = _tmp312_;
	if (_tmp313_ > 0) {
		gchar* error_string = NULL;
		gchar* _tmp314_;
		gchar* _tmp315_;
		gchar* _tmp316_;
		gchar* _tmp317_;
		gboolean first = FALSE;
		const gchar* _tmp336_;
		gchar* _tmp337_;
		ValaSourceReference* _tmp338_;
		ValaSourceReference* _tmp339_;
		const gchar* _tmp340_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp314_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp315_ = _tmp314_;
		_tmp316_ = g_strdup_printf ("%s: some prerequisites (", _tmp315_);
		_tmp317_ = _tmp316_;
		_g_free0 (_tmp315_);
		error_string = _tmp317_;
		first = TRUE;
		{
			ValaList* _s_list = NULL;
			ValaList* _tmp318_;
			ValaList* _tmp319_;
			gint _s_size = 0;
			ValaList* _tmp320_;
			gint _tmp321_;
			gint _tmp322_;
			gint _s_index = 0;
			_tmp318_ = missing_prereqs;
			_tmp319_ = _vala_iterable_ref0 (_tmp318_);
			_s_list = _tmp319_;
			_tmp320_ = _s_list;
			_tmp321_ = vala_collection_get_size ((ValaCollection*) _tmp320_);
			_tmp322_ = _tmp321_;
			_s_size = _tmp322_;
			_s_index = -1;
			while (TRUE) {
				gint _tmp323_;
				gint _tmp324_;
				gint _tmp325_;
				gchar* s = NULL;
				ValaList* _tmp326_;
				gint _tmp327_;
				gpointer _tmp328_;
				gboolean _tmp329_;
				_tmp323_ = _s_index;
				_s_index = _tmp323_ + 1;
				_tmp324_ = _s_index;
				_tmp325_ = _s_size;
				if (!(_tmp324_ < _tmp325_)) {
					break;
				}
				_tmp326_ = _s_list;
				_tmp327_ = _s_index;
				_tmp328_ = vala_list_get (_tmp326_, _tmp327_);
				s = (gchar*) _tmp328_;
				_tmp329_ = first;
				if (_tmp329_) {
					const gchar* _tmp330_;
					const gchar* _tmp331_;
					gchar* _tmp332_;
					_tmp330_ = error_string;
					_tmp331_ = s;
					_tmp332_ = g_strdup_printf ("%s`%s'", _tmp330_, _tmp331_);
					_g_free0 (error_string);
					error_string = _tmp332_;
					first = FALSE;
				} else {
					const gchar* _tmp333_;
					const gchar* _tmp334_;
					gchar* _tmp335_;
					_tmp333_ = error_string;
					_tmp334_ = s;
					_tmp335_ = g_strdup_printf ("%s, `%s'", _tmp333_, _tmp334_);
					_g_free0 (error_string);
					error_string = _tmp335_;
				}
				_g_free0 (s);
			}
			_vala_iterable_unref0 (_s_list);
		}
		_tmp336_ = error_string;
		_tmp337_ = g_strconcat (_tmp336_, ") are not met", NULL);
		_g_free0 (error_string);
		error_string = _tmp337_;
		_tmp338_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp339_ = _tmp338_;
		_tmp340_ = error_string;
		vala_report_error (_tmp339_, _tmp340_);
		_g_free0 (error_string);
	}
	_tmp341_ = vala_symbol_get_source_type ((ValaSymbol*) self);
	_tmp342_ = _tmp341_;
	if (_tmp342_ == VALA_SOURCE_FILE_TYPE_SOURCE) {
		gboolean _tmp492_;
		{
			ValaList* _base_type_list = NULL;
			ValaList* _tmp343_;
			gint _base_type_size = 0;
			ValaList* _tmp344_;
			gint _tmp345_;
			gint _tmp346_;
			gint _base_type_index = 0;
			_tmp343_ = vala_class_get_base_types (self);
			_base_type_list = _tmp343_;
			_tmp344_ = _base_type_list;
			_tmp345_ = vala_collection_get_size ((ValaCollection*) _tmp344_);
			_tmp346_ = _tmp345_;
			_base_type_size = _tmp346_;
			_base_type_index = -1;
			while (TRUE) {
				gint _tmp347_;
				gint _tmp348_;
				gint _tmp349_;
				ValaDataType* base_type = NULL;
				ValaList* _tmp350_;
				gint _tmp351_;
				gpointer _tmp352_;
				ValaDataType* _tmp353_;
				ValaTypeSymbol* _tmp354_;
				ValaTypeSymbol* _tmp355_;
				_tmp347_ = _base_type_index;
				_base_type_index = _tmp347_ + 1;
				_tmp348_ = _base_type_index;
				_tmp349_ = _base_type_size;
				if (!(_tmp348_ < _tmp349_)) {
					break;
				}
				_tmp350_ = _base_type_list;
				_tmp351_ = _base_type_index;
				_tmp352_ = vala_list_get (_tmp350_, _tmp351_);
				base_type = (ValaDataType*) _tmp352_;
				_tmp353_ = base_type;
				_tmp354_ = vala_data_type_get_data_type (_tmp353_);
				_tmp355_ = _tmp354_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp355_, VALA_TYPE_INTERFACE)) {
					ValaInterface* iface = NULL;
					ValaDataType* _tmp356_;
					ValaTypeSymbol* _tmp357_;
					ValaTypeSymbol* _tmp358_;
					ValaInterface* _tmp359_;
					gboolean _tmp360_ = FALSE;
					ValaClass* _tmp361_;
					_tmp356_ = base_type;
					_tmp357_ = vala_data_type_get_data_type (_tmp356_);
					_tmp358_ = _tmp357_;
					_tmp359_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp358_, VALA_TYPE_INTERFACE, ValaInterface));
					iface = _tmp359_;
					_tmp361_ = self->priv->_base_class;
					if (_tmp361_ != NULL) {
						ValaClass* _tmp362_;
						ValaInterface* _tmp363_;
						_tmp362_ = self->priv->_base_class;
						_tmp363_ = iface;
						_tmp360_ = vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp362_, (ValaTypeSymbol*) _tmp363_);
					} else {
						_tmp360_ = FALSE;
					}
					if (_tmp360_) {
						_vala_code_node_unref0 (iface);
						_vala_code_node_unref0 (base_type);
						break;
					}
					{
						ValaList* _m_list = NULL;
						ValaInterface* _tmp364_;
						ValaList* _tmp365_;
						gint _m_size = 0;
						ValaList* _tmp366_;
						gint _tmp367_;
						gint _tmp368_;
						gint _m_index = 0;
						_tmp364_ = iface;
						_tmp365_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) _tmp364_);
						_m_list = _tmp365_;
						_tmp366_ = _m_list;
						_tmp367_ = vala_collection_get_size ((ValaCollection*) _tmp366_);
						_tmp368_ = _tmp367_;
						_m_size = _tmp368_;
						_m_index = -1;
						while (TRUE) {
							gint _tmp369_;
							gint _tmp370_;
							gint _tmp371_;
							ValaMethod* m = NULL;
							ValaList* _tmp372_;
							gint _tmp373_;
							gpointer _tmp374_;
							ValaMethod* _tmp375_;
							gboolean _tmp376_;
							gboolean _tmp377_;
							_tmp369_ = _m_index;
							_m_index = _tmp369_ + 1;
							_tmp370_ = _m_index;
							_tmp371_ = _m_size;
							if (!(_tmp370_ < _tmp371_)) {
								break;
							}
							_tmp372_ = _m_list;
							_tmp373_ = _m_index;
							_tmp374_ = vala_list_get (_tmp372_, _tmp373_);
							m = (ValaMethod*) _tmp374_;
							_tmp375_ = m;
							_tmp376_ = vala_method_get_is_abstract (_tmp375_);
							_tmp377_ = _tmp376_;
							if (_tmp377_) {
								gboolean implemented = FALSE;
								ValaClass* base_class = NULL;
								ValaClass* _tmp378_;
								gboolean _tmp417_;
								implemented = FALSE;
								_tmp378_ = _vala_code_node_ref0 (self);
								base_class = _tmp378_;
								while (TRUE) {
									ValaClass* _tmp379_;
									ValaClass* _tmp414_;
									ValaClass* _tmp415_;
									ValaClass* _tmp416_;
									_tmp379_ = base_class;
									if (!(_tmp379_ != NULL)) {
										break;
									}
									{
										ValaList* _impl_list = NULL;
										ValaClass* _tmp380_;
										ValaList* _tmp381_;
										gint _impl_size = 0;
										ValaList* _tmp382_;
										gint _tmp383_;
										gint _tmp384_;
										gint _impl_index = 0;
										_tmp380_ = base_class;
										_tmp381_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) _tmp380_);
										_impl_list = _tmp381_;
										_tmp382_ = _impl_list;
										_tmp383_ = vala_collection_get_size ((ValaCollection*) _tmp382_);
										_tmp384_ = _tmp383_;
										_impl_size = _tmp384_;
										_impl_index = -1;
										while (TRUE) {
											gint _tmp385_;
											gint _tmp386_;
											gint _tmp387_;
											ValaMethod* impl = NULL;
											ValaList* _tmp388_;
											gint _tmp389_;
											gpointer _tmp390_;
											gboolean _tmp391_ = FALSE;
											ValaMethod* _tmp392_;
											const gchar* _tmp393_;
											const gchar* _tmp394_;
											ValaMethod* _tmp395_;
											const gchar* _tmp396_;
											const gchar* _tmp397_;
											_tmp385_ = _impl_index;
											_impl_index = _tmp385_ + 1;
											_tmp386_ = _impl_index;
											_tmp387_ = _impl_size;
											if (!(_tmp386_ < _tmp387_)) {
												break;
											}
											_tmp388_ = _impl_list;
											_tmp389_ = _impl_index;
											_tmp390_ = vala_list_get (_tmp388_, _tmp389_);
											impl = (ValaMethod*) _tmp390_;
											_tmp392_ = impl;
											_tmp393_ = vala_symbol_get_name ((ValaSymbol*) _tmp392_);
											_tmp394_ = _tmp393_;
											_tmp395_ = m;
											_tmp396_ = vala_symbol_get_name ((ValaSymbol*) _tmp395_);
											_tmp397_ = _tmp396_;
											if (g_strcmp0 (_tmp394_, _tmp397_) == 0) {
												gboolean _tmp398_ = FALSE;
												ValaMethod* _tmp399_;
												ValaDataType* _tmp400_;
												ValaDataType* _tmp401_;
												_tmp399_ = impl;
												_tmp400_ = vala_method_get_base_interface_type (_tmp399_);
												_tmp401_ = _tmp400_;
												if (_tmp401_ == NULL) {
													_tmp398_ = TRUE;
												} else {
													ValaMethod* _tmp402_;
													ValaDataType* _tmp403_;
													ValaDataType* _tmp404_;
													ValaTypeSymbol* _tmp405_;
													ValaTypeSymbol* _tmp406_;
													ValaInterface* _tmp407_;
													_tmp402_ = impl;
													_tmp403_ = vala_method_get_base_interface_type (_tmp402_);
													_tmp404_ = _tmp403_;
													_tmp405_ = vala_data_type_get_data_type (_tmp404_);
													_tmp406_ = _tmp405_;
													_tmp407_ = iface;
													_tmp398_ = _tmp406_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp407_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol);
												}
												_tmp391_ = _tmp398_;
											} else {
												_tmp391_ = FALSE;
											}
											if (_tmp391_) {
												ValaMethod* _tmp408_;
												ValaVersionAttribute* _tmp409_;
												ValaVersionAttribute* _tmp410_;
												ValaSourceReference* _tmp411_;
												ValaSourceReference* _tmp412_;
												ValaMethod* _tmp413_;
												_tmp408_ = impl;
												_tmp409_ = vala_symbol_get_version ((ValaSymbol*) _tmp408_);
												_tmp410_ = _tmp409_;
												_tmp411_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
												_tmp412_ = _tmp411_;
												vala_version_attribute_check (_tmp410_, _tmp412_);
												_tmp413_ = impl;
												vala_symbol_set_used ((ValaSymbol*) _tmp413_, TRUE);
												implemented = TRUE;
												_vala_code_node_unref0 (impl);
												break;
											}
											_vala_code_node_unref0 (impl);
										}
										_vala_iterable_unref0 (_impl_list);
									}
									_tmp414_ = base_class;
									_tmp415_ = _tmp414_->priv->_base_class;
									_tmp416_ = _vala_code_node_ref0 (_tmp415_);
									_vala_code_node_unref0 (base_class);
									base_class = _tmp416_;
								}
								_tmp417_ = implemented;
								if (!_tmp417_) {
									ValaSourceReference* _tmp418_;
									ValaSourceReference* _tmp419_;
									gchar* _tmp420_;
									gchar* _tmp421_;
									ValaMethod* _tmp422_;
									gchar* _tmp423_;
									gchar* _tmp424_;
									gchar* _tmp425_;
									gchar* _tmp426_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp418_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp419_ = _tmp418_;
									_tmp420_ = vala_symbol_get_full_name ((ValaSymbol*) self);
									_tmp421_ = _tmp420_;
									_tmp422_ = m;
									_tmp423_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp422_);
									_tmp424_ = _tmp423_;
									_tmp425_ = g_strdup_printf ("`%s' does not implement interface method `%s'", _tmp421_, _tmp424_);
									_tmp426_ = _tmp425_;
									vala_report_error (_tmp419_, _tmp426_);
									_g_free0 (_tmp426_);
									_g_free0 (_tmp424_);
									_g_free0 (_tmp421_);
								}
								_vala_code_node_unref0 (base_class);
							}
							_vala_code_node_unref0 (m);
						}
						_vala_iterable_unref0 (_m_list);
					}
					{
						ValaList* _prop_list = NULL;
						ValaInterface* _tmp427_;
						ValaList* _tmp428_;
						gint _prop_size = 0;
						ValaList* _tmp429_;
						gint _tmp430_;
						gint _tmp431_;
						gint _prop_index = 0;
						_tmp427_ = iface;
						_tmp428_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) _tmp427_);
						_prop_list = _tmp428_;
						_tmp429_ = _prop_list;
						_tmp430_ = vala_collection_get_size ((ValaCollection*) _tmp429_);
						_tmp431_ = _tmp430_;
						_prop_size = _tmp431_;
						_prop_index = -1;
						while (TRUE) {
							gint _tmp432_;
							gint _tmp433_;
							gint _tmp434_;
							ValaProperty* prop = NULL;
							ValaList* _tmp435_;
							gint _tmp436_;
							gpointer _tmp437_;
							ValaProperty* _tmp438_;
							gboolean _tmp439_;
							gboolean _tmp440_;
							_tmp432_ = _prop_index;
							_prop_index = _tmp432_ + 1;
							_tmp433_ = _prop_index;
							_tmp434_ = _prop_size;
							if (!(_tmp433_ < _tmp434_)) {
								break;
							}
							_tmp435_ = _prop_list;
							_tmp436_ = _prop_index;
							_tmp437_ = vala_list_get (_tmp435_, _tmp436_);
							prop = (ValaProperty*) _tmp437_;
							_tmp438_ = prop;
							_tmp439_ = vala_property_get_is_abstract (_tmp438_);
							_tmp440_ = _tmp439_;
							if (_tmp440_) {
								ValaSymbol* sym = NULL;
								ValaClass* base_class = NULL;
								ValaClass* _tmp441_;
								ValaSymbol* _tmp455_;
								sym = NULL;
								_tmp441_ = _vala_code_node_ref0 (self);
								base_class = _tmp441_;
								while (TRUE) {
									gboolean _tmp442_ = FALSE;
									ValaClass* _tmp443_;
									ValaClass* _tmp445_;
									ValaScope* _tmp446_;
									ValaScope* _tmp447_;
									ValaProperty* _tmp448_;
									const gchar* _tmp449_;
									const gchar* _tmp450_;
									ValaSymbol* _tmp451_;
									ValaClass* _tmp452_;
									ValaClass* _tmp453_;
									ValaClass* _tmp454_;
									_tmp443_ = base_class;
									if (_tmp443_ != NULL) {
										ValaSymbol* _tmp444_;
										_tmp444_ = sym;
										_tmp442_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp444_, VALA_TYPE_PROPERTY);
									} else {
										_tmp442_ = FALSE;
									}
									if (!_tmp442_) {
										break;
									}
									_tmp445_ = base_class;
									_tmp446_ = vala_symbol_get_scope ((ValaSymbol*) _tmp445_);
									_tmp447_ = _tmp446_;
									_tmp448_ = prop;
									_tmp449_ = vala_symbol_get_name ((ValaSymbol*) _tmp448_);
									_tmp450_ = _tmp449_;
									_tmp451_ = vala_scope_lookup (_tmp447_, _tmp450_);
									_vala_code_node_unref0 (sym);
									sym = _tmp451_;
									_tmp452_ = base_class;
									_tmp453_ = _tmp452_->priv->_base_class;
									_tmp454_ = _vala_code_node_ref0 (_tmp453_);
									_vala_code_node_unref0 (base_class);
									base_class = _tmp454_;
								}
								_tmp455_ = sym;
								if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp455_, VALA_TYPE_PROPERTY)) {
									ValaProperty* base_prop = NULL;
									ValaSymbol* _tmp456_;
									ValaProperty* _tmp457_;
									gchar* invalid_match = NULL;
									gboolean _tmp458_ = FALSE;
									ValaProperty* _tmp459_;
									gboolean _tmp460_;
									gboolean _tmp461_;
									ValaSymbol* _tmp477_;
									ValaVersionAttribute* _tmp478_;
									ValaVersionAttribute* _tmp479_;
									ValaSourceReference* _tmp480_;
									ValaSourceReference* _tmp481_;
									ValaSymbol* _tmp482_;
									_tmp456_ = sym;
									_tmp457_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp456_, VALA_TYPE_PROPERTY, ValaProperty));
									base_prop = _tmp457_;
									invalid_match = NULL;
									_tmp459_ = base_prop;
									_tmp460_ = vala_symbol_get_hides ((ValaSymbol*) _tmp459_);
									_tmp461_ = _tmp460_;
									if (!_tmp461_) {
										ValaProperty* _tmp462_;
										ValaProperty* _tmp463_;
										gchar* _tmp464_ = NULL;
										gboolean _tmp465_;
										_tmp462_ = base_prop;
										_tmp463_ = prop;
										_tmp465_ = vala_property_compatible (_tmp462_, _tmp463_, &_tmp464_);
										_g_free0 (invalid_match);
										invalid_match = _tmp464_;
										_tmp458_ = !_tmp465_;
									} else {
										_tmp458_ = FALSE;
									}
									if (_tmp458_) {
										ValaSourceReference* _tmp466_;
										ValaSourceReference* _tmp467_;
										ValaProperty* _tmp468_;
										gchar* _tmp469_;
										gchar* _tmp470_;
										ValaProperty* _tmp471_;
										gchar* _tmp472_;
										gchar* _tmp473_;
										const gchar* _tmp474_;
										gchar* _tmp475_;
										gchar* _tmp476_;
										vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
										_tmp466_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
										_tmp467_ = _tmp466_;
										_tmp468_ = prop;
										_tmp469_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp468_);
										_tmp470_ = _tmp469_;
										_tmp471_ = base_prop;
										_tmp472_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp471_);
										_tmp473_ = _tmp472_;
										_tmp474_ = invalid_match;
										_tmp475_ = g_strdup_printf ("Type and/or accessors of inherited properties `%s' and `%s' do not mat" \
"ch: %s.", _tmp470_, _tmp473_, _tmp474_);
										_tmp476_ = _tmp475_;
										vala_report_error (_tmp467_, _tmp476_);
										_g_free0 (_tmp476_);
										_g_free0 (_tmp473_);
										_g_free0 (_tmp470_);
									}
									_tmp477_ = sym;
									_tmp478_ = vala_symbol_get_version (_tmp477_);
									_tmp479_ = _tmp478_;
									_tmp480_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp481_ = _tmp480_;
									vala_version_attribute_check (_tmp479_, _tmp481_);
									_tmp482_ = sym;
									vala_symbol_set_used (_tmp482_, TRUE);
									_g_free0 (invalid_match);
									_vala_code_node_unref0 (base_prop);
								} else {
									ValaSourceReference* _tmp483_;
									ValaSourceReference* _tmp484_;
									gchar* _tmp485_;
									gchar* _tmp486_;
									ValaProperty* _tmp487_;
									gchar* _tmp488_;
									gchar* _tmp489_;
									gchar* _tmp490_;
									gchar* _tmp491_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp483_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp484_ = _tmp483_;
									_tmp485_ = vala_symbol_get_full_name ((ValaSymbol*) self);
									_tmp486_ = _tmp485_;
									_tmp487_ = prop;
									_tmp488_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp487_);
									_tmp489_ = _tmp488_;
									_tmp490_ = g_strdup_printf ("`%s' does not implement interface property `%s'", _tmp486_, _tmp489_);
									_tmp491_ = _tmp490_;
									vala_report_error (_tmp484_, _tmp491_);
									_g_free0 (_tmp491_);
									_g_free0 (_tmp489_);
									_g_free0 (_tmp486_);
								}
								_vala_code_node_unref0 (base_class);
								_vala_code_node_unref0 (sym);
							}
							_vala_code_node_unref0 (prop);
						}
						_vala_iterable_unref0 (_prop_list);
					}
					_vala_code_node_unref0 (iface);
				}
				_vala_code_node_unref0 (base_type);
			}
			_vala_iterable_unref0 (_base_type_list);
		}
		_tmp492_ = self->priv->_is_abstract;
		if (!_tmp492_) {
			ValaClass* base_class = NULL;
			ValaClass* _tmp493_;
			ValaClass* _tmp494_;
			_tmp493_ = self->priv->_base_class;
			_tmp494_ = _vala_code_node_ref0 (_tmp493_);
			base_class = _tmp494_;
			while (TRUE) {
				gboolean _tmp495_ = FALSE;
				ValaClass* _tmp496_;
				ValaClass* _tmp565_;
				ValaClass* _tmp566_;
				ValaClass* _tmp567_;
				_tmp496_ = base_class;
				if (_tmp496_ != NULL) {
					ValaClass* _tmp497_;
					gboolean _tmp498_;
					_tmp497_ = base_class;
					_tmp498_ = _tmp497_->priv->_is_abstract;
					_tmp495_ = _tmp498_;
				} else {
					_tmp495_ = FALSE;
				}
				if (!_tmp495_) {
					break;
				}
				{
					ValaList* _base_method_list = NULL;
					ValaClass* _tmp499_;
					ValaList* _tmp500_;
					gint _base_method_size = 0;
					ValaList* _tmp501_;
					gint _tmp502_;
					gint _tmp503_;
					gint _base_method_index = 0;
					_tmp499_ = base_class;
					_tmp500_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) _tmp499_);
					_base_method_list = _tmp500_;
					_tmp501_ = _base_method_list;
					_tmp502_ = vala_collection_get_size ((ValaCollection*) _tmp501_);
					_tmp503_ = _tmp502_;
					_base_method_size = _tmp503_;
					_base_method_index = -1;
					while (TRUE) {
						gint _tmp504_;
						gint _tmp505_;
						gint _tmp506_;
						ValaMethod* base_method = NULL;
						ValaList* _tmp507_;
						gint _tmp508_;
						gpointer _tmp509_;
						ValaMethod* _tmp510_;
						gboolean _tmp511_;
						gboolean _tmp512_;
						_tmp504_ = _base_method_index;
						_base_method_index = _tmp504_ + 1;
						_tmp505_ = _base_method_index;
						_tmp506_ = _base_method_size;
						if (!(_tmp505_ < _tmp506_)) {
							break;
						}
						_tmp507_ = _base_method_list;
						_tmp508_ = _base_method_index;
						_tmp509_ = vala_list_get (_tmp507_, _tmp508_);
						base_method = (ValaMethod*) _tmp509_;
						_tmp510_ = base_method;
						_tmp511_ = vala_method_get_is_abstract (_tmp510_);
						_tmp512_ = _tmp511_;
						if (_tmp512_) {
							ValaMethod* override_method = NULL;
							ValaMethod* _tmp513_;
							const gchar* _tmp514_;
							const gchar* _tmp515_;
							ValaSymbol* _tmp516_;
							ValaMethod* _tmp517_;
							gboolean _tmp518_ = FALSE;
							ValaMethod* _tmp519_;
							_tmp513_ = base_method;
							_tmp514_ = vala_symbol_get_name ((ValaSymbol*) _tmp513_);
							_tmp515_ = _tmp514_;
							_tmp516_ = vala_semantic_analyzer_symbol_lookup_inherited ((ValaSymbol*) self, _tmp515_);
							_tmp517_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp516_, VALA_TYPE_METHOD) ? ((ValaMethod*) _tmp516_) : NULL;
							if (_tmp517_ == NULL) {
								_vala_code_node_unref0 (_tmp516_);
							}
							override_method = _tmp517_;
							_tmp519_ = override_method;
							if (_tmp519_ == NULL) {
								_tmp518_ = TRUE;
							} else {
								ValaMethod* _tmp520_;
								gboolean _tmp521_;
								gboolean _tmp522_;
								_tmp520_ = override_method;
								_tmp521_ = vala_method_get_overrides (_tmp520_);
								_tmp522_ = _tmp521_;
								_tmp518_ = !_tmp522_;
							}
							if (_tmp518_) {
								ValaSourceReference* _tmp523_;
								ValaSourceReference* _tmp524_;
								gchar* _tmp525_;
								gchar* _tmp526_;
								ValaMethod* _tmp527_;
								gchar* _tmp528_;
								gchar* _tmp529_;
								gchar* _tmp530_;
								gchar* _tmp531_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp523_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp524_ = _tmp523_;
								_tmp525_ = vala_symbol_get_full_name ((ValaSymbol*) self);
								_tmp526_ = _tmp525_;
								_tmp527_ = base_method;
								_tmp528_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp527_);
								_tmp529_ = _tmp528_;
								_tmp530_ = g_strdup_printf ("`%s' does not implement abstract method `%s'", _tmp526_, _tmp529_);
								_tmp531_ = _tmp530_;
								vala_report_error (_tmp524_, _tmp531_);
								_g_free0 (_tmp531_);
								_g_free0 (_tmp529_);
								_g_free0 (_tmp526_);
							}
							_vala_code_node_unref0 (override_method);
						}
						_vala_code_node_unref0 (base_method);
					}
					_vala_iterable_unref0 (_base_method_list);
				}
				{
					ValaList* _base_property_list = NULL;
					ValaClass* _tmp532_;
					ValaList* _tmp533_;
					gint _base_property_size = 0;
					ValaList* _tmp534_;
					gint _tmp535_;
					gint _tmp536_;
					gint _base_property_index = 0;
					_tmp532_ = base_class;
					_tmp533_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) _tmp532_);
					_base_property_list = _tmp533_;
					_tmp534_ = _base_property_list;
					_tmp535_ = vala_collection_get_size ((ValaCollection*) _tmp534_);
					_tmp536_ = _tmp535_;
					_base_property_size = _tmp536_;
					_base_property_index = -1;
					while (TRUE) {
						gint _tmp537_;
						gint _tmp538_;
						gint _tmp539_;
						ValaProperty* base_property = NULL;
						ValaList* _tmp540_;
						gint _tmp541_;
						gpointer _tmp542_;
						ValaProperty* _tmp543_;
						gboolean _tmp544_;
						gboolean _tmp545_;
						_tmp537_ = _base_property_index;
						_base_property_index = _tmp537_ + 1;
						_tmp538_ = _base_property_index;
						_tmp539_ = _base_property_size;
						if (!(_tmp538_ < _tmp539_)) {
							break;
						}
						_tmp540_ = _base_property_list;
						_tmp541_ = _base_property_index;
						_tmp542_ = vala_list_get (_tmp540_, _tmp541_);
						base_property = (ValaProperty*) _tmp542_;
						_tmp543_ = base_property;
						_tmp544_ = vala_property_get_is_abstract (_tmp543_);
						_tmp545_ = _tmp544_;
						if (_tmp545_) {
							ValaProperty* override_property = NULL;
							ValaProperty* _tmp546_;
							const gchar* _tmp547_;
							const gchar* _tmp548_;
							ValaSymbol* _tmp549_;
							ValaProperty* _tmp550_;
							gboolean _tmp551_ = FALSE;
							ValaProperty* _tmp552_;
							_tmp546_ = base_property;
							_tmp547_ = vala_symbol_get_name ((ValaSymbol*) _tmp546_);
							_tmp548_ = _tmp547_;
							_tmp549_ = vala_semantic_analyzer_symbol_lookup_inherited ((ValaSymbol*) self, _tmp548_);
							_tmp550_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp549_, VALA_TYPE_PROPERTY) ? ((ValaProperty*) _tmp549_) : NULL;
							if (_tmp550_ == NULL) {
								_vala_code_node_unref0 (_tmp549_);
							}
							override_property = _tmp550_;
							_tmp552_ = override_property;
							if (_tmp552_ == NULL) {
								_tmp551_ = TRUE;
							} else {
								ValaProperty* _tmp553_;
								gboolean _tmp554_;
								gboolean _tmp555_;
								_tmp553_ = override_property;
								_tmp554_ = vala_property_get_overrides (_tmp553_);
								_tmp555_ = _tmp554_;
								_tmp551_ = !_tmp555_;
							}
							if (_tmp551_) {
								ValaSourceReference* _tmp556_;
								ValaSourceReference* _tmp557_;
								gchar* _tmp558_;
								gchar* _tmp559_;
								ValaProperty* _tmp560_;
								gchar* _tmp561_;
								gchar* _tmp562_;
								gchar* _tmp563_;
								gchar* _tmp564_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp556_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp557_ = _tmp556_;
								_tmp558_ = vala_symbol_get_full_name ((ValaSymbol*) self);
								_tmp559_ = _tmp558_;
								_tmp560_ = base_property;
								_tmp561_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp560_);
								_tmp562_ = _tmp561_;
								_tmp563_ = g_strdup_printf ("`%s' does not implement abstract property `%s'", _tmp559_, _tmp562_);
								_tmp564_ = _tmp563_;
								vala_report_error (_tmp557_, _tmp564_);
								_g_free0 (_tmp564_);
								_g_free0 (_tmp562_);
								_g_free0 (_tmp559_);
							}
							_vala_code_node_unref0 (override_property);
						}
						_vala_code_node_unref0 (base_property);
					}
					_vala_iterable_unref0 (_base_property_list);
				}
				_tmp565_ = base_class;
				_tmp566_ = _tmp565_->priv->_base_class;
				_tmp567_ = _vala_code_node_ref0 (_tmp566_);
				_vala_code_node_unref0 (base_class);
				base_class = _tmp567_;
			}
			_vala_code_node_unref0 (base_class);
		}
	}
	_tmp568_ = vala_code_context_get_analyzer (context);
	_tmp569_ = _tmp568_;
	_tmp570_ = old_source_file;
	vala_semantic_analyzer_set_current_source_file (_tmp569_, _tmp570_);
	_tmp571_ = vala_code_context_get_analyzer (context);
	_tmp572_ = _tmp571_;
	_tmp573_ = old_symbol;
	vala_semantic_analyzer_set_current_symbol (_tmp572_, _tmp573_);
	_tmp574_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp575_ = _tmp574_;
	result = !_tmp575_;
	_vala_iterable_unref0 (missing_prereqs);
	_vala_iterable_unref0 (prerequisites);
	_vala_code_node_unref0 (old_symbol);
	_vala_source_file_unref0 (old_source_file);
	return result;
}


ValaClass*
vala_class_get_base_class (ValaClass* self)
{
	ValaClass* result;
	ValaClass* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_base_class;
	result = _tmp0_;
	return result;
}


void
vala_class_set_base_class (ValaClass* self,
                           ValaClass* value)
{
	ValaClass* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_base_class);
	self->priv->_base_class = _tmp0_;
}


gboolean
vala_class_get_is_abstract (ValaClass* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_abstract;
	result = _tmp0_;
	return result;
}


void
vala_class_set_is_abstract (ValaClass* self,
                            gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_abstract = value;
}


static gboolean*
_bool_dup (gboolean* self)
{
	gboolean* dup;
	dup = g_new0 (gboolean, 1);
	memcpy (dup, self, sizeof (gboolean));
	return dup;
}


static gpointer
__bool_dup0 (gpointer self)
{
	return self ? _bool_dup (self) : NULL;
}


gboolean
vala_class_get_is_compact (ValaClass* self)
{
	gboolean result;
	gboolean* _tmp0_;
	gboolean* _tmp9_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_compact;
	if (_tmp0_ == NULL) {
		ValaClass* _tmp1_;
		_tmp1_ = self->priv->_base_class;
		if (_tmp1_ != NULL) {
			ValaClass* _tmp2_;
			gboolean _tmp3_;
			gboolean _tmp4_;
			gboolean* _tmp5_;
			_tmp2_ = self->priv->_base_class;
			_tmp3_ = vala_class_get_is_compact (_tmp2_);
			_tmp4_ = _tmp3_;
			_tmp5_ = __bool_dup0 (&_tmp4_);
			_g_free0 (self->priv->_is_compact);
			self->priv->_is_compact = _tmp5_;
		} else {
			ValaAttribute* _tmp6_;
			gboolean _tmp7_;
			gboolean* _tmp8_;
			_tmp6_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "Compact");
			_tmp7_ = _tmp6_ != NULL;
			_tmp8_ = __bool_dup0 (&_tmp7_);
			_g_free0 (self->priv->_is_compact);
			self->priv->_is_compact = _tmp8_;
		}
	}
	_tmp9_ = self->priv->_is_compact;
	result = *_tmp9_;
	return result;
}


void
vala_class_set_is_compact (ValaClass* self,
                           gboolean value)
{
	gboolean* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = __bool_dup0 (&value);
	_g_free0 (self->priv->_is_compact);
	self->priv->_is_compact = _tmp0_;
	vala_code_node_set_attribute ((ValaCodeNode*) self, "Compact", value, NULL);
}


gboolean
vala_class_get_is_immutable (ValaClass* self)
{
	gboolean result;
	gboolean* _tmp0_;
	gboolean* _tmp9_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_immutable;
	if (_tmp0_ == NULL) {
		ValaClass* _tmp1_;
		_tmp1_ = self->priv->_base_class;
		if (_tmp1_ != NULL) {
			ValaClass* _tmp2_;
			gboolean _tmp3_;
			gboolean _tmp4_;
			gboolean* _tmp5_;
			_tmp2_ = self->priv->_base_class;
			_tmp3_ = vala_class_get_is_immutable (_tmp2_);
			_tmp4_ = _tmp3_;
			_tmp5_ = __bool_dup0 (&_tmp4_);
			_g_free0 (self->priv->_is_immutable);
			self->priv->_is_immutable = _tmp5_;
		} else {
			ValaAttribute* _tmp6_;
			gboolean _tmp7_;
			gboolean* _tmp8_;
			_tmp6_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "Immutable");
			_tmp7_ = _tmp6_ != NULL;
			_tmp8_ = __bool_dup0 (&_tmp7_);
			_g_free0 (self->priv->_is_immutable);
			self->priv->_is_immutable = _tmp8_;
		}
	}
	_tmp9_ = self->priv->_is_immutable;
	result = *_tmp9_;
	return result;
}


void
vala_class_set_is_immutable (ValaClass* self,
                             gboolean value)
{
	gboolean* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = __bool_dup0 (&value);
	_g_free0 (self->priv->_is_immutable);
	self->priv->_is_immutable = _tmp0_;
	vala_code_node_set_attribute ((ValaCodeNode*) self, "Immutable", value, NULL);
}


gboolean
vala_class_get_has_private_fields (ValaClass* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_has_private_fields;
	result = _tmp0_;
	return result;
}


void
vala_class_set_has_private_fields (ValaClass* self,
                                   gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_has_private_fields = value;
}


gboolean
vala_class_get_has_class_private_fields (ValaClass* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_has_class_private_fields;
	result = _tmp0_;
	return result;
}


static void
vala_class_set_has_class_private_fields (ValaClass* self,
                                         gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_has_class_private_fields = value;
}


ValaCreationMethod*
vala_class_get_default_construction_method (ValaClass* self)
{
	ValaCreationMethod* result;
	ValaCreationMethod* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_default_construction_method;
	result = _tmp0_;
	return result;
}


void
vala_class_set_default_construction_method (ValaClass* self,
                                            ValaCreationMethod* value)
{
	ValaCreationMethod* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_default_construction_method);
	self->priv->_default_construction_method = _tmp0_;
}


ValaConstructor*
vala_class_get_constructor (ValaClass* self)
{
	ValaConstructor* result;
	ValaConstructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_constructor;
	result = _tmp0_;
	return result;
}


void
vala_class_set_constructor (ValaClass* self,
                            ValaConstructor* value)
{
	ValaConstructor* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_constructor);
	self->priv->_constructor = _tmp0_;
}


ValaConstructor*
vala_class_get_class_constructor (ValaClass* self)
{
	ValaConstructor* result;
	ValaConstructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_class_constructor;
	result = _tmp0_;
	return result;
}


void
vala_class_set_class_constructor (ValaClass* self,
                                  ValaConstructor* value)
{
	ValaConstructor* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_class_constructor);
	self->priv->_class_constructor = _tmp0_;
}


ValaConstructor*
vala_class_get_static_constructor (ValaClass* self)
{
	ValaConstructor* result;
	ValaConstructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_static_constructor;
	result = _tmp0_;
	return result;
}


void
vala_class_set_static_constructor (ValaClass* self,
                                   ValaConstructor* value)
{
	ValaConstructor* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_static_constructor);
	self->priv->_static_constructor = _tmp0_;
}


ValaDestructor*
vala_class_get_destructor (ValaClass* self)
{
	ValaDestructor* result;
	ValaDestructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_destructor;
	result = _tmp0_;
	return result;
}


void
vala_class_set_destructor (ValaClass* self,
                           ValaDestructor* value)
{
	ValaDestructor* _tmp0_;
	ValaDestructor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_destructor);
	self->priv->_destructor = _tmp0_;
	_tmp1_ = self->priv->_destructor;
	if (_tmp1_ != NULL) {
		ValaDestructor* _tmp2_;
		ValaParameter* _tmp3_;
		ValaParameter* _tmp4_;
		ValaDestructor* _tmp13_;
		ValaObjectType* _tmp14_;
		ValaObjectType* _tmp15_;
		ValaParameter* _tmp16_;
		ValaParameter* _tmp17_;
		ValaDestructor* _tmp18_;
		ValaScope* _tmp19_;
		ValaScope* _tmp20_;
		ValaDestructor* _tmp21_;
		ValaParameter* _tmp22_;
		ValaParameter* _tmp23_;
		const gchar* _tmp24_;
		const gchar* _tmp25_;
		ValaDestructor* _tmp26_;
		ValaParameter* _tmp27_;
		ValaParameter* _tmp28_;
		_tmp2_ = self->priv->_destructor;
		_tmp3_ = vala_destructor_get_this_parameter (_tmp2_);
		_tmp4_ = _tmp3_;
		if (_tmp4_ != NULL) {
			ValaDestructor* _tmp5_;
			ValaScope* _tmp6_;
			ValaScope* _tmp7_;
			ValaDestructor* _tmp8_;
			ValaParameter* _tmp9_;
			ValaParameter* _tmp10_;
			const gchar* _tmp11_;
			const gchar* _tmp12_;
			_tmp5_ = self->priv->_destructor;
			_tmp6_ = vala_symbol_get_scope ((ValaSymbol*) _tmp5_);
			_tmp7_ = _tmp6_;
			_tmp8_ = self->priv->_destructor;
			_tmp9_ = vala_destructor_get_this_parameter (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = vala_symbol_get_name ((ValaSymbol*) _tmp10_);
			_tmp12_ = _tmp11_;
			vala_scope_remove (_tmp7_, _tmp12_);
		}
		_tmp13_ = self->priv->_destructor;
		_tmp14_ = vala_object_type_symbol_get_this_type ((ValaObjectTypeSymbol*) self);
		_tmp15_ = _tmp14_;
		_tmp16_ = vala_parameter_new ("this", (ValaDataType*) _tmp15_, NULL);
		_tmp17_ = _tmp16_;
		vala_destructor_set_this_parameter (_tmp13_, _tmp17_);
		_vala_code_node_unref0 (_tmp17_);
		_vala_code_node_unref0 (_tmp15_);
		_tmp18_ = self->priv->_destructor;
		_tmp19_ = vala_symbol_get_scope ((ValaSymbol*) _tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = self->priv->_destructor;
		_tmp22_ = vala_destructor_get_this_parameter (_tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = vala_symbol_get_name ((ValaSymbol*) _tmp23_);
		_tmp25_ = _tmp24_;
		_tmp26_ = self->priv->_destructor;
		_tmp27_ = vala_destructor_get_this_parameter (_tmp26_);
		_tmp28_ = _tmp27_;
		vala_scope_add (_tmp20_, _tmp25_, (ValaSymbol*) _tmp28_);
	}
}


ValaDestructor*
vala_class_get_static_destructor (ValaClass* self)
{
	ValaDestructor* result;
	ValaDestructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_static_destructor;
	result = _tmp0_;
	return result;
}


void
vala_class_set_static_destructor (ValaClass* self,
                                  ValaDestructor* value)
{
	ValaDestructor* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_static_destructor);
	self->priv->_static_destructor = _tmp0_;
}


ValaDestructor*
vala_class_get_class_destructor (ValaClass* self)
{
	ValaDestructor* result;
	ValaDestructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_class_destructor;
	result = _tmp0_;
	return result;
}


void
vala_class_set_class_destructor (ValaClass* self,
                                 ValaDestructor* value)
{
	ValaDestructor* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_class_destructor);
	self->priv->_class_destructor = _tmp0_;
}


gboolean
vala_class_get_is_error_base (ValaClass* self)
{
	gboolean result;
	ValaAttribute* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "ErrorBase");
	result = _tmp0_ != NULL;
	return result;
}


static void
vala_class_class_init (ValaClassClass * klass)
{
	vala_class_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_class_finalize;
	g_type_class_adjust_private_offset (klass, &ValaClass_private_offset);
	((ValaSymbolClass *) klass)->add_field = (void (*) (ValaSymbol *, ValaField*)) vala_class_real_add_field;
	((ValaSymbolClass *) klass)->add_method = (void (*) (ValaSymbol *, ValaMethod*)) vala_class_real_add_method;
	((ValaSymbolClass *) klass)->add_property = (void (*) (ValaSymbol *, ValaProperty*)) vala_class_real_add_property;
	((ValaSymbolClass *) klass)->add_constructor = (void (*) (ValaSymbol *, ValaConstructor*)) vala_class_real_add_constructor;
	((ValaSymbolClass *) klass)->add_destructor = (void (*) (ValaSymbol *, ValaDestructor*)) vala_class_real_add_destructor;
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_class_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_class_real_accept_children;
	((ValaTypeSymbolClass *) klass)->is_reference_type = (gboolean (*) (ValaTypeSymbol *)) vala_class_real_is_reference_type;
	((ValaTypeSymbolClass *) klass)->is_subtype_of = (gboolean (*) (ValaTypeSymbol *, ValaTypeSymbol*)) vala_class_real_is_subtype_of;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode *, ValaDataType*, ValaDataType*)) vala_class_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode *, ValaCodeContext*)) vala_class_real_check;
}


static void
vala_class_instance_init (ValaClass * self)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = vala_class_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->base_types = (ValaList*) _tmp1_;
}


static void
vala_class_finalize (ValaCodeNode * obj)
{
	ValaClass * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_CLASS, ValaClass);
	_vala_code_node_unref0 (self->priv->_base_class);
	_g_free0 (self->priv->_is_compact);
	_g_free0 (self->priv->_is_immutable);
	_vala_iterable_unref0 (self->priv->base_types);
	_vala_code_node_unref0 (self->priv->_default_construction_method);
	_vala_code_node_unref0 (self->priv->_constructor);
	_vala_code_node_unref0 (self->priv->_class_constructor);
	_vala_code_node_unref0 (self->priv->_static_constructor);
	_vala_code_node_unref0 (self->priv->_static_destructor);
	_vala_code_node_unref0 (self->priv->_class_destructor);
	_vala_code_node_unref0 (self->priv->_destructor);
	VALA_CODE_NODE_CLASS (vala_class_parent_class)->finalize (obj);
}


/**
 * Represents a class declaration in the source code.
 */
GType
vala_class_get_type (void)
{
	static volatile gsize vala_class_type_id__volatile = 0;
	if (g_once_init_enter (&vala_class_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaClassClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_class_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaClass), 0, (GInstanceInitFunc) vala_class_instance_init, NULL };
		GType vala_class_type_id;
		vala_class_type_id = g_type_register_static (VALA_TYPE_OBJECT_TYPE_SYMBOL, "ValaClass", &g_define_type_info, 0);
		ValaClass_private_offset = g_type_add_instance_private (vala_class_type_id, sizeof (ValaClassPrivate));
		g_once_init_leave (&vala_class_type_id__volatile, vala_class_type_id);
	}
	return vala_class_type_id__volatile;
}



