/* tracker-resources.c generated by valac 0.40.6, the Vala compiler
 * generated from tracker-resources.vala, do not modify */

/*
 * Copyright (C) 2006, Jamie McCracken <jamiemcc@gnome.org>
 * Copyright (C) 2008-2011, Nokia <ivan.frade@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 */


#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include "tracker-store/tracker-config.h"
#include <stdlib.h>
#include <string.h>
#include "libtracker-common/tracker-common.h"
#include "libtracker-data/tracker-data-manager.h"
#include "libtracker-data/tracker-db-interface.h"
#include "libtracker-sparql/tracker-sparql.h"
#include "libtracker-data/tracker-data-query.h"
#include "libtracker-data/tracker-data-update.h"
#include "libtracker-data/tracker-class.h"
#include "tracker-store/tracker-events.h"
#include "tracker-store/tracker-writeback.h"


#define TRACKER_TYPE_RESOURCES (tracker_resources_get_type ())
#define TRACKER_RESOURCES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_RESOURCES, TrackerResources))
#define TRACKER_RESOURCES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_RESOURCES, TrackerResourcesClass))
#define TRACKER_IS_RESOURCES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_RESOURCES))
#define TRACKER_IS_RESOURCES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_RESOURCES))
#define TRACKER_RESOURCES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_RESOURCES, TrackerResourcesClass))

typedef struct _TrackerResources TrackerResources;
typedef struct _TrackerResourcesClass TrackerResourcesClass;
typedef struct _TrackerResourcesPrivate TrackerResourcesPrivate;
enum  {
	TRACKER_RESOURCES_0_PROPERTY,
	TRACKER_RESOURCES_NUM_PROPERTIES
};
static GParamSpec* tracker_resources_properties[TRACKER_RESOURCES_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _TrackerResourcesLoadData TrackerResourcesLoadData;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _Block3Data Block3Data;
#define _g_variant_builder_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_builder_unref (var), NULL)))

#define TRACKER_STORE_TYPE_PRIORITY (tracker_store_priority_get_type ())
typedef struct _TrackerResourcesSparqlQueryData TrackerResourcesSparqlQueryData;
typedef struct _TrackerResourcesSparqlUpdateData TrackerResourcesSparqlUpdateData;
typedef struct _TrackerResourcesSparqlUpdateBlankData TrackerResourcesSparqlUpdateBlankData;
typedef struct _TrackerResourcesBatchSparqlUpdateData TrackerResourcesBatchSparqlUpdateData;
typedef struct _Block4Data Block4Data;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
enum  {
	TRACKER_RESOURCES_WRITEBACK_SIGNAL,
	TRACKER_RESOURCES_GRAPH_UPDATED_SIGNAL,
	TRACKER_RESOURCES_NUM_SIGNALS
};
static guint tracker_resources_signals[TRACKER_RESOURCES_NUM_SIGNALS] = {0};

struct _TrackerResources {
	GObject parent_instance;
	TrackerResourcesPrivate * priv;
};

struct _TrackerResourcesClass {
	GObjectClass parent_class;
};

struct _TrackerResourcesPrivate {
	GDBusConnection* connection;
	guint signal_timeout;
	gboolean regular_commit_pending;
	TrackerConfig* config;
};

struct _TrackerResourcesLoadData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TrackerResources* self;
	char* sender;
	gchar* uri;
	TrackerDBusRequest* request;
	TrackerDBusRequest* _tmp0_;
	GFile* file;
	GFile* _tmp1_;
	TrackerDataManager* data_manager;
	TrackerDataManager* _tmp2_;
	TrackerDataManager* _tmp3_;
	GError* ie;
	GError* _tmp4_;
	const gchar* _tmp5_;
	GError* _tmp6_;
	GError* e;
	GError* _tmp7_;
	GError* _tmp8_;
	GError* _tmp9_;
	GError* _tmp10_;
	GError* _tmp11_;
	const gchar* _tmp12_;
	GError* _tmp13_;
	GError * _inner_error_;
};

struct _Block3Data {
	int _ref_count_;
	TrackerResources* self;
	GVariantBuilder* builder;
};

typedef enum  {
	TRACKER_STORE_PRIORITY_HIGH,
	TRACKER_STORE_PRIORITY_LOW,
	TRACKER_STORE_PRIORITY_TURTLE,
	TRACKER_STORE_PRIORITY_N_PRIORITIES
} TrackerStorePriority;

typedef void (*TrackerStoreSparqlQueryInThread) (TrackerDBCursor* cursor, void* user_data, GError** error);
struct _TrackerResourcesSparqlQueryData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TrackerResources* self;
	char* sender;
	gchar* query;
	GVariant* result;
	TrackerDBusRequest* request;
	TrackerDBusRequest* _tmp0_;
	TrackerDBusRequest* _tmp1_;
	Block3Data* _data3_;
	GVariantBuilder* _tmp2_;
	TrackerDataManager* data_manager;
	TrackerDataManager* _tmp3_;
	TrackerDataManager* _tmp4_;
	TrackerDataManager* _tmp5_;
	GVariant* _result_;
	GVariantBuilder* _tmp6_;
	GVariant* _tmp7_;
	GVariant* _tmp8_;
	GError* _tmp9_;
	TrackerDBusRequest* _tmp10_;
	GError* e;
	TrackerDBusRequest* _tmp11_;
	GError* _tmp12_;
	GError* _tmp13_;
	GError* _tmp14_;
	GError* _tmp15_;
	GError* _tmp16_;
	const gchar* _tmp17_;
	GError* _tmp18_;
	GError * _inner_error_;
};

struct _TrackerResourcesSparqlUpdateData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TrackerResources* self;
	char* sender;
	gchar* update;
	TrackerDBusRequest* request;
	TrackerDBusRequest* _tmp0_;
	TrackerDataManager* data_manager;
	TrackerDataManager* _tmp1_;
	TrackerDataManager* _tmp2_;
	GError* ie;
	GError* _tmp3_;
	const gchar* _tmp4_;
	GError* _tmp5_;
	GError* e;
	GError* _tmp6_;
	GError* _tmp7_;
	GError* _tmp8_;
	GError* _tmp9_;
	GError* _tmp10_;
	const gchar* _tmp11_;
	GError* _tmp12_;
	GError * _inner_error_;
};

struct _TrackerResourcesSparqlUpdateBlankData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TrackerResources* self;
	char* sender;
	gchar* update;
	GVariant* result;
	TrackerDBusRequest* request;
	TrackerDBusRequest* _tmp0_;
	TrackerDBusRequest* _tmp1_;
	TrackerDataManager* data_manager;
	TrackerDataManager* _tmp2_;
	TrackerDataManager* _tmp3_;
	GVariant* variant;
	TrackerDataManager* _tmp4_;
	GVariant* _tmp5_;
	TrackerDBusRequest* _tmp6_;
	GError* ie;
	GError* _tmp7_;
	const gchar* _tmp8_;
	GError* _tmp9_;
	GError* e;
	TrackerDBusRequest* _tmp10_;
	GError* _tmp11_;
	GError* _tmp12_;
	GError* _tmp13_;
	GError* _tmp14_;
	GError* _tmp15_;
	const gchar* _tmp16_;
	GError* _tmp17_;
	GError * _inner_error_;
};

struct _TrackerResourcesBatchSparqlUpdateData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TrackerResources* self;
	char* sender;
	gchar* update;
	TrackerDBusRequest* request;
	TrackerDBusRequest* _tmp0_;
	TrackerDataManager* data_manager;
	TrackerDataManager* _tmp1_;
	TrackerDataManager* _tmp2_;
	GError* ie;
	GError* _tmp3_;
	const gchar* _tmp4_;
	GError* _tmp5_;
	GError* e;
	GError* _tmp6_;
	GError* _tmp7_;
	GError* _tmp8_;
	GError* _tmp9_;
	GError* _tmp10_;
	const gchar* _tmp11_;
	GError* _tmp12_;
	GError * _inner_error_;
};

struct _Block4Data {
	int _ref_count_;
	TrackerResources* self;
	GVariantBuilder* builder;
};


static gpointer tracker_resources_parent_class = NULL;

GType tracker_resources_get_type (void) G_GNUC_CONST;
guint tracker_resources_register_object (void* object,
                                         GDBusConnection* connection,
                                         const gchar* path,
                                         GError** error);
#define TRACKER_RESOURCES_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TRACKER_TYPE_RESOURCES, TrackerResourcesPrivate))
void tracker_resources_disable_signals (TrackerResources* self);
#define TRACKER_RESOURCES_PATH "/org/freedesktop/Tracker1/Resources"
#define TRACKER_RESOURCES_GRAPH_UPDATED_IMMEDIATE_EMIT_AT 50000
#define TRACKER_RESOURCES_DBUS_ARBITRARY_MAX_MSG_SIZE 10000000
TrackerResources* tracker_resources_new (GDBusConnection* connection,
                                         TrackerConfig* config_p);
TrackerResources* tracker_resources_construct (GType object_type,
                                               GDBusConnection* connection,
                                               TrackerConfig* config_p);
static void tracker_resources_load_data_free (gpointer _data);
void tracker_resources_load (TrackerResources* self,
                             const char* sender,
                             const gchar* uri,
                             GAsyncReadyCallback _callback_,
                             gpointer _user_data_);
void tracker_resources_load_finish (TrackerResources* self,
                                    GAsyncResult* _res_,
                                    GError** error);
static gboolean tracker_resources_load_co (TrackerResourcesLoadData* _data_);
TrackerDataManager* tracker_main_get_data_manager (void);
void tracker_store_queue_turtle_import (TrackerDataManager* manager,
                                        GFile* file,
                                        const gchar* client_id,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_);
void tracker_store_queue_turtle_import_finish (GAsyncResult* _res_,
                                               GError** error);
static void tracker_resources_load_ready (GObject* source_object,
                                   GAsyncResult* _res_,
                                   gpointer _user_data_);
static void tracker_resources_sparql_query_data_free (gpointer _data);
void tracker_resources_sparql_query (TrackerResources* self,
                                     const char* sender,
                                     const gchar* query,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_);
GVariant* tracker_resources_sparql_query_finish (TrackerResources* self,
                                                 GAsyncResult* _res_,
                                                 GError** error);
static gboolean tracker_resources_sparql_query_co (TrackerResourcesSparqlQueryData* _data_);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
GType tracker_store_priority_get_type (void) G_GNUC_CONST;
void tracker_store_sparql_query (TrackerDataManager* manager,
                                 const gchar* sparql,
                                 TrackerStorePriority priority,
                                 TrackerStoreSparqlQueryInThread in_thread,
                                 void* in_thread_target,
                                 const gchar* client_id,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_);
void tracker_store_sparql_query_finish (GAsyncResult* _res_,
                                        GError** error);
static void ___lambda8_ (Block3Data* _data3_,
                  TrackerDBCursor* cursor,
                  GError** error);
static void ____lambda8__tracker_store_sparql_query_in_thread (TrackerDBCursor* cursor,
                                                        gpointer self,
                                                        GError** error);
static void tracker_resources_sparql_query_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_);
static void tracker_resources_sparql_update_data_free (gpointer _data);
void tracker_resources_sparql_update (TrackerResources* self,
                                      const char* sender,
                                      const gchar* update,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_);
void tracker_resources_sparql_update_finish (TrackerResources* self,
                                             GAsyncResult* _res_,
                                             GError** error);
static gboolean tracker_resources_sparql_update_co (TrackerResourcesSparqlUpdateData* _data_);
void tracker_store_sparql_update (TrackerDataManager* manager,
                                  const gchar* sparql,
                                  TrackerStorePriority priority,
                                  const gchar* client_id,
                                  GAsyncReadyCallback _callback_,
                                  gpointer _user_data_);
void tracker_store_sparql_update_finish (GAsyncResult* _res_,
                                         GError** error);
static void tracker_resources_sparql_update_ready (GObject* source_object,
                                            GAsyncResult* _res_,
                                            gpointer _user_data_);
static void tracker_resources_sparql_update_blank_data_free (gpointer _data);
void tracker_resources_sparql_update_blank (TrackerResources* self,
                                            const char* sender,
                                            const gchar* update,
                                            GAsyncReadyCallback _callback_,
                                            gpointer _user_data_);
GVariant* tracker_resources_sparql_update_blank_finish (TrackerResources* self,
                                                        GAsyncResult* _res_,
                                                        GError** error);
static gboolean tracker_resources_sparql_update_blank_co (TrackerResourcesSparqlUpdateBlankData* _data_);
void tracker_store_sparql_update_blank (TrackerDataManager* manager,
                                        const gchar* sparql,
                                        TrackerStorePriority priority,
                                        const gchar* client_id,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_);
GVariant* tracker_store_sparql_update_blank_finish (GAsyncResult* _res_,
                                                    GError** error);
static void tracker_resources_sparql_update_blank_ready (GObject* source_object,
                                                  GAsyncResult* _res_,
                                                  gpointer _user_data_);
void tracker_resources_sync (TrackerResources* self,
                             const char* sender);
void tracker_store_wal_checkpoint (TrackerDBInterface* iface,
                                   gboolean blocking);
static void tracker_resources_batch_sparql_update_data_free (gpointer _data);
void tracker_resources_batch_sparql_update (TrackerResources* self,
                                            const char* sender,
                                            const gchar* update,
                                            GAsyncReadyCallback _callback_,
                                            gpointer _user_data_);
void tracker_resources_batch_sparql_update_finish (TrackerResources* self,
                                                   GAsyncResult* _res_,
                                                   GError** error);
static gboolean tracker_resources_batch_sparql_update_co (TrackerResourcesBatchSparqlUpdateData* _data_);
static void tracker_resources_batch_sparql_update_ready (GObject* source_object,
                                                  GAsyncResult* _res_,
                                                  gpointer _user_data_);
void tracker_resources_batch_commit (TrackerResources* self);
static gboolean tracker_resources_emit_graph_updated (TrackerResources* self,
                                               TrackerClass* cl);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void ___lambda9_ (Block4Data* _data4_,
                  gint graph_id,
                  gint subject_id,
                  gint pred_id,
                  gint object_id);
static void ____lambda9__tracker_events_foreach (gint graph_id,
                                          gint subject_id,
                                          gint pred_id,
                                          gint object_id,
                                          gpointer self);
static void ___lambda10_ (Block4Data* _data4_,
                   gint graph_id,
                   gint subject_id,
                   gint pred_id,
                   gint object_id);
static void ____lambda10__tracker_events_foreach (gint graph_id,
                                           gint subject_id,
                                           gint pred_id,
                                           gint object_id,
                                           gpointer self);
static gboolean tracker_resources_on_emit_signals (TrackerResources* self);
static void tracker_resources_on_statements_committed (TrackerResources* self,
                                                TrackerDataCommitType commit_type);
static gboolean _tracker_resources_on_emit_signals_gsource_func (gpointer self);
static void tracker_resources_on_statements_rolled_back (TrackerResources* self,
                                                  TrackerDataCommitType commit_type);
static void tracker_resources_check_graph_updated_signal (TrackerResources* self);
static void tracker_resources_on_statement_inserted (TrackerResources* self,
                                              gint graph_id,
                                              const gchar* graph,
                                              gint subject_id,
                                              const gchar* subject,
                                              gint pred_id,
                                              gint object_id,
                                              const gchar* object,
                                              GPtrArray* rdf_types);
static void tracker_resources_on_statement_deleted (TrackerResources* self,
                                             gint graph_id,
                                             const gchar* graph,
                                             gint subject_id,
                                             const gchar* subject,
                                             gint pred_id,
                                             gint object_id,
                                             const gchar* object,
                                             GPtrArray* rdf_types);
void tracker_resources_enable_signals (TrackerResources* self);
static void _tracker_resources_on_statement_inserted_tracker_statement_callback (gint graph_id,
                                                                          const gchar* graph,
                                                                          gint subject_id,
                                                                          const gchar* subject,
                                                                          gint predicate_id,
                                                                          gint object_id,
                                                                          const gchar* object,
                                                                          GPtrArray* rdf_types,
                                                                          gpointer self);
static void _tracker_resources_on_statement_deleted_tracker_statement_callback (gint graph_id,
                                                                         const gchar* graph,
                                                                         gint subject_id,
                                                                         const gchar* subject,
                                                                         gint predicate_id,
                                                                         gint object_id,
                                                                         const gchar* object,
                                                                         GPtrArray* rdf_types,
                                                                         gpointer self);
static void _tracker_resources_on_statements_committed_tracker_commit_callback (TrackerDataCommitType commit_type,
                                                                         gpointer self);
static void _tracker_resources_on_statements_rolled_back_tracker_commit_callback (TrackerDataCommitType commit_type,
                                                                           gpointer self);
void tracker_resources_unreg_batches (TrackerResources* self,
                                      const gchar* old_owner);
void tracker_store_unreg_batches (const gchar* client_id);
static void g_cclosure_user_marshal_VOID__STRING_VARIANT_VARIANT (GClosure * closure,
                                                           GValue * return_value,
                                                           guint n_param_values,
                                                           const GValue * param_values,
                                                           gpointer invocation_hint,
                                                           gpointer marshal_data);
static void tracker_resources_finalize (GObject * obj);
static void _dbus_tracker_resources_load (TrackerResources* self,
                                   GVariant* _parameters_,
                                   GDBusMethodInvocation* invocation);
static void _dbus_tracker_resources_load_ready (GObject * source_object,
                                         GAsyncResult * _res_,
                                         gpointer _user_data_);
static void _dbus_tracker_resources_sparql_query (TrackerResources* self,
                                           GVariant* _parameters_,
                                           GDBusMethodInvocation* invocation);
static void _dbus_tracker_resources_sparql_query_ready (GObject * source_object,
                                                 GAsyncResult * _res_,
                                                 gpointer _user_data_);
static void _dbus_tracker_resources_sparql_update (TrackerResources* self,
                                            GVariant* _parameters_,
                                            GDBusMethodInvocation* invocation);
static void _dbus_tracker_resources_sparql_update_ready (GObject * source_object,
                                                  GAsyncResult * _res_,
                                                  gpointer _user_data_);
static void _dbus_tracker_resources_sparql_update_blank (TrackerResources* self,
                                                  GVariant* _parameters_,
                                                  GDBusMethodInvocation* invocation);
static void _dbus_tracker_resources_sparql_update_blank_ready (GObject * source_object,
                                                        GAsyncResult * _res_,
                                                        gpointer _user_data_);
static void _dbus_tracker_resources_sync (TrackerResources* self,
                                   GVariant* _parameters_,
                                   GDBusMethodInvocation* invocation);
static void _dbus_tracker_resources_batch_sparql_update (TrackerResources* self,
                                                  GVariant* _parameters_,
                                                  GDBusMethodInvocation* invocation);
static void _dbus_tracker_resources_batch_sparql_update_ready (GObject * source_object,
                                                        GAsyncResult * _res_,
                                                        gpointer _user_data_);
static void _dbus_tracker_resources_batch_commit (TrackerResources* self,
                                           GVariant* _parameters_,
                                           GDBusMethodInvocation* invocation);
static void tracker_resources_dbus_interface_method_call (GDBusConnection* connection,
                                                   const gchar* sender,
                                                   const gchar* object_path,
                                                   const gchar* interface_name,
                                                   const gchar* method_name,
                                                   GVariant* parameters,
                                                   GDBusMethodInvocation* invocation,
                                                   gpointer user_data);
static GVariant* tracker_resources_dbus_interface_get_property (GDBusConnection* connection,
                                                         const gchar* sender,
                                                         const gchar* object_path,
                                                         const gchar* interface_name,
                                                         const gchar* property_name,
                                                         GError** error,
                                                         gpointer user_data);
static gboolean tracker_resources_dbus_interface_set_property (GDBusConnection* connection,
                                                        const gchar* sender,
                                                        const gchar* object_path,
                                                        const gchar* interface_name,
                                                        const gchar* property_name,
                                                        GVariant* value,
                                                        GError** error,
                                                        gpointer user_data);
static void _dbus_tracker_resources_writeback (GObject* _sender,
                                        GVariant* subjects,
                                        gpointer* _data);
static void _dbus_tracker_resources_graph_updated (GObject* _sender,
                                            const gchar* classname,
                                            GVariant* deletes,
                                            GVariant* inserts,
                                            gpointer* _data);
static void _tracker_resources_unregister_object (gpointer user_data);

static const GDBusArgInfo _tracker_resources_dbus_arg_info_load_uri = {-1, "uri", "s"};
static const GDBusArgInfo * const _tracker_resources_dbus_arg_info_load_in[] = {&_tracker_resources_dbus_arg_info_load_uri, NULL};
static const GDBusArgInfo * const _tracker_resources_dbus_arg_info_load_out[] = {NULL};
static const GDBusMethodInfo _tracker_resources_dbus_method_info_load = {-1, "Load", (GDBusArgInfo **) (&_tracker_resources_dbus_arg_info_load_in), (GDBusArgInfo **) (&_tracker_resources_dbus_arg_info_load_out)};
static const GDBusArgInfo _tracker_resources_dbus_arg_info_sparql_query_query = {-1, "query", "s"};
static const GDBusArgInfo _tracker_resources_dbus_arg_info_sparql_query_result = {-1, "result", "aas"};
static const GDBusArgInfo * const _tracker_resources_dbus_arg_info_sparql_query_in[] = {&_tracker_resources_dbus_arg_info_sparql_query_query, NULL};
static const GDBusArgInfo * const _tracker_resources_dbus_arg_info_sparql_query_out[] = {&_tracker_resources_dbus_arg_info_sparql_query_result, NULL};
static const GDBusMethodInfo _tracker_resources_dbus_method_info_sparql_query = {-1, "SparqlQuery", (GDBusArgInfo **) (&_tracker_resources_dbus_arg_info_sparql_query_in), (GDBusArgInfo **) (&_tracker_resources_dbus_arg_info_sparql_query_out)};
static const GDBusArgInfo _tracker_resources_dbus_arg_info_sparql_update_update = {-1, "update", "s"};
static const GDBusArgInfo * const _tracker_resources_dbus_arg_info_sparql_update_in[] = {&_tracker_resources_dbus_arg_info_sparql_update_update, NULL};
static const GDBusArgInfo * const _tracker_resources_dbus_arg_info_sparql_update_out[] = {NULL};
static const GDBusMethodInfo _tracker_resources_dbus_method_info_sparql_update = {-1, "SparqlUpdate", (GDBusArgInfo **) (&_tracker_resources_dbus_arg_info_sparql_update_in), (GDBusArgInfo **) (&_tracker_resources_dbus_arg_info_sparql_update_out)};
static const GDBusArgInfo _tracker_resources_dbus_arg_info_sparql_update_blank_update = {-1, "update", "s"};
static const GDBusArgInfo _tracker_resources_dbus_arg_info_sparql_update_blank_result = {-1, "result", "aaa{ss}"};
static const GDBusArgInfo * const _tracker_resources_dbus_arg_info_sparql_update_blank_in[] = {&_tracker_resources_dbus_arg_info_sparql_update_blank_update, NULL};
static const GDBusArgInfo * const _tracker_resources_dbus_arg_info_sparql_update_blank_out[] = {&_tracker_resources_dbus_arg_info_sparql_update_blank_result, NULL};
static const GDBusMethodInfo _tracker_resources_dbus_method_info_sparql_update_blank = {-1, "SparqlUpdateBlank", (GDBusArgInfo **) (&_tracker_resources_dbus_arg_info_sparql_update_blank_in), (GDBusArgInfo **) (&_tracker_resources_dbus_arg_info_sparql_update_blank_out)};
static const GDBusArgInfo * const _tracker_resources_dbus_arg_info_sync_in[] = {NULL};
static const GDBusArgInfo * const _tracker_resources_dbus_arg_info_sync_out[] = {NULL};
static const GDBusMethodInfo _tracker_resources_dbus_method_info_sync = {-1, "Sync", (GDBusArgInfo **) (&_tracker_resources_dbus_arg_info_sync_in), (GDBusArgInfo **) (&_tracker_resources_dbus_arg_info_sync_out)};
static const GDBusArgInfo _tracker_resources_dbus_arg_info_batch_sparql_update_update = {-1, "update", "s"};
static const GDBusArgInfo * const _tracker_resources_dbus_arg_info_batch_sparql_update_in[] = {&_tracker_resources_dbus_arg_info_batch_sparql_update_update, NULL};
static const GDBusArgInfo * const _tracker_resources_dbus_arg_info_batch_sparql_update_out[] = {NULL};
static const GDBusMethodInfo _tracker_resources_dbus_method_info_batch_sparql_update = {-1, "BatchSparqlUpdate", (GDBusArgInfo **) (&_tracker_resources_dbus_arg_info_batch_sparql_update_in), (GDBusArgInfo **) (&_tracker_resources_dbus_arg_info_batch_sparql_update_out)};
static const GDBusArgInfo * const _tracker_resources_dbus_arg_info_batch_commit_in[] = {NULL};
static const GDBusArgInfo * const _tracker_resources_dbus_arg_info_batch_commit_out[] = {NULL};
static const GDBusMethodInfo _tracker_resources_dbus_method_info_batch_commit = {-1, "BatchCommit", (GDBusArgInfo **) (&_tracker_resources_dbus_arg_info_batch_commit_in), (GDBusArgInfo **) (&_tracker_resources_dbus_arg_info_batch_commit_out)};
static const GDBusMethodInfo * const _tracker_resources_dbus_method_info[] = {&_tracker_resources_dbus_method_info_load, &_tracker_resources_dbus_method_info_sparql_query, &_tracker_resources_dbus_method_info_sparql_update, &_tracker_resources_dbus_method_info_sparql_update_blank, &_tracker_resources_dbus_method_info_sync, &_tracker_resources_dbus_method_info_batch_sparql_update, &_tracker_resources_dbus_method_info_batch_commit, NULL};
static const GDBusArgInfo _tracker_resources_dbus_arg_info_writeback_subjects = {-1, "subjects", "a{iai}"};
static const GDBusArgInfo * const _tracker_resources_dbus_arg_info_writeback[] = {&_tracker_resources_dbus_arg_info_writeback_subjects, NULL};
static const GDBusSignalInfo _tracker_resources_dbus_signal_info_writeback = {-1, "Writeback", (GDBusArgInfo **) (&_tracker_resources_dbus_arg_info_writeback)};
static const GDBusArgInfo _tracker_resources_dbus_arg_info_graph_updated_classname = {-1, "classname", "s"};
static const GDBusArgInfo _tracker_resources_dbus_arg_info_graph_updated_deletes = {-1, "deletes", "a(iiii)"};
static const GDBusArgInfo _tracker_resources_dbus_arg_info_graph_updated_inserts = {-1, "inserts", "a(iiii)"};
static const GDBusArgInfo * const _tracker_resources_dbus_arg_info_graph_updated[] = {&_tracker_resources_dbus_arg_info_graph_updated_classname, &_tracker_resources_dbus_arg_info_graph_updated_deletes, &_tracker_resources_dbus_arg_info_graph_updated_inserts, NULL};
static const GDBusSignalInfo _tracker_resources_dbus_signal_info_graph_updated = {-1, "GraphUpdated", (GDBusArgInfo **) (&_tracker_resources_dbus_arg_info_graph_updated)};
static const GDBusSignalInfo * const _tracker_resources_dbus_signal_info[] = {&_tracker_resources_dbus_signal_info_writeback, &_tracker_resources_dbus_signal_info_graph_updated, NULL};
static const GDBusPropertyInfo * const _tracker_resources_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _tracker_resources_dbus_interface_info = {-1, "org.freedesktop.Tracker1.Resources", (GDBusMethodInfo **) (&_tracker_resources_dbus_method_info), (GDBusSignalInfo **) (&_tracker_resources_dbus_signal_info), (GDBusPropertyInfo **) (&_tracker_resources_dbus_property_info)};
static const GDBusInterfaceVTable _tracker_resources_dbus_interface_vtable = {tracker_resources_dbus_interface_method_call, tracker_resources_dbus_interface_get_property, tracker_resources_dbus_interface_set_property};

static gpointer
_g_object_ref0 (gpointer self)
{
#line 61 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	return self ? g_object_ref (self) : NULL;
#line 602 "tracker-resources.c"
}


TrackerResources*
tracker_resources_construct (GType object_type,
                             GDBusConnection* connection,
                             TrackerConfig* config_p)
{
	TrackerResources * self = NULL;
	GDBusConnection* _tmp0_;
	TrackerConfig* _tmp1_;
#line 60 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	g_return_val_if_fail (connection != NULL, NULL);
#line 60 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	g_return_val_if_fail (config_p != NULL, NULL);
#line 60 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	self = (TrackerResources*) g_object_new (object_type, NULL);
#line 61 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp0_ = _g_object_ref0 (connection);
#line 61 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_g_object_unref0 (self->priv->connection);
#line 61 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	self->priv->connection = _tmp0_;
#line 62 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp1_ = _g_object_ref0 (config_p);
#line 62 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_g_object_unref0 (self->priv->config);
#line 62 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	self->priv->config = _tmp1_;
#line 60 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	return self;
#line 634 "tracker-resources.c"
}


TrackerResources*
tracker_resources_new (GDBusConnection* connection,
                       TrackerConfig* config_p)
{
#line 60 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	return tracker_resources_construct (TRACKER_TYPE_RESOURCES, connection, config_p);
#line 644 "tracker-resources.c"
}


static void
tracker_resources_load_data_free (gpointer _data)
{
	TrackerResourcesLoadData* _data_;
	_data_ = _data;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_g_free0 (_data_->sender);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_g_free0 (_data_->uri);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_g_object_unref0 (_data_->self);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	g_slice_free (TrackerResourcesLoadData, _data_);
#line 661 "tracker-resources.c"
}


void
tracker_resources_load (TrackerResources* self,
                        const char* sender,
                        const gchar* uri,
                        GAsyncReadyCallback _callback_,
                        gpointer _user_data_)
{
	TrackerResourcesLoadData* _data_;
	TrackerResources* _tmp0_;
	char* _tmp1_;
	gchar* _tmp2_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_ = g_slice_new0 (TrackerResourcesLoadData);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	g_task_set_task_data (_data_->_async_result, _data_, tracker_resources_load_data_free);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_->self = _tmp0_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp1_ = g_strdup (sender);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_g_free0 (_data_->sender);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_->sender = _tmp1_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp2_ = g_strdup (uri);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_g_free0 (_data_->uri);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_->uri = _tmp2_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	tracker_resources_load_co (_data_);
#line 700 "tracker-resources.c"
}


void
tracker_resources_load_finish (TrackerResources* self,
                               GAsyncResult* _res_,
                               GError** error)
{
	TrackerResourcesLoadData* _data_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	if (NULL == _data_) {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		return;
#line 716 "tracker-resources.c"
	}
}


static void
tracker_resources_load_ready (GObject* source_object,
                              GAsyncResult* _res_,
                              gpointer _user_data_)
{
	TrackerResourcesLoadData* _data_;
#line 71 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_ = _user_data_;
#line 71 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_->_source_object_ = source_object;
#line 71 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_->_res_ = _res_;
#line 71 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	tracker_resources_load_co (_data_);
#line 735 "tracker-resources.c"
}


static gpointer
_g_error_copy0 (gpointer self)
{
#line 79 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	return self ? g_error_copy (self) : NULL;
#line 744 "tracker-resources.c"
}


static gboolean
tracker_resources_load_co (TrackerResourcesLoadData* _data_)
{
#line 65 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	switch (_data_->_state_) {
#line 65 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		case 0:
#line 755 "tracker-resources.c"
		goto _state_0;
#line 65 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		case 1:
#line 759 "tracker-resources.c"
		goto _state_1;
		default:
#line 65 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		g_assert_not_reached ();
#line 764 "tracker-resources.c"
	}
	_state_0:
#line 66 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_->_tmp0_ = tracker_dbus_request_begin ((const gchar*) _data_->sender, "Resources.Load (uri: '%s')", _data_->uri, NULL);
#line 66 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_->request = _data_->_tmp0_;
#line 771 "tracker-resources.c"
	{
#line 68 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp1_ = g_file_new_for_uri (_data_->uri);
#line 68 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->file = _data_->_tmp1_;
#line 69 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp2_ = tracker_main_get_data_manager ();
#line 69 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp3_ = _g_object_ref0 (_data_->_tmp2_);
#line 69 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->data_manager = _data_->_tmp3_;
#line 71 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_state_ = 1;
#line 71 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		tracker_store_queue_turtle_import (_data_->data_manager, _data_->file, (const gchar*) _data_->sender, tracker_resources_load_ready, _data_);
#line 71 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		return FALSE;
#line 789 "tracker-resources.c"
		_state_1:
#line 71 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		tracker_store_queue_turtle_import_finish (_data_->_res_, &_data_->_inner_error_);
#line 71 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 71 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_g_object_unref0 (_data_->data_manager);
#line 71 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_g_object_unref0 (_data_->file);
#line 71 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
			if (g_error_matches (_data_->_inner_error_, TRACKER_DB_INTERFACE_ERROR, TRACKER_DB_NO_SPACE)) {
#line 801 "tracker-resources.c"
				goto __catch9_tracker_db_no_space;
			}
			goto __catch9_g_error;
		}
#line 73 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		tracker_dbus_request_end (_data_->request, NULL);
#line 67 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_g_object_unref0 (_data_->data_manager);
#line 67 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_g_object_unref0 (_data_->file);
#line 812 "tracker-resources.c"
	}
	goto __finally9;
	__catch9_tracker_db_no_space:
	{
#line 67 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->ie = _data_->_inner_error_;
#line 67 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_inner_error_ = NULL;
#line 75 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp4_ = _data_->ie;
#line 75 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp5_ = _data_->_tmp4_->message;
#line 75 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp6_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_NO_SPACE, _data_->_tmp5_);
#line 75 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_inner_error_ = _data_->_tmp6_;
#line 75 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_g_error_free0 (_data_->ie);
#line 831 "tracker-resources.c"
		goto __finally9;
	}
	goto __finally9;
	__catch9_g_error:
	{
#line 67 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->e = _data_->_inner_error_;
#line 67 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_inner_error_ = NULL;
#line 77 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp7_ = _data_->e;
#line 77 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		tracker_dbus_request_end (_data_->request, _data_->_tmp7_);
#line 78 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp8_ = _data_->e;
#line 78 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		if (_data_->_tmp8_->domain == TRACKER_SPARQL_ERROR) {
#line 79 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_data_->_tmp9_ = _data_->e;
#line 79 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_data_->_tmp10_ = _g_error_copy0 (_data_->_tmp9_);
#line 79 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_data_->_inner_error_ = _data_->_tmp10_;
#line 79 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_g_error_free0 (_data_->e);
#line 857 "tracker-resources.c"
			goto __finally9;
		} else {
#line 81 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_data_->_tmp11_ = _data_->e;
#line 81 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_data_->_tmp12_ = _data_->_tmp11_->message;
#line 81 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_data_->_tmp13_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_INTERNAL, _data_->_tmp12_);
#line 81 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_data_->_inner_error_ = _data_->_tmp13_;
#line 81 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_g_error_free0 (_data_->e);
#line 870 "tracker-resources.c"
			goto __finally9;
		}
#line 67 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_g_error_free0 (_data_->e);
#line 875 "tracker-resources.c"
	}
	__finally9:
#line 67 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 67 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 67 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		g_object_unref (_data_->_async_result);
#line 67 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		return FALSE;
#line 886 "tracker-resources.c"
	}
#line 65 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 65 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	if (_data_->_state_ != 0) {
#line 65 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		while (g_task_get_completed (_data_->_async_result) != TRUE) {
#line 65 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 896 "tracker-resources.c"
		}
	}
#line 65 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	g_object_unref (_data_->_async_result);
#line 65 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	return FALSE;
#line 903 "tracker-resources.c"
}


static void
tracker_resources_sparql_query_data_free (gpointer _data)
{
	TrackerResourcesSparqlQueryData* _data_;
	_data_ = _data;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_g_free0 (_data_->sender);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_g_free0 (_data_->query);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_g_variant_unref0 (_data_->result);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_g_object_unref0 (_data_->self);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	g_slice_free (TrackerResourcesSparqlQueryData, _data_);
#line 922 "tracker-resources.c"
}


void
tracker_resources_sparql_query (TrackerResources* self,
                                const char* sender,
                                const gchar* query,
                                GAsyncReadyCallback _callback_,
                                gpointer _user_data_)
{
	TrackerResourcesSparqlQueryData* _data_;
	TrackerResources* _tmp0_;
	char* _tmp1_;
	gchar* _tmp2_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_ = g_slice_new0 (TrackerResourcesSparqlQueryData);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	g_task_set_task_data (_data_->_async_result, _data_, tracker_resources_sparql_query_data_free);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_->self = _tmp0_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp1_ = g_strdup (sender);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_g_free0 (_data_->sender);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_->sender = _tmp1_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp2_ = g_strdup (query);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_g_free0 (_data_->query);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_->query = _tmp2_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	tracker_resources_sparql_query_co (_data_);
#line 961 "tracker-resources.c"
}


GVariant*
tracker_resources_sparql_query_finish (TrackerResources* self,
                                       GAsyncResult* _res_,
                                       GError** error)
{
	GVariant* result;
	TrackerResourcesSparqlQueryData* _data_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	if (NULL == _data_) {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		return NULL;
#line 978 "tracker-resources.c"
	}
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	result = _data_->result;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_->result = NULL;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	return result;
#line 986 "tracker-resources.c"
}


static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
#line 90 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	g_atomic_int_inc (&_data3_->_ref_count_);
#line 90 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	return _data3_;
#line 997 "tracker-resources.c"
}


static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
#line 90 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
#line 1008 "tracker-resources.c"
		TrackerResources* self;
#line 90 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		self = _data3_->self;
#line 90 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_g_variant_builder_unref0 (_data3_->builder);
#line 90 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_g_object_unref0 (self);
#line 90 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		g_slice_free (Block3Data, _data3_);
#line 1018 "tracker-resources.c"
	}
}


static void
___lambda8_ (Block3Data* _data3_,
             TrackerDBCursor* cursor,
             GError** error)
{
	TrackerResources* self;
	GError * _inner_error_ = NULL;
#line 94 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	self = _data3_->self;
#line 94 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	g_return_if_fail (cursor != NULL);
#line 95 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	while (TRUE) {
#line 1036 "tracker-resources.c"
		gboolean _tmp0_ = FALSE;
		GVariantBuilder* _tmp1_;
		GVariantBuilder* _tmp12_;
#line 95 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_tmp0_ = tracker_sparql_cursor_next ((TrackerSparqlCursor*) cursor, NULL, &_inner_error_);
#line 95 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 95 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
			g_propagate_error (error, _inner_error_);
#line 95 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
			return;
#line 1048 "tracker-resources.c"
		}
#line 95 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		if (!_tmp0_) {
#line 95 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
			break;
#line 1054 "tracker-resources.c"
		}
#line 96 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_tmp1_ = _data3_->builder;
#line 96 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		g_variant_builder_open (_tmp1_, (const GVariantType*) "as");
#line 1060 "tracker-resources.c"
		{
			gint i = 0;
#line 98 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
			i = 0;
#line 1065 "tracker-resources.c"
			{
				gboolean _tmp2_ = FALSE;
#line 98 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
				_tmp2_ = TRUE;
#line 98 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
				while (TRUE) {
#line 1072 "tracker-resources.c"
					gint _tmp4_;
					gint _tmp5_;
					gint _tmp6_;
					const gchar* str = NULL;
					gint _tmp7_;
					const gchar* _tmp8_;
					const gchar* _tmp9_;
					GVariantBuilder* _tmp10_;
					const gchar* _tmp11_;
#line 98 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
					if (!_tmp2_) {
#line 1084 "tracker-resources.c"
						gint _tmp3_;
#line 98 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
						_tmp3_ = i;
#line 98 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
						i = _tmp3_ + 1;
#line 1090 "tracker-resources.c"
					}
#line 98 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
					_tmp2_ = FALSE;
#line 98 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
					_tmp4_ = i;
#line 98 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
					_tmp5_ = tracker_sparql_cursor_get_n_columns ((TrackerSparqlCursor*) cursor);
#line 98 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
					_tmp6_ = _tmp5_;
#line 98 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
					if (!(_tmp4_ < _tmp6_)) {
#line 98 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
						break;
#line 1104 "tracker-resources.c"
					}
#line 99 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
					_tmp7_ = i;
#line 99 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
					_tmp8_ = tracker_sparql_cursor_get_string ((TrackerSparqlCursor*) cursor, _tmp7_, NULL);
#line 99 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
					str = _tmp8_;
#line 101 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
					_tmp9_ = str;
#line 101 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
					if (_tmp9_ == NULL) {
#line 102 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
						str = "";
#line 1118 "tracker-resources.c"
					}
#line 105 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
					_tmp10_ = _data3_->builder;
#line 105 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
					_tmp11_ = str;
#line 105 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
					g_variant_builder_add (_tmp10_, "s", _tmp11_, NULL);
#line 1126 "tracker-resources.c"
				}
			}
		}
#line 108 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_tmp12_ = _data3_->builder;
#line 108 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		g_variant_builder_close (_tmp12_);
#line 1134 "tracker-resources.c"
	}
}


static void
____lambda8__tracker_store_sparql_query_in_thread (TrackerDBCursor* cursor,
                                                   gpointer self,
                                                   GError** error)
{
#line 94 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	___lambda8_ (self, cursor, error);
#line 1146 "tracker-resources.c"
}


static void
tracker_resources_sparql_query_ready (GObject* source_object,
                                      GAsyncResult* _res_,
                                      gpointer _user_data_)
{
	TrackerResourcesSparqlQueryData* _data_;
#line 94 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_ = _user_data_;
#line 94 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_->_source_object_ = source_object;
#line 94 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_->_res_ = _res_;
#line 94 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	tracker_resources_sparql_query_co (_data_);
#line 1164 "tracker-resources.c"
}


static gboolean
tracker_resources_sparql_query_co (TrackerResourcesSparqlQueryData* _data_)
{
#line 87 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	switch (_data_->_state_) {
#line 87 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		case 0:
#line 1175 "tracker-resources.c"
		goto _state_0;
#line 87 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		case 1:
#line 1179 "tracker-resources.c"
		goto _state_1;
		default:
#line 87 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		g_assert_not_reached ();
#line 1184 "tracker-resources.c"
	}
	_state_0:
#line 88 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_->_tmp0_ = tracker_dbus_request_begin ((const gchar*) _data_->sender, "Resources.SparqlQuery", NULL);
#line 88 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_->request = _data_->_tmp0_;
#line 89 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_->_tmp1_ = _data_->request;
#line 89 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	tracker_dbus_request_debug (_data_->_tmp1_, "query: %s", _data_->query, NULL);
#line 1195 "tracker-resources.c"
	{
#line 90 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_data3_ = g_slice_new0 (Block3Data);
#line 90 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_data3_->_ref_count_ = 1;
#line 90 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_data3_->self = g_object_ref (_data_->self);
#line 91 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp2_ = g_variant_builder_new ((const GVariantType*) "aas");
#line 91 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_data3_->builder = _data_->_tmp2_;
#line 92 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp3_ = tracker_main_get_data_manager ();
#line 92 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp4_ = _g_object_ref0 (_data_->_tmp3_);
#line 92 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->data_manager = _data_->_tmp4_;
#line 94 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp5_ = _data_->data_manager;
#line 94 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_state_ = 1;
#line 94 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		tracker_store_sparql_query (_data_->_tmp5_, _data_->query, TRACKER_STORE_PRIORITY_HIGH, ____lambda8__tracker_store_sparql_query_in_thread, _data_->_data3_, (const gchar*) _data_->sender, tracker_resources_sparql_query_ready, _data_);
#line 94 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		return FALSE;
#line 1221 "tracker-resources.c"
		_state_1:
#line 94 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		tracker_store_sparql_query_finish (_data_->_res_, &_data_->_inner_error_);
#line 94 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 94 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_g_object_unref0 (_data_->data_manager);
#line 94 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
			block3_data_unref (_data_->_data3_);
#line 94 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_data_->_data3_ = NULL;
#line 1233 "tracker-resources.c"
			goto __catch10_g_error;
		}
#line 112 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp6_ = _data_->_data3_->builder;
#line 112 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp7_ = g_variant_builder_end (_data_->_tmp6_);
#line 112 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		g_variant_ref_sink (_data_->_tmp7_);
#line 112 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_result_ = _data_->_tmp7_;
#line 113 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp8_ = _data_->_result_;
#line 113 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		if (g_variant_get_size (_data_->_tmp8_) > ((gsize) TRACKER_RESOURCES_DBUS_ARBITRARY_MAX_MSG_SIZE)) {
#line 114 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_data_->_tmp9_ = g_error_new_literal (G_DBUS_ERROR, G_DBUS_ERROR_FAILED, "result set of the query is too large");
#line 114 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_data_->_inner_error_ = _data_->_tmp9_;
#line 114 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_g_variant_unref0 (_data_->_result_);
#line 114 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_g_object_unref0 (_data_->data_manager);
#line 114 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
			block3_data_unref (_data_->_data3_);
#line 114 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_data_->_data3_ = NULL;
#line 1260 "tracker-resources.c"
			goto __catch10_g_error;
		}
#line 117 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp10_ = _data_->request;
#line 117 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		tracker_dbus_request_end (_data_->_tmp10_, NULL);
#line 119 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->result = _data_->_result_;
#line 119 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_g_object_unref0 (_data_->data_manager);
#line 119 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		block3_data_unref (_data_->_data3_);
#line 119 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_data3_ = NULL;
#line 119 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 119 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		if (_data_->_state_ != 0) {
#line 119 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
			while (g_task_get_completed (_data_->_async_result) != TRUE) {
#line 119 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 1283 "tracker-resources.c"
			}
		}
#line 119 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		g_object_unref (_data_->_async_result);
#line 119 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		return FALSE;
#line 1290 "tracker-resources.c"
	}
	goto __finally10;
	__catch10_g_error:
	{
#line 90 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->e = _data_->_inner_error_;
#line 90 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_inner_error_ = NULL;
#line 121 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp11_ = _data_->request;
#line 121 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp12_ = _data_->e;
#line 121 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		tracker_dbus_request_end (_data_->_tmp11_, _data_->_tmp12_);
#line 122 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp13_ = _data_->e;
#line 122 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		if (_data_->_tmp13_->domain == TRACKER_SPARQL_ERROR) {
#line 123 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_data_->_tmp14_ = _data_->e;
#line 123 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_data_->_tmp15_ = _g_error_copy0 (_data_->_tmp14_);
#line 123 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_data_->_inner_error_ = _data_->_tmp15_;
#line 123 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_g_error_free0 (_data_->e);
#line 1317 "tracker-resources.c"
			goto __finally10;
		} else {
#line 125 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_data_->_tmp16_ = _data_->e;
#line 125 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_data_->_tmp17_ = _data_->_tmp16_->message;
#line 125 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_data_->_tmp18_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_INTERNAL, _data_->_tmp17_);
#line 125 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_data_->_inner_error_ = _data_->_tmp18_;
#line 125 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_g_error_free0 (_data_->e);
#line 1330 "tracker-resources.c"
			goto __finally10;
		}
#line 90 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_g_error_free0 (_data_->e);
#line 1335 "tracker-resources.c"
	}
	__finally10:
#line 90 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 90 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	g_object_unref (_data_->_async_result);
#line 90 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	return FALSE;
#line 1344 "tracker-resources.c"
}


static void
tracker_resources_sparql_update_data_free (gpointer _data)
{
	TrackerResourcesSparqlUpdateData* _data_;
	_data_ = _data;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_g_free0 (_data_->sender);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_g_free0 (_data_->update);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_g_object_unref0 (_data_->self);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	g_slice_free (TrackerResourcesSparqlUpdateData, _data_);
#line 1361 "tracker-resources.c"
}


void
tracker_resources_sparql_update (TrackerResources* self,
                                 const char* sender,
                                 const gchar* update,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_)
{
	TrackerResourcesSparqlUpdateData* _data_;
	TrackerResources* _tmp0_;
	char* _tmp1_;
	gchar* _tmp2_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_ = g_slice_new0 (TrackerResourcesSparqlUpdateData);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	g_task_set_task_data (_data_->_async_result, _data_, tracker_resources_sparql_update_data_free);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_->self = _tmp0_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp1_ = g_strdup (sender);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_g_free0 (_data_->sender);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_->sender = _tmp1_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp2_ = g_strdup (update);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_g_free0 (_data_->update);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_->update = _tmp2_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	tracker_resources_sparql_update_co (_data_);
#line 1400 "tracker-resources.c"
}


void
tracker_resources_sparql_update_finish (TrackerResources* self,
                                        GAsyncResult* _res_,
                                        GError** error)
{
	TrackerResourcesSparqlUpdateData* _data_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	if (NULL == _data_) {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		return;
#line 1416 "tracker-resources.c"
	}
}


static void
tracker_resources_sparql_update_ready (GObject* source_object,
                                       GAsyncResult* _res_,
                                       gpointer _user_data_)
{
	TrackerResourcesSparqlUpdateData* _data_;
#line 135 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_ = _user_data_;
#line 135 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_->_source_object_ = source_object;
#line 135 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_->_res_ = _res_;
#line 135 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	tracker_resources_sparql_update_co (_data_);
#line 1435 "tracker-resources.c"
}


static gboolean
tracker_resources_sparql_update_co (TrackerResourcesSparqlUpdateData* _data_)
{
#line 130 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	switch (_data_->_state_) {
#line 130 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		case 0:
#line 1446 "tracker-resources.c"
		goto _state_0;
#line 130 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		case 1:
#line 1450 "tracker-resources.c"
		goto _state_1;
		default:
#line 130 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		g_assert_not_reached ();
#line 1455 "tracker-resources.c"
	}
	_state_0:
#line 131 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_->_tmp0_ = tracker_dbus_request_begin ((const gchar*) _data_->sender, "Resources.SparqlUpdate", NULL);
#line 131 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_->request = _data_->_tmp0_;
#line 132 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	tracker_dbus_request_debug (_data_->request, "query: %s", _data_->update, NULL);
#line 1464 "tracker-resources.c"
	{
#line 134 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp1_ = tracker_main_get_data_manager ();
#line 134 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp2_ = _g_object_ref0 (_data_->_tmp1_);
#line 134 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->data_manager = _data_->_tmp2_;
#line 135 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_state_ = 1;
#line 135 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		tracker_store_sparql_update (_data_->data_manager, _data_->update, TRACKER_STORE_PRIORITY_HIGH, (const gchar*) _data_->sender, tracker_resources_sparql_update_ready, _data_);
#line 135 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		return FALSE;
#line 1478 "tracker-resources.c"
		_state_1:
#line 135 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		tracker_store_sparql_update_finish (_data_->_res_, &_data_->_inner_error_);
#line 135 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 135 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_g_object_unref0 (_data_->data_manager);
#line 135 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
			if (g_error_matches (_data_->_inner_error_, TRACKER_DB_INTERFACE_ERROR, TRACKER_DB_NO_SPACE)) {
#line 1488 "tracker-resources.c"
				goto __catch11_tracker_db_no_space;
			}
			goto __catch11_g_error;
		}
#line 137 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		tracker_dbus_request_end (_data_->request, NULL);
#line 133 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_g_object_unref0 (_data_->data_manager);
#line 1497 "tracker-resources.c"
	}
	goto __finally11;
	__catch11_tracker_db_no_space:
	{
#line 133 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->ie = _data_->_inner_error_;
#line 133 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_inner_error_ = NULL;
#line 139 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp3_ = _data_->ie;
#line 139 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp4_ = _data_->_tmp3_->message;
#line 139 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp5_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_NO_SPACE, _data_->_tmp4_);
#line 139 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_inner_error_ = _data_->_tmp5_;
#line 139 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_g_error_free0 (_data_->ie);
#line 1516 "tracker-resources.c"
		goto __finally11;
	}
	goto __finally11;
	__catch11_g_error:
	{
#line 133 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->e = _data_->_inner_error_;
#line 133 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_inner_error_ = NULL;
#line 141 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp6_ = _data_->e;
#line 141 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		tracker_dbus_request_end (_data_->request, _data_->_tmp6_);
#line 142 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp7_ = _data_->e;
#line 142 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		if (_data_->_tmp7_->domain == TRACKER_SPARQL_ERROR) {
#line 143 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_data_->_tmp8_ = _data_->e;
#line 143 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_data_->_tmp9_ = _g_error_copy0 (_data_->_tmp8_);
#line 143 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_data_->_inner_error_ = _data_->_tmp9_;
#line 143 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_g_error_free0 (_data_->e);
#line 1542 "tracker-resources.c"
			goto __finally11;
		} else {
#line 145 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_data_->_tmp10_ = _data_->e;
#line 145 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_data_->_tmp11_ = _data_->_tmp10_->message;
#line 145 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_data_->_tmp12_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_INTERNAL, _data_->_tmp11_);
#line 145 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_data_->_inner_error_ = _data_->_tmp12_;
#line 145 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_g_error_free0 (_data_->e);
#line 1555 "tracker-resources.c"
			goto __finally11;
		}
#line 133 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_g_error_free0 (_data_->e);
#line 1560 "tracker-resources.c"
	}
	__finally11:
#line 133 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 133 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 133 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		g_object_unref (_data_->_async_result);
#line 133 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		return FALSE;
#line 1571 "tracker-resources.c"
	}
#line 130 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 130 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	if (_data_->_state_ != 0) {
#line 130 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		while (g_task_get_completed (_data_->_async_result) != TRUE) {
#line 130 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 1581 "tracker-resources.c"
		}
	}
#line 130 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	g_object_unref (_data_->_async_result);
#line 130 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	return FALSE;
#line 1588 "tracker-resources.c"
}


static void
tracker_resources_sparql_update_blank_data_free (gpointer _data)
{
	TrackerResourcesSparqlUpdateBlankData* _data_;
	_data_ = _data;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_g_free0 (_data_->sender);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_g_free0 (_data_->update);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_g_variant_unref0 (_data_->result);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_g_object_unref0 (_data_->self);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	g_slice_free (TrackerResourcesSparqlUpdateBlankData, _data_);
#line 1607 "tracker-resources.c"
}


void
tracker_resources_sparql_update_blank (TrackerResources* self,
                                       const char* sender,
                                       const gchar* update,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_)
{
	TrackerResourcesSparqlUpdateBlankData* _data_;
	TrackerResources* _tmp0_;
	char* _tmp1_;
	gchar* _tmp2_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_ = g_slice_new0 (TrackerResourcesSparqlUpdateBlankData);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	g_task_set_task_data (_data_->_async_result, _data_, tracker_resources_sparql_update_blank_data_free);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_->self = _tmp0_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp1_ = g_strdup (sender);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_g_free0 (_data_->sender);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_->sender = _tmp1_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp2_ = g_strdup (update);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_g_free0 (_data_->update);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_->update = _tmp2_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	tracker_resources_sparql_update_blank_co (_data_);
#line 1646 "tracker-resources.c"
}


GVariant*
tracker_resources_sparql_update_blank_finish (TrackerResources* self,
                                              GAsyncResult* _res_,
                                              GError** error)
{
	GVariant* result;
	TrackerResourcesSparqlUpdateBlankData* _data_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	if (NULL == _data_) {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		return NULL;
#line 1663 "tracker-resources.c"
	}
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	result = _data_->result;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_->result = NULL;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	return result;
#line 1671 "tracker-resources.c"
}


static void
tracker_resources_sparql_update_blank_ready (GObject* source_object,
                                             GAsyncResult* _res_,
                                             gpointer _user_data_)
{
	TrackerResourcesSparqlUpdateBlankData* _data_;
#line 156 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_ = _user_data_;
#line 156 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_->_source_object_ = source_object;
#line 156 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_->_res_ = _res_;
#line 156 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	tracker_resources_sparql_update_blank_co (_data_);
#line 1689 "tracker-resources.c"
}


static gboolean
tracker_resources_sparql_update_blank_co (TrackerResourcesSparqlUpdateBlankData* _data_)
{
#line 151 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	switch (_data_->_state_) {
#line 151 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		case 0:
#line 1700 "tracker-resources.c"
		goto _state_0;
#line 151 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		case 1:
#line 1704 "tracker-resources.c"
		goto _state_1;
		default:
#line 151 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		g_assert_not_reached ();
#line 1709 "tracker-resources.c"
	}
	_state_0:
#line 152 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_->_tmp0_ = tracker_dbus_request_begin ((const gchar*) _data_->sender, "Resources.SparqlUpdateBlank", NULL);
#line 152 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_->request = _data_->_tmp0_;
#line 153 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_->_tmp1_ = _data_->request;
#line 153 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	tracker_dbus_request_debug (_data_->_tmp1_, "query: %s", _data_->update, NULL);
#line 1720 "tracker-resources.c"
	{
#line 155 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp2_ = tracker_main_get_data_manager ();
#line 155 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp3_ = _g_object_ref0 (_data_->_tmp2_);
#line 155 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->data_manager = _data_->_tmp3_;
#line 156 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp4_ = _data_->data_manager;
#line 156 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_state_ = 1;
#line 156 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		tracker_store_sparql_update_blank (_data_->_tmp4_, _data_->update, TRACKER_STORE_PRIORITY_HIGH, (const gchar*) _data_->sender, tracker_resources_sparql_update_blank_ready, _data_);
#line 156 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		return FALSE;
#line 1736 "tracker-resources.c"
		_state_1:
#line 156 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp5_ = tracker_store_sparql_update_blank_finish (_data_->_res_, &_data_->_inner_error_);
#line 156 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->variant = _data_->_tmp5_;
#line 156 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 156 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_g_object_unref0 (_data_->data_manager);
#line 156 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
			if (g_error_matches (_data_->_inner_error_, TRACKER_DB_INTERFACE_ERROR, TRACKER_DB_NO_SPACE)) {
#line 1748 "tracker-resources.c"
				goto __catch12_tracker_db_no_space;
			}
			goto __catch12_g_error;
		}
#line 158 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp6_ = _data_->request;
#line 158 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		tracker_dbus_request_end (_data_->_tmp6_, NULL);
#line 160 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->result = _data_->variant;
#line 160 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_g_object_unref0 (_data_->data_manager);
#line 160 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 160 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		if (_data_->_state_ != 0) {
#line 160 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
			while (g_task_get_completed (_data_->_async_result) != TRUE) {
#line 160 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 1769 "tracker-resources.c"
			}
		}
#line 160 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		g_object_unref (_data_->_async_result);
#line 160 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		return FALSE;
#line 1776 "tracker-resources.c"
	}
	goto __finally12;
	__catch12_tracker_db_no_space:
	{
#line 154 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->ie = _data_->_inner_error_;
#line 154 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_inner_error_ = NULL;
#line 162 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp7_ = _data_->ie;
#line 162 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp8_ = _data_->_tmp7_->message;
#line 162 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp9_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_NO_SPACE, _data_->_tmp8_);
#line 162 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_inner_error_ = _data_->_tmp9_;
#line 162 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_g_error_free0 (_data_->ie);
#line 1795 "tracker-resources.c"
		goto __finally12;
	}
	goto __finally12;
	__catch12_g_error:
	{
#line 154 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->e = _data_->_inner_error_;
#line 154 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_inner_error_ = NULL;
#line 164 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp10_ = _data_->request;
#line 164 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp11_ = _data_->e;
#line 164 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		tracker_dbus_request_end (_data_->_tmp10_, _data_->_tmp11_);
#line 165 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp12_ = _data_->e;
#line 165 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		if (_data_->_tmp12_->domain == TRACKER_SPARQL_ERROR) {
#line 166 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_data_->_tmp13_ = _data_->e;
#line 166 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_data_->_tmp14_ = _g_error_copy0 (_data_->_tmp13_);
#line 166 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_data_->_inner_error_ = _data_->_tmp14_;
#line 166 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_g_error_free0 (_data_->e);
#line 1823 "tracker-resources.c"
			goto __finally12;
		} else {
#line 168 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_data_->_tmp15_ = _data_->e;
#line 168 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_data_->_tmp16_ = _data_->_tmp15_->message;
#line 168 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_data_->_tmp17_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_INTERNAL, _data_->_tmp16_);
#line 168 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_data_->_inner_error_ = _data_->_tmp17_;
#line 168 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_g_error_free0 (_data_->e);
#line 1836 "tracker-resources.c"
			goto __finally12;
		}
#line 154 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_g_error_free0 (_data_->e);
#line 1841 "tracker-resources.c"
	}
	__finally12:
#line 154 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 154 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	g_object_unref (_data_->_async_result);
#line 154 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	return FALSE;
#line 1850 "tracker-resources.c"
}


void
tracker_resources_sync (TrackerResources* self,
                        const char* sender)
{
	TrackerDBusRequest* request = NULL;
	TrackerDBusRequest* _tmp0_;
	TrackerDataManager* data_manager = NULL;
	TrackerDataManager* _tmp1_;
	TrackerDataManager* _tmp2_;
	TrackerData* data = NULL;
	TrackerData* _tmp3_;
	TrackerData* _tmp4_;
	TrackerDBInterface* iface = NULL;
	TrackerDBInterface* _tmp5_;
	TrackerDBInterface* _tmp6_;
#line 173 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	g_return_if_fail (self != NULL);
#line 173 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	g_return_if_fail (sender != NULL);
#line 174 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp0_ = tracker_dbus_request_begin ((const gchar*) sender, "Resources.Sync", NULL);
#line 174 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	request = _tmp0_;
#line 175 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp1_ = tracker_main_get_data_manager ();
#line 175 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 175 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	data_manager = _tmp2_;
#line 176 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp3_ = tracker_data_manager_get_data (data_manager);
#line 176 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 176 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	data = _tmp4_;
#line 177 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp5_ = tracker_data_manager_get_writable_db_interface (data_manager);
#line 177 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp6_ = _g_object_ref0 (_tmp5_);
#line 177 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	iface = _tmp6_;
#line 180 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	tracker_store_wal_checkpoint (iface, TRUE);
#line 182 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	tracker_data_sync (data);
#line 184 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	tracker_dbus_request_end (request, NULL);
#line 173 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_g_object_unref0 (iface);
#line 173 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_g_object_unref0 (data);
#line 173 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_g_object_unref0 (data_manager);
#line 1907 "tracker-resources.c"
}


static void
tracker_resources_batch_sparql_update_data_free (gpointer _data)
{
	TrackerResourcesBatchSparqlUpdateData* _data_;
	_data_ = _data;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_g_free0 (_data_->sender);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_g_free0 (_data_->update);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_g_object_unref0 (_data_->self);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	g_slice_free (TrackerResourcesBatchSparqlUpdateData, _data_);
#line 1924 "tracker-resources.c"
}


void
tracker_resources_batch_sparql_update (TrackerResources* self,
                                       const char* sender,
                                       const gchar* update,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_)
{
	TrackerResourcesBatchSparqlUpdateData* _data_;
	TrackerResources* _tmp0_;
	char* _tmp1_;
	gchar* _tmp2_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_ = g_slice_new0 (TrackerResourcesBatchSparqlUpdateData);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	g_task_set_task_data (_data_->_async_result, _data_, tracker_resources_batch_sparql_update_data_free);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_->self = _tmp0_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp1_ = g_strdup (sender);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_g_free0 (_data_->sender);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_->sender = _tmp1_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp2_ = g_strdup (update);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_g_free0 (_data_->update);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_->update = _tmp2_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	tracker_resources_batch_sparql_update_co (_data_);
#line 1963 "tracker-resources.c"
}


void
tracker_resources_batch_sparql_update_finish (TrackerResources* self,
                                              GAsyncResult* _res_,
                                              GError** error)
{
	TrackerResourcesBatchSparqlUpdateData* _data_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	if (NULL == _data_) {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		return;
#line 1979 "tracker-resources.c"
	}
}


static void
tracker_resources_batch_sparql_update_ready (GObject* source_object,
                                             GAsyncResult* _res_,
                                             gpointer _user_data_)
{
	TrackerResourcesBatchSparqlUpdateData* _data_;
#line 192 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_ = _user_data_;
#line 192 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_->_source_object_ = source_object;
#line 192 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_->_res_ = _res_;
#line 192 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	tracker_resources_batch_sparql_update_co (_data_);
#line 1998 "tracker-resources.c"
}


static gboolean
tracker_resources_batch_sparql_update_co (TrackerResourcesBatchSparqlUpdateData* _data_)
{
#line 187 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	switch (_data_->_state_) {
#line 187 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		case 0:
#line 2009 "tracker-resources.c"
		goto _state_0;
#line 187 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		case 1:
#line 2013 "tracker-resources.c"
		goto _state_1;
		default:
#line 187 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		g_assert_not_reached ();
#line 2018 "tracker-resources.c"
	}
	_state_0:
#line 188 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_->_tmp0_ = tracker_dbus_request_begin ((const gchar*) _data_->sender, "Resources.BatchSparqlUpdate", NULL);
#line 188 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_->request = _data_->_tmp0_;
#line 189 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	tracker_dbus_request_debug (_data_->request, "query: %s", _data_->update, NULL);
#line 2027 "tracker-resources.c"
	{
#line 191 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp1_ = tracker_main_get_data_manager ();
#line 191 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp2_ = _g_object_ref0 (_data_->_tmp1_);
#line 191 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->data_manager = _data_->_tmp2_;
#line 192 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_state_ = 1;
#line 192 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		tracker_store_sparql_update (_data_->data_manager, _data_->update, TRACKER_STORE_PRIORITY_LOW, (const gchar*) _data_->sender, tracker_resources_batch_sparql_update_ready, _data_);
#line 192 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		return FALSE;
#line 2041 "tracker-resources.c"
		_state_1:
#line 192 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		tracker_store_sparql_update_finish (_data_->_res_, &_data_->_inner_error_);
#line 192 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 192 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_g_object_unref0 (_data_->data_manager);
#line 192 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
			if (g_error_matches (_data_->_inner_error_, TRACKER_DB_INTERFACE_ERROR, TRACKER_DB_NO_SPACE)) {
#line 2051 "tracker-resources.c"
				goto __catch13_tracker_db_no_space;
			}
			goto __catch13_g_error;
		}
#line 194 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		tracker_dbus_request_end (_data_->request, NULL);
#line 190 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_g_object_unref0 (_data_->data_manager);
#line 2060 "tracker-resources.c"
	}
	goto __finally13;
	__catch13_tracker_db_no_space:
	{
#line 190 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->ie = _data_->_inner_error_;
#line 190 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_inner_error_ = NULL;
#line 196 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp3_ = _data_->ie;
#line 196 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp4_ = _data_->_tmp3_->message;
#line 196 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp5_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_NO_SPACE, _data_->_tmp4_);
#line 196 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_inner_error_ = _data_->_tmp5_;
#line 196 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_g_error_free0 (_data_->ie);
#line 2079 "tracker-resources.c"
		goto __finally13;
	}
	goto __finally13;
	__catch13_g_error:
	{
#line 190 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->e = _data_->_inner_error_;
#line 190 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_inner_error_ = NULL;
#line 198 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp6_ = _data_->e;
#line 198 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		tracker_dbus_request_end (_data_->request, _data_->_tmp6_);
#line 199 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp7_ = _data_->e;
#line 199 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		if (_data_->_tmp7_->domain == TRACKER_SPARQL_ERROR) {
#line 200 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_data_->_tmp8_ = _data_->e;
#line 200 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_data_->_tmp9_ = _g_error_copy0 (_data_->_tmp8_);
#line 200 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_data_->_inner_error_ = _data_->_tmp9_;
#line 200 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_g_error_free0 (_data_->e);
#line 2105 "tracker-resources.c"
			goto __finally13;
		} else {
#line 202 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_data_->_tmp10_ = _data_->e;
#line 202 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_data_->_tmp11_ = _data_->_tmp10_->message;
#line 202 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_data_->_tmp12_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_INTERNAL, _data_->_tmp11_);
#line 202 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_data_->_inner_error_ = _data_->_tmp12_;
#line 202 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_g_error_free0 (_data_->e);
#line 2118 "tracker-resources.c"
			goto __finally13;
		}
#line 190 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_g_error_free0 (_data_->e);
#line 2123 "tracker-resources.c"
	}
	__finally13:
#line 190 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 190 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 190 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		g_object_unref (_data_->_async_result);
#line 190 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		return FALSE;
#line 2134 "tracker-resources.c"
	}
#line 187 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 187 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	if (_data_->_state_ != 0) {
#line 187 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		while (g_task_get_completed (_data_->_async_result) != TRUE) {
#line 187 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 2144 "tracker-resources.c"
		}
	}
#line 187 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	g_object_unref (_data_->_async_result);
#line 187 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	return FALSE;
#line 2151 "tracker-resources.c"
}


void
tracker_resources_batch_commit (TrackerResources* self)
{
#line 207 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	g_return_if_fail (self != NULL);
#line 2160 "tracker-resources.c"
}


static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
#line 212 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	g_atomic_int_inc (&_data4_->_ref_count_);
#line 212 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	return _data4_;
#line 2171 "tracker-resources.c"
}


static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
#line 212 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
#line 2182 "tracker-resources.c"
		TrackerResources* self;
#line 212 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		self = _data4_->self;
#line 212 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_g_variant_builder_unref0 (_data4_->builder);
#line 212 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_g_object_unref0 (self);
#line 212 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		g_slice_free (Block4Data, _data4_);
#line 2192 "tracker-resources.c"
	}
}


static void
___lambda9_ (Block4Data* _data4_,
             gint graph_id,
             gint subject_id,
             gint pred_id,
             gint object_id)
{
	TrackerResources* self;
	GVariantBuilder* _tmp0_;
#line 214 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	self = _data4_->self;
#line 215 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp0_ = _data4_->builder;
#line 215 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	g_variant_builder_add (_tmp0_, "(iiii)", graph_id, subject_id, pred_id, object_id, NULL);
#line 2212 "tracker-resources.c"
}


static void
____lambda9__tracker_events_foreach (gint graph_id,
                                     gint subject_id,
                                     gint pred_id,
                                     gint object_id,
                                     gpointer self)
{
#line 214 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	___lambda9_ (self, graph_id, subject_id, pred_id, object_id);
#line 2225 "tracker-resources.c"
}


static void
___lambda10_ (Block4Data* _data4_,
              gint graph_id,
              gint subject_id,
              gint pred_id,
              gint object_id)
{
	TrackerResources* self;
	GVariantBuilder* _tmp0_;
#line 220 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	self = _data4_->self;
#line 221 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp0_ = _data4_->builder;
#line 221 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	g_variant_builder_add (_tmp0_, "(iiii)", graph_id, subject_id, pred_id, object_id, NULL);
#line 2244 "tracker-resources.c"
}


static void
____lambda10__tracker_events_foreach (gint graph_id,
                                      gint subject_id,
                                      gint pred_id,
                                      gint object_id,
                                      gpointer self)
{
#line 220 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	___lambda10_ (self, graph_id, subject_id, pred_id, object_id);
#line 2257 "tracker-resources.c"
}


static gboolean
tracker_resources_emit_graph_updated (TrackerResources* self,
                                      TrackerClass* cl)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 211 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 211 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	g_return_val_if_fail (cl != NULL, FALSE);
#line 212 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	if (tracker_class_has_insert_events (cl)) {
#line 212 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_tmp0_ = TRUE;
#line 2275 "tracker-resources.c"
	} else {
#line 212 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_tmp0_ = tracker_class_has_delete_events (cl);
#line 2279 "tracker-resources.c"
	}
#line 212 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	if (_tmp0_) {
#line 2283 "tracker-resources.c"
		Block4Data* _data4_;
		GVariantBuilder* _tmp1_;
		GVariant* deletes = NULL;
		GVariantBuilder* _tmp2_;
		GVariant* _tmp3_;
		GVariantBuilder* _tmp4_;
		GVariant* inserts = NULL;
		GVariantBuilder* _tmp5_;
		GVariant* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		GVariant* _tmp9_;
		GVariant* _tmp10_;
#line 212 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data4_ = g_slice_new0 (Block4Data);
#line 212 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data4_->_ref_count_ = 1;
#line 212 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data4_->self = g_object_ref (self);
#line 213 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_tmp1_ = g_variant_builder_new ((const GVariantType*) "a(iiii)");
#line 213 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data4_->builder = _tmp1_;
#line 214 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		tracker_class_foreach_delete_event (cl, ____lambda9__tracker_events_foreach, _data4_);
#line 217 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_tmp2_ = _data4_->builder;
#line 217 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_tmp3_ = g_variant_builder_end (_tmp2_);
#line 217 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		g_variant_ref_sink (_tmp3_);
#line 217 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		deletes = _tmp3_;
#line 219 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_tmp4_ = g_variant_builder_new ((const GVariantType*) "a(iiii)");
#line 219 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_g_variant_builder_unref0 (_data4_->builder);
#line 219 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data4_->builder = _tmp4_;
#line 220 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		tracker_class_foreach_insert_event (cl, ____lambda10__tracker_events_foreach, _data4_);
#line 223 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_tmp5_ = _data4_->builder;
#line 223 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_tmp6_ = g_variant_builder_end (_tmp5_);
#line 223 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		g_variant_ref_sink (_tmp6_);
#line 223 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		inserts = _tmp6_;
#line 225 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_tmp7_ = tracker_class_get_uri (cl);
#line 225 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_tmp8_ = _tmp7_;
#line 225 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_tmp9_ = deletes;
#line 225 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_tmp10_ = inserts;
#line 225 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		g_signal_emit (self, tracker_resources_signals[TRACKER_RESOURCES_GRAPH_UPDATED_SIGNAL], 0, _tmp8_, _tmp9_, _tmp10_);
#line 227 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		tracker_class_reset_ready_events (cl);
#line 229 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		result = TRUE;
#line 229 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_g_variant_unref0 (inserts);
#line 229 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_g_variant_unref0 (deletes);
#line 229 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		block4_data_unref (_data4_);
#line 229 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data4_ = NULL;
#line 229 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		return result;
#line 2357 "tracker-resources.c"
	}
#line 231 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	result = FALSE;
#line 231 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	return result;
#line 2363 "tracker-resources.c"
}


static gpointer
_g_hash_table_ref0 (gpointer self)
{
#line 243 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	return self ? g_hash_table_ref (self) : NULL;
#line 2372 "tracker-resources.c"
}


static gboolean
tracker_resources_on_emit_signals (TrackerResources* self)
{
	gboolean result = FALSE;
	gint _tmp0_;
	TrackerClass** _tmp1_;
	GHashTable* writebacks = NULL;
	GHashTable* _tmp4_;
	GHashTable* _tmp5_;
	GHashTable* _tmp6_;
#line 234 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 235 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp1_ = tracker_events_get_classes (&_tmp0_);
#line 2390 "tracker-resources.c"
	{
		TrackerClass** cl_collection = NULL;
		gint cl_collection_length1 = 0;
		gint _cl_collection_size_ = 0;
		gint cl_it = 0;
#line 235 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		cl_collection = _tmp1_;
#line 235 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		cl_collection_length1 = _tmp0_;
#line 235 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		for (cl_it = 0; cl_it < _tmp0_; cl_it = cl_it + 1) {
#line 2402 "tracker-resources.c"
			TrackerClass* _tmp2_;
			TrackerClass* cl = NULL;
#line 235 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_tmp2_ = _g_object_ref0 (cl_collection[cl_it]);
#line 235 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
			cl = _tmp2_;
#line 2409 "tracker-resources.c"
			{
				TrackerClass* _tmp3_;
#line 236 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
				_tmp3_ = cl;
#line 236 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
				tracker_resources_emit_graph_updated (self, _tmp3_);
#line 235 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
				_g_object_unref0 (cl);
#line 2418 "tracker-resources.c"
			}
		}
	}
#line 240 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	tracker_events_get_total (TRUE);
#line 243 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp4_ = tracker_writeback_get_ready ();
#line 243 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp5_ = _g_hash_table_ref0 (_tmp4_);
#line 243 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	writebacks = _tmp5_;
#line 245 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp6_ = writebacks;
#line 245 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	if (_tmp6_ != NULL) {
#line 2434 "tracker-resources.c"
		GVariantBuilder* builder = NULL;
		GVariantBuilder* _tmp7_;
		GHashTableIter wb_iter = {0};
		GHashTable* _tmp8_;
		gint subject_id = 0;
		GArray* types = NULL;
		GVariantBuilder* _tmp26_;
		GVariant* _tmp27_;
		GVariant* _tmp28_;
#line 246 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_tmp7_ = g_variant_builder_new ((const GVariantType*) "a{iai}");
#line 246 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		builder = _tmp7_;
#line 248 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_tmp8_ = writebacks;
#line 248 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		g_hash_table_iter_init (&wb_iter, _tmp8_);
#line 252 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		while (TRUE) {
#line 2454 "tracker-resources.c"
			gconstpointer _tmp9_ = NULL;
			gconstpointer _tmp10_ = NULL;
			gboolean _tmp11_;
			GVariantBuilder* _tmp12_;
			GVariantBuilder* _tmp13_;
			gint _tmp14_;
			GVariantBuilder* _tmp15_;
			GVariantBuilder* _tmp24_;
			GVariantBuilder* _tmp25_;
#line 252 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_tmp11_ = g_hash_table_iter_next (&wb_iter, (gpointer*) (&_tmp9_), (gpointer*) (&_tmp10_));
#line 252 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
			subject_id = _tmp9_;
#line 252 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
			types = _tmp10_;
#line 252 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
			if (!_tmp11_) {
#line 252 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
				break;
#line 2474 "tracker-resources.c"
			}
#line 253 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_tmp12_ = builder;
#line 253 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
			g_variant_builder_open (_tmp12_, (const GVariantType*) "{iai}");
#line 255 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_tmp13_ = builder;
#line 255 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_tmp14_ = subject_id;
#line 255 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
			g_variant_builder_add (_tmp13_, "i", _tmp14_, NULL);
#line 257 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_tmp15_ = builder;
#line 257 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
			g_variant_builder_open (_tmp15_, (const GVariantType*) "ai");
#line 2490 "tracker-resources.c"
			{
				gint i = 0;
#line 258 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
				i = 0;
#line 2495 "tracker-resources.c"
				{
					gboolean _tmp16_ = FALSE;
#line 258 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
					_tmp16_ = TRUE;
#line 258 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
					while (TRUE) {
#line 2502 "tracker-resources.c"
						gint _tmp18_;
						GArray* _tmp19_;
						guint _tmp20_;
						GVariantBuilder* _tmp21_;
						GArray* _tmp22_;
						gint _tmp23_;
#line 258 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
						if (!_tmp16_) {
#line 2511 "tracker-resources.c"
							gint _tmp17_;
#line 258 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
							_tmp17_ = i;
#line 258 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
							i = _tmp17_ + 1;
#line 2517 "tracker-resources.c"
						}
#line 258 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
						_tmp16_ = FALSE;
#line 258 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
						_tmp18_ = i;
#line 258 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
						_tmp19_ = types;
#line 258 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
						_tmp20_ = _tmp19_->len;
#line 258 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
						if (!(((guint) _tmp18_) < _tmp20_)) {
#line 258 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
							break;
#line 2531 "tracker-resources.c"
						}
#line 259 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
						_tmp21_ = builder;
#line 259 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
						_tmp22_ = types;
#line 259 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
						_tmp23_ = i;
#line 259 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
						g_variant_builder_add (_tmp21_, "i", g_array_index (_tmp22_, gint, (guint) _tmp23_), NULL);
#line 2541 "tracker-resources.c"
					}
				}
			}
#line 261 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_tmp24_ = builder;
#line 261 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
			g_variant_builder_close (_tmp24_);
#line 263 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_tmp25_ = builder;
#line 263 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
			g_variant_builder_close (_tmp25_);
#line 2553 "tracker-resources.c"
		}
#line 266 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_tmp26_ = builder;
#line 266 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_tmp27_ = g_variant_builder_end (_tmp26_);
#line 266 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		g_variant_ref_sink (_tmp27_);
#line 266 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_tmp28_ = _tmp27_;
#line 266 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		g_signal_emit (self, tracker_resources_signals[TRACKER_RESOURCES_WRITEBACK_SIGNAL], 0, _tmp28_);
#line 266 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_g_variant_unref0 (_tmp28_);
#line 245 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_g_variant_builder_unref0 (builder);
#line 2569 "tracker-resources.c"
	}
#line 269 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	tracker_writeback_reset_ready ();
#line 271 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	self->priv->regular_commit_pending = FALSE;
#line 272 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	self->priv->signal_timeout = (guint) 0;
#line 273 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	result = FALSE;
#line 273 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_g_hash_table_unref0 (writebacks);
#line 273 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	return result;
#line 2583 "tracker-resources.c"
}


static gboolean
_tracker_resources_on_emit_signals_gsource_func (gpointer self)
{
	gboolean result;
	result = tracker_resources_on_emit_signals ((TrackerResources*) self);
#line 305 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	return result;
#line 2594 "tracker-resources.c"
}


static void
tracker_resources_on_statements_committed (TrackerResources* self,
                                           TrackerDataCommitType commit_type)
{
	gint _tmp0_;
	TrackerClass** _tmp1_;
	gboolean _tmp4_;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_;
#line 276 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	g_return_if_fail (self != NULL);
#line 279 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp1_ = tracker_events_get_classes (&_tmp0_);
#line 2611 "tracker-resources.c"
	{
		TrackerClass** cl_collection = NULL;
		gint cl_collection_length1 = 0;
		gint _cl_collection_size_ = 0;
		gint cl_it = 0;
#line 279 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		cl_collection = _tmp1_;
#line 279 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		cl_collection_length1 = _tmp0_;
#line 279 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		for (cl_it = 0; cl_it < _tmp0_; cl_it = cl_it + 1) {
#line 2623 "tracker-resources.c"
			TrackerClass* _tmp2_;
			TrackerClass* cl = NULL;
#line 279 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_tmp2_ = _g_object_ref0 (cl_collection[cl_it]);
#line 279 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
			cl = _tmp2_;
#line 2630 "tracker-resources.c"
			{
				TrackerClass* _tmp3_;
#line 280 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
				_tmp3_ = cl;
#line 280 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
				tracker_class_transact_events (_tmp3_);
#line 279 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
				_g_object_unref0 (cl);
#line 2639 "tracker-resources.c"
			}
		}
	}
#line 283 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp4_ = self->priv->regular_commit_pending;
#line 283 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	if (!_tmp4_) {
#line 2647 "tracker-resources.c"
		guint _tmp5_;
#line 292 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_tmp5_ = self->priv->signal_timeout;
#line 292 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		if (_tmp5_ != ((guint) 0)) {
#line 2653 "tracker-resources.c"
			guint _tmp6_;
#line 293 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_tmp6_ = self->priv->signal_timeout;
#line 293 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
			g_source_remove (_tmp6_);
#line 294 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
			self->priv->signal_timeout = (guint) 0;
#line 2661 "tracker-resources.c"
		}
	}
#line 298 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	if (commit_type == TRACKER_DATA_COMMIT_REGULAR) {
#line 299 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		self->priv->regular_commit_pending = TRUE;
#line 2668 "tracker-resources.c"
	}
#line 302 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp8_ = self->priv->regular_commit_pending;
#line 302 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	if (_tmp8_) {
#line 302 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_tmp7_ = TRUE;
#line 2676 "tracker-resources.c"
	} else {
#line 302 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_tmp7_ = commit_type == TRACKER_DATA_COMMIT_BATCH_LAST;
#line 2680 "tracker-resources.c"
	}
#line 302 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	if (_tmp7_) {
#line 2684 "tracker-resources.c"
		guint _tmp9_;
#line 304 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_tmp9_ = self->priv->signal_timeout;
#line 304 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		if (_tmp9_ == ((guint) 0)) {
#line 2690 "tracker-resources.c"
			TrackerConfig* _tmp10_;
			gint _tmp11_;
			gint _tmp12_;
#line 305 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_tmp10_ = self->priv->config;
#line 305 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_tmp11_ = tracker_config_get_graphupdated_delay (_tmp10_);
#line 305 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_tmp12_ = _tmp11_;
#line 305 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
			self->priv->signal_timeout = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) _tmp12_, _tracker_resources_on_emit_signals_gsource_func, g_object_ref (self), g_object_unref);
#line 2702 "tracker-resources.c"
		}
	}
#line 310 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	tracker_writeback_transact ();
#line 2707 "tracker-resources.c"
}


static void
tracker_resources_on_statements_rolled_back (TrackerResources* self,
                                             TrackerDataCommitType commit_type)
{
#line 313 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	g_return_if_fail (self != NULL);
#line 314 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	tracker_events_reset_pending ();
#line 315 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	tracker_writeback_reset_pending ();
#line 2721 "tracker-resources.c"
}


static void
tracker_resources_check_graph_updated_signal (TrackerResources* self)
{
#line 318 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	g_return_if_fail (self != NULL);
#line 320 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	if (tracker_events_get_total (FALSE) > ((guint) TRACKER_RESOURCES_GRAPH_UPDATED_IMMEDIATE_EMIT_AT)) {
#line 2732 "tracker-resources.c"
		guint _tmp0_;
#line 324 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_tmp0_ = self->priv->signal_timeout;
#line 324 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		if (_tmp0_ != ((guint) 0)) {
#line 2738 "tracker-resources.c"
			guint _tmp1_;
#line 325 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_tmp1_ = self->priv->signal_timeout;
#line 325 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
			g_source_remove (_tmp1_);
#line 326 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
			self->priv->signal_timeout = (guint) 0;
#line 2746 "tracker-resources.c"
		}
#line 330 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		tracker_resources_on_emit_signals (self);
#line 2750 "tracker-resources.c"
	}
}


static void
tracker_resources_on_statement_inserted (TrackerResources* self,
                                         gint graph_id,
                                         const gchar* graph,
                                         gint subject_id,
                                         const gchar* subject,
                                         gint pred_id,
                                         gint object_id,
                                         const gchar* object,
                                         GPtrArray* rdf_types)
{
#line 334 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	g_return_if_fail (self != NULL);
#line 334 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	g_return_if_fail (subject != NULL);
#line 334 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	g_return_if_fail (rdf_types != NULL);
#line 335 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	tracker_events_add_insert (graph_id, subject_id, subject, pred_id, object_id, object, rdf_types);
#line 336 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	tracker_writeback_check (graph_id, graph, subject_id, subject, pred_id, object_id, object, rdf_types);
#line 337 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	tracker_resources_check_graph_updated_signal (self);
#line 2778 "tracker-resources.c"
}


static void
tracker_resources_on_statement_deleted (TrackerResources* self,
                                        gint graph_id,
                                        const gchar* graph,
                                        gint subject_id,
                                        const gchar* subject,
                                        gint pred_id,
                                        gint object_id,
                                        const gchar* object,
                                        GPtrArray* rdf_types)
{
#line 340 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	g_return_if_fail (self != NULL);
#line 340 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	g_return_if_fail (subject != NULL);
#line 340 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	g_return_if_fail (rdf_types != NULL);
#line 341 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	tracker_events_add_delete (graph_id, subject_id, subject, pred_id, object_id, object, rdf_types);
#line 342 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	tracker_writeback_check (graph_id, graph, subject_id, subject, pred_id, object_id, object, rdf_types);
#line 343 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	tracker_resources_check_graph_updated_signal (self);
#line 2805 "tracker-resources.c"
}


static void
_tracker_resources_on_statement_inserted_tracker_statement_callback (gint graph_id,
                                                                     const gchar* graph,
                                                                     gint subject_id,
                                                                     const gchar* subject,
                                                                     gint predicate_id,
                                                                     gint object_id,
                                                                     const gchar* object,
                                                                     GPtrArray* rdf_types,
                                                                     gpointer self)
{
#line 350 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	tracker_resources_on_statement_inserted ((TrackerResources*) self, graph_id, graph, subject_id, subject, predicate_id, object_id, object, rdf_types);
#line 2822 "tracker-resources.c"
}


static void
_tracker_resources_on_statement_deleted_tracker_statement_callback (gint graph_id,
                                                                    const gchar* graph,
                                                                    gint subject_id,
                                                                    const gchar* subject,
                                                                    gint predicate_id,
                                                                    gint object_id,
                                                                    const gchar* object,
                                                                    GPtrArray* rdf_types,
                                                                    gpointer self)
{
#line 351 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	tracker_resources_on_statement_deleted ((TrackerResources*) self, graph_id, graph, subject_id, subject, predicate_id, object_id, object, rdf_types);
#line 2839 "tracker-resources.c"
}


static void
_tracker_resources_on_statements_committed_tracker_commit_callback (TrackerDataCommitType commit_type,
                                                                    gpointer self)
{
#line 352 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	tracker_resources_on_statements_committed ((TrackerResources*) self, commit_type);
#line 2849 "tracker-resources.c"
}


static void
_tracker_resources_on_statements_rolled_back_tracker_commit_callback (TrackerDataCommitType commit_type,
                                                                      gpointer self)
{
#line 353 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	tracker_resources_on_statements_rolled_back ((TrackerResources*) self, commit_type);
#line 2859 "tracker-resources.c"
}


void
tracker_resources_enable_signals (TrackerResources* self)
{
	TrackerDataManager* data_manager = NULL;
	TrackerDataManager* _tmp0_;
	TrackerDataManager* _tmp1_;
	TrackerData* data = NULL;
	TrackerData* _tmp2_;
	TrackerData* _tmp3_;
#line 347 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	g_return_if_fail (self != NULL);
#line 348 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp0_ = tracker_main_get_data_manager ();
#line 348 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 348 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	data_manager = _tmp1_;
#line 349 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp2_ = tracker_data_manager_get_data (data_manager);
#line 349 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 349 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	data = _tmp3_;
#line 350 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	tracker_data_add_insert_statement_callback (data, _tracker_resources_on_statement_inserted_tracker_statement_callback, self);
#line 351 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	tracker_data_add_delete_statement_callback (data, _tracker_resources_on_statement_deleted_tracker_statement_callback, self);
#line 352 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	tracker_data_add_commit_statement_callback (data, _tracker_resources_on_statements_committed_tracker_commit_callback, self);
#line 353 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	tracker_data_add_rollback_statement_callback (data, _tracker_resources_on_statements_rolled_back_tracker_commit_callback, self);
#line 347 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_g_object_unref0 (data);
#line 347 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_g_object_unref0 (data_manager);
#line 2898 "tracker-resources.c"
}


void
tracker_resources_disable_signals (TrackerResources* self)
{
	TrackerDataManager* data_manager = NULL;
	TrackerDataManager* _tmp0_;
	TrackerDataManager* _tmp1_;
	TrackerData* data = NULL;
	TrackerDataManager* _tmp2_;
	TrackerData* _tmp3_;
	TrackerData* _tmp4_;
	TrackerData* _tmp5_;
	TrackerData* _tmp6_;
	TrackerData* _tmp7_;
	TrackerData* _tmp8_;
	guint _tmp9_;
#line 357 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	g_return_if_fail (self != NULL);
#line 358 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp0_ = tracker_main_get_data_manager ();
#line 358 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 358 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	data_manager = _tmp1_;
#line 359 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp2_ = data_manager;
#line 359 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp3_ = tracker_data_manager_get_data (_tmp2_);
#line 359 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 359 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	data = _tmp4_;
#line 360 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp5_ = data;
#line 360 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	tracker_data_remove_insert_statement_callback (_tmp5_, _tracker_resources_on_statement_inserted_tracker_statement_callback, self);
#line 361 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp6_ = data;
#line 361 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	tracker_data_remove_delete_statement_callback (_tmp6_, _tracker_resources_on_statement_deleted_tracker_statement_callback, self);
#line 362 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp7_ = data;
#line 362 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	tracker_data_remove_commit_statement_callback (_tmp7_, _tracker_resources_on_statements_committed_tracker_commit_callback, self);
#line 363 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp8_ = data;
#line 363 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	tracker_data_remove_rollback_statement_callback (_tmp8_, _tracker_resources_on_statements_rolled_back_tracker_commit_callback, self);
#line 365 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp9_ = self->priv->signal_timeout;
#line 365 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	if (_tmp9_ != ((guint) 0)) {
#line 2953 "tracker-resources.c"
		guint _tmp10_;
#line 366 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_tmp10_ = self->priv->signal_timeout;
#line 366 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		g_source_remove (_tmp10_);
#line 367 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		self->priv->signal_timeout = (guint) 0;
#line 2961 "tracker-resources.c"
	}
#line 357 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_g_object_unref0 (data);
#line 357 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_g_object_unref0 (data_manager);
#line 2967 "tracker-resources.c"
}


void
tracker_resources_unreg_batches (TrackerResources* self,
                                 const gchar* old_owner)
{
#line 376 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	g_return_if_fail (self != NULL);
#line 376 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	g_return_if_fail (old_owner != NULL);
#line 377 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	tracker_store_unreg_batches (old_owner);
#line 2981 "tracker-resources.c"
}


static void
g_cclosure_user_marshal_VOID__STRING_VARIANT_VARIANT (GClosure * closure,
                                                      GValue * return_value,
                                                      guint n_param_values,
                                                      const GValue * param_values,
                                                      gpointer invocation_hint,
                                                      gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__STRING_VARIANT_VARIANT) (gpointer data1, const char* arg_1, gpointer arg_2, gpointer arg_3, gpointer data2);
	register GMarshalFunc_VOID__STRING_VARIANT_VARIANT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	g_return_if_fail (n_param_values == 4);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		data1 = closure->data;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		data2 = param_values->data[0].v_pointer;
#line 3007 "tracker-resources.c"
	} else {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		data1 = param_values->data[0].v_pointer;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
		data2 = closure->data;
#line 3013 "tracker-resources.c"
	}
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	callback = (GMarshalFunc_VOID__STRING_VARIANT_VARIANT) (marshal_data ? marshal_data : cc->callback);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	callback (data1, g_value_get_string (param_values + 1), g_value_get_variant (param_values + 2), g_value_get_variant (param_values + 3), data2);
#line 3019 "tracker-resources.c"
}


static void
tracker_resources_class_init (TrackerResourcesClass * klass)
{
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	tracker_resources_parent_class = g_type_class_peek_parent (klass);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	g_type_class_add_private (klass, sizeof (TrackerResourcesPrivate));
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	G_OBJECT_CLASS (klass)->finalize = tracker_resources_finalize;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	tracker_resources_signals[TRACKER_RESOURCES_WRITEBACK_SIGNAL] = g_signal_new ("writeback", TRACKER_TYPE_RESOURCES, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VARIANT, G_TYPE_NONE, 1, G_TYPE_VARIANT);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	tracker_resources_signals[TRACKER_RESOURCES_GRAPH_UPDATED_SIGNAL] = g_signal_new ("graph-updated", TRACKER_TYPE_RESOURCES, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_VARIANT_VARIANT, G_TYPE_NONE, 3, G_TYPE_STRING, G_TYPE_VARIANT, G_TYPE_VARIANT);
#line 3036 "tracker-resources.c"
}


static void
tracker_resources_instance_init (TrackerResources * self)
{
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	self->priv = TRACKER_RESOURCES_GET_PRIVATE (self);
#line 3045 "tracker-resources.c"
}


static void
tracker_resources_finalize (GObject * obj)
{
	TrackerResources * self;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_TYPE_RESOURCES, TrackerResources);
#line 372 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	tracker_resources_disable_signals (self);
#line 52 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_g_object_unref0 (self->priv->connection);
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_g_object_unref0 (self->priv->config);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-resources.vala"
	G_OBJECT_CLASS (tracker_resources_parent_class)->finalize (obj);
#line 3063 "tracker-resources.c"
}


GType
tracker_resources_get_type (void)
{
	static volatile gsize tracker_resources_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_resources_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerResourcesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_resources_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerResources), 0, (GInstanceInitFunc) tracker_resources_instance_init, NULL };
		GType tracker_resources_type_id;
		tracker_resources_type_id = g_type_register_static (G_TYPE_OBJECT, "TrackerResources", &g_define_type_info, 0);
		g_type_set_qdata (tracker_resources_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) tracker_resources_register_object);
		g_once_init_leave (&tracker_resources_type_id__volatile, tracker_resources_type_id);
	}
	return tracker_resources_type_id__volatile;
}


static void
_dbus_tracker_resources_load (TrackerResources* self,
                              GVariant* _parameters_,
                              GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	gchar* uri = NULL;
	GVariant* _tmp2_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp2_ = g_variant_iter_next_value (&_arguments_iter);
	uri = g_variant_dup_string (_tmp2_, NULL);
	g_variant_unref (_tmp2_);
	tracker_resources_load (self, g_dbus_method_invocation_get_sender (invocation), uri, (GAsyncReadyCallback) _dbus_tracker_resources_load_ready, invocation);
	_g_free0 (uri);
}


static void
_dbus_tracker_resources_load_ready (GObject * source_object,
                                    GAsyncResult * _res_,
                                    gpointer _user_data_)
{
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	invocation = _user_data_;
	tracker_resources_load_finish ((TrackerResources*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void
_dbus_tracker_resources_sparql_query (TrackerResources* self,
                                      GVariant* _parameters_,
                                      GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	gchar* query = NULL;
	GVariant* _tmp3_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp3_ = g_variant_iter_next_value (&_arguments_iter);
	query = g_variant_dup_string (_tmp3_, NULL);
	g_variant_unref (_tmp3_);
	tracker_resources_sparql_query (self, g_dbus_method_invocation_get_sender (invocation), query, (GAsyncReadyCallback) _dbus_tracker_resources_sparql_query_ready, invocation);
	_g_free0 (query);
}


static void
_dbus_tracker_resources_sparql_query_ready (GObject * source_object,
                                            GAsyncResult * _res_,
                                            gpointer _user_data_)
{
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	GVariant* result;
	invocation = _user_data_;
	result = tracker_resources_sparql_query_finish ((TrackerResources*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, result);
	_g_variant_unref0 (result);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void
_dbus_tracker_resources_sparql_update (TrackerResources* self,
                                       GVariant* _parameters_,
                                       GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	gchar* update = NULL;
	GVariant* _tmp4_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp4_ = g_variant_iter_next_value (&_arguments_iter);
	update = g_variant_dup_string (_tmp4_, NULL);
	g_variant_unref (_tmp4_);
	tracker_resources_sparql_update (self, g_dbus_method_invocation_get_sender (invocation), update, (GAsyncReadyCallback) _dbus_tracker_resources_sparql_update_ready, invocation);
	_g_free0 (update);
}


static void
_dbus_tracker_resources_sparql_update_ready (GObject * source_object,
                                             GAsyncResult * _res_,
                                             gpointer _user_data_)
{
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	invocation = _user_data_;
	tracker_resources_sparql_update_finish ((TrackerResources*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void
_dbus_tracker_resources_sparql_update_blank (TrackerResources* self,
                                             GVariant* _parameters_,
                                             GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	gchar* update = NULL;
	GVariant* _tmp5_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp5_ = g_variant_iter_next_value (&_arguments_iter);
	update = g_variant_dup_string (_tmp5_, NULL);
	g_variant_unref (_tmp5_);
	tracker_resources_sparql_update_blank (self, g_dbus_method_invocation_get_sender (invocation), update, (GAsyncReadyCallback) _dbus_tracker_resources_sparql_update_blank_ready, invocation);
	_g_free0 (update);
}


static void
_dbus_tracker_resources_sparql_update_blank_ready (GObject * source_object,
                                                   GAsyncResult * _res_,
                                                   gpointer _user_data_)
{
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	GVariant* result;
	invocation = _user_data_;
	result = tracker_resources_sparql_update_blank_finish ((TrackerResources*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, result);
	_g_variant_unref0 (result);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void
_dbus_tracker_resources_sync (TrackerResources* self,
                              GVariant* _parameters_,
                              GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	tracker_resources_sync (self, g_dbus_method_invocation_get_sender (invocation));
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void
_dbus_tracker_resources_batch_sparql_update (TrackerResources* self,
                                             GVariant* _parameters_,
                                             GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	gchar* update = NULL;
	GVariant* _tmp6_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp6_ = g_variant_iter_next_value (&_arguments_iter);
	update = g_variant_dup_string (_tmp6_, NULL);
	g_variant_unref (_tmp6_);
	tracker_resources_batch_sparql_update (self, g_dbus_method_invocation_get_sender (invocation), update, (GAsyncReadyCallback) _dbus_tracker_resources_batch_sparql_update_ready, invocation);
	_g_free0 (update);
}


static void
_dbus_tracker_resources_batch_sparql_update_ready (GObject * source_object,
                                                   GAsyncResult * _res_,
                                                   gpointer _user_data_)
{
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	invocation = _user_data_;
	tracker_resources_batch_sparql_update_finish ((TrackerResources*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void
_dbus_tracker_resources_batch_commit (TrackerResources* self,
                                      GVariant* _parameters_,
                                      GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	tracker_resources_batch_commit (self);
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void
tracker_resources_dbus_interface_method_call (GDBusConnection* connection,
                                              const gchar* sender,
                                              const gchar* object_path,
                                              const gchar* interface_name,
                                              const gchar* method_name,
                                              GVariant* parameters,
                                              GDBusMethodInvocation* invocation,
                                              gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "Load") == 0) {
		_dbus_tracker_resources_load (object, parameters, invocation);
	} else if (strcmp (method_name, "SparqlQuery") == 0) {
		_dbus_tracker_resources_sparql_query (object, parameters, invocation);
	} else if (strcmp (method_name, "SparqlUpdate") == 0) {
		_dbus_tracker_resources_sparql_update (object, parameters, invocation);
	} else if (strcmp (method_name, "SparqlUpdateBlank") == 0) {
		_dbus_tracker_resources_sparql_update_blank (object, parameters, invocation);
	} else if (strcmp (method_name, "Sync") == 0) {
		_dbus_tracker_resources_sync (object, parameters, invocation);
	} else if (strcmp (method_name, "BatchSparqlUpdate") == 0) {
		_dbus_tracker_resources_batch_sparql_update (object, parameters, invocation);
	} else if (strcmp (method_name, "BatchCommit") == 0) {
		_dbus_tracker_resources_batch_commit (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}


static GVariant*
tracker_resources_dbus_interface_get_property (GDBusConnection* connection,
                                               const gchar* sender,
                                               const gchar* object_path,
                                               const gchar* interface_name,
                                               const gchar* property_name,
                                               GError** error,
                                               gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}


static gboolean
tracker_resources_dbus_interface_set_property (GDBusConnection* connection,
                                               const gchar* sender,
                                               const gchar* object_path,
                                               const gchar* interface_name,
                                               const gchar* property_name,
                                               GVariant* value,
                                               GError** error,
                                               gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


static void
_dbus_tracker_resources_writeback (GObject* _sender,
                                   GVariant* subjects,
                                   gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, subjects);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.freedesktop.Tracker1.Resources", "Writeback", _arguments, NULL);
}


static void
_dbus_tracker_resources_graph_updated (GObject* _sender,
                                       const gchar* classname,
                                       GVariant* deletes,
                                       GVariant* inserts,
                                       gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (classname));
	g_variant_builder_add_value (&_arguments_builder, deletes);
	g_variant_builder_add_value (&_arguments_builder, inserts);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.freedesktop.Tracker1.Resources", "GraphUpdated", _arguments, NULL);
}


guint
tracker_resources_register_object (gpointer object,
                                   GDBusConnection* connection,
                                   const gchar* path,
                                   GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_tracker_resources_dbus_interface_info), &_tracker_resources_dbus_interface_vtable, data, _tracker_resources_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "writeback", (GCallback) _dbus_tracker_resources_writeback, data);
	g_signal_connect (object, "graph-updated", (GCallback) _dbus_tracker_resources_graph_updated, data);
	return result;
}


static void
_tracker_resources_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_signal_handlers_disconnect_by_func (data[0], _dbus_tracker_resources_writeback, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_tracker_resources_graph_updated, data);
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}



