/* potential-match.c generated by valac 0.36.1.697-2b74, the Vala compiler
 * generated from potential-match.vala, do not modify */

/*
 * Copyright (C) 2011 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Raul Gutierrez Segales <raul.gutierrez.segales@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <folks/small-set.h>
#include <float.h>
#include <math.h>
#include <gio/gio.h>


#define FOLKS_TYPE_MATCH_RESULT (folks_match_result_get_type ())

#define FOLKS_TYPE_POTENTIAL_MATCH (folks_potential_match_get_type ())
#define FOLKS_POTENTIAL_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_POTENTIAL_MATCH, FolksPotentialMatch))
#define FOLKS_POTENTIAL_MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_POTENTIAL_MATCH, FolksPotentialMatchClass))
#define FOLKS_IS_POTENTIAL_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_POTENTIAL_MATCH))
#define FOLKS_IS_POTENTIAL_MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_POTENTIAL_MATCH))
#define FOLKS_POTENTIAL_MATCH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_POTENTIAL_MATCH, FolksPotentialMatchClass))

typedef struct _FolksPotentialMatch FolksPotentialMatch;
typedef struct _FolksPotentialMatchClass FolksPotentialMatchClass;
typedef struct _FolksPotentialMatchPrivate FolksPotentialMatchPrivate;

#define FOLKS_TYPE_INDIVIDUAL (folks_individual_get_type ())
#define FOLKS_INDIVIDUAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_INDIVIDUAL, FolksIndividual))
#define FOLKS_INDIVIDUAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_INDIVIDUAL, FolksIndividualClass))
#define FOLKS_IS_INDIVIDUAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_INDIVIDUAL))
#define FOLKS_IS_INDIVIDUAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_INDIVIDUAL))
#define FOLKS_INDIVIDUAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_INDIVIDUAL, FolksIndividualClass))

typedef struct _FolksIndividual FolksIndividual;
typedef struct _FolksIndividualClass FolksIndividualClass;
enum  {
	FOLKS_POTENTIAL_MATCH_DUMMY_PROPERTY,
	FOLKS_POTENTIAL_MATCH_LAST_PROPERTY
};
static GParamSpec* folks_potential_match_properties[FOLKS_POTENTIAL_MATCH_LAST_PROPERTY];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define FOLKS_TYPE_TRUST_LEVEL (folks_trust_level_get_type ())

#define FOLKS_TYPE_GENDER_DETAILS (folks_gender_details_get_type ())
#define FOLKS_GENDER_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_GENDER_DETAILS, FolksGenderDetails))
#define FOLKS_IS_GENDER_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_GENDER_DETAILS))
#define FOLKS_GENDER_DETAILS_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), FOLKS_TYPE_GENDER_DETAILS, FolksGenderDetailsIface))

typedef struct _FolksGenderDetails FolksGenderDetails;
typedef struct _FolksGenderDetailsIface FolksGenderDetailsIface;

#define FOLKS_TYPE_GENDER (folks_gender_get_type ())

#define FOLKS_TYPE_ABSTRACT_FIELD_DETAILS (folks_abstract_field_details_get_type ())
#define FOLKS_ABSTRACT_FIELD_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_ABSTRACT_FIELD_DETAILS, FolksAbstractFieldDetails))
#define FOLKS_ABSTRACT_FIELD_DETAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_ABSTRACT_FIELD_DETAILS, FolksAbstractFieldDetailsClass))
#define FOLKS_IS_ABSTRACT_FIELD_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_ABSTRACT_FIELD_DETAILS))
#define FOLKS_IS_ABSTRACT_FIELD_DETAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_ABSTRACT_FIELD_DETAILS))
#define FOLKS_ABSTRACT_FIELD_DETAILS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_ABSTRACT_FIELD_DETAILS, FolksAbstractFieldDetailsClass))

typedef struct _FolksAbstractFieldDetails FolksAbstractFieldDetails;
typedef struct _FolksAbstractFieldDetailsClass FolksAbstractFieldDetailsClass;

#define FOLKS_TYPE_PHONE_FIELD_DETAILS (folks_phone_field_details_get_type ())
#define FOLKS_PHONE_FIELD_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_PHONE_FIELD_DETAILS, FolksPhoneFieldDetails))
#define FOLKS_PHONE_FIELD_DETAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_PHONE_FIELD_DETAILS, FolksPhoneFieldDetailsClass))
#define FOLKS_IS_PHONE_FIELD_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_PHONE_FIELD_DETAILS))
#define FOLKS_IS_PHONE_FIELD_DETAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_PHONE_FIELD_DETAILS))
#define FOLKS_PHONE_FIELD_DETAILS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_PHONE_FIELD_DETAILS, FolksPhoneFieldDetailsClass))

typedef struct _FolksPhoneFieldDetails FolksPhoneFieldDetails;
typedef struct _FolksPhoneFieldDetailsClass FolksPhoneFieldDetailsClass;

#define FOLKS_TYPE_PHONE_DETAILS (folks_phone_details_get_type ())
#define FOLKS_PHONE_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_PHONE_DETAILS, FolksPhoneDetails))
#define FOLKS_IS_PHONE_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_PHONE_DETAILS))
#define FOLKS_PHONE_DETAILS_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), FOLKS_TYPE_PHONE_DETAILS, FolksPhoneDetailsIface))

typedef struct _FolksPhoneDetails FolksPhoneDetails;
typedef struct _FolksPhoneDetailsIface FolksPhoneDetailsIface;

#define FOLKS_TYPE_NAME_DETAILS (folks_name_details_get_type ())
#define FOLKS_NAME_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_NAME_DETAILS, FolksNameDetails))
#define FOLKS_IS_NAME_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_NAME_DETAILS))
#define FOLKS_NAME_DETAILS_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), FOLKS_TYPE_NAME_DETAILS, FolksNameDetailsIface))

typedef struct _FolksNameDetails FolksNameDetails;
typedef struct _FolksNameDetailsIface FolksNameDetailsIface;

#define FOLKS_TYPE_STRUCTURED_NAME (folks_structured_name_get_type ())
#define FOLKS_STRUCTURED_NAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_STRUCTURED_NAME, FolksStructuredName))
#define FOLKS_STRUCTURED_NAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_STRUCTURED_NAME, FolksStructuredNameClass))
#define FOLKS_IS_STRUCTURED_NAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_STRUCTURED_NAME))
#define FOLKS_IS_STRUCTURED_NAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_STRUCTURED_NAME))
#define FOLKS_STRUCTURED_NAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_STRUCTURED_NAME, FolksStructuredNameClass))

typedef struct _FolksStructuredName FolksStructuredName;
typedef struct _FolksStructuredNameClass FolksStructuredNameClass;

#define FOLKS_TYPE_ALIAS_DETAILS (folks_alias_details_get_type ())
#define FOLKS_ALIAS_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_ALIAS_DETAILS, FolksAliasDetails))
#define FOLKS_IS_ALIAS_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_ALIAS_DETAILS))
#define FOLKS_ALIAS_DETAILS_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), FOLKS_TYPE_ALIAS_DETAILS, FolksAliasDetailsIface))

typedef struct _FolksAliasDetails FolksAliasDetails;
typedef struct _FolksAliasDetailsIface FolksAliasDetailsIface;

#define FOLKS_TYPE_IM_FIELD_DETAILS (folks_im_field_details_get_type ())
#define FOLKS_IM_FIELD_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_IM_FIELD_DETAILS, FolksImFieldDetails))
#define FOLKS_IM_FIELD_DETAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_IM_FIELD_DETAILS, FolksImFieldDetailsClass))
#define FOLKS_IS_IM_FIELD_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_IM_FIELD_DETAILS))
#define FOLKS_IS_IM_FIELD_DETAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_IM_FIELD_DETAILS))
#define FOLKS_IM_FIELD_DETAILS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_IM_FIELD_DETAILS, FolksImFieldDetailsClass))

typedef struct _FolksImFieldDetails FolksImFieldDetails;
typedef struct _FolksImFieldDetailsClass FolksImFieldDetailsClass;

#define FOLKS_TYPE_IM_DETAILS (folks_im_details_get_type ())
#define FOLKS_IM_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_IM_DETAILS, FolksImDetails))
#define FOLKS_IS_IM_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_IM_DETAILS))
#define FOLKS_IM_DETAILS_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), FOLKS_TYPE_IM_DETAILS, FolksImDetailsIface))

typedef struct _FolksImDetails FolksImDetails;
typedef struct _FolksImDetailsIface FolksImDetailsIface;

#define FOLKS_TYPE_EMAIL_FIELD_DETAILS (folks_email_field_details_get_type ())
#define FOLKS_EMAIL_FIELD_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_EMAIL_FIELD_DETAILS, FolksEmailFieldDetails))
#define FOLKS_EMAIL_FIELD_DETAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_EMAIL_FIELD_DETAILS, FolksEmailFieldDetailsClass))
#define FOLKS_IS_EMAIL_FIELD_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_EMAIL_FIELD_DETAILS))
#define FOLKS_IS_EMAIL_FIELD_DETAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_EMAIL_FIELD_DETAILS))
#define FOLKS_EMAIL_FIELD_DETAILS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_EMAIL_FIELD_DETAILS, FolksEmailFieldDetailsClass))

typedef struct _FolksEmailFieldDetails FolksEmailFieldDetails;
typedef struct _FolksEmailFieldDetailsClass FolksEmailFieldDetailsClass;

#define FOLKS_TYPE_EMAIL_DETAILS (folks_email_details_get_type ())
#define FOLKS_EMAIL_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_EMAIL_DETAILS, FolksEmailDetails))
#define FOLKS_IS_EMAIL_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_EMAIL_DETAILS))
#define FOLKS_EMAIL_DETAILS_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), FOLKS_TYPE_EMAIL_DETAILS, FolksEmailDetailsIface))

typedef struct _FolksEmailDetails FolksEmailDetails;
typedef struct _FolksEmailDetailsIface FolksEmailDetailsIface;

typedef enum  {
	FOLKS_MATCH_RESULT_NONE = -1,
	FOLKS_MATCH_RESULT_VERY_LOW = 0,
	FOLKS_MATCH_RESULT_LOW = 1,
	FOLKS_MATCH_RESULT_MEDIUM = 2,
	FOLKS_MATCH_RESULT_HIGH = 3,
	FOLKS_MATCH_RESULT_VERY_HIGH = 4,
	FOLKS_MATCH_RESULT_MIN = FOLKS_MATCH_RESULT_NONE,
	FOLKS_MATCH_RESULT_MAX = FOLKS_MATCH_RESULT_VERY_HIGH
} FolksMatchResult;

struct _FolksPotentialMatch {
	GObject parent_instance;
	FolksPotentialMatchPrivate * priv;
};

struct _FolksPotentialMatchClass {
	GObjectClass parent_class;
};

struct _FolksPotentialMatchPrivate {
	FolksIndividual* _individual_a;
	FolksIndividual* _individual_b;
};

typedef enum  {
	FOLKS_TRUST_LEVEL_NONE,
	FOLKS_TRUST_LEVEL_PERSONAS
} FolksTrustLevel;

typedef enum  {
	FOLKS_GENDER_UNSPECIFIED,
	FOLKS_GENDER_MALE,
	FOLKS_GENDER_FEMALE
} FolksGender;

typedef enum  {
	FOLKS_PROPERTY_ERROR_NOT_WRITEABLE,
	FOLKS_PROPERTY_ERROR_INVALID_VALUE,
	FOLKS_PROPERTY_ERROR_UNKNOWN_ERROR,
	FOLKS_PROPERTY_ERROR_UNAVAILABLE
} FolksPropertyError;
#define FOLKS_PROPERTY_ERROR folks_property_error_quark ()
struct _FolksGenderDetailsIface {
	GTypeInterface parent_iface;
	void (*change_gender) (FolksGenderDetails* self, FolksGender gender, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*change_gender_finish) (FolksGenderDetails* self, GAsyncResult* _res_, GError** error);
	FolksGender (*get_gender) (FolksGenderDetails* self);
	void (*set_gender) (FolksGenderDetails* self, FolksGender value);
};

struct _FolksPhoneDetailsIface {
	GTypeInterface parent_iface;
	void (*change_phone_numbers) (FolksPhoneDetails* self, GeeSet* phone_numbers, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*change_phone_numbers_finish) (FolksPhoneDetails* self, GAsyncResult* _res_, GError** error);
	GeeSet* (*get_phone_numbers) (FolksPhoneDetails* self);
	void (*set_phone_numbers) (FolksPhoneDetails* self, GeeSet* value);
};

struct _FolksNameDetailsIface {
	GTypeInterface parent_iface;
	void (*change_structured_name) (FolksNameDetails* self, FolksStructuredName* name, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*change_structured_name_finish) (FolksNameDetails* self, GAsyncResult* _res_, GError** error);
	void (*change_full_name) (FolksNameDetails* self, const gchar* full_name, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*change_full_name_finish) (FolksNameDetails* self, GAsyncResult* _res_, GError** error);
	void (*change_nickname) (FolksNameDetails* self, const gchar* nickname, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*change_nickname_finish) (FolksNameDetails* self, GAsyncResult* _res_, GError** error);
	FolksStructuredName* (*get_structured_name) (FolksNameDetails* self);
	void (*set_structured_name) (FolksNameDetails* self, FolksStructuredName* value);
	const gchar* (*get_full_name) (FolksNameDetails* self);
	void (*set_full_name) (FolksNameDetails* self, const gchar* value);
	const gchar* (*get_nickname) (FolksNameDetails* self);
	void (*set_nickname) (FolksNameDetails* self, const gchar* value);
};

struct _FolksAliasDetailsIface {
	GTypeInterface parent_iface;
	void (*change_alias) (FolksAliasDetails* self, const gchar* alias, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*change_alias_finish) (FolksAliasDetails* self, GAsyncResult* _res_, GError** error);
	const gchar* (*get_alias) (FolksAliasDetails* self);
	void (*set_alias) (FolksAliasDetails* self, const gchar* value);
};

struct _FolksImDetailsIface {
	GTypeInterface parent_iface;
	void (*change_im_addresses) (FolksImDetails* self, GeeMultiMap* im_addresses, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*change_im_addresses_finish) (FolksImDetails* self, GAsyncResult* _res_, GError** error);
	GeeMultiMap* (*get_im_addresses) (FolksImDetails* self);
	void (*set_im_addresses) (FolksImDetails* self, GeeMultiMap* value);
};

struct _FolksEmailDetailsIface {
	GTypeInterface parent_iface;
	void (*change_email_addresses) (FolksEmailDetails* self, GeeSet* email_addresses, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*change_email_addresses_finish) (FolksEmailDetails* self, GAsyncResult* _res_, GError** error);
	GeeSet* (*get_email_addresses) (FolksEmailDetails* self);
	void (*set_email_addresses) (FolksEmailDetails* self, GeeSet* value);
};


static gpointer folks_potential_match_parent_class = NULL;
extern GeeSet* folks_potential_match_known_email_aliases;
GeeSet* folks_potential_match_known_email_aliases = NULL;
static gdouble folks_potential_match__DIST_THRESHOLD;
static gdouble folks_potential_match__DIST_THRESHOLD = 0.70;

GType folks_match_result_get_type (void) G_GNUC_CONST;
GType folks_potential_match_get_type (void) G_GNUC_CONST;
GType folks_individual_get_type (void) G_GNUC_CONST;
#define FOLKS_POTENTIAL_MATCH_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), FOLKS_TYPE_POTENTIAL_MATCH, FolksPotentialMatchPrivate))
#define FOLKS_POTENTIAL_MATCH__SEPARATORS "._-+"
FolksPotentialMatch* folks_potential_match_new (void);
FolksPotentialMatch* folks_potential_match_construct (GType object_type);
FolksMatchResult folks_potential_match_potential_match (FolksPotentialMatch* self, FolksIndividual* a, FolksIndividual* b);
GType folks_trust_level_get_type (void) G_GNUC_CONST;
FolksTrustLevel folks_individual_get_trust_level (FolksIndividual* self);
gboolean folks_individual_has_anti_link_with_individual (FolksIndividual* self, FolksIndividual* i);
GType folks_gender_get_type (void) G_GNUC_CONST;
GQuark folks_property_error_quark (void);
GType folks_gender_details_get_type (void) G_GNUC_CONST;
FolksGender folks_gender_details_get_gender (FolksGenderDetails* self);
static FolksMatchResult _folks_potential_match_inspect_im_addresses (FolksPotentialMatch* self, FolksMatchResult old_result);
static FolksMatchResult _folks_potential_match_inspect_emails (FolksPotentialMatch* self, FolksMatchResult old_result);
static FolksMatchResult _folks_potential_match_inspect_phone_numbers (FolksPotentialMatch* self, FolksMatchResult old_result);
static FolksMatchResult _folks_potential_match_name_similarity (FolksPotentialMatch* self, FolksMatchResult old_result);
GType folks_abstract_field_details_get_type (void) G_GNUC_CONST;
GType folks_phone_field_details_get_type (void) G_GNUC_CONST;
GType folks_phone_details_get_type (void) G_GNUC_CONST;
GeeSet* folks_phone_details_get_phone_numbers (FolksPhoneDetails* self);
gboolean folks_abstract_field_details_values_equal (FolksAbstractFieldDetails* self, FolksAbstractFieldDetails* that);
static gboolean _folks_potential_match_look_alike (FolksPotentialMatch* self, const gchar* a, const gchar* b);
GType folks_structured_name_get_type (void) G_GNUC_CONST;
GType folks_name_details_get_type (void) G_GNUC_CONST;
const gchar* folks_name_details_get_nickname (FolksNameDetails* self);
static gboolean _folks_potential_match_look_alike_or_identical (FolksPotentialMatch* self, const gchar* a, const gchar* b, gboolean* exact);
const gchar* folks_name_details_get_full_name (FolksNameDetails* self);
GType folks_alias_details_get_type (void) G_GNUC_CONST;
const gchar* folks_alias_details_get_alias (FolksAliasDetails* self);
FolksStructuredName* folks_name_details_get_structured_name (FolksNameDetails* self);
gboolean folks_structured_name_is_empty (FolksStructuredName* self);
gboolean folks_structured_name_equal (FolksStructuredName* self, FolksStructuredName* other);
gboolean _folks_utils_str_equal_safe (const gchar* a, const gchar* b);
const gchar* folks_structured_name_get_given_name (FolksStructuredName* self);
const gchar* folks_structured_name_get_family_name (FolksStructuredName* self);
const gchar* folks_structured_name_get_additional_names (FolksStructuredName* self);
const gchar* folks_structured_name_get_prefixes (FolksStructuredName* self);
const gchar* folks_structured_name_get_suffixes (FolksStructuredName* self);
static FolksMatchResult _folks_potential_match_inc_match_level (FolksPotentialMatch* self, FolksMatchResult current_level, gint times);
GType folks_im_field_details_get_type (void) G_GNUC_CONST;
GType folks_im_details_get_type (void) G_GNUC_CONST;
GeeMultiMap* folks_im_details_get_im_addresses (FolksImDetails* self);
gconstpointer folks_abstract_field_details_get_value (FolksAbstractFieldDetails* self);
GType folks_email_field_details_get_type (void) G_GNUC_CONST;
GType folks_email_details_get_type (void) G_GNUC_CONST;
GeeSet* folks_email_details_get_email_addresses (FolksEmailDetails* self);
static gboolean _folks_potential_match_check_initials_expansion (FolksPotentialMatch* self, gchar** tokens_a, int tokens_a_length1, gchar** tokens_b, int tokens_b_length1);
static gboolean _folks_potential_match_match_tokens (FolksPotentialMatch* self, gchar** tokens_a, int tokens_a_length1, gchar** tokens_b, int tokens_b_length1);
static gboolean _folks_potential_match_do_check_initials_expansion (FolksPotentialMatch* self, gchar** expanded_name, int expanded_name_length1, const gchar* initials);
static gboolean _folks_potential_match_do_match_tokens (FolksPotentialMatch* self, gchar** bigger_set, int bigger_set_length1, gchar** smaller_set, int smaller_set_length1);
static gunichar* _folks_potential_match_strip_string (FolksPotentialMatch* self, const gchar* s, int* result_length1);
static gdouble _folks_potential_match_jaro_dist (FolksPotentialMatch* self, gunichar* s1, int s1_length1, gunichar* s2, int s2_length1);
static gint _folks_potential_match_matches (FolksPotentialMatch* self, gunichar* s1, int s1_length1, gunichar* s2, int s2_length1, gint max_dist, gdouble* t);
static gunichar _folks_potential_match_stripped_char (FolksPotentialMatch* self, gunichar ch);
static gint _folks_potential_match_contains (FolksPotentialMatch* self, gunichar* haystack, int haystack_length1, gunichar c, guint pos, guint max_dist);
static void folks_potential_match_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


/**
 * Likely-ness of a potential match.
 *
 * Note that the order should be maintained.
 *
 * @since 0.5.0
 */
GType folks_match_result_get_type (void) {
	static volatile gsize folks_match_result_type_id__volatile = 0;
	if (g_once_init_enter (&folks_match_result_type_id__volatile)) {
		static const GEnumValue values[] = {{FOLKS_MATCH_RESULT_NONE, "FOLKS_MATCH_RESULT_NONE", "none"}, {FOLKS_MATCH_RESULT_VERY_LOW, "FOLKS_MATCH_RESULT_VERY_LOW", "very-low"}, {FOLKS_MATCH_RESULT_LOW, "FOLKS_MATCH_RESULT_LOW", "low"}, {FOLKS_MATCH_RESULT_MEDIUM, "FOLKS_MATCH_RESULT_MEDIUM", "medium"}, {FOLKS_MATCH_RESULT_HIGH, "FOLKS_MATCH_RESULT_HIGH", "high"}, {FOLKS_MATCH_RESULT_VERY_HIGH, "FOLKS_MATCH_RESULT_VERY_HIGH", "very-high"}, {FOLKS_MATCH_RESULT_MIN, "FOLKS_MATCH_RESULT_MIN", "min"}, {FOLKS_MATCH_RESULT_MAX, "FOLKS_MATCH_RESULT_MAX", "max"}, {0, NULL, NULL}};
		GType folks_match_result_type_id;
		folks_match_result_type_id = g_enum_register_static ("FolksMatchResult", values);
		g_once_init_leave (&folks_match_result_type_id__volatile, folks_match_result_type_id);
	}
	return folks_match_result_type_id__volatile;
}


/**
   * Create a new PotentialMatch.
   *
   * @return a new PotentialMatch
   *
   * @since 0.5.0
   */
FolksPotentialMatch* folks_potential_match_construct (GType object_type) {
	FolksPotentialMatch * self = NULL;
	self = (FolksPotentialMatch*) g_object_new (object_type, NULL);
	return self;
}


FolksPotentialMatch* folks_potential_match_new (void) {
	return folks_potential_match_construct (FOLKS_TYPE_POTENTIAL_MATCH);
}


/**
   * Whether two individuals are likely to be the same person.
   *
   * @param a an individual to compare
   * @param b another individual to compare
   *
   * @since 0.5.0
   */
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


FolksMatchResult folks_potential_match_potential_match (FolksPotentialMatch* self, FolksIndividual* a, FolksIndividual* b) {
	FolksMatchResult result = 0;
	FolksIndividual* _tmp0_;
	FolksIndividual* _tmp1_;
	FolksIndividual* _tmp2_;
	FolksIndividual* _tmp3_;
	FolksMatchResult _result_ = 0;
	gboolean _tmp4_ = FALSE;
	FolksIndividual* _tmp5_;
	FolksTrustLevel _tmp6_;
	FolksTrustLevel _tmp7_;
	FolksIndividual* _tmp11_;
	FolksIndividual* _tmp12_;
	gboolean _tmp13_;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_ = FALSE;
	FolksIndividual* _tmp16_;
	FolksGender _tmp17_;
	FolksGender _tmp18_;
	FolksMatchResult _tmp28_;
	FolksMatchResult _tmp29_;
	FolksMatchResult _tmp30_;
	FolksMatchResult _tmp31_;
	FolksMatchResult _tmp32_;
	FolksMatchResult _tmp33_;
	FolksMatchResult _tmp34_;
	FolksMatchResult _tmp35_;
	FolksMatchResult _tmp36_;
	FolksMatchResult _tmp37_;
	FolksMatchResult _tmp38_;
	FolksMatchResult _tmp39_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = a;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_individual_a);
	self->priv->_individual_a = _tmp1_;
	_tmp2_ = b;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (self->priv->_individual_b);
	self->priv->_individual_b = _tmp3_;
	_result_ = FOLKS_MATCH_RESULT_MIN;
	_tmp5_ = a;
	_tmp6_ = folks_individual_get_trust_level (_tmp5_);
	_tmp7_ = _tmp6_;
	if (_tmp7_ == FOLKS_TRUST_LEVEL_NONE) {
		_tmp4_ = TRUE;
	} else {
		FolksIndividual* _tmp8_;
		FolksTrustLevel _tmp9_;
		FolksTrustLevel _tmp10_;
		_tmp8_ = b;
		_tmp9_ = folks_individual_get_trust_level (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp4_ = _tmp10_ == FOLKS_TRUST_LEVEL_NONE;
	}
	if (_tmp4_) {
		result = _result_;
		return result;
	}
	_tmp11_ = a;
	_tmp12_ = b;
	_tmp13_ = folks_individual_has_anti_link_with_individual (_tmp11_, _tmp12_);
	if (_tmp13_) {
		result = _result_;
		return result;
	}
	_result_ = FOLKS_MATCH_RESULT_VERY_LOW;
	_tmp16_ = self->priv->_individual_a;
	_tmp17_ = folks_gender_details_get_gender ((FolksGenderDetails*) _tmp16_);
	_tmp18_ = _tmp17_;
	if (_tmp18_ != FOLKS_GENDER_UNSPECIFIED) {
		FolksIndividual* _tmp19_;
		FolksGender _tmp20_;
		FolksGender _tmp21_;
		_tmp19_ = self->priv->_individual_b;
		_tmp20_ = folks_gender_details_get_gender ((FolksGenderDetails*) _tmp19_);
		_tmp21_ = _tmp20_;
		_tmp15_ = _tmp21_ != FOLKS_GENDER_UNSPECIFIED;
	} else {
		_tmp15_ = FALSE;
	}
	if (_tmp15_) {
		FolksIndividual* _tmp22_;
		FolksGender _tmp23_;
		FolksGender _tmp24_;
		FolksIndividual* _tmp25_;
		FolksGender _tmp26_;
		FolksGender _tmp27_;
		_tmp22_ = self->priv->_individual_a;
		_tmp23_ = folks_gender_details_get_gender ((FolksGenderDetails*) _tmp22_);
		_tmp24_ = _tmp23_;
		_tmp25_ = self->priv->_individual_b;
		_tmp26_ = folks_gender_details_get_gender ((FolksGenderDetails*) _tmp25_);
		_tmp27_ = _tmp26_;
		_tmp14_ = _tmp24_ != _tmp27_;
	} else {
		_tmp14_ = FALSE;
	}
	if (_tmp14_) {
		result = _result_;
		return result;
	}
	_tmp28_ = _result_;
	_tmp29_ = _folks_potential_match_inspect_im_addresses (self, _tmp28_);
	_result_ = _tmp29_;
	_tmp30_ = _result_;
	if (_tmp30_ == FOLKS_MATCH_RESULT_MAX) {
		result = _result_;
		return result;
	}
	_tmp31_ = _result_;
	_tmp32_ = _folks_potential_match_inspect_emails (self, _tmp31_);
	_result_ = _tmp32_;
	_tmp33_ = _result_;
	if (_tmp33_ == FOLKS_MATCH_RESULT_MAX) {
		result = _result_;
		return result;
	}
	_tmp34_ = _result_;
	_tmp35_ = _folks_potential_match_inspect_phone_numbers (self, _tmp34_);
	_result_ = _tmp35_;
	_tmp36_ = _result_;
	if (_tmp36_ == FOLKS_MATCH_RESULT_MAX) {
		result = _result_;
		return result;
	}
	_tmp37_ = _result_;
	_tmp38_ = _folks_potential_match_name_similarity (self, _tmp37_);
	_result_ = _tmp38_;
	_tmp39_ = _result_;
	if (_tmp39_ == FOLKS_MATCH_RESULT_MAX) {
		result = _result_;
		return result;
	}
	result = _result_;
	return result;
}


static FolksMatchResult _folks_potential_match_inspect_phone_numbers (FolksPotentialMatch* self, FolksMatchResult old_result) {
	FolksMatchResult result = 0;
	GeeSet* set_a = NULL;
	FolksIndividual* _tmp0_;
	GeeSet* _tmp1_;
	GeeSet* _tmp2_;
	GeeSet* _tmp3_;
	GeeSet* set_b = NULL;
	FolksIndividual* _tmp4_;
	GeeSet* _tmp5_;
	GeeSet* _tmp6_;
	GeeSet* _tmp7_;
	FolksMatchResult _tmp23_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_individual_a;
	_tmp1_ = folks_phone_details_get_phone_numbers ((FolksPhoneDetails*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	set_a = _tmp3_;
	_tmp4_ = self->priv->_individual_b;
	_tmp5_ = folks_phone_details_get_phone_numbers ((FolksPhoneDetails*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = _g_object_ref0 (_tmp6_);
	set_b = _tmp7_;
	{
		GeeIterator* _phone_fd_a_it = NULL;
		GeeSet* _tmp8_;
		GeeIterator* _tmp9_;
		_tmp8_ = set_a;
		_tmp9_ = gee_iterable_iterator ((GeeIterable*) _tmp8_);
		_phone_fd_a_it = _tmp9_;
		while (TRUE) {
			GeeIterator* _tmp10_;
			gboolean _tmp11_;
			FolksPhoneFieldDetails* phone_fd_a = NULL;
			GeeIterator* _tmp12_;
			gpointer _tmp13_;
			_tmp10_ = _phone_fd_a_it;
			_tmp11_ = gee_iterator_next (_tmp10_);
			if (!_tmp11_) {
				break;
			}
			_tmp12_ = _phone_fd_a_it;
			_tmp13_ = gee_iterator_get (_tmp12_);
			phone_fd_a = (FolksPhoneFieldDetails*) _tmp13_;
			{
				GeeIterator* _phone_fd_b_it = NULL;
				GeeSet* _tmp14_;
				GeeIterator* _tmp15_;
				_tmp14_ = set_b;
				_tmp15_ = gee_iterable_iterator ((GeeIterable*) _tmp14_);
				_phone_fd_b_it = _tmp15_;
				while (TRUE) {
					GeeIterator* _tmp16_;
					gboolean _tmp17_;
					FolksPhoneFieldDetails* phone_fd_b = NULL;
					GeeIterator* _tmp18_;
					gpointer _tmp19_;
					FolksPhoneFieldDetails* _tmp20_;
					FolksPhoneFieldDetails* _tmp21_;
					gboolean _tmp22_;
					_tmp16_ = _phone_fd_b_it;
					_tmp17_ = gee_iterator_next (_tmp16_);
					if (!_tmp17_) {
						break;
					}
					_tmp18_ = _phone_fd_b_it;
					_tmp19_ = gee_iterator_get (_tmp18_);
					phone_fd_b = (FolksPhoneFieldDetails*) _tmp19_;
					_tmp20_ = phone_fd_a;
					_tmp21_ = phone_fd_b;
					_tmp22_ = folks_abstract_field_details_values_equal ((FolksAbstractFieldDetails*) _tmp20_, (FolksAbstractFieldDetails*) _tmp21_);
					if (_tmp22_) {
						result = FOLKS_MATCH_RESULT_HIGH;
						_g_object_unref0 (phone_fd_b);
						_g_object_unref0 (_phone_fd_b_it);
						_g_object_unref0 (phone_fd_a);
						_g_object_unref0 (_phone_fd_a_it);
						_g_object_unref0 (set_b);
						_g_object_unref0 (set_a);
						return result;
					}
					_g_object_unref0 (phone_fd_b);
				}
				_g_object_unref0 (_phone_fd_b_it);
			}
			_g_object_unref0 (phone_fd_a);
		}
		_g_object_unref0 (_phone_fd_a_it);
	}
	_tmp23_ = old_result;
	result = _tmp23_;
	_g_object_unref0 (set_b);
	_g_object_unref0 (set_a);
	return result;
}


static FolksMatchResult _folks_potential_match_name_similarity (FolksPotentialMatch* self, FolksMatchResult old_result) {
	FolksMatchResult result = 0;
	gdouble similarity = 0.0;
	gboolean exact_match = FALSE;
	FolksIndividual* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	FolksIndividual* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp10_ = FALSE;
	FolksIndividual* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	FolksIndividual* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	gboolean _tmp17_ = FALSE;
	gboolean _tmp18_;
	FolksStructuredName* _a = NULL;
	FolksIndividual* _tmp44_;
	FolksStructuredName* _tmp45_;
	FolksStructuredName* _tmp46_;
	FolksStructuredName* _tmp47_;
	FolksStructuredName* _b = NULL;
	FolksIndividual* _tmp48_;
	FolksStructuredName* _tmp49_;
	FolksStructuredName* _tmp50_;
	FolksStructuredName* _tmp51_;
	gboolean _tmp52_ = FALSE;
	FolksStructuredName* _tmp53_;
	gdouble _tmp113_;
	gdouble _tmp114_;
	gdouble _tmp115_;
	FolksMatchResult _tmp121_;
	g_return_val_if_fail (self != NULL, 0);
	similarity = 0.0;
	exact_match = FALSE;
	_tmp0_ = self->priv->_individual_a;
	_tmp1_ = folks_name_details_get_nickname ((FolksNameDetails*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->_individual_b;
	_tmp4_ = folks_name_details_get_nickname ((FolksNameDetails*) _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = _folks_potential_match_look_alike (self, _tmp2_, _tmp5_);
	if (_tmp6_) {
		gdouble _tmp7_;
		_tmp7_ = similarity;
		similarity = _tmp7_ + 0.20;
	}
	_tmp11_ = self->priv->_individual_a;
	_tmp12_ = folks_name_details_get_full_name ((FolksNameDetails*) _tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = self->priv->_individual_b;
	_tmp15_ = folks_name_details_get_full_name ((FolksNameDetails*) _tmp14_);
	_tmp16_ = _tmp15_;
	_tmp18_ = _folks_potential_match_look_alike_or_identical (self, _tmp13_, _tmp16_, &_tmp17_);
	exact_match = _tmp17_;
	if (_tmp18_) {
		_tmp10_ = TRUE;
	} else {
		FolksIndividual* _tmp19_;
		const gchar* _tmp20_;
		const gchar* _tmp21_;
		FolksIndividual* _tmp22_;
		const gchar* _tmp23_;
		const gchar* _tmp24_;
		gboolean _tmp25_ = FALSE;
		gboolean _tmp26_;
		_tmp19_ = self->priv->_individual_a;
		_tmp20_ = folks_alias_details_get_alias ((FolksAliasDetails*) _tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = self->priv->_individual_b;
		_tmp23_ = folks_name_details_get_full_name ((FolksNameDetails*) _tmp22_);
		_tmp24_ = _tmp23_;
		_tmp26_ = _folks_potential_match_look_alike_or_identical (self, _tmp21_, _tmp24_, &_tmp25_);
		exact_match = _tmp25_;
		_tmp10_ = _tmp26_;
	}
	if (_tmp10_) {
		_tmp9_ = TRUE;
	} else {
		FolksIndividual* _tmp27_;
		const gchar* _tmp28_;
		const gchar* _tmp29_;
		FolksIndividual* _tmp30_;
		const gchar* _tmp31_;
		const gchar* _tmp32_;
		gboolean _tmp33_ = FALSE;
		gboolean _tmp34_;
		_tmp27_ = self->priv->_individual_a;
		_tmp28_ = folks_name_details_get_full_name ((FolksNameDetails*) _tmp27_);
		_tmp29_ = _tmp28_;
		_tmp30_ = self->priv->_individual_b;
		_tmp31_ = folks_alias_details_get_alias ((FolksAliasDetails*) _tmp30_);
		_tmp32_ = _tmp31_;
		_tmp34_ = _folks_potential_match_look_alike_or_identical (self, _tmp29_, _tmp32_, &_tmp33_);
		exact_match = _tmp33_;
		_tmp9_ = _tmp34_;
	}
	if (_tmp9_) {
		_tmp8_ = TRUE;
	} else {
		FolksIndividual* _tmp35_;
		const gchar* _tmp36_;
		const gchar* _tmp37_;
		FolksIndividual* _tmp38_;
		const gchar* _tmp39_;
		const gchar* _tmp40_;
		gboolean _tmp41_ = FALSE;
		gboolean _tmp42_;
		_tmp35_ = self->priv->_individual_a;
		_tmp36_ = folks_alias_details_get_alias ((FolksAliasDetails*) _tmp35_);
		_tmp37_ = _tmp36_;
		_tmp38_ = self->priv->_individual_b;
		_tmp39_ = folks_alias_details_get_alias ((FolksAliasDetails*) _tmp38_);
		_tmp40_ = _tmp39_;
		_tmp42_ = _folks_potential_match_look_alike_or_identical (self, _tmp37_, _tmp40_, &_tmp41_);
		exact_match = _tmp41_;
		_tmp8_ = _tmp42_;
	}
	if (_tmp8_) {
		gdouble _tmp43_;
		_tmp43_ = similarity;
		similarity = _tmp43_ + 0.70;
	}
	_tmp44_ = self->priv->_individual_a;
	_tmp45_ = folks_name_details_get_structured_name ((FolksNameDetails*) _tmp44_);
	_tmp46_ = _tmp45_;
	_tmp47_ = _g_object_ref0 (_tmp46_);
	_a = _tmp47_;
	_tmp48_ = self->priv->_individual_b;
	_tmp49_ = folks_name_details_get_structured_name ((FolksNameDetails*) _tmp48_);
	_tmp50_ = _tmp49_;
	_tmp51_ = _g_object_ref0 (_tmp50_);
	_b = _tmp51_;
	_tmp53_ = _a;
	if (_tmp53_ != NULL) {
		FolksStructuredName* _tmp54_;
		_tmp54_ = _b;
		_tmp52_ = _tmp54_ != NULL;
	} else {
		_tmp52_ = FALSE;
	}
	if (_tmp52_) {
		FolksStructuredName* a = NULL;
		FolksStructuredName* _tmp55_;
		FolksStructuredName* _tmp56_;
		FolksStructuredName* b = NULL;
		FolksStructuredName* _tmp57_;
		FolksStructuredName* _tmp58_;
		gboolean _tmp59_ = FALSE;
		FolksStructuredName* _tmp60_;
		gboolean _tmp61_;
		FolksStructuredName* _tmp65_;
		const gchar* _tmp66_;
		const gchar* _tmp67_;
		FolksStructuredName* _tmp68_;
		const gchar* _tmp69_;
		const gchar* _tmp70_;
		gboolean _tmp71_;
		gboolean _tmp73_ = FALSE;
		FolksStructuredName* _tmp74_;
		const gchar* _tmp75_;
		const gchar* _tmp76_;
		FolksStructuredName* _tmp77_;
		const gchar* _tmp78_;
		const gchar* _tmp79_;
		gboolean _tmp80_;
		FolksStructuredName* _tmp89_;
		const gchar* _tmp90_;
		const gchar* _tmp91_;
		FolksStructuredName* _tmp92_;
		const gchar* _tmp93_;
		const gchar* _tmp94_;
		gboolean _tmp95_;
		FolksStructuredName* _tmp97_;
		const gchar* _tmp98_;
		const gchar* _tmp99_;
		FolksStructuredName* _tmp100_;
		const gchar* _tmp101_;
		const gchar* _tmp102_;
		gboolean _tmp103_;
		FolksStructuredName* _tmp105_;
		const gchar* _tmp106_;
		const gchar* _tmp107_;
		FolksStructuredName* _tmp108_;
		const gchar* _tmp109_;
		const gchar* _tmp110_;
		gboolean _tmp111_;
		_tmp55_ = _a;
		_tmp56_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp55_, FOLKS_TYPE_STRUCTURED_NAME, FolksStructuredName));
		a = _tmp56_;
		_tmp57_ = _b;
		_tmp58_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp57_, FOLKS_TYPE_STRUCTURED_NAME, FolksStructuredName));
		b = _tmp58_;
		_tmp60_ = a;
		_tmp61_ = folks_structured_name_is_empty (_tmp60_);
		if (_tmp61_ == FALSE) {
			FolksStructuredName* _tmp62_;
			FolksStructuredName* _tmp63_;
			gboolean _tmp64_;
			_tmp62_ = a;
			_tmp63_ = b;
			_tmp64_ = folks_structured_name_equal (_tmp62_, _tmp63_);
			_tmp59_ = _tmp64_;
		} else {
			_tmp59_ = FALSE;
		}
		if (_tmp59_) {
			result = FOLKS_MATCH_RESULT_HIGH;
			_g_object_unref0 (b);
			_g_object_unref0 (a);
			_g_object_unref0 (_b);
			_g_object_unref0 (_a);
			return result;
		}
		_tmp65_ = a;
		_tmp66_ = folks_structured_name_get_given_name (_tmp65_);
		_tmp67_ = _tmp66_;
		_tmp68_ = b;
		_tmp69_ = folks_structured_name_get_given_name (_tmp68_);
		_tmp70_ = _tmp69_;
		_tmp71_ = _folks_utils_str_equal_safe (_tmp67_, _tmp70_);
		if (_tmp71_) {
			gdouble _tmp72_;
			_tmp72_ = similarity;
			similarity = _tmp72_ + 0.20;
		}
		_tmp74_ = a;
		_tmp75_ = folks_structured_name_get_family_name (_tmp74_);
		_tmp76_ = _tmp75_;
		_tmp77_ = b;
		_tmp78_ = folks_structured_name_get_family_name (_tmp77_);
		_tmp79_ = _tmp78_;
		_tmp80_ = _folks_potential_match_look_alike (self, _tmp76_, _tmp79_);
		if (_tmp80_) {
			FolksStructuredName* _tmp81_;
			const gchar* _tmp82_;
			const gchar* _tmp83_;
			FolksStructuredName* _tmp84_;
			const gchar* _tmp85_;
			const gchar* _tmp86_;
			gboolean _tmp87_;
			_tmp81_ = a;
			_tmp82_ = folks_structured_name_get_given_name (_tmp81_);
			_tmp83_ = _tmp82_;
			_tmp84_ = b;
			_tmp85_ = folks_structured_name_get_given_name (_tmp84_);
			_tmp86_ = _tmp85_;
			_tmp87_ = _folks_potential_match_look_alike (self, _tmp83_, _tmp86_);
			_tmp73_ = _tmp87_;
		} else {
			_tmp73_ = FALSE;
		}
		if (_tmp73_) {
			gdouble _tmp88_;
			_tmp88_ = similarity;
			similarity = _tmp88_ + 0.40;
		}
		_tmp89_ = a;
		_tmp90_ = folks_structured_name_get_additional_names (_tmp89_);
		_tmp91_ = _tmp90_;
		_tmp92_ = b;
		_tmp93_ = folks_structured_name_get_additional_names (_tmp92_);
		_tmp94_ = _tmp93_;
		_tmp95_ = _folks_utils_str_equal_safe (_tmp91_, _tmp94_);
		if (_tmp95_) {
			gdouble _tmp96_;
			_tmp96_ = similarity;
			similarity = _tmp96_ + 0.5;
		}
		_tmp97_ = a;
		_tmp98_ = folks_structured_name_get_prefixes (_tmp97_);
		_tmp99_ = _tmp98_;
		_tmp100_ = b;
		_tmp101_ = folks_structured_name_get_prefixes (_tmp100_);
		_tmp102_ = _tmp101_;
		_tmp103_ = _folks_utils_str_equal_safe (_tmp99_, _tmp102_);
		if (_tmp103_) {
			gdouble _tmp104_;
			_tmp104_ = similarity;
			similarity = _tmp104_ + 0.5;
		}
		_tmp105_ = a;
		_tmp106_ = folks_structured_name_get_suffixes (_tmp105_);
		_tmp107_ = _tmp106_;
		_tmp108_ = b;
		_tmp109_ = folks_structured_name_get_suffixes (_tmp108_);
		_tmp110_ = _tmp109_;
		_tmp111_ = _folks_utils_str_equal_safe (_tmp107_, _tmp110_);
		if (_tmp111_) {
			gdouble _tmp112_;
			_tmp112_ = similarity;
			similarity = _tmp112_ + 0.5;
		}
		_g_object_unref0 (b);
		_g_object_unref0 (a);
	}
	_tmp113_ = similarity;
	g_debug ("potential-match.vala:275: [name_similarity] Got %f\n", _tmp113_);
	_tmp114_ = similarity;
	_tmp115_ = folks_potential_match__DIST_THRESHOLD;
	if (_tmp114_ >= _tmp115_) {
		gint inc = 0;
		gboolean _tmp116_;
		FolksMatchResult _tmp118_;
		gint _tmp119_;
		FolksMatchResult _tmp120_;
		inc = 2;
		_tmp116_ = exact_match;
		if (_tmp116_) {
			gint _tmp117_;
			_tmp117_ = inc;
			inc = _tmp117_ + 1;
		}
		_tmp118_ = old_result;
		_tmp119_ = inc;
		_tmp120_ = _folks_potential_match_inc_match_level (self, _tmp118_, _tmp119_);
		result = _tmp120_;
		_g_object_unref0 (_b);
		_g_object_unref0 (_a);
		return result;
	}
	_tmp121_ = old_result;
	result = _tmp121_;
	_g_object_unref0 (_b);
	_g_object_unref0 (_a);
	return result;
}


/**
   * Number of equal IM addresses between two individuals.
   *
   * This compares the addresses without comparing their associated protocols.
   *
   * @since 0.5.0
   */
static FolksMatchResult _folks_potential_match_inspect_im_addresses (FolksPotentialMatch* self, FolksMatchResult old_result) {
	FolksMatchResult result = 0;
	GeeHashSet* addrs = NULL;
	GeeHashSet* _tmp0_;
	FolksMatchResult _tmp32_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
	addrs = _tmp0_;
	{
		GeeIterator* _im_a_it = NULL;
		FolksIndividual* _tmp1_;
		GeeMultiMap* _tmp2_;
		GeeMultiMap* _tmp3_;
		GeeCollection* _tmp4_;
		GeeCollection* _tmp5_;
		GeeIterator* _tmp6_;
		GeeIterator* _tmp7_;
		_tmp1_ = self->priv->_individual_a;
		_tmp2_ = folks_im_details_get_im_addresses ((FolksImDetails*) _tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = gee_multi_map_get_values (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = gee_iterable_iterator ((GeeIterable*) _tmp5_);
		_tmp7_ = _tmp6_;
		_g_object_unref0 (_tmp5_);
		_im_a_it = _tmp7_;
		while (TRUE) {
			GeeIterator* _tmp8_;
			gboolean _tmp9_;
			FolksImFieldDetails* im_a = NULL;
			GeeIterator* _tmp10_;
			gpointer _tmp11_;
			GeeHashSet* _tmp12_;
			FolksImFieldDetails* _tmp13_;
			gconstpointer _tmp14_;
			const gchar* _tmp15_;
			_tmp8_ = _im_a_it;
			_tmp9_ = gee_iterator_next (_tmp8_);
			if (!_tmp9_) {
				break;
			}
			_tmp10_ = _im_a_it;
			_tmp11_ = gee_iterator_get (_tmp10_);
			im_a = (FolksImFieldDetails*) _tmp11_;
			_tmp12_ = addrs;
			_tmp13_ = im_a;
			_tmp14_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp13_);
			_tmp15_ = _tmp14_;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp12_, (const gchar*) _tmp15_);
			_g_object_unref0 (im_a);
		}
		_g_object_unref0 (_im_a_it);
	}
	{
		GeeIterator* _im_b_it = NULL;
		FolksIndividual* _tmp16_;
		GeeMultiMap* _tmp17_;
		GeeMultiMap* _tmp18_;
		GeeCollection* _tmp19_;
		GeeCollection* _tmp20_;
		GeeIterator* _tmp21_;
		GeeIterator* _tmp22_;
		_tmp16_ = self->priv->_individual_b;
		_tmp17_ = folks_im_details_get_im_addresses ((FolksImDetails*) _tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = gee_multi_map_get_values (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = gee_iterable_iterator ((GeeIterable*) _tmp20_);
		_tmp22_ = _tmp21_;
		_g_object_unref0 (_tmp20_);
		_im_b_it = _tmp22_;
		while (TRUE) {
			GeeIterator* _tmp23_;
			gboolean _tmp24_;
			FolksImFieldDetails* im_b = NULL;
			GeeIterator* _tmp25_;
			gpointer _tmp26_;
			GeeHashSet* _tmp27_;
			FolksImFieldDetails* _tmp28_;
			gconstpointer _tmp29_;
			const gchar* _tmp30_;
			gboolean _tmp31_;
			_tmp23_ = _im_b_it;
			_tmp24_ = gee_iterator_next (_tmp23_);
			if (!_tmp24_) {
				break;
			}
			_tmp25_ = _im_b_it;
			_tmp26_ = gee_iterator_get (_tmp25_);
			im_b = (FolksImFieldDetails*) _tmp26_;
			_tmp27_ = addrs;
			_tmp28_ = im_b;
			_tmp29_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp28_);
			_tmp30_ = _tmp29_;
			_tmp31_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp27_, (const gchar*) _tmp30_);
			if (_tmp31_ == TRUE) {
				result = FOLKS_MATCH_RESULT_HIGH;
				_g_object_unref0 (im_b);
				_g_object_unref0 (_im_b_it);
				_g_object_unref0 (addrs);
				return result;
			}
			_g_object_unref0 (im_b);
		}
		_g_object_unref0 (_im_b_it);
	}
	_tmp32_ = old_result;
	result = _tmp32_;
	_g_object_unref0 (addrs);
	return result;
}


/**
   * Inspect email addresses.
   *
   * @since 0.5.0
   */
static FolksMatchResult _folks_potential_match_inspect_emails (FolksPotentialMatch* self, FolksMatchResult old_result) {
	FolksMatchResult result = 0;
	GeeSet* set_a = NULL;
	FolksIndividual* _tmp0_;
	GeeSet* _tmp1_;
	GeeSet* _tmp2_;
	GeeSet* _tmp3_;
	GeeSet* set_b = NULL;
	FolksIndividual* _tmp4_;
	GeeSet* _tmp5_;
	GeeSet* _tmp6_;
	GeeSet* _tmp7_;
	FolksMatchResult _result_ = 0;
	FolksMatchResult _tmp8_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_individual_a;
	_tmp1_ = folks_email_details_get_email_addresses ((FolksEmailDetails*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	set_a = _tmp3_;
	_tmp4_ = self->priv->_individual_b;
	_tmp5_ = folks_email_details_get_email_addresses ((FolksEmailDetails*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = _g_object_ref0 (_tmp6_);
	set_b = _tmp7_;
	_tmp8_ = old_result;
	_result_ = _tmp8_;
	{
		GeeIterator* _fd_a_it = NULL;
		GeeSet* _tmp9_;
		GeeIterator* _tmp10_;
		_tmp9_ = set_a;
		_tmp10_ = gee_iterable_iterator ((GeeIterable*) _tmp9_);
		_fd_a_it = _tmp10_;
		while (TRUE) {
			GeeIterator* _tmp11_;
			gboolean _tmp12_;
			FolksEmailFieldDetails* fd_a = NULL;
			GeeIterator* _tmp13_;
			gpointer _tmp14_;
			gchar** email_split_a = NULL;
			FolksEmailFieldDetails* _tmp15_;
			gconstpointer _tmp16_;
			const gchar* _tmp17_;
			gchar** _tmp18_;
			gchar** _tmp19_;
			gint email_split_a_length1;
			gint _email_split_a_size_;
			gchar** _tmp20_;
			gint _tmp20__length1;
			gchar** tokens_a = NULL;
			gchar** _tmp24_;
			gint _tmp24__length1;
			const gchar* _tmp25_;
			gchar** _tmp26_;
			gchar** _tmp27_;
			gint tokens_a_length1;
			gint _tokens_a_size_;
			_tmp11_ = _fd_a_it;
			_tmp12_ = gee_iterator_next (_tmp11_);
			if (!_tmp12_) {
				break;
			}
			_tmp13_ = _fd_a_it;
			_tmp14_ = gee_iterator_get (_tmp13_);
			fd_a = (FolksEmailFieldDetails*) _tmp14_;
			_tmp15_ = fd_a;
			_tmp16_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp15_);
			_tmp17_ = _tmp16_;
			_tmp19_ = _tmp18_ = g_strsplit ((const gchar*) _tmp17_, "@", 0);
			email_split_a = _tmp19_;
			email_split_a_length1 = _vala_array_length (_tmp18_);
			_email_split_a_size_ = email_split_a_length1;
			_tmp20_ = email_split_a;
			_tmp20__length1 = email_split_a_length1;
			if (_tmp20__length1 < 2) {
				FolksEmailFieldDetails* _tmp21_;
				gconstpointer _tmp22_;
				const gchar* _tmp23_;
				_tmp21_ = fd_a;
				_tmp22_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp21_);
				_tmp23_ = _tmp22_;
				g_warning ("Invalid e-mail address when looking for potential " "match: %s", (const gchar*) _tmp23_);
				email_split_a = (_vala_array_free (email_split_a, email_split_a_length1, (GDestroyNotify) g_free), NULL);
				_g_object_unref0 (fd_a);
				continue;
			}
			_tmp24_ = email_split_a;
			_tmp24__length1 = email_split_a_length1;
			_tmp25_ = _tmp24_[0];
			_tmp27_ = _tmp26_ = g_strsplit_set (_tmp25_, FOLKS_POTENTIAL_MATCH__SEPARATORS, 0);
			tokens_a = _tmp27_;
			tokens_a_length1 = _vala_array_length (_tmp26_);
			_tokens_a_size_ = tokens_a_length1;
			{
				GeeIterator* _fd_b_it = NULL;
				GeeSet* _tmp28_;
				GeeIterator* _tmp29_;
				_tmp28_ = set_b;
				_tmp29_ = gee_iterable_iterator ((GeeIterable*) _tmp28_);
				_fd_b_it = _tmp29_;
				while (TRUE) {
					GeeIterator* _tmp30_;
					gboolean _tmp31_;
					FolksEmailFieldDetails* fd_b = NULL;
					GeeIterator* _tmp32_;
					gpointer _tmp33_;
					gchar** email_split_b = NULL;
					FolksEmailFieldDetails* _tmp34_;
					gconstpointer _tmp35_;
					const gchar* _tmp36_;
					gchar** _tmp37_;
					gchar** _tmp38_;
					gint email_split_b_length1;
					gint _email_split_b_size_;
					gchar** _tmp39_;
					gint _tmp39__length1;
					FolksEmailFieldDetails* _tmp43_;
					gconstpointer _tmp44_;
					const gchar* _tmp45_;
					FolksEmailFieldDetails* _tmp46_;
					gconstpointer _tmp47_;
					const gchar* _tmp48_;
					_tmp30_ = _fd_b_it;
					_tmp31_ = gee_iterator_next (_tmp30_);
					if (!_tmp31_) {
						break;
					}
					_tmp32_ = _fd_b_it;
					_tmp33_ = gee_iterator_get (_tmp32_);
					fd_b = (FolksEmailFieldDetails*) _tmp33_;
					_tmp34_ = fd_b;
					_tmp35_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp34_);
					_tmp36_ = _tmp35_;
					_tmp38_ = _tmp37_ = g_strsplit ((const gchar*) _tmp36_, "@", 0);
					email_split_b = _tmp38_;
					email_split_b_length1 = _vala_array_length (_tmp37_);
					_email_split_b_size_ = email_split_b_length1;
					_tmp39_ = email_split_b;
					_tmp39__length1 = email_split_b_length1;
					if (_tmp39__length1 < 2) {
						FolksEmailFieldDetails* _tmp40_;
						gconstpointer _tmp41_;
						const gchar* _tmp42_;
						_tmp40_ = fd_b;
						_tmp41_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp40_);
						_tmp42_ = _tmp41_;
						g_warning ("Invalid e-mail address when looking for " "potential match: %s", (const gchar*) _tmp42_);
						email_split_b = (_vala_array_free (email_split_b, email_split_b_length1, (GDestroyNotify) g_free), NULL);
						_g_object_unref0 (fd_b);
						continue;
					}
					_tmp43_ = fd_a;
					_tmp44_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp43_);
					_tmp45_ = _tmp44_;
					_tmp46_ = fd_b;
					_tmp47_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp46_);
					_tmp48_ = _tmp47_;
					if (g_strcmp0 ((const gchar*) _tmp45_, (const gchar*) _tmp48_) == 0) {
						GeeSet* _tmp49_;
						gchar** _tmp50_;
						gint _tmp50__length1;
						const gchar* _tmp51_;
						gboolean _tmp52_;
						_tmp49_ = folks_potential_match_known_email_aliases;
						_tmp50_ = email_split_a;
						_tmp50__length1 = email_split_a_length1;
						_tmp51_ = _tmp50_[0];
						_tmp52_ = gee_collection_contains ((GeeCollection*) _tmp49_, _tmp51_);
						if (_tmp52_ == TRUE) {
							FolksMatchResult _tmp53_;
							_tmp53_ = _result_;
							if (_tmp53_ < FOLKS_MATCH_RESULT_HIGH) {
								_result_ = FOLKS_MATCH_RESULT_LOW;
							}
						} else {
							result = FOLKS_MATCH_RESULT_HIGH;
							email_split_b = (_vala_array_free (email_split_b, email_split_b_length1, (GDestroyNotify) g_free), NULL);
							_g_object_unref0 (fd_b);
							_g_object_unref0 (_fd_b_it);
							tokens_a = (_vala_array_free (tokens_a, tokens_a_length1, (GDestroyNotify) g_free), NULL);
							email_split_a = (_vala_array_free (email_split_a, email_split_a_length1, (GDestroyNotify) g_free), NULL);
							_g_object_unref0 (fd_a);
							_g_object_unref0 (_fd_a_it);
							_g_object_unref0 (set_b);
							_g_object_unref0 (set_a);
							return result;
						}
					} else {
						gchar** tokens_b = NULL;
						gchar** _tmp54_;
						gint _tmp54__length1;
						const gchar* _tmp55_;
						gchar** _tmp56_;
						gchar** _tmp57_;
						gint tokens_b_length1;
						gint _tokens_b_size_;
						gchar** _tmp58_;
						gint _tmp58__length1;
						gchar** _tmp59_;
						gint _tmp59__length1;
						gboolean _tmp60_;
						_tmp54_ = email_split_b;
						_tmp54__length1 = email_split_b_length1;
						_tmp55_ = _tmp54_[0];
						_tmp57_ = _tmp56_ = g_strsplit_set (_tmp55_, FOLKS_POTENTIAL_MATCH__SEPARATORS, 0);
						tokens_b = _tmp57_;
						tokens_b_length1 = _vala_array_length (_tmp56_);
						_tokens_b_size_ = tokens_b_length1;
						_tmp58_ = tokens_a;
						_tmp58__length1 = tokens_a_length1;
						_tmp59_ = tokens_b;
						_tmp59__length1 = tokens_b_length1;
						_tmp60_ = _folks_potential_match_check_initials_expansion (self, _tmp58_, _tmp58__length1, _tmp59_, _tmp59__length1);
						if (_tmp60_) {
							_result_ = FOLKS_MATCH_RESULT_MEDIUM;
						} else {
							gchar** _tmp61_;
							gint _tmp61__length1;
							gchar** _tmp62_;
							gint _tmp62__length1;
							gboolean _tmp63_;
							_tmp61_ = tokens_a;
							_tmp61__length1 = tokens_a_length1;
							_tmp62_ = tokens_b;
							_tmp62__length1 = tokens_b_length1;
							_tmp63_ = _folks_potential_match_match_tokens (self, _tmp61_, _tmp61__length1, _tmp62_, _tmp62__length1);
							if (_tmp63_) {
								_result_ = FOLKS_MATCH_RESULT_MEDIUM;
							}
						}
						tokens_b = (_vala_array_free (tokens_b, tokens_b_length1, (GDestroyNotify) g_free), NULL);
					}
					email_split_b = (_vala_array_free (email_split_b, email_split_b_length1, (GDestroyNotify) g_free), NULL);
					_g_object_unref0 (fd_b);
				}
				_g_object_unref0 (_fd_b_it);
			}
			tokens_a = (_vala_array_free (tokens_a, tokens_a_length1, (GDestroyNotify) g_free), NULL);
			email_split_a = (_vala_array_free (email_split_a, email_split_a_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (fd_a);
		}
		_g_object_unref0 (_fd_a_it);
	}
	result = _result_;
	_g_object_unref0 (set_b);
	_g_object_unref0 (set_a);
	return result;
}


static gboolean _folks_potential_match_check_initials_expansion (FolksPotentialMatch* self, gchar** tokens_a, int tokens_a_length1, gchar** tokens_b, int tokens_b_length1) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gchar** _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = tokens_a;
	_tmp1__length1 = tokens_a_length1;
	_tmp2_ = tokens_b;
	_tmp2__length1 = tokens_b_length1;
	if (_tmp1__length1 > _tmp2__length1) {
		gchar** _tmp3_;
		gint _tmp3__length1;
		_tmp3_ = tokens_b;
		_tmp3__length1 = tokens_b_length1;
		_tmp0_ = _tmp3__length1 == 1;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gchar** _tmp4_;
		gint _tmp4__length1;
		gchar** _tmp5_;
		gint _tmp5__length1;
		const gchar* _tmp6_;
		gboolean _tmp7_;
		_tmp4_ = tokens_a;
		_tmp4__length1 = tokens_a_length1;
		_tmp5_ = tokens_b;
		_tmp5__length1 = tokens_b_length1;
		_tmp6_ = _tmp5_[0];
		_tmp7_ = _folks_potential_match_do_check_initials_expansion (self, _tmp4_, _tmp4__length1, _tmp6_);
		result = _tmp7_;
		return result;
	} else {
		gboolean _tmp8_ = FALSE;
		gchar** _tmp9_;
		gint _tmp9__length1;
		gchar** _tmp10_;
		gint _tmp10__length1;
		_tmp9_ = tokens_b;
		_tmp9__length1 = tokens_b_length1;
		_tmp10_ = tokens_a;
		_tmp10__length1 = tokens_a_length1;
		if (_tmp9__length1 > _tmp10__length1) {
			gchar** _tmp11_;
			gint _tmp11__length1;
			_tmp11_ = tokens_a;
			_tmp11__length1 = tokens_a_length1;
			_tmp8_ = _tmp11__length1 == 1;
		} else {
			_tmp8_ = FALSE;
		}
		if (_tmp8_) {
			gchar** _tmp12_;
			gint _tmp12__length1;
			gchar** _tmp13_;
			gint _tmp13__length1;
			const gchar* _tmp14_;
			gboolean _tmp15_;
			_tmp12_ = tokens_b;
			_tmp12__length1 = tokens_b_length1;
			_tmp13_ = tokens_a;
			_tmp13__length1 = tokens_a_length1;
			_tmp14_ = _tmp13_[0];
			_tmp15_ = _folks_potential_match_do_check_initials_expansion (self, _tmp12_, _tmp12__length1, _tmp14_);
			result = _tmp15_;
			return result;
		}
	}
	result = FALSE;
	return result;
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_;
	gchar _tmp1_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static gboolean _folks_potential_match_do_check_initials_expansion (FolksPotentialMatch* self, gchar** expanded_name, int expanded_name_length1, const gchar* initials) {
	gboolean result = FALSE;
	gchar** _tmp0_;
	gint _tmp0__length1;
	const gchar* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (initials != NULL, FALSE);
	_tmp0_ = expanded_name;
	_tmp0__length1 = expanded_name_length1;
	_tmp1_ = initials;
	_tmp2_ = strlen (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp0__length1 != _tmp3_) {
		result = FALSE;
		return result;
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				gint _tmp6_;
				gchar** _tmp7_;
				gint _tmp7__length1;
				gchar** _tmp8_;
				gint _tmp8__length1;
				gint _tmp9_;
				const gchar* _tmp10_;
				gchar _tmp11_;
				const gchar* _tmp12_;
				gint _tmp13_;
				gchar _tmp14_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				_tmp6_ = i;
				_tmp7_ = expanded_name;
				_tmp7__length1 = expanded_name_length1;
				if (!(_tmp6_ < _tmp7__length1)) {
					break;
				}
				_tmp8_ = expanded_name;
				_tmp8__length1 = expanded_name_length1;
				_tmp9_ = i;
				_tmp10_ = _tmp8_[_tmp9_];
				_tmp11_ = string_get (_tmp10_, (glong) 0);
				_tmp12_ = initials;
				_tmp13_ = i;
				_tmp14_ = string_get (_tmp12_, (glong) _tmp13_);
				if (_tmp11_ != _tmp14_) {
					result = FALSE;
					return result;
				}
			}
		}
	}
	result = TRUE;
	return result;
}


static gboolean _folks_potential_match_match_tokens (FolksPotentialMatch* self, gchar** tokens_a, int tokens_a_length1, gchar** tokens_b, int tokens_b_length1) {
	gboolean result = FALSE;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = tokens_a;
	_tmp0__length1 = tokens_a_length1;
	_tmp1_ = tokens_b;
	_tmp1__length1 = tokens_b_length1;
	if (_tmp0__length1 > _tmp1__length1) {
		gchar** _tmp2_;
		gint _tmp2__length1;
		gchar** _tmp3_;
		gint _tmp3__length1;
		gboolean _tmp4_;
		_tmp2_ = tokens_a;
		_tmp2__length1 = tokens_a_length1;
		_tmp3_ = tokens_b;
		_tmp3__length1 = tokens_b_length1;
		_tmp4_ = _folks_potential_match_do_match_tokens (self, _tmp2_, _tmp2__length1, _tmp3_, _tmp3__length1);
		result = _tmp4_;
		return result;
	} else {
		gchar** _tmp5_;
		gint _tmp5__length1;
		gchar** _tmp6_;
		gint _tmp6__length1;
		gboolean _tmp7_;
		_tmp5_ = tokens_b;
		_tmp5__length1 = tokens_b_length1;
		_tmp6_ = tokens_a;
		_tmp6__length1 = tokens_a_length1;
		_tmp7_ = _folks_potential_match_do_match_tokens (self, _tmp5_, _tmp5__length1, _tmp6_, _tmp6__length1);
		result = _tmp7_;
		return result;
	}
}


static gboolean _folks_potential_match_do_match_tokens (FolksPotentialMatch* self, gchar** bigger_set, int bigger_set_length1, gchar** smaller_set, int smaller_set_length1) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				gchar** _tmp3_;
				gint _tmp3__length1;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = smaller_set;
				_tmp3__length1 = smaller_set_length1;
				if (!(_tmp2_ < _tmp3__length1)) {
					break;
				}
				{
					gint j = 0;
					j = 0;
					{
						gboolean _tmp4_ = FALSE;
						_tmp4_ = TRUE;
						while (TRUE) {
							gint _tmp6_;
							gchar** _tmp7_;
							gint _tmp7__length1;
							gchar** _tmp8_;
							gint _tmp8__length1;
							gint _tmp9_;
							const gchar* _tmp10_;
							gchar** _tmp11_;
							gint _tmp11__length1;
							gint _tmp12_;
							const gchar* _tmp13_;
							if (!_tmp4_) {
								gint _tmp5_;
								_tmp5_ = j;
								j = _tmp5_ + 1;
							}
							_tmp4_ = FALSE;
							_tmp6_ = j;
							_tmp7_ = bigger_set;
							_tmp7__length1 = bigger_set_length1;
							if (!(_tmp6_ < _tmp7__length1)) {
								break;
							}
							_tmp8_ = smaller_set;
							_tmp8__length1 = smaller_set_length1;
							_tmp9_ = i;
							_tmp10_ = _tmp8_[_tmp9_];
							_tmp11_ = bigger_set;
							_tmp11__length1 = bigger_set_length1;
							_tmp12_ = j;
							_tmp13_ = _tmp11_[_tmp12_];
							if (g_strcmp0 (_tmp10_, _tmp13_) == 0) {
								result = TRUE;
								return result;
							}
						}
					}
				}
			}
		}
	}
	result = FALSE;
	return result;
}


static FolksMatchResult _folks_potential_match_inc_match_level (FolksPotentialMatch* self, FolksMatchResult current_level, gint times) {
	FolksMatchResult result = 0;
	FolksMatchResult ret = 0;
	FolksMatchResult _tmp0_;
	gint _tmp1_;
	FolksMatchResult _tmp2_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = current_level;
	_tmp1_ = times;
	ret = _tmp0_ + _tmp1_;
	_tmp2_ = ret;
	if (_tmp2_ > FOLKS_MATCH_RESULT_MAX) {
		ret = FOLKS_MATCH_RESULT_MAX;
	}
	result = ret;
	return result;
}


static gboolean _folks_potential_match_look_alike_or_identical (FolksPotentialMatch* self, const gchar* a, const gchar* b, gboolean* exact) {
	gboolean _vala_exact = FALSE;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	const gchar* _tmp7_;
	gboolean _tmp8_;
	const gchar* _tmp9_;
	gboolean _tmp10_;
	gunichar* a_stripped = NULL;
	const gchar* _tmp11_;
	gint _tmp12_;
	gunichar* _tmp13_;
	gint a_stripped_length1;
	gint _a_stripped_size_;
	gunichar* b_stripped = NULL;
	const gchar* _tmp14_;
	gint _tmp15_;
	gunichar* _tmp16_;
	gint b_stripped_length1;
	gint _b_stripped_size_;
	gdouble jaro_dist = 0.0;
	gunichar* _tmp17_;
	gint _tmp17__length1;
	gunichar* _tmp18_;
	gint _tmp18__length1;
	gdouble _tmp19_;
	gdouble _tmp20_;
	gdouble _tmp21_;
	gdouble _tmp22_;
	g_return_val_if_fail (self != NULL, FALSE);
	_vala_exact = FALSE;
	_tmp3_ = a;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		const gchar* _tmp4_;
		_tmp4_ = a;
		_tmp2_ = g_strcmp0 (_tmp4_, "") == 0;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		const gchar* _tmp5_;
		_tmp5_ = b;
		_tmp1_ = _tmp5_ == NULL;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp6_;
		_tmp6_ = b;
		_tmp0_ = g_strcmp0 (_tmp6_, "") == 0;
	}
	if (_tmp0_) {
		result = FALSE;
		if (exact) {
			*exact = _vala_exact;
		}
		return result;
	}
	_tmp7_ = a;
	_tmp8_ = g_utf8_validate (_tmp7_, (gssize) -1, NULL);
	g_return_val_if_fail (_tmp8_, FALSE);
	_tmp9_ = b;
	_tmp10_ = g_utf8_validate (_tmp9_, (gssize) -1, NULL);
	g_return_val_if_fail (_tmp10_, FALSE);
	_tmp11_ = a;
	_tmp13_ = _folks_potential_match_strip_string (self, (const gchar*) _tmp11_, &_tmp12_);
	a_stripped = _tmp13_;
	a_stripped_length1 = _tmp12_;
	_a_stripped_size_ = a_stripped_length1;
	_tmp14_ = b;
	_tmp16_ = _folks_potential_match_strip_string (self, (const gchar*) _tmp14_, &_tmp15_);
	b_stripped = _tmp16_;
	b_stripped_length1 = _tmp15_;
	_b_stripped_size_ = b_stripped_length1;
	_tmp17_ = a_stripped;
	_tmp17__length1 = a_stripped_length1;
	_tmp18_ = b_stripped;
	_tmp18__length1 = b_stripped_length1;
	_tmp19_ = _folks_potential_match_jaro_dist (self, _tmp17_, _tmp17__length1, _tmp18_, _tmp18__length1);
	jaro_dist = _tmp19_;
	_tmp20_ = jaro_dist;
	if (_tmp20_ == 1.0) {
		_vala_exact = TRUE;
		result = TRUE;
		b_stripped = (g_free (b_stripped), NULL);
		a_stripped = (g_free (a_stripped), NULL);
		if (exact) {
			*exact = _vala_exact;
		}
		return result;
	}
	_tmp21_ = jaro_dist;
	_tmp22_ = folks_potential_match__DIST_THRESHOLD;
	result = _tmp21_ >= _tmp22_;
	b_stripped = (g_free (b_stripped), NULL);
	a_stripped = (g_free (a_stripped), NULL);
	if (exact) {
		*exact = _vala_exact;
	}
	return result;
}


static gboolean _folks_potential_match_look_alike (FolksPotentialMatch* self, const gchar* a, const gchar* b) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	const gchar* _tmp7_;
	gboolean _tmp8_;
	const gchar* _tmp9_;
	gboolean _tmp10_;
	gunichar* a_stripped = NULL;
	const gchar* _tmp11_;
	gint _tmp12_;
	gunichar* _tmp13_;
	gint a_stripped_length1;
	gint _a_stripped_size_;
	gunichar* b_stripped = NULL;
	const gchar* _tmp14_;
	gint _tmp15_;
	gunichar* _tmp16_;
	gint b_stripped_length1;
	gint _b_stripped_size_;
	gunichar* _tmp17_;
	gint _tmp17__length1;
	gunichar* _tmp18_;
	gint _tmp18__length1;
	gdouble _tmp19_;
	gdouble _tmp20_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp3_ = a;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		const gchar* _tmp4_;
		_tmp4_ = a;
		_tmp2_ = g_strcmp0 (_tmp4_, "") == 0;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		const gchar* _tmp5_;
		_tmp5_ = b;
		_tmp1_ = _tmp5_ == NULL;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp6_;
		_tmp6_ = b;
		_tmp0_ = g_strcmp0 (_tmp6_, "") == 0;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp7_ = a;
	_tmp8_ = g_utf8_validate (_tmp7_, (gssize) -1, NULL);
	g_return_val_if_fail (_tmp8_, FALSE);
	_tmp9_ = b;
	_tmp10_ = g_utf8_validate (_tmp9_, (gssize) -1, NULL);
	g_return_val_if_fail (_tmp10_, FALSE);
	_tmp11_ = a;
	_tmp13_ = _folks_potential_match_strip_string (self, (const gchar*) _tmp11_, &_tmp12_);
	a_stripped = _tmp13_;
	a_stripped_length1 = _tmp12_;
	_a_stripped_size_ = a_stripped_length1;
	_tmp14_ = b;
	_tmp16_ = _folks_potential_match_strip_string (self, (const gchar*) _tmp14_, &_tmp15_);
	b_stripped = _tmp16_;
	b_stripped_length1 = _tmp15_;
	_b_stripped_size_ = b_stripped_length1;
	_tmp17_ = a_stripped;
	_tmp17__length1 = a_stripped_length1;
	_tmp18_ = b_stripped;
	_tmp18__length1 = b_stripped_length1;
	_tmp19_ = _folks_potential_match_jaro_dist (self, _tmp17_, _tmp17__length1, _tmp18_, _tmp18__length1);
	_tmp20_ = folks_potential_match__DIST_THRESHOLD;
	result = _tmp19_ >= _tmp20_;
	b_stripped = (g_free (b_stripped), NULL);
	a_stripped = (g_free (a_stripped), NULL);
	return result;
}


static gdouble _folks_potential_match_jaro_dist (FolksPotentialMatch* self, gunichar* s1, int s1_length1, gunichar* s2, int s2_length1) {
	gdouble result = 0.0;
	gdouble distance = 0.0;
	gint _tmp0_ = 0;
	gunichar* _tmp1_;
	gint _tmp1__length1;
	gunichar* _tmp2_;
	gint _tmp2__length1;
	gint max = 0;
	gint max_dist = 0;
	gint _tmp5_;
	gdouble t = 0.0;
	gdouble m = 0.0;
	gunichar* _tmp6_;
	gint _tmp6__length1;
	gunichar* _tmp7_;
	gint _tmp7__length1;
	gint _tmp8_;
	gdouble _tmp9_ = 0.0;
	gint _tmp10_;
	gdouble len_s1 = 0.0;
	gunichar* _tmp11_;
	gint _tmp11__length1;
	gdouble len_s2 = 0.0;
	gunichar* _tmp12_;
	gint _tmp12__length1;
	gdouble a = 0.0;
	gdouble _tmp13_;
	gdouble _tmp14_;
	gdouble b = 0.0;
	gdouble _tmp15_;
	gdouble _tmp16_;
	gdouble c = 0.0;
	gdouble _tmp17_;
	gdouble _tmp21_;
	gdouble _tmp22_;
	gdouble _tmp23_;
	gdouble _tmp24_;
	gdouble _tmp25_;
	gdouble _tmp26_;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp1_ = s1;
	_tmp1__length1 = s1_length1;
	_tmp2_ = s2;
	_tmp2__length1 = s2_length1;
	if (_tmp1__length1 > _tmp2__length1) {
		gunichar* _tmp3_;
		gint _tmp3__length1;
		_tmp3_ = s1;
		_tmp3__length1 = s1_length1;
		_tmp0_ = _tmp3__length1;
	} else {
		gunichar* _tmp4_;
		gint _tmp4__length1;
		_tmp4_ = s2;
		_tmp4__length1 = s2_length1;
		_tmp0_ = _tmp4__length1;
	}
	max = _tmp0_;
	_tmp5_ = max;
	max_dist = (_tmp5_ / 2) - 1;
	_tmp6_ = s1;
	_tmp6__length1 = s1_length1;
	_tmp7_ = s2;
	_tmp7__length1 = s2_length1;
	_tmp8_ = max_dist;
	_tmp10_ = _folks_potential_match_matches (self, _tmp6_, _tmp6__length1, _tmp7_, _tmp7__length1, _tmp8_, &_tmp9_);
	t = _tmp9_;
	m = (gdouble) _tmp10_;
	_tmp11_ = s1;
	_tmp11__length1 = s1_length1;
	len_s1 = (gdouble) _tmp11__length1;
	_tmp12_ = s2;
	_tmp12__length1 = s2_length1;
	len_s2 = (gdouble) _tmp12__length1;
	_tmp13_ = m;
	_tmp14_ = len_s1;
	a = _tmp13_ / _tmp14_;
	_tmp15_ = m;
	_tmp16_ = len_s2;
	b = _tmp15_ / _tmp16_;
	c = (gdouble) 0;
	_tmp17_ = m;
	if (((gint) _tmp17_) > 0) {
		gdouble _tmp18_;
		gdouble _tmp19_;
		gdouble _tmp20_;
		_tmp18_ = m;
		_tmp19_ = t;
		_tmp20_ = m;
		c = (_tmp18_ - _tmp19_) / _tmp20_;
	}
	_tmp21_ = a;
	_tmp22_ = b;
	_tmp23_ = c;
	distance = (1.0 / 3.0) * ((_tmp21_ + _tmp22_) + _tmp23_);
	_tmp24_ = a;
	_tmp25_ = b;
	_tmp26_ = c;
	g_debug ("potential-match.vala:539: Jaro distance: %f (a = %f, b = %f, c = %f)", distance, _tmp24_, _tmp25_, _tmp26_);
	result = distance;
	return result;
}


/**
   * stripped_char:
   *
   * Returns a stripped version of @ch, removing any case, accentuation
   * mark, or any special mark on it.
   *
   * Copied from Empathy's libempathy-gtk/empathy-live-search.c.
   *
   * Copyright (C) 2010 Collabora Ltd.
   * Copyright (C) 2007-2010 Nokia Corporation.
   *
   * Authors: Felix Kaser <felix.kaser@collabora.co.uk>
   *          Xavier Claessens <xavier.claessens@collabora.co.uk>
   *          Claudio Saavedra <csaavedra@igalia.com>
   */
static gunichar _folks_potential_match_stripped_char (FolksPotentialMatch* self, gunichar ch) {
	gunichar result = 0U;
	gunichar retval[1] = {0};
	gunichar _tmp0_[1];
	GUnicodeType utype = 0;
	gunichar _tmp1_;
	GUnicodeType _tmp2_;
	GUnicodeType _tmp3_;
	gunichar _tmp8_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_[0] = (gunichar) 0;
	memcpy (retval, _tmp0_, 1 * sizeof (gunichar));
	_tmp1_ = ch;
	_tmp2_ = g_unichar_type (_tmp1_);
	utype = _tmp2_;
	_tmp3_ = utype;
	switch (_tmp3_) {
		case G_UNICODE_CONTROL:
		case G_UNICODE_FORMAT:
		case G_UNICODE_UNASSIGNED:
		case G_UNICODE_NON_SPACING_MARK:
		case G_UNICODE_COMBINING_MARK:
		case G_UNICODE_ENCLOSING_MARK:
		{
			break;
		}
		case G_UNICODE_DECIMAL_NUMBER:
		case G_UNICODE_LETTER_NUMBER:
		case G_UNICODE_OTHER_NUMBER:
		case G_UNICODE_CONNECT_PUNCTUATION:
		case G_UNICODE_DASH_PUNCTUATION:
		case G_UNICODE_CLOSE_PUNCTUATION:
		case G_UNICODE_FINAL_PUNCTUATION:
		case G_UNICODE_INITIAL_PUNCTUATION:
		case G_UNICODE_OTHER_PUNCTUATION:
		case G_UNICODE_OPEN_PUNCTUATION:
		case G_UNICODE_CURRENCY_SYMBOL:
		case G_UNICODE_MODIFIER_SYMBOL:
		case G_UNICODE_MATH_SYMBOL:
		case G_UNICODE_OTHER_SYMBOL:
		case G_UNICODE_LINE_SEPARATOR:
		case G_UNICODE_PARAGRAPH_SEPARATOR:
		case G_UNICODE_SPACE_SEPARATOR:
		{
			gunichar _tmp4_;
			retval[0] = (gunichar) ' ';
			_tmp4_ = retval[0];
			break;
		}
		default:
		case G_UNICODE_PRIVATE_USE:
		case G_UNICODE_SURROGATE:
		case G_UNICODE_LOWERCASE_LETTER:
		case G_UNICODE_MODIFIER_LETTER:
		case G_UNICODE_OTHER_LETTER:
		case G_UNICODE_TITLECASE_LETTER:
		case G_UNICODE_UPPERCASE_LETTER:
		{
			gunichar _tmp5_;
			gunichar _tmp6_;
			gunichar _tmp7_;
			_tmp5_ = ch;
			_tmp6_ = g_unichar_tolower (_tmp5_);
			ch = _tmp6_;
			_tmp7_ = ch;
			g_unichar_fully_decompose (_tmp7_, FALSE, retval, 1);
			break;
		}
	}
	_tmp8_ = retval[0];
	result = _tmp8_;
	return result;
}


static gboolean string_get_next_char (const gchar* self, gint* index, gunichar* c) {
	gunichar _vala_c = 0U;
	gboolean result = FALSE;
	gint _tmp0_;
	gunichar _tmp1_;
	gunichar _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = *index;
	_tmp1_ = g_utf8_get_char (((gchar*) self) + _tmp0_);
	_vala_c = _tmp1_;
	_tmp2_ = _vala_c;
	if (_tmp2_ != ((gunichar) 0)) {
		gint _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = *index;
		_tmp4_ = g_utf8_next_char (((gchar*) self) + _tmp3_);
		*index = (gint) (_tmp4_ - ((gchar*) self));
		result = TRUE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	} else {
		result = FALSE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	}
	if (c) {
		*c = _vala_c;
	}
}


static gunichar* _folks_potential_match_strip_string (FolksPotentialMatch* self, const gchar* s, int* result_length1) {
	gunichar* result = NULL;
	gint next_idx = 0;
	guint write_idx = 0U;
	gunichar ch = 0U;
	gunichar* output = NULL;
	const gchar* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gunichar* _tmp3_;
	gint output_length1;
	gint _output_size_;
	guint _tmp14_;
	gint _tmp15_;
	gunichar* _tmp16_;
	gint _tmp16__length1;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (s != NULL, NULL);
	next_idx = 0;
	write_idx = (guint) 0;
	ch = (gunichar) 0;
	_tmp0_ = s;
	_tmp1_ = strlen (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_new0 (gunichar, _tmp2_);
	output = _tmp3_;
	output_length1 = _tmp2_;
	_output_size_ = output_length1;
	while (TRUE) {
		const gchar* _tmp4_;
		gunichar _tmp5_ = 0U;
		gboolean _tmp6_;
		gunichar _tmp7_;
		gunichar _tmp8_;
		gunichar _tmp9_;
		_tmp4_ = s;
		_tmp6_ = string_get_next_char (_tmp4_, &next_idx, &_tmp5_);
		ch = _tmp5_;
		if (!_tmp6_) {
			break;
		}
		_tmp7_ = ch;
		_tmp8_ = _folks_potential_match_stripped_char (self, _tmp7_);
		ch = _tmp8_;
		_tmp9_ = ch;
		if (_tmp9_ != ((gunichar) 0)) {
			gunichar* _tmp10_;
			gint _tmp10__length1;
			guint _tmp11_;
			gunichar _tmp12_;
			gunichar _tmp13_;
			_tmp10_ = output;
			_tmp10__length1 = output_length1;
			_tmp11_ = write_idx;
			write_idx = _tmp11_ + 1;
			_tmp12_ = ch;
			_tmp10_[_tmp11_] = _tmp12_;
			_tmp13_ = _tmp10_[_tmp11_];
		}
	}
	_tmp14_ = write_idx;
	output_length1 = (gint) _tmp14_;
	_tmp15_ = output_length1;
	_tmp16_ = output;
	_tmp16__length1 = output_length1;
	if (result_length1) {
		*result_length1 = _tmp16__length1;
	}
	result = _tmp16_;
	return result;
}


static gint _folks_potential_match_matches (FolksPotentialMatch* self, gunichar* s1, int s1_length1, gunichar* s2, int s2_length1, gint max_dist, gdouble* t) {
	gdouble _vala_t = 0.0;
	gint result = 0;
	gint matches = 0;
	gunichar look_for = 0U;
	gint _tmp15_;
	gdouble _tmp16_;
	gdouble _tmp17_;
	g_return_val_if_fail (self != NULL, 0);
	matches = 0;
	_vala_t = 0.0;
	look_for = (gunichar) 0;
	{
		guint idx = 0U;
		idx = (guint) 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gunichar* _tmp2_;
				gint _tmp2__length1;
				guint _tmp3_;
				gunichar _tmp4_;
				gunichar _tmp5_;
				gint contains = 0;
				gunichar* _tmp6_;
				gint _tmp6__length1;
				gunichar _tmp7_;
				guint _tmp8_;
				gint _tmp9_;
				gint _tmp10_;
				gint _tmp11_;
				if (!_tmp0_) {
					guint _tmp1_;
					_tmp1_ = idx;
					idx = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = s1;
				_tmp2__length1 = s1_length1;
				_tmp3_ = idx;
				_tmp4_ = _tmp2_[_tmp3_];
				look_for = _tmp4_;
				_tmp5_ = look_for;
				if (!(_tmp5_ != ((gunichar) 0))) {
					break;
				}
				_tmp6_ = s2;
				_tmp6__length1 = s2_length1;
				_tmp7_ = look_for;
				_tmp8_ = idx;
				_tmp9_ = max_dist;
				_tmp10_ = _folks_potential_match_contains (self, _tmp6_, _tmp6__length1, _tmp7_, _tmp8_, (guint) _tmp9_);
				contains = _tmp10_;
				_tmp11_ = contains;
				if (_tmp11_ >= 0) {
					gint _tmp12_;
					gint _tmp13_;
					_tmp12_ = matches;
					matches = _tmp12_ + 1;
					_tmp13_ = contains;
					if (_tmp13_ > 0) {
						gdouble _tmp14_;
						_tmp14_ = _vala_t;
						_vala_t = _tmp14_ + 1.0;
					}
				}
			}
		}
	}
	_tmp15_ = matches;
	_tmp16_ = _vala_t;
	g_debug ("potential-match.vala:650: %d matches and %f / 2 transpositions", _tmp15_, _tmp16_);
	_tmp17_ = _vala_t;
	_vala_t = _tmp17_ / 2.0;
	result = matches;
	if (t) {
		*t = _vala_t;
	}
	return result;
}


static gint _folks_potential_match_contains (FolksPotentialMatch* self, gunichar* haystack, int haystack_length1, gunichar c, guint pos, guint max_dist) {
	gint result = 0;
	gint haystack_len = 0;
	gunichar* _tmp0_;
	gint _tmp0__length1;
	gunichar ch = 0U;
	gunichar* _tmp1_;
	gint _tmp1__length1;
	guint _tmp2_;
	gunichar _tmp3_;
	gboolean _tmp4_ = FALSE;
	guint _tmp5_;
	gint _tmp6_;
	guint idx = 0U;
	guint _tmp9_;
	guint _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = haystack;
	_tmp0__length1 = haystack_length1;
	haystack_len = _tmp0__length1;
	_tmp1_ = haystack;
	_tmp1__length1 = haystack_length1;
	_tmp2_ = pos;
	_tmp3_ = _tmp1_[_tmp2_];
	ch = _tmp3_;
	_tmp5_ = pos;
	_tmp6_ = haystack_len;
	if (_tmp5_ < ((guint) _tmp6_)) {
		gunichar _tmp7_;
		gunichar _tmp8_;
		_tmp7_ = ch;
		_tmp8_ = c;
		_tmp4_ = _tmp7_ == _tmp8_;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		result = 0;
		return result;
	}
	_tmp9_ = pos;
	_tmp10_ = max_dist;
	_tmp11_ = haystack_len;
	_tmp12_ = CLAMP (((gint) _tmp9_) - ((gint) _tmp10_), 0, _tmp11_);
	idx = (guint) _tmp12_;
	ch = (gunichar) 0;
	while (TRUE) {
		gboolean _tmp13_ = FALSE;
		guint _tmp14_;
		guint _tmp15_;
		guint _tmp16_;
		gunichar _tmp21_;
		gunichar _tmp22_;
		guint _tmp26_;
		_tmp14_ = idx;
		_tmp15_ = pos;
		_tmp16_ = max_dist;
		if (_tmp14_ < (_tmp15_ + _tmp16_)) {
			gunichar* _tmp17_;
			gint _tmp17__length1;
			guint _tmp18_;
			gunichar _tmp19_;
			gunichar _tmp20_;
			_tmp17_ = haystack;
			_tmp17__length1 = haystack_length1;
			_tmp18_ = idx;
			_tmp19_ = _tmp17_[_tmp18_];
			ch = _tmp19_;
			_tmp20_ = ch;
			_tmp13_ = _tmp20_ != ((gunichar) 0);
		} else {
			_tmp13_ = FALSE;
		}
		if (!_tmp13_) {
			break;
		}
		_tmp21_ = ch;
		_tmp22_ = c;
		if (_tmp21_ == _tmp22_) {
			guint _tmp23_;
			guint _tmp24_;
			gint _tmp25_;
			_tmp23_ = pos;
			_tmp24_ = idx;
			_tmp25_ = abs (((gint) _tmp23_) - ((gint) _tmp24_));
			result = _tmp25_;
			return result;
		}
		_tmp26_ = idx;
		idx = _tmp26_ + 1;
	}
	result = -1;
	return result;
}


static void folks_potential_match_class_init (FolksPotentialMatchClass * klass) {
	FolksSmallSet* _tmp0_;
	GeeSet* _tmp1_;
	GeeSet* _tmp2_;
	GeeSet* _tmp3_;
	folks_potential_match_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (FolksPotentialMatchPrivate));
	G_OBJECT_CLASS (klass)->finalize = folks_potential_match_finalize;
	_tmp0_ = folks_small_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
	folks_potential_match_known_email_aliases = (GeeSet*) _tmp0_;
	_tmp1_ = folks_potential_match_known_email_aliases;
	gee_collection_add ((GeeCollection*) _tmp1_, "admin");
	_tmp2_ = folks_potential_match_known_email_aliases;
	gee_collection_add ((GeeCollection*) _tmp2_, "abuse");
	_tmp3_ = folks_potential_match_known_email_aliases;
	gee_collection_add ((GeeCollection*) _tmp3_, "webmaster");
}


static void folks_potential_match_instance_init (FolksPotentialMatch * self) {
	self->priv = FOLKS_POTENTIAL_MATCH_GET_PRIVATE (self);
}


static void folks_potential_match_finalize (GObject * obj) {
	FolksPotentialMatch * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FOLKS_TYPE_POTENTIAL_MATCH, FolksPotentialMatch);
	_g_object_unref0 (self->priv->_individual_a);
	_g_object_unref0 (self->priv->_individual_b);
	G_OBJECT_CLASS (folks_potential_match_parent_class)->finalize (obj);
}


/**
 * Match calculator for pairs of individuals.
 *
 * This provides functionality to explore the degree of a potential match
 * between two individuals. It compares the similarity of the individuals'
 * properties to determine how likely it is that the individuals represent the
 * same physical person.
 *
 * This can be used by folks clients to, for example, present suggestions of
 * pairs of individuals which should be linked by the user.
 *
 * @since 0.5.0
 */
GType folks_potential_match_get_type (void) {
	static volatile gsize folks_potential_match_type_id__volatile = 0;
	if (g_once_init_enter (&folks_potential_match_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksPotentialMatchClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_potential_match_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksPotentialMatch), 0, (GInstanceInitFunc) folks_potential_match_instance_init, NULL };
		GType folks_potential_match_type_id;
		folks_potential_match_type_id = g_type_register_static (G_TYPE_OBJECT, "FolksPotentialMatch", &g_define_type_info, 0);
		g_once_init_leave (&folks_potential_match_type_id__volatile, folks_potential_match_type_id);
	}
	return folks_potential_match_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



