/* number.c generated by valac 0.38.4, the Vala compiler
 * generated from number.vala, do not modify */

/*
 * Copyright (C) 1987-2008 Sun Microsystems, Inc. All Rights Reserved.
 * Copyright (C) 2008-2012 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */
/*  This maths library is based on the MP multi-precision floating-point
 *  arithmetic package originally written in FORTRAN by Richard Brent,
 *  Computer Centre, Australian National University in the 1970's.
 *
 *  It has been converted from FORTRAN into C using the freely available
 *  f2c translator, available via netlib on research.att.com.
 *
 *  The subsequently converted C code has then been tidied up, mainly to
 *  remove any dependencies on the libI77 and libF77 support libraries.
 *
 *  FOR A GENERAL DESCRIPTION OF THE PHILOSOPHY AND DESIGN OF MP,
 *  SEE - R. P. BRENT, A FORTRAN MULTIPLE-PRECISION ARITHMETIC
 *  PACKAGE, ACM TRANS. MATH. SOFTWARE 4 (MARCH 1978), 57-70.
 *  SOME ADDITIONAL DETAILS ARE GIVEN IN THE SAME ISSUE, 71-81.
 *  FOR DETAILS OF THE IMPLEMENTATION, CALLING SEQUENCES ETC. SEE
 *  THE MP USERS GUIDE.
 */

#include <glib.h>
#include <glib-object.h>
#include "mpc.h"
#include "mpfr.h"
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <glib/gi18n-lib.h>


#define TYPE_ANGLE_UNIT (angle_unit_get_type ())

#define TYPE_NUMBER (number_get_type ())
#define NUMBER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NUMBER, Number))
#define NUMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NUMBER, NumberClass))
#define IS_NUMBER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NUMBER))
#define IS_NUMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NUMBER))
#define NUMBER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NUMBER, NumberClass))

typedef struct _Number Number;
typedef struct _NumberClass NumberClass;
typedef struct _NumberPrivate NumberPrivate;
enum  {
	NUMBER_0_PROPERTY,
	NUMBER_NUM_PROPERTIES
};
static GParamSpec* number_properties[NUMBER_NUM_PROPERTIES];
typedef struct _MPFRRealRef MPFRRealRef;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))

#define TYPE_SERIALIZER (serializer_get_type ())
#define SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SERIALIZER, Serializer))
#define SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SERIALIZER, SerializerClass))
#define IS_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SERIALIZER))
#define IS_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SERIALIZER))
#define SERIALIZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SERIALIZER, SerializerClass))

typedef struct _Serializer Serializer;
typedef struct _SerializerClass SerializerClass;

#define TYPE_DISPLAY_FORMAT (display_format_get_type ())

typedef gint (*BitwiseFunc) (gint v1, gint v2, void* user_data);
typedef enum  {
	ANGLE_UNIT_RADIANS,
	ANGLE_UNIT_DEGREES,
	ANGLE_UNIT_GRADIANS
} AngleUnit;

struct _Number {
	GObject parent_instance;
	NumberPrivate * priv;
};

struct _NumberClass {
	GObjectClass parent_class;
};

struct _NumberPrivate {
	__mpc_struct num;
};

struct _MPFRRealRef {
	__mpfr_struct val;
};

typedef enum  {
	DISPLAY_FORMAT_AUTOMATIC,
	DISPLAY_FORMAT_FIXED,
	DISPLAY_FORMAT_SCIENTIFIC,
	DISPLAY_FORMAT_ENGINEERING
} DisplayFormat;


static gpointer number_parent_class = NULL;
static mpfr_prec_t number__precision;
static mpfr_prec_t number__precision = (mpfr_prec_t) 1000;
static gchar* number__error;
static gchar* number__error = NULL;

GType angle_unit_get_type (void) G_GNUC_CONST;
GType number_get_type (void) G_GNUC_CONST;
#define NUMBER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_NUMBER, NumberPrivate))
mpfr_prec_t number_get_precision (void);
Number* number_new_integer (gint64 real, gint64 imag);
Number* number_construct_integer (GType object_type, gint64 real, gint64 imag);
Number* number_new_unsigned_integer (guint64 real, guint64 imag);
Number* number_construct_unsigned_integer (GType object_type, guint64 real, guint64 imag);
Number* number_new_fraction (gint64 numerator, gint64 denominator);
Number* number_construct_fraction (GType object_type, gint64 numerator, gint64 denominator);
Number* number_new_mpreal (__mpfr_struct* real, __mpfr_struct* imag);
Number* number_construct_mpreal (GType object_type, __mpfr_struct* real, __mpfr_struct* imag);
Number* number_new_double (gdouble real, gdouble imag);
Number* number_construct_double (GType object_type, gdouble real, gdouble imag);
Number* number_new_complex (Number* r, Number* i);
Number* number_construct_complex (GType object_type, Number* r, Number* i);
void mpfr_real_ref_free (MPFRRealRef * self);
Number* number_new_polar (Number* r, Number* theta, AngleUnit unit);
Number* number_construct_polar (GType object_type, Number* r, Number* theta, AngleUnit unit);
Number* number_cos (Number* self, AngleUnit unit);
Number* number_sin (Number* self, AngleUnit unit);
Number* number_multiply (Number* self, Number* y);
Number* number_new_eulers (void);
Number* number_construct_eulers (GType object_type);
Number* number_new_i (void);
Number* number_construct_i (GType object_type);
Number* number_new_pi (void);
Number* number_construct_pi (GType object_type);
Number* number_new_random (void);
Number* number_construct_random (GType object_type);
gint64 number_to_integer (Number* self);
guint64 number_to_unsigned_integer (Number* self);
gfloat number_to_float (Number* self);
gdouble number_to_double (Number* self);
gboolean number_is_zero (Number* self);
gboolean number_is_negative (Number* self);
gboolean number_is_integer (Number* self);
gboolean number_is_complex (Number* self);
gboolean number_is_positive_integer (Number* self);
gboolean number_is_natural (Number* self);
void number_check_flags (void);
const gchar* number_get_error (void);
void number_set_error (const gchar* value);
gboolean number_equals (Number* self, Number* y);
gint number_compare (Number* self, Number* y);
Number* number_sgn (Number* self);
Number* number_invert_sign (Number* self);
Number* number_new (void);
Number* number_construct (GType object_type);
Number* number_abs (Number* self);
Number* number_arg (Number* self, AngleUnit unit);
static void number_mpc_from_radians (__mpc_struct* res, __mpc_struct* op, AngleUnit unit);
Number* number_conjugate (Number* self);
Number* number_real_component (Number* self);
Number* number_imaginary_component (Number* self);
Number* number_integer_component (Number* self);
Number* number_fractional_component (Number* self);
Number* number_fractional_part (Number* self);
Number* number_subtract (Number* self, Number* y);
Number* number_floor (Number* self);
Number* number_ceiling (Number* self);
Number* number_round (Number* self);
Number* number_reciprocal (Number* self);
Number* number_epowy (Number* self);
Number* number_xpowy (Number* self, Number* y);
Number* number_root (Number* self, gint64 n);
Number* number_xpowy_integer (Number* self, gint64 n);
Number* number_sqrt (Number* self);
Number* number_ln (Number* self);
Number* number_logarithm (Number* self, gint64 n);
Number* number_divide (Number* self, Number* y);
Number* number_factorial (Number* self);
Number* number_add (Number* self, Number* y);
Number* number_multiply_integer (Number* self, gint64 y);
Number* number_divide_integer (Number* self, gint64 y);
Number* number_modulus_divide (Number* self, Number* y);
Number* number_modular_exponentiation (Number* self, Number* exp, Number* mod);
static Number* number_copy (Number* self);
static void number_mpc_to_radians (__mpc_struct* res, __mpc_struct* op, AngleUnit unit);
Number* number_tan (Number* self, AngleUnit unit);
static Number* number_to_radians (Number* self, AngleUnit unit);
Number* number_asin (Number* self, AngleUnit unit);
Number* number_acos (Number* self, AngleUnit unit);
Number* number_atan (Number* self, AngleUnit unit);
Number* number_sinh (Number* self);
Number* number_cosh (Number* self);
Number* number_tanh (Number* self);
Number* number_asinh (Number* self);
Number* number_acosh (Number* self);
Number* number_atanh (Number* self);
Number* number_and (Number* self, Number* y);
static Number* number_bitwise (Number* self, Number* y, BitwiseFunc bitwise_operator, void* bitwise_operator_target, gint wordlen);
static gint __lambda4_ (Number* self, gint v1, gint v2);
static gint ___lambda4__bitwise_func (gint v1, gint v2, gpointer self);
Number* number_or (Number* self, Number* y);
static gint __lambda5_ (Number* self, gint v1, gint v2);
static gint ___lambda5__bitwise_func (gint v1, gint v2, gpointer self);
Number* number_xor (Number* self, Number* y);
static gint __lambda6_ (Number* self, gint v1, gint v2);
static gint ___lambda6__bitwise_func (gint v1, gint v2, gpointer self);
Number* number_not (Number* self, gint wordlen);
static gint __lambda7_ (Number* self, gint v1, gint v2);
static gint ___lambda7__bitwise_func (gint v1, gint v2, gpointer self);
Number* number_mask (Number* self, Number* x, gint wordlen);
static gchar* number_to_hex_string (Number* self);
Number* mp_set_from_string (const gchar* str, gint default_base);
Number* number_shift (Number* self, gint count);
Number* number_ones_complement (Number* self, gint wordlen);
static gint __lambda8_ (Number* self, gint v1, gint v2);
static gint ___lambda8__bitwise_func (gint v1, gint v2, gpointer self);
Number* number_twos_complement (Number* self, gint wordlen);
GList* number_factorize (Number* self);
GList* number_factorize_uint64 (Number* self, guint64 n);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static gboolean _mpc_equal (const __mpc_struct * s1, const __mpc_struct * s2);
static gint number_hex_to_int (Number* self, gchar digit);
GType serializer_get_type (void) G_GNUC_CONST;
GType display_format_get_type (void) G_GNUC_CONST;
Serializer* serializer_new (DisplayFormat format, gint number_base, gint trailing_digits);
Serializer* serializer_construct (GType object_type, DisplayFormat format, gint number_base, gint trailing_digits);
gchar* serializer_to_string (Serializer* self, Number* x);
void number_set_precision (mpfr_prec_t value);
static void number_finalize (GObject * obj);
static void _vala_number_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_number_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
Number* set_from_sexagesimal (const gchar* str);
gint char_val (gunichar c, gint number_base);
gboolean mp_is_overflow (Number* x, gint wordlen);


GType angle_unit_get_type (void) {
	static volatile gsize angle_unit_type_id__volatile = 0;
	if (g_once_init_enter (&angle_unit_type_id__volatile)) {
		static const GEnumValue values[] = {{ANGLE_UNIT_RADIANS, "ANGLE_UNIT_RADIANS", "radians"}, {ANGLE_UNIT_DEGREES, "ANGLE_UNIT_DEGREES", "degrees"}, {ANGLE_UNIT_GRADIANS, "ANGLE_UNIT_GRADIANS", "gradians"}, {0, NULL, NULL}};
		GType angle_unit_type_id;
		angle_unit_type_id = g_enum_register_static ("AngleUnit", values);
		g_once_init_leave (&angle_unit_type_id__volatile, angle_unit_type_id);
	}
	return angle_unit_type_id__volatile;
}


Number* number_construct_integer (GType object_type, gint64 real, gint64 imag) {
	Number * self = NULL;
	gint64 _tmp0_;
	gint64 _tmp1_;
	self = (Number*) g_object_new (object_type, NULL);
	_tmp0_ = real;
	_tmp1_ = imag;
	mpc_set_si_si (&self->priv->num, (glong) _tmp0_, (glong) _tmp1_, MPC_RNDNN);
	return self;
}


Number* number_new_integer (gint64 real, gint64 imag) {
	return number_construct_integer (TYPE_NUMBER, real, imag);
}


Number* number_construct_unsigned_integer (GType object_type, guint64 real, guint64 imag) {
	Number * self = NULL;
	guint64 _tmp0_;
	guint64 _tmp1_;
	self = (Number*) g_object_new (object_type, NULL);
	_tmp0_ = real;
	_tmp1_ = imag;
	mpc_set_ui_ui (&self->priv->num, (gulong) _tmp0_, (gulong) _tmp1_, MPC_RNDNN);
	return self;
}


Number* number_new_unsigned_integer (guint64 real, guint64 imag) {
	return number_construct_unsigned_integer (TYPE_NUMBER, real, imag);
}


Number* number_construct_fraction (GType object_type, gint64 numerator, gint64 denominator) {
	Number * self = NULL;
	gint64 _tmp0_;
	gint64 _tmp3_;
	gint64 _tmp4_;
	_tmp0_ = denominator;
	if (_tmp0_ < ((gint64) 0)) {
		gint64 _tmp1_;
		gint64 _tmp2_;
		_tmp1_ = numerator;
		numerator = -_tmp1_;
		_tmp2_ = denominator;
		denominator = -_tmp2_;
	}
	_tmp3_ = numerator;
	self = (Number*) number_construct_integer (object_type, _tmp3_, (gint64) 0);
	_tmp4_ = denominator;
	if (_tmp4_ != ((gint64) 1)) {
		gint64 _tmp5_;
		_tmp5_ = denominator;
		mpc_div_ui (&self->priv->num, &self->priv->num, (gulong) ((glong) _tmp5_), MPC_RNDNN);
	}
	return self;
}


Number* number_new_fraction (gint64 numerator, gint64 denominator) {
	return number_construct_fraction (TYPE_NUMBER, numerator, denominator);
}


static gint mpc_set_mpreal (__mpc_struct *self, __mpfr_struct* re, __mpfr_struct* im, mpc_rnd_t rnd) {
	gint result = 0;
	mpc_rnd_t _tmp3_;
	__mpfr_struct _tmp4_;
	__mpfr_struct _tmp5_;
	gint _tmp6_;
	g_return_val_if_fail (re != NULL, 0);
	if (im == NULL) {
		mpc_rnd_t _tmp0_;
		__mpfr_struct _tmp1_;
		gint _tmp2_;
		_tmp0_ = rnd;
		_tmp1_ = *re;
		_tmp2_ = mpc_set_fr (&(*self), &_tmp1_, _tmp0_);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = rnd;
	_tmp4_ = *re;
	_tmp5_ = *im;
	_tmp6_ = mpc_set_fr_fr (&(*self), &_tmp4_, &_tmp5_, _tmp3_);
	result = _tmp6_;
	return result;
}


Number* number_construct_mpreal (GType object_type, __mpfr_struct* real, __mpfr_struct* imag) {
	Number * self = NULL;
	__mpfr_struct _tmp0_;
	g_return_val_if_fail (real != NULL, NULL);
	self = (Number*) g_object_new (object_type, NULL);
	_tmp0_ = *real;
	mpc_set_mpreal (&self->priv->num, &_tmp0_, imag, MPC_RNDNN);
	return self;
}


Number* number_new_mpreal (__mpfr_struct* real, __mpfr_struct* imag) {
	return number_construct_mpreal (TYPE_NUMBER, real, imag);
}


Number* number_construct_double (GType object_type, gdouble real, gdouble imag) {
	Number * self = NULL;
	gdouble _tmp0_;
	gdouble _tmp1_;
	self = (Number*) g_object_new (object_type, NULL);
	_tmp0_ = real;
	_tmp1_ = imag;
	mpc_set_d_d (&self->priv->num, _tmp0_, _tmp1_, MPC_RNDNN);
	return self;
}


Number* number_new_double (gdouble real, gdouble imag) {
	return number_construct_double (TYPE_NUMBER, real, imag);
}


Number* number_construct_complex (GType object_type, Number* r, Number* i) {
	Number * self = NULL;
	Number* _tmp0_;
	MPFRRealRef* _tmp1_;
	Number* _tmp2_;
	MPFRRealRef* _tmp3_;
	g_return_val_if_fail (r != NULL, NULL);
	g_return_val_if_fail (i != NULL, NULL);
	self = (Number*) g_object_new (object_type, NULL);
	_tmp0_ = r;
	_tmp1_ = mpc_realref (&_tmp0_->priv->num);
	_tmp2_ = i;
	_tmp3_ = mpc_realref (&_tmp2_->priv->num);
	mpc_set_mpreal (&self->priv->num, &_tmp1_->val, &_tmp3_->val, MPC_RNDNN);
	return self;
}


Number* number_new_complex (Number* r, Number* i) {
	return number_construct_complex (TYPE_NUMBER, r, i);
}


Number* number_construct_polar (GType object_type, Number* r, Number* theta, AngleUnit unit) {
	Number * self = NULL;
	Number* x = NULL;
	Number* _tmp0_;
	AngleUnit _tmp1_;
	Number* _tmp2_;
	Number* y = NULL;
	Number* _tmp3_;
	AngleUnit _tmp4_;
	Number* _tmp5_;
	Number* _tmp6_;
	Number* _tmp7_;
	Number* _tmp8_;
	Number* _tmp9_;
	Number* _tmp10_;
	Number* _tmp11_;
	g_return_val_if_fail (r != NULL, NULL);
	g_return_val_if_fail (theta != NULL, NULL);
	_tmp0_ = theta;
	_tmp1_ = unit;
	_tmp2_ = number_cos (_tmp0_, _tmp1_);
	x = _tmp2_;
	_tmp3_ = theta;
	_tmp4_ = unit;
	_tmp5_ = number_sin (_tmp3_, _tmp4_);
	y = _tmp5_;
	_tmp6_ = r;
	_tmp7_ = number_multiply (x, _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = r;
	_tmp10_ = number_multiply (y, _tmp9_);
	_tmp11_ = _tmp10_;
	self = (Number*) number_construct_complex (object_type, _tmp8_, _tmp11_);
	_g_object_unref0 (_tmp11_);
	_g_object_unref0 (_tmp8_);
	_g_object_unref0 (y);
	_g_object_unref0 (x);
	return self;
}


Number* number_new_polar (Number* r, Number* theta, AngleUnit unit) {
	return number_construct_polar (TYPE_NUMBER, r, theta, unit);
}


Number* number_construct_eulers (GType object_type) {
	Number * self = NULL;
	MPFRRealRef* _tmp0_;
	MPFRRealRef* _tmp1_;
	MPFRRealRef* _tmp2_;
	MPFRRealRef* _tmp3_;
	self = (Number*) g_object_new (object_type, NULL);
	_tmp0_ = mpc_realref (&self->priv->num);
	mpfr_set_ui (&_tmp0_->val, (gulong) 1, MPFR_RNDN);
	_tmp1_ = mpc_realref (&self->priv->num);
	_tmp2_ = mpc_realref (&self->priv->num);
	mpfr_exp (&_tmp1_->val, &_tmp2_->val, MPFR_RNDN);
	_tmp3_ = mpc_imagref (&self->priv->num);
	mpfr_set_zero (&_tmp3_->val, MPFR_RNDN);
	return self;
}


Number* number_new_eulers (void) {
	return number_construct_eulers (TYPE_NUMBER);
}


Number* number_construct_i (GType object_type) {
	Number * self = NULL;
	self = (Number*) g_object_new (object_type, NULL);
	mpc_set_si_si (&self->priv->num, (glong) 0, (glong) 1, MPC_RNDNN);
	return self;
}


Number* number_new_i (void) {
	return number_construct_i (TYPE_NUMBER);
}


Number* number_construct_pi (GType object_type) {
	Number * self = NULL;
	MPFRRealRef* _tmp0_;
	MPFRRealRef* _tmp1_;
	self = (Number*) g_object_new (object_type, NULL);
	_tmp0_ = mpc_realref (&self->priv->num);
	mpfr_const_pi (&_tmp0_->val, MPFR_RNDN);
	_tmp1_ = mpc_imagref (&self->priv->num);
	mpfr_set_zero (&_tmp1_->val, MPFR_RNDN);
	return self;
}


Number* number_new_pi (void) {
	return number_construct_pi (TYPE_NUMBER);
}


Number* number_construct_random (GType object_type) {
	Number * self = NULL;
	gdouble _tmp0_;
	_tmp0_ = g_random_double ();
	self = (Number*) number_construct_double (object_type, _tmp0_, (gdouble) 0);
	return self;
}


Number* number_new_random (void) {
	return number_construct_random (TYPE_NUMBER);
}


gint64 number_to_integer (Number* self) {
	gint64 result = 0LL;
	MPFRRealRef* _tmp0_;
	glong _tmp1_;
	g_return_val_if_fail (self != NULL, 0LL);
	_tmp0_ = mpc_realref (&self->priv->num);
	_tmp1_ = mpfr_get_si (&_tmp0_->val, MPFR_RNDN);
	result = (gint64) _tmp1_;
	return result;
}


guint64 number_to_unsigned_integer (Number* self) {
	guint64 result = 0ULL;
	MPFRRealRef* _tmp0_;
	gulong _tmp1_;
	g_return_val_if_fail (self != NULL, 0ULL);
	_tmp0_ = mpc_realref (&self->priv->num);
	_tmp1_ = mpfr_get_ui (&_tmp0_->val, MPFR_RNDN);
	result = (guint64) _tmp1_;
	return result;
}


gfloat number_to_float (Number* self) {
	gfloat result = 0.0F;
	MPFRRealRef* _tmp0_;
	gfloat _tmp1_;
	g_return_val_if_fail (self != NULL, 0.0F);
	_tmp0_ = mpc_realref (&self->priv->num);
	_tmp1_ = mpfr_get_flt (&_tmp0_->val, MPFR_RNDN);
	result = _tmp1_;
	return result;
}


gdouble number_to_double (Number* self) {
	gdouble result = 0.0;
	MPFRRealRef* _tmp0_;
	gdouble _tmp1_;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = mpc_realref (&self->priv->num);
	_tmp1_ = mpfr_get_d (&_tmp0_->val, MPFR_RNDN);
	result = _tmp1_;
	return result;
}


static gboolean mpc_is_zero (__mpc_struct *self) {
	gboolean result = FALSE;
	gint res = 0;
	gint _tmp0_;
	gboolean _tmp1_ = FALSE;
	gint _tmp2_;
	gint _tmp3_;
	_tmp0_ = mpc_cmp_si_si (&(*self), (glong) 0, (glong) 0);
	res = _tmp0_;
	_tmp2_ = res;
	_tmp3_ = MPC_INEX_RE (_tmp2_);
	if (_tmp3_ == 0) {
		gint _tmp4_;
		gint _tmp5_;
		_tmp4_ = res;
		_tmp5_ = MPC_INEX_IM (_tmp4_);
		_tmp1_ = _tmp5_ == 0;
	} else {
		_tmp1_ = FALSE;
	}
	result = _tmp1_;
	return result;
}


gboolean number_is_zero (Number* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = mpc_is_zero (&self->priv->num);
	result = _tmp0_;
	return result;
}


gboolean number_is_negative (Number* self) {
	gboolean result = FALSE;
	MPFRRealRef* _tmp0_;
	gint _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = mpc_realref (&self->priv->num);
	_tmp1_ = mpfr_sgn (&_tmp0_->val);
	result = _tmp1_ < 0;
	return result;
}


gboolean number_is_integer (Number* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	MPFRRealRef* _tmp1_;
	gint _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = number_is_complex (self);
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp1_ = mpc_realref (&self->priv->num);
	_tmp2_ = mpfr_integer_p (&_tmp1_->val);
	result = _tmp2_ != 0;
	return result;
}


gboolean number_is_positive_integer (Number* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = number_is_complex (self);
	if (_tmp0_) {
		result = FALSE;
		return result;
	} else {
		gboolean _tmp1_ = FALSE;
		MPFRRealRef* _tmp2_;
		gint _tmp3_;
		_tmp2_ = mpc_realref (&self->priv->num);
		_tmp3_ = mpfr_sgn (&_tmp2_->val);
		if (_tmp3_ >= 0) {
			gboolean _tmp4_;
			_tmp4_ = number_is_integer (self);
			_tmp1_ = _tmp4_;
		} else {
			_tmp1_ = FALSE;
		}
		result = _tmp1_;
		return result;
	}
}


gboolean number_is_natural (Number* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = number_is_complex (self);
	if (_tmp0_) {
		result = FALSE;
		return result;
	} else {
		gboolean _tmp1_ = FALSE;
		MPFRRealRef* _tmp2_;
		gint _tmp3_;
		_tmp2_ = mpc_realref (&self->priv->num);
		_tmp3_ = mpfr_sgn (&_tmp2_->val);
		if (_tmp3_ > 0) {
			gboolean _tmp4_;
			_tmp4_ = number_is_integer (self);
			_tmp1_ = _tmp4_;
		} else {
			_tmp1_ = FALSE;
		}
		result = _tmp1_;
		return result;
	}
}


gboolean number_is_complex (Number* self) {
	gboolean result = FALSE;
	MPFRRealRef* _tmp0_;
	gboolean _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = mpc_imagref (&self->priv->num);
	_tmp1_ = mpfr_zero_p (&_tmp0_->val);
	result = !_tmp1_;
	return result;
}


void number_check_flags (void) {
	gint _tmp0_;
	_tmp0_ = mpfr_underflow_p ();
	if (_tmp0_ != 0) {
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		_tmp1_ = number_get_error ();
		_tmp2_ = _tmp1_;
		number_set_error (_ ("Underflow error"));
	} else {
		gint _tmp3_;
		_tmp3_ = mpfr_overflow_p ();
		if (_tmp3_ != 0) {
			const gchar* _tmp4_;
			const gchar* _tmp5_;
			_tmp4_ = number_get_error ();
			_tmp5_ = _tmp4_;
			number_set_error (_ ("Overflow error"));
		}
	}
}


static gboolean mpc_is_equal (__mpc_struct *self, __mpc_struct* c) {
	gboolean result = FALSE;
	gint res = 0;
	__mpc_struct _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gint _tmp3_;
	gint _tmp4_;
	g_return_val_if_fail (c != NULL, FALSE);
	_tmp0_ = *c;
	_tmp1_ = mpc_cmp (&(*self), &_tmp0_);
	res = _tmp1_;
	_tmp3_ = res;
	_tmp4_ = MPC_INEX_RE (_tmp3_);
	if (_tmp4_ == 0) {
		gint _tmp5_;
		gint _tmp6_;
		_tmp5_ = res;
		_tmp6_ = MPC_INEX_IM (_tmp5_);
		_tmp2_ = _tmp6_ == 0;
	} else {
		_tmp2_ = FALSE;
	}
	result = _tmp2_;
	return result;
}


gboolean number_equals (Number* self, Number* y) {
	gboolean result = FALSE;
	Number* _tmp0_;
	gboolean _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (y != NULL, FALSE);
	_tmp0_ = y;
	_tmp1_ = mpc_is_equal (&self->priv->num, &_tmp0_->priv->num);
	result = _tmp1_;
	return result;
}


gint number_compare (Number* self, Number* y) {
	gint result = 0;
	MPFRRealRef* _tmp0_;
	Number* _tmp1_;
	MPFRRealRef* _tmp2_;
	gint _tmp3_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (y != NULL, 0);
	_tmp0_ = mpc_realref (&self->priv->num);
	_tmp1_ = y;
	_tmp2_ = mpc_realref (&_tmp1_->priv->num);
	_tmp3_ = mpfr_cmp (&_tmp0_->val, &_tmp2_->val);
	result = _tmp3_;
	return result;
}


Number* number_sgn (Number* self) {
	Number* result = NULL;
	Number* z = NULL;
	MPFRRealRef* _tmp0_;
	gint _tmp1_;
	Number* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = mpc_realref (&self->priv->num);
	_tmp1_ = mpfr_sgn (&_tmp0_->val);
	_tmp2_ = number_new_integer ((gint64) _tmp1_, (gint64) 0);
	z = _tmp2_;
	result = z;
	return result;
}


Number* number_invert_sign (Number* self) {
	Number* result = NULL;
	Number* z = NULL;
	Number* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_new ();
	z = _tmp0_;
	mpc_neg (&z->priv->num, &self->priv->num, MPC_RNDNN);
	result = z;
	return result;
}


Number* number_abs (Number* self) {
	Number* result = NULL;
	Number* z = NULL;
	Number* _tmp0_;
	MPFRRealRef* _tmp1_;
	MPFRRealRef* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_new ();
	z = _tmp0_;
	_tmp1_ = mpc_imagref (&z->priv->num);
	mpfr_set_zero (&_tmp1_->val, MPFR_RNDN);
	_tmp2_ = mpc_realref (&z->priv->num);
	mpc_abs (&_tmp2_->val, &self->priv->num, MPFR_RNDN);
	result = z;
	return result;
}


Number* number_arg (Number* self, AngleUnit unit) {
	Number* result = NULL;
	gboolean _tmp0_;
	Number* z = NULL;
	Number* _tmp4_;
	Number* _tmp5_;
	MPFRRealRef* _tmp6_;
	Number* _tmp7_;
	MPFRRealRef* _tmp8_;
	Number* _tmp9_;
	Number* _tmp10_;
	AngleUnit _tmp11_;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_is_zero (self);
	if (_tmp0_) {
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		Number* _tmp3_;
		_tmp1_ = number_get_error ();
		_tmp2_ = _tmp1_;
		number_set_error (_ ("Argument not defined for zero"));
		_tmp3_ = number_new_integer ((gint64) 0, (gint64) 0);
		result = _tmp3_;
		return result;
	}
	_tmp4_ = number_new ();
	z = _tmp4_;
	_tmp5_ = z;
	_tmp6_ = mpc_imagref (&_tmp5_->priv->num);
	mpfr_set_zero (&_tmp6_->val, MPFR_RNDN);
	_tmp7_ = z;
	_tmp8_ = mpc_realref (&_tmp7_->priv->num);
	mpc_arg (&_tmp8_->val, &self->priv->num, MPFR_RNDN);
	_tmp9_ = z;
	_tmp10_ = z;
	_tmp11_ = unit;
	number_mpc_from_radians (&_tmp9_->priv->num, &_tmp10_->priv->num, _tmp11_);
	_tmp13_ = number_is_complex (self);
	if (!_tmp13_) {
		gboolean _tmp14_;
		_tmp14_ = number_is_negative (self);
		_tmp12_ = _tmp14_;
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		Number* _tmp15_;
		MPFRRealRef* _tmp16_;
		Number* _tmp17_;
		MPFRRealRef* _tmp18_;
		_tmp15_ = z;
		_tmp16_ = mpc_realref (&_tmp15_->priv->num);
		_tmp17_ = z;
		_tmp18_ = mpc_realref (&_tmp17_->priv->num);
		mpfr_abs (&_tmp16_->val, &_tmp18_->val, MPFR_RNDN);
	}
	result = z;
	return result;
}


Number* number_conjugate (Number* self) {
	Number* result = NULL;
	Number* z = NULL;
	Number* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_new ();
	z = _tmp0_;
	mpc_conj (&z->priv->num, &self->priv->num, MPC_RNDNN);
	result = z;
	return result;
}


Number* number_real_component (Number* self) {
	Number* result = NULL;
	Number* z = NULL;
	Number* _tmp0_;
	MPFRRealRef* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_new ();
	z = _tmp0_;
	_tmp1_ = mpc_realref (&self->priv->num);
	mpc_set_mpreal (&z->priv->num, &_tmp1_->val, NULL, MPC_RNDNN);
	result = z;
	return result;
}


Number* number_imaginary_component (Number* self) {
	Number* result = NULL;
	Number* z = NULL;
	Number* _tmp0_;
	MPFRRealRef* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_new ();
	z = _tmp0_;
	_tmp1_ = mpc_imagref (&self->priv->num);
	mpc_set_mpreal (&z->priv->num, &_tmp1_->val, NULL, MPC_RNDNN);
	result = z;
	return result;
}


Number* number_integer_component (Number* self) {
	Number* result = NULL;
	Number* z = NULL;
	Number* _tmp0_;
	MPFRRealRef* _tmp1_;
	MPFRRealRef* _tmp2_;
	MPFRRealRef* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_new ();
	z = _tmp0_;
	_tmp1_ = mpc_imagref (&z->priv->num);
	mpfr_set_zero (&_tmp1_->val, MPFR_RNDN);
	_tmp2_ = mpc_realref (&z->priv->num);
	_tmp3_ = mpc_realref (&self->priv->num);
	mpfr_trunc (&_tmp2_->val, &_tmp3_->val);
	result = z;
	return result;
}


Number* number_fractional_component (Number* self) {
	Number* result = NULL;
	Number* z = NULL;
	Number* _tmp0_;
	MPFRRealRef* _tmp1_;
	MPFRRealRef* _tmp2_;
	MPFRRealRef* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_new ();
	z = _tmp0_;
	_tmp1_ = mpc_imagref (&z->priv->num);
	mpfr_set_zero (&_tmp1_->val, MPFR_RNDN);
	_tmp2_ = mpc_realref (&z->priv->num);
	_tmp3_ = mpc_realref (&self->priv->num);
	mpfr_frac (&_tmp2_->val, &_tmp3_->val, MPFR_RNDN);
	result = z;
	return result;
}


Number* number_fractional_part (Number* self) {
	Number* result = NULL;
	Number* _tmp0_;
	Number* _tmp1_;
	Number* _tmp2_;
	Number* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_floor (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = number_subtract (self, _tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	result = _tmp3_;
	return result;
}


Number* number_floor (Number* self) {
	Number* result = NULL;
	Number* z = NULL;
	Number* _tmp0_;
	MPFRRealRef* _tmp1_;
	MPFRRealRef* _tmp2_;
	MPFRRealRef* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_new ();
	z = _tmp0_;
	_tmp1_ = mpc_imagref (&z->priv->num);
	mpfr_set_zero (&_tmp1_->val, MPFR_RNDN);
	_tmp2_ = mpc_realref (&z->priv->num);
	_tmp3_ = mpc_realref (&self->priv->num);
	mpfr_floor (&_tmp2_->val, &_tmp3_->val);
	result = z;
	return result;
}


Number* number_ceiling (Number* self) {
	Number* result = NULL;
	Number* z = NULL;
	Number* _tmp0_;
	MPFRRealRef* _tmp1_;
	MPFRRealRef* _tmp2_;
	MPFRRealRef* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_new ();
	z = _tmp0_;
	_tmp1_ = mpc_imagref (&z->priv->num);
	mpfr_set_zero (&_tmp1_->val, MPFR_RNDN);
	_tmp2_ = mpc_realref (&z->priv->num);
	_tmp3_ = mpc_realref (&self->priv->num);
	mpfr_ceil (&_tmp2_->val, &_tmp3_->val);
	result = z;
	return result;
}


Number* number_round (Number* self) {
	Number* result = NULL;
	Number* z = NULL;
	Number* _tmp0_;
	MPFRRealRef* _tmp1_;
	MPFRRealRef* _tmp2_;
	MPFRRealRef* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_new ();
	z = _tmp0_;
	_tmp1_ = mpc_imagref (&z->priv->num);
	mpfr_set_zero (&_tmp1_->val, MPFR_RNDN);
	_tmp2_ = mpc_realref (&z->priv->num);
	_tmp3_ = mpc_realref (&self->priv->num);
	mpfr_round (&_tmp2_->val, &_tmp3_->val);
	result = z;
	return result;
}


Number* number_reciprocal (Number* self) {
	Number* result = NULL;
	Number* z = NULL;
	Number* _tmp0_;
	MPFRRealRef* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_new ();
	z = _tmp0_;
	mpc_set_si_si (&z->priv->num, (glong) 1, (glong) 0, MPC_RNDNN);
	_tmp1_ = mpc_realref (&z->priv->num);
	mpc_fr_div (&z->priv->num, &_tmp1_->val, &self->priv->num, MPC_RNDNN);
	result = z;
	return result;
}


Number* number_epowy (Number* self) {
	Number* result = NULL;
	Number* z = NULL;
	Number* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_new ();
	z = _tmp0_;
	mpc_exp (&z->priv->num, &self->priv->num, MPC_RNDNN);
	result = z;
	return result;
}


Number* number_xpowy (Number* self, Number* y) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_ = FALSE;
	gboolean _tmp16_;
	Number* z = NULL;
	Number* _tmp28_;
	Number* _tmp29_;
	Number* _tmp30_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (y != NULL, NULL);
	_tmp1_ = number_is_zero (self);
	if (_tmp1_) {
		Number* _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = y;
		_tmp3_ = number_is_negative (_tmp2_);
		_tmp0_ = _tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		Number* _tmp6_;
		_tmp4_ = number_get_error ();
		_tmp5_ = _tmp4_;
		number_set_error (_ ("The power of zero is undefined for a negative exponent"));
		_tmp6_ = number_new_integer ((gint64) 0, (gint64) 0);
		result = _tmp6_;
		return result;
	}
	_tmp8_ = number_is_zero (self);
	if (_tmp8_) {
		Number* _tmp9_;
		gboolean _tmp10_;
		_tmp9_ = y;
		_tmp10_ = number_is_zero (_tmp9_);
		_tmp7_ = _tmp10_;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		Number* _tmp13_;
		_tmp11_ = number_get_error ();
		_tmp12_ = _tmp11_;
		number_set_error (_ ("Zero raised to zero is undefined"));
		_tmp13_ = number_new_integer ((gint64) 0, (gint64) 0);
		result = _tmp13_;
		return result;
	}
	_tmp16_ = number_is_complex (self);
	if (!_tmp16_) {
		Number* _tmp17_;
		gboolean _tmp18_;
		_tmp17_ = y;
		_tmp18_ = number_is_complex (_tmp17_);
		_tmp15_ = !_tmp18_;
	} else {
		_tmp15_ = FALSE;
	}
	if (_tmp15_) {
		Number* _tmp19_;
		gboolean _tmp20_;
		_tmp19_ = y;
		_tmp20_ = number_is_integer (_tmp19_);
		_tmp14_ = !_tmp20_;
	} else {
		_tmp14_ = FALSE;
	}
	if (_tmp14_) {
		Number* reciprocal = NULL;
		Number* _tmp21_;
		Number* _tmp22_;
		Number* _tmp23_;
		gboolean _tmp24_;
		_tmp21_ = y;
		_tmp22_ = number_reciprocal (_tmp21_);
		reciprocal = _tmp22_;
		_tmp23_ = reciprocal;
		_tmp24_ = number_is_integer (_tmp23_);
		if (_tmp24_) {
			Number* _tmp25_;
			gint64 _tmp26_;
			Number* _tmp27_;
			_tmp25_ = reciprocal;
			_tmp26_ = number_to_integer (_tmp25_);
			_tmp27_ = number_root (self, _tmp26_);
			result = _tmp27_;
			_g_object_unref0 (reciprocal);
			return result;
		}
		_g_object_unref0 (reciprocal);
	}
	_tmp28_ = number_new ();
	z = _tmp28_;
	_tmp29_ = z;
	_tmp30_ = y;
	mpc_pow (&_tmp29_->priv->num, &self->priv->num, &_tmp30_->priv->num, MPC_RNDNN);
	result = z;
	return result;
}


Number* number_xpowy_integer (Number* self, gint64 n) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_;
	Number* z = NULL;
	Number* _tmp12_;
	Number* _tmp13_;
	gint64 _tmp14_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = number_is_zero (self);
	if (_tmp1_) {
		gint64 _tmp2_;
		_tmp2_ = n;
		_tmp0_ = _tmp2_ < ((gint64) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		Number* _tmp5_;
		_tmp3_ = number_get_error ();
		_tmp4_ = _tmp3_;
		number_set_error (_ ("The power of zero is undefined for a negative exponent"));
		_tmp5_ = number_new_integer ((gint64) 0, (gint64) 0);
		result = _tmp5_;
		return result;
	}
	_tmp7_ = number_is_zero (self);
	if (_tmp7_) {
		gint64 _tmp8_;
		_tmp8_ = n;
		_tmp6_ = _tmp8_ == ((gint64) 0);
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		Number* _tmp11_;
		_tmp9_ = number_get_error ();
		_tmp10_ = _tmp9_;
		number_set_error (_ ("Zero raised to zero is undefined"));
		_tmp11_ = number_new_integer ((gint64) 0, (gint64) 0);
		result = _tmp11_;
		return result;
	}
	_tmp12_ = number_new ();
	z = _tmp12_;
	_tmp13_ = z;
	_tmp14_ = n;
	mpc_pow_si (&_tmp13_->priv->num, &self->priv->num, (glong) _tmp14_, MPC_RNDNN);
	result = z;
	return result;
}


Number* number_root (Number* self, gint64 n) {
	Number* result = NULL;
	guint64 p = 0ULL;
	Number* z = NULL;
	Number* _tmp0_;
	gint64 _tmp1_;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp12_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_new ();
	z = _tmp0_;
	_tmp1_ = n;
	if (_tmp1_ < ((gint64) 0)) {
		Number* _tmp2_;
		gint64 _tmp3_;
		_tmp2_ = z;
		mpc_ui_div (&_tmp2_->priv->num, (gulong) 1, &self->priv->num, MPC_RNDNN);
		_tmp3_ = n;
		if (_tmp3_ == G_MININT64) {
			p = ((guint64) G_MAXINT64) + 1;
		} else {
			gint64 _tmp4_;
			_tmp4_ = n;
			p = (guint64) (-_tmp4_);
		}
	} else {
		gint64 _tmp5_;
		_tmp5_ = n;
		if (_tmp5_ > ((gint64) 0)) {
			Number* _tmp6_;
			gint64 _tmp7_;
			_tmp6_ = z;
			mpc_set (&_tmp6_->priv->num, &self->priv->num, MPC_RNDNN);
			_tmp7_ = n;
			p = (guint64) _tmp7_;
		} else {
			const gchar* _tmp8_;
			const gchar* _tmp9_;
			Number* _tmp10_;
			_tmp8_ = number_get_error ();
			_tmp9_ = _tmp8_;
			number_set_error (_ ("The zeroth root of a number is undefined"));
			_tmp10_ = number_new_integer ((gint64) 0, (gint64) 0);
			result = _tmp10_;
			_g_object_unref0 (z);
			return result;
		}
	}
	_tmp12_ = number_is_complex (self);
	if (!_tmp12_) {
		gboolean _tmp13_ = FALSE;
		gboolean _tmp14_;
		_tmp14_ = number_is_negative (self);
		if (!_tmp14_) {
			_tmp13_ = TRUE;
		} else {
			guint64 _tmp15_;
			_tmp15_ = p;
			_tmp13_ = (_tmp15_ & 1) == ((guint64) 1);
		}
		_tmp11_ = _tmp13_;
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		Number* _tmp16_;
		MPFRRealRef* _tmp17_;
		Number* _tmp18_;
		MPFRRealRef* _tmp19_;
		guint64 _tmp20_;
		Number* _tmp21_;
		MPFRRealRef* _tmp22_;
		_tmp16_ = z;
		_tmp17_ = mpc_realref (&_tmp16_->priv->num);
		_tmp18_ = z;
		_tmp19_ = mpc_realref (&_tmp18_->priv->num);
		_tmp20_ = p;
		mpfr_root (&_tmp17_->val, &_tmp19_->val, (gulong) _tmp20_, MPFR_RNDN);
		_tmp21_ = z;
		_tmp22_ = mpc_imagref (&_tmp21_->priv->num);
		mpfr_set_zero (&_tmp22_->val, MPFR_RNDN);
	} else {
		__mpfr_struct tmp = {0};
		mpfr_prec_t _tmp23_;
		mpfr_prec_t _tmp24_;
		guint64 _tmp25_;
		Number* _tmp26_;
		Number* _tmp27_;
		_tmp23_ = number_get_precision ();
		_tmp24_ = _tmp23_;
		mpfr_init2 (&tmp, _tmp24_);
		_tmp25_ = p;
		mpfr_set_ui (&tmp, (gulong) _tmp25_, MPFR_RNDN);
		mpfr_ui_div (&tmp, (gulong) 1, &tmp, MPFR_RNDN);
		_tmp26_ = z;
		_tmp27_ = z;
		mpc_pow_fr (&_tmp26_->priv->num, &_tmp27_->priv->num, &tmp, MPC_RNDNN);
		mpfr_clear (&tmp);
	}
	result = z;
	return result;
}


Number* number_sqrt (Number* self) {
	Number* result = NULL;
	Number* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_root (self, (gint64) 2);
	result = _tmp0_;
	return result;
}


Number* number_ln (Number* self) {
	Number* result = NULL;
	gboolean _tmp0_;
	Number* z = NULL;
	Number* _tmp4_;
	Number* _tmp5_;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_is_zero (self);
	if (_tmp0_) {
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		Number* _tmp3_;
		_tmp1_ = number_get_error ();
		_tmp2_ = _tmp1_;
		number_set_error (_ ("Logarithm of zero is undefined"));
		_tmp3_ = number_new_integer ((gint64) 0, (gint64) 0);
		result = _tmp3_;
		return result;
	}
	_tmp4_ = number_new ();
	z = _tmp4_;
	_tmp5_ = z;
	mpc_log (&_tmp5_->priv->num, &self->priv->num, MPC_RNDNN);
	_tmp7_ = number_is_complex (self);
	if (!_tmp7_) {
		gboolean _tmp8_;
		_tmp8_ = number_is_negative (self);
		_tmp6_ = _tmp8_;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		Number* _tmp9_;
		MPFRRealRef* _tmp10_;
		Number* _tmp11_;
		MPFRRealRef* _tmp12_;
		_tmp9_ = z;
		_tmp10_ = mpc_imagref (&_tmp9_->priv->num);
		_tmp11_ = z;
		_tmp12_ = mpc_imagref (&_tmp11_->priv->num);
		mpfr_abs (&_tmp10_->val, &_tmp12_->val, MPFR_RNDN);
	}
	result = z;
	return result;
}


Number* number_logarithm (Number* self, gint64 n) {
	Number* result = NULL;
	gboolean _tmp0_;
	Number* t1 = NULL;
	gint64 _tmp4_;
	Number* _tmp5_;
	Number* _tmp6_;
	Number* _tmp7_;
	Number* _tmp8_;
	Number* _tmp9_;
	Number* _tmp10_;
	Number* _tmp11_;
	Number* _tmp12_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_is_zero (self);
	if (_tmp0_) {
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		Number* _tmp3_;
		_tmp1_ = number_get_error ();
		_tmp2_ = _tmp1_;
		number_set_error (_ ("Logarithm of zero is undefined"));
		_tmp3_ = number_new_integer ((gint64) 0, (gint64) 0);
		result = _tmp3_;
		return result;
	}
	_tmp4_ = n;
	_tmp5_ = number_new_integer (_tmp4_, (gint64) 0);
	t1 = _tmp5_;
	_tmp6_ = number_ln (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = t1;
	_tmp9_ = number_ln (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = number_divide (_tmp7_, _tmp10_);
	_tmp12_ = _tmp11_;
	_g_object_unref0 (_tmp10_);
	_g_object_unref0 (_tmp7_);
	result = _tmp12_;
	_g_object_unref0 (t1);
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


Number* number_factorial (Number* self) {
	Number* result = NULL;
	gboolean _tmp0_;
	gboolean _tmp2_;
	gint64 value = 0LL;
	gint64 _tmp18_;
	Number* z = NULL;
	Number* _tmp19_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_is_zero (self);
	if (_tmp0_) {
		Number* _tmp1_;
		_tmp1_ = number_new_integer ((gint64) 1, (gint64) 0);
		result = _tmp1_;
		return result;
	}
	_tmp2_ = number_is_natural (self);
	if (!_tmp2_) {
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_;
		Number* tmp = NULL;
		Number* _tmp9_;
		Number* _tmp10_;
		Number* _tmp11_;
		Number* _tmp12_;
		__mpfr_struct tmp2 = {0};
		mpfr_prec_t _tmp13_;
		mpfr_prec_t _tmp14_;
		Number* _tmp15_;
		MPFRRealRef* _tmp16_;
		Number* _tmp17_;
		_tmp4_ = number_is_negative (self);
		if (_tmp4_) {
			_tmp3_ = TRUE;
		} else {
			gboolean _tmp5_;
			_tmp5_ = number_is_complex (self);
			_tmp3_ = _tmp5_;
		}
		if (_tmp3_) {
			const gchar* _tmp6_;
			const gchar* _tmp7_;
			Number* _tmp8_;
			_tmp6_ = number_get_error ();
			_tmp7_ = _tmp6_;
			number_set_error (_ ("Factorial is only defined for non-negative real numbers"));
			_tmp8_ = number_new_integer ((gint64) 0, (gint64) 0);
			result = _tmp8_;
			return result;
		}
		_tmp9_ = number_new_integer ((gint64) 1, (gint64) 0);
		_tmp10_ = _tmp9_;
		_tmp11_ = number_add (self, _tmp10_);
		_tmp12_ = _tmp11_;
		_g_object_unref0 (_tmp10_);
		tmp = _tmp12_;
		_tmp13_ = number_get_precision ();
		_tmp14_ = _tmp13_;
		mpfr_init2 (&tmp2, _tmp14_);
		_tmp15_ = tmp;
		_tmp16_ = mpc_realref (&_tmp15_->priv->num);
		mpfr_gamma (&tmp2, &_tmp16_->val, MPFR_RNDN);
		_tmp17_ = number_new_mpreal (&tmp2, NULL);
		result = _tmp17_;
		mpfr_clear (&tmp2);
		_g_object_unref0 (tmp);
		return result;
	}
	_tmp18_ = number_to_integer (self);
	value = _tmp18_;
	_tmp19_ = _g_object_ref0 (self);
	z = _tmp19_;
	{
		gint i = 0;
		i = 2;
		{
			gboolean _tmp20_ = FALSE;
			_tmp20_ = TRUE;
			while (TRUE) {
				gint _tmp22_;
				gint64 _tmp23_;
				Number* _tmp24_;
				gint _tmp25_;
				Number* _tmp26_;
				if (!_tmp20_) {
					gint _tmp21_;
					_tmp21_ = i;
					i = _tmp21_ + 1;
				}
				_tmp20_ = FALSE;
				_tmp22_ = i;
				_tmp23_ = value;
				if (!(((gint64) _tmp22_) < _tmp23_)) {
					break;
				}
				_tmp24_ = z;
				_tmp25_ = i;
				_tmp26_ = number_multiply_integer (_tmp24_, (gint64) _tmp25_);
				_g_object_unref0 (z);
				z = _tmp26_;
			}
		}
	}
	result = z;
	return result;
}


Number* number_add (Number* self, Number* y) {
	Number* result = NULL;
	Number* z = NULL;
	Number* _tmp0_;
	Number* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (y != NULL, NULL);
	_tmp0_ = number_new ();
	z = _tmp0_;
	_tmp1_ = y;
	mpc_add (&z->priv->num, &self->priv->num, &_tmp1_->priv->num, MPC_RNDNN);
	result = z;
	return result;
}


Number* number_subtract (Number* self, Number* y) {
	Number* result = NULL;
	Number* z = NULL;
	Number* _tmp0_;
	Number* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (y != NULL, NULL);
	_tmp0_ = number_new ();
	z = _tmp0_;
	_tmp1_ = y;
	mpc_sub (&z->priv->num, &self->priv->num, &_tmp1_->priv->num, MPC_RNDNN);
	result = z;
	return result;
}


Number* number_multiply (Number* self, Number* y) {
	Number* result = NULL;
	Number* z = NULL;
	Number* _tmp0_;
	Number* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (y != NULL, NULL);
	_tmp0_ = number_new ();
	z = _tmp0_;
	_tmp1_ = y;
	mpc_mul (&z->priv->num, &self->priv->num, &_tmp1_->priv->num, MPC_RNDNN);
	result = z;
	return result;
}


Number* number_multiply_integer (Number* self, gint64 y) {
	Number* result = NULL;
	Number* z = NULL;
	Number* _tmp0_;
	gint64 _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_new ();
	z = _tmp0_;
	_tmp1_ = y;
	mpc_mul_si (&z->priv->num, &self->priv->num, (glong) _tmp1_, MPC_RNDNN);
	result = z;
	return result;
}


Number* number_divide (Number* self, Number* y) {
	Number* result = NULL;
	Number* _tmp0_;
	gboolean _tmp1_;
	Number* z = NULL;
	Number* _tmp5_;
	Number* _tmp6_;
	Number* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (y != NULL, NULL);
	_tmp0_ = y;
	_tmp1_ = number_is_zero (_tmp0_);
	if (_tmp1_) {
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		Number* _tmp4_;
		_tmp2_ = number_get_error ();
		_tmp3_ = _tmp2_;
		number_set_error (_ ("Division by zero is undefined"));
		_tmp4_ = number_new_integer ((gint64) 0, (gint64) 0);
		result = _tmp4_;
		return result;
	}
	_tmp5_ = number_new ();
	z = _tmp5_;
	_tmp6_ = z;
	_tmp7_ = y;
	mpc_div (&_tmp6_->priv->num, &self->priv->num, &_tmp7_->priv->num, MPC_RNDNN);
	result = z;
	return result;
}


Number* number_divide_integer (Number* self, gint64 y) {
	Number* result = NULL;
	gint64 _tmp0_;
	Number* _tmp1_;
	Number* _tmp2_;
	Number* _tmp3_;
	Number* _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = y;
	_tmp1_ = number_new_integer (_tmp0_, (gint64) 0);
	_tmp2_ = _tmp1_;
	_tmp3_ = number_divide (self, _tmp2_);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp2_);
	result = _tmp4_;
	return result;
}


Number* number_modulus_divide (Number* self, Number* y) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	Number* t1 = NULL;
	Number* _tmp7_;
	Number* _tmp8_;
	Number* _tmp9_;
	Number* _tmp10_;
	Number* _tmp11_;
	Number* t2 = NULL;
	Number* _tmp12_;
	Number* _tmp13_;
	Number* _tmp14_;
	Number* z = NULL;
	Number* _tmp15_;
	Number* _tmp16_;
	Number* _tmp17_;
	gboolean _tmp18_ = FALSE;
	gboolean _tmp19_ = FALSE;
	Number* _tmp20_;
	Number* _tmp21_;
	gint _tmp22_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (y != NULL, NULL);
	_tmp1_ = number_is_integer (self);
	if (!_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		Number* _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = y;
		_tmp3_ = number_is_integer (_tmp2_);
		_tmp0_ = !_tmp3_;
	}
	if (_tmp0_) {
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		Number* _tmp6_;
		_tmp4_ = number_get_error ();
		_tmp5_ = _tmp4_;
		number_set_error (_ ("Modulus division is only defined for integers"));
		_tmp6_ = number_new_integer ((gint64) 0, (gint64) 0);
		result = _tmp6_;
		return result;
	}
	_tmp7_ = y;
	_tmp8_ = number_divide (self, _tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = number_floor (_tmp9_);
	_tmp11_ = _tmp10_;
	_g_object_unref0 (_tmp9_);
	t1 = _tmp11_;
	_tmp12_ = t1;
	_tmp13_ = y;
	_tmp14_ = number_multiply (_tmp12_, _tmp13_);
	t2 = _tmp14_;
	_tmp15_ = t2;
	_tmp16_ = number_subtract (self, _tmp15_);
	z = _tmp16_;
	_tmp17_ = number_new_integer ((gint64) 0, (gint64) 0);
	_g_object_unref0 (t1);
	t1 = _tmp17_;
	_tmp20_ = y;
	_tmp21_ = t1;
	_tmp22_ = number_compare (_tmp20_, _tmp21_);
	if (_tmp22_ < 0) {
		Number* _tmp23_;
		Number* _tmp24_;
		gint _tmp25_;
		_tmp23_ = z;
		_tmp24_ = t1;
		_tmp25_ = number_compare (_tmp23_, _tmp24_);
		_tmp19_ = _tmp25_ > 0;
	} else {
		_tmp19_ = FALSE;
	}
	if (_tmp19_) {
		_tmp18_ = TRUE;
	} else {
		gboolean _tmp26_ = FALSE;
		Number* _tmp27_;
		Number* _tmp28_;
		gint _tmp29_;
		_tmp27_ = y;
		_tmp28_ = t1;
		_tmp29_ = number_compare (_tmp27_, _tmp28_);
		if (_tmp29_ > 0) {
			Number* _tmp30_;
			Number* _tmp31_;
			gint _tmp32_;
			_tmp30_ = z;
			_tmp31_ = t1;
			_tmp32_ = number_compare (_tmp30_, _tmp31_);
			_tmp26_ = _tmp32_ < 0;
		} else {
			_tmp26_ = FALSE;
		}
		_tmp18_ = _tmp26_;
	}
	if (_tmp18_) {
		Number* _tmp33_;
		Number* _tmp34_;
		Number* _tmp35_;
		_tmp33_ = z;
		_tmp34_ = y;
		_tmp35_ = number_add (_tmp33_, _tmp34_);
		_g_object_unref0 (z);
		z = _tmp35_;
	}
	result = z;
	_g_object_unref0 (t2);
	_g_object_unref0 (t1);
	return result;
}


Number* number_modular_exponentiation (Number* self, Number* exp, Number* mod) {
	Number* result = NULL;
	Number* base_value = NULL;
	Number* _tmp0_;
	Number* _tmp1_;
	gboolean _tmp2_;
	Number* exp_value = NULL;
	Number* _tmp5_;
	Number* _tmp6_;
	Number* ans = NULL;
	Number* _tmp7_;
	Number* two = NULL;
	Number* _tmp8_;
	Number* _tmp34_;
	Number* _tmp35_;
	Number* _tmp36_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (exp != NULL, NULL);
	g_return_val_if_fail (mod != NULL, NULL);
	_tmp0_ = number_copy (self);
	base_value = _tmp0_;
	_tmp1_ = exp;
	_tmp2_ = number_is_negative (_tmp1_);
	if (_tmp2_) {
		Number* _tmp3_;
		Number* _tmp4_;
		_tmp3_ = base_value;
		_tmp4_ = number_reciprocal (_tmp3_);
		_g_object_unref0 (base_value);
		base_value = _tmp4_;
	}
	_tmp5_ = exp;
	_tmp6_ = number_abs (_tmp5_);
	exp_value = _tmp6_;
	_tmp7_ = number_new_integer ((gint64) 1, (gint64) 0);
	ans = _tmp7_;
	_tmp8_ = number_new_integer ((gint64) 2, (gint64) 0);
	two = _tmp8_;
	while (TRUE) {
		Number* _tmp9_;
		gboolean _tmp10_;
		gboolean is_even = FALSE;
		Number* _tmp11_;
		Number* _tmp12_;
		Number* _tmp13_;
		Number* _tmp14_;
		gboolean _tmp15_;
		gboolean _tmp16_;
		gboolean _tmp17_;
		Number* _tmp24_;
		Number* _tmp25_;
		Number* _tmp26_;
		Number* _tmp27_;
		Number* _tmp28_;
		Number* _tmp29_;
		Number* _tmp30_;
		Number* _tmp31_;
		Number* _tmp32_;
		Number* _tmp33_;
		_tmp9_ = exp_value;
		_tmp10_ = number_is_zero (_tmp9_);
		if (!(!_tmp10_)) {
			break;
		}
		_tmp11_ = exp_value;
		_tmp12_ = two;
		_tmp13_ = number_modulus_divide (_tmp11_, _tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = number_is_zero (_tmp14_);
		_tmp16_ = _tmp15_;
		_g_object_unref0 (_tmp14_);
		is_even = _tmp16_;
		_tmp17_ = is_even;
		if (!_tmp17_) {
			Number* _tmp18_;
			Number* _tmp19_;
			Number* _tmp20_;
			Number* _tmp21_;
			Number* _tmp22_;
			Number* _tmp23_;
			_tmp18_ = ans;
			_tmp19_ = base_value;
			_tmp20_ = number_multiply (_tmp18_, _tmp19_);
			_g_object_unref0 (ans);
			ans = _tmp20_;
			_tmp21_ = ans;
			_tmp22_ = mod;
			_tmp23_ = number_modulus_divide (_tmp21_, _tmp22_);
			_g_object_unref0 (ans);
			ans = _tmp23_;
		}
		_tmp24_ = base_value;
		_tmp25_ = base_value;
		_tmp26_ = number_multiply (_tmp24_, _tmp25_);
		_g_object_unref0 (base_value);
		base_value = _tmp26_;
		_tmp27_ = base_value;
		_tmp28_ = mod;
		_tmp29_ = number_modulus_divide (_tmp27_, _tmp28_);
		_g_object_unref0 (base_value);
		base_value = _tmp29_;
		_tmp30_ = exp_value;
		_tmp31_ = number_divide_integer (_tmp30_, (gint64) 2);
		_tmp32_ = _tmp31_;
		_tmp33_ = number_floor (_tmp32_);
		_g_object_unref0 (exp_value);
		exp_value = _tmp33_;
		_g_object_unref0 (_tmp32_);
	}
	_tmp34_ = ans;
	_tmp35_ = mod;
	_tmp36_ = number_modulus_divide (_tmp34_, _tmp35_);
	result = _tmp36_;
	_g_object_unref0 (two);
	_g_object_unref0 (ans);
	_g_object_unref0 (exp_value);
	_g_object_unref0 (base_value);
	return result;
}


Number* number_sin (Number* self, AngleUnit unit) {
	Number* result = NULL;
	Number* z = NULL;
	Number* _tmp0_;
	gboolean _tmp1_;
	Number* _tmp5_;
	Number* _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_new ();
	z = _tmp0_;
	_tmp1_ = number_is_complex (self);
	if (_tmp1_) {
		Number* _tmp2_;
		_tmp2_ = z;
		mpc_set (&_tmp2_->priv->num, &self->priv->num, MPC_RNDNN);
	} else {
		Number* _tmp3_;
		AngleUnit _tmp4_;
		_tmp3_ = z;
		_tmp4_ = unit;
		number_mpc_to_radians (&_tmp3_->priv->num, &self->priv->num, _tmp4_);
	}
	_tmp5_ = z;
	_tmp6_ = z;
	mpc_sin (&_tmp5_->priv->num, &_tmp6_->priv->num, MPC_RNDNN);
	result = z;
	return result;
}


Number* number_cos (Number* self, AngleUnit unit) {
	Number* result = NULL;
	Number* z = NULL;
	Number* _tmp0_;
	gboolean _tmp1_;
	Number* _tmp5_;
	Number* _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_new ();
	z = _tmp0_;
	_tmp1_ = number_is_complex (self);
	if (_tmp1_) {
		Number* _tmp2_;
		_tmp2_ = z;
		mpc_set (&_tmp2_->priv->num, &self->priv->num, MPC_RNDNN);
	} else {
		Number* _tmp3_;
		AngleUnit _tmp4_;
		_tmp3_ = z;
		_tmp4_ = unit;
		number_mpc_to_radians (&_tmp3_->priv->num, &self->priv->num, _tmp4_);
	}
	_tmp5_ = z;
	_tmp6_ = z;
	mpc_cos (&_tmp5_->priv->num, &_tmp6_->priv->num, MPC_RNDNN);
	result = z;
	return result;
}


Number* number_tan (Number* self, AngleUnit unit) {
	Number* result = NULL;
	Number* x_radians = NULL;
	AngleUnit _tmp0_;
	Number* _tmp1_;
	Number* check = NULL;
	Number* _tmp2_;
	Number* _tmp3_;
	Number* _tmp4_;
	Number* _tmp5_;
	Number* _tmp6_;
	Number* _tmp7_;
	Number* _tmp8_;
	Number* _tmp9_;
	Number* _tmp10_;
	Number* _tmp11_;
	Number* _tmp12_;
	Number* _tmp13_;
	gboolean _tmp14_;
	Number* z = NULL;
	Number* _tmp18_;
	gboolean _tmp19_;
	Number* _tmp23_;
	Number* _tmp24_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = unit;
	_tmp1_ = number_to_radians (self, _tmp0_);
	x_radians = _tmp1_;
	_tmp2_ = x_radians;
	_tmp3_ = number_new_pi ();
	_tmp4_ = _tmp3_;
	_tmp5_ = number_divide_integer (_tmp4_, (gint64) 2);
	_tmp6_ = _tmp5_;
	_tmp7_ = number_subtract (_tmp2_, _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = number_new_pi ();
	_tmp10_ = _tmp9_;
	_tmp11_ = number_divide (_tmp8_, _tmp10_);
	_tmp12_ = _tmp11_;
	_g_object_unref0 (_tmp10_);
	_g_object_unref0 (_tmp8_);
	_g_object_unref0 (_tmp6_);
	_g_object_unref0 (_tmp4_);
	check = _tmp12_;
	_tmp13_ = check;
	_tmp14_ = number_is_integer (_tmp13_);
	if (_tmp14_) {
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		Number* _tmp17_;
		_tmp15_ = number_get_error ();
		_tmp16_ = _tmp15_;
		number_set_error (_ ("Tangent is undefined for angles that are multiples of π (180°) from π∕" \
"2 (90°)"));
		_tmp17_ = number_new_integer ((gint64) 0, (gint64) 0);
		result = _tmp17_;
		_g_object_unref0 (check);
		_g_object_unref0 (x_radians);
		return result;
	}
	_tmp18_ = number_new ();
	z = _tmp18_;
	_tmp19_ = number_is_complex (self);
	if (_tmp19_) {
		Number* _tmp20_;
		_tmp20_ = z;
		mpc_set (&_tmp20_->priv->num, &self->priv->num, MPC_RNDNN);
	} else {
		Number* _tmp21_;
		AngleUnit _tmp22_;
		_tmp21_ = z;
		_tmp22_ = unit;
		number_mpc_to_radians (&_tmp21_->priv->num, &self->priv->num, _tmp22_);
	}
	_tmp23_ = z;
	_tmp24_ = z;
	mpc_tan (&_tmp23_->priv->num, &_tmp24_->priv->num, MPC_RNDNN);
	result = z;
	_g_object_unref0 (check);
	_g_object_unref0 (x_radians);
	return result;
}


Number* number_asin (Number* self, AngleUnit unit) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	Number* _tmp1_;
	Number* _tmp2_;
	gint _tmp3_;
	gboolean _tmp4_;
	Number* z = NULL;
	Number* _tmp11_;
	Number* _tmp12_;
	Number* _tmp13_;
	gboolean _tmp14_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = number_new_integer ((gint64) 1, (gint64) 0);
	_tmp2_ = _tmp1_;
	_tmp3_ = number_compare (self, _tmp2_);
	_tmp4_ = _tmp3_ > 0;
	_g_object_unref0 (_tmp2_);
	if (_tmp4_) {
		_tmp0_ = TRUE;
	} else {
		Number* _tmp5_;
		Number* _tmp6_;
		gint _tmp7_;
		_tmp5_ = number_new_integer ((gint64) -1, (gint64) 0);
		_tmp6_ = _tmp5_;
		_tmp7_ = number_compare (self, _tmp6_);
		_tmp0_ = _tmp7_ < 0;
		_g_object_unref0 (_tmp6_);
	}
	if (_tmp0_) {
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		Number* _tmp10_;
		_tmp8_ = number_get_error ();
		_tmp9_ = _tmp8_;
		number_set_error (_ ("Inverse sine is undefined for values outside [-1, 1]"));
		_tmp10_ = number_new_integer ((gint64) 0, (gint64) 0);
		result = _tmp10_;
		return result;
	}
	_tmp11_ = number_new ();
	z = _tmp11_;
	_tmp12_ = z;
	mpc_asin (&_tmp12_->priv->num, &self->priv->num, MPC_RNDNN);
	_tmp13_ = z;
	_tmp14_ = number_is_complex (_tmp13_);
	if (!_tmp14_) {
		Number* _tmp15_;
		Number* _tmp16_;
		AngleUnit _tmp17_;
		_tmp15_ = z;
		_tmp16_ = z;
		_tmp17_ = unit;
		number_mpc_from_radians (&_tmp15_->priv->num, &_tmp16_->priv->num, _tmp17_);
	}
	result = z;
	return result;
}


Number* number_acos (Number* self, AngleUnit unit) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	Number* _tmp1_;
	Number* _tmp2_;
	gint _tmp3_;
	gboolean _tmp4_;
	Number* z = NULL;
	Number* _tmp11_;
	Number* _tmp12_;
	Number* _tmp13_;
	gboolean _tmp14_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = number_new_integer ((gint64) 1, (gint64) 0);
	_tmp2_ = _tmp1_;
	_tmp3_ = number_compare (self, _tmp2_);
	_tmp4_ = _tmp3_ > 0;
	_g_object_unref0 (_tmp2_);
	if (_tmp4_) {
		_tmp0_ = TRUE;
	} else {
		Number* _tmp5_;
		Number* _tmp6_;
		gint _tmp7_;
		_tmp5_ = number_new_integer ((gint64) -1, (gint64) 0);
		_tmp6_ = _tmp5_;
		_tmp7_ = number_compare (self, _tmp6_);
		_tmp0_ = _tmp7_ < 0;
		_g_object_unref0 (_tmp6_);
	}
	if (_tmp0_) {
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		Number* _tmp10_;
		_tmp8_ = number_get_error ();
		_tmp9_ = _tmp8_;
		number_set_error (_ ("Inverse cosine is undefined for values outside [-1, 1]"));
		_tmp10_ = number_new_integer ((gint64) 0, (gint64) 0);
		result = _tmp10_;
		return result;
	}
	_tmp11_ = number_new ();
	z = _tmp11_;
	_tmp12_ = z;
	mpc_acos (&_tmp12_->priv->num, &self->priv->num, MPC_RNDNN);
	_tmp13_ = z;
	_tmp14_ = number_is_complex (_tmp13_);
	if (!_tmp14_) {
		Number* _tmp15_;
		Number* _tmp16_;
		AngleUnit _tmp17_;
		_tmp15_ = z;
		_tmp16_ = z;
		_tmp17_ = unit;
		number_mpc_from_radians (&_tmp15_->priv->num, &_tmp16_->priv->num, _tmp17_);
	}
	result = z;
	return result;
}


Number* number_atan (Number* self, AngleUnit unit) {
	Number* result = NULL;
	Number* z = NULL;
	Number* _tmp0_;
	Number* _tmp1_;
	Number* _tmp2_;
	gboolean _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_new ();
	z = _tmp0_;
	_tmp1_ = z;
	mpc_atan (&_tmp1_->priv->num, &self->priv->num, MPC_RNDNN);
	_tmp2_ = z;
	_tmp3_ = number_is_complex (_tmp2_);
	if (!_tmp3_) {
		Number* _tmp4_;
		Number* _tmp5_;
		AngleUnit _tmp6_;
		_tmp4_ = z;
		_tmp5_ = z;
		_tmp6_ = unit;
		number_mpc_from_radians (&_tmp4_->priv->num, &_tmp5_->priv->num, _tmp6_);
	}
	result = z;
	return result;
}


Number* number_sinh (Number* self) {
	Number* result = NULL;
	Number* z = NULL;
	Number* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_new ();
	z = _tmp0_;
	mpc_sinh (&z->priv->num, &self->priv->num, MPC_RNDNN);
	result = z;
	return result;
}


Number* number_cosh (Number* self) {
	Number* result = NULL;
	Number* z = NULL;
	Number* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_new ();
	z = _tmp0_;
	mpc_cosh (&z->priv->num, &self->priv->num, MPC_RNDNN);
	result = z;
	return result;
}


Number* number_tanh (Number* self) {
	Number* result = NULL;
	Number* z = NULL;
	Number* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_new ();
	z = _tmp0_;
	mpc_tanh (&z->priv->num, &self->priv->num, MPC_RNDNN);
	result = z;
	return result;
}


Number* number_asinh (Number* self) {
	Number* result = NULL;
	Number* z = NULL;
	Number* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_new ();
	z = _tmp0_;
	mpc_asinh (&z->priv->num, &self->priv->num, MPC_RNDNN);
	result = z;
	return result;
}


Number* number_acosh (Number* self) {
	Number* result = NULL;
	Number* t = NULL;
	Number* _tmp0_;
	Number* _tmp1_;
	gint _tmp2_;
	Number* z = NULL;
	Number* _tmp6_;
	Number* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_new_integer ((gint64) 1, (gint64) 0);
	t = _tmp0_;
	_tmp1_ = t;
	_tmp2_ = number_compare (self, _tmp1_);
	if (_tmp2_ < 0) {
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		Number* _tmp5_;
		_tmp3_ = number_get_error ();
		_tmp4_ = _tmp3_;
		number_set_error (_ ("Inverse hyperbolic cosine is undefined for values less than one"));
		_tmp5_ = number_new_integer ((gint64) 0, (gint64) 0);
		result = _tmp5_;
		_g_object_unref0 (t);
		return result;
	}
	_tmp6_ = number_new ();
	z = _tmp6_;
	_tmp7_ = z;
	mpc_acosh (&_tmp7_->priv->num, &self->priv->num, MPC_RNDNN);
	result = z;
	_g_object_unref0 (t);
	return result;
}


Number* number_atanh (Number* self) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	Number* _tmp1_;
	Number* _tmp2_;
	gint _tmp3_;
	gboolean _tmp4_;
	Number* z = NULL;
	Number* _tmp11_;
	Number* _tmp12_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = number_new_integer ((gint64) 1, (gint64) 0);
	_tmp2_ = _tmp1_;
	_tmp3_ = number_compare (self, _tmp2_);
	_tmp4_ = _tmp3_ >= 0;
	_g_object_unref0 (_tmp2_);
	if (_tmp4_) {
		_tmp0_ = TRUE;
	} else {
		Number* _tmp5_;
		Number* _tmp6_;
		gint _tmp7_;
		_tmp5_ = number_new_integer ((gint64) -1, (gint64) 0);
		_tmp6_ = _tmp5_;
		_tmp7_ = number_compare (self, _tmp6_);
		_tmp0_ = _tmp7_ <= 0;
		_g_object_unref0 (_tmp6_);
	}
	if (_tmp0_) {
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		Number* _tmp10_;
		_tmp8_ = number_get_error ();
		_tmp9_ = _tmp8_;
		number_set_error (_ ("Inverse hyperbolic tangent is undefined for values outside [-1, 1]"));
		_tmp10_ = number_new_integer ((gint64) 0, (gint64) 0);
		result = _tmp10_;
		return result;
	}
	_tmp11_ = number_new ();
	z = _tmp11_;
	_tmp12_ = z;
	mpc_atanh (&_tmp12_->priv->num, &self->priv->num, MPC_RNDNN);
	result = z;
	return result;
}


static gint __lambda4_ (Number* self, gint v1, gint v2) {
	gint result = 0;
	gint _tmp0_;
	gint _tmp1_;
	_tmp0_ = v1;
	_tmp1_ = v2;
	result = _tmp0_ & _tmp1_;
	return result;
}


static gint ___lambda4__bitwise_func (gint v1, gint v2, gpointer self) {
	gint result;
	result = __lambda4_ ((Number*) self, v1, v2);
	return result;
}


Number* number_and (Number* self, Number* y) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	Number* _tmp6_;
	Number* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (y != NULL, NULL);
	_tmp1_ = number_is_positive_integer (self);
	if (!_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		Number* _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = y;
		_tmp3_ = number_is_positive_integer (_tmp2_);
		_tmp0_ = !_tmp3_;
	}
	if (_tmp0_) {
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		_tmp4_ = number_get_error ();
		_tmp5_ = _tmp4_;
		number_set_error (_ ("Boolean AND is only defined for positive integers"));
	}
	_tmp6_ = y;
	_tmp7_ = number_bitwise (self, _tmp6_, ___lambda4__bitwise_func, self, 0);
	result = _tmp7_;
	return result;
}


static gint __lambda5_ (Number* self, gint v1, gint v2) {
	gint result = 0;
	gint _tmp0_;
	gint _tmp1_;
	_tmp0_ = v1;
	_tmp1_ = v2;
	result = _tmp0_ | _tmp1_;
	return result;
}


static gint ___lambda5__bitwise_func (gint v1, gint v2, gpointer self) {
	gint result;
	result = __lambda5_ ((Number*) self, v1, v2);
	return result;
}


Number* number_or (Number* self, Number* y) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	Number* _tmp6_;
	Number* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (y != NULL, NULL);
	_tmp1_ = number_is_positive_integer (self);
	if (!_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		Number* _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = y;
		_tmp3_ = number_is_positive_integer (_tmp2_);
		_tmp0_ = !_tmp3_;
	}
	if (_tmp0_) {
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		_tmp4_ = number_get_error ();
		_tmp5_ = _tmp4_;
		number_set_error (_ ("Boolean OR is only defined for positive integers"));
	}
	_tmp6_ = y;
	_tmp7_ = number_bitwise (self, _tmp6_, ___lambda5__bitwise_func, self, 0);
	result = _tmp7_;
	return result;
}


static gint __lambda6_ (Number* self, gint v1, gint v2) {
	gint result = 0;
	gint _tmp0_;
	gint _tmp1_;
	_tmp0_ = v1;
	_tmp1_ = v2;
	result = _tmp0_ ^ _tmp1_;
	return result;
}


static gint ___lambda6__bitwise_func (gint v1, gint v2, gpointer self) {
	gint result;
	result = __lambda6_ ((Number*) self, v1, v2);
	return result;
}


Number* number_xor (Number* self, Number* y) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	Number* _tmp6_;
	Number* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (y != NULL, NULL);
	_tmp1_ = number_is_positive_integer (self);
	if (!_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		Number* _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = y;
		_tmp3_ = number_is_positive_integer (_tmp2_);
		_tmp0_ = !_tmp3_;
	}
	if (_tmp0_) {
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		_tmp4_ = number_get_error ();
		_tmp5_ = _tmp4_;
		number_set_error (_ ("Boolean XOR is only defined for positive integers"));
	}
	_tmp6_ = y;
	_tmp7_ = number_bitwise (self, _tmp6_, ___lambda6__bitwise_func, self, 0);
	result = _tmp7_;
	return result;
}


static gint __lambda7_ (Number* self, gint v1, gint v2) {
	gint result = 0;
	gint _tmp0_;
	_tmp0_ = v1;
	result = _tmp0_ ^ 0xF;
	return result;
}


static gint ___lambda7__bitwise_func (gint v1, gint v2, gpointer self) {
	gint result;
	result = __lambda7_ ((Number*) self, v1, v2);
	return result;
}


Number* number_not (Number* self, gint wordlen) {
	Number* result = NULL;
	gboolean _tmp0_;
	Number* _tmp3_;
	Number* _tmp4_;
	gint _tmp5_;
	Number* _tmp6_;
	Number* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_is_positive_integer (self);
	if (!_tmp0_) {
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		_tmp1_ = number_get_error ();
		_tmp2_ = _tmp1_;
		number_set_error (_ ("Boolean NOT is only defined for positive integers"));
	}
	_tmp3_ = number_new_integer ((gint64) 0, (gint64) 0);
	_tmp4_ = _tmp3_;
	_tmp5_ = wordlen;
	_tmp6_ = number_bitwise (self, _tmp4_, ___lambda7__bitwise_func, self, _tmp5_);
	_tmp7_ = _tmp6_;
	_g_object_unref0 (_tmp4_);
	result = _tmp7_;
	return result;
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	glong _tmp8_;
	glong _tmp14_;
	glong _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	gchar* _tmp22_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp3_;
		glong _tmp4_;
		glong _tmp5_;
		_tmp3_ = offset;
		_tmp4_ = len;
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
		string_length = _tmp5_;
	} else {
		gint _tmp6_;
		gint _tmp7_;
		_tmp6_ = strlen (self);
		_tmp7_ = _tmp6_;
		string_length = (glong) _tmp7_;
	}
	_tmp8_ = offset;
	if (_tmp8_ < ((glong) 0)) {
		glong _tmp9_;
		glong _tmp10_;
		glong _tmp11_;
		_tmp9_ = string_length;
		_tmp10_ = offset;
		offset = _tmp9_ + _tmp10_;
		_tmp11_ = offset;
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
	} else {
		glong _tmp12_;
		glong _tmp13_;
		_tmp12_ = offset;
		_tmp13_ = string_length;
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
	}
	_tmp14_ = len;
	if (_tmp14_ < ((glong) 0)) {
		glong _tmp15_;
		glong _tmp16_;
		_tmp15_ = string_length;
		_tmp16_ = offset;
		len = _tmp15_ - _tmp16_;
	}
	_tmp17_ = offset;
	_tmp18_ = len;
	_tmp19_ = string_length;
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
	_tmp20_ = offset;
	_tmp21_ = len;
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
	result = _tmp22_;
	return result;
}


Number* number_mask (Number* self, Number* x, gint wordlen) {
	Number* result = NULL;
	gchar* text = NULL;
	Number* _tmp0_;
	gchar* _tmp1_;
	gint len = 0;
	const gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint offset = 0;
	gint _tmp5_;
	gint _tmp6_ = 0;
	gint _tmp7_;
	gint _tmp8_;
	const gchar* _tmp11_;
	gint _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	Number* _tmp15_;
	Number* _tmp16_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (x != NULL, NULL);
	_tmp0_ = x;
	_tmp1_ = number_to_hex_string (_tmp0_);
	text = _tmp1_;
	_tmp2_ = text;
	_tmp3_ = strlen (_tmp2_);
	_tmp4_ = _tmp3_;
	len = _tmp4_;
	_tmp5_ = wordlen;
	offset = _tmp5_ / 4;
	_tmp7_ = len;
	_tmp8_ = offset;
	if (_tmp7_ > _tmp8_) {
		gint _tmp9_;
		gint _tmp10_;
		_tmp9_ = len;
		_tmp10_ = offset;
		_tmp6_ = ((gint) _tmp9_) - _tmp10_;
	} else {
		_tmp6_ = 0;
	}
	offset = _tmp6_;
	_tmp11_ = text;
	_tmp12_ = offset;
	_tmp13_ = string_substring (_tmp11_, (glong) _tmp12_, (glong) -1);
	_tmp14_ = _tmp13_;
	_tmp15_ = mp_set_from_string (_tmp14_, 16);
	_tmp16_ = _tmp15_;
	_g_free0 (_tmp14_);
	result = _tmp16_;
	_g_free0 (text);
	return result;
}


Number* number_shift (Number* self, gint count) {
	Number* result = NULL;
	gboolean _tmp0_;
	gint _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_is_integer (self);
	if (!_tmp0_) {
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		Number* _tmp3_;
		_tmp1_ = number_get_error ();
		_tmp2_ = _tmp1_;
		number_set_error (_ ("Shift is only possible on integer values"));
		_tmp3_ = number_new_integer ((gint64) 0, (gint64) 0);
		result = _tmp3_;
		return result;
	}
	_tmp4_ = count;
	if (_tmp4_ >= 0) {
		gint multiplier = 0;
		gint _tmp10_;
		Number* _tmp11_;
		multiplier = 1;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp5_ = FALSE;
				_tmp5_ = TRUE;
				while (TRUE) {
					gint _tmp7_;
					gint _tmp8_;
					gint _tmp9_;
					if (!_tmp5_) {
						gint _tmp6_;
						_tmp6_ = i;
						i = _tmp6_ + 1;
					}
					_tmp5_ = FALSE;
					_tmp7_ = i;
					_tmp8_ = count;
					if (!(_tmp7_ < _tmp8_)) {
						break;
					}
					_tmp9_ = multiplier;
					multiplier = _tmp9_ * 2;
				}
			}
		}
		_tmp10_ = multiplier;
		_tmp11_ = number_multiply_integer (self, (gint64) _tmp10_);
		result = _tmp11_;
		return result;
	} else {
		gint multiplier = 0;
		gint _tmp17_;
		Number* _tmp18_;
		Number* _tmp19_;
		Number* _tmp20_;
		Number* _tmp21_;
		multiplier = 1;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp12_ = FALSE;
				_tmp12_ = TRUE;
				while (TRUE) {
					gint _tmp14_;
					gint _tmp15_;
					gint _tmp16_;
					if (!_tmp12_) {
						gint _tmp13_;
						_tmp13_ = i;
						i = _tmp13_ + 1;
					}
					_tmp12_ = FALSE;
					_tmp14_ = i;
					_tmp15_ = count;
					if (!(_tmp14_ < (-_tmp15_))) {
						break;
					}
					_tmp16_ = multiplier;
					multiplier = _tmp16_ * 2;
				}
			}
		}
		_tmp17_ = multiplier;
		_tmp18_ = number_divide_integer (self, (gint64) _tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = number_floor (_tmp19_);
		_tmp21_ = _tmp20_;
		_g_object_unref0 (_tmp19_);
		result = _tmp21_;
		return result;
	}
}


static gint __lambda8_ (Number* self, gint v1, gint v2) {
	gint result = 0;
	gint _tmp0_;
	gint _tmp1_;
	_tmp0_ = v1;
	_tmp1_ = v2;
	result = _tmp0_ ^ _tmp1_;
	return result;
}


static gint ___lambda8__bitwise_func (gint v1, gint v2, gpointer self) {
	gint result;
	result = __lambda8_ ((Number*) self, v1, v2);
	return result;
}


Number* number_ones_complement (Number* self, gint wordlen) {
	Number* result = NULL;
	Number* _tmp0_;
	Number* _tmp1_;
	gint _tmp2_;
	Number* _tmp3_;
	Number* _tmp4_;
	gint _tmp5_;
	Number* _tmp6_;
	Number* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_new_integer ((gint64) 0, (gint64) 0);
	_tmp1_ = _tmp0_;
	_tmp2_ = wordlen;
	_tmp3_ = number_bitwise (self, _tmp1_, ___lambda8__bitwise_func, self, _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = wordlen;
	_tmp6_ = number_not (_tmp4_, _tmp5_);
	_tmp7_ = _tmp6_;
	_g_object_unref0 (_tmp4_);
	_g_object_unref0 (_tmp1_);
	result = _tmp7_;
	return result;
}


Number* number_twos_complement (Number* self, gint wordlen) {
	Number* result = NULL;
	gint _tmp0_;
	Number* _tmp1_;
	Number* _tmp2_;
	Number* _tmp3_;
	Number* _tmp4_;
	Number* _tmp5_;
	Number* _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = wordlen;
	_tmp1_ = number_ones_complement (self, _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = number_new_integer ((gint64) 1, (gint64) 0);
	_tmp4_ = _tmp3_;
	_tmp5_ = number_add (_tmp2_, _tmp4_);
	_tmp6_ = _tmp5_;
	_g_object_unref0 (_tmp4_);
	_g_object_unref0 (_tmp2_);
	result = _tmp6_;
	return result;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static inline void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}


GList* number_factorize (Number* self) {
	GList* result = NULL;
	GList* factors = NULL;
	Number* value = NULL;
	Number* _tmp0_;
	Number* _tmp1_;
	gboolean _tmp2_;
	Number* _tmp5_;
	Number* _tmp6_;
	Number* _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	guint64 num = 0ULL;
	guint64 _tmp11_;
	guint64 _tmp12_;
	guint64 _tmp13_;
	Number* int_max = NULL;
	guint64 _tmp14_;
	Number* _tmp15_;
	Number* _tmp16_;
	Number* _tmp17_;
	gint _tmp18_;
	Number* divisor = NULL;
	Number* _tmp27_;
	Number* _tmp37_;
	Number* root = NULL;
	Number* _tmp38_;
	Number* _tmp39_;
	Number* _tmp60_;
	Number* _tmp61_;
	Number* _tmp62_;
	gint _tmp63_;
	gboolean _tmp64_;
	gboolean _tmp67_;
	g_return_val_if_fail (self != NULL, NULL);
	factors = NULL;
	_tmp0_ = number_abs (self);
	value = _tmp0_;
	_tmp1_ = value;
	_tmp2_ = number_is_zero (_tmp1_);
	if (_tmp2_) {
		Number* _tmp3_;
		Number* _tmp4_;
		_tmp3_ = value;
		_tmp4_ = _g_object_ref0 (_tmp3_);
		factors = g_list_append (factors, _tmp4_);
		result = factors;
		_g_object_unref0 (value);
		return result;
	}
	_tmp5_ = value;
	_tmp6_ = number_new_integer ((gint64) 1, (gint64) 0);
	_tmp7_ = _tmp6_;
	_tmp8_ = number_equals (_tmp5_, _tmp7_);
	_tmp9_ = _tmp8_;
	_g_object_unref0 (_tmp7_);
	if (_tmp9_) {
		Number* _tmp10_;
		_tmp10_ = _g_object_ref0 (self);
		factors = g_list_append (factors, _tmp10_);
		result = factors;
		_g_object_unref0 (value);
		return result;
	}
	num = (guint64) 1;
	_tmp11_ = num;
	num = _tmp11_ << 63;
	_tmp12_ = num;
	_tmp13_ = num;
	num = _tmp12_ + (_tmp13_ - 1);
	_tmp14_ = num;
	_tmp15_ = number_new_unsigned_integer (_tmp14_, (guint64) 0);
	int_max = _tmp15_;
	_tmp16_ = value;
	_tmp17_ = int_max;
	_tmp18_ = number_compare (_tmp16_, _tmp17_);
	if (_tmp18_ <= 0) {
		GList* factors_int64 = NULL;
		Number* _tmp19_;
		guint64 _tmp20_;
		GList* _tmp21_;
		gboolean _tmp22_;
		_tmp19_ = value;
		_tmp20_ = number_to_unsigned_integer (_tmp19_);
		_tmp21_ = number_factorize_uint64 (self, _tmp20_);
		factors_int64 = _tmp21_;
		_tmp22_ = number_is_negative (self);
		if (_tmp22_) {
			GList* _tmp23_;
			GList* _tmp24_;
			gconstpointer _tmp25_;
			Number* _tmp26_;
			_tmp23_ = factors_int64;
			_tmp24_ = factors_int64;
			_tmp25_ = _tmp24_->data;
			_tmp26_ = number_invert_sign ((Number*) _tmp25_);
			_g_object_unref0 (_tmp23_->data);
			_tmp23_->data = _tmp26_;
		}
		result = factors_int64;
		_g_object_unref0 (int_max);
		_g_object_unref0 (value);
		__g_list_free__g_object_unref0_0 (factors);
		return result;
	}
	_tmp27_ = number_new_integer ((gint64) 2, (gint64) 0);
	divisor = _tmp27_;
	while (TRUE) {
		Number* tmp = NULL;
		Number* _tmp28_;
		Number* _tmp29_;
		Number* _tmp30_;
		Number* _tmp31_;
		gboolean _tmp32_;
		_tmp28_ = value;
		_tmp29_ = divisor;
		_tmp30_ = number_divide (_tmp28_, _tmp29_);
		tmp = _tmp30_;
		_tmp31_ = tmp;
		_tmp32_ = number_is_integer (_tmp31_);
		if (_tmp32_) {
			Number* _tmp33_;
			Number* _tmp34_;
			Number* _tmp35_;
			Number* _tmp36_;
			_tmp33_ = tmp;
			_tmp34_ = _g_object_ref0 (_tmp33_);
			_g_object_unref0 (value);
			value = _tmp34_;
			_tmp35_ = divisor;
			_tmp36_ = _g_object_ref0 (_tmp35_);
			factors = g_list_append (factors, _tmp36_);
		} else {
			_g_object_unref0 (tmp);
			break;
		}
		_g_object_unref0 (tmp);
	}
	_tmp37_ = number_new_integer ((gint64) 3, (gint64) 0);
	_g_object_unref0 (divisor);
	divisor = _tmp37_;
	_tmp38_ = value;
	_tmp39_ = number_sqrt (_tmp38_);
	root = _tmp39_;
	while (TRUE) {
		Number* _tmp40_;
		Number* _tmp41_;
		gint _tmp42_;
		Number* tmp = NULL;
		Number* _tmp43_;
		Number* _tmp44_;
		Number* _tmp45_;
		Number* _tmp46_;
		gboolean _tmp47_;
		_tmp40_ = divisor;
		_tmp41_ = root;
		_tmp42_ = number_compare (_tmp40_, _tmp41_);
		if (!(_tmp42_ <= 0)) {
			break;
		}
		_tmp43_ = value;
		_tmp44_ = divisor;
		_tmp45_ = number_divide (_tmp43_, _tmp44_);
		tmp = _tmp45_;
		_tmp46_ = tmp;
		_tmp47_ = number_is_integer (_tmp46_);
		if (_tmp47_) {
			Number* _tmp48_;
			Number* _tmp49_;
			Number* _tmp50_;
			Number* _tmp51_;
			Number* _tmp52_;
			Number* _tmp53_;
			_tmp48_ = tmp;
			_tmp49_ = _g_object_ref0 (_tmp48_);
			_g_object_unref0 (value);
			value = _tmp49_;
			_tmp50_ = value;
			_tmp51_ = number_sqrt (_tmp50_);
			_g_object_unref0 (root);
			root = _tmp51_;
			_tmp52_ = divisor;
			_tmp53_ = _g_object_ref0 (_tmp52_);
			factors = g_list_append (factors, _tmp53_);
		} else {
			Number* _tmp54_;
			Number* _tmp55_;
			Number* _tmp56_;
			Number* _tmp57_;
			Number* _tmp58_;
			Number* _tmp59_;
			_tmp54_ = divisor;
			_tmp55_ = number_new_integer ((gint64) 2, (gint64) 0);
			_tmp56_ = _tmp55_;
			_tmp57_ = number_add (_tmp54_, _tmp56_);
			_g_object_unref0 (tmp);
			tmp = _tmp57_;
			_g_object_unref0 (_tmp56_);
			_tmp58_ = tmp;
			_tmp59_ = _g_object_ref0 (_tmp58_);
			_g_object_unref0 (divisor);
			divisor = _tmp59_;
		}
		_g_object_unref0 (tmp);
	}
	_tmp60_ = value;
	_tmp61_ = number_new_integer ((gint64) 1, (gint64) 0);
	_tmp62_ = _tmp61_;
	_tmp63_ = number_compare (_tmp60_, _tmp62_);
	_tmp64_ = _tmp63_ > 0;
	_g_object_unref0 (_tmp62_);
	if (_tmp64_) {
		Number* _tmp65_;
		Number* _tmp66_;
		_tmp65_ = value;
		_tmp66_ = _g_object_ref0 (_tmp65_);
		factors = g_list_append (factors, _tmp66_);
	}
	_tmp67_ = number_is_negative (self);
	if (_tmp67_) {
		GList* _tmp68_;
		GList* _tmp69_;
		gconstpointer _tmp70_;
		Number* _tmp71_;
		_tmp68_ = factors;
		_tmp69_ = factors;
		_tmp70_ = _tmp69_->data;
		_tmp71_ = number_invert_sign ((Number*) _tmp70_);
		_g_object_unref0 (_tmp68_->data);
		_tmp68_->data = _tmp71_;
	}
	result = factors;
	_g_object_unref0 (root);
	_g_object_unref0 (divisor);
	_g_object_unref0 (int_max);
	_g_object_unref0 (value);
	return result;
}


GList* number_factorize_uint64 (Number* self, guint64 n) {
	GList* result = NULL;
	GList* factors = NULL;
	guint64 _tmp14_;
	g_return_val_if_fail (self != NULL, NULL);
	factors = NULL;
	while (TRUE) {
		guint64 _tmp0_;
		guint64 _tmp1_;
		Number* _tmp2_;
		_tmp0_ = n;
		if (!((_tmp0_ % 2) == ((guint64) 0))) {
			break;
		}
		_tmp1_ = n;
		n = _tmp1_ / 2;
		_tmp2_ = number_new_unsigned_integer ((guint64) 2, (guint64) 0);
		factors = g_list_append (factors, _tmp2_);
	}
	{
		guint64 divisor = 0ULL;
		divisor = (guint64) 3;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				guint64 _tmp5_;
				guint64 _tmp6_;
				guint64 _tmp7_;
				if (!_tmp3_) {
					guint64 _tmp4_;
					_tmp4_ = divisor;
					divisor = _tmp4_ + 2;
				}
				_tmp3_ = FALSE;
				_tmp5_ = divisor;
				_tmp6_ = n;
				_tmp7_ = divisor;
				if (!(_tmp5_ <= (_tmp6_ / _tmp7_))) {
					break;
				}
				while (TRUE) {
					guint64 _tmp8_;
					guint64 _tmp9_;
					guint64 _tmp10_;
					guint64 _tmp11_;
					guint64 _tmp12_;
					Number* _tmp13_;
					_tmp8_ = n;
					_tmp9_ = divisor;
					if (!((_tmp8_ % _tmp9_) == ((guint64) 0))) {
						break;
					}
					_tmp10_ = n;
					_tmp11_ = divisor;
					n = _tmp10_ / _tmp11_;
					_tmp12_ = divisor;
					_tmp13_ = number_new_unsigned_integer (_tmp12_, (guint64) 0);
					factors = g_list_append (factors, _tmp13_);
				}
			}
		}
	}
	_tmp14_ = n;
	if (_tmp14_ > ((guint64) 1)) {
		guint64 _tmp15_;
		Number* _tmp16_;
		_tmp15_ = n;
		_tmp16_ = number_new_unsigned_integer (_tmp15_, (guint64) 0);
		factors = g_list_append (factors, _tmp16_);
	}
	result = factors;
	return result;
}


static Number* number_copy (Number* self) {
	Number* result = NULL;
	Number* z = NULL;
	Number* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_new ();
	z = _tmp0_;
	mpc_set (&z->priv->num, &self->priv->num, MPC_RNDNN);
	result = z;
	return result;
}


static gboolean _mpc_equal (const __mpc_struct * s1, const __mpc_struct * s2) {
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	return FALSE;
}


static void number_mpc_from_radians (__mpc_struct* res, __mpc_struct* op, AngleUnit unit) {
	gint i = 0;
	AngleUnit _tmp0_;
	__mpfr_struct scale = {0};
	mpfr_prec_t _tmp2_;
	mpfr_prec_t _tmp3_;
	gint _tmp4_;
	__mpc_struct _tmp5_;
	g_return_if_fail (res != NULL);
	g_return_if_fail (op != NULL);
	_tmp0_ = unit;
	switch (_tmp0_) {
		default:
		case ANGLE_UNIT_RADIANS:
		{
			if (_mpc_equal (res, op) != TRUE) {
				__mpc_struct _tmp1_;
				_tmp1_ = *op;
				mpc_set (res, &_tmp1_, MPC_RNDNN);
			}
			return;
		}
		case ANGLE_UNIT_DEGREES:
		{
			i = 180;
			break;
		}
		case ANGLE_UNIT_GRADIANS:
		{
			i = 200;
			break;
		}
	}
	_tmp2_ = number_get_precision ();
	_tmp3_ = _tmp2_;
	mpfr_init2 (&scale, _tmp3_);
	mpfr_const_pi (&scale, MPFR_RNDN);
	_tmp4_ = i;
	mpfr_si_div (&scale, (glong) _tmp4_, &scale, MPFR_RNDN);
	_tmp5_ = *op;
	mpc_mul_fr (res, &_tmp5_, &scale, MPC_RNDNN);
	mpfr_clear (&scale);
}


static void number_mpc_to_radians (__mpc_struct* res, __mpc_struct* op, AngleUnit unit) {
	gint i = 0;
	AngleUnit _tmp0_;
	__mpfr_struct scale = {0};
	mpfr_prec_t _tmp2_;
	mpfr_prec_t _tmp3_;
	gint _tmp4_;
	__mpc_struct _tmp5_;
	g_return_if_fail (res != NULL);
	g_return_if_fail (op != NULL);
	_tmp0_ = unit;
	switch (_tmp0_) {
		default:
		case ANGLE_UNIT_RADIANS:
		{
			if (_mpc_equal (res, op) != TRUE) {
				__mpc_struct _tmp1_;
				_tmp1_ = *op;
				mpc_set (res, &_tmp1_, MPC_RNDNN);
			}
			return;
		}
		case ANGLE_UNIT_DEGREES:
		{
			i = 180;
			break;
		}
		case ANGLE_UNIT_GRADIANS:
		{
			i = 200;
			break;
		}
	}
	_tmp2_ = number_get_precision ();
	_tmp3_ = _tmp2_;
	mpfr_init2 (&scale, _tmp3_);
	mpfr_const_pi (&scale, MPFR_RNDN);
	_tmp4_ = i;
	mpfr_div_si (&scale, &scale, (glong) _tmp4_, MPFR_RNDN);
	_tmp5_ = *op;
	mpc_mul_fr (res, &_tmp5_, &scale, MPC_RNDNN);
	mpfr_clear (&scale);
}


static Number* number_to_radians (Number* self, AngleUnit unit) {
	Number* result = NULL;
	Number* z = NULL;
	Number* _tmp0_;
	AngleUnit _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_new ();
	z = _tmp0_;
	_tmp1_ = unit;
	number_mpc_to_radians (&z->priv->num, &self->priv->num, _tmp1_);
	result = z;
	return result;
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_;
	gchar _tmp1_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static Number* number_bitwise (Number* self, Number* y, BitwiseFunc bitwise_operator, void* bitwise_operator_target, gint wordlen) {
	Number* result = NULL;
	gchar* text1 = NULL;
	gchar* _tmp0_;
	gchar* text2 = NULL;
	Number* _tmp1_;
	gchar* _tmp2_;
	gint offset1 = 0;
	const gchar* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint offset2 = 0;
	const gchar* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gint offset_out = 0;
	gint _tmp9_;
	gint _tmp10_;
	gboolean _tmp16_ = FALSE;
	gint _tmp17_;
	gchar* text_out = NULL;
	gint _tmp26_;
	gchar* _tmp27_;
	gint text_out_length1;
	gint _text_out_size_;
	gchar* _tmp54_;
	gint _tmp54__length1;
	Number* _tmp55_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (y != NULL, NULL);
	_tmp0_ = number_to_hex_string (self);
	text1 = _tmp0_;
	_tmp1_ = y;
	_tmp2_ = number_to_hex_string (_tmp1_);
	text2 = _tmp2_;
	_tmp3_ = text1;
	_tmp4_ = strlen (_tmp3_);
	_tmp5_ = _tmp4_;
	offset1 = _tmp5_ - 1;
	_tmp6_ = text2;
	_tmp7_ = strlen (_tmp6_);
	_tmp8_ = _tmp7_;
	offset2 = _tmp8_ - 1;
	_tmp9_ = wordlen;
	offset_out = (_tmp9_ / 4) - 1;
	_tmp10_ = offset_out;
	if (_tmp10_ <= 0) {
		gint _tmp11_ = 0;
		gint _tmp12_;
		gint _tmp13_;
		_tmp12_ = offset1;
		_tmp13_ = offset2;
		if (_tmp12_ > _tmp13_) {
			gint _tmp14_;
			_tmp14_ = offset1;
			_tmp11_ = _tmp14_;
		} else {
			gint _tmp15_;
			_tmp15_ = offset2;
			_tmp11_ = _tmp15_;
		}
		offset_out = _tmp11_;
	}
	_tmp17_ = offset_out;
	if (_tmp17_ > 0) {
		gboolean _tmp18_ = FALSE;
		gint _tmp19_;
		gint _tmp20_;
		_tmp19_ = offset_out;
		_tmp20_ = offset1;
		if (_tmp19_ < _tmp20_) {
			_tmp18_ = TRUE;
		} else {
			gint _tmp21_;
			gint _tmp22_;
			_tmp21_ = offset_out;
			_tmp22_ = offset2;
			_tmp18_ = _tmp21_ < _tmp22_;
		}
		_tmp16_ = _tmp18_;
	} else {
		_tmp16_ = FALSE;
	}
	if (_tmp16_) {
		const gchar* _tmp23_;
		const gchar* _tmp24_;
		Number* _tmp25_;
		_tmp23_ = number_get_error ();
		_tmp24_ = _tmp23_;
		number_set_error ("Overflow. Try a bigger word size");
		_tmp25_ = number_new_integer ((gint64) 0, (gint64) 0);
		result = _tmp25_;
		_g_free0 (text2);
		_g_free0 (text1);
		return result;
	}
	_tmp26_ = offset_out;
	_tmp27_ = g_new0 (gchar, _tmp26_ + 2);
	text_out = _tmp27_;
	text_out_length1 = _tmp26_ + 2;
	_text_out_size_ = text_out_length1;
	{
		gchar* _tmp28_;
		gint _tmp28__length1;
		gint _tmp29_;
		gchar _tmp30_;
		gboolean _tmp31_ = FALSE;
		_tmp28_ = text_out;
		_tmp28__length1 = text_out_length1;
		_tmp29_ = offset_out;
		_tmp28_[_tmp29_ + 1] = '\0';
		_tmp30_ = _tmp28_[_tmp29_ + 1];
		_tmp31_ = TRUE;
		while (TRUE) {
			gint _tmp33_;
			gint v1 = 0;
			gint v2 = 0;
			static const gchar digits[] = {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
			gint _tmp34_;
			gint _tmp40_;
			gchar* _tmp46_;
			gint _tmp46__length1;
			gint _tmp47_;
			BitwiseFunc _tmp48_;
			void* _tmp48__target;
			gint _tmp49_;
			gint _tmp50_;
			gint _tmp51_;
			gchar _tmp52_;
			gchar _tmp53_;
			if (!_tmp31_) {
				gint _tmp32_;
				_tmp32_ = offset_out;
				offset_out = _tmp32_ - 1;
			}
			_tmp31_ = FALSE;
			_tmp33_ = offset_out;
			if (!(_tmp33_ >= 0)) {
				break;
			}
			v1 = 0;
			v2 = 0;
			_tmp34_ = offset1;
			if (_tmp34_ >= 0) {
				const gchar* _tmp35_;
				gint _tmp36_;
				gchar _tmp37_;
				gint _tmp38_;
				gint _tmp39_;
				_tmp35_ = text1;
				_tmp36_ = offset1;
				_tmp37_ = string_get (_tmp35_, (glong) _tmp36_);
				_tmp38_ = number_hex_to_int (self, _tmp37_);
				v1 = _tmp38_;
				_tmp39_ = offset1;
				offset1 = _tmp39_ - 1;
			}
			_tmp40_ = offset2;
			if (_tmp40_ >= 0) {
				const gchar* _tmp41_;
				gint _tmp42_;
				gchar _tmp43_;
				gint _tmp44_;
				gint _tmp45_;
				_tmp41_ = text2;
				_tmp42_ = offset2;
				_tmp43_ = string_get (_tmp41_, (glong) _tmp42_);
				_tmp44_ = number_hex_to_int (self, _tmp43_);
				v2 = _tmp44_;
				_tmp45_ = offset2;
				offset2 = _tmp45_ - 1;
			}
			_tmp46_ = text_out;
			_tmp46__length1 = text_out_length1;
			_tmp47_ = offset_out;
			_tmp48_ = bitwise_operator;
			_tmp48__target = bitwise_operator_target;
			_tmp49_ = v1;
			_tmp50_ = v2;
			_tmp51_ = _tmp48_ (_tmp49_, _tmp50_, _tmp48__target);
			_tmp52_ = digits[_tmp51_];
			_tmp46_[_tmp47_] = _tmp52_;
			_tmp53_ = _tmp46_[_tmp47_];
		}
	}
	_tmp54_ = text_out;
	_tmp54__length1 = text_out_length1;
	_tmp55_ = mp_set_from_string ((const gchar*) _tmp54_, 16);
	result = _tmp55_;
	text_out = (g_free (text_out), NULL);
	_g_free0 (text2);
	_g_free0 (text1);
	return result;
}


static gint number_hex_to_int (Number* self, gchar digit) {
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	gchar _tmp1_;
	gboolean _tmp4_ = FALSE;
	gchar _tmp5_;
	gboolean _tmp8_ = FALSE;
	gchar _tmp9_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp1_ = digit;
	if (_tmp1_ >= '0') {
		gchar _tmp2_;
		_tmp2_ = digit;
		_tmp0_ = _tmp2_ <= '9';
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gchar _tmp3_;
		_tmp3_ = digit;
		result = (gint) (_tmp3_ - '0');
		return result;
	}
	_tmp5_ = digit;
	if (_tmp5_ >= 'A') {
		gchar _tmp6_;
		_tmp6_ = digit;
		_tmp4_ = _tmp6_ <= 'F';
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		gchar _tmp7_;
		_tmp7_ = digit;
		result = (_tmp7_ - 'A') + 10;
		return result;
	}
	_tmp9_ = digit;
	if (_tmp9_ >= 'a') {
		gchar _tmp10_;
		_tmp10_ = digit;
		_tmp8_ = _tmp10_ <= 'f';
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		gchar _tmp11_;
		_tmp11_ = digit;
		result = (_tmp11_ - 'a') + 10;
		return result;
	}
	result = 0;
	return result;
}


static gchar* number_to_hex_string (Number* self) {
	gchar* result = NULL;
	Serializer* serializer = NULL;
	Serializer* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = serializer_new (DISPLAY_FORMAT_FIXED, 16, 0);
	serializer = _tmp0_;
	_tmp1_ = serializer_to_string (serializer, self);
	result = _tmp1_;
	_g_object_unref0 (serializer);
	return result;
}


Number* number_construct (GType object_type) {
	Number * self = NULL;
	self = (Number*) g_object_new (object_type, NULL);
	return self;
}


Number* number_new (void) {
	return number_construct (TYPE_NUMBER);
}


mpfr_prec_t number_get_precision (void) {
	mpfr_prec_t result;
	mpfr_prec_t _tmp0_;
	_tmp0_ = number__precision;
	result = _tmp0_;
	return result;
}


void number_set_precision (mpfr_prec_t value) {
	mpfr_prec_t _tmp0_;
	_tmp0_ = value;
	number__precision = _tmp0_;
}


const gchar* number_get_error (void) {
	const gchar* result;
	const gchar* _tmp0_;
	_tmp0_ = number__error;
	result = _tmp0_;
	return result;
}


void number_set_error (const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (number__error);
	number__error = _tmp1_;
}


static void number_class_init (NumberClass * klass) {
	number_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (NumberPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_number_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_number_set_property;
	G_OBJECT_CLASS (klass)->finalize = number_finalize;
}


static void number_instance_init (Number * self) {
	mpfr_prec_t _tmp0_;
	mpfr_prec_t _tmp1_;
	self->priv = NUMBER_GET_PRIVATE (self);
	_tmp0_ = number_get_precision ();
	_tmp1_ = _tmp0_;
	mpc_init2 (&self->priv->num, _tmp1_);
}


static void number_finalize (GObject * obj) {
	Number * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_NUMBER, Number);
	mpc_clear (&self->priv->num);
	G_OBJECT_CLASS (number_parent_class)->finalize (obj);
}


GType number_get_type (void) {
	static volatile gsize number_type_id__volatile = 0;
	if (g_once_init_enter (&number_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NumberClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) number_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Number), 0, (GInstanceInitFunc) number_instance_init, NULL };
		GType number_type_id;
		number_type_id = g_type_register_static (G_TYPE_OBJECT, "Number", &g_define_type_info, 0);
		g_once_init_leave (&number_type_id__volatile, number_type_id);
	}
	return number_type_id__volatile;
}


static void _vala_number_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	Number * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_NUMBER, Number);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_number_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	Number * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_NUMBER, Number);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static gint string_index_of_char (const gchar* self, gunichar c, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_;
	gunichar _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = c;
	_tmp2_ = g_utf8_strchr (((gchar*) self) + _tmp0_, (gssize) -1, _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static gboolean string_get_next_char (const gchar* self, gint* index, gunichar* c) {
	gunichar _vala_c = 0U;
	gboolean result = FALSE;
	gint _tmp0_;
	gunichar _tmp1_;
	gunichar _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = *index;
	_tmp1_ = g_utf8_get_char (((gchar*) self) + _tmp0_);
	_vala_c = _tmp1_;
	_tmp2_ = _vala_c;
	if (_tmp2_ != ((gunichar) 0)) {
		gint _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = *index;
		_tmp4_ = g_utf8_next_char (((gchar*) self) + _tmp3_);
		*index = (gint) (_tmp4_ - ((gchar*) self));
		result = TRUE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	} else {
		result = FALSE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	}
	if (c) {
		*c = _vala_c;
	}
}


static gboolean string_get_prev_char (const gchar* self, gint* index, gunichar* c) {
	gunichar _vala_c = 0U;
	gboolean result = FALSE;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = *index;
	if (0 < _tmp0_) {
		gint _tmp1_;
		gchar* _tmp2_;
		gint _tmp3_;
		gunichar _tmp4_;
		_tmp1_ = *index;
		_tmp2_ = g_utf8_prev_char (((gchar*) self) + _tmp1_);
		*index = (gint) (_tmp2_ - ((gchar*) self));
		_tmp3_ = *index;
		_tmp4_ = g_utf8_get_char (((gchar*) self) + _tmp3_);
		_vala_c = _tmp4_;
		result = TRUE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	} else {
		_vala_c = (gunichar) 0;
		result = FALSE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	}
	if (c) {
		*c = _vala_c;
	}
}


Number* mp_set_from_string (const gchar* str, gint default_base) {
	Number* result = NULL;
	const gchar* _tmp0_;
	gint _tmp1_;
	static const gunichar base_digits[] = {8320U, 8321U, 8322U, 8323U, 8324U, 8325U, 8326U, 8327U, 8328U, 8329U};
	gint index = 0;
	gunichar c = 0U;
	gint end = 0;
	gint _tmp7_;
	gint number_base = 0;
	gint base_multiplier = 0;
	gint _tmp24_;
	gboolean negate = FALSE;
	const gchar* _tmp26_;
	gunichar _tmp27_ = 0U;
	gunichar _tmp28_;
	Number* z = NULL;
	Number* _tmp34_;
	static const gunichar fractions[] = {189U, 8531U, 8532U, 188U, 190U, 8533U, 8534U, 8535U, 8536U, 8537U, 8538U, 8539U, 8540U, 8541U, 8542U};
	static const gint numerators[] = {1, 1, 2, 1, 3, 1, 2, 3, 4, 1, 5, 1, 3, 5, 7};
	static const gint denominators[] = {2, 3, 3, 4, 4, 5, 5, 5, 5, 6, 6, 8, 8, 8, 8};
	gboolean has_fraction = FALSE;
	const gchar* _tmp54_;
	gunichar _tmp55_ = 0U;
	gboolean _tmp56_;
	gboolean _tmp77_;
	gint _tmp106_;
	gint _tmp107_;
	gboolean _tmp108_;
	g_return_val_if_fail (str != NULL, NULL);
	_tmp0_ = str;
	_tmp1_ = string_index_of_char (_tmp0_, 176U, 0);
	if (_tmp1_ >= 0) {
		const gchar* _tmp2_;
		Number* _tmp3_;
		_tmp2_ = str;
		_tmp3_ = set_from_sexagesimal (_tmp2_);
		result = _tmp3_;
		return result;
	}
	index = 0;
	while (TRUE) {
		const gchar* _tmp4_;
		gunichar _tmp5_ = 0U;
		gboolean _tmp6_;
		_tmp4_ = str;
		_tmp6_ = string_get_next_char (_tmp4_, &index, &_tmp5_);
		c = _tmp5_;
		if (!_tmp6_) {
			break;
		}
	}
	_tmp7_ = index;
	end = _tmp7_;
	number_base = 0;
	base_multiplier = 1;
	while (TRUE) {
		const gchar* _tmp8_;
		gunichar _tmp9_ = 0U;
		gboolean _tmp10_;
		gint value = 0;
		gint _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		gint _tmp21_;
		gint _tmp22_;
		gint _tmp23_;
		_tmp8_ = str;
		_tmp10_ = string_get_prev_char (_tmp8_, &index, &_tmp9_);
		c = _tmp9_;
		if (!_tmp10_) {
			break;
		}
		value = -1;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp11_ = FALSE;
				_tmp11_ = TRUE;
				while (TRUE) {
					gint _tmp13_;
					gunichar _tmp14_;
					gint _tmp15_;
					gunichar _tmp16_;
					if (!_tmp11_) {
						gint _tmp12_;
						_tmp12_ = i;
						i = _tmp12_ + 1;
					}
					_tmp11_ = FALSE;
					_tmp13_ = i;
					if (!(_tmp13_ < G_N_ELEMENTS (base_digits))) {
						break;
					}
					_tmp14_ = c;
					_tmp15_ = i;
					_tmp16_ = base_digits[_tmp15_];
					if (_tmp14_ == _tmp16_) {
						gint _tmp17_;
						_tmp17_ = i;
						value = _tmp17_;
						break;
					}
				}
			}
		}
		_tmp18_ = value;
		if (_tmp18_ < 0) {
			break;
		}
		_tmp19_ = index;
		end = _tmp19_;
		_tmp20_ = number_base;
		_tmp21_ = value;
		_tmp22_ = base_multiplier;
		number_base = _tmp20_ + (_tmp21_ * _tmp22_);
		_tmp23_ = base_multiplier;
		base_multiplier = _tmp23_ * 10;
	}
	_tmp24_ = base_multiplier;
	if (_tmp24_ == 1) {
		gint _tmp25_;
		_tmp25_ = default_base;
		number_base = _tmp25_;
	}
	negate = FALSE;
	index = 0;
	_tmp26_ = str;
	string_get_next_char (_tmp26_, &index, &_tmp27_);
	c = _tmp27_;
	_tmp28_ = c;
	if (_tmp28_ == ((gunichar) '+')) {
		negate = FALSE;
	} else {
		gboolean _tmp29_ = FALSE;
		gunichar _tmp30_;
		_tmp30_ = c;
		if (_tmp30_ == ((gunichar) '-')) {
			_tmp29_ = TRUE;
		} else {
			gunichar _tmp31_;
			_tmp31_ = c;
			_tmp29_ = _tmp31_ == 8722U;
		}
		if (_tmp29_) {
			negate = TRUE;
		} else {
			const gchar* _tmp32_;
			gunichar _tmp33_ = 0U;
			_tmp32_ = str;
			string_get_prev_char (_tmp32_, &index, &_tmp33_);
			c = _tmp33_;
		}
	}
	_tmp34_ = number_new_integer ((gint64) 0, (gint64) 0);
	z = _tmp34_;
	while (TRUE) {
		const gchar* _tmp35_;
		gunichar _tmp36_ = 0U;
		gboolean _tmp37_;
		gint i = 0;
		gunichar _tmp38_;
		gint _tmp39_;
		gint _tmp40_;
		gint _tmp41_;
		gint _tmp42_;
		gint _tmp43_;
		Number* _tmp46_;
		gint _tmp47_;
		Number* _tmp48_;
		Number* _tmp49_;
		gint _tmp50_;
		Number* _tmp51_;
		Number* _tmp52_;
		Number* _tmp53_;
		_tmp35_ = str;
		_tmp37_ = string_get_next_char (_tmp35_, &index, &_tmp36_);
		c = _tmp36_;
		if (!_tmp37_) {
			break;
		}
		_tmp38_ = c;
		_tmp39_ = number_base;
		_tmp40_ = char_val (_tmp38_, _tmp39_);
		i = _tmp40_;
		_tmp41_ = i;
		_tmp42_ = number_base;
		if (_tmp41_ > _tmp42_) {
			result = NULL;
			_g_object_unref0 (z);
			return result;
		}
		_tmp43_ = i;
		if (_tmp43_ < 0) {
			const gchar* _tmp44_;
			gunichar _tmp45_ = 0U;
			_tmp44_ = str;
			string_get_prev_char (_tmp44_, &index, &_tmp45_);
			c = _tmp45_;
			break;
		}
		_tmp46_ = z;
		_tmp47_ = number_base;
		_tmp48_ = number_multiply_integer (_tmp46_, (gint64) _tmp47_);
		_tmp49_ = _tmp48_;
		_tmp50_ = i;
		_tmp51_ = number_new_integer ((gint64) _tmp50_, (gint64) 0);
		_tmp52_ = _tmp51_;
		_tmp53_ = number_add (_tmp49_, _tmp52_);
		_g_object_unref0 (z);
		z = _tmp53_;
		_g_object_unref0 (_tmp52_);
		_g_object_unref0 (_tmp49_);
	}
	has_fraction = FALSE;
	_tmp54_ = str;
	_tmp56_ = string_get_next_char (_tmp54_, &index, &_tmp55_);
	c = _tmp55_;
	if (_tmp56_) {
		gunichar _tmp74_;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp57_ = FALSE;
				_tmp57_ = TRUE;
				while (TRUE) {
					gint _tmp59_;
					gunichar _tmp60_;
					gint _tmp61_;
					gunichar _tmp62_;
					if (!_tmp57_) {
						gint _tmp58_;
						_tmp58_ = i;
						i = _tmp58_ + 1;
					}
					_tmp57_ = FALSE;
					_tmp59_ = i;
					if (!(_tmp59_ < G_N_ELEMENTS (fractions))) {
						break;
					}
					_tmp60_ = c;
					_tmp61_ = i;
					_tmp62_ = fractions[_tmp61_];
					if (_tmp60_ == _tmp62_) {
						Number* fraction = NULL;
						gint _tmp63_;
						gint _tmp64_;
						gint _tmp65_;
						gint _tmp66_;
						Number* _tmp67_;
						Number* _tmp68_;
						Number* _tmp69_;
						Number* _tmp70_;
						const gchar* _tmp71_;
						gunichar _tmp72_ = 0U;
						gboolean _tmp73_;
						_tmp63_ = i;
						_tmp64_ = numerators[_tmp63_];
						_tmp65_ = i;
						_tmp66_ = denominators[_tmp65_];
						_tmp67_ = number_new_fraction ((gint64) _tmp64_, (gint64) _tmp66_);
						fraction = _tmp67_;
						_tmp68_ = z;
						_tmp69_ = fraction;
						_tmp70_ = number_add (_tmp68_, _tmp69_);
						_g_object_unref0 (z);
						z = _tmp70_;
						_tmp71_ = str;
						_tmp73_ = string_get_next_char (_tmp71_, &index, &_tmp72_);
						c = _tmp72_;
						if (!_tmp73_) {
							result = z;
							_g_object_unref0 (fraction);
							return result;
						} else {
							result = NULL;
							_g_object_unref0 (fraction);
							_g_object_unref0 (z);
							return result;
						}
						_g_object_unref0 (fraction);
					}
				}
			}
		}
		_tmp74_ = c;
		if (_tmp74_ == ((gunichar) '.')) {
			has_fraction = TRUE;
		} else {
			const gchar* _tmp75_;
			gunichar _tmp76_ = 0U;
			_tmp75_ = str;
			string_get_prev_char (_tmp75_, &index, &_tmp76_);
			c = _tmp76_;
		}
	}
	_tmp77_ = has_fraction;
	if (_tmp77_) {
		Number* numerator = NULL;
		Number* _tmp78_;
		Number* denominator = NULL;
		Number* _tmp79_;
		Number* _tmp100_;
		Number* _tmp101_;
		Number* _tmp102_;
		Number* _tmp103_;
		Number* _tmp104_;
		Number* _tmp105_;
		_tmp78_ = number_new_integer ((gint64) 0, (gint64) 0);
		numerator = _tmp78_;
		_tmp79_ = number_new_integer ((gint64) 1, (gint64) 0);
		denominator = _tmp79_;
		while (TRUE) {
			const gchar* _tmp80_;
			gunichar _tmp81_ = 0U;
			gboolean _tmp82_;
			gint i = 0;
			gunichar _tmp83_;
			gint _tmp84_;
			gint _tmp85_;
			gint _tmp86_;
			Number* _tmp89_;
			gint _tmp90_;
			Number* _tmp91_;
			Number* _tmp92_;
			gint _tmp93_;
			Number* _tmp94_;
			Number* _tmp95_;
			gint _tmp96_;
			Number* _tmp97_;
			Number* _tmp98_;
			Number* _tmp99_;
			_tmp80_ = str;
			_tmp82_ = string_get_next_char (_tmp80_, &index, &_tmp81_);
			c = _tmp81_;
			if (!_tmp82_) {
				break;
			}
			_tmp83_ = c;
			_tmp84_ = number_base;
			_tmp85_ = char_val (_tmp83_, _tmp84_);
			i = _tmp85_;
			_tmp86_ = i;
			if (_tmp86_ < 0) {
				const gchar* _tmp87_;
				gunichar _tmp88_ = 0U;
				_tmp87_ = str;
				string_get_prev_char (_tmp87_, &index, &_tmp88_);
				c = _tmp88_;
				break;
			}
			_tmp89_ = denominator;
			_tmp90_ = number_base;
			_tmp91_ = number_multiply_integer (_tmp89_, (gint64) _tmp90_);
			_g_object_unref0 (denominator);
			denominator = _tmp91_;
			_tmp92_ = numerator;
			_tmp93_ = number_base;
			_tmp94_ = number_multiply_integer (_tmp92_, (gint64) _tmp93_);
			_g_object_unref0 (numerator);
			numerator = _tmp94_;
			_tmp95_ = numerator;
			_tmp96_ = i;
			_tmp97_ = number_new_integer ((gint64) _tmp96_, (gint64) 0);
			_tmp98_ = _tmp97_;
			_tmp99_ = number_add (_tmp95_, _tmp98_);
			_g_object_unref0 (numerator);
			numerator = _tmp99_;
			_g_object_unref0 (_tmp98_);
		}
		_tmp100_ = numerator;
		_tmp101_ = denominator;
		_tmp102_ = number_divide (_tmp100_, _tmp101_);
		_g_object_unref0 (numerator);
		numerator = _tmp102_;
		_tmp103_ = z;
		_tmp104_ = numerator;
		_tmp105_ = number_add (_tmp103_, _tmp104_);
		_g_object_unref0 (z);
		z = _tmp105_;
		_g_object_unref0 (denominator);
		_g_object_unref0 (numerator);
	}
	_tmp106_ = index;
	_tmp107_ = end;
	if (_tmp106_ != _tmp107_) {
		result = NULL;
		_g_object_unref0 (z);
		return result;
	}
	_tmp108_ = negate;
	if (_tmp108_) {
		Number* _tmp109_;
		Number* _tmp110_;
		_tmp109_ = z;
		_tmp110_ = number_invert_sign (_tmp109_);
		_g_object_unref0 (z);
		z = _tmp110_;
	}
	result = z;
	return result;
}


gint char_val (gunichar c, gint number_base) {
	gint result = 0;
	gunichar _tmp0_;
	gboolean _tmp1_;
	gint value = 0;
	gunichar _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	_tmp0_ = c;
	_tmp1_ = g_unichar_isxdigit (_tmp0_);
	if (!_tmp1_) {
		result = -1;
		return result;
	}
	_tmp2_ = c;
	_tmp3_ = g_unichar_xdigit_value (_tmp2_);
	value = _tmp3_;
	_tmp4_ = value;
	_tmp5_ = number_base;
	if (_tmp4_ >= _tmp5_) {
		result = -1;
		return result;
	}
	result = value;
	return result;
}


Number* set_from_sexagesimal (const gchar* str) {
	Number* result = NULL;
	gint degree_index = 0;
	const gchar* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	Number* degrees = NULL;
	const gchar* _tmp3_;
	gint _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	Number* _tmp7_;
	Number* _tmp8_;
	Number* _tmp9_;
	gint minute_start = 0;
	gint _tmp10_;
	gunichar c = 0U;
	const gchar* _tmp11_;
	gunichar _tmp12_ = 0U;
	const gchar* _tmp13_;
	gint _tmp14_;
	gchar _tmp15_;
	gint minute_index = 0;
	const gchar* _tmp16_;
	gint _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
	Number* minutes = NULL;
	const gchar* _tmp20_;
	gint _tmp21_;
	gint _tmp22_;
	gint _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	Number* _tmp26_;
	Number* _tmp27_;
	Number* _tmp28_;
	Number* _tmp29_;
	Number* _tmp30_;
	Number* _tmp31_;
	Number* _tmp32_;
	Number* _tmp33_;
	gint second_start = 0;
	gint _tmp34_;
	const gchar* _tmp35_;
	gunichar _tmp36_ = 0U;
	const gchar* _tmp37_;
	gint _tmp38_;
	gchar _tmp39_;
	gint second_index = 0;
	const gchar* _tmp40_;
	gint _tmp41_;
	gint _tmp42_;
	gint _tmp43_;
	Number* seconds = NULL;
	const gchar* _tmp44_;
	gint _tmp45_;
	gint _tmp46_;
	gint _tmp47_;
	gchar* _tmp48_;
	gchar* _tmp49_;
	Number* _tmp50_;
	Number* _tmp51_;
	Number* _tmp52_;
	Number* _tmp53_;
	Number* _tmp54_;
	Number* _tmp55_;
	Number* _tmp56_;
	Number* _tmp57_;
	const gchar* _tmp58_;
	gunichar _tmp59_ = 0U;
	const gchar* _tmp60_;
	gint _tmp61_;
	gchar _tmp62_;
	g_return_val_if_fail (str != NULL, NULL);
	_tmp0_ = str;
	_tmp1_ = string_index_of_char (_tmp0_, 176U, 0);
	degree_index = _tmp1_;
	_tmp2_ = degree_index;
	if (_tmp2_ < 0) {
		result = NULL;
		return result;
	}
	_tmp3_ = str;
	_tmp4_ = degree_index;
	_tmp5_ = string_substring (_tmp3_, (glong) 0, (glong) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = mp_set_from_string (_tmp6_, 10);
	_tmp8_ = _tmp7_;
	_g_free0 (_tmp6_);
	degrees = _tmp8_;
	_tmp9_ = degrees;
	if (_tmp9_ == NULL) {
		result = NULL;
		_g_object_unref0 (degrees);
		return result;
	}
	_tmp10_ = degree_index;
	minute_start = _tmp10_;
	_tmp11_ = str;
	string_get_next_char (_tmp11_, &minute_start, &_tmp12_);
	c = _tmp12_;
	_tmp13_ = str;
	_tmp14_ = minute_start;
	_tmp15_ = string_get (_tmp13_, (glong) _tmp14_);
	if (_tmp15_ == '\0') {
		result = degrees;
		return result;
	}
	_tmp16_ = str;
	_tmp17_ = minute_start;
	_tmp18_ = string_index_of_char (_tmp16_, (gunichar) '\'', _tmp17_);
	minute_index = _tmp18_;
	_tmp19_ = minute_index;
	if (_tmp19_ < 0) {
		result = NULL;
		_g_object_unref0 (degrees);
		return result;
	}
	_tmp20_ = str;
	_tmp21_ = minute_start;
	_tmp22_ = minute_index;
	_tmp23_ = minute_start;
	_tmp24_ = string_substring (_tmp20_, (glong) _tmp21_, (glong) (_tmp22_ - _tmp23_));
	_tmp25_ = _tmp24_;
	_tmp26_ = mp_set_from_string (_tmp25_, 10);
	_tmp27_ = _tmp26_;
	_g_free0 (_tmp25_);
	minutes = _tmp27_;
	_tmp28_ = minutes;
	if (_tmp28_ == NULL) {
		result = NULL;
		_g_object_unref0 (minutes);
		_g_object_unref0 (degrees);
		return result;
	}
	_tmp29_ = degrees;
	_tmp30_ = minutes;
	_tmp31_ = number_divide_integer (_tmp30_, (gint64) 60);
	_tmp32_ = _tmp31_;
	_tmp33_ = number_add (_tmp29_, _tmp32_);
	_g_object_unref0 (degrees);
	degrees = _tmp33_;
	_g_object_unref0 (_tmp32_);
	_tmp34_ = minute_index;
	second_start = _tmp34_;
	_tmp35_ = str;
	string_get_next_char (_tmp35_, &second_start, &_tmp36_);
	c = _tmp36_;
	_tmp37_ = str;
	_tmp38_ = second_start;
	_tmp39_ = string_get (_tmp37_, (glong) _tmp38_);
	if (_tmp39_ == '\0') {
		result = degrees;
		_g_object_unref0 (minutes);
		return result;
	}
	_tmp40_ = str;
	_tmp41_ = second_start;
	_tmp42_ = string_index_of_char (_tmp40_, (gunichar) '"', _tmp41_);
	second_index = _tmp42_;
	_tmp43_ = second_index;
	if (_tmp43_ < 0) {
		result = NULL;
		_g_object_unref0 (minutes);
		_g_object_unref0 (degrees);
		return result;
	}
	_tmp44_ = str;
	_tmp45_ = second_start;
	_tmp46_ = second_index;
	_tmp47_ = second_start;
	_tmp48_ = string_substring (_tmp44_, (glong) _tmp45_, (glong) (_tmp46_ - _tmp47_));
	_tmp49_ = _tmp48_;
	_tmp50_ = mp_set_from_string (_tmp49_, 10);
	_tmp51_ = _tmp50_;
	_g_free0 (_tmp49_);
	seconds = _tmp51_;
	_tmp52_ = seconds;
	if (_tmp52_ == NULL) {
		result = NULL;
		_g_object_unref0 (seconds);
		_g_object_unref0 (minutes);
		_g_object_unref0 (degrees);
		return result;
	}
	_tmp53_ = degrees;
	_tmp54_ = seconds;
	_tmp55_ = number_divide_integer (_tmp54_, (gint64) 3600);
	_tmp56_ = _tmp55_;
	_tmp57_ = number_add (_tmp53_, _tmp56_);
	_g_object_unref0 (degrees);
	degrees = _tmp57_;
	_g_object_unref0 (_tmp56_);
	_tmp58_ = str;
	string_get_next_char (_tmp58_, &second_index, &_tmp59_);
	c = _tmp59_;
	_tmp60_ = str;
	_tmp61_ = second_index;
	_tmp62_ = string_get (_tmp60_, (glong) _tmp61_);
	if (_tmp62_ == '\0') {
		result = degrees;
		_g_object_unref0 (seconds);
		_g_object_unref0 (minutes);
		return result;
	} else {
		result = NULL;
		_g_object_unref0 (seconds);
		_g_object_unref0 (minutes);
		_g_object_unref0 (degrees);
		return result;
	}
	_g_object_unref0 (seconds);
	_g_object_unref0 (minutes);
	_g_object_unref0 (degrees);
}


gboolean mp_is_overflow (Number* x, gint wordlen) {
	gboolean result = FALSE;
	Number* t2 = NULL;
	Number* _tmp0_;
	Number* _tmp1_;
	gint _tmp2_;
	Number* _tmp3_;
	Number* _tmp4_;
	Number* _tmp5_;
	gint _tmp6_;
	g_return_val_if_fail (x != NULL, FALSE);
	_tmp0_ = number_new_integer ((gint64) 2, (gint64) 0);
	_tmp1_ = _tmp0_;
	_tmp2_ = wordlen;
	_tmp3_ = number_xpowy_integer (_tmp1_, (gint64) _tmp2_);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp1_);
	t2 = _tmp4_;
	_tmp5_ = x;
	_tmp6_ = number_compare (t2, _tmp5_);
	result = _tmp6_ > 0;
	_g_object_unref0 (t2);
	return result;
}



