/* valacodevisitor.c generated by valac, the Vala compiler
 * generated from valacodevisitor.vala, do not modify */

/* valacodevisitor.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <gobject/gvaluecollector.h>

typedef struct _ValaParamSpecCodeVisitor ValaParamSpecCodeVisitor;

struct _ValaParamSpecCodeVisitor {
	GParamSpec parent_instance;
};


static gpointer vala_code_visitor_parent_class = NULL;

static void vala_code_visitor_real_visit_source_file (ValaCodeVisitor* self,
                                               ValaSourceFile* source_file);
static void vala_code_visitor_real_visit_namespace (ValaCodeVisitor* self,
                                             ValaNamespace* ns);
static void vala_code_visitor_real_visit_class (ValaCodeVisitor* self,
                                         ValaClass* cl);
static void vala_code_visitor_real_visit_struct (ValaCodeVisitor* self,
                                          ValaStruct* st);
static void vala_code_visitor_real_visit_interface (ValaCodeVisitor* self,
                                             ValaInterface* iface);
static void vala_code_visitor_real_visit_enum (ValaCodeVisitor* self,
                                        ValaEnum* en);
static void vala_code_visitor_real_visit_enum_value (ValaCodeVisitor* self,
                                              ValaEnumValue* ev);
static void vala_code_visitor_real_visit_error_domain (ValaCodeVisitor* self,
                                                ValaErrorDomain* edomain);
static void vala_code_visitor_real_visit_error_code (ValaCodeVisitor* self,
                                              ValaErrorCode* ecode);
static void vala_code_visitor_real_visit_delegate (ValaCodeVisitor* self,
                                            ValaDelegate* d);
static void vala_code_visitor_real_visit_constant (ValaCodeVisitor* self,
                                            ValaConstant* c);
static void vala_code_visitor_real_visit_field (ValaCodeVisitor* self,
                                         ValaField* f);
static void vala_code_visitor_real_visit_method (ValaCodeVisitor* self,
                                          ValaMethod* m);
static void vala_code_visitor_real_visit_creation_method (ValaCodeVisitor* self,
                                                   ValaCreationMethod* m);
static void vala_code_visitor_real_visit_formal_parameter (ValaCodeVisitor* self,
                                                    ValaParameter* p);
static void vala_code_visitor_real_visit_property (ValaCodeVisitor* self,
                                            ValaProperty* prop);
static void vala_code_visitor_real_visit_property_accessor (ValaCodeVisitor* self,
                                                     ValaPropertyAccessor* acc);
static void vala_code_visitor_real_visit_signal (ValaCodeVisitor* self,
                                          ValaSignal* sig);
static void vala_code_visitor_real_visit_constructor (ValaCodeVisitor* self,
                                               ValaConstructor* c);
static void vala_code_visitor_real_visit_destructor (ValaCodeVisitor* self,
                                              ValaDestructor* d);
static void vala_code_visitor_real_visit_type_parameter (ValaCodeVisitor* self,
                                                  ValaTypeParameter* p);
static void vala_code_visitor_real_visit_using_directive (ValaCodeVisitor* self,
                                                   ValaUsingDirective* ns);
static void vala_code_visitor_real_visit_data_type (ValaCodeVisitor* self,
                                             ValaDataType* type);
static void vala_code_visitor_real_visit_block (ValaCodeVisitor* self,
                                         ValaBlock* b);
static void vala_code_visitor_real_visit_empty_statement (ValaCodeVisitor* self,
                                                   ValaEmptyStatement* stmt);
static void vala_code_visitor_real_visit_declaration_statement (ValaCodeVisitor* self,
                                                         ValaDeclarationStatement* stmt);
static void vala_code_visitor_real_visit_local_variable (ValaCodeVisitor* self,
                                                  ValaLocalVariable* local);
static void vala_code_visitor_real_visit_initializer_list (ValaCodeVisitor* self,
                                                    ValaInitializerList* list);
static void vala_code_visitor_real_visit_expression_statement (ValaCodeVisitor* self,
                                                        ValaExpressionStatement* stmt);
static void vala_code_visitor_real_visit_if_statement (ValaCodeVisitor* self,
                                                ValaIfStatement* stmt);
static void vala_code_visitor_real_visit_switch_statement (ValaCodeVisitor* self,
                                                    ValaSwitchStatement* stmt);
static void vala_code_visitor_real_visit_switch_section (ValaCodeVisitor* self,
                                                  ValaSwitchSection* section);
static void vala_code_visitor_real_visit_switch_label (ValaCodeVisitor* self,
                                                ValaSwitchLabel* label);
static void vala_code_visitor_real_visit_loop (ValaCodeVisitor* self,
                                        ValaLoop* stmt);
static void vala_code_visitor_real_visit_while_statement (ValaCodeVisitor* self,
                                                   ValaWhileStatement* stmt);
static void vala_code_visitor_real_visit_do_statement (ValaCodeVisitor* self,
                                                ValaDoStatement* stmt);
static void vala_code_visitor_real_visit_for_statement (ValaCodeVisitor* self,
                                                 ValaForStatement* stmt);
static void vala_code_visitor_real_visit_foreach_statement (ValaCodeVisitor* self,
                                                     ValaForeachStatement* stmt);
static void vala_code_visitor_real_visit_break_statement (ValaCodeVisitor* self,
                                                   ValaBreakStatement* stmt);
static void vala_code_visitor_real_visit_continue_statement (ValaCodeVisitor* self,
                                                      ValaContinueStatement* stmt);
static void vala_code_visitor_real_visit_return_statement (ValaCodeVisitor* self,
                                                    ValaReturnStatement* stmt);
static void vala_code_visitor_real_visit_yield_statement (ValaCodeVisitor* self,
                                                   ValaYieldStatement* y);
static void vala_code_visitor_real_visit_throw_statement (ValaCodeVisitor* self,
                                                   ValaThrowStatement* stmt);
static void vala_code_visitor_real_visit_try_statement (ValaCodeVisitor* self,
                                                 ValaTryStatement* stmt);
static void vala_code_visitor_real_visit_catch_clause (ValaCodeVisitor* self,
                                                ValaCatchClause* clause);
static void vala_code_visitor_real_visit_lock_statement (ValaCodeVisitor* self,
                                                  ValaLockStatement* stmt);
static void vala_code_visitor_real_visit_unlock_statement (ValaCodeVisitor* self,
                                                    ValaUnlockStatement* stmt);
static void vala_code_visitor_real_visit_delete_statement (ValaCodeVisitor* self,
                                                    ValaDeleteStatement* stmt);
static void vala_code_visitor_real_visit_expression (ValaCodeVisitor* self,
                                              ValaExpression* expr);
static void vala_code_visitor_real_visit_array_creation_expression (ValaCodeVisitor* self,
                                                             ValaArrayCreationExpression* expr);
static void vala_code_visitor_real_visit_boolean_literal (ValaCodeVisitor* self,
                                                   ValaBooleanLiteral* lit);
static void vala_code_visitor_real_visit_character_literal (ValaCodeVisitor* self,
                                                     ValaCharacterLiteral* lit);
static void vala_code_visitor_real_visit_integer_literal (ValaCodeVisitor* self,
                                                   ValaIntegerLiteral* lit);
static void vala_code_visitor_real_visit_real_literal (ValaCodeVisitor* self,
                                                ValaRealLiteral* lit);
static void vala_code_visitor_real_visit_regex_literal (ValaCodeVisitor* self,
                                                 ValaRegexLiteral* lit);
static void vala_code_visitor_real_visit_string_literal (ValaCodeVisitor* self,
                                                  ValaStringLiteral* lit);
static void vala_code_visitor_real_visit_template (ValaCodeVisitor* self,
                                            ValaTemplate* tmpl);
static void vala_code_visitor_real_visit_tuple (ValaCodeVisitor* self,
                                         ValaTuple* tuple);
static void vala_code_visitor_real_visit_null_literal (ValaCodeVisitor* self,
                                                ValaNullLiteral* lit);
static void vala_code_visitor_real_visit_member_access (ValaCodeVisitor* self,
                                                 ValaMemberAccess* expr);
static void vala_code_visitor_real_visit_method_call (ValaCodeVisitor* self,
                                               ValaMethodCall* expr);
static void vala_code_visitor_real_visit_element_access (ValaCodeVisitor* self,
                                                  ValaElementAccess* expr);
static void vala_code_visitor_real_visit_slice_expression (ValaCodeVisitor* self,
                                                    ValaSliceExpression* expr);
static void vala_code_visitor_real_visit_base_access (ValaCodeVisitor* self,
                                               ValaBaseAccess* expr);
static void vala_code_visitor_real_visit_postfix_expression (ValaCodeVisitor* self,
                                                      ValaPostfixExpression* expr);
static void vala_code_visitor_real_visit_object_creation_expression (ValaCodeVisitor* self,
                                                              ValaObjectCreationExpression* expr);
static void vala_code_visitor_real_visit_sizeof_expression (ValaCodeVisitor* self,
                                                     ValaSizeofExpression* expr);
static void vala_code_visitor_real_visit_typeof_expression (ValaCodeVisitor* self,
                                                     ValaTypeofExpression* expr);
static void vala_code_visitor_real_visit_unary_expression (ValaCodeVisitor* self,
                                                    ValaUnaryExpression* expr);
static void vala_code_visitor_real_visit_cast_expression (ValaCodeVisitor* self,
                                                   ValaCastExpression* expr);
static void vala_code_visitor_real_visit_named_argument (ValaCodeVisitor* self,
                                                  ValaNamedArgument* expr);
static void vala_code_visitor_real_visit_pointer_indirection (ValaCodeVisitor* self,
                                                       ValaPointerIndirection* expr);
static void vala_code_visitor_real_visit_addressof_expression (ValaCodeVisitor* self,
                                                        ValaAddressofExpression* expr);
static void vala_code_visitor_real_visit_reference_transfer_expression (ValaCodeVisitor* self,
                                                                 ValaReferenceTransferExpression* expr);
static void vala_code_visitor_real_visit_binary_expression (ValaCodeVisitor* self,
                                                     ValaBinaryExpression* expr);
static void vala_code_visitor_real_visit_type_check (ValaCodeVisitor* self,
                                              ValaTypeCheck* expr);
static void vala_code_visitor_real_visit_conditional_expression (ValaCodeVisitor* self,
                                                          ValaConditionalExpression* expr);
static void vala_code_visitor_real_visit_lambda_expression (ValaCodeVisitor* self,
                                                     ValaLambdaExpression* expr);
static void vala_code_visitor_real_visit_assignment (ValaCodeVisitor* self,
                                              ValaAssignment* a);
static void vala_code_visitor_real_visit_end_full_expression (ValaCodeVisitor* self,
                                                       ValaExpression* expr);
static void vala_code_visitor_finalize (ValaCodeVisitor * obj);


/**
 * Visit operation called for source files.
 *
 * @param source_file a source file
 */
static void
vala_code_visitor_real_visit_source_file (ValaCodeVisitor* self,
                                          ValaSourceFile* source_file)
{
	g_return_if_fail (source_file != NULL);
}


void
vala_code_visitor_visit_source_file (ValaCodeVisitor* self,
                                     ValaSourceFile* source_file)
{
	g_return_if_fail (self != NULL);
	VALA_CODE_VISITOR_GET_CLASS (self)->visit_source_file (self, source_file);
}


/**
 * Visit operation called for namespaces.
 *
 * @param ns a namespace
 */
static void
vala_code_visitor_real_visit_namespace (ValaCodeVisitor* self,
                                        ValaNamespace* ns)
{
	g_return_if_fail (ns != NULL);
}


void
vala_code_visitor_visit_namespace (ValaCodeVisitor* self,
                                   ValaNamespace* ns)
{
	g_return_if_fail (self != NULL);
	VALA_CODE_VISITOR_GET_CLASS (self)->visit_namespace (self, ns);
}


/**
 * Visit operation called for classes.
 *
 * @param cl a class
 */
static void
vala_code_visitor_real_visit_class (ValaCodeVisitor* self,
                                    ValaClass* cl)
{
	g_return_if_fail (cl != NULL);
}


void
vala_code_visitor_visit_class (ValaCodeVisitor* self,
                               ValaClass* cl)
{
	g_return_if_fail (self != NULL);
	VALA_CODE_VISITOR_GET_CLASS (self)->visit_class (self, cl);
}


/**
 * Visit operation called for structs.
 *
 * @param st a struct
 */
static void
vala_code_visitor_real_visit_struct (ValaCodeVisitor* self,
                                     ValaStruct* st)
{
	g_return_if_fail (st != NULL);
}


void
vala_code_visitor_visit_struct (ValaCodeVisitor* self,
                                ValaStruct* st)
{
	g_return_if_fail (self != NULL);
	VALA_CODE_VISITOR_GET_CLASS (self)->visit_struct (self, st);
}


/**
 * Visit operation called for interfaces.
 *
 * @param iface an interface
 */
static void
vala_code_visitor_real_visit_interface (ValaCodeVisitor* self,
                                        ValaInterface* iface)
{
	g_return_if_fail (iface != NULL);
}


void
vala_code_visitor_visit_interface (ValaCodeVisitor* self,
                                   ValaInterface* iface)
{
	g_return_if_fail (self != NULL);
	VALA_CODE_VISITOR_GET_CLASS (self)->visit_interface (self, iface);
}


/**
 * Visit operation called for enums.
 *
 * @param en an enum
 */
static void
vala_code_visitor_real_visit_enum (ValaCodeVisitor* self,
                                   ValaEnum* en)
{
	g_return_if_fail (en != NULL);
}


void
vala_code_visitor_visit_enum (ValaCodeVisitor* self,
                              ValaEnum* en)
{
	g_return_if_fail (self != NULL);
	VALA_CODE_VISITOR_GET_CLASS (self)->visit_enum (self, en);
}


/**
 * Visit operation called for enum values.
 *
 * @param ev an enum value
 */
static void
vala_code_visitor_real_visit_enum_value (ValaCodeVisitor* self,
                                         ValaEnumValue* ev)
{
	g_return_if_fail (ev != NULL);
}


void
vala_code_visitor_visit_enum_value (ValaCodeVisitor* self,
                                    ValaEnumValue* ev)
{
	g_return_if_fail (self != NULL);
	VALA_CODE_VISITOR_GET_CLASS (self)->visit_enum_value (self, ev);
}


/**
 * Visit operation called for error domains.
 *
 * @param edomain an error domain
 */
static void
vala_code_visitor_real_visit_error_domain (ValaCodeVisitor* self,
                                           ValaErrorDomain* edomain)
{
	g_return_if_fail (edomain != NULL);
}


void
vala_code_visitor_visit_error_domain (ValaCodeVisitor* self,
                                      ValaErrorDomain* edomain)
{
	g_return_if_fail (self != NULL);
	VALA_CODE_VISITOR_GET_CLASS (self)->visit_error_domain (self, edomain);
}


/**
 * Visit operation called for error codes.
 *
 * @param ecode an error code
 */
static void
vala_code_visitor_real_visit_error_code (ValaCodeVisitor* self,
                                         ValaErrorCode* ecode)
{
	g_return_if_fail (ecode != NULL);
}


void
vala_code_visitor_visit_error_code (ValaCodeVisitor* self,
                                    ValaErrorCode* ecode)
{
	g_return_if_fail (self != NULL);
	VALA_CODE_VISITOR_GET_CLASS (self)->visit_error_code (self, ecode);
}


/**
 * Visit operation called for delegates.
 *
 * @param d a delegate
 */
static void
vala_code_visitor_real_visit_delegate (ValaCodeVisitor* self,
                                       ValaDelegate* d)
{
	g_return_if_fail (d != NULL);
}


void
vala_code_visitor_visit_delegate (ValaCodeVisitor* self,
                                  ValaDelegate* d)
{
	g_return_if_fail (self != NULL);
	VALA_CODE_VISITOR_GET_CLASS (self)->visit_delegate (self, d);
}


/**
 * Visit operation called for constants.
 *
 * @param c a constant
 */
static void
vala_code_visitor_real_visit_constant (ValaCodeVisitor* self,
                                       ValaConstant* c)
{
	g_return_if_fail (c != NULL);
}


void
vala_code_visitor_visit_constant (ValaCodeVisitor* self,
                                  ValaConstant* c)
{
	g_return_if_fail (self != NULL);
	VALA_CODE_VISITOR_GET_CLASS (self)->visit_constant (self, c);
}


/**
 * Visit operation called for fields.
 *
 * @param f a field
 */
static void
vala_code_visitor_real_visit_field (ValaCodeVisitor* self,
                                    ValaField* f)
{
	g_return_if_fail (f != NULL);
}


void
vala_code_visitor_visit_field (ValaCodeVisitor* self,
                               ValaField* f)
{
	g_return_if_fail (self != NULL);
	VALA_CODE_VISITOR_GET_CLASS (self)->visit_field (self, f);
}


/**
 * Visit operation called for methods.
 *
 * @param m a method
 */
static void
vala_code_visitor_real_visit_method (ValaCodeVisitor* self,
                                     ValaMethod* m)
{
	g_return_if_fail (m != NULL);
}


void
vala_code_visitor_visit_method (ValaCodeVisitor* self,
                                ValaMethod* m)
{
	g_return_if_fail (self != NULL);
	VALA_CODE_VISITOR_GET_CLASS (self)->visit_method (self, m);
}


/**
 * Visit operation called for creation methods.
 *
 * @param m a method
 */
static void
vala_code_visitor_real_visit_creation_method (ValaCodeVisitor* self,
                                              ValaCreationMethod* m)
{
	g_return_if_fail (m != NULL);
}


void
vala_code_visitor_visit_creation_method (ValaCodeVisitor* self,
                                         ValaCreationMethod* m)
{
	g_return_if_fail (self != NULL);
	VALA_CODE_VISITOR_GET_CLASS (self)->visit_creation_method (self, m);
}


/**
 * Visit operation called for formal parameters.
 *
 * @param p a formal parameter
 */
static void
vala_code_visitor_real_visit_formal_parameter (ValaCodeVisitor* self,
                                               ValaParameter* p)
{
	g_return_if_fail (p != NULL);
}


void
vala_code_visitor_visit_formal_parameter (ValaCodeVisitor* self,
                                          ValaParameter* p)
{
	g_return_if_fail (self != NULL);
	VALA_CODE_VISITOR_GET_CLASS (self)->visit_formal_parameter (self, p);
}


/**
 * Visit operation called for properties.
 *
 * @param prop a property
 */
static void
vala_code_visitor_real_visit_property (ValaCodeVisitor* self,
                                       ValaProperty* prop)
{
	g_return_if_fail (prop != NULL);
}


void
vala_code_visitor_visit_property (ValaCodeVisitor* self,
                                  ValaProperty* prop)
{
	g_return_if_fail (self != NULL);
	VALA_CODE_VISITOR_GET_CLASS (self)->visit_property (self, prop);
}


/**
 * Visit operation called for property accessors.
 *
 * @param acc a property accessor
 */
static void
vala_code_visitor_real_visit_property_accessor (ValaCodeVisitor* self,
                                                ValaPropertyAccessor* acc)
{
	g_return_if_fail (acc != NULL);
}


void
vala_code_visitor_visit_property_accessor (ValaCodeVisitor* self,
                                           ValaPropertyAccessor* acc)
{
	g_return_if_fail (self != NULL);
	VALA_CODE_VISITOR_GET_CLASS (self)->visit_property_accessor (self, acc);
}


/**
 * Visit operation called for signals.
 *
 * @param sig a signal
 */
static void
vala_code_visitor_real_visit_signal (ValaCodeVisitor* self,
                                     ValaSignal* sig)
{
	g_return_if_fail (sig != NULL);
}


void
vala_code_visitor_visit_signal (ValaCodeVisitor* self,
                                ValaSignal* sig)
{
	g_return_if_fail (self != NULL);
	VALA_CODE_VISITOR_GET_CLASS (self)->visit_signal (self, sig);
}


/**
 * Visit operation called for constructors.
 *
 * @param c a constructor
 */
static void
vala_code_visitor_real_visit_constructor (ValaCodeVisitor* self,
                                          ValaConstructor* c)
{
	g_return_if_fail (c != NULL);
}


void
vala_code_visitor_visit_constructor (ValaCodeVisitor* self,
                                     ValaConstructor* c)
{
	g_return_if_fail (self != NULL);
	VALA_CODE_VISITOR_GET_CLASS (self)->visit_constructor (self, c);
}


/**
 * Visit operation called for destructors.
 *
 * @param d a destructor
 */
static void
vala_code_visitor_real_visit_destructor (ValaCodeVisitor* self,
                                         ValaDestructor* d)
{
	g_return_if_fail (d != NULL);
}


void
vala_code_visitor_visit_destructor (ValaCodeVisitor* self,
                                    ValaDestructor* d)
{
	g_return_if_fail (self != NULL);
	VALA_CODE_VISITOR_GET_CLASS (self)->visit_destructor (self, d);
}


/**
 * Visit operation called for type parameters.
 *
 * @param p a type parameter
 */
static void
vala_code_visitor_real_visit_type_parameter (ValaCodeVisitor* self,
                                             ValaTypeParameter* p)
{
	g_return_if_fail (p != NULL);
}


void
vala_code_visitor_visit_type_parameter (ValaCodeVisitor* self,
                                        ValaTypeParameter* p)
{
	g_return_if_fail (self != NULL);
	VALA_CODE_VISITOR_GET_CLASS (self)->visit_type_parameter (self, p);
}


/**
 * Visit operation called for using directives.
 *
 * @param ns a using directive
 */
static void
vala_code_visitor_real_visit_using_directive (ValaCodeVisitor* self,
                                              ValaUsingDirective* ns)
{
	g_return_if_fail (ns != NULL);
}


void
vala_code_visitor_visit_using_directive (ValaCodeVisitor* self,
                                         ValaUsingDirective* ns)
{
	g_return_if_fail (self != NULL);
	VALA_CODE_VISITOR_GET_CLASS (self)->visit_using_directive (self, ns);
}


/**
 * Visit operation called for type references.
 *
 * @param type a type reference
 */
static void
vala_code_visitor_real_visit_data_type (ValaCodeVisitor* self,
                                        ValaDataType* type)
{
	g_return_if_fail (type != NULL);
}


void
vala_code_visitor_visit_data_type (ValaCodeVisitor* self,
                                   ValaDataType* type)
{
	g_return_if_fail (self != NULL);
	VALA_CODE_VISITOR_GET_CLASS (self)->visit_data_type (self, type);
}


/**
 * Visit operation called for blocks.
 *
 * @param b a block
 */
static void
vala_code_visitor_real_visit_block (ValaCodeVisitor* self,
                                    ValaBlock* b)
{
	g_return_if_fail (b != NULL);
}


void
vala_code_visitor_visit_block (ValaCodeVisitor* self,
                               ValaBlock* b)
{
	g_return_if_fail (self != NULL);
	VALA_CODE_VISITOR_GET_CLASS (self)->visit_block (self, b);
}


/**
 * Visit operation called for empty statements.
 *
 * @param stmt an empty statement
 */
static void
vala_code_visitor_real_visit_empty_statement (ValaCodeVisitor* self,
                                              ValaEmptyStatement* stmt)
{
	g_return_if_fail (stmt != NULL);
}


void
vala_code_visitor_visit_empty_statement (ValaCodeVisitor* self,
                                         ValaEmptyStatement* stmt)
{
	g_return_if_fail (self != NULL);
	VALA_CODE_VISITOR_GET_CLASS (self)->visit_empty_statement (self, stmt);
}


/**
 * Visit operation called for declaration statements.
 *
 * @param stmt a declaration statement
 */
static void
vala_code_visitor_real_visit_declaration_statement (ValaCodeVisitor* self,
                                                    ValaDeclarationStatement* stmt)
{
	g_return_if_fail (stmt != NULL);
}


void
vala_code_visitor_visit_declaration_statement (ValaCodeVisitor* self,
                                               ValaDeclarationStatement* stmt)
{
	g_return_if_fail (self != NULL);
	VALA_CODE_VISITOR_GET_CLASS (self)->visit_declaration_statement (self, stmt);
}


/**
 * Visit operation called for local variables.
 *
 * @param local a local variable
 */
static void
vala_code_visitor_real_visit_local_variable (ValaCodeVisitor* self,
                                             ValaLocalVariable* local)
{
	g_return_if_fail (local != NULL);
}


void
vala_code_visitor_visit_local_variable (ValaCodeVisitor* self,
                                        ValaLocalVariable* local)
{
	g_return_if_fail (self != NULL);
	VALA_CODE_VISITOR_GET_CLASS (self)->visit_local_variable (self, local);
}


/**
 * Visit operation called for initializer lists
 *
 * @param list an initializer list
 */
static void
vala_code_visitor_real_visit_initializer_list (ValaCodeVisitor* self,
                                               ValaInitializerList* list)
{
	g_return_if_fail (list != NULL);
}


void
vala_code_visitor_visit_initializer_list (ValaCodeVisitor* self,
                                          ValaInitializerList* list)
{
	g_return_if_fail (self != NULL);
	VALA_CODE_VISITOR_GET_CLASS (self)->visit_initializer_list (self, list);
}


/**
 * Visit operation called for expression statements.
 *
 * @param stmt an expression statement
 */
static void
vala_code_visitor_real_visit_expression_statement (ValaCodeVisitor* self,
                                                   ValaExpressionStatement* stmt)
{
	g_return_if_fail (stmt != NULL);
}


void
vala_code_visitor_visit_expression_statement (ValaCodeVisitor* self,
                                              ValaExpressionStatement* stmt)
{
	g_return_if_fail (self != NULL);
	VALA_CODE_VISITOR_GET_CLASS (self)->visit_expression_statement (self, stmt);
}


/**
 * Visit operation called for if statements.
 *
 * @param stmt an if statement
 */
static void
vala_code_visitor_real_visit_if_statement (ValaCodeVisitor* self,
                                           ValaIfStatement* stmt)
{
	g_return_if_fail (stmt != NULL);
}


void
vala_code_visitor_visit_if_statement (ValaCodeVisitor* self,
                                      ValaIfStatement* stmt)
{
	g_return_if_fail (self != NULL);
	VALA_CODE_VISITOR_GET_CLASS (self)->visit_if_statement (self, stmt);
}


/**
 * Visit operation called for switch statements.
 *
 * @param stmt a switch statement
 */
static void
vala_code_visitor_real_visit_switch_statement (ValaCodeVisitor* self,
                                               ValaSwitchStatement* stmt)
{
	g_return_if_fail (stmt != NULL);
}


void
vala_code_visitor_visit_switch_statement (ValaCodeVisitor* self,
                                          ValaSwitchStatement* stmt)
{
	g_return_if_fail (self != NULL);
	VALA_CODE_VISITOR_GET_CLASS (self)->visit_switch_statement (self, stmt);
}


/**
 * Visit operation called for switch sections.
 *
 * @param section a switch section
 */
static void
vala_code_visitor_real_visit_switch_section (ValaCodeVisitor* self,
                                             ValaSwitchSection* section)
{
	g_return_if_fail (section != NULL);
}


void
vala_code_visitor_visit_switch_section (ValaCodeVisitor* self,
                                        ValaSwitchSection* section)
{
	g_return_if_fail (self != NULL);
	VALA_CODE_VISITOR_GET_CLASS (self)->visit_switch_section (self, section);
}


/**
 * Visit operation called for switch label.
 *
 * @param label a switch label
 */
static void
vala_code_visitor_real_visit_switch_label (ValaCodeVisitor* self,
                                           ValaSwitchLabel* label)
{
	g_return_if_fail (label != NULL);
}


void
vala_code_visitor_visit_switch_label (ValaCodeVisitor* self,
                                      ValaSwitchLabel* label)
{
	g_return_if_fail (self != NULL);
	VALA_CODE_VISITOR_GET_CLASS (self)->visit_switch_label (self, label);
}


/**
 * Visit operation called for loops.
 *
 * @param stmt a loop
 */
static void
vala_code_visitor_real_visit_loop (ValaCodeVisitor* self,
                                   ValaLoop* stmt)
{
	g_return_if_fail (stmt != NULL);
}


void
vala_code_visitor_visit_loop (ValaCodeVisitor* self,
                              ValaLoop* stmt)
{
	g_return_if_fail (self != NULL);
	VALA_CODE_VISITOR_GET_CLASS (self)->visit_loop (self, stmt);
}


/**
 * Visit operation called for while statements.
 *
 * @param stmt an while statement
 */
static void
vala_code_visitor_real_visit_while_statement (ValaCodeVisitor* self,
                                              ValaWhileStatement* stmt)
{
	g_return_if_fail (stmt != NULL);
}


void
vala_code_visitor_visit_while_statement (ValaCodeVisitor* self,
                                         ValaWhileStatement* stmt)
{
	g_return_if_fail (self != NULL);
	VALA_CODE_VISITOR_GET_CLASS (self)->visit_while_statement (self, stmt);
}


/**
 * Visit operation called for do statements.
 *
 * @param stmt a do statement
 */
static void
vala_code_visitor_real_visit_do_statement (ValaCodeVisitor* self,
                                           ValaDoStatement* stmt)
{
	g_return_if_fail (stmt != NULL);
}


void
vala_code_visitor_visit_do_statement (ValaCodeVisitor* self,
                                      ValaDoStatement* stmt)
{
	g_return_if_fail (self != NULL);
	VALA_CODE_VISITOR_GET_CLASS (self)->visit_do_statement (self, stmt);
}


/**
 * Visit operation called for for statements.
 *
 * @param stmt a for statement
 */
static void
vala_code_visitor_real_visit_for_statement (ValaCodeVisitor* self,
                                            ValaForStatement* stmt)
{
	g_return_if_fail (stmt != NULL);
}


void
vala_code_visitor_visit_for_statement (ValaCodeVisitor* self,
                                       ValaForStatement* stmt)
{
	g_return_if_fail (self != NULL);
	VALA_CODE_VISITOR_GET_CLASS (self)->visit_for_statement (self, stmt);
}


/**
 * Visit operation called for foreach statements.
 *
 * @param stmt a foreach statement
 */
static void
vala_code_visitor_real_visit_foreach_statement (ValaCodeVisitor* self,
                                                ValaForeachStatement* stmt)
{
	g_return_if_fail (stmt != NULL);
}


void
vala_code_visitor_visit_foreach_statement (ValaCodeVisitor* self,
                                           ValaForeachStatement* stmt)
{
	g_return_if_fail (self != NULL);
	VALA_CODE_VISITOR_GET_CLASS (self)->visit_foreach_statement (self, stmt);
}


/**
 * Visit operation called for break statements.
 *
 * @param stmt a break statement
 */
static void
vala_code_visitor_real_visit_break_statement (ValaCodeVisitor* self,
                                              ValaBreakStatement* stmt)
{
	g_return_if_fail (stmt != NULL);
}


void
vala_code_visitor_visit_break_statement (ValaCodeVisitor* self,
                                         ValaBreakStatement* stmt)
{
	g_return_if_fail (self != NULL);
	VALA_CODE_VISITOR_GET_CLASS (self)->visit_break_statement (self, stmt);
}


/**
 * Visit operation called for continue statements.
 *
 * @param stmt a continue statement
 */
static void
vala_code_visitor_real_visit_continue_statement (ValaCodeVisitor* self,
                                                 ValaContinueStatement* stmt)
{
	g_return_if_fail (stmt != NULL);
}


void
vala_code_visitor_visit_continue_statement (ValaCodeVisitor* self,
                                            ValaContinueStatement* stmt)
{
	g_return_if_fail (self != NULL);
	VALA_CODE_VISITOR_GET_CLASS (self)->visit_continue_statement (self, stmt);
}


/**
 * Visit operation called for return statements.
 *
 * @param stmt a return statement
 */
static void
vala_code_visitor_real_visit_return_statement (ValaCodeVisitor* self,
                                               ValaReturnStatement* stmt)
{
	g_return_if_fail (stmt != NULL);
}


void
vala_code_visitor_visit_return_statement (ValaCodeVisitor* self,
                                          ValaReturnStatement* stmt)
{
	g_return_if_fail (self != NULL);
	VALA_CODE_VISITOR_GET_CLASS (self)->visit_return_statement (self, stmt);
}


/**
 * Visit operation called for yield statement.
 *
 * @param y a yield statement
 */
static void
vala_code_visitor_real_visit_yield_statement (ValaCodeVisitor* self,
                                              ValaYieldStatement* y)
{
	g_return_if_fail (y != NULL);
}


void
vala_code_visitor_visit_yield_statement (ValaCodeVisitor* self,
                                         ValaYieldStatement* y)
{
	g_return_if_fail (self != NULL);
	VALA_CODE_VISITOR_GET_CLASS (self)->visit_yield_statement (self, y);
}


/**
 * Visit operation called for throw statements.
 *
 * @param stmt a throw statement
 */
static void
vala_code_visitor_real_visit_throw_statement (ValaCodeVisitor* self,
                                              ValaThrowStatement* stmt)
{
	g_return_if_fail (stmt != NULL);
}


void
vala_code_visitor_visit_throw_statement (ValaCodeVisitor* self,
                                         ValaThrowStatement* stmt)
{
	g_return_if_fail (self != NULL);
	VALA_CODE_VISITOR_GET_CLASS (self)->visit_throw_statement (self, stmt);
}


/**
 * Visit operation called for try statements.
 *
 * @param stmt a try statement
 */
static void
vala_code_visitor_real_visit_try_statement (ValaCodeVisitor* self,
                                            ValaTryStatement* stmt)
{
	g_return_if_fail (stmt != NULL);
}


void
vala_code_visitor_visit_try_statement (ValaCodeVisitor* self,
                                       ValaTryStatement* stmt)
{
	g_return_if_fail (self != NULL);
	VALA_CODE_VISITOR_GET_CLASS (self)->visit_try_statement (self, stmt);
}


/**
 * Visit operation called for catch clauses.
 *
 * @param clause a catch cluase
 */
static void
vala_code_visitor_real_visit_catch_clause (ValaCodeVisitor* self,
                                           ValaCatchClause* clause)
{
	g_return_if_fail (clause != NULL);
}


void
vala_code_visitor_visit_catch_clause (ValaCodeVisitor* self,
                                      ValaCatchClause* clause)
{
	g_return_if_fail (self != NULL);
	VALA_CODE_VISITOR_GET_CLASS (self)->visit_catch_clause (self, clause);
}


/**
 * Visit operation called for lock statements before the body has been visited.
 *
 * @param stmt a lock statement
 */
static void
vala_code_visitor_real_visit_lock_statement (ValaCodeVisitor* self,
                                             ValaLockStatement* stmt)
{
	g_return_if_fail (stmt != NULL);
}


void
vala_code_visitor_visit_lock_statement (ValaCodeVisitor* self,
                                        ValaLockStatement* stmt)
{
	g_return_if_fail (self != NULL);
	VALA_CODE_VISITOR_GET_CLASS (self)->visit_lock_statement (self, stmt);
}


/**
 * Visit operation called for unlock statements.
 *
 * @param stmt an unlock statement
 */
static void
vala_code_visitor_real_visit_unlock_statement (ValaCodeVisitor* self,
                                               ValaUnlockStatement* stmt)
{
	g_return_if_fail (stmt != NULL);
}


void
vala_code_visitor_visit_unlock_statement (ValaCodeVisitor* self,
                                          ValaUnlockStatement* stmt)
{
	g_return_if_fail (self != NULL);
	VALA_CODE_VISITOR_GET_CLASS (self)->visit_unlock_statement (self, stmt);
}


/**
 * Visit operation called for delete statements.
 *
 * @param stmt a delete statement
 */
static void
vala_code_visitor_real_visit_delete_statement (ValaCodeVisitor* self,
                                               ValaDeleteStatement* stmt)
{
	g_return_if_fail (stmt != NULL);
}


void
vala_code_visitor_visit_delete_statement (ValaCodeVisitor* self,
                                          ValaDeleteStatement* stmt)
{
	g_return_if_fail (self != NULL);
	VALA_CODE_VISITOR_GET_CLASS (self)->visit_delete_statement (self, stmt);
}


/**
 * Visit operations called for expresions.
 *
 * @param expr an expression
 */
static void
vala_code_visitor_real_visit_expression (ValaCodeVisitor* self,
                                         ValaExpression* expr)
{
	g_return_if_fail (expr != NULL);
}


void
vala_code_visitor_visit_expression (ValaCodeVisitor* self,
                                    ValaExpression* expr)
{
	g_return_if_fail (self != NULL);
	VALA_CODE_VISITOR_GET_CLASS (self)->visit_expression (self, expr);
}


/**
 * Visit operations called for array creation expresions.
 *
 * @param expr an array creation expression
 */
static void
vala_code_visitor_real_visit_array_creation_expression (ValaCodeVisitor* self,
                                                        ValaArrayCreationExpression* expr)
{
	g_return_if_fail (expr != NULL);
}


void
vala_code_visitor_visit_array_creation_expression (ValaCodeVisitor* self,
                                                   ValaArrayCreationExpression* expr)
{
	g_return_if_fail (self != NULL);
	VALA_CODE_VISITOR_GET_CLASS (self)->visit_array_creation_expression (self, expr);
}


/**
 * Visit operation called for boolean literals.
 *
 * @param lit a boolean literal
 */
static void
vala_code_visitor_real_visit_boolean_literal (ValaCodeVisitor* self,
                                              ValaBooleanLiteral* lit)
{
	g_return_if_fail (lit != NULL);
}


void
vala_code_visitor_visit_boolean_literal (ValaCodeVisitor* self,
                                         ValaBooleanLiteral* lit)
{
	g_return_if_fail (self != NULL);
	VALA_CODE_VISITOR_GET_CLASS (self)->visit_boolean_literal (self, lit);
}


/**
 * Visit operation called for character literals.
 *
 * @param lit a character literal
 */
static void
vala_code_visitor_real_visit_character_literal (ValaCodeVisitor* self,
                                                ValaCharacterLiteral* lit)
{
	g_return_if_fail (lit != NULL);
}


void
vala_code_visitor_visit_character_literal (ValaCodeVisitor* self,
                                           ValaCharacterLiteral* lit)
{
	g_return_if_fail (self != NULL);
	VALA_CODE_VISITOR_GET_CLASS (self)->visit_character_literal (self, lit);
}


/**
 * Visit operation called for integer literals.
 *
 * @param lit an integer literal
 */
static void
vala_code_visitor_real_visit_integer_literal (ValaCodeVisitor* self,
                                              ValaIntegerLiteral* lit)
{
	g_return_if_fail (lit != NULL);
}


void
vala_code_visitor_visit_integer_literal (ValaCodeVisitor* self,
                                         ValaIntegerLiteral* lit)
{
	g_return_if_fail (self != NULL);
	VALA_CODE_VISITOR_GET_CLASS (self)->visit_integer_literal (self, lit);
}


/**
 * Visit operation called for real literals.
 *
 * @param lit a real literal
 */
static void
vala_code_visitor_real_visit_real_literal (ValaCodeVisitor* self,
                                           ValaRealLiteral* lit)
{
	g_return_if_fail (lit != NULL);
}


void
vala_code_visitor_visit_real_literal (ValaCodeVisitor* self,
                                      ValaRealLiteral* lit)
{
	g_return_if_fail (self != NULL);
	VALA_CODE_VISITOR_GET_CLASS (self)->visit_real_literal (self, lit);
}


/**
 * Visit operation called for regex literals.
 *
 * @param lit a regex literal
 */
static void
vala_code_visitor_real_visit_regex_literal (ValaCodeVisitor* self,
                                            ValaRegexLiteral* lit)
{
	g_return_if_fail (lit != NULL);
}


void
vala_code_visitor_visit_regex_literal (ValaCodeVisitor* self,
                                       ValaRegexLiteral* lit)
{
	g_return_if_fail (self != NULL);
	VALA_CODE_VISITOR_GET_CLASS (self)->visit_regex_literal (self, lit);
}


/**
 * Visit operation called for string literals.
 *
 * @param lit a string literal
 */
static void
vala_code_visitor_real_visit_string_literal (ValaCodeVisitor* self,
                                             ValaStringLiteral* lit)
{
	g_return_if_fail (lit != NULL);
}


void
vala_code_visitor_visit_string_literal (ValaCodeVisitor* self,
                                        ValaStringLiteral* lit)
{
	g_return_if_fail (self != NULL);
	VALA_CODE_VISITOR_GET_CLASS (self)->visit_string_literal (self, lit);
}


/**
 * Visit operation called for string templates.
 *
 * @param tmpl a string template
 */
static void
vala_code_visitor_real_visit_template (ValaCodeVisitor* self,
                                       ValaTemplate* tmpl)
{
	g_return_if_fail (tmpl != NULL);
}


void
vala_code_visitor_visit_template (ValaCodeVisitor* self,
                                  ValaTemplate* tmpl)
{
	g_return_if_fail (self != NULL);
	VALA_CODE_VISITOR_GET_CLASS (self)->visit_template (self, tmpl);
}


/**
 * Visit operation called for tuples.
 *
 * @param tuple a tuple
 */
static void
vala_code_visitor_real_visit_tuple (ValaCodeVisitor* self,
                                    ValaTuple* tuple)
{
	g_return_if_fail (tuple != NULL);
}


void
vala_code_visitor_visit_tuple (ValaCodeVisitor* self,
                               ValaTuple* tuple)
{
	g_return_if_fail (self != NULL);
	VALA_CODE_VISITOR_GET_CLASS (self)->visit_tuple (self, tuple);
}


/**
 * Visit operation called for null literals.
 *
 * @param lit a null literal
 */
static void
vala_code_visitor_real_visit_null_literal (ValaCodeVisitor* self,
                                           ValaNullLiteral* lit)
{
	g_return_if_fail (lit != NULL);
}


void
vala_code_visitor_visit_null_literal (ValaCodeVisitor* self,
                                      ValaNullLiteral* lit)
{
	g_return_if_fail (self != NULL);
	VALA_CODE_VISITOR_GET_CLASS (self)->visit_null_literal (self, lit);
}


/**
 * Visit operation called for member access expressions.
 *
 * @param expr a member access expression
 */
static void
vala_code_visitor_real_visit_member_access (ValaCodeVisitor* self,
                                            ValaMemberAccess* expr)
{
	g_return_if_fail (expr != NULL);
}


void
vala_code_visitor_visit_member_access (ValaCodeVisitor* self,
                                       ValaMemberAccess* expr)
{
	g_return_if_fail (self != NULL);
	VALA_CODE_VISITOR_GET_CLASS (self)->visit_member_access (self, expr);
}


/**
 * Visit operation called for invocation expressions.
 *
 * @param expr an invocation expression
 */
static void
vala_code_visitor_real_visit_method_call (ValaCodeVisitor* self,
                                          ValaMethodCall* expr)
{
	g_return_if_fail (expr != NULL);
}


void
vala_code_visitor_visit_method_call (ValaCodeVisitor* self,
                                     ValaMethodCall* expr)
{
	g_return_if_fail (self != NULL);
	VALA_CODE_VISITOR_GET_CLASS (self)->visit_method_call (self, expr);
}


/**
 * Visit operation called for element access expressions.
 *
 * @param expr an element access expression
 */
static void
vala_code_visitor_real_visit_element_access (ValaCodeVisitor* self,
                                             ValaElementAccess* expr)
{
	g_return_if_fail (expr != NULL);
}


void
vala_code_visitor_visit_element_access (ValaCodeVisitor* self,
                                        ValaElementAccess* expr)
{
	g_return_if_fail (self != NULL);
	VALA_CODE_VISITOR_GET_CLASS (self)->visit_element_access (self, expr);
}


/**
 * Visit operation called for array slice expressions.
 *
 * @param expr an array slice expression
 */
static void
vala_code_visitor_real_visit_slice_expression (ValaCodeVisitor* self,
                                               ValaSliceExpression* expr)
{
	g_return_if_fail (expr != NULL);
}


void
vala_code_visitor_visit_slice_expression (ValaCodeVisitor* self,
                                          ValaSliceExpression* expr)
{
	g_return_if_fail (self != NULL);
	VALA_CODE_VISITOR_GET_CLASS (self)->visit_slice_expression (self, expr);
}


/**
 * Visit operation called for base access expressions.
 *
 * @param expr a base access expression
 */
static void
vala_code_visitor_real_visit_base_access (ValaCodeVisitor* self,
                                          ValaBaseAccess* expr)
{
	g_return_if_fail (expr != NULL);
}


void
vala_code_visitor_visit_base_access (ValaCodeVisitor* self,
                                     ValaBaseAccess* expr)
{
	g_return_if_fail (self != NULL);
	VALA_CODE_VISITOR_GET_CLASS (self)->visit_base_access (self, expr);
}


/**
 * Visit operation called for postfix expressions.
 *
 * @param expr a postfix expression
 */
static void
vala_code_visitor_real_visit_postfix_expression (ValaCodeVisitor* self,
                                                 ValaPostfixExpression* expr)
{
	g_return_if_fail (expr != NULL);
}


void
vala_code_visitor_visit_postfix_expression (ValaCodeVisitor* self,
                                            ValaPostfixExpression* expr)
{
	g_return_if_fail (self != NULL);
	VALA_CODE_VISITOR_GET_CLASS (self)->visit_postfix_expression (self, expr);
}


/**
 * Visit operation called for object creation expressions.
 *
 * @param expr an object creation expression
 */
static void
vala_code_visitor_real_visit_object_creation_expression (ValaCodeVisitor* self,
                                                         ValaObjectCreationExpression* expr)
{
	g_return_if_fail (expr != NULL);
}


void
vala_code_visitor_visit_object_creation_expression (ValaCodeVisitor* self,
                                                    ValaObjectCreationExpression* expr)
{
	g_return_if_fail (self != NULL);
	VALA_CODE_VISITOR_GET_CLASS (self)->visit_object_creation_expression (self, expr);
}


/**
 * Visit operation called for sizeof expressions.
 *
 * @param expr a sizeof expression
 */
static void
vala_code_visitor_real_visit_sizeof_expression (ValaCodeVisitor* self,
                                                ValaSizeofExpression* expr)
{
	g_return_if_fail (expr != NULL);
}


void
vala_code_visitor_visit_sizeof_expression (ValaCodeVisitor* self,
                                           ValaSizeofExpression* expr)
{
	g_return_if_fail (self != NULL);
	VALA_CODE_VISITOR_GET_CLASS (self)->visit_sizeof_expression (self, expr);
}


/**
 * Visit operation called for typeof expressions.
 *
 * @param expr a typeof expression
 */
static void
vala_code_visitor_real_visit_typeof_expression (ValaCodeVisitor* self,
                                                ValaTypeofExpression* expr)
{
	g_return_if_fail (expr != NULL);
}


void
vala_code_visitor_visit_typeof_expression (ValaCodeVisitor* self,
                                           ValaTypeofExpression* expr)
{
	g_return_if_fail (self != NULL);
	VALA_CODE_VISITOR_GET_CLASS (self)->visit_typeof_expression (self, expr);
}


/**
 * Visit operation called for unary expressions.
 *
 * @param expr an unary expression
 */
static void
vala_code_visitor_real_visit_unary_expression (ValaCodeVisitor* self,
                                               ValaUnaryExpression* expr)
{
	g_return_if_fail (expr != NULL);
}


void
vala_code_visitor_visit_unary_expression (ValaCodeVisitor* self,
                                          ValaUnaryExpression* expr)
{
	g_return_if_fail (self != NULL);
	VALA_CODE_VISITOR_GET_CLASS (self)->visit_unary_expression (self, expr);
}


/**
 * Visit operation called for call expressions.
 *
 * @param expr a call expression
 */
static void
vala_code_visitor_real_visit_cast_expression (ValaCodeVisitor* self,
                                              ValaCastExpression* expr)
{
	g_return_if_fail (expr != NULL);
}


void
vala_code_visitor_visit_cast_expression (ValaCodeVisitor* self,
                                         ValaCastExpression* expr)
{
	g_return_if_fail (self != NULL);
	VALA_CODE_VISITOR_GET_CLASS (self)->visit_cast_expression (self, expr);
}


/**
 * Visit operation called for named arguments.
 *
 * @param expr a named argument
 */
static void
vala_code_visitor_real_visit_named_argument (ValaCodeVisitor* self,
                                             ValaNamedArgument* expr)
{
	g_return_if_fail (expr != NULL);
}


void
vala_code_visitor_visit_named_argument (ValaCodeVisitor* self,
                                        ValaNamedArgument* expr)
{
	g_return_if_fail (self != NULL);
	VALA_CODE_VISITOR_GET_CLASS (self)->visit_named_argument (self, expr);
}


/**
 * Visit operation called for pointer indirections.
 *
 * @param expr a pointer indirection
 */
static void
vala_code_visitor_real_visit_pointer_indirection (ValaCodeVisitor* self,
                                                  ValaPointerIndirection* expr)
{
	g_return_if_fail (expr != NULL);
}


void
vala_code_visitor_visit_pointer_indirection (ValaCodeVisitor* self,
                                             ValaPointerIndirection* expr)
{
	g_return_if_fail (self != NULL);
	VALA_CODE_VISITOR_GET_CLASS (self)->visit_pointer_indirection (self, expr);
}


/**
 * Visit operation called for address-of expressions.
 *
 * @param expr an address-of expression
 */
static void
vala_code_visitor_real_visit_addressof_expression (ValaCodeVisitor* self,
                                                   ValaAddressofExpression* expr)
{
	g_return_if_fail (expr != NULL);
}


void
vala_code_visitor_visit_addressof_expression (ValaCodeVisitor* self,
                                              ValaAddressofExpression* expr)
{
	g_return_if_fail (self != NULL);
	VALA_CODE_VISITOR_GET_CLASS (self)->visit_addressof_expression (self, expr);
}


/**
 * Visit operation called for reference transfer expressions.
 *
 * @param expr a reference transfer expression
 */
static void
vala_code_visitor_real_visit_reference_transfer_expression (ValaCodeVisitor* self,
                                                            ValaReferenceTransferExpression* expr)
{
	g_return_if_fail (expr != NULL);
}


void
vala_code_visitor_visit_reference_transfer_expression (ValaCodeVisitor* self,
                                                       ValaReferenceTransferExpression* expr)
{
	g_return_if_fail (self != NULL);
	VALA_CODE_VISITOR_GET_CLASS (self)->visit_reference_transfer_expression (self, expr);
}


/**
 * Visit operation called for binary expressions.
 *
 * @param expr a binary expression
 */
static void
vala_code_visitor_real_visit_binary_expression (ValaCodeVisitor* self,
                                                ValaBinaryExpression* expr)
{
	g_return_if_fail (expr != NULL);
}


void
vala_code_visitor_visit_binary_expression (ValaCodeVisitor* self,
                                           ValaBinaryExpression* expr)
{
	g_return_if_fail (self != NULL);
	VALA_CODE_VISITOR_GET_CLASS (self)->visit_binary_expression (self, expr);
}


/**
 * Visit operation called for type checks.
 *
 * @param expr a type check expression
 */
static void
vala_code_visitor_real_visit_type_check (ValaCodeVisitor* self,
                                         ValaTypeCheck* expr)
{
	g_return_if_fail (expr != NULL);
}


void
vala_code_visitor_visit_type_check (ValaCodeVisitor* self,
                                    ValaTypeCheck* expr)
{
	g_return_if_fail (self != NULL);
	VALA_CODE_VISITOR_GET_CLASS (self)->visit_type_check (self, expr);
}


/**
 * Visit operation called for conditional expressions.
 *
 * @param expr a conditional expression
 */
static void
vala_code_visitor_real_visit_conditional_expression (ValaCodeVisitor* self,
                                                     ValaConditionalExpression* expr)
{
	g_return_if_fail (expr != NULL);
}


void
vala_code_visitor_visit_conditional_expression (ValaCodeVisitor* self,
                                                ValaConditionalExpression* expr)
{
	g_return_if_fail (self != NULL);
	VALA_CODE_VISITOR_GET_CLASS (self)->visit_conditional_expression (self, expr);
}


/**
 * Visit operation called for lambda expressions.
 *
 * @param expr a lambda expression
 */
static void
vala_code_visitor_real_visit_lambda_expression (ValaCodeVisitor* self,
                                                ValaLambdaExpression* expr)
{
	g_return_if_fail (expr != NULL);
}


void
vala_code_visitor_visit_lambda_expression (ValaCodeVisitor* self,
                                           ValaLambdaExpression* expr)
{
	g_return_if_fail (self != NULL);
	VALA_CODE_VISITOR_GET_CLASS (self)->visit_lambda_expression (self, expr);
}


/**
 * Visit operation called for assignments.
 *
 * @param a an assignment
 */
static void
vala_code_visitor_real_visit_assignment (ValaCodeVisitor* self,
                                         ValaAssignment* a)
{
	g_return_if_fail (a != NULL);
}


void
vala_code_visitor_visit_assignment (ValaCodeVisitor* self,
                                    ValaAssignment* a)
{
	g_return_if_fail (self != NULL);
	VALA_CODE_VISITOR_GET_CLASS (self)->visit_assignment (self, a);
}


/**
 * Visit operation called at end of full expressions.
 *
 * @param expr a full expression
 */
static void
vala_code_visitor_real_visit_end_full_expression (ValaCodeVisitor* self,
                                                  ValaExpression* expr)
{
	g_return_if_fail (expr != NULL);
}


void
vala_code_visitor_visit_end_full_expression (ValaCodeVisitor* self,
                                             ValaExpression* expr)
{
	g_return_if_fail (self != NULL);
	VALA_CODE_VISITOR_GET_CLASS (self)->visit_end_full_expression (self, expr);
}


ValaCodeVisitor*
vala_code_visitor_construct (GType object_type)
{
	ValaCodeVisitor* self = NULL;
	self = (ValaCodeVisitor*) g_type_create_instance (object_type);
	return self;
}


static void
vala_value_code_visitor_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}


static void
vala_value_code_visitor_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		vala_code_visitor_unref (value->data[0].v_pointer);
	}
}


static void
vala_value_code_visitor_copy_value (const GValue* src_value,
                                    GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_code_visitor_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer
vala_value_code_visitor_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}


static gchar*
vala_value_code_visitor_collect_value (GValue* value,
                                       guint n_collect_values,
                                       GTypeCValue* collect_values,
                                       guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		ValaCodeVisitor * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_code_visitor_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar*
vala_value_code_visitor_lcopy_value (const GValue* value,
                                     guint n_collect_values,
                                     GTypeCValue* collect_values,
                                     guint collect_flags)
{
	ValaCodeVisitor ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_code_visitor_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec*
vala_param_spec_code_visitor (const gchar* name,
                              const gchar* nick,
                              const gchar* blurb,
                              GType object_type,
                              GParamFlags flags)
{
	ValaParamSpecCodeVisitor* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_TYPE_CODE_VISITOR), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer
vala_value_get_code_visitor (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_CODE_VISITOR), NULL);
	return value->data[0].v_pointer;
}


void
vala_value_set_code_visitor (GValue* value,
                             gpointer v_object)
{
	ValaCodeVisitor * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_CODE_VISITOR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_CODE_VISITOR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_code_visitor_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_code_visitor_unref (old);
	}
}


void
vala_value_take_code_visitor (GValue* value,
                              gpointer v_object)
{
	ValaCodeVisitor * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_CODE_VISITOR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_CODE_VISITOR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_code_visitor_unref (old);
	}
}


static void
vala_code_visitor_class_init (ValaCodeVisitorClass * klass)
{
	vala_code_visitor_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeVisitorClass *) klass)->finalize = vala_code_visitor_finalize;
	((ValaCodeVisitorClass *) klass)->visit_source_file = (void (*) (ValaCodeVisitor *, ValaSourceFile*)) vala_code_visitor_real_visit_source_file;
	((ValaCodeVisitorClass *) klass)->visit_namespace = (void (*) (ValaCodeVisitor *, ValaNamespace*)) vala_code_visitor_real_visit_namespace;
	((ValaCodeVisitorClass *) klass)->visit_class = (void (*) (ValaCodeVisitor *, ValaClass*)) vala_code_visitor_real_visit_class;
	((ValaCodeVisitorClass *) klass)->visit_struct = (void (*) (ValaCodeVisitor *, ValaStruct*)) vala_code_visitor_real_visit_struct;
	((ValaCodeVisitorClass *) klass)->visit_interface = (void (*) (ValaCodeVisitor *, ValaInterface*)) vala_code_visitor_real_visit_interface;
	((ValaCodeVisitorClass *) klass)->visit_enum = (void (*) (ValaCodeVisitor *, ValaEnum*)) vala_code_visitor_real_visit_enum;
	((ValaCodeVisitorClass *) klass)->visit_enum_value = (void (*) (ValaCodeVisitor *, ValaEnumValue*)) vala_code_visitor_real_visit_enum_value;
	((ValaCodeVisitorClass *) klass)->visit_error_domain = (void (*) (ValaCodeVisitor *, ValaErrorDomain*)) vala_code_visitor_real_visit_error_domain;
	((ValaCodeVisitorClass *) klass)->visit_error_code = (void (*) (ValaCodeVisitor *, ValaErrorCode*)) vala_code_visitor_real_visit_error_code;
	((ValaCodeVisitorClass *) klass)->visit_delegate = (void (*) (ValaCodeVisitor *, ValaDelegate*)) vala_code_visitor_real_visit_delegate;
	((ValaCodeVisitorClass *) klass)->visit_constant = (void (*) (ValaCodeVisitor *, ValaConstant*)) vala_code_visitor_real_visit_constant;
	((ValaCodeVisitorClass *) klass)->visit_field = (void (*) (ValaCodeVisitor *, ValaField*)) vala_code_visitor_real_visit_field;
	((ValaCodeVisitorClass *) klass)->visit_method = (void (*) (ValaCodeVisitor *, ValaMethod*)) vala_code_visitor_real_visit_method;
	((ValaCodeVisitorClass *) klass)->visit_creation_method = (void (*) (ValaCodeVisitor *, ValaCreationMethod*)) vala_code_visitor_real_visit_creation_method;
	((ValaCodeVisitorClass *) klass)->visit_formal_parameter = (void (*) (ValaCodeVisitor *, ValaParameter*)) vala_code_visitor_real_visit_formal_parameter;
	((ValaCodeVisitorClass *) klass)->visit_property = (void (*) (ValaCodeVisitor *, ValaProperty*)) vala_code_visitor_real_visit_property;
	((ValaCodeVisitorClass *) klass)->visit_property_accessor = (void (*) (ValaCodeVisitor *, ValaPropertyAccessor*)) vala_code_visitor_real_visit_property_accessor;
	((ValaCodeVisitorClass *) klass)->visit_signal = (void (*) (ValaCodeVisitor *, ValaSignal*)) vala_code_visitor_real_visit_signal;
	((ValaCodeVisitorClass *) klass)->visit_constructor = (void (*) (ValaCodeVisitor *, ValaConstructor*)) vala_code_visitor_real_visit_constructor;
	((ValaCodeVisitorClass *) klass)->visit_destructor = (void (*) (ValaCodeVisitor *, ValaDestructor*)) vala_code_visitor_real_visit_destructor;
	((ValaCodeVisitorClass *) klass)->visit_type_parameter = (void (*) (ValaCodeVisitor *, ValaTypeParameter*)) vala_code_visitor_real_visit_type_parameter;
	((ValaCodeVisitorClass *) klass)->visit_using_directive = (void (*) (ValaCodeVisitor *, ValaUsingDirective*)) vala_code_visitor_real_visit_using_directive;
	((ValaCodeVisitorClass *) klass)->visit_data_type = (void (*) (ValaCodeVisitor *, ValaDataType*)) vala_code_visitor_real_visit_data_type;
	((ValaCodeVisitorClass *) klass)->visit_block = (void (*) (ValaCodeVisitor *, ValaBlock*)) vala_code_visitor_real_visit_block;
	((ValaCodeVisitorClass *) klass)->visit_empty_statement = (void (*) (ValaCodeVisitor *, ValaEmptyStatement*)) vala_code_visitor_real_visit_empty_statement;
	((ValaCodeVisitorClass *) klass)->visit_declaration_statement = (void (*) (ValaCodeVisitor *, ValaDeclarationStatement*)) vala_code_visitor_real_visit_declaration_statement;
	((ValaCodeVisitorClass *) klass)->visit_local_variable = (void (*) (ValaCodeVisitor *, ValaLocalVariable*)) vala_code_visitor_real_visit_local_variable;
	((ValaCodeVisitorClass *) klass)->visit_initializer_list = (void (*) (ValaCodeVisitor *, ValaInitializerList*)) vala_code_visitor_real_visit_initializer_list;
	((ValaCodeVisitorClass *) klass)->visit_expression_statement = (void (*) (ValaCodeVisitor *, ValaExpressionStatement*)) vala_code_visitor_real_visit_expression_statement;
	((ValaCodeVisitorClass *) klass)->visit_if_statement = (void (*) (ValaCodeVisitor *, ValaIfStatement*)) vala_code_visitor_real_visit_if_statement;
	((ValaCodeVisitorClass *) klass)->visit_switch_statement = (void (*) (ValaCodeVisitor *, ValaSwitchStatement*)) vala_code_visitor_real_visit_switch_statement;
	((ValaCodeVisitorClass *) klass)->visit_switch_section = (void (*) (ValaCodeVisitor *, ValaSwitchSection*)) vala_code_visitor_real_visit_switch_section;
	((ValaCodeVisitorClass *) klass)->visit_switch_label = (void (*) (ValaCodeVisitor *, ValaSwitchLabel*)) vala_code_visitor_real_visit_switch_label;
	((ValaCodeVisitorClass *) klass)->visit_loop = (void (*) (ValaCodeVisitor *, ValaLoop*)) vala_code_visitor_real_visit_loop;
	((ValaCodeVisitorClass *) klass)->visit_while_statement = (void (*) (ValaCodeVisitor *, ValaWhileStatement*)) vala_code_visitor_real_visit_while_statement;
	((ValaCodeVisitorClass *) klass)->visit_do_statement = (void (*) (ValaCodeVisitor *, ValaDoStatement*)) vala_code_visitor_real_visit_do_statement;
	((ValaCodeVisitorClass *) klass)->visit_for_statement = (void (*) (ValaCodeVisitor *, ValaForStatement*)) vala_code_visitor_real_visit_for_statement;
	((ValaCodeVisitorClass *) klass)->visit_foreach_statement = (void (*) (ValaCodeVisitor *, ValaForeachStatement*)) vala_code_visitor_real_visit_foreach_statement;
	((ValaCodeVisitorClass *) klass)->visit_break_statement = (void (*) (ValaCodeVisitor *, ValaBreakStatement*)) vala_code_visitor_real_visit_break_statement;
	((ValaCodeVisitorClass *) klass)->visit_continue_statement = (void (*) (ValaCodeVisitor *, ValaContinueStatement*)) vala_code_visitor_real_visit_continue_statement;
	((ValaCodeVisitorClass *) klass)->visit_return_statement = (void (*) (ValaCodeVisitor *, ValaReturnStatement*)) vala_code_visitor_real_visit_return_statement;
	((ValaCodeVisitorClass *) klass)->visit_yield_statement = (void (*) (ValaCodeVisitor *, ValaYieldStatement*)) vala_code_visitor_real_visit_yield_statement;
	((ValaCodeVisitorClass *) klass)->visit_throw_statement = (void (*) (ValaCodeVisitor *, ValaThrowStatement*)) vala_code_visitor_real_visit_throw_statement;
	((ValaCodeVisitorClass *) klass)->visit_try_statement = (void (*) (ValaCodeVisitor *, ValaTryStatement*)) vala_code_visitor_real_visit_try_statement;
	((ValaCodeVisitorClass *) klass)->visit_catch_clause = (void (*) (ValaCodeVisitor *, ValaCatchClause*)) vala_code_visitor_real_visit_catch_clause;
	((ValaCodeVisitorClass *) klass)->visit_lock_statement = (void (*) (ValaCodeVisitor *, ValaLockStatement*)) vala_code_visitor_real_visit_lock_statement;
	((ValaCodeVisitorClass *) klass)->visit_unlock_statement = (void (*) (ValaCodeVisitor *, ValaUnlockStatement*)) vala_code_visitor_real_visit_unlock_statement;
	((ValaCodeVisitorClass *) klass)->visit_delete_statement = (void (*) (ValaCodeVisitor *, ValaDeleteStatement*)) vala_code_visitor_real_visit_delete_statement;
	((ValaCodeVisitorClass *) klass)->visit_expression = (void (*) (ValaCodeVisitor *, ValaExpression*)) vala_code_visitor_real_visit_expression;
	((ValaCodeVisitorClass *) klass)->visit_array_creation_expression = (void (*) (ValaCodeVisitor *, ValaArrayCreationExpression*)) vala_code_visitor_real_visit_array_creation_expression;
	((ValaCodeVisitorClass *) klass)->visit_boolean_literal = (void (*) (ValaCodeVisitor *, ValaBooleanLiteral*)) vala_code_visitor_real_visit_boolean_literal;
	((ValaCodeVisitorClass *) klass)->visit_character_literal = (void (*) (ValaCodeVisitor *, ValaCharacterLiteral*)) vala_code_visitor_real_visit_character_literal;
	((ValaCodeVisitorClass *) klass)->visit_integer_literal = (void (*) (ValaCodeVisitor *, ValaIntegerLiteral*)) vala_code_visitor_real_visit_integer_literal;
	((ValaCodeVisitorClass *) klass)->visit_real_literal = (void (*) (ValaCodeVisitor *, ValaRealLiteral*)) vala_code_visitor_real_visit_real_literal;
	((ValaCodeVisitorClass *) klass)->visit_regex_literal = (void (*) (ValaCodeVisitor *, ValaRegexLiteral*)) vala_code_visitor_real_visit_regex_literal;
	((ValaCodeVisitorClass *) klass)->visit_string_literal = (void (*) (ValaCodeVisitor *, ValaStringLiteral*)) vala_code_visitor_real_visit_string_literal;
	((ValaCodeVisitorClass *) klass)->visit_template = (void (*) (ValaCodeVisitor *, ValaTemplate*)) vala_code_visitor_real_visit_template;
	((ValaCodeVisitorClass *) klass)->visit_tuple = (void (*) (ValaCodeVisitor *, ValaTuple*)) vala_code_visitor_real_visit_tuple;
	((ValaCodeVisitorClass *) klass)->visit_null_literal = (void (*) (ValaCodeVisitor *, ValaNullLiteral*)) vala_code_visitor_real_visit_null_literal;
	((ValaCodeVisitorClass *) klass)->visit_member_access = (void (*) (ValaCodeVisitor *, ValaMemberAccess*)) vala_code_visitor_real_visit_member_access;
	((ValaCodeVisitorClass *) klass)->visit_method_call = (void (*) (ValaCodeVisitor *, ValaMethodCall*)) vala_code_visitor_real_visit_method_call;
	((ValaCodeVisitorClass *) klass)->visit_element_access = (void (*) (ValaCodeVisitor *, ValaElementAccess*)) vala_code_visitor_real_visit_element_access;
	((ValaCodeVisitorClass *) klass)->visit_slice_expression = (void (*) (ValaCodeVisitor *, ValaSliceExpression*)) vala_code_visitor_real_visit_slice_expression;
	((ValaCodeVisitorClass *) klass)->visit_base_access = (void (*) (ValaCodeVisitor *, ValaBaseAccess*)) vala_code_visitor_real_visit_base_access;
	((ValaCodeVisitorClass *) klass)->visit_postfix_expression = (void (*) (ValaCodeVisitor *, ValaPostfixExpression*)) vala_code_visitor_real_visit_postfix_expression;
	((ValaCodeVisitorClass *) klass)->visit_object_creation_expression = (void (*) (ValaCodeVisitor *, ValaObjectCreationExpression*)) vala_code_visitor_real_visit_object_creation_expression;
	((ValaCodeVisitorClass *) klass)->visit_sizeof_expression = (void (*) (ValaCodeVisitor *, ValaSizeofExpression*)) vala_code_visitor_real_visit_sizeof_expression;
	((ValaCodeVisitorClass *) klass)->visit_typeof_expression = (void (*) (ValaCodeVisitor *, ValaTypeofExpression*)) vala_code_visitor_real_visit_typeof_expression;
	((ValaCodeVisitorClass *) klass)->visit_unary_expression = (void (*) (ValaCodeVisitor *, ValaUnaryExpression*)) vala_code_visitor_real_visit_unary_expression;
	((ValaCodeVisitorClass *) klass)->visit_cast_expression = (void (*) (ValaCodeVisitor *, ValaCastExpression*)) vala_code_visitor_real_visit_cast_expression;
	((ValaCodeVisitorClass *) klass)->visit_named_argument = (void (*) (ValaCodeVisitor *, ValaNamedArgument*)) vala_code_visitor_real_visit_named_argument;
	((ValaCodeVisitorClass *) klass)->visit_pointer_indirection = (void (*) (ValaCodeVisitor *, ValaPointerIndirection*)) vala_code_visitor_real_visit_pointer_indirection;
	((ValaCodeVisitorClass *) klass)->visit_addressof_expression = (void (*) (ValaCodeVisitor *, ValaAddressofExpression*)) vala_code_visitor_real_visit_addressof_expression;
	((ValaCodeVisitorClass *) klass)->visit_reference_transfer_expression = (void (*) (ValaCodeVisitor *, ValaReferenceTransferExpression*)) vala_code_visitor_real_visit_reference_transfer_expression;
	((ValaCodeVisitorClass *) klass)->visit_binary_expression = (void (*) (ValaCodeVisitor *, ValaBinaryExpression*)) vala_code_visitor_real_visit_binary_expression;
	((ValaCodeVisitorClass *) klass)->visit_type_check = (void (*) (ValaCodeVisitor *, ValaTypeCheck*)) vala_code_visitor_real_visit_type_check;
	((ValaCodeVisitorClass *) klass)->visit_conditional_expression = (void (*) (ValaCodeVisitor *, ValaConditionalExpression*)) vala_code_visitor_real_visit_conditional_expression;
	((ValaCodeVisitorClass *) klass)->visit_lambda_expression = (void (*) (ValaCodeVisitor *, ValaLambdaExpression*)) vala_code_visitor_real_visit_lambda_expression;
	((ValaCodeVisitorClass *) klass)->visit_assignment = (void (*) (ValaCodeVisitor *, ValaAssignment*)) vala_code_visitor_real_visit_assignment;
	((ValaCodeVisitorClass *) klass)->visit_end_full_expression = (void (*) (ValaCodeVisitor *, ValaExpression*)) vala_code_visitor_real_visit_end_full_expression;
}


static void
vala_code_visitor_instance_init (ValaCodeVisitor * self)
{
	self->ref_count = 1;
}


static void
vala_code_visitor_finalize (ValaCodeVisitor * obj)
{
	ValaCodeVisitor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_CODE_VISITOR, ValaCodeVisitor);
	g_signal_handlers_destroy (self);
}


/**
 * Abstract code node visitor for traversing source code tree.
 */
GType
vala_code_visitor_get_type (void)
{
	static volatile gsize vala_code_visitor_type_id__volatile = 0;
	if (g_once_init_enter (&vala_code_visitor_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { vala_value_code_visitor_init, vala_value_code_visitor_free_value, vala_value_code_visitor_copy_value, vala_value_code_visitor_peek_pointer, "p", vala_value_code_visitor_collect_value, "p", vala_value_code_visitor_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ValaCodeVisitorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_code_visitor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCodeVisitor), 0, (GInstanceInitFunc) vala_code_visitor_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType vala_code_visitor_type_id;
		vala_code_visitor_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaCodeVisitor", &g_define_type_info, &g_define_type_fundamental_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&vala_code_visitor_type_id__volatile, vala_code_visitor_type_id);
	}
	return vala_code_visitor_type_id__volatile;
}


gpointer
vala_code_visitor_ref (gpointer instance)
{
	ValaCodeVisitor * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void
vala_code_visitor_unref (gpointer instance)
{
	ValaCodeVisitor * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_CODE_VISITOR_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}



