/* tracker-builder.c generated by valac 0.38.2, the Vala compiler
 * generated from tracker-builder.vala, do not modify */

/*
 * Copyright (C) 2009, Nokia <ivan.frade@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 */
/**
 * SECTION: tracker-sparql-builder
 * @short_description: Creating insertion/update SPARQL queries.
 * @title: TrackerSparqlBuilder
 * @stability: Stable
 * @include: tracker-sparql.h
 *
 * <note>
 * This object is deprecated since 2.0, use #TrackerResource to build
 * SPARQL updates.
 * </note>
 *
 * <para>
 * #TrackerSparqlBuilder is an object what will gather a set of
 * subject/predicate/object triples, together with an optional WHERE clause,
 * in order to create a query that may be issued to tracker-store.
 * </para>
 *
 * <para>
 * When using #TrackerSparqlBuilder, note that you may append several predicates
 * for the same subject, and several objects for the same predicate.
 * </para>
 */
/**
 * TrackerSparqlBuilder:
 *
 * The <structname>TrackerSparqlBuilder</structname> object represents an
 * insertion/update SPARQL query.
 */
/**
 * tracker_sparql_builder_get_result:
 * @self: a #TrackerSparqlBuilder
 *
 * Retrieves a string representation of the constructed SPARQL query.
 *
 * Returns: the created SPARQL query. The string is contained in the
 * #TrackerSparqlBuilder object, and should not be freed by the caller.
 *
 * Since: 0.10
 */
/**
 * tracker_sparql_builder_get_length:
 * @self: a #TrackerSparqlBuilder
 *
 * Returns the number of objects added to @self.
 *
 * Returns: the number of objects contained.
 *
 * Since: 0.10
 */
/**
 * tracker_sparql_builder_get_state:
 * @self: a #TrackerSparqlBuilder
 *
 * Returns the current state of @self
 *
 * Returns: a #TrackerSparqlBuilderState defining the current state of @self
 *
 * Since: 0.10
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <float.h>
#include <math.h>


#define TRACKER_SPARQL_TYPE_BUILDER (tracker_sparql_builder_get_type ())
#define TRACKER_SPARQL_BUILDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_BUILDER, TrackerSparqlBuilder))
#define TRACKER_SPARQL_BUILDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_BUILDER, TrackerSparqlBuilderClass))
#define TRACKER_SPARQL_IS_BUILDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_BUILDER))
#define TRACKER_SPARQL_IS_BUILDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_BUILDER))
#define TRACKER_SPARQL_BUILDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_BUILDER, TrackerSparqlBuilderClass))

typedef struct _TrackerSparqlBuilder TrackerSparqlBuilder;
typedef struct _TrackerSparqlBuilderClass TrackerSparqlBuilderClass;
typedef struct _TrackerSparqlBuilderPrivate TrackerSparqlBuilderPrivate;

#define TRACKER_SPARQL_BUILDER_TYPE_STATE (tracker_sparql_builder_state_get_type ())
enum  {
	TRACKER_SPARQL_BUILDER_DUMMY_PROPERTY,
	TRACKER_SPARQL_BUILDER_RESULT_PROPERTY,
	TRACKER_SPARQL_BUILDER_LENGTH_PROPERTY,
	TRACKER_SPARQL_BUILDER_STATE_PROPERTY,
	TRACKER_SPARQL_BUILDER_LAST_PROPERTY
};
static GParamSpec* tracker_sparql_builder_properties[TRACKER_SPARQL_BUILDER_LAST_PROPERTY];
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _TrackerSparqlBuilder {
	GObject parent_instance;
	TrackerSparqlBuilderPrivate * priv;
};

struct _TrackerSparqlBuilderClass {
	GObjectClass parent_class;
};

typedef enum  {
	TRACKER_SPARQL_BUILDER_STATE_UPDATE,
	TRACKER_SPARQL_BUILDER_STATE_INSERT,
	TRACKER_SPARQL_BUILDER_STATE_DELETE,
	TRACKER_SPARQL_BUILDER_STATE_SUBJECT,
	TRACKER_SPARQL_BUILDER_STATE_PREDICATE,
	TRACKER_SPARQL_BUILDER_STATE_OBJECT,
	TRACKER_SPARQL_BUILDER_STATE_BLANK,
	TRACKER_SPARQL_BUILDER_STATE_WHERE,
	TRACKER_SPARQL_BUILDER_STATE_EMBEDDED_INSERT,
	TRACKER_SPARQL_BUILDER_STATE_GRAPH
} TrackerSparqlBuilderState;

struct _TrackerSparqlBuilderPrivate {
	gint _length;
	TrackerSparqlBuilderState* states;
	gint states_length1;
	gint _states_size_;
	GString* str;
};


static gpointer tracker_sparql_builder_parent_class = NULL;

GType tracker_sparql_builder_get_type (void) G_GNUC_CONST;
GType tracker_sparql_builder_state_get_type (void) G_GNUC_CONST;
#define TRACKER_SPARQL_BUILDER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TRACKER_SPARQL_TYPE_BUILDER, TrackerSparqlBuilderPrivate))
TrackerSparqlBuilder* tracker_sparql_builder_new_update (void);
TrackerSparqlBuilder* tracker_sparql_builder_construct_update (GType object_type);
static void _vala_array_add1 (TrackerSparqlBuilderState* * array, int* length, int* size, TrackerSparqlBuilderState value);
TrackerSparqlBuilder* tracker_sparql_builder_new_embedded_insert (void);
TrackerSparqlBuilder* tracker_sparql_builder_construct_embedded_insert (GType object_type);
static void _vala_array_add2 (TrackerSparqlBuilderState* * array, int* length, int* size, TrackerSparqlBuilderState value);
static void _vala_array_add3 (TrackerSparqlBuilderState* * array, int* length, int* size, TrackerSparqlBuilderState value);
static void _vala_array_add4 (TrackerSparqlBuilderState* * array, int* length, int* size, TrackerSparqlBuilderState value);
void tracker_sparql_builder_insert_open (TrackerSparqlBuilder* self, const gchar* graph) G_GNUC_DEPRECATED;
TrackerSparqlBuilderState tracker_sparql_builder_get_state (TrackerSparqlBuilder* self);
static void _vala_array_add5 (TrackerSparqlBuilderState* * array, int* length, int* size, TrackerSparqlBuilderState value);
void tracker_sparql_builder_insert_silent_open (TrackerSparqlBuilder* self, const gchar* graph) G_GNUC_DEPRECATED;
static void _vala_array_add6 (TrackerSparqlBuilderState* * array, int* length, int* size, TrackerSparqlBuilderState value);
void tracker_sparql_builder_insert_close (TrackerSparqlBuilder* self) G_GNUC_DEPRECATED;
void tracker_sparql_builder_delete_open (TrackerSparqlBuilder* self, const gchar* graph) G_GNUC_DEPRECATED;
static void _vala_array_add7 (TrackerSparqlBuilderState* * array, int* length, int* size, TrackerSparqlBuilderState value);
void tracker_sparql_builder_delete_close (TrackerSparqlBuilder* self) G_GNUC_DEPRECATED;
void tracker_sparql_builder_graph_open (TrackerSparqlBuilder* self, const gchar* graph) G_GNUC_DEPRECATED;
static void _vala_array_add8 (TrackerSparqlBuilderState* * array, int* length, int* size, TrackerSparqlBuilderState value);
void tracker_sparql_builder_graph_close (TrackerSparqlBuilder* self) G_GNUC_DEPRECATED;
void tracker_sparql_builder_where_open (TrackerSparqlBuilder* self) G_GNUC_DEPRECATED;
static void _vala_array_add9 (TrackerSparqlBuilderState* * array, int* length, int* size, TrackerSparqlBuilderState value);
void tracker_sparql_builder_where_close (TrackerSparqlBuilder* self) G_GNUC_DEPRECATED;
void tracker_sparql_builder_subject_variable (TrackerSparqlBuilder* self, const gchar* var_name) G_GNUC_DEPRECATED;
void tracker_sparql_builder_subject (TrackerSparqlBuilder* self, const gchar* s) G_GNUC_DEPRECATED;
void tracker_sparql_builder_object_variable (TrackerSparqlBuilder* self, const gchar* var_name) G_GNUC_DEPRECATED;
void tracker_sparql_builder_object (TrackerSparqlBuilder* self, const gchar* s) G_GNUC_DEPRECATED;
void tracker_sparql_builder_subject_iri (TrackerSparqlBuilder* self, const gchar* iri) G_GNUC_DEPRECATED;
static void _vala_array_add10 (TrackerSparqlBuilderState* * array, int* length, int* size, TrackerSparqlBuilderState value);
void tracker_sparql_builder_predicate_iri (TrackerSparqlBuilder* self, const gchar* iri) G_GNUC_DEPRECATED;
void tracker_sparql_builder_predicate (TrackerSparqlBuilder* self, const gchar* s) G_GNUC_DEPRECATED;
static void _vala_array_add11 (TrackerSparqlBuilderState* * array, int* length, int* size, TrackerSparqlBuilderState value);
void tracker_sparql_builder_object_iri (TrackerSparqlBuilder* self, const gchar* iri) G_GNUC_DEPRECATED;
static void _vala_array_add12 (TrackerSparqlBuilderState* * array, int* length, int* size, TrackerSparqlBuilderState value);
gint tracker_sparql_builder_get_length (TrackerSparqlBuilder* self);
static void tracker_sparql_builder_set_length (TrackerSparqlBuilder* self, gint value);
void tracker_sparql_builder_object_string (TrackerSparqlBuilder* self, const gchar* literal) G_GNUC_DEPRECATED;
gchar* tracker_sparql_escape_string (const gchar* literal);
static void _vala_array_add13 (TrackerSparqlBuilderState* * array, int* length, int* size, TrackerSparqlBuilderState value);
void tracker_sparql_builder_object_unvalidated (TrackerSparqlBuilder* self, const gchar* value) G_GNUC_DEPRECATED;
void tracker_sparql_builder_object_boolean (TrackerSparqlBuilder* self, gboolean literal) G_GNUC_DEPRECATED;
void tracker_sparql_builder_object_int64 (TrackerSparqlBuilder* self, gint64 literal) G_GNUC_DEPRECATED;
void tracker_sparql_builder_object_date (TrackerSparqlBuilder* self, time_t* literal) G_GNUC_DEPRECATED;
void tracker_sparql_builder_object_double (TrackerSparqlBuilder* self, gdouble literal) G_GNUC_DEPRECATED;
void tracker_sparql_builder_object_blank_open (TrackerSparqlBuilder* self) G_GNUC_DEPRECATED;
static void _vala_array_add14 (TrackerSparqlBuilderState* * array, int* length, int* size, TrackerSparqlBuilderState value);
void tracker_sparql_builder_object_blank_close (TrackerSparqlBuilder* self) G_GNUC_DEPRECATED;
static void _vala_array_add15 (TrackerSparqlBuilderState* * array, int* length, int* size, TrackerSparqlBuilderState value);
void tracker_sparql_builder_prepend (TrackerSparqlBuilder* self, const gchar* raw) G_GNUC_DEPRECATED;
void tracker_sparql_builder_append (TrackerSparqlBuilder* self, const gchar* raw) G_GNUC_DEPRECATED;
TrackerSparqlBuilder* tracker_sparql_builder_new (void);
TrackerSparqlBuilder* tracker_sparql_builder_construct (GType object_type);
const gchar* tracker_sparql_builder_get_result (TrackerSparqlBuilder* self);
static void tracker_sparql_builder_finalize (GObject * obj);
static void _vala_tracker_sparql_builder_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_tracker_sparql_builder_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


/**
 * TrackerSparqlBuilderState:
 * @TRACKER_SPARQL_BUILDER_STATE_UPDATE: Builder is generating an UPDATE
 * @TRACKER_SPARQL_BUILDER_STATE_INSERT: Builder is generating an INSERT
 * @TRACKER_SPARQL_BUILDER_STATE_DELETE: Builder is generating a DELETE
 * @TRACKER_SPARQL_BUILDER_STATE_SUBJECT: Builder is generating the subject of the query
 * @TRACKER_SPARQL_BUILDER_STATE_PREDICATE: Builder is generating the predicate of the query
 * @TRACKER_SPARQL_BUILDER_STATE_OBJECT: Builder is generating the object of the query
 * @TRACKER_SPARQL_BUILDER_STATE_BLANK: Builder is generating a blank node subject
 * @TRACKER_SPARQL_BUILDER_STATE_WHERE: Builder is generating the WHERE clause contents
 * @TRACKER_SPARQL_BUILDER_STATE_EMBEDDED_INSERT: Builder is generating an embedded INSERT
 * @TRACKER_SPARQL_BUILDER_STATE_GRAPH: Builder is generating the GRAPH clause contents
 *
 * Enumeration with the possible states of the SPARQL Builder
 */
GType tracker_sparql_builder_state_get_type (void) {
	static volatile gsize tracker_sparql_builder_state_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_sparql_builder_state_type_id__volatile)) {
		static const GEnumValue values[] = {{TRACKER_SPARQL_BUILDER_STATE_UPDATE, "TRACKER_SPARQL_BUILDER_STATE_UPDATE", "update"}, {TRACKER_SPARQL_BUILDER_STATE_INSERT, "TRACKER_SPARQL_BUILDER_STATE_INSERT", "insert"}, {TRACKER_SPARQL_BUILDER_STATE_DELETE, "TRACKER_SPARQL_BUILDER_STATE_DELETE", "delete"}, {TRACKER_SPARQL_BUILDER_STATE_SUBJECT, "TRACKER_SPARQL_BUILDER_STATE_SUBJECT", "subject"}, {TRACKER_SPARQL_BUILDER_STATE_PREDICATE, "TRACKER_SPARQL_BUILDER_STATE_PREDICATE", "predicate"}, {TRACKER_SPARQL_BUILDER_STATE_OBJECT, "TRACKER_SPARQL_BUILDER_STATE_OBJECT", "object"}, {TRACKER_SPARQL_BUILDER_STATE_BLANK, "TRACKER_SPARQL_BUILDER_STATE_BLANK", "blank"}, {TRACKER_SPARQL_BUILDER_STATE_WHERE, "TRACKER_SPARQL_BUILDER_STATE_WHERE", "where"}, {TRACKER_SPARQL_BUILDER_STATE_EMBEDDED_INSERT, "TRACKER_SPARQL_BUILDER_STATE_EMBEDDED_INSERT", "embedded-insert"}, {TRACKER_SPARQL_BUILDER_STATE_GRAPH, "TRACKER_SPARQL_BUILDER_STATE_GRAPH", "graph"}, {0, NULL, NULL}};
		GType tracker_sparql_builder_state_type_id;
		tracker_sparql_builder_state_type_id = g_enum_register_static ("TrackerSparqlBuilderState", values);
		g_once_init_leave (&tracker_sparql_builder_state_type_id__volatile, tracker_sparql_builder_state_type_id);
	}
	return tracker_sparql_builder_state_type_id__volatile;
}


/**
 * tracker_sparql_builder_new_update:
 *
 * Creates an empty #TrackerSparqlBuilder for an update query.
 *
 * Returns: a newly created #TrackerSparqlBuilder. Free with g_object_unref() when done
 *
 * Since: 0.10
 */
static void _vala_array_add1 (TrackerSparqlBuilderState* * array, int* length, int* size, TrackerSparqlBuilderState value) {
#line 178 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	if ((*length) == (*size)) {
#line 178 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 178 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		*array = g_renew (TrackerSparqlBuilderState, *array, *size);
#line 257 "tracker-builder.c"
	}
#line 178 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	(*array)[(*length)++] = value;
#line 261 "tracker-builder.c"
}


TrackerSparqlBuilder* tracker_sparql_builder_construct_update (GType object_type) {
	TrackerSparqlBuilder * self = NULL;
	TrackerSparqlBuilderState* _tmp0_;
	gint _tmp0__length1;
#line 177 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	self = (TrackerSparqlBuilder*) g_object_new (object_type, NULL);
#line 178 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = self->priv->states;
#line 178 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0__length1 = self->priv->states_length1;
#line 178 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_vala_array_add1 (&self->priv->states, &self->priv->states_length1, &self->priv->_states_size_, TRACKER_SPARQL_BUILDER_STATE_UPDATE);
#line 177 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	return self;
#line 279 "tracker-builder.c"
}


TrackerSparqlBuilder* tracker_sparql_builder_new_update (void) {
#line 177 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	return tracker_sparql_builder_construct_update (TRACKER_SPARQL_TYPE_BUILDER);
#line 286 "tracker-builder.c"
}


/**
 * tracker_sparql_builder_new_embedded_insert:
 *
 * Creates a #TrackerSparqlBuilder ready to be embedded in another query. In embedded
 * inserts, the subject is implied (responsibility of the embedder), so only calls to
 * append predicates and objects for the given subject are allowed.
 *
 * Returns: a newly created #TrackerSparqlBuilder. Free with g_object_unref() when done
 *
 * Since: 0.10
 */
static void _vala_array_add2 (TrackerSparqlBuilderState* * array, int* length, int* size, TrackerSparqlBuilderState value) {
#line 193 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	if ((*length) == (*size)) {
#line 193 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 193 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		*array = g_renew (TrackerSparqlBuilderState, *array, *size);
#line 308 "tracker-builder.c"
	}
#line 193 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	(*array)[(*length)++] = value;
#line 312 "tracker-builder.c"
}


static void _vala_array_add3 (TrackerSparqlBuilderState* * array, int* length, int* size, TrackerSparqlBuilderState value) {
#line 194 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	if ((*length) == (*size)) {
#line 194 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 194 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		*array = g_renew (TrackerSparqlBuilderState, *array, *size);
#line 323 "tracker-builder.c"
	}
#line 194 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	(*array)[(*length)++] = value;
#line 327 "tracker-builder.c"
}


static void _vala_array_add4 (TrackerSparqlBuilderState* * array, int* length, int* size, TrackerSparqlBuilderState value) {
#line 195 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	if ((*length) == (*size)) {
#line 195 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 195 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		*array = g_renew (TrackerSparqlBuilderState, *array, *size);
#line 338 "tracker-builder.c"
	}
#line 195 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	(*array)[(*length)++] = value;
#line 342 "tracker-builder.c"
}


TrackerSparqlBuilder* tracker_sparql_builder_construct_embedded_insert (GType object_type) {
	TrackerSparqlBuilder * self = NULL;
	TrackerSparqlBuilderState* _tmp0_;
	gint _tmp0__length1;
	TrackerSparqlBuilderState* _tmp1_;
	gint _tmp1__length1;
	TrackerSparqlBuilderState* _tmp2_;
	gint _tmp2__length1;
#line 192 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	self = (TrackerSparqlBuilder*) g_object_new (object_type, NULL);
#line 193 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = self->priv->states;
#line 193 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0__length1 = self->priv->states_length1;
#line 193 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_vala_array_add2 (&self->priv->states, &self->priv->states_length1, &self->priv->_states_size_, TRACKER_SPARQL_BUILDER_STATE_EMBEDDED_INSERT);
#line 194 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1_ = self->priv->states;
#line 194 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1__length1 = self->priv->states_length1;
#line 194 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_vala_array_add3 (&self->priv->states, &self->priv->states_length1, &self->priv->_states_size_, TRACKER_SPARQL_BUILDER_STATE_INSERT);
#line 195 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2_ = self->priv->states;
#line 195 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2__length1 = self->priv->states_length1;
#line 195 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_vala_array_add4 (&self->priv->states, &self->priv->states_length1, &self->priv->_states_size_, TRACKER_SPARQL_BUILDER_STATE_SUBJECT);
#line 192 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	return self;
#line 376 "tracker-builder.c"
}


TrackerSparqlBuilder* tracker_sparql_builder_new_embedded_insert (void) {
#line 192 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	return tracker_sparql_builder_construct_embedded_insert (TRACKER_SPARQL_TYPE_BUILDER);
#line 383 "tracker-builder.c"
}


/**
 * tracker_sparql_builder_insert_open:
 * @self: a #TrackerSparqlBuilder
 * @graph: graph name, or %NULL.
 *
 * Opens an insertion statement.
 *
 * Since: 0.10
 * Deprecated: 2.0
 */
static void _vala_array_add5 (TrackerSparqlBuilderState* * array, int* length, int* size, TrackerSparqlBuilderState value) {
#line 212 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	if ((*length) == (*size)) {
#line 212 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 212 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		*array = g_renew (TrackerSparqlBuilderState, *array, *size);
#line 404 "tracker-builder.c"
	}
#line 212 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	(*array)[(*length)++] = value;
#line 408 "tracker-builder.c"
}


void tracker_sparql_builder_insert_open (TrackerSparqlBuilder* self, const gchar* graph) {
	TrackerSparqlBuilderState _tmp0_;
	TrackerSparqlBuilderState _tmp1_;
	TrackerSparqlBuilderState* _tmp2_;
	gint _tmp2__length1;
	const gchar* _tmp3_;
#line 209 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (self != NULL);
#line 209 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = tracker_sparql_builder_get_state (self);
#line 209 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1_ = _tmp0_;
#line 209 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_vala_return_if_fail (_tmp1_ == TRACKER_SPARQL_BUILDER_STATE_UPDATE, "state == State.UPDATE");
#line 212 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2_ = self->priv->states;
#line 212 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2__length1 = self->priv->states_length1;
#line 212 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_vala_array_add5 (&self->priv->states, &self->priv->states_length1, &self->priv->_states_size_, TRACKER_SPARQL_BUILDER_STATE_INSERT);
#line 213 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp3_ = graph;
#line 213 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	if (_tmp3_ != NULL) {
#line 436 "tracker-builder.c"
		GString* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
#line 214 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp4_ = self->priv->str;
#line 214 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp5_ = graph;
#line 214 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp6_ = g_strdup_printf ("INSERT INTO <%s> {\n", _tmp5_);
#line 214 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp7_ = _tmp6_;
#line 214 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		g_string_append (_tmp4_, _tmp7_);
#line 214 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		_g_free0 (_tmp7_);
#line 453 "tracker-builder.c"
	} else {
		GString* _tmp8_;
#line 216 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp8_ = self->priv->str;
#line 216 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		g_string_append (_tmp8_, "INSERT {\n");
#line 460 "tracker-builder.c"
	}
}


/**
 * tracker_sparql_builder_insert_silent_open:
 * @self: a #TrackerSparqlBuilder
 * @graph: graph name, or %NULL.
 *
 * Opens a silent insertion statement.
 *
 * Since: 0.10
 * Deprecated: 2.0
 */
static void _vala_array_add6 (TrackerSparqlBuilderState* * array, int* length, int* size, TrackerSparqlBuilderState value) {
#line 233 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	if ((*length) == (*size)) {
#line 233 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 233 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		*array = g_renew (TrackerSparqlBuilderState, *array, *size);
#line 482 "tracker-builder.c"
	}
#line 233 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	(*array)[(*length)++] = value;
#line 486 "tracker-builder.c"
}


void tracker_sparql_builder_insert_silent_open (TrackerSparqlBuilder* self, const gchar* graph) {
	TrackerSparqlBuilderState _tmp0_;
	TrackerSparqlBuilderState _tmp1_;
	TrackerSparqlBuilderState* _tmp2_;
	gint _tmp2__length1;
	const gchar* _tmp3_;
#line 230 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (self != NULL);
#line 230 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = tracker_sparql_builder_get_state (self);
#line 230 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1_ = _tmp0_;
#line 230 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_vala_return_if_fail (_tmp1_ == TRACKER_SPARQL_BUILDER_STATE_UPDATE, "state == State.UPDATE");
#line 233 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2_ = self->priv->states;
#line 233 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2__length1 = self->priv->states_length1;
#line 233 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_vala_array_add6 (&self->priv->states, &self->priv->states_length1, &self->priv->_states_size_, TRACKER_SPARQL_BUILDER_STATE_INSERT);
#line 234 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp3_ = graph;
#line 234 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	if (_tmp3_ != NULL) {
#line 514 "tracker-builder.c"
		GString* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
#line 235 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp4_ = self->priv->str;
#line 235 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp5_ = graph;
#line 235 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp6_ = g_strdup_printf ("INSERT SILENT INTO <%s> {\n", _tmp5_);
#line 235 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp7_ = _tmp6_;
#line 235 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		g_string_append (_tmp4_, _tmp7_);
#line 235 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		_g_free0 (_tmp7_);
#line 531 "tracker-builder.c"
	} else {
		GString* _tmp8_;
#line 237 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp8_ = self->priv->str;
#line 237 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		g_string_append (_tmp8_, "INSERT SILENT {\n");
#line 538 "tracker-builder.c"
	}
}


/**
 * tracker_sparql_builder_insert_close:
 * @self: a #TrackerSparqlBuilder
 *
 * Closes an insertion statement opened with tracker_sparql_builder_insert_open().
 *
 * Since: 0.10
 * Deprecated: 2.0
 */
void tracker_sparql_builder_insert_close (TrackerSparqlBuilder* self) {
	TrackerSparqlBuilderState _tmp0_;
	TrackerSparqlBuilderState _tmp1_;
	TrackerSparqlBuilderState _tmp2_;
	TrackerSparqlBuilderState _tmp3_;
	TrackerSparqlBuilderState _tmp4_;
	TrackerSparqlBuilderState _tmp5_;
	gint _tmp8_;
	TrackerSparqlBuilderState _tmp9_;
	TrackerSparqlBuilderState _tmp10_;
#line 250 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (self != NULL);
#line 250 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = tracker_sparql_builder_get_state (self);
#line 250 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1_ = _tmp0_;
#line 250 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2_ = tracker_sparql_builder_get_state (self);
#line 250 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp3_ = _tmp2_;
#line 250 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_vala_return_if_fail ((_tmp1_ == TRACKER_SPARQL_BUILDER_STATE_INSERT) || (_tmp3_ == TRACKER_SPARQL_BUILDER_STATE_OBJECT), "state == State.INSERT || state == State.OBJECT");
#line 253 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp4_ = tracker_sparql_builder_get_state (self);
#line 253 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp5_ = _tmp4_;
#line 253 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	if (_tmp5_ == TRACKER_SPARQL_BUILDER_STATE_OBJECT) {
#line 580 "tracker-builder.c"
		GString* _tmp6_;
		gint _tmp7_;
#line 254 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp6_ = self->priv->str;
#line 254 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		g_string_append (_tmp6_, " .\n");
#line 255 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		self->priv->states_length1 = self->priv->states_length1 - 3;
#line 255 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp7_ = self->priv->states_length1;
#line 591 "tracker-builder.c"
	}
#line 257 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp8_ = self->priv->states_length1;
#line 257 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	self->priv->states_length1 = _tmp8_ - 1;
#line 259 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp9_ = tracker_sparql_builder_get_state (self);
#line 259 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp10_ = _tmp9_;
#line 259 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	if (_tmp10_ != TRACKER_SPARQL_BUILDER_STATE_EMBEDDED_INSERT) {
#line 603 "tracker-builder.c"
		GString* _tmp11_;
#line 260 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp11_ = self->priv->str;
#line 260 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		g_string_append (_tmp11_, "}\n");
#line 609 "tracker-builder.c"
	}
}


/**
 * tracker_sparql_builder_delete_open:
 * @self: a #TrackerSparqlBuilder
 * @graph: graph name, or %NULL.
 *
 * Opens a DELETE clause. Data triples may be appended in order to prepare
 * a query to delete them.
 *
 * Since: 0.10
 * Deprecated: 2.0
 */
static void _vala_array_add7 (TrackerSparqlBuilderState* * array, int* length, int* size, TrackerSparqlBuilderState value) {
#line 279 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	if ((*length) == (*size)) {
#line 279 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 279 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		*array = g_renew (TrackerSparqlBuilderState, *array, *size);
#line 632 "tracker-builder.c"
	}
#line 279 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	(*array)[(*length)++] = value;
#line 636 "tracker-builder.c"
}


void tracker_sparql_builder_delete_open (TrackerSparqlBuilder* self, const gchar* graph) {
	TrackerSparqlBuilderState _tmp0_;
	TrackerSparqlBuilderState _tmp1_;
	TrackerSparqlBuilderState* _tmp2_;
	gint _tmp2__length1;
	const gchar* _tmp3_;
#line 276 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (self != NULL);
#line 276 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = tracker_sparql_builder_get_state (self);
#line 276 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1_ = _tmp0_;
#line 276 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_vala_return_if_fail (_tmp1_ == TRACKER_SPARQL_BUILDER_STATE_UPDATE, "state == State.UPDATE");
#line 279 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2_ = self->priv->states;
#line 279 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2__length1 = self->priv->states_length1;
#line 279 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_vala_array_add7 (&self->priv->states, &self->priv->states_length1, &self->priv->_states_size_, TRACKER_SPARQL_BUILDER_STATE_DELETE);
#line 280 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp3_ = graph;
#line 280 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	if (_tmp3_ != NULL) {
#line 664 "tracker-builder.c"
		GString* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
#line 281 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp4_ = self->priv->str;
#line 281 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp5_ = graph;
#line 281 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp6_ = g_strdup_printf ("DELETE FROM <%s> {\n", _tmp5_);
#line 281 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp7_ = _tmp6_;
#line 281 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		g_string_append (_tmp4_, _tmp7_);
#line 281 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		_g_free0 (_tmp7_);
#line 681 "tracker-builder.c"
	} else {
		GString* _tmp8_;
#line 283 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp8_ = self->priv->str;
#line 283 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		g_string_append (_tmp8_, "DELETE {\n");
#line 688 "tracker-builder.c"
	}
}


/**
 * tracker_sparql_builder_delete_close:
 * @self: a #TrackerSparqlBuilder
 *
 * Closes a DELETE clause opened through tracker_sparql_builder_delete_open().
 *
 * Since: 0.10
 * Deprecated: 2.0
 */
void tracker_sparql_builder_delete_close (TrackerSparqlBuilder* self) {
	TrackerSparqlBuilderState _tmp0_;
	TrackerSparqlBuilderState _tmp1_;
	TrackerSparqlBuilderState _tmp2_;
	TrackerSparqlBuilderState _tmp3_;
	TrackerSparqlBuilderState _tmp4_;
	TrackerSparqlBuilderState _tmp5_;
	gint _tmp8_;
	GString* _tmp9_;
#line 296 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (self != NULL);
#line 296 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = tracker_sparql_builder_get_state (self);
#line 296 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1_ = _tmp0_;
#line 296 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2_ = tracker_sparql_builder_get_state (self);
#line 296 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp3_ = _tmp2_;
#line 296 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_vala_return_if_fail ((_tmp1_ == TRACKER_SPARQL_BUILDER_STATE_DELETE) || (_tmp3_ == TRACKER_SPARQL_BUILDER_STATE_OBJECT), "state == State.DELETE || state == State.OBJECT");
#line 299 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp4_ = tracker_sparql_builder_get_state (self);
#line 299 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp5_ = _tmp4_;
#line 299 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	if (_tmp5_ == TRACKER_SPARQL_BUILDER_STATE_OBJECT) {
#line 729 "tracker-builder.c"
		GString* _tmp6_;
		gint _tmp7_;
#line 300 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp6_ = self->priv->str;
#line 300 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		g_string_append (_tmp6_, " .\n");
#line 301 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		self->priv->states_length1 = self->priv->states_length1 - 3;
#line 301 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp7_ = self->priv->states_length1;
#line 740 "tracker-builder.c"
	}
#line 303 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp8_ = self->priv->states_length1;
#line 303 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	self->priv->states_length1 = _tmp8_ - 1;
#line 305 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp9_ = self->priv->str;
#line 305 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_string_append (_tmp9_, "}\n");
#line 750 "tracker-builder.c"
}


/**
 * tracker_sparql_builder_graph_open:
 * @self: a #TrackerSparqlBuilder
 * @graph: graph name.
 *
 * Opens a GRAPH clause within INSERT, DELETE, or WHERE.
 *
 * Since: 0.10
 * Deprecated: 2.0
 */
static void _vala_array_add8 (TrackerSparqlBuilderState* * array, int* length, int* size, TrackerSparqlBuilderState value) {
#line 322 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	if ((*length) == (*size)) {
#line 322 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 322 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		*array = g_renew (TrackerSparqlBuilderState, *array, *size);
#line 771 "tracker-builder.c"
	}
#line 322 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	(*array)[(*length)++] = value;
#line 775 "tracker-builder.c"
}


void tracker_sparql_builder_graph_open (TrackerSparqlBuilder* self, const gchar* graph) {
	TrackerSparqlBuilderState _tmp0_;
	TrackerSparqlBuilderState _tmp1_;
	TrackerSparqlBuilderState _tmp2_;
	TrackerSparqlBuilderState _tmp3_;
	TrackerSparqlBuilderState _tmp4_;
	TrackerSparqlBuilderState _tmp5_;
	TrackerSparqlBuilderState _tmp6_;
	TrackerSparqlBuilderState _tmp7_;
	TrackerSparqlBuilderState _tmp8_;
	TrackerSparqlBuilderState _tmp9_;
	TrackerSparqlBuilderState* _tmp10_;
	gint _tmp10__length1;
	GString* _tmp11_;
	const gchar* _tmp12_;
#line 319 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (self != NULL);
#line 319 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (graph != NULL);
#line 319 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = tracker_sparql_builder_get_state (self);
#line 319 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1_ = _tmp0_;
#line 319 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2_ = tracker_sparql_builder_get_state (self);
#line 319 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp3_ = _tmp2_;
#line 319 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp4_ = tracker_sparql_builder_get_state (self);
#line 319 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp5_ = _tmp4_;
#line 319 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp6_ = tracker_sparql_builder_get_state (self);
#line 319 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp7_ = _tmp6_;
#line 319 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp8_ = tracker_sparql_builder_get_state (self);
#line 319 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp9_ = _tmp8_;
#line 319 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_vala_return_if_fail (((((_tmp1_ == TRACKER_SPARQL_BUILDER_STATE_INSERT) || (_tmp3_ == TRACKER_SPARQL_BUILDER_STATE_DELETE)) || (_tmp5_ == TRACKER_SPARQL_BUILDER_STATE_OBJECT)) || (_tmp7_ == TRACKER_SPARQL_BUILDER_STATE_WHERE)) || (_tmp9_ == TRACKER_SPARQL_BUILDER_STATE_GRAPH), "state == State.INSERT || state == State.DELETE || state == State.OBJECT || state == State.WHERE || state == State.GRAPH");
#line 322 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp10_ = self->priv->states;
#line 322 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp10__length1 = self->priv->states_length1;
#line 322 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_vala_array_add8 (&self->priv->states, &self->priv->states_length1, &self->priv->_states_size_, TRACKER_SPARQL_BUILDER_STATE_GRAPH);
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp11_ = self->priv->str;
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp12_ = graph;
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_string_append_printf (_tmp11_, "GRAPH <%s> {\n", _tmp12_);
#line 832 "tracker-builder.c"
}


/**
 * tracker_sparql_builder_graph_close:
 * @self: a #TrackerSparqlBuilder
 *
 * Closes a GRAPH clause opened through tracker_sparql_builder_graph_open().
 *
 * Since: 0.10
 * Deprecated: 2.0
 */
void tracker_sparql_builder_graph_close (TrackerSparqlBuilder* self) {
	TrackerSparqlBuilderState _tmp0_;
	TrackerSparqlBuilderState _tmp1_;
	TrackerSparqlBuilderState _tmp2_;
	TrackerSparqlBuilderState _tmp3_;
	TrackerSparqlBuilderState _tmp4_;
	TrackerSparqlBuilderState _tmp5_;
	gint _tmp8_;
	GString* _tmp9_;
#line 336 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (self != NULL);
#line 336 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = tracker_sparql_builder_get_state (self);
#line 336 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1_ = _tmp0_;
#line 336 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2_ = tracker_sparql_builder_get_state (self);
#line 336 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp3_ = _tmp2_;
#line 336 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_vala_return_if_fail ((_tmp1_ == TRACKER_SPARQL_BUILDER_STATE_GRAPH) || (_tmp3_ == TRACKER_SPARQL_BUILDER_STATE_OBJECT), "state == State.GRAPH || state == State.OBJECT");
#line 339 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp4_ = tracker_sparql_builder_get_state (self);
#line 339 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp5_ = _tmp4_;
#line 339 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	if (_tmp5_ == TRACKER_SPARQL_BUILDER_STATE_OBJECT) {
#line 872 "tracker-builder.c"
		GString* _tmp6_;
		gint _tmp7_;
#line 340 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp6_ = self->priv->str;
#line 340 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		g_string_append (_tmp6_, " .\n");
#line 341 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		self->priv->states_length1 = self->priv->states_length1 - 3;
#line 341 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp7_ = self->priv->states_length1;
#line 883 "tracker-builder.c"
	}
#line 343 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp8_ = self->priv->states_length1;
#line 343 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	self->priv->states_length1 = _tmp8_ - 1;
#line 345 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp9_ = self->priv->str;
#line 345 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_string_append (_tmp9_, "}\n");
#line 893 "tracker-builder.c"
}


/**
 * tracker_sparql_builder_where_open:
 * @self: a #TrackerSparqlBuilder
 *
 * Opens a WHERE clause. Data triples may be appended then to narrow the scope
 * to which the update query applies.
 *
 * Since: 0.10
 * Deprecated: 2.0
 */
static void _vala_array_add9 (TrackerSparqlBuilderState* * array, int* length, int* size, TrackerSparqlBuilderState value) {
#line 362 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	if ((*length) == (*size)) {
#line 362 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 362 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		*array = g_renew (TrackerSparqlBuilderState, *array, *size);
#line 914 "tracker-builder.c"
	}
#line 362 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	(*array)[(*length)++] = value;
#line 918 "tracker-builder.c"
}


void tracker_sparql_builder_where_open (TrackerSparqlBuilder* self) {
	TrackerSparqlBuilderState _tmp0_;
	TrackerSparqlBuilderState _tmp1_;
	TrackerSparqlBuilderState* _tmp2_;
	gint _tmp2__length1;
	GString* _tmp3_;
#line 359 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (self != NULL);
#line 359 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = tracker_sparql_builder_get_state (self);
#line 359 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1_ = _tmp0_;
#line 359 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_vala_return_if_fail (_tmp1_ == TRACKER_SPARQL_BUILDER_STATE_UPDATE, "state == State.UPDATE");
#line 362 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2_ = self->priv->states;
#line 362 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2__length1 = self->priv->states_length1;
#line 362 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_vala_array_add9 (&self->priv->states, &self->priv->states_length1, &self->priv->_states_size_, TRACKER_SPARQL_BUILDER_STATE_WHERE);
#line 363 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp3_ = self->priv->str;
#line 363 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_string_append (_tmp3_, "WHERE {\n");
#line 946 "tracker-builder.c"
}


/**
 * tracker_sparql_builder_where_close:
 * @self: a #TrackerSparqlBuilder
 *
 * Closes a WHERE clause opened through tracker_sparql_builder_where_open().
 *
 * Since: 0.10
 * Deprecated: 2.0
 */
void tracker_sparql_builder_where_close (TrackerSparqlBuilder* self) {
	TrackerSparqlBuilderState _tmp0_;
	TrackerSparqlBuilderState _tmp1_;
	TrackerSparqlBuilderState _tmp2_;
	TrackerSparqlBuilderState _tmp3_;
	TrackerSparqlBuilderState _tmp4_;
	TrackerSparqlBuilderState _tmp5_;
	gint _tmp8_;
	GString* _tmp9_;
#line 376 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (self != NULL);
#line 376 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = tracker_sparql_builder_get_state (self);
#line 376 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1_ = _tmp0_;
#line 376 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2_ = tracker_sparql_builder_get_state (self);
#line 376 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp3_ = _tmp2_;
#line 376 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_vala_return_if_fail ((_tmp1_ == TRACKER_SPARQL_BUILDER_STATE_WHERE) || (_tmp3_ == TRACKER_SPARQL_BUILDER_STATE_OBJECT), "state == State.WHERE || state == State.OBJECT");
#line 379 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp4_ = tracker_sparql_builder_get_state (self);
#line 379 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp5_ = _tmp4_;
#line 379 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	if (_tmp5_ == TRACKER_SPARQL_BUILDER_STATE_OBJECT) {
#line 986 "tracker-builder.c"
		GString* _tmp6_;
		gint _tmp7_;
#line 380 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp6_ = self->priv->str;
#line 380 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		g_string_append (_tmp6_, " .\n");
#line 381 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		self->priv->states_length1 = self->priv->states_length1 - 3;
#line 381 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp7_ = self->priv->states_length1;
#line 997 "tracker-builder.c"
	}
#line 383 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp8_ = self->priv->states_length1;
#line 383 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	self->priv->states_length1 = _tmp8_ - 1;
#line 384 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp9_ = self->priv->str;
#line 384 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_string_append (_tmp9_, "}\n");
#line 1007 "tracker-builder.c"
}


/**
 * tracker_sparql_builder_subject_variable:
 * @self: a #TrackerSparqlBuilder
 * @var_name: variable name, without leading '?'
 *
 * Appends a subject as a SPARQL variable, such as "?urn".
 *
 * Since: 0.10
 * Deprecated: 2.0
 */
void tracker_sparql_builder_subject_variable (TrackerSparqlBuilder* self, const gchar* var_name) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
#line 398 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (self != NULL);
#line 398 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (var_name != NULL);
#line 399 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = var_name;
#line 399 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1_ = g_strdup_printf ("?%s", _tmp0_);
#line 399 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2_ = _tmp1_;
#line 399 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	tracker_sparql_builder_subject (self, _tmp2_);
#line 399 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_g_free0 (_tmp2_);
#line 1039 "tracker-builder.c"
}


/**
 * tracker_sparql_builder_object_variable:
 * @self: a #TrackerSparqlBuilder
 * @var_name: variable name, without leading '?'
 *
 * Appends an object as a SparQL variable, such as "?urn".
 *
 * Since: 0.10
 * Deprecated: 2.0
 */
void tracker_sparql_builder_object_variable (TrackerSparqlBuilder* self, const gchar* var_name) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
#line 413 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (self != NULL);
#line 413 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (var_name != NULL);
#line 414 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = var_name;
#line 414 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1_ = g_strdup_printf ("?%s", _tmp0_);
#line 414 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2_ = _tmp1_;
#line 414 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	tracker_sparql_builder_object (self, _tmp2_);
#line 414 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_g_free0 (_tmp2_);
#line 1071 "tracker-builder.c"
}


/**
 * tracker_sparql_builder_subject_iri:
 * @self: a #TrackerSparqlBuilder
 * @iri: IRI name, without leading and trailing greater/less than symbols.
 *
 * Appends a subject as an IRI, such as "&lt;urn:file:1234-5678&gt;". IRIs
 * univocally identify a resource in tracker-store.
 *
 * Since: 0.10
 * Deprecated: 2.0
 */
void tracker_sparql_builder_subject_iri (TrackerSparqlBuilder* self, const gchar* iri) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
#line 429 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (self != NULL);
#line 429 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (iri != NULL);
#line 430 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = iri;
#line 430 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1_ = g_strdup_printf ("<%s>", _tmp0_);
#line 430 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2_ = _tmp1_;
#line 430 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	tracker_sparql_builder_subject (self, _tmp2_);
#line 430 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_g_free0 (_tmp2_);
#line 1104 "tracker-builder.c"
}


/**
 * tracker_sparql_builder_subject:
 * @self: a #TrackerSparqlBuilder
 * @s: subject string
 *
 * Appends a subject.
 *
 * Since: 0.10
 * Deprecated: 2.0
 */
static void _vala_array_add10 (TrackerSparqlBuilderState* * array, int* length, int* size, TrackerSparqlBuilderState value) {
#line 452 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	if ((*length) == (*size)) {
#line 452 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 452 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		*array = g_renew (TrackerSparqlBuilderState, *array, *size);
#line 1125 "tracker-builder.c"
	}
#line 452 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	(*array)[(*length)++] = value;
#line 1129 "tracker-builder.c"
}


void tracker_sparql_builder_subject (TrackerSparqlBuilder* self, const gchar* s) {
	TrackerSparqlBuilderState _tmp0_;
	TrackerSparqlBuilderState _tmp1_;
	TrackerSparqlBuilderState _tmp2_;
	TrackerSparqlBuilderState _tmp3_;
	TrackerSparqlBuilderState _tmp4_;
	TrackerSparqlBuilderState _tmp5_;
	TrackerSparqlBuilderState _tmp6_;
	TrackerSparqlBuilderState _tmp7_;
	TrackerSparqlBuilderState _tmp8_;
	TrackerSparqlBuilderState _tmp9_;
	TrackerSparqlBuilderState _tmp10_;
	TrackerSparqlBuilderState _tmp11_;
	TrackerSparqlBuilderState _tmp12_;
	TrackerSparqlBuilderState _tmp13_;
	GString* _tmp16_;
	const gchar* _tmp17_;
	TrackerSparqlBuilderState* _tmp18_;
	gint _tmp18__length1;
#line 444 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (self != NULL);
#line 444 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (s != NULL);
#line 444 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = tracker_sparql_builder_get_state (self);
#line 444 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1_ = _tmp0_;
#line 444 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2_ = tracker_sparql_builder_get_state (self);
#line 444 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp3_ = _tmp2_;
#line 444 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp4_ = tracker_sparql_builder_get_state (self);
#line 444 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp5_ = _tmp4_;
#line 444 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp6_ = tracker_sparql_builder_get_state (self);
#line 444 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp7_ = _tmp6_;
#line 444 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp8_ = tracker_sparql_builder_get_state (self);
#line 444 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp9_ = _tmp8_;
#line 444 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp10_ = tracker_sparql_builder_get_state (self);
#line 444 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp11_ = _tmp10_;
#line 444 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_vala_return_if_fail ((((((_tmp1_ == TRACKER_SPARQL_BUILDER_STATE_INSERT) || (_tmp3_ == TRACKER_SPARQL_BUILDER_STATE_OBJECT)) || (_tmp5_ == TRACKER_SPARQL_BUILDER_STATE_EMBEDDED_INSERT)) || (_tmp7_ == TRACKER_SPARQL_BUILDER_STATE_DELETE)) || (_tmp9_ == TRACKER_SPARQL_BUILDER_STATE_WHERE)) || (_tmp11_ == TRACKER_SPARQL_BUILDER_STATE_GRAPH), "state == State.INSERT || state == State.OBJECT || state == State.EMBEDDED_INSERT || state == State.DELETE || state == State.WHERE || state == State.GRAPH");
#line 447 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp12_ = tracker_sparql_builder_get_state (self);
#line 447 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp13_ = _tmp12_;
#line 447 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	if (_tmp13_ == TRACKER_SPARQL_BUILDER_STATE_OBJECT) {
#line 1188 "tracker-builder.c"
		GString* _tmp14_;
		gint _tmp15_;
#line 448 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp14_ = self->priv->str;
#line 448 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		g_string_append (_tmp14_, " .\n");
#line 449 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		self->priv->states_length1 = self->priv->states_length1 - 3;
#line 449 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp15_ = self->priv->states_length1;
#line 1199 "tracker-builder.c"
	}
#line 451 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp16_ = self->priv->str;
#line 451 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp17_ = s;
#line 451 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_string_append (_tmp16_, _tmp17_);
#line 452 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp18_ = self->priv->states;
#line 452 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp18__length1 = self->priv->states_length1;
#line 452 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_vala_array_add10 (&self->priv->states, &self->priv->states_length1, &self->priv->_states_size_, TRACKER_SPARQL_BUILDER_STATE_SUBJECT);
#line 1213 "tracker-builder.c"
}


/**
 * tracker_sparql_builder_predicate_iri:
 * @self: a #TrackerSparqlBuilder
 * @iri: IRI name, without leading and trailing greater/less than symbols.
 *
 * Appends a predicate as an IRI.
 *
 * Since: 0.10
 * Deprecated: 2.0
 */
void tracker_sparql_builder_predicate_iri (TrackerSparqlBuilder* self, const gchar* iri) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
#line 466 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (self != NULL);
#line 466 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (iri != NULL);
#line 467 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = iri;
#line 467 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1_ = g_strdup_printf ("<%s>", _tmp0_);
#line 467 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2_ = _tmp1_;
#line 467 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	tracker_sparql_builder_predicate (self, _tmp2_);
#line 467 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_g_free0 (_tmp2_);
#line 1245 "tracker-builder.c"
}


/**
 * tracker_sparql_builder_predicate:
 * @self: a #TrackerSparqlBuilder
 * @s: predicate string
 *
 * Appends a predicate for the previously appended subject.
 *
 * Since: 0.10
 * Deprecated: 2.0
 */
static void _vala_array_add11 (TrackerSparqlBuilderState* * array, int* length, int* size, TrackerSparqlBuilderState value) {
#line 490 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	if ((*length) == (*size)) {
#line 490 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 490 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		*array = g_renew (TrackerSparqlBuilderState, *array, *size);
#line 1266 "tracker-builder.c"
	}
#line 490 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	(*array)[(*length)++] = value;
#line 1270 "tracker-builder.c"
}


void tracker_sparql_builder_predicate (TrackerSparqlBuilder* self, const gchar* s) {
	TrackerSparqlBuilderState _tmp0_;
	TrackerSparqlBuilderState _tmp1_;
	TrackerSparqlBuilderState _tmp2_;
	TrackerSparqlBuilderState _tmp3_;
	TrackerSparqlBuilderState _tmp4_;
	TrackerSparqlBuilderState _tmp5_;
	TrackerSparqlBuilderState _tmp6_;
	TrackerSparqlBuilderState _tmp7_;
	GString* _tmp10_;
	GString* _tmp11_;
	const gchar* _tmp12_;
	TrackerSparqlBuilderState* _tmp13_;
	gint _tmp13__length1;
#line 481 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (self != NULL);
#line 481 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (s != NULL);
#line 481 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = tracker_sparql_builder_get_state (self);
#line 481 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1_ = _tmp0_;
#line 481 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2_ = tracker_sparql_builder_get_state (self);
#line 481 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp3_ = _tmp2_;
#line 481 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp4_ = tracker_sparql_builder_get_state (self);
#line 481 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp5_ = _tmp4_;
#line 481 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_vala_return_if_fail (((_tmp1_ == TRACKER_SPARQL_BUILDER_STATE_SUBJECT) || (_tmp3_ == TRACKER_SPARQL_BUILDER_STATE_OBJECT)) || (_tmp5_ == TRACKER_SPARQL_BUILDER_STATE_BLANK), "state == State.SUBJECT || state == State.OBJECT || state == State.BLANK");
#line 484 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp6_ = tracker_sparql_builder_get_state (self);
#line 484 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp7_ = _tmp6_;
#line 484 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	if (_tmp7_ == TRACKER_SPARQL_BUILDER_STATE_OBJECT) {
#line 1312 "tracker-builder.c"
		GString* _tmp8_;
		gint _tmp9_;
#line 485 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp8_ = self->priv->str;
#line 485 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		g_string_append (_tmp8_, " ;\n\t");
#line 486 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		self->priv->states_length1 = self->priv->states_length1 - 2;
#line 486 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp9_ = self->priv->states_length1;
#line 1323 "tracker-builder.c"
	}
#line 488 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp10_ = self->priv->str;
#line 488 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_string_append (_tmp10_, " ");
#line 489 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp11_ = self->priv->str;
#line 489 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp12_ = s;
#line 489 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_string_append (_tmp11_, _tmp12_);
#line 490 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp13_ = self->priv->states;
#line 490 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp13__length1 = self->priv->states_length1;
#line 490 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_vala_array_add11 (&self->priv->states, &self->priv->states_length1, &self->priv->_states_size_, TRACKER_SPARQL_BUILDER_STATE_PREDICATE);
#line 1341 "tracker-builder.c"
}


/**
 * tracker_sparql_builder_object_iri:
 * @self: a #TrackerSparqlBuilder
 * @iri: IRI name, without leading and trailing greater/less than symbols.
 *
 * Appends an object as an IRI.
 *
 * Since: 0.10
 * Deprecated: 2.0
 */
void tracker_sparql_builder_object_iri (TrackerSparqlBuilder* self, const gchar* iri) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
#line 504 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (self != NULL);
#line 504 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (iri != NULL);
#line 505 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = iri;
#line 505 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1_ = g_strdup_printf ("<%s>", _tmp0_);
#line 505 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2_ = _tmp1_;
#line 505 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	tracker_sparql_builder_object (self, _tmp2_);
#line 505 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_g_free0 (_tmp2_);
#line 1373 "tracker-builder.c"
}


/**
 * tracker_sparql_builder_object:
 * @self: a #TrackerSparqlBuilder
 * @s: object string
 *
 * Appends a free-form object for the previously appended subject and predicate.
 *
 * Since: 0.10
 * Deprecated: 2.0
 */
static void _vala_array_add12 (TrackerSparqlBuilderState* * array, int* length, int* size, TrackerSparqlBuilderState value) {
#line 528 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	if ((*length) == (*size)) {
#line 528 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 528 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		*array = g_renew (TrackerSparqlBuilderState, *array, *size);
#line 1394 "tracker-builder.c"
	}
#line 528 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	(*array)[(*length)++] = value;
#line 1398 "tracker-builder.c"
}


void tracker_sparql_builder_object (TrackerSparqlBuilder* self, const gchar* s) {
	TrackerSparqlBuilderState _tmp0_;
	TrackerSparqlBuilderState _tmp1_;
	TrackerSparqlBuilderState _tmp2_;
	TrackerSparqlBuilderState _tmp3_;
	TrackerSparqlBuilderState _tmp4_;
	TrackerSparqlBuilderState _tmp5_;
	GString* _tmp8_;
	GString* _tmp9_;
	const gchar* _tmp10_;
	TrackerSparqlBuilderState* _tmp11_;
	gint _tmp11__length1;
	gint _tmp12_;
#line 519 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (self != NULL);
#line 519 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (s != NULL);
#line 519 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = tracker_sparql_builder_get_state (self);
#line 519 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1_ = _tmp0_;
#line 519 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2_ = tracker_sparql_builder_get_state (self);
#line 519 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp3_ = _tmp2_;
#line 519 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_vala_return_if_fail ((_tmp1_ == TRACKER_SPARQL_BUILDER_STATE_PREDICATE) || (_tmp3_ == TRACKER_SPARQL_BUILDER_STATE_OBJECT), "state == State.PREDICATE || state == State.OBJECT");
#line 522 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp4_ = tracker_sparql_builder_get_state (self);
#line 522 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp5_ = _tmp4_;
#line 522 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	if (_tmp5_ == TRACKER_SPARQL_BUILDER_STATE_OBJECT) {
#line 1435 "tracker-builder.c"
		GString* _tmp6_;
		gint _tmp7_;
#line 523 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp6_ = self->priv->str;
#line 523 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		g_string_append (_tmp6_, " ,");
#line 524 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp7_ = self->priv->states_length1;
#line 524 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		self->priv->states_length1 = _tmp7_ - 1;
#line 1446 "tracker-builder.c"
	}
#line 526 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp8_ = self->priv->str;
#line 526 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_string_append (_tmp8_, " ");
#line 527 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp9_ = self->priv->str;
#line 527 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp10_ = s;
#line 527 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_string_append (_tmp9_, _tmp10_);
#line 528 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp11_ = self->priv->states;
#line 528 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp11__length1 = self->priv->states_length1;
#line 528 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_vala_array_add12 (&self->priv->states, &self->priv->states_length1, &self->priv->_states_size_, TRACKER_SPARQL_BUILDER_STATE_OBJECT);
#line 530 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp12_ = self->priv->_length;
#line 530 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	tracker_sparql_builder_set_length (self, _tmp12_ + 1);
#line 1468 "tracker-builder.c"
}


/**
 * tracker_sparql_builder_object_string:
 * @self: a #TrackerSparqlBuilder
 * @literal: string object
 *
 * Appends an object formatted as an string. @literal will be escaped and surrounded
 * by double quotes.
 *
 * Since: 0.10
 * Deprecated: 2.0
 */
static void _vala_array_add13 (TrackerSparqlBuilderState* * array, int* length, int* size, TrackerSparqlBuilderState value) {
#line 554 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	if ((*length) == (*size)) {
#line 554 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 554 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		*array = g_renew (TrackerSparqlBuilderState, *array, *size);
#line 1490 "tracker-builder.c"
	}
#line 554 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	(*array)[(*length)++] = value;
#line 1494 "tracker-builder.c"
}


void tracker_sparql_builder_object_string (TrackerSparqlBuilder* self, const gchar* literal) {
	TrackerSparqlBuilderState _tmp0_;
	TrackerSparqlBuilderState _tmp1_;
	TrackerSparqlBuilderState _tmp2_;
	TrackerSparqlBuilderState _tmp3_;
	TrackerSparqlBuilderState _tmp4_;
	TrackerSparqlBuilderState _tmp5_;
	GString* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	TrackerSparqlBuilderState* _tmp12_;
	gint _tmp12__length1;
	gint _tmp13_;
#line 545 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (self != NULL);
#line 545 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (literal != NULL);
#line 545 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = tracker_sparql_builder_get_state (self);
#line 545 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1_ = _tmp0_;
#line 545 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2_ = tracker_sparql_builder_get_state (self);
#line 545 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp3_ = _tmp2_;
#line 545 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_vala_return_if_fail ((_tmp1_ == TRACKER_SPARQL_BUILDER_STATE_PREDICATE) || (_tmp3_ == TRACKER_SPARQL_BUILDER_STATE_OBJECT), "state == State.PREDICATE || state == State.OBJECT");
#line 548 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp4_ = tracker_sparql_builder_get_state (self);
#line 548 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp5_ = _tmp4_;
#line 548 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	if (_tmp5_ == TRACKER_SPARQL_BUILDER_STATE_OBJECT) {
#line 1532 "tracker-builder.c"
		GString* _tmp6_;
		gint _tmp7_;
#line 549 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp6_ = self->priv->str;
#line 549 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		g_string_append (_tmp6_, " ,");
#line 550 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp7_ = self->priv->states_length1;
#line 550 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		self->priv->states_length1 = _tmp7_ - 1;
#line 1543 "tracker-builder.c"
	}
#line 553 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp8_ = self->priv->str;
#line 553 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp9_ = literal;
#line 553 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp10_ = tracker_sparql_escape_string (_tmp9_);
#line 553 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp11_ = _tmp10_;
#line 553 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_string_append_printf (_tmp8_, " \"%s\"", _tmp11_);
#line 553 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_g_free0 (_tmp11_);
#line 554 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp12_ = self->priv->states;
#line 554 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp12__length1 = self->priv->states_length1;
#line 554 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_vala_array_add13 (&self->priv->states, &self->priv->states_length1, &self->priv->_states_size_, TRACKER_SPARQL_BUILDER_STATE_OBJECT);
#line 556 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp13_ = self->priv->_length;
#line 556 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	tracker_sparql_builder_set_length (self, _tmp13_ + 1);
#line 1567 "tracker-builder.c"
}


/**
 * tracker_sparql_builder_object_unvalidated:
 * @self: a #TrackerSparqlBuilder
 * @value: possibly UTF-8 invalid string.
 *
 * Appends a string not validated as UTF-8 as an object.
 *
 * Since: 0.10
 * Deprecated: 2.0
 */
static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
#line 1330 "/usr/share/vala-0.38/vapi/glib-2.0.vapi"
	_tmp0_ = str;
#line 1330 "/usr/share/vala-0.38/vapi/glib-2.0.vapi"
	_tmp1_ = maxlen;
#line 1330 "/usr/share/vala-0.38/vapi/glib-2.0.vapi"
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
#line 1330 "/usr/share/vala-0.38/vapi/glib-2.0.vapi"
	end = _tmp2_;
#line 1331 "/usr/share/vala-0.38/vapi/glib-2.0.vapi"
	_tmp3_ = end;
#line 1331 "/usr/share/vala-0.38/vapi/glib-2.0.vapi"
	if (_tmp3_ == NULL) {
#line 1600 "tracker-builder.c"
		glong _tmp4_;
#line 1332 "/usr/share/vala-0.38/vapi/glib-2.0.vapi"
		_tmp4_ = maxlen;
#line 1332 "/usr/share/vala-0.38/vapi/glib-2.0.vapi"
		result = _tmp4_;
#line 1332 "/usr/share/vala-0.38/vapi/glib-2.0.vapi"
		return result;
#line 1608 "tracker-builder.c"
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
#line 1334 "/usr/share/vala-0.38/vapi/glib-2.0.vapi"
		_tmp5_ = end;
#line 1334 "/usr/share/vala-0.38/vapi/glib-2.0.vapi"
		_tmp6_ = str;
#line 1334 "/usr/share/vala-0.38/vapi/glib-2.0.vapi"
		result = (glong) (_tmp5_ - _tmp6_);
#line 1334 "/usr/share/vala-0.38/vapi/glib-2.0.vapi"
		return result;
#line 1620 "tracker-builder.c"
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	glong _tmp8_;
	glong _tmp14_;
	glong _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	gchar* _tmp22_;
#line 1341 "/usr/share/vala-0.38/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1343 "/usr/share/vala-0.38/vapi/glib-2.0.vapi"
	_tmp1_ = offset;
#line 1343 "/usr/share/vala-0.38/vapi/glib-2.0.vapi"
	if (_tmp1_ >= ((glong) 0)) {
#line 1644 "tracker-builder.c"
		glong _tmp2_;
#line 1343 "/usr/share/vala-0.38/vapi/glib-2.0.vapi"
		_tmp2_ = len;
#line 1343 "/usr/share/vala-0.38/vapi/glib-2.0.vapi"
		_tmp0_ = _tmp2_ >= ((glong) 0);
#line 1650 "tracker-builder.c"
	} else {
#line 1343 "/usr/share/vala-0.38/vapi/glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 1654 "tracker-builder.c"
	}
#line 1343 "/usr/share/vala-0.38/vapi/glib-2.0.vapi"
	if (_tmp0_) {
#line 1658 "tracker-builder.c"
		glong _tmp3_;
		glong _tmp4_;
		glong _tmp5_;
#line 1345 "/usr/share/vala-0.38/vapi/glib-2.0.vapi"
		_tmp3_ = offset;
#line 1345 "/usr/share/vala-0.38/vapi/glib-2.0.vapi"
		_tmp4_ = len;
#line 1345 "/usr/share/vala-0.38/vapi/glib-2.0.vapi"
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
#line 1345 "/usr/share/vala-0.38/vapi/glib-2.0.vapi"
		string_length = _tmp5_;
#line 1670 "tracker-builder.c"
	} else {
		gint _tmp6_;
		gint _tmp7_;
#line 1347 "/usr/share/vala-0.38/vapi/glib-2.0.vapi"
		_tmp6_ = strlen (self);
#line 1347 "/usr/share/vala-0.38/vapi/glib-2.0.vapi"
		_tmp7_ = _tmp6_;
#line 1347 "/usr/share/vala-0.38/vapi/glib-2.0.vapi"
		string_length = (glong) _tmp7_;
#line 1680 "tracker-builder.c"
	}
#line 1350 "/usr/share/vala-0.38/vapi/glib-2.0.vapi"
	_tmp8_ = offset;
#line 1350 "/usr/share/vala-0.38/vapi/glib-2.0.vapi"
	if (_tmp8_ < ((glong) 0)) {
#line 1686 "tracker-builder.c"
		glong _tmp9_;
		glong _tmp10_;
		glong _tmp11_;
#line 1351 "/usr/share/vala-0.38/vapi/glib-2.0.vapi"
		_tmp9_ = string_length;
#line 1351 "/usr/share/vala-0.38/vapi/glib-2.0.vapi"
		_tmp10_ = offset;
#line 1351 "/usr/share/vala-0.38/vapi/glib-2.0.vapi"
		offset = _tmp9_ + _tmp10_;
#line 1352 "/usr/share/vala-0.38/vapi/glib-2.0.vapi"
		_tmp11_ = offset;
#line 1352 "/usr/share/vala-0.38/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
#line 1700 "tracker-builder.c"
	} else {
		glong _tmp12_;
		glong _tmp13_;
#line 1354 "/usr/share/vala-0.38/vapi/glib-2.0.vapi"
		_tmp12_ = offset;
#line 1354 "/usr/share/vala-0.38/vapi/glib-2.0.vapi"
		_tmp13_ = string_length;
#line 1354 "/usr/share/vala-0.38/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
#line 1710 "tracker-builder.c"
	}
#line 1356 "/usr/share/vala-0.38/vapi/glib-2.0.vapi"
	_tmp14_ = len;
#line 1356 "/usr/share/vala-0.38/vapi/glib-2.0.vapi"
	if (_tmp14_ < ((glong) 0)) {
#line 1716 "tracker-builder.c"
		glong _tmp15_;
		glong _tmp16_;
#line 1357 "/usr/share/vala-0.38/vapi/glib-2.0.vapi"
		_tmp15_ = string_length;
#line 1357 "/usr/share/vala-0.38/vapi/glib-2.0.vapi"
		_tmp16_ = offset;
#line 1357 "/usr/share/vala-0.38/vapi/glib-2.0.vapi"
		len = _tmp15_ - _tmp16_;
#line 1725 "tracker-builder.c"
	}
#line 1359 "/usr/share/vala-0.38/vapi/glib-2.0.vapi"
	_tmp17_ = offset;
#line 1359 "/usr/share/vala-0.38/vapi/glib-2.0.vapi"
	_tmp18_ = len;
#line 1359 "/usr/share/vala-0.38/vapi/glib-2.0.vapi"
	_tmp19_ = string_length;
#line 1359 "/usr/share/vala-0.38/vapi/glib-2.0.vapi"
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
#line 1360 "/usr/share/vala-0.38/vapi/glib-2.0.vapi"
	_tmp20_ = offset;
#line 1360 "/usr/share/vala-0.38/vapi/glib-2.0.vapi"
	_tmp21_ = len;
#line 1360 "/usr/share/vala-0.38/vapi/glib-2.0.vapi"
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
#line 1360 "/usr/share/vala-0.38/vapi/glib-2.0.vapi"
	result = _tmp22_;
#line 1360 "/usr/share/vala-0.38/vapi/glib-2.0.vapi"
	return result;
#line 1745 "tracker-builder.c"
}


void tracker_sparql_builder_object_unvalidated (TrackerSparqlBuilder* self, const gchar* value) {
	gchar* end = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gboolean _tmp2_;
	const gchar* _tmp10_;
#line 570 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (self != NULL);
#line 570 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (value != NULL);
#line 573 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = value;
#line 573 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2_ = g_utf8_validate (_tmp0_, (gssize) -1, &_tmp1_);
#line 573 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	end = _tmp1_;
#line 573 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	if (!_tmp2_) {
#line 1767 "tracker-builder.c"
		const gchar* _tmp3_;
		gchar* _tmp4_;
#line 574 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp3_ = value;
#line 574 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp4_ = end;
#line 574 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		if (_tmp3_ != _tmp4_) {
#line 1776 "tracker-builder.c"
			const gchar* _tmp5_;
			gchar* _tmp6_;
			const gchar* _tmp7_;
			gchar* _tmp8_;
			gchar* _tmp9_;
#line 575 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
			_tmp5_ = value;
#line 575 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
			_tmp6_ = end;
#line 575 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
			_tmp7_ = value;
#line 575 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
			_tmp8_ = string_substring (_tmp5_, (glong) 0, (glong) (_tmp6_ - ((gchar*) _tmp7_)));
#line 575 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
			_tmp9_ = _tmp8_;
#line 575 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
			tracker_sparql_builder_object_string (self, _tmp9_);
#line 575 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
			_g_free0 (_tmp9_);
#line 1796 "tracker-builder.c"
		} else {
#line 577 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
			tracker_sparql_builder_object_string (self, "(invalid data)");
#line 1800 "tracker-builder.c"
		}
#line 580 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		return;
#line 1804 "tracker-builder.c"
	}
#line 583 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp10_ = value;
#line 583 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	tracker_sparql_builder_object_string (self, _tmp10_);
#line 1810 "tracker-builder.c"
}


/**
 * tracker_sparql_builder_object_boolean:
 * @self: a #TrackerSparqlBuilder
 * @literal: object as a #gboolean
 *
 * Appends a #gboolean value as an object.
 *
 * Since: 0.10
 * Deprecated: 2.0
 */
void tracker_sparql_builder_object_boolean (TrackerSparqlBuilder* self, gboolean literal) {
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_;
#line 597 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (self != NULL);
#line 598 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1_ = literal;
#line 598 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	if (_tmp1_) {
#line 598 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp0_ = "true";
#line 1835 "tracker-builder.c"
	} else {
#line 598 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp0_ = "false";
#line 1839 "tracker-builder.c"
	}
#line 598 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	tracker_sparql_builder_object (self, _tmp0_);
#line 1843 "tracker-builder.c"
}


/**
 * tracker_sparql_builder_object_int64:
 * @self: a #TrackerSparqlBuilder
 * @literal: object as a #gint64
 *
 * Appends a #gint64 value as an object.
 *
 * Since: 0.10
 * Deprecated: 2.0
 */
void tracker_sparql_builder_object_int64 (TrackerSparqlBuilder* self, gint64 literal) {
	gint64 _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
#line 612 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (self != NULL);
#line 613 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = literal;
#line 613 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp0_);
#line 613 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2_ = _tmp1_;
#line 613 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	tracker_sparql_builder_object (self, _tmp2_);
#line 613 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_g_free0 (_tmp2_);
#line 1873 "tracker-builder.c"
}


/**
 * tracker_sparql_builder_object_date:
 * @self: a #TrackerSparqlBuilder
 * @literal: object as a #time_t
 *
 * Appends a #time_t value as an object. @literal will be converted
 * to a string in the date format used by tracker-store.
 *
 * Since: 0.10
 * Deprecated: 2.0
 */
static void g_time_gm (time_t time, struct tm* result) {
	struct tm _result_ = {0};
	struct tm _tmp0_ = {0};
#line 2849 "/usr/share/vala-0.38/vapi/glib-2.0.vapi"
	gmtime_r (&time, &_tmp0_);
#line 2849 "/usr/share/vala-0.38/vapi/glib-2.0.vapi"
	_result_ = _tmp0_;
#line 2850 "/usr/share/vala-0.38/vapi/glib-2.0.vapi"
	*result = _result_;
#line 2850 "/usr/share/vala-0.38/vapi/glib-2.0.vapi"
	return;
#line 1899 "tracker-builder.c"
}


void tracker_sparql_builder_object_date (TrackerSparqlBuilder* self, time_t* literal) {
	struct tm tm = {0};
	time_t _tmp0_;
	struct tm _tmp1_ = {0};
	struct tm _tmp2_;
	gint _tmp3_;
	struct tm _tmp4_;
	gint _tmp5_;
	struct tm _tmp6_;
	gint _tmp7_;
	struct tm _tmp8_;
	gint _tmp9_;
	struct tm _tmp10_;
	gint _tmp11_;
	struct tm _tmp12_;
	gint _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
#line 628 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (self != NULL);
#line 629 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = *literal;
#line 629 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_time_gm (_tmp0_, &_tmp1_);
#line 629 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	tm = _tmp1_;
#line 631 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2_ = tm;
#line 631 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp3_ = _tmp2_.tm_year;
#line 631 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp4_ = tm;
#line 631 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp5_ = _tmp4_.tm_mon;
#line 631 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp6_ = tm;
#line 631 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp7_ = _tmp6_.tm_mday;
#line 631 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp8_ = tm;
#line 631 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp9_ = _tmp8_.tm_hour;
#line 631 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp10_ = tm;
#line 631 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp11_ = _tmp10_.tm_min;
#line 631 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp12_ = tm;
#line 631 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp13_ = _tmp12_.tm_sec;
#line 631 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp14_ = g_strdup_printf ("%04d-%02d-%02dT%02d:%02d:%02dZ", _tmp3_ + 1900, _tmp5_ + 1, _tmp7_, _tmp9_, _tmp11_, _tmp13_);
#line 631 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp15_ = _tmp14_;
#line 631 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	tracker_sparql_builder_object_string (self, _tmp15_);
#line 631 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_g_free0 (_tmp15_);
#line 1961 "tracker-builder.c"
}


/**
 * tracker_sparql_builder_object_double:
 * @self: a #TrackerSparqlBuilder
 * @literal: object as a #gdouble
 *
 * Appends a #gdouble value as an object.
 *
 * Since: 0.10
 * Deprecated: 2.0
 */
static gchar* double_to_string (gdouble self) {
	gchar* result = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
#line 879 "/usr/share/vala-0.38/vapi/glib-2.0.vapi"
	_tmp0_ = g_new0 (gchar, G_ASCII_DTOSTR_BUF_SIZE);
#line 879 "/usr/share/vala-0.38/vapi/glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 879 "/usr/share/vala-0.38/vapi/glib-2.0.vapi"
	_tmp1__length1 = G_ASCII_DTOSTR_BUF_SIZE;
#line 879 "/usr/share/vala-0.38/vapi/glib-2.0.vapi"
	_tmp2_ = g_ascii_dtostr (_tmp1_, G_ASCII_DTOSTR_BUF_SIZE, self);
#line 879 "/usr/share/vala-0.38/vapi/glib-2.0.vapi"
	_tmp3_ = g_strdup (_tmp2_);
#line 879 "/usr/share/vala-0.38/vapi/glib-2.0.vapi"
	_tmp4_ = _tmp3_;
#line 879 "/usr/share/vala-0.38/vapi/glib-2.0.vapi"
	_tmp1_ = (g_free (_tmp1_), NULL);
#line 879 "/usr/share/vala-0.38/vapi/glib-2.0.vapi"
	result = _tmp4_;
#line 879 "/usr/share/vala-0.38/vapi/glib-2.0.vapi"
	return result;
#line 2001 "tracker-builder.c"
}


void tracker_sparql_builder_object_double (TrackerSparqlBuilder* self, gdouble literal) {
	gdouble _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
#line 645 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (self != NULL);
#line 646 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = literal;
#line 646 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1_ = double_to_string (_tmp0_);
#line 646 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2_ = _tmp1_;
#line 646 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	tracker_sparql_builder_object (self, _tmp2_);
#line 646 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_g_free0 (_tmp2_);
#line 2021 "tracker-builder.c"
}


/**
 * tracker_sparql_builder_object_blank_open:
 * @self: a #TrackerSparqlBuilder
 *
 * Opens an anonymous blank node. In insertions this can be used to create
 * anonymous nodes for not previously known data without the need of a
 * separate insertion.
 *
 * Since: 0.10
 * Deprecated: 2.0
 */
static void _vala_array_add14 (TrackerSparqlBuilderState* * array, int* length, int* size, TrackerSparqlBuilderState value) {
#line 669 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	if ((*length) == (*size)) {
#line 669 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 669 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		*array = g_renew (TrackerSparqlBuilderState, *array, *size);
#line 2043 "tracker-builder.c"
	}
#line 669 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	(*array)[(*length)++] = value;
#line 2047 "tracker-builder.c"
}


void tracker_sparql_builder_object_blank_open (TrackerSparqlBuilder* self) {
	TrackerSparqlBuilderState _tmp0_;
	TrackerSparqlBuilderState _tmp1_;
	TrackerSparqlBuilderState _tmp2_;
	TrackerSparqlBuilderState _tmp3_;
	TrackerSparqlBuilderState _tmp4_;
	TrackerSparqlBuilderState _tmp5_;
	GString* _tmp8_;
	TrackerSparqlBuilderState* _tmp9_;
	gint _tmp9__length1;
#line 661 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (self != NULL);
#line 661 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = tracker_sparql_builder_get_state (self);
#line 661 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1_ = _tmp0_;
#line 661 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2_ = tracker_sparql_builder_get_state (self);
#line 661 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp3_ = _tmp2_;
#line 661 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_vala_return_if_fail ((_tmp1_ == TRACKER_SPARQL_BUILDER_STATE_PREDICATE) || (_tmp3_ == TRACKER_SPARQL_BUILDER_STATE_OBJECT), "state == State.PREDICATE || state == State.OBJECT");
#line 664 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp4_ = tracker_sparql_builder_get_state (self);
#line 664 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp5_ = _tmp4_;
#line 664 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	if (_tmp5_ == TRACKER_SPARQL_BUILDER_STATE_OBJECT) {
#line 2079 "tracker-builder.c"
		GString* _tmp6_;
		gint _tmp7_;
#line 665 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp6_ = self->priv->str;
#line 665 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		g_string_append (_tmp6_, " ,");
#line 666 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp7_ = self->priv->states_length1;
#line 666 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		self->priv->states_length1 = _tmp7_ - 1;
#line 2090 "tracker-builder.c"
	}
#line 668 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp8_ = self->priv->str;
#line 668 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_string_append (_tmp8_, " [");
#line 669 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp9_ = self->priv->states;
#line 669 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp9__length1 = self->priv->states_length1;
#line 669 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_vala_array_add14 (&self->priv->states, &self->priv->states_length1, &self->priv->_states_size_, TRACKER_SPARQL_BUILDER_STATE_BLANK);
#line 2102 "tracker-builder.c"
}


/**
 * tracker_sparql_builder_object_blank_close:
 * @self: a #TrackerSparqlBuilder
 *
 * Closes an anomymous blank node opened with tracker_sparql_builder_object_blank_open()
 *
 * Since: 0.10
 * Deprecated: 2.0
 */
static void _vala_array_add15 (TrackerSparqlBuilderState* * array, int* length, int* size, TrackerSparqlBuilderState value) {
#line 687 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	if ((*length) == (*size)) {
#line 687 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 687 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		*array = g_renew (TrackerSparqlBuilderState, *array, *size);
#line 2122 "tracker-builder.c"
	}
#line 687 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	(*array)[(*length)++] = value;
#line 2126 "tracker-builder.c"
}


void tracker_sparql_builder_object_blank_close (TrackerSparqlBuilder* self) {
	TrackerSparqlBuilderState _tmp0_;
	TrackerSparqlBuilderState _tmp1_;
	TrackerSparqlBuilderState* _tmp2_;
	gint _tmp2__length1;
	TrackerSparqlBuilderState* _tmp3_;
	gint _tmp3__length1;
	TrackerSparqlBuilderState _tmp4_;
	GString* _tmp5_;
	gint _tmp6_;
	TrackerSparqlBuilderState* _tmp7_;
	gint _tmp7__length1;
	gint _tmp8_;
#line 682 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (self != NULL);
#line 682 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = tracker_sparql_builder_get_state (self);
#line 682 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1_ = _tmp0_;
#line 682 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2_ = self->priv->states;
#line 682 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2__length1 = self->priv->states_length1;
#line 682 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp3_ = self->priv->states;
#line 682 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp3__length1 = self->priv->states_length1;
#line 682 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp4_ = _tmp2_[_tmp3__length1 - 3];
#line 682 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_vala_return_if_fail ((_tmp1_ == TRACKER_SPARQL_BUILDER_STATE_OBJECT) && (_tmp4_ == TRACKER_SPARQL_BUILDER_STATE_BLANK), "state == State.OBJECT && states[states.length - 3] == State.BLANK");
#line 685 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp5_ = self->priv->str;
#line 685 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_string_append (_tmp5_, "]");
#line 686 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	self->priv->states_length1 = self->priv->states_length1 - 3;
#line 686 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp6_ = self->priv->states_length1;
#line 687 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp7_ = self->priv->states;
#line 687 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp7__length1 = self->priv->states_length1;
#line 687 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_vala_array_add15 (&self->priv->states, &self->priv->states_length1, &self->priv->_states_size_, TRACKER_SPARQL_BUILDER_STATE_OBJECT);
#line 689 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp8_ = self->priv->_length;
#line 689 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	tracker_sparql_builder_set_length (self, _tmp8_ + 1);
#line 2179 "tracker-builder.c"
}


/**
 * tracker_sparql_builder_prepend:
 * @self: a #TrackerSparqlBuilder
 * @raw: raw content to prepend.
 *
 * Prepends raw, unvalidated content to @self.
 *
 * Since: 0.10
 * Deprecated: 2.0
 */
void tracker_sparql_builder_prepend (TrackerSparqlBuilder* self, const gchar* raw) {
	GString* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gint _tmp4_;
#line 703 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (self != NULL);
#line 703 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (raw != NULL);
#line 705 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = self->priv->str;
#line 705 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1_ = raw;
#line 705 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2_ = g_strdup_printf ("%s\n", _tmp1_);
#line 705 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp3_ = _tmp2_;
#line 705 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_string_prepend (_tmp0_, _tmp3_);
#line 705 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_g_free0 (_tmp3_);
#line 707 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp4_ = self->priv->_length;
#line 707 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	tracker_sparql_builder_set_length (self, _tmp4_ + 1);
#line 2219 "tracker-builder.c"
}


/**
 * tracker_sparql_builder_append:
 * @self: a #TrackerSparqlBuilder
 * @raw: raw content to append.
 *
 * Appends raw, unvalidated content to @self.
 *
 * Since: 0.10
 * Deprecated: 2.0
 */
void tracker_sparql_builder_append (TrackerSparqlBuilder* self, const gchar* raw) {
	TrackerSparqlBuilderState _tmp0_;
	TrackerSparqlBuilderState _tmp1_;
	GString* _tmp4_;
	const gchar* _tmp5_;
	gint _tmp6_;
#line 721 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (self != NULL);
#line 721 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (raw != NULL);
#line 723 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = tracker_sparql_builder_get_state (self);
#line 723 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1_ = _tmp0_;
#line 723 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	if (_tmp1_ == TRACKER_SPARQL_BUILDER_STATE_OBJECT) {
#line 2249 "tracker-builder.c"
		GString* _tmp2_;
		gint _tmp3_;
#line 724 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp2_ = self->priv->str;
#line 724 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		g_string_append (_tmp2_, " .\n");
#line 725 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		self->priv->states_length1 = self->priv->states_length1 - 3;
#line 725 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp3_ = self->priv->states_length1;
#line 2260 "tracker-builder.c"
	}
#line 728 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp4_ = self->priv->str;
#line 728 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp5_ = raw;
#line 728 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_string_append (_tmp4_, _tmp5_);
#line 730 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp6_ = self->priv->_length;
#line 730 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	tracker_sparql_builder_set_length (self, _tmp6_ + 1);
#line 2272 "tracker-builder.c"
}


TrackerSparqlBuilder* tracker_sparql_builder_construct (GType object_type) {
	TrackerSparqlBuilder * self = NULL;
#line 62 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	self = (TrackerSparqlBuilder*) g_object_new (object_type, NULL);
#line 62 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	return self;
#line 2282 "tracker-builder.c"
}


TrackerSparqlBuilder* tracker_sparql_builder_new (void) {
#line 62 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	return tracker_sparql_builder_construct (TRACKER_SPARQL_TYPE_BUILDER);
#line 2289 "tracker-builder.c"
}


const gchar* tracker_sparql_builder_get_result (TrackerSparqlBuilder* self) {
	const gchar* result;
	gboolean _tmp0_ = FALSE;
	TrackerSparqlBuilderState* _tmp1_;
	gint _tmp1__length1;
	GString* _tmp6_;
	const gchar* _tmp7_;
#line 112 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 113 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1_ = self->priv->states;
#line 113 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1__length1 = self->priv->states_length1;
#line 113 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	if (_tmp1__length1 == 1) {
#line 113 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp0_ = TRUE;
#line 2310 "tracker-builder.c"
	} else {
		gboolean _tmp2_ = FALSE;
		TrackerSparqlBuilderState* _tmp3_;
		gint _tmp3__length1;
		TrackerSparqlBuilderState _tmp4_;
#line 114 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp3_ = self->priv->states;
#line 114 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp3__length1 = self->priv->states_length1;
#line 114 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp4_ = _tmp3_[0];
#line 114 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		if (_tmp4_ == TRACKER_SPARQL_BUILDER_STATE_EMBEDDED_INSERT) {
#line 2324 "tracker-builder.c"
			TrackerSparqlBuilderState* _tmp5_;
			gint _tmp5__length1;
#line 115 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
			_tmp5_ = self->priv->states;
#line 115 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
			_tmp5__length1 = self->priv->states_length1;
#line 115 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
			_tmp2_ = _tmp5__length1 == 3;
#line 2333 "tracker-builder.c"
		} else {
#line 114 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
			_tmp2_ = FALSE;
#line 2337 "tracker-builder.c"
		}
#line 114 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp0_ = _tmp2_;
#line 2341 "tracker-builder.c"
	}
#line 113 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_warn_if_fail (_tmp0_);
#line 116 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp6_ = self->priv->str;
#line 116 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp7_ = _tmp6_->str;
#line 116 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	result = _tmp7_;
#line 116 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	return result;
#line 2353 "tracker-builder.c"
}


gint tracker_sparql_builder_get_length (TrackerSparqlBuilder* self) {
	gint result;
	gint _tmp0_;
#line 139 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 139 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = self->priv->_length;
#line 139 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	result = _tmp0_;
#line 139 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	return result;
#line 2368 "tracker-builder.c"
}


static void tracker_sparql_builder_set_length (TrackerSparqlBuilder* self, gint value) {
#line 140 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (self != NULL);
#line 140 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	if (tracker_sparql_builder_get_length (self) != value) {
#line 2377 "tracker-builder.c"
		gint _tmp0_;
#line 140 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp0_ = value;
#line 140 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		self->priv->_length = _tmp0_;
#line 140 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		g_object_notify_by_pspec ((GObject *) self, tracker_sparql_builder_properties[TRACKER_SPARQL_BUILDER_LENGTH_PROPERTY]);
#line 2385 "tracker-builder.c"
	}
}


TrackerSparqlBuilderState tracker_sparql_builder_get_state (TrackerSparqlBuilder* self) {
	TrackerSparqlBuilderState result;
	TrackerSparqlBuilderState* _tmp0_;
	gint _tmp0__length1;
	TrackerSparqlBuilderState* _tmp1_;
	gint _tmp1__length1;
	TrackerSparqlBuilderState _tmp2_;
#line 162 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 162 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = self->priv->states;
#line 162 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0__length1 = self->priv->states_length1;
#line 162 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1_ = self->priv->states;
#line 162 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1__length1 = self->priv->states_length1;
#line 162 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2_ = _tmp0_[_tmp1__length1 - 1];
#line 162 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	result = _tmp2_;
#line 162 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	return result;
#line 2413 "tracker-builder.c"
}


static void tracker_sparql_builder_class_init (TrackerSparqlBuilderClass * klass) {
#line 62 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	tracker_sparql_builder_parent_class = g_type_class_peek_parent (klass);
#line 62 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_type_class_add_private (klass, sizeof (TrackerSparqlBuilderPrivate));
#line 62 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_tracker_sparql_builder_get_property;
#line 62 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_tracker_sparql_builder_set_property;
#line 62 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	G_OBJECT_CLASS (klass)->finalize = tracker_sparql_builder_finalize;
#line 2428 "tracker-builder.c"
	/**
	 * TrackerSparqlBuilder:result:
	 *
	 * String containing the constructed SPARQL in the #TrackerSparqlBuilder.
	 *
	 * Since: 0.10
	 */
#line 62 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRACKER_SPARQL_BUILDER_RESULT_PROPERTY, tracker_sparql_builder_properties[TRACKER_SPARQL_BUILDER_RESULT_PROPERTY] = g_param_spec_string ("result", "result", "result", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 2438 "tracker-builder.c"
	/**
	 * TrackerSparqlBuilder:length:
	 *
	 * Number of objects added to the #TrackerSparqlBuilder.
	 *
	 * Since: 0.10
	 */
#line 62 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRACKER_SPARQL_BUILDER_LENGTH_PROPERTY, tracker_sparql_builder_properties[TRACKER_SPARQL_BUILDER_LENGTH_PROPERTY] = g_param_spec_int ("length", "length", "length", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 2448 "tracker-builder.c"
	/**
	 * TrackerSparqlBuilder:state:
	 *
	 * Current state of the #TrackerSparqlBuilder.
	 *
	 * Since: 0.10
	 */
#line 62 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRACKER_SPARQL_BUILDER_STATE_PROPERTY, tracker_sparql_builder_properties[TRACKER_SPARQL_BUILDER_STATE_PROPERTY] = g_param_spec_enum ("state", "state", "state", TRACKER_SPARQL_BUILDER_TYPE_STATE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 2458 "tracker-builder.c"
}


static void tracker_sparql_builder_instance_init (TrackerSparqlBuilder * self) {
	GString* _tmp0_;
#line 62 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	self->priv = TRACKER_SPARQL_BUILDER_GET_PRIVATE (self);
#line 166 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = g_string_new ("");
#line 166 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	self->priv->str = _tmp0_;
#line 2470 "tracker-builder.c"
}


static void tracker_sparql_builder_finalize (GObject * obj) {
	TrackerSparqlBuilder * self;
#line 62 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_SPARQL_TYPE_BUILDER, TrackerSparqlBuilder);
#line 165 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	self->priv->states = (g_free (self->priv->states), NULL);
#line 166 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	_g_string_free0 (self->priv->str);
#line 62 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	G_OBJECT_CLASS (tracker_sparql_builder_parent_class)->finalize (obj);
#line 2484 "tracker-builder.c"
}


/**
 * tracker_sparql_builder_new:
 *
 * Creates a stateless #TrackerSparqlBuilder.
 *
 * Returns: a newly created #TrackerSparqlBuilder. Free with g_object_unref() when done
 *
 * Since: 0.10
 */
GType tracker_sparql_builder_get_type (void) {
	static volatile gsize tracker_sparql_builder_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_sparql_builder_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerSparqlBuilderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_sparql_builder_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerSparqlBuilder), 0, (GInstanceInitFunc) tracker_sparql_builder_instance_init, NULL };
		GType tracker_sparql_builder_type_id;
		tracker_sparql_builder_type_id = g_type_register_static (G_TYPE_OBJECT, "TrackerSparqlBuilder", &g_define_type_info, 0);
		g_once_init_leave (&tracker_sparql_builder_type_id__volatile, tracker_sparql_builder_type_id);
	}
	return tracker_sparql_builder_type_id__volatile;
}


static void _vala_tracker_sparql_builder_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	TrackerSparqlBuilder * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TRACKER_SPARQL_TYPE_BUILDER, TrackerSparqlBuilder);
#line 62 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	switch (property_id) {
#line 62 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		case TRACKER_SPARQL_BUILDER_RESULT_PROPERTY:
#line 62 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		g_value_set_string (value, tracker_sparql_builder_get_result (self));
#line 62 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		break;
#line 62 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		case TRACKER_SPARQL_BUILDER_LENGTH_PROPERTY:
#line 62 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		g_value_set_int (value, tracker_sparql_builder_get_length (self));
#line 62 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		break;
#line 62 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		case TRACKER_SPARQL_BUILDER_STATE_PROPERTY:
#line 62 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		g_value_set_enum (value, tracker_sparql_builder_get_state (self));
#line 62 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		break;
#line 2532 "tracker-builder.c"
		default:
#line 62 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 62 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		break;
#line 2538 "tracker-builder.c"
	}
}


static void _vala_tracker_sparql_builder_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	TrackerSparqlBuilder * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TRACKER_SPARQL_TYPE_BUILDER, TrackerSparqlBuilder);
#line 62 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
	switch (property_id) {
#line 62 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		case TRACKER_SPARQL_BUILDER_LENGTH_PROPERTY:
#line 62 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		tracker_sparql_builder_set_length (self, g_value_get_int (value));
#line 62 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		break;
#line 2554 "tracker-builder.c"
		default:
#line 62 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 62 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-builder.vala"
		break;
#line 2560 "tracker-builder.c"
	}
}



