/* valadoc.c generated by valac, the Vala compiler
 * generated from valadoc.vala, do not modify */

/* valadoc.vala
 *
 * Copyright (C) 2008-2014 Florian Brosch
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Florian Brosch <flo.brosch@gmail.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <valadoc.h>
#include <stdio.h>
#include <locale.h>
#include <version.h>
#include <glib/gstdio.h>


#define TYPE_VALA_DOC (vala_doc_get_type ())
#define VALA_DOC(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VALA_DOC, ValaDoc))
#define VALA_DOC_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VALA_DOC, ValaDocClass))
#define IS_VALA_DOC(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VALA_DOC))
#define IS_VALA_DOC_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VALA_DOC))
#define VALA_DOC_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VALA_DOC, ValaDocClass))

typedef struct _ValaDoc ValaDoc;
typedef struct _ValaDocClass ValaDocClass;
typedef struct _ValaDocPrivate ValaDocPrivate;
enum  {
	VALA_DOC_DUMMY_PROPERTY,
	VALA_DOC_LAST_PROPERTY
};
static GParamSpec* vala_doc_properties[VALA_DOC_LAST_PROPERTY];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define VALADOC_DRIVERS_TYPE_DRIVER (valadoc_drivers_driver_get_type ())
#define VALADOC_DRIVERS_DRIVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALADOC_DRIVERS_TYPE_DRIVER, ValadocDriversDriver))
#define VALADOC_DRIVERS_DRIVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALADOC_DRIVERS_TYPE_DRIVER, ValadocDriversDriverClass))
#define VALADOC_DRIVERS_IS_DRIVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALADOC_DRIVERS_TYPE_DRIVER))
#define VALADOC_DRIVERS_IS_DRIVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALADOC_DRIVERS_TYPE_DRIVER))
#define VALADOC_DRIVERS_DRIVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALADOC_DRIVERS_TYPE_DRIVER, ValadocDriversDriverClass))

typedef struct _ValadocDriversDriver ValadocDriversDriver;
typedef struct _ValadocDriversDriverClass ValadocDriversDriverClass;
#define _valadoc_api_tree_unref0(var) ((var == NULL) ? NULL : (var = (valadoc_api_tree_unref (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ValaDoc {
	GObject parent_instance;
	ValaDocPrivate * priv;
};

struct _ValaDocClass {
	GObjectClass parent_class;
};


static gpointer vala_doc_parent_class = NULL;
static gchar* vala_doc_wikidirectory;
static gchar* vala_doc_wikidirectory = NULL;
static gchar* vala_doc_pkg_version;
static gchar* vala_doc_pkg_version = NULL;
static gchar* vala_doc_docletpath;
static gchar* vala_doc_docletpath = NULL;
static gchar** vala_doc_pluginargs;
static gchar** vala_doc_pluginargs = NULL;
static gchar* vala_doc_directory;
static gchar* vala_doc_directory = NULL;
static gchar* vala_doc_pkg_name;
static gchar* vala_doc_pkg_name = NULL;
static gchar* vala_doc_gir_name;
static gchar* vala_doc_gir_name = NULL;
static gchar* vala_doc_gir_namespace;
static gchar* vala_doc_gir_namespace = NULL;
static gchar* vala_doc_gir_version;
static gchar* vala_doc_gir_version = NULL;
static gchar* vala_doc_driverpath;
static gchar* vala_doc_driverpath = NULL;
static gboolean vala_doc_add_inherited;
static gboolean vala_doc_add_inherited = FALSE;
static gboolean vala_doc__protected;
static gboolean vala_doc__protected = TRUE;
static gboolean vala_doc__internal;
static gboolean vala_doc__internal = FALSE;
static gboolean vala_doc_with_deps;
static gboolean vala_doc_with_deps = FALSE;
static gboolean vala_doc__private;
static gboolean vala_doc__private = FALSE;
static gboolean vala_doc_version;
static gboolean vala_doc_version = FALSE;
static gboolean vala_doc_use_svg_images;
static gboolean vala_doc_use_svg_images = FALSE;
static gboolean vala_doc_disable_diagnostic_colors;
static gboolean vala_doc_disable_diagnostic_colors = FALSE;
static gboolean vala_doc_verbose;
static gboolean vala_doc_verbose = FALSE;
static gboolean vala_doc_force;
static gboolean vala_doc_force = FALSE;
static gchar* vala_doc_basedir;
static gchar* vala_doc_basedir = NULL;
static gchar** vala_doc_defines;
static gchar** vala_doc_defines = NULL;
static gboolean vala_doc_experimental;
static gboolean vala_doc_experimental = FALSE;
static gboolean vala_doc_experimental_non_null;
static gboolean vala_doc_experimental_non_null = FALSE;
static gchar* vala_doc_profile;
static gchar* vala_doc_profile = NULL;
static gchar** vala_doc_import_packages;
static gchar** vala_doc_import_packages = NULL;
static gchar** vala_doc_import_directories;
static gchar** vala_doc_import_directories = NULL;
static gchar** vala_doc_vapi_directories;
static gchar** vala_doc_vapi_directories = NULL;
static gchar** vala_doc_metadata_directories;
static gchar** vala_doc_metadata_directories = NULL;
static gchar** vala_doc_gir_directories;
static gchar** vala_doc_gir_directories = NULL;
static gchar** vala_doc_tsources;
static gchar** vala_doc_tsources = NULL;
static gchar** vala_doc_packages;
static gchar** vala_doc_packages = NULL;
static gchar** vala_doc_alternative_resource_dirs;
static gchar** vala_doc_alternative_resource_dirs = NULL;
static gchar* vala_doc_target_glib;
static gchar* vala_doc_target_glib = NULL;

GType vala_doc_get_type (void) G_GNUC_CONST;
#define VALA_DOC_DEFAULT_COLORS "error=01;31:warning=01;35:note=01;36:caret=01;32:locus=01:quote=01"
static gint vala_doc_quit (ValadocErrorReporter* reporter);
static gboolean vala_doc_check_pkg_name (void);
static gchar* vala_doc_get_pkg_name (ValaDoc* self);
static ValadocModuleLoader* vala_doc_create_module_loader (ValaDoc* self, ValadocErrorReporter* reporter, ValadocDoclet* * doclet, ValadocDriver* * driver);
ValadocDriversDriver* valadoc_drivers_driver_new (void);
ValadocDriversDriver* valadoc_drivers_driver_construct (GType object_type);
GType valadoc_drivers_driver_get_type (void) G_GNUC_CONST;
static gint vala_doc_run (ValaDoc* self, ValadocErrorReporter* reporter);
static gchar** _vala_array_dup4 (gchar** self, int length);
static gchar** _vala_array_dup5 (gchar** self, int length);
static gchar** _vala_array_dup6 (gchar** self, int length);
static gchar** _vala_array_dup7 (gchar** self, int length);
static gchar** _vala_array_dup8 (gchar** self, int length);
static gchar** _vala_array_dup9 (gchar** self, int length);
static gchar** _vala_array_dup10 (gchar** self, int length);
static gchar** _vala_array_dup11 (gchar** self, int length);
static gint vala_doc_main (gchar** args, int args_length1);
ValaDoc* vala_doc_new (void);
ValaDoc* vala_doc_construct (GType object_type);
static void vala_doc_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const GOptionEntry VALA_DOC_options[32] = {{"directory", 'o', 0, G_OPTION_ARG_FILENAME, &vala_doc_directory, "Output directory", "DIRECTORY"}, {"basedir", 'b', 0, G_OPTION_ARG_FILENAME, &vala_doc_basedir, "Base source directory", "DIRECTORY"}, {"define", 'D', 0, G_OPTION_ARG_STRING_ARRAY, &vala_doc_defines, "Define SYMBOL", "SYMBOL..."}, {"profile", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_doc_profile, "Use the given profile instead of the default", "PROFILE"}, {"enable-experimental", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_doc_experimental, "Enable experimental features", NULL}, {"enable-experimental-non-null", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_doc_experimental_non_null, "Enable experimental enhancements for non-null types", NULL}, {"metadatadir", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_doc_metadata_directories, "Look for GIR .metadata files in DIRECTORY", "DIRECTORY..."}, {"girdir", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_doc_gir_directories, "Look for .gir files in DIRECTORY", "DIRECTORY..."}, {"vapidir", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_doc_vapi_directories, "Look for package bindings in DIRECTORY", "DIRECTORY..."}, {"pkg", (gchar) 0, 0, G_OPTION_ARG_STRING_ARRAY, &vala_doc_packages, "Include binding for PACKAGE", "PACKAGE..."}, {"driver", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_doc_driverpath, "Name of an driver or path to a custom driver", NULL}, {"importdir", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_doc_import_directories, "Look for external documentation in DIRECTORY", "DIRECTORY..."}, {"import", (gchar) 0, 0, G_OPTION_ARG_STRING_ARRAY, &vala_doc_import_packages, "Include binding for PACKAGE", "PACKAGE..."}, {"alternative-resource-dir", (gchar) 0, 0, G_OPTION_ARG_STRING_ARRAY, &vala_doc_alternative_resource_dirs, "Alternative resource directories", "DIRECTORY..."}, {"wiki", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &vala_doc_wikidirectory, "Wiki directory", "DIRECTORY"}, {"deps", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_doc_with_deps, "Adds packages to the documentation", NULL}, {"doclet", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_doc_docletpath, "Name of an included doclet or path to custom doclet", "PLUGIN"}, {"doclet-arg", 'X', 0, G_OPTION_ARG_STRING_ARRAY, &vala_doc_pluginargs, "Pass arguments to the doclet", "ARG"}, {"no-protected", (gchar) 0, (gint) G_OPTION_FLAG_REVERSE, G_OPTION_ARG_NONE, &vala_doc__protected, "Removes protected elements from documentation", NULL}, {"internal", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_doc__internal, "Adds internal elements to documentation", NULL}, {"private", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_doc__private, "Adds private elements to documentation", NULL}, {"use-svg-images", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_doc_use_svg_images, "Generate SVG image charts instead of PNG", NULL}, {"package-name", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_doc_pkg_name, "package name", "NAME"}, {"package-version", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_doc_pkg_version, "package version", "VERSION"}, {"gir", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_doc_gir_name, "GObject-Introspection repository file name", "NAME-VERSION.gir"}, {"version", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_doc_version, "Display version number", NULL}, {"force", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_doc_force, "force", NULL}, {"verbose", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_doc_verbose, "Show all warnings", NULL}, {"no-color", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_doc_disable_diagnostic_colors, "Disable colored output", NULL}, {"target-glib", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_doc_target_glib, "Target version of glib for code generation", "MAJOR.MINOR"}, {"", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_doc_tsources, NULL, "FILE..."}, {NULL}};

static gint vala_doc_quit (ValadocErrorReporter* reporter) {
	gint result = 0;
	ValadocErrorReporter* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_val_if_fail (reporter != NULL, 0);
	_tmp0_ = reporter;
	_tmp1_ = valadoc_error_reporter_get_errors (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == 0) {
		FILE* _tmp3_;
		ValadocErrorReporter* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		_tmp3_ = stdout;
		_tmp4_ = reporter;
		_tmp5_ = valadoc_error_reporter_get_warnings (_tmp4_);
		_tmp6_ = _tmp5_;
		fprintf (_tmp3_, "Succeeded - %d warning(s)\n", _tmp6_);
		result = 0;
		return result;
	} else {
		FILE* _tmp7_;
		ValadocErrorReporter* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		ValadocErrorReporter* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		_tmp7_ = stdout;
		_tmp8_ = reporter;
		_tmp9_ = valadoc_error_reporter_get_errors (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = reporter;
		_tmp12_ = valadoc_error_reporter_get_warnings (_tmp11_);
		_tmp13_ = _tmp12_;
		fprintf (_tmp7_, "Failed: %d error(s), %d warning(s)\n", _tmp10_, _tmp13_);
		result = 1;
		return result;
	}
}


static gboolean vala_doc_check_pkg_name (void) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	_tmp0_ = vala_doc_pkg_name;
	if (_tmp0_ == NULL) {
		result = TRUE;
		return result;
	}
	_tmp2_ = vala_doc_pkg_name;
	if (g_strcmp0 (_tmp2_, "glib-2.0") == 0) {
		_tmp1_ = TRUE;
	} else {
		const gchar* _tmp3_;
		_tmp3_ = vala_doc_pkg_name;
		_tmp1_ = g_strcmp0 (_tmp3_, "gobject-2.0") == 0;
	}
	if (_tmp1_) {
		result = FALSE;
		return result;
	}
	_tmp4_ = vala_doc_tsources;
	_tmp4__length1 = _vala_array_length (vala_doc_tsources);
	{
		gchar** package_collection = NULL;
		gint package_collection_length1 = 0;
		gint _package_collection_size_ = 0;
		gint package_it = 0;
		package_collection = _tmp4_;
		package_collection_length1 = _tmp4__length1;
		for (package_it = 0; package_it < _tmp4__length1; package_it = package_it + 1) {
			gchar* _tmp5_;
			gchar* package = NULL;
			_tmp5_ = g_strdup (package_collection[package_it]);
			package = _tmp5_;
			{
				const gchar* _tmp6_;
				const gchar* _tmp7_;
				_tmp6_ = vala_doc_pkg_name;
				_tmp7_ = package;
				if (g_strcmp0 (_tmp6_, _tmp7_) == 0) {
					result = FALSE;
					_g_free0 (package);
					return result;
				}
				_g_free0 (package);
			}
		}
	}
	result = TRUE;
	return result;
}


static gchar* vala_doc_get_pkg_name (ValaDoc* self) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = vala_doc_pkg_name;
	if (_tmp0_ == NULL) {
		const gchar* _tmp1_;
		gboolean _tmp2_;
		_tmp1_ = vala_doc_directory;
		_tmp2_ = g_str_has_suffix (_tmp1_, "/");
		if (_tmp2_) {
			const gchar* _tmp3_;
			gchar* _tmp4_;
			_tmp3_ = vala_doc_directory;
			_tmp4_ = g_path_get_dirname (_tmp3_);
			_g_free0 (vala_doc_pkg_name);
			vala_doc_pkg_name = _tmp4_;
		} else {
			const gchar* _tmp5_;
			gchar* _tmp6_;
			_tmp5_ = vala_doc_directory;
			_tmp6_ = g_path_get_basename (_tmp5_);
			_g_free0 (vala_doc_pkg_name);
			vala_doc_pkg_name = _tmp6_;
		}
	}
	_tmp7_ = vala_doc_pkg_name;
	_tmp8_ = g_strdup (_tmp7_);
	result = _tmp8_;
	return result;
}


static ValadocModuleLoader* vala_doc_create_module_loader (ValaDoc* self, ValadocErrorReporter* reporter, ValadocDoclet* * doclet, ValadocDriver* * driver) {
	ValadocDoclet* _vala_doclet = NULL;
	ValadocDriver* _vala_driver = NULL;
	ValadocModuleLoader* result = NULL;
	ValadocModuleLoader* modules = NULL;
	ValadocModuleLoader* _tmp0_;
	gchar* pluginpath = NULL;
	const gchar* _tmp1_;
	ValadocErrorReporter* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	ValadocModuleLoader* _tmp5_;
	const gchar* _tmp6_;
	ValadocDoclet* _tmp7_;
	ValadocDoclet* _tmp8_;
	ValadocDriversDriver* _tmp10_;
	gboolean _tmp11_ = FALSE;
	ValadocDriver* _tmp12_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (reporter != NULL, NULL);
	_tmp0_ = valadoc_module_loader_get_instance ();
	modules = _tmp0_;
	_g_object_unref0 (_vala_doclet);
	_vala_doclet = NULL;
	_g_object_unref0 (_vala_driver);
	_vala_driver = NULL;
	_tmp1_ = vala_doc_docletpath;
	_tmp2_ = reporter;
	_tmp3_ = valadoc_module_loader_get_doclet_path (_tmp1_, _tmp2_);
	pluginpath = _tmp3_;
	_tmp4_ = pluginpath;
	if (_tmp4_ == NULL) {
		result = NULL;
		_g_free0 (pluginpath);
		_g_object_unref0 (modules);
		if (doclet) {
			*doclet = _vala_doclet;
		} else {
			_g_object_unref0 (_vala_doclet);
		}
		if (driver) {
			*driver = _vala_driver;
		} else {
			_g_object_unref0 (_vala_driver);
		}
		return result;
	}
	_tmp5_ = modules;
	_tmp6_ = pluginpath;
	_tmp7_ = valadoc_module_loader_create_doclet (_tmp5_, _tmp6_);
	_g_object_unref0 (_vala_doclet);
	_vala_doclet = _tmp7_;
	_tmp8_ = _vala_doclet;
	if (_tmp8_ == NULL) {
		ValadocErrorReporter* _tmp9_;
		_tmp9_ = reporter;
		valadoc_error_reporter_simple_error (_tmp9_, NULL, "failed to load doclet");
		result = NULL;
		_g_free0 (pluginpath);
		_g_object_unref0 (modules);
		if (doclet) {
			*doclet = _vala_doclet;
		} else {
			_g_object_unref0 (_vala_doclet);
		}
		if (driver) {
			*driver = _vala_driver;
		} else {
			_g_object_unref0 (_vala_driver);
		}
		return result;
	}
	_tmp10_ = valadoc_drivers_driver_new ();
	_g_object_unref0 (_vala_driver);
	_vala_driver = (ValadocDriver*) _tmp10_;
	_tmp12_ = _vala_driver;
	if (_tmp12_ != NULL) {
		ValadocDoclet* _tmp13_;
		_tmp13_ = _vala_doclet;
		_tmp11_ = _tmp13_ != NULL;
	} else {
		_tmp11_ = FALSE;
	}
	_vala_assert (_tmp11_, "driver != null && doclet != null");
	result = modules;
	_g_free0 (pluginpath);
	if (doclet) {
		*doclet = _vala_doclet;
	} else {
		_g_object_unref0 (_vala_doclet);
	}
	if (driver) {
		*driver = _vala_driver;
	} else {
		_g_object_unref0 (_vala_driver);
	}
	return result;
}


static gchar** _vala_array_dup4 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup5 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup6 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup7 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup8 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup9 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup10 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup11 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gint vala_doc_run (ValaDoc* self, ValadocErrorReporter* reporter) {
	gint result = 0;
	ValadocSettings* settings = NULL;
	ValadocSettings* _tmp0_;
	ValadocErrorReporter* _tmp1_;
	ValadocSettings* _tmp2_;
	ValadocSettings* _tmp3_;
	gchar* _tmp4_;
	ValadocSettings* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	ValadocSettings* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	ValadocSettings* _tmp23_;
	const gchar* _tmp24_;
	gchar* _tmp25_;
	ValadocSettings* _tmp26_;
	gboolean _tmp27_;
	ValadocSettings* _tmp28_;
	gboolean _tmp29_;
	ValadocSettings* _tmp30_;
	gboolean _tmp31_;
	ValadocSettings* _tmp32_;
	gboolean _tmp33_;
	ValadocSettings* _tmp34_;
	gboolean _tmp35_;
	ValadocSettings* _tmp36_;
	const gchar* _tmp37_;
	gchar* _tmp38_;
	ValadocSettings* _tmp39_;
	gboolean _tmp40_;
	ValadocSettings* _tmp41_;
	const gchar* _tmp42_;
	gchar* _tmp43_;
	ValadocSettings* _tmp44_;
	gchar** _tmp45_;
	gint _tmp45__length1;
	gchar** _tmp46_;
	gint _tmp46__length1;
	ValadocSettings* _tmp47_;
	gboolean _tmp48_;
	ValadocSettings* _tmp49_;
	gboolean _tmp50_;
	ValadocSettings* _tmp51_;
	const gchar* _tmp52_;
	gchar* _tmp53_;
	ValadocSettings* _tmp54_;
	const gchar* _tmp55_;
	gchar* _tmp56_;
	ValadocSettings* _tmp57_;
	gchar** _tmp58_;
	gint _tmp58__length1;
	gchar** _tmp59_;
	gint _tmp59__length1;
	ValadocSettings* _tmp60_;
	gchar** _tmp61_;
	gint _tmp61__length1;
	gchar** _tmp62_;
	gint _tmp62__length1;
	ValadocSettings* _tmp63_;
	gchar** _tmp64_;
	gint _tmp64__length1;
	gchar** _tmp65_;
	gint _tmp65__length1;
	ValadocSettings* _tmp66_;
	const gchar* _tmp67_;
	gchar* _tmp68_;
	ValadocSettings* _tmp69_;
	gboolean _tmp70_;
	ValadocSettings* _tmp71_;
	gchar** _tmp72_;
	gint _tmp72__length1;
	gchar** _tmp73_;
	gint _tmp73__length1;
	ValadocSettings* _tmp74_;
	gchar** _tmp75_;
	gint _tmp75__length1;
	gchar** _tmp76_;
	gint _tmp76__length1;
	ValadocSettings* _tmp77_;
	const gchar* _tmp78_;
	gchar* _tmp79_;
	ValadocSettings* _tmp80_;
	gchar** _tmp81_;
	gint _tmp81__length1;
	gchar** _tmp82_;
	gint _tmp82__length1;
	ValadocSettings* _tmp83_;
	gchar** _tmp84_;
	gint _tmp84__length1;
	gchar** _tmp85_;
	gint _tmp85__length1;
	ValadocDoclet* doclet = NULL;
	ValadocDriver* driver = NULL;
	ValadocModuleLoader* modules = NULL;
	ValadocErrorReporter* _tmp86_;
	ValadocDoclet* _tmp87_ = NULL;
	ValadocDriver* _tmp88_ = NULL;
	ValadocModuleLoader* _tmp89_;
	gboolean _tmp90_ = FALSE;
	ValadocErrorReporter* _tmp91_;
	gint _tmp92_;
	gint _tmp93_;
	ValadocApiTree* doctree = NULL;
	ValadocDriver* _tmp97_;
	ValadocSettings* _tmp98_;
	ValadocErrorReporter* _tmp99_;
	ValadocApiTree* _tmp100_;
	ValadocErrorReporter* _tmp101_;
	gint _tmp102_;
	gint _tmp103_;
	ValadocApiChildSymbolRegistrar* registrar = NULL;
	ValadocApiChildSymbolRegistrar* _tmp106_;
	ValadocApiTree* _tmp107_;
	ValadocApiChildSymbolRegistrar* _tmp108_;
	ValadocDocumentationParser* docparser = NULL;
	ValadocSettings* _tmp109_;
	ValadocErrorReporter* _tmp110_;
	ValadocApiTree* _tmp111_;
	ValadocModuleLoader* _tmp112_;
	ValadocDocumentationParser* _tmp113_;
	ValadocApiTree* _tmp114_;
	gboolean _tmp115_;
	ValadocImporterDocumentationImporter** importers = NULL;
	ValadocApiTree* _tmp118_;
	ValadocDocumentationParser* _tmp119_;
	ValadocModuleLoader* _tmp120_;
	ValadocSettings* _tmp121_;
	ValadocErrorReporter* _tmp122_;
	ValadocImporterValadocDocumentationImporter* _tmp123_;
	ValadocApiTree* _tmp124_;
	ValadocDocumentationParser* _tmp125_;
	ValadocModuleLoader* _tmp126_;
	ValadocSettings* _tmp127_;
	ValadocErrorReporter* _tmp128_;
	ValadocImporterGirDocumentationImporter* _tmp129_;
	ValadocImporterDocumentationImporter** _tmp130_;
	gint importers_length1;
	gint _importers_size_;
	ValadocApiTree* _tmp131_;
	ValadocDocumentationParser* _tmp132_;
	ValadocErrorReporter* _tmp133_;
	gint _tmp134_;
	gint _tmp135_;
	ValadocApiTree* _tmp138_;
	ValadocImporterDocumentationImporter** _tmp139_;
	gint _tmp139__length1;
	gchar** _tmp140_;
	gint _tmp140__length1;
	gchar** _tmp141_;
	gint _tmp141__length1;
	ValadocErrorReporter* _tmp142_;
	gint _tmp143_;
	gint _tmp144_;
	ValadocApiTree* _tmp147_;
	ValadocDocumentationParser* _tmp148_;
	ValadocErrorReporter* _tmp149_;
	gint _tmp150_;
	gint _tmp151_;
	const gchar* _tmp154_;
	ValadocDoclet* _tmp163_;
	ValadocSettings* _tmp164_;
	ValadocApiTree* _tmp165_;
	ValadocErrorReporter* _tmp166_;
	ValadocErrorReporter* _tmp167_;
	gint _tmp168_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (reporter != NULL, 0);
	_tmp0_ = valadoc_settings_new ();
	settings = _tmp0_;
	_tmp1_ = reporter;
	_tmp2_ = settings;
	valadoc_error_reporter_set_settings (_tmp1_, _tmp2_);
	_tmp3_ = settings;
	_tmp4_ = vala_doc_get_pkg_name (self);
	_g_free0 (_tmp3_->pkg_name);
	_tmp3_->pkg_name = _tmp4_;
	_tmp5_ = settings;
	_tmp6_ = vala_doc_gir_namespace;
	_tmp7_ = g_strdup (_tmp6_);
	_g_free0 (_tmp5_->gir_namespace);
	_tmp5_->gir_namespace = _tmp7_;
	_tmp8_ = settings;
	_tmp9_ = vala_doc_gir_version;
	_tmp10_ = g_strdup (_tmp9_);
	_g_free0 (_tmp8_->gir_version);
	_tmp8_->gir_version = _tmp10_;
	_tmp11_ = vala_doc_gir_name;
	if (_tmp11_ != NULL) {
		ValadocSettings* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		ValadocSettings* _tmp15_;
		const gchar* _tmp16_;
		gchar* _tmp17_;
		ValadocSettings* _tmp18_;
		const gchar* _tmp19_;
		_tmp12_ = settings;
		_tmp13_ = vala_doc_gir_name;
		_tmp14_ = g_path_get_basename (_tmp13_);
		_g_free0 (_tmp12_->gir_name);
		_tmp12_->gir_name = _tmp14_;
		_tmp15_ = settings;
		_tmp16_ = vala_doc_gir_name;
		_tmp17_ = g_path_get_dirname (_tmp16_);
		_g_free0 (_tmp15_->gir_directory);
		_tmp15_->gir_directory = _tmp17_;
		_tmp18_ = settings;
		_tmp19_ = _tmp18_->gir_directory;
		if (g_strcmp0 (_tmp19_, "") == 0) {
			ValadocSettings* _tmp20_;
			const gchar* _tmp21_;
			gchar* _tmp22_;
			_tmp20_ = settings;
			_tmp21_ = vala_doc_directory;
			_tmp22_ = g_path_get_dirname (_tmp21_);
			_g_free0 (_tmp20_->gir_directory);
			_tmp20_->gir_directory = _tmp22_;
		}
	}
	_tmp23_ = settings;
	_tmp24_ = vala_doc_pkg_version;
	_tmp25_ = g_strdup (_tmp24_);
	_g_free0 (_tmp23_->pkg_version);
	_tmp23_->pkg_version = _tmp25_;
	_tmp26_ = settings;
	_tmp27_ = vala_doc_add_inherited;
	_tmp26_->add_inherited = _tmp27_;
	_tmp28_ = settings;
	_tmp29_ = vala_doc__protected;
	_tmp28_->_protected = _tmp29_;
	_tmp30_ = settings;
	_tmp31_ = vala_doc__internal;
	_tmp30_->_internal = _tmp31_;
	_tmp32_ = settings;
	_tmp33_ = vala_doc_with_deps;
	_tmp32_->with_deps = _tmp33_;
	_tmp34_ = settings;
	_tmp35_ = vala_doc__private;
	_tmp34_->_private = _tmp35_;
	_tmp36_ = settings;
	_tmp37_ = vala_doc_directory;
	_tmp38_ = valadoc_realpath (_tmp37_);
	_g_free0 (_tmp36_->path);
	_tmp36_->path = _tmp38_;
	_tmp39_ = settings;
	_tmp40_ = vala_doc_verbose;
	_tmp39_->verbose = _tmp40_;
	_tmp41_ = settings;
	_tmp42_ = vala_doc_wikidirectory;
	_tmp43_ = g_strdup (_tmp42_);
	_g_free0 (_tmp41_->wiki_directory);
	_tmp41_->wiki_directory = _tmp43_;
	_tmp44_ = settings;
	_tmp45_ = vala_doc_pluginargs;
	_tmp45__length1 = _vala_array_length (vala_doc_pluginargs);
	_tmp46_ = (_tmp45_ != NULL) ? _vala_array_dup4 (_tmp45_, _tmp45__length1) : ((gpointer) _tmp45_);
	_tmp46__length1 = _tmp45__length1;
	_tmp44_->pluginargs = (_vala_array_free (_tmp44_->pluginargs, _tmp44_->pluginargs_length1, (GDestroyNotify) g_free), NULL);
	_tmp44_->pluginargs = _tmp46_;
	_tmp44_->pluginargs_length1 = _tmp46__length1;
	_tmp47_ = settings;
	_tmp48_ = vala_doc_experimental;
	_tmp47_->experimental = _tmp48_;
	_tmp49_ = settings;
	_tmp50_ = vala_doc_experimental_non_null;
	_tmp49_->experimental_non_null = _tmp50_;
	_tmp51_ = settings;
	_tmp52_ = vala_doc_basedir;
	_tmp53_ = g_strdup (_tmp52_);
	_g_free0 (_tmp51_->basedir);
	_tmp51_->basedir = _tmp53_;
	_tmp54_ = settings;
	_tmp55_ = vala_doc_directory;
	_tmp56_ = g_strdup (_tmp55_);
	_g_free0 (_tmp54_->directory);
	_tmp54_->directory = _tmp56_;
	_tmp57_ = settings;
	_tmp58_ = vala_doc_vapi_directories;
	_tmp58__length1 = _vala_array_length (vala_doc_vapi_directories);
	_tmp59_ = (_tmp58_ != NULL) ? _vala_array_dup5 (_tmp58_, _tmp58__length1) : ((gpointer) _tmp58_);
	_tmp59__length1 = _tmp58__length1;
	_tmp57_->vapi_directories = (_vala_array_free (_tmp57_->vapi_directories, _tmp57_->vapi_directories_length1, (GDestroyNotify) g_free), NULL);
	_tmp57_->vapi_directories = _tmp59_;
	_tmp57_->vapi_directories_length1 = _tmp59__length1;
	_tmp60_ = settings;
	_tmp61_ = vala_doc_metadata_directories;
	_tmp61__length1 = _vala_array_length (vala_doc_metadata_directories);
	_tmp62_ = (_tmp61_ != NULL) ? _vala_array_dup6 (_tmp61_, _tmp61__length1) : ((gpointer) _tmp61_);
	_tmp62__length1 = _tmp61__length1;
	_tmp60_->metadata_directories = (_vala_array_free (_tmp60_->metadata_directories, _tmp60_->metadata_directories_length1, (GDestroyNotify) g_free), NULL);
	_tmp60_->metadata_directories = _tmp62_;
	_tmp60_->metadata_directories_length1 = _tmp62__length1;
	_tmp63_ = settings;
	_tmp64_ = vala_doc_gir_directories;
	_tmp64__length1 = _vala_array_length (vala_doc_gir_directories);
	_tmp65_ = (_tmp64_ != NULL) ? _vala_array_dup7 (_tmp64_, _tmp64__length1) : ((gpointer) _tmp64_);
	_tmp65__length1 = _tmp64__length1;
	_tmp63_->gir_directories = (_vala_array_free (_tmp63_->gir_directories, _tmp63_->gir_directories_length1, (GDestroyNotify) g_free), NULL);
	_tmp63_->gir_directories = _tmp65_;
	_tmp63_->gir_directories_length1 = _tmp65__length1;
	_tmp66_ = settings;
	_tmp67_ = vala_doc_target_glib;
	_tmp68_ = g_strdup (_tmp67_);
	_g_free0 (_tmp66_->target_glib);
	_tmp66_->target_glib = _tmp68_;
	_tmp69_ = settings;
	_tmp70_ = vala_doc_use_svg_images;
	_tmp69_->use_svg_images = _tmp70_;
	_tmp71_ = settings;
	_tmp72_ = vala_doc_tsources;
	_tmp72__length1 = _vala_array_length (vala_doc_tsources);
	_tmp73_ = (_tmp72_ != NULL) ? _vala_array_dup8 (_tmp72_, _tmp72__length1) : ((gpointer) _tmp72_);
	_tmp73__length1 = _tmp72__length1;
	_tmp71_->source_files = (_vala_array_free (_tmp71_->source_files, _tmp71_->source_files_length1, (GDestroyNotify) g_free), NULL);
	_tmp71_->source_files = _tmp73_;
	_tmp71_->source_files_length1 = _tmp73__length1;
	_tmp74_ = settings;
	_tmp75_ = vala_doc_packages;
	_tmp75__length1 = _vala_array_length (vala_doc_packages);
	_tmp76_ = (_tmp75_ != NULL) ? _vala_array_dup9 (_tmp75_, _tmp75__length1) : ((gpointer) _tmp75_);
	_tmp76__length1 = _tmp75__length1;
	_tmp74_->packages = (_vala_array_free (_tmp74_->packages, _tmp74_->packages_length1, (GDestroyNotify) g_free), NULL);
	_tmp74_->packages = _tmp76_;
	_tmp74_->packages_length1 = _tmp76__length1;
	_tmp77_ = settings;
	_tmp78_ = vala_doc_profile;
	_tmp79_ = g_strdup (_tmp78_);
	_g_free0 (_tmp77_->profile);
	_tmp77_->profile = _tmp79_;
	_tmp80_ = settings;
	_tmp81_ = vala_doc_defines;
	_tmp81__length1 = _vala_array_length (vala_doc_defines);
	_tmp82_ = (_tmp81_ != NULL) ? _vala_array_dup10 (_tmp81_, _tmp81__length1) : ((gpointer) _tmp81_);
	_tmp82__length1 = _tmp81__length1;
	_tmp80_->defines = (_vala_array_free (_tmp80_->defines, _tmp80_->defines_length1, (GDestroyNotify) g_free), NULL);
	_tmp80_->defines = _tmp82_;
	_tmp80_->defines_length1 = _tmp82__length1;
	_tmp83_ = settings;
	_tmp84_ = vala_doc_alternative_resource_dirs;
	_tmp84__length1 = _vala_array_length (vala_doc_alternative_resource_dirs);
	_tmp85_ = (_tmp84_ != NULL) ? _vala_array_dup11 (_tmp84_, _tmp84__length1) : ((gpointer) _tmp84_);
	_tmp85__length1 = _tmp84__length1;
	_tmp83_->alternative_resource_dirs = (_vala_array_free (_tmp83_->alternative_resource_dirs, _tmp83_->alternative_resource_dirs_length1, (GDestroyNotify) g_free), NULL);
	_tmp83_->alternative_resource_dirs = _tmp85_;
	_tmp83_->alternative_resource_dirs_length1 = _tmp85__length1;
	doclet = NULL;
	driver = NULL;
	_tmp86_ = reporter;
	_tmp89_ = vala_doc_create_module_loader (self, _tmp86_, &_tmp87_, &_tmp88_);
	_g_object_unref0 (doclet);
	doclet = _tmp87_;
	_g_object_unref0 (driver);
	driver = _tmp88_;
	modules = _tmp89_;
	_tmp91_ = reporter;
	_tmp92_ = valadoc_error_reporter_get_errors (_tmp91_);
	_tmp93_ = _tmp92_;
	if (_tmp93_ > 0) {
		_tmp90_ = TRUE;
	} else {
		ValadocModuleLoader* _tmp94_;
		_tmp94_ = modules;
		_tmp90_ = _tmp94_ == NULL;
	}
	if (_tmp90_) {
		ValadocErrorReporter* _tmp95_;
		gint _tmp96_;
		_tmp95_ = reporter;
		_tmp96_ = vala_doc_quit (_tmp95_);
		result = _tmp96_;
		_g_object_unref0 (modules);
		_g_object_unref0 (driver);
		_g_object_unref0 (doclet);
		_g_object_unref0 (settings);
		return result;
	}
	_tmp97_ = driver;
	_tmp98_ = settings;
	_tmp99_ = reporter;
	_tmp100_ = valadoc_driver_build (_tmp97_, _tmp98_, _tmp99_);
	doctree = _tmp100_;
	_tmp101_ = reporter;
	_tmp102_ = valadoc_error_reporter_get_errors (_tmp101_);
	_tmp103_ = _tmp102_;
	if (_tmp103_ > 0) {
		ValadocErrorReporter* _tmp104_;
		gint _tmp105_;
		_g_object_unref0 (driver);
		driver = NULL;
		_g_object_unref0 (doclet);
		doclet = NULL;
		_tmp104_ = reporter;
		_tmp105_ = vala_doc_quit (_tmp104_);
		result = _tmp105_;
		_valadoc_api_tree_unref0 (doctree);
		_g_object_unref0 (modules);
		_g_object_unref0 (driver);
		_g_object_unref0 (doclet);
		_g_object_unref0 (settings);
		return result;
	}
	_tmp106_ = valadoc_api_child_symbol_registrar_new ();
	registrar = _tmp106_;
	_tmp107_ = doctree;
	_tmp108_ = registrar;
	valadoc_api_tree_accept (_tmp107_, (ValadocApiVisitor*) _tmp108_);
	_tmp109_ = settings;
	_tmp110_ = reporter;
	_tmp111_ = doctree;
	_tmp112_ = modules;
	_tmp113_ = valadoc_documentation_parser_new (_tmp109_, _tmp110_, _tmp111_, _tmp112_);
	docparser = _tmp113_;
	_tmp114_ = doctree;
	_tmp115_ = valadoc_api_tree_create_tree (_tmp114_);
	if (!_tmp115_) {
		ValadocErrorReporter* _tmp116_;
		gint _tmp117_;
		_tmp116_ = reporter;
		_tmp117_ = vala_doc_quit (_tmp116_);
		result = _tmp117_;
		_g_object_unref0 (docparser);
		_g_object_unref0 (registrar);
		_valadoc_api_tree_unref0 (doctree);
		_g_object_unref0 (modules);
		_g_object_unref0 (driver);
		_g_object_unref0 (doclet);
		_g_object_unref0 (settings);
		return result;
	}
	_tmp118_ = doctree;
	_tmp119_ = docparser;
	_tmp120_ = modules;
	_tmp121_ = settings;
	_tmp122_ = reporter;
	_tmp123_ = valadoc_importer_valadoc_documentation_importer_new (_tmp118_, _tmp119_, _tmp120_, _tmp121_, _tmp122_);
	_tmp124_ = doctree;
	_tmp125_ = docparser;
	_tmp126_ = modules;
	_tmp127_ = settings;
	_tmp128_ = reporter;
	_tmp129_ = valadoc_importer_gir_documentation_importer_new (_tmp124_, _tmp125_, _tmp126_, _tmp127_, _tmp128_);
	_tmp130_ = g_new0 (ValadocImporterDocumentationImporter*, 2 + 1);
	_tmp130_[0] = (ValadocImporterDocumentationImporter*) _tmp123_;
	_tmp130_[1] = (ValadocImporterDocumentationImporter*) _tmp129_;
	importers = _tmp130_;
	importers_length1 = 2;
	_importers_size_ = importers_length1;
	_tmp131_ = doctree;
	_tmp132_ = docparser;
	valadoc_api_tree_parse_comments (_tmp131_, _tmp132_);
	_tmp133_ = reporter;
	_tmp134_ = valadoc_error_reporter_get_errors (_tmp133_);
	_tmp135_ = _tmp134_;
	if (_tmp135_ > 0) {
		ValadocErrorReporter* _tmp136_;
		gint _tmp137_;
		_tmp136_ = reporter;
		_tmp137_ = vala_doc_quit (_tmp136_);
		result = _tmp137_;
		importers = (_vala_array_free (importers, importers_length1, (GDestroyNotify) g_object_unref), NULL);
		_g_object_unref0 (docparser);
		_g_object_unref0 (registrar);
		_valadoc_api_tree_unref0 (doctree);
		_g_object_unref0 (modules);
		_g_object_unref0 (driver);
		_g_object_unref0 (doclet);
		_g_object_unref0 (settings);
		return result;
	}
	_tmp138_ = doctree;
	_tmp139_ = importers;
	_tmp139__length1 = importers_length1;
	_tmp140_ = vala_doc_import_packages;
	_tmp140__length1 = _vala_array_length (vala_doc_import_packages);
	_tmp141_ = vala_doc_import_directories;
	_tmp141__length1 = _vala_array_length (vala_doc_import_directories);
	valadoc_api_tree_import_comments (_tmp138_, _tmp139_, _tmp139__length1, _tmp140_, _tmp140__length1, _tmp141_, _tmp141__length1);
	_tmp142_ = reporter;
	_tmp143_ = valadoc_error_reporter_get_errors (_tmp142_);
	_tmp144_ = _tmp143_;
	if (_tmp144_ > 0) {
		ValadocErrorReporter* _tmp145_;
		gint _tmp146_;
		_tmp145_ = reporter;
		_tmp146_ = vala_doc_quit (_tmp145_);
		result = _tmp146_;
		importers = (_vala_array_free (importers, importers_length1, (GDestroyNotify) g_object_unref), NULL);
		_g_object_unref0 (docparser);
		_g_object_unref0 (registrar);
		_valadoc_api_tree_unref0 (doctree);
		_g_object_unref0 (modules);
		_g_object_unref0 (driver);
		_g_object_unref0 (doclet);
		_g_object_unref0 (settings);
		return result;
	}
	_tmp147_ = doctree;
	_tmp148_ = docparser;
	valadoc_api_tree_check_comments (_tmp147_, _tmp148_);
	_tmp149_ = reporter;
	_tmp150_ = valadoc_error_reporter_get_errors (_tmp149_);
	_tmp151_ = _tmp150_;
	if (_tmp151_ > 0) {
		ValadocErrorReporter* _tmp152_;
		gint _tmp153_;
		_tmp152_ = reporter;
		_tmp153_ = vala_doc_quit (_tmp152_);
		result = _tmp153_;
		importers = (_vala_array_free (importers, importers_length1, (GDestroyNotify) g_object_unref), NULL);
		_g_object_unref0 (docparser);
		_g_object_unref0 (registrar);
		_valadoc_api_tree_unref0 (doctree);
		_g_object_unref0 (modules);
		_g_object_unref0 (driver);
		_g_object_unref0 (doclet);
		_g_object_unref0 (settings);
		return result;
	}
	_tmp154_ = vala_doc_gir_name;
	if (_tmp154_ != NULL) {
		ValadocDriver* _tmp155_;
		ValadocSettings* _tmp156_;
		ValadocErrorReporter* _tmp157_;
		ValadocErrorReporter* _tmp158_;
		gint _tmp159_;
		gint _tmp160_;
		_tmp155_ = driver;
		_tmp156_ = settings;
		_tmp157_ = reporter;
		valadoc_driver_write_gir (_tmp155_, _tmp156_, _tmp157_);
		_tmp158_ = reporter;
		_tmp159_ = valadoc_error_reporter_get_errors (_tmp158_);
		_tmp160_ = _tmp159_;
		if (_tmp160_ > 0) {
			ValadocErrorReporter* _tmp161_;
			gint _tmp162_;
			_tmp161_ = reporter;
			_tmp162_ = vala_doc_quit (_tmp161_);
			result = _tmp162_;
			importers = (_vala_array_free (importers, importers_length1, (GDestroyNotify) g_object_unref), NULL);
			_g_object_unref0 (docparser);
			_g_object_unref0 (registrar);
			_valadoc_api_tree_unref0 (doctree);
			_g_object_unref0 (modules);
			_g_object_unref0 (driver);
			_g_object_unref0 (doclet);
			_g_object_unref0 (settings);
			return result;
		}
	}
	_tmp163_ = doclet;
	_tmp164_ = settings;
	_tmp165_ = doctree;
	_tmp166_ = reporter;
	valadoc_doclet_process (_tmp163_, _tmp164_, _tmp165_, _tmp166_);
	_tmp167_ = reporter;
	_tmp168_ = vala_doc_quit (_tmp167_);
	result = _tmp168_;
	importers = (_vala_array_free (importers, importers_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (docparser);
	_g_object_unref0 (registrar);
	_valadoc_api_tree_unref0 (doctree);
	_g_object_unref0 (modules);
	_g_object_unref0 (driver);
	_g_object_unref0 (doclet);
	_g_object_unref0 (settings);
	return result;
}


static gint string_last_index_of_char (const gchar* self, gunichar c, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_;
	gunichar _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = c;
	_tmp2_ = g_utf8_strrchr (((gchar*) self) + _tmp0_, (gssize) -1, _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	glong _tmp8_;
	glong _tmp14_;
	glong _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	gchar* _tmp22_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp3_;
		glong _tmp4_;
		glong _tmp5_;
		_tmp3_ = offset;
		_tmp4_ = len;
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
		string_length = _tmp5_;
	} else {
		gint _tmp6_;
		gint _tmp7_;
		_tmp6_ = strlen (self);
		_tmp7_ = _tmp6_;
		string_length = (glong) _tmp7_;
	}
	_tmp8_ = offset;
	if (_tmp8_ < ((glong) 0)) {
		glong _tmp9_;
		glong _tmp10_;
		glong _tmp11_;
		_tmp9_ = string_length;
		_tmp10_ = offset;
		offset = _tmp9_ + _tmp10_;
		_tmp11_ = offset;
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
	} else {
		glong _tmp12_;
		glong _tmp13_;
		_tmp12_ = offset;
		_tmp13_ = string_length;
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
	}
	_tmp14_ = len;
	if (_tmp14_ < ((glong) 0)) {
		glong _tmp15_;
		glong _tmp16_;
		_tmp15_ = string_length;
		_tmp16_ = offset;
		len = _tmp15_ - _tmp16_;
	}
	_tmp17_ = offset;
	_tmp18_ = len;
	_tmp19_ = string_length;
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
	_tmp20_ = offset;
	_tmp21_ = len;
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
	result = _tmp22_;
	return result;
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_;
	gchar _tmp1_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


static gint vala_doc_main (gchar** args, int args_length1) {
	gint result = 0;
	ValadocErrorReporter* reporter = NULL;
	ValadocErrorReporter* _tmp0_;
	gboolean _tmp15_;
	gboolean _tmp21_;
	const gchar* _tmp23_;
	gboolean _tmp27_;
	const gchar* _tmp31_;
	gboolean _tmp32_;
	const gchar* _tmp43_;
	gchar** _tmp49_;
	gint _tmp49__length1;
	ValadocErrorReporter* _tmp58_;
	gint _tmp59_;
	gint _tmp60_;
	const gchar* _tmp63_;
	ValaDoc* valadoc = NULL;
	ValaDoc* _tmp111_;
	ValaDoc* _tmp112_;
	ValadocErrorReporter* _tmp113_;
	gint _tmp114_;
	GError * _inner_error_ = NULL;
	setlocale (LC_ALL, "");
	_tmp0_ = valadoc_error_reporter_new (NULL);
	reporter = _tmp0_;
	{
		GOptionContext* opt_context = NULL;
		GOptionContext* _tmp1_;
		GOptionContext* _tmp2_;
		GOptionContext* _tmp3_;
		GOptionContext* _tmp4_;
		_tmp1_ = g_option_context_new ("- Vala Documentation Tool");
		opt_context = _tmp1_;
		_tmp2_ = opt_context;
		g_option_context_set_help_enabled (_tmp2_, TRUE);
		_tmp3_ = opt_context;
		g_option_context_add_main_entries (_tmp3_, VALA_DOC_options, NULL);
		_tmp4_ = opt_context;
		g_option_context_parse (_tmp4_, &args_length1, &args, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			gint _tmp5_ = 0;
			_g_option_context_free0 (opt_context);
			if (_inner_error_->domain == G_OPTION_ERROR) {
				goto __catch1_g_option_error;
			}
			_g_option_context_free0 (opt_context);
			_g_object_unref0 (reporter);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp5_;
		}
		_g_option_context_free0 (opt_context);
	}
	goto __finally1;
	__catch1_g_option_error:
	{
		GError* e = NULL;
		ValadocErrorReporter* _tmp6_;
		GError* _tmp7_;
		const gchar* _tmp8_;
		FILE* _tmp9_;
		gchar** _tmp10_;
		gint _tmp10__length1;
		const gchar* _tmp11_;
		ValadocErrorReporter* _tmp12_;
		gint _tmp13_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp6_ = reporter;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		valadoc_error_reporter_simple_error (_tmp6_, NULL, "%s", _tmp8_);
		_tmp9_ = stdout;
		_tmp10_ = args;
		_tmp10__length1 = args_length1;
		_tmp11_ = _tmp10_[0];
		fprintf (_tmp9_, "Run '%s --help' to see a full list of available command line options.\n", _tmp11_);
		_tmp12_ = reporter;
		_tmp13_ = vala_doc_quit (_tmp12_);
		result = _tmp13_;
		_g_error_free0 (e);
		_g_object_unref0 (reporter);
		return result;
	}
	__finally1:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gint _tmp14_ = 0;
		_g_object_unref0 (reporter);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return _tmp14_;
	}
	_tmp15_ = vala_doc_disable_diagnostic_colors;
	if (_tmp15_ == FALSE) {
		const gchar* env_colors = NULL;
		const gchar* _tmp16_;
		const gchar* _tmp17_;
		_tmp16_ = g_getenv ("VALA_COLORS");
		env_colors = _tmp16_;
		_tmp17_ = env_colors;
		if (_tmp17_ != NULL) {
			ValadocErrorReporter* _tmp18_;
			const gchar* _tmp19_;
			_tmp18_ = reporter;
			_tmp19_ = env_colors;
			valadoc_error_reporter_set_colors (_tmp18_, _tmp19_);
		} else {
			ValadocErrorReporter* _tmp20_;
			_tmp20_ = reporter;
			valadoc_error_reporter_set_colors (_tmp20_, VALA_DOC_DEFAULT_COLORS);
		}
	}
	_tmp21_ = vala_doc_version;
	if (_tmp21_) {
		FILE* _tmp22_;
		_tmp22_ = stdout;
		fprintf (_tmp22_, "Valadoc %s\n", BUILD_VERSION);
		result = 0;
		_g_object_unref0 (reporter);
		return result;
	}
	_tmp23_ = vala_doc_directory;
	if (_tmp23_ == NULL) {
		ValadocErrorReporter* _tmp24_;
		ValadocErrorReporter* _tmp25_;
		gint _tmp26_;
		_tmp24_ = reporter;
		valadoc_error_reporter_simple_error (_tmp24_, NULL, "No output directory specified.");
		_tmp25_ = reporter;
		_tmp26_ = vala_doc_quit (_tmp25_);
		result = _tmp26_;
		_g_object_unref0 (reporter);
		return result;
	}
	_tmp27_ = vala_doc_check_pkg_name ();
	if (!_tmp27_) {
		ValadocErrorReporter* _tmp28_;
		ValadocErrorReporter* _tmp29_;
		gint _tmp30_;
		_tmp28_ = reporter;
		valadoc_error_reporter_simple_error (_tmp28_, NULL, "File already exists");
		_tmp29_ = reporter;
		_tmp30_ = vala_doc_quit (_tmp29_);
		result = _tmp30_;
		_g_object_unref0 (reporter);
		return result;
	}
	_tmp31_ = vala_doc_directory;
	_tmp32_ = g_file_test (_tmp31_, G_FILE_TEST_EXISTS);
	if (_tmp32_) {
		gboolean _tmp33_;
		_tmp33_ = vala_doc_force;
		if (_tmp33_ == TRUE) {
			gboolean tmp = FALSE;
			const gchar* _tmp34_;
			gboolean _tmp35_;
			gboolean _tmp36_;
			_tmp34_ = vala_doc_directory;
			_tmp35_ = valadoc_remove_directory (_tmp34_);
			tmp = _tmp35_;
			_tmp36_ = tmp;
			if (_tmp36_ == FALSE) {
				ValadocErrorReporter* _tmp37_;
				ValadocErrorReporter* _tmp38_;
				gint _tmp39_;
				_tmp37_ = reporter;
				valadoc_error_reporter_simple_error (_tmp37_, NULL, "Can't remove directory.");
				_tmp38_ = reporter;
				_tmp39_ = vala_doc_quit (_tmp38_);
				result = _tmp39_;
				_g_object_unref0 (reporter);
				return result;
			}
		} else {
			ValadocErrorReporter* _tmp40_;
			ValadocErrorReporter* _tmp41_;
			gint _tmp42_;
			_tmp40_ = reporter;
			valadoc_error_reporter_simple_error (_tmp40_, NULL, "File already exists");
			_tmp41_ = reporter;
			_tmp42_ = vala_doc_quit (_tmp41_);
			result = _tmp42_;
			_g_object_unref0 (reporter);
			return result;
		}
	}
	_tmp43_ = vala_doc_wikidirectory;
	if (_tmp43_ != NULL) {
		const gchar* _tmp44_;
		gboolean _tmp45_;
		_tmp44_ = vala_doc_wikidirectory;
		_tmp45_ = g_file_test (_tmp44_, G_FILE_TEST_IS_DIR);
		if (!_tmp45_) {
			ValadocErrorReporter* _tmp46_;
			ValadocErrorReporter* _tmp47_;
			gint _tmp48_;
			_tmp46_ = reporter;
			valadoc_error_reporter_simple_error (_tmp46_, NULL, "Wiki-directory does not exist.");
			_tmp47_ = reporter;
			_tmp48_ = vala_doc_quit (_tmp47_);
			result = _tmp48_;
			_g_object_unref0 (reporter);
			return result;
		}
	}
	_tmp49_ = vala_doc_alternative_resource_dirs;
	_tmp49__length1 = _vala_array_length (vala_doc_alternative_resource_dirs);
	{
		gchar** dir_collection = NULL;
		gint dir_collection_length1 = 0;
		gint _dir_collection_size_ = 0;
		gint dir_it = 0;
		dir_collection = _tmp49_;
		dir_collection_length1 = _tmp49__length1;
		for (dir_it = 0; dir_it < _tmp49__length1; dir_it = dir_it + 1) {
			const gchar* dir = NULL;
			dir = dir_collection[dir_it];
			{
				const gchar* _tmp50_;
				gboolean _tmp51_;
				_tmp50_ = dir;
				_tmp51_ = g_file_test (_tmp50_, G_FILE_TEST_IS_DIR);
				if (!_tmp51_) {
					ValadocErrorReporter* _tmp52_;
					const gchar* _tmp53_;
					gchar* _tmp54_;
					gchar* _tmp55_;
					ValadocErrorReporter* _tmp56_;
					gint _tmp57_;
					_tmp52_ = reporter;
					_tmp53_ = dir;
					_tmp54_ = g_strdup_printf ("alternative resource directory '%s' does not exist.", _tmp53_);
					_tmp55_ = _tmp54_;
					valadoc_error_reporter_simple_error (_tmp52_, NULL, "%s", _tmp55_);
					_g_free0 (_tmp55_);
					_tmp56_ = reporter;
					_tmp57_ = vala_doc_quit (_tmp56_);
					result = _tmp57_;
					_g_object_unref0 (reporter);
					return result;
				}
			}
		}
	}
	_tmp58_ = reporter;
	_tmp59_ = valadoc_error_reporter_get_errors (_tmp58_);
	_tmp60_ = _tmp59_;
	if (_tmp60_ > 0) {
		ValadocErrorReporter* _tmp61_;
		gint _tmp62_;
		_tmp61_ = reporter;
		_tmp62_ = vala_doc_quit (_tmp61_);
		result = _tmp62_;
		_g_object_unref0 (reporter);
		return result;
	}
	_tmp63_ = vala_doc_gir_name;
	if (_tmp63_ != NULL) {
		glong gir_len = 0L;
		const gchar* _tmp64_;
		gint _tmp65_;
		gint _tmp66_;
		gint last_hyphen = 0;
		const gchar* _tmp67_;
		gint _tmp68_;
		gboolean _tmp69_ = FALSE;
		gint _tmp70_;
		const gchar* _tmp77_;
		gint _tmp78_;
		gchar* _tmp79_;
		const gchar* _tmp80_;
		gint _tmp81_;
		glong _tmp82_;
		gint _tmp83_;
		gchar* _tmp84_;
		const gchar* _tmp85_;
		gboolean _tmp86_ = FALSE;
		gboolean _tmp87_ = FALSE;
		gboolean _tmp88_ = FALSE;
		const gchar* _tmp89_;
		gboolean report_warning = FALSE;
		gchar** _tmp100_;
		gint _tmp100__length1;
		gboolean _tmp107_;
		_tmp64_ = vala_doc_gir_name;
		_tmp65_ = strlen (_tmp64_);
		_tmp66_ = _tmp65_;
		gir_len = (glong) _tmp66_;
		_tmp67_ = vala_doc_gir_name;
		_tmp68_ = string_last_index_of_char (_tmp67_, (gunichar) '-', 0);
		last_hyphen = _tmp68_;
		_tmp70_ = last_hyphen;
		if (_tmp70_ == -1) {
			_tmp69_ = TRUE;
		} else {
			const gchar* _tmp71_;
			gboolean _tmp72_;
			_tmp71_ = vala_doc_gir_name;
			_tmp72_ = g_str_has_suffix (_tmp71_, ".gir");
			_tmp69_ = !_tmp72_;
		}
		if (_tmp69_) {
			ValadocErrorReporter* _tmp73_;
			const gchar* _tmp74_;
			ValadocErrorReporter* _tmp75_;
			gint _tmp76_;
			_tmp73_ = reporter;
			_tmp74_ = vala_doc_gir_name;
			valadoc_error_reporter_simple_error (_tmp73_, NULL, "GIR file name '%s' is not well-formed, expected NAME-VERSION.gir", _tmp74_);
			_tmp75_ = reporter;
			_tmp76_ = vala_doc_quit (_tmp75_);
			result = _tmp76_;
			_g_object_unref0 (reporter);
			return result;
		}
		_tmp77_ = vala_doc_gir_name;
		_tmp78_ = last_hyphen;
		_tmp79_ = string_substring (_tmp77_, (glong) 0, (glong) _tmp78_);
		_g_free0 (vala_doc_gir_namespace);
		vala_doc_gir_namespace = _tmp79_;
		_tmp80_ = vala_doc_gir_name;
		_tmp81_ = last_hyphen;
		_tmp82_ = gir_len;
		_tmp83_ = last_hyphen;
		_tmp84_ = string_substring (_tmp80_, (glong) (_tmp81_ + 1), (_tmp82_ - _tmp83_) - 5);
		_g_free0 (vala_doc_gir_version);
		vala_doc_gir_version = _tmp84_;
		_tmp85_ = vala_doc_gir_version;
		g_strcanon (_tmp85_, "0123456789.", '?');
		_tmp89_ = vala_doc_gir_namespace;
		if (g_strcmp0 (_tmp89_, "") == 0) {
			_tmp88_ = TRUE;
		} else {
			const gchar* _tmp90_;
			_tmp90_ = vala_doc_gir_version;
			_tmp88_ = g_strcmp0 (_tmp90_, "") == 0;
		}
		if (_tmp88_) {
			_tmp87_ = TRUE;
		} else {
			const gchar* _tmp91_;
			gchar _tmp92_;
			gboolean _tmp93_;
			_tmp91_ = vala_doc_gir_version;
			_tmp92_ = string_get (_tmp91_, (glong) 0);
			_tmp93_ = g_ascii_isdigit (_tmp92_);
			_tmp87_ = !_tmp93_;
		}
		if (_tmp87_) {
			_tmp86_ = TRUE;
		} else {
			const gchar* _tmp94_;
			gboolean _tmp95_;
			_tmp94_ = vala_doc_gir_version;
			_tmp95_ = string_contains (_tmp94_, "?");
			_tmp86_ = _tmp95_;
		}
		if (_tmp86_) {
			ValadocErrorReporter* _tmp96_;
			const gchar* _tmp97_;
			ValadocErrorReporter* _tmp98_;
			gint _tmp99_;
			_tmp96_ = reporter;
			_tmp97_ = vala_doc_gir_name;
			valadoc_error_reporter_simple_error (_tmp96_, NULL, "GIR file name '%s' is not well-formed, expected NAME-VERSION.gir", _tmp97_);
			_tmp98_ = reporter;
			_tmp99_ = vala_doc_quit (_tmp98_);
			result = _tmp99_;
			_g_object_unref0 (reporter);
			return result;
		}
		report_warning = TRUE;
		_tmp100_ = vala_doc_tsources;
		_tmp100__length1 = _vala_array_length (vala_doc_tsources);
		{
			gchar** source_collection = NULL;
			gint source_collection_length1 = 0;
			gint _source_collection_size_ = 0;
			gint source_it = 0;
			source_collection = _tmp100_;
			source_collection_length1 = _tmp100__length1;
			for (source_it = 0; source_it < _tmp100__length1; source_it = source_it + 1) {
				gchar* _tmp101_;
				gchar* source = NULL;
				_tmp101_ = g_strdup (source_collection[source_it]);
				source = _tmp101_;
				{
					gboolean _tmp102_ = FALSE;
					const gchar* _tmp103_;
					gboolean _tmp104_;
					_tmp103_ = source;
					_tmp104_ = g_str_has_suffix (_tmp103_, ".vala");
					if (_tmp104_) {
						_tmp102_ = TRUE;
					} else {
						const gchar* _tmp105_;
						gboolean _tmp106_;
						_tmp105_ = source;
						_tmp106_ = g_str_has_suffix (_tmp105_, ".gs");
						_tmp102_ = _tmp106_;
					}
					if (_tmp102_) {
						report_warning = FALSE;
						_g_free0 (source);
						break;
					}
					_g_free0 (source);
				}
			}
		}
		_tmp107_ = report_warning;
		if (_tmp107_ == TRUE) {
			ValadocErrorReporter* _tmp108_;
			ValadocErrorReporter* _tmp109_;
			gint _tmp110_;
			_tmp108_ = reporter;
			valadoc_error_reporter_simple_error (_tmp108_, NULL, "No source file specified to be compiled to gir.");
			_tmp109_ = reporter;
			_tmp110_ = vala_doc_quit (_tmp109_);
			result = _tmp110_;
			_g_object_unref0 (reporter);
			return result;
		}
	}
	_tmp111_ = vala_doc_new ();
	valadoc = _tmp111_;
	_tmp112_ = valadoc;
	_tmp113_ = reporter;
	_tmp114_ = vala_doc_run (_tmp112_, _tmp113_);
	result = _tmp114_;
	_g_object_unref0 (valadoc);
	_g_object_unref0 (reporter);
	return result;
}


int main (int argc, char ** argv) {
	return vala_doc_main (argv, argc);
}


ValaDoc* vala_doc_construct (GType object_type) {
	ValaDoc * self = NULL;
	self = (ValaDoc*) g_object_new (object_type, NULL);
	return self;
}


ValaDoc* vala_doc_new (void) {
	return vala_doc_construct (TYPE_VALA_DOC);
}


static void vala_doc_class_init (ValaDocClass * klass) {
	vala_doc_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = vala_doc_finalize;
}


static void vala_doc_instance_init (ValaDoc * self) {
}


static void vala_doc_finalize (GObject * obj) {
	ValaDoc * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_VALA_DOC, ValaDoc);
	G_OBJECT_CLASS (vala_doc_parent_class)->finalize (obj);
}


GType vala_doc_get_type (void) {
	static volatile gsize vala_doc_type_id__volatile = 0;
	if (g_once_init_enter (&vala_doc_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaDocClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_doc_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaDoc), 0, (GInstanceInitFunc) vala_doc_instance_init, NULL };
		GType vala_doc_type_id;
		vala_doc_type_id = g_type_register_static (G_TYPE_OBJECT, "ValaDoc", &g_define_type_info, 0);
		g_once_init_leave (&vala_doc_type_id__volatile, vala_doc_type_id);
	}
	return vala_doc_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



