/* markupwriter.c generated by valac, the Vala compiler
 * generated from markupwriter.vala, do not modify */

/* markupwriter.vala
 *
 * Copyright (C) 2008-2009 Florian Brosch, Didier Villevalois
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Didier 'Ptitjes Villevalois <ptitjes@free.fr>
 */

#include <glib.h>
#include <glib-object.h>
#include "valadoc.h"
#include <stdlib.h>
#include <string.h>
#include <gobject/gvaluecollector.h>

enum  {
	VALADOC_MARKUP_WRITER_DUMMY_PROPERTY,
	VALADOC_MARKUP_WRITER_LAST_PROPERTY
};
static GParamSpec* valadoc_markup_writer_properties[VALADOC_MARKUP_WRITER_LAST_PROPERTY];
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ValadocParamSpecMarkupWriter ValadocParamSpecMarkupWriter;

struct _ValadocMarkupWriterPrivate {
	gboolean wrap;
};

struct _ValadocParamSpecMarkupWriter {
	GParamSpec parent_instance;
};


static gpointer valadoc_markup_writer_parent_class = NULL;

#define VALADOC_MARKUP_WRITER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALADOC_TYPE_MARKUP_WRITER, ValadocMarkupWriterPrivate))
#define VALADOC_MARKUP_WRITER_MAX_COLUMN 150
static void valadoc_markup_writer_check_column (ValadocMarkupWriter* self, const gchar* name, gboolean end_tag);
static void valadoc_markup_writer_break_line (ValadocMarkupWriter* self);
static gboolean valadoc_markup_writer_real_inline_element (ValadocMarkupWriter* self, const gchar* name);
static gboolean valadoc_markup_writer_real_content_inline_element (ValadocMarkupWriter* self, const gchar* name);
static void valadoc_markup_writer_finalize (ValadocMarkupWriter * obj);


static gunichar string_get_char (const gchar* self, glong index) {
	gunichar result = 0U;
	glong _tmp0_;
	gunichar _tmp1_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = index;
	_tmp1_ = g_utf8_get_char (((gchar*) self) + _tmp0_);
	result = _tmp1_;
	return result;
}


gchar* valadoc_markup_writer_escape (const gchar* txt) {
	gchar* result = NULL;
	GString* builder = NULL;
	GString* _tmp0_;
	const gchar* start = NULL;
	const gchar* _tmp1_;
	const gchar* pos = NULL;
	gunichar c = 0U;
	g_return_val_if_fail (txt != NULL, NULL);
	_tmp0_ = g_string_new ("");
	builder = _tmp0_;
	_tmp1_ = txt;
	start = _tmp1_;
	{
		const gchar* _tmp2_;
		gboolean _tmp3_ = FALSE;
		_tmp2_ = txt;
		pos = _tmp2_;
		_tmp3_ = TRUE;
		while (TRUE) {
			const gchar* _tmp6_;
			gunichar _tmp7_;
			gunichar _tmp8_;
			gunichar _tmp9_;
			if (!_tmp3_) {
				const gchar* _tmp4_;
				const gchar* _tmp5_;
				_tmp4_ = pos;
				_tmp5_ = g_utf8_next_char (_tmp4_);
				pos = _tmp5_;
			}
			_tmp3_ = FALSE;
			_tmp6_ = pos;
			_tmp7_ = string_get_char (_tmp6_, (glong) 0);
			c = _tmp7_;
			_tmp8_ = c;
			if (!(_tmp8_ != ((gunichar) '\0'))) {
				break;
			}
			_tmp9_ = c;
			switch (_tmp9_) {
				case '"':
				{
					GString* _tmp10_;
					const gchar* _tmp11_;
					const gchar* _tmp12_;
					const gchar* _tmp13_;
					GString* _tmp14_;
					const gchar* _tmp15_;
					const gchar* _tmp16_;
					_tmp10_ = builder;
					_tmp11_ = start;
					_tmp12_ = pos;
					_tmp13_ = start;
					g_string_append_len (_tmp10_, _tmp11_, (gssize) (((gchar*) _tmp12_) - ((gchar*) _tmp13_)));
					_tmp14_ = builder;
					g_string_append (_tmp14_, "&quot;");
					_tmp15_ = pos;
					_tmp16_ = g_utf8_next_char (_tmp15_);
					start = _tmp16_;
					break;
				}
				case '<':
				{
					GString* _tmp17_;
					const gchar* _tmp18_;
					const gchar* _tmp19_;
					const gchar* _tmp20_;
					GString* _tmp21_;
					const gchar* _tmp22_;
					const gchar* _tmp23_;
					_tmp17_ = builder;
					_tmp18_ = start;
					_tmp19_ = pos;
					_tmp20_ = start;
					g_string_append_len (_tmp17_, _tmp18_, (gssize) (((gchar*) _tmp19_) - ((gchar*) _tmp20_)));
					_tmp21_ = builder;
					g_string_append (_tmp21_, "&lt;");
					_tmp22_ = pos;
					_tmp23_ = g_utf8_next_char (_tmp22_);
					start = _tmp23_;
					break;
				}
				case '>':
				{
					GString* _tmp24_;
					const gchar* _tmp25_;
					const gchar* _tmp26_;
					const gchar* _tmp27_;
					GString* _tmp28_;
					const gchar* _tmp29_;
					const gchar* _tmp30_;
					_tmp24_ = builder;
					_tmp25_ = start;
					_tmp26_ = pos;
					_tmp27_ = start;
					g_string_append_len (_tmp24_, _tmp25_, (gssize) (((gchar*) _tmp26_) - ((gchar*) _tmp27_)));
					_tmp28_ = builder;
					g_string_append (_tmp28_, "&gt;");
					_tmp29_ = pos;
					_tmp30_ = g_utf8_next_char (_tmp29_);
					start = _tmp30_;
					break;
				}
				case '&':
				{
					GString* _tmp31_;
					const gchar* _tmp32_;
					const gchar* _tmp33_;
					const gchar* _tmp34_;
					GString* _tmp35_;
					const gchar* _tmp36_;
					const gchar* _tmp37_;
					_tmp31_ = builder;
					_tmp32_ = start;
					_tmp33_ = pos;
					_tmp34_ = start;
					g_string_append_len (_tmp31_, _tmp32_, (gssize) (((gchar*) _tmp33_) - ((gchar*) _tmp34_)));
					_tmp35_ = builder;
					g_string_append (_tmp35_, "&amp;");
					_tmp36_ = pos;
					_tmp37_ = g_utf8_next_char (_tmp36_);
					start = _tmp37_;
					break;
				}
				case '\'':
				{
					GString* _tmp38_;
					const gchar* _tmp39_;
					const gchar* _tmp40_;
					const gchar* _tmp41_;
					GString* _tmp42_;
					const gchar* _tmp43_;
					const gchar* _tmp44_;
					_tmp38_ = builder;
					_tmp39_ = start;
					_tmp40_ = pos;
					_tmp41_ = start;
					g_string_append_len (_tmp38_, _tmp39_, (gssize) (((gchar*) _tmp40_) - ((gchar*) _tmp41_)));
					_tmp42_ = builder;
					g_string_append (_tmp42_, "&apos;");
					_tmp43_ = pos;
					_tmp44_ = g_utf8_next_char (_tmp43_);
					start = _tmp44_;
					break;
				}
				default:
				break;
			}
		}
	}
	if ((&txt) == (&start)) {
		const gchar* _tmp45_;
		gchar* _tmp46_;
		_tmp45_ = txt;
		_tmp46_ = g_strdup (_tmp45_);
		result = _tmp46_;
		_g_string_free0 (builder);
		return result;
	} else {
		GString* _tmp47_;
		const gchar* _tmp48_;
		const gchar* _tmp49_;
		const gchar* _tmp50_;
		GString* _tmp51_;
		gchar* _tmp52_;
		_tmp47_ = builder;
		_tmp48_ = start;
		_tmp49_ = pos;
		_tmp50_ = start;
		g_string_append_len (_tmp47_, _tmp48_, (gssize) (((gchar*) _tmp49_) - ((gchar*) _tmp50_)));
		_tmp51_ = builder;
		_tmp52_ = _tmp51_->str;
		_tmp51_->str = NULL;
		result = _tmp52_;
		_g_string_free0 (builder);
		return result;
	}
	_g_string_free0 (builder);
}


/**
 * Initializes a new instance of the MarkupWriter
 * 
 * @param write stream a WriteFunc
 * @param xml_declaration specifies whether this file starts with an xml-declaration
 */
ValadocMarkupWriter* valadoc_markup_writer_construct (GType object_type, ValadocMarkupWriterWriteFunc write, void* write_target, GDestroyNotify write_target_destroy_notify, gboolean xml_declaration) {
	ValadocMarkupWriter* self = NULL;
	ValadocMarkupWriterWriteFunc _tmp0_;
	void* _tmp0__target;
	GDestroyNotify _tmp0__target_destroy_notify;
	gboolean _tmp1_;
	self = (ValadocMarkupWriter*) g_type_create_instance (object_type);
	_tmp0_ = write;
	_tmp0__target = write_target;
	_tmp0__target_destroy_notify = write_target_destroy_notify;
	write = NULL;
	write_target = NULL;
	write_target_destroy_notify = NULL;
	(self->write_target_destroy_notify == NULL) ? NULL : (self->write_target_destroy_notify (self->write_target), NULL);
	self->write = NULL;
	self->write_target = NULL;
	self->write_target_destroy_notify = NULL;
	self->write = _tmp0_;
	self->write_target = _tmp0__target;
	self->write_target_destroy_notify = _tmp0__target_destroy_notify;
	_tmp1_ = xml_declaration;
	if (_tmp1_) {
		valadoc_markup_writer_do_write (self, "<?xml version=\"1.0\" encoding=\"utf-8\"?>");
	}
	self->indent = -1;
	self->last_was_tag = TRUE;
	(write_target_destroy_notify == NULL) ? NULL : (write_target_destroy_notify (write_target), NULL);
	write = NULL;
	write_target = NULL;
	write_target_destroy_notify = NULL;
	return self;
}


ValadocMarkupWriter* valadoc_markup_writer_new (ValadocMarkupWriterWriteFunc write, void* write_target, GDestroyNotify write_target_destroy_notify, gboolean xml_declaration) {
	return valadoc_markup_writer_construct (VALADOC_TYPE_MARKUP_WRITER, write, write_target, write_target_destroy_notify, xml_declaration);
}


/**
 * Writes an start tag of a markup element to the file
 *
 * @param name the name of the markup
 * @param attributes a list of name/value pairs
 * @return this
 */
static gpointer _valadoc_markup_writer_ref0 (gpointer self) {
	return self ? valadoc_markup_writer_ref (self) : NULL;
}


ValadocMarkupWriter* valadoc_markup_writer_start_tag (ValadocMarkupWriter* self, const gchar* name, gchar** attributes, int attributes_length1) {
	ValadocMarkupWriter* result = NULL;
	gint _tmp0_;
	const gchar* _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	GString* content = NULL;
	GString* _tmp9_;
	GString* _tmp10_;
	const gchar* _tmp11_;
	GString* _tmp26_;
	GString* _tmp27_;
	const gchar* _tmp28_;
	ValadocMarkupWriter* _tmp29_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = self->indent;
	self->indent = _tmp0_ + 1;
	_tmp1_ = name;
	valadoc_markup_writer_check_column (self, _tmp1_, FALSE);
	_tmp2_ = attributes;
	_tmp2__length1 = attributes_length1;
	if ((_tmp2__length1 % 2) != 0) {
		gchar** _tmp3_;
		gint _tmp3__length1;
		gint _tmp4_;
		gchar** _tmp5_;
		gint _tmp5__length1;
		gchar** _tmp6_;
		gint _tmp6__length1;
		gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp3_ = attributes;
		_tmp3__length1 = attributes_length1;
		_tmp4_ = _tmp3__length1 + 1;
		attributes = g_renew (gchar*, attributes, _tmp3__length1 + 1);
		(_tmp4_ > attributes_length1) ? memset (attributes + attributes_length1, 0, sizeof (gchar*) * (_tmp4_ - attributes_length1)) : NULL;
		attributes_length1 = _tmp4_;
		_tmp5_ = attributes;
		_tmp5__length1 = attributes_length1;
		_tmp6_ = attributes;
		_tmp6__length1 = attributes_length1;
		_tmp7_ = g_strdup ("");
		_g_free0 (_tmp5_[_tmp6__length1 - 1]);
		_tmp5_[_tmp6__length1 - 1] = _tmp7_;
		_tmp8_ = _tmp5_[_tmp6__length1 - 1];
	}
	_tmp9_ = g_string_new ("<");
	content = _tmp9_;
	_tmp10_ = content;
	_tmp11_ = name;
	g_string_append (_tmp10_, _tmp11_);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp12_ = FALSE;
			_tmp12_ = TRUE;
			while (TRUE) {
				gint _tmp14_;
				gchar** _tmp15_;
				gint _tmp15__length1;
				gchar** _tmp16_;
				gint _tmp16__length1;
				gint _tmp17_;
				const gchar* _tmp18_;
				if (!_tmp12_) {
					gint _tmp13_;
					_tmp13_ = i;
					i = _tmp13_ + 2;
				}
				_tmp12_ = FALSE;
				_tmp14_ = i;
				_tmp15_ = attributes;
				_tmp15__length1 = attributes_length1;
				if (!(_tmp14_ < _tmp15__length1)) {
					break;
				}
				_tmp16_ = attributes;
				_tmp16__length1 = attributes_length1;
				_tmp17_ = i;
				_tmp18_ = _tmp16_[_tmp17_ + 1];
				if (_tmp18_ != NULL) {
					GString* _tmp19_;
					gchar** _tmp20_;
					gint _tmp20__length1;
					gint _tmp21_;
					const gchar* _tmp22_;
					gchar** _tmp23_;
					gint _tmp23__length1;
					gint _tmp24_;
					const gchar* _tmp25_;
					_tmp19_ = content;
					_tmp20_ = attributes;
					_tmp20__length1 = attributes_length1;
					_tmp21_ = i;
					_tmp22_ = _tmp20_[_tmp21_];
					_tmp23_ = attributes;
					_tmp23__length1 = attributes_length1;
					_tmp24_ = i;
					_tmp25_ = _tmp23_[_tmp24_ + 1];
					g_string_append_printf (_tmp19_, " %s=\"%s\"", _tmp22_, _tmp25_);
				}
			}
		}
	}
	_tmp26_ = content;
	g_string_append (_tmp26_, ">");
	_tmp27_ = content;
	_tmp28_ = _tmp27_->str;
	valadoc_markup_writer_do_write (self, _tmp28_);
	self->last_was_tag = TRUE;
	_tmp29_ = _valadoc_markup_writer_ref0 (self);
	result = _tmp29_;
	_g_string_free0 (content);
	return result;
}


/**
 * Writes a simple tag (<name />) to the file
 *
 * @param name the name of the markup
 * @param attributes a list of name/value pairs
 * @return this
 */
ValadocMarkupWriter* valadoc_markup_writer_simple_tag (ValadocMarkupWriter* self, const gchar* name, gchar** attributes, int attributes_length1) {
	ValadocMarkupWriter* result = NULL;
	gint _tmp0_;
	const gchar* _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	GString* content = NULL;
	GString* _tmp9_;
	GString* _tmp10_;
	const gchar* _tmp11_;
	GString* _tmp26_;
	GString* _tmp27_;
	const gchar* _tmp28_;
	gint _tmp29_;
	ValadocMarkupWriter* _tmp30_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = self->indent;
	self->indent = _tmp0_ + 1;
	_tmp1_ = name;
	valadoc_markup_writer_check_column (self, _tmp1_, FALSE);
	_tmp2_ = attributes;
	_tmp2__length1 = attributes_length1;
	if ((_tmp2__length1 % 2) != 0) {
		gchar** _tmp3_;
		gint _tmp3__length1;
		gint _tmp4_;
		gchar** _tmp5_;
		gint _tmp5__length1;
		gchar** _tmp6_;
		gint _tmp6__length1;
		gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp3_ = attributes;
		_tmp3__length1 = attributes_length1;
		_tmp4_ = _tmp3__length1 + 1;
		attributes = g_renew (gchar*, attributes, _tmp3__length1 + 1);
		(_tmp4_ > attributes_length1) ? memset (attributes + attributes_length1, 0, sizeof (gchar*) * (_tmp4_ - attributes_length1)) : NULL;
		attributes_length1 = _tmp4_;
		_tmp5_ = attributes;
		_tmp5__length1 = attributes_length1;
		_tmp6_ = attributes;
		_tmp6__length1 = attributes_length1;
		_tmp7_ = g_strdup ("");
		_g_free0 (_tmp5_[_tmp6__length1 - 1]);
		_tmp5_[_tmp6__length1 - 1] = _tmp7_;
		_tmp8_ = _tmp5_[_tmp6__length1 - 1];
	}
	_tmp9_ = g_string_new ("<");
	content = _tmp9_;
	_tmp10_ = content;
	_tmp11_ = name;
	g_string_append (_tmp10_, _tmp11_);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp12_ = FALSE;
			_tmp12_ = TRUE;
			while (TRUE) {
				gint _tmp14_;
				gchar** _tmp15_;
				gint _tmp15__length1;
				gchar** _tmp16_;
				gint _tmp16__length1;
				gint _tmp17_;
				const gchar* _tmp18_;
				if (!_tmp12_) {
					gint _tmp13_;
					_tmp13_ = i;
					i = _tmp13_ + 2;
				}
				_tmp12_ = FALSE;
				_tmp14_ = i;
				_tmp15_ = attributes;
				_tmp15__length1 = attributes_length1;
				if (!(_tmp14_ < _tmp15__length1)) {
					break;
				}
				_tmp16_ = attributes;
				_tmp16__length1 = attributes_length1;
				_tmp17_ = i;
				_tmp18_ = _tmp16_[_tmp17_ + 1];
				if (_tmp18_ != NULL) {
					GString* _tmp19_;
					gchar** _tmp20_;
					gint _tmp20__length1;
					gint _tmp21_;
					const gchar* _tmp22_;
					gchar** _tmp23_;
					gint _tmp23__length1;
					gint _tmp24_;
					const gchar* _tmp25_;
					_tmp19_ = content;
					_tmp20_ = attributes;
					_tmp20__length1 = attributes_length1;
					_tmp21_ = i;
					_tmp22_ = _tmp20_[_tmp21_];
					_tmp23_ = attributes;
					_tmp23__length1 = attributes_length1;
					_tmp24_ = i;
					_tmp25_ = _tmp23_[_tmp24_ + 1];
					g_string_append_printf (_tmp19_, " %s=\"%s\"", _tmp22_, _tmp25_);
				}
			}
		}
	}
	_tmp26_ = content;
	g_string_append (_tmp26_, "/>");
	_tmp27_ = content;
	_tmp28_ = _tmp27_->str;
	valadoc_markup_writer_do_write (self, _tmp28_);
	_tmp29_ = self->indent;
	self->indent = _tmp29_ - 1;
	self->last_was_tag = TRUE;
	_tmp30_ = _valadoc_markup_writer_ref0 (self);
	result = _tmp30_;
	_g_string_free0 (content);
	return result;
}


/**
 * Writes an end tag of a markup element to the file
 *
 * @param name the name of the markup
 * @return this
 */
ValadocMarkupWriter* valadoc_markup_writer_end_tag (ValadocMarkupWriter* self, const gchar* name) {
	ValadocMarkupWriter* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gint _tmp4_;
	ValadocMarkupWriter* _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = name;
	valadoc_markup_writer_check_column (self, _tmp0_, TRUE);
	_tmp1_ = name;
	_tmp2_ = g_strdup_printf ("</%s>", _tmp1_);
	_tmp3_ = _tmp2_;
	valadoc_markup_writer_do_write (self, _tmp3_);
	_g_free0 (_tmp3_);
	_tmp4_ = self->indent;
	self->indent = _tmp4_ - 1;
	self->last_was_tag = TRUE;
	_tmp5_ = _valadoc_markup_writer_ref0 (self);
	result = _tmp5_;
	return result;
}


/**
 * Writes the specified string to the output stream
 *
 * @see raw_text
 * @return this
 */
static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_;
	gchar _tmp1_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	glong _tmp8_;
	glong _tmp14_;
	glong _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	gchar* _tmp22_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp3_;
		glong _tmp4_;
		glong _tmp5_;
		_tmp3_ = offset;
		_tmp4_ = len;
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
		string_length = _tmp5_;
	} else {
		gint _tmp6_;
		gint _tmp7_;
		_tmp6_ = strlen (self);
		_tmp7_ = _tmp6_;
		string_length = (glong) _tmp7_;
	}
	_tmp8_ = offset;
	if (_tmp8_ < ((glong) 0)) {
		glong _tmp9_;
		glong _tmp10_;
		glong _tmp11_;
		_tmp9_ = string_length;
		_tmp10_ = offset;
		offset = _tmp9_ + _tmp10_;
		_tmp11_ = offset;
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
	} else {
		glong _tmp12_;
		glong _tmp13_;
		_tmp12_ = offset;
		_tmp13_ = string_length;
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
	}
	_tmp14_ = len;
	if (_tmp14_ < ((glong) 0)) {
		glong _tmp15_;
		glong _tmp16_;
		_tmp15_ = string_length;
		_tmp16_ = offset;
		len = _tmp15_ - _tmp16_;
	}
	_tmp17_ = offset;
	_tmp18_ = len;
	_tmp19_ = string_length;
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
	_tmp20_ = offset;
	_tmp21_ = len;
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
	result = _tmp22_;
	return result;
}


ValadocMarkupWriter* valadoc_markup_writer_text (ValadocMarkupWriter* self, const gchar* text) {
	ValadocMarkupWriter* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	ValadocMarkupWriter* _tmp49_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (text != NULL, NULL);
	_tmp1_ = self->priv->wrap;
	if (_tmp1_) {
		const gchar* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		glong _tmp5_;
		_tmp2_ = text;
		_tmp3_ = strlen (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = self->current_column;
		_tmp0_ = (_tmp4_ + _tmp5_) > ((glong) VALADOC_MARKUP_WRITER_MAX_COLUMN);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong wrote = 0L;
		wrote = (glong) 0;
		while (TRUE) {
			glong _tmp6_;
			const gchar* _tmp7_;
			gint _tmp8_;
			gint _tmp9_;
			glong space_pos = 0L;
			const gchar* _tmp24_;
			gint _tmp25_;
			gint _tmp26_;
			glong _tmp27_;
			glong _tmp28_;
			glong _tmp44_;
			const gchar* _tmp45_;
			gint _tmp46_;
			gint _tmp47_;
			_tmp6_ = wrote;
			_tmp7_ = text;
			_tmp8_ = strlen (_tmp7_);
			_tmp9_ = _tmp8_;
			if (!(_tmp6_ < ((glong) _tmp9_))) {
				break;
			}
			space_pos = (glong) -1;
			{
				glong i = 0L;
				glong _tmp10_;
				_tmp10_ = wrote;
				i = _tmp10_ + 1;
				{
					gboolean _tmp11_ = FALSE;
					_tmp11_ = TRUE;
					while (TRUE) {
						glong _tmp13_;
						const gchar* _tmp14_;
						gint _tmp15_;
						gint _tmp16_;
						const gchar* _tmp17_;
						glong _tmp18_;
						gchar _tmp19_;
						if (!_tmp11_) {
							glong _tmp12_;
							_tmp12_ = i;
							i = _tmp12_ + 1;
						}
						_tmp11_ = FALSE;
						_tmp13_ = i;
						_tmp14_ = text;
						_tmp15_ = strlen (_tmp14_);
						_tmp16_ = _tmp15_;
						if (!(_tmp13_ < ((glong) _tmp16_))) {
							break;
						}
						_tmp17_ = text;
						_tmp18_ = i;
						_tmp19_ = string_get (_tmp17_, _tmp18_);
						if (_tmp19_ == ' ') {
							glong _tmp20_;
							glong _tmp21_;
							glong _tmp22_;
							glong _tmp23_;
							_tmp20_ = i;
							_tmp21_ = wrote;
							_tmp22_ = self->current_column;
							if (((_tmp20_ - _tmp21_) + _tmp22_) > ((glong) VALADOC_MARKUP_WRITER_MAX_COLUMN)) {
								break;
							}
							_tmp23_ = i;
							space_pos = _tmp23_;
						}
					}
				}
			}
			_tmp24_ = text;
			_tmp25_ = strlen (_tmp24_);
			_tmp26_ = _tmp25_;
			_tmp27_ = wrote;
			_tmp28_ = self->current_column;
			if (((_tmp26_ - _tmp27_) + _tmp28_) <= ((glong) VALADOC_MARKUP_WRITER_MAX_COLUMN)) {
				const gchar* _tmp29_;
				glong _tmp30_;
				gchar* _tmp31_;
				gchar* _tmp32_;
				const gchar* _tmp33_;
				gint _tmp34_;
				gint _tmp35_;
				_tmp29_ = text;
				_tmp30_ = wrote;
				_tmp31_ = string_substring (_tmp29_, _tmp30_, (glong) -1);
				_tmp32_ = _tmp31_;
				valadoc_markup_writer_do_write (self, _tmp32_);
				_g_free0 (_tmp32_);
				_tmp33_ = text;
				_tmp34_ = strlen (_tmp33_);
				_tmp35_ = _tmp34_;
				wrote = (glong) (_tmp35_ + 1);
			} else {
				glong _tmp36_;
				_tmp36_ = space_pos;
				if (_tmp36_ == ((glong) -1)) {
				} else {
					const gchar* _tmp37_;
					glong _tmp38_;
					glong _tmp39_;
					glong _tmp40_;
					gchar* _tmp41_;
					gchar* _tmp42_;
					glong _tmp43_;
					_tmp37_ = text;
					_tmp38_ = wrote;
					_tmp39_ = space_pos;
					_tmp40_ = wrote;
					_tmp41_ = string_substring (_tmp37_, _tmp38_, _tmp39_ - _tmp40_);
					_tmp42_ = _tmp41_;
					valadoc_markup_writer_do_write (self, _tmp42_);
					_g_free0 (_tmp42_);
					_tmp43_ = space_pos;
					wrote = _tmp43_ + 1;
				}
			}
			_tmp44_ = wrote;
			_tmp45_ = text;
			_tmp46_ = strlen (_tmp45_);
			_tmp47_ = _tmp46_;
			if (_tmp44_ < ((glong) _tmp47_)) {
				valadoc_markup_writer_break_line (self);
				valadoc_markup_writer_do_write (self, "  ");
			}
		}
	} else {
		const gchar* _tmp48_;
		_tmp48_ = text;
		valadoc_markup_writer_do_write (self, _tmp48_);
	}
	self->last_was_tag = FALSE;
	_tmp49_ = _valadoc_markup_writer_ref0 (self);
	result = _tmp49_;
	return result;
}


/**
 * Writes the specified string to the output stream
 *
 * @see text
 * @return this
 */
ValadocMarkupWriter* valadoc_markup_writer_raw_text (ValadocMarkupWriter* self, const gchar* text) {
	ValadocMarkupWriter* result = NULL;
	const gchar* _tmp0_;
	ValadocMarkupWriter* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (text != NULL, NULL);
	_tmp0_ = text;
	valadoc_markup_writer_do_write (self, _tmp0_);
	self->last_was_tag = FALSE;
	_tmp1_ = _valadoc_markup_writer_ref0 (self);
	result = _tmp1_;
	return result;
}


void valadoc_markup_writer_set_wrap (ValadocMarkupWriter* self, gboolean wrap) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = wrap;
	self->priv->wrap = _tmp0_;
}


static void valadoc_markup_writer_break_line (ValadocMarkupWriter* self) {
	ValadocMarkupWriterWriteFunc _tmp0_;
	void* _tmp0__target;
	ValadocMarkupWriterWriteFunc _tmp1_;
	void* _tmp1__target;
	gint _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gint _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->write;
	_tmp0__target = self->write_target;
	_tmp0_ ("\n", _tmp0__target);
	_tmp1_ = self->write;
	_tmp1__target = self->write_target;
	_tmp2_ = self->indent;
	_tmp3_ = g_strnfill ((gsize) (_tmp2_ * 2), ' ');
	_tmp4_ = _tmp3_;
	_tmp1_ (_tmp4_, _tmp1__target);
	_g_free0 (_tmp4_);
	_tmp5_ = self->indent;
	self->current_column = (glong) (_tmp5_ * 2);
}


void valadoc_markup_writer_do_write (ValadocMarkupWriter* self, const gchar* text) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	ValadocMarkupWriterWriteFunc _tmp6_;
	void* _tmp6__target;
	const gchar* _tmp7_;
	glong _tmp8_;
	const gchar* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	_tmp1_ = self->priv->wrap;
	if (_tmp1_) {
		glong _tmp2_;
		const gchar* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		_tmp2_ = self->current_column;
		_tmp3_ = text;
		_tmp4_ = strlen (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp0_ = (_tmp2_ + _tmp5_) > ((glong) VALADOC_MARKUP_WRITER_MAX_COLUMN);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		valadoc_markup_writer_break_line (self);
	}
	_tmp6_ = self->write;
	_tmp6__target = self->write_target;
	_tmp7_ = text;
	_tmp6_ (_tmp7_, _tmp6__target);
	_tmp8_ = self->current_column;
	_tmp9_ = text;
	_tmp10_ = strlen (_tmp9_);
	_tmp11_ = _tmp10_;
	self->current_column = _tmp8_ + _tmp11_;
}


static void valadoc_markup_writer_check_column (ValadocMarkupWriter* self, const gchar* name, gboolean end_tag) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = self->priv->wrap;
	if (!_tmp0_) {
		return;
	} else {
		gboolean _tmp1_ = FALSE;
		gboolean _tmp2_;
		_tmp2_ = end_tag;
		if (!_tmp2_) {
			const gchar* _tmp3_;
			gboolean _tmp4_;
			_tmp3_ = name;
			_tmp4_ = valadoc_markup_writer_inline_element (self, _tmp3_);
			_tmp1_ = _tmp4_;
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			return;
		} else {
			gboolean _tmp5_ = FALSE;
			gboolean _tmp6_;
			_tmp6_ = end_tag;
			if (_tmp6_) {
				const gchar* _tmp7_;
				gboolean _tmp8_;
				_tmp7_ = name;
				_tmp8_ = valadoc_markup_writer_content_inline_element (self, _tmp7_);
				_tmp5_ = _tmp8_;
			} else {
				_tmp5_ = FALSE;
			}
			if (_tmp5_) {
				return;
			} else {
				gboolean _tmp9_ = FALSE;
				gboolean _tmp10_;
				_tmp10_ = end_tag;
				if (_tmp10_) {
					gboolean _tmp11_;
					_tmp11_ = self->last_was_tag;
					_tmp9_ = !_tmp11_;
				} else {
					_tmp9_ = FALSE;
				}
				if (_tmp9_) {
					return;
				}
			}
		}
	}
	valadoc_markup_writer_break_line (self);
}


static gboolean valadoc_markup_writer_real_inline_element (ValadocMarkupWriter* self, const gchar* name) {
	gboolean result = FALSE;
	g_return_val_if_fail (name != NULL, FALSE);
	result = FALSE;
	return result;
}


gboolean valadoc_markup_writer_inline_element (ValadocMarkupWriter* self, const gchar* name) {
	g_return_val_if_fail (self != NULL, FALSE);
	return VALADOC_MARKUP_WRITER_GET_CLASS (self)->inline_element (self, name);
}


static gboolean valadoc_markup_writer_real_content_inline_element (ValadocMarkupWriter* self, const gchar* name) {
	gboolean result = FALSE;
	g_return_val_if_fail (name != NULL, FALSE);
	result = TRUE;
	return result;
}


gboolean valadoc_markup_writer_content_inline_element (ValadocMarkupWriter* self, const gchar* name) {
	g_return_val_if_fail (self != NULL, FALSE);
	return VALADOC_MARKUP_WRITER_GET_CLASS (self)->content_inline_element (self, name);
}


static void valadoc_value_markup_writer_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void valadoc_value_markup_writer_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		valadoc_markup_writer_unref (value->data[0].v_pointer);
	}
}


static void valadoc_value_markup_writer_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = valadoc_markup_writer_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer valadoc_value_markup_writer_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* valadoc_value_markup_writer_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		ValadocMarkupWriter * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = valadoc_markup_writer_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* valadoc_value_markup_writer_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ValadocMarkupWriter ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = valadoc_markup_writer_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* valadoc_param_spec_markup_writer (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ValadocParamSpecMarkupWriter* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALADOC_TYPE_MARKUP_WRITER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer valadoc_value_get_markup_writer (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALADOC_TYPE_MARKUP_WRITER), NULL);
	return value->data[0].v_pointer;
}


void valadoc_value_set_markup_writer (GValue* value, gpointer v_object) {
	ValadocMarkupWriter * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALADOC_TYPE_MARKUP_WRITER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALADOC_TYPE_MARKUP_WRITER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		valadoc_markup_writer_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		valadoc_markup_writer_unref (old);
	}
}


void valadoc_value_take_markup_writer (GValue* value, gpointer v_object) {
	ValadocMarkupWriter * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALADOC_TYPE_MARKUP_WRITER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALADOC_TYPE_MARKUP_WRITER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		valadoc_markup_writer_unref (old);
	}
}


static void valadoc_markup_writer_class_init (ValadocMarkupWriterClass * klass) {
	valadoc_markup_writer_parent_class = g_type_class_peek_parent (klass);
	((ValadocMarkupWriterClass *) klass)->finalize = valadoc_markup_writer_finalize;
	g_type_class_add_private (klass, sizeof (ValadocMarkupWriterPrivate));
	((ValadocMarkupWriterClass *) klass)->inline_element = (gboolean (*) (ValadocMarkupWriter *, const gchar*)) valadoc_markup_writer_real_inline_element;
	((ValadocMarkupWriterClass *) klass)->content_inline_element = (gboolean (*) (ValadocMarkupWriter *, const gchar*)) valadoc_markup_writer_real_content_inline_element;
}


static void valadoc_markup_writer_instance_init (ValadocMarkupWriter * self) {
	self->priv = VALADOC_MARKUP_WRITER_GET_PRIVATE (self);
	self->current_column = (glong) 0;
	self->priv->wrap = TRUE;
	self->ref_count = 1;
}


static void valadoc_markup_writer_finalize (ValadocMarkupWriter * obj) {
	ValadocMarkupWriter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALADOC_TYPE_MARKUP_WRITER, ValadocMarkupWriter);
	g_signal_handlers_destroy (self);
	(self->write_target_destroy_notify == NULL) ? NULL : (self->write_target_destroy_notify (self->write_target), NULL);
	self->write = NULL;
	self->write_target = NULL;
	self->write_target_destroy_notify = NULL;
}


/**
 * Writes markups and text to a file.
 */
GType valadoc_markup_writer_get_type (void) {
	static volatile gsize valadoc_markup_writer_type_id__volatile = 0;
	if (g_once_init_enter (&valadoc_markup_writer_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { valadoc_value_markup_writer_init, valadoc_value_markup_writer_free_value, valadoc_value_markup_writer_copy_value, valadoc_value_markup_writer_peek_pointer, "p", valadoc_value_markup_writer_collect_value, "p", valadoc_value_markup_writer_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ValadocMarkupWriterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) valadoc_markup_writer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValadocMarkupWriter), 0, (GInstanceInitFunc) valadoc_markup_writer_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType valadoc_markup_writer_type_id;
		valadoc_markup_writer_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValadocMarkupWriter", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&valadoc_markup_writer_type_id__volatile, valadoc_markup_writer_type_id);
	}
	return valadoc_markup_writer_type_id__volatile;
}


gpointer valadoc_markup_writer_ref (gpointer instance) {
	ValadocMarkupWriter * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void valadoc_markup_writer_unref (gpointer instance) {
	ValadocMarkupWriter * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALADOC_MARKUP_WRITER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}



