// Generated by gmmproc 2.55.1 -- DO NOT MODIFY!
#ifndef _GTKMM_ICONINFO_H
#define _GTKMM_ICONINFO_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* Copyright (C) 2003 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <vector>

#include <gtkmm/stylecontext.h>
#include <gdkmm/rectangle.h>
#include <gdkmm/pixbuf.h>
#include <gdkmm/rgba.h>
#include <gdkmm/types.h>
#include <giomm/asyncresult.h>
#include <giomm/cancellable.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
extern "C" { typedef struct _GtkIconInfo GtkIconInfo; }
#endif

namespace Gtk
{

class IconTheme;

class IconInfo
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = IconInfo;
  using BaseObjectType = GtkIconInfo;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type() G_GNUC_CONST;

  IconInfo();

  explicit IconInfo(GtkIconInfo* gobject, bool make_a_copy = true);

  IconInfo(const IconInfo& other);
  IconInfo& operator=(const IconInfo& other);

  IconInfo(IconInfo&& other) noexcept;
  IconInfo& operator=(IconInfo&& other) noexcept;

  ~IconInfo() noexcept;

  void swap(IconInfo& other) noexcept;

  ///Provides access to the underlying C instance.
  GtkIconInfo*       gobj()       { return gobject_; }

  ///Provides access to the underlying C instance.
  const GtkIconInfo* gobj() const { return gobject_; }

  ///Provides access to the underlying C instance. The caller is responsible for freeing it. Use when directly setting fields in structs.
  GtkIconInfo* gobj_copy() const;

protected:
  GtkIconInfo* gobject_;

private:

public:

  IconInfo(const Glib::RefPtr<IconTheme>& icon_theme, const Glib::RefPtr<Gdk::Pixbuf>& pixbuf);
  

   /** Tests whether the IconInfo is valid.
    *
    * @newin{3,22}
    */
   explicit operator bool() const;

  
  /** Gets the base size for the icon. The base size
   * is a size for the icon that was specified by
   * the icon theme creator. This may be different
   * than the actual size of image; an example of
   * this is small emblem icons that can be attached
   * to a larger icon. These icons will be given
   * the same base size as the larger icons to which
   * they are attached.
   * 
   * Note that for scaled icons the base size does
   * not include the base scale.
   * 
   * @newin{2,4}
   * 
   * @return The base size, or 0, if no base
   * size is known for the icon.
   */
  int get_base_size() const;
  
  /** Gets the base scale for the icon. The base scale is a scale
   * for the icon that was specified by the icon theme creator.
   * For instance an icon drawn for a high-dpi screen with window
   * scale 2 for a base size of 32 will be 64 pixels tall and have
   * a base scale of 2.
   * 
   * @newin{3,10}
   * 
   * @return The base scale.
   */
  int get_base_scale() const;

  
  /** Gets the filename for the icon. If the Gtk::IconLookupFlags::USE_BUILTIN
   * flag was passed to Gtk::IconTheme::lookup_icon(), there may be no
   * filename if a builtin icon is returned; in this case, you should
   * use gtk_icon_info_get_builtin_pixbuf().
   * 
   * @newin{2,4}
   * 
   * @return The filename for the icon, or <tt>nullptr</tt>
   * if gtk_icon_info_get_builtin_pixbuf() should
   * be used instead.
   */
  Glib::ustring get_filename() const;
  
  /** Renders an icon previously looked up in an icon theme using
   * Gtk::IconTheme::lookup_icon(); the size will be based on the size
   * passed to Gtk::IconTheme::lookup_icon(). Note that the resulting
   * pixbuf may not be exactly this size; an icon theme may have icons
   * that differ slightly from their nominal sizes, and in addition GTK+
   * will avoid scaling icons that it considers sufficiently close to the
   * requested size or for which the source image would have to be scaled
   * up too far. (This maintains sharpness.). This behaviour can be changed
   * by passing the Gtk::IconLookupFlags::FORCE_SIZE flag when obtaining
   * the Gtk::IconInfo. If this flag has been specified, the pixbuf
   * returned by this function will be scaled to the exact size.
   * 
   * @newin{2,4}
   * 
   * @return The rendered icon; this may be a newly
   * created icon or a new reference to an internal icon, so you must
   * not modify the icon. Use Glib::object_unref() to release your reference
   * to the icon.
   */
  Glib::RefPtr<Gdk::Pixbuf> load_icon();

  
  /** Renders an icon previously looked up in an icon theme using
   * Gtk::IconTheme::lookup_icon(); the size will be based on the size
   * passed to Gtk::IconTheme::lookup_icon(). Note that the resulting
   * surface may not be exactly this size; an icon theme may have icons
   * that differ slightly from their nominal sizes, and in addition GTK+
   * will avoid scaling icons that it considers sufficiently close to the
   * requested size or for which the source image would have to be scaled
   * up too far. (This maintains sharpness.). This behaviour can be changed
   * by passing the Gtk::IconLookupFlags::FORCE_SIZE flag when obtaining
   * the Gtk::IconInfo. If this flag has been specified, the pixbuf
   * returned by this function will be scaled to the exact size.
   * 
   * @newin{3,10}
   * 
   * @param for_window Gdk::Window to optimize drawing for, or <tt>nullptr</tt>.
   * @return The rendered icon; this may be a newly
   * created icon or a new reference to an internal icon, so you must
   * not modify the icon. Use cairo_surface_destroy() to release your
   * reference to the icon.
   */
  ::Cairo::RefPtr< ::Cairo::Surface> load_surface(const Glib::RefPtr<Gdk::Window>& for_window);

  //TODO: Documentation
  Glib::RefPtr<Gdk::Pixbuf> load_symbolic(const Gdk::RGBA& fg, const Gdk::RGBA& success_color, const Gdk::RGBA& warning_color, const Gdk::RGBA& error_color, bool& was_symbolic);
  

  /** Asynchronously load, render and scale an icon previously looked up from the icon theme using Gtk::IconTheme::lookup_icon().
   *
   * @param slot A callback slot to call when the request is satisfied.
   * @param cancellable A Cancellable object which can be used to cancel the operation.
   *
   * @newin{3,8}
   */
  void load_icon_async(const Gio::SlotAsyncReady& slot, const Glib::RefPtr<Gio::Cancellable>& cancellable);

  /** Asynchronously load, render and scale an icon previously looked up from the icon theme using Gtk::IconTheme::lookup_icon().
   *
   * @param slot A callback slot to call when the request is satisfied.
   *
   * @newin{3,8}
   */
  void load_icon_async(const Gio::SlotAsyncReady& slot);
  

  /** Finishes an async icon load, see load_icon_async().
   * 
   * @newin{3,8}
   * 
   * @param result A Gio::AsyncResult.
   * @return The rendered icon; this may be a newly
   * created icon or a new reference to an internal icon, so you must
   * not modify the icon. Use Glib::object_unref() to release your reference
   * to the icon.
   */
  Glib::RefPtr<Gdk::Pixbuf> load_icon_finish(const Glib::RefPtr<Gio::AsyncResult>& result);


  /** Loads an icon, modifying it to match the system colors for the foreground, success, warning and error colors provided.
   * If the icon is not a symbolic one, this method will return the result from load_icon().
   * This method uses the regular foreground color and the symbolic colors with the names "success_color",
   * "warning_color" and "error_color" from the context.
   *
   * This allows loading symbolic icons that will match the system theme.
   *
   * @param context A StyleContext.
   * @param was_symbolic Whether the loaded icon was a symbolic one and whether the fg color was applied to it.
   */
  Glib::RefPtr<Gdk::Pixbuf> load_symbolic_for_context(const Glib::RefPtr<StyleContext>& context, bool& was_symbolic);
  

  /** Asynchronously load, render and scale a symbolic icon previously looked up from the icon theme using Gtk::IconTheme::lookup_icon().
   * For more details, see load_symbolic_for_context() which is the synchronous version of this call.
   *
   * @param context A StyleContext.
   * @param slot A callback slot to call when the request is satisfied.
   * @param cancellable A Cancellable object which can be used to cancel the operation.
   *
   * @newin{3,8}
   */
  void load_symbolic_for_context_async(const Glib::RefPtr<StyleContext>& context, const Gio::SlotAsyncReady& slot, const Glib::RefPtr<Gio::Cancellable>& cancellable);

  /** Asynchronously load, render and scale a symbolic icon previously looked up from the icon theme using Gtk::IconTheme::lookup_icon().
   * For more details, see load_symbolic_for_context() which is the synchronous version of this call.
   *
   * @param context A StyleContext.
   * @param slot A callback slot to call when the request is satisfied.
   *
   * @newin{3,8}
   */
  void load_symbolic_for_context_async(const Glib::RefPtr<StyleContext>& context, const Gio::SlotAsyncReady& slot);
  

  /** Finishes an async icon load, see load_symbolic_for_context_async().
   * 
   * @newin{3,8}
   * 
   * @param result A Gio::AsyncResult.
   * @param was_symbolic A <tt>bool</tt>, returns whether the
   * loaded icon was a symbolic one and whether the @a fg color was
   * applied to it.
   * @return The rendered icon; this may be a newly
   * created icon or a new reference to an internal icon, so you must
   * not modify the icon. Use Glib::object_unref() to release your reference
   * to the icon.
   */
  Glib::RefPtr<Gdk::Pixbuf> load_symbolic_for_context_finish(const Glib::RefPtr<Gio::AsyncResult>& result, bool& was_symbolic);


  //TODO: In gtk_icon_info_load_symbolic_async(), each GdkRGBA* can be NULL, but we do not want that many method overloads.
  //TODO: Documentation.
  void load_symbolic_async(const Gdk::RGBA& fg, const Gdk::RGBA& success_color, const Gdk::RGBA& warning_color, const Gdk::RGBA& error_color, const Gio::SlotAsyncReady& slot, const Glib::RefPtr<Gio::Cancellable>& cancellable);
  void load_symbolic_async(const Gdk::RGBA& fg, const Gdk::RGBA& success_color, const Gdk::RGBA& warning_color, const Gdk::RGBA& error_color, const Gio::SlotAsyncReady& slot);
  

  /** Finishes an async icon load, see load_symbolic_async().
   * 
   * @newin{3,8}
   * 
   * @param result A Gio::AsyncResult.
   * @param was_symbolic A <tt>bool</tt>, returns whether the
   * loaded icon was a symbolic one and whether the @a fg color was
   * applied to it.
   * @return The rendered icon; this may be a newly
   * created icon or a new reference to an internal icon, so you must
   * not modify the icon. Use Glib::object_unref() to release your reference
   * to the icon.
   */
  Glib::RefPtr<Gdk::Pixbuf> load_symbolic_finish(const Glib::RefPtr<Gio::AsyncResult>& result, bool& was_symbolic);

  
  /** Checks if the icon is symbolic or not. This currently uses only
   * the file name and not the file contents for determining this.
   * This behaviour may change in the future.
   * 
   * @newin{3,12}
   * 
   * @return <tt>true</tt> if the icon is symbolic, <tt>false</tt> otherwise.
   */
  bool is_symbolic() const;


};

} // namespace Gtk


namespace Gtk
{

/** @relates Gtk::IconInfo
 * @param lhs The left-hand side
 * @param rhs The right-hand side
 */
inline void swap(IconInfo& lhs, IconInfo& rhs) noexcept
  { lhs.swap(rhs); }

} // namespace Gtk

namespace Glib
{

/** A Glib::wrap() method for this object.
 *
 * @param object The C instance.
 * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
 * @result A C++ instance that wraps this C instance.
 *
 * @relates Gtk::IconInfo
 */
Gtk::IconInfo wrap(GtkIconInfo* object, bool take_copy = false);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
template <>
class Value<Gtk::IconInfo> : public Glib::Value_Boxed<Gtk::IconInfo>
{};
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

} // namespace Glib


#endif /* _GTKMM_ICONINFO_H */

