/* wikiscanner.c generated by valac, the Vala compiler
 * generated from wikiscanner.vala, do not modify */

/* wikiscanner.vala
 *
 * Copyright (C) 2008-2009 Florian Brosch, Didier Villevalois
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Didier 'Ptitjes Villevalois <ptitjes@free.fr>
 */

#include <glib.h>
#include <glib-object.h>
#include "valadoc.h"
#include <stdlib.h>
#include <string.h>

enum  {
	VALADOC_WIKI_SCANNER_DUMMY_PROPERTY,
	VALADOC_WIKI_SCANNER_LAST_PROPERTY
};
static GParamSpec* valadoc_wiki_scanner_properties[VALADOC_WIKI_SCANNER_LAST_PROPERTY];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _valadoc_parser_unref0(var) ((var == NULL) ? NULL : (var = (valadoc_parser_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

struct _ValadocWikiScannerPrivate {
	ValadocSettings* _settings;
	ValadocParser* _parser;
	gchar* _content;
	const gchar* _index;
	gboolean _stop;
	gint _last_line;
	gint _last_column;
	gint _line;
	gint _column;
	gboolean _url_escape_mode;
	gboolean _code_escape_mode;
	gunichar _last_char;
	gint _skip;
	GString* _current_string;
};


static gpointer valadoc_wiki_scanner_parent_class = NULL;
static ValadocScannerIface * valadoc_wiki_scanner_valadoc_scanner_parent_iface = NULL;

#define VALADOC_WIKI_SCANNER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALADOC_TYPE_WIKI_SCANNER, ValadocWikiScannerPrivate))
static void valadoc_wiki_scanner_real_set_parser (ValadocScanner* base, ValadocParser* parser);
static void valadoc_wiki_scanner_real_reset (ValadocWikiScanner* self);
static void valadoc_wiki_scanner_real_scan (ValadocScanner* base, const gchar* content, GError** error);
static void valadoc_wiki_scanner_real_end (ValadocScanner* base, GError** error);
static void valadoc_wiki_scanner_emit_token (ValadocWikiScanner* self, ValadocTokenType* type, GError** error);
static void valadoc_wiki_scanner_real_stop (ValadocWikiScanner* self);
static gchar* valadoc_wiki_scanner_real_get_line_content (ValadocWikiScanner* self);
static void valadoc_wiki_scanner_real_accept (ValadocWikiScanner* self, gunichar c, GError** error);
static void valadoc_wiki_scanner_append_char (ValadocWikiScanner* self, gunichar c);
static void valadoc_wiki_scanner_look_for_three (ValadocWikiScanner* self, gunichar c, ValadocTokenType* one, ValadocTokenType* two, ValadocTokenType* three, GError** error);
static void valadoc_wiki_scanner_look_for_two_or_append (ValadocWikiScanner* self, gunichar c, ValadocTokenType* type, GError** error);
static void valadoc_wiki_scanner_look_for_two (ValadocWikiScanner* self, gunichar c, ValadocTokenType* one, ValadocTokenType* two, GError** error);
static void valadoc_wiki_scanner_look_for_five (ValadocWikiScanner* self, gunichar c, ValadocTokenType* one, ValadocTokenType* two, ValadocTokenType* three, ValadocTokenType* four, ValadocTokenType* five, GError** error);
static gboolean valadoc_wiki_scanner_look_for (ValadocWikiScanner* self, const gchar* str, ValadocTokenType* type, GError** error);
static gint valadoc_wiki_scanner_real_get_line_start_column (ValadocWikiScanner* self);
static void valadoc_wiki_scanner_get_begin (ValadocWikiScanner* self, ValadocSourceLocation* result);
static void valadoc_wiki_scanner_get_end (ValadocWikiScanner* self, gint offset, ValadocSourceLocation* result);
static void valadoc_wiki_scanner_emit_current_word (ValadocWikiScanner* self, GError** error);
static void valadoc_wiki_scanner_finalize (GObject * obj);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


ValadocWikiScanner* valadoc_wiki_scanner_construct (GType object_type, ValadocSettings* settings) {
	ValadocWikiScanner * self = NULL;
	ValadocSettings* _tmp0_;
	ValadocSettings* _tmp1_;
	g_return_val_if_fail (settings != NULL, NULL);
	self = (ValadocWikiScanner*) g_object_new (object_type, NULL);
	_tmp0_ = settings;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_settings);
	self->priv->_settings = _tmp1_;
	return self;
}


ValadocWikiScanner* valadoc_wiki_scanner_new (ValadocSettings* settings) {
	return valadoc_wiki_scanner_construct (VALADOC_TYPE_WIKI_SCANNER, settings);
}


static gpointer _valadoc_parser_ref0 (gpointer self) {
	return self ? valadoc_parser_ref (self) : NULL;
}


static void valadoc_wiki_scanner_real_set_parser (ValadocScanner* base, ValadocParser* parser) {
	ValadocWikiScanner * self;
	ValadocParser* _tmp0_;
	ValadocParser* _tmp1_;
	self = (ValadocWikiScanner*) base;
	g_return_if_fail (parser != NULL);
	_tmp0_ = parser;
	_tmp1_ = _valadoc_parser_ref0 (_tmp0_);
	_valadoc_parser_unref0 (self->priv->_parser);
	self->priv->_parser = _tmp1_;
}


static void valadoc_wiki_scanner_real_reset (ValadocWikiScanner* self) {
	GString* _tmp0_;
	self->priv->_stop = FALSE;
	self->priv->_last_line = 0;
	self->priv->_last_column = 0;
	self->priv->_line = 0;
	self->priv->_column = 0;
	self->priv->_url_escape_mode = FALSE;
	self->priv->_code_escape_mode = FALSE;
	self->priv->_last_char = (gunichar) 0;
	self->priv->_skip = 0;
	_tmp0_ = self->priv->_current_string;
	g_string_erase (_tmp0_, (gssize) 0, (gssize) -1);
}


void valadoc_wiki_scanner_reset (ValadocWikiScanner* self) {
	g_return_if_fail (self != NULL);
	VALADOC_WIKI_SCANNER_GET_CLASS (self)->reset (self);
}


static gunichar string_get_char (const gchar* self, glong index) {
	gunichar result = 0U;
	glong _tmp0_;
	gunichar _tmp1_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = index;
	_tmp1_ = g_utf8_get_char (((gchar*) self) + _tmp0_);
	result = _tmp1_;
	return result;
}


static void valadoc_wiki_scanner_real_scan (ValadocScanner* base, const gchar* content, GError** error) {
	ValadocWikiScanner * self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GError * _inner_error_ = NULL;
	self = (ValadocWikiScanner*) base;
	g_return_if_fail (content != NULL);
	_tmp0_ = content;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_content);
	self->priv->_content = _tmp1_;
	{
		const gchar* _tmp2_;
		gboolean _tmp3_ = FALSE;
		_tmp2_ = self->priv->_content;
		self->priv->_index = _tmp2_;
		_tmp3_ = TRUE;
		while (TRUE) {
			gboolean _tmp6_ = FALSE;
			gboolean _tmp7_;
			gunichar c = 0U;
			const gchar* _tmp10_;
			gunichar _tmp11_;
			gunichar _tmp12_;
			if (!_tmp3_) {
				const gchar* _tmp4_;
				const gchar* _tmp5_;
				_tmp4_ = self->priv->_index;
				_tmp5_ = g_utf8_next_char (_tmp4_);
				self->priv->_index = _tmp5_;
			}
			_tmp3_ = FALSE;
			_tmp7_ = self->priv->_stop;
			if (!_tmp7_) {
				const gchar* _tmp8_;
				gunichar _tmp9_;
				_tmp8_ = self->priv->_index;
				_tmp9_ = string_get_char (_tmp8_, (glong) 0);
				_tmp6_ = _tmp9_ != ((gunichar) 0);
			} else {
				_tmp6_ = FALSE;
			}
			if (!_tmp6_) {
				break;
			}
			_tmp10_ = self->priv->_index;
			_tmp11_ = string_get_char (_tmp10_, (glong) 0);
			c = _tmp11_;
			_tmp12_ = c;
			valadoc_wiki_scanner_accept (self, _tmp12_, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == VALADOC_PARSER_ERROR) {
					g_propagate_error (error, _inner_error_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		}
	}
}


static void valadoc_wiki_scanner_real_end (ValadocScanner* base, GError** error) {
	ValadocWikiScanner * self;
	ValadocTokenType* _tmp0_;
	GError * _inner_error_ = NULL;
	self = (ValadocWikiScanner*) base;
	_tmp0_ = valadoc_token_type_EOF;
	valadoc_wiki_scanner_emit_token (self, _tmp0_, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALADOC_PARSER_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static void valadoc_wiki_scanner_real_stop (ValadocWikiScanner* self) {
	self->priv->_stop = TRUE;
}


void valadoc_wiki_scanner_stop (ValadocWikiScanner* self) {
	g_return_if_fail (self != NULL);
	VALADOC_WIKI_SCANNER_GET_CLASS (self)->stop (self);
}


void valadoc_wiki_scanner_set_url_escape_mode (ValadocWikiScanner* self, gboolean escape_mode) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = escape_mode;
	self->priv->_url_escape_mode = _tmp0_;
}


void valadoc_wiki_scanner_set_code_escape_mode (ValadocWikiScanner* self, gboolean escape_mode) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = escape_mode;
	self->priv->_code_escape_mode = _tmp0_;
}


gint valadoc_wiki_scanner_get_line (ValadocWikiScanner* self) {
	gint result = 0;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_line;
	result = _tmp0_;
	return result;
}


static gchar* valadoc_wiki_scanner_real_get_line_content (ValadocWikiScanner* self) {
	gchar* result = NULL;
	GString* builder = NULL;
	GString* _tmp0_;
	const gchar* line_start = NULL;
	const gchar* _tmp1_;
	gunichar c = 0U;
	GString* _tmp21_;
	const gchar* _tmp22_;
	gchar* _tmp23_;
	_tmp0_ = g_string_new ("");
	builder = _tmp0_;
	_tmp1_ = self->priv->_index;
	line_start = _tmp1_;
	while (TRUE) {
		gboolean _tmp2_ = FALSE;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		_tmp3_ = line_start;
		_tmp4_ = self->priv->_content;
		if (((gchar*) _tmp3_) > ((gchar*) _tmp4_)) {
			const gchar* _tmp5_;
			const gchar* _tmp6_;
			gunichar _tmp7_;
			_tmp5_ = line_start;
			_tmp6_ = g_utf8_prev_char (_tmp5_);
			_tmp7_ = string_get_char (_tmp6_, (glong) 0);
			_tmp2_ = _tmp7_ != ((gunichar) '\n');
		} else {
			_tmp2_ = FALSE;
		}
		if (!_tmp2_) {
			break;
		}
		_tmp8_ = line_start;
		_tmp9_ = g_utf8_prev_char (_tmp8_);
		line_start = _tmp9_;
	}
	while (TRUE) {
		gboolean _tmp10_ = FALSE;
		const gchar* _tmp11_;
		gunichar _tmp12_;
		gunichar _tmp13_;
		gunichar _tmp15_;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		_tmp11_ = line_start;
		_tmp12_ = string_get_char (_tmp11_, (glong) 0);
		c = _tmp12_;
		_tmp13_ = c;
		if (_tmp13_ != ((gunichar) '\n')) {
			gunichar _tmp14_;
			_tmp14_ = c;
			_tmp10_ = _tmp14_ != ((gunichar) '\0');
		} else {
			_tmp10_ = FALSE;
		}
		if (!_tmp10_) {
			break;
		}
		_tmp15_ = c;
		if (_tmp15_ == ((gunichar) '\t')) {
			GString* _tmp16_;
			_tmp16_ = builder;
			g_string_append_c (_tmp16_, ' ');
		} else {
			GString* _tmp17_;
			gunichar _tmp18_;
			_tmp17_ = builder;
			_tmp18_ = c;
			g_string_append_unichar (_tmp17_, _tmp18_);
		}
		_tmp19_ = line_start;
		_tmp20_ = g_utf8_next_char (_tmp19_);
		line_start = _tmp20_;
	}
	_tmp21_ = builder;
	_tmp22_ = _tmp21_->str;
	_tmp23_ = g_strdup (_tmp22_);
	result = _tmp23_;
	_g_string_free0 (builder);
	return result;
}


gchar* valadoc_wiki_scanner_get_line_content (ValadocWikiScanner* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return VALADOC_WIKI_SCANNER_GET_CLASS (self)->get_line_content (self);
}


static gint string_index_of_nth_char (const gchar* self, glong c) {
	gint result = 0;
	glong _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = c;
	_tmp1_ = g_utf8_offset_to_pointer (self, _tmp0_);
	result = (gint) (_tmp1_ - ((gchar*) self));
	return result;
}


gunichar valadoc_wiki_scanner_get_next_char (ValadocWikiScanner* self, gint offset) {
	gunichar result = 0U;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gunichar _tmp4_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->_index;
	_tmp1_ = self->priv->_index;
	_tmp2_ = offset;
	_tmp3_ = string_index_of_nth_char (_tmp1_, (glong) _tmp2_);
	_tmp4_ = string_get_char (_tmp0_, (glong) _tmp3_);
	result = _tmp4_;
	return result;
}


static void valadoc_wiki_scanner_real_accept (ValadocWikiScanner* self, gunichar c, GError** error) {
	gint _tmp0_;
	gint _tmp1_;
	gunichar _tmp75_;
	GError * _inner_error_ = NULL;
	_tmp0_ = self->priv->_column;
	self->priv->_column = _tmp0_ + 1;
	_tmp1_ = self->priv->_skip;
	if (_tmp1_ == 0) {
		gboolean _tmp2_;
		gunichar _tmp13_;
		_tmp2_ = self->priv->_code_escape_mode;
		if (_tmp2_) {
			gboolean _tmp3_ = FALSE;
			gboolean _tmp4_ = FALSE;
			gunichar _tmp5_;
			_tmp5_ = c;
			if (_tmp5_ == ((gunichar) '}')) {
				gunichar _tmp6_;
				_tmp6_ = valadoc_wiki_scanner_get_next_char (self, 1);
				_tmp4_ = _tmp6_ == ((gunichar) '}');
			} else {
				_tmp4_ = FALSE;
			}
			if (_tmp4_) {
				gunichar _tmp7_;
				_tmp7_ = valadoc_wiki_scanner_get_next_char (self, 2);
				_tmp3_ = _tmp7_ == ((gunichar) '}');
			} else {
				_tmp3_ = FALSE;
			}
			if (_tmp3_) {
				ValadocTokenType* _tmp8_;
				self->priv->_code_escape_mode = FALSE;
				_tmp8_ = valadoc_token_type_TRIPLE_CLOSED_BRACE;
				valadoc_wiki_scanner_emit_token (self, _tmp8_, &_inner_error_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == VALADOC_PARSER_ERROR) {
						g_propagate_error (error, _inner_error_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				self->priv->_skip = 2;
			} else {
				gunichar _tmp9_;
				_tmp9_ = c;
				valadoc_wiki_scanner_append_char (self, _tmp9_);
			}
			return;
		} else {
			gboolean _tmp10_;
			_tmp10_ = self->priv->_url_escape_mode;
			if (_tmp10_) {
				gunichar _tmp11_;
				_tmp11_ = c;
				switch (_tmp11_) {
					case ';':
					case '/':
					case '?':
					case ':':
					case '@':
					case '#':
					case '=':
					case '&':
					case '$':
					case '-':
					case '_':
					case '.':
					case '+':
					case '!':
					case '*':
					case '\'':
					case '(':
					case ')':
					case ',':
					{
						gunichar _tmp12_;
						_tmp12_ = c;
						valadoc_wiki_scanner_append_char (self, _tmp12_);
						return;
					}
					default:
					{
						break;
					}
				}
			}
		}
		_tmp13_ = c;
		switch (_tmp13_) {
			case '@':
			{
				ValadocTokenType* _tmp14_;
				_tmp14_ = valadoc_token_type_AROBASE;
				valadoc_wiki_scanner_emit_token (self, _tmp14_, &_inner_error_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == VALADOC_PARSER_ERROR) {
						g_propagate_error (error, _inner_error_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				break;
			}
			case '{':
			{
				gunichar _tmp15_;
				ValadocTokenType* _tmp16_;
				ValadocTokenType* _tmp17_;
				ValadocTokenType* _tmp18_;
				_tmp15_ = c;
				_tmp16_ = valadoc_token_type_OPEN_BRACE;
				_tmp17_ = valadoc_token_type_DOUBLE_OPEN_BRACE;
				_tmp18_ = valadoc_token_type_TRIPLE_OPEN_BRACE;
				valadoc_wiki_scanner_look_for_three (self, _tmp15_, _tmp16_, _tmp17_, _tmp18_, &_inner_error_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == VALADOC_PARSER_ERROR) {
						g_propagate_error (error, _inner_error_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				break;
			}
			case '}':
			{
				gunichar _tmp19_;
				ValadocTokenType* _tmp20_;
				ValadocTokenType* _tmp21_;
				ValadocTokenType* _tmp22_;
				_tmp19_ = c;
				_tmp20_ = valadoc_token_type_CLOSED_BRACE;
				_tmp21_ = valadoc_token_type_DOUBLE_CLOSED_BRACE;
				_tmp22_ = valadoc_token_type_TRIPLE_CLOSED_BRACE;
				valadoc_wiki_scanner_look_for_three (self, _tmp19_, _tmp20_, _tmp21_, _tmp22_, &_inner_error_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == VALADOC_PARSER_ERROR) {
						g_propagate_error (error, _inner_error_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				break;
			}
			case '[':
			{
				gunichar _tmp23_;
				ValadocTokenType* _tmp24_;
				_tmp23_ = c;
				_tmp24_ = valadoc_token_type_DOUBLE_OPEN_BRACKET;
				valadoc_wiki_scanner_look_for_two_or_append (self, _tmp23_, _tmp24_, &_inner_error_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == VALADOC_PARSER_ERROR) {
						g_propagate_error (error, _inner_error_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				break;
			}
			case ']':
			{
				gunichar _tmp25_;
				ValadocTokenType* _tmp26_;
				_tmp25_ = c;
				_tmp26_ = valadoc_token_type_DOUBLE_CLOSED_BRACKET;
				valadoc_wiki_scanner_look_for_two_or_append (self, _tmp25_, _tmp26_, &_inner_error_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == VALADOC_PARSER_ERROR) {
						g_propagate_error (error, _inner_error_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				break;
			}
			case '|':
			{
				gunichar _tmp27_;
				ValadocTokenType* _tmp28_;
				ValadocTokenType* _tmp29_;
				_tmp27_ = c;
				_tmp28_ = valadoc_token_type_PIPE;
				_tmp29_ = valadoc_token_type_DOUBLE_PIPE;
				valadoc_wiki_scanner_look_for_two (self, _tmp27_, _tmp28_, _tmp29_, &_inner_error_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == VALADOC_PARSER_ERROR) {
						g_propagate_error (error, _inner_error_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				break;
			}
			case ')':
			{
				gunichar _tmp30_;
				_tmp30_ = valadoc_wiki_scanner_get_next_char (self, 1);
				if (_tmp30_ == ((gunichar) ')')) {
					ValadocTokenType* _tmp31_;
					_tmp31_ = valadoc_token_type_ALIGN_RIGHT;
					valadoc_wiki_scanner_emit_token (self, _tmp31_, &_inner_error_);
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						if (_inner_error_->domain == VALADOC_PARSER_ERROR) {
							g_propagate_error (error, _inner_error_);
							return;
						} else {
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
					}
					self->priv->_skip = 1;
				} else {
					gunichar _tmp32_;
					_tmp32_ = valadoc_wiki_scanner_get_next_char (self, 1);
					if (_tmp32_ == ((gunichar) '(')) {
						ValadocTokenType* _tmp33_;
						_tmp33_ = valadoc_token_type_ALIGN_CENTER;
						valadoc_wiki_scanner_emit_token (self, _tmp33_, &_inner_error_);
						if (G_UNLIKELY (_inner_error_ != NULL)) {
							if (_inner_error_->domain == VALADOC_PARSER_ERROR) {
								g_propagate_error (error, _inner_error_);
								return;
							} else {
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return;
							}
						}
						self->priv->_skip = 1;
					} else {
						gunichar _tmp34_;
						_tmp34_ = c;
						valadoc_wiki_scanner_append_char (self, _tmp34_);
					}
				}
				break;
			}
			case '-':
			{
				ValadocTokenType* _tmp35_;
				_tmp35_ = valadoc_token_type_MINUS;
				valadoc_wiki_scanner_emit_token (self, _tmp35_, &_inner_error_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == VALADOC_PARSER_ERROR) {
						g_propagate_error (error, _inner_error_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				break;
			}
			case '=':
			{
				gunichar _tmp36_;
				ValadocTokenType* _tmp37_;
				ValadocTokenType* _tmp38_;
				ValadocTokenType* _tmp39_;
				ValadocTokenType* _tmp40_;
				ValadocTokenType* _tmp41_;
				_tmp36_ = c;
				_tmp37_ = valadoc_token_type_EQUAL_1;
				_tmp38_ = valadoc_token_type_EQUAL_2;
				_tmp39_ = valadoc_token_type_EQUAL_3;
				_tmp40_ = valadoc_token_type_EQUAL_4;
				_tmp41_ = valadoc_token_type_EQUAL_5;
				valadoc_wiki_scanner_look_for_five (self, _tmp36_, _tmp37_, _tmp38_, _tmp39_, _tmp40_, _tmp41_, &_inner_error_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == VALADOC_PARSER_ERROR) {
						g_propagate_error (error, _inner_error_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				break;
			}
			case '<':
			{
				gboolean _tmp42_ = FALSE;
				ValadocTokenType* _tmp43_;
				gboolean _tmp44_;
				_tmp43_ = valadoc_token_type_BREAK;
				_tmp44_ = valadoc_wiki_scanner_look_for (self, "<<BR>>", _tmp43_, &_inner_error_);
				_tmp42_ = _tmp44_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == VALADOC_PARSER_ERROR) {
						g_propagate_error (error, _inner_error_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				if (!_tmp42_) {
					ValadocTokenType* _tmp45_;
					_tmp45_ = valadoc_token_type_LESS_THAN;
					valadoc_wiki_scanner_emit_token (self, _tmp45_, &_inner_error_);
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						if (_inner_error_->domain == VALADOC_PARSER_ERROR) {
							g_propagate_error (error, _inner_error_);
							return;
						} else {
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
					}
				}
				break;
			}
			case '>':
			{
				ValadocTokenType* _tmp46_;
				_tmp46_ = valadoc_token_type_GREATER_THAN;
				valadoc_wiki_scanner_emit_token (self, _tmp46_, &_inner_error_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == VALADOC_PARSER_ERROR) {
						g_propagate_error (error, _inner_error_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				break;
			}
			case '^':
			{
				ValadocTokenType* _tmp47_;
				_tmp47_ = valadoc_token_type_ALIGN_TOP;
				valadoc_wiki_scanner_emit_token (self, _tmp47_, &_inner_error_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == VALADOC_PARSER_ERROR) {
						g_propagate_error (error, _inner_error_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				break;
			}
			case 'v':
			{
				gunichar next_char = 0U;
				gunichar _tmp48_;
				gboolean _tmp49_ = FALSE;
				gboolean _tmp50_ = FALSE;
				gboolean _tmp51_ = FALSE;
				gunichar _tmp52_;
				gboolean _tmp53_;
				_tmp48_ = valadoc_wiki_scanner_get_next_char (self, 1);
				next_char = _tmp48_;
				_tmp52_ = self->priv->_last_char;
				_tmp53_ = g_unichar_isalnum (_tmp52_);
				if (_tmp53_) {
					_tmp51_ = TRUE;
				} else {
					gunichar _tmp54_;
					_tmp54_ = self->priv->_last_char;
					_tmp51_ = _tmp54_ == ((gunichar) ' ');
				}
				if (_tmp51_) {
					_tmp50_ = TRUE;
				} else {
					gunichar _tmp55_;
					gboolean _tmp56_;
					_tmp55_ = next_char;
					_tmp56_ = g_unichar_isalnum (_tmp55_);
					_tmp50_ = _tmp56_;
				}
				if (_tmp50_) {
					_tmp49_ = TRUE;
				} else {
					gunichar _tmp57_;
					_tmp57_ = next_char;
					_tmp49_ = _tmp57_ == ((gunichar) ' ');
				}
				if (_tmp49_) {
					gunichar _tmp58_;
					_tmp58_ = c;
					valadoc_wiki_scanner_append_char (self, _tmp58_);
				} else {
					ValadocTokenType* _tmp59_;
					_tmp59_ = valadoc_token_type_ALIGN_BOTTOM;
					valadoc_wiki_scanner_emit_token (self, _tmp59_, &_inner_error_);
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						if (_inner_error_->domain == VALADOC_PARSER_ERROR) {
							g_propagate_error (error, _inner_error_);
							return;
						} else {
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
					}
				}
				break;
			}
			case '\'':
			{
				gunichar _tmp60_;
				ValadocTokenType* _tmp61_;
				_tmp60_ = c;
				_tmp61_ = valadoc_token_type_SINGLE_QUOTE_2;
				valadoc_wiki_scanner_look_for_two_or_append (self, _tmp60_, _tmp61_, &_inner_error_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == VALADOC_PARSER_ERROR) {
						g_propagate_error (error, _inner_error_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				break;
			}
			case '/':
			{
				gunichar _tmp62_;
				ValadocTokenType* _tmp63_;
				_tmp62_ = c;
				_tmp63_ = valadoc_token_type_SLASH_2;
				valadoc_wiki_scanner_look_for_two_or_append (self, _tmp62_, _tmp63_, &_inner_error_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == VALADOC_PARSER_ERROR) {
						g_propagate_error (error, _inner_error_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				break;
			}
			case '_':
			{
				gunichar _tmp64_;
				ValadocTokenType* _tmp65_;
				_tmp64_ = c;
				_tmp65_ = valadoc_token_type_UNDERSCORE_2;
				valadoc_wiki_scanner_look_for_two_or_append (self, _tmp64_, _tmp65_, &_inner_error_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == VALADOC_PARSER_ERROR) {
						g_propagate_error (error, _inner_error_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				break;
			}
			case '`':
			{
				gunichar _tmp66_;
				_tmp66_ = valadoc_wiki_scanner_get_next_char (self, 1);
				if (_tmp66_ == ((gunichar) '`')) {
					ValadocTokenType* _tmp67_;
					_tmp67_ = valadoc_token_type_BACK_QUOTE_2;
					valadoc_wiki_scanner_emit_token (self, _tmp67_, &_inner_error_);
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						if (_inner_error_->domain == VALADOC_PARSER_ERROR) {
							g_propagate_error (error, _inner_error_);
							return;
						} else {
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
					}
					self->priv->_skip = 1;
				} else {
					gunichar _tmp68_;
					_tmp68_ = c;
					valadoc_wiki_scanner_append_char (self, _tmp68_);
				}
				break;
			}
			case '\t':
			{
				ValadocTokenType* _tmp69_;
				_tmp69_ = valadoc_token_type_TAB;
				valadoc_wiki_scanner_emit_token (self, _tmp69_, &_inner_error_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == VALADOC_PARSER_ERROR) {
						g_propagate_error (error, _inner_error_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				break;
			}
			case ' ':
			{
				ValadocTokenType* _tmp70_;
				_tmp70_ = valadoc_token_type_SPACE;
				valadoc_wiki_scanner_emit_token (self, _tmp70_, &_inner_error_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == VALADOC_PARSER_ERROR) {
						g_propagate_error (error, _inner_error_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				break;
			}
			case '\r':
			{
				break;
			}
			case '\n':
			{
				ValadocTokenType* _tmp71_;
				gint _tmp72_;
				_tmp71_ = valadoc_token_type_EOL;
				valadoc_wiki_scanner_emit_token (self, _tmp71_, &_inner_error_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == VALADOC_PARSER_ERROR) {
						g_propagate_error (error, _inner_error_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				_tmp72_ = self->priv->_line;
				self->priv->_line = _tmp72_ + 1;
				self->priv->_column = 0;
				self->priv->_last_column = 0;
				break;
			}
			default:
			{
				gunichar _tmp73_;
				_tmp73_ = c;
				valadoc_wiki_scanner_append_char (self, _tmp73_);
				break;
			}
		}
	} else {
		gint _tmp74_;
		_tmp74_ = self->priv->_skip;
		self->priv->_skip = _tmp74_ - 1;
	}
	_tmp75_ = c;
	self->priv->_last_char = _tmp75_;
}


void valadoc_wiki_scanner_accept (ValadocWikiScanner* self, gunichar c, GError** error) {
	g_return_if_fail (self != NULL);
	VALADOC_WIKI_SCANNER_GET_CLASS (self)->accept (self, c, error);
}


static void valadoc_wiki_scanner_append_char (ValadocWikiScanner* self, gunichar c) {
	GString* _tmp0_;
	gunichar _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_current_string;
	_tmp1_ = c;
	g_string_append_unichar (_tmp0_, _tmp1_);
}


static gint valadoc_wiki_scanner_real_get_line_start_column (ValadocWikiScanner* self) {
	gint result = 0;
	result = 0;
	return result;
}


gint valadoc_wiki_scanner_get_line_start_column (ValadocWikiScanner* self) {
	g_return_val_if_fail (self != NULL, 0);
	return VALADOC_WIKI_SCANNER_GET_CLASS (self)->get_line_start_column (self);
}


static void valadoc_wiki_scanner_get_begin (ValadocWikiScanner* self, ValadocSourceLocation* result) {
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	ValadocSourceLocation _tmp3_ = {0};
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_last_line;
	_tmp1_ = valadoc_wiki_scanner_get_line_start_column (self);
	_tmp2_ = self->priv->_last_column;
	valadoc_source_location_init (&_tmp3_, _tmp0_, _tmp1_ + _tmp2_);
	*result = _tmp3_;
	return;
}


static void valadoc_wiki_scanner_get_end (ValadocWikiScanner* self, gint offset, ValadocSourceLocation* result) {
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	ValadocSourceLocation _tmp4_ = {0};
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_line;
	_tmp1_ = valadoc_wiki_scanner_get_line_start_column (self);
	_tmp2_ = self->priv->_column;
	_tmp3_ = offset;
	valadoc_source_location_init (&_tmp4_, _tmp0_, (_tmp1_ + _tmp2_) + _tmp3_);
	*result = _tmp4_;
	return;
}


static void valadoc_wiki_scanner_emit_current_word (ValadocWikiScanner* self, GError** error) {
	GString* _tmp0_;
	gssize _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_current_string;
	_tmp1_ = _tmp0_->len;
	if (_tmp1_ > ((gssize) 0)) {
		ValadocParser* _tmp2_;
		GString* _tmp3_;
		const gchar* _tmp4_;
		ValadocSourceLocation _tmp5_ = {0};
		ValadocSourceLocation _tmp6_ = {0};
		ValadocToken* _tmp7_;
		ValadocToken* _tmp8_;
		GString* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		_tmp2_ = self->priv->_parser;
		_tmp3_ = self->priv->_current_string;
		_tmp4_ = _tmp3_->str;
		valadoc_wiki_scanner_get_begin (self, &_tmp5_);
		valadoc_wiki_scanner_get_end (self, -1, &_tmp6_);
		_tmp7_ = valadoc_token_new_from_word (_tmp4_, &_tmp5_, &_tmp6_);
		_tmp8_ = _tmp7_;
		valadoc_parser_accept_token (_tmp2_, _tmp8_, &_inner_error_);
		_g_object_unref0 (_tmp8_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == VALADOC_PARSER_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_tmp9_ = self->priv->_current_string;
		g_string_erase (_tmp9_, (gssize) 0, (gssize) -1);
		_tmp10_ = self->priv->_line;
		self->priv->_last_line = _tmp10_;
		_tmp11_ = self->priv->_column;
		self->priv->_last_column = _tmp11_ - 1;
	}
}


static void valadoc_wiki_scanner_emit_token (ValadocWikiScanner* self, ValadocTokenType* type, GError** error) {
	ValadocParser* _tmp0_;
	ValadocTokenType* _tmp1_;
	ValadocSourceLocation _tmp2_ = {0};
	gint _tmp3_;
	ValadocSourceLocation _tmp4_ = {0};
	ValadocToken* _tmp5_;
	ValadocToken* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	valadoc_wiki_scanner_emit_current_word (self, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALADOC_PARSER_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp0_ = self->priv->_parser;
	_tmp1_ = type;
	valadoc_wiki_scanner_get_begin (self, &_tmp2_);
	_tmp3_ = self->priv->_skip;
	valadoc_wiki_scanner_get_end (self, _tmp3_, &_tmp4_);
	_tmp5_ = valadoc_token_new_from_type (_tmp1_, &_tmp2_, &_tmp4_, NULL);
	_tmp6_ = _tmp5_;
	valadoc_parser_accept_token (_tmp0_, _tmp6_, &_inner_error_);
	_g_object_unref0 (_tmp6_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALADOC_PARSER_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp7_ = self->priv->_line;
	self->priv->_last_line = _tmp7_;
	_tmp8_ = self->priv->_column;
	self->priv->_last_column = _tmp8_;
}


static void valadoc_wiki_scanner_look_for_two_or_append (ValadocWikiScanner* self, gunichar c, ValadocTokenType* type, GError** error) {
	gunichar _tmp0_;
	gunichar _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	_tmp0_ = valadoc_wiki_scanner_get_next_char (self, 1);
	_tmp1_ = c;
	if (_tmp0_ == _tmp1_) {
		ValadocTokenType* _tmp2_;
		_tmp2_ = type;
		valadoc_wiki_scanner_emit_token (self, _tmp2_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == VALADOC_PARSER_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		self->priv->_skip = 1;
	} else {
		gunichar _tmp3_;
		_tmp3_ = c;
		valadoc_wiki_scanner_append_char (self, _tmp3_);
	}
}


static void valadoc_wiki_scanner_look_for_two (ValadocWikiScanner* self, gunichar c, ValadocTokenType* one, ValadocTokenType* two, GError** error) {
	gunichar _tmp0_;
	gunichar _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (one != NULL);
	g_return_if_fail (two != NULL);
	_tmp0_ = valadoc_wiki_scanner_get_next_char (self, 1);
	_tmp1_ = c;
	if (_tmp0_ == _tmp1_) {
		ValadocTokenType* _tmp2_;
		_tmp2_ = two;
		valadoc_wiki_scanner_emit_token (self, _tmp2_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == VALADOC_PARSER_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		self->priv->_skip = 1;
	} else {
		ValadocTokenType* _tmp3_;
		_tmp3_ = one;
		valadoc_wiki_scanner_emit_token (self, _tmp3_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == VALADOC_PARSER_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
}


static void valadoc_wiki_scanner_look_for_three (ValadocWikiScanner* self, gunichar c, ValadocTokenType* one, ValadocTokenType* two, ValadocTokenType* three, GError** error) {
	gunichar _tmp0_;
	gunichar _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (one != NULL);
	g_return_if_fail (two != NULL);
	g_return_if_fail (three != NULL);
	_tmp0_ = valadoc_wiki_scanner_get_next_char (self, 1);
	_tmp1_ = c;
	if (_tmp0_ == _tmp1_) {
		gunichar _tmp2_;
		gunichar _tmp3_;
		_tmp2_ = valadoc_wiki_scanner_get_next_char (self, 2);
		_tmp3_ = c;
		if (_tmp2_ == _tmp3_) {
			ValadocTokenType* _tmp4_;
			_tmp4_ = three;
			valadoc_wiki_scanner_emit_token (self, _tmp4_, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == VALADOC_PARSER_ERROR) {
					g_propagate_error (error, _inner_error_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			self->priv->_skip = 2;
		} else {
			ValadocTokenType* _tmp5_;
			_tmp5_ = two;
			valadoc_wiki_scanner_emit_token (self, _tmp5_, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == VALADOC_PARSER_ERROR) {
					g_propagate_error (error, _inner_error_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			self->priv->_skip = 1;
		}
	} else {
		ValadocTokenType* _tmp6_;
		_tmp6_ = one;
		valadoc_wiki_scanner_emit_token (self, _tmp6_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == VALADOC_PARSER_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
}


static void valadoc_wiki_scanner_look_for_five (ValadocWikiScanner* self, gunichar c, ValadocTokenType* one, ValadocTokenType* two, ValadocTokenType* three, ValadocTokenType* four, ValadocTokenType* five, GError** error) {
	gunichar _tmp0_;
	gunichar _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (one != NULL);
	g_return_if_fail (two != NULL);
	g_return_if_fail (three != NULL);
	g_return_if_fail (four != NULL);
	g_return_if_fail (five != NULL);
	_tmp0_ = valadoc_wiki_scanner_get_next_char (self, 1);
	_tmp1_ = c;
	if (_tmp0_ == _tmp1_) {
		gunichar _tmp2_;
		gunichar _tmp3_;
		_tmp2_ = valadoc_wiki_scanner_get_next_char (self, 2);
		_tmp3_ = c;
		if (_tmp2_ == _tmp3_) {
			gunichar _tmp4_;
			gunichar _tmp5_;
			_tmp4_ = valadoc_wiki_scanner_get_next_char (self, 3);
			_tmp5_ = c;
			if (_tmp4_ == _tmp5_) {
				gunichar _tmp6_;
				gunichar _tmp7_;
				_tmp6_ = valadoc_wiki_scanner_get_next_char (self, 4);
				_tmp7_ = c;
				if (_tmp6_ == _tmp7_) {
					ValadocTokenType* _tmp8_;
					_tmp8_ = five;
					valadoc_wiki_scanner_emit_token (self, _tmp8_, &_inner_error_);
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						if (_inner_error_->domain == VALADOC_PARSER_ERROR) {
							g_propagate_error (error, _inner_error_);
							return;
						} else {
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
					}
					self->priv->_skip = 4;
				} else {
					ValadocTokenType* _tmp9_;
					_tmp9_ = four;
					valadoc_wiki_scanner_emit_token (self, _tmp9_, &_inner_error_);
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						if (_inner_error_->domain == VALADOC_PARSER_ERROR) {
							g_propagate_error (error, _inner_error_);
							return;
						} else {
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
					}
					self->priv->_skip = 3;
				}
			} else {
				ValadocTokenType* _tmp10_;
				_tmp10_ = three;
				valadoc_wiki_scanner_emit_token (self, _tmp10_, &_inner_error_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == VALADOC_PARSER_ERROR) {
						g_propagate_error (error, _inner_error_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				self->priv->_skip = 2;
			}
		} else {
			ValadocTokenType* _tmp11_;
			_tmp11_ = two;
			valadoc_wiki_scanner_emit_token (self, _tmp11_, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == VALADOC_PARSER_ERROR) {
					g_propagate_error (error, _inner_error_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			self->priv->_skip = 1;
		}
	} else {
		ValadocTokenType* _tmp12_;
		_tmp12_ = one;
		valadoc_wiki_scanner_emit_token (self, _tmp12_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == VALADOC_PARSER_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_;
	gchar _tmp1_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static gboolean valadoc_wiki_scanner_look_for (ValadocWikiScanner* self, const gchar* str, ValadocTokenType* type, GError** error) {
	gboolean result = FALSE;
	ValadocTokenType* _tmp11_;
	const gchar* _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (str != NULL, FALSE);
	g_return_val_if_fail (type != NULL, FALSE);
	{
		gint i = 0;
		i = 1;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				const gchar* _tmp3_;
				gint _tmp4_;
				gint _tmp5_;
				gint _tmp6_;
				gunichar _tmp7_;
				const gchar* _tmp8_;
				gint _tmp9_;
				gchar _tmp10_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = str;
				_tmp4_ = strlen (_tmp3_);
				_tmp5_ = _tmp4_;
				if (!(_tmp2_ < _tmp5_)) {
					break;
				}
				_tmp6_ = i;
				_tmp7_ = valadoc_wiki_scanner_get_next_char (self, _tmp6_);
				_tmp8_ = str;
				_tmp9_ = i;
				_tmp10_ = string_get (_tmp8_, (glong) _tmp9_);
				if (_tmp7_ != ((gunichar) _tmp10_)) {
					result = FALSE;
					return result;
				}
			}
		}
	}
	_tmp11_ = type;
	valadoc_wiki_scanner_emit_token (self, _tmp11_, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALADOC_PARSER_ERROR) {
			gboolean _tmp12_ = FALSE;
			g_propagate_error (error, _inner_error_);
			return _tmp12_;
		} else {
			gboolean _tmp13_ = FALSE;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp13_;
		}
	}
	_tmp14_ = str;
	_tmp15_ = strlen (_tmp14_);
	_tmp16_ = _tmp15_;
	self->priv->_skip = (gint) (_tmp16_ - 1);
	result = TRUE;
	return result;
}


static void valadoc_wiki_scanner_class_init (ValadocWikiScannerClass * klass) {
	valadoc_wiki_scanner_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValadocWikiScannerPrivate));
	((ValadocWikiScannerClass *) klass)->reset = (void (*) (ValadocWikiScanner *)) valadoc_wiki_scanner_real_reset;
	((ValadocWikiScannerClass *) klass)->stop = (void (*) (ValadocWikiScanner *)) valadoc_wiki_scanner_real_stop;
	((ValadocWikiScannerClass *) klass)->get_line_content = (gchar* (*) (ValadocWikiScanner *)) valadoc_wiki_scanner_real_get_line_content;
	((ValadocWikiScannerClass *) klass)->accept = (void (*) (ValadocWikiScanner *, gunichar, GError**)) valadoc_wiki_scanner_real_accept;
	((ValadocWikiScannerClass *) klass)->get_line_start_column = (gint (*) (ValadocWikiScanner *)) valadoc_wiki_scanner_real_get_line_start_column;
	G_OBJECT_CLASS (klass)->finalize = valadoc_wiki_scanner_finalize;
}


static void valadoc_wiki_scanner_valadoc_scanner_interface_init (ValadocScannerIface * iface) {
	valadoc_wiki_scanner_valadoc_scanner_parent_iface = g_type_interface_peek_parent (iface);
	iface->set_parser = (void (*) (ValadocScanner *, ValadocParser*)) valadoc_wiki_scanner_real_set_parser;
	iface->reset = (void (*) (ValadocScanner *)) valadoc_wiki_scanner_reset;
	iface->scan = (void (*) (ValadocScanner *, const gchar*, GError**)) valadoc_wiki_scanner_real_scan;
	iface->end = (void (*) (ValadocScanner *, GError**)) valadoc_wiki_scanner_real_end;
	iface->stop = (void (*) (ValadocScanner *)) valadoc_wiki_scanner_stop;
	iface->get_line_content = (gchar* (*) (ValadocScanner *)) valadoc_wiki_scanner_get_line_content;
}


static void valadoc_wiki_scanner_instance_init (ValadocWikiScanner * self) {
	GString* _tmp0_;
	self->priv = VALADOC_WIKI_SCANNER_GET_PRIVATE (self);
	_tmp0_ = g_string_new ("");
	self->priv->_current_string = _tmp0_;
}


static void valadoc_wiki_scanner_finalize (GObject * obj) {
	ValadocWikiScanner * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALADOC_TYPE_WIKI_SCANNER, ValadocWikiScanner);
	_g_object_unref0 (self->priv->_settings);
	_valadoc_parser_unref0 (self->priv->_parser);
	_g_free0 (self->priv->_content);
	_g_string_free0 (self->priv->_current_string);
	G_OBJECT_CLASS (valadoc_wiki_scanner_parent_class)->finalize (obj);
}


GType valadoc_wiki_scanner_get_type (void) {
	static volatile gsize valadoc_wiki_scanner_type_id__volatile = 0;
	if (g_once_init_enter (&valadoc_wiki_scanner_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValadocWikiScannerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) valadoc_wiki_scanner_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValadocWikiScanner), 0, (GInstanceInitFunc) valadoc_wiki_scanner_instance_init, NULL };
		static const GInterfaceInfo valadoc_scanner_info = { (GInterfaceInitFunc) valadoc_wiki_scanner_valadoc_scanner_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType valadoc_wiki_scanner_type_id;
		valadoc_wiki_scanner_type_id = g_type_register_static (G_TYPE_OBJECT, "ValadocWikiScanner", &g_define_type_info, 0);
		g_type_add_interface_static (valadoc_wiki_scanner_type_id, VALADOC_TYPE_SCANNER, &valadoc_scanner_info);
		g_once_init_leave (&valadoc_wiki_scanner_type_id__volatile, valadoc_wiki_scanner_type_id);
	}
	return valadoc_wiki_scanner_type_id__volatile;
}



