/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*-
 *
 * Copyright (C) 2012-2013 Richard Hughes <richard@hughsie.com>
 * Copyright (C) 2013 Matthias Clasen <mclasen@redhat.com>
 *
 * Licensed under the GNU General Public License Version 2
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#include "config.h"

#include <glib/gi18n.h>
#include <gio/gio.h>
#include <gio/gdesktopappinfo.h>
#include <gtk/gtk.h>
#include <locale.h>

#include "gs-application.h"
#include "gs-debug.h"

int
main (int argc, char **argv)
{
	int status = 0;
	g_autoptr(GDesktopAppInfo) appinfo = NULL;
	g_autoptr(GsApplication) application = NULL;
	g_autoptr(GsDebug) debug = gs_debug_new ();
	g_autoptr(AsProfile) profile = NULL;
	g_autoptr(AsProfileTask) ptask = NULL;

	setlocale (LC_ALL, "");

	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);

	profile = as_profile_new ();
	as_profile_set_duration_min (profile, 1);
	ptask = as_profile_start_literal (profile, "GsMain");
	g_assert (ptask != NULL);

	/* redirect logs */
	application = gs_application_new ();
	appinfo = g_desktop_app_info_new ("org.gnome.Software.desktop");
	g_set_application_name (g_app_info_get_name (G_APP_INFO (appinfo)));
	status = g_application_run (G_APPLICATION (application), argc, argv);
	return status;
}

/* vim: set noexpandtab: */
