// Generated by gmmproc 2.55.1 -- DO NOT MODIFY!
#ifndef _ATKMM_RANGE_H
#define _ATKMM_RANGE_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/*
 * Copyright (C) 2015 The atkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glibmm/value.h>
#include <atk/atk.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
extern "C" { typedef struct _AtkRange AtkRange; }
#endif

namespace Atk
{

/** A given range or subrange, to be used with Atk::Value.
 * This represents the full range of a given component (for example a slider or a range control),
 * or, to define each individual subrange, this full range is split if available.
 *
 * @newin{2,24}
 */
class Range
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = Range;
  using BaseObjectType = AtkRange;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type() G_GNUC_CONST;

  Range();

  explicit Range(AtkRange* gobject, bool make_a_copy = true);

  Range(const Range& other);
  Range& operator=(const Range& other);

  Range(Range&& other) noexcept;
  Range& operator=(Range&& other) noexcept;

  ~Range() noexcept;

  void swap(Range& other) noexcept;

  ///Provides access to the underlying C instance.
  AtkRange*       gobj()       { return gobject_; }

  ///Provides access to the underlying C instance.
  const AtkRange* gobj() const { return gobject_; }

  ///Provides access to the underlying C instance. The caller is responsible for freeing it. Use when directly setting fields in structs.
  AtkRange* gobj_copy() const;

protected:
  AtkRange* gobject_;

private:

  
public:
 
  Range(double lower_limit, double upper_limit, const Glib::ustring& description);
  

  /** Returns the lower limit of @a range
   * 
   * @newin{2,12}
   * 
   * @return The lower limit of @a range.
   */
  double get_lower_limit() const;
  
  /** Returns the upper limit of @a range
   * 
   * @newin{2,12}
   * 
   * @return The upper limit of @a range.
   */
  double get_upper_limit() const;
  
  /** Returns the human readable description of @a range
   * 
   * @newin{2,12}
   * 
   * @return The human-readable description of @a range.
   */
  Glib::ustring _get_description() const;


};

} // namespace Atk


namespace Atk
{

/** @relates Atk::Range
 * @param lhs The left-hand side
 * @param rhs The right-hand side
 */
inline void swap(Range& lhs, Range& rhs) noexcept
  { lhs.swap(rhs); }

} // namespace Atk

namespace Glib
{

/** A Glib::wrap() method for this object.
 *
 * @param object The C instance.
 * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
 * @result A C++ instance that wraps this C instance.
 *
 * @relates Atk::Range
 */
Atk::Range wrap(AtkRange* object, bool take_copy = false);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
template <>
class Value<Atk::Range> : public Glib::Value_Boxed<Atk::Range>
{};
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

} // namespace Glib


#endif /* _ATKMM_RANGE_H */

