/* xmlscanner.c generated by valac, the Vala compiler
 * generated from xmlscanner.vala, do not modify */

/* xmlscanner.vala
 *
 * Copyright (C) 2015       Florian Brosch
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Florian Brosch <flo.brosch@gmail.com>
 */

#include <glib.h>
#include <glib-object.h>
#include "valadoc.h"
#include <stdlib.h>
#include <string.h>

enum  {
	VALADOC_HIGHLIGHTER_XML_SCANNER_DUMMY_PROPERTY,
	VALADOC_HIGHLIGHTER_XML_SCANNER_LAST_PROPERTY
};
static GParamSpec* valadoc_highlighter_xml_scanner_properties[VALADOC_HIGHLIGHTER_XML_SCANNER_LAST_PROPERTY];
#define __g_queue_free__valadoc_highlighter_code_token_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_queue_free__valadoc_highlighter_code_token_unref0_ (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ValadocHighlighterXmlScannerPrivate {
	GQueue* token_queue;
	const gchar* content;
	const gchar* pos;
};


static gpointer valadoc_highlighter_xml_scanner_parent_class = NULL;
static ValadocHighlighterScannerIface * valadoc_highlighter_xml_scanner_valadoc_highlighter_scanner_parent_iface = NULL;

#define VALADOC_HIGHLIGHTER_XML_SCANNER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALADOC_HIGHLIGHTER_TYPE_XML_SCANNER, ValadocHighlighterXmlScannerPrivate))
static void _valadoc_highlighter_code_token_unref0_ (gpointer var);
static inline void _g_queue_free__valadoc_highlighter_code_token_unref0_ (GQueue* self);
static ValadocHighlighterCodeToken* valadoc_highlighter_xml_scanner_real_next (ValadocHighlighterScanner* base);
static gboolean valadoc_highlighter_xml_scanner_queue_escape (ValadocHighlighterXmlScanner* self);
static ValadocHighlighterCodeToken* valadoc_highlighter_xml_scanner_dispatch (ValadocHighlighterXmlScanner* self, const gchar* start, const gchar* end);
static gboolean valadoc_highlighter_xml_scanner_queue_end_element (ValadocHighlighterXmlScanner* self);
static gboolean valadoc_highlighter_xml_scanner_queue_comment (ValadocHighlighterXmlScanner* self);
static gboolean valadoc_highlighter_xml_scanner_queue_start_element (ValadocHighlighterXmlScanner* self, const gchar* dispatch_start, gboolean xml_decl);
static gboolean valadoc_highlighter_xml_scanner_skip_optional_spaces (const gchar* * pos);
static gboolean valadoc_highlighter_xml_scanner_skip_id (const gchar* * pos);
static void valadoc_highlighter_xml_scanner_queue_token (ValadocHighlighterXmlScanner* self, const gchar* start, const gchar* end, ValadocHighlighterCodeTokenType token_type);
static gboolean valadoc_highlighter_xml_scanner_queue_attributes (ValadocHighlighterXmlScanner* self);
static inline gboolean valadoc_highlighter_xml_scanner_is_id_char (gchar c);
G_GNUC_INTERNAL gboolean valadoc_highlighter_xml_scanner_is_xml (const gchar* source);
static void valadoc_highlighter_xml_scanner_finalize (GObject * obj);


static void _valadoc_highlighter_code_token_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (valadoc_highlighter_code_token_unref (var), NULL));
}


static inline void _g_queue_free__valadoc_highlighter_code_token_unref0_ (GQueue* self) {
	g_queue_free_full (self, (GDestroyNotify) _valadoc_highlighter_code_token_unref0_);
}


ValadocHighlighterXmlScanner* valadoc_highlighter_xml_scanner_construct (GType object_type, const gchar* content) {
	ValadocHighlighterXmlScanner * self = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_val_if_fail (content != NULL, NULL);
	self = (ValadocHighlighterXmlScanner*) g_object_new (object_type, NULL);
	_tmp0_ = content;
	self->priv->content = _tmp0_;
	_tmp1_ = content;
	self->priv->pos = _tmp1_;
	return self;
}


ValadocHighlighterXmlScanner* valadoc_highlighter_xml_scanner_new (const gchar* content) {
	return valadoc_highlighter_xml_scanner_construct (VALADOC_HIGHLIGHTER_TYPE_XML_SCANNER, content);
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_;
	gchar _tmp1_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static const gchar* string_offset (const gchar* self, glong offset) {
	const gchar* result = NULL;
	glong _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = offset;
	result = (const gchar*) (((gchar*) self) + _tmp0_);
	return result;
}


static ValadocHighlighterCodeToken* valadoc_highlighter_xml_scanner_real_next (ValadocHighlighterScanner* base) {
	ValadocHighlighterXmlScanner * self;
	ValadocHighlighterCodeToken* result = NULL;
	GQueue* _tmp0_;
	gboolean _tmp1_;
	const gchar* start = NULL;
	GQueue* _tmp94_;
	ValadocHighlighterCodeToken* _tmp95_;
	const gchar* _tmp96_;
	const gchar* _tmp97_;
	ValadocHighlighterCodeToken* _tmp98_;
	self = (ValadocHighlighterXmlScanner*) base;
	_tmp0_ = self->priv->token_queue;
	_tmp1_ = g_queue_is_empty (_tmp0_);
	if (!_tmp1_) {
		GQueue* _tmp2_;
		gpointer _tmp3_;
		_tmp2_ = self->priv->token_queue;
		_tmp3_ = g_queue_pop_head (_tmp2_);
		result = (ValadocHighlighterCodeToken*) _tmp3_;
		return result;
	}
	{
		const gchar* _tmp4_;
		gboolean _tmp5_ = FALSE;
		_tmp4_ = self->priv->pos;
		start = _tmp4_;
		_tmp5_ = TRUE;
		while (TRUE) {
			const gchar* _tmp8_;
			gchar _tmp9_;
			const gchar* _tmp10_;
			gchar _tmp11_;
			if (!_tmp5_) {
				const gchar* _tmp6_;
				const gchar* _tmp7_;
				_tmp6_ = self->priv->pos;
				_tmp7_ = g_utf8_next_char (_tmp6_);
				self->priv->pos = _tmp7_;
			}
			_tmp5_ = FALSE;
			_tmp8_ = self->priv->pos;
			_tmp9_ = string_get (_tmp8_, (glong) 0);
			if (!(_tmp9_ != '\0')) {
				break;
			}
			_tmp10_ = self->priv->pos;
			_tmp11_ = string_get (_tmp10_, (glong) 0);
			if (_tmp11_ == '&') {
				const gchar* begin = NULL;
				const gchar* _tmp12_;
				gboolean _tmp13_;
				_tmp12_ = self->priv->pos;
				begin = _tmp12_;
				_tmp13_ = valadoc_highlighter_xml_scanner_queue_escape (self);
				if (_tmp13_) {
					const gchar* _tmp14_;
					const gchar* _tmp15_;
					ValadocHighlighterCodeToken* _tmp16_;
					_tmp14_ = start;
					_tmp15_ = begin;
					_tmp16_ = valadoc_highlighter_xml_scanner_dispatch (self, _tmp14_, _tmp15_);
					result = _tmp16_;
					return result;
				}
			} else {
				const gchar* _tmp17_;
				gchar _tmp18_;
				_tmp17_ = self->priv->pos;
				_tmp18_ = string_get (_tmp17_, (glong) 0);
				if (_tmp18_ == '<') {
					const gchar* _tmp19_;
					gchar _tmp20_;
					_tmp19_ = self->priv->pos;
					_tmp20_ = string_get (_tmp19_, (glong) 1);
					if (_tmp20_ == '/') {
						const gchar* end = NULL;
						const gchar* _tmp21_;
						gboolean _tmp22_;
						_tmp21_ = self->priv->pos;
						end = _tmp21_;
						_tmp22_ = valadoc_highlighter_xml_scanner_queue_end_element (self);
						if (_tmp22_) {
							const gchar* _tmp23_;
							const gchar* _tmp24_;
							ValadocHighlighterCodeToken* _tmp25_;
							_tmp23_ = start;
							_tmp24_ = end;
							_tmp25_ = valadoc_highlighter_xml_scanner_dispatch (self, _tmp23_, _tmp24_);
							result = _tmp25_;
							return result;
						}
					} else {
						gboolean _tmp26_ = FALSE;
						gboolean _tmp27_ = FALSE;
						const gchar* _tmp28_;
						gchar _tmp29_;
						_tmp28_ = self->priv->pos;
						_tmp29_ = string_get (_tmp28_, (glong) 1);
						if (_tmp29_ == '!') {
							const gchar* _tmp30_;
							gchar _tmp31_;
							_tmp30_ = self->priv->pos;
							_tmp31_ = string_get (_tmp30_, (glong) 2);
							_tmp27_ = _tmp31_ == '-';
						} else {
							_tmp27_ = FALSE;
						}
						if (_tmp27_) {
							const gchar* _tmp32_;
							gchar _tmp33_;
							_tmp32_ = self->priv->pos;
							_tmp33_ = string_get (_tmp32_, (glong) 3);
							_tmp26_ = _tmp33_ == '-';
						} else {
							_tmp26_ = FALSE;
						}
						if (_tmp26_) {
							const gchar* end = NULL;
							const gchar* _tmp34_;
							gboolean _tmp35_;
							_tmp34_ = self->priv->pos;
							end = _tmp34_;
							_tmp35_ = valadoc_highlighter_xml_scanner_queue_comment (self);
							if (_tmp35_) {
								const gchar* _tmp36_;
								const gchar* _tmp37_;
								ValadocHighlighterCodeToken* _tmp38_;
								_tmp36_ = start;
								_tmp37_ = end;
								_tmp38_ = valadoc_highlighter_xml_scanner_dispatch (self, _tmp36_, _tmp37_);
								result = _tmp38_;
								return result;
							}
						} else {
							gboolean _tmp39_ = FALSE;
							gboolean _tmp40_ = FALSE;
							gboolean _tmp41_ = FALSE;
							gboolean _tmp42_ = FALSE;
							gboolean _tmp43_ = FALSE;
							gboolean _tmp44_ = FALSE;
							gboolean _tmp45_ = FALSE;
							const gchar* _tmp46_;
							gchar _tmp47_;
							_tmp46_ = self->priv->pos;
							_tmp47_ = string_get (_tmp46_, (glong) 1);
							if (_tmp47_ == '!') {
								const gchar* _tmp48_;
								gchar _tmp49_;
								_tmp48_ = self->priv->pos;
								_tmp49_ = string_get (_tmp48_, (glong) 2);
								_tmp45_ = _tmp49_ == '[';
							} else {
								_tmp45_ = FALSE;
							}
							if (_tmp45_) {
								const gchar* _tmp50_;
								gchar _tmp51_;
								_tmp50_ = self->priv->pos;
								_tmp51_ = string_get (_tmp50_, (glong) 3);
								_tmp44_ = _tmp51_ == 'C';
							} else {
								_tmp44_ = FALSE;
							}
							if (_tmp44_) {
								const gchar* _tmp52_;
								gchar _tmp53_;
								_tmp52_ = self->priv->pos;
								_tmp53_ = string_get (_tmp52_, (glong) 4);
								_tmp43_ = _tmp53_ == 'D';
							} else {
								_tmp43_ = FALSE;
							}
							if (_tmp43_) {
								const gchar* _tmp54_;
								gchar _tmp55_;
								_tmp54_ = self->priv->pos;
								_tmp55_ = string_get (_tmp54_, (glong) 5);
								_tmp42_ = _tmp55_ == 'A';
							} else {
								_tmp42_ = FALSE;
							}
							if (_tmp42_) {
								const gchar* _tmp56_;
								gchar _tmp57_;
								_tmp56_ = self->priv->pos;
								_tmp57_ = string_get (_tmp56_, (glong) 6);
								_tmp41_ = _tmp57_ == 'T';
							} else {
								_tmp41_ = FALSE;
							}
							if (_tmp41_) {
								const gchar* _tmp58_;
								gchar _tmp59_;
								_tmp58_ = self->priv->pos;
								_tmp59_ = string_get (_tmp58_, (glong) 7);
								_tmp40_ = _tmp59_ == 'A';
							} else {
								_tmp40_ = FALSE;
							}
							if (_tmp40_) {
								const gchar* _tmp60_;
								gchar _tmp61_;
								_tmp60_ = self->priv->pos;
								_tmp61_ = string_get (_tmp60_, (glong) 8);
								_tmp39_ = _tmp61_ == '[';
							} else {
								_tmp39_ = FALSE;
							}
							if (_tmp39_) {
								const gchar* end = NULL;
								const gchar* _tmp62_;
								const gchar* _tmp63_;
								const gchar* _tmp64_;
								GQueue* _tmp65_;
								ValadocHighlighterCodeToken* _tmp66_;
								const gchar* _tmp67_;
								const gchar* _tmp68_;
								ValadocHighlighterCodeToken* _tmp69_;
								_tmp62_ = self->priv->pos;
								end = _tmp62_;
								_tmp63_ = self->priv->pos;
								_tmp64_ = string_offset (_tmp63_, (glong) 9);
								self->priv->pos = _tmp64_;
								_tmp65_ = self->priv->token_queue;
								_tmp66_ = valadoc_highlighter_code_token_new (VALADOC_HIGHLIGHTER_CODE_TOKEN_TYPE_XML_CDATA, "<![CDATA[");
								g_queue_push_tail (_tmp65_, _tmp66_);
								_tmp67_ = start;
								_tmp68_ = end;
								_tmp69_ = valadoc_highlighter_xml_scanner_dispatch (self, _tmp67_, _tmp68_);
								result = _tmp69_;
								return result;
							} else {
								const gchar* end = NULL;
								const gchar* _tmp70_;
								const gchar* _tmp71_;
								const gchar* _tmp72_;
								gchar _tmp73_;
								gboolean _tmp74_;
								_tmp70_ = self->priv->pos;
								end = _tmp70_;
								_tmp71_ = start;
								_tmp72_ = self->priv->pos;
								_tmp73_ = string_get (_tmp72_, (glong) 1);
								_tmp74_ = valadoc_highlighter_xml_scanner_queue_start_element (self, _tmp71_, _tmp73_ == '?');
								if (_tmp74_) {
									const gchar* _tmp75_;
									const gchar* _tmp76_;
									ValadocHighlighterCodeToken* _tmp77_;
									_tmp75_ = start;
									_tmp76_ = end;
									_tmp77_ = valadoc_highlighter_xml_scanner_dispatch (self, _tmp75_, _tmp76_);
									result = _tmp77_;
									return result;
								} else {
									continue;
								}
							}
						}
					}
				} else {
					gboolean _tmp78_ = FALSE;
					gboolean _tmp79_ = FALSE;
					const gchar* _tmp80_;
					gchar _tmp81_;
					_tmp80_ = self->priv->pos;
					_tmp81_ = string_get (_tmp80_, (glong) 0);
					if (_tmp81_ == ']') {
						const gchar* _tmp82_;
						gchar _tmp83_;
						_tmp82_ = self->priv->pos;
						_tmp83_ = string_get (_tmp82_, (glong) 1);
						_tmp79_ = _tmp83_ == ']';
					} else {
						_tmp79_ = FALSE;
					}
					if (_tmp79_) {
						const gchar* _tmp84_;
						gchar _tmp85_;
						_tmp84_ = self->priv->pos;
						_tmp85_ = string_get (_tmp84_, (glong) 2);
						_tmp78_ = _tmp85_ == '>';
					} else {
						_tmp78_ = FALSE;
					}
					if (_tmp78_) {
						const gchar* end = NULL;
						const gchar* _tmp86_;
						const gchar* _tmp87_;
						const gchar* _tmp88_;
						GQueue* _tmp89_;
						ValadocHighlighterCodeToken* _tmp90_;
						const gchar* _tmp91_;
						const gchar* _tmp92_;
						ValadocHighlighterCodeToken* _tmp93_;
						_tmp86_ = self->priv->pos;
						end = _tmp86_;
						_tmp87_ = self->priv->pos;
						_tmp88_ = string_offset (_tmp87_, (glong) 3);
						self->priv->pos = _tmp88_;
						_tmp89_ = self->priv->token_queue;
						_tmp90_ = valadoc_highlighter_code_token_new (VALADOC_HIGHLIGHTER_CODE_TOKEN_TYPE_XML_CDATA, "]]>");
						g_queue_push_tail (_tmp89_, _tmp90_);
						_tmp91_ = start;
						_tmp92_ = end;
						_tmp93_ = valadoc_highlighter_xml_scanner_dispatch (self, _tmp91_, _tmp92_);
						result = _tmp93_;
						return result;
					}
				}
			}
		}
	}
	_tmp94_ = self->priv->token_queue;
	_tmp95_ = valadoc_highlighter_code_token_new (VALADOC_HIGHLIGHTER_CODE_TOKEN_TYPE_EOF, "");
	g_queue_push_tail (_tmp94_, _tmp95_);
	_tmp96_ = start;
	_tmp97_ = self->priv->pos;
	_tmp98_ = valadoc_highlighter_xml_scanner_dispatch (self, _tmp96_, _tmp97_);
	result = _tmp98_;
	return result;
}


static gboolean valadoc_highlighter_xml_scanner_queue_start_element (ValadocHighlighterXmlScanner* self, const gchar* dispatch_start, gboolean xml_decl) {
	gboolean result = FALSE;
	GQueue* _tmp0_;
	gboolean _tmp1_;
	const gchar* element_start = NULL;
	const gchar* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp8_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	gboolean _tmp13_;
	const gchar* element_end_start = NULL;
	const gchar* _tmp16_;
	gboolean _tmp17_ = FALSE;
	gboolean _tmp18_;
	const gchar* _tmp43_;
	const gchar* _tmp44_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (dispatch_start != NULL, FALSE);
	_tmp0_ = self->priv->token_queue;
	_tmp1_ = g_queue_is_empty (_tmp0_);
	_vala_assert (_tmp1_, "token_queue.is_empty ()");
	_tmp2_ = self->priv->pos;
	element_start = _tmp2_;
	_tmp3_ = xml_decl;
	if (_tmp3_) {
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		_tmp4_ = self->priv->pos;
		_tmp5_ = string_offset (_tmp4_, (glong) 2);
		self->priv->pos = _tmp5_;
	} else {
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		_tmp6_ = self->priv->pos;
		_tmp7_ = string_offset (_tmp6_, (glong) 1);
		self->priv->pos = _tmp7_;
	}
	valadoc_highlighter_xml_scanner_skip_optional_spaces (&self->priv->pos);
	_tmp8_ = valadoc_highlighter_xml_scanner_skip_id (&self->priv->pos);
	if (_tmp8_ == FALSE) {
		GQueue* _tmp9_;
		const gchar* _tmp10_;
		_tmp9_ = self->priv->token_queue;
		g_queue_clear (_tmp9_);
		_tmp10_ = element_start;
		self->priv->pos = _tmp10_;
		result = FALSE;
		return result;
	}
	valadoc_highlighter_xml_scanner_skip_optional_spaces (&self->priv->pos);
	_tmp11_ = element_start;
	_tmp12_ = self->priv->pos;
	valadoc_highlighter_xml_scanner_queue_token (self, _tmp11_, _tmp12_, VALADOC_HIGHLIGHTER_CODE_TOKEN_TYPE_XML_ELEMENT);
	_tmp13_ = valadoc_highlighter_xml_scanner_queue_attributes (self);
	if (_tmp13_ == FALSE) {
		GQueue* _tmp14_;
		const gchar* _tmp15_;
		_tmp14_ = self->priv->token_queue;
		g_queue_clear (_tmp14_);
		_tmp15_ = element_start;
		self->priv->pos = _tmp15_;
		result = FALSE;
		return result;
	}
	_tmp16_ = self->priv->pos;
	element_end_start = _tmp16_;
	_tmp18_ = xml_decl;
	if (!_tmp18_) {
		const gchar* _tmp19_;
		gchar _tmp20_;
		_tmp19_ = self->priv->pos;
		_tmp20_ = string_get (_tmp19_, (glong) 0);
		_tmp17_ = _tmp20_ == '>';
	} else {
		_tmp17_ = FALSE;
	}
	if (_tmp17_) {
		const gchar* _tmp21_;
		const gchar* _tmp22_;
		_tmp21_ = self->priv->pos;
		_tmp22_ = string_offset (_tmp21_, (glong) 1);
		self->priv->pos = _tmp22_;
	} else {
		gboolean _tmp23_ = FALSE;
		gboolean _tmp24_ = FALSE;
		gboolean _tmp25_;
		_tmp25_ = xml_decl;
		if (!_tmp25_) {
			const gchar* _tmp26_;
			gchar _tmp27_;
			_tmp26_ = self->priv->pos;
			_tmp27_ = string_get (_tmp26_, (glong) 0);
			_tmp24_ = _tmp27_ == '/';
		} else {
			_tmp24_ = FALSE;
		}
		if (_tmp24_) {
			const gchar* _tmp28_;
			gchar _tmp29_;
			_tmp28_ = self->priv->pos;
			_tmp29_ = string_get (_tmp28_, (glong) 1);
			_tmp23_ = _tmp29_ == '>';
		} else {
			_tmp23_ = FALSE;
		}
		if (_tmp23_) {
			const gchar* _tmp30_;
			const gchar* _tmp31_;
			_tmp30_ = self->priv->pos;
			_tmp31_ = string_offset (_tmp30_, (glong) 2);
			self->priv->pos = _tmp31_;
		} else {
			gboolean _tmp32_ = FALSE;
			gboolean _tmp33_ = FALSE;
			gboolean _tmp34_;
			_tmp34_ = xml_decl;
			if (_tmp34_) {
				const gchar* _tmp35_;
				gchar _tmp36_;
				_tmp35_ = self->priv->pos;
				_tmp36_ = string_get (_tmp35_, (glong) 0);
				_tmp33_ = _tmp36_ == '?';
			} else {
				_tmp33_ = FALSE;
			}
			if (_tmp33_) {
				const gchar* _tmp37_;
				gchar _tmp38_;
				_tmp37_ = self->priv->pos;
				_tmp38_ = string_get (_tmp37_, (glong) 1);
				_tmp32_ = _tmp38_ == '>';
			} else {
				_tmp32_ = FALSE;
			}
			if (_tmp32_) {
				const gchar* _tmp39_;
				const gchar* _tmp40_;
				_tmp39_ = self->priv->pos;
				_tmp40_ = string_offset (_tmp39_, (glong) 2);
				self->priv->pos = _tmp40_;
			} else {
				GQueue* _tmp41_;
				const gchar* _tmp42_;
				_tmp41_ = self->priv->token_queue;
				g_queue_clear (_tmp41_);
				_tmp42_ = element_start;
				self->priv->pos = _tmp42_;
				result = FALSE;
				return result;
			}
		}
	}
	_tmp43_ = element_end_start;
	_tmp44_ = self->priv->pos;
	valadoc_highlighter_xml_scanner_queue_token (self, _tmp43_, _tmp44_, VALADOC_HIGHLIGHTER_CODE_TOKEN_TYPE_XML_ELEMENT);
	result = TRUE;
	return result;
}


static gboolean valadoc_highlighter_xml_scanner_queue_attributes (ValadocHighlighterXmlScanner* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	while (TRUE) {
		const gchar* _tmp0_;
		gchar _tmp1_;
		gboolean _tmp2_;
		const gchar* begin = NULL;
		const gchar* _tmp3_;
		gboolean _tmp4_;
		const gchar* _tmp5_;
		gchar _tmp6_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		gchar _tmp13_;
		const gchar* _tmp23_;
		gchar _tmp24_;
		const gchar* _tmp27_;
		const gchar* _tmp28_;
		_tmp0_ = self->priv->pos;
		_tmp1_ = string_get (_tmp0_, (glong) 0);
		_tmp2_ = valadoc_highlighter_xml_scanner_is_id_char (_tmp1_);
		if (!_tmp2_) {
			break;
		}
		_tmp3_ = self->priv->pos;
		begin = _tmp3_;
		_tmp4_ = valadoc_highlighter_xml_scanner_skip_id (&self->priv->pos);
		if (_tmp4_ == FALSE) {
			result = FALSE;
			return result;
		}
		valadoc_highlighter_xml_scanner_skip_optional_spaces (&self->priv->pos);
		_tmp5_ = self->priv->pos;
		_tmp6_ = string_get (_tmp5_, (glong) 0);
		if (_tmp6_ == '=') {
			const gchar* _tmp7_;
			const gchar* _tmp8_;
			_tmp7_ = self->priv->pos;
			_tmp8_ = string_offset (_tmp7_, (glong) 1);
			self->priv->pos = _tmp8_;
		} else {
			result = FALSE;
			return result;
		}
		valadoc_highlighter_xml_scanner_skip_optional_spaces (&self->priv->pos);
		_tmp9_ = begin;
		_tmp10_ = self->priv->pos;
		valadoc_highlighter_xml_scanner_queue_token (self, _tmp9_, _tmp10_, VALADOC_HIGHLIGHTER_CODE_TOKEN_TYPE_XML_ATTRIBUTE);
		_tmp11_ = self->priv->pos;
		begin = _tmp11_;
		_tmp12_ = self->priv->pos;
		_tmp13_ = string_get (_tmp12_, (glong) 0);
		if (_tmp13_ == '"') {
			const gchar* _tmp14_;
			const gchar* _tmp15_;
			_tmp14_ = self->priv->pos;
			_tmp15_ = string_offset (_tmp14_, (glong) 1);
			self->priv->pos = _tmp15_;
		} else {
			result = FALSE;
			return result;
		}
		while (TRUE) {
			gboolean _tmp16_ = FALSE;
			const gchar* _tmp17_;
			gchar _tmp18_;
			const gchar* _tmp21_;
			const gchar* _tmp22_;
			_tmp17_ = self->priv->pos;
			_tmp18_ = string_get (_tmp17_, (glong) 0);
			if (_tmp18_ != '"') {
				const gchar* _tmp19_;
				gchar _tmp20_;
				_tmp19_ = self->priv->pos;
				_tmp20_ = string_get (_tmp19_, (glong) 0);
				_tmp16_ = _tmp20_ != '\0';
			} else {
				_tmp16_ = FALSE;
			}
			if (!_tmp16_) {
				break;
			}
			_tmp21_ = self->priv->pos;
			_tmp22_ = string_offset (_tmp21_, (glong) 1);
			self->priv->pos = _tmp22_;
		}
		_tmp23_ = self->priv->pos;
		_tmp24_ = string_get (_tmp23_, (glong) 0);
		if (_tmp24_ == '"') {
			const gchar* _tmp25_;
			const gchar* _tmp26_;
			_tmp25_ = self->priv->pos;
			_tmp26_ = string_offset (_tmp25_, (glong) 1);
			self->priv->pos = _tmp26_;
		} else {
			result = FALSE;
			return result;
		}
		valadoc_highlighter_xml_scanner_skip_optional_spaces (&self->priv->pos);
		_tmp27_ = begin;
		_tmp28_ = self->priv->pos;
		valadoc_highlighter_xml_scanner_queue_token (self, _tmp27_, _tmp28_, VALADOC_HIGHLIGHTER_CODE_TOKEN_TYPE_XML_ATTRIBUTE_VALUE);
	}
	result = TRUE;
	return result;
}


static gboolean valadoc_highlighter_xml_scanner_queue_end_element (ValadocHighlighterXmlScanner* self) {
	gboolean result = FALSE;
	const gchar* start = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gboolean _tmp3_;
	const gchar* _tmp5_;
	gchar _tmp6_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->pos;
	start = _tmp0_;
	_tmp1_ = self->priv->pos;
	_tmp2_ = string_offset (_tmp1_, (glong) 2);
	self->priv->pos = _tmp2_;
	valadoc_highlighter_xml_scanner_skip_optional_spaces (&self->priv->pos);
	_tmp3_ = valadoc_highlighter_xml_scanner_skip_id (&self->priv->pos);
	if (_tmp3_ == FALSE) {
		const gchar* _tmp4_;
		_tmp4_ = start;
		self->priv->pos = _tmp4_;
		result = FALSE;
		return result;
	}
	valadoc_highlighter_xml_scanner_skip_optional_spaces (&self->priv->pos);
	_tmp5_ = self->priv->pos;
	_tmp6_ = string_get (_tmp5_, (glong) 0);
	if (_tmp6_ == '>') {
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		_tmp7_ = self->priv->pos;
		_tmp8_ = string_offset (_tmp7_, (glong) 1);
		self->priv->pos = _tmp8_;
	} else {
		const gchar* _tmp9_;
		_tmp9_ = start;
		self->priv->pos = _tmp9_;
		result = FALSE;
		return result;
	}
	_tmp10_ = start;
	_tmp11_ = self->priv->pos;
	valadoc_highlighter_xml_scanner_queue_token (self, _tmp10_, _tmp11_, VALADOC_HIGHLIGHTER_CODE_TOKEN_TYPE_XML_ELEMENT);
	result = TRUE;
	return result;
}


static gboolean valadoc_highlighter_xml_scanner_queue_escape (ValadocHighlighterXmlScanner* self) {
	gboolean result = FALSE;
	const gchar* start = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gboolean _tmp3_;
	const gchar* _tmp5_;
	gchar _tmp6_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->pos;
	start = _tmp0_;
	_tmp1_ = self->priv->pos;
	_tmp2_ = string_offset (_tmp1_, (glong) 1);
	self->priv->pos = _tmp2_;
	_tmp3_ = valadoc_highlighter_xml_scanner_skip_id (&self->priv->pos);
	if (_tmp3_ == FALSE) {
		const gchar* _tmp4_;
		_tmp4_ = start;
		self->priv->pos = _tmp4_;
		result = FALSE;
		return result;
	}
	_tmp5_ = self->priv->pos;
	_tmp6_ = string_get (_tmp5_, (glong) 0);
	if (_tmp6_ == ';') {
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		_tmp7_ = self->priv->pos;
		_tmp8_ = string_offset (_tmp7_, (glong) 1);
		self->priv->pos = _tmp8_;
	} else {
		const gchar* _tmp9_;
		_tmp9_ = start;
		self->priv->pos = _tmp9_;
		result = FALSE;
		return result;
	}
	_tmp10_ = start;
	_tmp11_ = self->priv->pos;
	valadoc_highlighter_xml_scanner_queue_token (self, _tmp10_, _tmp11_, VALADOC_HIGHLIGHTER_CODE_TOKEN_TYPE_XML_ESCAPE);
	result = TRUE;
	return result;
}


static gboolean valadoc_highlighter_xml_scanner_queue_comment (ValadocHighlighterXmlScanner* self) {
	gboolean result = FALSE;
	const gchar* start = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp10_;
	gchar _tmp11_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->pos;
	start = _tmp0_;
	_tmp1_ = self->priv->pos;
	_tmp2_ = string_offset (_tmp1_, (glong) 4);
	self->priv->pos = _tmp2_;
	while (TRUE) {
		gboolean _tmp3_ = FALSE;
		const gchar* _tmp4_;
		gchar _tmp5_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		_tmp4_ = self->priv->pos;
		_tmp5_ = string_get (_tmp4_, (glong) 0);
		if (_tmp5_ != '>') {
			const gchar* _tmp6_;
			gchar _tmp7_;
			_tmp6_ = self->priv->pos;
			_tmp7_ = string_get (_tmp6_, (glong) 0);
			_tmp3_ = _tmp7_ != '\0';
		} else {
			_tmp3_ = FALSE;
		}
		if (!_tmp3_) {
			break;
		}
		_tmp8_ = self->priv->pos;
		_tmp9_ = string_offset (_tmp8_, (glong) 1);
		self->priv->pos = _tmp9_;
	}
	_tmp10_ = self->priv->pos;
	_tmp11_ = string_get (_tmp10_, (glong) 0);
	if (_tmp11_ == '>') {
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		_tmp12_ = self->priv->pos;
		_tmp13_ = string_offset (_tmp12_, (glong) 1);
		self->priv->pos = _tmp13_;
	} else {
		const gchar* _tmp14_;
		_tmp14_ = start;
		self->priv->pos = _tmp14_;
		result = FALSE;
		return result;
	}
	_tmp15_ = start;
	_tmp16_ = self->priv->pos;
	valadoc_highlighter_xml_scanner_queue_token (self, _tmp15_, _tmp16_, VALADOC_HIGHLIGHTER_CODE_TOKEN_TYPE_XML_COMMENT);
	result = TRUE;
	return result;
}


static gboolean valadoc_highlighter_xml_scanner_skip_id (const gchar* * pos) {
	gboolean result = FALSE;
	gboolean has_next_segment = FALSE;
	gboolean has_id = FALSE;
	g_return_val_if_fail (*pos != NULL, FALSE);
	has_next_segment = TRUE;
	has_id = FALSE;
	while (TRUE) {
		gboolean _tmp0_;
		gboolean _tmp6_ = FALSE;
		const gchar* _tmp7_;
		gchar _tmp8_;
		_tmp0_ = has_next_segment;
		if (!_tmp0_) {
			break;
		}
		has_id = FALSE;
		while (TRUE) {
			const gchar* _tmp1_;
			gchar _tmp2_;
			gboolean _tmp3_;
			const gchar* _tmp4_;
			const gchar* _tmp5_;
			_tmp1_ = *pos;
			_tmp2_ = string_get (_tmp1_, (glong) 0);
			_tmp3_ = valadoc_highlighter_xml_scanner_is_id_char (_tmp2_);
			if (!_tmp3_) {
				break;
			}
			_tmp4_ = *pos;
			_tmp5_ = string_offset (_tmp4_, (glong) 1);
			*pos = _tmp5_;
			has_id = TRUE;
		}
		_tmp7_ = *pos;
		_tmp8_ = string_get (_tmp7_, (glong) 0);
		if (_tmp8_ == ':') {
			gboolean _tmp9_;
			_tmp9_ = has_id;
			_tmp6_ = _tmp9_;
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
			const gchar* _tmp10_;
			const gchar* _tmp11_;
			has_next_segment = TRUE;
			_tmp10_ = *pos;
			_tmp11_ = string_offset (_tmp10_, (glong) 1);
			*pos = _tmp11_;
		} else {
			has_next_segment = FALSE;
		}
	}
	result = has_id;
	return result;
}


static gboolean valadoc_highlighter_xml_scanner_skip_optional_spaces (const gchar* * pos) {
	gboolean result = FALSE;
	gboolean skipped = FALSE;
	g_return_val_if_fail (*pos != NULL, FALSE);
	skipped = FALSE;
	while (TRUE) {
		const gchar* _tmp0_;
		gchar _tmp1_;
		gboolean _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp0_ = *pos;
		_tmp1_ = string_get (_tmp0_, (glong) 0);
		_tmp2_ = g_ascii_isspace (_tmp1_);
		if (!_tmp2_) {
			break;
		}
		_tmp3_ = *pos;
		_tmp4_ = string_offset (_tmp3_, (glong) 1);
		*pos = _tmp4_;
		skipped = TRUE;
	}
	result = skipped;
	return result;
}


static glong string_pointer_to_offset (const gchar* self, const gchar* pos) {
	glong result = 0L;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, 0L);
	g_return_val_if_fail (pos != NULL, 0L);
	_tmp0_ = pos;
	result = (glong) (((gchar*) _tmp0_) - ((gchar*) self));
	return result;
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	glong _tmp8_;
	glong _tmp14_;
	glong _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	gchar* _tmp22_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp3_;
		glong _tmp4_;
		glong _tmp5_;
		_tmp3_ = offset;
		_tmp4_ = len;
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
		string_length = _tmp5_;
	} else {
		gint _tmp6_;
		gint _tmp7_;
		_tmp6_ = strlen (self);
		_tmp7_ = _tmp6_;
		string_length = (glong) _tmp7_;
	}
	_tmp8_ = offset;
	if (_tmp8_ < ((glong) 0)) {
		glong _tmp9_;
		glong _tmp10_;
		glong _tmp11_;
		_tmp9_ = string_length;
		_tmp10_ = offset;
		offset = _tmp9_ + _tmp10_;
		_tmp11_ = offset;
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
	} else {
		glong _tmp12_;
		glong _tmp13_;
		_tmp12_ = offset;
		_tmp13_ = string_length;
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
	}
	_tmp14_ = len;
	if (_tmp14_ < ((glong) 0)) {
		glong _tmp15_;
		glong _tmp16_;
		_tmp15_ = string_length;
		_tmp16_ = offset;
		len = _tmp15_ - _tmp16_;
	}
	_tmp17_ = offset;
	_tmp18_ = len;
	_tmp19_ = string_length;
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
	_tmp20_ = offset;
	_tmp21_ = len;
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
	result = _tmp22_;
	return result;
}


static ValadocHighlighterCodeToken* valadoc_highlighter_xml_scanner_dispatch (ValadocHighlighterXmlScanner* self, const gchar* start, const gchar* end) {
	ValadocHighlighterCodeToken* result = NULL;
	GQueue* _tmp0_;
	gboolean _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	glong length = 0L;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	glong _tmp8_;
	gchar* content = NULL;
	const gchar* _tmp9_;
	glong _tmp10_;
	gchar* _tmp11_;
	const gchar* _tmp12_;
	ValadocHighlighterCodeToken* _tmp13_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (start != NULL, NULL);
	g_return_val_if_fail (end != NULL, NULL);
	_tmp0_ = self->priv->token_queue;
	_tmp1_ = g_queue_is_empty (_tmp0_);
	_vala_assert (_tmp1_ == FALSE, "token_queue.is_empty () == false");
	_tmp2_ = start;
	_tmp3_ = end;
	if (((gchar*) _tmp2_) == ((gchar*) _tmp3_)) {
		GQueue* _tmp4_;
		gpointer _tmp5_;
		_tmp4_ = self->priv->token_queue;
		_tmp5_ = g_queue_pop_head (_tmp4_);
		result = (ValadocHighlighterCodeToken*) _tmp5_;
		return result;
	}
	_tmp6_ = start;
	_tmp7_ = end;
	_tmp8_ = string_pointer_to_offset (_tmp6_, _tmp7_);
	length = _tmp8_;
	_tmp9_ = start;
	_tmp10_ = length;
	_tmp11_ = string_substring (_tmp9_, (glong) 0, _tmp10_);
	content = _tmp11_;
	_tmp12_ = content;
	_tmp13_ = valadoc_highlighter_code_token_new (VALADOC_HIGHLIGHTER_CODE_TOKEN_TYPE_PLAIN, _tmp12_);
	result = _tmp13_;
	_g_free0 (content);
	return result;
}


static void valadoc_highlighter_xml_scanner_queue_token (ValadocHighlighterXmlScanner* self, const gchar* start, const gchar* end, ValadocHighlighterCodeTokenType token_type) {
	glong length = 0L;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	glong _tmp2_;
	gchar* content = NULL;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	GQueue* _tmp5_;
	ValadocHighlighterCodeTokenType _tmp6_;
	ValadocHighlighterCodeToken* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (start != NULL);
	g_return_if_fail (end != NULL);
	_tmp0_ = start;
	_tmp1_ = end;
	_tmp2_ = string_pointer_to_offset (_tmp0_, _tmp1_);
	length = _tmp2_;
	_tmp3_ = start;
	_tmp4_ = string_substring (_tmp3_, (glong) 0, length);
	content = _tmp4_;
	_tmp5_ = self->priv->token_queue;
	_tmp6_ = token_type;
	_tmp7_ = valadoc_highlighter_code_token_new (_tmp6_, content);
	g_queue_push_tail (_tmp5_, _tmp7_);
	_g_free0 (content);
}


static inline gboolean valadoc_highlighter_xml_scanner_is_id_char (gchar c) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gchar _tmp2_;
	gboolean _tmp3_;
	_tmp2_ = c;
	_tmp3_ = g_ascii_isalnum (_tmp2_);
	if (_tmp3_) {
		_tmp1_ = TRUE;
	} else {
		gchar _tmp4_;
		_tmp4_ = c;
		_tmp1_ = _tmp4_ == '_';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gchar _tmp5_;
		_tmp5_ = c;
		_tmp0_ = _tmp5_ == '-';
	}
	result = _tmp0_;
	return result;
}


G_GNUC_INTERNAL gboolean valadoc_highlighter_xml_scanner_is_xml (const gchar* source) {
	gboolean result = FALSE;
	const gchar* pos = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar _tmp2_;
	g_return_val_if_fail (source != NULL, FALSE);
	_tmp0_ = source;
	pos = _tmp0_;
	valadoc_highlighter_xml_scanner_skip_optional_spaces (&pos);
	_tmp1_ = pos;
	_tmp2_ = string_get (_tmp1_, (glong) 0);
	if (_tmp2_ == '<') {
		const gchar* _tmp3_;
		gboolean _tmp4_;
		const gchar* _tmp5_;
		gboolean _tmp6_;
		gboolean proc_instr = FALSE;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		gchar _tmp10_;
		gboolean _tmp13_;
		gboolean _tmp37_ = FALSE;
		gboolean _tmp38_ = FALSE;
		gboolean _tmp39_;
		gboolean _tmp44_ = FALSE;
		gboolean _tmp45_;
		_tmp3_ = pos;
		_tmp4_ = g_str_has_prefix (_tmp3_, "<!--");
		if (_tmp4_) {
			result = TRUE;
			return result;
		}
		_tmp5_ = pos;
		_tmp6_ = g_str_has_prefix (_tmp5_, "<![CDATA[");
		if (_tmp6_) {
			result = TRUE;
			return result;
		}
		proc_instr = FALSE;
		_tmp7_ = pos;
		_tmp8_ = string_offset (_tmp7_, (glong) 1);
		pos = _tmp8_;
		_tmp9_ = pos;
		_tmp10_ = string_get (_tmp9_, (glong) 0);
		if (_tmp10_ == '?') {
			const gchar* _tmp11_;
			const gchar* _tmp12_;
			_tmp11_ = pos;
			_tmp12_ = string_offset (_tmp11_, (glong) 1);
			pos = _tmp12_;
			proc_instr = TRUE;
		}
		_tmp13_ = valadoc_highlighter_xml_scanner_skip_id (&pos);
		if (_tmp13_ == FALSE) {
			result = FALSE;
			return result;
		}
		valadoc_highlighter_xml_scanner_skip_optional_spaces (&pos);
		while (TRUE) {
			gboolean _tmp14_;
			const gchar* _tmp15_;
			gchar _tmp16_;
			const gchar* _tmp19_;
			gchar _tmp20_;
			const gchar* _tmp33_;
			gchar _tmp34_;
			_tmp14_ = valadoc_highlighter_xml_scanner_skip_id (&pos);
			if (!_tmp14_) {
				break;
			}
			_tmp15_ = pos;
			_tmp16_ = string_get (_tmp15_, (glong) 0);
			if (_tmp16_ == '=') {
				const gchar* _tmp17_;
				const gchar* _tmp18_;
				_tmp17_ = pos;
				_tmp18_ = string_offset (_tmp17_, (glong) 1);
				pos = _tmp18_;
			} else {
				result = FALSE;
				return result;
			}
			valadoc_highlighter_xml_scanner_skip_optional_spaces (&pos);
			_tmp19_ = pos;
			_tmp20_ = string_get (_tmp19_, (glong) 0);
			if (_tmp20_ == '"') {
				const gchar* _tmp21_;
				const gchar* _tmp22_;
				_tmp21_ = pos;
				_tmp22_ = string_offset (_tmp21_, (glong) 1);
				pos = _tmp22_;
			} else {
				result = FALSE;
				return result;
			}
			while (TRUE) {
				gboolean _tmp23_ = FALSE;
				gboolean _tmp24_ = FALSE;
				const gchar* _tmp25_;
				gchar _tmp26_;
				const gchar* _tmp31_;
				const gchar* _tmp32_;
				_tmp25_ = pos;
				_tmp26_ = string_get (_tmp25_, (glong) 0);
				if (_tmp26_ != '\0') {
					const gchar* _tmp27_;
					gchar _tmp28_;
					_tmp27_ = pos;
					_tmp28_ = string_get (_tmp27_, (glong) 0);
					_tmp24_ = _tmp28_ != '\n';
				} else {
					_tmp24_ = FALSE;
				}
				if (_tmp24_) {
					const gchar* _tmp29_;
					gchar _tmp30_;
					_tmp29_ = pos;
					_tmp30_ = string_get (_tmp29_, (glong) 0);
					_tmp23_ = _tmp30_ != '"';
				} else {
					_tmp23_ = FALSE;
				}
				if (!_tmp23_) {
					break;
				}
				_tmp31_ = pos;
				_tmp32_ = string_offset (_tmp31_, (glong) 1);
				pos = _tmp32_;
			}
			_tmp33_ = pos;
			_tmp34_ = string_get (_tmp33_, (glong) 0);
			if (_tmp34_ == '"') {
				const gchar* _tmp35_;
				const gchar* _tmp36_;
				_tmp35_ = pos;
				_tmp36_ = string_offset (_tmp35_, (glong) 1);
				pos = _tmp36_;
			} else {
				result = FALSE;
				return result;
			}
			valadoc_highlighter_xml_scanner_skip_optional_spaces (&pos);
		}
		_tmp39_ = proc_instr;
		if (_tmp39_) {
			const gchar* _tmp40_;
			gchar _tmp41_;
			_tmp40_ = pos;
			_tmp41_ = string_get (_tmp40_, (glong) 0);
			_tmp38_ = _tmp41_ == '?';
		} else {
			_tmp38_ = FALSE;
		}
		if (_tmp38_) {
			const gchar* _tmp42_;
			gchar _tmp43_;
			_tmp42_ = pos;
			_tmp43_ = string_get (_tmp42_, (glong) 1);
			_tmp37_ = _tmp43_ == '>';
		} else {
			_tmp37_ = FALSE;
		}
		if (_tmp37_) {
			result = TRUE;
			return result;
		}
		_tmp45_ = proc_instr;
		if (!_tmp45_) {
			gboolean _tmp46_ = FALSE;
			const gchar* _tmp47_;
			gchar _tmp48_;
			_tmp47_ = pos;
			_tmp48_ = string_get (_tmp47_, (glong) 0);
			if (_tmp48_ == '>') {
				_tmp46_ = TRUE;
			} else {
				gboolean _tmp49_ = FALSE;
				const gchar* _tmp50_;
				gchar _tmp51_;
				_tmp50_ = pos;
				_tmp51_ = string_get (_tmp50_, (glong) 0);
				if (_tmp51_ == '/') {
					const gchar* _tmp52_;
					gchar _tmp53_;
					_tmp52_ = pos;
					_tmp53_ = string_get (_tmp52_, (glong) 1);
					_tmp49_ = _tmp53_ == '>';
				} else {
					_tmp49_ = FALSE;
				}
				_tmp46_ = _tmp49_;
			}
			_tmp44_ = _tmp46_;
		} else {
			_tmp44_ = FALSE;
		}
		if (_tmp44_) {
			result = TRUE;
			return result;
		}
		result = FALSE;
		return result;
	} else {
		result = FALSE;
		return result;
	}
}


static void valadoc_highlighter_xml_scanner_class_init (ValadocHighlighterXmlScannerClass * klass) {
	valadoc_highlighter_xml_scanner_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValadocHighlighterXmlScannerPrivate));
	G_OBJECT_CLASS (klass)->finalize = valadoc_highlighter_xml_scanner_finalize;
}


static void valadoc_highlighter_xml_scanner_valadoc_highlighter_scanner_interface_init (ValadocHighlighterScannerIface * iface) {
	valadoc_highlighter_xml_scanner_valadoc_highlighter_scanner_parent_iface = g_type_interface_peek_parent (iface);
	iface->next = (ValadocHighlighterCodeToken* (*) (ValadocHighlighterScanner *)) valadoc_highlighter_xml_scanner_real_next;
}


static void valadoc_highlighter_xml_scanner_instance_init (ValadocHighlighterXmlScanner * self) {
	GQueue* _tmp0_;
	self->priv = VALADOC_HIGHLIGHTER_XML_SCANNER_GET_PRIVATE (self);
	_tmp0_ = g_queue_new ();
	self->priv->token_queue = _tmp0_;
}


static void valadoc_highlighter_xml_scanner_finalize (GObject * obj) {
	ValadocHighlighterXmlScanner * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALADOC_HIGHLIGHTER_TYPE_XML_SCANNER, ValadocHighlighterXmlScanner);
	__g_queue_free__valadoc_highlighter_code_token_unref0_0 (self->priv->token_queue);
	G_OBJECT_CLASS (valadoc_highlighter_xml_scanner_parent_class)->finalize (obj);
}


/**
 * A cheap scanner used to highlight XML.
 */
GType valadoc_highlighter_xml_scanner_get_type (void) {
	static volatile gsize valadoc_highlighter_xml_scanner_type_id__volatile = 0;
	if (g_once_init_enter (&valadoc_highlighter_xml_scanner_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValadocHighlighterXmlScannerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) valadoc_highlighter_xml_scanner_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValadocHighlighterXmlScanner), 0, (GInstanceInitFunc) valadoc_highlighter_xml_scanner_instance_init, NULL };
		static const GInterfaceInfo valadoc_highlighter_scanner_info = { (GInterfaceInitFunc) valadoc_highlighter_xml_scanner_valadoc_highlighter_scanner_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType valadoc_highlighter_xml_scanner_type_id;
		valadoc_highlighter_xml_scanner_type_id = g_type_register_static (G_TYPE_OBJECT, "ValadocHighlighterXmlScanner", &g_define_type_info, 0);
		g_type_add_interface_static (valadoc_highlighter_xml_scanner_type_id, VALADOC_HIGHLIGHTER_TYPE_SCANNER, &valadoc_highlighter_scanner_info);
		g_once_init_leave (&valadoc_highlighter_xml_scanner_type_id__volatile, valadoc_highlighter_xml_scanner_type_id);
	}
	return valadoc_highlighter_xml_scanner_type_id__volatile;
}



