/* cheese-preferences.c generated by valac 0.36.1.54-17500, the Vala compiler
 * generated from cheese-preferences.vala, do not modify */

/*
 * Copyright © 2010 Yuvaraj Pandian T <yuvipanda@yuvi.in>
 * Copyright © 2010 daniel g. siegel <dgsiegel@gnome.org>
 * Copyright © 2008 Filippo Argiolas <filippo.argiolas@gmail.com>
 *
 * Licensed under the GNU General Public License Version 2
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <cheese-camera.h>
#include <gio/gio.h>
#include <cheese-fileutil.h>
#include <stdlib.h>
#include <string.h>
#include <cheese-camera-device.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>


#define CHEESE_TYPE_PREFERENCES_DIALOG (cheese_preferences_dialog_get_type ())
#define CHEESE_PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CHEESE_TYPE_PREFERENCES_DIALOG, CheesePreferencesDialog))
#define CHEESE_PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CHEESE_TYPE_PREFERENCES_DIALOG, CheesePreferencesDialogClass))
#define CHEESE_IS_PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CHEESE_TYPE_PREFERENCES_DIALOG))
#define CHEESE_IS_PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CHEESE_TYPE_PREFERENCES_DIALOG))
#define CHEESE_PREFERENCES_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CHEESE_TYPE_PREFERENCES_DIALOG, CheesePreferencesDialogClass))

typedef struct _CheesePreferencesDialog CheesePreferencesDialog;
typedef struct _CheesePreferencesDialogClass CheesePreferencesDialogClass;
typedef struct _CheesePreferencesDialogPrivate CheesePreferencesDialogPrivate;
enum  {
	CHEESE_PREFERENCES_DIALOG_DUMMY_PROPERTY,
	CHEESE_PREFERENCES_DIALOG_LAST_PROPERTY
};
static GParamSpec* cheese_preferences_dialog_properties[CHEESE_PREFERENCES_DIALOG_LAST_PROPERTY];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define __vala_CheeseVideoFormat_free0(var) ((var == NULL) ? NULL : (var = (_vala_CheeseVideoFormat_free (var), NULL)))
typedef struct _Block2Data Block2Data;

struct _CheesePreferencesDialog {
	GtkDialog parent_instance;
	CheesePreferencesDialogPrivate * priv;
};

struct _CheesePreferencesDialogClass {
	GtkDialogClass parent_class;
};

struct _CheesePreferencesDialogPrivate {
	CheeseCamera* camera;
	GSettings* settings;
	GtkComboBox* photo_resolution_combo;
	GtkComboBox* video_resolution_combo;
	GtkComboBox* source_combo;
	GtkListStore* camera_model;
	GtkAdjustment* brightness_adjustment;
	GtkAdjustment* contrast_adjustment;
	GtkAdjustment* hue_adjustment;
	GtkAdjustment* saturation_adjustment;
	GtkSpinButton* burst_repeat_spin;
	GtkSpinButton* burst_delay_spin;
	GtkCheckButton* countdown_check;
	GtkCheckButton* flash_check;
	CheeseMediaMode current_mode;
};

struct _Block1Data {
	int _ref_count_;
	CheesePreferencesDialog* self;
	GtkListStore* resolution_model;
};

struct _Block2Data {
	int _ref_count_;
	CheesePreferencesDialog* self;
	GtkTreeIter iter;
	CheeseCameraDevice* active_device;
	gboolean device_removed;
};


static gpointer cheese_preferences_dialog_parent_class = NULL;

GType cheese_preferences_dialog_get_type (void) G_GNUC_CONST;
#define CHEESE_PREFERENCES_DIALOG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CHEESE_TYPE_PREFERENCES_DIALOG, CheesePreferencesDialogPrivate))
CheesePreferencesDialog* cheese_preferences_dialog_new (CheeseCamera* camera);
CheesePreferencesDialog* cheese_preferences_dialog_construct (GType object_type, CheeseCamera* camera);
static void cheese_preferences_dialog_setup_combo_box_models (CheesePreferencesDialog* self);
static void cheese_preferences_dialog_initialize_camera_devices (CheesePreferencesDialog* self);
static void cheese_preferences_dialog_initialize_values_from_settings (CheesePreferencesDialog* self);
static void cheese_preferences_dialog_on_camera_update_num_camera_devices (CheesePreferencesDialog* self);
static void _cheese_preferences_dialog_on_camera_update_num_camera_devices_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void cheese_preferences_dialog_add_camera_device (CheesePreferencesDialog* self, void* device);
static void _cheese_preferences_dialog_add_camera_device_gfunc (gconstpointer data, gpointer self);
static void cheese_preferences_dialog_setup_resolutions_for_device (CheesePreferencesDialog* self, CheeseCameraDevice* device);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void __lambda5_ (Block1Data* _data1_, CheeseVideoFormat* format);
static void ___lambda5__gfunc (gconstpointer data, gpointer self);
static void cheese_preferences_dialog_on_source_change (CheesePreferencesDialog* self, GtkComboBox* combo);
static void _cheese_preferences_dialog_on_source_change_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self);
static void cheese_preferences_dialog_on_photo_resolution_change (CheesePreferencesDialog* self, GtkComboBox* combo);
static void _vala_CheeseVideoFormat_free (CheeseVideoFormat* self);
static void _cheese_preferences_dialog_on_photo_resolution_change_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self);
static void cheese_preferences_dialog_on_video_resolution_change (CheesePreferencesDialog* self, GtkComboBox* combo);
static void _cheese_preferences_dialog_on_video_resolution_change_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self);
static gboolean cheese_preferences_dialog_on_delete (CheesePreferencesDialog* self);
static gboolean _cheese_preferences_dialog_on_delete_gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self);
static void cheese_preferences_dialog_on_dialog_close (CheesePreferencesDialog* self, GtkButton* button);
static void _cheese_preferences_dialog_on_dialog_close_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void cheese_preferences_dialog_on_dialog_help (CheesePreferencesDialog* self, GtkButton* button);
static void _cheese_preferences_dialog_on_dialog_help_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void cheese_preferences_dialog_on_burst_delay_change (CheesePreferencesDialog* self, GtkSpinButton* spinbutton);
static void _cheese_preferences_dialog_on_burst_delay_change_gtk_spin_button_value_changed (GtkSpinButton* _sender, gpointer self);
static void cheese_preferences_dialog_on_brightness_change (CheesePreferencesDialog* self, GtkAdjustment* adjustment);
static void _cheese_preferences_dialog_on_brightness_change_gtk_adjustment_value_changed (GtkAdjustment* _sender, gpointer self);
static void cheese_preferences_dialog_on_contrast_change (CheesePreferencesDialog* self, GtkAdjustment* adjustment);
static void _cheese_preferences_dialog_on_contrast_change_gtk_adjustment_value_changed (GtkAdjustment* _sender, gpointer self);
static void cheese_preferences_dialog_on_hue_change (CheesePreferencesDialog* self, GtkAdjustment* adjustment);
static void _cheese_preferences_dialog_on_hue_change_gtk_adjustment_value_changed (GtkAdjustment* _sender, gpointer self);
static void cheese_preferences_dialog_on_saturation_change (CheesePreferencesDialog* self, GtkAdjustment* adjustment);
static void _cheese_preferences_dialog_on_saturation_change_gtk_adjustment_value_changed (GtkAdjustment* _sender, gpointer self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void ___lambda6_ (Block2Data* _data2_, void* device);
static void cheese_preferences_dialog_remove_camera_device (CheesePreferencesDialog* self, GtkTreeIter* iter, CheeseCameraDevice* device_node, CheeseCameraDevice* active_device_node);
static void ____lambda6__gfunc (gconstpointer data, gpointer self);
static void cheese_preferences_dialog_set_new_available_camera_device (CheesePreferencesDialog* self, GtkTreeIter* iter);
void cheese_preferences_dialog_set_current_mode (CheesePreferencesDialog* self, CheeseMediaMode mode);
static void cheese_preferences_dialog_finalize (GObject * obj);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _cheese_preferences_dialog_on_camera_update_num_camera_devices_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	cheese_preferences_dialog_on_camera_update_num_camera_devices ((CheesePreferencesDialog*) self);
}


CheesePreferencesDialog* cheese_preferences_dialog_construct (GType object_type, CheeseCamera* camera) {
	CheesePreferencesDialog * self = NULL;
	GtkSettings* gtk_settings = NULL;
	GtkSettings* _tmp0_;
	GtkSettings* _tmp1_;
	gint _tmp2_ = 0;
	GtkSettings* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	CheeseCamera* _tmp6_;
	CheeseCamera* _tmp7_;
	GSettings* _tmp8_;
	CheeseCamera* _tmp9_;
	g_return_val_if_fail (camera != NULL, NULL);
	_tmp0_ = gtk_settings_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	gtk_settings = _tmp1_;
	_tmp3_ = gtk_settings;
	g_object_get (_tmp3_, "gtk-dialogs-use-header", &_tmp4_, NULL);
	_tmp5_ = _tmp4_;
	if (_tmp5_) {
		_tmp2_ = 1;
	} else {
		_tmp2_ = 0;
	}
	self = (CheesePreferencesDialog*) g_object_new (object_type, "use-header-bar", _tmp2_, NULL);
	_tmp6_ = camera;
	_tmp7_ = _g_object_ref0 (_tmp6_);
	_g_object_unref0 (self->priv->camera);
	self->priv->camera = _tmp7_;
	_tmp8_ = g_settings_new ("org.gnome.Cheese");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp8_;
	cheese_preferences_dialog_setup_combo_box_models (self);
	cheese_preferences_dialog_initialize_camera_devices (self);
	cheese_preferences_dialog_initialize_values_from_settings (self);
	_tmp9_ = camera;
	g_signal_connect_object ((GObject*) _tmp9_, "notify::num-camera-devices", (GCallback) _cheese_preferences_dialog_on_camera_update_num_camera_devices_g_object_notify, self, 0);
	_g_object_unref0 (gtk_settings);
	return self;
}


CheesePreferencesDialog* cheese_preferences_dialog_new (CheeseCamera* camera) {
	return cheese_preferences_dialog_construct (CHEESE_TYPE_PREFERENCES_DIALOG, camera);
}


/**
   * Set up combo box cell renderers.
   */
static void cheese_preferences_dialog_setup_combo_box_models (CheesePreferencesDialog* self) {
	GtkCellRendererText* cell = NULL;
	GtkCellRendererText* _tmp0_;
	GtkComboBox* _tmp1_;
	GtkComboBox* _tmp2_;
	GtkComboBox* _tmp3_;
	GtkComboBox* _tmp4_;
	GtkComboBox* _tmp5_;
	GtkComboBox* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp0_);
	cell = _tmp0_;
	_tmp1_ = self->priv->photo_resolution_combo;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp1_, (GtkCellRenderer*) cell, FALSE);
	_tmp2_ = self->priv->photo_resolution_combo;
	gtk_cell_layout_set_attributes ((GtkCellLayout*) _tmp2_, (GtkCellRenderer*) cell, "text", 0, NULL);
	_tmp3_ = self->priv->video_resolution_combo;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp3_, (GtkCellRenderer*) cell, FALSE);
	_tmp4_ = self->priv->video_resolution_combo;
	gtk_cell_layout_set_attributes ((GtkCellLayout*) _tmp4_, (GtkCellRenderer*) cell, "text", 0, NULL);
	_tmp5_ = self->priv->source_combo;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp5_, (GtkCellRenderer*) cell, FALSE);
	_tmp6_ = self->priv->source_combo;
	gtk_cell_layout_set_attributes ((GtkCellLayout*) _tmp6_, (GtkCellRenderer*) cell, "text", 0, NULL);
	_g_object_unref0 (cell);
}


/**
   * Initialize and populate the camera device combo box model.
   */
static void _cheese_preferences_dialog_add_camera_device_gfunc (gconstpointer data, gpointer self) {
	cheese_preferences_dialog_add_camera_device ((CheesePreferencesDialog*) self, data);
}


static void cheese_preferences_dialog_initialize_camera_devices (CheesePreferencesDialog* self) {
	GPtrArray* devices = NULL;
	CheeseCamera* _tmp0_;
	GPtrArray* _tmp1_;
	GtkListStore* _tmp2_;
	GtkComboBox* _tmp3_;
	GtkListStore* _tmp4_;
	GtkComboBox* _tmp5_;
	GSettings* _tmp6_;
	CheeseCamera* _tmp7_;
	CheeseCameraDevice* _tmp8_;
	const gchar* _tmp9_;
	CheeseCamera* _tmp10_;
	CheeseCameraDevice* _tmp11_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->camera;
	_tmp1_ = cheese_camera_get_camera_devices (_tmp0_);
	devices = _tmp1_;
	_tmp2_ = gtk_list_store_new (2, G_TYPE_STRING, CHEESE_TYPE_CAMERA_DEVICE, -1);
	_g_object_unref0 (self->priv->camera_model);
	self->priv->camera_model = _tmp2_;
	_tmp3_ = self->priv->source_combo;
	_tmp4_ = self->priv->camera_model;
	gtk_combo_box_set_model (_tmp3_, (GtkTreeModel*) _tmp4_);
	_tmp5_ = self->priv->source_combo;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp5_, FALSE);
	g_ptr_array_foreach (devices, _cheese_preferences_dialog_add_camera_device_gfunc, self);
	_tmp6_ = self->priv->settings;
	_tmp7_ = self->priv->camera;
	_tmp8_ = cheese_camera_get_selected_device (_tmp7_);
	_tmp9_ = cheese_camera_device_get_name (_tmp8_);
	g_settings_set_string (_tmp6_, "camera", _tmp9_);
	_tmp10_ = self->priv->camera;
	_tmp11_ = cheese_camera_get_selected_device (_tmp10_);
	cheese_preferences_dialog_setup_resolutions_for_device (self, _tmp11_);
}


/**
   * Initialize and populate the resolution combo box models for the device.
   *
   * @param device the Cheese.CameraDevice for which to enumerate resolutions
   */
static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		CheesePreferencesDialog* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->resolution_model);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}


static void __lambda5_ (Block1Data* _data1_, CheeseVideoFormat* format) {
	CheesePreferencesDialog* self;
	GtkTreeIter iter = {0};
	GtkListStore* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	GtkListStore* _tmp2_;
	GtkTreeIter _tmp3_;
	CheeseVideoFormat* _tmp4_;
	gint _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	CheeseVideoFormat* _tmp10_;
	gint _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	CheeseVideoFormat* _tmp16_;
	gboolean _tmp17_ = FALSE;
	CheeseCamera* _tmp18_;
	CheeseVideoFormat* _tmp19_;
	gint _tmp20_;
	CheeseVideoFormat* _tmp21_;
	gint _tmp22_;
	gboolean _tmp36_ = FALSE;
	GSettings* _tmp37_;
	gint _tmp38_;
	CheeseVideoFormat* _tmp39_;
	gint _tmp40_;
	self = _data1_->self;
	g_return_if_fail (format != NULL);
	_tmp0_ = _data1_->resolution_model;
	gtk_list_store_append (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	_tmp2_ = _data1_->resolution_model;
	_tmp3_ = iter;
	_tmp4_ = format;
	_tmp5_ = _tmp4_->width;
	_tmp6_ = g_strdup_printf ("%i", _tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strconcat (_tmp7_, " × ", NULL);
	_tmp9_ = _tmp8_;
	_tmp10_ = format;
	_tmp11_ = _tmp10_->height;
	_tmp12_ = g_strdup_printf ("%i", _tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_strconcat (_tmp9_, _tmp13_, NULL);
	_tmp15_ = _tmp14_;
	_tmp16_ = format;
	gtk_list_store_set (_tmp2_, &_tmp3_, 0, _tmp15_, 1, _tmp16_, -1);
	_g_free0 (_tmp15_);
	_g_free0 (_tmp13_);
	_g_free0 (_tmp9_);
	_g_free0 (_tmp7_);
	_tmp18_ = self->priv->camera;
	_tmp19_ = cheese_camera_get_current_video_format (_tmp18_);
	_tmp20_ = _tmp19_->width;
	_tmp21_ = format;
	_tmp22_ = _tmp21_->width;
	if (_tmp20_ == _tmp22_) {
		CheeseCamera* _tmp23_;
		CheeseVideoFormat* _tmp24_;
		gint _tmp25_;
		CheeseVideoFormat* _tmp26_;
		gint _tmp27_;
		_tmp23_ = self->priv->camera;
		_tmp24_ = cheese_camera_get_current_video_format (_tmp23_);
		_tmp25_ = _tmp24_->height;
		_tmp26_ = format;
		_tmp27_ = _tmp26_->height;
		_tmp17_ = _tmp25_ == _tmp27_;
	} else {
		_tmp17_ = FALSE;
	}
	if (_tmp17_) {
		GtkComboBox* _tmp28_;
		GtkTreeIter _tmp29_;
		GSettings* _tmp30_;
		CheeseVideoFormat* _tmp31_;
		gint _tmp32_;
		GSettings* _tmp33_;
		CheeseVideoFormat* _tmp34_;
		gint _tmp35_;
		_tmp28_ = self->priv->photo_resolution_combo;
		_tmp29_ = iter;
		gtk_combo_box_set_active_iter (_tmp28_, &_tmp29_);
		_tmp30_ = self->priv->settings;
		_tmp31_ = format;
		_tmp32_ = _tmp31_->width;
		g_settings_set_int (_tmp30_, "photo-x-resolution", _tmp32_);
		_tmp33_ = self->priv->settings;
		_tmp34_ = format;
		_tmp35_ = _tmp34_->height;
		g_settings_set_int (_tmp33_, "photo-y-resolution", _tmp35_);
	}
	_tmp37_ = self->priv->settings;
	_tmp38_ = g_settings_get_int (_tmp37_, "video-x-resolution");
	_tmp39_ = format;
	_tmp40_ = _tmp39_->width;
	if (_tmp38_ == _tmp40_) {
		GSettings* _tmp41_;
		gint _tmp42_;
		CheeseVideoFormat* _tmp43_;
		gint _tmp44_;
		_tmp41_ = self->priv->settings;
		_tmp42_ = g_settings_get_int (_tmp41_, "video-y-resolution");
		_tmp43_ = format;
		_tmp44_ = _tmp43_->height;
		_tmp36_ = _tmp42_ == _tmp44_;
	} else {
		_tmp36_ = FALSE;
	}
	if (_tmp36_) {
		GtkComboBox* _tmp45_;
		GtkTreeIter _tmp46_;
		_tmp45_ = self->priv->video_resolution_combo;
		_tmp46_ = iter;
		gtk_combo_box_set_active_iter (_tmp45_, &_tmp46_);
	}
}


static void ___lambda5__gfunc (gconstpointer data, gpointer self) {
	__lambda5_ (self, (CheeseVideoFormat*) data);
}


static void cheese_preferences_dialog_setup_resolutions_for_device (CheesePreferencesDialog* self, CheeseCameraDevice* device) {
	Block1Data* _data1_;
	GList* formats = NULL;
	CheeseCameraDevice* _tmp0_;
	GList* _tmp1_;
	GtkListStore* _tmp2_;
	GtkComboBox* _tmp3_;
	GtkListStore* _tmp4_;
	GtkComboBox* _tmp5_;
	GtkListStore* _tmp6_;
	GList* _tmp7_;
	GtkComboBox* _tmp8_;
	gint _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (device != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = device;
	_tmp1_ = cheese_camera_device_get_format_list (_tmp0_);
	formats = _tmp1_;
	_tmp2_ = gtk_list_store_new (2, G_TYPE_STRING, CHEESE_TYPE_VIDEO_FORMAT, -1);
	_data1_->resolution_model = _tmp2_;
	_tmp3_ = self->priv->photo_resolution_combo;
	_tmp4_ = _data1_->resolution_model;
	gtk_combo_box_set_model (_tmp3_, (GtkTreeModel*) _tmp4_);
	_tmp5_ = self->priv->video_resolution_combo;
	_tmp6_ = _data1_->resolution_model;
	gtk_combo_box_set_model (_tmp5_, (GtkTreeModel*) _tmp6_);
	_tmp7_ = formats;
	g_list_foreach (_tmp7_, ___lambda5__gfunc, _data1_);
	_tmp8_ = self->priv->video_resolution_combo;
	_tmp9_ = gtk_combo_box_get_active (_tmp8_);
	if (_tmp9_ == -1) {
		GtkComboBox* _tmp10_;
		GtkComboBox* _tmp11_;
		gint _tmp12_;
		GSettings* _tmp13_;
		GSettings* _tmp14_;
		gint _tmp15_;
		GSettings* _tmp16_;
		GSettings* _tmp17_;
		gint _tmp18_;
		_tmp10_ = self->priv->video_resolution_combo;
		_tmp11_ = self->priv->photo_resolution_combo;
		_tmp12_ = gtk_combo_box_get_active (_tmp11_);
		gtk_combo_box_set_active (_tmp10_, _tmp12_);
		_tmp13_ = self->priv->settings;
		_tmp14_ = self->priv->settings;
		_tmp15_ = g_settings_get_int (_tmp14_, "photo-x-resolution");
		g_settings_set_int (_tmp13_, "video-x-resolution", _tmp15_);
		_tmp16_ = self->priv->settings;
		_tmp17_ = self->priv->settings;
		_tmp18_ = g_settings_get_int (_tmp17_, "photo-y-resolution");
		g_settings_set_int (_tmp16_, "video-y-resolution", _tmp18_);
	}
	_g_list_free0 (formats);
	block1_data_unref (_data1_);
	_data1_ = NULL;
}


/**
     * Take the user preferences from GSettings.
     */
static void cheese_preferences_dialog_initialize_values_from_settings (CheesePreferencesDialog* self) {
	GtkAdjustment* _tmp0_;
	GSettings* _tmp1_;
	gdouble _tmp2_;
	GtkAdjustment* _tmp3_;
	GSettings* _tmp4_;
	gdouble _tmp5_;
	GtkAdjustment* _tmp6_;
	GSettings* _tmp7_;
	gdouble _tmp8_;
	GtkAdjustment* _tmp9_;
	GSettings* _tmp10_;
	gdouble _tmp11_;
	GSettings* _tmp12_;
	GtkSpinButton* _tmp13_;
	GtkSpinButton* _tmp14_;
	GSettings* _tmp15_;
	gint _tmp16_;
	GSettings* _tmp17_;
	GtkCheckButton* _tmp18_;
	GSettings* _tmp19_;
	GtkCheckButton* _tmp20_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->brightness_adjustment;
	_tmp1_ = self->priv->settings;
	_tmp2_ = g_settings_get_double (_tmp1_, "brightness");
	gtk_adjustment_set_value (_tmp0_, _tmp2_);
	_tmp3_ = self->priv->contrast_adjustment;
	_tmp4_ = self->priv->settings;
	_tmp5_ = g_settings_get_double (_tmp4_, "contrast");
	gtk_adjustment_set_value (_tmp3_, _tmp5_);
	_tmp6_ = self->priv->hue_adjustment;
	_tmp7_ = self->priv->settings;
	_tmp8_ = g_settings_get_double (_tmp7_, "hue");
	gtk_adjustment_set_value (_tmp6_, _tmp8_);
	_tmp9_ = self->priv->saturation_adjustment;
	_tmp10_ = self->priv->settings;
	_tmp11_ = g_settings_get_double (_tmp10_, "saturation");
	gtk_adjustment_set_value (_tmp9_, _tmp11_);
	_tmp12_ = self->priv->settings;
	_tmp13_ = self->priv->burst_repeat_spin;
	g_settings_bind (_tmp12_, "burst-repeat", (GObject*) _tmp13_, "value", G_SETTINGS_BIND_DEFAULT);
	_tmp14_ = self->priv->burst_delay_spin;
	_tmp15_ = self->priv->settings;
	_tmp16_ = g_settings_get_int (_tmp15_, "burst-delay");
	gtk_spin_button_set_value (_tmp14_, (gdouble) (_tmp16_ / 1000));
	_tmp17_ = self->priv->settings;
	_tmp18_ = self->priv->countdown_check;
	g_settings_bind (_tmp17_, "countdown", (GObject*) _tmp18_, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp19_ = self->priv->settings;
	_tmp20_ = self->priv->flash_check;
	g_settings_bind (_tmp19_, "flash", (GObject*) _tmp20_, "active", G_SETTINGS_BIND_DEFAULT);
}


/**
   * Update the active device to the active iter of the device combo box.
   *
   * @param combo the video device combo box
   */
static void cheese_preferences_dialog_on_source_change (CheesePreferencesDialog* self, GtkComboBox* combo) {
	CheeseCamera* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	GtkTreeIter iter = {0};
	CheeseCameraDevice* dev = NULL;
	GtkComboBox* _tmp3_;
	GtkTreeIter _tmp4_ = {0};
	GtkComboBox* _tmp5_;
	GtkTreeModel* _tmp6_;
	GtkTreeModel* _tmp7_;
	GtkTreeIter _tmp8_;
	CheeseCamera* _tmp9_;
	CheeseCamera* _tmp10_;
	CheeseCamera* _tmp11_;
	CheeseCameraDevice* _tmp12_;
	GSettings* _tmp13_;
	const gchar* _tmp14_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo != NULL);
	_tmp0_ = self->priv->camera;
	g_object_get (_tmp0_, "num-camera-devices", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	g_return_if_fail (_tmp2_ > ((guint) 0));
	_tmp3_ = combo;
	gtk_combo_box_get_active_iter (_tmp3_, &_tmp4_);
	iter = _tmp4_;
	_tmp5_ = combo;
	_tmp6_ = gtk_combo_box_get_model (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = iter;
	gtk_tree_model_get (_tmp7_, &_tmp8_, 1, &dev, -1);
	_tmp9_ = self->priv->camera;
	cheese_camera_set_device (_tmp9_, dev);
	_tmp10_ = self->priv->camera;
	cheese_camera_switch_camera_device (_tmp10_);
	_tmp11_ = self->priv->camera;
	_tmp12_ = cheese_camera_get_selected_device (_tmp11_);
	cheese_preferences_dialog_setup_resolutions_for_device (self, _tmp12_);
	_tmp13_ = self->priv->settings;
	_tmp14_ = cheese_camera_device_get_name (dev);
	g_settings_set_string (_tmp13_, "camera", _tmp14_);
	_g_object_unref0 (dev);
}


static void _cheese_preferences_dialog_on_source_change_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self) {
	cheese_preferences_dialog_on_source_change ((CheesePreferencesDialog*) self, _sender);
}


/**
   * Update the current photo capture resolution to the active iter of the
   * photo resolution combo box.
   *
   * @param combo the photo resolution combo box
   */
static void _vala_CheeseVideoFormat_free (CheeseVideoFormat* self) {
	g_boxed_free (CHEESE_TYPE_VIDEO_FORMAT, self);
}


static void cheese_preferences_dialog_on_photo_resolution_change (CheesePreferencesDialog* self, GtkComboBox* combo) {
	GtkTreeIter iter = {0};
	CheeseVideoFormat* format = NULL;
	GtkComboBox* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	GtkComboBox* _tmp2_;
	GtkTreeModel* _tmp3_;
	GtkTreeModel* _tmp4_;
	GtkTreeIter _tmp5_;
	gboolean _tmp6_ = FALSE;
	CheeseMediaMode _tmp7_;
	GSettings* _tmp11_;
	CheeseVideoFormat* _tmp12_;
	gint _tmp13_;
	GSettings* _tmp14_;
	CheeseVideoFormat* _tmp15_;
	gint _tmp16_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo != NULL);
	_tmp0_ = combo;
	gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	_tmp2_ = combo;
	_tmp3_ = gtk_combo_box_get_model (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = iter;
	gtk_tree_model_get (_tmp4_, &_tmp5_, 1, &format, -1);
	_tmp7_ = self->priv->current_mode;
	if (_tmp7_ == CHEESE_MEDIA_MODE_PHOTO) {
		_tmp6_ = TRUE;
	} else {
		CheeseMediaMode _tmp8_;
		_tmp8_ = self->priv->current_mode;
		_tmp6_ = _tmp8_ == CHEESE_MEDIA_MODE_BURST;
	}
	if (_tmp6_) {
		CheeseCamera* _tmp9_;
		CheeseVideoFormat* _tmp10_;
		_tmp9_ = self->priv->camera;
		_tmp10_ = format;
		cheese_camera_set_video_format (_tmp9_, _tmp10_);
	}
	_tmp11_ = self->priv->settings;
	_tmp12_ = format;
	_tmp13_ = _tmp12_->width;
	g_settings_set_int (_tmp11_, "photo-x-resolution", _tmp13_);
	_tmp14_ = self->priv->settings;
	_tmp15_ = format;
	_tmp16_ = _tmp15_->height;
	g_settings_set_int (_tmp14_, "photo-y-resolution", _tmp16_);
	__vala_CheeseVideoFormat_free0 (format);
}


static void _cheese_preferences_dialog_on_photo_resolution_change_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self) {
	cheese_preferences_dialog_on_photo_resolution_change ((CheesePreferencesDialog*) self, _sender);
}


/**
   * Update the current video capture resolution to the active iter of the
   * video resolution combo box.
   *
   * @param combo the video resolution combo box
   */
static void cheese_preferences_dialog_on_video_resolution_change (CheesePreferencesDialog* self, GtkComboBox* combo) {
	GtkTreeIter iter = {0};
	CheeseVideoFormat* format = NULL;
	GtkComboBox* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	GtkComboBox* _tmp2_;
	GtkTreeModel* _tmp3_;
	GtkTreeModel* _tmp4_;
	GtkTreeIter _tmp5_;
	CheeseMediaMode _tmp6_;
	GSettings* _tmp9_;
	CheeseVideoFormat* _tmp10_;
	gint _tmp11_;
	GSettings* _tmp12_;
	CheeseVideoFormat* _tmp13_;
	gint _tmp14_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo != NULL);
	_tmp0_ = combo;
	gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	_tmp2_ = combo;
	_tmp3_ = gtk_combo_box_get_model (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = iter;
	gtk_tree_model_get (_tmp4_, &_tmp5_, 1, &format, -1);
	_tmp6_ = self->priv->current_mode;
	if (_tmp6_ == CHEESE_MEDIA_MODE_VIDEO) {
		CheeseCamera* _tmp7_;
		CheeseVideoFormat* _tmp8_;
		_tmp7_ = self->priv->camera;
		_tmp8_ = format;
		cheese_camera_set_video_format (_tmp7_, _tmp8_);
	}
	_tmp9_ = self->priv->settings;
	_tmp10_ = format;
	_tmp11_ = _tmp10_->width;
	g_settings_set_int (_tmp9_, "video-x-resolution", _tmp11_);
	_tmp12_ = self->priv->settings;
	_tmp13_ = format;
	_tmp14_ = _tmp13_->height;
	g_settings_set_int (_tmp12_, "video-y-resolution", _tmp14_);
	__vala_CheeseVideoFormat_free0 (format);
}


static void _cheese_preferences_dialog_on_video_resolution_change_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self) {
	cheese_preferences_dialog_on_video_resolution_change ((CheesePreferencesDialog*) self, _sender);
}


/**
    * Hide the dialog when it is closed, rather than deleting it.
    */
static gboolean cheese_preferences_dialog_on_delete (CheesePreferencesDialog* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = gtk_widget_hide_on_delete ((GtkWidget*) self);
	result = _tmp0_;
	return result;
}


static gboolean _cheese_preferences_dialog_on_delete_gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self) {
	gboolean result;
	result = cheese_preferences_dialog_on_delete ((CheesePreferencesDialog*) self);
	return result;
}


/**
    * Hide the dialog when it is closed, rather than deleting it.
    */
static void cheese_preferences_dialog_on_dialog_close (CheesePreferencesDialog* self, GtkButton* button) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	gtk_widget_hide ((GtkWidget*) self);
}


static void _cheese_preferences_dialog_on_dialog_close_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	cheese_preferences_dialog_on_dialog_close ((CheesePreferencesDialog*) self, _sender);
}


/**
    * Show the help for the preferences dialog.
    *
    * @param button the help button
    */
static void cheese_preferences_dialog_on_dialog_help (CheesePreferencesDialog* self, GtkButton* button) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	{
		GdkScreen* _tmp0_;
		_tmp0_ = gtk_window_get_screen ((GtkWindow*) self);
		gtk_show_uri (_tmp0_, "help:cheese/index#preferences", (guint32) GDK_CURRENT_TIME, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch3_g_error;
		}
	}
	goto __finally3;
	__catch3_g_error:
	{
		g_clear_error (&_inner_error_);
		_inner_error_ = NULL;
		g_warning ("cheese-preferences.vala:284: %s", "Error showing help");
	}
	__finally3:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void _cheese_preferences_dialog_on_dialog_help_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	cheese_preferences_dialog_on_dialog_help ((CheesePreferencesDialog*) self, _sender);
}


/**
   * Change the burst-delay GSetting when changing the spin button.
   *
   * The burst delay is the time, in milliseconds, between individual photos in
   * a burst.
   *
   * @param spinbutton the burst-delay spin button
   */
static void cheese_preferences_dialog_on_burst_delay_change (CheesePreferencesDialog* self, GtkSpinButton* spinbutton) {
	GSettings* _tmp0_;
	GtkSpinButton* _tmp1_;
	gdouble _tmp2_;
	gdouble _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (spinbutton != NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = spinbutton;
	_tmp2_ = gtk_spin_button_get_value (_tmp1_);
	_tmp3_ = _tmp2_;
	g_settings_set_int (_tmp0_, "burst-delay", ((gint) _tmp3_) * 1000);
}


static void _cheese_preferences_dialog_on_burst_delay_change_gtk_spin_button_value_changed (GtkSpinButton* _sender, gpointer self) {
	cheese_preferences_dialog_on_burst_delay_change ((CheesePreferencesDialog*) self, _sender);
}


/**
   * Change the brightness of the image, and update the GSetting, when changing
   * the scale.
   *
   * @param adjustment the adjustment of the brightness Gtk.Scale
   */
static void cheese_preferences_dialog_on_brightness_change (CheesePreferencesDialog* self, GtkAdjustment* adjustment) {
	CheeseCamera* _tmp0_;
	GtkAdjustment* _tmp1_;
	gdouble _tmp2_;
	gdouble _tmp3_;
	GSettings* _tmp4_;
	GtkAdjustment* _tmp5_;
	gdouble _tmp6_;
	gdouble _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (adjustment != NULL);
	_tmp0_ = self->priv->camera;
	_tmp1_ = adjustment;
	_tmp2_ = gtk_adjustment_get_value (_tmp1_);
	_tmp3_ = _tmp2_;
	cheese_camera_set_balance_property (_tmp0_, "brightness", _tmp3_);
	_tmp4_ = self->priv->settings;
	_tmp5_ = adjustment;
	_tmp6_ = gtk_adjustment_get_value (_tmp5_);
	_tmp7_ = _tmp6_;
	g_settings_set_double (_tmp4_, "brightness", _tmp7_);
}


static void _cheese_preferences_dialog_on_brightness_change_gtk_adjustment_value_changed (GtkAdjustment* _sender, gpointer self) {
	cheese_preferences_dialog_on_brightness_change ((CheesePreferencesDialog*) self, _sender);
}


/**
   * Change the contrast of the image, and update the GSetting, when changing
   * the scale.
   *
   * @param adjustment the adjustment of the contrast Gtk.Scale
   */
static void cheese_preferences_dialog_on_contrast_change (CheesePreferencesDialog* self, GtkAdjustment* adjustment) {
	CheeseCamera* _tmp0_;
	GtkAdjustment* _tmp1_;
	gdouble _tmp2_;
	gdouble _tmp3_;
	GSettings* _tmp4_;
	GtkAdjustment* _tmp5_;
	gdouble _tmp6_;
	gdouble _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (adjustment != NULL);
	_tmp0_ = self->priv->camera;
	_tmp1_ = adjustment;
	_tmp2_ = gtk_adjustment_get_value (_tmp1_);
	_tmp3_ = _tmp2_;
	cheese_camera_set_balance_property (_tmp0_, "contrast", _tmp3_);
	_tmp4_ = self->priv->settings;
	_tmp5_ = adjustment;
	_tmp6_ = gtk_adjustment_get_value (_tmp5_);
	_tmp7_ = _tmp6_;
	g_settings_set_double (_tmp4_, "contrast", _tmp7_);
}


static void _cheese_preferences_dialog_on_contrast_change_gtk_adjustment_value_changed (GtkAdjustment* _sender, gpointer self) {
	cheese_preferences_dialog_on_contrast_change ((CheesePreferencesDialog*) self, _sender);
}


/**
   * Change the hue of the image, and update the GSetting, when changing the
   * scale.
   *
   * @param adjustment the adjustment of the hue Gtk.Scale
   */
static void cheese_preferences_dialog_on_hue_change (CheesePreferencesDialog* self, GtkAdjustment* adjustment) {
	CheeseCamera* _tmp0_;
	GtkAdjustment* _tmp1_;
	gdouble _tmp2_;
	gdouble _tmp3_;
	GSettings* _tmp4_;
	GtkAdjustment* _tmp5_;
	gdouble _tmp6_;
	gdouble _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (adjustment != NULL);
	_tmp0_ = self->priv->camera;
	_tmp1_ = adjustment;
	_tmp2_ = gtk_adjustment_get_value (_tmp1_);
	_tmp3_ = _tmp2_;
	cheese_camera_set_balance_property (_tmp0_, "hue", _tmp3_);
	_tmp4_ = self->priv->settings;
	_tmp5_ = adjustment;
	_tmp6_ = gtk_adjustment_get_value (_tmp5_);
	_tmp7_ = _tmp6_;
	g_settings_set_double (_tmp4_, "hue", _tmp7_);
}


static void _cheese_preferences_dialog_on_hue_change_gtk_adjustment_value_changed (GtkAdjustment* _sender, gpointer self) {
	cheese_preferences_dialog_on_hue_change ((CheesePreferencesDialog*) self, _sender);
}


/**
   * Change the saturation of the image, and update the GSetting, when changing
   * the scale.
   *
   * @param adjustment the adjustment of the saturation Gtk.Scale
   */
static void cheese_preferences_dialog_on_saturation_change (CheesePreferencesDialog* self, GtkAdjustment* adjustment) {
	CheeseCamera* _tmp0_;
	GtkAdjustment* _tmp1_;
	gdouble _tmp2_;
	gdouble _tmp3_;
	GSettings* _tmp4_;
	GtkAdjustment* _tmp5_;
	gdouble _tmp6_;
	gdouble _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (adjustment != NULL);
	_tmp0_ = self->priv->camera;
	_tmp1_ = adjustment;
	_tmp2_ = gtk_adjustment_get_value (_tmp1_);
	_tmp3_ = _tmp2_;
	cheese_camera_set_balance_property (_tmp0_, "saturation", _tmp3_);
	_tmp4_ = self->priv->settings;
	_tmp5_ = adjustment;
	_tmp6_ = gtk_adjustment_get_value (_tmp5_);
	_tmp7_ = _tmp6_;
	g_settings_set_double (_tmp4_, "saturation", _tmp7_);
}


static void _cheese_preferences_dialog_on_saturation_change_gtk_adjustment_value_changed (GtkAdjustment* _sender, gpointer self) {
	cheese_preferences_dialog_on_saturation_change ((CheesePreferencesDialog*) self, _sender);
}


/**
   * Update the video device combo box when a camera device was added or
   * removed.
   */
static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		CheesePreferencesDialog* self;
		self = _data2_->self;
		_g_object_unref0 (_data2_->active_device);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}


static void ___lambda6_ (Block2Data* _data2_, void* device) {
	CheesePreferencesDialog* self;
	CheeseCameraDevice* old_device = NULL;
	void* _tmp0_;
	CheeseCameraDevice* _tmp1_;
	CheeseCameraDevice* new_device = NULL;
	GtkListStore* _tmp2_;
	GtkTreeIter _tmp3_;
	CheeseCameraDevice* _tmp4_;
	CheeseCameraDevice* _tmp5_;
	GtkListStore* _tmp9_;
	self = _data2_->self;
	_tmp0_ = device;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, CHEESE_TYPE_CAMERA_DEVICE, CheeseCameraDevice));
	old_device = _tmp1_;
	_tmp2_ = self->priv->camera_model;
	_tmp3_ = _data2_->iter;
	gtk_tree_model_get ((GtkTreeModel*) _tmp2_, &_tmp3_, 1, &new_device, -1, -1);
	_tmp4_ = old_device;
	_tmp5_ = new_device;
	if (_tmp4_ != _tmp5_) {
		GtkTreeIter _tmp6_;
		CheeseCameraDevice* _tmp7_;
		CheeseCameraDevice* _tmp8_;
		_tmp6_ = _data2_->iter;
		_tmp7_ = new_device;
		_tmp8_ = _data2_->active_device;
		cheese_preferences_dialog_remove_camera_device (self, &_tmp6_, _tmp7_, _tmp8_);
		_data2_->device_removed = TRUE;
		_g_object_unref0 (new_device);
		_g_object_unref0 (old_device);
		return;
	}
	_tmp9_ = self->priv->camera_model;
	gtk_tree_model_iter_next ((GtkTreeModel*) _tmp9_, &_data2_->iter);
	_g_object_unref0 (new_device);
	_g_object_unref0 (old_device);
}


static void ____lambda6__gfunc (gconstpointer data, gpointer self) {
	___lambda6_ (self, data);
}


static void cheese_preferences_dialog_on_camera_update_num_camera_devices (CheesePreferencesDialog* self) {
	GPtrArray* devices = NULL;
	CheeseCamera* _tmp0_;
	GPtrArray* _tmp1_;
	CheeseCameraDevice* dev = NULL;
	GPtrArray* _tmp2_;
	guint _tmp3_;
	GtkListStore* _tmp4_;
	gint _tmp5_;
	GSettings* _tmp25_;
	CheeseCamera* _tmp26_;
	CheeseCameraDevice* _tmp27_;
	const gchar* _tmp28_;
	CheeseCamera* _tmp29_;
	CheeseCameraDevice* _tmp30_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->camera;
	_tmp1_ = cheese_camera_get_camera_devices (_tmp0_);
	devices = _tmp1_;
	_tmp2_ = devices;
	_tmp3_ = _tmp2_->len;
	_tmp4_ = self->priv->camera_model;
	_tmp5_ = gtk_tree_model_iter_n_children ((GtkTreeModel*) _tmp4_, NULL);
	if (_tmp3_ > ((guint) _tmp5_)) {
		GPtrArray* _tmp6_;
		GPtrArray* _tmp7_;
		guint _tmp8_;
		void* _tmp9_;
		CheeseCameraDevice* _tmp10_;
		CheeseCameraDevice* _tmp11_;
		_tmp6_ = devices;
		_tmp7_ = devices;
		_tmp8_ = _tmp7_->len;
		_tmp9_ = g_ptr_array_index (_tmp6_, _tmp8_ - 1);
		_tmp10_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, CHEESE_TYPE_CAMERA_DEVICE, CheeseCameraDevice));
		_g_object_unref0 (dev);
		dev = _tmp10_;
		_tmp11_ = dev;
		cheese_preferences_dialog_add_camera_device (self, _tmp11_);
	} else {
		Block2Data* _data2_;
		GtkListStore* _tmp12_;
		GtkTreeIter _tmp13_ = {0};
		GtkTreeIter active_iter = {0};
		GtkComboBox* _tmp14_;
		GtkTreeIter _tmp15_ = {0};
		GtkListStore* _tmp16_;
		GtkTreeIter _tmp17_;
		GPtrArray* _tmp18_;
		gboolean _tmp19_;
		_data2_ = g_slice_new0 (Block2Data);
		_data2_->_ref_count_ = 1;
		_data2_->self = g_object_ref (self);
		_tmp12_ = self->priv->camera_model;
		gtk_tree_model_get_iter_first ((GtkTreeModel*) _tmp12_, &_tmp13_);
		_data2_->iter = _tmp13_;
		_tmp14_ = self->priv->source_combo;
		gtk_combo_box_get_active_iter (_tmp14_, &_tmp15_);
		active_iter = _tmp15_;
		_tmp16_ = self->priv->camera_model;
		_tmp17_ = active_iter;
		gtk_tree_model_get ((GtkTreeModel*) _tmp16_, &_tmp17_, 1, &_data2_->active_device, -1, -1);
		_data2_->device_removed = FALSE;
		_tmp18_ = devices;
		g_ptr_array_foreach (_tmp18_, ____lambda6__gfunc, _data2_);
		_tmp19_ = _data2_->device_removed;
		if (!_tmp19_) {
			CheeseCameraDevice* old_device = NULL;
			GtkListStore* _tmp20_;
			GtkTreeIter _tmp21_;
			GtkTreeIter _tmp22_;
			CheeseCameraDevice* _tmp23_;
			CheeseCameraDevice* _tmp24_;
			_tmp20_ = self->priv->camera_model;
			_tmp21_ = _data2_->iter;
			gtk_tree_model_get ((GtkTreeModel*) _tmp20_, &_tmp21_, 1, &old_device, -1, -1);
			_tmp22_ = _data2_->iter;
			_tmp23_ = old_device;
			_tmp24_ = _data2_->active_device;
			cheese_preferences_dialog_remove_camera_device (self, &_tmp22_, _tmp23_, _tmp24_);
			_g_object_unref0 (old_device);
		}
		block2_data_unref (_data2_);
		_data2_ = NULL;
	}
	_tmp25_ = self->priv->settings;
	_tmp26_ = self->priv->camera;
	_tmp27_ = cheese_camera_get_selected_device (_tmp26_);
	_tmp28_ = cheese_camera_device_get_name (_tmp27_);
	g_settings_set_string (_tmp25_, "camera", _tmp28_);
	_tmp29_ = self->priv->camera;
	_tmp30_ = cheese_camera_get_selected_device (_tmp29_);
	cheese_preferences_dialog_setup_resolutions_for_device (self, _tmp30_);
	_g_object_unref0 (dev);
}


/**
   * Add the supplied camera device to the device combo box model.
   *
   * This method is intended to be used with the foreach method of GLib
   * containers.
   *
   * @param device a Cheese.CameraDevice to add to the device combo box model
   */
static void cheese_preferences_dialog_add_camera_device (CheesePreferencesDialog* self, void* device) {
	GtkTreeIter iter = {0};
	CheeseCameraDevice* dev = NULL;
	void* _tmp0_;
	CheeseCameraDevice* _tmp1_;
	GtkListStore* _tmp2_;
	GtkTreeIter _tmp3_ = {0};
	GtkListStore* _tmp4_;
	GtkTreeIter _tmp5_;
	CheeseCameraDevice* _tmp6_;
	const gchar* _tmp7_;
	CheeseCameraDevice* _tmp8_;
	CheeseCamera* _tmp9_;
	CheeseCameraDevice* _tmp10_;
	CheeseCameraDevice* _tmp11_;
	GtkListStore* _tmp14_;
	gint _tmp15_;
	g_return_if_fail (self != NULL);
	_tmp0_ = device;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, CHEESE_TYPE_CAMERA_DEVICE, CheeseCameraDevice));
	dev = _tmp1_;
	_tmp2_ = self->priv->camera_model;
	gtk_list_store_append (_tmp2_, &_tmp3_);
	iter = _tmp3_;
	_tmp4_ = self->priv->camera_model;
	_tmp5_ = iter;
	_tmp6_ = dev;
	_tmp7_ = cheese_camera_device_get_name (_tmp6_);
	_tmp8_ = dev;
	gtk_list_store_set (_tmp4_, &_tmp5_, 0, _tmp7_, 1, _tmp8_, -1);
	_tmp9_ = self->priv->camera;
	_tmp10_ = cheese_camera_get_selected_device (_tmp9_);
	_tmp11_ = dev;
	if (_tmp10_ == _tmp11_) {
		GtkComboBox* _tmp12_;
		GtkTreeIter _tmp13_;
		_tmp12_ = self->priv->source_combo;
		_tmp13_ = iter;
		gtk_combo_box_set_active_iter (_tmp12_, &_tmp13_);
	}
	_tmp14_ = self->priv->camera_model;
	_tmp15_ = gtk_tree_model_iter_n_children ((GtkTreeModel*) _tmp14_, NULL);
	if (_tmp15_ > 1) {
		GtkComboBox* _tmp16_;
		_tmp16_ = self->priv->source_combo;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp16_, TRUE);
	}
	_g_object_unref0 (dev);
}


/**
   * Remove the supplied camera device from the device combo box model.
   *
   * @param iter the iterator of the device to remove
   * @param device_node the device to remove from the combo box model
   * @param active_device_node the currently-active camera device
   */
static void cheese_preferences_dialog_remove_camera_device (CheesePreferencesDialog* self, GtkTreeIter* iter, CheeseCameraDevice* device_node, CheeseCameraDevice* active_device_node) {
	GPtrArray* devices = NULL;
	CheeseCamera* _tmp0_;
	GPtrArray* _tmp1_;
	CheeseCameraDevice* _tmp2_;
	CheeseCameraDevice* _tmp3_;
	GtkListStore* _tmp7_;
	GtkListStore* _tmp8_;
	gint _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (iter != NULL);
	g_return_if_fail (device_node != NULL);
	g_return_if_fail (active_device_node != NULL);
	_tmp0_ = self->priv->camera;
	_tmp1_ = cheese_camera_get_camera_devices (_tmp0_);
	devices = _tmp1_;
	_tmp2_ = device_node;
	_tmp3_ = active_device_node;
	if (_tmp2_ == _tmp3_) {
		GPtrArray* _tmp4_;
		guint _tmp5_;
		_tmp4_ = devices;
		_tmp5_ = _tmp4_->len;
		if (_tmp5_ > ((guint) 0)) {
			GtkTreeIter _tmp6_;
			_tmp6_ = *iter;
			cheese_preferences_dialog_set_new_available_camera_device (self, &_tmp6_);
		} else {
			gtk_widget_hide ((GtkWidget*) self);
		}
	}
	_tmp7_ = self->priv->camera_model;
	gtk_list_store_remove (_tmp7_, iter);
	_tmp8_ = self->priv->camera_model;
	_tmp9_ = gtk_tree_model_iter_n_children ((GtkTreeModel*) _tmp8_, NULL);
	if (_tmp9_ <= 1) {
		GtkComboBox* _tmp10_;
		_tmp10_ = self->priv->source_combo;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp10_, FALSE);
	}
}


/**
   * Search for an available camera device and activate it in the device combo
   * box model.
   *
   * @param iter a device in the combo box model to search either side of
   */
static void cheese_preferences_dialog_set_new_available_camera_device (CheesePreferencesDialog* self, GtkTreeIter* iter) {
	GtkTreeIter new_iter = {0};
	GtkTreeIter _tmp0_;
	GtkListStore* _tmp1_;
	gboolean _tmp2_;
	GtkComboBox* _tmp5_;
	GtkTreeIter _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (iter != NULL);
	_tmp0_ = *iter;
	new_iter = _tmp0_;
	_tmp1_ = self->priv->camera_model;
	_tmp2_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp1_, &new_iter);
	if (!_tmp2_) {
		GtkTreeIter _tmp3_;
		GtkListStore* _tmp4_;
		_tmp3_ = *iter;
		new_iter = _tmp3_;
		_tmp4_ = self->priv->camera_model;
		gtk_tree_model_iter_previous ((GtkTreeModel*) _tmp4_, &new_iter);
	}
	_tmp5_ = self->priv->source_combo;
	_tmp6_ = new_iter;
	gtk_combo_box_set_active_iter (_tmp5_, &_tmp6_);
}


/**
     * Set the current media mode (photo, video or burst).
     *
     * The current mode is used to update the video format on the Cheese.Camera
     * when the resolution for the current mode is changed.
     *
     * @param mode the media mode to set
     */
void cheese_preferences_dialog_set_current_mode (CheesePreferencesDialog* self, CheeseMediaMode mode) {
	CheeseMediaMode _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = mode;
	self->priv->current_mode = _tmp0_;
}


static void cheese_preferences_dialog_class_init (CheesePreferencesDialogClass * klass) {
	gint CheesePreferencesDialog_private_offset;
	cheese_preferences_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (CheesePreferencesDialogPrivate));
	G_OBJECT_CLASS (klass)->finalize = cheese_preferences_dialog_finalize;
	CheesePreferencesDialog_private_offset = g_type_class_get_instance_private_offset (klass);
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/Cheese/cheese-prefs.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "photo_resolution_combo", FALSE, CheesePreferencesDialog_private_offset + G_STRUCT_OFFSET (CheesePreferencesDialogPrivate, photo_resolution_combo));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "video_resolution_combo", FALSE, CheesePreferencesDialog_private_offset + G_STRUCT_OFFSET (CheesePreferencesDialogPrivate, video_resolution_combo));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "source_combo", FALSE, CheesePreferencesDialog_private_offset + G_STRUCT_OFFSET (CheesePreferencesDialogPrivate, source_combo));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "brightness_adjustment", FALSE, CheesePreferencesDialog_private_offset + G_STRUCT_OFFSET (CheesePreferencesDialogPrivate, brightness_adjustment));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "contrast_adjustment", FALSE, CheesePreferencesDialog_private_offset + G_STRUCT_OFFSET (CheesePreferencesDialogPrivate, contrast_adjustment));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "hue_adjustment", FALSE, CheesePreferencesDialog_private_offset + G_STRUCT_OFFSET (CheesePreferencesDialogPrivate, hue_adjustment));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "saturation_adjustment", FALSE, CheesePreferencesDialog_private_offset + G_STRUCT_OFFSET (CheesePreferencesDialogPrivate, saturation_adjustment));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "burst_repeat_spin", FALSE, CheesePreferencesDialog_private_offset + G_STRUCT_OFFSET (CheesePreferencesDialogPrivate, burst_repeat_spin));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "burst_delay_spin", FALSE, CheesePreferencesDialog_private_offset + G_STRUCT_OFFSET (CheesePreferencesDialogPrivate, burst_delay_spin));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "countdown_check", FALSE, CheesePreferencesDialog_private_offset + G_STRUCT_OFFSET (CheesePreferencesDialogPrivate, countdown_check));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "flash_check", FALSE, CheesePreferencesDialog_private_offset + G_STRUCT_OFFSET (CheesePreferencesDialogPrivate, flash_check));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_source_change", G_CALLBACK(_cheese_preferences_dialog_on_source_change_gtk_combo_box_changed));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_photo_resolution_change", G_CALLBACK(_cheese_preferences_dialog_on_photo_resolution_change_gtk_combo_box_changed));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_video_resolution_change", G_CALLBACK(_cheese_preferences_dialog_on_video_resolution_change_gtk_combo_box_changed));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_delete", G_CALLBACK(_cheese_preferences_dialog_on_delete_gtk_widget_delete_event));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_dialog_close", G_CALLBACK(_cheese_preferences_dialog_on_dialog_close_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_dialog_help", G_CALLBACK(_cheese_preferences_dialog_on_dialog_help_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_burst_delay_change", G_CALLBACK(_cheese_preferences_dialog_on_burst_delay_change_gtk_spin_button_value_changed));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_brightness_change", G_CALLBACK(_cheese_preferences_dialog_on_brightness_change_gtk_adjustment_value_changed));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_contrast_change", G_CALLBACK(_cheese_preferences_dialog_on_contrast_change_gtk_adjustment_value_changed));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_hue_change", G_CALLBACK(_cheese_preferences_dialog_on_hue_change_gtk_adjustment_value_changed));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_saturation_change", G_CALLBACK(_cheese_preferences_dialog_on_saturation_change_gtk_adjustment_value_changed));
}


static void cheese_preferences_dialog_instance_init (CheesePreferencesDialog * self) {
	self->priv = CHEESE_PREFERENCES_DIALOG_GET_PRIVATE (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}


static void cheese_preferences_dialog_finalize (GObject * obj) {
	CheesePreferencesDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CHEESE_TYPE_PREFERENCES_DIALOG, CheesePreferencesDialog);
	_g_object_unref0 (self->priv->camera);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->photo_resolution_combo);
	_g_object_unref0 (self->priv->video_resolution_combo);
	_g_object_unref0 (self->priv->source_combo);
	_g_object_unref0 (self->priv->camera_model);
	_g_object_unref0 (self->priv->brightness_adjustment);
	_g_object_unref0 (self->priv->contrast_adjustment);
	_g_object_unref0 (self->priv->hue_adjustment);
	_g_object_unref0 (self->priv->saturation_adjustment);
	_g_object_unref0 (self->priv->burst_repeat_spin);
	_g_object_unref0 (self->priv->burst_delay_spin);
	_g_object_unref0 (self->priv->countdown_check);
	_g_object_unref0 (self->priv->flash_check);
	G_OBJECT_CLASS (cheese_preferences_dialog_parent_class)->finalize (obj);
}


GType cheese_preferences_dialog_get_type (void) {
	static volatile gsize cheese_preferences_dialog_type_id__volatile = 0;
	if (g_once_init_enter (&cheese_preferences_dialog_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CheesePreferencesDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) cheese_preferences_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CheesePreferencesDialog), 0, (GInstanceInitFunc) cheese_preferences_dialog_instance_init, NULL };
		GType cheese_preferences_dialog_type_id;
		cheese_preferences_dialog_type_id = g_type_register_static (gtk_dialog_get_type (), "CheesePreferencesDialog", &g_define_type_info, 0);
		g_once_init_leave (&cheese_preferences_dialog_type_id__volatile, cheese_preferences_dialog_type_id);
	}
	return cheese_preferences_dialog_type_id__volatile;
}



