/* valaobjectcreationexpression.c generated by valac, the Vala compiler
 * generated from valaobjectcreationexpression.vala, do not modify */

/* valaobjectcreationexpression.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <valagee.h>
#include <stdlib.h>
#include <string.h>

enum  {
	VALA_OBJECT_CREATION_EXPRESSION_DUMMY_PROPERTY,
	VALA_OBJECT_CREATION_EXPRESSION_LAST_PROPERTY
};
static GParamSpec* vala_object_creation_expression_properties[VALA_OBJECT_CREATION_EXPRESSION_LAST_PROPERTY];
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))

struct _ValaObjectCreationExpressionPrivate {
	ValaMemberAccess* _member_name;
	gboolean _is_yield_expression;
	gboolean _struct_creation;
	ValaList* argument_list;
	ValaList* object_initializer;
	ValaDataType* _data_type;
};


static gpointer vala_object_creation_expression_parent_class = NULL;

#define VALA_OBJECT_CREATION_EXPRESSION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_OBJECT_CREATION_EXPRESSION, ValaObjectCreationExpressionPrivate))
static void vala_object_creation_expression_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_object_creation_expression_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_object_creation_expression_real_replace_expression (ValaCodeNode* base, ValaExpression* old_node, ValaExpression* new_node);
static gboolean vala_object_creation_expression_real_is_pure (ValaExpression* base);
static gboolean vala_object_creation_expression_real_is_accessible (ValaExpression* base, ValaSymbol* sym);
static void vala_object_creation_expression_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type);
static gboolean vala_object_creation_expression_real_check (ValaCodeNode* base, ValaCodeContext* context);
static void vala_object_creation_expression_real_emit (ValaCodeNode* base, ValaCodeGenerator* codegen);
static void vala_object_creation_expression_real_get_defined_variables (ValaCodeNode* base, ValaCollection* collection);
static void vala_object_creation_expression_real_get_used_variables (ValaCodeNode* base, ValaCollection* collection);
static void vala_object_creation_expression_finalize (ValaCodeNode * obj);


/**
 * Creates a new object creation expression.
 *
 * @param member_name      object type to create
 * @param source_reference reference to source code
 * @return                 newly created object creation expression
 */
ValaObjectCreationExpression* vala_object_creation_expression_construct (GType object_type, ValaMemberAccess* member_name, ValaSourceReference* source_reference) {
	ValaObjectCreationExpression* self = NULL;
	ValaSourceReference* _tmp0_;
	ValaMemberAccess* _tmp1_;
	g_return_val_if_fail (member_name != NULL, NULL);
	g_return_val_if_fail (source_reference != NULL, NULL);
	self = (ValaObjectCreationExpression*) vala_expression_construct (object_type);
	_tmp0_ = source_reference;
	vala_code_node_set_source_reference ((ValaCodeNode*) self, _tmp0_);
	_tmp1_ = member_name;
	vala_object_creation_expression_set_member_name (self, _tmp1_);
	return self;
}


ValaObjectCreationExpression* vala_object_creation_expression_new (ValaMemberAccess* member_name, ValaSourceReference* source_reference) {
	return vala_object_creation_expression_construct (VALA_TYPE_OBJECT_CREATION_EXPRESSION, member_name, source_reference);
}


/**
 * Appends the specified expression to the list of arguments.
 *
 * @param arg an argument
 */
void vala_object_creation_expression_add_argument (ValaObjectCreationExpression* self, ValaExpression* arg) {
	ValaList* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (arg != NULL);
	_tmp0_ = self->priv->argument_list;
	_tmp1_ = arg;
	vala_collection_add ((ValaCollection*) _tmp0_, _tmp1_);
	_tmp2_ = arg;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
}


/**
 * Returns a copy of the argument list.
 *
 * @return argument list
 */
static gpointer _vala_iterable_ref0 (gpointer self) {
	return self ? vala_iterable_ref (self) : NULL;
}


ValaList* vala_object_creation_expression_get_argument_list (ValaObjectCreationExpression* self) {
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->argument_list;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Appends the specified member initializer to the object initializer.
 *
 * @param init a member initializer
 */
void vala_object_creation_expression_add_member_initializer (ValaObjectCreationExpression* self, ValaMemberInitializer* init) {
	ValaList* _tmp0_;
	ValaMemberInitializer* _tmp1_;
	ValaMemberInitializer* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (init != NULL);
	_tmp0_ = self->priv->object_initializer;
	_tmp1_ = init;
	vala_collection_add ((ValaCollection*) _tmp0_, _tmp1_);
	_tmp2_ = init;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
}


/**
 * Returns the object initializer.
 *
 * @return member initializer list
 */
ValaList* vala_object_creation_expression_get_object_initializer (ValaObjectCreationExpression* self) {
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->object_initializer;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


static void vala_object_creation_expression_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaObjectCreationExpression * self;
	ValaCodeVisitor* _tmp0_;
	ValaCodeVisitor* _tmp1_;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = visitor;
	vala_code_visitor_visit_object_creation_expression (_tmp0_, self);
	_tmp1_ = visitor;
	vala_code_visitor_visit_expression (_tmp1_, (ValaExpression*) self);
}


static void vala_object_creation_expression_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaObjectCreationExpression * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaMemberAccess* _tmp5_;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_object_creation_expression_get_type_reference (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaDataType* _tmp2_;
		ValaDataType* _tmp3_;
		ValaCodeVisitor* _tmp4_;
		_tmp2_ = vala_object_creation_expression_get_type_reference (self);
		_tmp3_ = _tmp2_;
		_tmp4_ = visitor;
		vala_code_node_accept ((ValaCodeNode*) _tmp3_, _tmp4_);
	}
	_tmp5_ = self->priv->_member_name;
	if (_tmp5_ != NULL) {
		ValaMemberAccess* _tmp6_;
		ValaCodeVisitor* _tmp7_;
		_tmp6_ = self->priv->_member_name;
		_tmp7_ = visitor;
		vala_code_node_accept ((ValaCodeNode*) _tmp6_, _tmp7_);
	}
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp8_;
		ValaList* _tmp9_;
		gint _arg_size = 0;
		ValaList* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _arg_index = 0;
		_tmp8_ = self->priv->argument_list;
		_tmp9_ = _vala_iterable_ref0 (_tmp8_);
		_arg_list = _tmp9_;
		_tmp10_ = _arg_list;
		_tmp11_ = vala_collection_get_size ((ValaCollection*) _tmp10_);
		_tmp12_ = _tmp11_;
		_arg_size = _tmp12_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp13_;
			gint _tmp14_;
			gint _tmp15_;
			ValaExpression* arg = NULL;
			ValaList* _tmp16_;
			gint _tmp17_;
			gpointer _tmp18_;
			ValaExpression* _tmp19_;
			ValaCodeVisitor* _tmp20_;
			_tmp13_ = _arg_index;
			_arg_index = _tmp13_ + 1;
			_tmp14_ = _arg_index;
			_tmp15_ = _arg_size;
			if (!(_tmp14_ < _tmp15_)) {
				break;
			}
			_tmp16_ = _arg_list;
			_tmp17_ = _arg_index;
			_tmp18_ = vala_list_get (_tmp16_, _tmp17_);
			arg = (ValaExpression*) _tmp18_;
			_tmp19_ = arg;
			_tmp20_ = visitor;
			vala_code_node_accept ((ValaCodeNode*) _tmp19_, _tmp20_);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	{
		ValaList* _init_list = NULL;
		ValaList* _tmp21_;
		ValaList* _tmp22_;
		gint _init_size = 0;
		ValaList* _tmp23_;
		gint _tmp24_;
		gint _tmp25_;
		gint _init_index = 0;
		_tmp21_ = self->priv->object_initializer;
		_tmp22_ = _vala_iterable_ref0 (_tmp21_);
		_init_list = _tmp22_;
		_tmp23_ = _init_list;
		_tmp24_ = vala_collection_get_size ((ValaCollection*) _tmp23_);
		_tmp25_ = _tmp24_;
		_init_size = _tmp25_;
		_init_index = -1;
		while (TRUE) {
			gint _tmp26_;
			gint _tmp27_;
			gint _tmp28_;
			ValaMemberInitializer* init = NULL;
			ValaList* _tmp29_;
			gint _tmp30_;
			gpointer _tmp31_;
			ValaMemberInitializer* _tmp32_;
			ValaCodeVisitor* _tmp33_;
			_tmp26_ = _init_index;
			_init_index = _tmp26_ + 1;
			_tmp27_ = _init_index;
			_tmp28_ = _init_size;
			if (!(_tmp27_ < _tmp28_)) {
				break;
			}
			_tmp29_ = _init_list;
			_tmp30_ = _init_index;
			_tmp31_ = vala_list_get (_tmp29_, _tmp30_);
			init = (ValaMemberInitializer*) _tmp31_;
			_tmp32_ = init;
			_tmp33_ = visitor;
			vala_code_node_accept ((ValaCodeNode*) _tmp32_, _tmp33_);
			_vala_code_node_unref0 (init);
		}
		_vala_iterable_unref0 (_init_list);
	}
}


static void vala_object_creation_expression_real_replace_expression (ValaCodeNode* base, ValaExpression* old_node, ValaExpression* new_node) {
	ValaObjectCreationExpression * self;
	gint index = 0;
	ValaList* _tmp0_;
	ValaExpression* _tmp1_;
	gint _tmp2_;
	gboolean _tmp3_ = FALSE;
	gint _tmp4_;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = self->priv->argument_list;
	_tmp1_ = old_node;
	_tmp2_ = vala_list_index_of (_tmp0_, _tmp1_);
	index = _tmp2_;
	_tmp4_ = index;
	if (_tmp4_ >= 0) {
		ValaExpression* _tmp5_;
		ValaCodeNode* _tmp6_;
		ValaCodeNode* _tmp7_;
		_tmp5_ = new_node;
		_tmp6_ = vala_code_node_get_parent_node ((ValaCodeNode*) _tmp5_);
		_tmp7_ = _tmp6_;
		_tmp3_ = _tmp7_ == NULL;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		ValaList* _tmp8_;
		gint _tmp9_;
		ValaExpression* _tmp10_;
		ValaExpression* _tmp11_;
		_tmp8_ = self->priv->argument_list;
		_tmp9_ = index;
		_tmp10_ = new_node;
		vala_list_set (_tmp8_, _tmp9_, _tmp10_);
		_tmp11_ = new_node;
		vala_code_node_set_parent_node ((ValaCodeNode*) _tmp11_, (ValaCodeNode*) self);
	}
}


static gboolean vala_object_creation_expression_real_is_pure (ValaExpression* base) {
	ValaObjectCreationExpression * self;
	gboolean result = FALSE;
	self = (ValaObjectCreationExpression*) base;
	result = FALSE;
	return result;
}


static gboolean vala_object_creation_expression_real_is_accessible (ValaExpression* base, ValaSymbol* sym) {
	ValaObjectCreationExpression * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	ValaMemberAccess* _tmp1_;
	self = (ValaObjectCreationExpression*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp1_ = self->priv->_member_name;
	if (_tmp1_ != NULL) {
		ValaMemberAccess* _tmp2_;
		ValaSymbol* _tmp3_;
		gboolean _tmp4_;
		_tmp2_ = self->priv->_member_name;
		_tmp3_ = sym;
		_tmp4_ = vala_expression_is_accessible ((ValaExpression*) _tmp2_, _tmp3_);
		_tmp0_ = !_tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp5_;
		ValaList* _tmp6_;
		gint _arg_size = 0;
		ValaList* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		gint _arg_index = 0;
		_tmp5_ = self->priv->argument_list;
		_tmp6_ = _vala_iterable_ref0 (_tmp5_);
		_arg_list = _tmp6_;
		_tmp7_ = _arg_list;
		_tmp8_ = vala_collection_get_size ((ValaCollection*) _tmp7_);
		_tmp9_ = _tmp8_;
		_arg_size = _tmp9_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp10_;
			gint _tmp11_;
			gint _tmp12_;
			ValaExpression* arg = NULL;
			ValaList* _tmp13_;
			gint _tmp14_;
			gpointer _tmp15_;
			ValaExpression* _tmp16_;
			ValaSymbol* _tmp17_;
			gboolean _tmp18_;
			_tmp10_ = _arg_index;
			_arg_index = _tmp10_ + 1;
			_tmp11_ = _arg_index;
			_tmp12_ = _arg_size;
			if (!(_tmp11_ < _tmp12_)) {
				break;
			}
			_tmp13_ = _arg_list;
			_tmp14_ = _arg_index;
			_tmp15_ = vala_list_get (_tmp13_, _tmp14_);
			arg = (ValaExpression*) _tmp15_;
			_tmp16_ = arg;
			_tmp17_ = sym;
			_tmp18_ = vala_expression_is_accessible (_tmp16_, _tmp17_);
			if (!_tmp18_) {
				result = FALSE;
				_vala_code_node_unref0 (arg);
				_vala_iterable_unref0 (_arg_list);
				return result;
			}
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	{
		ValaList* _init_list = NULL;
		ValaList* _tmp19_;
		ValaList* _tmp20_;
		gint _init_size = 0;
		ValaList* _tmp21_;
		gint _tmp22_;
		gint _tmp23_;
		gint _init_index = 0;
		_tmp19_ = self->priv->object_initializer;
		_tmp20_ = _vala_iterable_ref0 (_tmp19_);
		_init_list = _tmp20_;
		_tmp21_ = _init_list;
		_tmp22_ = vala_collection_get_size ((ValaCollection*) _tmp21_);
		_tmp23_ = _tmp22_;
		_init_size = _tmp23_;
		_init_index = -1;
		while (TRUE) {
			gint _tmp24_;
			gint _tmp25_;
			gint _tmp26_;
			ValaMemberInitializer* init = NULL;
			ValaList* _tmp27_;
			gint _tmp28_;
			gpointer _tmp29_;
			ValaMemberInitializer* _tmp30_;
			ValaExpression* _tmp31_;
			ValaExpression* _tmp32_;
			ValaSymbol* _tmp33_;
			gboolean _tmp34_;
			_tmp24_ = _init_index;
			_init_index = _tmp24_ + 1;
			_tmp25_ = _init_index;
			_tmp26_ = _init_size;
			if (!(_tmp25_ < _tmp26_)) {
				break;
			}
			_tmp27_ = _init_list;
			_tmp28_ = _init_index;
			_tmp29_ = vala_list_get (_tmp27_, _tmp28_);
			init = (ValaMemberInitializer*) _tmp29_;
			_tmp30_ = init;
			_tmp31_ = vala_member_initializer_get_initializer (_tmp30_);
			_tmp32_ = _tmp31_;
			_tmp33_ = sym;
			_tmp34_ = vala_expression_is_accessible (_tmp32_, _tmp33_);
			if (!_tmp34_) {
				result = FALSE;
				_vala_code_node_unref0 (init);
				_vala_iterable_unref0 (_init_list);
				return result;
			}
			_vala_code_node_unref0 (init);
		}
		_vala_iterable_unref0 (_init_list);
	}
	result = TRUE;
	return result;
}


static void vala_object_creation_expression_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type) {
	ValaObjectCreationExpression * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_object_creation_expression_get_type_reference (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = old_type;
	if (_tmp1_ == _tmp2_) {
		ValaDataType* _tmp3_;
		_tmp3_ = new_type;
		vala_object_creation_expression_set_type_reference (self, _tmp3_);
	}
}


static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


static gboolean vala_object_creation_expression_real_check (ValaCodeNode* base, ValaCodeContext* context) {
	ValaObjectCreationExpression * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaMemberAccess* _tmp4_;
	ValaTypeSymbol* type = NULL;
	ValaDataType* _tmp8_;
	ValaDataType* _tmp9_;
	ValaDataType* _tmp104_;
	ValaDataType* _tmp105_;
	ValaDataType* _tmp106_;
	ValaDataType* _tmp107_;
	ValaDataType* _tmp108_;
	ValaDataType* _tmp109_;
	gboolean may_throw = FALSE;
	gint given_num_type_args = 0;
	ValaDataType* _tmp110_;
	ValaDataType* _tmp111_;
	ValaList* _tmp112_;
	ValaList* _tmp113_;
	gint _tmp114_;
	gint _tmp115_;
	gint _tmp116_;
	gint expected_num_type_args = 0;
	ValaTypeSymbol* _tmp117_;
	gint _tmp242_;
	gint _tmp243_;
	gboolean _tmp250_ = FALSE;
	ValaSymbol* _tmp251_;
	ValaSymbol* _tmp252_;
	ValaSymbol* _tmp264_;
	ValaSymbol* _tmp265_;
	gboolean _tmp526_;
	gboolean _tmp585_;
	gboolean _tmp586_;
	self = (ValaObjectCreationExpression*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = self->priv->_member_name;
	if (_tmp4_ != NULL) {
		ValaMemberAccess* _tmp5_;
		ValaCodeContext* _tmp6_;
		gboolean _tmp7_;
		_tmp5_ = self->priv->_member_name;
		_tmp6_ = context;
		_tmp7_ = vala_code_node_check ((ValaCodeNode*) _tmp5_, _tmp6_);
		if (!_tmp7_) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			return result;
		}
	}
	type = NULL;
	_tmp8_ = vala_object_creation_expression_get_type_reference (self);
	_tmp9_ = _tmp8_;
	if (_tmp9_ == NULL) {
		ValaMemberAccess* _tmp10_;
		ValaMemberAccess* _tmp13_;
		ValaSymbol* _tmp14_;
		ValaSymbol* _tmp15_;
		ValaSymbol* constructor_sym = NULL;
		ValaMemberAccess* _tmp16_;
		ValaSymbol* _tmp17_;
		ValaSymbol* _tmp18_;
		ValaSymbol* _tmp19_;
		ValaSymbol* type_sym = NULL;
		ValaMemberAccess* _tmp20_;
		ValaSymbol* _tmp21_;
		ValaSymbol* _tmp22_;
		ValaSymbol* _tmp23_;
		ValaList* type_args = NULL;
		ValaMemberAccess* _tmp24_;
		ValaList* _tmp25_;
		ValaSymbol* _tmp26_;
		ValaSymbol* _tmp49_;
		_tmp10_ = self->priv->_member_name;
		if (_tmp10_ == NULL) {
			ValaSourceReference* _tmp11_;
			ValaSourceReference* _tmp12_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp11_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp12_ = _tmp11_;
			vala_report_error (_tmp12_, "Incomplete object creation expression");
			result = FALSE;
			_vala_code_node_unref0 (type);
			return result;
		}
		_tmp13_ = self->priv->_member_name;
		_tmp14_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp13_);
		_tmp15_ = _tmp14_;
		if (_tmp15_ == NULL) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_code_node_unref0 (type);
			return result;
		}
		_tmp16_ = self->priv->_member_name;
		_tmp17_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = _vala_code_node_ref0 (_tmp18_);
		constructor_sym = _tmp19_;
		_tmp20_ = self->priv->_member_name;
		_tmp21_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = _vala_code_node_ref0 (_tmp22_);
		type_sym = _tmp23_;
		_tmp24_ = self->priv->_member_name;
		_tmp25_ = vala_member_access_get_type_arguments (_tmp24_);
		type_args = _tmp25_;
		_tmp26_ = constructor_sym;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp26_, VALA_TYPE_METHOD)) {
			ValaSymbol* _tmp27_;
			ValaSymbol* _tmp28_;
			ValaSymbol* _tmp29_;
			ValaSymbol* _tmp30_;
			ValaMethod* constructor = NULL;
			ValaSymbol* _tmp31_;
			ValaMethod* _tmp32_;
			ValaSymbol* _tmp33_;
			ValaMethod* _tmp41_;
			ValaMemberAccess* ma = NULL;
			ValaMemberAccess* _tmp42_;
			ValaExpression* _tmp43_;
			ValaExpression* _tmp44_;
			ValaMemberAccess* _tmp45_;
			ValaMemberAccess* _tmp46_;
			_tmp27_ = constructor_sym;
			_tmp28_ = vala_symbol_get_parent_symbol (_tmp27_);
			_tmp29_ = _tmp28_;
			_tmp30_ = _vala_code_node_ref0 (_tmp29_);
			_vala_code_node_unref0 (type_sym);
			type_sym = _tmp30_;
			_tmp31_ = constructor_sym;
			_tmp32_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, VALA_TYPE_METHOD, ValaMethod));
			constructor = _tmp32_;
			_tmp33_ = constructor_sym;
			if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp33_, VALA_TYPE_CREATION_METHOD)) {
				ValaSourceReference* _tmp34_;
				ValaSourceReference* _tmp35_;
				ValaMethod* _tmp36_;
				gchar* _tmp37_;
				gchar* _tmp38_;
				gchar* _tmp39_;
				gchar* _tmp40_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp34_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp35_ = _tmp34_;
				_tmp36_ = constructor;
				_tmp37_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp36_);
				_tmp38_ = _tmp37_;
				_tmp39_ = g_strdup_printf ("`%s' is not a creation method", _tmp38_);
				_tmp40_ = _tmp39_;
				vala_report_error (_tmp35_, _tmp40_);
				_g_free0 (_tmp40_);
				_g_free0 (_tmp38_);
				result = FALSE;
				_vala_code_node_unref0 (constructor);
				_vala_iterable_unref0 (type_args);
				_vala_code_node_unref0 (type_sym);
				_vala_code_node_unref0 (constructor_sym);
				_vala_code_node_unref0 (type);
				return result;
			}
			_tmp41_ = constructor;
			vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp41_);
			_tmp42_ = self->priv->_member_name;
			_tmp43_ = vala_member_access_get_inner (_tmp42_);
			_tmp44_ = _tmp43_;
			_tmp45_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp44_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp44_) : NULL);
			ma = _tmp45_;
			_tmp46_ = ma;
			if (_tmp46_ != NULL) {
				ValaMemberAccess* _tmp47_;
				ValaList* _tmp48_;
				_tmp47_ = ma;
				_tmp48_ = vala_member_access_get_type_arguments (_tmp47_);
				_vala_iterable_unref0 (type_args);
				type_args = _tmp48_;
			}
			_vala_code_node_unref0 (ma);
			_vala_code_node_unref0 (constructor);
		}
		_tmp49_ = type_sym;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp49_, VALA_TYPE_CLASS)) {
			ValaSymbol* _tmp50_;
			ValaTypeSymbol* _tmp51_;
			ValaTypeSymbol* _tmp52_;
			gboolean _tmp53_;
			gboolean _tmp54_;
			_tmp50_ = type_sym;
			_tmp51_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp50_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol));
			_vala_code_node_unref0 (type);
			type = _tmp51_;
			_tmp52_ = type;
			_tmp53_ = vala_class_get_is_error_base (G_TYPE_CHECK_INSTANCE_CAST (_tmp52_, VALA_TYPE_CLASS, ValaClass));
			_tmp54_ = _tmp53_;
			if (_tmp54_) {
				ValaSourceReference* _tmp55_;
				ValaSourceReference* _tmp56_;
				ValaErrorType* _tmp57_;
				ValaErrorType* _tmp58_;
				_tmp55_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp56_ = _tmp55_;
				_tmp57_ = vala_error_type_new (NULL, NULL, _tmp56_);
				_tmp58_ = _tmp57_;
				vala_object_creation_expression_set_type_reference (self, (ValaDataType*) _tmp58_);
				_vala_code_node_unref0 (_tmp58_);
			} else {
				ValaTypeSymbol* _tmp59_;
				ValaObjectType* _tmp60_;
				ValaObjectType* _tmp61_;
				_tmp59_ = type;
				_tmp60_ = vala_object_type_new ((ValaObjectTypeSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp59_, VALA_TYPE_CLASS, ValaClass));
				_tmp61_ = _tmp60_;
				vala_object_creation_expression_set_type_reference (self, (ValaDataType*) _tmp61_);
				_vala_code_node_unref0 (_tmp61_);
			}
		} else {
			ValaSymbol* _tmp62_;
			_tmp62_ = type_sym;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp62_, VALA_TYPE_STRUCT)) {
				ValaSymbol* _tmp63_;
				ValaTypeSymbol* _tmp64_;
				ValaTypeSymbol* _tmp65_;
				ValaStructValueType* _tmp66_;
				ValaStructValueType* _tmp67_;
				_tmp63_ = type_sym;
				_tmp64_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp63_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol));
				_vala_code_node_unref0 (type);
				type = _tmp64_;
				_tmp65_ = type;
				_tmp66_ = vala_struct_value_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp65_, VALA_TYPE_STRUCT, ValaStruct));
				_tmp67_ = _tmp66_;
				vala_object_creation_expression_set_type_reference (self, (ValaDataType*) _tmp67_);
				_vala_code_node_unref0 (_tmp67_);
			} else {
				ValaSymbol* _tmp68_;
				_tmp68_ = type_sym;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp68_, VALA_TYPE_ERROR_CODE)) {
					ValaSymbol* _tmp69_;
					ValaSymbol* _tmp70_;
					ValaSymbol* _tmp71_;
					ValaSymbol* _tmp72_;
					ValaSourceReference* _tmp73_;
					ValaSourceReference* _tmp74_;
					ValaErrorType* _tmp75_;
					ValaErrorType* _tmp76_;
					ValaSymbol* _tmp77_;
					_tmp69_ = type_sym;
					_tmp70_ = vala_symbol_get_parent_symbol (_tmp69_);
					_tmp71_ = _tmp70_;
					_tmp72_ = type_sym;
					_tmp73_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp74_ = _tmp73_;
					_tmp75_ = vala_error_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp71_, VALA_TYPE_ERROR_DOMAIN, ValaErrorDomain), G_TYPE_CHECK_INSTANCE_CAST (_tmp72_, VALA_TYPE_ERROR_CODE, ValaErrorCode), _tmp74_);
					_tmp76_ = _tmp75_;
					vala_object_creation_expression_set_type_reference (self, (ValaDataType*) _tmp76_);
					_vala_code_node_unref0 (_tmp76_);
					_tmp77_ = type_sym;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp77_);
				} else {
					ValaSourceReference* _tmp78_;
					ValaSourceReference* _tmp79_;
					ValaSymbol* _tmp80_;
					gchar* _tmp81_;
					gchar* _tmp82_;
					gchar* _tmp83_;
					gchar* _tmp84_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp78_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp79_ = _tmp78_;
					_tmp80_ = type_sym;
					_tmp81_ = vala_symbol_get_full_name (_tmp80_);
					_tmp82_ = _tmp81_;
					_tmp83_ = g_strdup_printf ("`%s' is not a class, struct, or error code", _tmp82_);
					_tmp84_ = _tmp83_;
					vala_report_error (_tmp79_, _tmp84_);
					_g_free0 (_tmp84_);
					_g_free0 (_tmp82_);
					result = FALSE;
					_vala_iterable_unref0 (type_args);
					_vala_code_node_unref0 (type_sym);
					_vala_code_node_unref0 (constructor_sym);
					_vala_code_node_unref0 (type);
					return result;
				}
			}
		}
		{
			ValaList* _type_arg_list = NULL;
			ValaList* _tmp85_;
			ValaList* _tmp86_;
			gint _type_arg_size = 0;
			ValaList* _tmp87_;
			gint _tmp88_;
			gint _tmp89_;
			gint _type_arg_index = 0;
			_tmp85_ = type_args;
			_tmp86_ = _vala_iterable_ref0 (_tmp85_);
			_type_arg_list = _tmp86_;
			_tmp87_ = _type_arg_list;
			_tmp88_ = vala_collection_get_size ((ValaCollection*) _tmp87_);
			_tmp89_ = _tmp88_;
			_type_arg_size = _tmp89_;
			_type_arg_index = -1;
			while (TRUE) {
				gint _tmp90_;
				gint _tmp91_;
				gint _tmp92_;
				ValaDataType* type_arg = NULL;
				ValaList* _tmp93_;
				gint _tmp94_;
				gpointer _tmp95_;
				ValaDataType* _tmp96_;
				ValaDataType* _tmp97_;
				ValaDataType* _tmp98_;
				_tmp90_ = _type_arg_index;
				_type_arg_index = _tmp90_ + 1;
				_tmp91_ = _type_arg_index;
				_tmp92_ = _type_arg_size;
				if (!(_tmp91_ < _tmp92_)) {
					break;
				}
				_tmp93_ = _type_arg_list;
				_tmp94_ = _type_arg_index;
				_tmp95_ = vala_list_get (_tmp93_, _tmp94_);
				type_arg = (ValaDataType*) _tmp95_;
				_tmp96_ = vala_object_creation_expression_get_type_reference (self);
				_tmp97_ = _tmp96_;
				_tmp98_ = type_arg;
				vala_data_type_add_type_argument (_tmp97_, _tmp98_);
				_vala_code_node_unref0 (type_arg);
			}
			_vala_iterable_unref0 (_type_arg_list);
		}
		_vala_iterable_unref0 (type_args);
		_vala_code_node_unref0 (type_sym);
		_vala_code_node_unref0 (constructor_sym);
	} else {
		ValaDataType* _tmp99_;
		ValaDataType* _tmp100_;
		ValaTypeSymbol* _tmp101_;
		ValaTypeSymbol* _tmp102_;
		ValaTypeSymbol* _tmp103_;
		_tmp99_ = vala_object_creation_expression_get_type_reference (self);
		_tmp100_ = _tmp99_;
		_tmp101_ = vala_data_type_get_data_type (_tmp100_);
		_tmp102_ = _tmp101_;
		_tmp103_ = _vala_code_node_ref0 (_tmp102_);
		_vala_code_node_unref0 (type);
		type = _tmp103_;
	}
	_tmp104_ = vala_object_creation_expression_get_type_reference (self);
	_tmp105_ = _tmp104_;
	_tmp106_ = vala_data_type_copy (_tmp105_);
	_tmp107_ = _tmp106_;
	vala_expression_set_value_type ((ValaExpression*) self, _tmp107_);
	_vala_code_node_unref0 (_tmp107_);
	_tmp108_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp109_ = _tmp108_;
	vala_data_type_set_value_owned (_tmp109_, TRUE);
	may_throw = FALSE;
	_tmp110_ = vala_object_creation_expression_get_type_reference (self);
	_tmp111_ = _tmp110_;
	_tmp112_ = vala_data_type_get_type_arguments (_tmp111_);
	_tmp113_ = _tmp112_;
	_tmp114_ = vala_collection_get_size ((ValaCollection*) _tmp113_);
	_tmp115_ = _tmp114_;
	_tmp116_ = _tmp115_;
	_vala_iterable_unref0 (_tmp113_);
	given_num_type_args = _tmp116_;
	expected_num_type_args = 0;
	_tmp117_ = type;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp117_, VALA_TYPE_CLASS)) {
		ValaClass* cl = NULL;
		ValaTypeSymbol* _tmp118_;
		ValaClass* _tmp119_;
		ValaClass* _tmp120_;
		ValaList* _tmp121_;
		ValaList* _tmp122_;
		gint _tmp123_;
		gint _tmp124_;
		gboolean _tmp125_;
		ValaClass* _tmp128_;
		gboolean _tmp129_;
		gboolean _tmp130_;
		ValaSymbol* _tmp138_;
		ValaSymbol* _tmp139_;
		gboolean _tmp160_ = FALSE;
		ValaSymbol* _tmp161_;
		ValaSymbol* _tmp162_;
		_tmp118_ = type;
		_tmp119_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp118_, VALA_TYPE_CLASS, ValaClass));
		cl = _tmp119_;
		_tmp120_ = cl;
		_tmp121_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) _tmp120_);
		_tmp122_ = _tmp121_;
		_tmp123_ = vala_collection_get_size ((ValaCollection*) _tmp122_);
		_tmp124_ = _tmp123_;
		expected_num_type_args = _tmp124_;
		_vala_iterable_unref0 (_tmp122_);
		_tmp125_ = self->priv->_struct_creation;
		if (_tmp125_) {
			ValaSourceReference* _tmp126_;
			ValaSourceReference* _tmp127_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp126_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp127_ = _tmp126_;
			vala_report_error (_tmp127_, "syntax error, use `new' to create new objects");
			result = FALSE;
			_vala_code_node_unref0 (cl);
			_vala_code_node_unref0 (type);
			return result;
		}
		_tmp128_ = cl;
		_tmp129_ = vala_class_get_is_abstract (_tmp128_);
		_tmp130_ = _tmp129_;
		if (_tmp130_) {
			ValaSourceReference* _tmp131_;
			ValaSourceReference* _tmp132_;
			ValaClass* _tmp133_;
			gchar* _tmp134_;
			gchar* _tmp135_;
			gchar* _tmp136_;
			gchar* _tmp137_;
			vala_expression_set_value_type ((ValaExpression*) self, NULL);
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp131_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp132_ = _tmp131_;
			_tmp133_ = cl;
			_tmp134_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp133_);
			_tmp135_ = _tmp134_;
			_tmp136_ = g_strdup_printf ("Can't create instance of abstract class `%s'", _tmp135_);
			_tmp137_ = _tmp136_;
			vala_report_error (_tmp132_, _tmp137_);
			_g_free0 (_tmp137_);
			_g_free0 (_tmp135_);
			result = FALSE;
			_vala_code_node_unref0 (cl);
			_vala_code_node_unref0 (type);
			return result;
		}
		_tmp138_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp139_ = _tmp138_;
		if (_tmp139_ == NULL) {
			ValaClass* _tmp140_;
			ValaCreationMethod* _tmp141_;
			ValaCreationMethod* _tmp142_;
			ValaSymbol* _tmp143_;
			ValaSymbol* _tmp144_;
			ValaSymbol* _tmp152_;
			ValaSymbol* _tmp153_;
			ValaSymbol* _tmp154_;
			ValaSymbol* _tmp155_;
			ValaVersionAttribute* _tmp156_;
			ValaVersionAttribute* _tmp157_;
			ValaSourceReference* _tmp158_;
			ValaSourceReference* _tmp159_;
			_tmp140_ = cl;
			_tmp141_ = vala_class_get_default_construction_method (_tmp140_);
			_tmp142_ = _tmp141_;
			vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp142_);
			_tmp143_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp144_ = _tmp143_;
			if (_tmp144_ == NULL) {
				ValaSourceReference* _tmp145_;
				ValaSourceReference* _tmp146_;
				ValaClass* _tmp147_;
				gchar* _tmp148_;
				gchar* _tmp149_;
				gchar* _tmp150_;
				gchar* _tmp151_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp145_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp146_ = _tmp145_;
				_tmp147_ = cl;
				_tmp148_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp147_);
				_tmp149_ = _tmp148_;
				_tmp150_ = g_strdup_printf ("`%s' does not have a default constructor", _tmp149_);
				_tmp151_ = _tmp150_;
				vala_report_error (_tmp146_, _tmp151_);
				_g_free0 (_tmp151_);
				_g_free0 (_tmp149_);
				result = FALSE;
				_vala_code_node_unref0 (cl);
				_vala_code_node_unref0 (type);
				return result;
			}
			_tmp152_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp153_ = _tmp152_;
			vala_symbol_set_used (_tmp153_, TRUE);
			_tmp154_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp155_ = _tmp154_;
			_tmp156_ = vala_symbol_get_version (_tmp155_);
			_tmp157_ = _tmp156_;
			_tmp158_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp159_ = _tmp158_;
			vala_version_attribute_check (_tmp157_, _tmp159_);
		}
		_tmp161_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp162_ = _tmp161_;
		if (_tmp162_ != NULL) {
			gboolean _tmp163_ = FALSE;
			ValaSymbol* _tmp164_;
			ValaSymbol* _tmp165_;
			ValaSymbolAccessibility _tmp166_;
			ValaSymbolAccessibility _tmp167_;
			_tmp164_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp165_ = _tmp164_;
			_tmp166_ = vala_symbol_get_access (_tmp165_);
			_tmp167_ = _tmp166_;
			if (_tmp167_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
				_tmp163_ = TRUE;
			} else {
				ValaSymbol* _tmp168_;
				ValaSymbol* _tmp169_;
				ValaSymbolAccessibility _tmp170_;
				ValaSymbolAccessibility _tmp171_;
				_tmp168_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp169_ = _tmp168_;
				_tmp170_ = vala_symbol_get_access (_tmp169_);
				_tmp171_ = _tmp170_;
				_tmp163_ = _tmp171_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED;
			}
			_tmp160_ = _tmp163_;
		} else {
			_tmp160_ = FALSE;
		}
		if (_tmp160_) {
			gboolean in_target_type = FALSE;
			gboolean _tmp186_;
			in_target_type = FALSE;
			{
				ValaSymbol* this_symbol = NULL;
				ValaCodeContext* _tmp172_;
				ValaSemanticAnalyzer* _tmp173_;
				ValaSemanticAnalyzer* _tmp174_;
				ValaSymbol* _tmp175_;
				ValaSymbol* _tmp176_;
				ValaSymbol* _tmp177_;
				_tmp172_ = context;
				_tmp173_ = vala_code_context_get_analyzer (_tmp172_);
				_tmp174_ = _tmp173_;
				_tmp175_ = vala_semantic_analyzer_get_current_symbol (_tmp174_);
				_tmp176_ = _tmp175_;
				_tmp177_ = _vala_code_node_ref0 (_tmp176_);
				this_symbol = _tmp177_;
				{
					gboolean _tmp178_ = FALSE;
					_tmp178_ = TRUE;
					while (TRUE) {
						ValaSymbol* _tmp183_;
						ValaSymbol* _tmp184_;
						ValaClass* _tmp185_;
						if (!_tmp178_) {
							ValaSymbol* _tmp179_;
							ValaSymbol* _tmp180_;
							ValaSymbol* _tmp181_;
							ValaSymbol* _tmp182_;
							_tmp179_ = this_symbol;
							_tmp180_ = vala_symbol_get_parent_symbol (_tmp179_);
							_tmp181_ = _tmp180_;
							_tmp182_ = _vala_code_node_ref0 (_tmp181_);
							_vala_code_node_unref0 (this_symbol);
							this_symbol = _tmp182_;
						}
						_tmp178_ = FALSE;
						_tmp183_ = this_symbol;
						if (!(_tmp183_ != NULL)) {
							break;
						}
						_tmp184_ = this_symbol;
						_tmp185_ = cl;
						if (_tmp184_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp185_, VALA_TYPE_SYMBOL, ValaSymbol)) {
							in_target_type = TRUE;
							break;
						}
					}
				}
				_vala_code_node_unref0 (this_symbol);
			}
			_tmp186_ = in_target_type;
			if (!_tmp186_) {
				ValaSourceReference* _tmp187_;
				ValaSourceReference* _tmp188_;
				ValaSymbol* _tmp189_;
				ValaSymbol* _tmp190_;
				gchar* _tmp191_;
				gchar* _tmp192_;
				gchar* _tmp193_;
				gchar* _tmp194_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp187_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp188_ = _tmp187_;
				_tmp189_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp190_ = _tmp189_;
				_tmp191_ = vala_symbol_get_full_name (_tmp190_);
				_tmp192_ = _tmp191_;
				_tmp193_ = g_strdup_printf ("Access to non-public constructor `%s' denied", _tmp192_);
				_tmp194_ = _tmp193_;
				vala_report_error (_tmp188_, _tmp194_);
				_g_free0 (_tmp194_);
				_g_free0 (_tmp192_);
				result = FALSE;
				_vala_code_node_unref0 (cl);
				_vala_code_node_unref0 (type);
				return result;
			}
		}
		while (TRUE) {
			ValaClass* _tmp195_;
			ValaClass* _tmp196_;
			gchar* _tmp197_;
			gchar* _tmp198_;
			gboolean _tmp199_;
			ValaClass* _tmp202_;
			ValaClass* _tmp203_;
			ValaClass* _tmp204_;
			ValaClass* _tmp205_;
			_tmp195_ = cl;
			if (!(_tmp195_ != NULL)) {
				break;
			}
			_tmp196_ = cl;
			_tmp197_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp196_, "CCode", "ref_sink_function", NULL);
			_tmp198_ = _tmp197_;
			_tmp199_ = _tmp198_ != NULL;
			_g_free0 (_tmp198_);
			if (_tmp199_) {
				ValaDataType* _tmp200_;
				ValaDataType* _tmp201_;
				_tmp200_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp201_ = _tmp200_;
				vala_data_type_set_floating_reference (_tmp201_, TRUE);
				break;
			}
			_tmp202_ = cl;
			_tmp203_ = vala_class_get_base_class (_tmp202_);
			_tmp204_ = _tmp203_;
			_tmp205_ = _vala_code_node_ref0 (_tmp204_);
			_vala_code_node_unref0 (cl);
			cl = _tmp205_;
		}
		_vala_code_node_unref0 (cl);
	} else {
		ValaTypeSymbol* _tmp206_;
		_tmp206_ = type;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp206_, VALA_TYPE_STRUCT)) {
			ValaStruct* st = NULL;
			ValaTypeSymbol* _tmp207_;
			ValaStruct* _tmp208_;
			ValaStruct* _tmp209_;
			ValaList* _tmp210_;
			ValaList* _tmp211_;
			gint _tmp212_;
			gint _tmp213_;
			gboolean _tmp214_ = FALSE;
			gboolean _tmp215_;
			ValaSymbol* _tmp221_;
			ValaSymbol* _tmp222_;
			gboolean _tmp226_ = FALSE;
			gboolean _tmp227_ = FALSE;
			ValaStruct* _tmp228_;
			gboolean _tmp229_;
			_tmp207_ = type;
			_tmp208_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp207_, VALA_TYPE_STRUCT, ValaStruct));
			st = _tmp208_;
			_tmp209_ = st;
			_tmp210_ = vala_struct_get_type_parameters (_tmp209_);
			_tmp211_ = _tmp210_;
			_tmp212_ = vala_collection_get_size ((ValaCollection*) _tmp211_);
			_tmp213_ = _tmp212_;
			expected_num_type_args = _tmp213_;
			_vala_iterable_unref0 (_tmp211_);
			_tmp215_ = self->priv->_struct_creation;
			if (!_tmp215_) {
				ValaCodeContext* _tmp216_;
				gboolean _tmp217_;
				gboolean _tmp218_;
				_tmp216_ = context;
				_tmp217_ = vala_code_context_get_deprecated (_tmp216_);
				_tmp218_ = _tmp217_;
				_tmp214_ = !_tmp218_;
			} else {
				_tmp214_ = FALSE;
			}
			if (_tmp214_) {
				ValaSourceReference* _tmp219_;
				ValaSourceReference* _tmp220_;
				_tmp219_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp220_ = _tmp219_;
				vala_report_warning (_tmp220_, "deprecated syntax, don't use `new' to initialize structs");
			}
			_tmp221_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp222_ = _tmp221_;
			if (_tmp222_ == NULL) {
				ValaStruct* _tmp223_;
				ValaMethod* _tmp224_;
				ValaMethod* _tmp225_;
				_tmp223_ = st;
				_tmp224_ = vala_struct_get_default_construction_method (_tmp223_);
				_tmp225_ = _tmp224_;
				vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp225_);
			}
			_tmp228_ = st;
			_tmp229_ = vala_struct_is_simple_type (_tmp228_);
			if (_tmp229_) {
				ValaSymbol* _tmp230_;
				ValaSymbol* _tmp231_;
				_tmp230_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp231_ = _tmp230_;
				_tmp227_ = _tmp231_ == NULL;
			} else {
				_tmp227_ = FALSE;
			}
			if (_tmp227_) {
				ValaList* _tmp232_;
				gint _tmp233_;
				gint _tmp234_;
				_tmp232_ = self->priv->object_initializer;
				_tmp233_ = vala_collection_get_size ((ValaCollection*) _tmp232_);
				_tmp234_ = _tmp233_;
				_tmp226_ = _tmp234_ == 0;
			} else {
				_tmp226_ = FALSE;
			}
			if (_tmp226_) {
				ValaSourceReference* _tmp235_;
				ValaSourceReference* _tmp236_;
				ValaStruct* _tmp237_;
				gchar* _tmp238_;
				gchar* _tmp239_;
				gchar* _tmp240_;
				gchar* _tmp241_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp235_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp236_ = _tmp235_;
				_tmp237_ = st;
				_tmp238_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp237_);
				_tmp239_ = _tmp238_;
				_tmp240_ = g_strdup_printf ("`%s' does not have a default constructor", _tmp239_);
				_tmp241_ = _tmp240_;
				vala_report_error (_tmp236_, _tmp241_);
				_g_free0 (_tmp241_);
				_g_free0 (_tmp239_);
				result = FALSE;
				_vala_code_node_unref0 (st);
				_vala_code_node_unref0 (type);
				return result;
			}
			_vala_code_node_unref0 (st);
		}
	}
	_tmp242_ = expected_num_type_args;
	_tmp243_ = given_num_type_args;
	if (_tmp242_ > _tmp243_) {
		ValaSourceReference* _tmp244_;
		ValaSourceReference* _tmp245_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp244_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp245_ = _tmp244_;
		vala_report_error (_tmp245_, "too few type arguments");
		result = FALSE;
		_vala_code_node_unref0 (type);
		return result;
	} else {
		gint _tmp246_;
		gint _tmp247_;
		_tmp246_ = expected_num_type_args;
		_tmp247_ = given_num_type_args;
		if (_tmp246_ < _tmp247_) {
			ValaSourceReference* _tmp248_;
			ValaSourceReference* _tmp249_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp248_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp249_ = _tmp248_;
			vala_report_error (_tmp249_, "too many type arguments");
			result = FALSE;
			_vala_code_node_unref0 (type);
			return result;
		}
	}
	_tmp251_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp252_ = _tmp251_;
	if (_tmp252_ == NULL) {
		ValaList* _tmp253_;
		ValaList* _tmp254_;
		gint _tmp255_;
		gint _tmp256_;
		_tmp253_ = vala_object_creation_expression_get_argument_list (self);
		_tmp254_ = _tmp253_;
		_tmp255_ = vala_collection_get_size ((ValaCollection*) _tmp254_);
		_tmp256_ = _tmp255_;
		_tmp250_ = _tmp256_ != 0;
		_vala_iterable_unref0 (_tmp254_);
	} else {
		_tmp250_ = FALSE;
	}
	if (_tmp250_) {
		ValaSourceReference* _tmp257_;
		ValaSourceReference* _tmp258_;
		ValaTypeSymbol* _tmp259_;
		gchar* _tmp260_;
		gchar* _tmp261_;
		gchar* _tmp262_;
		gchar* _tmp263_;
		vala_expression_set_value_type ((ValaExpression*) self, NULL);
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp257_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp258_ = _tmp257_;
		_tmp259_ = type;
		_tmp260_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp259_);
		_tmp261_ = _tmp260_;
		_tmp262_ = g_strdup_printf ("No arguments allowed when constructing type `%s'", _tmp261_);
		_tmp263_ = _tmp262_;
		vala_report_error (_tmp258_, _tmp263_);
		_g_free0 (_tmp263_);
		_g_free0 (_tmp261_);
		result = FALSE;
		_vala_code_node_unref0 (type);
		return result;
	}
	_tmp264_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp265_ = _tmp264_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp265_, VALA_TYPE_METHOD)) {
		ValaMethod* m = NULL;
		ValaSymbol* _tmp266_;
		ValaSymbol* _tmp267_;
		ValaMethod* _tmp268_;
		gboolean _tmp269_;
		ValaExpression* last_arg = NULL;
		ValaList* args = NULL;
		ValaList* _tmp290_;
		ValaIterator* arg_it = NULL;
		ValaList* _tmp291_;
		ValaIterator* _tmp292_;
		ValaMethod* _tmp325_;
		gboolean _tmp326_;
		gboolean _tmp327_;
		ValaCodeContext* _tmp395_;
		ValaSemanticAnalyzer* _tmp396_;
		ValaSemanticAnalyzer* _tmp397_;
		ValaMethod* _tmp398_;
		ValaMethodType* _tmp399_;
		ValaMethodType* _tmp400_;
		ValaMethod* _tmp401_;
		ValaList* _tmp402_;
		ValaList* _tmp403_;
		ValaList* _tmp404_;
		_tmp266_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp267_ = _tmp266_;
		_tmp268_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp267_, VALA_TYPE_METHOD, ValaMethod));
		m = _tmp268_;
		_tmp269_ = self->priv->_is_yield_expression;
		if (_tmp269_) {
			ValaMethod* _tmp270_;
			gboolean _tmp271_;
			gboolean _tmp272_;
			gboolean _tmp275_ = FALSE;
			ValaCodeContext* _tmp276_;
			ValaSemanticAnalyzer* _tmp277_;
			ValaSemanticAnalyzer* _tmp278_;
			ValaMethod* _tmp279_;
			ValaMethod* _tmp280_;
			_tmp270_ = m;
			_tmp271_ = vala_method_get_coroutine (_tmp270_);
			_tmp272_ = _tmp271_;
			if (!_tmp272_) {
				ValaSourceReference* _tmp273_;
				ValaSourceReference* _tmp274_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp273_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp274_ = _tmp273_;
				vala_report_error (_tmp274_, "yield expression requires async method");
			}
			_tmp276_ = context;
			_tmp277_ = vala_code_context_get_analyzer (_tmp276_);
			_tmp278_ = _tmp277_;
			_tmp279_ = vala_semantic_analyzer_get_current_method (_tmp278_);
			_tmp280_ = _tmp279_;
			if (_tmp280_ == NULL) {
				_tmp275_ = TRUE;
			} else {
				ValaCodeContext* _tmp281_;
				ValaSemanticAnalyzer* _tmp282_;
				ValaSemanticAnalyzer* _tmp283_;
				ValaMethod* _tmp284_;
				ValaMethod* _tmp285_;
				gboolean _tmp286_;
				gboolean _tmp287_;
				_tmp281_ = context;
				_tmp282_ = vala_code_context_get_analyzer (_tmp281_);
				_tmp283_ = _tmp282_;
				_tmp284_ = vala_semantic_analyzer_get_current_method (_tmp283_);
				_tmp285_ = _tmp284_;
				_tmp286_ = vala_method_get_coroutine (_tmp285_);
				_tmp287_ = _tmp286_;
				_tmp275_ = !_tmp287_;
			}
			if (_tmp275_) {
				ValaSourceReference* _tmp288_;
				ValaSourceReference* _tmp289_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp288_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp289_ = _tmp288_;
				vala_report_error (_tmp289_, "yield expression not available outside async method");
			}
		}
		last_arg = NULL;
		_tmp290_ = vala_object_creation_expression_get_argument_list (self);
		args = _tmp290_;
		_tmp291_ = args;
		_tmp292_ = vala_iterable_iterator ((ValaIterable*) _tmp291_);
		arg_it = _tmp292_;
		{
			ValaList* _param_list = NULL;
			ValaMethod* _tmp293_;
			ValaList* _tmp294_;
			gint _param_size = 0;
			ValaList* _tmp295_;
			gint _tmp296_;
			gint _tmp297_;
			gint _param_index = 0;
			_tmp293_ = m;
			_tmp294_ = vala_callable_get_parameters ((ValaCallable*) _tmp293_);
			_param_list = _tmp294_;
			_tmp295_ = _param_list;
			_tmp296_ = vala_collection_get_size ((ValaCollection*) _tmp295_);
			_tmp297_ = _tmp296_;
			_param_size = _tmp297_;
			_param_index = -1;
			while (TRUE) {
				gint _tmp298_;
				gint _tmp299_;
				gint _tmp300_;
				ValaParameter* param = NULL;
				ValaList* _tmp301_;
				gint _tmp302_;
				gpointer _tmp303_;
				ValaParameter* _tmp304_;
				gboolean _tmp305_;
				gboolean _tmp306_;
				ValaIterator* _tmp307_;
				gboolean _tmp308_;
				_tmp298_ = _param_index;
				_param_index = _tmp298_ + 1;
				_tmp299_ = _param_index;
				_tmp300_ = _param_size;
				if (!(_tmp299_ < _tmp300_)) {
					break;
				}
				_tmp301_ = _param_list;
				_tmp302_ = _param_index;
				_tmp303_ = vala_list_get (_tmp301_, _tmp302_);
				param = (ValaParameter*) _tmp303_;
				_tmp304_ = param;
				_tmp305_ = vala_parameter_get_ellipsis (_tmp304_);
				_tmp306_ = _tmp305_;
				if (_tmp306_) {
					_vala_code_node_unref0 (param);
					break;
				}
				_tmp307_ = arg_it;
				_tmp308_ = vala_iterator_next (_tmp307_);
				if (_tmp308_) {
					ValaExpression* arg = NULL;
					ValaIterator* _tmp309_;
					gpointer _tmp310_;
					ValaExpression* _tmp311_;
					ValaParameter* _tmp312_;
					ValaDataType* _tmp313_;
					ValaDataType* _tmp314_;
					ValaExpression* _tmp315_;
					ValaExpression* _tmp316_;
					ValaDataType* _tmp317_;
					ValaDataType* _tmp318_;
					ValaDataType* _tmp319_;
					ValaDataType* _tmp320_;
					ValaDataType* _tmp321_;
					ValaDataType* _tmp322_;
					ValaExpression* _tmp323_;
					ValaExpression* _tmp324_;
					_tmp309_ = arg_it;
					_tmp310_ = vala_iterator_get (_tmp309_);
					arg = (ValaExpression*) _tmp310_;
					_tmp311_ = arg;
					_tmp312_ = param;
					_tmp313_ = vala_variable_get_variable_type ((ValaVariable*) _tmp312_);
					_tmp314_ = _tmp313_;
					vala_expression_set_formal_target_type (_tmp311_, _tmp314_);
					_tmp315_ = arg;
					_tmp316_ = arg;
					_tmp317_ = vala_expression_get_formal_target_type (_tmp316_);
					_tmp318_ = _tmp317_;
					_tmp319_ = vala_expression_get_value_type ((ValaExpression*) self);
					_tmp320_ = _tmp319_;
					_tmp321_ = vala_data_type_get_actual_type (_tmp318_, _tmp320_, NULL, (ValaCodeNode*) self);
					_tmp322_ = _tmp321_;
					vala_expression_set_target_type (_tmp315_, _tmp322_);
					_vala_code_node_unref0 (_tmp322_);
					_tmp323_ = arg;
					_tmp324_ = _vala_code_node_ref0 (_tmp323_);
					_vala_code_node_unref0 (last_arg);
					last_arg = _tmp324_;
					_vala_code_node_unref0 (arg);
				}
				_vala_code_node_unref0 (param);
			}
			_vala_iterable_unref0 (_param_list);
		}
		_tmp325_ = m;
		_tmp326_ = vala_method_get_printf_format (_tmp325_);
		_tmp327_ = _tmp326_;
		if (_tmp327_) {
			ValaStringLiteral* format_literal = NULL;
			ValaExpression* _tmp328_;
			ValaStringLiteral* _tmp371_;
			format_literal = NULL;
			_tmp328_ = last_arg;
			if (_tmp328_ != NULL) {
				ValaExpression* _tmp329_;
				ValaStringLiteral* _tmp330_;
				gboolean _tmp331_ = FALSE;
				ValaStringLiteral* _tmp332_;
				_tmp329_ = last_arg;
				_tmp330_ = vala_string_literal_get_format_literal (_tmp329_);
				_vala_code_node_unref0 (format_literal);
				format_literal = _tmp330_;
				_tmp332_ = format_literal;
				if (_tmp332_ == NULL) {
					ValaList* _tmp333_;
					gint _tmp334_;
					gint _tmp335_;
					ValaMethod* _tmp336_;
					ValaList* _tmp337_;
					ValaList* _tmp338_;
					gint _tmp339_;
					gint _tmp340_;
					_tmp333_ = args;
					_tmp334_ = vala_collection_get_size ((ValaCollection*) _tmp333_);
					_tmp335_ = _tmp334_;
					_tmp336_ = m;
					_tmp337_ = vala_callable_get_parameters ((ValaCallable*) _tmp336_);
					_tmp338_ = _tmp337_;
					_tmp339_ = vala_collection_get_size ((ValaCollection*) _tmp338_);
					_tmp340_ = _tmp339_;
					_tmp331_ = _tmp335_ == (_tmp340_ - 1);
					_vala_iterable_unref0 (_tmp338_);
				} else {
					_tmp331_ = FALSE;
				}
				if (_tmp331_) {
					ValaStringLiteral* _tmp341_;
					ValaStringLiteral* _tmp342_;
					ValaCodeContext* _tmp343_;
					ValaSemanticAnalyzer* _tmp344_;
					ValaSemanticAnalyzer* _tmp345_;
					ValaDataType* _tmp346_;
					ValaDataType* _tmp347_;
					ValaDataType* _tmp348_;
					ValaList* _tmp349_;
					ValaList* _tmp350_;
					gint _tmp351_;
					gint _tmp352_;
					ValaStringLiteral* _tmp353_;
					ValaList* _tmp354_;
					ValaIterator* _tmp355_;
					_tmp341_ = vala_string_literal_new ("\"%s\"", NULL);
					_vala_code_node_unref0 (format_literal);
					format_literal = _tmp341_;
					_tmp342_ = format_literal;
					_tmp343_ = context;
					_tmp344_ = vala_code_context_get_analyzer (_tmp343_);
					_tmp345_ = _tmp344_;
					_tmp346_ = _tmp345_->string_type;
					_tmp347_ = vala_data_type_copy (_tmp346_);
					_tmp348_ = _tmp347_;
					vala_expression_set_target_type ((ValaExpression*) _tmp342_, _tmp348_);
					_vala_code_node_unref0 (_tmp348_);
					_tmp349_ = self->priv->argument_list;
					_tmp350_ = args;
					_tmp351_ = vala_collection_get_size ((ValaCollection*) _tmp350_);
					_tmp352_ = _tmp351_;
					_tmp353_ = format_literal;
					vala_list_insert (_tmp349_, _tmp352_ - 1, (ValaExpression*) _tmp353_);
					_tmp354_ = self->priv->argument_list;
					_tmp355_ = vala_iterable_iterator ((ValaIterable*) _tmp354_);
					_vala_iterator_unref0 (arg_it);
					arg_it = _tmp355_;
					{
						ValaList* _param_list = NULL;
						ValaMethod* _tmp356_;
						ValaList* _tmp357_;
						gint _param_size = 0;
						ValaList* _tmp358_;
						gint _tmp359_;
						gint _tmp360_;
						gint _param_index = 0;
						_tmp356_ = m;
						_tmp357_ = vala_callable_get_parameters ((ValaCallable*) _tmp356_);
						_param_list = _tmp357_;
						_tmp358_ = _param_list;
						_tmp359_ = vala_collection_get_size ((ValaCollection*) _tmp358_);
						_tmp360_ = _tmp359_;
						_param_size = _tmp360_;
						_param_index = -1;
						while (TRUE) {
							gint _tmp361_;
							gint _tmp362_;
							gint _tmp363_;
							ValaParameter* param = NULL;
							ValaList* _tmp364_;
							gint _tmp365_;
							gpointer _tmp366_;
							ValaParameter* _tmp367_;
							gboolean _tmp368_;
							gboolean _tmp369_;
							ValaIterator* _tmp370_;
							_tmp361_ = _param_index;
							_param_index = _tmp361_ + 1;
							_tmp362_ = _param_index;
							_tmp363_ = _param_size;
							if (!(_tmp362_ < _tmp363_)) {
								break;
							}
							_tmp364_ = _param_list;
							_tmp365_ = _param_index;
							_tmp366_ = vala_list_get (_tmp364_, _tmp365_);
							param = (ValaParameter*) _tmp366_;
							_tmp367_ = param;
							_tmp368_ = vala_parameter_get_ellipsis (_tmp367_);
							_tmp369_ = _tmp368_;
							if (_tmp369_) {
								_vala_code_node_unref0 (param);
								break;
							}
							_tmp370_ = arg_it;
							vala_iterator_next (_tmp370_);
							_vala_code_node_unref0 (param);
						}
						_vala_iterable_unref0 (_param_list);
					}
				}
			}
			_tmp371_ = format_literal;
			if (_tmp371_ != NULL) {
				gchar* format = NULL;
				ValaStringLiteral* _tmp372_;
				gchar* _tmp373_;
				ValaCodeContext* _tmp374_;
				ValaSemanticAnalyzer* _tmp375_;
				ValaSemanticAnalyzer* _tmp376_;
				const gchar* _tmp377_;
				ValaIterator* _tmp378_;
				ValaSourceReference* _tmp379_;
				ValaSourceReference* _tmp380_;
				gboolean _tmp381_;
				_tmp372_ = format_literal;
				_tmp373_ = vala_string_literal_eval (_tmp372_);
				format = _tmp373_;
				_tmp374_ = context;
				_tmp375_ = vala_code_context_get_analyzer (_tmp374_);
				_tmp376_ = _tmp375_;
				_tmp377_ = format;
				_tmp378_ = arg_it;
				_tmp379_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp380_ = _tmp379_;
				_tmp381_ = vala_semantic_analyzer_check_print_format (_tmp376_, _tmp377_, _tmp378_, _tmp380_);
				if (!_tmp381_) {
					result = FALSE;
					_g_free0 (format);
					_vala_code_node_unref0 (format_literal);
					_vala_iterator_unref0 (arg_it);
					_vala_iterable_unref0 (args);
					_vala_code_node_unref0 (last_arg);
					_vala_code_node_unref0 (m);
					_vala_code_node_unref0 (type);
					return result;
				}
				_g_free0 (format);
			}
			_vala_code_node_unref0 (format_literal);
		}
		{
			ValaList* _arg_list = NULL;
			ValaList* _tmp382_;
			ValaList* _tmp383_;
			gint _arg_size = 0;
			ValaList* _tmp384_;
			gint _tmp385_;
			gint _tmp386_;
			gint _arg_index = 0;
			_tmp382_ = args;
			_tmp383_ = _vala_iterable_ref0 (_tmp382_);
			_arg_list = _tmp383_;
			_tmp384_ = _arg_list;
			_tmp385_ = vala_collection_get_size ((ValaCollection*) _tmp384_);
			_tmp386_ = _tmp385_;
			_arg_size = _tmp386_;
			_arg_index = -1;
			while (TRUE) {
				gint _tmp387_;
				gint _tmp388_;
				gint _tmp389_;
				ValaExpression* arg = NULL;
				ValaList* _tmp390_;
				gint _tmp391_;
				gpointer _tmp392_;
				ValaExpression* _tmp393_;
				ValaCodeContext* _tmp394_;
				_tmp387_ = _arg_index;
				_arg_index = _tmp387_ + 1;
				_tmp388_ = _arg_index;
				_tmp389_ = _arg_size;
				if (!(_tmp388_ < _tmp389_)) {
					break;
				}
				_tmp390_ = _arg_list;
				_tmp391_ = _arg_index;
				_tmp392_ = vala_list_get (_tmp390_, _tmp391_);
				arg = (ValaExpression*) _tmp392_;
				_tmp393_ = arg;
				_tmp394_ = context;
				vala_code_node_check ((ValaCodeNode*) _tmp393_, _tmp394_);
				_vala_code_node_unref0 (arg);
			}
			_vala_iterable_unref0 (_arg_list);
		}
		_tmp395_ = context;
		_tmp396_ = vala_code_context_get_analyzer (_tmp395_);
		_tmp397_ = _tmp396_;
		_tmp398_ = m;
		_tmp399_ = vala_method_type_new (_tmp398_);
		_tmp400_ = _tmp399_;
		_tmp401_ = m;
		_tmp402_ = vala_callable_get_parameters ((ValaCallable*) _tmp401_);
		_tmp403_ = _tmp402_;
		_tmp404_ = args;
		vala_semantic_analyzer_check_arguments (_tmp397_, (ValaExpression*) self, (ValaDataType*) _tmp400_, _tmp403_, _tmp404_);
		_vala_iterable_unref0 (_tmp403_);
		_vala_code_node_unref0 (_tmp400_);
		{
			ValaList* _error_type_list = NULL;
			ValaMethod* _tmp405_;
			ValaList* _tmp406_;
			gint _error_type_size = 0;
			ValaList* _tmp407_;
			gint _tmp408_;
			gint _tmp409_;
			gint _error_type_index = 0;
			_tmp405_ = m;
			_tmp406_ = vala_code_node_get_error_types ((ValaCodeNode*) _tmp405_);
			_error_type_list = _tmp406_;
			_tmp407_ = _error_type_list;
			_tmp408_ = vala_collection_get_size ((ValaCollection*) _tmp407_);
			_tmp409_ = _tmp408_;
			_error_type_size = _tmp409_;
			_error_type_index = -1;
			while (TRUE) {
				gint _tmp410_;
				gint _tmp411_;
				gint _tmp412_;
				ValaDataType* error_type = NULL;
				ValaList* _tmp413_;
				gint _tmp414_;
				gpointer _tmp415_;
				ValaDataType* call_error_type = NULL;
				ValaDataType* _tmp416_;
				ValaDataType* _tmp417_;
				ValaDataType* _tmp418_;
				ValaSourceReference* _tmp419_;
				ValaSourceReference* _tmp420_;
				ValaDataType* _tmp421_;
				_tmp410_ = _error_type_index;
				_error_type_index = _tmp410_ + 1;
				_tmp411_ = _error_type_index;
				_tmp412_ = _error_type_size;
				if (!(_tmp411_ < _tmp412_)) {
					break;
				}
				_tmp413_ = _error_type_list;
				_tmp414_ = _error_type_index;
				_tmp415_ = vala_list_get (_tmp413_, _tmp414_);
				error_type = (ValaDataType*) _tmp415_;
				may_throw = TRUE;
				_tmp416_ = error_type;
				_tmp417_ = vala_data_type_copy (_tmp416_);
				call_error_type = _tmp417_;
				_tmp418_ = call_error_type;
				_tmp419_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp420_ = _tmp419_;
				vala_code_node_set_source_reference ((ValaCodeNode*) _tmp418_, _tmp420_);
				_tmp421_ = call_error_type;
				vala_code_node_add_error_type ((ValaCodeNode*) self, _tmp421_);
				_vala_code_node_unref0 (call_error_type);
				_vala_code_node_unref0 (error_type);
			}
			_vala_iterable_unref0 (_error_type_list);
		}
		_vala_iterator_unref0 (arg_it);
		_vala_iterable_unref0 (args);
		_vala_code_node_unref0 (last_arg);
		_vala_code_node_unref0 (m);
	} else {
		ValaDataType* _tmp422_;
		ValaDataType* _tmp423_;
		_tmp422_ = vala_object_creation_expression_get_type_reference (self);
		_tmp423_ = _tmp422_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp423_, VALA_TYPE_ERROR_TYPE)) {
			ValaDataType* _tmp424_;
			ValaDataType* _tmp425_;
			ValaMemberAccess* _tmp429_;
			ValaList* _tmp458_;
			ValaList* _tmp459_;
			gint _tmp460_;
			gint _tmp461_;
			gboolean _tmp462_;
			_tmp424_ = vala_object_creation_expression_get_type_reference (self);
			_tmp425_ = _tmp424_;
			if (_tmp425_ != NULL) {
				ValaDataType* _tmp426_;
				ValaDataType* _tmp427_;
				ValaCodeContext* _tmp428_;
				_tmp426_ = vala_object_creation_expression_get_type_reference (self);
				_tmp427_ = _tmp426_;
				_tmp428_ = context;
				vala_code_node_check ((ValaCodeNode*) _tmp427_, _tmp428_);
			}
			_tmp429_ = self->priv->_member_name;
			if (_tmp429_ != NULL) {
				ValaMemberAccess* _tmp430_;
				ValaCodeContext* _tmp431_;
				_tmp430_ = self->priv->_member_name;
				_tmp431_ = context;
				vala_code_node_check ((ValaCodeNode*) _tmp430_, _tmp431_);
			}
			{
				ValaList* _arg_list = NULL;
				ValaList* _tmp432_;
				ValaList* _tmp433_;
				gint _arg_size = 0;
				ValaList* _tmp434_;
				gint _tmp435_;
				gint _tmp436_;
				gint _arg_index = 0;
				_tmp432_ = self->priv->argument_list;
				_tmp433_ = _vala_iterable_ref0 (_tmp432_);
				_arg_list = _tmp433_;
				_tmp434_ = _arg_list;
				_tmp435_ = vala_collection_get_size ((ValaCollection*) _tmp434_);
				_tmp436_ = _tmp435_;
				_arg_size = _tmp436_;
				_arg_index = -1;
				while (TRUE) {
					gint _tmp437_;
					gint _tmp438_;
					gint _tmp439_;
					ValaExpression* arg = NULL;
					ValaList* _tmp440_;
					gint _tmp441_;
					gpointer _tmp442_;
					ValaExpression* _tmp443_;
					ValaCodeContext* _tmp444_;
					_tmp437_ = _arg_index;
					_arg_index = _tmp437_ + 1;
					_tmp438_ = _arg_index;
					_tmp439_ = _arg_size;
					if (!(_tmp438_ < _tmp439_)) {
						break;
					}
					_tmp440_ = _arg_list;
					_tmp441_ = _arg_index;
					_tmp442_ = vala_list_get (_tmp440_, _tmp441_);
					arg = (ValaExpression*) _tmp442_;
					_tmp443_ = arg;
					_tmp444_ = context;
					vala_code_node_check ((ValaCodeNode*) _tmp443_, _tmp444_);
					_vala_code_node_unref0 (arg);
				}
				_vala_iterable_unref0 (_arg_list);
			}
			{
				ValaList* _init_list = NULL;
				ValaList* _tmp445_;
				ValaList* _tmp446_;
				gint _init_size = 0;
				ValaList* _tmp447_;
				gint _tmp448_;
				gint _tmp449_;
				gint _init_index = 0;
				_tmp445_ = self->priv->object_initializer;
				_tmp446_ = _vala_iterable_ref0 (_tmp445_);
				_init_list = _tmp446_;
				_tmp447_ = _init_list;
				_tmp448_ = vala_collection_get_size ((ValaCollection*) _tmp447_);
				_tmp449_ = _tmp448_;
				_init_size = _tmp449_;
				_init_index = -1;
				while (TRUE) {
					gint _tmp450_;
					gint _tmp451_;
					gint _tmp452_;
					ValaMemberInitializer* init = NULL;
					ValaList* _tmp453_;
					gint _tmp454_;
					gpointer _tmp455_;
					ValaMemberInitializer* _tmp456_;
					ValaCodeContext* _tmp457_;
					_tmp450_ = _init_index;
					_init_index = _tmp450_ + 1;
					_tmp451_ = _init_index;
					_tmp452_ = _init_size;
					if (!(_tmp451_ < _tmp452_)) {
						break;
					}
					_tmp453_ = _init_list;
					_tmp454_ = _init_index;
					_tmp455_ = vala_list_get (_tmp453_, _tmp454_);
					init = (ValaMemberInitializer*) _tmp455_;
					_tmp456_ = init;
					_tmp457_ = context;
					vala_code_node_check ((ValaCodeNode*) _tmp456_, _tmp457_);
					_vala_code_node_unref0 (init);
				}
				_vala_iterable_unref0 (_init_list);
			}
			_tmp458_ = vala_object_creation_expression_get_argument_list (self);
			_tmp459_ = _tmp458_;
			_tmp460_ = vala_collection_get_size ((ValaCollection*) _tmp459_);
			_tmp461_ = _tmp460_;
			_tmp462_ = _tmp461_ == 0;
			_vala_iterable_unref0 (_tmp459_);
			if (_tmp462_) {
				ValaSourceReference* _tmp463_;
				ValaSourceReference* _tmp464_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp463_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp464_ = _tmp463_;
				vala_report_error (_tmp464_, "Too few arguments, errors need at least 1 argument");
			} else {
				ValaIterator* arg_it = NULL;
				ValaList* _tmp465_;
				ValaList* _tmp466_;
				ValaIterator* _tmp467_;
				ValaIterator* _tmp468_;
				ValaIterator* _tmp469_;
				ValaExpression* ex = NULL;
				ValaIterator* _tmp470_;
				gpointer _tmp471_;
				gboolean _tmp472_ = FALSE;
				ValaExpression* _tmp473_;
				ValaDataType* _tmp474_;
				ValaDataType* _tmp475_;
				ValaStringLiteral* format_literal = NULL;
				ValaExpression* _tmp486_;
				ValaStringLiteral* _tmp487_;
				ValaStringLiteral* _tmp488_;
				ValaList* _tmp499_;
				ValaList* _tmp500_;
				ValaIterator* _tmp501_;
				ValaIterator* _tmp502_;
				ValaCodeContext* _tmp503_;
				ValaSemanticAnalyzer* _tmp504_;
				ValaSemanticAnalyzer* _tmp505_;
				ValaIterator* _tmp506_;
				ValaSourceReference* _tmp507_;
				ValaSourceReference* _tmp508_;
				gboolean _tmp509_;
				_tmp465_ = vala_object_creation_expression_get_argument_list (self);
				_tmp466_ = _tmp465_;
				_tmp467_ = vala_iterable_iterator ((ValaIterable*) _tmp466_);
				_tmp468_ = _tmp467_;
				_vala_iterable_unref0 (_tmp466_);
				arg_it = _tmp468_;
				_tmp469_ = arg_it;
				vala_iterator_next (_tmp469_);
				_tmp470_ = arg_it;
				_tmp471_ = vala_iterator_get (_tmp470_);
				ex = (ValaExpression*) _tmp471_;
				_tmp473_ = ex;
				_tmp474_ = vala_expression_get_value_type (_tmp473_);
				_tmp475_ = _tmp474_;
				if (_tmp475_ == NULL) {
					_tmp472_ = TRUE;
				} else {
					ValaExpression* _tmp476_;
					ValaDataType* _tmp477_;
					ValaDataType* _tmp478_;
					ValaCodeContext* _tmp479_;
					ValaSemanticAnalyzer* _tmp480_;
					ValaSemanticAnalyzer* _tmp481_;
					ValaDataType* _tmp482_;
					gboolean _tmp483_;
					_tmp476_ = ex;
					_tmp477_ = vala_expression_get_value_type (_tmp476_);
					_tmp478_ = _tmp477_;
					_tmp479_ = context;
					_tmp480_ = vala_code_context_get_analyzer (_tmp479_);
					_tmp481_ = _tmp480_;
					_tmp482_ = _tmp481_->string_type;
					_tmp483_ = vala_data_type_compatible (_tmp478_, _tmp482_);
					_tmp472_ = !_tmp483_;
				}
				if (_tmp472_) {
					ValaSourceReference* _tmp484_;
					ValaSourceReference* _tmp485_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp484_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp485_ = _tmp484_;
					vala_report_error (_tmp485_, "Invalid type for argument 1");
				}
				_tmp486_ = ex;
				_tmp487_ = vala_string_literal_get_format_literal (_tmp486_);
				format_literal = _tmp487_;
				_tmp488_ = format_literal;
				if (_tmp488_ != NULL) {
					gchar* format = NULL;
					ValaStringLiteral* _tmp489_;
					gchar* _tmp490_;
					ValaCodeContext* _tmp491_;
					ValaSemanticAnalyzer* _tmp492_;
					ValaSemanticAnalyzer* _tmp493_;
					const gchar* _tmp494_;
					ValaIterator* _tmp495_;
					ValaSourceReference* _tmp496_;
					ValaSourceReference* _tmp497_;
					gboolean _tmp498_;
					_tmp489_ = format_literal;
					_tmp490_ = vala_string_literal_eval (_tmp489_);
					format = _tmp490_;
					_tmp491_ = context;
					_tmp492_ = vala_code_context_get_analyzer (_tmp491_);
					_tmp493_ = _tmp492_;
					_tmp494_ = format;
					_tmp495_ = arg_it;
					_tmp496_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp497_ = _tmp496_;
					_tmp498_ = vala_semantic_analyzer_check_print_format (_tmp493_, _tmp494_, _tmp495_, _tmp497_);
					if (!_tmp498_) {
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						result = FALSE;
						_g_free0 (format);
						_vala_code_node_unref0 (format_literal);
						_vala_code_node_unref0 (ex);
						_vala_iterator_unref0 (arg_it);
						_vala_code_node_unref0 (type);
						return result;
					}
					_g_free0 (format);
				}
				_tmp499_ = vala_object_creation_expression_get_argument_list (self);
				_tmp500_ = _tmp499_;
				_tmp501_ = vala_iterable_iterator ((ValaIterable*) _tmp500_);
				_vala_iterator_unref0 (arg_it);
				arg_it = _tmp501_;
				_vala_iterable_unref0 (_tmp500_);
				_tmp502_ = arg_it;
				vala_iterator_next (_tmp502_);
				_tmp503_ = context;
				_tmp504_ = vala_code_context_get_analyzer (_tmp503_);
				_tmp505_ = _tmp504_;
				_tmp506_ = arg_it;
				_tmp507_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp508_ = _tmp507_;
				_tmp509_ = vala_semantic_analyzer_check_variadic_arguments (_tmp505_, _tmp506_, 1, _tmp508_);
				if (!_tmp509_) {
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					result = FALSE;
					_vala_code_node_unref0 (format_literal);
					_vala_code_node_unref0 (ex);
					_vala_iterator_unref0 (arg_it);
					_vala_code_node_unref0 (type);
					return result;
				}
				_vala_code_node_unref0 (format_literal);
				_vala_code_node_unref0 (ex);
				_vala_iterator_unref0 (arg_it);
			}
		}
	}
	{
		ValaList* _init_list = NULL;
		ValaList* _tmp510_;
		gint _init_size = 0;
		ValaList* _tmp511_;
		gint _tmp512_;
		gint _tmp513_;
		gint _init_index = 0;
		_tmp510_ = vala_object_creation_expression_get_object_initializer (self);
		_init_list = _tmp510_;
		_tmp511_ = _init_list;
		_tmp512_ = vala_collection_get_size ((ValaCollection*) _tmp511_);
		_tmp513_ = _tmp512_;
		_init_size = _tmp513_;
		_init_index = -1;
		while (TRUE) {
			gint _tmp514_;
			gint _tmp515_;
			gint _tmp516_;
			ValaMemberInitializer* init = NULL;
			ValaList* _tmp517_;
			gint _tmp518_;
			gpointer _tmp519_;
			ValaCodeContext* _tmp520_;
			ValaSemanticAnalyzer* _tmp521_;
			ValaSemanticAnalyzer* _tmp522_;
			ValaMemberInitializer* _tmp523_;
			ValaDataType* _tmp524_;
			ValaDataType* _tmp525_;
			_tmp514_ = _init_index;
			_init_index = _tmp514_ + 1;
			_tmp515_ = _init_index;
			_tmp516_ = _init_size;
			if (!(_tmp515_ < _tmp516_)) {
				break;
			}
			_tmp517_ = _init_list;
			_tmp518_ = _init_index;
			_tmp519_ = vala_list_get (_tmp517_, _tmp518_);
			init = (ValaMemberInitializer*) _tmp519_;
			_tmp520_ = context;
			_tmp521_ = vala_code_context_get_analyzer (_tmp520_);
			_tmp522_ = _tmp521_;
			_tmp523_ = init;
			_tmp524_ = vala_object_creation_expression_get_type_reference (self);
			_tmp525_ = _tmp524_;
			vala_semantic_analyzer_visit_member_initializer (_tmp522_, _tmp523_, _tmp525_);
			_vala_code_node_unref0 (init);
		}
		_vala_iterable_unref0 (_init_list);
	}
	_tmp526_ = may_throw;
	if (_tmp526_) {
		gboolean _tmp527_ = FALSE;
		ValaCodeNode* _tmp528_;
		ValaCodeNode* _tmp529_;
		_tmp528_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp529_ = _tmp528_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp529_, VALA_TYPE_LOCAL_VARIABLE)) {
			_tmp527_ = TRUE;
		} else {
			ValaCodeNode* _tmp530_;
			ValaCodeNode* _tmp531_;
			_tmp530_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp531_ = _tmp530_;
			_tmp527_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp531_, VALA_TYPE_EXPRESSION_STATEMENT);
		}
		if (_tmp527_) {
		} else {
			ValaCodeContext* _tmp532_;
			ValaSemanticAnalyzer* _tmp533_;
			ValaSemanticAnalyzer* _tmp534_;
			ValaSymbol* _tmp535_;
			ValaSymbol* _tmp536_;
			_tmp532_ = context;
			_tmp533_ = vala_code_context_get_analyzer (_tmp532_);
			_tmp534_ = _tmp533_;
			_tmp535_ = vala_semantic_analyzer_get_current_symbol (_tmp534_);
			_tmp536_ = _tmp535_;
			if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp536_, VALA_TYPE_BLOCK)) {
				ValaSourceReference* _tmp537_;
				ValaSourceReference* _tmp538_;
				_tmp537_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp538_ = _tmp537_;
				vala_report_error (_tmp538_, "Field initializers must not throw errors");
			} else {
				ValaCodeNode* old_parent_node = NULL;
				ValaCodeNode* _tmp539_;
				ValaCodeNode* _tmp540_;
				ValaCodeNode* _tmp541_;
				ValaLocalVariable* local = NULL;
				ValaDataType* _tmp542_;
				ValaDataType* _tmp543_;
				ValaDataType* _tmp544_;
				ValaDataType* _tmp545_;
				gchar* _tmp546_;
				gchar* _tmp547_;
				ValaSourceReference* _tmp548_;
				ValaSourceReference* _tmp549_;
				ValaLocalVariable* _tmp550_;
				ValaLocalVariable* _tmp551_;
				ValaDeclarationStatement* decl = NULL;
				ValaLocalVariable* _tmp552_;
				ValaSourceReference* _tmp553_;
				ValaSourceReference* _tmp554_;
				ValaDeclarationStatement* _tmp555_;
				ValaCodeContext* _tmp556_;
				ValaSemanticAnalyzer* _tmp557_;
				ValaSemanticAnalyzer* _tmp558_;
				ValaBlock* _tmp559_;
				ValaDeclarationStatement* _tmp560_;
				ValaExpression* temp_access = NULL;
				ValaLocalVariable* _tmp561_;
				ValaDataType* _tmp562_;
				ValaDataType* _tmp563_;
				ValaExpression* _tmp564_;
				ValaLocalVariable* _tmp565_;
				ValaDeclarationStatement* _tmp566_;
				ValaCodeContext* _tmp567_;
				ValaBlock* block = NULL;
				ValaCodeContext* _tmp568_;
				ValaSemanticAnalyzer* _tmp569_;
				ValaSemanticAnalyzer* _tmp570_;
				ValaSymbol* _tmp571_;
				ValaSymbol* _tmp572_;
				ValaBlock* _tmp573_;
				ValaBlock* _tmp574_;
				ValaLocalVariable* _tmp575_;
				ValaCodeContext* _tmp576_;
				ValaSemanticAnalyzer* _tmp577_;
				ValaSemanticAnalyzer* _tmp578_;
				ValaBlock* _tmp579_;
				ValaLocalVariable* _tmp580_;
				ValaCodeNode* _tmp581_;
				ValaExpression* _tmp582_;
				ValaExpression* _tmp583_;
				ValaCodeContext* _tmp584_;
				_tmp539_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp540_ = _tmp539_;
				_tmp541_ = _vala_code_node_ref0 (_tmp540_);
				old_parent_node = _tmp541_;
				_tmp542_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp543_ = _tmp542_;
				_tmp544_ = vala_data_type_copy (_tmp543_);
				_tmp545_ = _tmp544_;
				_tmp546_ = vala_code_node_get_temp_name ();
				_tmp547_ = _tmp546_;
				_tmp548_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp549_ = _tmp548_;
				_tmp550_ = vala_local_variable_new (_tmp545_, _tmp547_, NULL, _tmp549_);
				_tmp551_ = _tmp550_;
				_g_free0 (_tmp547_);
				_vala_code_node_unref0 (_tmp545_);
				local = _tmp551_;
				_tmp552_ = local;
				_tmp553_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp554_ = _tmp553_;
				_tmp555_ = vala_declaration_statement_new ((ValaSymbol*) _tmp552_, _tmp554_);
				decl = _tmp555_;
				_tmp556_ = context;
				_tmp557_ = vala_code_context_get_analyzer (_tmp556_);
				_tmp558_ = _tmp557_;
				_tmp559_ = _tmp558_->insert_block;
				_tmp560_ = decl;
				vala_expression_insert_statement ((ValaExpression*) self, _tmp559_, (ValaStatement*) _tmp560_);
				_tmp561_ = local;
				_tmp562_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp563_ = _tmp562_;
				_tmp564_ = vala_semantic_analyzer_create_temp_access (_tmp561_, _tmp563_);
				temp_access = _tmp564_;
				_tmp565_ = local;
				vala_variable_set_initializer ((ValaVariable*) _tmp565_, (ValaExpression*) self);
				_tmp566_ = decl;
				_tmp567_ = context;
				vala_code_node_check ((ValaCodeNode*) _tmp566_, _tmp567_);
				_tmp568_ = context;
				_tmp569_ = vala_code_context_get_analyzer (_tmp568_);
				_tmp570_ = _tmp569_;
				_tmp571_ = vala_semantic_analyzer_get_current_symbol (_tmp570_);
				_tmp572_ = _tmp571_;
				_tmp573_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp572_, VALA_TYPE_BLOCK, ValaBlock));
				block = _tmp573_;
				_tmp574_ = block;
				_tmp575_ = local;
				vala_block_remove_local_variable (_tmp574_, _tmp575_);
				_tmp576_ = context;
				_tmp577_ = vala_code_context_get_analyzer (_tmp576_);
				_tmp578_ = _tmp577_;
				_tmp579_ = _tmp578_->insert_block;
				_tmp580_ = local;
				vala_block_add_local_variable (_tmp579_, _tmp580_);
				_tmp581_ = old_parent_node;
				_tmp582_ = temp_access;
				vala_code_node_replace_expression (_tmp581_, (ValaExpression*) self, _tmp582_);
				_tmp583_ = temp_access;
				_tmp584_ = context;
				vala_code_node_check ((ValaCodeNode*) _tmp583_, _tmp584_);
				_vala_code_node_unref0 (block);
				_vala_code_node_unref0 (temp_access);
				_vala_code_node_unref0 (decl);
				_vala_code_node_unref0 (local);
				_vala_code_node_unref0 (old_parent_node);
			}
		}
	}
	_tmp585_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp586_ = _tmp585_;
	result = !_tmp586_;
	_vala_code_node_unref0 (type);
	return result;
}


static void vala_object_creation_expression_real_emit (ValaCodeNode* base, ValaCodeGenerator* codegen) {
	ValaObjectCreationExpression * self;
	ValaCodeGenerator* _tmp26_;
	ValaCodeGenerator* _tmp27_;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (codegen != NULL);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _arg_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _arg_index = 0;
		_tmp0_ = self->priv->argument_list;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_arg_list = _tmp1_;
		_tmp2_ = _arg_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_arg_size = _tmp4_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaExpression* arg = NULL;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			ValaExpression* _tmp11_;
			ValaCodeGenerator* _tmp12_;
			_tmp5_ = _arg_index;
			_arg_index = _tmp5_ + 1;
			_tmp6_ = _arg_index;
			_tmp7_ = _arg_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _arg_list;
			_tmp9_ = _arg_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			arg = (ValaExpression*) _tmp10_;
			_tmp11_ = arg;
			_tmp12_ = codegen;
			vala_code_node_emit ((ValaCodeNode*) _tmp11_, _tmp12_);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	{
		ValaList* _init_list = NULL;
		ValaList* _tmp13_;
		ValaList* _tmp14_;
		gint _init_size = 0;
		ValaList* _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		gint _init_index = 0;
		_tmp13_ = self->priv->object_initializer;
		_tmp14_ = _vala_iterable_ref0 (_tmp13_);
		_init_list = _tmp14_;
		_tmp15_ = _init_list;
		_tmp16_ = vala_collection_get_size ((ValaCollection*) _tmp15_);
		_tmp17_ = _tmp16_;
		_init_size = _tmp17_;
		_init_index = -1;
		while (TRUE) {
			gint _tmp18_;
			gint _tmp19_;
			gint _tmp20_;
			ValaMemberInitializer* init = NULL;
			ValaList* _tmp21_;
			gint _tmp22_;
			gpointer _tmp23_;
			ValaMemberInitializer* _tmp24_;
			ValaCodeGenerator* _tmp25_;
			_tmp18_ = _init_index;
			_init_index = _tmp18_ + 1;
			_tmp19_ = _init_index;
			_tmp20_ = _init_size;
			if (!(_tmp19_ < _tmp20_)) {
				break;
			}
			_tmp21_ = _init_list;
			_tmp22_ = _init_index;
			_tmp23_ = vala_list_get (_tmp21_, _tmp22_);
			init = (ValaMemberInitializer*) _tmp23_;
			_tmp24_ = init;
			_tmp25_ = codegen;
			vala_code_node_emit ((ValaCodeNode*) _tmp24_, _tmp25_);
			_vala_code_node_unref0 (init);
		}
		_vala_iterable_unref0 (_init_list);
	}
	_tmp26_ = codegen;
	vala_code_visitor_visit_object_creation_expression ((ValaCodeVisitor*) _tmp26_, self);
	_tmp27_ = codegen;
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) _tmp27_, (ValaExpression*) self);
}


static void vala_object_creation_expression_real_get_defined_variables (ValaCodeNode* base, ValaCollection* collection) {
	ValaObjectCreationExpression * self;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (collection != NULL);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _arg_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _arg_index = 0;
		_tmp0_ = self->priv->argument_list;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_arg_list = _tmp1_;
		_tmp2_ = _arg_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_arg_size = _tmp4_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaExpression* arg = NULL;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			ValaExpression* _tmp11_;
			ValaCollection* _tmp12_;
			_tmp5_ = _arg_index;
			_arg_index = _tmp5_ + 1;
			_tmp6_ = _arg_index;
			_tmp7_ = _arg_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _arg_list;
			_tmp9_ = _arg_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			arg = (ValaExpression*) _tmp10_;
			_tmp11_ = arg;
			_tmp12_ = collection;
			vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp11_, _tmp12_);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
}


static void vala_object_creation_expression_real_get_used_variables (ValaCodeNode* base, ValaCollection* collection) {
	ValaObjectCreationExpression * self;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (collection != NULL);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _arg_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _arg_index = 0;
		_tmp0_ = self->priv->argument_list;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_arg_list = _tmp1_;
		_tmp2_ = _arg_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_arg_size = _tmp4_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaExpression* arg = NULL;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			ValaExpression* _tmp11_;
			ValaCollection* _tmp12_;
			_tmp5_ = _arg_index;
			_arg_index = _tmp5_ + 1;
			_tmp6_ = _arg_index;
			_tmp7_ = _arg_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _arg_list;
			_tmp9_ = _arg_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			arg = (ValaExpression*) _tmp10_;
			_tmp11_ = arg;
			_tmp12_ = collection;
			vala_code_node_get_used_variables ((ValaCodeNode*) _tmp11_, _tmp12_);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	{
		ValaList* _init_list = NULL;
		ValaList* _tmp13_;
		ValaList* _tmp14_;
		gint _init_size = 0;
		ValaList* _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		gint _init_index = 0;
		_tmp13_ = self->priv->object_initializer;
		_tmp14_ = _vala_iterable_ref0 (_tmp13_);
		_init_list = _tmp14_;
		_tmp15_ = _init_list;
		_tmp16_ = vala_collection_get_size ((ValaCollection*) _tmp15_);
		_tmp17_ = _tmp16_;
		_init_size = _tmp17_;
		_init_index = -1;
		while (TRUE) {
			gint _tmp18_;
			gint _tmp19_;
			gint _tmp20_;
			ValaMemberInitializer* init = NULL;
			ValaList* _tmp21_;
			gint _tmp22_;
			gpointer _tmp23_;
			ValaMemberInitializer* _tmp24_;
			ValaCollection* _tmp25_;
			_tmp18_ = _init_index;
			_init_index = _tmp18_ + 1;
			_tmp19_ = _init_index;
			_tmp20_ = _init_size;
			if (!(_tmp19_ < _tmp20_)) {
				break;
			}
			_tmp21_ = _init_list;
			_tmp22_ = _init_index;
			_tmp23_ = vala_list_get (_tmp21_, _tmp22_);
			init = (ValaMemberInitializer*) _tmp23_;
			_tmp24_ = init;
			_tmp25_ = collection;
			vala_code_node_get_used_variables ((ValaCodeNode*) _tmp24_, _tmp25_);
			_vala_code_node_unref0 (init);
		}
		_vala_iterable_unref0 (_init_list);
	}
}


ValaDataType* vala_object_creation_expression_get_type_reference (ValaObjectCreationExpression* self) {
	ValaDataType* result;
	ValaDataType* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_data_type;
	result = _tmp0_;
	return result;
}


void vala_object_creation_expression_set_type_reference (ValaObjectCreationExpression* self, ValaDataType* value) {
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	_vala_code_node_unref0 (self->priv->_data_type);
	self->priv->_data_type = _tmp1_;
	_tmp2_ = self->priv->_data_type;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
}


ValaMemberAccess* vala_object_creation_expression_get_member_name (ValaObjectCreationExpression* self) {
	ValaMemberAccess* result;
	ValaMemberAccess* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_member_name;
	result = _tmp0_;
	return result;
}


void vala_object_creation_expression_set_member_name (ValaObjectCreationExpression* self, ValaMemberAccess* value) {
	ValaMemberAccess* _tmp0_;
	ValaMemberAccess* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	_vala_code_node_unref0 (self->priv->_member_name);
	self->priv->_member_name = _tmp1_;
}


gboolean vala_object_creation_expression_get_is_yield_expression (ValaObjectCreationExpression* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_yield_expression;
	result = _tmp0_;
	return result;
}


void vala_object_creation_expression_set_is_yield_expression (ValaObjectCreationExpression* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_is_yield_expression = _tmp0_;
}


gboolean vala_object_creation_expression_get_struct_creation (ValaObjectCreationExpression* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_struct_creation;
	result = _tmp0_;
	return result;
}


void vala_object_creation_expression_set_struct_creation (ValaObjectCreationExpression* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_struct_creation = _tmp0_;
}


static void vala_object_creation_expression_class_init (ValaObjectCreationExpressionClass * klass) {
	vala_object_creation_expression_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_object_creation_expression_finalize;
	g_type_class_add_private (klass, sizeof (ValaObjectCreationExpressionPrivate));
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_object_creation_expression_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_object_creation_expression_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode *, ValaExpression*, ValaExpression*)) vala_object_creation_expression_real_replace_expression;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression *)) vala_object_creation_expression_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression *, ValaSymbol*)) vala_object_creation_expression_real_is_accessible;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode *, ValaDataType*, ValaDataType*)) vala_object_creation_expression_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode *, ValaCodeContext*)) vala_object_creation_expression_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode *, ValaCodeGenerator*)) vala_object_creation_expression_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode *, ValaCollection*)) vala_object_creation_expression_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode *, ValaCollection*)) vala_object_creation_expression_real_get_used_variables;
}


static void vala_object_creation_expression_instance_init (ValaObjectCreationExpression * self) {
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	GEqualFunc _tmp2_;
	ValaArrayList* _tmp3_;
	self->priv = VALA_OBJECT_CREATION_EXPRESSION_GET_PRIVATE (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->argument_list = (ValaList*) _tmp1_;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_array_list_new (VALA_TYPE_MEMBER_INITIALIZER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp2_);
	self->priv->object_initializer = (ValaList*) _tmp3_;
}


static void vala_object_creation_expression_finalize (ValaCodeNode * obj) {
	ValaObjectCreationExpression * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_OBJECT_CREATION_EXPRESSION, ValaObjectCreationExpression);
	_vala_code_node_unref0 (self->priv->_member_name);
	_vala_iterable_unref0 (self->priv->argument_list);
	_vala_iterable_unref0 (self->priv->object_initializer);
	_vala_code_node_unref0 (self->priv->_data_type);
	VALA_CODE_NODE_CLASS (vala_object_creation_expression_parent_class)->finalize (obj);
}


/**
 * Represents an object creation expression in the source code.
 */
GType vala_object_creation_expression_get_type (void) {
	static volatile gsize vala_object_creation_expression_type_id__volatile = 0;
	if (g_once_init_enter (&vala_object_creation_expression_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaObjectCreationExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_object_creation_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaObjectCreationExpression), 0, (GInstanceInitFunc) vala_object_creation_expression_instance_init, NULL };
		GType vala_object_creation_expression_type_id;
		vala_object_creation_expression_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaObjectCreationExpression", &g_define_type_info, 0);
		g_once_init_leave (&vala_object_creation_expression_type_id__volatile, vala_object_creation_expression_type_id);
	}
	return vala_object_creation_expression_type_id__volatile;
}



