/* tracker-dbus.c generated by valac 0.36.3, the Vala compiler
 * generated from tracker-dbus.vala, do not modify */

/*
 * Copyright (C) 2006, Jamie McCracken <jamiemcc@gnome.org>
 * Copyright (C) 2008-2011, Nokia <ivan.frade@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include "tracker-store/tracker-config.h"
#include <stdlib.h>
#include <string.h>
#include "libtracker-common/tracker-common.h"
#include <gobject/gvaluecollector.h>


#define TRACKER_TYPE_DBUS (tracker_dbus_get_type ())
#define TRACKER_DBUS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_DBUS, TrackerDBus))
#define TRACKER_DBUS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_DBUS, TrackerDBusClass))
#define TRACKER_IS_DBUS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_DBUS))
#define TRACKER_IS_DBUS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_DBUS))
#define TRACKER_DBUS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_DBUS, TrackerDBusClass))

typedef struct _TrackerDBus TrackerDBus;
typedef struct _TrackerDBusClass TrackerDBusClass;
typedef struct _TrackerDBusPrivate TrackerDBusPrivate;

#define TRACKER_TYPE_STATISTICS (tracker_statistics_get_type ())
#define TRACKER_STATISTICS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_STATISTICS, TrackerStatistics))
#define TRACKER_STATISTICS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_STATISTICS, TrackerStatisticsClass))
#define TRACKER_IS_STATISTICS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_STATISTICS))
#define TRACKER_IS_STATISTICS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_STATISTICS))
#define TRACKER_STATISTICS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_STATISTICS, TrackerStatisticsClass))

typedef struct _TrackerStatistics TrackerStatistics;
typedef struct _TrackerStatisticsClass TrackerStatisticsClass;

#define TRACKER_TYPE_RESOURCES (tracker_resources_get_type ())
#define TRACKER_RESOURCES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_RESOURCES, TrackerResources))
#define TRACKER_RESOURCES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_RESOURCES, TrackerResourcesClass))
#define TRACKER_IS_RESOURCES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_RESOURCES))
#define TRACKER_IS_RESOURCES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_RESOURCES))
#define TRACKER_RESOURCES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_RESOURCES, TrackerResourcesClass))

typedef struct _TrackerResources TrackerResources;
typedef struct _TrackerResourcesClass TrackerResourcesClass;

#define TRACKER_TYPE_STEROIDS (tracker_steroids_get_type ())
#define TRACKER_STEROIDS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_STEROIDS, TrackerSteroids))
#define TRACKER_STEROIDS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_STEROIDS, TrackerSteroidsClass))
#define TRACKER_IS_STEROIDS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_STEROIDS))
#define TRACKER_IS_STEROIDS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_STEROIDS))
#define TRACKER_STEROIDS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_STEROIDS, TrackerSteroidsClass))

typedef struct _TrackerSteroids TrackerSteroids;
typedef struct _TrackerSteroidsClass TrackerSteroidsClass;

#define TRACKER_TYPE_STATUS (tracker_status_get_type ())
#define TRACKER_STATUS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_STATUS, TrackerStatus))
#define TRACKER_STATUS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_STATUS, TrackerStatusClass))
#define TRACKER_IS_STATUS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_STATUS))
#define TRACKER_IS_STATUS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_STATUS))
#define TRACKER_STATUS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_STATUS, TrackerStatusClass))

typedef struct _TrackerStatus TrackerStatus;
typedef struct _TrackerStatusClass TrackerStatusClass;

#define TRACKER_TYPE_BACKUP (tracker_backup_get_type ())
#define TRACKER_BACKUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_BACKUP, TrackerBackup))
#define TRACKER_BACKUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_BACKUP, TrackerBackupClass))
#define TRACKER_IS_BACKUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_BACKUP))
#define TRACKER_IS_BACKUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_BACKUP))
#define TRACKER_BACKUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_BACKUP, TrackerBackupClass))

typedef struct _TrackerBackup TrackerBackup;
typedef struct _TrackerBackupClass TrackerBackupClass;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _TrackerParamSpecDBus TrackerParamSpecDBus;

struct _TrackerDBus {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TrackerDBusPrivate * priv;
};

struct _TrackerDBusClass {
	GTypeClass parent_class;
	void (*finalize) (TrackerDBus *self);
};

struct _TrackerParamSpecDBus {
	GParamSpec parent_instance;
};


static gpointer tracker_dbus_parent_class = NULL;
static GDBusConnection* tracker_dbus_connection;
static GDBusConnection* tracker_dbus_connection = NULL;
static guint tracker_dbus_name_owner_changed_id;
static guint tracker_dbus_name_owner_changed_id = 0U;
static TrackerStatistics* tracker_dbus_statistics;
static TrackerStatistics* tracker_dbus_statistics = NULL;
static guint tracker_dbus_statistics_id;
static guint tracker_dbus_statistics_id = 0U;
static TrackerResources* tracker_dbus_resources;
static TrackerResources* tracker_dbus_resources = NULL;
static guint tracker_dbus_resources_id;
static guint tracker_dbus_resources_id = 0U;
static TrackerSteroids* tracker_dbus_steroids;
static TrackerSteroids* tracker_dbus_steroids = NULL;
static guint tracker_dbus_steroids_id;
static guint tracker_dbus_steroids_id = 0U;
static TrackerStatus* tracker_dbus_notifier;
static TrackerStatus* tracker_dbus_notifier = NULL;
static guint tracker_dbus_notifier_id;
static guint tracker_dbus_notifier_id = 0U;
static TrackerBackup* tracker_dbus_backup;
static TrackerBackup* tracker_dbus_backup = NULL;
static guint tracker_dbus_backup_id;
static guint tracker_dbus_backup_id = 0U;
static TrackerConfig* tracker_dbus_config;
static TrackerConfig* tracker_dbus_config = NULL;
static guint tracker_dbus_domain_watch_id;
static guint tracker_dbus_domain_watch_id = 0U;
static GMainLoop* tracker_dbus_watch_main_loop;
static GMainLoop* tracker_dbus_watch_main_loop = NULL;

gpointer tracker_dbus_ref (gpointer instance);
void tracker_dbus_unref (gpointer instance);
GParamSpec* tracker_param_spec_dbus (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void tracker_value_set_dbus (GValue* value, gpointer v_object);
void tracker_value_take_dbus (GValue* value, gpointer v_object);
gpointer tracker_value_get_dbus (const GValue* value);
GType tracker_dbus_get_type (void) G_GNUC_CONST;
enum  {
	TRACKER_DBUS_DUMMY_PROPERTY
};
GType tracker_statistics_get_type (void) G_GNUC_CONST;
guint tracker_statistics_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType tracker_resources_get_type (void) G_GNUC_CONST;
guint tracker_resources_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType tracker_steroids_get_type (void) G_GNUC_CONST;
guint tracker_steroids_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType tracker_status_get_type (void) G_GNUC_CONST;
guint tracker_status_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType tracker_backup_get_type (void) G_GNUC_CONST;
guint tracker_backup_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
#define TRACKER_DBUS_SERVICE "org.freedesktop.Tracker1"
static gboolean tracker_dbus_dbus_register_service (const gchar* name);
static guint tracker_dbus_register_object (GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func, GDBusConnection* lconnection, gconstpointer object, const gchar* path);
static guint _vala_g_dbus_connection_register_object (GType type, void* object, GDBusConnection* connection, const gchar* path, GError** error);
gboolean tracker_dbus_register_names (const gchar* domain);
void tracker_dbus_on_domain_name_disappeared (GDBusConnection* connection, const gchar* name);
void tracker_status_wait (TrackerStatus* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tracker_status_wait_finish (TrackerStatus* self, GAsyncResult* _res_, GError** error);
void tracker_dbus_watch_domain (const gchar* domain, GMainLoop* main_loop);
static void _tracker_dbus_on_domain_name_disappeared_gbus_name_vanished_callback (GDBusConnection* connection, const gchar* name, gpointer self);
gboolean tracker_dbus_init (TrackerConfig* config_p);
static void tracker_dbus_name_owner_changed_cb (GDBusConnection* connection, const gchar* sender_name, const gchar* object_path, const gchar* interface_name, const gchar* signal_name, GVariant* parameters);
void tracker_resources_unreg_batches (TrackerResources* self, const gchar* old_owner);
static void tracker_dbus_set_available (gboolean available);
gboolean tracker_dbus_register_objects (void);
void tracker_dbus_shutdown (void);
TrackerStatus* tracker_dbus_register_notifier (void);
TrackerStatus* tracker_status_new (void);
TrackerStatus* tracker_status_construct (GType object_type);
#define TRACKER_STATUS_PATH "/org/freedesktop/Tracker1/Status"
TrackerStatistics* tracker_statistics_new (void);
TrackerStatistics* tracker_statistics_construct (GType object_type);
#define TRACKER_STATISTICS_PATH "/org/freedesktop/Tracker1/Statistics"
TrackerResources* tracker_resources_new (GDBusConnection* connection, TrackerConfig* config_p);
TrackerResources* tracker_resources_construct (GType object_type, GDBusConnection* connection, TrackerConfig* config_p);
static void _tracker_dbus_name_owner_changed_cb_gd_bus_signal_callback (GDBusConnection* connection, const gchar* sender_name, const gchar* object_path, const gchar* interface_name, const gchar* signal_name, GVariant* parameters, gpointer self);
#define TRACKER_RESOURCES_PATH "/org/freedesktop/Tracker1/Resources"
TrackerSteroids* tracker_steroids_new (void);
TrackerSteroids* tracker_steroids_construct (GType object_type);
#define TRACKER_STEROIDS_PATH "/org/freedesktop/Tracker1/Steroids"
TrackerBackup* tracker_backup_new (void);
TrackerBackup* tracker_backup_construct (GType object_type);
#define TRACKER_BACKUP_PATH "/org/freedesktop/Tracker1/Backup"
gboolean tracker_dbus_register_prepare_class_signal (void);
void tracker_resources_enable_signals (TrackerResources* self);
GObject* tracker_dbus_get_object (GType type);
TrackerDBus* tracker_dbus_new (void);
TrackerDBus* tracker_dbus_construct (GType object_type);
static void tracker_dbus_finalize (TrackerDBus * obj);


static gboolean tracker_dbus_dbus_register_service (const gchar* name) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gboolean _tmp13_ = FALSE;
	GError * _inner_error_ = NULL;
#line 41 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	g_return_val_if_fail (name != NULL, FALSE);
#line 42 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	_tmp0_ = name;
#line 42 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	g_message ("Registering D-Bus service...\n  Name:'%s'", _tmp0_);
#line 222 "tracker-dbus.c"
	{
		GVariant* reply = NULL;
		GDBusConnection* _tmp1_;
		const gchar* _tmp2_;
		GVariant* _tmp3_;
		GVariant* _tmp4_;
		GVariant* _tmp5_;
		GVariant* _tmp6_;
		guint _result_ = 0U;
		GVariant* _tmp7_;
		guint _tmp8_;
#line 45 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_tmp1_ = tracker_dbus_connection;
#line 45 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_tmp2_ = name;
#line 45 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_tmp3_ = g_variant_new ("(su)", _tmp2_, 1 << 2, NULL);
#line 45 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		g_variant_ref_sink (_tmp3_);
#line 45 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_tmp4_ = _tmp3_;
#line 45 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_tmp5_ = g_dbus_connection_call_sync (_tmp1_, "org.freedesktop.DBus", "/org/freedesktop/DBus", "org.freedesktop.DBus", "RequestName", _tmp4_, (const GVariantType*) "(u)", 0, -1, NULL, &_inner_error_);
#line 45 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_tmp6_ = _tmp5_;
#line 45 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_g_variant_unref0 (_tmp4_);
#line 45 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		reply = _tmp6_;
#line 45 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 254 "tracker-dbus.c"
			goto __catch2_g_error;
		}
#line 53 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_tmp7_ = reply;
#line 53 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		g_variant_get (_tmp7_, "(u)", &_result_, NULL);
#line 54 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_tmp8_ = _result_;
#line 54 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		if (_tmp8_ != ((guint) 1)) {
#line 265 "tracker-dbus.c"
			const gchar* _tmp9_;
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
			_tmp9_ = name;
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
			g_critical ("D-Bus service name:'%s' is already taken, " "perhaps the daemon is already running?", _tmp9_);
#line 58 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
			result = FALSE;
#line 58 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
			_g_variant_unref0 (reply);
#line 58 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
			return result;
#line 277 "tracker-dbus.c"
		}
#line 61 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		result = TRUE;
#line 61 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_g_variant_unref0 (reply);
#line 61 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		return result;
#line 285 "tracker-dbus.c"
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp10_;
		GError* _tmp11_;
		const gchar* _tmp12_;
#line 44 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		e = _inner_error_;
#line 44 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_inner_error_ = NULL;
#line 63 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_tmp10_ = name;
#line 63 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_tmp11_ = e;
#line 63 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_tmp12_ = _tmp11_->message;
#line 63 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		g_critical ("Could not aquire name:'%s', %s", _tmp10_, _tmp12_);
#line 64 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		result = FALSE;
#line 64 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_g_error_free0 (e);
#line 64 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		return result;
#line 312 "tracker-dbus.c"
	}
	__finally2:
#line 44 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 44 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	g_clear_error (&_inner_error_);
#line 44 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	return _tmp13_;
#line 321 "tracker-dbus.c"
}


static guint _vala_g_dbus_connection_register_object (GType type, void* object, GDBusConnection* connection, const gchar* path, GError** error) {
	void *func;
#line 74 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	func = g_type_get_qdata (type, g_quark_from_static_string ("vala-dbus-register-object"));
#line 74 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	if (!func) {
#line 74 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		g_set_error_literal (error, G_IO_ERROR, G_IO_ERROR_FAILED, "The specified type does not support D-Bus registration");
#line 74 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		return 0;
#line 335 "tracker-dbus.c"
	}
#line 74 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	return ((guint (*) (void *, GDBusConnection *, const gchar *, GError **)) func) (object, connection, path, error);
#line 339 "tracker-dbus.c"
}


static guint tracker_dbus_register_object (GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func, GDBusConnection* lconnection, gconstpointer object, const gchar* path) {
	guint result = 0U;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	guint _tmp8_ = 0U;
	GError * _inner_error_ = NULL;
#line 68 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	g_return_val_if_fail (lconnection != NULL, 0U);
#line 68 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	g_return_val_if_fail (path != NULL, 0U);
#line 69 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	g_message ("Registering D-Bus object...");
#line 70 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	_tmp0_ = path;
#line 70 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	g_message ("  Path:'%s'", _tmp0_);
#line 71 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	_tmp1_ = g_type_name (t_type);
#line 71 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	g_message ("  Type:'%s'", _tmp1_);
#line 363 "tracker-dbus.c"
	{
		guint id = 0U;
		GDBusConnection* _tmp2_;
		const gchar* _tmp3_;
		gconstpointer _tmp4_;
		guint _tmp5_;
#line 74 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_tmp2_ = lconnection;
#line 74 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_tmp3_ = path;
#line 74 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_tmp4_ = object;
#line 74 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_tmp5_ = _vala_g_dbus_connection_register_object (t_type, _tmp4_, _tmp2_, _tmp3_, &_inner_error_);
#line 74 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		id = _tmp5_;
#line 74 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 382 "tracker-dbus.c"
			goto __catch3_g_error;
		}
#line 75 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		result = id;
#line 75 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		return result;
#line 389 "tracker-dbus.c"
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
#line 73 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		e = _inner_error_;
#line 73 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_inner_error_ = NULL;
#line 77 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_tmp6_ = e;
#line 77 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_tmp7_ = _tmp6_->message;
#line 77 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		g_critical ("Could not register D-Bus object: %s", _tmp7_);
#line 78 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		result = (guint) 0;
#line 78 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_g_error_free0 (e);
#line 78 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		return result;
#line 413 "tracker-dbus.c"
	}
	__finally3:
#line 73 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 73 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	g_clear_error (&_inner_error_);
#line 73 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	return _tmp8_;
#line 422 "tracker-dbus.c"
}


gboolean tracker_dbus_register_names (const gchar* domain) {
	gboolean result = FALSE;
	gchar* service_name = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp4_;
	gboolean _tmp5_;
#line 85 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	_tmp0_ = domain;
#line 85 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	if (_tmp0_ != NULL) {
#line 436 "tracker-dbus.c"
		const gchar* _tmp1_;
		gchar* _tmp2_;
#line 86 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_tmp1_ = domain;
#line 86 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_tmp2_ = g_strdup (_tmp1_);
#line 86 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_g_free0 (service_name);
#line 86 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		service_name = _tmp2_;
#line 447 "tracker-dbus.c"
	} else {
		gchar* _tmp3_;
#line 89 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_tmp3_ = g_strdup (TRACKER_DBUS_SERVICE);
#line 89 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_g_free0 (service_name);
#line 89 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		service_name = _tmp3_;
#line 456 "tracker-dbus.c"
	}
#line 92 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	_tmp4_ = service_name;
#line 92 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	_tmp5_ = tracker_dbus_dbus_register_service (_tmp4_);
#line 92 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	result = _tmp5_;
#line 92 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	_g_free0 (service_name);
#line 92 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	return result;
#line 468 "tracker-dbus.c"
}


void tracker_dbus_on_domain_name_disappeared (GDBusConnection* connection, const gchar* name) {
	TrackerStatus* _tmp0_;
	GMainLoop* _tmp1_;
#line 95 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	g_return_if_fail (connection != NULL);
#line 95 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	g_return_if_fail (name != NULL);
#line 96 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	_tmp0_ = tracker_dbus_notifier;
#line 96 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	tracker_status_wait (_tmp0_, NULL, NULL);
#line 98 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	_tmp1_ = tracker_dbus_watch_main_loop;
#line 98 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	g_main_loop_quit (_tmp1_);
#line 487 "tracker-dbus.c"
}


static gpointer _g_main_loop_ref0 (gpointer self) {
#line 103 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	return self ? g_main_loop_ref (self) : NULL;
#line 494 "tracker-dbus.c"
}


static void _tracker_dbus_on_domain_name_disappeared_gbus_name_vanished_callback (GDBusConnection* connection, const gchar* name, gpointer self) {
#line 104 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	tracker_dbus_on_domain_name_disappeared (connection, name);
#line 501 "tracker-dbus.c"
}


void tracker_dbus_watch_domain (const gchar* domain, GMainLoop* main_loop) {
	gboolean _tmp0_ = FALSE;
	guint _tmp1_;
#line 101 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	g_return_if_fail (main_loop != NULL);
#line 102 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	_tmp1_ = tracker_dbus_domain_watch_id;
#line 102 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	if (_tmp1_ == ((guint) 0)) {
#line 514 "tracker-dbus.c"
		const gchar* _tmp2_;
#line 102 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_tmp2_ = domain;
#line 102 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_tmp0_ = _tmp2_ != NULL;
#line 520 "tracker-dbus.c"
	} else {
#line 102 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_tmp0_ = FALSE;
#line 524 "tracker-dbus.c"
	}
#line 102 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	if (_tmp0_) {
#line 528 "tracker-dbus.c"
		GMainLoop* _tmp3_;
		GMainLoop* _tmp4_;
		GDBusConnection* _tmp5_;
		const gchar* _tmp6_;
		guint _tmp7_;
#line 103 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_tmp3_ = main_loop;
#line 103 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_tmp4_ = _g_main_loop_ref0 (_tmp3_);
#line 103 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_g_main_loop_unref0 (tracker_dbus_watch_main_loop);
#line 103 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		tracker_dbus_watch_main_loop = _tmp4_;
#line 104 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_tmp5_ = tracker_dbus_connection;
#line 104 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_tmp6_ = domain;
#line 104 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_tmp7_ = g_bus_watch_name_on_connection_with_closures (_tmp5_, _tmp6_, G_BUS_NAME_WATCHER_FLAGS_NONE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((_tracker_dbus_on_domain_name_disappeared_gbus_name_vanished_callback == NULL) ? NULL : g_cclosure_new ((GCallback) _tracker_dbus_on_domain_name_disappeared_gbus_name_vanished_callback, NULL, (GClosureNotify) NULL)));
#line 104 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		tracker_dbus_domain_watch_id = _tmp7_;
#line 550 "tracker-dbus.c"
	}
}


static gpointer _g_object_ref0 (gpointer self) {
#line 113 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	return self ? g_object_ref (self) : NULL;
#line 558 "tracker-dbus.c"
}


gboolean tracker_dbus_init (TrackerConfig* config_p) {
	gboolean result = FALSE;
	TrackerConfig* _tmp0_;
	TrackerConfig* _tmp1_;
	GDBusConnection* _tmp2_;
	GError * _inner_error_ = NULL;
#line 111 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	g_return_val_if_fail (config_p != NULL, FALSE);
#line 113 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	_tmp0_ = config_p;
#line 113 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 113 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	_g_object_unref0 (tracker_dbus_config);
#line 113 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	tracker_dbus_config = _tmp1_;
#line 114 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	_tmp2_ = tracker_dbus_connection;
#line 114 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	if (_tmp2_ != NULL) {
#line 115 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		result = TRUE;
#line 115 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		return result;
#line 586 "tracker-dbus.c"
	}
	{
		GDBusConnection* _tmp3_ = NULL;
		GBusType _tmp4_;
		GDBusConnection* _tmp5_;
		GDBusConnection* _tmp6_;
#line 119 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_tmp4_ = tracker_ipc_bus ();
#line 119 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_tmp5_ = g_bus_get_sync (_tmp4_, NULL, &_inner_error_);
#line 119 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_tmp3_ = _tmp5_;
#line 119 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 601 "tracker-dbus.c"
			goto __catch4_g_error;
		}
#line 119 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_tmp6_ = _tmp3_;
#line 119 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_tmp3_ = NULL;
#line 119 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_g_object_unref0 (tracker_dbus_connection);
#line 119 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		tracker_dbus_connection = _tmp6_;
#line 118 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_g_object_unref0 (_tmp3_);
#line 614 "tracker-dbus.c"
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* e = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
#line 118 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		e = _inner_error_;
#line 118 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_inner_error_ = NULL;
#line 121 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_tmp7_ = e;
#line 121 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_tmp8_ = _tmp7_->message;
#line 121 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		g_critical ("Could not connect to the D-Bus session bus, %s", _tmp8_);
#line 122 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		result = FALSE;
#line 122 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_g_error_free0 (e);
#line 122 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		return result;
#line 638 "tracker-dbus.c"
	}
	__finally4:
#line 118 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 643 "tracker-dbus.c"
		gboolean _tmp9_ = FALSE;
#line 118 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 118 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		g_clear_error (&_inner_error_);
#line 118 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		return _tmp9_;
#line 651 "tracker-dbus.c"
	}
#line 125 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	result = TRUE;
#line 125 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	return result;
#line 657 "tracker-dbus.c"
}


static void tracker_dbus_name_owner_changed_cb (GDBusConnection* connection, const gchar* sender_name, const gchar* object_path, const gchar* interface_name, const gchar* signal_name, GVariant* parameters) {
	const gchar* name = NULL;
	const gchar* old_owner = NULL;
	const gchar* new_owner = NULL;
	GVariant* _tmp0_;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
#line 128 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	g_return_if_fail (connection != NULL);
#line 128 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	g_return_if_fail (sender_name != NULL);
#line 128 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	g_return_if_fail (object_path != NULL);
#line 128 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	g_return_if_fail (interface_name != NULL);
#line 128 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	g_return_if_fail (signal_name != NULL);
#line 128 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	g_return_if_fail (parameters != NULL);
#line 131 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	_tmp0_ = parameters;
#line 131 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	g_variant_get (_tmp0_, "(&s&s&s)", &name, &old_owner, &new_owner, NULL);
#line 133 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	_tmp2_ = old_owner;
#line 133 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	if (g_strcmp0 (_tmp2_, "") != 0) {
#line 688 "tracker-dbus.c"
		const gchar* _tmp3_;
#line 133 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_tmp3_ = new_owner;
#line 133 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_tmp1_ = g_strcmp0 (_tmp3_, "") == 0;
#line 694 "tracker-dbus.c"
	} else {
#line 133 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_tmp1_ = FALSE;
#line 698 "tracker-dbus.c"
	}
#line 133 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	if (_tmp1_) {
#line 702 "tracker-dbus.c"
		TrackerResources* _tmp4_;
		const gchar* _tmp5_;
#line 135 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_tmp4_ = tracker_dbus_resources;
#line 135 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_tmp5_ = old_owner;
#line 135 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		tracker_resources_unreg_batches (_tmp4_, _tmp5_);
#line 711 "tracker-dbus.c"
	}
}


static void tracker_dbus_set_available (gboolean available) {
	gboolean _tmp0_;
#line 140 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	_tmp0_ = available;
#line 140 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	if (_tmp0_) {
#line 722 "tracker-dbus.c"
		guint _tmp1_;
#line 141 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_tmp1_ = tracker_dbus_resources_id;
#line 141 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		if (_tmp1_ == ((guint) 0)) {
#line 142 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
			tracker_dbus_register_objects ();
#line 730 "tracker-dbus.c"
		}
	} else {
		guint _tmp2_;
#line 145 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_tmp2_ = tracker_dbus_resources_id;
#line 145 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		if (_tmp2_ != ((guint) 0)) {
#line 738 "tracker-dbus.c"
			GDBusConnection* _tmp3_;
			guint _tmp4_;
			GDBusConnection* _tmp5_;
			guint _tmp6_;
			GDBusConnection* _tmp7_;
			guint _tmp8_;
#line 146 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
			_tmp3_ = tracker_dbus_connection;
#line 146 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
			_tmp4_ = tracker_dbus_name_owner_changed_id;
#line 146 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
			g_dbus_connection_signal_unsubscribe (_tmp3_, _tmp4_);
#line 147 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
			tracker_dbus_name_owner_changed_id = (guint) 0;
#line 149 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
			_tmp5_ = tracker_dbus_connection;
#line 149 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
			_tmp6_ = tracker_dbus_resources_id;
#line 149 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
			g_dbus_connection_unregister_object (_tmp5_, _tmp6_);
#line 150 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
			_g_object_unref0 (tracker_dbus_resources);
#line 150 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
			tracker_dbus_resources = NULL;
#line 151 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
			tracker_dbus_resources_id = (guint) 0;
#line 153 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
			_tmp7_ = tracker_dbus_connection;
#line 153 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
			_tmp8_ = tracker_dbus_steroids_id;
#line 153 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
			g_dbus_connection_unregister_object (_tmp7_, _tmp8_);
#line 154 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
			_g_object_unref0 (tracker_dbus_steroids);
#line 154 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
			tracker_dbus_steroids = NULL;
#line 155 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
			tracker_dbus_steroids_id = (guint) 0;
#line 777 "tracker-dbus.c"
		}
	}
}


void tracker_dbus_shutdown (void) {
	TrackerBackup* _tmp0_;
	TrackerStatus* _tmp3_;
	guint _tmp6_;
#line 161 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	tracker_dbus_set_available (FALSE);
#line 163 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	_tmp0_ = tracker_dbus_backup;
#line 163 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	if (_tmp0_ != NULL) {
#line 793 "tracker-dbus.c"
		GDBusConnection* _tmp1_;
		guint _tmp2_;
#line 164 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_tmp1_ = tracker_dbus_connection;
#line 164 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_tmp2_ = tracker_dbus_backup_id;
#line 164 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		g_dbus_connection_unregister_object (_tmp1_, _tmp2_);
#line 165 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_g_object_unref0 (tracker_dbus_backup);
#line 165 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		tracker_dbus_backup = NULL;
#line 166 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		tracker_dbus_backup_id = (guint) 0;
#line 808 "tracker-dbus.c"
	}
#line 169 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	_tmp3_ = tracker_dbus_notifier;
#line 169 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	if (_tmp3_ != NULL) {
#line 814 "tracker-dbus.c"
		GDBusConnection* _tmp4_;
		guint _tmp5_;
#line 170 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_tmp4_ = tracker_dbus_connection;
#line 170 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_tmp5_ = tracker_dbus_notifier_id;
#line 170 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		g_dbus_connection_unregister_object (_tmp4_, _tmp5_);
#line 171 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_g_object_unref0 (tracker_dbus_notifier);
#line 171 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		tracker_dbus_notifier = NULL;
#line 172 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		tracker_dbus_notifier_id = (guint) 0;
#line 829 "tracker-dbus.c"
	}
#line 175 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	_tmp6_ = tracker_dbus_domain_watch_id;
#line 175 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	if (_tmp6_ != ((guint) 0)) {
#line 835 "tracker-dbus.c"
		guint _tmp7_;
#line 176 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_tmp7_ = tracker_dbus_domain_watch_id;
#line 176 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		g_bus_unwatch_name (_tmp7_);
#line 177 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		tracker_dbus_domain_watch_id = (guint) 0;
#line 843 "tracker-dbus.c"
	}
#line 180 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	_g_object_unref0 (tracker_dbus_connection);
#line 180 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	tracker_dbus_connection = NULL;
#line 849 "tracker-dbus.c"
}


TrackerStatus* tracker_dbus_register_notifier (void) {
	TrackerStatus* result = NULL;
	GDBusConnection* _tmp0_;
	TrackerStatus* _tmp1_;
	TrackerStatus* _tmp2_;
	GDBusConnection* _tmp3_;
	TrackerStatus* _tmp4_;
	guint _tmp5_;
	TrackerStatus* _tmp6_;
	TrackerStatus* _tmp7_;
#line 184 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	_tmp0_ = tracker_dbus_connection;
#line 184 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	if (_tmp0_ == NULL) {
#line 185 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		g_critical ("D-Bus support must be initialized before registering objects!");
#line 186 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		result = NULL;
#line 186 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		return result;
#line 873 "tracker-dbus.c"
	}
#line 190 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	_tmp1_ = tracker_status_new ();
#line 190 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	_g_object_unref0 (tracker_dbus_notifier);
#line 190 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	tracker_dbus_notifier = _tmp1_;
#line 191 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	_tmp2_ = tracker_dbus_notifier;
#line 191 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	if (_tmp2_ == NULL) {
#line 192 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		g_critical ("Could not create TrackerStatus object to register");
#line 193 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		result = NULL;
#line 193 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		return result;
#line 891 "tracker-dbus.c"
	}
#line 196 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	_tmp3_ = tracker_dbus_connection;
#line 196 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	_tmp4_ = tracker_dbus_notifier;
#line 196 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	_tmp5_ = tracker_dbus_register_object (TRACKER_TYPE_STATUS, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp3_, _tmp4_, TRACKER_STATUS_PATH);
#line 196 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	tracker_dbus_notifier_id = _tmp5_;
#line 198 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	_tmp6_ = tracker_dbus_notifier;
#line 198 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	_tmp7_ = _g_object_ref0 (_tmp6_);
#line 198 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	result = _tmp7_;
#line 198 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	return result;
#line 909 "tracker-dbus.c"
}


static void _tracker_dbus_name_owner_changed_cb_gd_bus_signal_callback (GDBusConnection* connection, const gchar* sender_name, const gchar* object_path, const gchar* interface_name, const gchar* signal_name, GVariant* parameters, gpointer self) {
#line 225 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	tracker_dbus_name_owner_changed_cb (connection, sender_name, object_path, interface_name, signal_name, parameters);
#line 916 "tracker-dbus.c"
}


gboolean tracker_dbus_register_objects (void) {
	gboolean result = FALSE;
	GDBusConnection* _tmp0_;
	TrackerStatistics* _tmp1_;
	TrackerStatistics* _tmp2_;
	GDBusConnection* _tmp3_;
	TrackerStatistics* _tmp4_;
	guint _tmp5_;
	GDBusConnection* _tmp6_;
	TrackerConfig* _tmp7_;
	TrackerResources* _tmp8_;
	TrackerResources* _tmp9_;
	GDBusConnection* _tmp10_;
	guint _tmp11_;
	GDBusConnection* _tmp12_;
	TrackerResources* _tmp13_;
	guint _tmp14_;
	TrackerSteroids* _tmp15_;
	TrackerSteroids* _tmp16_;
	GDBusConnection* _tmp17_;
	TrackerSteroids* _tmp18_;
	guint _tmp19_;
	TrackerBackup* _tmp20_;
#line 204 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	_tmp0_ = tracker_dbus_connection;
#line 204 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	if (_tmp0_ == NULL) {
#line 205 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		g_critical ("D-Bus support must be initialized before registering objects!");
#line 206 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		result = FALSE;
#line 206 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		return result;
#line 953 "tracker-dbus.c"
	}
#line 210 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	_tmp1_ = tracker_statistics_new ();
#line 210 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	_g_object_unref0 (tracker_dbus_statistics);
#line 210 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	tracker_dbus_statistics = _tmp1_;
#line 211 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	_tmp2_ = tracker_dbus_statistics;
#line 211 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	if (_tmp2_ == NULL) {
#line 212 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		g_critical ("Could not create TrackerStatistics object to register");
#line 213 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		result = FALSE;
#line 213 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		return result;
#line 971 "tracker-dbus.c"
	}
#line 216 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	_tmp3_ = tracker_dbus_connection;
#line 216 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	_tmp4_ = tracker_dbus_statistics;
#line 216 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	_tmp5_ = tracker_dbus_register_object (TRACKER_TYPE_STATISTICS, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp3_, _tmp4_, TRACKER_STATISTICS_PATH);
#line 216 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	tracker_dbus_statistics_id = _tmp5_;
#line 219 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	_tmp6_ = tracker_dbus_connection;
#line 219 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	_tmp7_ = tracker_dbus_config;
#line 219 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	_tmp8_ = tracker_resources_new (_tmp6_, _tmp7_);
#line 219 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	_g_object_unref0 (tracker_dbus_resources);
#line 219 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	tracker_dbus_resources = _tmp8_;
#line 220 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	_tmp9_ = tracker_dbus_resources;
#line 220 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	if (_tmp9_ == NULL) {
#line 221 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		g_critical ("Could not create TrackerResources object to register");
#line 222 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		result = FALSE;
#line 222 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		return result;
#line 1001 "tracker-dbus.c"
	}
#line 225 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	_tmp10_ = tracker_dbus_connection;
#line 225 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	_tmp11_ = g_dbus_connection_signal_subscribe (_tmp10_, "org.freedesktop.DBus", "org.freedesktop.DBus", "NameOwnerChanged", "/org/freedesktop/DBus", NULL, 0, _tracker_dbus_name_owner_changed_cb_gd_bus_signal_callback, NULL, NULL);
#line 225 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	tracker_dbus_name_owner_changed_id = _tmp11_;
#line 232 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	_tmp12_ = tracker_dbus_connection;
#line 232 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	_tmp13_ = tracker_dbus_resources;
#line 232 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	_tmp14_ = tracker_dbus_register_object (TRACKER_TYPE_RESOURCES, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp12_, _tmp13_, TRACKER_RESOURCES_PATH);
#line 232 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	tracker_dbus_resources_id = _tmp14_;
#line 235 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	_tmp15_ = tracker_steroids_new ();
#line 235 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	_g_object_unref0 (tracker_dbus_steroids);
#line 235 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	tracker_dbus_steroids = _tmp15_;
#line 236 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	_tmp16_ = tracker_dbus_steroids;
#line 236 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	if (_tmp16_ == NULL) {
#line 237 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		g_critical ("Could not create TrackerSteroids object to register");
#line 238 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		result = FALSE;
#line 238 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		return result;
#line 1033 "tracker-dbus.c"
	}
#line 241 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	_tmp17_ = tracker_dbus_connection;
#line 241 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	_tmp18_ = tracker_dbus_steroids;
#line 241 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	_tmp19_ = tracker_dbus_register_object (TRACKER_TYPE_STEROIDS, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp17_, _tmp18_, TRACKER_STEROIDS_PATH);
#line 241 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	tracker_dbus_steroids_id = _tmp19_;
#line 243 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	_tmp20_ = tracker_dbus_backup;
#line 243 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	if (_tmp20_ == NULL) {
#line 1047 "tracker-dbus.c"
		TrackerBackup* _tmp21_;
		TrackerBackup* _tmp22_;
		GDBusConnection* _tmp23_;
		TrackerBackup* _tmp24_;
		guint _tmp25_;
#line 245 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_tmp21_ = tracker_backup_new ();
#line 245 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_g_object_unref0 (tracker_dbus_backup);
#line 245 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		tracker_dbus_backup = _tmp21_;
#line 246 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_tmp22_ = tracker_dbus_backup;
#line 246 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		if (_tmp22_ == NULL) {
#line 247 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
			g_critical ("Could not create TrackerBackup object to register");
#line 248 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
			result = FALSE;
#line 248 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
			return result;
#line 1069 "tracker-dbus.c"
		}
#line 252 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_tmp23_ = tracker_dbus_connection;
#line 252 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_tmp24_ = tracker_dbus_backup;
#line 252 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_tmp25_ = tracker_dbus_register_object (TRACKER_TYPE_BACKUP, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp23_, _tmp24_, TRACKER_BACKUP_PATH);
#line 252 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		tracker_dbus_backup_id = _tmp25_;
#line 1079 "tracker-dbus.c"
	}
#line 255 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	result = TRUE;
#line 255 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	return result;
#line 1085 "tracker-dbus.c"
}


gboolean tracker_dbus_register_prepare_class_signal (void) {
	gboolean result = FALSE;
	TrackerResources* _tmp0_;
	TrackerResources* _tmp1_;
#line 259 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	_tmp0_ = tracker_dbus_resources;
#line 259 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	if (_tmp0_ == NULL) {
#line 260 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		g_message ("Error during initialization, Resources DBus object not available");
#line 261 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		result = FALSE;
#line 261 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		return result;
#line 1103 "tracker-dbus.c"
	}
#line 264 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	_tmp1_ = tracker_dbus_resources;
#line 264 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	tracker_resources_enable_signals (_tmp1_);
#line 266 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	result = TRUE;
#line 266 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	return result;
#line 1113 "tracker-dbus.c"
}


GObject* tracker_dbus_get_object (GType type) {
	GObject* result = NULL;
	GType _tmp0_;
	GType _tmp3_;
	GType _tmp6_;
	GType _tmp9_;
#line 270 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	_tmp0_ = type;
#line 270 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	if (_tmp0_ == TRACKER_TYPE_RESOURCES) {
#line 1127 "tracker-dbus.c"
		TrackerResources* _tmp1_;
		GObject* _tmp2_;
#line 271 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_tmp1_ = tracker_dbus_resources;
#line 271 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_tmp2_ = _g_object_ref0 ((GObject*) _tmp1_);
#line 271 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		result = _tmp2_;
#line 271 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		return result;
#line 1138 "tracker-dbus.c"
	}
#line 274 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	_tmp3_ = type;
#line 274 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	if (_tmp3_ == TRACKER_TYPE_STEROIDS) {
#line 1144 "tracker-dbus.c"
		TrackerSteroids* _tmp4_;
		GObject* _tmp5_;
#line 275 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_tmp4_ = tracker_dbus_steroids;
#line 275 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_tmp5_ = _g_object_ref0 ((GObject*) _tmp4_);
#line 275 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		result = _tmp5_;
#line 275 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		return result;
#line 1155 "tracker-dbus.c"
	}
#line 278 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	_tmp6_ = type;
#line 278 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	if (_tmp6_ == TRACKER_TYPE_STATUS) {
#line 1161 "tracker-dbus.c"
		TrackerStatus* _tmp7_;
		GObject* _tmp8_;
#line 279 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_tmp7_ = tracker_dbus_notifier;
#line 279 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_tmp8_ = _g_object_ref0 ((GObject*) _tmp7_);
#line 279 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		result = _tmp8_;
#line 279 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		return result;
#line 1172 "tracker-dbus.c"
	}
#line 282 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	_tmp9_ = type;
#line 282 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	if (_tmp9_ == TRACKER_TYPE_BACKUP) {
#line 1178 "tracker-dbus.c"
		TrackerBackup* _tmp10_;
		GObject* _tmp11_;
#line 283 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_tmp10_ = tracker_dbus_backup;
#line 283 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_tmp11_ = _g_object_ref0 ((GObject*) _tmp10_);
#line 283 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		result = _tmp11_;
#line 283 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		return result;
#line 1189 "tracker-dbus.c"
	}
#line 286 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	result = NULL;
#line 286 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	return result;
#line 1195 "tracker-dbus.c"
}


TrackerDBus* tracker_dbus_construct (GType object_type) {
	TrackerDBus* self = NULL;
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	self = (TrackerDBus*) g_type_create_instance (object_type);
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	return self;
#line 1205 "tracker-dbus.c"
}


TrackerDBus* tracker_dbus_new (void) {
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	return tracker_dbus_construct (TRACKER_TYPE_DBUS);
#line 1212 "tracker-dbus.c"
}


static void tracker_value_dbus_init (GValue* value) {
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	value->data[0].v_pointer = NULL;
#line 1219 "tracker-dbus.c"
}


static void tracker_value_dbus_free_value (GValue* value) {
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	if (value->data[0].v_pointer) {
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		tracker_dbus_unref (value->data[0].v_pointer);
#line 1228 "tracker-dbus.c"
	}
}


static void tracker_value_dbus_copy_value (const GValue* src_value, GValue* dest_value) {
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	if (src_value->data[0].v_pointer) {
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		dest_value->data[0].v_pointer = tracker_dbus_ref (src_value->data[0].v_pointer);
#line 1238 "tracker-dbus.c"
	} else {
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		dest_value->data[0].v_pointer = NULL;
#line 1242 "tracker-dbus.c"
	}
}


static gpointer tracker_value_dbus_peek_pointer (const GValue* value) {
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	return value->data[0].v_pointer;
#line 1250 "tracker-dbus.c"
}


static gchar* tracker_value_dbus_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	if (collect_values[0].v_pointer) {
#line 1257 "tracker-dbus.c"
		TrackerDBus * object;
		object = collect_values[0].v_pointer;
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		if (object->parent_instance.g_class == NULL) {
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1264 "tracker-dbus.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1268 "tracker-dbus.c"
		}
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		value->data[0].v_pointer = tracker_dbus_ref (object);
#line 1272 "tracker-dbus.c"
	} else {
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		value->data[0].v_pointer = NULL;
#line 1276 "tracker-dbus.c"
	}
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	return NULL;
#line 1280 "tracker-dbus.c"
}


static gchar* tracker_value_dbus_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	TrackerDBus ** object_p;
	object_p = collect_values[0].v_pointer;
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	if (!object_p) {
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 1291 "tracker-dbus.c"
	}
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	if (!value->data[0].v_pointer) {
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		*object_p = NULL;
#line 1297 "tracker-dbus.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		*object_p = value->data[0].v_pointer;
#line 1301 "tracker-dbus.c"
	} else {
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		*object_p = tracker_dbus_ref (value->data[0].v_pointer);
#line 1305 "tracker-dbus.c"
	}
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	return NULL;
#line 1309 "tracker-dbus.c"
}


GParamSpec* tracker_param_spec_dbus (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	TrackerParamSpecDBus* spec;
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TRACKER_TYPE_DBUS), NULL);
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	return G_PARAM_SPEC (spec);
#line 1323 "tracker-dbus.c"
}


gpointer tracker_value_get_dbus (const GValue* value) {
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_TYPE_DBUS), NULL);
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	return value->data[0].v_pointer;
#line 1332 "tracker-dbus.c"
}


void tracker_value_set_dbus (GValue* value, gpointer v_object) {
	TrackerDBus * old;
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_TYPE_DBUS));
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	old = value->data[0].v_pointer;
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	if (v_object) {
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TRACKER_TYPE_DBUS));
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		value->data[0].v_pointer = v_object;
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		tracker_dbus_ref (value->data[0].v_pointer);
#line 1352 "tracker-dbus.c"
	} else {
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		value->data[0].v_pointer = NULL;
#line 1356 "tracker-dbus.c"
	}
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	if (old) {
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		tracker_dbus_unref (old);
#line 1362 "tracker-dbus.c"
	}
}


void tracker_value_take_dbus (GValue* value, gpointer v_object) {
	TrackerDBus * old;
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_TYPE_DBUS));
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	old = value->data[0].v_pointer;
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	if (v_object) {
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TRACKER_TYPE_DBUS));
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		value->data[0].v_pointer = v_object;
#line 1381 "tracker-dbus.c"
	} else {
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		value->data[0].v_pointer = NULL;
#line 1385 "tracker-dbus.c"
	}
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	if (old) {
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		tracker_dbus_unref (old);
#line 1391 "tracker-dbus.c"
	}
}


static void tracker_dbus_class_init (TrackerDBusClass * klass) {
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	tracker_dbus_parent_class = g_type_class_peek_parent (klass);
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	((TrackerDBusClass *) klass)->finalize = tracker_dbus_finalize;
#line 1401 "tracker-dbus.c"
}


static void tracker_dbus_instance_init (TrackerDBus * self) {
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	self->ref_count = 1;
#line 1408 "tracker-dbus.c"
}


static void tracker_dbus_finalize (TrackerDBus * obj) {
	TrackerDBus * self;
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_TYPE_DBUS, TrackerDBus);
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	g_signal_handlers_destroy (self);
#line 1418 "tracker-dbus.c"
}


GType tracker_dbus_get_type (void) {
	static volatile gsize tracker_dbus_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_dbus_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { tracker_value_dbus_init, tracker_value_dbus_free_value, tracker_value_dbus_copy_value, tracker_value_dbus_peek_pointer, "p", tracker_value_dbus_collect_value, "p", tracker_value_dbus_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (TrackerDBusClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_dbus_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerDBus), 0, (GInstanceInitFunc) tracker_dbus_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType tracker_dbus_type_id;
		tracker_dbus_type_id = g_type_register_fundamental (g_type_fundamental_next (), "TrackerDBus", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&tracker_dbus_type_id__volatile, tracker_dbus_type_id);
	}
	return tracker_dbus_type_id__volatile;
}


gpointer tracker_dbus_ref (gpointer instance) {
	TrackerDBus * self;
	self = instance;
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	g_atomic_int_inc (&self->ref_count);
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	return instance;
#line 1443 "tracker-dbus.c"
}


void tracker_dbus_unref (gpointer instance) {
	TrackerDBus * self;
	self = instance;
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		TRACKER_DBUS_GET_CLASS (self)->finalize (self);
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 1456 "tracker-dbus.c"
	}
}



