/* valascanner.c generated by valac, the Vala compiler
 * generated from valascanner.vala, do not modify */

/* valascanner.vala
 *
 * Copyright (C) 2008-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 * 	Jukka-Pekka Iivonen <jp0409@jippii.fi>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gobject/gvaluecollector.h>


#define VALA_TYPE_SCANNER (vala_scanner_get_type ())
#define VALA_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SCANNER, ValaScanner))
#define VALA_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SCANNER, ValaScannerClass))
#define VALA_IS_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SCANNER))
#define VALA_IS_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SCANNER))
#define VALA_SCANNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SCANNER, ValaScannerClass))

typedef struct _ValaScanner ValaScanner;
typedef struct _ValaScannerClass ValaScannerClass;
typedef struct _ValaScannerPrivate ValaScannerPrivate;

#define VALA_TYPE_SOURCE_FILE (vala_source_file_get_type ())
#define VALA_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_FILE, ValaSourceFile))
#define VALA_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_FILE, ValaSourceFileClass))
#define VALA_IS_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_FILE))
#define VALA_IS_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_FILE))
#define VALA_SOURCE_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_FILE, ValaSourceFileClass))

typedef struct _ValaSourceFile ValaSourceFile;
typedef struct _ValaSourceFileClass ValaSourceFileClass;

#define VALA_TYPE_TOKEN_TYPE (vala_token_type_get_type ())

#define VALA_TYPE_COMMENT (vala_comment_get_type ())
#define VALA_COMMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_COMMENT, ValaComment))
#define VALA_COMMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_COMMENT, ValaCommentClass))
#define VALA_IS_COMMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_COMMENT))
#define VALA_IS_COMMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_COMMENT))
#define VALA_COMMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_COMMENT, ValaCommentClass))

typedef struct _ValaComment ValaComment;
typedef struct _ValaCommentClass ValaCommentClass;

#define VALA_SCANNER_TYPE_CONDITIONAL (vala_scanner_conditional_get_type ())
typedef struct _ValaScannerConditional ValaScannerConditional;

#define VALA_SCANNER_TYPE_STATE (vala_scanner_state_get_type ())
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _vala_comment_unref0(var) ((var == NULL) ? NULL : (var = (vala_comment_unref (var), NULL)))

#define VALA_TYPE_SOURCE_LOCATION (vala_source_location_get_type ())
typedef struct _ValaSourceLocation ValaSourceLocation;

#define VALA_TYPE_SOURCE_REFERENCE (vala_source_reference_get_type ())
#define VALA_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReference))
#define VALA_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))
#define VALA_IS_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_IS_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_SOURCE_REFERENCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))

typedef struct _ValaSourceReference ValaSourceReference;
typedef struct _ValaSourceReferenceClass ValaSourceReferenceClass;
#define _vala_source_reference_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_reference_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define VALA_TYPE_CODE_CONTEXT (vala_code_context_get_type ())
#define VALA_CODE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_CONTEXT, ValaCodeContext))
#define VALA_CODE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_CONTEXT, ValaCodeContextClass))
#define VALA_IS_CODE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_CONTEXT))
#define VALA_IS_CODE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_CONTEXT))
#define VALA_CODE_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_CONTEXT, ValaCodeContextClass))

typedef struct _ValaCodeContext ValaCodeContext;
typedef struct _ValaCodeContextClass ValaCodeContextClass;
typedef struct _ValaParamSpecScanner ValaParamSpecScanner;

struct _ValaScanner {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaScannerPrivate * priv;
};

struct _ValaScannerClass {
	GTypeClass parent_class;
	void (*finalize) (ValaScanner *self);
};

typedef enum  {
	VALA_TOKEN_TYPE_NONE,
	VALA_TOKEN_TYPE_ABSTRACT,
	VALA_TOKEN_TYPE_AS,
	VALA_TOKEN_TYPE_ASSIGN,
	VALA_TOKEN_TYPE_ASSIGN_ADD,
	VALA_TOKEN_TYPE_ASSIGN_BITWISE_AND,
	VALA_TOKEN_TYPE_ASSIGN_BITWISE_OR,
	VALA_TOKEN_TYPE_ASSIGN_BITWISE_XOR,
	VALA_TOKEN_TYPE_ASSIGN_DIV,
	VALA_TOKEN_TYPE_ASSIGN_MUL,
	VALA_TOKEN_TYPE_ASSIGN_PERCENT,
	VALA_TOKEN_TYPE_ASSIGN_SHIFT_LEFT,
	VALA_TOKEN_TYPE_ASSIGN_SUB,
	VALA_TOKEN_TYPE_ASYNC,
	VALA_TOKEN_TYPE_BASE,
	VALA_TOKEN_TYPE_BITWISE_AND,
	VALA_TOKEN_TYPE_BITWISE_OR,
	VALA_TOKEN_TYPE_BREAK,
	VALA_TOKEN_TYPE_CARRET,
	VALA_TOKEN_TYPE_CASE,
	VALA_TOKEN_TYPE_CATCH,
	VALA_TOKEN_TYPE_CHARACTER_LITERAL,
	VALA_TOKEN_TYPE_CLASS,
	VALA_TOKEN_TYPE_CLOSE_BRACE,
	VALA_TOKEN_TYPE_CLOSE_BRACKET,
	VALA_TOKEN_TYPE_CLOSE_PARENS,
	VALA_TOKEN_TYPE_CLOSE_REGEX_LITERAL,
	VALA_TOKEN_TYPE_CLOSE_TEMPLATE,
	VALA_TOKEN_TYPE_COLON,
	VALA_TOKEN_TYPE_COMMA,
	VALA_TOKEN_TYPE_CONST,
	VALA_TOKEN_TYPE_CONSTRUCT,
	VALA_TOKEN_TYPE_CONTINUE,
	VALA_TOKEN_TYPE_DEFAULT,
	VALA_TOKEN_TYPE_DELEGATE,
	VALA_TOKEN_TYPE_DELETE,
	VALA_TOKEN_TYPE_DIV,
	VALA_TOKEN_TYPE_DO,
	VALA_TOKEN_TYPE_DOUBLE_COLON,
	VALA_TOKEN_TYPE_DOT,
	VALA_TOKEN_TYPE_DYNAMIC,
	VALA_TOKEN_TYPE_ELLIPSIS,
	VALA_TOKEN_TYPE_ELSE,
	VALA_TOKEN_TYPE_ENUM,
	VALA_TOKEN_TYPE_ENSURES,
	VALA_TOKEN_TYPE_ERRORDOMAIN,
	VALA_TOKEN_TYPE_EOF,
	VALA_TOKEN_TYPE_EXTERN,
	VALA_TOKEN_TYPE_FALSE,
	VALA_TOKEN_TYPE_FINALLY,
	VALA_TOKEN_TYPE_FOR,
	VALA_TOKEN_TYPE_FOREACH,
	VALA_TOKEN_TYPE_GET,
	VALA_TOKEN_TYPE_HASH,
	VALA_TOKEN_TYPE_IDENTIFIER,
	VALA_TOKEN_TYPE_IF,
	VALA_TOKEN_TYPE_IN,
	VALA_TOKEN_TYPE_INLINE,
	VALA_TOKEN_TYPE_INTEGER_LITERAL,
	VALA_TOKEN_TYPE_INTERFACE,
	VALA_TOKEN_TYPE_INTERNAL,
	VALA_TOKEN_TYPE_INTERR,
	VALA_TOKEN_TYPE_IS,
	VALA_TOKEN_TYPE_LAMBDA,
	VALA_TOKEN_TYPE_LOCK,
	VALA_TOKEN_TYPE_MINUS,
	VALA_TOKEN_TYPE_NAMESPACE,
	VALA_TOKEN_TYPE_NEW,
	VALA_TOKEN_TYPE_NULL,
	VALA_TOKEN_TYPE_OUT,
	VALA_TOKEN_TYPE_OP_AND,
	VALA_TOKEN_TYPE_OP_COALESCING,
	VALA_TOKEN_TYPE_OP_DEC,
	VALA_TOKEN_TYPE_OP_EQ,
	VALA_TOKEN_TYPE_OP_GE,
	VALA_TOKEN_TYPE_OP_GT,
	VALA_TOKEN_TYPE_OP_INC,
	VALA_TOKEN_TYPE_OP_LE,
	VALA_TOKEN_TYPE_OP_LT,
	VALA_TOKEN_TYPE_OP_NE,
	VALA_TOKEN_TYPE_OP_NEG,
	VALA_TOKEN_TYPE_OP_OR,
	VALA_TOKEN_TYPE_OP_PTR,
	VALA_TOKEN_TYPE_OP_SHIFT_LEFT,
	VALA_TOKEN_TYPE_OPEN_BRACE,
	VALA_TOKEN_TYPE_OPEN_BRACKET,
	VALA_TOKEN_TYPE_OPEN_PARENS,
	VALA_TOKEN_TYPE_OPEN_REGEX_LITERAL,
	VALA_TOKEN_TYPE_OPEN_TEMPLATE,
	VALA_TOKEN_TYPE_OVERRIDE,
	VALA_TOKEN_TYPE_OWNED,
	VALA_TOKEN_TYPE_PARAMS,
	VALA_TOKEN_TYPE_PERCENT,
	VALA_TOKEN_TYPE_PLUS,
	VALA_TOKEN_TYPE_PRIVATE,
	VALA_TOKEN_TYPE_PROTECTED,
	VALA_TOKEN_TYPE_PUBLIC,
	VALA_TOKEN_TYPE_REAL_LITERAL,
	VALA_TOKEN_TYPE_REF,
	VALA_TOKEN_TYPE_REGEX_LITERAL,
	VALA_TOKEN_TYPE_REQUIRES,
	VALA_TOKEN_TYPE_RETURN,
	VALA_TOKEN_TYPE_SEALED,
	VALA_TOKEN_TYPE_SEMICOLON,
	VALA_TOKEN_TYPE_SET,
	VALA_TOKEN_TYPE_SIGNAL,
	VALA_TOKEN_TYPE_SIZEOF,
	VALA_TOKEN_TYPE_STAR,
	VALA_TOKEN_TYPE_STATIC,
	VALA_TOKEN_TYPE_STRING_LITERAL,
	VALA_TOKEN_TYPE_STRUCT,
	VALA_TOKEN_TYPE_SWITCH,
	VALA_TOKEN_TYPE_TEMPLATE_STRING_LITERAL,
	VALA_TOKEN_TYPE_THIS,
	VALA_TOKEN_TYPE_THROW,
	VALA_TOKEN_TYPE_THROWS,
	VALA_TOKEN_TYPE_TILDE,
	VALA_TOKEN_TYPE_TRUE,
	VALA_TOKEN_TYPE_TRY,
	VALA_TOKEN_TYPE_TYPEOF,
	VALA_TOKEN_TYPE_UNOWNED,
	VALA_TOKEN_TYPE_USING,
	VALA_TOKEN_TYPE_VAR,
	VALA_TOKEN_TYPE_VERBATIM_STRING_LITERAL,
	VALA_TOKEN_TYPE_VIRTUAL,
	VALA_TOKEN_TYPE_VOID,
	VALA_TOKEN_TYPE_VOLATILE,
	VALA_TOKEN_TYPE_WEAK,
	VALA_TOKEN_TYPE_WHILE,
	VALA_TOKEN_TYPE_YIELD
} ValaTokenType;

struct _ValaScannerConditional {
	gboolean matched;
	gboolean else_found;
	gboolean skip_section;
};

typedef enum  {
	VALA_SCANNER_STATE_PARENS,
	VALA_SCANNER_STATE_BRACE,
	VALA_SCANNER_STATE_BRACKET,
	VALA_SCANNER_STATE_TEMPLATE,
	VALA_SCANNER_STATE_TEMPLATE_PART,
	VALA_SCANNER_STATE_REGEX_LITERAL
} ValaScannerState;

struct _ValaScannerPrivate {
	ValaSourceFile* _source_file;
	ValaTokenType previous;
	gchar* current;
	gchar* end;
	gint line;
	gint column;
	ValaComment* _comment;
	ValaScannerConditional* conditional_stack;
	gint conditional_stack_length1;
	gint _conditional_stack_size_;
	ValaScannerState* state_stack;
	gint state_stack_length1;
	gint _state_stack_size_;
};

struct _ValaSourceLocation {
	gchar* pos;
	gint line;
	gint column;
};

struct _ValaParamSpecScanner {
	GParamSpec parent_instance;
};


static gpointer vala_scanner_parent_class = NULL;

gpointer vala_scanner_ref (gpointer instance);
void vala_scanner_unref (gpointer instance);
GParamSpec* vala_param_spec_scanner (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_scanner (GValue* value, gpointer v_object);
void vala_value_take_scanner (GValue* value, gpointer v_object);
gpointer vala_value_get_scanner (const GValue* value);
GType vala_scanner_get_type (void) G_GNUC_CONST;
gpointer vala_source_file_ref (gpointer instance);
void vala_source_file_unref (gpointer instance);
GParamSpec* vala_param_spec_source_file (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_file (GValue* value, gpointer v_object);
void vala_value_take_source_file (GValue* value, gpointer v_object);
gpointer vala_value_get_source_file (const GValue* value);
GType vala_source_file_get_type (void) G_GNUC_CONST;
GType vala_token_type_get_type (void) G_GNUC_CONST;
gpointer vala_comment_ref (gpointer instance);
void vala_comment_unref (gpointer instance);
GParamSpec* vala_param_spec_comment (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_comment (GValue* value, gpointer v_object);
void vala_value_take_comment (GValue* value, gpointer v_object);
gpointer vala_value_get_comment (const GValue* value);
GType vala_comment_get_type (void) G_GNUC_CONST;
static GType vala_scanner_conditional_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static ValaScannerConditional* vala_scanner_conditional_dup (const ValaScannerConditional* self);
static void vala_scanner_conditional_free (ValaScannerConditional* self);
static GType vala_scanner_state_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define VALA_SCANNER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_SCANNER, ValaScannerPrivate))
enum  {
	VALA_SCANNER_DUMMY_PROPERTY
};
ValaScanner* vala_scanner_new (ValaSourceFile* source_file);
ValaScanner* vala_scanner_construct (GType object_type, ValaSourceFile* source_file);
static void vala_scanner_set_source_file (ValaScanner* self, ValaSourceFile* value);
gchar* vala_source_file_get_mapped_contents (ValaSourceFile* self);
gsize vala_source_file_get_mapped_length (ValaSourceFile* self);
GType vala_source_location_get_type (void) G_GNUC_CONST;
ValaSourceLocation* vala_source_location_dup (const ValaSourceLocation* self);
void vala_source_location_free (ValaSourceLocation* self);
void vala_scanner_seek (ValaScanner* self, ValaSourceLocation* location);
static gboolean vala_scanner_in_template (ValaScanner* self);
static gboolean vala_scanner_in_template_part (ValaScanner* self);
static gboolean vala_scanner_in_regex_literal (ValaScanner* self);
static gboolean vala_scanner_is_ident_char (ValaScanner* self, gchar c);
gpointer vala_source_reference_ref (gpointer instance);
void vala_source_reference_unref (gpointer instance);
GParamSpec* vala_param_spec_source_reference (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_reference (GValue* value, gpointer v_object);
void vala_value_take_source_reference (GValue* value, gpointer v_object);
gpointer vala_value_get_source_reference (const GValue* value);
GType vala_source_reference_get_type (void) G_GNUC_CONST;
static ValaSourceReference* vala_scanner_get_source_reference (ValaScanner* self, gint offset, gint length);
ValaSourceFile* vala_scanner_get_source_file (ValaScanner* self);
void vala_source_location_init (ValaSourceLocation *self, gchar* _pos, gint _line, gint _column);
ValaSourceReference* vala_source_reference_new (ValaSourceFile* _file, ValaSourceLocation* begin, ValaSourceLocation* end);
ValaSourceReference* vala_source_reference_construct (GType object_type, ValaSourceFile* _file, ValaSourceLocation* begin, ValaSourceLocation* end);
ValaTokenType vala_scanner_read_regex_token (ValaScanner* self, ValaSourceLocation* token_begin, ValaSourceLocation* token_end);
void vala_report_error (ValaSourceReference* source, const gchar* message);
ValaTokenType vala_scanner_read_token (ValaScanner* self, ValaSourceLocation* token_begin, ValaSourceLocation* token_end);
ValaTokenType vala_scanner_get_identifier_or_keyword (gchar* begin, gint len);
static gboolean vala_scanner_matches (gchar* begin, const gchar* keyword);
static ValaTokenType vala_scanner_read_number (ValaScanner* self);
ValaTokenType vala_scanner_read_template_token (ValaScanner* self, ValaSourceLocation* token_begin, ValaSourceLocation* token_end);
static void _vala_array_add13 (ValaScannerState* * array, int* length, int* size, ValaScannerState value);
static void _vala_array_add14 (ValaScannerState* * array, int* length, int* size, ValaScannerState value);
static void _vala_array_add15 (ValaScannerState* * array, int* length, int* size, ValaScannerState value);
static void _vala_array_add16 (ValaScannerState* * array, int* length, int* size, ValaScannerState value);
static void vala_scanner_space (ValaScanner* self);
static void _vala_array_add17 (ValaScannerState* * array, int* length, int* size, ValaScannerState value);
static void _vala_array_add18 (ValaScannerState* * array, int* length, int* size, ValaScannerState value);
static void _vala_array_add19 (ValaScannerState* * array, int* length, int* size, ValaScannerState value);
static void _vala_array_add20 (ValaScannerState* * array, int* length, int* size, ValaScannerState value);
static void _vala_array_add21 (ValaScannerState* * array, int* length, int* size, ValaScannerState value);
static gboolean vala_scanner_pp_whitespace (ValaScanner* self);
static void vala_scanner_pp_space (ValaScanner* self);
static gboolean vala_scanner_comment (ValaScanner* self, gboolean file_comment);
static void vala_scanner_pp_directive (ValaScanner* self);
static void vala_scanner_parse_pp_if (ValaScanner* self);
static void vala_scanner_parse_pp_elif (ValaScanner* self);
static void vala_scanner_parse_pp_else (ValaScanner* self);
static void vala_scanner_parse_pp_endif (ValaScanner* self);
static void vala_scanner_pp_eol (ValaScanner* self);
static gboolean vala_scanner_parse_pp_expression (ValaScanner* self);
static void _vala_array_add22 (ValaScannerConditional* * array, int* length, int* size, const ValaScannerConditional* value);
static gboolean vala_scanner_parse_pp_symbol (ValaScanner* self);
gpointer vala_code_context_ref (gpointer instance);
void vala_code_context_unref (gpointer instance);
GParamSpec* vala_param_spec_code_context (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_context (GValue* value, gpointer v_object);
void vala_value_take_code_context (GValue* value, gpointer v_object);
gpointer vala_value_get_code_context (const GValue* value);
GType vala_code_context_get_type (void) G_GNUC_CONST;
ValaCodeContext* vala_source_file_get_context (ValaSourceFile* self);
gboolean vala_code_context_is_defined (ValaCodeContext* self, const gchar* define);
static gboolean vala_scanner_parse_pp_primary_expression (ValaScanner* self);
static gboolean vala_scanner_parse_pp_unary_expression (ValaScanner* self);
static gboolean vala_scanner_parse_pp_equality_expression (ValaScanner* self);
static gboolean vala_scanner_parse_pp_and_expression (ValaScanner* self);
static gboolean vala_scanner_parse_pp_or_expression (ValaScanner* self);
static gboolean vala_scanner_whitespace (ValaScanner* self);
static void vala_scanner_push_comment (ValaScanner* self, const gchar* comment_item, ValaSourceReference* source_reference, gboolean file_comment);
void vala_scanner_parse_file_comments (ValaScanner* self);
void vala_source_file_add_comment (ValaSourceFile* self, ValaComment* comment);
ValaComment* vala_comment_new (const gchar* comment, ValaSourceReference* _source_reference);
ValaComment* vala_comment_construct (GType object_type, const gchar* comment, ValaSourceReference* _source_reference);
ValaComment* vala_scanner_pop_comment (ValaScanner* self);
static void vala_scanner_finalize (ValaScanner * obj);


static GType vala_scanner_state_get_type (void) {
	static volatile gsize vala_scanner_state_type_id__volatile = 0;
	if (g_once_init_enter (&vala_scanner_state_type_id__volatile)) {
		static const GEnumValue values[] = {{VALA_SCANNER_STATE_PARENS, "VALA_SCANNER_STATE_PARENS", "parens"}, {VALA_SCANNER_STATE_BRACE, "VALA_SCANNER_STATE_BRACE", "brace"}, {VALA_SCANNER_STATE_BRACKET, "VALA_SCANNER_STATE_BRACKET", "bracket"}, {VALA_SCANNER_STATE_TEMPLATE, "VALA_SCANNER_STATE_TEMPLATE", "template"}, {VALA_SCANNER_STATE_TEMPLATE_PART, "VALA_SCANNER_STATE_TEMPLATE_PART", "template-part"}, {VALA_SCANNER_STATE_REGEX_LITERAL, "VALA_SCANNER_STATE_REGEX_LITERAL", "regex-literal"}, {0, NULL, NULL}};
		GType vala_scanner_state_type_id;
		vala_scanner_state_type_id = g_enum_register_static ("ValaScannerState", values);
		g_once_init_leave (&vala_scanner_state_type_id__volatile, vala_scanner_state_type_id);
	}
	return vala_scanner_state_type_id__volatile;
}


ValaScanner* vala_scanner_construct (GType object_type, ValaSourceFile* source_file) {
	ValaScanner* self = NULL;
	ValaSourceFile* _tmp0_;
	gchar* begin;
	ValaSourceFile* _tmp1_;
	gchar* _tmp2_;
	ValaSourceFile* _tmp3_;
	gsize _tmp4_;
	g_return_val_if_fail (source_file != NULL, NULL);
	self = (ValaScanner*) g_type_create_instance (object_type);
	_tmp0_ = source_file;
	vala_scanner_set_source_file (self, _tmp0_);
	_tmp1_ = source_file;
	_tmp2_ = vala_source_file_get_mapped_contents (_tmp1_);
	begin = _tmp2_;
	_tmp3_ = source_file;
	_tmp4_ = vala_source_file_get_mapped_length (_tmp3_);
	self->priv->end = begin + _tmp4_;
	self->priv->current = begin;
	self->priv->line = 1;
	self->priv->column = 1;
	return self;
}


ValaScanner* vala_scanner_new (ValaSourceFile* source_file) {
	return vala_scanner_construct (VALA_TYPE_SCANNER, source_file);
}


void vala_scanner_seek (ValaScanner* self, ValaSourceLocation* location) {
	ValaSourceLocation _tmp0_;
	gchar* _tmp1_;
	ValaSourceLocation _tmp2_;
	gint _tmp3_;
	ValaSourceLocation _tmp4_;
	gint _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (location != NULL);
	_tmp0_ = *location;
	_tmp1_ = _tmp0_.pos;
	self->priv->current = _tmp1_;
	_tmp2_ = *location;
	_tmp3_ = _tmp2_.line;
	self->priv->line = _tmp3_;
	_tmp4_ = *location;
	_tmp5_ = _tmp4_.column;
	self->priv->column = _tmp5_;
	self->priv->conditional_stack = (g_free (self->priv->conditional_stack), NULL);
	self->priv->conditional_stack = NULL;
	self->priv->conditional_stack_length1 = 0;
	self->priv->_conditional_stack_size_ = self->priv->conditional_stack_length1;
	self->priv->state_stack = (g_free (self->priv->state_stack), NULL);
	self->priv->state_stack = NULL;
	self->priv->state_stack_length1 = 0;
	self->priv->_state_stack_size_ = self->priv->state_stack_length1;
}


static gboolean vala_scanner_in_template (ValaScanner* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	ValaScannerState* _tmp1_;
	gint _tmp1__length1;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->state_stack;
	_tmp1__length1 = self->priv->state_stack_length1;
	if (_tmp1__length1 > 0) {
		ValaScannerState* _tmp2_;
		gint _tmp2__length1;
		ValaScannerState* _tmp3_;
		gint _tmp3__length1;
		ValaScannerState _tmp4_;
		_tmp2_ = self->priv->state_stack;
		_tmp2__length1 = self->priv->state_stack_length1;
		_tmp3_ = self->priv->state_stack;
		_tmp3__length1 = self->priv->state_stack_length1;
		_tmp4_ = _tmp2_[_tmp3__length1 - 1];
		_tmp0_ = _tmp4_ == VALA_SCANNER_STATE_TEMPLATE;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


static gboolean vala_scanner_in_template_part (ValaScanner* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	ValaScannerState* _tmp1_;
	gint _tmp1__length1;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->state_stack;
	_tmp1__length1 = self->priv->state_stack_length1;
	if (_tmp1__length1 > 0) {
		ValaScannerState* _tmp2_;
		gint _tmp2__length1;
		ValaScannerState* _tmp3_;
		gint _tmp3__length1;
		ValaScannerState _tmp4_;
		_tmp2_ = self->priv->state_stack;
		_tmp2__length1 = self->priv->state_stack_length1;
		_tmp3_ = self->priv->state_stack;
		_tmp3__length1 = self->priv->state_stack_length1;
		_tmp4_ = _tmp2_[_tmp3__length1 - 1];
		_tmp0_ = _tmp4_ == VALA_SCANNER_STATE_TEMPLATE_PART;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


static gboolean vala_scanner_in_regex_literal (ValaScanner* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	ValaScannerState* _tmp1_;
	gint _tmp1__length1;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->state_stack;
	_tmp1__length1 = self->priv->state_stack_length1;
	if (_tmp1__length1 > 0) {
		ValaScannerState* _tmp2_;
		gint _tmp2__length1;
		ValaScannerState* _tmp3_;
		gint _tmp3__length1;
		ValaScannerState _tmp4_;
		_tmp2_ = self->priv->state_stack;
		_tmp2__length1 = self->priv->state_stack_length1;
		_tmp3_ = self->priv->state_stack;
		_tmp3__length1 = self->priv->state_stack_length1;
		_tmp4_ = _tmp2_[_tmp3__length1 - 1];
		_tmp0_ = _tmp4_ == VALA_SCANNER_STATE_REGEX_LITERAL;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


static gboolean vala_scanner_is_ident_char (ValaScanner* self, gchar c) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gchar _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = c;
	_tmp2_ = g_ascii_isalnum (_tmp1_);
	if (_tmp2_) {
		_tmp0_ = TRUE;
	} else {
		gchar _tmp3_;
		_tmp3_ = c;
		_tmp0_ = _tmp3_ == '_';
	}
	result = _tmp0_;
	return result;
}


static ValaSourceReference* vala_scanner_get_source_reference (ValaScanner* self, gint offset, gint length) {
	ValaSourceReference* result = NULL;
	ValaSourceFile* _tmp0_;
	gchar* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	ValaSourceLocation _tmp5_ = {0};
	gchar* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	ValaSourceLocation _tmp12_ = {0};
	ValaSourceReference* _tmp13_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_source_file;
	_tmp1_ = self->priv->current;
	_tmp2_ = self->priv->line;
	_tmp3_ = self->priv->column;
	_tmp4_ = offset;
	vala_source_location_init (&_tmp5_, _tmp1_, _tmp2_, _tmp3_ + _tmp4_);
	_tmp6_ = self->priv->current;
	_tmp7_ = length;
	_tmp8_ = self->priv->line;
	_tmp9_ = self->priv->column;
	_tmp10_ = offset;
	_tmp11_ = length;
	vala_source_location_init (&_tmp12_, _tmp6_ + _tmp7_, _tmp8_, (_tmp9_ + _tmp10_) + _tmp11_);
	_tmp13_ = vala_source_reference_new (_tmp0_, &_tmp5_, &_tmp12_);
	result = _tmp13_;
	return result;
}


ValaTokenType vala_scanner_read_regex_token (ValaScanner* self, ValaSourceLocation* token_begin, ValaSourceLocation* token_end) {
	ValaSourceLocation _vala_token_begin = {0};
	ValaSourceLocation _vala_token_end = {0};
	ValaTokenType result = 0;
	ValaTokenType type = 0;
	gchar* begin;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint token_length_in_chars;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gint _tmp120_;
	gchar* _tmp126_;
	gint _tmp127_;
	gint _tmp128_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->current;
	begin = _tmp0_;
	_tmp1_ = begin;
	_tmp2_ = self->priv->line;
	_tmp3_ = self->priv->column;
	vala_source_location_init (&_vala_token_begin, _tmp1_, _tmp2_, _tmp3_);
	token_length_in_chars = -1;
	_tmp4_ = self->priv->current;
	_tmp5_ = self->priv->end;
	if (_tmp4_ >= _tmp5_) {
		type = VALA_TOKEN_TYPE_EOF;
	} else {
		gchar* _tmp6_;
		gchar _tmp7_;
		_tmp6_ = self->priv->current;
		_tmp7_ = _tmp6_[0];
		switch (_tmp7_) {
			case '/':
			{
				gchar* _tmp8_;
				gint _tmp9_;
				gboolean fl_i;
				gboolean fl_s;
				gboolean fl_m;
				gboolean fl_x;
				type = VALA_TOKEN_TYPE_CLOSE_REGEX_LITERAL;
				_tmp8_ = self->priv->current;
				self->priv->current = _tmp8_ + 1;
				_tmp9_ = self->priv->state_stack_length1;
				self->priv->state_stack_length1 = _tmp9_ - 1;
				fl_i = FALSE;
				fl_s = FALSE;
				fl_m = FALSE;
				fl_x = FALSE;
				while (TRUE) {
					gboolean _tmp10_ = FALSE;
					gboolean _tmp11_ = FALSE;
					gboolean _tmp12_ = FALSE;
					gchar* _tmp13_;
					gchar _tmp14_;
					gchar* _tmp21_;
					gchar _tmp22_;
					gchar* _tmp39_;
					gint _tmp40_;
					_tmp13_ = self->priv->current;
					_tmp14_ = _tmp13_[0];
					if (_tmp14_ == 'i') {
						_tmp12_ = TRUE;
					} else {
						gchar* _tmp15_;
						gchar _tmp16_;
						_tmp15_ = self->priv->current;
						_tmp16_ = _tmp15_[0];
						_tmp12_ = _tmp16_ == 's';
					}
					if (_tmp12_) {
						_tmp11_ = TRUE;
					} else {
						gchar* _tmp17_;
						gchar _tmp18_;
						_tmp17_ = self->priv->current;
						_tmp18_ = _tmp17_[0];
						_tmp11_ = _tmp18_ == 'm';
					}
					if (_tmp11_) {
						_tmp10_ = TRUE;
					} else {
						gchar* _tmp19_;
						gchar _tmp20_;
						_tmp19_ = self->priv->current;
						_tmp20_ = _tmp19_[0];
						_tmp10_ = _tmp20_ == 'x';
					}
					if (!_tmp10_) {
						break;
					}
					_tmp21_ = self->priv->current;
					_tmp22_ = _tmp21_[0];
					switch (_tmp22_) {
						case 'i':
						{
							gboolean _tmp23_;
							_tmp23_ = fl_i;
							if (_tmp23_) {
								gint _tmp24_;
								ValaSourceReference* _tmp25_;
								ValaSourceReference* _tmp26_;
								_tmp24_ = token_length_in_chars;
								_tmp25_ = vala_scanner_get_source_reference (self, _tmp24_, 0);
								_tmp26_ = _tmp25_;
								vala_report_error (_tmp26_, "modifier 'i' used more than once");
								_vala_source_reference_unref0 (_tmp26_);
							}
							fl_i = TRUE;
							break;
						}
						case 's':
						{
							gboolean _tmp27_;
							_tmp27_ = fl_s;
							if (_tmp27_) {
								gint _tmp28_;
								ValaSourceReference* _tmp29_;
								ValaSourceReference* _tmp30_;
								_tmp28_ = token_length_in_chars;
								_tmp29_ = vala_scanner_get_source_reference (self, _tmp28_, 0);
								_tmp30_ = _tmp29_;
								vala_report_error (_tmp30_, "modifier 's' used more than once");
								_vala_source_reference_unref0 (_tmp30_);
							}
							fl_s = TRUE;
							break;
						}
						case 'm':
						{
							gboolean _tmp31_;
							_tmp31_ = fl_m;
							if (_tmp31_) {
								gint _tmp32_;
								ValaSourceReference* _tmp33_;
								ValaSourceReference* _tmp34_;
								_tmp32_ = token_length_in_chars;
								_tmp33_ = vala_scanner_get_source_reference (self, _tmp32_, 0);
								_tmp34_ = _tmp33_;
								vala_report_error (_tmp34_, "modifier 'm' used more than once");
								_vala_source_reference_unref0 (_tmp34_);
							}
							fl_m = TRUE;
							break;
						}
						case 'x':
						{
							gboolean _tmp35_;
							_tmp35_ = fl_x;
							if (_tmp35_) {
								gint _tmp36_;
								ValaSourceReference* _tmp37_;
								ValaSourceReference* _tmp38_;
								_tmp36_ = token_length_in_chars;
								_tmp37_ = vala_scanner_get_source_reference (self, _tmp36_, 0);
								_tmp38_ = _tmp37_;
								vala_report_error (_tmp38_, "modifier 'x' used more than once");
								_vala_source_reference_unref0 (_tmp38_);
							}
							fl_x = TRUE;
							break;
						}
						default:
						break;
					}
					_tmp39_ = self->priv->current;
					self->priv->current = _tmp39_ + 1;
					_tmp40_ = token_length_in_chars;
					token_length_in_chars = _tmp40_ + 1;
				}
				break;
			}
			default:
			{
				gboolean _tmp108_ = FALSE;
				gchar* _tmp109_;
				gchar* _tmp110_;
				type = VALA_TOKEN_TYPE_REGEX_LITERAL;
				token_length_in_chars = 0;
				while (TRUE) {
					gboolean _tmp41_ = FALSE;
					gchar* _tmp42_;
					gchar* _tmp43_;
					gchar* _tmp46_;
					gchar _tmp47_;
					_tmp42_ = self->priv->current;
					_tmp43_ = self->priv->end;
					if (_tmp42_ < _tmp43_) {
						gchar* _tmp44_;
						gchar _tmp45_;
						_tmp44_ = self->priv->current;
						_tmp45_ = _tmp44_[0];
						_tmp41_ = _tmp45_ != '/';
					} else {
						_tmp41_ = FALSE;
					}
					if (!_tmp41_) {
						break;
					}
					_tmp46_ = self->priv->current;
					_tmp47_ = _tmp46_[0];
					if (_tmp47_ == '\\') {
						gchar* _tmp48_;
						gint _tmp49_;
						gchar* _tmp50_;
						gchar* _tmp51_;
						gchar* _tmp52_;
						gchar _tmp53_;
						_tmp48_ = self->priv->current;
						self->priv->current = _tmp48_ + 1;
						_tmp49_ = token_length_in_chars;
						token_length_in_chars = _tmp49_ + 1;
						_tmp50_ = self->priv->current;
						_tmp51_ = self->priv->end;
						if (_tmp50_ >= _tmp51_) {
							break;
						}
						_tmp52_ = self->priv->current;
						_tmp53_ = _tmp52_[0];
						switch (_tmp53_) {
							case '\'':
							case '"':
							case '\\':
							case '/':
							case '^':
							case '$':
							case '.':
							case '[':
							case ']':
							case '{':
							case '}':
							case '(':
							case ')':
							case '?':
							case '*':
							case '+':
							case '-':
							case '#':
							case '&':
							case '~':
							case ':':
							case ';':
							case '<':
							case '>':
							case '|':
							case '%':
							case '=':
							case '@':
							case '0':
							case 'b':
							case 'B':
							case 'f':
							case 'n':
							case 'r':
							case 't':
							case 'v':
							case 'a':
							case 'A':
							case 'p':
							case 'P':
							case 'e':
							case 'd':
							case 'D':
							case 's':
							case 'S':
							case 'w':
							case 'W':
							case 'G':
							case 'z':
							case 'Z':
							{
								gchar* _tmp54_;
								gint _tmp55_;
								_tmp54_ = self->priv->current;
								self->priv->current = _tmp54_ + 1;
								_tmp55_ = token_length_in_chars;
								token_length_in_chars = _tmp55_ + 1;
								break;
							}
							case 'u':
							{
								gchar* _tmp56_;
								gint _tmp57_;
								gint digit_length = 0;
								gint _tmp70_;
								_tmp56_ = self->priv->current;
								self->priv->current = _tmp56_ + 1;
								_tmp57_ = token_length_in_chars;
								token_length_in_chars = _tmp57_ + 1;
								{
									gboolean _tmp58_;
									digit_length = 0;
									_tmp58_ = TRUE;
									while (TRUE) {
										gboolean _tmp60_ = FALSE;
										gboolean _tmp61_ = FALSE;
										gint _tmp62_;
										gchar* _tmp68_;
										gint _tmp69_;
										if (!_tmp58_) {
											gint _tmp59_;
											_tmp59_ = digit_length;
											digit_length = _tmp59_ + 1;
										}
										_tmp58_ = FALSE;
										_tmp62_ = digit_length;
										if (_tmp62_ < 4) {
											gchar* _tmp63_;
											gchar* _tmp64_;
											_tmp63_ = self->priv->current;
											_tmp64_ = self->priv->end;
											_tmp61_ = _tmp63_ < _tmp64_;
										} else {
											_tmp61_ = FALSE;
										}
										if (_tmp61_) {
											gchar* _tmp65_;
											gchar _tmp66_;
											gboolean _tmp67_;
											_tmp65_ = self->priv->current;
											_tmp66_ = _tmp65_[0];
											_tmp67_ = g_ascii_isxdigit (_tmp66_);
											_tmp60_ = _tmp67_;
										} else {
											_tmp60_ = FALSE;
										}
										if (!_tmp60_) {
											break;
										}
										_tmp68_ = self->priv->current;
										self->priv->current = _tmp68_ + 1;
										_tmp69_ = token_length_in_chars;
										token_length_in_chars = _tmp69_ + 1;
									}
								}
								_tmp70_ = digit_length;
								if (_tmp70_ != 4) {
									gint _tmp71_;
									ValaSourceReference* _tmp72_;
									ValaSourceReference* _tmp73_;
									_tmp71_ = token_length_in_chars;
									_tmp72_ = vala_scanner_get_source_reference (self, _tmp71_, 0);
									_tmp73_ = _tmp72_;
									vala_report_error (_tmp73_, "\\u requires four hex digits");
									_vala_source_reference_unref0 (_tmp73_);
								}
								break;
							}
							case 'x':
							{
								gchar* _tmp74_;
								gint _tmp75_;
								gint digit_length = 0;
								gint _tmp86_;
								_tmp74_ = self->priv->current;
								self->priv->current = _tmp74_ + 1;
								_tmp75_ = token_length_in_chars;
								token_length_in_chars = _tmp75_ + 1;
								{
									gboolean _tmp76_;
									digit_length = 0;
									_tmp76_ = TRUE;
									while (TRUE) {
										gboolean _tmp78_ = FALSE;
										gchar* _tmp79_;
										gchar* _tmp80_;
										gchar* _tmp84_;
										gint _tmp85_;
										if (!_tmp76_) {
											gint _tmp77_;
											_tmp77_ = digit_length;
											digit_length = _tmp77_ + 1;
										}
										_tmp76_ = FALSE;
										_tmp79_ = self->priv->current;
										_tmp80_ = self->priv->end;
										if (_tmp79_ < _tmp80_) {
											gchar* _tmp81_;
											gchar _tmp82_;
											gboolean _tmp83_;
											_tmp81_ = self->priv->current;
											_tmp82_ = _tmp81_[0];
											_tmp83_ = g_ascii_isxdigit (_tmp82_);
											_tmp78_ = _tmp83_;
										} else {
											_tmp78_ = FALSE;
										}
										if (!_tmp78_) {
											break;
										}
										_tmp84_ = self->priv->current;
										self->priv->current = _tmp84_ + 1;
										_tmp85_ = token_length_in_chars;
										token_length_in_chars = _tmp85_ + 1;
									}
								}
								_tmp86_ = digit_length;
								if (_tmp86_ < 1) {
									gint _tmp87_;
									ValaSourceReference* _tmp88_;
									ValaSourceReference* _tmp89_;
									_tmp87_ = token_length_in_chars;
									_tmp88_ = vala_scanner_get_source_reference (self, _tmp87_, 0);
									_tmp89_ = _tmp88_;
									vala_report_error (_tmp89_, "\\x requires at least one hex digit");
									_vala_source_reference_unref0 (_tmp89_);
								}
								break;
							}
							default:
							{
								gint _tmp90_;
								ValaSourceReference* _tmp91_;
								ValaSourceReference* _tmp92_;
								_tmp90_ = token_length_in_chars;
								_tmp91_ = vala_scanner_get_source_reference (self, _tmp90_, 0);
								_tmp92_ = _tmp91_;
								vala_report_error (_tmp92_, "invalid escape sequence");
								_vala_source_reference_unref0 (_tmp92_);
								break;
							}
						}
					} else {
						gchar* _tmp93_;
						gchar _tmp94_;
						_tmp93_ = self->priv->current;
						_tmp94_ = _tmp93_[0];
						if (_tmp94_ == '\n') {
							break;
						} else {
							gunichar u;
							gchar* _tmp95_;
							gchar* _tmp96_;
							gchar* _tmp97_;
							gunichar _tmp98_;
							gunichar _tmp99_;
							_tmp95_ = self->priv->current;
							_tmp96_ = self->priv->end;
							_tmp97_ = self->priv->current;
							_tmp98_ = g_utf8_get_char_validated ((const gchar*) _tmp95_, (gssize) ((glong) (_tmp96_ - _tmp97_)));
							u = _tmp98_;
							_tmp99_ = u;
							if (_tmp99_ != ((gunichar) -1)) {
								gchar* _tmp100_;
								gunichar _tmp101_;
								gint _tmp102_;
								gint _tmp103_;
								_tmp100_ = self->priv->current;
								_tmp101_ = u;
								_tmp102_ = g_unichar_to_utf8 (_tmp101_, NULL);
								self->priv->current = _tmp100_ + _tmp102_;
								_tmp103_ = token_length_in_chars;
								token_length_in_chars = _tmp103_ + 1;
							} else {
								gchar* _tmp104_;
								gint _tmp105_;
								ValaSourceReference* _tmp106_;
								ValaSourceReference* _tmp107_;
								_tmp104_ = self->priv->current;
								self->priv->current = _tmp104_ + 1;
								_tmp105_ = token_length_in_chars;
								_tmp106_ = vala_scanner_get_source_reference (self, _tmp105_, 0);
								_tmp107_ = _tmp106_;
								vala_report_error (_tmp107_, "invalid UTF-8 character");
								_vala_source_reference_unref0 (_tmp107_);
							}
						}
					}
				}
				_tmp109_ = self->priv->current;
				_tmp110_ = self->priv->end;
				if (_tmp109_ >= _tmp110_) {
					_tmp108_ = TRUE;
				} else {
					gchar* _tmp111_;
					gchar _tmp112_;
					_tmp111_ = self->priv->current;
					_tmp112_ = _tmp111_[0];
					_tmp108_ = _tmp112_ == '\n';
				}
				if (_tmp108_) {
					gint _tmp113_;
					ValaSourceReference* _tmp114_;
					ValaSourceReference* _tmp115_;
					gint _tmp116_;
					ValaSourceLocation _tmp117_ = {0};
					ValaSourceLocation _tmp118_ = {0};
					ValaTokenType _tmp119_;
					_tmp113_ = token_length_in_chars;
					_tmp114_ = vala_scanner_get_source_reference (self, _tmp113_, 0);
					_tmp115_ = _tmp114_;
					vala_report_error (_tmp115_, "syntax error, expected \"");
					_vala_source_reference_unref0 (_tmp115_);
					_tmp116_ = self->priv->state_stack_length1;
					self->priv->state_stack_length1 = _tmp116_ - 1;
					_tmp119_ = vala_scanner_read_token (self, &_tmp117_, &_tmp118_);
					_vala_token_begin = _tmp117_;
					_vala_token_end = _tmp118_;
					result = _tmp119_;
					if (token_begin) {
						*token_begin = _vala_token_begin;
					}
					if (token_end) {
						*token_end = _vala_token_end;
					}
					return result;
				}
				break;
			}
		}
	}
	_tmp120_ = token_length_in_chars;
	if (_tmp120_ < 0) {
		gint _tmp121_;
		gchar* _tmp122_;
		gchar* _tmp123_;
		_tmp121_ = self->priv->column;
		_tmp122_ = self->priv->current;
		_tmp123_ = begin;
		self->priv->column = _tmp121_ + ((gint) (_tmp122_ - _tmp123_));
	} else {
		gint _tmp124_;
		gint _tmp125_;
		_tmp124_ = self->priv->column;
		_tmp125_ = token_length_in_chars;
		self->priv->column = _tmp124_ + _tmp125_;
	}
	_tmp126_ = self->priv->current;
	_tmp127_ = self->priv->line;
	_tmp128_ = self->priv->column;
	vala_source_location_init (&_vala_token_end, _tmp126_, _tmp127_, _tmp128_ - 1);
	result = type;
	if (token_begin) {
		*token_begin = _vala_token_begin;
	}
	if (token_end) {
		*token_end = _vala_token_end;
	}
	return result;
}


ValaTokenType vala_scanner_get_identifier_or_keyword (gchar* begin, gint len) {
	ValaTokenType result = 0;
	gint _tmp0_;
	_tmp0_ = len;
	switch (_tmp0_) {
		case 2:
		{
			gchar* _tmp1_;
			gchar _tmp2_;
			_tmp1_ = begin;
			_tmp2_ = _tmp1_[0];
			switch (_tmp2_) {
				case 'a':
				{
					gchar* _tmp3_;
					gboolean _tmp4_;
					_tmp3_ = begin;
					_tmp4_ = vala_scanner_matches (_tmp3_, "as");
					if (_tmp4_) {
						result = VALA_TOKEN_TYPE_AS;
						return result;
					}
					break;
				}
				case 'd':
				{
					gchar* _tmp5_;
					gboolean _tmp6_;
					_tmp5_ = begin;
					_tmp6_ = vala_scanner_matches (_tmp5_, "do");
					if (_tmp6_) {
						result = VALA_TOKEN_TYPE_DO;
						return result;
					}
					break;
				}
				case 'i':
				{
					gchar* _tmp7_;
					gchar _tmp8_;
					_tmp7_ = begin;
					_tmp8_ = _tmp7_[1];
					switch (_tmp8_) {
						case 'f':
						{
							result = VALA_TOKEN_TYPE_IF;
							return result;
						}
						case 'n':
						{
							result = VALA_TOKEN_TYPE_IN;
							return result;
						}
						case 's':
						{
							result = VALA_TOKEN_TYPE_IS;
							return result;
						}
						default:
						break;
					}
					break;
				}
				default:
				break;
			}
			break;
		}
		case 3:
		{
			gchar* _tmp9_;
			gchar _tmp10_;
			_tmp9_ = begin;
			_tmp10_ = _tmp9_[0];
			switch (_tmp10_) {
				case 'f':
				{
					gchar* _tmp11_;
					gboolean _tmp12_;
					_tmp11_ = begin;
					_tmp12_ = vala_scanner_matches (_tmp11_, "for");
					if (_tmp12_) {
						result = VALA_TOKEN_TYPE_FOR;
						return result;
					}
					break;
				}
				case 'g':
				{
					gchar* _tmp13_;
					gboolean _tmp14_;
					_tmp13_ = begin;
					_tmp14_ = vala_scanner_matches (_tmp13_, "get");
					if (_tmp14_) {
						result = VALA_TOKEN_TYPE_GET;
						return result;
					}
					break;
				}
				case 'n':
				{
					gchar* _tmp15_;
					gboolean _tmp16_;
					_tmp15_ = begin;
					_tmp16_ = vala_scanner_matches (_tmp15_, "new");
					if (_tmp16_) {
						result = VALA_TOKEN_TYPE_NEW;
						return result;
					}
					break;
				}
				case 'o':
				{
					gchar* _tmp17_;
					gboolean _tmp18_;
					_tmp17_ = begin;
					_tmp18_ = vala_scanner_matches (_tmp17_, "out");
					if (_tmp18_) {
						result = VALA_TOKEN_TYPE_OUT;
						return result;
					}
					break;
				}
				case 'r':
				{
					gchar* _tmp19_;
					gboolean _tmp20_;
					_tmp19_ = begin;
					_tmp20_ = vala_scanner_matches (_tmp19_, "ref");
					if (_tmp20_) {
						result = VALA_TOKEN_TYPE_REF;
						return result;
					}
					break;
				}
				case 's':
				{
					gchar* _tmp21_;
					gboolean _tmp22_;
					_tmp21_ = begin;
					_tmp22_ = vala_scanner_matches (_tmp21_, "set");
					if (_tmp22_) {
						result = VALA_TOKEN_TYPE_SET;
						return result;
					}
					break;
				}
				case 't':
				{
					gchar* _tmp23_;
					gboolean _tmp24_;
					_tmp23_ = begin;
					_tmp24_ = vala_scanner_matches (_tmp23_, "try");
					if (_tmp24_) {
						result = VALA_TOKEN_TYPE_TRY;
						return result;
					}
					break;
				}
				case 'v':
				{
					gchar* _tmp25_;
					gboolean _tmp26_;
					_tmp25_ = begin;
					_tmp26_ = vala_scanner_matches (_tmp25_, "var");
					if (_tmp26_) {
						result = VALA_TOKEN_TYPE_VAR;
						return result;
					}
					break;
				}
				default:
				break;
			}
			break;
		}
		case 4:
		{
			gchar* _tmp27_;
			gchar _tmp28_;
			_tmp27_ = begin;
			_tmp28_ = _tmp27_[0];
			switch (_tmp28_) {
				case 'b':
				{
					gchar* _tmp29_;
					gboolean _tmp30_;
					_tmp29_ = begin;
					_tmp30_ = vala_scanner_matches (_tmp29_, "base");
					if (_tmp30_) {
						result = VALA_TOKEN_TYPE_BASE;
						return result;
					}
					break;
				}
				case 'c':
				{
					gchar* _tmp31_;
					gboolean _tmp32_;
					_tmp31_ = begin;
					_tmp32_ = vala_scanner_matches (_tmp31_, "case");
					if (_tmp32_) {
						result = VALA_TOKEN_TYPE_CASE;
						return result;
					}
					break;
				}
				case 'e':
				{
					gchar* _tmp33_;
					gchar _tmp34_;
					_tmp33_ = begin;
					_tmp34_ = _tmp33_[1];
					switch (_tmp34_) {
						case 'l':
						{
							gchar* _tmp35_;
							gboolean _tmp36_;
							_tmp35_ = begin;
							_tmp36_ = vala_scanner_matches (_tmp35_, "else");
							if (_tmp36_) {
								result = VALA_TOKEN_TYPE_ELSE;
								return result;
							}
							break;
						}
						case 'n':
						{
							gchar* _tmp37_;
							gboolean _tmp38_;
							_tmp37_ = begin;
							_tmp38_ = vala_scanner_matches (_tmp37_, "enum");
							if (_tmp38_) {
								result = VALA_TOKEN_TYPE_ENUM;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 'l':
				{
					gchar* _tmp39_;
					gboolean _tmp40_;
					_tmp39_ = begin;
					_tmp40_ = vala_scanner_matches (_tmp39_, "lock");
					if (_tmp40_) {
						result = VALA_TOKEN_TYPE_LOCK;
						return result;
					}
					break;
				}
				case 'n':
				{
					gchar* _tmp41_;
					gboolean _tmp42_;
					_tmp41_ = begin;
					_tmp42_ = vala_scanner_matches (_tmp41_, "null");
					if (_tmp42_) {
						result = VALA_TOKEN_TYPE_NULL;
						return result;
					}
					break;
				}
				case 't':
				{
					gchar* _tmp43_;
					gchar _tmp44_;
					_tmp43_ = begin;
					_tmp44_ = _tmp43_[1];
					switch (_tmp44_) {
						case 'h':
						{
							gchar* _tmp45_;
							gboolean _tmp46_;
							_tmp45_ = begin;
							_tmp46_ = vala_scanner_matches (_tmp45_, "this");
							if (_tmp46_) {
								result = VALA_TOKEN_TYPE_THIS;
								return result;
							}
							break;
						}
						case 'r':
						{
							gchar* _tmp47_;
							gboolean _tmp48_;
							_tmp47_ = begin;
							_tmp48_ = vala_scanner_matches (_tmp47_, "true");
							if (_tmp48_) {
								result = VALA_TOKEN_TYPE_TRUE;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 'v':
				{
					gchar* _tmp49_;
					gboolean _tmp50_;
					_tmp49_ = begin;
					_tmp50_ = vala_scanner_matches (_tmp49_, "void");
					if (_tmp50_) {
						result = VALA_TOKEN_TYPE_VOID;
						return result;
					}
					break;
				}
				case 'w':
				{
					gchar* _tmp51_;
					gboolean _tmp52_;
					_tmp51_ = begin;
					_tmp52_ = vala_scanner_matches (_tmp51_, "weak");
					if (_tmp52_) {
						result = VALA_TOKEN_TYPE_WEAK;
						return result;
					}
					break;
				}
				default:
				break;
			}
			break;
		}
		case 5:
		{
			gchar* _tmp53_;
			gchar _tmp54_;
			_tmp53_ = begin;
			_tmp54_ = _tmp53_[0];
			switch (_tmp54_) {
				case 'a':
				{
					gchar* _tmp55_;
					gboolean _tmp56_;
					_tmp55_ = begin;
					_tmp56_ = vala_scanner_matches (_tmp55_, "async");
					if (_tmp56_) {
						result = VALA_TOKEN_TYPE_ASYNC;
						return result;
					}
					break;
				}
				case 'b':
				{
					gchar* _tmp57_;
					gboolean _tmp58_;
					_tmp57_ = begin;
					_tmp58_ = vala_scanner_matches (_tmp57_, "break");
					if (_tmp58_) {
						result = VALA_TOKEN_TYPE_BREAK;
						return result;
					}
					break;
				}
				case 'c':
				{
					gchar* _tmp59_;
					gchar _tmp60_;
					_tmp59_ = begin;
					_tmp60_ = _tmp59_[1];
					switch (_tmp60_) {
						case 'a':
						{
							gchar* _tmp61_;
							gboolean _tmp62_;
							_tmp61_ = begin;
							_tmp62_ = vala_scanner_matches (_tmp61_, "catch");
							if (_tmp62_) {
								result = VALA_TOKEN_TYPE_CATCH;
								return result;
							}
							break;
						}
						case 'l':
						{
							gchar* _tmp63_;
							gboolean _tmp64_;
							_tmp63_ = begin;
							_tmp64_ = vala_scanner_matches (_tmp63_, "class");
							if (_tmp64_) {
								result = VALA_TOKEN_TYPE_CLASS;
								return result;
							}
							break;
						}
						case 'o':
						{
							gchar* _tmp65_;
							gboolean _tmp66_;
							_tmp65_ = begin;
							_tmp66_ = vala_scanner_matches (_tmp65_, "const");
							if (_tmp66_) {
								result = VALA_TOKEN_TYPE_CONST;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 'f':
				{
					gchar* _tmp67_;
					gboolean _tmp68_;
					_tmp67_ = begin;
					_tmp68_ = vala_scanner_matches (_tmp67_, "false");
					if (_tmp68_) {
						result = VALA_TOKEN_TYPE_FALSE;
						return result;
					}
					break;
				}
				case 'o':
				{
					gchar* _tmp69_;
					gboolean _tmp70_;
					_tmp69_ = begin;
					_tmp70_ = vala_scanner_matches (_tmp69_, "owned");
					if (_tmp70_) {
						result = VALA_TOKEN_TYPE_OWNED;
						return result;
					}
					break;
				}
				case 't':
				{
					gchar* _tmp71_;
					gboolean _tmp72_;
					_tmp71_ = begin;
					_tmp72_ = vala_scanner_matches (_tmp71_, "throw");
					if (_tmp72_) {
						result = VALA_TOKEN_TYPE_THROW;
						return result;
					}
					break;
				}
				case 'u':
				{
					gchar* _tmp73_;
					gboolean _tmp74_;
					_tmp73_ = begin;
					_tmp74_ = vala_scanner_matches (_tmp73_, "using");
					if (_tmp74_) {
						result = VALA_TOKEN_TYPE_USING;
						return result;
					}
					break;
				}
				case 'w':
				{
					gchar* _tmp75_;
					gboolean _tmp76_;
					_tmp75_ = begin;
					_tmp76_ = vala_scanner_matches (_tmp75_, "while");
					if (_tmp76_) {
						result = VALA_TOKEN_TYPE_WHILE;
						return result;
					}
					break;
				}
				case 'y':
				{
					gchar* _tmp77_;
					gboolean _tmp78_;
					_tmp77_ = begin;
					_tmp78_ = vala_scanner_matches (_tmp77_, "yield");
					if (_tmp78_) {
						result = VALA_TOKEN_TYPE_YIELD;
						return result;
					}
					break;
				}
				default:
				break;
			}
			break;
		}
		case 6:
		{
			gchar* _tmp79_;
			gchar _tmp80_;
			_tmp79_ = begin;
			_tmp80_ = _tmp79_[0];
			switch (_tmp80_) {
				case 'd':
				{
					gchar* _tmp81_;
					gboolean _tmp82_;
					_tmp81_ = begin;
					_tmp82_ = vala_scanner_matches (_tmp81_, "delete");
					if (_tmp82_) {
						result = VALA_TOKEN_TYPE_DELETE;
						return result;
					}
					break;
				}
				case 'e':
				{
					gchar* _tmp83_;
					gboolean _tmp84_;
					_tmp83_ = begin;
					_tmp84_ = vala_scanner_matches (_tmp83_, "extern");
					if (_tmp84_) {
						result = VALA_TOKEN_TYPE_EXTERN;
						return result;
					}
					break;
				}
				case 'i':
				{
					gchar* _tmp85_;
					gboolean _tmp86_;
					_tmp85_ = begin;
					_tmp86_ = vala_scanner_matches (_tmp85_, "inline");
					if (_tmp86_) {
						result = VALA_TOKEN_TYPE_INLINE;
						return result;
					}
					break;
				}
				case 'p':
				{
					gchar* _tmp87_;
					gchar _tmp88_;
					_tmp87_ = begin;
					_tmp88_ = _tmp87_[1];
					switch (_tmp88_) {
						case 'a':
						{
							gchar* _tmp89_;
							gboolean _tmp90_;
							_tmp89_ = begin;
							_tmp90_ = vala_scanner_matches (_tmp89_, "params");
							if (_tmp90_) {
								result = VALA_TOKEN_TYPE_PARAMS;
								return result;
							}
							break;
						}
						case 'u':
						{
							gchar* _tmp91_;
							gboolean _tmp92_;
							_tmp91_ = begin;
							_tmp92_ = vala_scanner_matches (_tmp91_, "public");
							if (_tmp92_) {
								result = VALA_TOKEN_TYPE_PUBLIC;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 'r':
				{
					gchar* _tmp93_;
					gboolean _tmp94_;
					_tmp93_ = begin;
					_tmp94_ = vala_scanner_matches (_tmp93_, "return");
					if (_tmp94_) {
						result = VALA_TOKEN_TYPE_RETURN;
						return result;
					}
					break;
				}
				case 's':
				{
					gchar* _tmp95_;
					gchar _tmp96_;
					_tmp95_ = begin;
					_tmp96_ = _tmp95_[1];
					switch (_tmp96_) {
						case 'e':
						{
							gchar* _tmp97_;
							gboolean _tmp98_;
							_tmp97_ = begin;
							_tmp98_ = vala_scanner_matches (_tmp97_, "sealed");
							if (_tmp98_) {
								result = VALA_TOKEN_TYPE_SEALED;
								return result;
							}
							break;
						}
						case 'i':
						{
							gchar* _tmp99_;
							gchar _tmp100_;
							_tmp99_ = begin;
							_tmp100_ = _tmp99_[2];
							switch (_tmp100_) {
								case 'g':
								{
									gchar* _tmp101_;
									gboolean _tmp102_;
									_tmp101_ = begin;
									_tmp102_ = vala_scanner_matches (_tmp101_, "signal");
									if (_tmp102_) {
										result = VALA_TOKEN_TYPE_SIGNAL;
										return result;
									}
									break;
								}
								case 'z':
								{
									gchar* _tmp103_;
									gboolean _tmp104_;
									_tmp103_ = begin;
									_tmp104_ = vala_scanner_matches (_tmp103_, "sizeof");
									if (_tmp104_) {
										result = VALA_TOKEN_TYPE_SIZEOF;
										return result;
									}
									break;
								}
								default:
								break;
							}
							break;
						}
						case 't':
						{
							gchar* _tmp105_;
							gchar _tmp106_;
							_tmp105_ = begin;
							_tmp106_ = _tmp105_[2];
							switch (_tmp106_) {
								case 'a':
								{
									gchar* _tmp107_;
									gboolean _tmp108_;
									_tmp107_ = begin;
									_tmp108_ = vala_scanner_matches (_tmp107_, "static");
									if (_tmp108_) {
										result = VALA_TOKEN_TYPE_STATIC;
										return result;
									}
									break;
								}
								case 'r':
								{
									gchar* _tmp109_;
									gboolean _tmp110_;
									_tmp109_ = begin;
									_tmp110_ = vala_scanner_matches (_tmp109_, "struct");
									if (_tmp110_) {
										result = VALA_TOKEN_TYPE_STRUCT;
										return result;
									}
									break;
								}
								default:
								break;
							}
							break;
						}
						case 'w':
						{
							gchar* _tmp111_;
							gboolean _tmp112_;
							_tmp111_ = begin;
							_tmp112_ = vala_scanner_matches (_tmp111_, "switch");
							if (_tmp112_) {
								result = VALA_TOKEN_TYPE_SWITCH;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 't':
				{
					gchar* _tmp113_;
					gchar _tmp114_;
					_tmp113_ = begin;
					_tmp114_ = _tmp113_[1];
					switch (_tmp114_) {
						case 'h':
						{
							gchar* _tmp115_;
							gboolean _tmp116_;
							_tmp115_ = begin;
							_tmp116_ = vala_scanner_matches (_tmp115_, "throws");
							if (_tmp116_) {
								result = VALA_TOKEN_TYPE_THROWS;
								return result;
							}
							break;
						}
						case 'y':
						{
							gchar* _tmp117_;
							gboolean _tmp118_;
							_tmp117_ = begin;
							_tmp118_ = vala_scanner_matches (_tmp117_, "typeof");
							if (_tmp118_) {
								result = VALA_TOKEN_TYPE_TYPEOF;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				default:
				break;
			}
			break;
		}
		case 7:
		{
			gchar* _tmp119_;
			gchar _tmp120_;
			_tmp119_ = begin;
			_tmp120_ = _tmp119_[0];
			switch (_tmp120_) {
				case 'd':
				{
					gchar* _tmp121_;
					gchar _tmp122_;
					_tmp121_ = begin;
					_tmp122_ = _tmp121_[1];
					switch (_tmp122_) {
						case 'e':
						{
							gchar* _tmp123_;
							gboolean _tmp124_;
							_tmp123_ = begin;
							_tmp124_ = vala_scanner_matches (_tmp123_, "default");
							if (_tmp124_) {
								result = VALA_TOKEN_TYPE_DEFAULT;
								return result;
							}
							break;
						}
						case 'y':
						{
							gchar* _tmp125_;
							gboolean _tmp126_;
							_tmp125_ = begin;
							_tmp126_ = vala_scanner_matches (_tmp125_, "dynamic");
							if (_tmp126_) {
								result = VALA_TOKEN_TYPE_DYNAMIC;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 'e':
				{
					gchar* _tmp127_;
					gboolean _tmp128_;
					_tmp127_ = begin;
					_tmp128_ = vala_scanner_matches (_tmp127_, "ensures");
					if (_tmp128_) {
						result = VALA_TOKEN_TYPE_ENSURES;
						return result;
					}
					break;
				}
				case 'f':
				{
					gchar* _tmp129_;
					gchar _tmp130_;
					_tmp129_ = begin;
					_tmp130_ = _tmp129_[1];
					switch (_tmp130_) {
						case 'i':
						{
							gchar* _tmp131_;
							gboolean _tmp132_;
							_tmp131_ = begin;
							_tmp132_ = vala_scanner_matches (_tmp131_, "finally");
							if (_tmp132_) {
								result = VALA_TOKEN_TYPE_FINALLY;
								return result;
							}
							break;
						}
						case 'o':
						{
							gchar* _tmp133_;
							gboolean _tmp134_;
							_tmp133_ = begin;
							_tmp134_ = vala_scanner_matches (_tmp133_, "foreach");
							if (_tmp134_) {
								result = VALA_TOKEN_TYPE_FOREACH;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 'p':
				{
					gchar* _tmp135_;
					gboolean _tmp136_;
					_tmp135_ = begin;
					_tmp136_ = vala_scanner_matches (_tmp135_, "private");
					if (_tmp136_) {
						result = VALA_TOKEN_TYPE_PRIVATE;
						return result;
					}
					break;
				}
				case 'u':
				{
					gchar* _tmp137_;
					gboolean _tmp138_;
					_tmp137_ = begin;
					_tmp138_ = vala_scanner_matches (_tmp137_, "unowned");
					if (_tmp138_) {
						result = VALA_TOKEN_TYPE_UNOWNED;
						return result;
					}
					break;
				}
				case 'v':
				{
					gchar* _tmp139_;
					gboolean _tmp140_;
					_tmp139_ = begin;
					_tmp140_ = vala_scanner_matches (_tmp139_, "virtual");
					if (_tmp140_) {
						result = VALA_TOKEN_TYPE_VIRTUAL;
						return result;
					}
					break;
				}
				default:
				break;
			}
			break;
		}
		case 8:
		{
			gchar* _tmp141_;
			gchar _tmp142_;
			_tmp141_ = begin;
			_tmp142_ = _tmp141_[0];
			switch (_tmp142_) {
				case 'a':
				{
					gchar* _tmp143_;
					gboolean _tmp144_;
					_tmp143_ = begin;
					_tmp144_ = vala_scanner_matches (_tmp143_, "abstract");
					if (_tmp144_) {
						result = VALA_TOKEN_TYPE_ABSTRACT;
						return result;
					}
					break;
				}
				case 'c':
				{
					gchar* _tmp145_;
					gboolean _tmp146_;
					_tmp145_ = begin;
					_tmp146_ = vala_scanner_matches (_tmp145_, "continue");
					if (_tmp146_) {
						result = VALA_TOKEN_TYPE_CONTINUE;
						return result;
					}
					break;
				}
				case 'd':
				{
					gchar* _tmp147_;
					gboolean _tmp148_;
					_tmp147_ = begin;
					_tmp148_ = vala_scanner_matches (_tmp147_, "delegate");
					if (_tmp148_) {
						result = VALA_TOKEN_TYPE_DELEGATE;
						return result;
					}
					break;
				}
				case 'i':
				{
					gchar* _tmp149_;
					gboolean _tmp150_;
					_tmp149_ = begin;
					_tmp150_ = vala_scanner_matches (_tmp149_, "internal");
					if (_tmp150_) {
						result = VALA_TOKEN_TYPE_INTERNAL;
						return result;
					}
					break;
				}
				case 'o':
				{
					gchar* _tmp151_;
					gboolean _tmp152_;
					_tmp151_ = begin;
					_tmp152_ = vala_scanner_matches (_tmp151_, "override");
					if (_tmp152_) {
						result = VALA_TOKEN_TYPE_OVERRIDE;
						return result;
					}
					break;
				}
				case 'r':
				{
					gchar* _tmp153_;
					gboolean _tmp154_;
					_tmp153_ = begin;
					_tmp154_ = vala_scanner_matches (_tmp153_, "requires");
					if (_tmp154_) {
						result = VALA_TOKEN_TYPE_REQUIRES;
						return result;
					}
					break;
				}
				case 'v':
				{
					gchar* _tmp155_;
					gboolean _tmp156_;
					_tmp155_ = begin;
					_tmp156_ = vala_scanner_matches (_tmp155_, "volatile");
					if (_tmp156_) {
						result = VALA_TOKEN_TYPE_VOLATILE;
						return result;
					}
					break;
				}
				default:
				break;
			}
			break;
		}
		case 9:
		{
			gchar* _tmp157_;
			gchar _tmp158_;
			_tmp157_ = begin;
			_tmp158_ = _tmp157_[0];
			switch (_tmp158_) {
				case 'c':
				{
					gchar* _tmp159_;
					gboolean _tmp160_;
					_tmp159_ = begin;
					_tmp160_ = vala_scanner_matches (_tmp159_, "construct");
					if (_tmp160_) {
						result = VALA_TOKEN_TYPE_CONSTRUCT;
						return result;
					}
					break;
				}
				case 'i':
				{
					gchar* _tmp161_;
					gboolean _tmp162_;
					_tmp161_ = begin;
					_tmp162_ = vala_scanner_matches (_tmp161_, "interface");
					if (_tmp162_) {
						result = VALA_TOKEN_TYPE_INTERFACE;
						return result;
					}
					break;
				}
				case 'n':
				{
					gchar* _tmp163_;
					gboolean _tmp164_;
					_tmp163_ = begin;
					_tmp164_ = vala_scanner_matches (_tmp163_, "namespace");
					if (_tmp164_) {
						result = VALA_TOKEN_TYPE_NAMESPACE;
						return result;
					}
					break;
				}
				case 'p':
				{
					gchar* _tmp165_;
					gboolean _tmp166_;
					_tmp165_ = begin;
					_tmp166_ = vala_scanner_matches (_tmp165_, "protected");
					if (_tmp166_) {
						result = VALA_TOKEN_TYPE_PROTECTED;
						return result;
					}
					break;
				}
				default:
				break;
			}
			break;
		}
		case 11:
		{
			gchar* _tmp167_;
			gboolean _tmp168_;
			_tmp167_ = begin;
			_tmp168_ = vala_scanner_matches (_tmp167_, "errordomain");
			if (_tmp168_) {
				result = VALA_TOKEN_TYPE_ERRORDOMAIN;
				return result;
			}
			break;
		}
		default:
		break;
	}
	result = VALA_TOKEN_TYPE_IDENTIFIER;
	return result;
}


static ValaTokenType vala_scanner_read_number (ValaScanner* self) {
	ValaTokenType result = 0;
	ValaTokenType type;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gboolean _tmp27_ = FALSE;
	gboolean _tmp28_ = FALSE;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gboolean _tmp44_ = FALSE;
	gchar* _tmp45_;
	gchar* _tmp46_;
	gchar* _tmp67_;
	gchar* _tmp68_;
	g_return_val_if_fail (self != NULL, 0);
	type = VALA_TOKEN_TYPE_INTEGER_LITERAL;
	_tmp3_ = self->priv->current;
	_tmp4_ = self->priv->end;
	if (_tmp3_ < (_tmp4_ - 2)) {
		gchar* _tmp5_;
		gchar _tmp6_;
		_tmp5_ = self->priv->current;
		_tmp6_ = _tmp5_[0];
		_tmp2_ = _tmp6_ == '0';
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gchar* _tmp7_;
		gchar _tmp8_;
		_tmp7_ = self->priv->current;
		_tmp8_ = _tmp7_[1];
		_tmp1_ = _tmp8_ == 'x';
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gchar* _tmp9_;
		gchar _tmp10_;
		gboolean _tmp11_;
		_tmp9_ = self->priv->current;
		_tmp10_ = _tmp9_[2];
		_tmp11_ = g_ascii_isxdigit (_tmp10_);
		_tmp0_ = _tmp11_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gchar* _tmp12_;
		_tmp12_ = self->priv->current;
		self->priv->current = _tmp12_ + 2;
		while (TRUE) {
			gboolean _tmp13_ = FALSE;
			gchar* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp19_;
			_tmp14_ = self->priv->current;
			_tmp15_ = self->priv->end;
			if (_tmp14_ < _tmp15_) {
				gchar* _tmp16_;
				gchar _tmp17_;
				gboolean _tmp18_;
				_tmp16_ = self->priv->current;
				_tmp17_ = _tmp16_[0];
				_tmp18_ = g_ascii_isxdigit (_tmp17_);
				_tmp13_ = _tmp18_;
			} else {
				_tmp13_ = FALSE;
			}
			if (!_tmp13_) {
				break;
			}
			_tmp19_ = self->priv->current;
			self->priv->current = _tmp19_ + 1;
		}
	} else {
		while (TRUE) {
			gboolean _tmp20_ = FALSE;
			gchar* _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp26_;
			_tmp21_ = self->priv->current;
			_tmp22_ = self->priv->end;
			if (_tmp21_ < _tmp22_) {
				gchar* _tmp23_;
				gchar _tmp24_;
				gboolean _tmp25_;
				_tmp23_ = self->priv->current;
				_tmp24_ = _tmp23_[0];
				_tmp25_ = g_ascii_isdigit (_tmp24_);
				_tmp20_ = _tmp25_;
			} else {
				_tmp20_ = FALSE;
			}
			if (!_tmp20_) {
				break;
			}
			_tmp26_ = self->priv->current;
			self->priv->current = _tmp26_ + 1;
		}
	}
	_tmp29_ = self->priv->current;
	_tmp30_ = self->priv->end;
	if (_tmp29_ < (_tmp30_ - 1)) {
		gchar* _tmp31_;
		gchar _tmp32_;
		_tmp31_ = self->priv->current;
		_tmp32_ = _tmp31_[0];
		_tmp28_ = _tmp32_ == '.';
	} else {
		_tmp28_ = FALSE;
	}
	if (_tmp28_) {
		gchar* _tmp33_;
		gchar _tmp34_;
		gboolean _tmp35_;
		_tmp33_ = self->priv->current;
		_tmp34_ = _tmp33_[1];
		_tmp35_ = g_ascii_isdigit (_tmp34_);
		_tmp27_ = _tmp35_;
	} else {
		_tmp27_ = FALSE;
	}
	if (_tmp27_) {
		gchar* _tmp36_;
		type = VALA_TOKEN_TYPE_REAL_LITERAL;
		_tmp36_ = self->priv->current;
		self->priv->current = _tmp36_ + 1;
		while (TRUE) {
			gboolean _tmp37_ = FALSE;
			gchar* _tmp38_;
			gchar* _tmp39_;
			gchar* _tmp43_;
			_tmp38_ = self->priv->current;
			_tmp39_ = self->priv->end;
			if (_tmp38_ < _tmp39_) {
				gchar* _tmp40_;
				gchar _tmp41_;
				gboolean _tmp42_;
				_tmp40_ = self->priv->current;
				_tmp41_ = _tmp40_[0];
				_tmp42_ = g_ascii_isdigit (_tmp41_);
				_tmp37_ = _tmp42_;
			} else {
				_tmp37_ = FALSE;
			}
			if (!_tmp37_) {
				break;
			}
			_tmp43_ = self->priv->current;
			self->priv->current = _tmp43_ + 1;
		}
	}
	_tmp45_ = self->priv->current;
	_tmp46_ = self->priv->end;
	if (_tmp45_ < _tmp46_) {
		gchar* _tmp47_;
		gchar _tmp48_;
		gchar _tmp49_;
		_tmp47_ = self->priv->current;
		_tmp48_ = _tmp47_[0];
		_tmp49_ = g_ascii_tolower (_tmp48_);
		_tmp44_ = _tmp49_ == 'e';
	} else {
		_tmp44_ = FALSE;
	}
	if (_tmp44_) {
		gchar* _tmp50_;
		gboolean _tmp51_ = FALSE;
		gchar* _tmp52_;
		gchar* _tmp53_;
		type = VALA_TOKEN_TYPE_REAL_LITERAL;
		_tmp50_ = self->priv->current;
		self->priv->current = _tmp50_ + 1;
		_tmp52_ = self->priv->current;
		_tmp53_ = self->priv->end;
		if (_tmp52_ < _tmp53_) {
			gboolean _tmp54_ = FALSE;
			gchar* _tmp55_;
			gchar _tmp56_;
			_tmp55_ = self->priv->current;
			_tmp56_ = _tmp55_[0];
			if (_tmp56_ == '+') {
				_tmp54_ = TRUE;
			} else {
				gchar* _tmp57_;
				gchar _tmp58_;
				_tmp57_ = self->priv->current;
				_tmp58_ = _tmp57_[0];
				_tmp54_ = _tmp58_ == '-';
			}
			_tmp51_ = _tmp54_;
		} else {
			_tmp51_ = FALSE;
		}
		if (_tmp51_) {
			gchar* _tmp59_;
			_tmp59_ = self->priv->current;
			self->priv->current = _tmp59_ + 1;
		}
		while (TRUE) {
			gboolean _tmp60_ = FALSE;
			gchar* _tmp61_;
			gchar* _tmp62_;
			gchar* _tmp66_;
			_tmp61_ = self->priv->current;
			_tmp62_ = self->priv->end;
			if (_tmp61_ < _tmp62_) {
				gchar* _tmp63_;
				gchar _tmp64_;
				gboolean _tmp65_;
				_tmp63_ = self->priv->current;
				_tmp64_ = _tmp63_[0];
				_tmp65_ = g_ascii_isdigit (_tmp64_);
				_tmp60_ = _tmp65_;
			} else {
				_tmp60_ = FALSE;
			}
			if (!_tmp60_) {
				break;
			}
			_tmp66_ = self->priv->current;
			self->priv->current = _tmp66_ + 1;
		}
	}
	_tmp67_ = self->priv->current;
	_tmp68_ = self->priv->end;
	if (_tmp67_ < _tmp68_) {
		gboolean real_literal;
		ValaTokenType _tmp69_;
		gchar* _tmp70_;
		gchar _tmp71_;
		gboolean _tmp98_ = FALSE;
		gboolean _tmp99_;
		_tmp69_ = type;
		real_literal = _tmp69_ == VALA_TOKEN_TYPE_REAL_LITERAL;
		_tmp70_ = self->priv->current;
		_tmp71_ = _tmp70_[0];
		switch (_tmp71_) {
			case 'l':
			case 'L':
			{
				ValaTokenType _tmp72_;
				_tmp72_ = type;
				if (_tmp72_ == VALA_TOKEN_TYPE_INTEGER_LITERAL) {
					gchar* _tmp73_;
					gboolean _tmp74_ = FALSE;
					gchar* _tmp75_;
					gchar* _tmp76_;
					_tmp73_ = self->priv->current;
					self->priv->current = _tmp73_ + 1;
					_tmp75_ = self->priv->current;
					_tmp76_ = self->priv->end;
					if (_tmp75_ < _tmp76_) {
						gchar* _tmp77_;
						gchar _tmp78_;
						gchar _tmp79_;
						_tmp77_ = self->priv->current;
						_tmp78_ = _tmp77_[0];
						_tmp79_ = g_ascii_tolower (_tmp78_);
						_tmp74_ = _tmp79_ == 'l';
					} else {
						_tmp74_ = FALSE;
					}
					if (_tmp74_) {
						gchar* _tmp80_;
						_tmp80_ = self->priv->current;
						self->priv->current = _tmp80_ + 1;
					}
				}
				break;
			}
			case 'u':
			case 'U':
			{
				ValaTokenType _tmp81_;
				_tmp81_ = type;
				if (_tmp81_ == VALA_TOKEN_TYPE_INTEGER_LITERAL) {
					gchar* _tmp82_;
					gboolean _tmp83_ = FALSE;
					gchar* _tmp84_;
					gchar* _tmp85_;
					_tmp82_ = self->priv->current;
					self->priv->current = _tmp82_ + 1;
					_tmp84_ = self->priv->current;
					_tmp85_ = self->priv->end;
					if (_tmp84_ < _tmp85_) {
						gchar* _tmp86_;
						gchar _tmp87_;
						gchar _tmp88_;
						_tmp86_ = self->priv->current;
						_tmp87_ = _tmp86_[0];
						_tmp88_ = g_ascii_tolower (_tmp87_);
						_tmp83_ = _tmp88_ == 'l';
					} else {
						_tmp83_ = FALSE;
					}
					if (_tmp83_) {
						gchar* _tmp89_;
						gboolean _tmp90_ = FALSE;
						gchar* _tmp91_;
						gchar* _tmp92_;
						_tmp89_ = self->priv->current;
						self->priv->current = _tmp89_ + 1;
						_tmp91_ = self->priv->current;
						_tmp92_ = self->priv->end;
						if (_tmp91_ < _tmp92_) {
							gchar* _tmp93_;
							gchar _tmp94_;
							gchar _tmp95_;
							_tmp93_ = self->priv->current;
							_tmp94_ = _tmp93_[0];
							_tmp95_ = g_ascii_tolower (_tmp94_);
							_tmp90_ = _tmp95_ == 'l';
						} else {
							_tmp90_ = FALSE;
						}
						if (_tmp90_) {
							gchar* _tmp96_;
							_tmp96_ = self->priv->current;
							self->priv->current = _tmp96_ + 1;
						}
					}
				}
				break;
			}
			case 'f':
			case 'F':
			case 'd':
			case 'D':
			{
				gchar* _tmp97_;
				type = VALA_TOKEN_TYPE_REAL_LITERAL;
				_tmp97_ = self->priv->current;
				self->priv->current = _tmp97_ + 1;
				break;
			}
			default:
			break;
		}
		_tmp99_ = real_literal;
		if (!_tmp99_) {
			gchar* _tmp100_;
			gchar _tmp101_;
			gboolean _tmp102_;
			_tmp100_ = self->priv->current;
			_tmp101_ = _tmp100_[0];
			_tmp102_ = vala_scanner_is_ident_char (self, _tmp101_);
			_tmp98_ = _tmp102_;
		} else {
			_tmp98_ = FALSE;
		}
		if (_tmp98_) {
			while (TRUE) {
				gboolean _tmp103_ = FALSE;
				gchar* _tmp104_;
				gchar* _tmp105_;
				gchar* _tmp109_;
				_tmp104_ = self->priv->current;
				_tmp105_ = self->priv->end;
				if (_tmp104_ < _tmp105_) {
					gchar* _tmp106_;
					gchar _tmp107_;
					gboolean _tmp108_;
					_tmp106_ = self->priv->current;
					_tmp107_ = _tmp106_[0];
					_tmp108_ = vala_scanner_is_ident_char (self, _tmp107_);
					_tmp103_ = _tmp108_;
				} else {
					_tmp103_ = FALSE;
				}
				if (!_tmp103_) {
					break;
				}
				_tmp109_ = self->priv->current;
				self->priv->current = _tmp109_ + 1;
			}
			type = VALA_TOKEN_TYPE_IDENTIFIER;
		}
	}
	result = type;
	return result;
}


static void _vala_array_add13 (ValaScannerState* * array, int* length, int* size, ValaScannerState value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaScannerState, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void _vala_array_add14 (ValaScannerState* * array, int* length, int* size, ValaScannerState value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaScannerState, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void _vala_array_add15 (ValaScannerState* * array, int* length, int* size, ValaScannerState value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaScannerState, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void _vala_array_add16 (ValaScannerState* * array, int* length, int* size, ValaScannerState value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaScannerState, *array, *size);
	}
	(*array)[(*length)++] = value;
}


ValaTokenType vala_scanner_read_template_token (ValaScanner* self, ValaSourceLocation* token_begin, ValaSourceLocation* token_end) {
	ValaSourceLocation _vala_token_begin = {0};
	ValaSourceLocation _vala_token_end = {0};
	ValaTokenType result = 0;
	ValaTokenType type = 0;
	gchar* begin;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint token_length_in_chars;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gint _tmp126_;
	gchar* _tmp132_;
	gint _tmp133_;
	gint _tmp134_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->current;
	begin = _tmp0_;
	_tmp1_ = begin;
	_tmp2_ = self->priv->line;
	_tmp3_ = self->priv->column;
	vala_source_location_init (&_vala_token_begin, _tmp1_, _tmp2_, _tmp3_);
	token_length_in_chars = -1;
	_tmp4_ = self->priv->current;
	_tmp5_ = self->priv->end;
	if (_tmp4_ >= _tmp5_) {
		type = VALA_TOKEN_TYPE_EOF;
	} else {
		gchar* _tmp6_;
		gchar _tmp7_;
		_tmp6_ = self->priv->current;
		_tmp7_ = _tmp6_[0];
		switch (_tmp7_) {
			case '"':
			{
				gchar* _tmp8_;
				gint _tmp9_;
				type = VALA_TOKEN_TYPE_CLOSE_TEMPLATE;
				_tmp8_ = self->priv->current;
				self->priv->current = _tmp8_ + 1;
				_tmp9_ = self->priv->state_stack_length1;
				self->priv->state_stack_length1 = _tmp9_ - 1;
				break;
			}
			case '$':
			{
				gchar* _tmp10_;
				gchar* _tmp11_;
				gboolean _tmp12_ = FALSE;
				gchar* _tmp13_;
				gchar _tmp14_;
				gboolean _tmp15_;
				_tmp10_ = _vala_token_begin.pos;
				_vala_token_begin.pos = _tmp10_ + 1;
				_tmp11_ = self->priv->current;
				self->priv->current = _tmp11_ + 1;
				_tmp13_ = self->priv->current;
				_tmp14_ = _tmp13_[0];
				_tmp15_ = g_ascii_isalpha (_tmp14_);
				if (_tmp15_) {
					_tmp12_ = TRUE;
				} else {
					gchar* _tmp16_;
					gchar _tmp17_;
					_tmp16_ = self->priv->current;
					_tmp17_ = _tmp16_[0];
					_tmp12_ = _tmp17_ == '_';
				}
				if (_tmp12_) {
					gint len;
					ValaScannerState* _tmp26_;
					gint _tmp26__length1;
					len = 0;
					while (TRUE) {
						gboolean _tmp18_ = FALSE;
						gchar* _tmp19_;
						gchar* _tmp20_;
						gchar* _tmp24_;
						gint _tmp25_;
						_tmp19_ = self->priv->current;
						_tmp20_ = self->priv->end;
						if (_tmp19_ < _tmp20_) {
							gchar* _tmp21_;
							gchar _tmp22_;
							gboolean _tmp23_;
							_tmp21_ = self->priv->current;
							_tmp22_ = _tmp21_[0];
							_tmp23_ = vala_scanner_is_ident_char (self, _tmp22_);
							_tmp18_ = _tmp23_;
						} else {
							_tmp18_ = FALSE;
						}
						if (!_tmp18_) {
							break;
						}
						_tmp24_ = self->priv->current;
						self->priv->current = _tmp24_ + 1;
						_tmp25_ = len;
						len = _tmp25_ + 1;
					}
					type = VALA_TOKEN_TYPE_IDENTIFIER;
					_tmp26_ = self->priv->state_stack;
					_tmp26__length1 = self->priv->state_stack_length1;
					_vala_array_add13 (&self->priv->state_stack, &self->priv->state_stack_length1, &self->priv->_state_stack_size_, VALA_SCANNER_STATE_TEMPLATE_PART);
				} else {
					gchar* _tmp27_;
					gchar _tmp28_;
					_tmp27_ = self->priv->current;
					_tmp28_ = _tmp27_[0];
					if (_tmp28_ == '(') {
						gchar* _tmp29_;
						gint _tmp30_;
						ValaScannerState* _tmp31_;
						gint _tmp31__length1;
						ValaSourceLocation _tmp32_ = {0};
						ValaSourceLocation _tmp33_ = {0};
						ValaTokenType _tmp34_;
						_tmp29_ = self->priv->current;
						self->priv->current = _tmp29_ + 1;
						_tmp30_ = self->priv->column;
						self->priv->column = _tmp30_ + 2;
						_tmp31_ = self->priv->state_stack;
						_tmp31__length1 = self->priv->state_stack_length1;
						_vala_array_add14 (&self->priv->state_stack, &self->priv->state_stack_length1, &self->priv->_state_stack_size_, VALA_SCANNER_STATE_PARENS);
						_tmp34_ = vala_scanner_read_token (self, &_tmp32_, &_tmp33_);
						_vala_token_begin = _tmp32_;
						_vala_token_end = _tmp33_;
						result = _tmp34_;
						if (token_begin) {
							*token_begin = _vala_token_begin;
						}
						if (token_end) {
							*token_end = _vala_token_end;
						}
						return result;
					} else {
						gchar* _tmp35_;
						gchar _tmp36_;
						_tmp35_ = self->priv->current;
						_tmp36_ = _tmp35_[0];
						if (_tmp36_ == '$') {
							gchar* _tmp37_;
							ValaScannerState* _tmp38_;
							gint _tmp38__length1;
							type = VALA_TOKEN_TYPE_TEMPLATE_STRING_LITERAL;
							_tmp37_ = self->priv->current;
							self->priv->current = _tmp37_ + 1;
							_tmp38_ = self->priv->state_stack;
							_tmp38__length1 = self->priv->state_stack_length1;
							_vala_array_add15 (&self->priv->state_stack, &self->priv->state_stack_length1, &self->priv->_state_stack_size_, VALA_SCANNER_STATE_TEMPLATE_PART);
						} else {
							ValaSourceReference* _tmp39_;
							ValaSourceReference* _tmp40_;
							ValaSourceLocation _tmp41_ = {0};
							ValaSourceLocation _tmp42_ = {0};
							ValaTokenType _tmp43_;
							_tmp39_ = vala_scanner_get_source_reference (self, 1, 0);
							_tmp40_ = _tmp39_;
							vala_report_error (_tmp40_, "unexpected character");
							_vala_source_reference_unref0 (_tmp40_);
							_tmp43_ = vala_scanner_read_template_token (self, &_tmp41_, &_tmp42_);
							_vala_token_begin = _tmp41_;
							_vala_token_end = _tmp42_;
							result = _tmp43_;
							if (token_begin) {
								*token_begin = _vala_token_begin;
							}
							if (token_end) {
								*token_end = _vala_token_end;
							}
							return result;
						}
					}
				}
				break;
			}
			default:
			{
				gchar* _tmp116_;
				gchar* _tmp117_;
				ValaScannerState* _tmp125_;
				gint _tmp125__length1;
				type = VALA_TOKEN_TYPE_TEMPLATE_STRING_LITERAL;
				token_length_in_chars = 0;
				while (TRUE) {
					gboolean _tmp44_ = FALSE;
					gboolean _tmp45_ = FALSE;
					gchar* _tmp46_;
					gchar* _tmp47_;
					gchar* _tmp52_;
					gchar _tmp53_;
					_tmp46_ = self->priv->current;
					_tmp47_ = self->priv->end;
					if (_tmp46_ < _tmp47_) {
						gchar* _tmp48_;
						gchar _tmp49_;
						_tmp48_ = self->priv->current;
						_tmp49_ = _tmp48_[0];
						_tmp45_ = _tmp49_ != '"';
					} else {
						_tmp45_ = FALSE;
					}
					if (_tmp45_) {
						gchar* _tmp50_;
						gchar _tmp51_;
						_tmp50_ = self->priv->current;
						_tmp51_ = _tmp50_[0];
						_tmp44_ = _tmp51_ != '$';
					} else {
						_tmp44_ = FALSE;
					}
					if (!_tmp44_) {
						break;
					}
					_tmp52_ = self->priv->current;
					_tmp53_ = _tmp52_[0];
					if (_tmp53_ == '\\') {
						gchar* _tmp54_;
						gint _tmp55_;
						gchar* _tmp56_;
						gchar* _tmp57_;
						gchar* _tmp58_;
						gchar _tmp59_;
						_tmp54_ = self->priv->current;
						self->priv->current = _tmp54_ + 1;
						_tmp55_ = token_length_in_chars;
						token_length_in_chars = _tmp55_ + 1;
						_tmp56_ = self->priv->current;
						_tmp57_ = self->priv->end;
						if (_tmp56_ >= _tmp57_) {
							break;
						}
						_tmp58_ = self->priv->current;
						_tmp59_ = _tmp58_[0];
						switch (_tmp59_) {
							case '\'':
							case '"':
							case '\\':
							case '0':
							case 'b':
							case 'f':
							case 'n':
							case 'r':
							case 't':
							case 'v':
							{
								gchar* _tmp60_;
								gint _tmp61_;
								_tmp60_ = self->priv->current;
								self->priv->current = _tmp60_ + 1;
								_tmp61_ = token_length_in_chars;
								token_length_in_chars = _tmp61_ + 1;
								break;
							}
							case 'u':
							{
								gchar* _tmp62_;
								gint _tmp63_;
								gint digit_length = 0;
								gint _tmp76_;
								_tmp62_ = self->priv->current;
								self->priv->current = _tmp62_ + 1;
								_tmp63_ = token_length_in_chars;
								token_length_in_chars = _tmp63_ + 1;
								{
									gboolean _tmp64_;
									digit_length = 0;
									_tmp64_ = TRUE;
									while (TRUE) {
										gboolean _tmp66_ = FALSE;
										gboolean _tmp67_ = FALSE;
										gint _tmp68_;
										gchar* _tmp74_;
										gint _tmp75_;
										if (!_tmp64_) {
											gint _tmp65_;
											_tmp65_ = digit_length;
											digit_length = _tmp65_ + 1;
										}
										_tmp64_ = FALSE;
										_tmp68_ = digit_length;
										if (_tmp68_ < 4) {
											gchar* _tmp69_;
											gchar* _tmp70_;
											_tmp69_ = self->priv->current;
											_tmp70_ = self->priv->end;
											_tmp67_ = _tmp69_ < _tmp70_;
										} else {
											_tmp67_ = FALSE;
										}
										if (_tmp67_) {
											gchar* _tmp71_;
											gchar _tmp72_;
											gboolean _tmp73_;
											_tmp71_ = self->priv->current;
											_tmp72_ = _tmp71_[0];
											_tmp73_ = g_ascii_isxdigit (_tmp72_);
											_tmp66_ = _tmp73_;
										} else {
											_tmp66_ = FALSE;
										}
										if (!_tmp66_) {
											break;
										}
										_tmp74_ = self->priv->current;
										self->priv->current = _tmp74_ + 1;
										_tmp75_ = token_length_in_chars;
										token_length_in_chars = _tmp75_ + 1;
									}
								}
								_tmp76_ = digit_length;
								if (_tmp76_ != 4) {
									gint _tmp77_;
									ValaSourceReference* _tmp78_;
									ValaSourceReference* _tmp79_;
									_tmp77_ = token_length_in_chars;
									_tmp78_ = vala_scanner_get_source_reference (self, _tmp77_, 0);
									_tmp79_ = _tmp78_;
									vala_report_error (_tmp79_, "\\u requires four hex digits");
									_vala_source_reference_unref0 (_tmp79_);
								}
								break;
							}
							case 'x':
							{
								gchar* _tmp80_;
								gint _tmp81_;
								gint digit_length = 0;
								gint _tmp92_;
								_tmp80_ = self->priv->current;
								self->priv->current = _tmp80_ + 1;
								_tmp81_ = token_length_in_chars;
								token_length_in_chars = _tmp81_ + 1;
								{
									gboolean _tmp82_;
									digit_length = 0;
									_tmp82_ = TRUE;
									while (TRUE) {
										gboolean _tmp84_ = FALSE;
										gchar* _tmp85_;
										gchar* _tmp86_;
										gchar* _tmp90_;
										gint _tmp91_;
										if (!_tmp82_) {
											gint _tmp83_;
											_tmp83_ = digit_length;
											digit_length = _tmp83_ + 1;
										}
										_tmp82_ = FALSE;
										_tmp85_ = self->priv->current;
										_tmp86_ = self->priv->end;
										if (_tmp85_ < _tmp86_) {
											gchar* _tmp87_;
											gchar _tmp88_;
											gboolean _tmp89_;
											_tmp87_ = self->priv->current;
											_tmp88_ = _tmp87_[0];
											_tmp89_ = g_ascii_isxdigit (_tmp88_);
											_tmp84_ = _tmp89_;
										} else {
											_tmp84_ = FALSE;
										}
										if (!_tmp84_) {
											break;
										}
										_tmp90_ = self->priv->current;
										self->priv->current = _tmp90_ + 1;
										_tmp91_ = token_length_in_chars;
										token_length_in_chars = _tmp91_ + 1;
									}
								}
								_tmp92_ = digit_length;
								if (_tmp92_ < 1) {
									gint _tmp93_;
									ValaSourceReference* _tmp94_;
									ValaSourceReference* _tmp95_;
									_tmp93_ = token_length_in_chars;
									_tmp94_ = vala_scanner_get_source_reference (self, _tmp93_, 0);
									_tmp95_ = _tmp94_;
									vala_report_error (_tmp95_, "\\x requires at least one hex digit");
									_vala_source_reference_unref0 (_tmp95_);
								}
								break;
							}
							default:
							{
								gint _tmp96_;
								ValaSourceReference* _tmp97_;
								ValaSourceReference* _tmp98_;
								_tmp96_ = token_length_in_chars;
								_tmp97_ = vala_scanner_get_source_reference (self, _tmp96_, 0);
								_tmp98_ = _tmp97_;
								vala_report_error (_tmp98_, "invalid escape sequence");
								_vala_source_reference_unref0 (_tmp98_);
								break;
							}
						}
					} else {
						gchar* _tmp99_;
						gchar _tmp100_;
						_tmp99_ = self->priv->current;
						_tmp100_ = _tmp99_[0];
						if (_tmp100_ == '\n') {
							gchar* _tmp101_;
							gint _tmp102_;
							_tmp101_ = self->priv->current;
							self->priv->current = _tmp101_ + 1;
							_tmp102_ = self->priv->line;
							self->priv->line = _tmp102_ + 1;
							self->priv->column = 1;
							token_length_in_chars = 1;
						} else {
							gunichar u;
							gchar* _tmp103_;
							gchar* _tmp104_;
							gchar* _tmp105_;
							gunichar _tmp106_;
							gunichar _tmp107_;
							_tmp103_ = self->priv->current;
							_tmp104_ = self->priv->end;
							_tmp105_ = self->priv->current;
							_tmp106_ = g_utf8_get_char_validated ((const gchar*) _tmp103_, (gssize) ((glong) (_tmp104_ - _tmp105_)));
							u = _tmp106_;
							_tmp107_ = u;
							if (_tmp107_ != ((gunichar) -1)) {
								gchar* _tmp108_;
								gunichar _tmp109_;
								gint _tmp110_;
								gint _tmp111_;
								_tmp108_ = self->priv->current;
								_tmp109_ = u;
								_tmp110_ = g_unichar_to_utf8 (_tmp109_, NULL);
								self->priv->current = _tmp108_ + _tmp110_;
								_tmp111_ = token_length_in_chars;
								token_length_in_chars = _tmp111_ + 1;
							} else {
								gchar* _tmp112_;
								gint _tmp113_;
								ValaSourceReference* _tmp114_;
								ValaSourceReference* _tmp115_;
								_tmp112_ = self->priv->current;
								self->priv->current = _tmp112_ + 1;
								_tmp113_ = token_length_in_chars;
								_tmp114_ = vala_scanner_get_source_reference (self, _tmp113_, 0);
								_tmp115_ = _tmp114_;
								vala_report_error (_tmp115_, "invalid UTF-8 character");
								_vala_source_reference_unref0 (_tmp115_);
							}
						}
					}
				}
				_tmp116_ = self->priv->current;
				_tmp117_ = self->priv->end;
				if (_tmp116_ >= _tmp117_) {
					gint _tmp118_;
					ValaSourceReference* _tmp119_;
					ValaSourceReference* _tmp120_;
					gint _tmp121_;
					ValaSourceLocation _tmp122_ = {0};
					ValaSourceLocation _tmp123_ = {0};
					ValaTokenType _tmp124_;
					_tmp118_ = token_length_in_chars;
					_tmp119_ = vala_scanner_get_source_reference (self, _tmp118_, 0);
					_tmp120_ = _tmp119_;
					vala_report_error (_tmp120_, "syntax error, expected \"");
					_vala_source_reference_unref0 (_tmp120_);
					_tmp121_ = self->priv->state_stack_length1;
					self->priv->state_stack_length1 = _tmp121_ - 1;
					_tmp124_ = vala_scanner_read_token (self, &_tmp122_, &_tmp123_);
					_vala_token_begin = _tmp122_;
					_vala_token_end = _tmp123_;
					result = _tmp124_;
					if (token_begin) {
						*token_begin = _vala_token_begin;
					}
					if (token_end) {
						*token_end = _vala_token_end;
					}
					return result;
				}
				_tmp125_ = self->priv->state_stack;
				_tmp125__length1 = self->priv->state_stack_length1;
				_vala_array_add16 (&self->priv->state_stack, &self->priv->state_stack_length1, &self->priv->_state_stack_size_, VALA_SCANNER_STATE_TEMPLATE_PART);
				break;
			}
		}
	}
	_tmp126_ = token_length_in_chars;
	if (_tmp126_ < 0) {
		gint _tmp127_;
		gchar* _tmp128_;
		gchar* _tmp129_;
		_tmp127_ = self->priv->column;
		_tmp128_ = self->priv->current;
		_tmp129_ = begin;
		self->priv->column = _tmp127_ + ((gint) (_tmp128_ - _tmp129_));
	} else {
		gint _tmp130_;
		gint _tmp131_;
		_tmp130_ = self->priv->column;
		_tmp131_ = token_length_in_chars;
		self->priv->column = _tmp130_ + _tmp131_;
	}
	_tmp132_ = self->priv->current;
	_tmp133_ = self->priv->line;
	_tmp134_ = self->priv->column;
	vala_source_location_init (&_vala_token_end, _tmp132_, _tmp133_, _tmp134_ - 1);
	result = type;
	if (token_begin) {
		*token_begin = _vala_token_begin;
	}
	if (token_end) {
		*token_end = _vala_token_end;
	}
	return result;
}


static void _vala_array_add17 (ValaScannerState* * array, int* length, int* size, ValaScannerState value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaScannerState, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void _vala_array_add18 (ValaScannerState* * array, int* length, int* size, ValaScannerState value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaScannerState, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void _vala_array_add19 (ValaScannerState* * array, int* length, int* size, ValaScannerState value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaScannerState, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void _vala_array_add20 (ValaScannerState* * array, int* length, int* size, ValaScannerState value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaScannerState, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void _vala_array_add21 (ValaScannerState* * array, int* length, int* size, ValaScannerState value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaScannerState, *array, *size);
	}
	(*array)[(*length)++] = value;
}


ValaTokenType vala_scanner_read_token (ValaScanner* self, ValaSourceLocation* token_begin, ValaSourceLocation* token_end) {
	ValaSourceLocation _vala_token_begin = {0};
	ValaSourceLocation _vala_token_end = {0};
	ValaTokenType result = 0;
	gboolean _tmp0_;
	ValaTokenType type = 0;
	gchar* begin;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
	gint token_length_in_chars;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gint _tmp363_;
	gchar* _tmp369_;
	gint _tmp370_;
	gint _tmp371_;
	ValaTokenType _tmp372_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = vala_scanner_in_template (self);
	if (_tmp0_) {
		ValaSourceLocation _tmp1_ = {0};
		ValaSourceLocation _tmp2_ = {0};
		ValaTokenType _tmp3_;
		_tmp3_ = vala_scanner_read_template_token (self, &_tmp1_, &_tmp2_);
		_vala_token_begin = _tmp1_;
		_vala_token_end = _tmp2_;
		result = _tmp3_;
		if (token_begin) {
			*token_begin = _vala_token_begin;
		}
		if (token_end) {
			*token_end = _vala_token_end;
		}
		return result;
	} else {
		gboolean _tmp4_;
		_tmp4_ = vala_scanner_in_template_part (self);
		if (_tmp4_) {
			gint _tmp5_;
			gchar* _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			gchar* _tmp9_;
			gint _tmp10_;
			gint _tmp11_;
			_tmp5_ = self->priv->state_stack_length1;
			self->priv->state_stack_length1 = _tmp5_ - 1;
			_tmp6_ = self->priv->current;
			_tmp7_ = self->priv->line;
			_tmp8_ = self->priv->column;
			vala_source_location_init (&_vala_token_begin, _tmp6_, _tmp7_, _tmp8_);
			_tmp9_ = self->priv->current;
			_tmp10_ = self->priv->line;
			_tmp11_ = self->priv->column;
			vala_source_location_init (&_vala_token_end, _tmp9_, _tmp10_, _tmp11_ - 1);
			result = VALA_TOKEN_TYPE_COMMA;
			if (token_begin) {
				*token_begin = _vala_token_begin;
			}
			if (token_end) {
				*token_end = _vala_token_end;
			}
			return result;
		} else {
			gboolean _tmp12_;
			_tmp12_ = vala_scanner_in_regex_literal (self);
			if (_tmp12_) {
				ValaSourceLocation _tmp13_ = {0};
				ValaSourceLocation _tmp14_ = {0};
				ValaTokenType _tmp15_;
				_tmp15_ = vala_scanner_read_regex_token (self, &_tmp13_, &_tmp14_);
				_vala_token_begin = _tmp13_;
				_vala_token_end = _tmp14_;
				result = _tmp15_;
				if (token_begin) {
					*token_begin = _vala_token_begin;
				}
				if (token_end) {
					*token_end = _vala_token_end;
				}
				return result;
			}
		}
	}
	vala_scanner_space (self);
	_tmp16_ = self->priv->current;
	begin = _tmp16_;
	_tmp17_ = begin;
	_tmp18_ = self->priv->line;
	_tmp19_ = self->priv->column;
	vala_source_location_init (&_vala_token_begin, _tmp17_, _tmp18_, _tmp19_);
	token_length_in_chars = -1;
	_tmp20_ = self->priv->current;
	_tmp21_ = self->priv->end;
	if (_tmp20_ >= _tmp21_) {
		type = VALA_TOKEN_TYPE_EOF;
	} else {
		gboolean _tmp22_ = FALSE;
		gchar* _tmp23_;
		gchar _tmp24_;
		gboolean _tmp25_;
		_tmp23_ = self->priv->current;
		_tmp24_ = _tmp23_[0];
		_tmp25_ = g_ascii_isalpha (_tmp24_);
		if (_tmp25_) {
			_tmp22_ = TRUE;
		} else {
			gchar* _tmp26_;
			gchar _tmp27_;
			_tmp26_ = self->priv->current;
			_tmp27_ = _tmp26_[0];
			_tmp22_ = _tmp27_ == '_';
		}
		if (_tmp22_) {
			gint len;
			gchar* _tmp36_;
			gint _tmp37_;
			ValaTokenType _tmp38_;
			len = 0;
			while (TRUE) {
				gboolean _tmp28_ = FALSE;
				gchar* _tmp29_;
				gchar* _tmp30_;
				gchar* _tmp34_;
				gint _tmp35_;
				_tmp29_ = self->priv->current;
				_tmp30_ = self->priv->end;
				if (_tmp29_ < _tmp30_) {
					gchar* _tmp31_;
					gchar _tmp32_;
					gboolean _tmp33_;
					_tmp31_ = self->priv->current;
					_tmp32_ = _tmp31_[0];
					_tmp33_ = vala_scanner_is_ident_char (self, _tmp32_);
					_tmp28_ = _tmp33_;
				} else {
					_tmp28_ = FALSE;
				}
				if (!_tmp28_) {
					break;
				}
				_tmp34_ = self->priv->current;
				self->priv->current = _tmp34_ + 1;
				_tmp35_ = len;
				len = _tmp35_ + 1;
			}
			_tmp36_ = begin;
			_tmp37_ = len;
			_tmp38_ = vala_scanner_get_identifier_or_keyword (_tmp36_, _tmp37_);
			type = _tmp38_;
		} else {
			gchar* _tmp39_;
			gchar _tmp40_;
			_tmp39_ = self->priv->current;
			_tmp40_ = _tmp39_[0];
			if (_tmp40_ == '@') {
				gboolean _tmp41_ = FALSE;
				gchar* _tmp42_;
				gchar* _tmp43_;
				_tmp42_ = self->priv->current;
				_tmp43_ = self->priv->end;
				if (_tmp42_ < (_tmp43_ - 1)) {
					gchar* _tmp44_;
					gchar _tmp45_;
					_tmp44_ = self->priv->current;
					_tmp45_ = _tmp44_[1];
					_tmp41_ = _tmp45_ == '"';
				} else {
					_tmp41_ = FALSE;
				}
				if (_tmp41_) {
					gchar* _tmp46_;
					ValaScannerState* _tmp47_;
					gint _tmp47__length1;
					type = VALA_TOKEN_TYPE_OPEN_TEMPLATE;
					_tmp46_ = self->priv->current;
					self->priv->current = _tmp46_ + 2;
					_tmp47_ = self->priv->state_stack;
					_tmp47__length1 = self->priv->state_stack_length1;
					_vala_array_add17 (&self->priv->state_stack, &self->priv->state_stack_length1, &self->priv->_state_stack_size_, VALA_SCANNER_STATE_TEMPLATE);
				} else {
					gchar* _tmp48_;
					gchar* _tmp49_;
					gint len;
					_tmp48_ = _vala_token_begin.pos;
					_vala_token_begin.pos = _tmp48_ + 1;
					_tmp49_ = self->priv->current;
					self->priv->current = _tmp49_ + 1;
					len = 0;
					while (TRUE) {
						gboolean _tmp50_ = FALSE;
						gchar* _tmp51_;
						gchar* _tmp52_;
						gchar* _tmp56_;
						gint _tmp57_;
						_tmp51_ = self->priv->current;
						_tmp52_ = self->priv->end;
						if (_tmp51_ < _tmp52_) {
							gchar* _tmp53_;
							gchar _tmp54_;
							gboolean _tmp55_;
							_tmp53_ = self->priv->current;
							_tmp54_ = _tmp53_[0];
							_tmp55_ = vala_scanner_is_ident_char (self, _tmp54_);
							_tmp50_ = _tmp55_;
						} else {
							_tmp50_ = FALSE;
						}
						if (!_tmp50_) {
							break;
						}
						_tmp56_ = self->priv->current;
						self->priv->current = _tmp56_ + 1;
						_tmp57_ = len;
						len = _tmp57_ + 1;
					}
					type = VALA_TOKEN_TYPE_IDENTIFIER;
				}
			} else {
				gchar* _tmp58_;
				gchar _tmp59_;
				gboolean _tmp60_;
				_tmp58_ = self->priv->current;
				_tmp59_ = _tmp58_[0];
				_tmp60_ = g_ascii_isdigit (_tmp59_);
				if (_tmp60_) {
					ValaTokenType _tmp61_;
					_tmp61_ = vala_scanner_read_number (self);
					type = _tmp61_;
				} else {
					gchar* _tmp62_;
					gchar _tmp63_;
					_tmp62_ = self->priv->current;
					_tmp63_ = _tmp62_[0];
					switch (_tmp63_) {
						case '{':
						{
							gchar* _tmp64_;
							ValaScannerState* _tmp65_;
							gint _tmp65__length1;
							type = VALA_TOKEN_TYPE_OPEN_BRACE;
							_tmp64_ = self->priv->current;
							self->priv->current = _tmp64_ + 1;
							_tmp65_ = self->priv->state_stack;
							_tmp65__length1 = self->priv->state_stack_length1;
							_vala_array_add18 (&self->priv->state_stack, &self->priv->state_stack_length1, &self->priv->_state_stack_size_, VALA_SCANNER_STATE_BRACE);
							break;
						}
						case '}':
						{
							gchar* _tmp66_;
							ValaScannerState* _tmp67_;
							gint _tmp67__length1;
							type = VALA_TOKEN_TYPE_CLOSE_BRACE;
							_tmp66_ = self->priv->current;
							self->priv->current = _tmp66_ + 1;
							_tmp67_ = self->priv->state_stack;
							_tmp67__length1 = self->priv->state_stack_length1;
							if (_tmp67__length1 > 0) {
								gint _tmp68_;
								_tmp68_ = self->priv->state_stack_length1;
								self->priv->state_stack_length1 = _tmp68_ - 1;
							}
							break;
						}
						case '(':
						{
							gchar* _tmp69_;
							ValaScannerState* _tmp70_;
							gint _tmp70__length1;
							type = VALA_TOKEN_TYPE_OPEN_PARENS;
							_tmp69_ = self->priv->current;
							self->priv->current = _tmp69_ + 1;
							_tmp70_ = self->priv->state_stack;
							_tmp70__length1 = self->priv->state_stack_length1;
							_vala_array_add19 (&self->priv->state_stack, &self->priv->state_stack_length1, &self->priv->_state_stack_size_, VALA_SCANNER_STATE_PARENS);
							break;
						}
						case ')':
						{
							gchar* _tmp71_;
							ValaScannerState* _tmp72_;
							gint _tmp72__length1;
							gboolean _tmp74_;
							type = VALA_TOKEN_TYPE_CLOSE_PARENS;
							_tmp71_ = self->priv->current;
							self->priv->current = _tmp71_ + 1;
							_tmp72_ = self->priv->state_stack;
							_tmp72__length1 = self->priv->state_stack_length1;
							if (_tmp72__length1 > 0) {
								gint _tmp73_;
								_tmp73_ = self->priv->state_stack_length1;
								self->priv->state_stack_length1 = _tmp73_ - 1;
							}
							_tmp74_ = vala_scanner_in_template (self);
							if (_tmp74_) {
								type = VALA_TOKEN_TYPE_COMMA;
							}
							break;
						}
						case '[':
						{
							gchar* _tmp75_;
							ValaScannerState* _tmp76_;
							gint _tmp76__length1;
							type = VALA_TOKEN_TYPE_OPEN_BRACKET;
							_tmp75_ = self->priv->current;
							self->priv->current = _tmp75_ + 1;
							_tmp76_ = self->priv->state_stack;
							_tmp76__length1 = self->priv->state_stack_length1;
							_vala_array_add20 (&self->priv->state_stack, &self->priv->state_stack_length1, &self->priv->_state_stack_size_, VALA_SCANNER_STATE_BRACKET);
							break;
						}
						case ']':
						{
							gchar* _tmp77_;
							ValaScannerState* _tmp78_;
							gint _tmp78__length1;
							type = VALA_TOKEN_TYPE_CLOSE_BRACKET;
							_tmp77_ = self->priv->current;
							self->priv->current = _tmp77_ + 1;
							_tmp78_ = self->priv->state_stack;
							_tmp78__length1 = self->priv->state_stack_length1;
							if (_tmp78__length1 > 0) {
								gint _tmp79_;
								_tmp79_ = self->priv->state_stack_length1;
								self->priv->state_stack_length1 = _tmp79_ - 1;
							}
							break;
						}
						case '.':
						{
							gchar* _tmp80_;
							gchar* _tmp81_;
							gchar* _tmp82_;
							type = VALA_TOKEN_TYPE_DOT;
							_tmp80_ = self->priv->current;
							self->priv->current = _tmp80_ + 1;
							_tmp81_ = self->priv->current;
							_tmp82_ = self->priv->end;
							if (_tmp81_ < (_tmp82_ - 1)) {
								gboolean _tmp83_ = FALSE;
								gchar* _tmp84_;
								gchar _tmp85_;
								_tmp84_ = self->priv->current;
								_tmp85_ = _tmp84_[0];
								if (_tmp85_ == '.') {
									gchar* _tmp86_;
									gchar _tmp87_;
									_tmp86_ = self->priv->current;
									_tmp87_ = _tmp86_[1];
									_tmp83_ = _tmp87_ == '.';
								} else {
									_tmp83_ = FALSE;
								}
								if (_tmp83_) {
									gchar* _tmp88_;
									type = VALA_TOKEN_TYPE_ELLIPSIS;
									_tmp88_ = self->priv->current;
									self->priv->current = _tmp88_ + 2;
								}
							}
							break;
						}
						case ':':
						{
							gchar* _tmp89_;
							gboolean _tmp90_ = FALSE;
							gchar* _tmp91_;
							gchar* _tmp92_;
							type = VALA_TOKEN_TYPE_COLON;
							_tmp89_ = self->priv->current;
							self->priv->current = _tmp89_ + 1;
							_tmp91_ = self->priv->current;
							_tmp92_ = self->priv->end;
							if (_tmp91_ < _tmp92_) {
								gchar* _tmp93_;
								gchar _tmp94_;
								_tmp93_ = self->priv->current;
								_tmp94_ = _tmp93_[0];
								_tmp90_ = _tmp94_ == ':';
							} else {
								_tmp90_ = FALSE;
							}
							if (_tmp90_) {
								gchar* _tmp95_;
								type = VALA_TOKEN_TYPE_DOUBLE_COLON;
								_tmp95_ = self->priv->current;
								self->priv->current = _tmp95_ + 1;
							}
							break;
						}
						case ',':
						{
							gchar* _tmp96_;
							type = VALA_TOKEN_TYPE_COMMA;
							_tmp96_ = self->priv->current;
							self->priv->current = _tmp96_ + 1;
							break;
						}
						case ';':
						{
							gchar* _tmp97_;
							type = VALA_TOKEN_TYPE_SEMICOLON;
							_tmp97_ = self->priv->current;
							self->priv->current = _tmp97_ + 1;
							break;
						}
						case '#':
						{
							gchar* _tmp98_;
							type = VALA_TOKEN_TYPE_HASH;
							_tmp98_ = self->priv->current;
							self->priv->current = _tmp98_ + 1;
							break;
						}
						case '?':
						{
							gchar* _tmp99_;
							gboolean _tmp100_ = FALSE;
							gchar* _tmp101_;
							gchar* _tmp102_;
							type = VALA_TOKEN_TYPE_INTERR;
							_tmp99_ = self->priv->current;
							self->priv->current = _tmp99_ + 1;
							_tmp101_ = self->priv->current;
							_tmp102_ = self->priv->end;
							if (_tmp101_ < _tmp102_) {
								gchar* _tmp103_;
								gchar _tmp104_;
								_tmp103_ = self->priv->current;
								_tmp104_ = _tmp103_[0];
								_tmp100_ = _tmp104_ == '?';
							} else {
								_tmp100_ = FALSE;
							}
							if (_tmp100_) {
								gchar* _tmp105_;
								type = VALA_TOKEN_TYPE_OP_COALESCING;
								_tmp105_ = self->priv->current;
								self->priv->current = _tmp105_ + 1;
							}
							break;
						}
						case '|':
						{
							gchar* _tmp106_;
							gchar* _tmp107_;
							gchar* _tmp108_;
							type = VALA_TOKEN_TYPE_BITWISE_OR;
							_tmp106_ = self->priv->current;
							self->priv->current = _tmp106_ + 1;
							_tmp107_ = self->priv->current;
							_tmp108_ = self->priv->end;
							if (_tmp107_ < _tmp108_) {
								gchar* _tmp109_;
								gchar _tmp110_;
								_tmp109_ = self->priv->current;
								_tmp110_ = _tmp109_[0];
								switch (_tmp110_) {
									case '=':
									{
										gchar* _tmp111_;
										type = VALA_TOKEN_TYPE_ASSIGN_BITWISE_OR;
										_tmp111_ = self->priv->current;
										self->priv->current = _tmp111_ + 1;
										break;
									}
									case '|':
									{
										gchar* _tmp112_;
										type = VALA_TOKEN_TYPE_OP_OR;
										_tmp112_ = self->priv->current;
										self->priv->current = _tmp112_ + 1;
										break;
									}
									default:
									break;
								}
							}
							break;
						}
						case '&':
						{
							gchar* _tmp113_;
							gchar* _tmp114_;
							gchar* _tmp115_;
							type = VALA_TOKEN_TYPE_BITWISE_AND;
							_tmp113_ = self->priv->current;
							self->priv->current = _tmp113_ + 1;
							_tmp114_ = self->priv->current;
							_tmp115_ = self->priv->end;
							if (_tmp114_ < _tmp115_) {
								gchar* _tmp116_;
								gchar _tmp117_;
								_tmp116_ = self->priv->current;
								_tmp117_ = _tmp116_[0];
								switch (_tmp117_) {
									case '=':
									{
										gchar* _tmp118_;
										type = VALA_TOKEN_TYPE_ASSIGN_BITWISE_AND;
										_tmp118_ = self->priv->current;
										self->priv->current = _tmp118_ + 1;
										break;
									}
									case '&':
									{
										gchar* _tmp119_;
										type = VALA_TOKEN_TYPE_OP_AND;
										_tmp119_ = self->priv->current;
										self->priv->current = _tmp119_ + 1;
										break;
									}
									default:
									break;
								}
							}
							break;
						}
						case '^':
						{
							gchar* _tmp120_;
							gboolean _tmp121_ = FALSE;
							gchar* _tmp122_;
							gchar* _tmp123_;
							type = VALA_TOKEN_TYPE_CARRET;
							_tmp120_ = self->priv->current;
							self->priv->current = _tmp120_ + 1;
							_tmp122_ = self->priv->current;
							_tmp123_ = self->priv->end;
							if (_tmp122_ < _tmp123_) {
								gchar* _tmp124_;
								gchar _tmp125_;
								_tmp124_ = self->priv->current;
								_tmp125_ = _tmp124_[0];
								_tmp121_ = _tmp125_ == '=';
							} else {
								_tmp121_ = FALSE;
							}
							if (_tmp121_) {
								gchar* _tmp126_;
								type = VALA_TOKEN_TYPE_ASSIGN_BITWISE_XOR;
								_tmp126_ = self->priv->current;
								self->priv->current = _tmp126_ + 1;
							}
							break;
						}
						case '~':
						{
							gchar* _tmp127_;
							type = VALA_TOKEN_TYPE_TILDE;
							_tmp127_ = self->priv->current;
							self->priv->current = _tmp127_ + 1;
							break;
						}
						case '=':
						{
							gchar* _tmp128_;
							gchar* _tmp129_;
							gchar* _tmp130_;
							type = VALA_TOKEN_TYPE_ASSIGN;
							_tmp128_ = self->priv->current;
							self->priv->current = _tmp128_ + 1;
							_tmp129_ = self->priv->current;
							_tmp130_ = self->priv->end;
							if (_tmp129_ < _tmp130_) {
								gchar* _tmp131_;
								gchar _tmp132_;
								_tmp131_ = self->priv->current;
								_tmp132_ = _tmp131_[0];
								switch (_tmp132_) {
									case '=':
									{
										gchar* _tmp133_;
										type = VALA_TOKEN_TYPE_OP_EQ;
										_tmp133_ = self->priv->current;
										self->priv->current = _tmp133_ + 1;
										break;
									}
									case '>':
									{
										gchar* _tmp134_;
										type = VALA_TOKEN_TYPE_LAMBDA;
										_tmp134_ = self->priv->current;
										self->priv->current = _tmp134_ + 1;
										break;
									}
									default:
									break;
								}
							}
							break;
						}
						case '<':
						{
							gchar* _tmp135_;
							gchar* _tmp136_;
							gchar* _tmp137_;
							type = VALA_TOKEN_TYPE_OP_LT;
							_tmp135_ = self->priv->current;
							self->priv->current = _tmp135_ + 1;
							_tmp136_ = self->priv->current;
							_tmp137_ = self->priv->end;
							if (_tmp136_ < _tmp137_) {
								gchar* _tmp138_;
								gchar _tmp139_;
								_tmp138_ = self->priv->current;
								_tmp139_ = _tmp138_[0];
								switch (_tmp139_) {
									case '=':
									{
										gchar* _tmp140_;
										type = VALA_TOKEN_TYPE_OP_LE;
										_tmp140_ = self->priv->current;
										self->priv->current = _tmp140_ + 1;
										break;
									}
									case '<':
									{
										gchar* _tmp141_;
										gboolean _tmp142_ = FALSE;
										gchar* _tmp143_;
										gchar* _tmp144_;
										type = VALA_TOKEN_TYPE_OP_SHIFT_LEFT;
										_tmp141_ = self->priv->current;
										self->priv->current = _tmp141_ + 1;
										_tmp143_ = self->priv->current;
										_tmp144_ = self->priv->end;
										if (_tmp143_ < _tmp144_) {
											gchar* _tmp145_;
											gchar _tmp146_;
											_tmp145_ = self->priv->current;
											_tmp146_ = _tmp145_[0];
											_tmp142_ = _tmp146_ == '=';
										} else {
											_tmp142_ = FALSE;
										}
										if (_tmp142_) {
											gchar* _tmp147_;
											type = VALA_TOKEN_TYPE_ASSIGN_SHIFT_LEFT;
											_tmp147_ = self->priv->current;
											self->priv->current = _tmp147_ + 1;
										}
										break;
									}
									default:
									break;
								}
							}
							break;
						}
						case '>':
						{
							gchar* _tmp148_;
							gboolean _tmp149_ = FALSE;
							gchar* _tmp150_;
							gchar* _tmp151_;
							type = VALA_TOKEN_TYPE_OP_GT;
							_tmp148_ = self->priv->current;
							self->priv->current = _tmp148_ + 1;
							_tmp150_ = self->priv->current;
							_tmp151_ = self->priv->end;
							if (_tmp150_ < _tmp151_) {
								gchar* _tmp152_;
								gchar _tmp153_;
								_tmp152_ = self->priv->current;
								_tmp153_ = _tmp152_[0];
								_tmp149_ = _tmp153_ == '=';
							} else {
								_tmp149_ = FALSE;
							}
							if (_tmp149_) {
								gchar* _tmp154_;
								type = VALA_TOKEN_TYPE_OP_GE;
								_tmp154_ = self->priv->current;
								self->priv->current = _tmp154_ + 1;
							}
							break;
						}
						case '!':
						{
							gchar* _tmp155_;
							gboolean _tmp156_ = FALSE;
							gchar* _tmp157_;
							gchar* _tmp158_;
							type = VALA_TOKEN_TYPE_OP_NEG;
							_tmp155_ = self->priv->current;
							self->priv->current = _tmp155_ + 1;
							_tmp157_ = self->priv->current;
							_tmp158_ = self->priv->end;
							if (_tmp157_ < _tmp158_) {
								gchar* _tmp159_;
								gchar _tmp160_;
								_tmp159_ = self->priv->current;
								_tmp160_ = _tmp159_[0];
								_tmp156_ = _tmp160_ == '=';
							} else {
								_tmp156_ = FALSE;
							}
							if (_tmp156_) {
								gchar* _tmp161_;
								type = VALA_TOKEN_TYPE_OP_NE;
								_tmp161_ = self->priv->current;
								self->priv->current = _tmp161_ + 1;
							}
							break;
						}
						case '+':
						{
							gchar* _tmp162_;
							gchar* _tmp163_;
							gchar* _tmp164_;
							type = VALA_TOKEN_TYPE_PLUS;
							_tmp162_ = self->priv->current;
							self->priv->current = _tmp162_ + 1;
							_tmp163_ = self->priv->current;
							_tmp164_ = self->priv->end;
							if (_tmp163_ < _tmp164_) {
								gchar* _tmp165_;
								gchar _tmp166_;
								_tmp165_ = self->priv->current;
								_tmp166_ = _tmp165_[0];
								switch (_tmp166_) {
									case '=':
									{
										gchar* _tmp167_;
										type = VALA_TOKEN_TYPE_ASSIGN_ADD;
										_tmp167_ = self->priv->current;
										self->priv->current = _tmp167_ + 1;
										break;
									}
									case '+':
									{
										gchar* _tmp168_;
										type = VALA_TOKEN_TYPE_OP_INC;
										_tmp168_ = self->priv->current;
										self->priv->current = _tmp168_ + 1;
										break;
									}
									default:
									break;
								}
							}
							break;
						}
						case '-':
						{
							gchar* _tmp169_;
							gchar* _tmp170_;
							gchar* _tmp171_;
							type = VALA_TOKEN_TYPE_MINUS;
							_tmp169_ = self->priv->current;
							self->priv->current = _tmp169_ + 1;
							_tmp170_ = self->priv->current;
							_tmp171_ = self->priv->end;
							if (_tmp170_ < _tmp171_) {
								gchar* _tmp172_;
								gchar _tmp173_;
								_tmp172_ = self->priv->current;
								_tmp173_ = _tmp172_[0];
								switch (_tmp173_) {
									case '=':
									{
										gchar* _tmp174_;
										type = VALA_TOKEN_TYPE_ASSIGN_SUB;
										_tmp174_ = self->priv->current;
										self->priv->current = _tmp174_ + 1;
										break;
									}
									case '-':
									{
										gchar* _tmp175_;
										type = VALA_TOKEN_TYPE_OP_DEC;
										_tmp175_ = self->priv->current;
										self->priv->current = _tmp175_ + 1;
										break;
									}
									case '>':
									{
										gchar* _tmp176_;
										type = VALA_TOKEN_TYPE_OP_PTR;
										_tmp176_ = self->priv->current;
										self->priv->current = _tmp176_ + 1;
										break;
									}
									default:
									break;
								}
							}
							break;
						}
						case '*':
						{
							gchar* _tmp177_;
							gboolean _tmp178_ = FALSE;
							gchar* _tmp179_;
							gchar* _tmp180_;
							type = VALA_TOKEN_TYPE_STAR;
							_tmp177_ = self->priv->current;
							self->priv->current = _tmp177_ + 1;
							_tmp179_ = self->priv->current;
							_tmp180_ = self->priv->end;
							if (_tmp179_ < _tmp180_) {
								gchar* _tmp181_;
								gchar _tmp182_;
								_tmp181_ = self->priv->current;
								_tmp182_ = _tmp181_[0];
								_tmp178_ = _tmp182_ == '=';
							} else {
								_tmp178_ = FALSE;
							}
							if (_tmp178_) {
								gchar* _tmp183_;
								type = VALA_TOKEN_TYPE_ASSIGN_MUL;
								_tmp183_ = self->priv->current;
								self->priv->current = _tmp183_ + 1;
							}
							break;
						}
						case '/':
						{
							ValaTokenType _tmp184_;
							_tmp184_ = self->priv->previous;
							switch (_tmp184_) {
								case VALA_TOKEN_TYPE_ASSIGN:
								case VALA_TOKEN_TYPE_COMMA:
								case VALA_TOKEN_TYPE_MINUS:
								case VALA_TOKEN_TYPE_OP_AND:
								case VALA_TOKEN_TYPE_OP_COALESCING:
								case VALA_TOKEN_TYPE_OP_EQ:
								case VALA_TOKEN_TYPE_OP_GE:
								case VALA_TOKEN_TYPE_OP_GT:
								case VALA_TOKEN_TYPE_OP_LE:
								case VALA_TOKEN_TYPE_OP_LT:
								case VALA_TOKEN_TYPE_OP_NE:
								case VALA_TOKEN_TYPE_OP_NEG:
								case VALA_TOKEN_TYPE_OP_OR:
								case VALA_TOKEN_TYPE_OPEN_BRACE:
								case VALA_TOKEN_TYPE_OPEN_PARENS:
								case VALA_TOKEN_TYPE_PLUS:
								case VALA_TOKEN_TYPE_RETURN:
								{
									ValaScannerState* _tmp185_;
									gint _tmp185__length1;
									gchar* _tmp186_;
									type = VALA_TOKEN_TYPE_OPEN_REGEX_LITERAL;
									_tmp185_ = self->priv->state_stack;
									_tmp185__length1 = self->priv->state_stack_length1;
									_vala_array_add21 (&self->priv->state_stack, &self->priv->state_stack_length1, &self->priv->_state_stack_size_, VALA_SCANNER_STATE_REGEX_LITERAL);
									_tmp186_ = self->priv->current;
									self->priv->current = _tmp186_ + 1;
									break;
								}
								default:
								{
									gchar* _tmp187_;
									gboolean _tmp188_ = FALSE;
									gchar* _tmp189_;
									gchar* _tmp190_;
									type = VALA_TOKEN_TYPE_DIV;
									_tmp187_ = self->priv->current;
									self->priv->current = _tmp187_ + 1;
									_tmp189_ = self->priv->current;
									_tmp190_ = self->priv->end;
									if (_tmp189_ < _tmp190_) {
										gchar* _tmp191_;
										gchar _tmp192_;
										_tmp191_ = self->priv->current;
										_tmp192_ = _tmp191_[0];
										_tmp188_ = _tmp192_ == '=';
									} else {
										_tmp188_ = FALSE;
									}
									if (_tmp188_) {
										gchar* _tmp193_;
										type = VALA_TOKEN_TYPE_ASSIGN_DIV;
										_tmp193_ = self->priv->current;
										self->priv->current = _tmp193_ + 1;
									}
									break;
								}
							}
							break;
						}
						case '%':
						{
							gchar* _tmp194_;
							gboolean _tmp195_ = FALSE;
							gchar* _tmp196_;
							gchar* _tmp197_;
							type = VALA_TOKEN_TYPE_PERCENT;
							_tmp194_ = self->priv->current;
							self->priv->current = _tmp194_ + 1;
							_tmp196_ = self->priv->current;
							_tmp197_ = self->priv->end;
							if (_tmp196_ < _tmp197_) {
								gchar* _tmp198_;
								gchar _tmp199_;
								_tmp198_ = self->priv->current;
								_tmp199_ = _tmp198_[0];
								_tmp195_ = _tmp199_ == '=';
							} else {
								_tmp195_ = FALSE;
							}
							if (_tmp195_) {
								gchar* _tmp200_;
								type = VALA_TOKEN_TYPE_ASSIGN_PERCENT;
								_tmp200_ = self->priv->current;
								self->priv->current = _tmp200_ + 1;
							}
							break;
						}
						case '\'':
						case '"':
						{
							gchar* _tmp201_;
							gchar _tmp202_;
							gchar* _tmp253_;
							gchar* _tmp336_;
							gchar* _tmp337_;
							_tmp201_ = begin;
							_tmp202_ = _tmp201_[0];
							if (_tmp202_ == '\'') {
								type = VALA_TOKEN_TYPE_CHARACTER_LITERAL;
							} else {
								gboolean _tmp203_ = FALSE;
								gboolean _tmp204_ = FALSE;
								gchar* _tmp205_;
								gchar* _tmp206_;
								_tmp205_ = self->priv->current;
								_tmp206_ = self->priv->end;
								if (_tmp205_ < (_tmp206_ - 6)) {
									gchar* _tmp207_;
									gchar _tmp208_;
									_tmp207_ = begin;
									_tmp208_ = _tmp207_[1];
									_tmp204_ = _tmp208_ == '"';
								} else {
									_tmp204_ = FALSE;
								}
								if (_tmp204_) {
									gchar* _tmp209_;
									gchar _tmp210_;
									_tmp209_ = begin;
									_tmp210_ = _tmp209_[2];
									_tmp203_ = _tmp210_ == '"';
								} else {
									_tmp203_ = FALSE;
								}
								if (_tmp203_) {
									gchar* _tmp211_;
									gboolean _tmp241_ = FALSE;
									gboolean _tmp242_ = FALSE;
									gchar* _tmp243_;
									gchar _tmp244_;
									type = VALA_TOKEN_TYPE_VERBATIM_STRING_LITERAL;
									token_length_in_chars = 6;
									_tmp211_ = self->priv->current;
									self->priv->current = _tmp211_ + 3;
									while (TRUE) {
										gchar* _tmp212_;
										gchar* _tmp213_;
										gboolean _tmp214_ = FALSE;
										gboolean _tmp215_ = FALSE;
										gboolean _tmp216_ = FALSE;
										gchar* _tmp217_;
										gchar _tmp218_;
										_tmp212_ = self->priv->current;
										_tmp213_ = self->priv->end;
										if (!(_tmp212_ < (_tmp213_ - 4))) {
											break;
										}
										_tmp217_ = self->priv->current;
										_tmp218_ = _tmp217_[0];
										if (_tmp218_ == '"') {
											gchar* _tmp219_;
											gchar _tmp220_;
											_tmp219_ = self->priv->current;
											_tmp220_ = _tmp219_[1];
											_tmp216_ = _tmp220_ == '"';
										} else {
											_tmp216_ = FALSE;
										}
										if (_tmp216_) {
											gchar* _tmp221_;
											gchar _tmp222_;
											_tmp221_ = self->priv->current;
											_tmp222_ = _tmp221_[2];
											_tmp215_ = _tmp222_ == '"';
										} else {
											_tmp215_ = FALSE;
										}
										if (_tmp215_) {
											gchar* _tmp223_;
											gchar _tmp224_;
											_tmp223_ = self->priv->current;
											_tmp224_ = _tmp223_[3];
											_tmp214_ = _tmp224_ != '"';
										} else {
											_tmp214_ = FALSE;
										}
										if (_tmp214_) {
											break;
										} else {
											gchar* _tmp225_;
											gchar _tmp226_;
											_tmp225_ = self->priv->current;
											_tmp226_ = _tmp225_[0];
											if (_tmp226_ == '\n') {
												gchar* _tmp227_;
												gint _tmp228_;
												_tmp227_ = self->priv->current;
												self->priv->current = _tmp227_ + 1;
												_tmp228_ = self->priv->line;
												self->priv->line = _tmp228_ + 1;
												self->priv->column = 1;
												token_length_in_chars = 3;
											} else {
												gunichar u;
												gchar* _tmp229_;
												gchar* _tmp230_;
												gchar* _tmp231_;
												gunichar _tmp232_;
												gunichar _tmp233_;
												_tmp229_ = self->priv->current;
												_tmp230_ = self->priv->end;
												_tmp231_ = self->priv->current;
												_tmp232_ = g_utf8_get_char_validated ((const gchar*) _tmp229_, (gssize) ((glong) (_tmp230_ - _tmp231_)));
												u = _tmp232_;
												_tmp233_ = u;
												if (_tmp233_ != ((gunichar) -1)) {
													gchar* _tmp234_;
													gunichar _tmp235_;
													gint _tmp236_;
													gint _tmp237_;
													_tmp234_ = self->priv->current;
													_tmp235_ = u;
													_tmp236_ = g_unichar_to_utf8 (_tmp235_, NULL);
													self->priv->current = _tmp234_ + _tmp236_;
													_tmp237_ = token_length_in_chars;
													token_length_in_chars = _tmp237_ + 1;
												} else {
													gint _tmp238_;
													ValaSourceReference* _tmp239_;
													ValaSourceReference* _tmp240_;
													_tmp238_ = token_length_in_chars;
													_tmp239_ = vala_scanner_get_source_reference (self, _tmp238_, 0);
													_tmp240_ = _tmp239_;
													vala_report_error (_tmp240_, "invalid UTF-8 character");
													_vala_source_reference_unref0 (_tmp240_);
												}
											}
										}
									}
									_tmp243_ = self->priv->current;
									_tmp244_ = _tmp243_[0];
									if (_tmp244_ == '"') {
										gchar* _tmp245_;
										gchar _tmp246_;
										_tmp245_ = self->priv->current;
										_tmp246_ = _tmp245_[1];
										_tmp242_ = _tmp246_ == '"';
									} else {
										_tmp242_ = FALSE;
									}
									if (_tmp242_) {
										gchar* _tmp247_;
										gchar _tmp248_;
										_tmp247_ = self->priv->current;
										_tmp248_ = _tmp247_[2];
										_tmp241_ = _tmp248_ == '"';
									} else {
										_tmp241_ = FALSE;
									}
									if (_tmp241_) {
										gchar* _tmp249_;
										_tmp249_ = self->priv->current;
										self->priv->current = _tmp249_ + 3;
									} else {
										gint _tmp250_;
										ValaSourceReference* _tmp251_;
										ValaSourceReference* _tmp252_;
										_tmp250_ = token_length_in_chars;
										_tmp251_ = vala_scanner_get_source_reference (self, _tmp250_, 0);
										_tmp252_ = _tmp251_;
										vala_report_error (_tmp252_, "syntax error, expected \"\"\"");
										_vala_source_reference_unref0 (_tmp252_);
									}
									break;
								} else {
									type = VALA_TOKEN_TYPE_STRING_LITERAL;
								}
							}
							token_length_in_chars = 2;
							_tmp253_ = self->priv->current;
							self->priv->current = _tmp253_ + 1;
							while (TRUE) {
								gboolean _tmp254_ = FALSE;
								gchar* _tmp255_;
								gchar* _tmp256_;
								gchar* _tmp261_;
								gchar _tmp262_;
								gboolean _tmp325_ = FALSE;
								gboolean _tmp326_ = FALSE;
								gchar* _tmp327_;
								gchar* _tmp328_;
								_tmp255_ = self->priv->current;
								_tmp256_ = self->priv->end;
								if (_tmp255_ < _tmp256_) {
									gchar* _tmp257_;
									gchar _tmp258_;
									gchar* _tmp259_;
									gchar _tmp260_;
									_tmp257_ = self->priv->current;
									_tmp258_ = _tmp257_[0];
									_tmp259_ = begin;
									_tmp260_ = _tmp259_[0];
									_tmp254_ = _tmp258_ != _tmp260_;
								} else {
									_tmp254_ = FALSE;
								}
								if (!_tmp254_) {
									break;
								}
								_tmp261_ = self->priv->current;
								_tmp262_ = _tmp261_[0];
								if (_tmp262_ == '\\') {
									gchar* _tmp263_;
									gint _tmp264_;
									gchar* _tmp265_;
									gchar* _tmp266_;
									gchar* _tmp267_;
									gchar _tmp268_;
									_tmp263_ = self->priv->current;
									self->priv->current = _tmp263_ + 1;
									_tmp264_ = token_length_in_chars;
									token_length_in_chars = _tmp264_ + 1;
									_tmp265_ = self->priv->current;
									_tmp266_ = self->priv->end;
									if (_tmp265_ >= _tmp266_) {
										break;
									}
									_tmp267_ = self->priv->current;
									_tmp268_ = _tmp267_[0];
									switch (_tmp268_) {
										case '\'':
										case '"':
										case '\\':
										case '0':
										case 'b':
										case 'f':
										case 'n':
										case 'r':
										case 't':
										case 'v':
										case '$':
										{
											gchar* _tmp269_;
											gint _tmp270_;
											_tmp269_ = self->priv->current;
											self->priv->current = _tmp269_ + 1;
											_tmp270_ = token_length_in_chars;
											token_length_in_chars = _tmp270_ + 1;
											break;
										}
										case 'u':
										{
											gchar* _tmp271_;
											gint _tmp272_;
											gint digit_length = 0;
											gint _tmp285_;
											_tmp271_ = self->priv->current;
											self->priv->current = _tmp271_ + 1;
											_tmp272_ = token_length_in_chars;
											token_length_in_chars = _tmp272_ + 1;
											{
												gboolean _tmp273_;
												digit_length = 0;
												_tmp273_ = TRUE;
												while (TRUE) {
													gboolean _tmp275_ = FALSE;
													gboolean _tmp276_ = FALSE;
													gint _tmp277_;
													gchar* _tmp283_;
													gint _tmp284_;
													if (!_tmp273_) {
														gint _tmp274_;
														_tmp274_ = digit_length;
														digit_length = _tmp274_ + 1;
													}
													_tmp273_ = FALSE;
													_tmp277_ = digit_length;
													if (_tmp277_ < 4) {
														gchar* _tmp278_;
														gchar* _tmp279_;
														_tmp278_ = self->priv->current;
														_tmp279_ = self->priv->end;
														_tmp276_ = _tmp278_ < _tmp279_;
													} else {
														_tmp276_ = FALSE;
													}
													if (_tmp276_) {
														gchar* _tmp280_;
														gchar _tmp281_;
														gboolean _tmp282_;
														_tmp280_ = self->priv->current;
														_tmp281_ = _tmp280_[0];
														_tmp282_ = g_ascii_isxdigit (_tmp281_);
														_tmp275_ = _tmp282_;
													} else {
														_tmp275_ = FALSE;
													}
													if (!_tmp275_) {
														break;
													}
													_tmp283_ = self->priv->current;
													self->priv->current = _tmp283_ + 1;
													_tmp284_ = token_length_in_chars;
													token_length_in_chars = _tmp284_ + 1;
												}
											}
											_tmp285_ = digit_length;
											if (_tmp285_ != 4) {
												gint _tmp286_;
												ValaSourceReference* _tmp287_;
												ValaSourceReference* _tmp288_;
												_tmp286_ = token_length_in_chars;
												_tmp287_ = vala_scanner_get_source_reference (self, _tmp286_, 0);
												_tmp288_ = _tmp287_;
												vala_report_error (_tmp288_, "\\u requires four hex digits");
												_vala_source_reference_unref0 (_tmp288_);
											}
											break;
										}
										case 'x':
										{
											gchar* _tmp289_;
											gint _tmp290_;
											gint digit_length = 0;
											gint _tmp301_;
											_tmp289_ = self->priv->current;
											self->priv->current = _tmp289_ + 1;
											_tmp290_ = token_length_in_chars;
											token_length_in_chars = _tmp290_ + 1;
											{
												gboolean _tmp291_;
												digit_length = 0;
												_tmp291_ = TRUE;
												while (TRUE) {
													gboolean _tmp293_ = FALSE;
													gchar* _tmp294_;
													gchar* _tmp295_;
													gchar* _tmp299_;
													gint _tmp300_;
													if (!_tmp291_) {
														gint _tmp292_;
														_tmp292_ = digit_length;
														digit_length = _tmp292_ + 1;
													}
													_tmp291_ = FALSE;
													_tmp294_ = self->priv->current;
													_tmp295_ = self->priv->end;
													if (_tmp294_ < _tmp295_) {
														gchar* _tmp296_;
														gchar _tmp297_;
														gboolean _tmp298_;
														_tmp296_ = self->priv->current;
														_tmp297_ = _tmp296_[0];
														_tmp298_ = g_ascii_isxdigit (_tmp297_);
														_tmp293_ = _tmp298_;
													} else {
														_tmp293_ = FALSE;
													}
													if (!_tmp293_) {
														break;
													}
													_tmp299_ = self->priv->current;
													self->priv->current = _tmp299_ + 1;
													_tmp300_ = token_length_in_chars;
													token_length_in_chars = _tmp300_ + 1;
												}
											}
											_tmp301_ = digit_length;
											if (_tmp301_ < 1) {
												gint _tmp302_;
												ValaSourceReference* _tmp303_;
												ValaSourceReference* _tmp304_;
												_tmp302_ = token_length_in_chars;
												_tmp303_ = vala_scanner_get_source_reference (self, _tmp302_, 0);
												_tmp304_ = _tmp303_;
												vala_report_error (_tmp304_, "\\x requires at least one hex digit");
												_vala_source_reference_unref0 (_tmp304_);
											}
											break;
										}
										default:
										{
											gint _tmp305_;
											ValaSourceReference* _tmp306_;
											ValaSourceReference* _tmp307_;
											_tmp305_ = token_length_in_chars;
											_tmp306_ = vala_scanner_get_source_reference (self, _tmp305_, 0);
											_tmp307_ = _tmp306_;
											vala_report_error (_tmp307_, "invalid escape sequence");
											_vala_source_reference_unref0 (_tmp307_);
											break;
										}
									}
								} else {
									gchar* _tmp308_;
									gchar _tmp309_;
									_tmp308_ = self->priv->current;
									_tmp309_ = _tmp308_[0];
									if (_tmp309_ == '\n') {
										gchar* _tmp310_;
										gint _tmp311_;
										_tmp310_ = self->priv->current;
										self->priv->current = _tmp310_ + 1;
										_tmp311_ = self->priv->line;
										self->priv->line = _tmp311_ + 1;
										self->priv->column = 1;
										token_length_in_chars = 1;
									} else {
										gunichar u;
										gchar* _tmp312_;
										gchar* _tmp313_;
										gchar* _tmp314_;
										gunichar _tmp315_;
										gunichar _tmp316_;
										_tmp312_ = self->priv->current;
										_tmp313_ = self->priv->end;
										_tmp314_ = self->priv->current;
										_tmp315_ = g_utf8_get_char_validated ((const gchar*) _tmp312_, (gssize) ((glong) (_tmp313_ - _tmp314_)));
										u = _tmp315_;
										_tmp316_ = u;
										if (_tmp316_ != ((gunichar) -1)) {
											gchar* _tmp317_;
											gunichar _tmp318_;
											gint _tmp319_;
											gint _tmp320_;
											_tmp317_ = self->priv->current;
											_tmp318_ = u;
											_tmp319_ = g_unichar_to_utf8 (_tmp318_, NULL);
											self->priv->current = _tmp317_ + _tmp319_;
											_tmp320_ = token_length_in_chars;
											token_length_in_chars = _tmp320_ + 1;
										} else {
											gchar* _tmp321_;
											gint _tmp322_;
											ValaSourceReference* _tmp323_;
											ValaSourceReference* _tmp324_;
											_tmp321_ = self->priv->current;
											self->priv->current = _tmp321_ + 1;
											_tmp322_ = token_length_in_chars;
											_tmp323_ = vala_scanner_get_source_reference (self, _tmp322_, 0);
											_tmp324_ = _tmp323_;
											vala_report_error (_tmp324_, "invalid UTF-8 character");
											_vala_source_reference_unref0 (_tmp324_);
										}
									}
								}
								_tmp327_ = self->priv->current;
								_tmp328_ = self->priv->end;
								if (_tmp327_ < _tmp328_) {
									gchar* _tmp329_;
									gchar _tmp330_;
									_tmp329_ = begin;
									_tmp330_ = _tmp329_[0];
									_tmp326_ = _tmp330_ == '\'';
								} else {
									_tmp326_ = FALSE;
								}
								if (_tmp326_) {
									gchar* _tmp331_;
									gchar _tmp332_;
									_tmp331_ = self->priv->current;
									_tmp332_ = _tmp331_[0];
									_tmp325_ = _tmp332_ != '\'';
								} else {
									_tmp325_ = FALSE;
								}
								if (_tmp325_) {
									gint _tmp333_;
									ValaSourceReference* _tmp334_;
									ValaSourceReference* _tmp335_;
									_tmp333_ = token_length_in_chars;
									_tmp334_ = vala_scanner_get_source_reference (self, _tmp333_, 0);
									_tmp335_ = _tmp334_;
									vala_report_error (_tmp335_, "invalid character literal");
									_vala_source_reference_unref0 (_tmp335_);
								}
							}
							_tmp336_ = self->priv->current;
							_tmp337_ = self->priv->end;
							if (_tmp336_ < _tmp337_) {
								gchar* _tmp338_;
								_tmp338_ = self->priv->current;
								self->priv->current = _tmp338_ + 1;
							} else {
								gint _tmp339_;
								ValaSourceReference* _tmp340_;
								ValaSourceReference* _tmp341_;
								gchar* _tmp342_;
								gchar _tmp343_;
								gchar* _tmp344_;
								gchar* _tmp345_;
								_tmp339_ = token_length_in_chars;
								_tmp340_ = vala_scanner_get_source_reference (self, _tmp339_, 0);
								_tmp341_ = _tmp340_;
								_tmp342_ = begin;
								_tmp343_ = _tmp342_[0];
								_tmp344_ = g_strdup_printf ("syntax error, expected %c", (gint) _tmp343_);
								_tmp345_ = _tmp344_;
								vala_report_error (_tmp341_, _tmp345_);
								_g_free0 (_tmp345_);
								_vala_source_reference_unref0 (_tmp341_);
							}
							break;
						}
						default:
						{
							gunichar u;
							gchar* _tmp346_;
							gchar* _tmp347_;
							gchar* _tmp348_;
							gunichar _tmp349_;
							gunichar _tmp350_;
							gint _tmp359_;
							ValaSourceLocation _tmp360_ = {0};
							ValaSourceLocation _tmp361_ = {0};
							ValaTokenType _tmp362_;
							_tmp346_ = self->priv->current;
							_tmp347_ = self->priv->end;
							_tmp348_ = self->priv->current;
							_tmp349_ = g_utf8_get_char_validated ((const gchar*) _tmp346_, (gssize) ((glong) (_tmp347_ - _tmp348_)));
							u = _tmp349_;
							_tmp350_ = u;
							if (_tmp350_ != ((gunichar) -1)) {
								gchar* _tmp351_;
								gunichar _tmp352_;
								gint _tmp353_;
								ValaSourceReference* _tmp354_;
								ValaSourceReference* _tmp355_;
								_tmp351_ = self->priv->current;
								_tmp352_ = u;
								_tmp353_ = g_unichar_to_utf8 (_tmp352_, NULL);
								self->priv->current = _tmp351_ + _tmp353_;
								_tmp354_ = vala_scanner_get_source_reference (self, 0, 0);
								_tmp355_ = _tmp354_;
								vala_report_error (_tmp355_, "syntax error, unexpected character");
								_vala_source_reference_unref0 (_tmp355_);
							} else {
								gchar* _tmp356_;
								ValaSourceReference* _tmp357_;
								ValaSourceReference* _tmp358_;
								_tmp356_ = self->priv->current;
								self->priv->current = _tmp356_ + 1;
								_tmp357_ = vala_scanner_get_source_reference (self, 0, 0);
								_tmp358_ = _tmp357_;
								vala_report_error (_tmp358_, "invalid UTF-8 character");
								_vala_source_reference_unref0 (_tmp358_);
							}
							_tmp359_ = self->priv->column;
							self->priv->column = _tmp359_ + 1;
							_tmp362_ = vala_scanner_read_token (self, &_tmp360_, &_tmp361_);
							_vala_token_begin = _tmp360_;
							_vala_token_end = _tmp361_;
							result = _tmp362_;
							if (token_begin) {
								*token_begin = _vala_token_begin;
							}
							if (token_end) {
								*token_end = _vala_token_end;
							}
							return result;
						}
					}
				}
			}
		}
	}
	_tmp363_ = token_length_in_chars;
	if (_tmp363_ < 0) {
		gint _tmp364_;
		gchar* _tmp365_;
		gchar* _tmp366_;
		_tmp364_ = self->priv->column;
		_tmp365_ = self->priv->current;
		_tmp366_ = begin;
		self->priv->column = _tmp364_ + ((gint) (_tmp365_ - _tmp366_));
	} else {
		gint _tmp367_;
		gint _tmp368_;
		_tmp367_ = self->priv->column;
		_tmp368_ = token_length_in_chars;
		self->priv->column = _tmp367_ + _tmp368_;
	}
	_tmp369_ = self->priv->current;
	_tmp370_ = self->priv->line;
	_tmp371_ = self->priv->column;
	vala_source_location_init (&_vala_token_end, _tmp369_, _tmp370_, _tmp371_ - 1);
	_tmp372_ = type;
	self->priv->previous = _tmp372_;
	result = type;
	if (token_begin) {
		*token_begin = _vala_token_begin;
	}
	if (token_end) {
		*token_end = _vala_token_end;
	}
	return result;
}


static gboolean vala_scanner_matches (gchar* begin, const gchar* keyword) {
	gboolean result = FALSE;
	gchar* keyword_array;
	const gchar* _tmp0_;
	glong len;
	const gchar* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	g_return_val_if_fail (keyword != NULL, FALSE);
	_tmp0_ = keyword;
	keyword_array = (gchar*) _tmp0_;
	_tmp1_ = keyword;
	_tmp2_ = strlen (_tmp1_);
	_tmp3_ = _tmp2_;
	len = (glong) _tmp3_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp4_;
			_tmp4_ = TRUE;
			while (TRUE) {
				gint _tmp6_;
				glong _tmp7_;
				gchar* _tmp8_;
				gint _tmp9_;
				gchar _tmp10_;
				gchar* _tmp11_;
				gint _tmp12_;
				gchar _tmp13_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				_tmp6_ = i;
				_tmp7_ = len;
				if (!(((glong) _tmp6_) < _tmp7_)) {
					break;
				}
				_tmp8_ = begin;
				_tmp9_ = i;
				_tmp10_ = _tmp8_[_tmp9_];
				_tmp11_ = keyword_array;
				_tmp12_ = i;
				_tmp13_ = _tmp11_[_tmp12_];
				if (_tmp10_ != _tmp13_) {
					result = FALSE;
					return result;
				}
			}
		}
	}
	result = TRUE;
	return result;
}


static gboolean vala_scanner_pp_whitespace (ValaScanner* self) {
	gboolean result = FALSE;
	gboolean found;
	g_return_val_if_fail (self != NULL, FALSE);
	found = FALSE;
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_ = FALSE;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp9_;
		gint _tmp10_;
		_tmp2_ = self->priv->current;
		_tmp3_ = self->priv->end;
		if (_tmp2_ < _tmp3_) {
			gchar* _tmp4_;
			gchar _tmp5_;
			gboolean _tmp6_;
			_tmp4_ = self->priv->current;
			_tmp5_ = _tmp4_[0];
			_tmp6_ = g_ascii_isspace (_tmp5_);
			_tmp1_ = _tmp6_;
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			gchar* _tmp7_;
			gchar _tmp8_;
			_tmp7_ = self->priv->current;
			_tmp8_ = _tmp7_[0];
			_tmp0_ = _tmp8_ != '\n';
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		found = TRUE;
		_tmp9_ = self->priv->current;
		self->priv->current = _tmp9_ + 1;
		_tmp10_ = self->priv->column;
		self->priv->column = _tmp10_ + 1;
	}
	result = found;
	return result;
}


static void vala_scanner_pp_space (ValaScanner* self) {
	g_return_if_fail (self != NULL);
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_;
		_tmp1_ = vala_scanner_pp_whitespace (self);
		if (_tmp1_) {
			_tmp0_ = TRUE;
		} else {
			gboolean _tmp2_;
			_tmp2_ = vala_scanner_comment (self, FALSE);
			_tmp0_ = _tmp2_;
		}
		if (!_tmp0_) {
			break;
		}
	}
}


static void vala_scanner_pp_directive (ValaScanner* self) {
	gchar* _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gint _tmp5_;
	gchar* begin;
	gchar* _tmp17_;
	gint len;
	gboolean _tmp27_ = FALSE;
	gint _tmp28_;
	gboolean _tmp47_ = FALSE;
	ValaScannerConditional* _tmp48_;
	gint _tmp48__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->current;
	self->priv->current = _tmp0_ + 1;
	_tmp1_ = self->priv->column;
	self->priv->column = _tmp1_ + 1;
	_tmp5_ = self->priv->line;
	if (_tmp5_ == 1) {
		gint _tmp6_;
		_tmp6_ = self->priv->column;
		_tmp4_ = _tmp6_ == 2;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp7_ = self->priv->current;
		_tmp8_ = self->priv->end;
		_tmp3_ = _tmp7_ < _tmp8_;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		gchar* _tmp9_;
		gchar _tmp10_;
		_tmp9_ = self->priv->current;
		_tmp10_ = _tmp9_[0];
		_tmp2_ = _tmp10_ == '!';
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		while (TRUE) {
			gboolean _tmp11_ = FALSE;
			gchar* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp16_;
			_tmp12_ = self->priv->current;
			_tmp13_ = self->priv->end;
			if (_tmp12_ < _tmp13_) {
				gchar* _tmp14_;
				gchar _tmp15_;
				_tmp14_ = self->priv->current;
				_tmp15_ = _tmp14_[0];
				_tmp11_ = _tmp15_ != '\n';
			} else {
				_tmp11_ = FALSE;
			}
			if (!_tmp11_) {
				break;
			}
			_tmp16_ = self->priv->current;
			self->priv->current = _tmp16_ + 1;
		}
		return;
	}
	vala_scanner_pp_space (self);
	_tmp17_ = self->priv->current;
	begin = _tmp17_;
	len = 0;
	while (TRUE) {
		gboolean _tmp18_ = FALSE;
		gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp24_;
		gint _tmp25_;
		gint _tmp26_;
		_tmp19_ = self->priv->current;
		_tmp20_ = self->priv->end;
		if (_tmp19_ < _tmp20_) {
			gchar* _tmp21_;
			gchar _tmp22_;
			gboolean _tmp23_;
			_tmp21_ = self->priv->current;
			_tmp22_ = _tmp21_[0];
			_tmp23_ = g_ascii_isalnum (_tmp22_);
			_tmp18_ = _tmp23_;
		} else {
			_tmp18_ = FALSE;
		}
		if (!_tmp18_) {
			break;
		}
		_tmp24_ = self->priv->current;
		self->priv->current = _tmp24_ + 1;
		_tmp25_ = self->priv->column;
		self->priv->column = _tmp25_ + 1;
		_tmp26_ = len;
		len = _tmp26_ + 1;
	}
	_tmp28_ = len;
	if (_tmp28_ == 2) {
		gchar* _tmp29_;
		gboolean _tmp30_;
		_tmp29_ = begin;
		_tmp30_ = vala_scanner_matches (_tmp29_, "if");
		_tmp27_ = _tmp30_;
	} else {
		_tmp27_ = FALSE;
	}
	if (_tmp27_) {
		vala_scanner_parse_pp_if (self);
	} else {
		gboolean _tmp31_ = FALSE;
		gint _tmp32_;
		_tmp32_ = len;
		if (_tmp32_ == 4) {
			gchar* _tmp33_;
			gboolean _tmp34_;
			_tmp33_ = begin;
			_tmp34_ = vala_scanner_matches (_tmp33_, "elif");
			_tmp31_ = _tmp34_;
		} else {
			_tmp31_ = FALSE;
		}
		if (_tmp31_) {
			vala_scanner_parse_pp_elif (self);
		} else {
			gboolean _tmp35_ = FALSE;
			gint _tmp36_;
			_tmp36_ = len;
			if (_tmp36_ == 4) {
				gchar* _tmp37_;
				gboolean _tmp38_;
				_tmp37_ = begin;
				_tmp38_ = vala_scanner_matches (_tmp37_, "else");
				_tmp35_ = _tmp38_;
			} else {
				_tmp35_ = FALSE;
			}
			if (_tmp35_) {
				vala_scanner_parse_pp_else (self);
			} else {
				gboolean _tmp39_ = FALSE;
				gint _tmp40_;
				_tmp40_ = len;
				if (_tmp40_ == 5) {
					gchar* _tmp41_;
					gboolean _tmp42_;
					_tmp41_ = begin;
					_tmp42_ = vala_scanner_matches (_tmp41_, "endif");
					_tmp39_ = _tmp42_;
				} else {
					_tmp39_ = FALSE;
				}
				if (_tmp39_) {
					vala_scanner_parse_pp_endif (self);
				} else {
					gint _tmp43_;
					gint _tmp44_;
					ValaSourceReference* _tmp45_;
					ValaSourceReference* _tmp46_;
					_tmp43_ = len;
					_tmp44_ = len;
					_tmp45_ = vala_scanner_get_source_reference (self, -_tmp43_, _tmp44_);
					_tmp46_ = _tmp45_;
					vala_report_error (_tmp46_, "syntax error, invalid preprocessing directive");
					_vala_source_reference_unref0 (_tmp46_);
				}
			}
		}
	}
	_tmp48_ = self->priv->conditional_stack;
	_tmp48__length1 = self->priv->conditional_stack_length1;
	if (_tmp48__length1 > 0) {
		ValaScannerConditional* _tmp49_;
		gint _tmp49__length1;
		ValaScannerConditional* _tmp50_;
		gint _tmp50__length1;
		ValaScannerConditional _tmp51_;
		gboolean _tmp52_;
		_tmp49_ = self->priv->conditional_stack;
		_tmp49__length1 = self->priv->conditional_stack_length1;
		_tmp50_ = self->priv->conditional_stack;
		_tmp50__length1 = self->priv->conditional_stack_length1;
		_tmp51_ = _tmp49_[_tmp50__length1 - 1];
		_tmp52_ = _tmp51_.skip_section;
		_tmp47_ = _tmp52_;
	} else {
		_tmp47_ = FALSE;
	}
	if (_tmp47_) {
		gboolean bol;
		bol = FALSE;
		while (TRUE) {
			gchar* _tmp53_;
			gchar* _tmp54_;
			gboolean _tmp55_ = FALSE;
			gboolean _tmp56_;
			gchar* _tmp61_;
			gchar _tmp62_;
			gchar* _tmp67_;
			gint _tmp68_;
			_tmp53_ = self->priv->current;
			_tmp54_ = self->priv->end;
			if (!(_tmp53_ < _tmp54_)) {
				break;
			}
			_tmp56_ = bol;
			if (_tmp56_) {
				gchar* _tmp57_;
				gchar _tmp58_;
				_tmp57_ = self->priv->current;
				_tmp58_ = _tmp57_[0];
				_tmp55_ = _tmp58_ == '#';
			} else {
				_tmp55_ = FALSE;
			}
			if (_tmp55_) {
				gchar* _tmp59_;
				gint _tmp60_;
				_tmp59_ = self->priv->current;
				_tmp60_ = self->priv->column;
				self->priv->current = _tmp59_ - (_tmp60_ - 1);
				self->priv->column = 1;
				return;
			}
			_tmp61_ = self->priv->current;
			_tmp62_ = _tmp61_[0];
			if (_tmp62_ == '\n') {
				gint _tmp63_;
				_tmp63_ = self->priv->line;
				self->priv->line = _tmp63_ + 1;
				self->priv->column = 0;
				bol = TRUE;
			} else {
				gchar* _tmp64_;
				gchar _tmp65_;
				gboolean _tmp66_;
				_tmp64_ = self->priv->current;
				_tmp65_ = _tmp64_[0];
				_tmp66_ = g_ascii_isspace (_tmp65_);
				if (!_tmp66_) {
					bol = FALSE;
				}
			}
			_tmp67_ = self->priv->current;
			self->priv->current = _tmp67_ + 1;
			_tmp68_ = self->priv->column;
			self->priv->column = _tmp68_ + 1;
		}
	}
}


static void vala_scanner_pp_eol (ValaScanner* self) {
	gboolean _tmp0_ = FALSE;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	vala_scanner_pp_space (self);
	_tmp1_ = self->priv->current;
	_tmp2_ = self->priv->end;
	if (_tmp1_ >= _tmp2_) {
		_tmp0_ = TRUE;
	} else {
		gchar* _tmp3_;
		gchar _tmp4_;
		_tmp3_ = self->priv->current;
		_tmp4_ = _tmp3_[0];
		_tmp0_ = _tmp4_ != '\n';
	}
	if (_tmp0_) {
		ValaSourceReference* _tmp5_;
		ValaSourceReference* _tmp6_;
		_tmp5_ = vala_scanner_get_source_reference (self, 0, 0);
		_tmp6_ = _tmp5_;
		vala_report_error (_tmp6_, "syntax error, expected newline");
		_vala_source_reference_unref0 (_tmp6_);
	}
}


static void _vala_array_add22 (ValaScannerConditional* * array, int* length, int* size, const ValaScannerConditional* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaScannerConditional, *array, *size);
	}
	(*array)[(*length)++] = *value;
}


static void vala_scanner_parse_pp_if (ValaScanner* self) {
	gboolean condition;
	gboolean _tmp0_;
	ValaScannerConditional* _tmp1_;
	gint _tmp1__length1;
	ValaScannerConditional _tmp2_ = {0};
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_;
	g_return_if_fail (self != NULL);
	vala_scanner_pp_space (self);
	_tmp0_ = vala_scanner_parse_pp_expression (self);
	condition = _tmp0_;
	vala_scanner_pp_eol (self);
	_tmp1_ = self->priv->conditional_stack;
	_tmp1__length1 = self->priv->conditional_stack_length1;
	memset (&_tmp2_, 0, sizeof (ValaScannerConditional));
	_vala_array_add22 (&self->priv->conditional_stack, &self->priv->conditional_stack_length1, &self->priv->_conditional_stack_size_, &_tmp2_);
	_tmp4_ = condition;
	if (_tmp4_) {
		gboolean _tmp5_ = FALSE;
		ValaScannerConditional* _tmp6_;
		gint _tmp6__length1;
		_tmp6_ = self->priv->conditional_stack;
		_tmp6__length1 = self->priv->conditional_stack_length1;
		if (_tmp6__length1 == 1) {
			_tmp5_ = TRUE;
		} else {
			ValaScannerConditional* _tmp7_;
			gint _tmp7__length1;
			ValaScannerConditional* _tmp8_;
			gint _tmp8__length1;
			ValaScannerConditional _tmp9_;
			gboolean _tmp10_;
			_tmp7_ = self->priv->conditional_stack;
			_tmp7__length1 = self->priv->conditional_stack_length1;
			_tmp8_ = self->priv->conditional_stack;
			_tmp8__length1 = self->priv->conditional_stack_length1;
			_tmp9_ = _tmp7_[_tmp8__length1 - 2];
			_tmp10_ = _tmp9_.skip_section;
			_tmp5_ = !_tmp10_;
		}
		_tmp3_ = _tmp5_;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		ValaScannerConditional* _tmp11_;
		gint _tmp11__length1;
		ValaScannerConditional* _tmp12_;
		gint _tmp12__length1;
		_tmp11_ = self->priv->conditional_stack;
		_tmp11__length1 = self->priv->conditional_stack_length1;
		_tmp12_ = self->priv->conditional_stack;
		_tmp12__length1 = self->priv->conditional_stack_length1;
		_tmp11_[_tmp12__length1 - 1].matched = TRUE;
	} else {
		ValaScannerConditional* _tmp13_;
		gint _tmp13__length1;
		ValaScannerConditional* _tmp14_;
		gint _tmp14__length1;
		_tmp13_ = self->priv->conditional_stack;
		_tmp13__length1 = self->priv->conditional_stack_length1;
		_tmp14_ = self->priv->conditional_stack;
		_tmp14__length1 = self->priv->conditional_stack_length1;
		_tmp13_[_tmp14__length1 - 1].skip_section = TRUE;
	}
}


static void vala_scanner_parse_pp_elif (ValaScanner* self) {
	gboolean condition;
	gboolean _tmp0_;
	gboolean _tmp1_ = FALSE;
	ValaScannerConditional* _tmp2_;
	gint _tmp2__length1;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_;
	g_return_if_fail (self != NULL);
	vala_scanner_pp_space (self);
	_tmp0_ = vala_scanner_parse_pp_expression (self);
	condition = _tmp0_;
	vala_scanner_pp_eol (self);
	_tmp2_ = self->priv->conditional_stack;
	_tmp2__length1 = self->priv->conditional_stack_length1;
	if (_tmp2__length1 == 0) {
		_tmp1_ = TRUE;
	} else {
		ValaScannerConditional* _tmp3_;
		gint _tmp3__length1;
		ValaScannerConditional* _tmp4_;
		gint _tmp4__length1;
		ValaScannerConditional _tmp5_;
		gboolean _tmp6_;
		_tmp3_ = self->priv->conditional_stack;
		_tmp3__length1 = self->priv->conditional_stack_length1;
		_tmp4_ = self->priv->conditional_stack;
		_tmp4__length1 = self->priv->conditional_stack_length1;
		_tmp5_ = _tmp3_[_tmp4__length1 - 1];
		_tmp6_ = _tmp5_.else_found;
		_tmp1_ = _tmp6_;
	}
	if (_tmp1_) {
		ValaSourceReference* _tmp7_;
		ValaSourceReference* _tmp8_;
		_tmp7_ = vala_scanner_get_source_reference (self, 0, 0);
		_tmp8_ = _tmp7_;
		vala_report_error (_tmp8_, "syntax error, unexpected #elif");
		_vala_source_reference_unref0 (_tmp8_);
		return;
	}
	_tmp11_ = condition;
	if (_tmp11_) {
		ValaScannerConditional* _tmp12_;
		gint _tmp12__length1;
		ValaScannerConditional* _tmp13_;
		gint _tmp13__length1;
		ValaScannerConditional _tmp14_;
		gboolean _tmp15_;
		_tmp12_ = self->priv->conditional_stack;
		_tmp12__length1 = self->priv->conditional_stack_length1;
		_tmp13_ = self->priv->conditional_stack;
		_tmp13__length1 = self->priv->conditional_stack_length1;
		_tmp14_ = _tmp12_[_tmp13__length1 - 1];
		_tmp15_ = _tmp14_.matched;
		_tmp10_ = !_tmp15_;
	} else {
		_tmp10_ = FALSE;
	}
	if (_tmp10_) {
		gboolean _tmp16_ = FALSE;
		ValaScannerConditional* _tmp17_;
		gint _tmp17__length1;
		_tmp17_ = self->priv->conditional_stack;
		_tmp17__length1 = self->priv->conditional_stack_length1;
		if (_tmp17__length1 == 1) {
			_tmp16_ = TRUE;
		} else {
			ValaScannerConditional* _tmp18_;
			gint _tmp18__length1;
			ValaScannerConditional* _tmp19_;
			gint _tmp19__length1;
			ValaScannerConditional _tmp20_;
			gboolean _tmp21_;
			_tmp18_ = self->priv->conditional_stack;
			_tmp18__length1 = self->priv->conditional_stack_length1;
			_tmp19_ = self->priv->conditional_stack;
			_tmp19__length1 = self->priv->conditional_stack_length1;
			_tmp20_ = _tmp18_[_tmp19__length1 - 2];
			_tmp21_ = _tmp20_.skip_section;
			_tmp16_ = !_tmp21_;
		}
		_tmp9_ = _tmp16_;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		ValaScannerConditional* _tmp22_;
		gint _tmp22__length1;
		ValaScannerConditional* _tmp23_;
		gint _tmp23__length1;
		ValaScannerConditional* _tmp24_;
		gint _tmp24__length1;
		ValaScannerConditional* _tmp25_;
		gint _tmp25__length1;
		_tmp22_ = self->priv->conditional_stack;
		_tmp22__length1 = self->priv->conditional_stack_length1;
		_tmp23_ = self->priv->conditional_stack;
		_tmp23__length1 = self->priv->conditional_stack_length1;
		_tmp22_[_tmp23__length1 - 1].matched = TRUE;
		_tmp24_ = self->priv->conditional_stack;
		_tmp24__length1 = self->priv->conditional_stack_length1;
		_tmp25_ = self->priv->conditional_stack;
		_tmp25__length1 = self->priv->conditional_stack_length1;
		_tmp24_[_tmp25__length1 - 1].skip_section = FALSE;
	} else {
		ValaScannerConditional* _tmp26_;
		gint _tmp26__length1;
		ValaScannerConditional* _tmp27_;
		gint _tmp27__length1;
		_tmp26_ = self->priv->conditional_stack;
		_tmp26__length1 = self->priv->conditional_stack_length1;
		_tmp27_ = self->priv->conditional_stack;
		_tmp27__length1 = self->priv->conditional_stack_length1;
		_tmp26_[_tmp27__length1 - 1].skip_section = TRUE;
	}
}


static void vala_scanner_parse_pp_else (ValaScanner* self) {
	gboolean _tmp0_ = FALSE;
	ValaScannerConditional* _tmp1_;
	gint _tmp1__length1;
	gboolean _tmp8_ = FALSE;
	ValaScannerConditional* _tmp9_;
	gint _tmp9__length1;
	ValaScannerConditional* _tmp10_;
	gint _tmp10__length1;
	ValaScannerConditional _tmp11_;
	gboolean _tmp12_;
	g_return_if_fail (self != NULL);
	vala_scanner_pp_eol (self);
	_tmp1_ = self->priv->conditional_stack;
	_tmp1__length1 = self->priv->conditional_stack_length1;
	if (_tmp1__length1 == 0) {
		_tmp0_ = TRUE;
	} else {
		ValaScannerConditional* _tmp2_;
		gint _tmp2__length1;
		ValaScannerConditional* _tmp3_;
		gint _tmp3__length1;
		ValaScannerConditional _tmp4_;
		gboolean _tmp5_;
		_tmp2_ = self->priv->conditional_stack;
		_tmp2__length1 = self->priv->conditional_stack_length1;
		_tmp3_ = self->priv->conditional_stack;
		_tmp3__length1 = self->priv->conditional_stack_length1;
		_tmp4_ = _tmp2_[_tmp3__length1 - 1];
		_tmp5_ = _tmp4_.else_found;
		_tmp0_ = _tmp5_;
	}
	if (_tmp0_) {
		ValaSourceReference* _tmp6_;
		ValaSourceReference* _tmp7_;
		_tmp6_ = vala_scanner_get_source_reference (self, 0, 0);
		_tmp7_ = _tmp6_;
		vala_report_error (_tmp7_, "syntax error, unexpected #else");
		_vala_source_reference_unref0 (_tmp7_);
		return;
	}
	_tmp9_ = self->priv->conditional_stack;
	_tmp9__length1 = self->priv->conditional_stack_length1;
	_tmp10_ = self->priv->conditional_stack;
	_tmp10__length1 = self->priv->conditional_stack_length1;
	_tmp11_ = _tmp9_[_tmp10__length1 - 1];
	_tmp12_ = _tmp11_.matched;
	if (!_tmp12_) {
		gboolean _tmp13_ = FALSE;
		ValaScannerConditional* _tmp14_;
		gint _tmp14__length1;
		_tmp14_ = self->priv->conditional_stack;
		_tmp14__length1 = self->priv->conditional_stack_length1;
		if (_tmp14__length1 == 1) {
			_tmp13_ = TRUE;
		} else {
			ValaScannerConditional* _tmp15_;
			gint _tmp15__length1;
			ValaScannerConditional* _tmp16_;
			gint _tmp16__length1;
			ValaScannerConditional _tmp17_;
			gboolean _tmp18_;
			_tmp15_ = self->priv->conditional_stack;
			_tmp15__length1 = self->priv->conditional_stack_length1;
			_tmp16_ = self->priv->conditional_stack;
			_tmp16__length1 = self->priv->conditional_stack_length1;
			_tmp17_ = _tmp15_[_tmp16__length1 - 2];
			_tmp18_ = _tmp17_.skip_section;
			_tmp13_ = !_tmp18_;
		}
		_tmp8_ = _tmp13_;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		ValaScannerConditional* _tmp19_;
		gint _tmp19__length1;
		ValaScannerConditional* _tmp20_;
		gint _tmp20__length1;
		ValaScannerConditional* _tmp21_;
		gint _tmp21__length1;
		ValaScannerConditional* _tmp22_;
		gint _tmp22__length1;
		_tmp19_ = self->priv->conditional_stack;
		_tmp19__length1 = self->priv->conditional_stack_length1;
		_tmp20_ = self->priv->conditional_stack;
		_tmp20__length1 = self->priv->conditional_stack_length1;
		_tmp19_[_tmp20__length1 - 1].matched = TRUE;
		_tmp21_ = self->priv->conditional_stack;
		_tmp21__length1 = self->priv->conditional_stack_length1;
		_tmp22_ = self->priv->conditional_stack;
		_tmp22__length1 = self->priv->conditional_stack_length1;
		_tmp21_[_tmp22__length1 - 1].skip_section = FALSE;
	} else {
		ValaScannerConditional* _tmp23_;
		gint _tmp23__length1;
		ValaScannerConditional* _tmp24_;
		gint _tmp24__length1;
		_tmp23_ = self->priv->conditional_stack;
		_tmp23__length1 = self->priv->conditional_stack_length1;
		_tmp24_ = self->priv->conditional_stack;
		_tmp24__length1 = self->priv->conditional_stack_length1;
		_tmp23_[_tmp24__length1 - 1].skip_section = TRUE;
	}
}


static void vala_scanner_parse_pp_endif (ValaScanner* self) {
	ValaScannerConditional* _tmp0_;
	gint _tmp0__length1;
	gint _tmp3_;
	g_return_if_fail (self != NULL);
	vala_scanner_pp_eol (self);
	_tmp0_ = self->priv->conditional_stack;
	_tmp0__length1 = self->priv->conditional_stack_length1;
	if (_tmp0__length1 == 0) {
		ValaSourceReference* _tmp1_;
		ValaSourceReference* _tmp2_;
		_tmp1_ = vala_scanner_get_source_reference (self, 0, 0);
		_tmp2_ = _tmp1_;
		vala_report_error (_tmp2_, "syntax error, unexpected #endif");
		_vala_source_reference_unref0 (_tmp2_);
		return;
	}
	_tmp3_ = self->priv->conditional_stack_length1;
	self->priv->conditional_stack_length1 = _tmp3_ - 1;
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	glong _tmp8_;
	glong _tmp14_;
	glong _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	gchar* _tmp22_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp3_;
		glong _tmp4_;
		glong _tmp5_;
		_tmp3_ = offset;
		_tmp4_ = len;
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
		string_length = _tmp5_;
	} else {
		gint _tmp6_;
		gint _tmp7_;
		_tmp6_ = strlen (self);
		_tmp7_ = _tmp6_;
		string_length = (glong) _tmp7_;
	}
	_tmp8_ = offset;
	if (_tmp8_ < ((glong) 0)) {
		glong _tmp9_;
		glong _tmp10_;
		glong _tmp11_;
		_tmp9_ = string_length;
		_tmp10_ = offset;
		offset = _tmp9_ + _tmp10_;
		_tmp11_ = offset;
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
	} else {
		glong _tmp12_;
		glong _tmp13_;
		_tmp12_ = offset;
		_tmp13_ = string_length;
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
	}
	_tmp14_ = len;
	if (_tmp14_ < ((glong) 0)) {
		glong _tmp15_;
		glong _tmp16_;
		_tmp15_ = string_length;
		_tmp16_ = offset;
		len = _tmp15_ - _tmp16_;
	}
	_tmp17_ = offset;
	_tmp18_ = len;
	_tmp19_ = string_length;
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
	_tmp20_ = offset;
	_tmp21_ = len;
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
	result = _tmp22_;
	return result;
}


static gboolean vala_scanner_parse_pp_symbol (ValaScanner* self) {
	gboolean result = FALSE;
	gint len;
	gint _tmp9_;
	gchar* identifier;
	gchar* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	gchar* _tmp15_;
	gboolean defined = FALSE;
	const gchar* _tmp16_;
	g_return_val_if_fail (self != NULL, FALSE);
	len = 0;
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		_tmp1_ = self->priv->current;
		_tmp2_ = self->priv->end;
		if (_tmp1_ < _tmp2_) {
			gchar* _tmp3_;
			gchar _tmp4_;
			gboolean _tmp5_;
			_tmp3_ = self->priv->current;
			_tmp4_ = _tmp3_[0];
			_tmp5_ = vala_scanner_is_ident_char (self, _tmp4_);
			_tmp0_ = _tmp5_;
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		_tmp6_ = self->priv->current;
		self->priv->current = _tmp6_ + 1;
		_tmp7_ = self->priv->column;
		self->priv->column = _tmp7_ + 1;
		_tmp8_ = len;
		len = _tmp8_ + 1;
	}
	_tmp9_ = len;
	if (_tmp9_ == 0) {
		ValaSourceReference* _tmp10_;
		ValaSourceReference* _tmp11_;
		_tmp10_ = vala_scanner_get_source_reference (self, 0, 0);
		_tmp11_ = _tmp10_;
		vala_report_error (_tmp11_, "syntax error, expected identifier");
		_vala_source_reference_unref0 (_tmp11_);
		result = FALSE;
		return result;
	}
	_tmp12_ = self->priv->current;
	_tmp13_ = len;
	_tmp14_ = len;
	_tmp15_ = string_substring ((const gchar*) (_tmp12_ - _tmp13_), (glong) 0, (glong) _tmp14_);
	identifier = _tmp15_;
	_tmp16_ = identifier;
	if (g_strcmp0 (_tmp16_, "true") == 0) {
		defined = TRUE;
	} else {
		const gchar* _tmp17_;
		_tmp17_ = identifier;
		if (g_strcmp0 (_tmp17_, "false") == 0) {
			defined = FALSE;
		} else {
			ValaSourceFile* _tmp18_;
			ValaCodeContext* _tmp19_;
			ValaCodeContext* _tmp20_;
			const gchar* _tmp21_;
			gboolean _tmp22_;
			_tmp18_ = self->priv->_source_file;
			_tmp19_ = vala_source_file_get_context (_tmp18_);
			_tmp20_ = _tmp19_;
			_tmp21_ = identifier;
			_tmp22_ = vala_code_context_is_defined (_tmp20_, _tmp21_);
			defined = _tmp22_;
		}
	}
	result = defined;
	_g_free0 (identifier);
	return result;
}


static gboolean vala_scanner_parse_pp_primary_expression (ValaScanner* self) {
	gboolean result = FALSE;
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->current;
	_tmp1_ = self->priv->end;
	if (_tmp0_ >= _tmp1_) {
		ValaSourceReference* _tmp2_;
		ValaSourceReference* _tmp3_;
		_tmp2_ = vala_scanner_get_source_reference (self, 0, 0);
		_tmp3_ = _tmp2_;
		vala_report_error (_tmp3_, "syntax error, expected identifier");
		_vala_source_reference_unref0 (_tmp3_);
	} else {
		gchar* _tmp4_;
		gchar _tmp5_;
		gboolean _tmp6_;
		_tmp4_ = self->priv->current;
		_tmp5_ = _tmp4_[0];
		_tmp6_ = vala_scanner_is_ident_char (self, _tmp5_);
		if (_tmp6_) {
			gboolean _tmp7_;
			_tmp7_ = vala_scanner_parse_pp_symbol (self);
			result = _tmp7_;
			return result;
		} else {
			gchar* _tmp8_;
			gchar _tmp9_;
			_tmp8_ = self->priv->current;
			_tmp9_ = _tmp8_[0];
			if (_tmp9_ == '(') {
				gchar* _tmp10_;
				gint _tmp11_;
				gboolean _result_;
				gboolean _tmp12_;
				gboolean _tmp13_ = FALSE;
				gchar* _tmp14_;
				gchar* _tmp15_;
				_tmp10_ = self->priv->current;
				self->priv->current = _tmp10_ + 1;
				_tmp11_ = self->priv->column;
				self->priv->column = _tmp11_ + 1;
				vala_scanner_pp_space (self);
				_tmp12_ = vala_scanner_parse_pp_expression (self);
				_result_ = _tmp12_;
				vala_scanner_pp_space (self);
				_tmp14_ = self->priv->current;
				_tmp15_ = self->priv->end;
				if (_tmp14_ < _tmp15_) {
					gchar* _tmp16_;
					gchar _tmp17_;
					_tmp16_ = self->priv->current;
					_tmp17_ = _tmp16_[0];
					_tmp13_ = _tmp17_ == ')';
				} else {
					_tmp13_ = FALSE;
				}
				if (_tmp13_) {
					gchar* _tmp18_;
					gint _tmp19_;
					_tmp18_ = self->priv->current;
					self->priv->current = _tmp18_ + 1;
					_tmp19_ = self->priv->column;
					self->priv->column = _tmp19_ + 1;
				} else {
					ValaSourceReference* _tmp20_;
					ValaSourceReference* _tmp21_;
					_tmp20_ = vala_scanner_get_source_reference (self, 0, 0);
					_tmp21_ = _tmp20_;
					vala_report_error (_tmp21_, "syntax error, expected `)'");
					_vala_source_reference_unref0 (_tmp21_);
				}
				result = _result_;
				return result;
			} else {
				ValaSourceReference* _tmp22_;
				ValaSourceReference* _tmp23_;
				_tmp22_ = vala_scanner_get_source_reference (self, 0, 0);
				_tmp23_ = _tmp22_;
				vala_report_error (_tmp23_, "syntax error, expected identifier");
				_vala_source_reference_unref0 (_tmp23_);
			}
		}
	}
	result = FALSE;
	return result;
}


static gboolean vala_scanner_parse_pp_unary_expression (ValaScanner* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp8_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->current;
	_tmp2_ = self->priv->end;
	if (_tmp1_ < _tmp2_) {
		gchar* _tmp3_;
		gchar _tmp4_;
		_tmp3_ = self->priv->current;
		_tmp4_ = _tmp3_[0];
		_tmp0_ = _tmp4_ == '!';
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gchar* _tmp5_;
		gint _tmp6_;
		gboolean _tmp7_;
		_tmp5_ = self->priv->current;
		self->priv->current = _tmp5_ + 1;
		_tmp6_ = self->priv->column;
		self->priv->column = _tmp6_ + 1;
		vala_scanner_pp_space (self);
		_tmp7_ = vala_scanner_parse_pp_unary_expression (self);
		result = !_tmp7_;
		return result;
	}
	_tmp8_ = vala_scanner_parse_pp_primary_expression (self);
	result = _tmp8_;
	return result;
}


static gboolean vala_scanner_parse_pp_equality_expression (ValaScanner* self) {
	gboolean result = FALSE;
	gboolean left;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_scanner_parse_pp_unary_expression (self);
	left = _tmp0_;
	vala_scanner_pp_space (self);
	while (TRUE) {
		gboolean _tmp1_ = FALSE;
		gboolean _tmp2_ = FALSE;
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = self->priv->current;
		_tmp4_ = self->priv->end;
		if (_tmp3_ < (_tmp4_ - 1)) {
			gchar* _tmp5_;
			gchar _tmp6_;
			_tmp5_ = self->priv->current;
			_tmp6_ = _tmp5_[0];
			_tmp2_ = _tmp6_ == '=';
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			gchar* _tmp7_;
			gchar _tmp8_;
			_tmp7_ = self->priv->current;
			_tmp8_ = _tmp7_[1];
			_tmp1_ = _tmp8_ == '=';
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			gchar* _tmp9_;
			gint _tmp10_;
			gboolean right;
			gboolean _tmp11_;
			gboolean _tmp12_;
			gboolean _tmp13_;
			_tmp9_ = self->priv->current;
			self->priv->current = _tmp9_ + 2;
			_tmp10_ = self->priv->column;
			self->priv->column = _tmp10_ + 2;
			vala_scanner_pp_space (self);
			_tmp11_ = vala_scanner_parse_pp_unary_expression (self);
			right = _tmp11_;
			_tmp12_ = left;
			_tmp13_ = right;
			left = _tmp12_ == _tmp13_;
		} else {
			gboolean _tmp14_ = FALSE;
			gboolean _tmp15_ = FALSE;
			gchar* _tmp16_;
			gchar* _tmp17_;
			_tmp16_ = self->priv->current;
			_tmp17_ = self->priv->end;
			if (_tmp16_ < (_tmp17_ - 1)) {
				gchar* _tmp18_;
				gchar _tmp19_;
				_tmp18_ = self->priv->current;
				_tmp19_ = _tmp18_[0];
				_tmp15_ = _tmp19_ == '!';
			} else {
				_tmp15_ = FALSE;
			}
			if (_tmp15_) {
				gchar* _tmp20_;
				gchar _tmp21_;
				_tmp20_ = self->priv->current;
				_tmp21_ = _tmp20_[1];
				_tmp14_ = _tmp21_ == '=';
			} else {
				_tmp14_ = FALSE;
			}
			if (_tmp14_) {
				gchar* _tmp22_;
				gint _tmp23_;
				gboolean right;
				gboolean _tmp24_;
				gboolean _tmp25_;
				gboolean _tmp26_;
				_tmp22_ = self->priv->current;
				self->priv->current = _tmp22_ + 2;
				_tmp23_ = self->priv->column;
				self->priv->column = _tmp23_ + 2;
				vala_scanner_pp_space (self);
				_tmp24_ = vala_scanner_parse_pp_unary_expression (self);
				right = _tmp24_;
				_tmp25_ = left;
				_tmp26_ = right;
				left = _tmp25_ != _tmp26_;
			} else {
				break;
			}
		}
	}
	result = left;
	return result;
}


static gboolean vala_scanner_parse_pp_and_expression (ValaScanner* self) {
	gboolean result = FALSE;
	gboolean left;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_scanner_parse_pp_equality_expression (self);
	left = _tmp0_;
	vala_scanner_pp_space (self);
	while (TRUE) {
		gboolean _tmp1_ = FALSE;
		gboolean _tmp2_ = FALSE;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp9_;
		gint _tmp10_;
		gboolean right;
		gboolean _tmp11_;
		gboolean _tmp12_ = FALSE;
		gboolean _tmp13_;
		_tmp3_ = self->priv->current;
		_tmp4_ = self->priv->end;
		if (_tmp3_ < (_tmp4_ - 1)) {
			gchar* _tmp5_;
			gchar _tmp6_;
			_tmp5_ = self->priv->current;
			_tmp6_ = _tmp5_[0];
			_tmp2_ = _tmp6_ == '&';
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			gchar* _tmp7_;
			gchar _tmp8_;
			_tmp7_ = self->priv->current;
			_tmp8_ = _tmp7_[1];
			_tmp1_ = _tmp8_ == '&';
		} else {
			_tmp1_ = FALSE;
		}
		if (!_tmp1_) {
			break;
		}
		_tmp9_ = self->priv->current;
		self->priv->current = _tmp9_ + 2;
		_tmp10_ = self->priv->column;
		self->priv->column = _tmp10_ + 2;
		vala_scanner_pp_space (self);
		_tmp11_ = vala_scanner_parse_pp_equality_expression (self);
		right = _tmp11_;
		_tmp13_ = left;
		if (_tmp13_) {
			gboolean _tmp14_;
			_tmp14_ = right;
			_tmp12_ = _tmp14_;
		} else {
			_tmp12_ = FALSE;
		}
		left = _tmp12_;
	}
	result = left;
	return result;
}


static gboolean vala_scanner_parse_pp_or_expression (ValaScanner* self) {
	gboolean result = FALSE;
	gboolean left;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_scanner_parse_pp_and_expression (self);
	left = _tmp0_;
	vala_scanner_pp_space (self);
	while (TRUE) {
		gboolean _tmp1_ = FALSE;
		gboolean _tmp2_ = FALSE;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp9_;
		gint _tmp10_;
		gboolean right;
		gboolean _tmp11_;
		gboolean _tmp12_ = FALSE;
		gboolean _tmp13_;
		_tmp3_ = self->priv->current;
		_tmp4_ = self->priv->end;
		if (_tmp3_ < (_tmp4_ - 1)) {
			gchar* _tmp5_;
			gchar _tmp6_;
			_tmp5_ = self->priv->current;
			_tmp6_ = _tmp5_[0];
			_tmp2_ = _tmp6_ == '|';
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			gchar* _tmp7_;
			gchar _tmp8_;
			_tmp7_ = self->priv->current;
			_tmp8_ = _tmp7_[1];
			_tmp1_ = _tmp8_ == '|';
		} else {
			_tmp1_ = FALSE;
		}
		if (!_tmp1_) {
			break;
		}
		_tmp9_ = self->priv->current;
		self->priv->current = _tmp9_ + 2;
		_tmp10_ = self->priv->column;
		self->priv->column = _tmp10_ + 2;
		vala_scanner_pp_space (self);
		_tmp11_ = vala_scanner_parse_pp_and_expression (self);
		right = _tmp11_;
		_tmp13_ = left;
		if (_tmp13_) {
			_tmp12_ = TRUE;
		} else {
			gboolean _tmp14_;
			_tmp14_ = right;
			_tmp12_ = _tmp14_;
		}
		left = _tmp12_;
	}
	result = left;
	return result;
}


static gboolean vala_scanner_parse_pp_expression (ValaScanner* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_scanner_parse_pp_or_expression (self);
	result = _tmp0_;
	return result;
}


static gboolean vala_scanner_whitespace (ValaScanner* self) {
	gboolean result = FALSE;
	gboolean found;
	gboolean bol;
	gint _tmp0_;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp14_;
	g_return_val_if_fail (self != NULL, FALSE);
	found = FALSE;
	_tmp0_ = self->priv->column;
	bol = _tmp0_ == 1;
	while (TRUE) {
		gboolean _tmp1_ = FALSE;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp7_;
		gchar _tmp8_;
		gchar* _tmp10_;
		gint _tmp11_;
		_tmp2_ = self->priv->current;
		_tmp3_ = self->priv->end;
		if (_tmp2_ < _tmp3_) {
			gchar* _tmp4_;
			gchar _tmp5_;
			gboolean _tmp6_;
			_tmp4_ = self->priv->current;
			_tmp5_ = _tmp4_[0];
			_tmp6_ = g_ascii_isspace (_tmp5_);
			_tmp1_ = _tmp6_;
		} else {
			_tmp1_ = FALSE;
		}
		if (!_tmp1_) {
			break;
		}
		_tmp7_ = self->priv->current;
		_tmp8_ = _tmp7_[0];
		if (_tmp8_ == '\n') {
			gint _tmp9_;
			_tmp9_ = self->priv->line;
			self->priv->line = _tmp9_ + 1;
			self->priv->column = 0;
			bol = TRUE;
		}
		found = TRUE;
		_tmp10_ = self->priv->current;
		self->priv->current = _tmp10_ + 1;
		_tmp11_ = self->priv->column;
		self->priv->column = _tmp11_ + 1;
	}
	_tmp14_ = bol;
	if (_tmp14_) {
		gchar* _tmp15_;
		gchar* _tmp16_;
		_tmp15_ = self->priv->current;
		_tmp16_ = self->priv->end;
		_tmp13_ = _tmp15_ < _tmp16_;
	} else {
		_tmp13_ = FALSE;
	}
	if (_tmp13_) {
		gchar* _tmp17_;
		gchar _tmp18_;
		_tmp17_ = self->priv->current;
		_tmp18_ = _tmp17_[0];
		_tmp12_ = _tmp18_ == '#';
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		vala_scanner_pp_directive (self);
		result = TRUE;
		return result;
	}
	result = found;
	return result;
}


static gboolean vala_scanner_comment (ValaScanner* self, gboolean file_comment) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gchar* _tmp3_;
	gchar* _tmp13_;
	gchar _tmp14_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp3_ = self->priv->current;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp4_ = self->priv->current;
		_tmp5_ = self->priv->end;
		_tmp2_ = _tmp4_ > (_tmp5_ - 2);
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		gchar* _tmp6_;
		gchar _tmp7_;
		_tmp6_ = self->priv->current;
		_tmp7_ = _tmp6_[0];
		_tmp1_ = _tmp7_ != '/';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp8_ = FALSE;
		gchar* _tmp9_;
		gchar _tmp10_;
		_tmp9_ = self->priv->current;
		_tmp10_ = _tmp9_[1];
		if (_tmp10_ != '/') {
			gchar* _tmp11_;
			gchar _tmp12_;
			_tmp11_ = self->priv->current;
			_tmp12_ = _tmp11_[1];
			_tmp8_ = _tmp12_ != '*';
		} else {
			_tmp8_ = FALSE;
		}
		_tmp0_ = _tmp8_;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp13_ = self->priv->current;
	_tmp14_ = _tmp13_[1];
	if (_tmp14_ == '/') {
		ValaSourceReference* source_reference;
		gboolean _tmp15_;
		gchar* _tmp17_;
		gchar* begin;
		gchar* _tmp18_;
		ValaSourceReference* _tmp25_;
		source_reference = NULL;
		_tmp15_ = file_comment;
		if (_tmp15_) {
			ValaSourceReference* _tmp16_;
			_tmp16_ = vala_scanner_get_source_reference (self, 0, 0);
			_vala_source_reference_unref0 (source_reference);
			source_reference = _tmp16_;
		}
		_tmp17_ = self->priv->current;
		self->priv->current = _tmp17_ + 2;
		_tmp18_ = self->priv->current;
		begin = _tmp18_;
		while (TRUE) {
			gboolean _tmp19_ = FALSE;
			gchar* _tmp20_;
			gchar* _tmp21_;
			gchar* _tmp24_;
			_tmp20_ = self->priv->current;
			_tmp21_ = self->priv->end;
			if (_tmp20_ < _tmp21_) {
				gchar* _tmp22_;
				gchar _tmp23_;
				_tmp22_ = self->priv->current;
				_tmp23_ = _tmp22_[0];
				_tmp19_ = _tmp23_ != '\n';
			} else {
				_tmp19_ = FALSE;
			}
			if (!_tmp19_) {
				break;
			}
			_tmp24_ = self->priv->current;
			self->priv->current = _tmp24_ + 1;
		}
		_tmp25_ = source_reference;
		if (_tmp25_ != NULL) {
			gchar* _tmp26_;
			gchar* _tmp27_;
			gchar* _tmp28_;
			gchar* _tmp29_;
			gchar* _tmp30_;
			ValaSourceReference* _tmp31_;
			gboolean _tmp32_;
			_tmp26_ = begin;
			_tmp27_ = self->priv->current;
			_tmp28_ = begin;
			_tmp29_ = string_substring ((const gchar*) _tmp26_, (glong) 0, (glong) (_tmp27_ - _tmp28_));
			_tmp30_ = _tmp29_;
			_tmp31_ = source_reference;
			_tmp32_ = file_comment;
			vala_scanner_push_comment (self, _tmp30_, _tmp31_, _tmp32_);
			_g_free0 (_tmp30_);
		}
		_vala_source_reference_unref0 (source_reference);
	} else {
		ValaSourceReference* source_reference;
		gboolean _tmp33_ = FALSE;
		gboolean _tmp34_;
		gboolean _tmp37_ = FALSE;
		gchar* _tmp38_;
		gchar _tmp39_;
		gchar* _tmp42_;
		gchar* begin;
		gchar* _tmp43_;
		gchar* _tmp57_;
		gchar* _tmp58_;
		ValaSourceReference* _tmp61_;
		gchar* _tmp69_;
		gint _tmp70_;
		source_reference = NULL;
		_tmp34_ = file_comment;
		if (_tmp34_) {
			gchar* _tmp35_;
			gchar _tmp36_;
			_tmp35_ = self->priv->current;
			_tmp36_ = _tmp35_[2];
			_tmp33_ = _tmp36_ == '*';
		} else {
			_tmp33_ = FALSE;
		}
		if (_tmp33_) {
			result = FALSE;
			_vala_source_reference_unref0 (source_reference);
			return result;
		}
		_tmp38_ = self->priv->current;
		_tmp39_ = _tmp38_[2];
		if (_tmp39_ == '*') {
			_tmp37_ = TRUE;
		} else {
			gboolean _tmp40_;
			_tmp40_ = file_comment;
			_tmp37_ = _tmp40_;
		}
		if (_tmp37_) {
			ValaSourceReference* _tmp41_;
			_tmp41_ = vala_scanner_get_source_reference (self, 0, 0);
			_vala_source_reference_unref0 (source_reference);
			source_reference = _tmp41_;
		}
		_tmp42_ = self->priv->current;
		self->priv->current = _tmp42_ + 2;
		_tmp43_ = self->priv->current;
		begin = _tmp43_;
		while (TRUE) {
			gboolean _tmp44_ = FALSE;
			gchar* _tmp45_;
			gchar* _tmp46_;
			gchar* _tmp52_;
			gchar _tmp53_;
			gchar* _tmp55_;
			gint _tmp56_;
			_tmp45_ = self->priv->current;
			_tmp46_ = self->priv->end;
			if (_tmp45_ < (_tmp46_ - 1)) {
				gboolean _tmp47_ = FALSE;
				gchar* _tmp48_;
				gchar _tmp49_;
				_tmp48_ = self->priv->current;
				_tmp49_ = _tmp48_[0];
				if (_tmp49_ != '*') {
					_tmp47_ = TRUE;
				} else {
					gchar* _tmp50_;
					gchar _tmp51_;
					_tmp50_ = self->priv->current;
					_tmp51_ = _tmp50_[1];
					_tmp47_ = _tmp51_ != '/';
				}
				_tmp44_ = _tmp47_;
			} else {
				_tmp44_ = FALSE;
			}
			if (!_tmp44_) {
				break;
			}
			_tmp52_ = self->priv->current;
			_tmp53_ = _tmp52_[0];
			if (_tmp53_ == '\n') {
				gint _tmp54_;
				_tmp54_ = self->priv->line;
				self->priv->line = _tmp54_ + 1;
				self->priv->column = 0;
			}
			_tmp55_ = self->priv->current;
			self->priv->current = _tmp55_ + 1;
			_tmp56_ = self->priv->column;
			self->priv->column = _tmp56_ + 1;
		}
		_tmp57_ = self->priv->current;
		_tmp58_ = self->priv->end;
		if (_tmp57_ == (_tmp58_ - 1)) {
			ValaSourceReference* _tmp59_;
			ValaSourceReference* _tmp60_;
			_tmp59_ = vala_scanner_get_source_reference (self, 0, 0);
			_tmp60_ = _tmp59_;
			vala_report_error (_tmp60_, "syntax error, expected */");
			_vala_source_reference_unref0 (_tmp60_);
			result = TRUE;
			_vala_source_reference_unref0 (source_reference);
			return result;
		}
		_tmp61_ = source_reference;
		if (_tmp61_ != NULL) {
			gchar* _tmp62_;
			gchar* _tmp63_;
			gchar* _tmp64_;
			gchar* _tmp65_;
			gchar* _tmp66_;
			ValaSourceReference* _tmp67_;
			gboolean _tmp68_;
			_tmp62_ = begin;
			_tmp63_ = self->priv->current;
			_tmp64_ = begin;
			_tmp65_ = string_substring ((const gchar*) _tmp62_, (glong) 0, (glong) (_tmp63_ - _tmp64_));
			_tmp66_ = _tmp65_;
			_tmp67_ = source_reference;
			_tmp68_ = file_comment;
			vala_scanner_push_comment (self, _tmp66_, _tmp67_, _tmp68_);
			_g_free0 (_tmp66_);
		}
		_tmp69_ = self->priv->current;
		self->priv->current = _tmp69_ + 2;
		_tmp70_ = self->priv->column;
		self->priv->column = _tmp70_ + 2;
		_vala_source_reference_unref0 (source_reference);
	}
	result = TRUE;
	return result;
}


static void vala_scanner_space (ValaScanner* self) {
	g_return_if_fail (self != NULL);
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_;
		_tmp1_ = vala_scanner_whitespace (self);
		if (_tmp1_) {
			_tmp0_ = TRUE;
		} else {
			gboolean _tmp2_;
			_tmp2_ = vala_scanner_comment (self, FALSE);
			_tmp0_ = _tmp2_;
		}
		if (!_tmp0_) {
			break;
		}
	}
}


void vala_scanner_parse_file_comments (ValaScanner* self) {
	g_return_if_fail (self != NULL);
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_;
		_tmp1_ = vala_scanner_whitespace (self);
		if (_tmp1_) {
			_tmp0_ = TRUE;
		} else {
			gboolean _tmp2_;
			_tmp2_ = vala_scanner_comment (self, TRUE);
			_tmp0_ = _tmp2_;
		}
		if (!_tmp0_) {
			break;
		}
	}
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_;
	gchar _tmp1_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static void vala_scanner_push_comment (ValaScanner* self, const gchar* comment_item, ValaSourceReference* source_reference, gboolean file_comment) {
	const gchar* _tmp0_;
	gchar _tmp1_;
	gboolean _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (comment_item != NULL);
	g_return_if_fail (source_reference != NULL);
	_tmp0_ = comment_item;
	_tmp1_ = string_get (_tmp0_, (glong) 0);
	if (_tmp1_ == '*') {
		ValaComment* _tmp2_;
		const gchar* _tmp5_;
		ValaSourceReference* _tmp6_;
		ValaComment* _tmp7_;
		_tmp2_ = self->priv->_comment;
		if (_tmp2_ != NULL) {
			ValaSourceFile* _tmp3_;
			ValaComment* _tmp4_;
			_tmp3_ = self->priv->_source_file;
			_tmp4_ = self->priv->_comment;
			vala_source_file_add_comment (_tmp3_, _tmp4_);
		}
		_tmp5_ = comment_item;
		_tmp6_ = source_reference;
		_tmp7_ = vala_comment_new (_tmp5_, _tmp6_);
		_vala_comment_unref0 (self->priv->_comment);
		self->priv->_comment = _tmp7_;
	}
	_tmp8_ = file_comment;
	if (_tmp8_) {
		ValaSourceFile* _tmp9_;
		const gchar* _tmp10_;
		ValaSourceReference* _tmp11_;
		ValaComment* _tmp12_;
		ValaComment* _tmp13_;
		_tmp9_ = self->priv->_source_file;
		_tmp10_ = comment_item;
		_tmp11_ = source_reference;
		_tmp12_ = vala_comment_new (_tmp10_, _tmp11_);
		_tmp13_ = _tmp12_;
		vala_source_file_add_comment (_tmp9_, _tmp13_);
		_vala_comment_unref0 (_tmp13_);
		_vala_comment_unref0 (self->priv->_comment);
		self->priv->_comment = NULL;
	}
}


/**
 * Clears and returns the content of the comment stack.
 *
 * @return saved comment
 */
static gpointer _vala_comment_ref0 (gpointer self) {
	return self ? vala_comment_ref (self) : NULL;
}


ValaComment* vala_scanner_pop_comment (ValaScanner* self) {
	ValaComment* result = NULL;
	ValaComment* _tmp0_;
	ValaComment* comment;
	ValaComment* _tmp1_;
	ValaComment* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_comment;
	if (_tmp0_ == NULL) {
		result = NULL;
		return result;
	}
	_tmp1_ = self->priv->_comment;
	_tmp2_ = _vala_comment_ref0 (_tmp1_);
	comment = _tmp2_;
	_vala_comment_unref0 (self->priv->_comment);
	self->priv->_comment = NULL;
	result = comment;
	return result;
}


ValaSourceFile* vala_scanner_get_source_file (ValaScanner* self) {
	ValaSourceFile* result;
	ValaSourceFile* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_source_file;
	result = _tmp0_;
	return result;
}


static gpointer _vala_source_file_ref0 (gpointer self) {
	return self ? vala_source_file_ref (self) : NULL;
}


static void vala_scanner_set_source_file (ValaScanner* self, ValaSourceFile* value) {
	ValaSourceFile* _tmp0_;
	ValaSourceFile* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_source_file_ref0 (_tmp0_);
	_vala_source_file_unref0 (self->priv->_source_file);
	self->priv->_source_file = _tmp1_;
}


static ValaScannerConditional* vala_scanner_conditional_dup (const ValaScannerConditional* self) {
	ValaScannerConditional* dup;
	dup = g_new0 (ValaScannerConditional, 1);
	memcpy (dup, self, sizeof (ValaScannerConditional));
	return dup;
}


static void vala_scanner_conditional_free (ValaScannerConditional* self) {
	g_free (self);
}


static GType vala_scanner_conditional_get_type (void) {
	static volatile gsize vala_scanner_conditional_type_id__volatile = 0;
	if (g_once_init_enter (&vala_scanner_conditional_type_id__volatile)) {
		GType vala_scanner_conditional_type_id;
		vala_scanner_conditional_type_id = g_boxed_type_register_static ("ValaScannerConditional", (GBoxedCopyFunc) vala_scanner_conditional_dup, (GBoxedFreeFunc) vala_scanner_conditional_free);
		g_once_init_leave (&vala_scanner_conditional_type_id__volatile, vala_scanner_conditional_type_id);
	}
	return vala_scanner_conditional_type_id__volatile;
}


static void vala_value_scanner_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void vala_value_scanner_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		vala_scanner_unref (value->data[0].v_pointer);
	}
}


static void vala_value_scanner_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_scanner_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer vala_value_scanner_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* vala_value_scanner_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		ValaScanner * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_scanner_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* vala_value_scanner_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ValaScanner ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_scanner_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* vala_param_spec_scanner (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ValaParamSpecScanner* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_TYPE_SCANNER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer vala_value_get_scanner (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_SCANNER), NULL);
	return value->data[0].v_pointer;
}


void vala_value_set_scanner (GValue* value, gpointer v_object) {
	ValaScanner * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_SCANNER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_SCANNER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_scanner_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_scanner_unref (old);
	}
}


void vala_value_take_scanner (GValue* value, gpointer v_object) {
	ValaScanner * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_SCANNER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_SCANNER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_scanner_unref (old);
	}
}


static void vala_scanner_class_init (ValaScannerClass * klass) {
	vala_scanner_parent_class = g_type_class_peek_parent (klass);
	((ValaScannerClass *) klass)->finalize = vala_scanner_finalize;
	g_type_class_add_private (klass, sizeof (ValaScannerPrivate));
}


static void vala_scanner_instance_init (ValaScanner * self) {
	self->priv = VALA_SCANNER_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void vala_scanner_finalize (ValaScanner * obj) {
	ValaScanner * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_SCANNER, ValaScanner);
	g_signal_handlers_destroy (self);
	_vala_source_file_unref0 (self->priv->_source_file);
	_vala_comment_unref0 (self->priv->_comment);
	self->priv->conditional_stack = (g_free (self->priv->conditional_stack), NULL);
	self->priv->state_stack = (g_free (self->priv->state_stack), NULL);
}


/**
 * Lexical scanner for Vala source files.
 */
GType vala_scanner_get_type (void) {
	static volatile gsize vala_scanner_type_id__volatile = 0;
	if (g_once_init_enter (&vala_scanner_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { vala_value_scanner_init, vala_value_scanner_free_value, vala_value_scanner_copy_value, vala_value_scanner_peek_pointer, "p", vala_value_scanner_collect_value, "p", vala_value_scanner_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ValaScannerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_scanner_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaScanner), 0, (GInstanceInitFunc) vala_scanner_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType vala_scanner_type_id;
		vala_scanner_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaScanner", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&vala_scanner_type_id__volatile, vala_scanner_type_id);
	}
	return vala_scanner_type_id__volatile;
}


gpointer vala_scanner_ref (gpointer instance) {
	ValaScanner * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void vala_scanner_unref (gpointer instance) {
	ValaScanner * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_SCANNER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}



