# NMake Makefile portion for displaying config info

INC_FEATURES =
BUILT_TOOLS =
BUILT_LIBRARIES = GXPS

!if "$(CAIRO_PDF)" == "1"
BUILT_TOOLS = xpstopdf.exe $(BUILT_TOOLS)
!endif

build-info-gxps:
	@echo.
	@echo ==================================
	@echo Configuration for GXPS Library
	@echo ==================================

all-build-info: build-info-gxps
	@echo.
	@echo ----------------
	@echo Other build info
	@echo ----------------
	@echo Built Libraries: $(BUILT_LIBRARIES)
	@echo Built Tools: $(BUILT_TOOLS)

help:
	@echo.
	@echo =============================
	@echo Building GXPS Using NMake
	@echo =============================
	@echo nmake /f Makefile.vc CFG=[release^|debug] ^<PREFIX=PATH^> OPTION=1 ...
	@echo.
	@echo Where:
	@echo ------
	@echo CFG: Required, use CFG=release for an optimized build and CFG=debug
	@echo for a debug build.  PDB files are generated for all builds.
	@echo.
	@echo PREFIX: Optional, the path where dependent libraries and tools may be
	@echo found, default is ^$(srcrootdir)\..\vs^$(short_vs_ver)\^$(platform),
	@echo where ^$(short_vs_ver) is 9 for VS 2008, 10 for VS 2010 and so on; and
	@echo ^$(platform) is Win32 for 32-bit builds and x64 for x64 builds.
	@echo.
	@echo LIBTOOL_DLL_NAME:
	@echo Use a libtool-style DLL name to mimic the DLL file naming generated by
	@echo MinGW builds.
	@echo.
	@echo Note that GLib2 support is required for all utility and test programs.
	@echo ======
	@echo A 'clean' target is supported to remove all generated files, intermediate
	@echo object files and binaries for the specified configuration.
	@echo.
	@echo A 'tests' target is supported to build the test programs, if GLib2 support
	@echo is enabled.  Use after building the libraries and utilities.
	@echo.
	@echo An 'install' target is supported to copy the build (DLLs, utility programs,
	@echo LIBs, along with the introspection files if applicable) to appropriate
	@echo locations under ^$(PREFIX).
	@echo ======
	@echo.
	
