// Generated by gmmproc 2.51.2 -- DO NOT MODIFY!


#include <glibmm.h>

#include <gtkmm/container.h>
#include <gtkmm/private/container_p.h>


/* Copyright 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glibmm/vectorutils.h>

#include <gtkmm/adjustment.h>
#include <gtkmm/scrolledwindow.h>
#include <gtk/gtk.h>


namespace
{

// Marks a widget that has been automatically created and added by gtk_container_add().
// The only reason we must use this GQuark or a similar trick, is that we want
// to restore the state of a managed removed object.
// gtk_container_remove() does not do that.
GQuark quark_auto_added_widget = g_quark_from_static_string("gtkmm_Container::auto_added_widget");

static void container_foreach_callback(GtkWidget* widget_gobj, void* data)
{
  try
  {
    const auto & slot = *static_cast<Gtk::Container::ForeachSlot*>(data);
    const auto widget = Glib::wrap(widget_gobj);

    g_return_if_fail(widget != nullptr);

    slot(*widget);
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }
}


//Copy of generated callback:
static void Container_signal_remove_callback_normal(GtkContainer* self, GtkWidget* p0,void* data)
{
  using namespace Gtk;
  typedef sigc::slot<void(Widget*)> SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    try
    {
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Glib::wrap(p0)
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
}

static void Container_signal_remove_callback(GtkContainer* self, GtkWidget* p0, void* data)
{
  //GTKMM_LIFECYCLE

#ifdef GLIBMM_DEBUG_REFCOUNTING
  g_warning("Container_signal_remove_callback()");
#endif

  //Don't call wrap() on a GTK+ instance whose gtkmm instance has been deleted - just call the original C callback.
  const bool gtkmm_child_already_deleted = Glib::_gobject_cppinstance_already_deleted((GObject*)p0);

  if(!gtkmm_child_already_deleted)
  {
    //Call the regular, generated callback:
    Container_signal_remove_callback_normal(self, p0, data);
  }
  else
  {
    //Do nothing.
  }
}

} // anonymous namespace


namespace Gtk
{

//Copy of generated callback:
void Container_Class::remove_callback_normal(GtkContainer* self, GtkWidget* p0)
{
  const auto obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj && obj->is_derived_())
  {
    try // Trap C++ exceptions which would normally be lost because this is a C callback.
    {
      // Call the virtual member method, which derived classes might override.
      obj->on_remove(Glib::wrap(p0)
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

    // Call the original underlying C function:
    if(base && base->remove)
      (*base->remove)(self, p0);
  }
}

//Custom hand-coded callback:
void Container_Class::remove_callback(GtkContainer* self, GtkWidget* p0)
{
  //GTKMM_LIFECYCLE

#ifdef GLIBMM_DEBUG_REFCOUNTING
  g_warning("Container_Class::remove_callback_custom() C self=%p: C child=%p\n", (void*)self, (void*)p0);
  g_warning("gtypename self: %s\n, gtypename child: %s", G_OBJECT_TYPE_NAME(G_OBJECT(self)), G_OBJECT_TYPE_NAME(G_OBJECT(p0)));
#endif

  //Don't call wrap() on a GTK+ instance whose gtkmm instance has been deleted - just call the original C callback.
  const bool gtkmm_child_already_deleted = Glib::_gobject_cppinstance_already_deleted((GObject*)p0);

  if(!gtkmm_child_already_deleted)
  {
    //Call the regular, generated callback:
    Container_Class::remove_callback_normal(self, p0);
  }
  else
  {
    BaseClassType *const base =
      static_cast<BaseClassType*>(g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)));

    // Do not try to call the default implementation of the virtual function
    // GtkContainerClass::remove(), because it unhelpfully informs us that
    // it isn't implemented.  This leaves us with no generic means to check
    // whether it is implemented.
    if(base && G_TYPE_FROM_CLASS(base) != GTK_TYPE_CONTAINER && base->remove)
      (*base->remove)(self, p0);
  }
}

// Custom hand-coded callback:
void Container_Class::forall_vfunc_callback(GtkContainer* self,
  gboolean include_internals, GtkCallback callback, gpointer callback_data)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        if (callback == &container_foreach_callback)
        {
          // This call comes from Container::forall() or Container::foreach(),
          // or is a recursive call. Don't create another slot layer.
          // callback_data is a pointer to a Container::ForeachSlot.
          const auto slot = static_cast<Container::ForeachSlot*>(callback_data);

          // Call the virtual member method, which derived classes might override.
          obj->forall_vfunc(include_internals, *slot);
        }
        else
        {
          // A slot that, when called, will call the callback function with the callback_data.
          Container::ForeachSlot slot = [callback, callback_data](Widget& widget)
                                        { callback(widget.gobj(), callback_data); };

          // Call the virtual member method, which derived classes might override.
          obj->forall_vfunc(include_internals, slot);
        }
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
  );

  // Call the original underlying C function:
  if(base && base->forall)
    (*base->forall)(self, include_internals, callback, callback_data);
}

void Container::foreach(const Container::ForeachSlot& slot)
{
  ForeachSlot slot_copy (slot);
  gtk_container_foreach(gobj(), &container_foreach_callback, &slot_copy);
}

void Container::forall(const Container::ForeachSlot& slot)
{
  ForeachSlot slot_copy (slot);
  gtk_container_forall(gobj(), &container_foreach_callback, &slot_copy);
}

// Why not let both add() and remove() be virtual, and override them in ScrolledWindow?
// Because a virtual add() has an unwanted side-effect in Gtk::Stack.
// See https://bugzilla.gnome.org/show_bug.cgi?id=724732
// And a virtual remove() can be problematic because ScrolledWindow and other
// subclasses of Bin have a remove() overload with no parameter.

void Container::add(Widget& widget)
{
  auto scrolled_window = dynamic_cast<ScrolledWindow*>(this);
  if (scrolled_window)
  {
    auto old_child = gtk_bin_get_child(scrolled_window->Bin::gobj()); // Normally nullptr
    gtk_container_add(gobj(), widget.gobj());
    auto child = gtk_bin_get_child(scrolled_window->Bin::gobj());
    if (child && child != old_child)
    {
      // If the child is not the inserted widget, gtk_scrolled_window_add() has
      // created and inserted a GtkViewport. Mark this GtkViewport as automatically
      // added. Container::remove() needs this information.
      const gpointer qdata_value = (child != widget.gobj()) ? child : nullptr;
      g_object_set_qdata(G_OBJECT(child), quark_auto_added_widget, qdata_value);
    }
  }
  else
    gtk_container_add(gobj(), widget.gobj());
}

bool Container::has_focus_chain() const
{
  return gtk_container_get_focus_chain(const_cast<GtkContainer*>(gobj()), nullptr);
}

std::vector<Widget*> Container::get_focus_chain()
{
  GList* list = nullptr;
  gtk_container_get_focus_chain(gobj(), &list);

  return Glib::ListHandler<Widget*>::list_to_vector(list, Glib::OWNERSHIP_SHALLOW);
}

std::vector<const Widget*> Container::get_focus_chain() const
{
  GList* list = nullptr;
  gtk_container_get_focus_chain(const_cast<GtkContainer*>(gobj()), &list);

  return Glib::ListHandler<const Widget*>::list_to_vector(list, Glib::OWNERSHIP_SHALLOW);
}

void Container::remove(Widget& widget)
{
  auto child_to_float = &widget;
  if (g_object_get_qdata(widget.Glib::Object::gobj(), quark_auto_added_widget))
  {
    // If widget was created by gtk_scrolled_window_add(),
    // don't restore the floating state of that widget. Instead, restore the
    // state of that widget's child, which was added by add().
    auto scrolled_window = dynamic_cast<ScrolledWindow*>(this);
    if (scrolled_window)
    {
      auto bin = dynamic_cast<Bin*>(&widget);
      if (bin)
        child_to_float = bin->get_child();
    }
  }

  // If this is a managed widget, then do an extra ref so that it will not be
  // destroyed when it is removed, and restore the floating state of the ref.
  // This should leave it in the same state as when it was instantiated,
  // before being added to the container.
  if (child_to_float && child_to_float->is_managed_())
  {
    child_to_float->reference();
    g_object_force_floating(child_to_float->Glib::Object::gobj());
  }

  // gtk_container_remove() removes what gtk_container_add() added, even if
  // gtk_container_add() added an extra GtkViewport in a GtkScrolledWindow.
  // See https://bugzilla.gnome.org/show_bug.cgi?id=710471
  gtk_container_remove(gobj(), widget.gobj());
}

} // namespace Gtk

namespace
{


static void Container_signal_add_callback(GtkContainer* self, GtkWidget* p0,void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot<void(Widget*)>;

  auto obj = dynamic_cast<Container*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Glib::wrap(p0)
);
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }
}

static const Glib::SignalProxyInfo Container_signal_add_info =
{
  "add",
  (GCallback) &Container_signal_add_callback,
  (GCallback) &Container_signal_add_callback
};


static const Glib::SignalProxyInfo Container_signal_remove_info =
{
  "remove",
  (GCallback) &Container_signal_remove_callback,
  (GCallback) &Container_signal_remove_callback
};


static const Glib::SignalProxyInfo Container_signal_check_resize_info =
{
  "check_resize",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


static void Container_signal_set_focus_child_callback(GtkContainer* self, GtkWidget* p0,void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot<void(Widget*)>;

  auto obj = dynamic_cast<Container*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Glib::wrap(p0)
);
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }
}

static const Glib::SignalProxyInfo Container_signal_set_focus_child_info =
{
  "set_focus_child",
  (GCallback) &Container_signal_set_focus_child_callback,
  (GCallback) &Container_signal_set_focus_child_callback
};


} // anonymous namespace


namespace Glib
{

Gtk::Container* wrap(GtkContainer* object, bool take_copy)
{
  return dynamic_cast<Gtk::Container *> (Glib::wrap_auto ((GObject*)(object), take_copy));
}

} /* namespace Glib */

namespace Gtk
{


/* The *_Class implementation: */

const Glib::Class& Container_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Class has to know the class init function to clone custom types.
    class_init_func_ = &Container_Class::class_init_function;

    // This is actually just optimized away, apparently with no harm.
    // Make sure that the parent type has been created.
    //CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gtk_container_get_type());

    // Add derived versions of interfaces, if the C type implements any interfaces:

  }

  return *this;
}


void Container_Class::class_init_function(void* g_class, void* class_data)
{
  const auto klass = static_cast<BaseClassType*>(g_class);
  CppClassParent::class_init_function(klass, class_data);

  klass->child_type = &child_type_vfunc_callback;
  klass->forall = &forall_vfunc_callback;
  klass->set_child_property = &set_child_property_vfunc_callback;
  klass->get_child_property = &get_child_property_vfunc_callback;
  klass->get_path_for_child = &get_path_for_child_vfunc_callback;

  klass->add = &add_callback;
  klass->remove = &remove_callback;
  klass->check_resize = &check_resize_callback;
  klass->set_focus_child = &set_focus_child_callback;
  }

GType Container_Class::child_type_vfunc_callback(GtkContainer* self)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        return obj->child_type_vfunc();
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
  );

  // Call the original underlying C function:
  if(base && base->child_type)
    return (*base->child_type)(self);

  using RType = GType;
  return RType();
}
void Container_Class::set_child_property_vfunc_callback(GtkContainer* self, GtkWidget* child, guint property_id, const GValue* value, GParamSpec* pspec)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        obj->set_child_property_vfunc(Glib::wrap(child)
, property_id, *reinterpret_cast<const Glib::ValueBase*>(value)
, pspec);
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
  );

  // Call the original underlying C function:
  if(base && base->set_child_property)
    (*base->set_child_property)(self, child, property_id, value, pspec);
}
void Container_Class::get_child_property_vfunc_callback(GtkContainer* self, GtkWidget* child, guint property_id, GValue* value, GParamSpec* pspec)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        obj->get_child_property_vfunc(Glib::wrap(child)
, property_id, *reinterpret_cast<Glib::ValueBase*>(value)
, pspec);
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
  );

  // Call the original underlying C function:
  if(base && base->get_child_property)
    (*base->get_child_property)(self, child, property_id, value, pspec);
}
GtkWidgetPath* Container_Class::get_path_for_child_vfunc_callback(GtkContainer* self, GtkWidget* child)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        return Glib::unwrap_copy(obj->get_path_for_child_vfunc(Glib::wrap(child)
));
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
  );

  // Call the original underlying C function:
  if(base && base->get_path_for_child)
    return (*base->get_path_for_child)(self, child);

  using RType = GtkWidgetPath*;
  return RType();
}

void Container_Class::add_callback(GtkContainer* self, GtkWidget* p0)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        obj->on_add(Glib::wrap(p0)
);
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->add)
    (*base->add)(self, p0);
}
void Container_Class::check_resize_callback(GtkContainer* self)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        obj->on_check_resize();
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->check_resize)
    (*base->check_resize)(self);
}
void Container_Class::set_focus_child_callback(GtkContainer* self, GtkWidget* p0)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        obj->on_set_focus_child(Glib::wrap(p0)
);
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->set_focus_child)
    (*base->set_focus_child)(self, p0);
}


Glib::ObjectBase* Container_Class::wrap_new(GObject* o)
{
  return manage(new Container((GtkContainer*)(o)));

}


/* The implementation: */

Container::Container(const Glib::ConstructParams& construct_params)
:
  Gtk::Widget(construct_params)
{
  }

Container::Container(GtkContainer* castitem)
:
  Gtk::Widget((GtkWidget*)(castitem))
{
  }


Container::Container(Container&& src) noexcept
: Gtk::Widget(std::move(src))
{}

Container& Container::operator=(Container&& src) noexcept
{
  Gtk::Widget::operator=(std::move(src));
  return *this;
}

Container::~Container() noexcept
{
  destroy_();
}

Container::CppClassType Container::container_class_; // initialize static member

GType Container::get_type()
{
  return container_class_.init().get_type();
}


GType Container::get_base_type()
{
  return gtk_container_get_type();
}


void Container::check_resize()
{
  gtk_container_check_resize(gobj());
}

std::vector<Widget*> Container::get_children()
{
  return Glib::ListHandler<Widget*>::list_to_vector(gtk_container_get_children(gobj()), Glib::OWNERSHIP_SHALLOW);
}

std::vector<const Widget*> Container::get_children() const
{
  return Glib::ListHandler<const Widget*>::list_to_vector(gtk_container_get_children(const_cast<GtkContainer*>(gobj())), Glib::OWNERSHIP_SHALLOW);
}

void Container::propagate_draw(Widget& child, const ::Cairo::RefPtr< ::Cairo::Context>& cr)
{
  gtk_container_propagate_draw(gobj(), (child).gobj(), (cr)->cobj());
}

void Container::set_focus_chain(const std::vector<Widget*>& focusable_widgets)
{
  gtk_container_set_focus_chain(gobj(), Glib::ListHandler<Widget*>::vector_to_list(focusable_widgets).data ());
}

void Container::unset_focus_chain()
{
  gtk_container_unset_focus_chain(gobj());
}

void Container::set_focus_child(Widget& widget)
{
  gtk_container_set_focus_child(gobj(), (widget).gobj());
}

Widget* Container::get_focus_child()
{
  return Glib::wrap(gtk_container_get_focus_child(gobj()));
}

const Widget* Container::get_focus_child() const
{
  return const_cast<Container*>(this)->get_focus_child();
}

void Container::set_focus_vadjustment(const Glib::RefPtr<Adjustment>& adjustment)
{
  gtk_container_set_focus_vadjustment(gobj(), Glib::unwrap(adjustment));
}

Glib::RefPtr<Adjustment> Container::get_focus_vadjustment()
{
  Glib::RefPtr<Adjustment> retvalue = Glib::wrap(gtk_container_get_focus_vadjustment(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<const Adjustment> Container::get_focus_vadjustment() const
{
  return const_cast<Container*>(this)->get_focus_vadjustment();
}

void Container::set_focus_hadjustment(const Glib::RefPtr<Adjustment>& adjustment)
{
  gtk_container_set_focus_hadjustment(gobj(), Glib::unwrap(adjustment));
}

Glib::RefPtr<Adjustment> Container::get_focus_hadjustment()
{
  Glib::RefPtr<Adjustment> retvalue = Glib::wrap(gtk_container_get_focus_hadjustment(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<const Adjustment> Container::get_focus_hadjustment() const
{
  return const_cast<Container*>(this)->get_focus_hadjustment();
}

GType Container::child_type() const
{
  return gtk_container_child_type(const_cast<GtkContainer*>(gobj()));
}

WidgetPath Container::get_path_for_child(const Widget& child) const
{
  return Glib::wrap(gtk_container_get_path_for_child(const_cast<GtkContainer*>(gobj()), const_cast<GtkWidget*>((child).gobj())), false);
}

Container::Container()
:
  // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(nullptr),
  Gtk::Widget(Glib::ConstructParams(container_class_.init()))
{
  

}


Glib::SignalProxy<void(Widget*)> Container::signal_add()
{
  return Glib::SignalProxy<void(Widget*) >(this, &Container_signal_add_info);
}


Glib::SignalProxy<void(Widget*)> Container::signal_remove()
{
  return Glib::SignalProxy<void(Widget*) >(this, &Container_signal_remove_info);
}


Glib::SignalProxy<void()> Container::signal_check_resize()
{
  return Glib::SignalProxy<void() >(this, &Container_signal_check_resize_info);
}


Glib::SignalProxy<void(Widget*)> Container::signal_set_focus_child()
{
  return Glib::SignalProxy<void(Widget*) >(this, &Container_signal_set_focus_child_info);
}


void Gtk::Container::on_add(Widget* widget)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->add)
    (*base->add)(gobj(),(GtkWidget*)Glib::unwrap(widget));
}
void Gtk::Container::on_remove(Widget* widget)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->remove)
    (*base->remove)(gobj(),(GtkWidget*)Glib::unwrap(widget));
}
void Gtk::Container::on_check_resize()
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->check_resize)
    (*base->check_resize)(gobj());
}
void Gtk::Container::on_set_focus_child(Widget* widget)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->set_focus_child)
    (*base->set_focus_child)(gobj(),(GtkWidget*)Glib::unwrap(widget));
}

GType Gtk::Container::child_type_vfunc() const
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->child_type)
  {
    GType retval((*base->child_type)(const_cast<GtkContainer*>(gobj())));
    return retval;
  }

  using RType = GType;
  return RType();
}
void Gtk::Container::forall_vfunc(bool include_internals, const ForeachSlot& slot) 
{
  // Use the original slot (not a copy).
  auto slot_copy = const_cast<ForeachSlot*>(&slot);

  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->forall)
  {
    (*base->forall)(gobj(),static_cast<int>(include_internals),&container_foreach_callback,slot_copy);
  }
}
void Gtk::Container::set_child_property_vfunc(Widget* child, guint property_id, const Glib::ValueBase& value, GParamSpec* pspec) 
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->set_child_property)
  {
    (*base->set_child_property)(gobj(),(GtkWidget*)Glib::unwrap(child),property_id,(value).gobj(),pspec);
  }
}
void Gtk::Container::get_child_property_vfunc(const Widget* child, guint property_id, Glib::ValueBase& value, GParamSpec* pspec) const
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->get_child_property)
  {
    (*base->get_child_property)(const_cast<GtkContainer*>(gobj()),const_cast<GtkWidget*>(Glib::unwrap(child)),property_id,(value).gobj(),pspec);
  }
}
WidgetPath Gtk::Container::get_path_for_child_vfunc(const Widget* child) const
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->get_path_for_child)
  {
    WidgetPath retval(Glib::wrap((*base->get_path_for_child)(const_cast<GtkContainer*>(gobj()),const_cast<GtkWidget*>(Glib::unwrap(child))), false));
    return retval;
  }

  using RType = WidgetPath;
  return RType();
}


} // namespace Gtk


