/* persona-store-tests.c generated by valac 0.26.2.1-1f25, the Vala compiler
 * generated from persona-store-tests.vala, do not modify */

/*
 * Copyright (C) 2011, 2015 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: Raul Gutierrez Segales <raul.gutierrez.segales@collabora.co.uk>
 *          Philip Withnall <philip.withnall@collabora.co.uk>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <eds-test.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <folks-test.h>
#include <folks/folks.h>
#include <folks/folks-eds.h>
#include <gio/gio.h>


#define TYPE_PERSONA_STORE_TESTS (persona_store_tests_get_type ())
#define PERSONA_STORE_TESTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PERSONA_STORE_TESTS, PersonaStoreTests))
#define PERSONA_STORE_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PERSONA_STORE_TESTS, PersonaStoreTestsClass))
#define IS_PERSONA_STORE_TESTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PERSONA_STORE_TESTS))
#define IS_PERSONA_STORE_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PERSONA_STORE_TESTS))
#define PERSONA_STORE_TESTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PERSONA_STORE_TESTS, PersonaStoreTestsClass))

typedef struct _PersonaStoreTests PersonaStoreTests;
typedef struct _PersonaStoreTestsClass PersonaStoreTestsClass;
typedef struct _PersonaStoreTestsPrivate PersonaStoreTestsPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define __vala_GValue_free0(var) ((var == NULL) ? NULL : (var = (_vala_GValue_free (var), NULL)))
typedef struct _Block2Data Block2Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _PersonaStoreTests {
	EdsTestTestCase parent_instance;
	PersonaStoreTestsPrivate * priv;
};

struct _PersonaStoreTestsClass {
	EdsTestTestCaseClass parent_class;
};

struct _PersonaStoreTestsPrivate {
	GeeHashSet* _capabilities_received;
	GMainLoop* _main_loop;
	guint _callbacks_received;
};

struct _Block1Data {
	int _ref_count_;
	PersonaStoreTests* self;
	FolksBackendStore* backend_store;
};

struct _Block2Data {
	int _ref_count_;
	PersonaStoreTests* self;
	FolksPersonaStore* store;
};


static gpointer persona_store_tests_parent_class = NULL;

GType persona_store_tests_get_type (void) G_GNUC_CONST;
#define PERSONA_STORE_TESTS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PERSONA_STORE_TESTS, PersonaStoreTestsPrivate))
enum  {
	PERSONA_STORE_TESTS_DUMMY_PROPERTY
};
PersonaStoreTests* persona_store_tests_new (void);
PersonaStoreTests* persona_store_tests_construct (GType object_type);
void persona_store_tests_test_persona_store (PersonaStoreTests* self);
static void _persona_store_tests_test_persona_store_folks_test_case_test_method (gpointer self);
static void persona_store_tests_real_set_up (FolksTestCase* base);
static void persona_store_tests_real_tear_down (FolksTestCase* base);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static GValue* _g_value_dup (GValue* self);
static void _vala_GValue_free (GValue* self);
static void __lambda4_ (Block1Data* _data1_, GObject* o, GAsyncResult* r);
static void ___lambda4__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void __lambda5_ (PersonaStoreTests* self, FolksBackend* b);
static void ___lambda6_ (PersonaStoreTests* self, FolksPersonaStore* ps);
static void _persona_store_tests_set_up_persona_store (PersonaStoreTests* self, FolksPersonaStore* store);
static void ____lambda6__folks_backend_persona_store_added (FolksBackend* _sender, FolksPersonaStore* store, gpointer self);
static void ___lambda5__folks_backend_store_backend_available (FolksBackendStore* _sender, FolksBackend* backend, gpointer self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void __lambda7_ (Block2Data* _data2_, GObject* obj, GAsyncResult* _result_);
static void _persona_store_tests_can_add_personas_cb (PersonaStoreTests* self, GObject* s, GParamSpec* p);
static void __persona_store_tests_can_add_personas_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _persona_store_tests_can_remove_personas_cb (PersonaStoreTests* self, GObject* s, GParamSpec* p);
static void __persona_store_tests_can_remove_personas_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _persona_store_tests_check_can_alias_personas (PersonaStoreTests* self, GObject* s, GParamSpec* p);
static void _persona_store_tests_check_can_group_personas (PersonaStoreTests* self, GObject* s, GParamSpec* p);
static void ___lambda7__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle);
static void persona_store_tests_finalize (GObject* obj);
gint _vala_main (gchar** args, int args_length1);


static void _persona_store_tests_test_persona_store_folks_test_case_test_method (gpointer self) {
#line 35 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	persona_store_tests_test_persona_store ((PersonaStoreTests*) self);
#line 126 "persona-store-tests.c"
}


PersonaStoreTests* persona_store_tests_construct (GType object_type) {
	PersonaStoreTests * self = NULL;
#line 34 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	self = (PersonaStoreTests*) eds_test_test_case_construct (object_type, "PersonaStoreTests");
#line 35 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	folks_test_case_add_test ((FolksTestCase*) self, "persona store tests", _persona_store_tests_test_persona_store_folks_test_case_test_method, g_object_ref (self), g_object_unref);
#line 32 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	return self;
#line 138 "persona-store-tests.c"
}


PersonaStoreTests* persona_store_tests_new (void) {
#line 32 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	return persona_store_tests_construct (TYPE_PERSONA_STORE_TESTS);
#line 145 "persona-store-tests.c"
}


static void persona_store_tests_real_set_up (FolksTestCase* base) {
	PersonaStoreTests * self;
	GeeHashSet* _tmp0_ = NULL;
#line 38 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	self = (PersonaStoreTests*) base;
#line 40 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	FOLKS_TEST_CASE_CLASS (persona_store_tests_parent_class)->set_up ((FolksTestCase*) G_TYPE_CHECK_INSTANCE_CAST (self, EDS_TEST_TYPE_TEST_CASE, EdsTestTestCase));
#line 41 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_tmp0_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL, NULL, NULL, NULL);
#line 41 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_g_object_unref0 (self->priv->_capabilities_received);
#line 41 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	self->priv->_capabilities_received = _tmp0_;
#line 162 "persona-store-tests.c"
}


static void persona_store_tests_real_tear_down (FolksTestCase* base) {
	PersonaStoreTests * self;
#line 44 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	self = (PersonaStoreTests*) base;
#line 46 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_g_object_unref0 (self->priv->_capabilities_received);
#line 46 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	self->priv->_capabilities_received = NULL;
#line 47 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	FOLKS_TEST_CASE_CLASS (persona_store_tests_parent_class)->tear_down ((FolksTestCase*) G_TYPE_CHECK_INSTANCE_CAST (self, EDS_TEST_TYPE_TEST_CASE, EdsTestTestCase));
#line 176 "persona-store-tests.c"
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
#line 50 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	g_atomic_int_inc (&_data1_->_ref_count_);
#line 50 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	return _data1_;
#line 185 "persona-store-tests.c"
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
#line 50 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
#line 194 "persona-store-tests.c"
		PersonaStoreTests* self;
#line 50 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
		self = _data1_->self;
#line 50 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
		_g_object_unref0 (_data1_->backend_store);
#line 50 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
		_g_object_unref0 (self);
#line 50 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
		g_slice_free (Block1Data, _data1_);
#line 204 "persona-store-tests.c"
	}
}


static GValue* _g_value_dup (GValue* self) {
#line 52 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	return g_boxed_copy (G_TYPE_VALUE, self);
#line 212 "persona-store-tests.c"
}


static void _vala_GValue_free (GValue* self) {
#line 52 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	g_value_unset (self);
#line 52 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	g_free (self);
#line 221 "persona-store-tests.c"
}


static gpointer __g_value_dup0 (gpointer self) {
#line 59 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	return self ? _g_value_dup (self) : NULL;
#line 228 "persona-store-tests.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 65 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	return self ? g_object_ref (self) : NULL;
#line 235 "persona-store-tests.c"
}


static void __lambda4_ (Block1Data* _data1_, GObject* o, GAsyncResult* r) {
	PersonaStoreTests* self;
	GAsyncResult* _tmp0_ = NULL;
#line 78 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	self = _data1_->self;
#line 78 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	g_return_if_fail (r != NULL);
#line 80 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_tmp0_ = r;
#line 80 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	folks_backend_store_prepare_finish (_data1_->backend_store, _tmp0_);
#line 250 "persona-store-tests.c"
}


static void ___lambda4__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 78 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	__lambda4_ (self, source_object, res);
#line 78 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	block1_data_unref (self);
#line 259 "persona-store-tests.c"
}


static void ___lambda6_ (PersonaStoreTests* self, FolksPersonaStore* ps) {
	FolksPersonaStore* _tmp0_ = NULL;
#line 86 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	g_return_if_fail (ps != NULL);
#line 88 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_tmp0_ = ps;
#line 88 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_persona_store_tests_set_up_persona_store (self, _tmp0_);
#line 271 "persona-store-tests.c"
}


static void ____lambda6__folks_backend_persona_store_added (FolksBackend* _sender, FolksPersonaStore* store, gpointer self) {
#line 86 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	___lambda6_ ((PersonaStoreTests*) self, store);
#line 278 "persona-store-tests.c"
}


static void __lambda5_ (PersonaStoreTests* self, FolksBackend* b) {
	FolksBackend* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
#line 82 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	g_return_if_fail (b != NULL);
#line 84 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_tmp0_ = b;
#line 84 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_tmp1_ = folks_backend_get_name (_tmp0_);
#line 84 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_tmp2_ = _tmp1_;
#line 84 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	if (g_strcmp0 (_tmp2_, "eds") == 0) {
#line 296 "persona-store-tests.c"
		FolksBackend* _tmp3_ = NULL;
#line 86 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
		_tmp3_ = b;
#line 86 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
		g_signal_connect_object (_tmp3_, "persona-store-added", (GCallback) ____lambda6__folks_backend_persona_store_added, self, 0);
#line 302 "persona-store-tests.c"
		{
			GeeIterator* _store_it = NULL;
			FolksBackend* _tmp4_ = NULL;
			GeeMap* _tmp5_ = NULL;
			GeeMap* _tmp6_ = NULL;
			GeeCollection* _tmp7_ = NULL;
			GeeCollection* _tmp8_ = NULL;
			GeeCollection* _tmp9_ = NULL;
			GeeIterator* _tmp10_ = NULL;
			GeeIterator* _tmp11_ = NULL;
#line 91 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
			_tmp4_ = b;
#line 91 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
			_tmp5_ = folks_backend_get_persona_stores (_tmp4_);
#line 91 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
			_tmp6_ = _tmp5_;
#line 91 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
			_tmp7_ = gee_map_get_values (_tmp6_);
#line 91 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
			_tmp8_ = _tmp7_;
#line 91 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
			_tmp9_ = _tmp8_;
#line 91 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
			_tmp10_ = gee_iterable_iterator ((GeeIterable*) _tmp9_);
#line 91 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
			_tmp11_ = _tmp10_;
#line 91 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
			_g_object_unref0 (_tmp9_);
#line 91 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
			_store_it = _tmp11_;
#line 91 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
			while (TRUE) {
#line 335 "persona-store-tests.c"
				GeeIterator* _tmp12_ = NULL;
				gboolean _tmp13_ = FALSE;
				FolksPersonaStore* store = NULL;
				GeeIterator* _tmp14_ = NULL;
				gpointer _tmp15_ = NULL;
				FolksPersonaStore* _tmp16_ = NULL;
#line 91 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
				_tmp12_ = _store_it;
#line 91 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
				_tmp13_ = gee_iterator_next (_tmp12_);
#line 91 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
				if (!_tmp13_) {
#line 91 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
					break;
#line 350 "persona-store-tests.c"
				}
#line 91 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
				_tmp14_ = _store_it;
#line 91 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
				_tmp15_ = gee_iterator_get (_tmp14_);
#line 91 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
				store = (FolksPersonaStore*) _tmp15_;
#line 93 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
				_tmp16_ = store;
#line 93 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
				_persona_store_tests_set_up_persona_store (self, _tmp16_);
#line 91 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
				_g_object_unref0 (store);
#line 364 "persona-store-tests.c"
			}
#line 91 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
			_g_object_unref0 (_store_it);
#line 368 "persona-store-tests.c"
		}
	}
}


static void ___lambda5__folks_backend_store_backend_available (FolksBackendStore* _sender, FolksBackend* backend, gpointer self) {
#line 82 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	__lambda5_ ((PersonaStoreTests*) self, backend);
#line 377 "persona-store-tests.c"
}


void persona_store_tests_test_persona_store (PersonaStoreTests* self) {
	Block1Data* _data1_;
	GeeHashMap* c1 = NULL;
	GeeHashMap* _tmp0_ = NULL;
	GeeHashMap* c2 = NULL;
	GeeHashMap* _tmp1_ = NULL;
	GMainLoop* _tmp2_ = NULL;
	GValue* v = NULL;
	EdsTestBackend* _tmp3_ = NULL;
	GValue _tmp4_ = {0};
	GValue _tmp5_ = {0};
	GValue* _tmp6_ = NULL;
	GValue* _tmp7_ = NULL;
	GValue* _tmp8_ = NULL;
	GValue* _tmp9_ = NULL;
	GValue _tmp10_ = {0};
	GValue _tmp11_ = {0};
	GValue* _tmp12_ = NULL;
	GValue* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	GValue* _tmp15_ = NULL;
	GValue* _tmp16_ = NULL;
	EdsTestBackend* _tmp17_ = NULL;
	GeeHashMap* _tmp18_ = NULL;
	GValue _tmp19_ = {0};
	GValue _tmp20_ = {0};
	GValue* _tmp21_ = NULL;
	GValue* _tmp22_ = NULL;
	GValue* _tmp23_ = NULL;
	GValue* _tmp24_ = NULL;
	GValue _tmp25_ = {0};
	GValue _tmp26_ = {0};
	GValue* _tmp27_ = NULL;
	GValue* _tmp28_ = NULL;
	const gchar* _tmp29_ = NULL;
	GValue* _tmp30_ = NULL;
	GValue* _tmp31_ = NULL;
	EdsTestBackend* _tmp32_ = NULL;
	GeeHashMap* _tmp33_ = NULL;
	FolksBackendStore* _tmp34_ = NULL;
	GMainLoop* _tmp35_ = NULL;
	GeeHashSet* _tmp36_ = NULL;
	gboolean _tmp37_ = FALSE;
	GeeHashSet* _tmp38_ = NULL;
	gboolean _tmp39_ = FALSE;
	GeeHashSet* _tmp40_ = NULL;
	gboolean _tmp41_ = FALSE;
	GeeHashSet* _tmp42_ = NULL;
	gboolean _tmp43_ = FALSE;
	EdsTestBackend* _tmp44_ = NULL;
#line 50 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	g_return_if_fail (self != NULL);
#line 50 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_data1_ = g_slice_new0 (Block1Data);
#line 50 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_data1_->_ref_count_ = 1;
#line 50 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_data1_->self = g_object_ref (self);
#line 52 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_VALUE, (GBoxedCopyFunc) _g_value_dup, _vala_GValue_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 52 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	c1 = _tmp0_;
#line 53 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_VALUE, (GBoxedCopyFunc) _g_value_dup, _vala_GValue_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 53 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	c2 = _tmp1_;
#line 54 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_tmp2_ = g_main_loop_new (NULL, FALSE);
#line 54 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_g_main_loop_unref0 (self->priv->_main_loop);
#line 54 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	self->priv->_main_loop = _tmp2_;
#line 57 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_tmp3_ = ((EdsTestTestCase*) self)->eds_backend;
#line 57 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	eds_test_backend_reset (_tmp3_);
#line 59 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	g_value_init (&_tmp4_, G_TYPE_STRING);
#line 59 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_tmp5_ = _tmp4_;
#line 59 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_tmp6_ = __g_value_dup0 (&_tmp5_);
#line 59 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	__vala_GValue_free0 (v);
#line 59 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	v = _tmp6_;
#line 59 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	G_IS_VALUE (&_tmp5_) ? (g_value_unset (&_tmp5_), NULL) : NULL;
#line 60 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_tmp7_ = v;
#line 60 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	g_value_set_string (_tmp7_, "bernie h. innocenti");
#line 61 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_tmp8_ = v;
#line 61 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	v = NULL;
#line 61 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_tmp9_ = _tmp8_;
#line 61 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	gee_abstract_map_set ((GeeAbstractMap*) c1, "full_name", _tmp9_);
#line 61 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	__vala_GValue_free0 (_tmp9_);
#line 62 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	g_value_init (&_tmp10_, G_TYPE_STRING);
#line 62 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_tmp11_ = _tmp10_;
#line 62 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_tmp12_ = __g_value_dup0 (&_tmp11_);
#line 62 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	__vala_GValue_free0 (v);
#line 62 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	v = _tmp12_;
#line 62 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	G_IS_VALUE (&_tmp11_) ? (g_value_unset (&_tmp11_), NULL) : NULL;
#line 63 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_tmp13_ = v;
#line 63 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	g_value_set_string (_tmp13_, "bernie@example.org");
#line 64 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_tmp14_ = EDSF_PERSONA_email_fields[0];
#line 64 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_tmp15_ = v;
#line 64 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	v = NULL;
#line 64 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_tmp16_ = _tmp15_;
#line 64 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	gee_abstract_map_set ((GeeAbstractMap*) c1, _tmp14_, _tmp16_);
#line 64 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	__vala_GValue_free0 (_tmp16_);
#line 65 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_tmp17_ = ((EdsTestTestCase*) self)->eds_backend;
#line 65 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_tmp18_ = _g_object_ref0 (c1);
#line 65 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	eds_test_backend_add_contact (_tmp17_, _tmp18_);
#line 67 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	g_value_init (&_tmp19_, G_TYPE_STRING);
#line 67 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_tmp20_ = _tmp19_;
#line 67 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_tmp21_ = __g_value_dup0 (&_tmp20_);
#line 67 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	__vala_GValue_free0 (v);
#line 67 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	v = _tmp21_;
#line 67 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	G_IS_VALUE (&_tmp20_) ? (g_value_unset (&_tmp20_), NULL) : NULL;
#line 68 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_tmp22_ = v;
#line 68 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	g_value_set_string (_tmp22_, "richard m. stallman");
#line 69 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_tmp23_ = v;
#line 69 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	v = NULL;
#line 69 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_tmp24_ = _tmp23_;
#line 69 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	gee_abstract_map_set ((GeeAbstractMap*) c2, "full_name", _tmp24_);
#line 69 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	__vala_GValue_free0 (_tmp24_);
#line 70 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	g_value_init (&_tmp25_, G_TYPE_STRING);
#line 70 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_tmp26_ = _tmp25_;
#line 70 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_tmp27_ = __g_value_dup0 (&_tmp26_);
#line 70 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	__vala_GValue_free0 (v);
#line 70 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	v = _tmp27_;
#line 70 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	G_IS_VALUE (&_tmp26_) ? (g_value_unset (&_tmp26_), NULL) : NULL;
#line 71 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_tmp28_ = v;
#line 71 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	g_value_set_string (_tmp28_, "rms@example.org");
#line 72 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_tmp29_ = EDSF_PERSONA_email_fields[0];
#line 72 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_tmp30_ = v;
#line 72 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	v = NULL;
#line 72 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_tmp31_ = _tmp30_;
#line 72 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	gee_abstract_map_set ((GeeAbstractMap*) c2, _tmp29_, _tmp31_);
#line 72 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	__vala_GValue_free0 (_tmp31_);
#line 73 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_tmp32_ = ((EdsTestTestCase*) self)->eds_backend;
#line 73 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_tmp33_ = _g_object_ref0 (c2);
#line 73 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	eds_test_backend_add_contact (_tmp32_, _tmp33_);
#line 75 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	self->priv->_callbacks_received = (guint) 0;
#line 77 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_tmp34_ = folks_backend_store_dup ();
#line 77 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_data1_->backend_store = _tmp34_;
#line 78 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	folks_backend_store_prepare (_data1_->backend_store, ___lambda4__gasync_ready_callback, block1_data_ref (_data1_));
#line 82 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	g_signal_connect_object (_data1_->backend_store, "backend-available", (GCallback) ___lambda5__folks_backend_store_backend_available, self, 0);
#line 99 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	folks_backend_store_load_backends (_data1_->backend_store, NULL, NULL);
#line 101 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_tmp35_ = self->priv->_main_loop;
#line 101 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	folks_test_utils_loop_run_with_timeout (_tmp35_, 5);
#line 103 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_tmp36_ = self->priv->_capabilities_received;
#line 103 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_tmp37_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp36_, "can-add-personas");
#line 103 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_vala_assert (_tmp37_, "this._capabilities_received.contains (\"can-add-personas\")");
#line 104 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_tmp38_ = self->priv->_capabilities_received;
#line 104 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_tmp39_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp38_, "can-remove-personas");
#line 104 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_vala_assert (_tmp39_, "this._capabilities_received.contains (\"can-remove-personas\")");
#line 105 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_tmp40_ = self->priv->_capabilities_received;
#line 105 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_tmp41_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp40_, "can-alias-personas");
#line 105 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_vala_assert (!_tmp41_, "!this._capabilities_received.contains (\"can-alias-personas\")");
#line 106 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_tmp42_ = self->priv->_capabilities_received;
#line 106 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_tmp43_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp42_, "can-group-personas");
#line 106 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_vala_assert (_tmp43_, "this._capabilities_received.contains (\"can-group-personas\")");
#line 108 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_tmp44_ = ((EdsTestTestCase*) self)->eds_backend;
#line 108 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	eds_test_backend_tear_down (_tmp44_);
#line 50 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	__vala_GValue_free0 (v);
#line 50 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_g_object_unref0 (c2);
#line 50 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_g_object_unref0 (c1);
#line 50 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	block1_data_unref (_data1_);
#line 50 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_data1_ = NULL;
#line 631 "persona-store-tests.c"
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
#line 111 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	g_atomic_int_inc (&_data2_->_ref_count_);
#line 111 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	return _data2_;
#line 640 "persona-store-tests.c"
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
#line 111 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
#line 649 "persona-store-tests.c"
		PersonaStoreTests* self;
#line 111 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
		self = _data2_->self;
#line 111 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
		_g_object_unref0 (_data2_->store);
#line 111 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
		_g_object_unref0 (self);
#line 111 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
		g_slice_free (Block2Data, _data2_);
#line 659 "persona-store-tests.c"
	}
}


static void __persona_store_tests_can_add_personas_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 122 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_persona_store_tests_can_add_personas_cb ((PersonaStoreTests*) self, _sender, pspec);
#line 667 "persona-store-tests.c"
}


static void __persona_store_tests_can_remove_personas_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 128 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_persona_store_tests_can_remove_personas_cb ((PersonaStoreTests*) self, _sender, pspec);
#line 674 "persona-store-tests.c"
}


static void __lambda7_ (Block2Data* _data2_, GObject* obj, GAsyncResult* _result_) {
	PersonaStoreTests* self;
	GError * _inner_error_ = NULL;
#line 113 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	self = _data2_->self;
#line 113 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	g_return_if_fail (_result_ != NULL);
#line 685 "persona-store-tests.c"
	{
		FolksPersonaStore* _tmp0_ = NULL;
		GAsyncResult* _tmp1_ = NULL;
		FolksPersonaStore* _tmp2_ = NULL;
		FolksMaybeBool _tmp3_ = 0;
		FolksMaybeBool _tmp4_ = 0;
		FolksPersonaStore* _tmp7_ = NULL;
		FolksMaybeBool _tmp8_ = 0;
		FolksMaybeBool _tmp9_ = 0;
		FolksPersonaStore* _tmp12_ = NULL;
		FolksPersonaStore* _tmp13_ = NULL;
		guint _tmp14_ = 0U;
#line 117 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
		_tmp0_ = _data2_->store;
#line 117 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
		_tmp1_ = _result_;
#line 117 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
		folks_persona_store_prepare_finish (_tmp0_, _tmp1_, &_inner_error_);
#line 117 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 706 "persona-store-tests.c"
			goto __catch0_g_error;
		}
#line 119 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
		_tmp2_ = _data2_->store;
#line 119 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
		_tmp3_ = folks_persona_store_get_can_add_personas (_tmp2_);
#line 119 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
		_tmp4_ = _tmp3_;
#line 119 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
		if (_tmp4_ != FOLKS_MAYBE_BOOL_UNSET) {
#line 717 "persona-store-tests.c"
			FolksPersonaStore* _tmp5_ = NULL;
#line 120 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
			_tmp5_ = _data2_->store;
#line 120 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
			_persona_store_tests_can_add_personas_cb (self, (GObject*) _tmp5_, NULL);
#line 723 "persona-store-tests.c"
		} else {
			FolksPersonaStore* _tmp6_ = NULL;
#line 122 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
			_tmp6_ = _data2_->store;
#line 122 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
			g_signal_connect_object ((GObject*) _tmp6_, "notify::can-add-personas", (GCallback) __persona_store_tests_can_add_personas_cb_g_object_notify, self, 0);
#line 730 "persona-store-tests.c"
		}
#line 125 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
		_tmp7_ = _data2_->store;
#line 125 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
		_tmp8_ = folks_persona_store_get_can_remove_personas (_tmp7_);
#line 125 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
		_tmp9_ = _tmp8_;
#line 125 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
		if (_tmp9_ != FOLKS_MAYBE_BOOL_UNSET) {
#line 740 "persona-store-tests.c"
			FolksPersonaStore* _tmp10_ = NULL;
#line 126 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
			_tmp10_ = _data2_->store;
#line 126 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
			_persona_store_tests_can_remove_personas_cb (self, (GObject*) _tmp10_, NULL);
#line 746 "persona-store-tests.c"
		} else {
			FolksPersonaStore* _tmp11_ = NULL;
#line 128 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
			_tmp11_ = _data2_->store;
#line 128 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
			g_signal_connect_object ((GObject*) _tmp11_, "notify::can-remove-personas", (GCallback) __persona_store_tests_can_remove_personas_cb_g_object_notify, self, 0);
#line 753 "persona-store-tests.c"
		}
#line 131 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
		_tmp12_ = _data2_->store;
#line 131 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
		_persona_store_tests_check_can_alias_personas (self, (GObject*) _tmp12_, NULL);
#line 132 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
		_tmp13_ = _data2_->store;
#line 132 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
		_persona_store_tests_check_can_group_personas (self, (GObject*) _tmp13_, NULL);
#line 134 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
		_tmp14_ = self->priv->_callbacks_received;
#line 134 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
		if (_tmp14_ == ((guint) 4)) {
#line 767 "persona-store-tests.c"
			GMainLoop* _tmp15_ = NULL;
#line 135 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
			_tmp15_ = self->priv->_main_loop;
#line 135 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
			g_main_loop_quit (_tmp15_);
#line 773 "persona-store-tests.c"
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		FolksPersonaStore* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
		FolksPersonaStore* _tmp19_ = NULL;
		const gchar* _tmp20_ = NULL;
		const gchar* _tmp21_ = NULL;
		GError* _tmp22_ = NULL;
		const gchar* _tmp23_ = NULL;
#line 115 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
		e = _inner_error_;
#line 115 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
		_inner_error_ = NULL;
#line 139 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
		_tmp16_ = _data2_->store;
#line 139 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
		_tmp17_ = folks_persona_store_get_type_id (_tmp16_);
#line 139 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
		_tmp18_ = _tmp17_;
#line 139 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
		_tmp19_ = _data2_->store;
#line 139 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
		_tmp20_ = folks_persona_store_get_id (_tmp19_);
#line 139 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
		_tmp21_ = _tmp20_;
#line 139 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
		_tmp22_ = e;
#line 139 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
		_tmp23_ = _tmp22_->message;
#line 139 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
		g_warning ("Error preparing PersonaStore type: %s, id: %s: " "'%s'", _tmp18_, _tmp21_, _tmp23_);
#line 115 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
		_g_error_free0 (e);
#line 812 "persona-store-tests.c"
	}
	__finally0:
#line 115 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 115 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 115 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
		g_clear_error (&_inner_error_);
#line 115 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
		return;
#line 823 "persona-store-tests.c"
	}
}


static void ___lambda7__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 113 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	__lambda7_ (self, source_object, res);
#line 113 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	block2_data_unref (self);
#line 833 "persona-store-tests.c"
}


static void _persona_store_tests_set_up_persona_store (PersonaStoreTests* self, FolksPersonaStore* store) {
	Block2Data* _data2_;
	FolksPersonaStore* _tmp0_ = NULL;
	FolksPersonaStore* _tmp1_ = NULL;
	FolksPersonaStore* _tmp2_ = NULL;
#line 111 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	g_return_if_fail (self != NULL);
#line 111 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	g_return_if_fail (store != NULL);
#line 111 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_data2_ = g_slice_new0 (Block2Data);
#line 111 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_data2_->_ref_count_ = 1;
#line 111 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_data2_->self = g_object_ref (self);
#line 111 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_tmp0_ = store;
#line 111 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 111 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_g_object_unref0 (_data2_->store);
#line 111 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_data2_->store = _tmp1_;
#line 113 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_tmp2_ = _data2_->store;
#line 113 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	folks_persona_store_prepare (_tmp2_, ___lambda7__gasync_ready_callback, block2_data_ref (_data2_));
#line 111 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	block2_data_unref (_data2_);
#line 111 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_data2_ = NULL;
#line 868 "persona-store-tests.c"
}


static void _persona_store_tests_can_add_personas_cb (PersonaStoreTests* self, GObject* s, GParamSpec* p) {
	GObject* _tmp0_ = NULL;
	EdsfPersonaStore* store = NULL;
	GObject* _tmp1_ = NULL;
	EdsfPersonaStore* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	EdsfPersonaStore* _tmp4_ = NULL;
	FolksMaybeBool _tmp5_ = 0;
	FolksMaybeBool _tmp6_ = 0;
	guint _tmp14_ = 0U;
#line 145 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	g_return_if_fail (self != NULL);
#line 145 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	g_return_if_fail (s != NULL);
#line 147 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_tmp0_ = s;
#line 147 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_vala_assert (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, EDSF_TYPE_PERSONA_STORE), "s is Edsf.PersonaStore");
#line 148 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_tmp1_ = s;
#line 148 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, EDSF_TYPE_PERSONA_STORE, EdsfPersonaStore));
#line 148 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	store = _tmp2_;
#line 149 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_tmp3_ = self->priv->_callbacks_received;
#line 149 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	self->priv->_callbacks_received = _tmp3_ + 1;
#line 151 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_tmp4_ = store;
#line 151 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_tmp5_ = folks_persona_store_get_can_add_personas ((FolksPersonaStore*) _tmp4_);
#line 151 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_tmp6_ = _tmp5_;
#line 151 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	if (_tmp6_ != FOLKS_MAYBE_BOOL_UNSET) {
#line 908 "persona-store-tests.c"
		EdsfPersonaStore* _tmp7_ = NULL;
		FolksMaybeBool _tmp8_ = 0;
		FolksMaybeBool _tmp9_ = 0;
		GeeHashSet* _tmp10_ = NULL;
		EdsfPersonaStore* _tmp11_ = NULL;
		guint _tmp12_ = 0U;
		GQuark _tmp13_ = 0U;
#line 153 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
		_tmp7_ = store;
#line 153 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
		_tmp8_ = folks_persona_store_get_can_add_personas ((FolksPersonaStore*) _tmp7_);
#line 153 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
		_tmp9_ = _tmp8_;
#line 153 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
		_vala_assert (_tmp9_ == FOLKS_MAYBE_BOOL_TRUE, "store.can_add_personas == MaybeBool.TRUE");
#line 155 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
		_tmp10_ = self->priv->_capabilities_received;
#line 155 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp10_, "can-add-personas");
#line 157 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
		_tmp11_ = store;
#line 157 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
		g_signal_parse_name ("notify::can-add-personas", G_TYPE_OBJECT, &_tmp12_, &_tmp13_, TRUE);
#line 157 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
		g_signal_handlers_disconnect_matched ((GObject*) _tmp11_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp12_, _tmp13_, NULL, (GCallback) __persona_store_tests_can_add_personas_cb_g_object_notify, self);
#line 934 "persona-store-tests.c"
	}
#line 161 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_tmp14_ = self->priv->_callbacks_received;
#line 161 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	if (_tmp14_ == ((guint) 4)) {
#line 940 "persona-store-tests.c"
		GMainLoop* _tmp15_ = NULL;
#line 162 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
		_tmp15_ = self->priv->_main_loop;
#line 162 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
		g_main_loop_quit (_tmp15_);
#line 946 "persona-store-tests.c"
	}
#line 145 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_g_object_unref0 (store);
#line 950 "persona-store-tests.c"
}


static void _persona_store_tests_can_remove_personas_cb (PersonaStoreTests* self, GObject* s, GParamSpec* p) {
	GObject* _tmp0_ = NULL;
	EdsfPersonaStore* store = NULL;
	GObject* _tmp1_ = NULL;
	EdsfPersonaStore* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	EdsfPersonaStore* _tmp4_ = NULL;
	FolksMaybeBool _tmp5_ = 0;
	FolksMaybeBool _tmp6_ = 0;
	guint _tmp14_ = 0U;
#line 165 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	g_return_if_fail (self != NULL);
#line 165 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	g_return_if_fail (s != NULL);
#line 167 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_tmp0_ = s;
#line 167 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_vala_assert (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, EDSF_TYPE_PERSONA_STORE), "s is Edsf.PersonaStore");
#line 168 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_tmp1_ = s;
#line 168 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, EDSF_TYPE_PERSONA_STORE, EdsfPersonaStore));
#line 168 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	store = _tmp2_;
#line 169 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_tmp3_ = self->priv->_callbacks_received;
#line 169 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	self->priv->_callbacks_received = _tmp3_ + 1;
#line 171 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_tmp4_ = store;
#line 171 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_tmp5_ = folks_persona_store_get_can_remove_personas ((FolksPersonaStore*) _tmp4_);
#line 171 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_tmp6_ = _tmp5_;
#line 171 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	if (_tmp6_ != FOLKS_MAYBE_BOOL_UNSET) {
#line 990 "persona-store-tests.c"
		EdsfPersonaStore* _tmp7_ = NULL;
		FolksMaybeBool _tmp8_ = 0;
		FolksMaybeBool _tmp9_ = 0;
		GeeHashSet* _tmp10_ = NULL;
		EdsfPersonaStore* _tmp11_ = NULL;
		guint _tmp12_ = 0U;
		GQuark _tmp13_ = 0U;
#line 173 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
		_tmp7_ = store;
#line 173 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
		_tmp8_ = folks_persona_store_get_can_remove_personas ((FolksPersonaStore*) _tmp7_);
#line 173 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
		_tmp9_ = _tmp8_;
#line 173 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
		_vala_assert (_tmp9_ == FOLKS_MAYBE_BOOL_TRUE, "store.can_remove_personas == MaybeBool.TRUE");
#line 175 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
		_tmp10_ = self->priv->_capabilities_received;
#line 175 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp10_, "can-remove-personas");
#line 177 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
		_tmp11_ = store;
#line 177 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
		g_signal_parse_name ("notify::can-remove-personas", G_TYPE_OBJECT, &_tmp12_, &_tmp13_, TRUE);
#line 177 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
		g_signal_handlers_disconnect_matched ((GObject*) _tmp11_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp12_, _tmp13_, NULL, (GCallback) __persona_store_tests_can_remove_personas_cb_g_object_notify, self);
#line 1016 "persona-store-tests.c"
	}
#line 181 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_tmp14_ = self->priv->_callbacks_received;
#line 181 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	if (_tmp14_ == ((guint) 4)) {
#line 1022 "persona-store-tests.c"
		GMainLoop* _tmp15_ = NULL;
#line 182 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
		_tmp15_ = self->priv->_main_loop;
#line 182 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
		g_main_loop_quit (_tmp15_);
#line 1028 "persona-store-tests.c"
	}
#line 165 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_g_object_unref0 (store);
#line 1032 "persona-store-tests.c"
}


static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle) {
	int i;
#line 191 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	for (i = 0; i < stack_length; i++) {
#line 191 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
		if (g_strcmp0 (stack[i], needle) == 0) {
#line 191 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
			return TRUE;
#line 1044 "persona-store-tests.c"
		}
	}
#line 191 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	return FALSE;
#line 1049 "persona-store-tests.c"
}


static void _persona_store_tests_check_can_alias_personas (PersonaStoreTests* self, GObject* s, GParamSpec* p) {
	GObject* _tmp0_ = NULL;
	EdsfPersonaStore* store = NULL;
	GObject* _tmp1_ = NULL;
	EdsfPersonaStore* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	EdsfPersonaStore* _tmp4_ = NULL;
	gchar** _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	gchar** _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
	guint _tmp8_ = 0U;
#line 185 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	g_return_if_fail (self != NULL);
#line 185 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	g_return_if_fail (s != NULL);
#line 187 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_tmp0_ = s;
#line 187 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_vala_assert (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, EDSF_TYPE_PERSONA_STORE), "s is Edsf.PersonaStore");
#line 188 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_tmp1_ = s;
#line 188 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, EDSF_TYPE_PERSONA_STORE, EdsfPersonaStore));
#line 188 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	store = _tmp2_;
#line 189 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_tmp3_ = self->priv->_callbacks_received;
#line 189 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	self->priv->_callbacks_received = _tmp3_ + 1;
#line 191 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_tmp4_ = store;
#line 191 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_tmp5_ = folks_persona_store_get_always_writeable_properties ((FolksPersonaStore*) _tmp4_, &_tmp5__length1);
#line 191 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_tmp6_ = _tmp5_;
#line 191 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_tmp6__length1 = _tmp5__length1;
#line 191 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	if (_vala_string_array_contains (_tmp6_, _tmp6__length1, "alias")) {
#line 1093 "persona-store-tests.c"
		GeeHashSet* _tmp7_ = NULL;
#line 193 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
		_tmp7_ = self->priv->_capabilities_received;
#line 193 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp7_, "can-alias-personas");
#line 1099 "persona-store-tests.c"
	}
#line 196 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_tmp8_ = self->priv->_callbacks_received;
#line 196 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	if (_tmp8_ == ((guint) 4)) {
#line 1105 "persona-store-tests.c"
		GMainLoop* _tmp9_ = NULL;
#line 197 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
		_tmp9_ = self->priv->_main_loop;
#line 197 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
		g_main_loop_quit (_tmp9_);
#line 1111 "persona-store-tests.c"
	}
#line 185 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_g_object_unref0 (store);
#line 1115 "persona-store-tests.c"
}


static void _persona_store_tests_check_can_group_personas (PersonaStoreTests* self, GObject* s, GParamSpec* p) {
	GObject* _tmp0_ = NULL;
	EdsfPersonaStore* store = NULL;
	GObject* _tmp1_ = NULL;
	EdsfPersonaStore* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	EdsfPersonaStore* _tmp4_ = NULL;
	gchar** _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	gchar** _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
	guint _tmp8_ = 0U;
#line 200 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	g_return_if_fail (self != NULL);
#line 200 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	g_return_if_fail (s != NULL);
#line 202 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_tmp0_ = s;
#line 202 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_vala_assert (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, EDSF_TYPE_PERSONA_STORE), "s is Edsf.PersonaStore");
#line 203 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_tmp1_ = s;
#line 203 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, EDSF_TYPE_PERSONA_STORE, EdsfPersonaStore));
#line 203 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	store = _tmp2_;
#line 204 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_tmp3_ = self->priv->_callbacks_received;
#line 204 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	self->priv->_callbacks_received = _tmp3_ + 1;
#line 206 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_tmp4_ = store;
#line 206 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_tmp5_ = folks_persona_store_get_always_writeable_properties ((FolksPersonaStore*) _tmp4_, &_tmp5__length1);
#line 206 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_tmp6_ = _tmp5_;
#line 206 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_tmp6__length1 = _tmp5__length1;
#line 206 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	if (_vala_string_array_contains (_tmp6_, _tmp6__length1, "groups")) {
#line 1159 "persona-store-tests.c"
		GeeHashSet* _tmp7_ = NULL;
#line 208 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
		_tmp7_ = self->priv->_capabilities_received;
#line 208 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp7_, "can-group-personas");
#line 1165 "persona-store-tests.c"
	}
#line 211 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_tmp8_ = self->priv->_callbacks_received;
#line 211 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	if (_tmp8_ == ((guint) 4)) {
#line 1171 "persona-store-tests.c"
		GMainLoop* _tmp9_ = NULL;
#line 212 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
		_tmp9_ = self->priv->_main_loop;
#line 212 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
		g_main_loop_quit (_tmp9_);
#line 1177 "persona-store-tests.c"
	}
#line 200 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_g_object_unref0 (store);
#line 1181 "persona-store-tests.c"
}


static void persona_store_tests_class_init (PersonaStoreTestsClass * klass) {
#line 26 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	persona_store_tests_parent_class = g_type_class_peek_parent (klass);
#line 26 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	g_type_class_add_private (klass, sizeof (PersonaStoreTestsPrivate));
#line 26 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	((FolksTestCaseClass *) klass)->set_up = persona_store_tests_real_set_up;
#line 26 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	((FolksTestCaseClass *) klass)->tear_down = persona_store_tests_real_tear_down;
#line 26 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	G_OBJECT_CLASS (klass)->finalize = persona_store_tests_finalize;
#line 1196 "persona-store-tests.c"
}


static void persona_store_tests_instance_init (PersonaStoreTests * self) {
#line 26 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	self->priv = PERSONA_STORE_TESTS_GET_PRIVATE (self);
#line 28 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	self->priv->_capabilities_received = NULL;
#line 29 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	self->priv->_main_loop = NULL;
#line 30 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	self->priv->_callbacks_received = (guint) 0;
#line 1209 "persona-store-tests.c"
}


static void persona_store_tests_finalize (GObject* obj) {
	PersonaStoreTests * self;
#line 26 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PERSONA_STORE_TESTS, PersonaStoreTests);
#line 28 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_g_object_unref0 (self->priv->_capabilities_received);
#line 29 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_g_main_loop_unref0 (self->priv->_main_loop);
#line 26 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	G_OBJECT_CLASS (persona_store_tests_parent_class)->finalize (obj);
#line 1223 "persona-store-tests.c"
}


GType persona_store_tests_get_type (void) {
	static volatile gsize persona_store_tests_type_id__volatile = 0;
	if (g_once_init_enter (&persona_store_tests_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PersonaStoreTestsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) persona_store_tests_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PersonaStoreTests), 0, (GInstanceInitFunc) persona_store_tests_instance_init, NULL };
		GType persona_store_tests_type_id;
		persona_store_tests_type_id = g_type_register_static (EDS_TEST_TYPE_TEST_CASE, "PersonaStoreTests", &g_define_type_info, 0);
		g_once_init_leave (&persona_store_tests_type_id__volatile, persona_store_tests_type_id);
	}
	return persona_store_tests_type_id__volatile;
}


gint _vala_main (gchar** args, int args_length1) {
	gint result = 0;
	PersonaStoreTests* tests = NULL;
	PersonaStoreTests* _tmp0_ = NULL;
#line 218 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	g_test_init (&args_length1, &args, NULL);
#line 220 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_tmp0_ = persona_store_tests_new ();
#line 220 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	tests = _tmp0_;
#line 221 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	folks_test_case_register ((FolksTestCase*) tests);
#line 222 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	g_test_run ();
#line 223 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	folks_test_case_final_tear_down ((FolksTestCase*) tests);
#line 225 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	result = 0;
#line 225 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	_g_object_unref0 (tests);
#line 225 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	return result;
#line 1261 "persona-store-tests.c"
}


int main (int argc, char ** argv) {
#if !GLIB_CHECK_VERSION (2,35,0)
	g_type_init ();
#endif
#line 216 "/opt/gnome3/source/folks/tests/eds/persona-store-tests.vala"
	return _vala_main (argv, argc);
#line 1271 "persona-store-tests.c"
}



