/* valaparameter.c generated by valac, the Vala compiler
 * generated from valaparameter.vala, do not modify */

/* valaparameter.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <valagee.h>


#define VALA_TYPE_CODE_NODE (vala_code_node_get_type ())
#define VALA_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_NODE, ValaCodeNode))
#define VALA_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))
#define VALA_IS_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_NODE))
#define VALA_IS_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_NODE))
#define VALA_CODE_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))

typedef struct _ValaCodeNode ValaCodeNode;
typedef struct _ValaCodeNodeClass ValaCodeNodeClass;
typedef struct _ValaCodeNodePrivate ValaCodeNodePrivate;

#define VALA_TYPE_CODE_VISITOR (vala_code_visitor_get_type ())
#define VALA_CODE_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_VISITOR, ValaCodeVisitor))
#define VALA_CODE_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_VISITOR, ValaCodeVisitorClass))
#define VALA_IS_CODE_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_VISITOR))
#define VALA_IS_CODE_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_VISITOR))
#define VALA_CODE_VISITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_VISITOR, ValaCodeVisitorClass))

typedef struct _ValaCodeVisitor ValaCodeVisitor;
typedef struct _ValaCodeVisitorClass ValaCodeVisitorClass;

#define VALA_TYPE_CODE_CONTEXT (vala_code_context_get_type ())
#define VALA_CODE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_CONTEXT, ValaCodeContext))
#define VALA_CODE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_CONTEXT, ValaCodeContextClass))
#define VALA_IS_CODE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_CONTEXT))
#define VALA_IS_CODE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_CONTEXT))
#define VALA_CODE_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_CONTEXT, ValaCodeContextClass))

typedef struct _ValaCodeContext ValaCodeContext;
typedef struct _ValaCodeContextClass ValaCodeContextClass;

#define VALA_TYPE_CODE_GENERATOR (vala_code_generator_get_type ())
#define VALA_CODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_GENERATOR, ValaCodeGenerator))
#define VALA_CODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_GENERATOR, ValaCodeGeneratorClass))
#define VALA_IS_CODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_GENERATOR))
#define VALA_IS_CODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_GENERATOR))
#define VALA_CODE_GENERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_GENERATOR, ValaCodeGeneratorClass))

typedef struct _ValaCodeGenerator ValaCodeGenerator;
typedef struct _ValaCodeGeneratorClass ValaCodeGeneratorClass;

#define VALA_TYPE_DATA_TYPE (vala_data_type_get_type ())
#define VALA_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DATA_TYPE, ValaDataType))
#define VALA_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DATA_TYPE, ValaDataTypeClass))
#define VALA_IS_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DATA_TYPE))
#define VALA_IS_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DATA_TYPE))
#define VALA_DATA_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DATA_TYPE, ValaDataTypeClass))

typedef struct _ValaDataType ValaDataType;
typedef struct _ValaDataTypeClass ValaDataTypeClass;

#define VALA_TYPE_EXPRESSION (vala_expression_get_type ())
#define VALA_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_EXPRESSION, ValaExpression))
#define VALA_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_EXPRESSION, ValaExpressionClass))
#define VALA_IS_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_EXPRESSION))
#define VALA_IS_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_EXPRESSION))
#define VALA_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_EXPRESSION, ValaExpressionClass))

typedef struct _ValaExpression ValaExpression;
typedef struct _ValaExpressionClass ValaExpressionClass;

#define VALA_TYPE_SYMBOL (vala_symbol_get_type ())
#define VALA_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SYMBOL, ValaSymbol))
#define VALA_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SYMBOL, ValaSymbolClass))
#define VALA_IS_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SYMBOL))
#define VALA_IS_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SYMBOL))
#define VALA_SYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SYMBOL, ValaSymbolClass))

typedef struct _ValaSymbol ValaSymbol;
typedef struct _ValaSymbolClass ValaSymbolClass;

#define VALA_TYPE_VARIABLE (vala_variable_get_type ())
#define VALA_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_VARIABLE, ValaVariable))
#define VALA_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_VARIABLE, ValaVariableClass))
#define VALA_IS_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_VARIABLE))
#define VALA_IS_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_VARIABLE))
#define VALA_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_VARIABLE, ValaVariableClass))

typedef struct _ValaVariable ValaVariable;
typedef struct _ValaVariableClass ValaVariableClass;

#define VALA_TYPE_ATTRIBUTE (vala_attribute_get_type ())
#define VALA_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ATTRIBUTE, ValaAttribute))
#define VALA_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ATTRIBUTE, ValaAttributeClass))
#define VALA_IS_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ATTRIBUTE))
#define VALA_IS_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ATTRIBUTE))
#define VALA_ATTRIBUTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ATTRIBUTE, ValaAttributeClass))

typedef struct _ValaAttribute ValaAttribute;
typedef struct _ValaAttributeClass ValaAttributeClass;
typedef struct _ValaSymbolPrivate ValaSymbolPrivate;

#define VALA_TYPE_NAMESPACE (vala_namespace_get_type ())
#define VALA_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_NAMESPACE, ValaNamespace))
#define VALA_NAMESPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_NAMESPACE, ValaNamespaceClass))
#define VALA_IS_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_NAMESPACE))
#define VALA_IS_NAMESPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_NAMESPACE))
#define VALA_NAMESPACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_NAMESPACE, ValaNamespaceClass))

typedef struct _ValaNamespace ValaNamespace;
typedef struct _ValaNamespaceClass ValaNamespaceClass;

#define VALA_TYPE_TYPESYMBOL (vala_typesymbol_get_type ())
#define VALA_TYPESYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TYPESYMBOL, ValaTypeSymbol))
#define VALA_TYPESYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TYPESYMBOL, ValaTypeSymbolClass))
#define VALA_IS_TYPESYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TYPESYMBOL))
#define VALA_IS_TYPESYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TYPESYMBOL))
#define VALA_TYPESYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TYPESYMBOL, ValaTypeSymbolClass))

typedef struct _ValaTypeSymbol ValaTypeSymbol;
typedef struct _ValaTypeSymbolClass ValaTypeSymbolClass;

#define VALA_TYPE_OBJECT_TYPE_SYMBOL (vala_object_type_symbol_get_type ())
#define VALA_OBJECT_TYPE_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol))
#define VALA_OBJECT_TYPE_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbolClass))
#define VALA_IS_OBJECT_TYPE_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_OBJECT_TYPE_SYMBOL))
#define VALA_IS_OBJECT_TYPE_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_OBJECT_TYPE_SYMBOL))
#define VALA_OBJECT_TYPE_SYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbolClass))

typedef struct _ValaObjectTypeSymbol ValaObjectTypeSymbol;
typedef struct _ValaObjectTypeSymbolClass ValaObjectTypeSymbolClass;

#define VALA_TYPE_CLASS (vala_class_get_type ())
#define VALA_CLASS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CLASS, ValaClass))
#define VALA_CLASS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CLASS, ValaClassClass))
#define VALA_IS_CLASS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CLASS))
#define VALA_IS_CLASS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CLASS))
#define VALA_CLASS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CLASS, ValaClassClass))

typedef struct _ValaClass ValaClass;
typedef struct _ValaClassClass ValaClassClass;

#define VALA_TYPE_INTERFACE (vala_interface_get_type ())
#define VALA_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_INTERFACE, ValaInterface))
#define VALA_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_INTERFACE, ValaInterfaceClass))
#define VALA_IS_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_INTERFACE))
#define VALA_IS_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_INTERFACE))
#define VALA_INTERFACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_INTERFACE, ValaInterfaceClass))

typedef struct _ValaInterface ValaInterface;
typedef struct _ValaInterfaceClass ValaInterfaceClass;

#define VALA_TYPE_STRUCT (vala_struct_get_type ())
#define VALA_STRUCT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_STRUCT, ValaStruct))
#define VALA_STRUCT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_STRUCT, ValaStructClass))
#define VALA_IS_STRUCT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_STRUCT))
#define VALA_IS_STRUCT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_STRUCT))
#define VALA_STRUCT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_STRUCT, ValaStructClass))

typedef struct _ValaStruct ValaStruct;
typedef struct _ValaStructClass ValaStructClass;

#define VALA_TYPE_ENUM (vala_enum_get_type ())
#define VALA_ENUM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ENUM, ValaEnum))
#define VALA_ENUM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ENUM, ValaEnumClass))
#define VALA_IS_ENUM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ENUM))
#define VALA_IS_ENUM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ENUM))
#define VALA_ENUM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ENUM, ValaEnumClass))

typedef struct _ValaEnum ValaEnum;
typedef struct _ValaEnumClass ValaEnumClass;

#define VALA_TYPE_ERROR_DOMAIN (vala_error_domain_get_type ())
#define VALA_ERROR_DOMAIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ERROR_DOMAIN, ValaErrorDomain))
#define VALA_ERROR_DOMAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ERROR_DOMAIN, ValaErrorDomainClass))
#define VALA_IS_ERROR_DOMAIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ERROR_DOMAIN))
#define VALA_IS_ERROR_DOMAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ERROR_DOMAIN))
#define VALA_ERROR_DOMAIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ERROR_DOMAIN, ValaErrorDomainClass))

typedef struct _ValaErrorDomain ValaErrorDomain;
typedef struct _ValaErrorDomainClass ValaErrorDomainClass;

#define VALA_TYPE_DELEGATE (vala_delegate_get_type ())
#define VALA_DELEGATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DELEGATE, ValaDelegate))
#define VALA_DELEGATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DELEGATE, ValaDelegateClass))
#define VALA_IS_DELEGATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DELEGATE))
#define VALA_IS_DELEGATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DELEGATE))
#define VALA_DELEGATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DELEGATE, ValaDelegateClass))

typedef struct _ValaDelegate ValaDelegate;
typedef struct _ValaDelegateClass ValaDelegateClass;

#define VALA_TYPE_CONSTANT (vala_constant_get_type ())
#define VALA_CONSTANT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CONSTANT, ValaConstant))
#define VALA_CONSTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CONSTANT, ValaConstantClass))
#define VALA_IS_CONSTANT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CONSTANT))
#define VALA_IS_CONSTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CONSTANT))
#define VALA_CONSTANT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CONSTANT, ValaConstantClass))

typedef struct _ValaConstant ValaConstant;
typedef struct _ValaConstantClass ValaConstantClass;

#define VALA_TYPE_FIELD (vala_field_get_type ())
#define VALA_FIELD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_FIELD, ValaField))
#define VALA_FIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_FIELD, ValaFieldClass))
#define VALA_IS_FIELD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_FIELD))
#define VALA_IS_FIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_FIELD))
#define VALA_FIELD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_FIELD, ValaFieldClass))

typedef struct _ValaField ValaField;
typedef struct _ValaFieldClass ValaFieldClass;

#define VALA_TYPE_SUBROUTINE (vala_subroutine_get_type ())
#define VALA_SUBROUTINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SUBROUTINE, ValaSubroutine))
#define VALA_SUBROUTINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SUBROUTINE, ValaSubroutineClass))
#define VALA_IS_SUBROUTINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SUBROUTINE))
#define VALA_IS_SUBROUTINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SUBROUTINE))
#define VALA_SUBROUTINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SUBROUTINE, ValaSubroutineClass))

typedef struct _ValaSubroutine ValaSubroutine;
typedef struct _ValaSubroutineClass ValaSubroutineClass;

#define VALA_TYPE_METHOD (vala_method_get_type ())
#define VALA_METHOD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_METHOD, ValaMethod))
#define VALA_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_METHOD, ValaMethodClass))
#define VALA_IS_METHOD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_METHOD))
#define VALA_IS_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_METHOD))
#define VALA_METHOD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_METHOD, ValaMethodClass))

typedef struct _ValaMethod ValaMethod;
typedef struct _ValaMethodClass ValaMethodClass;

#define VALA_TYPE_PROPERTY (vala_property_get_type ())
#define VALA_PROPERTY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_PROPERTY, ValaProperty))
#define VALA_PROPERTY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_PROPERTY, ValaPropertyClass))
#define VALA_IS_PROPERTY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_PROPERTY))
#define VALA_IS_PROPERTY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_PROPERTY))
#define VALA_PROPERTY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_PROPERTY, ValaPropertyClass))

typedef struct _ValaProperty ValaProperty;
typedef struct _ValaPropertyClass ValaPropertyClass;

#define VALA_TYPE_SIGNAL (vala_signal_get_type ())
#define VALA_SIGNAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SIGNAL, ValaSignal))
#define VALA_SIGNAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SIGNAL, ValaSignalClass))
#define VALA_IS_SIGNAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SIGNAL))
#define VALA_IS_SIGNAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SIGNAL))
#define VALA_SIGNAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SIGNAL, ValaSignalClass))

typedef struct _ValaSignal ValaSignal;
typedef struct _ValaSignalClass ValaSignalClass;

#define VALA_TYPE_CONSTRUCTOR (vala_constructor_get_type ())
#define VALA_CONSTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CONSTRUCTOR, ValaConstructor))
#define VALA_CONSTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CONSTRUCTOR, ValaConstructorClass))
#define VALA_IS_CONSTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CONSTRUCTOR))
#define VALA_IS_CONSTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CONSTRUCTOR))
#define VALA_CONSTRUCTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CONSTRUCTOR, ValaConstructorClass))

typedef struct _ValaConstructor ValaConstructor;
typedef struct _ValaConstructorClass ValaConstructorClass;

#define VALA_TYPE_DESTRUCTOR (vala_destructor_get_type ())
#define VALA_DESTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DESTRUCTOR, ValaDestructor))
#define VALA_DESTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DESTRUCTOR, ValaDestructorClass))
#define VALA_IS_DESTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DESTRUCTOR))
#define VALA_IS_DESTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DESTRUCTOR))
#define VALA_DESTRUCTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DESTRUCTOR, ValaDestructorClass))

typedef struct _ValaDestructor ValaDestructor;
typedef struct _ValaDestructorClass ValaDestructorClass;
typedef struct _ValaVariablePrivate ValaVariablePrivate;

#define VALA_TYPE_PARAMETER (vala_parameter_get_type ())
#define VALA_PARAMETER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_PARAMETER, ValaParameter))
#define VALA_PARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_PARAMETER, ValaParameterClass))
#define VALA_IS_PARAMETER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_PARAMETER))
#define VALA_IS_PARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_PARAMETER))
#define VALA_PARAMETER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_PARAMETER, ValaParameterClass))

typedef struct _ValaParameter ValaParameter;
typedef struct _ValaParameterClass ValaParameterClass;
typedef struct _ValaParameterPrivate ValaParameterPrivate;

#define VALA_TYPE_PARAMETER_DIRECTION (vala_parameter_direction_get_type ())
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))

#define VALA_TYPE_SOURCE_REFERENCE (vala_source_reference_get_type ())
#define VALA_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReference))
#define VALA_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))
#define VALA_IS_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_IS_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_SOURCE_REFERENCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))

typedef struct _ValaSourceReference ValaSourceReference;
typedef struct _ValaSourceReferenceClass ValaSourceReferenceClass;

#define VALA_TYPE_COMMENT (vala_comment_get_type ())
#define VALA_COMMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_COMMENT, ValaComment))
#define VALA_COMMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_COMMENT, ValaCommentClass))
#define VALA_IS_COMMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_COMMENT))
#define VALA_IS_COMMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_COMMENT))
#define VALA_COMMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_COMMENT, ValaCommentClass))

typedef struct _ValaComment ValaComment;
typedef struct _ValaCommentClass ValaCommentClass;

#define VALA_TYPE_SYMBOL_ACCESSIBILITY (vala_symbol_accessibility_get_type ())

#define VALA_TYPE_SOURCE_FILE (vala_source_file_get_type ())
#define VALA_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_FILE, ValaSourceFile))
#define VALA_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_FILE, ValaSourceFileClass))
#define VALA_IS_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_FILE))
#define VALA_IS_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_FILE))
#define VALA_SOURCE_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_FILE, ValaSourceFileClass))

typedef struct _ValaSourceFile ValaSourceFile;
typedef struct _ValaSourceFileClass ValaSourceFileClass;

#define VALA_TYPE_SEMANTIC_ANALYZER (vala_semantic_analyzer_get_type ())
#define VALA_SEMANTIC_ANALYZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzer))
#define VALA_SEMANTIC_ANALYZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzerClass))
#define VALA_IS_SEMANTIC_ANALYZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SEMANTIC_ANALYZER))
#define VALA_IS_SEMANTIC_ANALYZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SEMANTIC_ANALYZER))
#define VALA_SEMANTIC_ANALYZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzerClass))

typedef struct _ValaSemanticAnalyzer ValaSemanticAnalyzer;
typedef struct _ValaSemanticAnalyzerClass ValaSemanticAnalyzerClass;

#define VALA_TYPE_VOID_TYPE (vala_void_type_get_type ())
#define VALA_VOID_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_VOID_TYPE, ValaVoidType))
#define VALA_VOID_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_VOID_TYPE, ValaVoidTypeClass))
#define VALA_IS_VOID_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_VOID_TYPE))
#define VALA_IS_VOID_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_VOID_TYPE))
#define VALA_VOID_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_VOID_TYPE, ValaVoidTypeClass))

typedef struct _ValaVoidType ValaVoidType;
typedef struct _ValaVoidTypeClass ValaVoidTypeClass;
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))

#define VALA_TYPE_REFERENCE_TYPE (vala_reference_type_get_type ())
#define VALA_REFERENCE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_REFERENCE_TYPE, ValaReferenceType))
#define VALA_REFERENCE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_REFERENCE_TYPE, ValaReferenceTypeClass))
#define VALA_IS_REFERENCE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_REFERENCE_TYPE))
#define VALA_IS_REFERENCE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_REFERENCE_TYPE))
#define VALA_REFERENCE_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_REFERENCE_TYPE, ValaReferenceTypeClass))

typedef struct _ValaReferenceType ValaReferenceType;
typedef struct _ValaReferenceTypeClass ValaReferenceTypeClass;

#define VALA_TYPE_ARRAY_TYPE (vala_array_type_get_type ())
#define VALA_ARRAY_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ARRAY_TYPE, ValaArrayType))
#define VALA_ARRAY_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ARRAY_TYPE, ValaArrayTypeClass))
#define VALA_IS_ARRAY_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ARRAY_TYPE))
#define VALA_IS_ARRAY_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ARRAY_TYPE))
#define VALA_ARRAY_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ARRAY_TYPE, ValaArrayTypeClass))

typedef struct _ValaArrayType ValaArrayType;
typedef struct _ValaArrayTypeClass ValaArrayTypeClass;

#define VALA_TYPE_DELEGATE_TYPE (vala_delegate_type_get_type ())
#define VALA_DELEGATE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DELEGATE_TYPE, ValaDelegateType))
#define VALA_DELEGATE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DELEGATE_TYPE, ValaDelegateTypeClass))
#define VALA_IS_DELEGATE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DELEGATE_TYPE))
#define VALA_IS_DELEGATE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DELEGATE_TYPE))
#define VALA_DELEGATE_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DELEGATE_TYPE, ValaDelegateTypeClass))

typedef struct _ValaDelegateType ValaDelegateType;
typedef struct _ValaDelegateTypeClass ValaDelegateTypeClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define VALA_TYPE_LITERAL (vala_literal_get_type ())
#define VALA_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_LITERAL, ValaLiteral))
#define VALA_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_LITERAL, ValaLiteralClass))
#define VALA_IS_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_LITERAL))
#define VALA_IS_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_LITERAL))
#define VALA_LITERAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_LITERAL, ValaLiteralClass))

typedef struct _ValaLiteral ValaLiteral;
typedef struct _ValaLiteralClass ValaLiteralClass;

#define VALA_TYPE_NULL_LITERAL (vala_null_literal_get_type ())
#define VALA_NULL_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_NULL_LITERAL, ValaNullLiteral))
#define VALA_NULL_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_NULL_LITERAL, ValaNullLiteralClass))
#define VALA_IS_NULL_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_NULL_LITERAL))
#define VALA_IS_NULL_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_NULL_LITERAL))
#define VALA_NULL_LITERAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_NULL_LITERAL, ValaNullLiteralClass))

typedef struct _ValaNullLiteral ValaNullLiteral;
typedef struct _ValaNullLiteralClass ValaNullLiteralClass;
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))

struct _ValaCodeNode {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCodeNodePrivate * priv;
	GList* attributes;
};

struct _ValaCodeNodeClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCodeNode *self);
	void (*accept) (ValaCodeNode* self, ValaCodeVisitor* visitor);
	void (*accept_children) (ValaCodeNode* self, ValaCodeVisitor* visitor);
	gboolean (*check) (ValaCodeNode* self, ValaCodeContext* context);
	void (*emit) (ValaCodeNode* self, ValaCodeGenerator* codegen);
	void (*replace_type) (ValaCodeNode* self, ValaDataType* old_type, ValaDataType* new_type);
	void (*replace_expression) (ValaCodeNode* self, ValaExpression* old_node, ValaExpression* new_node);
	gchar* (*to_string) (ValaCodeNode* self);
	void (*get_defined_variables) (ValaCodeNode* self, ValaCollection* collection);
	void (*get_used_variables) (ValaCodeNode* self, ValaCollection* collection);
};

struct _ValaSymbol {
	ValaCodeNode parent_instance;
	ValaSymbolPrivate * priv;
};

struct _ValaSymbolClass {
	ValaCodeNodeClass parent_class;
	gboolean (*is_instance_member) (ValaSymbol* self);
	gboolean (*is_class_member) (ValaSymbol* self);
	void (*add_namespace) (ValaSymbol* self, ValaNamespace* ns);
	void (*add_class) (ValaSymbol* self, ValaClass* cl);
	void (*add_interface) (ValaSymbol* self, ValaInterface* iface);
	void (*add_struct) (ValaSymbol* self, ValaStruct* st);
	void (*add_enum) (ValaSymbol* self, ValaEnum* en);
	void (*add_error_domain) (ValaSymbol* self, ValaErrorDomain* edomain);
	void (*add_delegate) (ValaSymbol* self, ValaDelegate* d);
	void (*add_constant) (ValaSymbol* self, ValaConstant* constant);
	void (*add_field) (ValaSymbol* self, ValaField* f);
	void (*add_method) (ValaSymbol* self, ValaMethod* m);
	void (*add_property) (ValaSymbol* self, ValaProperty* prop);
	void (*add_signal) (ValaSymbol* self, ValaSignal* sig);
	void (*add_constructor) (ValaSymbol* self, ValaConstructor* c);
	void (*add_destructor) (ValaSymbol* self, ValaDestructor* d);
};

struct _ValaVariable {
	ValaSymbol parent_instance;
	ValaVariablePrivate * priv;
};

struct _ValaVariableClass {
	ValaSymbolClass parent_class;
};

struct _ValaParameter {
	ValaVariable parent_instance;
	ValaParameterPrivate * priv;
};

struct _ValaParameterClass {
	ValaVariableClass parent_class;
};

typedef enum  {
	VALA_PARAMETER_DIRECTION_IN,
	VALA_PARAMETER_DIRECTION_OUT,
	VALA_PARAMETER_DIRECTION_REF
} ValaParameterDirection;

struct _ValaParameterPrivate {
	ValaParameterDirection _direction;
	gboolean _ellipsis;
	gboolean _params_array;
	gboolean _captured;
	ValaParameter* _base_parameter;
};

typedef enum  {
	VALA_SYMBOL_ACCESSIBILITY_PRIVATE,
	VALA_SYMBOL_ACCESSIBILITY_INTERNAL,
	VALA_SYMBOL_ACCESSIBILITY_PROTECTED,
	VALA_SYMBOL_ACCESSIBILITY_PUBLIC
} ValaSymbolAccessibility;


static gpointer vala_parameter_parent_class = NULL;

gpointer vala_code_node_ref (gpointer instance);
void vala_code_node_unref (gpointer instance);
GParamSpec* vala_param_spec_code_node (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_node (GValue* value, gpointer v_object);
void vala_value_take_code_node (GValue* value, gpointer v_object);
gpointer vala_value_get_code_node (const GValue* value);
GType vala_code_node_get_type (void) G_GNUC_CONST;
gpointer vala_code_visitor_ref (gpointer instance);
void vala_code_visitor_unref (gpointer instance);
GParamSpec* vala_param_spec_code_visitor (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_visitor (GValue* value, gpointer v_object);
void vala_value_take_code_visitor (GValue* value, gpointer v_object);
gpointer vala_value_get_code_visitor (const GValue* value);
GType vala_code_visitor_get_type (void) G_GNUC_CONST;
gpointer vala_code_context_ref (gpointer instance);
void vala_code_context_unref (gpointer instance);
GParamSpec* vala_param_spec_code_context (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_context (GValue* value, gpointer v_object);
void vala_value_take_code_context (GValue* value, gpointer v_object);
gpointer vala_value_get_code_context (const GValue* value);
GType vala_code_context_get_type (void) G_GNUC_CONST;
GType vala_code_generator_get_type (void) G_GNUC_CONST;
GType vala_data_type_get_type (void) G_GNUC_CONST;
GType vala_expression_get_type (void) G_GNUC_CONST;
GType vala_symbol_get_type (void) G_GNUC_CONST;
GType vala_variable_get_type (void) G_GNUC_CONST;
GType vala_attribute_get_type (void) G_GNUC_CONST;
GType vala_namespace_get_type (void) G_GNUC_CONST;
GType vala_typesymbol_get_type (void) G_GNUC_CONST;
GType vala_object_type_symbol_get_type (void) G_GNUC_CONST;
GType vala_class_get_type (void) G_GNUC_CONST;
GType vala_interface_get_type (void) G_GNUC_CONST;
GType vala_struct_get_type (void) G_GNUC_CONST;
GType vala_enum_get_type (void) G_GNUC_CONST;
GType vala_error_domain_get_type (void) G_GNUC_CONST;
GType vala_delegate_get_type (void) G_GNUC_CONST;
GType vala_constant_get_type (void) G_GNUC_CONST;
GType vala_field_get_type (void) G_GNUC_CONST;
GType vala_subroutine_get_type (void) G_GNUC_CONST;
GType vala_method_get_type (void) G_GNUC_CONST;
GType vala_property_get_type (void) G_GNUC_CONST;
GType vala_signal_get_type (void) G_GNUC_CONST;
GType vala_constructor_get_type (void) G_GNUC_CONST;
GType vala_destructor_get_type (void) G_GNUC_CONST;
GType vala_parameter_get_type (void) G_GNUC_CONST;
GType vala_parameter_direction_get_type (void) G_GNUC_CONST;
#define VALA_PARAMETER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_PARAMETER, ValaParameterPrivate))
enum  {
	VALA_PARAMETER_DUMMY_PROPERTY
};
gpointer vala_source_reference_ref (gpointer instance);
void vala_source_reference_unref (gpointer instance);
GParamSpec* vala_param_spec_source_reference (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_reference (GValue* value, gpointer v_object);
void vala_value_take_source_reference (GValue* value, gpointer v_object);
gpointer vala_value_get_source_reference (const GValue* value);
GType vala_source_reference_get_type (void) G_GNUC_CONST;
ValaParameter* vala_parameter_new (const gchar* name, ValaDataType* variable_type, ValaSourceReference* source_reference);
ValaParameter* vala_parameter_construct (GType object_type, const gchar* name, ValaDataType* variable_type, ValaSourceReference* source_reference);
gpointer vala_comment_ref (gpointer instance);
void vala_comment_unref (gpointer instance);
GParamSpec* vala_param_spec_comment (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_comment (GValue* value, gpointer v_object);
void vala_value_take_comment (GValue* value, gpointer v_object);
gpointer vala_value_get_comment (const GValue* value);
GType vala_comment_get_type (void) G_GNUC_CONST;
ValaVariable* vala_variable_new (ValaDataType* variable_type, const gchar* name, ValaExpression* initializer, ValaSourceReference* source_reference, ValaComment* comment);
ValaVariable* vala_variable_construct (GType object_type, ValaDataType* variable_type, const gchar* name, ValaExpression* initializer, ValaSourceReference* source_reference, ValaComment* comment);
GType vala_symbol_accessibility_get_type (void) G_GNUC_CONST;
void vala_symbol_set_access (ValaSymbol* self, ValaSymbolAccessibility value);
ValaParameter* vala_parameter_new_with_ellipsis (ValaSourceReference* source_reference);
ValaParameter* vala_parameter_construct_with_ellipsis (GType object_type, ValaSourceReference* source_reference);
void vala_parameter_set_ellipsis (ValaParameter* self, gboolean value);
static void vala_parameter_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
void vala_code_visitor_visit_formal_parameter (ValaCodeVisitor* self, ValaParameter* p);
static void vala_parameter_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor);
gboolean vala_parameter_get_ellipsis (ValaParameter* self);
ValaDataType* vala_variable_get_variable_type (ValaVariable* self);
void vala_code_node_accept (ValaCodeNode* self, ValaCodeVisitor* visitor);
ValaExpression* vala_variable_get_initializer (ValaVariable* self);
static void vala_parameter_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type);
void vala_variable_set_variable_type (ValaVariable* self, ValaDataType* value);
static void vala_parameter_real_replace_expression (ValaCodeNode* base, ValaExpression* old_node, ValaExpression* new_node);
void vala_variable_set_initializer (ValaVariable* self, ValaExpression* value);
ValaParameter* vala_parameter_copy (ValaParameter* self);
const gchar* vala_symbol_get_name (ValaSymbol* self);
ValaDataType* vala_data_type_copy (ValaDataType* self);
ValaSourceReference* vala_code_node_get_source_reference (ValaCodeNode* self);
gboolean vala_parameter_get_params_array (ValaParameter* self);
void vala_parameter_set_params_array (ValaParameter* self, gboolean value);
ValaParameterDirection vala_parameter_get_direction (ValaParameter* self);
void vala_parameter_set_direction (ValaParameter* self, ValaParameterDirection value);
static gboolean vala_parameter_real_check (ValaCodeNode* base, ValaCodeContext* context);
gboolean vala_code_node_get_checked (ValaCodeNode* self);
gboolean vala_code_node_get_error (ValaCodeNode* self);
void vala_code_node_set_checked (ValaCodeNode* self, gboolean value);
gpointer vala_source_file_ref (gpointer instance);
void vala_source_file_unref (gpointer instance);
GParamSpec* vala_param_spec_source_file (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_file (GValue* value, gpointer v_object);
void vala_value_take_source_file (GValue* value, gpointer v_object);
gpointer vala_value_get_source_file (const GValue* value);
GType vala_source_file_get_type (void) G_GNUC_CONST;
GType vala_semantic_analyzer_get_type (void) G_GNUC_CONST;
ValaSemanticAnalyzer* vala_code_context_get_analyzer (ValaCodeContext* self);
ValaSourceFile* vala_semantic_analyzer_get_current_source_file (ValaSemanticAnalyzer* self);
ValaSymbol* vala_semantic_analyzer_get_current_symbol (ValaSemanticAnalyzer* self);
ValaSourceFile* vala_source_reference_get_file (ValaSourceReference* self);
void vala_semantic_analyzer_set_current_source_file (ValaSemanticAnalyzer* self, ValaSourceFile* value);
ValaSymbol* vala_symbol_get_parent_symbol (ValaSymbol* self);
void vala_semantic_analyzer_set_current_symbol (ValaSemanticAnalyzer* self, ValaSymbol* value);
GType vala_void_type_get_type (void) G_GNUC_CONST;
void vala_code_node_set_error (ValaCodeNode* self, gboolean value);
void vala_report_error (ValaSourceReference* source, const gchar* message);
gboolean vala_code_node_check (ValaCodeNode* self, ValaCodeContext* context);
GType vala_reference_type_get_type (void) G_GNUC_CONST;
GType vala_array_type_get_type (void) G_GNUC_CONST;
gboolean vala_code_node_has_attribute_argument (ValaCodeNode* self, const gchar* attribute, const gchar* argument);
GType vala_delegate_type_get_type (void) G_GNUC_CONST;
gchar* vala_code_node_get_attribute_string (ValaCodeNode* self, const gchar* attribute, const gchar* argument, const gchar* default_value);
void vala_delegate_type_set_is_called_once (ValaDelegateType* self, gboolean value);
void vala_expression_set_target_type (ValaExpression* self, ValaDataType* value);
GType vala_literal_get_type (void) G_GNUC_CONST;
GType vala_null_literal_get_type (void) G_GNUC_CONST;
gboolean vala_data_type_get_nullable (ValaDataType* self);
void vala_report_warning (ValaSourceReference* source, const gchar* message);
gchar* vala_code_node_to_string (ValaCodeNode* self);
ValaDataType* vala_expression_get_value_type (ValaExpression* self);
gboolean vala_data_type_compatible (ValaDataType* self, ValaDataType* target_type);
gboolean vala_semantic_analyzer_is_type_accessible (ValaSemanticAnalyzer* self, ValaSymbol* sym, ValaDataType* type);
gchar* vala_symbol_get_full_name (ValaSymbol* self);
ValaMethod* vala_method_get_base_method (ValaMethod* self);
ValaMethod* vala_method_get_base_interface_method (ValaMethod* self);
ValaList* vala_method_get_parameters (ValaMethod* self);
void vala_parameter_set_base_parameter (ValaParameter* self, ValaParameter* value);
gboolean vala_parameter_get_captured (ValaParameter* self);
void vala_parameter_set_captured (ValaParameter* self, gboolean value);
ValaParameter* vala_parameter_get_base_parameter (ValaParameter* self);
static void vala_parameter_finalize (ValaCodeNode* obj);


/**
 * Creates a new formal parameter.
 *
 * @param name              parameter name
 * @param variable_type     parameter type
 * @param source_reference  reference to source code
 * @return                  newly created formal parameter
 */
ValaParameter* vala_parameter_construct (GType object_type, const gchar* name, ValaDataType* variable_type, ValaSourceReference* source_reference) {
	ValaParameter* self = NULL;
	ValaDataType* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	ValaSourceReference* _tmp2_ = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = variable_type;
	_tmp1_ = name;
	_tmp2_ = source_reference;
	self = (ValaParameter*) vala_variable_construct (object_type, _tmp0_, _tmp1_, NULL, _tmp2_, NULL);
	vala_symbol_set_access ((ValaSymbol*) self, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	return self;
}


ValaParameter* vala_parameter_new (const gchar* name, ValaDataType* variable_type, ValaSourceReference* source_reference) {
	return vala_parameter_construct (VALA_TYPE_PARAMETER, name, variable_type, source_reference);
}


/**
 * Creates a new ellipsis parameter representing an indefinite number of
 * parameters.
 */
ValaParameter* vala_parameter_construct_with_ellipsis (GType object_type, ValaSourceReference* source_reference) {
	ValaParameter* self = NULL;
	ValaSourceReference* _tmp0_ = NULL;
	_tmp0_ = source_reference;
	self = (ValaParameter*) vala_variable_construct (object_type, NULL, NULL, NULL, _tmp0_, NULL);
	vala_parameter_set_ellipsis (self, TRUE);
	vala_symbol_set_access ((ValaSymbol*) self, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	return self;
}


ValaParameter* vala_parameter_new_with_ellipsis (ValaSourceReference* source_reference) {
	return vala_parameter_construct_with_ellipsis (VALA_TYPE_PARAMETER, source_reference);
}


static void vala_parameter_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaParameter * self;
	ValaCodeVisitor* _tmp0_ = NULL;
	self = (ValaParameter*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = visitor;
	vala_code_visitor_visit_formal_parameter (_tmp0_, self);
}


static void vala_parameter_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaParameter * self;
	gboolean _tmp0_ = FALSE;
	self = (ValaParameter*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = self->priv->_ellipsis;
	if (!_tmp0_) {
		ValaDataType* _tmp1_ = NULL;
		ValaDataType* _tmp2_ = NULL;
		ValaCodeVisitor* _tmp3_ = NULL;
		ValaExpression* _tmp4_ = NULL;
		ValaExpression* _tmp5_ = NULL;
		_tmp1_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp2_ = _tmp1_;
		_tmp3_ = visitor;
		vala_code_node_accept ((ValaCodeNode*) _tmp2_, _tmp3_);
		_tmp4_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp5_ = _tmp4_;
		if (_tmp5_ != NULL) {
			ValaExpression* _tmp6_ = NULL;
			ValaExpression* _tmp7_ = NULL;
			ValaCodeVisitor* _tmp8_ = NULL;
			_tmp6_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp7_ = _tmp6_;
			_tmp8_ = visitor;
			vala_code_node_accept ((ValaCodeNode*) _tmp7_, _tmp8_);
		}
	}
}


static void vala_parameter_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type) {
	ValaParameter * self;
	ValaDataType* _tmp0_ = NULL;
	ValaDataType* _tmp1_ = NULL;
	ValaDataType* _tmp2_ = NULL;
	self = (ValaParameter*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = old_type;
	if (_tmp1_ == _tmp2_) {
		ValaDataType* _tmp3_ = NULL;
		_tmp3_ = new_type;
		vala_variable_set_variable_type ((ValaVariable*) self, _tmp3_);
	}
}


static void vala_parameter_real_replace_expression (ValaCodeNode* base, ValaExpression* old_node, ValaExpression* new_node) {
	ValaParameter * self;
	ValaExpression* _tmp0_ = NULL;
	ValaExpression* _tmp1_ = NULL;
	ValaExpression* _tmp2_ = NULL;
	self = (ValaParameter*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = old_node;
	if (_tmp1_ == _tmp2_) {
		ValaExpression* _tmp3_ = NULL;
		_tmp3_ = new_node;
		vala_variable_set_initializer ((ValaVariable*) self, _tmp3_);
	}
}


static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


ValaParameter* vala_parameter_copy (ValaParameter* self) {
	ValaParameter* result = NULL;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_ellipsis;
	if (!_tmp0_) {
		ValaParameter* _result_ = NULL;
		const gchar* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		ValaDataType* _tmp3_ = NULL;
		ValaDataType* _tmp4_ = NULL;
		ValaDataType* _tmp5_ = NULL;
		ValaDataType* _tmp6_ = NULL;
		ValaSourceReference* _tmp7_ = NULL;
		ValaSourceReference* _tmp8_ = NULL;
		ValaParameter* _tmp9_ = NULL;
		ValaParameter* _tmp10_ = NULL;
		ValaParameter* _tmp11_ = NULL;
		gboolean _tmp12_ = FALSE;
		ValaParameter* _tmp13_ = NULL;
		ValaParameterDirection _tmp14_ = 0;
		ValaParameter* _tmp15_ = NULL;
		ValaExpression* _tmp16_ = NULL;
		ValaExpression* _tmp17_ = NULL;
		GList* _tmp18_ = NULL;
		_tmp1_ = vala_symbol_get_name ((ValaSymbol*) self);
		_tmp2_ = _tmp1_;
		_tmp3_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp4_ = _tmp3_;
		_tmp5_ = vala_data_type_copy (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp8_ = _tmp7_;
		_tmp9_ = vala_parameter_new (_tmp2_, _tmp6_, _tmp8_);
		_tmp10_ = _tmp9_;
		_vala_code_node_unref0 (_tmp6_);
		_result_ = _tmp10_;
		_tmp11_ = _result_;
		_tmp12_ = self->priv->_params_array;
		vala_parameter_set_params_array (_tmp11_, _tmp12_);
		_tmp13_ = _result_;
		_tmp14_ = self->priv->_direction;
		vala_parameter_set_direction (_tmp13_, _tmp14_);
		_tmp15_ = _result_;
		_tmp16_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp17_ = _tmp16_;
		vala_variable_set_initializer ((ValaVariable*) _tmp15_, _tmp17_);
		_tmp18_ = ((ValaCodeNode*) self)->attributes;
		{
			GList* a_collection = NULL;
			GList* a_it = NULL;
			a_collection = _tmp18_;
			for (a_it = a_collection; a_it != NULL; a_it = a_it->next) {
				ValaAttribute* _tmp19_ = NULL;
				ValaAttribute* a = NULL;
				_tmp19_ = _vala_code_node_ref0 ((ValaAttribute*) a_it->data);
				a = _tmp19_;
				{
					ValaParameter* _tmp20_ = NULL;
					ValaAttribute* _tmp21_ = NULL;
					ValaAttribute* _tmp22_ = NULL;
					_tmp20_ = _result_;
					_tmp21_ = a;
					_tmp22_ = _vala_code_node_ref0 (_tmp21_);
					((ValaCodeNode*) _tmp20_)->attributes = g_list_append (((ValaCodeNode*) _tmp20_)->attributes, _tmp22_);
					_vala_code_node_unref0 (a);
				}
			}
		}
		result = _result_;
		return result;
	} else {
		ValaParameter* _tmp23_ = NULL;
		_tmp23_ = vala_parameter_new_with_ellipsis (NULL);
		result = _tmp23_;
		return result;
	}
}


static gpointer _vala_source_file_ref0 (gpointer self) {
	return self ? vala_source_file_ref (self) : NULL;
}


static gboolean vala_parameter_real_check (ValaCodeNode* base, ValaCodeContext* context) {
	ValaParameter * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaSourceFile* old_source_file = NULL;
	ValaCodeContext* _tmp4_ = NULL;
	ValaSemanticAnalyzer* _tmp5_ = NULL;
	ValaSemanticAnalyzer* _tmp6_ = NULL;
	ValaSourceFile* _tmp7_ = NULL;
	ValaSourceFile* _tmp8_ = NULL;
	ValaSourceFile* _tmp9_ = NULL;
	ValaSymbol* old_symbol = NULL;
	ValaCodeContext* _tmp10_ = NULL;
	ValaSemanticAnalyzer* _tmp11_ = NULL;
	ValaSemanticAnalyzer* _tmp12_ = NULL;
	ValaSymbol* _tmp13_ = NULL;
	ValaSymbol* _tmp14_ = NULL;
	ValaSymbol* _tmp15_ = NULL;
	ValaSourceReference* _tmp16_ = NULL;
	ValaSourceReference* _tmp17_ = NULL;
	ValaCodeContext* _tmp25_ = NULL;
	ValaSemanticAnalyzer* _tmp26_ = NULL;
	ValaSemanticAnalyzer* _tmp27_ = NULL;
	ValaSymbol* _tmp28_ = NULL;
	ValaSymbol* _tmp29_ = NULL;
	ValaDataType* _tmp30_ = NULL;
	ValaDataType* _tmp31_ = NULL;
	gboolean _tmp39_ = FALSE;
	ValaExpression* _tmp70_ = NULL;
	ValaExpression* _tmp71_ = NULL;
	gboolean _tmp123_ = FALSE;
	ValaMethod* m = NULL;
	ValaSymbol* _tmp142_ = NULL;
	ValaSymbol* _tmp143_ = NULL;
	ValaMethod* _tmp144_ = NULL;
	ValaMethod* _tmp145_ = NULL;
	ValaCodeContext* _tmp173_ = NULL;
	ValaSemanticAnalyzer* _tmp174_ = NULL;
	ValaSemanticAnalyzer* _tmp175_ = NULL;
	ValaSourceFile* _tmp176_ = NULL;
	ValaCodeContext* _tmp177_ = NULL;
	ValaSemanticAnalyzer* _tmp178_ = NULL;
	ValaSemanticAnalyzer* _tmp179_ = NULL;
	ValaSymbol* _tmp180_ = NULL;
	gboolean _tmp181_ = FALSE;
	gboolean _tmp182_ = FALSE;
	self = (ValaParameter*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_ = FALSE;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = context;
	_tmp5_ = vala_code_context_get_analyzer (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_semantic_analyzer_get_current_source_file (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = _vala_source_file_ref0 (_tmp8_);
	old_source_file = _tmp9_;
	_tmp10_ = context;
	_tmp11_ = vala_code_context_get_analyzer (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = vala_semantic_analyzer_get_current_symbol (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = _vala_code_node_ref0 (_tmp14_);
	old_symbol = _tmp15_;
	_tmp16_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp17_ = _tmp16_;
	if (_tmp17_ != NULL) {
		ValaCodeContext* _tmp18_ = NULL;
		ValaSemanticAnalyzer* _tmp19_ = NULL;
		ValaSemanticAnalyzer* _tmp20_ = NULL;
		ValaSourceReference* _tmp21_ = NULL;
		ValaSourceReference* _tmp22_ = NULL;
		ValaSourceFile* _tmp23_ = NULL;
		ValaSourceFile* _tmp24_ = NULL;
		_tmp18_ = context;
		_tmp19_ = vala_code_context_get_analyzer (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp22_ = _tmp21_;
		_tmp23_ = vala_source_reference_get_file (_tmp22_);
		_tmp24_ = _tmp23_;
		vala_semantic_analyzer_set_current_source_file (_tmp20_, _tmp24_);
	}
	_tmp25_ = context;
	_tmp26_ = vala_code_context_get_analyzer (_tmp25_);
	_tmp27_ = _tmp26_;
	_tmp28_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
	_tmp29_ = _tmp28_;
	vala_semantic_analyzer_set_current_symbol (_tmp27_, _tmp29_);
	_tmp30_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp31_ = _tmp30_;
	if (_tmp31_ != NULL) {
		ValaDataType* _tmp32_ = NULL;
		ValaDataType* _tmp33_ = NULL;
		ValaDataType* _tmp36_ = NULL;
		ValaDataType* _tmp37_ = NULL;
		ValaCodeContext* _tmp38_ = NULL;
		_tmp32_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp33_ = _tmp32_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp33_, VALA_TYPE_VOID_TYPE)) {
			ValaSourceReference* _tmp34_ = NULL;
			ValaSourceReference* _tmp35_ = NULL;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp34_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp35_ = _tmp34_;
			vala_report_error (_tmp35_, "'void' not supported as parameter type");
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp36_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp37_ = _tmp36_;
		_tmp38_ = context;
		vala_code_node_check ((ValaCodeNode*) _tmp37_, _tmp38_);
	}
	_tmp39_ = self->priv->_ellipsis;
	if (!_tmp39_) {
		ValaDataType* _tmp40_ = NULL;
		ValaDataType* _tmp41_ = NULL;
		ValaCodeContext* _tmp42_ = NULL;
		gboolean _tmp43_ = FALSE;
		gboolean _tmp44_ = FALSE;
		gboolean _tmp49_ = FALSE;
		gboolean _tmp50_ = FALSE;
		ValaExpression* _tmp59_ = NULL;
		ValaExpression* _tmp60_ = NULL;
		_tmp40_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp41_ = _tmp40_;
		_tmp42_ = context;
		vala_code_node_check ((ValaCodeNode*) _tmp41_, _tmp42_);
		_tmp44_ = self->priv->_params_array;
		if (_tmp44_) {
			ValaDataType* _tmp45_ = NULL;
			ValaDataType* _tmp46_ = NULL;
			_tmp45_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp46_ = _tmp45_;
			_tmp43_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp46_, VALA_TYPE_ARRAY_TYPE);
		} else {
			_tmp43_ = FALSE;
		}
		if (_tmp43_) {
			ValaSourceReference* _tmp47_ = NULL;
			ValaSourceReference* _tmp48_ = NULL;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp47_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp48_ = _tmp47_;
			vala_report_error (_tmp48_, "parameter array expected");
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp50_ = vala_code_node_has_attribute_argument ((ValaCodeNode*) self, "CCode", "scope");
		if (_tmp50_) {
			ValaDataType* _tmp51_ = NULL;
			ValaDataType* _tmp52_ = NULL;
			_tmp51_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp52_ = _tmp51_;
			_tmp49_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp52_, VALA_TYPE_DELEGATE_TYPE);
		} else {
			_tmp49_ = FALSE;
		}
		if (_tmp49_) {
			ValaDelegateType* delegate_type = NULL;
			ValaDataType* _tmp53_ = NULL;
			ValaDataType* _tmp54_ = NULL;
			ValaDelegateType* _tmp55_ = NULL;
			ValaDelegateType* _tmp56_ = NULL;
			gchar* _tmp57_ = NULL;
			gchar* _tmp58_ = NULL;
			_tmp53_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp54_ = _tmp53_;
			_tmp55_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp54_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
			delegate_type = _tmp55_;
			_tmp56_ = delegate_type;
			_tmp57_ = vala_code_node_get_attribute_string ((ValaCodeNode*) self, "CCode", "scope", NULL);
			_tmp58_ = _tmp57_;
			vala_delegate_type_set_is_called_once (_tmp56_, g_strcmp0 (_tmp58_, "async") == 0);
			_g_free0 (_tmp58_);
			_vala_code_node_unref0 (delegate_type);
		}
		_tmp59_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp60_ = _tmp59_;
		if (_tmp60_ != NULL) {
			ValaExpression* _tmp61_ = NULL;
			ValaExpression* _tmp62_ = NULL;
			ValaDataType* _tmp63_ = NULL;
			ValaDataType* _tmp64_ = NULL;
			ValaDataType* _tmp65_ = NULL;
			ValaDataType* _tmp66_ = NULL;
			ValaExpression* _tmp67_ = NULL;
			ValaExpression* _tmp68_ = NULL;
			ValaCodeContext* _tmp69_ = NULL;
			_tmp61_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp62_ = _tmp61_;
			_tmp63_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp64_ = _tmp63_;
			_tmp65_ = vala_data_type_copy (_tmp64_);
			_tmp66_ = _tmp65_;
			vala_expression_set_target_type (_tmp62_, _tmp66_);
			_vala_code_node_unref0 (_tmp66_);
			_tmp67_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp68_ = _tmp67_;
			_tmp69_ = context;
			vala_code_node_check ((ValaCodeNode*) _tmp68_, _tmp69_);
		}
	}
	_tmp70_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp71_ = _tmp70_;
	if (_tmp71_ != NULL) {
		gboolean _tmp72_ = FALSE;
		gboolean _tmp73_ = FALSE;
		ValaExpression* _tmp74_ = NULL;
		ValaExpression* _tmp75_ = NULL;
		_tmp74_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp75_ = _tmp74_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp75_, VALA_TYPE_NULL_LITERAL)) {
			ValaDataType* _tmp76_ = NULL;
			ValaDataType* _tmp77_ = NULL;
			gboolean _tmp78_ = FALSE;
			gboolean _tmp79_ = FALSE;
			_tmp76_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp77_ = _tmp76_;
			_tmp78_ = vala_data_type_get_nullable (_tmp77_);
			_tmp79_ = _tmp78_;
			_tmp73_ = !_tmp79_;
		} else {
			_tmp73_ = FALSE;
		}
		if (_tmp73_) {
			ValaParameterDirection _tmp80_ = 0;
			_tmp80_ = self->priv->_direction;
			_tmp72_ = _tmp80_ != VALA_PARAMETER_DIRECTION_OUT;
		} else {
			_tmp72_ = FALSE;
		}
		if (_tmp72_) {
			ValaSourceReference* _tmp81_ = NULL;
			ValaSourceReference* _tmp82_ = NULL;
			ValaDataType* _tmp83_ = NULL;
			ValaDataType* _tmp84_ = NULL;
			gchar* _tmp85_ = NULL;
			gchar* _tmp86_ = NULL;
			gchar* _tmp87_ = NULL;
			gchar* _tmp88_ = NULL;
			_tmp81_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp82_ = _tmp81_;
			_tmp83_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp84_ = _tmp83_;
			_tmp85_ = vala_code_node_to_string ((ValaCodeNode*) _tmp84_);
			_tmp86_ = _tmp85_;
			_tmp87_ = g_strdup_printf ("`null' incompatible with parameter type `%s`", _tmp86_);
			_tmp88_ = _tmp87_;
			vala_report_warning (_tmp82_, _tmp88_);
			_g_free0 (_tmp88_);
			_g_free0 (_tmp86_);
		} else {
			gboolean _tmp89_ = FALSE;
			ValaExpression* _tmp90_ = NULL;
			ValaExpression* _tmp91_ = NULL;
			_tmp90_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp91_ = _tmp90_;
			if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp91_, VALA_TYPE_NULL_LITERAL)) {
				ValaParameterDirection _tmp92_ = 0;
				_tmp92_ = self->priv->_direction;
				_tmp89_ = _tmp92_ == VALA_PARAMETER_DIRECTION_OUT;
			} else {
				_tmp89_ = FALSE;
			}
			if (_tmp89_) {
				ValaSourceReference* _tmp93_ = NULL;
				ValaSourceReference* _tmp94_ = NULL;
				_tmp93_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp94_ = _tmp93_;
				vala_report_error (_tmp94_, "only `null' is allowed as default value for out parameters");
			} else {
				gboolean _tmp95_ = FALSE;
				ValaParameterDirection _tmp96_ = 0;
				_tmp96_ = self->priv->_direction;
				if (_tmp96_ == VALA_PARAMETER_DIRECTION_IN) {
					ValaExpression* _tmp97_ = NULL;
					ValaExpression* _tmp98_ = NULL;
					ValaDataType* _tmp99_ = NULL;
					ValaDataType* _tmp100_ = NULL;
					ValaDataType* _tmp101_ = NULL;
					ValaDataType* _tmp102_ = NULL;
					gboolean _tmp103_ = FALSE;
					_tmp97_ = vala_variable_get_initializer ((ValaVariable*) self);
					_tmp98_ = _tmp97_;
					_tmp99_ = vala_expression_get_value_type (_tmp98_);
					_tmp100_ = _tmp99_;
					_tmp101_ = vala_variable_get_variable_type ((ValaVariable*) self);
					_tmp102_ = _tmp101_;
					_tmp103_ = vala_data_type_compatible (_tmp100_, _tmp102_);
					_tmp95_ = !_tmp103_;
				} else {
					_tmp95_ = FALSE;
				}
				if (_tmp95_) {
					ValaExpression* _tmp104_ = NULL;
					ValaExpression* _tmp105_ = NULL;
					ValaSourceReference* _tmp106_ = NULL;
					ValaSourceReference* _tmp107_ = NULL;
					ValaExpression* _tmp108_ = NULL;
					ValaExpression* _tmp109_ = NULL;
					ValaDataType* _tmp110_ = NULL;
					ValaDataType* _tmp111_ = NULL;
					gchar* _tmp112_ = NULL;
					gchar* _tmp113_ = NULL;
					ValaDataType* _tmp114_ = NULL;
					ValaDataType* _tmp115_ = NULL;
					gchar* _tmp116_ = NULL;
					gchar* _tmp117_ = NULL;
					gchar* _tmp118_ = NULL;
					gchar* _tmp119_ = NULL;
					_tmp104_ = vala_variable_get_initializer ((ValaVariable*) self);
					_tmp105_ = _tmp104_;
					_tmp106_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp105_);
					_tmp107_ = _tmp106_;
					_tmp108_ = vala_variable_get_initializer ((ValaVariable*) self);
					_tmp109_ = _tmp108_;
					_tmp110_ = vala_expression_get_value_type (_tmp109_);
					_tmp111_ = _tmp110_;
					_tmp112_ = vala_code_node_to_string ((ValaCodeNode*) _tmp111_);
					_tmp113_ = _tmp112_;
					_tmp114_ = vala_variable_get_variable_type ((ValaVariable*) self);
					_tmp115_ = _tmp114_;
					_tmp116_ = vala_code_node_to_string ((ValaCodeNode*) _tmp115_);
					_tmp117_ = _tmp116_;
					_tmp118_ = g_strdup_printf ("Cannot convert from `%s' to `%s'", _tmp113_, _tmp117_);
					_tmp119_ = _tmp118_;
					vala_report_error (_tmp107_, _tmp119_);
					_g_free0 (_tmp119_);
					_g_free0 (_tmp117_);
					_g_free0 (_tmp113_);
				} else {
					ValaParameterDirection _tmp120_ = 0;
					_tmp120_ = self->priv->_direction;
					if (_tmp120_ == VALA_PARAMETER_DIRECTION_REF) {
						ValaSourceReference* _tmp121_ = NULL;
						ValaSourceReference* _tmp122_ = NULL;
						_tmp121_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp122_ = _tmp121_;
						vala_report_error (_tmp122_, "default value not allowed for ref parameter");
					}
				}
			}
		}
	}
	_tmp123_ = self->priv->_ellipsis;
	if (!_tmp123_) {
		ValaCodeContext* _tmp124_ = NULL;
		ValaSemanticAnalyzer* _tmp125_ = NULL;
		ValaSemanticAnalyzer* _tmp126_ = NULL;
		ValaDataType* _tmp127_ = NULL;
		ValaDataType* _tmp128_ = NULL;
		gboolean _tmp129_ = FALSE;
		_tmp124_ = context;
		_tmp125_ = vala_code_context_get_analyzer (_tmp124_);
		_tmp126_ = _tmp125_;
		_tmp127_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp128_ = _tmp127_;
		_tmp129_ = vala_semantic_analyzer_is_type_accessible (_tmp126_, (ValaSymbol*) self, _tmp128_);
		if (!_tmp129_) {
			ValaSourceReference* _tmp130_ = NULL;
			ValaSourceReference* _tmp131_ = NULL;
			ValaDataType* _tmp132_ = NULL;
			ValaDataType* _tmp133_ = NULL;
			gchar* _tmp134_ = NULL;
			gchar* _tmp135_ = NULL;
			ValaSymbol* _tmp136_ = NULL;
			ValaSymbol* _tmp137_ = NULL;
			gchar* _tmp138_ = NULL;
			gchar* _tmp139_ = NULL;
			gchar* _tmp140_ = NULL;
			gchar* _tmp141_ = NULL;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp130_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp131_ = _tmp130_;
			_tmp132_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp133_ = _tmp132_;
			_tmp134_ = vala_code_node_to_string ((ValaCodeNode*) _tmp133_);
			_tmp135_ = _tmp134_;
			_tmp136_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp137_ = _tmp136_;
			_tmp138_ = vala_symbol_get_full_name (_tmp137_);
			_tmp139_ = _tmp138_;
			_tmp140_ = g_strdup_printf ("parameter type `%s` is less accessible than method `%s`", _tmp135_, _tmp139_);
			_tmp141_ = _tmp140_;
			vala_report_error (_tmp131_, _tmp141_);
			_g_free0 (_tmp141_);
			_g_free0 (_tmp139_);
			_g_free0 (_tmp135_);
		}
	}
	_tmp142_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
	_tmp143_ = _tmp142_;
	_tmp144_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp143_, VALA_TYPE_METHOD) ? ((ValaMethod*) _tmp143_) : NULL);
	m = _tmp144_;
	_tmp145_ = m;
	if (_tmp145_ != NULL) {
		ValaMethod* _tmp146_ = NULL;
		ValaMethod* _tmp147_ = NULL;
		ValaMethod* _tmp148_ = NULL;
		ValaMethod* _tmp149_ = NULL;
		ValaMethod* base_method = NULL;
		ValaMethod* _tmp156_ = NULL;
		gboolean _tmp157_ = FALSE;
		ValaMethod* _tmp158_ = NULL;
		_tmp147_ = m;
		_tmp148_ = vala_method_get_base_method (_tmp147_);
		_tmp149_ = _tmp148_;
		if (_tmp149_ != NULL) {
			ValaMethod* _tmp150_ = NULL;
			ValaMethod* _tmp151_ = NULL;
			ValaMethod* _tmp152_ = NULL;
			_tmp150_ = m;
			_tmp151_ = vala_method_get_base_method (_tmp150_);
			_tmp152_ = _tmp151_;
			_tmp146_ = _tmp152_;
		} else {
			ValaMethod* _tmp153_ = NULL;
			ValaMethod* _tmp154_ = NULL;
			ValaMethod* _tmp155_ = NULL;
			_tmp153_ = m;
			_tmp154_ = vala_method_get_base_interface_method (_tmp153_);
			_tmp155_ = _tmp154_;
			_tmp146_ = _tmp155_;
		}
		_tmp156_ = _vala_code_node_ref0 (_tmp146_);
		base_method = _tmp156_;
		_tmp158_ = base_method;
		if (_tmp158_ != NULL) {
			ValaMethod* _tmp159_ = NULL;
			ValaMethod* _tmp160_ = NULL;
			_tmp159_ = base_method;
			_tmp160_ = m;
			_tmp157_ = _tmp159_ != _tmp160_;
		} else {
			_tmp157_ = FALSE;
		}
		if (_tmp157_) {
			gint index = 0;
			ValaMethod* _tmp161_ = NULL;
			ValaList* _tmp162_ = NULL;
			ValaList* _tmp163_ = NULL;
			gint _tmp164_ = 0;
			gint _tmp165_ = 0;
			gint _tmp166_ = 0;
			_tmp161_ = m;
			_tmp162_ = vala_method_get_parameters (_tmp161_);
			_tmp163_ = _tmp162_;
			_tmp164_ = vala_list_index_of (_tmp163_, self);
			_tmp165_ = _tmp164_;
			_vala_iterable_unref0 (_tmp163_);
			index = _tmp165_;
			_tmp166_ = index;
			if (_tmp166_ >= 0) {
				ValaMethod* _tmp167_ = NULL;
				ValaList* _tmp168_ = NULL;
				ValaList* _tmp169_ = NULL;
				gint _tmp170_ = 0;
				gpointer _tmp171_ = NULL;
				ValaParameter* _tmp172_ = NULL;
				_tmp167_ = base_method;
				_tmp168_ = vala_method_get_parameters (_tmp167_);
				_tmp169_ = _tmp168_;
				_tmp170_ = index;
				_tmp171_ = vala_list_get (_tmp169_, _tmp170_);
				_tmp172_ = (ValaParameter*) _tmp171_;
				vala_parameter_set_base_parameter (self, _tmp172_);
				_vala_code_node_unref0 (_tmp172_);
				_vala_iterable_unref0 (_tmp169_);
			}
		}
		_vala_code_node_unref0 (base_method);
	}
	_tmp173_ = context;
	_tmp174_ = vala_code_context_get_analyzer (_tmp173_);
	_tmp175_ = _tmp174_;
	_tmp176_ = old_source_file;
	vala_semantic_analyzer_set_current_source_file (_tmp175_, _tmp176_);
	_tmp177_ = context;
	_tmp178_ = vala_code_context_get_analyzer (_tmp177_);
	_tmp179_ = _tmp178_;
	_tmp180_ = old_symbol;
	vala_semantic_analyzer_set_current_symbol (_tmp179_, _tmp180_);
	_tmp181_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp182_ = _tmp181_;
	result = !_tmp182_;
	_vala_code_node_unref0 (m);
	_vala_code_node_unref0 (old_symbol);
	_vala_source_file_unref0 (old_source_file);
	return result;
}


ValaParameterDirection vala_parameter_get_direction (ValaParameter* self) {
	ValaParameterDirection result;
	ValaParameterDirection _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_direction;
	result = _tmp0_;
	return result;
}


void vala_parameter_set_direction (ValaParameter* self, ValaParameterDirection value) {
	ValaParameterDirection _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_direction = _tmp0_;
}


gboolean vala_parameter_get_ellipsis (ValaParameter* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_ellipsis;
	result = _tmp0_;
	return result;
}


void vala_parameter_set_ellipsis (ValaParameter* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_ellipsis = _tmp0_;
}


gboolean vala_parameter_get_params_array (ValaParameter* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_params_array;
	result = _tmp0_;
	return result;
}


void vala_parameter_set_params_array (ValaParameter* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_params_array = _tmp0_;
}


gboolean vala_parameter_get_captured (ValaParameter* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_captured;
	result = _tmp0_;
	return result;
}


void vala_parameter_set_captured (ValaParameter* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_captured = _tmp0_;
}


ValaParameter* vala_parameter_get_base_parameter (ValaParameter* self) {
	ValaParameter* result;
	ValaParameter* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_base_parameter;
	result = _tmp0_;
	return result;
}


void vala_parameter_set_base_parameter (ValaParameter* self, ValaParameter* value) {
	ValaParameter* _tmp0_ = NULL;
	ValaParameter* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	_vala_code_node_unref0 (self->priv->_base_parameter);
	self->priv->_base_parameter = _tmp1_;
}


static void vala_parameter_class_init (ValaParameterClass * klass) {
	vala_parameter_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_parameter_finalize;
	g_type_class_add_private (klass, sizeof (ValaParameterPrivate));
	((ValaCodeNodeClass *) klass)->accept = vala_parameter_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = vala_parameter_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_type = vala_parameter_real_replace_type;
	((ValaCodeNodeClass *) klass)->replace_expression = vala_parameter_real_replace_expression;
	((ValaCodeNodeClass *) klass)->check = vala_parameter_real_check;
}


static void vala_parameter_instance_init (ValaParameter * self) {
	self->priv = VALA_PARAMETER_GET_PRIVATE (self);
	self->priv->_direction = VALA_PARAMETER_DIRECTION_IN;
}


static void vala_parameter_finalize (ValaCodeNode* obj) {
	ValaParameter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_PARAMETER, ValaParameter);
	_vala_code_node_unref0 (self->priv->_base_parameter);
	VALA_CODE_NODE_CLASS (vala_parameter_parent_class)->finalize (obj);
}


/**
 * Represents a formal parameter in method and callback signatures.
 */
GType vala_parameter_get_type (void) {
	static volatile gsize vala_parameter_type_id__volatile = 0;
	if (g_once_init_enter (&vala_parameter_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaParameterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_parameter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaParameter), 0, (GInstanceInitFunc) vala_parameter_instance_init, NULL };
		GType vala_parameter_type_id;
		vala_parameter_type_id = g_type_register_static (VALA_TYPE_VARIABLE, "ValaParameter", &g_define_type_info, 0);
		g_once_init_leave (&vala_parameter_type_id__volatile, vala_parameter_type_id);
	}
	return vala_parameter_type_id__volatile;
}


GType vala_parameter_direction_get_type (void) {
	static volatile gsize vala_parameter_direction_type_id__volatile = 0;
	if (g_once_init_enter (&vala_parameter_direction_type_id__volatile)) {
		static const GEnumValue values[] = {{VALA_PARAMETER_DIRECTION_IN, "VALA_PARAMETER_DIRECTION_IN", "in"}, {VALA_PARAMETER_DIRECTION_OUT, "VALA_PARAMETER_DIRECTION_OUT", "out"}, {VALA_PARAMETER_DIRECTION_REF, "VALA_PARAMETER_DIRECTION_REF", "ref"}, {0, NULL, NULL}};
		GType vala_parameter_direction_type_id;
		vala_parameter_direction_type_id = g_enum_register_static ("ValaParameterDirection", values);
		g_once_init_leave (&vala_parameter_direction_type_id__volatile, vala_parameter_direction_type_id);
	}
	return vala_parameter_direction_type_id__volatile;
}



