// Generated by gmmproc 2.47.4 -- DO NOT MODIFY!
#ifndef _GTKMM_TEXTVIEW_H
#define _GTKMM_TEXTVIEW_H

#include <gtkmmconfig.h>


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* Copyright(C) 2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or(at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

// This is for including the config header before any code (such as
// the #ifndef GTKMM_DISABLE_DEPRECATED in deprecated classes) is generated:


#include <gtkmm/container.h>
#include <gtkmm/scrollable.h>
#include <gtkmm/textbuffer.h>
#include <gtkmm/textmark.h>
#include <gtkmm/menu.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkTextView GtkTextView;
typedef struct _GtkTextViewClass GtkTextViewClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Gtk
{ class TextView_Class; } // namespace Gtk
#endif //DOXYGEN_SHOULD_SKIP_THIS

namespace Gtk
{


/** @addtogroup gtkmmEnums gtkmm Enums and Flags */

/** 
 *  @var TextWindowType TEXT_WINDOW_WIDGET
 * Window that floats over scrolling areas.
 * 
 *  @var TextWindowType TEXT_WINDOW_TEXT
 * Scrollable text window.
 * 
 *  @var TextWindowType TEXT_WINDOW_LEFT
 * Left side border window.
 * 
 *  @var TextWindowType TEXT_WINDOW_RIGHT
 * Right side border window.
 * 
 *  @var TextWindowType TEXT_WINDOW_TOP
 * Top border window.
 * 
 *  @var TextWindowType TEXT_WINDOW_BOTTOM
 * Bottom border window.
 * 
 *  @enum TextWindowType
 * 
 * Used to reference the parts of Gtk::TextView.
 *
 * @ingroup gtkmmEnums
 */
enum TextWindowType
{
  TEXT_WINDOW_PRIVATE,
  TEXT_WINDOW_WIDGET,
  TEXT_WINDOW_TEXT,
  TEXT_WINDOW_LEFT,
  TEXT_WINDOW_RIGHT,
  TEXT_WINDOW_TOP,
  TEXT_WINDOW_BOTTOM
};

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::TextWindowType> : public Glib::Value_Enum<Gtk::TextWindowType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{


/** @defgroup TextView TextView Classes
 * These classes are used with the Gtk::TextView widget.
 */

/** Multi-line text editing widget. It displays a Gtk::TextBuffer.
 *
 * The TextView widget looks like this:
 * @image html textview1.png
 *
 * @ingroup Widgets
 * @ingroup Containers
 * @ingroup TextView
 */

class TextView
 : public Container,
   public Scrollable
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef TextView CppObjectType;
  typedef TextView_Class CppClassType;
  typedef GtkTextView BaseObjectType;
  typedef GtkTextViewClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  TextView(TextView&& src) noexcept;
  TextView& operator=(TextView&& src) noexcept;

  // noncopyable
  TextView(const TextView&) = delete;
  TextView& operator=(const TextView&) = delete;

  ~TextView() noexcept override;

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class TextView_Class;
  static CppClassType textview_class_;

protected:
  explicit TextView(const Glib::ConstructParams& construct_params);
  explicit TextView(GtkTextView* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  GtkTextView*       gobj()       { return reinterpret_cast<GtkTextView*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const GtkTextView* gobj() const { return reinterpret_cast<GtkTextView*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  /// This is a default handler for the signal signal_populate_popup().
  virtual void on_populate_popup(Menu* menu);
  /// This is a default handler for the signal signal_set_anchor().
  virtual void on_set_anchor();
  /// This is a default handler for the signal signal_insert_at_cursor().
  virtual void on_insert_at_cursor(const Glib::ustring& str);


private:

  
public:
  TextView();
  explicit TextView(const Glib::RefPtr<TextBuffer>& buffer);

  
  /** Sets @a buffer as the buffer being displayed by @a text_view. The previous
   * buffer displayed by the text view is unreferenced, and a reference is
   * added to @a buffer. If you owned a reference to @a buffer before passing it
   * to this function, you must remove that reference yourself; Gtk::TextView
   * will not “adopt” it.
   * 
   * @param buffer A Gtk::TextBuffer.
   */
  void set_buffer(const Glib::RefPtr<TextBuffer>& buffer);
  
  /** Returns the Gtk::TextBuffer being displayed by this text view.
   * The reference count on the buffer is not incremented; the caller
   * of this function won’t own a new reference.
   * 
   * @return A Gtk::TextBuffer.
   */
  Glib::RefPtr<TextBuffer> get_buffer();
  
  /** Returns the Gtk::TextBuffer being displayed by this text view.
   * The reference count on the buffer is not incremented; the caller
   * of this function won’t own a new reference.
   * 
   * @return A Gtk::TextBuffer.
   */
  Glib::RefPtr<const TextBuffer> get_buffer() const;

  /** Scrolls the TextView so that @a iter is on the screen, by scrolling the minimal distance to get the mark onscreen,
   * possibly not scrolling at all. The effective screen for purposes of this function is reduced by a margin of size
   * @a within_margin.
   * @note This function uses the currently-computed height of the lines in the text buffer. Note that line heights are computed
   * in an idle handler; so this function may not have the desired effect if it's called before the height computations. To avoid
   * oddness, consider using gtk_text_view_scroll_to_mark() which saves a point to be scrolled to after line validation.
   *
   * @param iter An iterator pointing to the position that should be made visible by scrolling.
   * @param within_margin margin as a [0.0,0.5] fraction of screen size.
   * @result true if scrolling occurred.
   */
  bool scroll_to(TextBuffer::iterator& iter, double within_margin = 0);

  /** Scrolls the TextView so that @a iter is on the screen, in the position indicated by xalign and yalign,
   * possibly not scrolling at all. The effective screen for purposes of this function is reduced by a margin of size
   * @a within_margin.
   * @note This function uses the currently-computed height of the lines in the text buffer. Note that line heights are computed
   * in an idle handler; so this function may not have the desired effect if it's called before the height computations. To avoid
   * oddness, consider using gtk_text_view_scroll_to_mark() which saves a point to be scrolled to after line validation.
   *
   * @param iter An iterator pointing to the position that should be made visible by scrolling.
   * @param within_margin margin as a [0.0,0.5] fraction of screen size.
   * @param xalign horizontal alignment of mark within visible area. An alignment of 0.0 indicates left, 1.0 indicates right, 0.5 means center.
   * @param yalign vertical alignment of mark within visible area. An alignment of 0.0 indicates top, 1.0 indicates bottom, 0.5 means center.
   * @result true if scrolling occurred.
   */
  bool scroll_to(TextBuffer::iterator& iter, double within_margin, double xalign, double yalign);
  

  /** Scrolls text_view so that @a mark is on the screen, by scrolling the minimal distance to get the mark onscreen,
   * possibly not scrolling at all. The effective screen for purposes of this function is reduced by a margin of size
   * @a within_margin.
   *
   * @param mark An mark pointing to the position that should be made visible by scrolling.
   * @param within_margin margin as a [0.0,0.5] fraction of screen size.
   */
  void scroll_to(const Glib::RefPtr<TextBuffer::Mark>& mark, double within_margin = 0);

 /** Scrolls the TextView so that @a iter is on the screen, in the position indicated by xalign and yalign,
   * possibly not scrolling at all. The effective screen for purposes of this function is reduced by a margin of size
   * @a within_margin.
   *
   * @param mark An mark pointing to the position that should be made visible by scrolling.
   * @param within_margin margin as a [0.0,0.5] fraction of screen size.
   * @param xalign horizontal alignment of mark within visible area. An alignment of 0.0 indicates left, 1.0 indicates right, 0.5 means center.
   * @param yalign vertical alignment of mark within visible area. An alignment of 0.0 indicates top, 1.0 indicates bottom, 0.5 means center.
   */
  void scroll_to(const Glib::RefPtr<TextBuffer::Mark>& mark, double within_margin, double xalign, double yalign);
  

   //It does not do anything more than the default scroll_to(mark).

  
  /** Moves a mark within the buffer so that it's
   * located within the currently-visible text area.
   * 
   * @param mark A Gtk::TextMark.
   * @return <tt>true</tt> if the mark moved (wasn’t already onscreen).
   */
  bool move_mark_onscreen(const Glib::RefPtr<TextBuffer::Mark>& mark);
  
  /** Moves the cursor to the currently visible region of the
   * buffer, it it isn’t there already.
   * 
   * @return <tt>true</tt> if the cursor had to be moved.
   */
  bool place_cursor_onscreen();

  
  /** Fills @a visible_rect with the currently-visible
   * region of the buffer, in buffer coordinates. Convert to window coordinates
   * with buffer_to_window_coords().
   * 
   * @param visible_rect Rectangle to fill.
   */
  void get_visible_rect(Gdk::Rectangle& visible_rect) const;
  
  /** Toggles whether the insertion point is displayed. A buffer with no editable
   * text probably shouldn’t have a visible cursor, so you may want to turn
   * the cursor off.
   * 
   * @param setting Whether to show the insertion cursor.
   */
  void set_cursor_visible(bool setting =  true);
  
  /** Find out whether the cursor is being displayed.
   * 
   * @return Whether the insertion mark is visible.
   */
  bool get_cursor_visible() const;

  
  /** Given an @a iter within a text layout, determine the positions of the
   * strong and weak cursors if the insertion point is at that
   * iterator. The position of each cursor is stored as a zero-width
   * rectangle. The strong cursor location is the location where
   * characters of the directionality equal to the base direction of the
   * paragraph are inserted.  The weak cursor location is the location
   * where characters of the directionality opposite to the base
   * direction of the paragraph are inserted.
   * 
   * If @a iter is <tt>nullptr</tt>, the actual cursor position is used.
   * 
   * Note that if @a iter happens to be the actual cursor position, and
   * there is currently an IM preedit sequence being entered, the
   * returned locations will be adjusted to account for the preedit
   * cursor’s offset within the preedit sequence.
   * 
   * The rectangle position is in buffer coordinates; use
   * buffer_to_window_coords() to convert these
   * coordinates to coordinates for one of the windows in the text view.
   * 
   * @newin{3,0}
   * 
   * @param iter A Gtk::TextIter.
   * @param strong Location to store the strong
   * cursor position (may be <tt>nullptr</tt>).
   * @param weak Location to store the weak
   * cursor position (may be <tt>nullptr</tt>).
   */
  void get_cursor_locations(const TextBuffer::iterator& iter, Gdk::Rectangle& strong, Gdk::Rectangle& weak) const;

  
  /** Gets a rectangle which roughly contains the character at @a iter.
   * The rectangle position is in buffer coordinates; use
   * buffer_to_window_coords() to convert these
   * coordinates to coordinates for one of the windows in the text view.
   * 
   * @param iter A Gtk::TextIter.
   * @param location Bounds of the character at @a iter.
   */
  void get_iter_location(const TextBuffer::iterator& iter, Gdk::Rectangle& location) const;
  
  /** Retrieves the iterator at buffer coordinates @a x and @a y. Buffer
   * coordinates are coordinates for the entire buffer, not just the
   * currently-displayed portion.  If you have coordinates from an
   * event, you have to convert those to buffer coordinates with
   * window_to_buffer_coords().
   * 
   * @param iter A Gtk::TextIter.
   * @param x X position, in buffer coordinates.
   * @param y Y position, in buffer coordinates.
   */
  void get_iter_at_location(TextBuffer::iterator& iter, int x, int y) const;
  
  /** Retrieves the iterator pointing to the character at buffer 
   * coordinates @a x and @a y. Buffer coordinates are coordinates for 
   * the entire buffer, not just the currently-displayed portion.  
   * If you have coordinates from an event, you have to convert 
   * those to buffer coordinates with 
   * window_to_buffer_coords().
   * 
   * Note that this is different from get_iter_at_location(),
   * which returns cursor locations, i.e. positions between
   * characters.
   * 
   * @newin{2,6}
   * 
   * @param iter A Gtk::TextIter.
   * @param trailing If non-<tt>nullptr</tt>, location to store an integer indicating where
   * in the grapheme the user clicked. It will either be
   * zero, or the number of characters in the grapheme. 
   * 0 represents the trailing edge of the grapheme.
   * @param x X position, in buffer coordinates.
   * @param y Y position, in buffer coordinates.
   */
  void get_iter_at_position(TextBuffer::iterator& iter, int& trailing, int x, int y) const;
  
  /** Gets the y coordinate of the top of the line containing @a iter,
   * and the height of the line. The coordinate is a buffer coordinate;
   * convert to window coordinates with buffer_to_window_coords().
   * 
   * @param iter A Gtk::TextIter.
   * @param y Return location for a y coordinate.
   * @param height Return location for a height.
   */
  void get_line_yrange(const TextBuffer::iterator& iter, int& y, int& height) const;

  
  /** Gets the Gtk::TextIter at the start of the line containing
   * the coordinate @a y. @a y is in buffer coordinates, convert from
   * window coordinates with window_to_buffer_coords().
   * If non-<tt>nullptr</tt>, @a line_top will be filled with the coordinate of the top
   * edge of the line.
   * 
   * @param target_iter A Gtk::TextIter.
   * @param y A y coordinate.
   * @param line_top Return location for top coordinate of the line.
   */
  void get_line_at_y(TextBuffer::iterator& target_iter, int y, int& line_top) const;

  
  /** Converts coordinate ( @a buffer_x, @a buffer_y) to coordinates for the window
   *  @a win, and stores the result in ( @a window_x, @a window_y). 
   * 
   * Note that you can’t convert coordinates for a nonexisting window (see 
   * set_border_window_size()).
   * 
   * @param win A Gtk::TextWindowType except Gtk::TEXT_WINDOW_PRIVATE.
   * @param buffer_x Buffer x coordinate.
   * @param buffer_y Buffer y coordinate.
   * @param window_x Window x coordinate return location or <tt>nullptr</tt>.
   * @param window_y Window y coordinate return location or <tt>nullptr</tt>.
   */
  void buffer_to_window_coords(TextWindowType win, int buffer_x, int buffer_y, int& window_x, int& window_y) const;
  
  /** Converts coordinates on the window identified by @a win to buffer
   * coordinates, storing the result in ( @a buffer_x, @a buffer_y).
   * 
   * Note that you can’t convert coordinates for a nonexisting window (see 
   * set_border_window_size()).
   * 
   * @param win A Gtk::TextWindowType except Gtk::TEXT_WINDOW_PRIVATE.
   * @param window_x Window x coordinate.
   * @param window_y Window y coordinate.
   * @param buffer_x Buffer x coordinate return location or <tt>nullptr</tt>.
   * @param buffer_y Buffer y coordinate return location or <tt>nullptr</tt>.
   */
  void window_to_buffer_coords(TextWindowType win, int window_x, int window_y, int& buffer_x, int& buffer_y) const;

   //deprecated

  
  /** Retrieves the Gdk::Window corresponding to an area of the text view;
   * possible windows include the overall widget window, child windows
   * on the left, right, top, bottom, and the window that displays the
   * text buffer. Windows are <tt>nullptr</tt> and nonexistent if their width or
   * height is 0, and are nonexistent before the widget has been
   * realized.
   * 
   * @param win Window to get.
   * @return A Gdk::Window, or <tt>nullptr</tt>.
   */
  Glib::RefPtr<Gdk::Window> get_window(TextWindowType win);
  
  /** Retrieves the Gdk::Window corresponding to an area of the text view;
   * possible windows include the overall widget window, child windows
   * on the left, right, top, bottom, and the window that displays the
   * text buffer. Windows are <tt>nullptr</tt> and nonexistent if their width or
   * height is 0, and are nonexistent before the widget has been
   * realized.
   * 
   * @param win Window to get.
   * @return A Gdk::Window, or <tt>nullptr</tt>.
   */
  Glib::RefPtr<const Gdk::Window> get_window(TextWindowType win) const;
  
  /** Usually used to find out which window an event corresponds to.
   * If you connect to an event signal on @a text_view, this function
   * should be called on `event->window` to
   * see which window it was.
   * 
   * @param window A window type.
   * @return The window type.
   */
  TextWindowType get_window_type(const Glib::RefPtr<Gdk::Window>& window);

  
  /** Sets the width of Gtk::TEXT_WINDOW_LEFT or Gtk::TEXT_WINDOW_RIGHT,
   * or the height of Gtk::TEXT_WINDOW_TOP or Gtk::TEXT_WINDOW_BOTTOM.
   * Automatically destroys the corresponding window if the size is set
   * to 0, and creates the window if the size is set to non-zero.  This
   * function can only be used for the “border windows,” it doesn’t work
   * with Gtk::TEXT_WINDOW_WIDGET, Gtk::TEXT_WINDOW_TEXT, or
   * Gtk::TEXT_WINDOW_PRIVATE.
   * 
   * @param type Window to affect.
   * @param size Width or height of the window.
   */
  void set_border_window_size(TextWindowType type, int size);
  
  /** Gets the width of the specified border window. See
   * set_border_window_size().
   * 
   * @param type Window to return size from.
   * @return Width of window.
   */
  int get_border_window_size(TextWindowType type) const;

  
  /** Moves the given @a iter forward by one display (wrapped) line.
   * A display line is different from a paragraph. Paragraphs are
   * separated by newlines or other paragraph separator characters.
   * Display lines are created by line-wrapping a paragraph. If
   * wrapping is turned off, display lines and paragraphs will be the
   * same. Display lines are divided differently for each view, since
   * they depend on the view’s width; paragraphs are the same in all
   * views, since they depend on the contents of the Gtk::TextBuffer.
   * 
   * @param iter A Gtk::TextIter.
   * @return <tt>true</tt> if @a iter was moved and is not on the end iterator.
   */
  bool forward_display_line(TextBuffer::iterator& iter);
  
  /** Moves the given @a iter backward by one display (wrapped) line.
   * A display line is different from a paragraph. Paragraphs are
   * separated by newlines or other paragraph separator characters.
   * Display lines are created by line-wrapping a paragraph. If
   * wrapping is turned off, display lines and paragraphs will be the
   * same. Display lines are divided differently for each view, since
   * they depend on the view’s width; paragraphs are the same in all
   * views, since they depend on the contents of the Gtk::TextBuffer.
   * 
   * @param iter A Gtk::TextIter.
   * @return <tt>true</tt> if @a iter was moved and is not on the end iterator.
   */
  bool backward_display_line(TextBuffer::iterator& iter);
  
  /** Moves the given @a iter forward to the next display line end.
   * A display line is different from a paragraph. Paragraphs are
   * separated by newlines or other paragraph separator characters.
   * Display lines are created by line-wrapping a paragraph. If
   * wrapping is turned off, display lines and paragraphs will be the
   * same. Display lines are divided differently for each view, since
   * they depend on the view’s width; paragraphs are the same in all
   * views, since they depend on the contents of the Gtk::TextBuffer.
   * 
   * @param iter A Gtk::TextIter.
   * @return <tt>true</tt> if @a iter was moved and is not on the end iterator.
   */
  bool forward_display_line_end(TextBuffer::iterator& iter);
  
  /** Moves the given @a iter backward to the next display line start.
   * A display line is different from a paragraph. Paragraphs are
   * separated by newlines or other paragraph separator characters.
   * Display lines are created by line-wrapping a paragraph. If
   * wrapping is turned off, display lines and paragraphs will be the
   * same. Display lines are divided differently for each view, since
   * they depend on the view’s width; paragraphs are the same in all
   * views, since they depend on the contents of the Gtk::TextBuffer.
   * 
   * @param iter A Gtk::TextIter.
   * @return <tt>true</tt> if @a iter was moved and is not on the end iterator.
   */
  bool backward_display_line_start(TextBuffer::iterator& iter);
  
  /** Determines whether @a iter is at the start of a display line.
   * See forward_display_line() for an explanation of
   * display lines vs. paragraphs.
   * 
   * @param iter A Gtk::TextIter.
   * @return <tt>true</tt> if @a iter begins a wrapped line.
   */
  bool starts_display_line(const TextBuffer::iterator& iter);
  
  /** Move the iterator a given number of characters visually, treating
   * it as the strong cursor position. If @a count is positive, then the
   * new strong cursor position will be @a count positions to the right of
   * the old cursor position. If @a count is negative then the new strong
   * cursor position will be @a count positions to the left of the old
   * cursor position.
   * 
   * In the presence of bi-directional text, the correspondence
   * between logical and visual order will depend on the direction
   * of the current run, and there may be jumps when the cursor
   * is moved off of the end of a run.
   * 
   * @param iter A Gtk::TextIter.
   * @param count Number of characters to move (negative moves left, 
   * positive moves right).
   * @return <tt>true</tt> if @a iter moved and is not on the end iterator.
   */
  bool move_visually(TextBuffer::iterator& iter, int count);

  
  /** Allow the Gtk::TextView input method to internally handle key press
   * and release events. If this function returns <tt>true</tt>, then no further
   * processing should be done for this key event. See
   * gtk_im_context_filter_keypress().
   * 
   * Note that you are expected to call this function from your handler
   * when overriding key event handling. This is needed in the case when
   * you need to insert your own key handling between the input method
   * and the default key event handling of the Gtk::TextView.
   * 
   * 
   * [C example ellipted]
   * 
   * @newin{2,22}
   * 
   * @param gdk_event The key event.
   * @return <tt>true</tt> if the input method handled the key event.
   */
  bool im_context_filter_keypress(GdkEventKey* gdk_event);
  
  /** Reset the input method context of the text view if needed.
   * 
   * This can be necessary in the case where modifying the buffer
   * would confuse on-going input method behavior.
   * 
   * @newin{2,22}
   */
  void reset_im_context();

  
  /** Adds a child widget in the text buffer, at the given @a anchor.
   * 
   * @param child A Gtk::Widget.
   * @param anchor A Gtk::TextChildAnchor in the Gtk::TextBuffer for @a text_view.
   */
  void add_child_at_anchor(Widget& child, const Glib::RefPtr<TextBuffer::ChildAnchor>& anchor);

  
  /** Adds a child at fixed coordinates in one of the text widget's
   * windows.
   * 
   * The window must have nonzero size (see
   * set_border_window_size()). Note that the child
   * coordinates are given relative to scrolling. When
   * placing a child in Gtk::TEXT_WINDOW_WIDGET, scrolling is
   * irrelevant, the child floats above all scrollable areas. But when
   * placing a child in one of the scrollable windows (border windows or
   * text window) it will move with the scrolling as needed.
   * 
   * @param child A Gtk::Widget.
   * @param which_window Which window the child should appear in.
   * @param xpos X position of child in window coordinates.
   * @param ypos Y position of child in window coordinates.
   */
  void add_child_in_window(Widget& child, TextWindowType which_window, int xpos, int ypos);

  
  /** Updates the position of a child, as for add_child_in_window().
   * 
   * @param child Child widget already added to the text view.
   * @param xpos New X position in window coordinates.
   * @param ypos New Y position in window coordinates.
   */
  void move_child(Widget& child, int xpos, int ypos);

  
  /** Sets the line wrapping for the view.
   * 
   * @param wrap_mode A Gtk::WrapMode.
   */
  void set_wrap_mode(WrapMode wrap_mode);
  
  /** Gets the line wrapping for the view.
   * 
   * @return The line wrap setting.
   */
  WrapMode get_wrap_mode() const;
  
  /** Sets the default editability of the Gtk::TextView. You can override
   * this default setting with tags in the buffer, using the “editable”
   * attribute of tags.
   * 
   * @param setting Whether it’s editable.
   */
  void set_editable(bool setting =  true);
  
  /** Returns the default editability of the Gtk::TextView. Tags in the
   * buffer may override this setting for some ranges of text.
   * 
   * @return Whether text is editable by default.
   */
  bool get_editable() const;
  
  /** Sets the default number of blank pixels above paragraphs in @a text_view.
   * Tags in the buffer for @a text_view may override the defaults.
   * 
   * @param pixels_above_lines Pixels above paragraphs.
   */
  void set_pixels_above_lines(int pixels_above_lines);
  
  /** Gets the default number of pixels to put above paragraphs.
   * 
   * @return Default number of pixels above paragraphs.
   */
  int get_pixels_above_lines() const;
  
  /** Sets the default number of pixels of blank space
   * to put below paragraphs in @a text_view. May be overridden
   * by tags applied to @a text_view’s buffer.
   * 
   * @param pixels_below_lines Pixels below paragraphs.
   */
  void set_pixels_below_lines(int pixels_below_lines);
  
  /** Gets the value set by set_pixels_below_lines().
   * 
   * @return Default number of blank pixels below paragraphs.
   */
  int get_pixels_below_lines() const;
  
  /** Sets the default number of pixels of blank space to leave between
   * display/wrapped lines within a paragraph. May be overridden by
   * tags in @a text_view’s buffer.
   * 
   * @param pixels_inside_wrap Default number of pixels between wrapped lines.
   */
  void set_pixels_inside_wrap(int pixels_inside_wrap);
  
  /** Gets the value set by set_pixels_inside_wrap().
   * 
   * @return Default number of pixels of blank space between wrapped lines.
   */
  int get_pixels_inside_wrap() const;
  
  /** Sets the default justification of text in @a text_view.
   * Tags in the view’s buffer may override the default.
   * 
   * @param justification Justification.
   */
  void set_justification(Justification justification);
  
  /** Gets the default justification of paragraphs in @a text_view.
   * Tags in the buffer may override the default.
   * 
   * @return Default justification.
   */
  Justification get_justification() const;
  
  /** Sets the default left margin for text in @a text_view.
   * Tags in the buffer may override the default.
   * 
   * Note that this function is confusingly named.
   * In CSS terms, the value set here is padding.
   * 
   * @param left_margin Left margin in pixels.
   */
  void set_left_margin(int left_margin);
  
  /** Gets the default left margin size of paragraphs in the @a text_view.
   * Tags in the buffer may override the default.
   * 
   * @return Left margin in pixels.
   */
  int get_left_margin() const;
  
  /** Sets the default right margin for text in the text view.
   * Tags in the buffer may override the default.
   * 
   * Note that this function is confusingly named.
   * In CSS terms, the value set here is padding.
   * 
   * @param right_margin Right margin in pixels.
   */
  void set_right_margin(int right_margin);
  
  /** Gets the default right margin for text in @a text_view. Tags
   * in the buffer may override the default.
   * 
   * @return Right margin in pixels.
   */
  int get_right_margin() const;
  
  /** Sets the default indentation for paragraphs in @a text_view.
   * Tags in the buffer may override the default.
   * 
   * @param indent Indentation in pixels.
   */
  void set_indent(int indent);
  
  /** Gets the default indentation of paragraphs in @a text_view.
   * Tags in the view’s buffer may override the default.
   * The indentation may be negative.
   * 
   * @return Number of pixels of indentation.
   */
  int get_indent() const;
  
  /** Sets the default tab stops for paragraphs in @a text_view.
   * Tags in the buffer may override the default.
   * 
   * @param tabs Tabs as a Pango::TabArray.
   */
  void set_tabs(Pango::TabArray& tabs);
  
  /** Gets the default tabs for @a text_view. Tags in the buffer may
   * override the defaults. The returned array will be empty if
   * "standard" (8-space) tabs are used.
   * 
   * @return Copy of default tab array, or an empty array if "standard" tabs are used.
   */
  Pango::TabArray get_tabs() const;
  
  /** Obtains a copy of the default text attributes. These are the
   * attributes used for text unless a tag overrides them.
   * You'd typically pass the default attributes in to
   * Gtk::TextIter::get_attributes() in order to get the
   * attributes in effect at a given text position.
   * 
   * @return A new Gtk::TextAttributes.
   */
  TextAttributes get_default_attributes() const;

  
  /** Changes the Gtk::TextView overwrite mode.
   * 
   * @newin{2,4}
   * 
   * @param overwrite <tt>true</tt> to turn on overwrite mode, <tt>false</tt> to turn it off.
   */
  void set_overwrite(bool overwrite =  true);
  
  /** Returns whether the Gtk::TextView is in overwrite mode or not.
   * 
   * @newin{2,4}
   * 
   * @return Whether @a text_view is in overwrite mode or not.
   */
  bool get_overwrite() const;

  
  /** Sets the behavior of the text widget when the Tab key is pressed. 
   * If @a accepts_tab is <tt>true</tt>, a tab character is inserted. If @a accepts_tab 
   * is <tt>false</tt> the keyboard focus is moved to the next widget in the focus 
   * chain.
   * 
   * @newin{2,4}
   * 
   * @param accepts_tab <tt>true</tt> if pressing the Tab key should insert a tab 
   * character, <tt>false</tt>, if pressing the Tab key should move the 
   * keyboard focus.
   */
  void set_accepts_tab(bool accepts_tab =  true);
  
  /** Returns whether pressing the Tab key inserts a tab characters.
   * set_accepts_tab().
   * 
   * @newin{2,4}
   * 
   * @return <tt>true</tt> if pressing the Tab key inserts a tab character, 
   * <tt>false</tt> if pressing the Tab key moves the keyboard focus.
   */
  bool get_accepts_tab() const;

  
  /** Sets the Gtk::TextView::property_input_purpose() property which
   * can be used by on-screen keyboards and other input
   * methods to adjust their behaviour.
   * 
   * @newin{3,6}
   * 
   * @param purpose The purpose.
   */
  void set_input_purpose(InputPurpose purpose);
  
  /** Gets the value of the Gtk::TextView::property_input_purpose() property.
   * 
   * @newin{3,6}
   */
  InputPurpose get_input_purpose() const;

  
  /** Sets the Gtk::TextView::property_input_hints() property, which
   * allows input methods to fine-tune their behaviour.
   * 
   * @newin{3,6}
   * 
   * @param hints The hints.
   */
  void set_input_hints(InputHints hints);
  
  /** Gets the value of the Gtk::TextView::property_input_hints() property.
   * 
   * @newin{3,6}
   */
  InputHints get_input_hints() const;

  
  /** Sets the Gtk::TextView::property_monospace() property, which
   * indicates that the text view should use monospace
   * fonts.
   * 
   * @newin{3,16}
   * 
   * @param monospace <tt>true</tt> to request monospace styling.
   */
  void set_monospace(bool monospace =  true);
  
  /** Gets the value of the Gtk::TextView::property_monospace() property.
   * 
   * Return: <tt>true</tt> if monospace fonts are desired
   * 
   * @newin{3,16}
   */
  bool get_monospace() const;

  //TODO: This signal now takes a GtkWidget* instead of just a GtkMenu*,
  //so change that when we can break ABI.
  //See https://git.gnome.org/browse/gtk+/commit/?id=88623b98a7ca0afca08ac21bc3aa662c6ed3ab7f
 

  /**
   * @par Slot Prototype:
   * <tt>void on_my_%populate_popup(Menu* menu)</tt>
   *
   * The signal_populate_popup() signal gets emitted before showing the
   * context menu of the text view.
   * 
   * If you need to add items to the context menu, connect
   * to this signal and append your items to the @a menu, which
   * will be a Gtk::Menu in this case.
   * 
   * If Gtk::TextView::property_populate_all() is <tt>true</tt>, this signal will
   * also be emitted to populate touch popups. In this case,
   *  @a menu will be a different container, e.g. a Gtk::Toolbar.
   * 
   * The signal handler should not make assumptions about the
   * type of @a widget, but check whether @a menu is a Gtk::Menu
   * or Gtk::Toolbar or another kind of container.
   * 
   * @param menu The container that is being populated.
   */

  Glib::SignalProxy1< void,Menu* > signal_populate_popup();


  /**
   * @par Slot Prototype:
   * <tt>void on_my_%set_anchor()</tt>
   *
   * The signal_set_anchor() signal is a
   * [keybinding signal][GtkBindingSignal]
   * which gets emitted when the user initiates setting the "anchor" 
   * mark. The "anchor" mark gets placed at the same position as the
   * "insert" mark.
   * 
   * This signal has no default bindings.
   */

  Glib::SignalProxy0< void > signal_set_anchor();


  /**
   * @par Slot Prototype:
   * <tt>void on_my_%insert_at_cursor(const Glib::ustring& str)</tt>
   *
   * The signal_insert_at_cursor() signal is a
   * [keybinding signal][GtkBindingSignal]
   * which gets emitted when the user initiates the insertion of a 
   * fixed string at the cursor.
   * 
   * This signal has no default bindings.
   * 
   * @param str The string to insert.
   */

  Glib::SignalProxy1< void,const Glib::ustring& > signal_insert_at_cursor();


  //Keybinding signals:
  
  
  /** Pixels of blank space above paragraphs.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< int > property_pixels_above_lines() ;

/** Pixels of blank space above paragraphs.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< int > property_pixels_above_lines() const;

  /** Pixels of blank space below paragraphs.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< int > property_pixels_below_lines() ;

/** Pixels of blank space below paragraphs.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< int > property_pixels_below_lines() const;

  /** Pixels of blank space between wrapped lines in a paragraph.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< int > property_pixels_inside_wrap() ;

/** Pixels of blank space between wrapped lines in a paragraph.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< int > property_pixels_inside_wrap() const;

  /** Whether the text can be modified by the user.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_editable() ;

/** Whether the text can be modified by the user.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_editable() const;

  /** Whether to wrap lines never, at word boundaries, or at character boundaries.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< WrapMode > property_wrap_mode() ;

/** Whether to wrap lines never, at word boundaries, or at character boundaries.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< WrapMode > property_wrap_mode() const;

  /** Left, right, or center justification.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Justification > property_justification() ;

/** Left, right, or center justification.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Justification > property_justification() const;

  /** The default left margin for text in the text view.
   * Tags in the buffer may override the default.
   * 
   * Note that this property is confusingly named. In CSS terms,
   * the value set here is padding, and it is applied in addition
   * to the padding from the theme.
   * 
   * Don't confuse this property with Gtk::Widget::property_margin_left().
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< int > property_left_margin() ;

/** The default left margin for text in the text view.
   * Tags in the buffer may override the default.
   * 
   * Note that this property is confusingly named. In CSS terms,
   * the value set here is padding, and it is applied in addition
   * to the padding from the theme.
   * 
   * Don't confuse this property with Gtk::Widget::property_margin_left().
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< int > property_left_margin() const;

  /** The default right margin for text in the text view.
   * Tags in the buffer may override the default.
   * 
   * Note that this property is confusingly named. In CSS terms,
   * the value set here is padding, and it is applied in addition
   * to the padding from the theme.
   * 
   * Don't confuse this property with Gtk::Widget::property_margin_right().
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< int > property_right_margin() ;

/** The default right margin for text in the text view.
   * Tags in the buffer may override the default.
   * 
   * Note that this property is confusingly named. In CSS terms,
   * the value set here is padding, and it is applied in addition
   * to the padding from the theme.
   * 
   * Don't confuse this property with Gtk::Widget::property_margin_right().
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< int > property_right_margin() const;

  /** Amount to indent the paragraph, in pixels.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< int > property_indent() ;

/** Amount to indent the paragraph, in pixels.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< int > property_indent() const;

  /** Custom tabs for this text.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Pango::TabArray > property_tabs() ;

/** Custom tabs for this text.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Pango::TabArray > property_tabs() const;

  /** If the insertion cursor is shown.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_cursor_visible() ;

/** If the insertion cursor is shown.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_cursor_visible() const;

  /** The buffer which is displayed.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<TextBuffer> > property_buffer() ;

/** The buffer which is displayed.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<TextBuffer> > property_buffer() const;

  /** Whether entered text overwrites existing contents.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_overwrite() ;

/** Whether entered text overwrites existing contents.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_overwrite() const;

  /** Whether Tab will result in a tab character being entered.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_accepts_tab() ;

/** Whether Tab will result in a tab character being entered.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_accepts_tab() const;

  /** Which IM (input method) module should be used for this text_view. 
   * See Gtk::IMContext.
   * 
   * Setting this to a non-<tt>nullptr</tt> value overrides the
   * system-wide IM module setting. See the GtkSettings 
   * Gtk::Settings::property_gtk_im_module() property.
   * 
   * @newin{2,16}
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::ustring > property_im_module() ;

/** Which IM (input method) module should be used for this text_view. 
   * See Gtk::IMContext.
   * 
   * Setting this to a non-<tt>nullptr</tt> value overrides the
   * system-wide IM module setting. See the GtkSettings 
   * Gtk::Settings::property_gtk_im_module() property.
   * 
   * @newin{2,16}
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::ustring > property_im_module() const;

  /** The purpose of this text field.
   * 
   * This property can be used by on-screen keyboards and other input
   * methods to adjust their behaviour.
   * 
   * @newin{3,6}
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< InputPurpose > property_input_purpose() ;

/** The purpose of this text field.
   * 
   * This property can be used by on-screen keyboards and other input
   * methods to adjust their behaviour.
   * 
   * @newin{3,6}
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< InputPurpose > property_input_purpose() const;

  /** Additional hints (beyond Gtk::TextView::property_input_purpose()) that
   * allow input methods to fine-tune their behaviour.
   * 
   * @newin{3,6}
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< InputHints > property_input_hints() ;

/** Additional hints (beyond Gtk::TextView::property_input_purpose()) that
   * allow input methods to fine-tune their behaviour.
   * 
   * @newin{3,6}
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< InputHints > property_input_hints() const;

  /** If :populate-all is <tt>true</tt>, the Gtk::TextView::signal_populate_popup()
   * signal is also emitted for touch popups.
   * 
   * @newin{3,8}
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_populate_all() ;

/** If :populate-all is <tt>true</tt>, the Gtk::TextView::signal_populate_popup()
   * signal is also emitted for touch popups.
   * 
   * @newin{3,8}
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_populate_all() const;

  /** Whether to use a monospace font.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_monospace() ;

/** Whether to use a monospace font.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_monospace() const;


};

} //namespace Gtk


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gtk::TextView
   */
  Gtk::TextView* wrap(GtkTextView* object, bool take_copy = false);
} //namespace Glib


#endif /* _GTKMM_TEXTVIEW_H */

