// Generated by gmmproc 2.47.4 -- DO NOT MODIFY!
#ifndef _GTKMM_WINDOW_H
#define _GTKMM_WINDOW_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/*
 * Copyright (C) 1998-2013 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <vector>

#include <glibmm/object.h>
#include <gtkmm/bin.h>
#include <gtkmm/application.h>
#include <gtkmm/windowgroup.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkWindow GtkWindow;
typedef struct _GtkWindowClass GtkWindowClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Gtk
{ class Window_Class; } // namespace Gtk
#endif //DOXYGEN_SHOULD_SKIP_THIS

namespace Gtk
{

class AccelGroup;
class WindowGroup;

/** Toplevel Window
 * This represents all widgets which are physical windows controlled
 * by the window manager.
 *
 * The window will be hidden when the window manager's close button is clicked. Override on_delete_event() to stop this.
 *
 * Gtk::manage() has no effect on Windows because they have no parent Containers.
 * @ingroup Widgets
 */

class Window : public Bin
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef Window CppObjectType;
  typedef Window_Class CppClassType;
  typedef GtkWindow BaseObjectType;
  typedef GtkWindowClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  Window(Window&& src) noexcept;
  Window& operator=(Window&& src) noexcept;

  // noncopyable
  Window(const Window&) = delete;
  Window& operator=(const Window&) = delete;

  ~Window() noexcept override;

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class Window_Class;
  static CppClassType window_class_;

protected:
  explicit Window(const Glib::ConstructParams& construct_params);
  explicit Window(GtkWindow* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  GtkWindow*       gobj()       { return reinterpret_cast<GtkWindow*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const GtkWindow* gobj() const { return reinterpret_cast<GtkWindow*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  /// This is a default handler for the signal signal_set_focus().
  virtual void on_set_focus(Widget* focus);


private:

  
  //TODO: Use gtk_window_set_destroy_with_parent() to allow use of Gtk::manage() with top-level windows, using the transient-parent?

public:
    explicit Window(WindowType type =  WINDOW_TOPLEVEL);


  /** The type of the window.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< WindowType > property_type() const;


  /** The title of the window.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::ustring > property_title() ;

/** The title of the window.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::ustring > property_title() const;

  /** The :startup-id is a write-only property for setting window's
   * startup notification identifier. See Gtk::Window::set_startup_id()
   * for more details.
   * 
   * @newin{2,12}
   *
   * @return A PropertyProxy_WriteOnly that allows you to set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_WriteOnly< Glib::ustring > property_startup_id() ;


  /** If TRUE, users can resize the window.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_resizable() ;

/** If TRUE, users can resize the window.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_resizable() const;

  /** If TRUE, the window is modal (other windows are not usable while this one is up).
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_modal() ;

/** If TRUE, the window is modal (other windows are not usable while this one is up).
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_modal() const;

  /** The initial position of the window.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< WindowPosition > property_window_position() ;

/** The initial position of the window.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< WindowPosition > property_window_position() const;

  /** The default width of the window, used when initially showing the window.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< int > property_default_width() ;

/** The default width of the window, used when initially showing the window.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< int > property_default_width() const;

  /** The default height of the window, used when initially showing the window.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< int > property_default_height() ;

/** The default height of the window, used when initially showing the window.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< int > property_default_height() const;

  /** If this window should be destroyed when the parent is destroyed.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_destroy_with_parent() ;

/** If this window should be destroyed when the parent is destroyed.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_destroy_with_parent() const;

  /** Whether the titlebar should be hidden during maximization.
   * 
   * @newin{3,4}
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_hide_titlebar_when_maximized() ;

/** Whether the titlebar should be hidden during maximization.
   * 
   * @newin{3,4}
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_hide_titlebar_when_maximized() const;

  /** Icon for this window.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<Gdk::Pixbuf> > property_icon() ;

/** Icon for this window.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Gdk::Pixbuf> > property_icon() const;

  /** Whether mnemonics are currently visible in this window.
   * 
   * This property is maintained by GTK+ based on user input,
   * and should not be set by applications.
   * 
   * @newin{2,20}
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_mnemonics_visible() ;

/** Whether mnemonics are currently visible in this window.
   * 
   * This property is maintained by GTK+ based on user input,
   * and should not be set by applications.
   * 
   * @newin{2,20}
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_mnemonics_visible() const;

  /** The :icon-name property specifies the name of the themed icon to
   * use as the window icon. See Gtk::IconTheme for more details.
   * 
   * @newin{2,6}
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::ustring > property_icon_name() ;

/** The :icon-name property specifies the name of the themed icon to
   * use as the window icon. See Gtk::IconTheme for more details.
   * 
   * @newin{2,6}
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::ustring > property_icon_name() const;

  /** The screen where this window will be displayed.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<Gdk::Screen> > property_screen() ;

/** The screen where this window will be displayed.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Gdk::Screen> > property_screen() const;

  /** Whether the toplevel is the current active window.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_is_active() const;


  /** Whether the input focus is within this GtkWindow.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_has_toplevel_focus() const;


  /** Hint to help the desktop environment understand what kind of window this is and how to treat it.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< GdkWindowTypeHint > property_type_hint() ;

/** Hint to help the desktop environment understand what kind of window this is and how to treat it.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< GdkWindowTypeHint > property_type_hint() const;

  /** TRUE if the window should not be in the task bar.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_skip_taskbar_hint() ;

/** TRUE if the window should not be in the task bar.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_skip_taskbar_hint() const;

  /** TRUE if the window should not be in the pager.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_skip_pager_hint() ;

/** TRUE if the window should not be in the pager.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_skip_pager_hint() const;

  /** Unique identifier for the window to be used when restoring a session.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::ustring > property_role() ;

/** Unique identifier for the window to be used when restoring a session.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::ustring > property_role() const;

  /** Whether the window should be decorated by the window manager.
   * 
   * @newin{2,4}
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_decorated() ;

/** Whether the window should be decorated by the window manager.
   * 
   * @newin{2,4}
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_decorated() const;

  /** The window gravity of the window. See Gtk::Window::move() and Gdk::Gravity for
   * more details about window gravity.
   * 
   * @newin{2,4}
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Gdk::Gravity > property_gravity() ;

/** The window gravity of the window. See Gtk::Window::move() and Gdk::Gravity for
   * more details about window gravity.
   * 
   * @newin{2,4}
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Gdk::Gravity > property_gravity() const;

  /** The transient parent of the window. See Gtk::Window::set_transient_for() for
   * more details about transient windows.
   * 
   * @newin{2,10}
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Window* > property_transient_for() ;

/** The transient parent of the window. See Gtk::Window::set_transient_for() for
   * more details about transient windows.
   * 
   * @newin{2,10}
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Window* > property_transient_for() const;


#ifndef GTKMM_DISABLE_DEPRECATED
// _WRAP_PROPERTY("opacity", double, deprecated "Use the opacity property in the Widget base class instead.")
// The GtkWindow::opacity property does not exist in gtk+ 3.7.10 and later. Must hand-code to avoid an ABI break.
/** The opacity of the window, from 0 to 1.
   * @deprecated Use the opacity property in the Widget base class instead.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< double > property_opacity() ;

/** The opacity of the window, from 0 to 1.
   * @deprecated Use the opacity property in the Widget base class instead.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< double > property_opacity() const;
#endif // GTKMM_DISABLE_DEPRECATED

  
#ifndef GTKMM_DISABLE_DEPRECATED

/** Whether the window has a corner resize grip.
   * 
   * Note that the resize grip is only shown if the window is
   * actually resizable and not maximized. Use
   * Gtk::Window::property_resize_grip_visible() to find out if the resize
   * grip is currently shown.
   * 
   * Deprecated: 3.14: Resize grips have been removed.
   * 
   * @newin{3,0}
   * 
   * @deprecated Resize grips have been removed.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_has_resize_grip() ;

/** Whether the window has a corner resize grip.
   * 
   * Note that the resize grip is only shown if the window is
   * actually resizable and not maximized. Use
   * Gtk::Window::property_resize_grip_visible() to find out if the resize
   * grip is currently shown.
   * 
   * Deprecated: 3.14: Resize grips have been removed.
   * 
   * @newin{3,0}
   * 
   * @deprecated Resize grips have been removed.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_has_resize_grip() const;

#endif // GTKMM_DISABLE_DEPRECATED

  
#ifndef GTKMM_DISABLE_DEPRECATED

/** Whether a corner resize grip is currently shown.
   * 
   * Deprecated: 3.14: Resize grips have been removed.
   * 
   * @newin{3,0}
   * 
   * @deprecated Resize grips have been removed.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_resize_grip_visible() const;


#endif // GTKMM_DISABLE_DEPRECATED

  /** TRUE if the window should be brought to the user's attention.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_urgency_hint() ;

/** TRUE if the window should be brought to the user's attention.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_urgency_hint() const;

  /** Whether the window should receive the input focus.
   * 
   * @newin{2,4}
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_accept_focus() ;

/** Whether the window should receive the input focus.
   * 
   * @newin{2,4}
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_accept_focus() const;

  /** Whether the window should receive the input focus when mapped.
   * 
   * @newin{2,6}
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_focus_on_map() ;

/** Whether the window should receive the input focus when mapped.
   * 
   * @newin{2,6}
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_focus_on_map() const;

  /** Whether the window frame should have a close button.
   * 
   * @newin{2,10}
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_deletable() ;

/** Whether the window frame should have a close button.
   * 
   * @newin{2,10}
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_deletable() const;

  /** The Gtk::Application associated with the window.
   * 
   * The application will be kept alive for at least as long as it
   * has any windows associated with it (see Glib::application_hold()
   * for a way to keep it alive without windows).
   * 
   * Normally, the connection between the application and the window
   * will remain until the window is destroyed, but you can explicitly
   * remove it by setting the property_application() property to <tt>nullptr</tt>.
   * 
   * @newin{3,0}
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<Application> > property_application() ;

/** The Gtk::Application associated with the window.
   * 
   * The application will be kept alive for at least as long as it
   * has any windows associated with it (see Glib::application_hold()
   * for a way to keep it alive without windows).
   * 
   * Normally, the connection between the application and the window
   * will remain until the window is destroyed, but you can explicitly
   * remove it by setting the property_application() property to <tt>nullptr</tt>.
   * 
   * @newin{3,0}
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Application> > property_application() const;

  /** Whether 'focus rectangles' are currently visible in this window.
   * 
   * This property is maintained by GTK+ based on user input
   * and should not be set by applications.
   * 
   * @newin{2,20}
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_focus_visible() ;

/** Whether 'focus rectangles' are currently visible in this window.
   * 
   * This property is maintained by GTK+ based on user input
   * and should not be set by applications.
   * 
   * @newin{2,20}
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_focus_visible() const;

  /** The widget to which this window is attached.
   * See Gtk::Window::set_attached_to().
   * 
   * Examples of places where specifying this relation is useful are
   * for instance a Gtk::Menu created by a Gtk::ComboBox, a completion
   * popup window created by Gtk::Entry or a typeahead search entry
   * created by Gtk::TreeView.
   * 
   * @newin{3,4}
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Widget* > property_attached_to() ;

/** The widget to which this window is attached.
   * See Gtk::Window::set_attached_to().
   * 
   * Examples of places where specifying this relation is useful are
   * for instance a Gtk::Menu created by a Gtk::ComboBox, a completion
   * popup window created by Gtk::Entry or a typeahead search entry
   * created by Gtk::TreeView.
   * 
   * @newin{3,4}
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Widget* > property_attached_to() const;

  /** Whether the window is maximized.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_is_maximized() const;


  /**
   * @par Slot Prototype:
   * <tt>void on_my_%set_focus(Widget* focus)</tt>
   *
   */

  Glib::SignalProxy1< void,Widget* > signal_set_focus();


  //TODO: Remove no_default_handler when we can break ABI:
  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%keys_changed()</tt>
   *
   * The signal_keys_changed() signal gets emitted when the set of accelerators
   * or mnemonics that are associated with @a window changes.
   */

  Glib::SignalProxy0< void > signal_keys_changed();


  //Keybinding signals:
  
  
  /** Sets the title of the Gtk::Window. The title of a window will be
   * displayed in its title bar; on the X&nbsp;%Window System, the title bar
   * is rendered by the [window manager][gtk-X11-arch],
   * so exactly how the title appears to users may vary
   * according to a user’s exact configuration. The title should help a
   * user distinguish this window from other windows they may have
   * open. A good title might include the application name and current
   * document filename, for example.
   * 
   * @param title Title of the window.
   */
  void set_title(const Glib::ustring& title);

  
  /** Retrieves the title of the window. See set_title().
   * 
   * @return The title of the window, or <tt>nullptr</tt> if none has
   * been set explicitly. The returned string is owned by the widget
   * and must not be modified or freed.
   */
  Glib::ustring get_title() const;

  
  /** Don’t use this function. It sets the X&nbsp;%Window System “class” and
   * “name” hints for a window.  According to the ICCCM, you should
   * always set these to the same value for all windows in an
   * application, and GTK+ sets them to that value by default, so calling
   * this function is sort of pointless. However, you may want to call
   * set_role() on each window in your application, for the
   * benefit of the session manager. Setting the role allows the window
   * manager to restore window positions when loading a saved session.
   * 
   * @param wmclass_name Window name hint.
   * @param wmclass_class Window class hint.
   */
  void set_wmclass(const Glib::ustring& wmclass_name, const Glib::ustring& wmclass_class);

  
  /** This function is only useful on X11, not with other GTK+ targets.
   * 
   * In combination with the window title, the window role allows a
   * [window manager][gtk-X11-arch] to identify "the
   * same" window when an application is restarted. So for example you
   * might set the “toolbox” role on your app’s toolbox window, so that
   * when the user restarts their session, the window manager can put
   * the toolbox back in the same place.
   * 
   * If a window already has a unique title, you don’t need to set the
   * role, since the WM can use the title to identify the window when
   * restoring the session.
   * 
   * @param role Unique identifier for the window to be used when restoring a session.
   */
  void set_role(const Glib::ustring& role);

  
  /** Startup notification identifiers are used by desktop environment to 
   * track application startup, to provide user feedback and other 
   * features. This function changes the corresponding property on the
   * underlying GdkWindow. Normally, startup identifier is managed 
   * automatically and you should only use this function in special cases
   * like transferring focus from other processes. You should use this
   * function before calling present() or any equivalent
   * function generating a window map event.
   * 
   * This function is only useful on X11, not with other GTK+ targets.
   * 
   * @newin{2,12}
   * 
   * @param startup_id A string with startup-notification identifier.
   */
  void set_startup_id(const Glib::ustring& startup_id);

  
  /** Returns the role of the window. See set_role() for
   * further explanation.
   * 
   * @return The role of the window if set, or <tt>nullptr</tt>. The
   * returned is owned by the widget and must not be modified or freed.
   */
  Glib::ustring get_role() const;


  /** Associate @a accel_group with @a window, such that calling
   * gtk_accel_groups_activate() on @a window will activate accelerators
   * in @a accel_group.
   * 
   * @param accel_group A Gtk::AccelGroup.
   */
  void add_accel_group(const Glib::RefPtr<AccelGroup>& accel_group);

  
  /** Reverses the effects of add_accel_group().
   * 
   * @param accel_group A Gtk::AccelGroup.
   */
  void remove_accel_group(const Glib::RefPtr<AccelGroup>& accel_group);

  
  /** Sets a position constraint for this window. If the old or new
   * constraint is Gtk::WIN_POS_CENTER_ALWAYS, this will also cause
   * the window to be repositioned to satisfy the new constraint.
   * 
   * @param position A position constraint.
   */
  void set_position(WindowPosition position);

  
  /** Activates the current focused widget within the window.
   * 
   * @return <tt>true</tt> if a widget got activated.
   */
  bool activate_focus();

  
  /** If @a focus is not the current focus widget, and is focusable, sets
   * it as the focus widget for the window. To set the focus to a particular
   * widget in the toplevel, it is usually more convenient to use
   * Gtk::Widget::grab_focus() instead of this function.
   * 
   * @param focus Widget to be the new focus widget.
   */
  void set_focus(Gtk::Widget& focus);
  void unset_focus();

  
  /** Retrieves the current focused widget within the window.
   * Note that this is the widget that would have the focus
   * if the toplevel window focused; if the toplevel window
   * is not focused then  `gtk_widget_has_focus (widget)` will
   * not be <tt>true</tt> for the widget.
   * 
   * @return The currently focused widget,
   * or <tt>nullptr</tt> if there is none.
   */
  Widget* get_focus();
  
  /** Retrieves the current focused widget within the window.
   * Note that this is the widget that would have the focus
   * if the toplevel window focused; if the toplevel window
   * is not focused then  `gtk_widget_has_focus (widget)` will
   * not be <tt>true</tt> for the widget.
   * 
   * @return The currently focused widget,
   * or <tt>nullptr</tt> if there is none.
   */
  const Widget* get_focus() const;
  
  /** The default widget is the widget that's activated when the user
   * presses Enter in a dialog (for example). This function sets the default widget for a Gtk::Window. When setting
   * (rather than unsetting) the default widget it's generally easier to
   * call Gtk::Widget::grab_focus() on the widget. Before making a widget
   * the default widget, you must set the Gtk::CAN_DEFAULT flag on the
   * widget you'd like to make the default using GTK_WIDGET_SET_FLAGS().
   * 
   * @param default_widget Widget to be the default.
   */
  void set_default(Gtk::Widget& default_widget);
  void unset_default();

  
  /** Returns the default widget for @a window. See
   * set_default() for more details.
   * 
   * @newin{2,14}
   * 
   * @return The default widget, or <tt>nullptr</tt>
   * if there is none.
   */
  Widget* get_default_widget();
  
  /** Returns the default widget for @a window. See
   * set_default() for more details.
   * 
   * @newin{2,14}
   * 
   * @return The default widget, or <tt>nullptr</tt>
   * if there is none.
   */
  const Widget* get_default_widget() const;

  
  /** Activates the default widget for the window, unless the current 
   * focused widget has been configured to receive the default action 
   * (see Gtk::Widget::set_receives_default()), in which case the
   * focused widget is activated.
   * 
   * @return <tt>true</tt> if a widget got activated.
   */
  bool activate_default();

  
  /** Dialog windows should be set transient for the main application
   * window they were spawned from. This allows
   * [window managers][gtk-X11-arch] to e.g. keep the
   * dialog on top of the main window, or center the dialog over the
   * main window. Gtk::Dialog::new_with_buttons() and other convenience
   * functions in GTK+ will sometimes call
   * set_transient_for() on your behalf.
   * 
   * Passing <tt>nullptr</tt> for @a parent unsets the current transient window.
   * 
   * On Windows, this function puts the child window on top of the parent,
   * much as the window manager would have done on X.
   * 
   * @param parent Parent window, or <tt>nullptr</tt>.
   */
  void set_transient_for(Window& parent);

  /** Unsets the current transient window.
   * @see set_transient_for().
   * @newin{2,20}
   */
  void unset_transient_for();

  
  /** Fetches the transient parent for this window. See
   * set_transient_for().
   * 
   * @return The transient parent for this
   * window, or <tt>nullptr</tt> if no transient parent has been set.
   */
  Window* get_transient_for();
  
  /** Fetches the transient parent for this window. See
   * set_transient_for().
   * 
   * @return The transient parent for this
   * window, or <tt>nullptr</tt> if no transient parent has been set.
   */
  const Window* get_transient_for() const;

  /** Unsets the attached-to widget.
   * @see set_attached_to().
   * @newin{3,4}
   */
  void unset_attached_to();

  
  /** Marks @a window as attached to @a attach_widget. This creates a logical binding
   * between the window and the widget it belongs to, which is used by GTK+ to
   * propagate information such as styling or accessibility to @a window as if it
   * was a children of @a attach_widget.
   * 
   * Examples of places where specifying this relation is useful are for instance
   * a Gtk::Menu created by a Gtk::ComboBox, a completion popup window
   * created by Gtk::Entry or a typeahead search entry created by Gtk::TreeView.
   * 
   * Note that this function should not be confused with
   * set_transient_for(), which specifies a window manager relation
   * between two toplevels instead.
   * 
   * Passing <tt>nullptr</tt> for @a attach_widget detaches the window.
   * 
   * @newin{3,4}
   * 
   * @param attach_widget A Gtk::Widget, or <tt>nullptr</tt>.
   */
  void set_attached_to(Widget& attach_widget);

  
  /** Fetches the attach widget for this window. See
   * set_attached_to().
   * 
   * @newin{3,4}
   * 
   * @return The widget where the window
   * is attached, or <tt>nullptr</tt> if the window is not attached to any widget.
   */
  Widget* get_attached_to();
  
  /** Fetches the attach widget for this window. See
   * set_attached_to().
   * 
   * @newin{3,4}
   * 
   * @return The widget where the window
   * is attached, or <tt>nullptr</tt> if the window is not attached to any widget.
   */
  const Widget* get_attached_to() const;

  
#ifndef GTKMM_DISABLE_DEPRECATED

  /** Request the windowing system to make @a window partially transparent,
   * with opacity 0 being fully transparent and 1 fully opaque. (Values
   * of the opacity parameter are clamped to the [0,1] range.) On X11
   * this has any effect only on X screens with a compositing manager
   * running. See Gtk::Widget::is_composited(). On Windows it should work
   * always.
   * 
   * Note that setting a window’s opacity after the window has been
   * shown causes it to flicker once on Windows.
   * 
   * @newin{2,12}
   * Deprecated: 3.8: Use gtk_widget_set_opacity instead.
   * 
   * @deprecated Use Widget::set_opacity() instead.
   * 
   * @param opacity Desired opacity, between 0 and 1.
   */
  void set_opacity(double opacity);
#endif // GTKMM_DISABLE_DEPRECATED


#ifndef GTKMM_DISABLE_DEPRECATED

  /** Fetches the requested opacity for this window. See
   * set_opacity().
   * 
   * @newin{2,12}
   * Deprecated: 3.8: Use gtk_widget_get_opacity instead.
   * 
   * @deprecated Use Widget::get_opacity() instead.
   * 
   * @return The requested opacity for this window.
   */
  double get_opacity() const;
#endif // GTKMM_DISABLE_DEPRECATED


  /** By setting the type hint for the window, you allow the window
   * manager to decorate and handle the window in a way which is
   * suitable to the function of the window in your application.
   * 
   * This function should be called before the window becomes visible.
   * 
   * Gtk::Dialog::new_with_buttons() and other convenience functions in GTK+
   * will sometimes call set_type_hint() on your behalf.
   * 
   * @param hint The window type.
   */
  void set_type_hint(Gdk::WindowTypeHint hint);
  
  /** Gets the type hint for this window. See set_type_hint().
   * 
   * @return The type hint for @a window.
   */
  Gdk::WindowTypeHint get_type_hint() const;

  
  /** Windows may set a hint asking the desktop environment not to display
   * the window in the task bar. This function sets this hint.
   * 
   * @newin{2,2}
   * 
   * @param setting <tt>true</tt> to keep this window from appearing in the task bar.
   */
  void set_skip_taskbar_hint(bool setting =  true);
  
  /** Gets the value set by set_skip_taskbar_hint()
   * 
   * @newin{2,2}
   * 
   * @return <tt>true</tt> if window shouldn’t be in taskbar.
   */
  bool get_skip_taskbar_hint() const;

  
  /** Windows may set a hint asking the desktop environment not to display
   * the window in the pager. This function sets this hint.
   * (A "pager" is any desktop navigation tool such as a workspace
   * switcher that displays a thumbnail representation of the windows
   * on the screen.)
   * 
   * @newin{2,2}
   * 
   * @param setting <tt>true</tt> to keep this window from appearing in the pager.
   */
  void set_skip_pager_hint(bool setting =  true);
  
  /** Gets the value set by set_skip_pager_hint().
   * 
   * @newin{2,2}
   * 
   * @return <tt>true</tt> if window shouldn’t be in pager.
   */
  bool get_skip_pager_hint() const;

  
  /** Windows may set a hint asking the desktop environment to draw
   * the users attention to the window. This function sets this hint.
   * 
   * @newin{2,8}
   * 
   * @param setting <tt>true</tt> to mark this window as urgent.
   */
  void set_urgency_hint(bool setting =  true);
  
  /** Gets the value set by set_urgency_hint()
   * 
   * @newin{2,8}
   * 
   * @return <tt>true</tt> if window is urgent.
   */
  bool get_urgency_hint() const;

  
  /** Windows may set a hint asking the desktop environment not to receive
   * the input focus. This function sets this hint.
   * 
   * @newin{2,4}
   * 
   * @param setting <tt>true</tt> to let this window receive input focus.
   */
  void set_accept_focus(bool setting =  true);
  
  /** Gets the value set by set_accept_focus().
   * 
   * @newin{2,4}
   * 
   * @return <tt>true</tt> if window should receive the input focus.
   */
  bool get_accept_focus() const;
  
  /** Windows may set a hint asking the desktop environment not to receive
   * the input focus when the window is mapped.  This function sets this
   * hint.
   * 
   * @newin{2,6}
   * 
   * @param setting <tt>true</tt> to let this window receive input focus on map.
   */
  void set_focus_on_map(bool setting =  true);
  
  /** Gets the value set by set_focus_on_map().
   * 
   * @newin{2,6}
   * 
   * @return <tt>true</tt> if window should receive the input focus when
   * mapped.
   */
  bool get_focus_on_map() const;

  //_WRAP_METHOD(void set_destroy_with_parent(bool setting = true), gtk_window_set_destroy_with_parent)
  // I don't that that this is ever a good thing for C++.murrayc.

  //TODO: Remove?
  
  /** Returns whether the window will be destroyed with its transient parent. See
   * set_destroy_with_parent().
   * 
   * @return <tt>true</tt> if the window will be destroyed with its transient parent.
   */
  bool get_destroy_with_parent() const;
  // I don't that that this is ever a good thing for C++.murrayc.

  
  /** If @a setting is <tt>true</tt>, then @a window will request that it’s titlebar
   * should be hidden when maximized.
   * This is useful for windows that don’t convey any information other
   * than the application name in the titlebar, to put the available
   * screen space to better use. If the underlying window system does not
   * support the request, the setting will not have any effect.
   * 
   * Note that custom titlebars set with set_titlebar() are
   * not affected by this. The application is in full control of their
   * content and visibility anyway.
   * 
   * @newin{3,4}
   * 
   * @param setting Whether to hide the titlebar when @a window is maximized.
   */
  void set_hide_titlebar_when_maximized(bool setting =  true);
  
  /** Returns whether the window has requested to have its titlebar hidden
   * when maximized. See set_hide_titlebar_when_maximized().
   * 
   * @newin{3,4}
   * 
   * @return <tt>true</tt> if the window has requested to have its titlebar
   * hidden when maximized.
   */
  bool get_hide_titlebar_when_maximized() const;

  
  /** Sets the Gtk::Window::property_mnemonics_visible() property.
   * 
   * @newin{2,20}
   * 
   * @param setting The new value.
   */
  void set_mnemonics_visible(bool setting =  true);
  
  /** Gets the value of the Gtk::Window::property_mnemonics_visible() property.
   * 
   * @newin{2,20}
   * 
   * @return <tt>true</tt> if mnemonics are supposed to be visible
   * in this window.
   */
  bool get_mnemonics_visible() const;

  
  /** Sets the Gtk::Window::property_focus_visible() property.
   * 
   * @newin{3,2}
   * 
   * @param setting The new value.
   */
  void set_focus_visible(bool setting =  true);
  
  /** Gets the value of the Gtk::Window::property_focus_visible() property.
   * 
   * @newin{3,2}
   * 
   * @return <tt>true</tt> if “focus rectangles” are supposed to be visible
   * in this window.
   */
  bool get_focus_visible() const;

  
  /** Sets whether the user can resize a window. Windows are user resizable
   * by default.
   * 
   * @param resizable <tt>true</tt> if the user can resize this window.
   */
  void set_resizable(bool resizable =  true);

  
  /** Gets the value set by set_resizable().
   * 
   * @return <tt>true</tt> if the user can resize the window.
   */
  bool get_resizable() const;

  
  /** Window gravity defines the meaning of coordinates passed to
   * move(). See move() and Gdk::Gravity for
   * more details.
   * 
   * The default window gravity is Gdk::GRAVITY_NORTH_WEST which will
   * typically “do what you mean.”
   * 
   * @param gravity Window gravity.
   */
  void set_gravity(Gdk::Gravity gravity);

  
  /** Gets the value set by set_gravity().
   * 
   * @return Window gravity.
   */
  Gdk::Gravity get_gravity() const;

  
  /** This function sets up hints about how a window can be resized by
   * the user.  You can set a minimum and maximum size; allowed resize
   * increments (e.g. for xterm, you can only resize by the size of a
   * character); aspect ratios; and more. See the Gdk::Geometry struct.
   * 
   * @param geometry_widget Widget the geometry hints used to be applied to
   * or <tt>nullptr</tt>. Since 3.18 this argument is ignored and GTK behaves as if <tt>nullptr</tt> was
   * set.
   * @param geometry Struct containing geometry information or <tt>nullptr</tt>.
   * @param geom_mask Mask indicating which struct fields should be paid attention to.
   */
  void set_geometry_hints(Widget& geometry_widget, const Gdk::Geometry& geometry, Gdk::WindowHints geom_mask);

  
  /** Sets the Gdk::Screen where the @a window is displayed; if
   * the window is already mapped, it will be unmapped, and
   * then remapped on the new screen.
   * 
   * @newin{2,2}
   * 
   * @param screen A Gdk::Screen.
   */
  void set_screen(const Glib::RefPtr<Gdk::Screen>& screen);

  
  /** Returns the Gdk::Screen associated with @a window.
   * 
   * @newin{2,2}
   * 
   * @return A Gdk::Screen.
   */
  Glib::RefPtr<Gdk::Screen> get_screen();
  
  /** Returns the Gdk::Screen associated with @a window.
   * 
   * @newin{2,2}
   * 
   * @return A Gdk::Screen.
   */
  Glib::RefPtr<const Gdk::Screen> get_screen() const;

  
  /** Returns whether the window is part of the current active toplevel.
   * (That is, the toplevel window receiving keystrokes.)
   * The return value is <tt>true</tt> if the window is active toplevel
   * itself, but also if it is, say, a Gtk::Plug embedded in the active toplevel.
   * You might use this function if you wanted to draw a widget
   * differently in an active window from a widget in an inactive window.
   * See has_toplevel_focus()
   * 
   * @newin{2,4}
   * 
   * @return <tt>true</tt> if the window part of the current active window.
   */
  bool is_active() const;
  
  /** Returns whether the input focus is within this GtkWindow.
   * For real toplevel windows, this is identical to is_active(),
   * but for embedded windows, like Gtk::Plug, the results will differ.
   * 
   * @newin{2,4}
   * 
   * @return <tt>true</tt> if the input focus is within this GtkWindow.
   */
  bool has_toplevel_focus() const;

  
  /** By default, windows are decorated with a title bar, resize
   * controls, etc.  Some [window managers][gtk-X11-arch]
   * allow GTK+ to disable these decorations, creating a
   * borderless window. If you set the decorated property to <tt>false</tt>
   * using this function, GTK+ will do its best to convince the window
   * manager not to decorate the window. Depending on the system, this
   * function may not have any effect when called on a window that is
   * already visible, so you should call it before calling Gtk::Widget::show().
   * 
   * On Windows, this function always works, since there’s no window manager
   * policy involved.
   * 
   * @param setting <tt>true</tt> to decorate the window.
   */
  void set_decorated(bool setting =  true);
  
  /** Returns whether the window has been set to have decorations
   * such as a title bar via set_decorated().
   * 
   * @return <tt>true</tt> if the window has been set to have decorations.
   */
  bool get_decorated() const;

  
  /** By default, windows have a close button in the window frame. Some 
   * [window managers][gtk-X11-arch] allow GTK+ to 
   * disable this button. If you set the deletable property to <tt>false</tt>
   * using this function, GTK+ will do its best to convince the window
   * manager not to show a close button. Depending on the system, this
   * function may not have any effect when called on a window that is
   * already visible, so you should call it before calling Gtk::Widget::show().
   * 
   * On Windows, this function always works, since there’s no window manager
   * policy involved.
   * 
   * @newin{2,10}
   * 
   * @param setting <tt>true</tt> to decorate the window as deletable.
   */
  void set_deletable(bool setting =  true);
  
  /** Returns whether the window has been set to have a close button
   * via set_deletable().
   * 
   * @newin{2,10}
   * 
   * @return <tt>true</tt> if the window has been set to have a close button.
   */
  bool get_deletable() const;

 
  /** Retrieves the list of icons set by set_icon_list().
   * The list is copied, but the reference count on each
   * member won’t be incremented.
   * 
   * @return Copy of window’s icon list.
   */
  std::vector< Glib::RefPtr<Gdk::Pixbuf> > get_icon_list();
 

  /** Retrieves the list of icons set by set_icon_list().
   * The list is copied, but the reference count on each
   * member won’t be incremented.
   * 
   * @return Copy of window’s icon list.
   */
  std::vector< Glib::RefPtr<const Gdk::Pixbuf> > get_icon_list() const;

 
  /** Sets up the icon representing a Gtk::Window. The icon is used when
   * the window is minimized (also known as iconified).  Some window
   * managers or desktop environments may also place it in the window
   * frame, or display it in other contexts.
   * 
   * set_icon_list() allows you to pass in the same icon in
   * several hand-drawn sizes. The list should contain the natural sizes
   * your icon is available in; that is, don’t scale the image before
   * passing it to GTK+. Scaling is postponed until the last minute,
   * when the desired final size is known, to allow best quality.
   * 
   * By passing several sizes, you may improve the final image quality
   * of the icon, by reducing or eliminating automatic image scaling.
   * 
   * Recommended sizes to provide: 16x16, 32x32, 48x48 at minimum, and
   * larger images (64x64, 128x128) if you have them.
   * 
   * See also set_default_icon_list() to set the icon
   * for all windows in your application in one go.
   * 
   * Note that transient windows (those who have been set transient for another
   * window using set_transient_for()) will inherit their
   * icon from their transient parent. So there’s no need to explicitly
   * set the icon on transient windows.
   * 
   * @param list List of Gdk::Pixbuf.
   */
  void set_icon_list(const std::vector< Glib::RefPtr<Gdk::Pixbuf> >& list);

  
  /** Sets up the icon representing a Gtk::Window. This icon is used when
   * the window is minimized (also known as iconified).  Some window
   * managers or desktop environments may also place it in the window
   * frame, or display it in other contexts.
   * 
   * The icon should be provided in whatever size it was naturally
   * drawn; that is, don’t scale the image before passing it to
   * GTK+. Scaling is postponed until the last minute, when the desired
   * final size is known, to allow best quality.
   * 
   * If you have your icon hand-drawn in multiple sizes, use
   * set_icon_list(). Then the best size will be used.
   * 
   * This function is equivalent to calling set_icon_list()
   * with a 1-element list.
   * 
   * See also set_default_icon_list() to set the icon
   * for all windows in your application in one go.
   * 
   * @param icon Icon image, or <tt>nullptr</tt>.
   */
  void set_icon(const Glib::RefPtr<Gdk::Pixbuf>& icon);

  //TODO: Correct the since tag.
  
  /** Sets the icon for the window from a named themed icon. See
   * the docs for Gtk::IconTheme for more details.
   * 
   * Note that this has nothing to do with the WM_ICON_NAME 
   * property which is mentioned in the ICCCM.
   * 
   * @newin{2,6}
   * 
   * @param name The name of the themed icon.
   */
  void set_icon_name(const Glib::ustring& name);
  
  /** Sets the icon for the window.
   * 
   * This function is equivalent to calling set_icon()
   * with a pixbuf created by loading the image from @a filename.
   * 
   * @param filename Location of icon file.
   * @return <tt>true</tt> if setting the icon succeeded.
   */
  bool set_icon_from_file(const std::string& filename);

  
  /** Gets the value set by set_icon() (or if you've
   * called set_icon_list(), gets the first icon in
   * the icon list).
   * 
   * @return Icon for window.
   */
  Glib::RefPtr<Gdk::Pixbuf> get_icon();
  
  /** Gets the value set by set_icon() (or if you've
   * called set_icon_list(), gets the first icon in
   * the icon list).
   * 
   * @return Icon for window.
   */
  Glib::RefPtr<const Gdk::Pixbuf> get_icon() const;

  
  /** Returns the name of the themed icon for the window,
   * see set_icon_name().
   * 
   * @newin{2,6}
   * 
   * @return The icon name or <tt>nullptr</tt> if the window has
   * no themed icon.
   */
  Glib::ustring get_icon_name() const;

  
  /** Sets an icon list to be used as fallback for windows that haven't
   * had set_icon_list() called on them to set up a
   * window-specific icon list. This function allows you to set up the
   * icon for all windows in your app at once.
   * 
   * See set_icon_list() for more details.
   * 
   * @param list A list of Gdk::Pixbuf.
   */
  static void set_default_icon_list(const std::vector< Glib::RefPtr<Gdk::Pixbuf> >& list);

  
  /** Gets the value set by Gtk::Window::set_default_icon_list().
   * 
   * @return Copy of default icon list.
   */
  static std::vector< Glib::RefPtr<Gdk::Pixbuf> > get_default_icon_list();

  
  /** Sets an icon to be used as fallback for windows that haven't
   * had set_icon() called on them from a pixbuf.
   * 
   * @newin{2,4}
   * 
   * @param icon The icon.
   */
  static void set_default_icon(const Glib::RefPtr<Gdk::Pixbuf>& icon);
  
  /** Sets an icon to be used as fallback for windows that haven't
   * had set_icon_list() called on them from a named
   * themed icon, see set_icon_name().
   * 
   * @newin{2,6}
   * 
   * @param name The name of the themed icon.
   */
  static void set_default_icon_name(const Glib::ustring& name);
  
  /** Sets an icon to be used as fallback for windows that haven't
   * had set_icon_list() called on them from a file
   * on disk. Warns on failure if @a err is <tt>nullptr</tt>.
   * 
   * @newin{2,2}
   * 
   * @param filename Location of icon file.
   * @return <tt>true</tt> if setting the icon succeeded.
   */
  static bool set_default_icon_from_file(const std::string& filename);
  
  /** By default, after showing the first Gtk::Window, GTK+ calls 
   * gdk_notify_startup_complete().  Call this function to disable 
   * the automatic startup notification. You might do this if your 
   * first window is a splash screen, and you want to delay notification 
   * until after your real main window has been shown, for example.
   * 
   * In that example, you would disable startup notification
   * temporarily, show your splash screen, then re-enable it so that
   * showing the main window would automatically result in notification.
   * 
   * @newin{2,2}
   * 
   * @param setting <tt>true</tt> to automatically do startup notification.
   */
  static void set_auto_startup_notification(bool setting =  true);

  
  /** Sets a window modal or non-modal. Modal windows prevent interaction
   * with other windows in the same application. To keep modal dialogs
   * on top of main application windows, use
   * set_transient_for() to make the dialog transient for the
   * parent; most [window managers][gtk-X11-arch]
   * will then disallow lowering the dialog below the parent.
   * 
   * @param modal Whether the window is modal.
   */
  void set_modal(bool modal =  true);

  
  /** Returns whether the window is modal. See set_modal().
   * 
   * @return <tt>true</tt> if the window is set to be modal and
   * establishes a grab when shown.
   */
  bool get_modal() const;

 
  /** Returns a list of all existing toplevel windows. The widgets
   * in the list are not individually referenced. If you want
   * to iterate through the list and perform actions involving
   * callbacks that might destroy the widgets, you must call
   * `g_list_foreach (result, (GFunc)g_object_ref, <tt>nullptr</tt>)` first, and
   * then unref all the widgets afterwards.
   * 
   * @return List of toplevel widgets.
   */
  static std::vector<Window*> list_toplevels();

  
  /** Adds a mnemonic to this window.
   * 
   * @param keyval The mnemonic.
   * @param target The widget that gets activated by the mnemonic.
   */
  void add_mnemonic(guint keyval, Widget& target);

  
  /** Removes a mnemonic from this window.
   * 
   * @param keyval The mnemonic.
   * @param target The widget that gets activated by the mnemonic.
   */
  void remove_mnemonic(guint keyval, Widget& target);

  
  /** Activates the targets associated with the mnemonic.
   * 
   * @param keyval The mnemonic.
   * @param modifier The modifiers.
   * @return <tt>true</tt> if the activation is done.
   */
  bool mnemonic_activate(guint keyval, Gdk::ModifierType modifier);

  
  /** Sets the mnemonic modifier for this window.
   * 
   * @param modifier The modifier mask used to activate
   * mnemonics on this window.
   */
  void set_mnemonic_modifier(Gdk::ModifierType modifier);

  
  /** Returns the mnemonic modifier for this window. See
   * set_mnemonic_modifier().
   * 
   * @return The modifier mask used to activate
   * mnemonics on this window.
   */
  Gdk::ModifierType get_mnemonic_modifier();


  /** Presents a window to the user. This may mean raising the window
   * in the stacking order, deiconifying it, moving it to the current
   * desktop, and/or giving it the keyboard focus, possibly dependent
   * on the user’s platform, window manager, and preferences.
   * 
   * If @a window is hidden, this function calls Gtk::Widget::show()
   * as well.
   * 
   * This function should be used when the user tries to open a window
   * that’s already open. Say for example the preferences dialog is
   * currently open, and the user chooses Preferences from the menu
   * a second time; use present() to move the already-open dialog
   * where the user can see it.
   * 
   * If you are calling this function in response to a user interaction,
   * it is preferable to use present_with_time().
   */
  void present();
  
  /** Presents a window to the user in response to a user interaction.
   * If you need to present a window without a timestamp, use 
   * present(). See present() for details. 
   * 
   * @newin{2,8}
   * 
   * @param timestamp The timestamp of the user interaction (typically a 
   * button or key press event) which triggered this call.
   */
  void present(guint32 timestamp);

  
  /** Asks to iconify (i.e.\ minimize) the specified @a window. Note that
   * you shouldn’t assume the window is definitely iconified afterward,
   * because other entities (e.g. the user or
   * [window manager][gtk-X11-arch]) could deiconify it
   * again, or there may not be a window manager in which case
   * iconification isn’t possible, etc. But normally the window will end
   * up iconified. Just don’t write code that crashes if not.
   * 
   * It’s permitted to call this function before showing a window,
   * in which case the window will be iconified before it ever appears
   * onscreen.
   * 
   * You can track iconification via the “window-state-event” signal
   * on Gtk::Widget.
   */
  void iconify();
  
  /** Asks to deiconify (i.e.\ unminimize) the specified @a window. Note
   * that you shouldn’t assume the window is definitely deiconified
   * afterward, because other entities (e.g. the user or
   * [window manager][gtk-X11-arch])) could iconify it
   * again before your code which assumes deiconification gets to run.
   * 
   * You can track iconification via the “window-state-event” signal
   * on Gtk::Widget.
   */
  void deiconify();

  
  /** Asks to stick @a window, which means that it will appear on all user
   * desktops. Note that you shouldn’t assume the window is definitely
   * stuck afterward, because other entities (e.g. the user or
   * [window manager][gtk-X11-arch] could unstick it
   * again, and some window managers do not support sticking
   * windows. But normally the window will end up stuck. Just don't
   * write code that crashes if not.
   * 
   * It’s permitted to call this function before showing a window.
   * 
   * You can track stickiness via the “window-state-event” signal
   * on Gtk::Widget.
   */
  void stick();
  
  /** Asks to unstick @a window, which means that it will appear on only
   * one of the user’s desktops. Note that you shouldn’t assume the
   * window is definitely unstuck afterward, because other entities
   * (e.g. the user or [window manager][gtk-X11-arch]) could
   * stick it again. But normally the window will
   * end up stuck. Just don’t write code that crashes if not.
   * 
   * You can track stickiness via the “window-state-event” signal
   * on Gtk::Widget.
   */
  void unstick();

  
  /** Asks to maximize @a window, so that it becomes full-screen. Note that
   * you shouldn’t assume the window is definitely maximized afterward,
   * because other entities (e.g. the user or
   * [window manager][gtk-X11-arch]) could unmaximize it
   * again, and not all window managers support maximization. But
   * normally the window will end up maximized. Just don’t write code
   * that crashes if not.
   * 
   * It’s permitted to call this function before showing a window,
   * in which case the window will be maximized when it appears onscreen
   * initially.
   * 
   * You can track maximization via the “window-state-event” signal
   * on Gtk::Widget, or by listening to notifications on the
   * Gtk::Window::property_is_maximized() property.
   */
  void maximize();
  
  /** Asks to unmaximize @a window. Note that you shouldn’t assume the
   * window is definitely unmaximized afterward, because other entities
   * (e.g. the user or [window manager][gtk-X11-arch])
   * could maximize it again, and not all window
   * managers honor requests to unmaximize. But normally the window will
   * end up unmaximized. Just don’t write code that crashes if not.
   * 
   * You can track maximization via the “window-state-event” signal
   * on Gtk::Widget.
   */
  void unmaximize();

  
  /** Asks to place @a window in the fullscreen state. Note that you
   * shouldn’t assume the window is definitely full screen afterward,
   * because other entities (e.g. the user or
   * [window manager][gtk-X11-arch]) could unfullscreen it
   * again, and not all window managers honor requests to fullscreen
   * windows. But normally the window will end up fullscreen. Just
   * don’t write code that crashes if not.
   * 
   * You can track the fullscreen state via the “window-state-event” signal
   * on Gtk::Widget.
   * 
   * @newin{2,2}
   */
  void fullscreen();
  
  /** Asks to toggle off the fullscreen state for @a window. Note that you
   * shouldn’t assume the window is definitely not full screen
   * afterward, because other entities (e.g. the user or
   * [window manager][gtk-X11-arch]) could fullscreen it
   * again, and not all window managers honor requests to unfullscreen
   * windows. But normally the window will end up restored to its normal
   * state. Just don’t write code that crashes if not.
   * 
   * You can track the fullscreen state via the “window-state-event” signal
   * on Gtk::Widget.
   * 
   * @newin{2,2}
   */
  void unfullscreen();
  
  /** Asks to place @a window in the fullscreen state. Note that you shouldn't assume
   * the window is definitely full screen afterward.
   * 
   * You can track the fullscreen state via the "window-state-event" signal
   * on Gtk::Widget.
   * 
   * @newin{3,18}
   * 
   * @param screen A Gdk::Screen to draw to.
   * @param monitor Which monitor to go fullscreen on.
   */
  void fullscreen_on_monitor(const Glib::RefPtr<Gdk::Screen>& screen, int monitor);
  
  /** Requests that the window is closed, similar to what happens
   * when a window manager close button is clicked.
   * 
   * This function can be used with close buttons in custom
   * titlebars.
   * 
   * @newin{3,10}
   */
  void close();

  
  /** Starts resizing a window. This function is used if an application
   * has window resizing controls. When GDK can support it, the resize
   * will be done using the standard mechanism for the
   * [window manager][gtk-X11-arch] or windowing
   * system. Otherwise, GDK will try to emulate window resizing,
   * potentially not all that well, depending on the windowing system.
   * 
   * @param button Mouse button that initiated the drag.
   * @param edge Position of the resize control.
   * @param root_x X position where the user clicked to initiate the drag, in root window coordinates.
   * @param root_y Y position where the user clicked to initiate the drag.
   * @param timestamp Timestamp from the click event that initiated the drag.
   */
  void begin_resize_drag(Gdk::WindowEdge edge, int button, int root_x, int root_y, guint32 timestamp);

  
  /** Starts moving a window. This function is used if an application has
   * window movement grips. When GDK can support it, the window movement
   * will be done using the standard mechanism for the
   * [window manager][gtk-X11-arch] or windowing
   * system. Otherwise, GDK will try to emulate window movement,
   * potentially not all that well, depending on the windowing system.
   * 
   * @param button Mouse button that initiated the drag.
   * @param root_x X position where the user clicked to initiate the drag, in root window coordinates.
   * @param root_y Y position where the user clicked to initiate the drag.
   * @param timestamp Timestamp from the click event that initiated the drag.
   */
  void begin_move_drag(int button, int root_x, int root_y, guint32 timestamp);

  
  /** Sets the default size of a window. If the window’s “natural” size
   * (its size request) is larger than the default, the default will be
   * ignored. More generally, if the default size does not obey the
   * geometry hints for the window (set_geometry_hints() can
   * be used to set these explicitly), the default size will be clamped
   * to the nearest permitted size.
   * 
   * Unlike Gtk::Widget::set_size_request(), which sets a size request for
   * a widget and thus would keep users from shrinking the window, this
   * function only sets the initial size, just as if the user had
   * resized the window themselves. Users can still shrink the window
   * again as they normally would. Setting a default size of -1 means to
   * use the “natural” default size (the size request of the window).
   * 
   * For more control over a window’s initial size and how resizing works,
   * investigate set_geometry_hints().
   * 
   * For some uses, resize() is a more appropriate function.
   * resize() changes the current size of the window, rather
   * than the size to be used on initial display. resize() always
   * affects the window itself, not the geometry widget.
   * 
   * The default size of a window only affects the first time a window is
   * shown; if a window is hidden and re-shown, it will remember the size
   * it had prior to hiding, rather than using the default size.
   * 
   * Windows can’t actually be 0x0 in size, they must be at least 1x1, but
   * passing 0 for @a width and @a height is OK, resulting in a 1x1 default size.
   * 
   * @param width Width in pixels, or -1 to unset the default width.
   * @param height Height in pixels, or -1 to unset the default height.
   */
  void set_default_size(int width, int height);

  
  /** Gets the default size of the window. A value of -1 for the width or
   * height indicates that a default size has not been explicitly set
   * for that dimension, so the “natural” size of the window will be
   * used.
   * 
   * @param width Location to store the default width.
   * @param height Location to store the default height.
   */
  void get_default_size(int& width, int& height) const;

  
  /** Resizes the window as if the user had done so, obeying geometry
   * constraints. The default geometry constraint is that windows may
   * not be smaller than their size request; to override this
   * constraint, call Gtk::Widget::set_size_request() to set the window's
   * request to a smaller value.
   * 
   * If resize() is called before showing a window for the
   * first time, it overrides any default size set with
   * set_default_size().
   * 
   * Windows may not be resized smaller than 1 by 1 pixels.
   * 
   * When using client side decorations, GTK+ will do its best to adjust
   * the given size so that the resulting window size matches the
   * requested size without the title bar, borders and shadows added for
   * the client side decorations, but there is no garantee that the
   * result will be totally accurate because these widgets added for
   * client side decorations depend on the theme and may not be realized
   * or visible at the time resize() is issued.
   * 
   * Typically, resize() will compensate for the GtkHeaderBar
   * height only if it's known at the time the resulting GtkWindow
   * configuration is issued.
   * For example, if new widgets are added after the GtkWindow configuration
   * and cause the GtkHeaderBar to grow in height, this will result in a
   * window content smaller that specified by resize() and not
   * a larger window.
   * 
   * @param width Width in pixels to resize the window to.
   * @param height Height in pixels to resize the window to.
   */
  void resize(int width, int height);

  
  /** Obtains the current size of @a window. If @a window is not onscreen,
   * it returns the size GTK+ will suggest to the
   * [window manager][gtk-X11-arch]
   * for the initial window
   * size (but this is not reliably the same as the size the window
   * manager will actually select). The size obtained by
   * get_size() is the last size received in a
   * Gdk::EventConfigure, that is, GTK+ uses its locally-stored size,
   * rather than querying the X server for the size. As a result, if you
   * call resize() then immediately call
   * get_size(), the size won’t have taken effect yet. After
   * the window manager processes the resize request, GTK+ receives
   * notification that the size has changed via a configure event, and
   * the size of the window gets updated.
   * 
   * @note Nearly any use of this function creates a race condition,
   * because the size of the window may change between the time that you
   * get the size and the time that you perform some action assuming
   * that size is the current size. To avoid race conditions, connect to
   * “configure-event” on the window and adjust your size-dependent
   * state to match the size delivered in the Gdk::EventConfigure.
   * 
   * @note The returned size does not include the
   * size of the window manager decorations (aka the window frame or
   * border). Those are not drawn by GTK+ and GTK+ has no reliable
   * method of determining their size.
   * 
   * @note If you are getting a window size in order to position
   * the window onscreen, there may be a better way. The preferred
   * way is to simply set the window’s semantic type with
   * set_type_hint(), which allows the window manager to
   * e.g. center dialogs. Also, if you set the transient parent of
   * dialogs with set_transient_for() window managers
   * will often center the dialog over its parent window. It's
   * much preferred to let the window manager handle these
   * things rather than doing it yourself, because all apps will
   * behave consistently and according to user prefs if the window
   * manager handles it. Also, the window manager can take the size
   * of the window decorations/border into account, while your
   * application cannot.
   * 
   * @note When using client side decorations, GTK+ will do its best to
   * adjust the returned values to match the logical size of the window
   * excluding the widgets added for client side decorations, but there
   * is no garantee that the result will be totally accurate because
   * these widgets depend on the theme and may not be realized or
   * visible at the time get_size() is invoked.
   * 
   * In any case, if you insist on application-specified window
   * positioning, there’s still a better way than
   * doing it yourself - set_position() will frequently
   * handle the details for you.
   * 
   * @param width Return location for width.
   * @param height Return location for height.
   */
  void get_size(int& width, int& height) const;


  /** Asks the [window manager][gtk-X11-arch] to move
   *  @a window to the given position.  %Window managers are free to ignore
   * this; most window managers ignore requests for initial window
   * positions (instead using a user-defined placement algorithm) and
   * honor requests after the window has already been shown.
   * 
   * @note the position is the position of the gravity-determined
   * reference point for the window. The gravity determines two things:
   * first, the location of the reference point in root window
   * coordinates; and second, which point on the window is positioned at
   * the reference point.
   * 
   * By default the gravity is Gdk::GRAVITY_NORTH_WEST, so the reference
   * point is simply the @a x, @a y supplied to move(). The
   * top-left corner of the window decorations (aka window frame or
   * border) will be placed at @a x, @a y.  Therefore, to position a window
   * at the top left of the screen, you want to use the default gravity
   * (which is Gdk::GRAVITY_NORTH_WEST) and move the window to 0,0.
   * 
   * To position a window at the bottom right corner of the screen, you
   * would set Gdk::GRAVITY_SOUTH_EAST, which means that the reference
   * point is at @a x + the window width and @a y + the window height, and
   * the bottom-right corner of the window border will be placed at that
   * reference point. So, to place a window in the bottom right corner
   * you would first set gravity to south east, then write:
   * `gtk_window_move (window, gdk_screen_width() - window_width,
   * gdk_screen_height() - window_height)` (note that this
   * example does not take multi-head scenarios into account).
   * 
   * The [Extended Window Manager Hints Specification](http://www.freedesktop.org/Standards/wm-spec)
   * has a nice table of gravities in the “implementation notes” section.
   * 
   * The get_position() documentation may also be relevant.
   * 
   * @param x X coordinate to move window to.
   * @param y Y coordinate to move window to.
   */
  void move(int x, int y);

  
  /** This function returns the position you need to pass to
   * move() to keep @a window in its current position.
   * This means that the meaning of the returned value varies with
   * window gravity. See move() for more details.
   * 
   * If you haven’t changed the window gravity, its gravity will be
   * Gdk::GRAVITY_NORTH_WEST. This means that get_position()
   * gets the position of the top-left corner of the window manager
   * frame for the window. move() sets the position of this
   * same top-left corner.
   * 
   * get_position() is not 100% reliable because the X&nbsp;%Window System
   * does not specify a way to obtain the geometry of the
   * decorations placed on a window by the window manager.
   * Thus GTK+ is using a “best guess” that works with most
   * window managers.
   * 
   * Moreover, nearly all window managers are historically broken with
   * respect to their handling of window gravity. So moving a window to
   * its current position as returned by get_position() tends
   * to result in moving the window slightly. %Window managers are
   * slowly getting better over time.
   * 
   * If a window has gravity Gdk::GRAVITY_STATIC the window manager
   * frame is not relevant, and thus get_position() will
   * always produce accurate results. However you can’t use static
   * gravity to do things like place a window in a corner of the screen,
   * because static gravity ignores the window manager decorations.
   * 
   * If you are saving and restoring your application’s window
   * positions, you should know that it’s impossible for applications to
   * do this without getting it somewhat wrong because applications do
   * not have sufficient knowledge of window manager state. The Correct
   * Mechanism is to support the session management protocol (see the
   * “GnomeClient” object in the GNOME libraries for example) and allow
   * the window manager to save your window sizes and positions.
   * 
   * @param root_x Return location for X coordinate of gravity-determined reference point.
   * @param root_y Return location for Y coordinate of gravity-determined reference point.
   */
  void get_position(int& root_x, int& root_y) const;

  
  /** Parses a standard X&nbsp;%Window System geometry string - see the
   * manual page for X (type “man X”) for details on this.
   * parse_geometry() does work on all GTK+ ports
   * including Win32 but is primarily intended for an X environment.
   * 
   * If either a size or a position can be extracted from the
   * geometry string, parse_geometry() returns <tt>true</tt>
   * and calls set_default_size() and/or move()
   * to resize/move the window.
   * 
   * If parse_geometry() returns <tt>true</tt>, it will also
   * set the Gdk::HINT_USER_POS and/or Gdk::HINT_USER_SIZE hints
   * indicating to the window manager that the size/position of
   * the window was user-specified. This causes most window
   * managers to honor the geometry.
   * 
   * Note that for parse_geometry() to work as expected, it has
   * to be called when the window has its “final” size, i.e. after calling
   * Gtk::Widget::show_all() on the contents and set_geometry_hints()
   * on the window.
   * 
   * [C example ellipted]
   * 
   * @param geometry Geometry string.
   * @return <tt>true</tt> if string was parsed successfully.
   */
  bool parse_geometry(const Glib::ustring& geometry);

  
  /** Like set_default_size(), but @a width and @a height are interpreted
   * in terms of the base size and increment set with
   * gtk_window_set_geometry_hints.
   * 
   * @newin{3,0}
   * 
   * @param width Width in resize increments, or -1 to unset the default width.
   * @param height Height in resize increments, or -1 to unset the default height.
   */
  void set_default_geometry(int width, int height);
  
#ifndef GTKMM_DISABLE_DEPRECATED

  /** Like resize(), but @a width and @a height are interpreted
   * in terms of the base size and increment set with
   * gtk_window_set_geometry_hints.
   * 
   * @newin{3,0}
   * 
   * Deprecated: 3.20: This function does nothing. Use 
   * resize() and compute the geometry yourself.
   * 
   * @deprecated This function does nothing. Use resize() and compute the geometry yourself.
   * 
   * @param width Width in resize increments to resize the window to.
   * @param height Height in resize increments to resize the window to.
   */
  void resize_to_geometry(int width, int height);
#endif // GTKMM_DISABLE_DEPRECATED


  /** Returns the group for @a window or the default group, if
   *  @a window is <tt>nullptr</tt> or if @a window does not have an explicit
   * window group.
   * 
   * @newin{2,10}
   * 
   * @return The Gtk::WindowGroup for a window or the default group.
   */
  Glib::RefPtr<WindowGroup> get_group();
  
  /** Returns the group for @a window or the default group, if
   *  @a window is <tt>nullptr</tt> or if @a window does not have an explicit
   * window group.
   * 
   * @newin{2,10}
   * 
   * @return The Gtk::WindowGroup for a window or the default group.
   */
  Glib::RefPtr<const WindowGroup> get_group() const;

  
  /** Returns whether @a window has an explicit window group.
   * 
   * @newin{2,22}
   * 
   * @return <tt>true</tt> if @a window has an explicit window group.
   */
  bool has_group() const;

  
  /** Gets the type of the window. See Gtk::WindowType.
   * 
   * @newin{2,20}
   * 
   * @return The type of the window.
   */
  WindowType get_window_type() const;

  
#ifndef GTKMM_DISABLE_DEPRECATED

  /** Hides @a window, then reshows it, resetting the
   * default size and position of the window. Used
   * by GUI builders only.
   * 
   * Deprecated: 3.10: GUI builders can call Gtk::Widget::hide(),
   * Gtk::Widget::unrealize() and then Gtk::Widget::show() on @a window
   * themselves, if they still need this functionality.
   * 
   * @deprecated GUI builders can call Widget::hide(), Widget::unrealize() and then Widget::show() themselves, if they still need this functionality.
   */
  void reshow_with_initial_size();
#endif // GTKMM_DISABLE_DEPRECATED


  /** Gets the Gtk::Application associated with the window (if any).
   * 
   * @newin{3,0}
   * 
   * @return A Gtk::Application, or <tt>nullptr</tt>.
   */
  Glib::RefPtr<Application> get_application();
  
  /** Gets the Gtk::Application associated with the window (if any).
   * 
   * @newin{3,0}
   * 
   * @return A Gtk::Application, or <tt>nullptr</tt>.
   */
  Glib::RefPtr<const Application> get_application() const;

  
  /** Sets or unsets the Gtk::Application associated with the window.
   * 
   * The application will be kept alive for at least as long as the window
   * is open.
   * 
   * @newin{3,0}
   * 
   * @param application A Gtk::Application, or <tt>nullptr</tt>.
   */
  void set_application(const Glib::RefPtr<Application>& application);

  /** Unsets the Application associated with the window.
   * This could cause the application to exit if it is the application's last window.
   */
  void unset_application();

  
#ifndef GTKMM_DISABLE_DEPRECATED

  /** Sets whether @a window has a corner resize grip.
   * 
   * Note that the resize grip is only shown if the window
   * is actually resizable and not maximized. Use
   * resize_grip_is_visible() to find out if the
   * resize grip is currently shown.
   * 
   * @newin{3,0}
   * 
   * Deprecated: 3.14: Resize grips have been removed.
   * 
   * @deprecated Resize grips have been removed.
   * 
   * @param value <tt>true</tt> to allow a resize grip.
   */
  void set_has_resize_grip(bool value =  true);
#endif // GTKMM_DISABLE_DEPRECATED


#ifndef GTKMM_DISABLE_DEPRECATED

  /** Determines whether the window may have a resize grip.
   * 
   * @newin{3,0}
   * 
   * Deprecated: 3.14: Resize grips have been removed.
   * 
   * @deprecated Resize grips have been removed.
   * 
   * @return <tt>true</tt> if the window has a resize grip.
   */
  bool get_has_resize_grip() const;
#endif // GTKMM_DISABLE_DEPRECATED


#ifndef GTKMM_DISABLE_DEPRECATED

  /** Determines whether a resize grip is visible for the specified window.
   * 
   * @newin{3,0}
   * 
   * Deprecated: 3.14: Resize grips have been removed.
   * 
   * @deprecated Resize grips have been removed.
   * 
   * @return <tt>true</tt> if a resize grip exists and is visible.
   */
  bool get_resize_grip_is_visible() const;
#endif // GTKMM_DISABLE_DEPRECATED


#ifndef GTKMM_DISABLE_DEPRECATED

  /** If a window has a resize grip, this will retrieve the grip
   * position, width and height into the specified Gdk::Rectangle.
   * 
   * @newin{3,0}
   * 
   * Deprecated: 3.14: Resize grips have been removed.
   * 
   * @deprecated Resize grips have been removed.
   * 
   * @param rect A pointer to a Gdk::Rectangle which we should store
   * the resize grip area.
   * @return <tt>true</tt> if the resize grip’s area was retrieved.
   */
  bool get_resize_grip_area(Gdk::Rectangle& rect) const;
#endif // GTKMM_DISABLE_DEPRECATED


  /** Asks to keep @a window above, so that it stays on top. Note that
   * you shouldn’t assume the window is definitely above afterward,
   * because other entities (e.g. the user or
   * [window manager][gtk-X11-arch]) could not keep it above,
   * and not all window managers support keeping windows above. But
   * normally the window will end kept above. Just don’t write code
   * that crashes if not.
   * 
   * It’s permitted to call this function before showing a window,
   * in which case the window will be kept above when it appears onscreen
   * initially.
   * 
   * You can track the above state via the “window-state-event” signal
   * on Gtk::Widget.
   * 
   * Note that, according to the
   * [Extended Window Manager Hints Specification](http://www.freedesktop.org/Standards/wm-spec),
   * the above state is mainly meant for user preferences and should not
   * be used by applications e.g. for drawing attention to their
   * dialogs.
   * 
   * @newin{2,4}
   * 
   * @param setting Whether to keep @a window above other windows.
   */
  void set_keep_above(bool setting =  true);
  
  /** Asks to keep @a window below, so that it stays in bottom. Note that
   * you shouldn’t assume the window is definitely below afterward,
   * because other entities (e.g. the user or
   * [window manager][gtk-X11-arch]) could not keep it below,
   * and not all window managers support putting windows below. But
   * normally the window will be kept below. Just don’t write code
   * that crashes if not.
   * 
   * It’s permitted to call this function before showing a window,
   * in which case the window will be kept below when it appears onscreen
   * initially.
   * 
   * You can track the below state via the “window-state-event” signal
   * on Gtk::Widget.
   * 
   * Note that, according to the
   * [Extended Window Manager Hints Specification](http://www.freedesktop.org/Standards/wm-spec),
   * the above state is mainly meant for user preferences and should not
   * be used by applications e.g. for drawing attention to their
   * dialogs.
   * 
   * @newin{2,4}
   * 
   * @param setting Whether to keep @a window below other windows.
   */
  void set_keep_below(bool setting =  true);

  
  /** Sets a custom titlebar for @a window.
   * 
   * If you set a custom titlebar, GTK+ will do its best to convince
   * the window manager not to put its own titlebar on the window.
   * Depending on the system, this function may not work for a window
   * that is already visible, so you set the titlebar before calling
   * Gtk::Widget::show().
   * 
   * @newin{3,10}
   * 
   * @param titlebar The widget to use as titlebar.
   */
  void set_titlebar(Widget& titlebar);

  
  /** Returns the custom titlebar that has been set with
   * set_titlebar().
   * 
   * @newin{3,16}
   * 
   * @return The custom titlebar, or <tt>nullptr</tt>.
   */
  Widget* get_titlebar();
  
  /** Returns the custom titlebar that has been set with
   * set_titlebar().
   * 
   * @newin{3,16}
   * 
   * @return The custom titlebar, or <tt>nullptr</tt>.
   */
  const Widget* get_titlebar() const;

  
  /** Retrieves the current maximized state of @a window.
   * 
   * Note that since maximization is ultimately handled by the window
   * manager and happens asynchronously to an application request, you
   * shouldn’t assume the return value of this function changing
   * immediately (or at all), as an effect of calling
   * maximize() or unmaximize().
   * 
   * @newin{3,12}
   * 
   * @return Whether the window has a maximized state.
   */
  bool is_maximized() const;

  /** Returns a default accel group for this window
   * This is a gtkmm-specific function.  This accel group can not
   * be removed.
   */
  Glib::RefPtr<AccelGroup> get_accel_group();

  //TODO: Remove the virtual from this when we can break ABI.
  /** Brings the window to the front.
   * This is just a more obvious convenience wrapper for get_window()->raise().
   */
  virtual void raise();

  ///Overriden to warn that it doesn't make sense to use Gtk::manage() on this class because it has no parent container.
  void set_manage() override;

protected:

  //See comments in the implementations:
  void destroy_();
  void _release_c_instance();

private:

  //We'll create an accel_group if it's requested, and remember it.
  //Otherwise, you'd have to create it, add it to the window, then remember it somewhere else while you add it to other widgets.
  Glib::RefPtr<AccelGroup> accel_group_;


};


} // namespace Gtk


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gtk::Window
   */
  Gtk::Window* wrap(GtkWindow* object, bool take_copy = false);
} //namespace Glib


#endif /* _GTKMM_WINDOW_H */

