#include <gtk/gtk.h>

static GtkWidget*
get_test_page (const gchar *text)
{
  return gtk_label_new (text);
}


static void
blah_clicked (GtkButton *button, GtkAssistant *assistant)
{
  GtkWidget *page;

  page = g_object_ref (gtk_assistant_get_nth_page (assistant, 1));
  gtk_container_remove (GTK_CONTAINER (assistant), page);
  gtk_assistant_insert_page (assistant, page, 2);
  gtk_assistant_set_page_title (GTK_ASSISTANT (assistant), page, "Page 2 again");
  gtk_assistant_set_page_complete (GTK_ASSISTANT (assistant), page, TRUE);
  g_object_unref (page);
}

int main (int argc, char *argv[])
{
  GtkWidget *assistant;
  GtkWidget *page;
  GtkWidget *button;

  gtk_init (NULL, NULL);

  assistant = gtk_assistant_new ();
  gtk_window_set_default_size (GTK_WINDOW (assistant), 400, 300);

  button = gtk_button_new_with_label ("Blah");
  gtk_button_set_use_underline (GTK_BUTTON (button), TRUE);
  gtk_widget_show (button);
  gtk_assistant_add_action_widget (GTK_ASSISTANT (assistant), button);
  g_signal_connect (button, "clicked",
                    G_CALLBACK (blah_clicked), assistant);

  page = get_test_page ("Page 1");
  gtk_widget_show (page);
  gtk_assistant_append_page (GTK_ASSISTANT (assistant), page);
  gtk_assistant_set_page_title (GTK_ASSISTANT (assistant), page, "Page 1");
  gtk_assistant_set_page_complete (GTK_ASSISTANT (assistant), page, TRUE);

  page = get_test_page ("Page 2");
  gtk_widget_show (page);
  gtk_assistant_append_page (GTK_ASSISTANT (assistant), page);
  gtk_assistant_set_page_title (GTK_ASSISTANT (assistant), page, "Page 2");
  gtk_assistant_set_page_complete (GTK_ASSISTANT (assistant), page, TRUE);

  page = get_test_page ("Page 3");
  gtk_widget_show (page);
  gtk_assistant_append_page (GTK_ASSISTANT (assistant), page);
  gtk_assistant_set_page_title (GTK_ASSISTANT (assistant), page, "Page 3");
  gtk_assistant_set_page_complete (GTK_ASSISTANT (assistant), page, TRUE);

  page = get_test_page ("Summary");
  gtk_widget_show (page);
  gtk_assistant_append_page (GTK_ASSISTANT (assistant), page);
  gtk_assistant_set_page_type (GTK_ASSISTANT (assistant), page, GTK_ASSISTANT_PAGE_CONFIRM);
  gtk_assistant_set_page_title (GTK_ASSISTANT (assistant), page, "Summary");
  gtk_assistant_set_page_complete (GTK_ASSISTANT (assistant), page, TRUE);

  gtk_widget_show (assistant);

  gtk_main ();

  return 0;
}
