/* gnome-calculator.c generated by valac 0.27.2.2-e6bbc, the Vala compiler
 * generated from gnome-calculator.vala, do not modify */

/*
 * Copyright (C) 1987-2008 Sun Microsystems, Inc. All Rights Reserved.
 * Copyright (C) 2008-2012 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gtksourceview/gtksource.h>
#include <stdio.h>
#include <langinfo.h>
#include <glib/gi18n-lib.h>
#include <locale.h>


#define TYPE_CALCULATOR (calculator_get_type ())
#define CALCULATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CALCULATOR, Calculator))
#define CALCULATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CALCULATOR, CalculatorClass))
#define IS_CALCULATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CALCULATOR))
#define IS_CALCULATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CALCULATOR))
#define CALCULATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CALCULATOR, CalculatorClass))

typedef struct _Calculator Calculator;
typedef struct _CalculatorClass CalculatorClass;
typedef struct _CalculatorPrivate CalculatorPrivate;

#define TYPE_MATH_WINDOW (math_window_get_type ())
#define MATH_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_WINDOW, MathWindow))
#define MATH_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_WINDOW, MathWindowClass))
#define IS_MATH_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_WINDOW))
#define IS_MATH_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_WINDOW))
#define MATH_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_WINDOW, MathWindowClass))

typedef struct _MathWindow MathWindow;
typedef struct _MathWindowClass MathWindowClass;

#define TYPE_MATH_PREFERENCES_DIALOG (math_preferences_dialog_get_type ())
#define MATH_PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_PREFERENCES_DIALOG, MathPreferencesDialog))
#define MATH_PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_PREFERENCES_DIALOG, MathPreferencesDialogClass))
#define IS_MATH_PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_PREFERENCES_DIALOG))
#define IS_MATH_PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_PREFERENCES_DIALOG))
#define MATH_PREFERENCES_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_PREFERENCES_DIALOG, MathPreferencesDialogClass))

typedef struct _MathPreferencesDialog MathPreferencesDialog;
typedef struct _MathPreferencesDialogClass MathPreferencesDialogClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_DISPLAY_FORMAT (display_format_get_type ())

#define TYPE_ANGLE_UNIT (angle_unit_get_type ())

#define TYPE_BUTTON_MODE (button_mode_get_type ())

#define TYPE_MATH_EQUATION (math_equation_get_type ())
#define MATH_EQUATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_EQUATION, MathEquation))
#define MATH_EQUATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_EQUATION, MathEquationClass))
#define IS_MATH_EQUATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_EQUATION))
#define IS_MATH_EQUATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_EQUATION))
#define MATH_EQUATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_EQUATION, MathEquationClass))

typedef struct _MathEquation MathEquation;
typedef struct _MathEquationClass MathEquationClass;

#define TYPE_MATH_BUTTONS (math_buttons_get_type ())
#define MATH_BUTTONS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_BUTTONS, MathButtons))
#define MATH_BUTTONS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_BUTTONS, MathButtonsClass))
#define IS_MATH_BUTTONS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_BUTTONS))
#define IS_MATH_BUTTONS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_BUTTONS))
#define MATH_BUTTONS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_BUTTONS, MathButtonsClass))

typedef struct _MathButtons MathButtons;
typedef struct _MathButtonsClass MathButtonsClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))

#define TYPE_EQUATION (equation_get_type ())
#define EQUATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EQUATION, Equation))
#define EQUATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EQUATION, EquationClass))
#define IS_EQUATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EQUATION))
#define IS_EQUATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EQUATION))
#define EQUATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EQUATION, EquationClass))

typedef struct _Equation Equation;
typedef struct _EquationClass EquationClass;

#define TYPE_SOLVE_EQUATION (solve_equation_get_type ())
#define SOLVE_EQUATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOLVE_EQUATION, SolveEquation))
#define SOLVE_EQUATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOLVE_EQUATION, SolveEquationClass))
#define IS_SOLVE_EQUATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOLVE_EQUATION))
#define IS_SOLVE_EQUATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOLVE_EQUATION))
#define SOLVE_EQUATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOLVE_EQUATION, SolveEquationClass))

typedef struct _SolveEquation SolveEquation;
typedef struct _SolveEquationClass SolveEquationClass;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _EquationPrivate EquationPrivate;

#define TYPE_NUMBER (number_get_type ())
#define NUMBER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NUMBER, Number))
#define NUMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NUMBER, NumberClass))
#define IS_NUMBER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NUMBER))
#define IS_NUMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NUMBER))
#define NUMBER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NUMBER, NumberClass))

typedef struct _Number Number;
typedef struct _NumberClass NumberClass;

#define TYPE_ERROR_CODE (error_code_get_type ())

#define TYPE_SERIALIZER (serializer_get_type ())
#define SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SERIALIZER, Serializer))
#define SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SERIALIZER, SerializerClass))
#define IS_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SERIALIZER))
#define IS_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SERIALIZER))
#define SERIALIZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SERIALIZER, SerializerClass))

typedef struct _Serializer Serializer;
typedef struct _SerializerClass SerializerClass;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
typedef struct _SolveEquationPrivate SolveEquationPrivate;

#define TYPE_UNIT_MANAGER (unit_manager_get_type ())
#define UNIT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNIT_MANAGER, UnitManager))
#define UNIT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNIT_MANAGER, UnitManagerClass))
#define IS_UNIT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNIT_MANAGER))
#define IS_UNIT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNIT_MANAGER))
#define UNIT_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNIT_MANAGER, UnitManagerClass))

typedef struct _UnitManager UnitManager;
typedef struct _UnitManagerClass UnitManagerClass;

struct _Calculator {
	GtkApplication parent_instance;
	CalculatorPrivate * priv;
};

struct _CalculatorClass {
	GtkApplicationClass parent_class;
};

struct _CalculatorPrivate {
	GSettings* settings;
	MathWindow* window;
	MathPreferencesDialog* preferences_dialog;
};

typedef enum  {
	DISPLAY_FORMAT_AUTOMATIC,
	DISPLAY_FORMAT_FIXED,
	DISPLAY_FORMAT_SCIENTIFIC,
	DISPLAY_FORMAT_ENGINEERING
} DisplayFormat;

typedef enum  {
	ANGLE_UNIT_RADIANS,
	ANGLE_UNIT_DEGREES,
	ANGLE_UNIT_GRADIANS
} AngleUnit;

typedef enum  {
	BUTTON_MODE_BASIC,
	BUTTON_MODE_ADVANCED,
	BUTTON_MODE_FINANCIAL,
	BUTTON_MODE_PROGRAMMING,
	BUTTON_MODE_KEYBOARD
} ButtonMode;

struct _Equation {
	GObject parent_instance;
	EquationPrivate * priv;
	gint base;
	gint wordlen;
	AngleUnit angle_units;
};

struct _EquationClass {
	GObjectClass parent_class;
	gboolean (*variable_is_defined) (Equation* self, const gchar* name);
	Number* (*get_variable) (Equation* self, const gchar* name);
	void (*set_variable) (Equation* self, const gchar* name, Number* x);
	gboolean (*function_is_defined) (Equation* self, const gchar* name);
	Number* (*convert) (Equation* self, Number* x, const gchar* x_units, const gchar* z_units);
};

typedef enum  {
	ERROR_CODE_NONE,
	ERROR_CODE_INVALID,
	ERROR_CODE_OVERFLOW,
	ERROR_CODE_UNKNOWN_VARIABLE,
	ERROR_CODE_UNKNOWN_FUNCTION,
	ERROR_CODE_UNKNOWN_CONVERSION,
	ERROR_CODE_MP
} ErrorCode;

struct _SolveEquation {
	Equation parent_instance;
	SolveEquationPrivate * priv;
};

struct _SolveEquationClass {
	EquationClass parent_class;
};


static gpointer calculator_parent_class = NULL;
static gchar* calculator_program_name;
static gchar* calculator_program_name = NULL;
static gchar* calculator_equation_string;
static gchar* calculator_equation_string = NULL;
static gpointer solve_equation_parent_class = NULL;

GType calculator_get_type (void) G_GNUC_CONST;
GType math_window_get_type (void) G_GNUC_CONST;
GType math_preferences_dialog_get_type (void) G_GNUC_CONST;
#define CALCULATOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CALCULATOR, CalculatorPrivate))
enum  {
	CALCULATOR_DUMMY_PROPERTY
};
static void calculator_show_preferences_cb (Calculator* self);
static void _calculator_show_preferences_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void calculator_help_cb (Calculator* self);
static void _calculator_help_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void calculator_about_cb (Calculator* self);
static void _calculator_about_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void calculator_quit_cb (Calculator* self);
static void _calculator_quit_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
Calculator* calculator_new (void);
Calculator* calculator_construct (GType object_type);
static void calculator_real_startup (GApplication* base);
GType display_format_get_type (void) G_GNUC_CONST;
GType angle_unit_get_type (void) G_GNUC_CONST;
GType button_mode_get_type (void) G_GNUC_CONST;
GType math_equation_get_type (void) G_GNUC_CONST;
MathEquation* math_equation_new (void);
MathEquation* math_equation_construct (GType object_type);
void math_equation_set_accuracy (MathEquation* self, gint value);
void math_equation_set_word_size (MathEquation* self, gint value);
void math_equation_set_show_thousands_separators (MathEquation* self, gboolean value);
void math_equation_set_show_trailing_zeroes (MathEquation* self, gboolean value);
void math_equation_set_number_format (MathEquation* self, DisplayFormat value);
void math_equation_set_angle_units (MathEquation* self, AngleUnit value);
void math_equation_set_source_currency (MathEquation* self, const gchar* value);
void math_equation_set_target_currency (MathEquation* self, const gchar* value);
void math_equation_set_source_units (MathEquation* self, const gchar* value);
void math_equation_set_target_units (MathEquation* self, const gchar* value);
gulong number_get_precision (void);
void number_set_precision (gulong value);
MathWindow* math_window_new (GtkApplication* app, MathEquation* equation);
MathWindow* math_window_construct (GType object_type, GtkApplication* app, MathEquation* equation);
GType math_buttons_get_type (void) G_GNUC_CONST;
MathButtons* math_window_get_buttons (MathWindow* self);
void math_buttons_set_programming_base (MathButtons* self, gint value);
void math_buttons_set_mode (MathButtons* self, ButtonMode value);
static void calculator_real_activate (GApplication* base);
MathEquation* math_window_get_equation (MathWindow* self);
void math_equation_set (MathEquation* self, const gchar* text);
void math_equation_solve (MathEquation* self);
static void calculator_real_shutdown (GApplication* base);
ButtonMode math_buttons_get_mode (MathButtons* self);
gint math_equation_get_accuracy (MathEquation* self);
gint math_equation_get_word_size (MathEquation* self);
gboolean math_equation_get_show_thousands_separators (MathEquation* self);
gboolean math_equation_get_show_trailing_zeroes (MathEquation* self);
DisplayFormat math_equation_get_number_format (MathEquation* self);
AngleUnit math_equation_get_angle_units (MathEquation* self);
gchar* math_equation_get_source_currency (MathEquation* self);
gchar* math_equation_get_target_currency (MathEquation* self);
gchar* math_equation_get_source_units (MathEquation* self);
gchar* math_equation_get_target_units (MathEquation* self);
gint math_buttons_get_programming_base (MathButtons* self);
static gint calculator_real_handle_local_options (GApplication* base, GVariantDict* options);
static gchar* _variant_get1 (GVariant* value);
GType equation_get_type (void) G_GNUC_CONST;
GType solve_equation_get_type (void) G_GNUC_CONST;
SolveEquation* solve_equation_new (const gchar* text);
SolveEquation* solve_equation_construct (GType object_type, const gchar* text);
GType number_get_type (void) G_GNUC_CONST;
GType error_code_get_type (void) G_GNUC_CONST;
Number* equation_parse (Equation* self, guint* representation_base, ErrorCode* error_code, gchar** error_token, guint** error_start, guint** error_end);
GType serializer_get_type (void) G_GNUC_CONST;
Serializer* serializer_new (DisplayFormat format, gint number_base, gint trailing_digits);
Serializer* serializer_construct (GType object_type, DisplayFormat format, gint number_base, gint trailing_digits);
void serializer_set_representation_base (Serializer* self, guint representation_base);
gchar* serializer_to_string (Serializer* self, Number* x);
const gchar* number_get_error (void);
gchar* mp_error_code_to_string (ErrorCode error_code);
MathPreferencesDialog* math_preferences_dialog_new (MathEquation* eq);
MathPreferencesDialog* math_preferences_dialog_construct (GType object_type, MathEquation* eq);
gint calculator_main (gchar** args, int args_length1);
static void calculator_finalize (GObject* obj);
enum  {
	SOLVE_EQUATION_DUMMY_PROPERTY
};
Equation* equation_new (const gchar* expression);
Equation* equation_construct (GType object_type, const gchar* expression);
static Number* solve_equation_real_convert (Equation* base, Number* x, const gchar* x_units, const gchar* z_units);
GType unit_manager_get_type (void) G_GNUC_CONST;
UnitManager* unit_manager_get_default (void);
Number* unit_manager_convert_by_symbol (UnitManager* self, Number* x, const gchar* x_symbol, const gchar* z_symbol);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const GOptionEntry CALCULATOR_option_entries[4] = {{"solve", 's', 0, G_OPTION_ARG_STRING, NULL, "Solve given equation", "equation"}, {"equation", 'e', 0, G_OPTION_ARG_STRING, &calculator_equation_string, "Start with given equation", "equation"}, {"version", 'v', 0, G_OPTION_ARG_NONE, NULL, "Show release version", NULL}, {NULL}};
static const GActionEntry CALCULATOR_app_entries[4] = {{"preferences", _calculator_show_preferences_cb_gsimple_action_activate_callback, NULL, NULL, NULL}, {"help", _calculator_help_cb_gsimple_action_activate_callback, NULL, NULL, NULL}, {"about", _calculator_about_cb_gsimple_action_activate_callback, NULL, NULL, NULL}, {"quit", _calculator_quit_cb_gsimple_action_activate_callback, NULL, NULL, NULL}};

static void _calculator_show_preferences_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 27 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	calculator_show_preferences_cb ((Calculator*) self);
#line 324 "gnome-calculator.c"
}


static void _calculator_help_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 27 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	calculator_help_cb ((Calculator*) self);
#line 331 "gnome-calculator.c"
}


static void _calculator_about_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 27 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	calculator_about_cb ((Calculator*) self);
#line 338 "gnome-calculator.c"
}


static void _calculator_quit_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 27 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	calculator_quit_cb ((Calculator*) self);
#line 345 "gnome-calculator.c"
}


Calculator* calculator_construct (GType object_type) {
	Calculator * self = NULL;
#line 37 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	self = (Calculator*) g_object_new (object_type, "flags", G_APPLICATION_NON_UNIQUE, NULL);
#line 39 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	g_application_add_main_option_entries ((GApplication*) self, CALCULATOR_option_entries);
#line 35 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	return self;
#line 357 "gnome-calculator.c"
}


Calculator* calculator_new (void) {
#line 35 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	return calculator_construct (TYPE_CALCULATOR);
#line 364 "gnome-calculator.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 77 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	return self ? g_object_ref (self) : NULL;
#line 371 "gnome-calculator.c"
}


static void calculator_real_startup (GApplication* base) {
	Calculator * self;
	GSettings* _tmp0_ = NULL;
	gint accuracy = 0;
	GSettings* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint word_size = 0;
	GSettings* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint number_base = 0;
	GSettings* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gboolean show_tsep = FALSE;
	GSettings* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	gboolean show_zeroes = FALSE;
	GSettings* _tmp9_ = NULL;
	gboolean _tmp10_ = FALSE;
	DisplayFormat number_format = 0;
	GSettings* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	AngleUnit angle_units = 0;
	GSettings* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	ButtonMode button_mode = 0;
	GSettings* _tmp15_ = NULL;
	gint _tmp16_ = 0;
	gchar* source_currency = NULL;
	GSettings* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	gchar* target_currency = NULL;
	GSettings* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	gchar* source_units = NULL;
	GSettings* _tmp21_ = NULL;
	gchar* _tmp22_ = NULL;
	gchar* target_units = NULL;
	GSettings* _tmp23_ = NULL;
	gchar* _tmp24_ = NULL;
	gint precision = 0;
	GSettings* _tmp25_ = NULL;
	gint _tmp26_ = 0;
	MathEquation* equation = NULL;
	MathEquation* _tmp27_ = NULL;
	gulong _tmp28_ = 0UL;
	gulong _tmp29_ = 0UL;
	MathWindow* _tmp30_ = NULL;
	MathButtons* buttons = NULL;
	MathWindow* _tmp31_ = NULL;
	MathButtons* _tmp32_ = NULL;
	MathButtons* _tmp33_ = NULL;
	MathButtons* _tmp34_ = NULL;
	GtkBuilder* builder = NULL;
	GtkBuilder* _tmp35_ = NULL;
	GMenuModel* menu = NULL;
	GObject* _tmp37_ = NULL;
	GMenuModel* _tmp38_ = NULL;
	gchar* _tmp39_ = NULL;
	gchar** _tmp40_ = NULL;
	gchar** _tmp41_ = NULL;
	gint _tmp41__length1 = 0;
	gchar* _tmp42_ = NULL;
	gchar** _tmp43_ = NULL;
	gchar** _tmp44_ = NULL;
	gint _tmp44__length1 = 0;
	gchar* _tmp45_ = NULL;
	gchar** _tmp46_ = NULL;
	gchar** _tmp47_ = NULL;
	gint _tmp47__length1 = 0;
	gchar* _tmp48_ = NULL;
	gchar** _tmp49_ = NULL;
	gchar** _tmp50_ = NULL;
	gint _tmp50__length1 = 0;
	GError * _inner_error_ = NULL;
#line 42 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	self = (Calculator*) base;
#line 44 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	G_APPLICATION_CLASS (calculator_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp0_ = g_settings_new ("org.gnome.calculator");
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_g_object_unref0 (self->priv->settings);
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	self->priv->settings = _tmp0_;
#line 47 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp1_ = self->priv->settings;
#line 47 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp2_ = g_settings_get_int (_tmp1_, "accuracy");
#line 47 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	accuracy = _tmp2_;
#line 48 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp3_ = self->priv->settings;
#line 48 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp4_ = g_settings_get_int (_tmp3_, "word-size");
#line 48 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	word_size = _tmp4_;
#line 49 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp5_ = self->priv->settings;
#line 49 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp6_ = g_settings_get_int (_tmp5_, "base");
#line 49 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	number_base = _tmp6_;
#line 50 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp7_ = self->priv->settings;
#line 50 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp8_ = g_settings_get_boolean (_tmp7_, "show-thousands");
#line 50 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	show_tsep = _tmp8_;
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp9_ = self->priv->settings;
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp10_ = g_settings_get_boolean (_tmp9_, "show-zeroes");
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	show_zeroes = _tmp10_;
#line 52 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp11_ = self->priv->settings;
#line 52 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp12_ = g_settings_get_enum (_tmp11_, "number-format");
#line 52 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	number_format = (DisplayFormat) _tmp12_;
#line 53 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp13_ = self->priv->settings;
#line 53 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp14_ = g_settings_get_enum (_tmp13_, "angle-units");
#line 53 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	angle_units = (AngleUnit) _tmp14_;
#line 54 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp15_ = self->priv->settings;
#line 54 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp16_ = g_settings_get_enum (_tmp15_, "button-mode");
#line 54 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	button_mode = (ButtonMode) _tmp16_;
#line 55 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp17_ = self->priv->settings;
#line 55 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp18_ = g_settings_get_string (_tmp17_, "source-currency");
#line 55 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	source_currency = _tmp18_;
#line 56 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp19_ = self->priv->settings;
#line 56 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp20_ = g_settings_get_string (_tmp19_, "target-currency");
#line 56 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	target_currency = _tmp20_;
#line 57 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp21_ = self->priv->settings;
#line 57 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp22_ = g_settings_get_string (_tmp21_, "source-units");
#line 57 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	source_units = _tmp22_;
#line 58 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp23_ = self->priv->settings;
#line 58 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp24_ = g_settings_get_string (_tmp23_, "target-units");
#line 58 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	target_units = _tmp24_;
#line 59 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp25_ = self->priv->settings;
#line 59 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp26_ = g_settings_get_int (_tmp25_, "precision");
#line 59 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	precision = _tmp26_;
#line 61 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp27_ = math_equation_new ();
#line 61 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	equation = _tmp27_;
#line 62 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	math_equation_set_accuracy (equation, accuracy);
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	math_equation_set_word_size (equation, word_size);
#line 64 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	math_equation_set_show_thousands_separators (equation, show_tsep);
#line 65 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	math_equation_set_show_trailing_zeroes (equation, show_zeroes);
#line 66 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	math_equation_set_number_format (equation, number_format);
#line 67 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	math_equation_set_angle_units (equation, angle_units);
#line 68 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	math_equation_set_source_currency (equation, source_currency);
#line 69 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	math_equation_set_target_currency (equation, target_currency);
#line 70 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	math_equation_set_source_units (equation, source_units);
#line 71 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	math_equation_set_target_units (equation, target_units);
#line 72 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp28_ = number_get_precision ();
#line 72 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp29_ = _tmp28_;
#line 72 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	number_set_precision ((gulong) precision);
#line 74 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	g_action_map_add_action_entries ((GActionMap*) self, CALCULATOR_app_entries, G_N_ELEMENTS (CALCULATOR_app_entries), self);
#line 76 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp30_ = math_window_new ((GtkApplication*) self, equation);
#line 76 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	g_object_ref_sink (_tmp30_);
#line 76 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_g_object_unref0 (self->priv->window);
#line 76 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	self->priv->window = _tmp30_;
#line 77 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp31_ = self->priv->window;
#line 77 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp32_ = math_window_get_buttons (_tmp31_);
#line 77 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp33_ = _tmp32_;
#line 77 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp34_ = _g_object_ref0 (_tmp33_);
#line 77 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	buttons = _tmp34_;
#line 78 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	math_buttons_set_programming_base (buttons, number_base);
#line 79 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	math_buttons_set_mode (buttons, button_mode);
#line 81 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp35_ = gtk_builder_new ();
#line 81 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	builder = _tmp35_;
#line 595 "gnome-calculator.c"
	{
#line 84 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		gtk_builder_add_from_resource (builder, "/org/gnome/calculator/menu.ui", &_inner_error_);
#line 84 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 601 "gnome-calculator.c"
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp36_ = NULL;
#line 82 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		e = _inner_error_;
#line 82 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		_inner_error_ = NULL;
#line 88 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		_tmp36_ = e->message;
#line 88 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		g_error ("gnome-calculator.vala:88: Error loading menu UI: %s", _tmp36_);
#line 82 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		_g_error_free0 (e);
#line 620 "gnome-calculator.c"
	}
	__finally0:
#line 82 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 82 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		_g_object_unref0 (builder);
#line 82 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		_g_object_unref0 (buttons);
#line 82 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		_g_object_unref0 (equation);
#line 82 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		_g_free0 (target_units);
#line 82 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		_g_free0 (source_units);
#line 82 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		_g_free0 (target_currency);
#line 82 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		_g_free0 (source_currency);
#line 82 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 82 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		g_clear_error (&_inner_error_);
#line 82 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		return;
#line 645 "gnome-calculator.c"
	}
#line 91 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp37_ = gtk_builder_get_object (builder, "appmenu");
#line 91 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp38_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp37_, g_menu_model_get_type ()) ? ((GMenuModel*) _tmp37_) : NULL);
#line 91 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	menu = _tmp38_;
#line 92 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	gtk_application_set_app_menu ((GtkApplication*) self, menu);
#line 94 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp39_ = g_strdup ("<control>C");
#line 94 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp40_ = g_new0 (gchar*, 1 + 1);
#line 94 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp40_[0] = _tmp39_;
#line 94 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp41_ = _tmp40_;
#line 94 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp41__length1 = 1;
#line 94 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win.copy", _tmp41_);
#line 94 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp41_ = (_vala_array_free (_tmp41_, _tmp41__length1, (GDestroyNotify) g_free), NULL);
#line 95 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp42_ = g_strdup ("<control>V");
#line 95 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp43_ = g_new0 (gchar*, 1 + 1);
#line 95 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp43_[0] = _tmp42_;
#line 95 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp44_ = _tmp43_;
#line 95 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp44__length1 = 1;
#line 95 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win.paste", _tmp44_);
#line 95 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp44_ = (_vala_array_free (_tmp44_, _tmp44__length1, (GDestroyNotify) g_free), NULL);
#line 96 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp45_ = g_strdup ("<control>Z");
#line 96 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp46_ = g_new0 (gchar*, 1 + 1);
#line 96 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp46_[0] = _tmp45_;
#line 96 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp47_ = _tmp46_;
#line 96 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp47__length1 = 1;
#line 96 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win.undo", _tmp47_);
#line 96 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp47_ = (_vala_array_free (_tmp47_, _tmp47__length1, (GDestroyNotify) g_free), NULL);
#line 97 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp48_ = g_strdup ("<control><shift>Z");
#line 97 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp49_ = g_new0 (gchar*, 1 + 1);
#line 97 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp49_[0] = _tmp48_;
#line 97 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp50_ = _tmp49_;
#line 97 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp50__length1 = 1;
#line 97 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win.redo", _tmp50_);
#line 97 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp50_ = (_vala_array_free (_tmp50_, _tmp50__length1, (GDestroyNotify) g_free), NULL);
#line 42 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_g_object_unref0 (menu);
#line 42 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_g_object_unref0 (builder);
#line 42 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_g_object_unref0 (buttons);
#line 42 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_g_object_unref0 (equation);
#line 42 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_g_free0 (target_units);
#line 42 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_g_free0 (source_units);
#line 42 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_g_free0 (target_currency);
#line 42 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_g_free0 (source_currency);
#line 727 "gnome-calculator.c"
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
#line 1115 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1116 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp0_ = g_strdup (self);
#line 1116 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1117 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp1_ = _result_;
#line 1117 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_strstrip (_tmp1_);
#line 1118 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	result = _result_;
#line 1118 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	return result;
#line 750 "gnome-calculator.c"
}


static void calculator_real_activate (GApplication* base) {
	Calculator * self;
	MathWindow* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_ = NULL;
#line 100 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	self = (Calculator*) base;
#line 102 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	G_APPLICATION_CLASS (calculator_parent_class)->activate ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp0_ = self->priv->window;
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	gtk_window_present ((GtkWindow*) _tmp0_);
#line 105 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp2_ = calculator_equation_string;
#line 105 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	if (g_strcmp0 (_tmp2_, "") != 0) {
#line 771 "gnome-calculator.c"
		const gchar* _tmp3_ = NULL;
#line 105 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		_tmp3_ = calculator_equation_string;
#line 105 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		_tmp1_ = _tmp3_ != NULL;
#line 777 "gnome-calculator.c"
	} else {
#line 105 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		_tmp1_ = FALSE;
#line 781 "gnome-calculator.c"
	}
#line 105 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	if (_tmp1_) {
#line 785 "gnome-calculator.c"
		gchar** equations = NULL;
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar** _tmp7_ = NULL;
		gchar** _tmp8_ = NULL;
		gchar** _tmp9_ = NULL;
		gint _tmp9__length1 = 0;
		gint equations_length1 = 0;
		gint _equations_size_ = 0;
#line 107 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		_tmp4_ = calculator_equation_string;
#line 107 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		_tmp5_ = g_strcompress (_tmp4_);
#line 107 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		_tmp6_ = _tmp5_;
#line 107 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		_tmp8_ = _tmp7_ = g_strsplit (_tmp6_, "\n", 0);
#line 107 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		_tmp9_ = _tmp8_;
#line 107 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		_tmp9__length1 = _vala_array_length (_tmp7_);
#line 107 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		_g_free0 (_tmp6_);
#line 107 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		equations = _tmp9_;
#line 107 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		equations_length1 = _tmp9__length1;
#line 107 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		_equations_size_ = equations_length1;
#line 816 "gnome-calculator.c"
		{
			gint i = 0;
#line 108 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
			i = 0;
#line 821 "gnome-calculator.c"
			{
				gboolean _tmp10_ = FALSE;
#line 108 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
				_tmp10_ = TRUE;
#line 108 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
				while (TRUE) {
#line 828 "gnome-calculator.c"
					gint _tmp12_ = 0;
					gchar** _tmp13_ = NULL;
					gint _tmp13__length1 = 0;
					gchar** _tmp14_ = NULL;
					gint _tmp14__length1 = 0;
					gint _tmp15_ = 0;
					const gchar* _tmp16_ = NULL;
					gchar* _tmp17_ = NULL;
					gchar* _tmp18_ = NULL;
					gint _tmp19_ = 0;
					gint _tmp20_ = 0;
					gboolean _tmp21_ = FALSE;
#line 108 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
					if (!_tmp10_) {
#line 843 "gnome-calculator.c"
						gint _tmp11_ = 0;
#line 108 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
						_tmp11_ = i;
#line 108 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
						i = _tmp11_ + 1;
#line 849 "gnome-calculator.c"
					}
#line 108 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
					_tmp10_ = FALSE;
#line 108 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
					_tmp12_ = i;
#line 108 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
					_tmp13_ = equations;
#line 108 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
					_tmp13__length1 = equations_length1;
#line 108 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
					if (!(_tmp12_ < _tmp13__length1)) {
#line 108 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
						break;
#line 863 "gnome-calculator.c"
					}
#line 110 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
					_tmp14_ = equations;
#line 110 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
					_tmp14__length1 = equations_length1;
#line 110 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
					_tmp15_ = i;
#line 110 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
					_tmp16_ = _tmp14_[_tmp15_];
#line 110 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
					_tmp17_ = string_strip (_tmp16_);
#line 110 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
					_tmp18_ = _tmp17_;
#line 110 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
					_tmp19_ = strlen (_tmp18_);
#line 110 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
					_tmp20_ = _tmp19_;
#line 110 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
					_tmp21_ = _tmp20_ > 0;
#line 110 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
					_g_free0 (_tmp18_);
#line 110 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
					if (_tmp21_) {
#line 887 "gnome-calculator.c"
						MathWindow* _tmp22_ = NULL;
						MathEquation* _tmp23_ = NULL;
						MathEquation* _tmp24_ = NULL;
						gchar** _tmp25_ = NULL;
						gint _tmp25__length1 = 0;
						gint _tmp26_ = 0;
						const gchar* _tmp27_ = NULL;
#line 111 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
						_tmp22_ = self->priv->window;
#line 111 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
						_tmp23_ = math_window_get_equation (_tmp22_);
#line 111 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
						_tmp24_ = _tmp23_;
#line 111 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
						_tmp25_ = equations;
#line 111 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
						_tmp25__length1 = equations_length1;
#line 111 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
						_tmp26_ = i;
#line 111 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
						_tmp27_ = _tmp25_[_tmp26_];
#line 111 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
						math_equation_set (_tmp24_, _tmp27_);
#line 911 "gnome-calculator.c"
					} else {
						MathWindow* _tmp28_ = NULL;
						MathEquation* _tmp29_ = NULL;
						MathEquation* _tmp30_ = NULL;
#line 113 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
						_tmp28_ = self->priv->window;
#line 113 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
						_tmp29_ = math_window_get_equation (_tmp28_);
#line 113 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
						_tmp30_ = _tmp29_;
#line 113 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
						math_equation_solve (_tmp30_);
#line 924 "gnome-calculator.c"
					}
				}
			}
		}
#line 105 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		equations = (_vala_array_free (equations, equations_length1, (GDestroyNotify) g_free), NULL);
#line 931 "gnome-calculator.c"
	}
}


static void calculator_real_shutdown (GApplication* base) {
	Calculator * self;
	MathEquation* equation = NULL;
	MathWindow* _tmp0_ = NULL;
	MathEquation* _tmp1_ = NULL;
	MathEquation* _tmp2_ = NULL;
	MathEquation* _tmp3_ = NULL;
	MathButtons* buttons = NULL;
	MathWindow* _tmp4_ = NULL;
	MathButtons* _tmp5_ = NULL;
	MathButtons* _tmp6_ = NULL;
	MathButtons* _tmp7_ = NULL;
	GSettings* _tmp8_ = NULL;
	ButtonMode _tmp9_ = 0;
	ButtonMode _tmp10_ = 0;
	GSettings* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	GSettings* _tmp14_ = NULL;
	gint _tmp15_ = 0;
	gint _tmp16_ = 0;
	GSettings* _tmp17_ = NULL;
	gboolean _tmp18_ = FALSE;
	gboolean _tmp19_ = FALSE;
	GSettings* _tmp20_ = NULL;
	gboolean _tmp21_ = FALSE;
	gboolean _tmp22_ = FALSE;
	GSettings* _tmp23_ = NULL;
	DisplayFormat _tmp24_ = 0;
	DisplayFormat _tmp25_ = 0;
	GSettings* _tmp26_ = NULL;
	AngleUnit _tmp27_ = 0;
	AngleUnit _tmp28_ = 0;
	GSettings* _tmp29_ = NULL;
	gchar* _tmp30_ = NULL;
	gchar* _tmp31_ = NULL;
	gchar* _tmp32_ = NULL;
	GSettings* _tmp33_ = NULL;
	gchar* _tmp34_ = NULL;
	gchar* _tmp35_ = NULL;
	gchar* _tmp36_ = NULL;
	GSettings* _tmp37_ = NULL;
	gchar* _tmp38_ = NULL;
	gchar* _tmp39_ = NULL;
	gchar* _tmp40_ = NULL;
	GSettings* _tmp41_ = NULL;
	gchar* _tmp42_ = NULL;
	gchar* _tmp43_ = NULL;
	gchar* _tmp44_ = NULL;
	GSettings* _tmp45_ = NULL;
	gint _tmp46_ = 0;
	gint _tmp47_ = 0;
#line 118 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	self = (Calculator*) base;
#line 120 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	G_APPLICATION_CLASS (calculator_parent_class)->shutdown ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
#line 122 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp0_ = self->priv->window;
#line 122 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp1_ = math_window_get_equation (_tmp0_);
#line 122 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp2_ = _tmp1_;
#line 122 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 122 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	equation = _tmp3_;
#line 123 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp4_ = self->priv->window;
#line 123 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp5_ = math_window_get_buttons (_tmp4_);
#line 123 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp6_ = _tmp5_;
#line 123 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp7_ = _g_object_ref0 (_tmp6_);
#line 123 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	buttons = _tmp7_;
#line 125 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp8_ = self->priv->settings;
#line 125 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp9_ = math_buttons_get_mode (buttons);
#line 125 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp10_ = _tmp9_;
#line 125 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	g_settings_set_enum (_tmp8_, "button-mode", (gint) _tmp10_);
#line 126 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp11_ = self->priv->settings;
#line 126 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp12_ = math_equation_get_accuracy (equation);
#line 126 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp13_ = _tmp12_;
#line 126 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	g_settings_set_int (_tmp11_, "accuracy", _tmp13_);
#line 127 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp14_ = self->priv->settings;
#line 127 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp15_ = math_equation_get_word_size (equation);
#line 127 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp16_ = _tmp15_;
#line 127 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	g_settings_set_int (_tmp14_, "word-size", _tmp16_);
#line 128 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp17_ = self->priv->settings;
#line 128 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp18_ = math_equation_get_show_thousands_separators (equation);
#line 128 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp19_ = _tmp18_;
#line 128 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	g_settings_set_boolean (_tmp17_, "show-thousands", _tmp19_);
#line 129 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp20_ = self->priv->settings;
#line 129 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp21_ = math_equation_get_show_trailing_zeroes (equation);
#line 129 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp22_ = _tmp21_;
#line 129 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	g_settings_set_boolean (_tmp20_, "show-zeroes", _tmp22_);
#line 130 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp23_ = self->priv->settings;
#line 130 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp24_ = math_equation_get_number_format (equation);
#line 130 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp25_ = _tmp24_;
#line 130 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	g_settings_set_enum (_tmp23_, "number-format", (gint) _tmp25_);
#line 131 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp26_ = self->priv->settings;
#line 131 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp27_ = math_equation_get_angle_units (equation);
#line 131 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp28_ = _tmp27_;
#line 131 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	g_settings_set_enum (_tmp26_, "angle-units", (gint) _tmp28_);
#line 132 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp29_ = self->priv->settings;
#line 132 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp30_ = math_equation_get_source_currency (equation);
#line 132 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp31_ = _tmp30_;
#line 132 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp32_ = _tmp31_;
#line 132 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	g_settings_set_string (_tmp29_, "source-currency", _tmp32_);
#line 132 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_g_free0 (_tmp32_);
#line 133 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp33_ = self->priv->settings;
#line 133 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp34_ = math_equation_get_target_currency (equation);
#line 133 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp35_ = _tmp34_;
#line 133 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp36_ = _tmp35_;
#line 133 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	g_settings_set_string (_tmp33_, "target-currency", _tmp36_);
#line 133 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_g_free0 (_tmp36_);
#line 134 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp37_ = self->priv->settings;
#line 134 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp38_ = math_equation_get_source_units (equation);
#line 134 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp39_ = _tmp38_;
#line 134 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp40_ = _tmp39_;
#line 134 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	g_settings_set_string (_tmp37_, "source-units", _tmp40_);
#line 134 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_g_free0 (_tmp40_);
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp41_ = self->priv->settings;
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp42_ = math_equation_get_target_units (equation);
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp43_ = _tmp42_;
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp44_ = _tmp43_;
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	g_settings_set_string (_tmp41_, "target-units", _tmp44_);
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_g_free0 (_tmp44_);
#line 136 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp45_ = self->priv->settings;
#line 136 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp46_ = math_buttons_get_programming_base (buttons);
#line 136 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp47_ = _tmp46_;
#line 136 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	g_settings_set_int (_tmp45_, "base", _tmp47_);
#line 118 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_g_object_unref0 (buttons);
#line 118 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_g_object_unref0 (equation);
#line 1128 "gnome-calculator.c"
}


static gchar* _variant_get1 (GVariant* value) {
#line 150 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	return g_variant_dup_string (value, NULL);
#line 1135 "gnome-calculator.c"
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
#line 1282 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1282 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1282 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 1148 "gnome-calculator.c"
	{
		GRegex* regex = NULL;
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GRegex* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
#line 1284 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp0_ = old;
#line 1284 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
#line 1284 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp2_ = _tmp1_;
#line 1284 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
#line 1284 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp4_ = _tmp3_;
#line 1284 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_g_free0 (_tmp2_);
#line 1284 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		regex = _tmp4_;
#line 1284 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1284 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 1179 "gnome-calculator.c"
				goto __catch1_g_regex_error;
			}
#line 1284 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1284 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1284 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			return NULL;
#line 1188 "gnome-calculator.c"
		}
#line 1285 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp6_ = regex;
#line 1285 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp7_ = replacement;
#line 1285 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp8_ = g_regex_replace_literal (_tmp6_, self, (gssize) (-1), 0, _tmp7_, 0, &_inner_error_);
#line 1285 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp5_ = _tmp8_;
#line 1285 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1285 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1285 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 1204 "gnome-calculator.c"
				goto __catch1_g_regex_error;
			}
#line 1285 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1285 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1285 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1285 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			return NULL;
#line 1215 "gnome-calculator.c"
		}
#line 1285 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp9_ = _tmp5_;
#line 1285 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp5_ = NULL;
#line 1285 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		result = _tmp9_;
#line 1285 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_g_free0 (_tmp5_);
#line 1285 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_g_regex_unref0 (regex);
#line 1285 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		return result;
#line 1229 "gnome-calculator.c"
	}
	goto __finally1;
	__catch1_g_regex_error:
	{
		GError* e = NULL;
#line 1283 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		e = _inner_error_;
#line 1283 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_inner_error_ = NULL;
#line 1287 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		g_assert_not_reached ();
#line 1283 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_g_error_free0 (e);
#line 1243 "gnome-calculator.c"
	}
	__finally1:
#line 1283 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1283 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1283 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		g_clear_error (&_inner_error_);
#line 1283 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		return NULL;
#line 1254 "gnome-calculator.c"
	}
}


static gint calculator_real_handle_local_options (GApplication* base, GVariantDict* options) {
	Calculator * self;
	gint result = 0;
	GVariantDict* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GVariantDict* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
#line 139 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	self = (Calculator*) base;
#line 139 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	g_return_val_if_fail (options != NULL, 0);
#line 141 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp0_ = options;
#line 141 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp1_ = g_variant_dict_contains (_tmp0_, "version");
#line 141 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	if (_tmp1_) {
#line 1276 "gnome-calculator.c"
		FILE* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
#line 144 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		_tmp2_ = stderr;
#line 144 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		_tmp3_ = calculator_program_name;
#line 144 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		fprintf (_tmp2_, "%1$s %2$s\n", _tmp3_, VERSION);
#line 145 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		result = EXIT_SUCCESS;
#line 145 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		return result;
#line 1289 "gnome-calculator.c"
	}
#line 148 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp4_ = options;
#line 148 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp5_ = g_variant_dict_contains (_tmp4_, "solve");
#line 148 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	if (_tmp5_) {
#line 1297 "gnome-calculator.c"
		gchar* solve_equation = NULL;
		GVariantDict* _tmp6_ = NULL;
		const GVariantType* _tmp7_ = NULL;
		GVariant* _tmp8_ = NULL;
		GVariant* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		gchar* tsep_string = NULL;
		const gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		gboolean _tmp14_ = FALSE;
		const gchar* _tmp15_ = NULL;
		gchar* decimal = NULL;
		const gchar* _tmp18_ = NULL;
		gchar* _tmp19_ = NULL;
		const gchar* _tmp20_ = NULL;
		SolveEquation* e = NULL;
		const gchar* _tmp22_ = NULL;
		const gchar* _tmp23_ = NULL;
		gchar* _tmp24_ = NULL;
		gchar* _tmp25_ = NULL;
		const gchar* _tmp26_ = NULL;
		gchar* _tmp27_ = NULL;
		gchar* _tmp28_ = NULL;
		SolveEquation* _tmp29_ = NULL;
		SolveEquation* _tmp30_ = NULL;
		SolveEquation* _tmp31_ = NULL;
		SolveEquation* _tmp32_ = NULL;
		SolveEquation* _tmp33_ = NULL;
		ErrorCode _error_ = 0;
		guint representation_base = 0U;
		Number* _result_ = NULL;
		SolveEquation* _tmp34_ = NULL;
		guint _tmp35_ = 0U;
		ErrorCode _tmp36_ = 0;
		Number* _tmp37_ = NULL;
		Number* _tmp38_ = NULL;
#line 150 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		_tmp6_ = options;
#line 150 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		_tmp7_ = G_VARIANT_TYPE_STRING;
#line 150 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		_tmp8_ = g_variant_dict_lookup_value (_tmp6_, "solve", _tmp7_);
#line 150 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		_tmp9_ = _tmp8_;
#line 150 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		_tmp10_ = _variant_get1 (_tmp9_);
#line 150 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		_tmp11_ = _tmp10_;
#line 150 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		_g_variant_unref0 (_tmp9_);
#line 150 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		solve_equation = _tmp11_;
#line 151 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		_tmp12_ = nl_langinfo (THOUSEP);
#line 151 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		_tmp13_ = g_strdup (_tmp12_);
#line 151 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		tsep_string = _tmp13_;
#line 152 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		_tmp15_ = tsep_string;
#line 152 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		if (_tmp15_ == NULL) {
#line 152 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
			_tmp14_ = TRUE;
#line 1363 "gnome-calculator.c"
		} else {
			const gchar* _tmp16_ = NULL;
#line 152 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
			_tmp16_ = tsep_string;
#line 152 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
			_tmp14_ = g_strcmp0 (_tmp16_, "") == 0;
#line 1370 "gnome-calculator.c"
		}
#line 152 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		if (_tmp14_) {
#line 1374 "gnome-calculator.c"
			gchar* _tmp17_ = NULL;
#line 153 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
			_tmp17_ = g_strdup (" ");
#line 153 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
			_g_free0 (tsep_string);
#line 153 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
			tsep_string = _tmp17_;
#line 1382 "gnome-calculator.c"
		}
#line 155 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		_tmp18_ = nl_langinfo (RADIXCHAR);
#line 155 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		_tmp19_ = g_strdup (_tmp18_);
#line 155 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		decimal = _tmp19_;
#line 156 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		_tmp20_ = decimal;
#line 156 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		if (_tmp20_ == NULL) {
#line 1394 "gnome-calculator.c"
			gchar* _tmp21_ = NULL;
#line 157 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
			_tmp21_ = g_strdup ("");
#line 157 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
			_g_free0 (decimal);
#line 157 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
			decimal = _tmp21_;
#line 1402 "gnome-calculator.c"
		}
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		_tmp22_ = solve_equation;
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		_tmp23_ = tsep_string;
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		_tmp24_ = string_replace (_tmp22_, _tmp23_, "");
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		_tmp25_ = _tmp24_;
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		_tmp26_ = decimal;
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		_tmp27_ = string_replace (_tmp25_, _tmp26_, ".");
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		_tmp28_ = _tmp27_;
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		_tmp29_ = solve_equation_new (_tmp28_);
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		_tmp30_ = _tmp29_;
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		_g_free0 (_tmp28_);
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		_g_free0 (_tmp25_);
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		e = _tmp30_;
#line 160 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		_tmp31_ = e;
#line 160 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		((Equation*) _tmp31_)->base = 10;
#line 161 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		_tmp32_ = e;
#line 161 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		((Equation*) _tmp32_)->wordlen = 32;
#line 162 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		_tmp33_ = e;
#line 162 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		((Equation*) _tmp33_)->angle_units = ANGLE_UNIT_DEGREES;
#line 166 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		_tmp34_ = e;
#line 166 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		_tmp37_ = equation_parse ((Equation*) _tmp34_, &_tmp35_, &_tmp36_, NULL, NULL, NULL);
#line 166 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		representation_base = _tmp35_;
#line 166 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		_error_ = _tmp36_;
#line 166 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		_result_ = _tmp37_;
#line 167 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		_tmp38_ = _result_;
#line 167 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		if (_tmp38_ != NULL) {
#line 1454 "gnome-calculator.c"
			Serializer* serializer = NULL;
			Serializer* _tmp39_ = NULL;
			Serializer* _tmp40_ = NULL;
			guint _tmp41_ = 0U;
			FILE* _tmp42_ = NULL;
			Serializer* _tmp43_ = NULL;
			Number* _tmp44_ = NULL;
			gchar* _tmp45_ = NULL;
			gchar* _tmp46_ = NULL;
#line 169 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
			_tmp39_ = serializer_new (DISPLAY_FORMAT_AUTOMATIC, 10, 9);
#line 169 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
			serializer = _tmp39_;
#line 170 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
			_tmp40_ = serializer;
#line 170 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
			_tmp41_ = representation_base;
#line 170 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
			serializer_set_representation_base (_tmp40_, _tmp41_);
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
			_tmp42_ = stdout;
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
			_tmp43_ = serializer;
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
			_tmp44_ = _result_;
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
			_tmp45_ = serializer_to_string (_tmp43_, _tmp44_);
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
			_tmp46_ = _tmp45_;
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
			fprintf (_tmp42_, "%s\n", _tmp46_);
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
			_g_free0 (_tmp46_);
#line 172 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
			result = EXIT_SUCCESS;
#line 172 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
			_g_object_unref0 (serializer);
#line 172 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
			_g_object_unref0 (_result_);
#line 172 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
			_g_object_unref0 (e);
#line 172 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
			_g_free0 (decimal);
#line 172 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
			_g_free0 (tsep_string);
#line 172 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
			_g_free0 (solve_equation);
#line 172 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
			return result;
#line 1504 "gnome-calculator.c"
		} else {
			ErrorCode _tmp47_ = 0;
#line 174 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
			_tmp47_ = _error_;
#line 174 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
			if (_tmp47_ == ERROR_CODE_MP) {
#line 1511 "gnome-calculator.c"
				FILE* _tmp48_ = NULL;
				const gchar* _tmp49_ = NULL;
				const gchar* _tmp50_ = NULL;
#line 176 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
				_tmp48_ = stderr;
#line 176 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
				_tmp49_ = number_get_error ();
#line 176 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
				_tmp50_ = _tmp49_;
#line 176 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
				fprintf (_tmp48_, "Error: %s\n", _tmp50_);
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
				result = EXIT_FAILURE;
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
				_g_object_unref0 (_result_);
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
				_g_object_unref0 (e);
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
				_g_free0 (decimal);
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
				_g_free0 (tsep_string);
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
				_g_free0 (solve_equation);
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
				return result;
#line 1537 "gnome-calculator.c"
			} else {
				FILE* _tmp51_ = NULL;
				ErrorCode _tmp52_ = 0;
				gchar* _tmp53_ = NULL;
				gchar* _tmp54_ = NULL;
#line 181 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
				_tmp51_ = stderr;
#line 181 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
				_tmp52_ = _error_;
#line 181 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
				_tmp53_ = mp_error_code_to_string (_tmp52_);
#line 181 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
				_tmp54_ = _tmp53_;
#line 181 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
				fprintf (_tmp51_, "Error: %s\n", _tmp54_);
#line 181 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
				_g_free0 (_tmp54_);
#line 182 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
				result = EXIT_FAILURE;
#line 182 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
				_g_object_unref0 (_result_);
#line 182 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
				_g_object_unref0 (e);
#line 182 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
				_g_free0 (decimal);
#line 182 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
				_g_free0 (tsep_string);
#line 182 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
				_g_free0 (solve_equation);
#line 182 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
				return result;
#line 1569 "gnome-calculator.c"
			}
		}
#line 148 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		_g_object_unref0 (_result_);
#line 148 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		_g_object_unref0 (e);
#line 148 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		_g_free0 (decimal);
#line 148 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		_g_free0 (tsep_string);
#line 148 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		_g_free0 (solve_equation);
#line 1582 "gnome-calculator.c"
	}
#line 186 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	result = -1;
#line 186 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	return result;
#line 1588 "gnome-calculator.c"
}


static void calculator_show_preferences_cb (Calculator* self) {
	MathPreferencesDialog* _tmp0_ = NULL;
	MathPreferencesDialog* _tmp7_ = NULL;
#line 189 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	g_return_if_fail (self != NULL);
#line 191 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp0_ = self->priv->preferences_dialog;
#line 191 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	if (_tmp0_ == NULL) {
#line 1601 "gnome-calculator.c"
		MathWindow* _tmp1_ = NULL;
		MathEquation* _tmp2_ = NULL;
		MathEquation* _tmp3_ = NULL;
		MathPreferencesDialog* _tmp4_ = NULL;
		MathPreferencesDialog* _tmp5_ = NULL;
		MathWindow* _tmp6_ = NULL;
#line 193 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		_tmp1_ = self->priv->window;
#line 193 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		_tmp2_ = math_window_get_equation (_tmp1_);
#line 193 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		_tmp3_ = _tmp2_;
#line 193 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		_tmp4_ = math_preferences_dialog_new (_tmp3_);
#line 193 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		g_object_ref_sink (_tmp4_);
#line 193 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		_g_object_unref0 (self->priv->preferences_dialog);
#line 193 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		self->priv->preferences_dialog = _tmp4_;
#line 194 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		_tmp5_ = self->priv->preferences_dialog;
#line 194 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		_tmp6_ = self->priv->window;
#line 194 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		gtk_window_set_transient_for ((GtkWindow*) _tmp5_, (GtkWindow*) _tmp6_);
#line 1628 "gnome-calculator.c"
	}
#line 196 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp7_ = self->priv->preferences_dialog;
#line 196 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	gtk_window_present ((GtkWindow*) _tmp7_);
#line 1634 "gnome-calculator.c"
}


static void calculator_help_cb (Calculator* self) {
	GError * _inner_error_ = NULL;
#line 199 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	g_return_if_fail (self != NULL);
#line 1642 "gnome-calculator.c"
	{
		MathWindow* _tmp0_ = NULL;
		GdkScreen* _tmp1_ = NULL;
		guint32 _tmp2_ = 0U;
#line 203 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		_tmp0_ = self->priv->window;
#line 203 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		_tmp1_ = gtk_window_get_screen ((GtkWindow*) _tmp0_);
#line 203 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		_tmp2_ = gtk_get_current_event_time ();
#line 203 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		gtk_show_uri (_tmp1_, "help:gnome-calculator", _tmp2_, &_inner_error_);
#line 203 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1657 "gnome-calculator.c"
			goto __catch2_g_error;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		gchar* message = NULL;
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		GtkMessageDialog* d = NULL;
		MathWindow* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		GtkMessageDialog* _tmp7_ = NULL;
		GtkMessageDialog* _tmp8_ = NULL;
		GError* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		GtkMessageDialog* _tmp11_ = NULL;
		GtkMessageDialog* _tmp12_ = NULL;
#line 201 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		e = _inner_error_;
#line 201 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		_inner_error_ = NULL;
#line 208 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		_tmp3_ = _ ("Unable to open help file");
#line 208 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		_tmp4_ = g_strdup (_tmp3_);
#line 208 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		message = _tmp4_;
#line 210 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		_tmp5_ = self->priv->window;
#line 210 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		_tmp6_ = message;
#line 210 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		_tmp7_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _tmp5_, GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, "%s", _tmp6_);
#line 210 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		g_object_ref_sink (_tmp7_);
#line 210 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		d = _tmp7_;
#line 215 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		_tmp8_ = d;
#line 215 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		_tmp9_ = e;
#line 215 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		_tmp10_ = _tmp9_->message;
#line 215 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		gtk_message_dialog_format_secondary_text (_tmp8_, "%s", _tmp10_);
#line 216 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		_tmp11_ = d;
#line 216 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		gtk_dialog_run ((GtkDialog*) _tmp11_);
#line 217 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		_tmp12_ = d;
#line 217 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		gtk_widget_destroy ((GtkWidget*) _tmp12_);
#line 201 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		_g_object_unref0 (d);
#line 201 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		_g_free0 (message);
#line 201 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		_g_error_free0 (e);
#line 1719 "gnome-calculator.c"
	}
	__finally2:
#line 201 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 201 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 201 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		g_clear_error (&_inner_error_);
#line 201 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
		return;
#line 1730 "gnome-calculator.c"
	}
}


static void calculator_about_cb (Calculator* self) {
	gchar** authors = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar** _tmp4_ = NULL;
	gint authors_length1 = 0;
	gint _authors_size_ = 0;
	gchar** documenters = NULL;
	gchar* _tmp5_ = NULL;
	gchar** _tmp6_ = NULL;
	gint documenters_length1 = 0;
	gint _documenters_size_ = 0;
	gchar* translator_credits = NULL;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	MathWindow* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
#line 221 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	g_return_if_fail (self != NULL);
#line 223 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp0_ = g_strdup ("Rich Burridge <rich.burridge@gmail.com>");
#line 223 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp1_ = g_strdup ("Robert Ancell <robert.ancell@gmail.com>");
#line 223 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp2_ = g_strdup ("Klaus Niederkrüger <kniederk@umpa.ens-lyon.fr>");
#line 223 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp3_ = g_strdup ("Robin Sonefors <ozamosi@flukkost.nu>");
#line 223 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp4_ = g_new0 (gchar*, 5 + 1);
#line 223 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp4_[0] = _tmp0_;
#line 223 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp4_[1] = _tmp1_;
#line 223 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp4_[2] = _tmp2_;
#line 223 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp4_[3] = _tmp3_;
#line 223 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp4_[4] = NULL;
#line 223 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	authors = _tmp4_;
#line 223 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	authors_length1 = 5;
#line 223 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_authors_size_ = authors_length1;
#line 231 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp5_ = g_strdup ("Sun Microsystems");
#line 231 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp6_ = g_new0 (gchar*, 2 + 1);
#line 231 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp6_[0] = _tmp5_;
#line 231 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp6_[1] = NULL;
#line 231 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	documenters = _tmp6_;
#line 231 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	documenters_length1 = 2;
#line 231 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_documenters_size_ = documenters_length1;
#line 238 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp7_ = _ ("translator-credits");
#line 238 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp8_ = g_strdup (_tmp7_);
#line 238 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	translator_credits = _tmp8_;
#line 240 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp9_ = self->priv->window;
#line 240 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp10_ = _ ("Calculator");
#line 240 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp11_ = _ ("About Calculator");
#line 240 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp12_ = _ ("Calculator with financial and scientific modes.");
#line 240 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	gtk_show_about_dialog ((GtkWindow*) _tmp9_, "program-name", _tmp10_, "title", _tmp11_, "version", VERSION, "copyright", "\xc2\xa9 1986–2014 The Calculator authors", "license-type", GTK_LICENSE_GPL_3_0, "comments", _tmp12_, "authors", authors, "documenters", documenters, "translator_credits", translator_credits, "logo-icon-name", "accessories-calculator", NULL);
#line 221 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_g_free0 (translator_credits);
#line 221 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	documenters = (_vala_array_free (documenters, documenters_length1, (GDestroyNotify) g_free), NULL);
#line 221 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	authors = (_vala_array_free (authors, authors_length1, (GDestroyNotify) g_free), NULL);
#line 1820 "gnome-calculator.c"
}


static void calculator_quit_cb (Calculator* self) {
	MathWindow* _tmp0_ = NULL;
#line 259 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	g_return_if_fail (self != NULL);
#line 261 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp0_ = self->priv->window;
#line 261 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp0_);
#line 1832 "gnome-calculator.c"
}


gint calculator_main (gchar** args, int args_length1) {
	gint result = 0;
	GDateTime* now = NULL;
	GDateTime* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gchar** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	Calculator* app = NULL;
	Calculator* _tmp5_ = NULL;
	gchar** _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
	gint _tmp7_ = 0;
#line 266 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	setlocale (LC_ALL, "");
#line 267 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	bindtextdomain (GETTEXT_PACKAGE, LOCALE_DIR);
#line 268 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
#line 269 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	textdomain (GETTEXT_PACKAGE);
#line 272 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp0_ = g_date_time_new_now_utc ();
#line 272 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	now = _tmp0_;
#line 273 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp1_ = g_date_time_get_microsecond (now);
#line 273 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	g_random_set_seed ((guint32) _tmp1_);
#line 275 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp2_ = args;
#line 275 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp2__length1 = args_length1;
#line 275 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp3_ = _tmp2_[0];
#line 275 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp4_ = g_path_get_basename (_tmp3_);
#line 275 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_g_free0 (calculator_program_name);
#line 275 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	calculator_program_name = _tmp4_;
#line 277 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	gtk_window_set_default_icon_name ("accessories-calculator");
#line 279 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp5_ = calculator_new ();
#line 279 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	app = _tmp5_;
#line 281 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp6_ = args;
#line 281 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp6__length1 = args_length1;
#line 281 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp7_ = g_application_run ((GApplication*) app, _tmp6__length1, _tmp6_);
#line 281 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	result = _tmp7_;
#line 281 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_g_object_unref0 (app);
#line 281 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_g_date_time_unref0 (now);
#line 281 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	return result;
#line 1898 "gnome-calculator.c"
}


int main (int argc, char ** argv) {
#if !GLIB_CHECK_VERSION (2,35,0)
	g_type_init ();
#endif
#line 264 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	return calculator_main (argv, argc);
#line 1908 "gnome-calculator.c"
}


static void calculator_class_init (CalculatorClass * klass) {
#line 12 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	calculator_parent_class = g_type_class_peek_parent (klass);
#line 12 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	g_type_class_add_private (klass, sizeof (CalculatorPrivate));
#line 12 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	((GApplicationClass *) klass)->startup = calculator_real_startup;
#line 12 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	((GApplicationClass *) klass)->activate = calculator_real_activate;
#line 12 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	((GApplicationClass *) klass)->shutdown = calculator_real_shutdown;
#line 12 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	((GApplicationClass *) klass)->handle_local_options = calculator_real_handle_local_options;
#line 12 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	G_OBJECT_CLASS (klass)->finalize = calculator_finalize;
#line 1927 "gnome-calculator.c"
}


static void calculator_instance_init (Calculator * self) {
#line 12 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	self->priv = CALCULATOR_GET_PRIVATE (self);
#line 1934 "gnome-calculator.c"
}


static void calculator_finalize (GObject* obj) {
	Calculator * self;
#line 12 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CALCULATOR, Calculator);
#line 14 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_g_object_unref0 (self->priv->settings);
#line 15 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_g_object_unref0 (self->priv->window);
#line 16 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_g_object_unref0 (self->priv->preferences_dialog);
#line 12 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	G_OBJECT_CLASS (calculator_parent_class)->finalize (obj);
#line 1950 "gnome-calculator.c"
}


GType calculator_get_type (void) {
	static volatile gsize calculator_type_id__volatile = 0;
	if (g_once_init_enter (&calculator_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CalculatorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) calculator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Calculator), 0, (GInstanceInitFunc) calculator_instance_init, NULL };
		GType calculator_type_id;
		calculator_type_id = g_type_register_static (gtk_application_get_type (), "Calculator", &g_define_type_info, 0);
		g_once_init_leave (&calculator_type_id__volatile, calculator_type_id);
	}
	return calculator_type_id__volatile;
}


SolveEquation* solve_equation_construct (GType object_type, const gchar* text) {
	SolveEquation * self = NULL;
	const gchar* _tmp0_ = NULL;
#line 287 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	g_return_val_if_fail (text != NULL, NULL);
#line 289 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp0_ = text;
#line 289 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	self = (SolveEquation*) equation_construct (object_type, _tmp0_);
#line 287 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	return self;
#line 1977 "gnome-calculator.c"
}


SolveEquation* solve_equation_new (const gchar* text) {
#line 287 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	return solve_equation_construct (TYPE_SOLVE_EQUATION, text);
#line 1984 "gnome-calculator.c"
}


static Number* solve_equation_real_convert (Equation* base, Number* x, const gchar* x_units, const gchar* z_units) {
	SolveEquation * self;
	Number* result = NULL;
	UnitManager* _tmp0_ = NULL;
	UnitManager* _tmp1_ = NULL;
	Number* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	Number* _tmp5_ = NULL;
	Number* _tmp6_ = NULL;
#line 292 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	self = (SolveEquation*) base;
#line 292 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	g_return_val_if_fail (x != NULL, NULL);
#line 292 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	g_return_val_if_fail (x_units != NULL, NULL);
#line 292 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	g_return_val_if_fail (z_units != NULL, NULL);
#line 294 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp0_ = unit_manager_get_default ();
#line 294 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp1_ = _tmp0_;
#line 294 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp2_ = x;
#line 294 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp3_ = x_units;
#line 294 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp4_ = z_units;
#line 294 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp5_ = unit_manager_convert_by_symbol (_tmp1_, _tmp2_, _tmp3_, _tmp4_);
#line 294 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_tmp6_ = _tmp5_;
#line 294 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	_g_object_unref0 (_tmp1_);
#line 294 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	result = _tmp6_;
#line 294 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	return result;
#line 2026 "gnome-calculator.c"
}


static void solve_equation_class_init (SolveEquationClass * klass) {
#line 285 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	solve_equation_parent_class = g_type_class_peek_parent (klass);
#line 285 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/gnome-calculator.vala"
	((EquationClass *) klass)->convert = solve_equation_real_convert;
#line 2035 "gnome-calculator.c"
}


static void solve_equation_instance_init (SolveEquation * self) {
}


GType solve_equation_get_type (void) {
	static volatile gsize solve_equation_type_id__volatile = 0;
	if (g_once_init_enter (&solve_equation_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SolveEquationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) solve_equation_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SolveEquation), 0, (GInstanceInitFunc) solve_equation_instance_init, NULL };
		GType solve_equation_type_id;
		solve_equation_type_id = g_type_register_static (TYPE_EQUATION, "SolveEquation", &g_define_type_info, 0);
		g_once_init_leave (&solve_equation_type_id__volatile, solve_equation_type_id);
	}
	return solve_equation_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



