/* search-view.c generated by valac 0.27.1.7-1a9de, the Vala compiler
 * generated from search-view.vala, do not modify */

/*
 * Copyright (C) 2011, 2015 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: Travis Reitter <travis.reitter@collabora.co.uk>
 *          Philip Withnall <philip.withnall@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <dummy-test.h>
#include <stdlib.h>
#include <string.h>
#include <folks-test.h>
#include <folks/folks-dummy.h>
#include <gee.h>
#include <folks/folks.h>
#include <gio/gio.h>


#define TYPE_SEARCH_VIEW_TESTS (search_view_tests_get_type ())
#define SEARCH_VIEW_TESTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SEARCH_VIEW_TESTS, SearchViewTests))
#define SEARCH_VIEW_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SEARCH_VIEW_TESTS, SearchViewTestsClass))
#define IS_SEARCH_VIEW_TESTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SEARCH_VIEW_TESTS))
#define IS_SEARCH_VIEW_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SEARCH_VIEW_TESTS))
#define SEARCH_VIEW_TESTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SEARCH_VIEW_TESTS, SearchViewTestsClass))

typedef struct _SearchViewTests SearchViewTests;
typedef struct _SearchViewTestsClass SearchViewTestsClass;
typedef struct _SearchViewTestsPrivate SearchViewTestsPrivate;

#define SEARCH_VIEW_TESTS_TYPE_SIMPLE_TEST_VECTOR (search_view_tests_simple_test_vector_get_type ())
typedef struct _SearchViewTestsSimpleTestVector SearchViewTestsSimpleTestVector;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block2Data Block2Data;
typedef struct _Block3Data Block3Data;
typedef struct _Block4Data Block4Data;
typedef struct _Block5Data Block5Data;
typedef struct _Block6Data Block6Data;
typedef struct _SearchViewTestsChangeUserNamesData SearchViewTestsChangeUserNamesData;
typedef struct _Block7Data Block7Data;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _SearchViewTests {
	DummyTestTestCase parent_instance;
	SearchViewTestsPrivate * priv;
};

struct _SearchViewTestsClass {
	DummyTestTestCaseClass parent_class;
};

struct _SearchViewTestsSimpleTestVector {
	const gchar* query;
	const gchar* expected_individuals;
};

struct _Block1Data {
	int _ref_count_;
	SearchViewTests* self;
	GMainLoop* main_loop;
	FolksSearchView* search_view;
};

struct _Block2Data {
	int _ref_count_;
	SearchViewTests* self;
	GMainLoop* main_loop;
	GeeHashSet* expected_matches;
	GeeHashSet* expected_non_matches;
	GeeHashSet* unexpected_matches;
	FolksBackendStore* store;
	FolksSearchView* search_view;
};

struct _Block3Data {
	int _ref_count_;
	SearchViewTests* self;
	GMainLoop* main_loop;
	FolksBackendStore* backend_store;
	FolksIndividualAggregator* aggregator;
};

typedef void (*SearchViewTestsGeneratePersonaFunc) (FolksDummyFullPersona* persona, void* user_data);
struct _Block4Data {
	int _ref_count_;
	SearchViewTests* self;
	GeeHashSet* expected_matches;
	GeeHashSet* expected_non_matches;
	GeeHashSet* unexpected_matches;
	FolksSearchView* search_view;
	GMainLoop* main_loop;
};

struct _Block5Data {
	int _ref_count_;
	SearchViewTests* self;
	GMainLoop* main_loop;
	FolksBackendStore* backend_store;
};

struct _Block6Data {
	int _ref_count_;
	SearchViewTests* self;
	GMainLoop* main_loop;
	FolksBackendStore* backend_store;
};

struct _SearchViewTestsChangeUserNamesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SearchViewTests* self;
	gchar* expected_full_name;
	FolksStructuredName* non_matching_structured_name;
	FolksIndividualAggregator* aggregator;
	gchar* non_matching_full_name;
	FolksStructuredName* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	FolksStructuredName* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	FolksStructuredName* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	GeeIterator* _individual_it;
	FolksIndividualAggregator* _tmp10_;
	GeeMap* _tmp11_;
	GeeMap* _tmp12_;
	GeeCollection* _tmp13_;
	GeeCollection* _tmp14_;
	GeeCollection* _tmp15_;
	GeeIterator* _tmp16_;
	GeeIterator* _tmp17_;
	GeeIterator* _tmp18_;
	gboolean _tmp19_;
	FolksIndividual* individual;
	GeeIterator* _tmp20_;
	gpointer _tmp21_;
	FolksIndividual* _tmp22_;
	const gchar* _tmp23_;
	const gchar* _tmp24_;
	const gchar* _tmp25_;
	GeeIterator* _persona_it;
	FolksIndividual* _tmp26_;
	GeeSet* _tmp27_;
	GeeSet* _tmp28_;
	GeeIterator* _tmp29_;
	GeeIterator* _tmp30_;
	gboolean _tmp31_;
	FolksPersona* persona;
	GeeIterator* _tmp32_;
	gpointer _tmp33_;
	FolksNameDetails* name_details;
	FolksPersona* _tmp34_;
	FolksNameDetails* _tmp35_;
	FolksNameDetails* _tmp36_;
	FolksNameDetails* _tmp37_;
	const gchar* _tmp38_;
	FolksNameDetails* _tmp39_;
	FolksStructuredName* _tmp40_;
	GError* e;
	const gchar* _tmp41_;
	GError * _inner_error_;
};

struct _Block7Data {
	int _ref_count_;
	SearchViewTests* self;
	GMainLoop* main_loop;
	GeeHashSet* expected_matches;
	GeeHashSet* expected_non_matches;
	GeeHashSet* unexpected_matches;
	gboolean is_prepared;
	FolksSearchView* search_view;
};


static gpointer search_view_tests_parent_class = NULL;

GType search_view_tests_get_type (void) G_GNUC_CONST;
enum  {
	SEARCH_VIEW_TESTS_DUMMY_PROPERTY
};
#define SEARCH_VIEW_TESTS__FULL_NAME "Sterling Mallory Archer"
#define SEARCH_VIEW_TESTS__FULL_NAME_TOKEN "Archer"
#define SEARCH_VIEW_TESTS__FULL_NAME_TOKEN_LC "archer"
#define SEARCH_VIEW_TESTS__FULL_NAME_SUBTOKEN "cher"
#define SEARCH_VIEW_TESTS__FULL_NAME_PREFIX "arch"
#define SEARCH_VIEW_TESTS__NON_MATCHING_PARTIAL_NAME "Stimpson"
#define SEARCH_VIEW_TESTS__PHONE_NUMBER "+1-800-867-5309"
#define SEARCH_VIEW_TESTS__EQUIVALENT_PHONE_NUMBER "867-5309"
SearchViewTests* search_view_tests_new (void);
SearchViewTests* search_view_tests_construct (GType object_type);
void search_view_tests_test_simple_search_results (SearchViewTests* self);
static void _search_view_tests_test_simple_search_results_folks_test_case_test_method (gpointer self);
void search_view_tests_test_search_before_after (SearchViewTests* self);
static void _search_view_tests_test_search_before_after_folks_test_case_test_method (gpointer self);
void search_view_tests_test_match_each_field (SearchViewTests* self);
static void _search_view_tests_test_match_each_field_folks_test_case_test_method (gpointer self);
void search_view_tests_test_individual_changes (SearchViewTests* self);
static void _search_view_tests_test_individual_changes_folks_test_case_test_method (gpointer self);
void search_view_tests_test_query_changes (SearchViewTests* self);
static void _search_view_tests_test_query_changes_folks_test_case_test_method (gpointer self);
static void search_view_tests_real_configure_primary_store (DummyTestTestCase* base);
static GType search_view_tests_simple_test_vector_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static SearchViewTestsSimpleTestVector* search_view_tests_simple_test_vector_dup (const SearchViewTestsSimpleTestVector* self);
static void search_view_tests_simple_test_vector_free (SearchViewTestsSimpleTestVector* self);
static FolksDummyFullPersona* _search_view_tests_generate_main_persona (SearchViewTests* self);
static void _search_view_tests_test_simple_search_results_single (SearchViewTests* self, FolksIndividualAggregator* aggregator, const gchar* query, gchar** expected_individuals, int expected_individuals_length1);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static const gchar** _vala_array_dup1 (const gchar** self, int length);
static void _vala_array_add1 (const gchar*** array, int* length, int* size, const gchar* value);
static void __lambda4_ (Block1Data* _data1_, GObject* s, GAsyncResult* r);
static void ___lambda4__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void __lambda5_ (Block1Data* _data1_, GObject* s, GAsyncResult* r);
static void ___lambda5__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void __lambda6_ (Block1Data* _data1_, GObject* s, GAsyncResult* r);
static void ___lambda6__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void __lambda7_ (Block2Data* _data2_, GObject* s, GAsyncResult* r);
static void ___lambda7__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static const gchar** _vala_array_dup2 (const gchar** self, int length);
static void _vala_array_add2 (const gchar*** array, int* length, int* size, const gchar* value);
static void __lambda8_ (Block2Data* _data2_, GeeSortedSet* added, GeeSortedSet* removed);
static void _search_view_tests_individuals_added (SearchViewTests* self, GeeCollection* added, GMainLoop* main_loop, GeeSet* expected_matches, GeeSet* expected_non_matches, GeeSet* unexpected_matches);
static void _search_view_tests_individuals_removed (SearchViewTests* self, GeeCollection* removed, GMainLoop* main_loop, GeeSet* expected_matches, GeeSet* expected_non_matches, GeeSet* unexpected_matches);
static void ___lambda8__folks_search_view_individuals_changed_detailed (FolksSearchView* _sender, GeeSortedSet* added, GeeSortedSet* removed, gpointer self);
static void __lambda9_ (Block2Data* _data2_, GObject* s, GAsyncResult* r);
static void ___lambda9__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static const gchar** _vala_array_dup3 (const gchar** self, int length);
static void _vala_array_add3 (const gchar*** array, int* length, int* size, const gchar* value);
static void _search_view_tests_test_search_with_view_async (SearchViewTests* self, const gchar* expected_match_display_id, const gchar* expected_non_match_display_id, FolksSearchView* search_view);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static FolksDummyFullPersona* _search_view_tests_generate_test_contact (SearchViewTests* self, const gchar* contact_id, SearchViewTestsGeneratePersonaFunc generate_persona, void* generate_persona_target);
static void __lambda12_ (SearchViewTests* self, FolksDummyFullPersona* p);
static void ___lambda12__search_view_tests_generate_persona_func (FolksDummyFullPersona* persona, gpointer self);
static void __lambda13_ (SearchViewTests* self, FolksDummyFullPersona* p);
static void ___lambda13__search_view_tests_generate_persona_func (FolksDummyFullPersona* persona, gpointer self);
static void __lambda14_ (SearchViewTests* self, FolksDummyFullPersona* p);
static void ___lambda14__search_view_tests_generate_persona_func (FolksDummyFullPersona* persona, gpointer self);
static void __lambda15_ (SearchViewTests* self, FolksDummyFullPersona* p);
static void ___lambda15__search_view_tests_generate_persona_func (FolksDummyFullPersona* persona, gpointer self);
static void __lambda16_ (SearchViewTests* self, FolksDummyFullPersona* p);
static void ___lambda16__search_view_tests_generate_persona_func (FolksDummyFullPersona* persona, gpointer self);
static void __lambda17_ (SearchViewTests* self, FolksDummyFullPersona* p);
static void ___lambda17__search_view_tests_generate_persona_func (FolksDummyFullPersona* persona, gpointer self);
static void __lambda18_ (SearchViewTests* self, FolksDummyFullPersona* p);
static void ___lambda18__search_view_tests_generate_persona_func (FolksDummyFullPersona* persona, gpointer self);
static void __lambda19_ (SearchViewTests* self, FolksDummyFullPersona* p);
static guint _folks_abstract_field_details_hash_static_gee_hash_data_func (gconstpointer v, gpointer self);
static gboolean _folks_abstract_field_details_equal_static_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self);
static void ___lambda19__search_view_tests_generate_persona_func (FolksDummyFullPersona* persona, gpointer self);
static void __lambda20_ (SearchViewTests* self, FolksDummyFullPersona* p);
static void ___lambda20__search_view_tests_generate_persona_func (FolksDummyFullPersona* persona, gpointer self);
static void __lambda21_ (SearchViewTests* self, FolksDummyFullPersona* p);
static void ___lambda21__search_view_tests_generate_persona_func (FolksDummyFullPersona* persona, gpointer self);
static void __lambda22_ (SearchViewTests* self, FolksDummyFullPersona* p);
static void ___lambda22__search_view_tests_generate_persona_func (FolksDummyFullPersona* persona, gpointer self);
static void __lambda23_ (SearchViewTests* self, FolksDummyFullPersona* p);
static void ___lambda23__search_view_tests_generate_persona_func (FolksDummyFullPersona* persona, gpointer self);
static void __lambda24_ (Block3Data* _data3_, GObject* s, GAsyncResult* r);
static void ___lambda24__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void __lambda25_ (Block3Data* _data3_, GObject* s, GAsyncResult* r);
static void ___lambda25__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void _search_view_tests_test_match_each_field_search_for_prop_name (SearchViewTests* self, GMainLoop* main_loop, FolksIndividualAggregator* aggregator, const gchar* prop_name, const gchar* query);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void __lambda26_ (Block4Data* _data4_, GeeSortedSet* added, GeeSortedSet* removed);
static void ___lambda26__folks_search_view_individuals_changed_detailed (FolksSearchView* _sender, GeeSortedSet* added, GeeSortedSet* removed, gpointer self);
static void __lambda27_ (Block4Data* _data4_, GObject* s, GAsyncResult* r);
static void ___lambda27__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static void __lambda28_ (Block5Data* _data5_, GObject* s, GAsyncResult* r);
static void ___lambda28__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void _search_view_tests_change_user_names (SearchViewTests* self, const gchar* expected_full_name, FolksStructuredName* non_matching_structured_name, FolksIndividualAggregator* aggregator, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void _search_view_tests_change_user_names_finish (SearchViewTests* self, GAsyncResult* _res_);
static void __lambda29_ (Block5Data* _data5_, GObject* s, GAsyncResult* r);
static void ___lambda29__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static void __lambda30_ (Block6Data* _data6_, GObject* s, GAsyncResult* r);
static void ___lambda30__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void _search_view_tests_change_user_names_data_free (gpointer _data);
static gboolean _search_view_tests_change_user_names_co (SearchViewTestsChangeUserNamesData* _data_);
static void _search_view_tests_change_user_names_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
static void __lambda10_ (Block7Data* _data7_, GeeSortedSet* added, GeeSortedSet* removed);
static void ___lambda10__folks_search_view_individuals_changed_detailed (FolksSearchView* _sender, GeeSortedSet* added, GeeSortedSet* removed, gpointer self);
static void __lambda11_ (Block7Data* _data7_, GObject* s, GAsyncResult* r);
static void ___lambda11__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
gint _vala_main (gchar** args, int args_length1);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static void _search_view_tests_test_simple_search_results_folks_test_case_test_method (gpointer self) {
#line 41 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	search_view_tests_test_simple_search_results ((SearchViewTests*) self);
#line 332 "search-view.c"
}


static void _search_view_tests_test_search_before_after_folks_test_case_test_method (gpointer self) {
#line 42 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	search_view_tests_test_search_before_after ((SearchViewTests*) self);
#line 339 "search-view.c"
}


static void _search_view_tests_test_match_each_field_folks_test_case_test_method (gpointer self) {
#line 43 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	search_view_tests_test_match_each_field ((SearchViewTests*) self);
#line 346 "search-view.c"
}


static void _search_view_tests_test_individual_changes_folks_test_case_test_method (gpointer self) {
#line 44 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	search_view_tests_test_individual_changes ((SearchViewTests*) self);
#line 353 "search-view.c"
}


static void _search_view_tests_test_query_changes_folks_test_case_test_method (gpointer self) {
#line 45 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	search_view_tests_test_query_changes ((SearchViewTests*) self);
#line 360 "search-view.c"
}


SearchViewTests* search_view_tests_construct (GType object_type) {
	SearchViewTests * self = NULL;
#line 39 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	self = (SearchViewTests*) dummy_test_test_case_construct (object_type, "SearchView");
#line 41 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	folks_test_case_add_test ((FolksTestCase*) self, "simple search results", _search_view_tests_test_simple_search_results_folks_test_case_test_method, self);
#line 42 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	folks_test_case_add_test ((FolksTestCase*) self, "search before and after", _search_view_tests_test_search_before_after_folks_test_case_test_method, self);
#line 43 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	folks_test_case_add_test ((FolksTestCase*) self, "match each type of field", _search_view_tests_test_match_each_field_folks_test_case_test_method, self);
#line 44 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	folks_test_case_add_test ((FolksTestCase*) self, "individual changes", _search_view_tests_test_individual_changes_folks_test_case_test_method, self);
#line 45 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	folks_test_case_add_test ((FolksTestCase*) self, "query changes", _search_view_tests_test_query_changes_folks_test_case_test_method, self);
#line 37 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	return self;
#line 380 "search-view.c"
}


SearchViewTests* search_view_tests_new (void) {
#line 37 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	return search_view_tests_construct (TYPE_SEARCH_VIEW_TESTS);
#line 387 "search-view.c"
}


static void search_view_tests_real_configure_primary_store (DummyTestTestCase* base) {
	SearchViewTests * self;
	FolksDummyPersonaStore* _tmp0_ = NULL;
#line 48 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	self = (SearchViewTests*) base;
#line 50 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	DUMMY_TEST_TEST_CASE_CLASS (search_view_tests_parent_class)->configure_primary_store (G_TYPE_CHECK_INSTANCE_CAST (self, DUMMY_TEST_TYPE_TEST_CASE, DummyTestTestCase));
#line 51 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp0_ = ((DummyTestTestCase*) self)->dummy_persona_store;
#line 51 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	folks_dummy_persona_store_reach_quiescence (_tmp0_);
#line 402 "search-view.c"
}


void search_view_tests_test_simple_search_results (SearchViewTests* self) {
#line 63 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	static const SearchViewTestsSimpleTestVector vectors[] = {{"Ali", "persona1"}, {"Ali Avo", "persona1"}, {"Arachnid", "persona2"}, {"unmatched", ""}, {"archer", "persona0"}, {"arch", "persona0"}, {"cher", ""}, {"867-5309", "persona0"}, {"+1-800-867-5309", "persona0"}, {"Al", "persona1,persona3"}, {"Ál", "persona3"}, {"Pan", "persona3"}, {"Pa\xf1", "persona3"}, {"Pa\x6e\x303", "persona3"}, {"A", "persona1,persona2,persona0,persona3"}, {"Al", "persona1,persona3"}, {"Ali", "persona1"}};
#line 409 "search-view.c"
	FolksDummyFullPersona* persona0 = NULL;
	FolksDummyFullPersona* _tmp0_ = NULL;
	FolksDummyFullPersona* persona1 = NULL;
	FolksDummyPersonaStore* _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	FolksDummyFullPersona* _tmp4_ = NULL;
	FolksDummyFullPersona* _tmp5_ = NULL;
	FolksDummyFullPersona* persona2 = NULL;
	FolksDummyPersonaStore* _tmp6_ = NULL;
	gchar** _tmp7_ = NULL;
	gchar** _tmp8_ = NULL;
	gint _tmp8__length1 = 0;
	FolksDummyFullPersona* _tmp9_ = NULL;
	FolksDummyFullPersona* _tmp10_ = NULL;
	FolksDummyFullPersona* persona3 = NULL;
	FolksDummyPersonaStore* _tmp11_ = NULL;
	gchar** _tmp12_ = NULL;
	gchar** _tmp13_ = NULL;
	gint _tmp13__length1 = 0;
	FolksDummyFullPersona* _tmp14_ = NULL;
	FolksDummyFullPersona* _tmp15_ = NULL;
	FolksDummyFullPersona* _tmp16_ = NULL;
	FolksDummyFullPersona* _tmp17_ = NULL;
	FolksDummyFullPersona* _tmp18_ = NULL;
	GeeHashSet* personas = NULL;
	GeeHashSet* _tmp19_ = NULL;
	GeeHashSet* _tmp20_ = NULL;
	FolksDummyFullPersona* _tmp21_ = NULL;
	GeeHashSet* _tmp22_ = NULL;
	FolksDummyFullPersona* _tmp23_ = NULL;
	GeeHashSet* _tmp24_ = NULL;
	FolksDummyFullPersona* _tmp25_ = NULL;
	GeeHashSet* _tmp26_ = NULL;
	FolksDummyFullPersona* _tmp27_ = NULL;
	FolksDummyPersonaStore* _tmp28_ = NULL;
	GeeHashSet* _tmp29_ = NULL;
	FolksIndividualAggregator* aggregator = NULL;
	FolksIndividualAggregator* _tmp30_ = NULL;
#line 60 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	g_return_if_fail (self != NULL);
#line 90 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp0_ = _search_view_tests_generate_main_persona (self);
#line 90 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	persona0 = _tmp0_;
#line 91 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp1_ = ((DummyTestTestCase*) self)->dummy_persona_store;
#line 91 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp2_ = g_new0 (gchar*, 0 + 1);
#line 91 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp3_ = _tmp2_;
#line 91 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp3__length1 = 0;
#line 91 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp4_ = folks_dummy_full_persona_new (_tmp1_, "persona1", FALSE, _tmp3_, 0);
#line 91 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp5_ = _tmp4_;
#line 91 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp3_ = (_vala_array_free (_tmp3_, _tmp3__length1, (GDestroyNotify) g_free), NULL);
#line 91 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	persona1 = _tmp5_;
#line 92 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp6_ = ((DummyTestTestCase*) self)->dummy_persona_store;
#line 92 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp7_ = g_new0 (gchar*, 0 + 1);
#line 92 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp8_ = _tmp7_;
#line 92 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp8__length1 = 0;
#line 92 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp9_ = folks_dummy_full_persona_new (_tmp6_, "persona2", FALSE, _tmp8_, 0);
#line 92 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp10_ = _tmp9_;
#line 92 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp8_ = (_vala_array_free (_tmp8_, _tmp8__length1, (GDestroyNotify) g_free), NULL);
#line 92 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	persona2 = _tmp10_;
#line 93 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp11_ = ((DummyTestTestCase*) self)->dummy_persona_store;
#line 93 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp12_ = g_new0 (gchar*, 0 + 1);
#line 93 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp13_ = _tmp12_;
#line 93 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp13__length1 = 0;
#line 93 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp14_ = folks_dummy_full_persona_new (_tmp11_, "persona3", FALSE, _tmp13_, 0);
#line 93 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp15_ = _tmp14_;
#line 93 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp13_ = (_vala_array_free (_tmp13_, _tmp13__length1, (GDestroyNotify) g_free), NULL);
#line 93 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	persona3 = _tmp15_;
#line 95 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp16_ = persona1;
#line 95 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	folks_dummy_full_persona_update_full_name (_tmp16_, "Alice Avogadro");
#line 96 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp17_ = persona2;
#line 96 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	folks_dummy_full_persona_update_full_name (_tmp17_, "Artemis Arachnid");
#line 97 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp18_ = persona3;
#line 97 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	folks_dummy_full_persona_update_full_name (_tmp18_, "Álvaro Pañuelo");
#line 99 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp19_ = gee_hash_set_new (FOLKS_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
#line 99 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	personas = _tmp19_;
#line 100 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp20_ = personas;
#line 100 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp21_ = persona0;
#line 100 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp20_, (FolksPersona*) _tmp21_);
#line 101 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp22_ = personas;
#line 101 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp23_ = persona1;
#line 101 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp22_, (FolksPersona*) _tmp23_);
#line 102 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp24_ = personas;
#line 102 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp25_ = persona2;
#line 102 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp24_, (FolksPersona*) _tmp25_);
#line 103 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp26_ = personas;
#line 103 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp27_ = persona3;
#line 103 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp26_, (FolksPersona*) _tmp27_);
#line 105 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp28_ = ((DummyTestTestCase*) self)->dummy_persona_store;
#line 105 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp29_ = personas;
#line 105 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	folks_dummy_persona_store_register_personas (_tmp28_, (GeeSet*) _tmp29_);
#line 108 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp30_ = folks_individual_aggregator_dup ();
#line 108 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	aggregator = _tmp30_;
#line 554 "search-view.c"
	{
		SearchViewTestsSimpleTestVector* vector_collection = NULL;
		gint vector_collection_length1 = 0;
		gint _vector_collection_size_ = 0;
		gint vector_it = 0;
#line 110 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		vector_collection = vectors;
#line 110 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		vector_collection_length1 = G_N_ELEMENTS (vectors);
#line 110 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		for (vector_it = 0; vector_it < G_N_ELEMENTS (vectors); vector_it = vector_it + 1) {
#line 566 "search-view.c"
			SearchViewTestsSimpleTestVector vector = {0};
#line 110 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
			vector = vector_collection[vector_it];
#line 570 "search-view.c"
			{
				gchar** inds = NULL;
				SearchViewTestsSimpleTestVector _tmp31_ = {0};
				const gchar* _tmp32_ = NULL;
				gchar** _tmp33_ = NULL;
				gchar** _tmp34_ = NULL;
				gint inds_length1 = 0;
				gint _inds_size_ = 0;
				FolksIndividualAggregator* _tmp35_ = NULL;
				SearchViewTestsSimpleTestVector _tmp36_ = {0};
				const gchar* _tmp37_ = NULL;
				gchar** _tmp38_ = NULL;
				gint _tmp38__length1 = 0;
#line 113 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
				_tmp31_ = vector;
#line 113 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
				_tmp32_ = _tmp31_.expected_individuals;
#line 113 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
				_tmp34_ = _tmp33_ = g_strsplit (_tmp32_, ",", 0);
#line 113 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
				inds = _tmp34_;
#line 113 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
				inds_length1 = _vala_array_length (_tmp33_);
#line 113 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
				_inds_size_ = inds_length1;
#line 115 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
				_tmp35_ = aggregator;
#line 115 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
				_tmp36_ = vector;
#line 115 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
				_tmp37_ = _tmp36_.query;
#line 115 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
				_tmp38_ = inds;
#line 115 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
				_tmp38__length1 = inds_length1;
#line 115 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
				_search_view_tests_test_simple_search_results_single (self, _tmp35_, _tmp37_, _tmp38_, _tmp38__length1);
#line 110 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
				inds = (_vala_array_free (inds, inds_length1, (GDestroyNotify) g_free), NULL);
#line 610 "search-view.c"
			}
		}
	}
#line 119 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_g_object_unref0 (aggregator);
#line 119 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	aggregator = NULL;
#line 60 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_g_object_unref0 (aggregator);
#line 60 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_g_object_unref0 (personas);
#line 60 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_g_object_unref0 (persona3);
#line 60 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_g_object_unref0 (persona2);
#line 60 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_g_object_unref0 (persona1);
#line 60 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_g_object_unref0 (persona0);
#line 630 "search-view.c"
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
#line 123 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	g_atomic_int_inc (&_data1_->_ref_count_);
#line 123 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	return _data1_;
#line 639 "search-view.c"
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
#line 123 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
#line 648 "search-view.c"
		SearchViewTests* self;
#line 123 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		self = _data1_->self;
#line 123 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_g_object_unref0 (_data1_->search_view);
#line 123 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_g_main_loop_unref0 (_data1_->main_loop);
#line 123 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_g_object_unref0 (self);
#line 123 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		g_slice_free (Block1Data, _data1_);
#line 660 "search-view.c"
	}
}


static const gchar** _vala_array_dup1 (const gchar** self, int length) {
#line 131 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	return g_memdup (self, length * sizeof (const gchar*));
#line 668 "search-view.c"
}


static void _vala_array_add1 (const gchar*** array, int* length, int* size, const gchar* value) {
#line 133 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	if ((*length) == (*size)) {
#line 133 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 133 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		*array = g_renew (const gchar*, *array, (*size) + 1);
#line 679 "search-view.c"
	}
#line 133 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	(*array)[(*length)++] = value;
#line 133 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	(*array)[*length] = NULL;
#line 685 "search-view.c"
}


static void __lambda4_ (Block1Data* _data1_, GObject* s, GAsyncResult* r) {
	SearchViewTests* self;
	GError * _inner_error_ = NULL;
#line 137 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	self = _data1_->self;
#line 137 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	g_return_if_fail (r != NULL);
#line 696 "search-view.c"
	{
		FolksSearchView* _tmp0_ = NULL;
		GAsyncResult* _tmp1_ = NULL;
		GMainLoop* _tmp2_ = NULL;
#line 141 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_tmp0_ = _data1_->search_view;
#line 141 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_tmp1_ = r;
#line 141 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		folks_search_view_prepare_finish (_tmp0_, _tmp1_, &_inner_error_);
#line 141 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 709 "search-view.c"
			goto __catch0_g_error;
		}
#line 142 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_tmp2_ = _data1_->main_loop;
#line 142 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		g_main_loop_quit (_tmp2_);
#line 716 "search-view.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e1 = NULL;
		const gchar* _tmp3_ = NULL;
#line 139 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		e1 = _inner_error_;
#line 139 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_inner_error_ = NULL;
#line 146 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_tmp3_ = e1->message;
#line 146 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		g_error ("search-view.vala:146: Failed to prepare search view: %s", _tmp3_);
#line 139 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_g_error_free0 (e1);
#line 733 "search-view.c"
	}
	__finally0:
#line 139 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 139 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 139 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		g_clear_error (&_inner_error_);
#line 139 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		return;
#line 744 "search-view.c"
	}
}


static void ___lambda4__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 137 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	__lambda4_ (self, source_object, res);
#line 137 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	block1_data_unref (self);
#line 754 "search-view.c"
}


static void __lambda5_ (Block1Data* _data1_, GObject* s, GAsyncResult* r) {
	SearchViewTests* self;
	GError * _inner_error_ = NULL;
#line 169 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	self = _data1_->self;
#line 169 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	g_return_if_fail (r != NULL);
#line 765 "search-view.c"
	{
		FolksSearchView* _tmp0_ = NULL;
		GAsyncResult* _tmp1_ = NULL;
		GMainLoop* _tmp2_ = NULL;
#line 173 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_tmp0_ = _data1_->search_view;
#line 173 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_tmp1_ = r;
#line 173 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		folks_search_view_unprepare_finish (_tmp0_, _tmp1_, &_inner_error_);
#line 173 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 778 "search-view.c"
			goto __catch1_g_error;
		}
#line 174 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_tmp2_ = _data1_->main_loop;
#line 174 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		g_main_loop_quit (_tmp2_);
#line 785 "search-view.c"
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e1 = NULL;
		const gchar* _tmp3_ = NULL;
#line 171 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		e1 = _inner_error_;
#line 171 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_inner_error_ = NULL;
#line 178 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_tmp3_ = e1->message;
#line 178 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		g_error ("search-view.vala:178: Failed to unprepare search view: %s", _tmp3_);
#line 171 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_g_error_free0 (e1);
#line 802 "search-view.c"
	}
	__finally1:
#line 171 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 171 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 171 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		g_clear_error (&_inner_error_);
#line 171 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		return;
#line 813 "search-view.c"
	}
}


static void ___lambda5__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 169 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	__lambda5_ (self, source_object, res);
#line 169 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	block1_data_unref (self);
#line 823 "search-view.c"
}


static void __lambda6_ (Block1Data* _data1_, GObject* s, GAsyncResult* r) {
	SearchViewTests* self;
	GError * _inner_error_ = NULL;
#line 183 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	self = _data1_->self;
#line 183 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	g_return_if_fail (r != NULL);
#line 834 "search-view.c"
	{
		FolksSearchView* _tmp0_ = NULL;
		FolksIndividualAggregator* _tmp1_ = NULL;
		FolksIndividualAggregator* _tmp2_ = NULL;
		GAsyncResult* _tmp3_ = NULL;
		GMainLoop* _tmp4_ = NULL;
#line 187 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_tmp0_ = _data1_->search_view;
#line 187 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_tmp1_ = folks_search_view_get_aggregator (_tmp0_);
#line 187 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_tmp2_ = _tmp1_;
#line 187 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_tmp3_ = r;
#line 187 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		folks_individual_aggregator_unprepare_finish (_tmp2_, _tmp3_, &_inner_error_);
#line 187 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 853 "search-view.c"
			goto __catch2_g_error;
		}
#line 188 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_tmp4_ = _data1_->main_loop;
#line 188 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		g_main_loop_quit (_tmp4_);
#line 860 "search-view.c"
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e2 = NULL;
		const gchar* _tmp5_ = NULL;
#line 185 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		e2 = _inner_error_;
#line 185 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_inner_error_ = NULL;
#line 192 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_tmp5_ = e2->message;
#line 192 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		g_error ("search-view.vala:192: Failed to unprepare aggregator: %s", _tmp5_);
#line 185 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_g_error_free0 (e2);
#line 877 "search-view.c"
	}
	__finally2:
#line 185 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 185 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 185 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		g_clear_error (&_inner_error_);
#line 185 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		return;
#line 888 "search-view.c"
	}
}


static void ___lambda6__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 183 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	__lambda6_ (self, source_object, res);
#line 183 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	block1_data_unref (self);
#line 898 "search-view.c"
}


static void _search_view_tests_test_simple_search_results_single (SearchViewTests* self, FolksIndividualAggregator* aggregator, const gchar* query, gchar** expected_individuals, int expected_individuals_length1) {
	Block1Data* _data1_;
	GMainLoop* _tmp0_ = NULL;
	const gchar** fields = NULL;
	const gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	gint fields_length1 = 0;
	gint _fields_size_ = 0;
	FolksSimpleQuery* simple_query = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar** _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	FolksSimpleQuery* _tmp6_ = NULL;
	FolksIndividualAggregator* _tmp7_ = NULL;
	FolksSimpleQuery* _tmp8_ = NULL;
	FolksSearchView* _tmp9_ = NULL;
	FolksSearchView* _tmp10_ = NULL;
	GMainLoop* _tmp11_ = NULL;
	GeeIterator* iter = NULL;
	FolksSearchView* _tmp12_ = NULL;
	GeeSortedSet* _tmp13_ = NULL;
	GeeSortedSet* _tmp14_ = NULL;
	GeeIterator* _tmp15_ = NULL;
	gchar** _tmp16_ = NULL;
	gint _tmp16__length1 = 0;
	GeeIterator* _tmp39_ = NULL;
	gboolean _tmp40_ = FALSE;
	FolksSearchView* _tmp41_ = NULL;
	GMainLoop* _tmp42_ = NULL;
	FolksSearchView* _tmp43_ = NULL;
	FolksIndividualAggregator* _tmp44_ = NULL;
	FolksIndividualAggregator* _tmp45_ = NULL;
	GMainLoop* _tmp46_ = NULL;
#line 123 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	g_return_if_fail (self != NULL);
#line 123 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	g_return_if_fail (aggregator != NULL);
#line 123 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	g_return_if_fail (query != NULL);
#line 123 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_data1_ = g_slice_new0 (Block1Data);
#line 123 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_data1_->_ref_count_ = 1;
#line 123 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_data1_->self = g_object_ref (self);
#line 128 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp0_ = g_main_loop_new (NULL, FALSE);
#line 128 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_data1_->main_loop = _tmp0_;
#line 131 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp1_ = (FOLKS_QUERY_MATCH_FIELDS_NAMES != NULL) ? _vala_array_dup1 (FOLKS_QUERY_MATCH_FIELDS_NAMES, G_N_ELEMENTS (FOLKS_QUERY_MATCH_FIELDS_NAMES)) : ((gpointer) FOLKS_QUERY_MATCH_FIELDS_NAMES);
#line 131 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp1__length1 = G_N_ELEMENTS (FOLKS_QUERY_MATCH_FIELDS_NAMES);
#line 131 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	fields = _tmp1_;
#line 131 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	fields_length1 = _tmp1__length1;
#line 131 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_fields_size_ = fields_length1;
#line 961 "search-view.c"
	{
		const gchar** field_collection = NULL;
		gint field_collection_length1 = 0;
		gint _field_collection_size_ = 0;
		gint field_it = 0;
#line 132 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		field_collection = FOLKS_QUERY_MATCH_FIELDS_ADDRESSES;
#line 132 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		field_collection_length1 = G_N_ELEMENTS (FOLKS_QUERY_MATCH_FIELDS_ADDRESSES);
#line 132 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		for (field_it = 0; field_it < G_N_ELEMENTS (FOLKS_QUERY_MATCH_FIELDS_ADDRESSES); field_it = field_it + 1) {
#line 973 "search-view.c"
			const gchar* field = NULL;
#line 132 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
			field = field_collection[field_it];
#line 977 "search-view.c"
			{
				const gchar** _tmp2_ = NULL;
				gint _tmp2__length1 = 0;
				const gchar* _tmp3_ = NULL;
#line 133 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
				_tmp2_ = fields;
#line 133 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
				_tmp2__length1 = fields_length1;
#line 133 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
				_tmp3_ = field;
#line 133 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
				_vala_array_add1 (&fields, &fields_length1, &_fields_size_, _tmp3_);
#line 990 "search-view.c"
			}
		}
	}
#line 134 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp4_ = query;
#line 134 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp5_ = fields;
#line 134 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp5__length1 = fields_length1;
#line 134 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp6_ = folks_simple_query_new (_tmp4_, _tmp5_, _tmp5__length1);
#line 134 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	simple_query = _tmp6_;
#line 135 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp7_ = aggregator;
#line 135 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp8_ = simple_query;
#line 135 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp9_ = folks_search_view_new (_tmp7_, (FolksQuery*) _tmp8_);
#line 135 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_data1_->search_view = _tmp9_;
#line 137 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp10_ = _data1_->search_view;
#line 137 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	folks_search_view_prepare (_tmp10_, ___lambda4__gasync_ready_callback, block1_data_ref (_data1_));
#line 151 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp11_ = _data1_->main_loop;
#line 151 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	folks_test_utils_loop_run_with_timeout (_tmp11_, 5);
#line 154 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp12_ = _data1_->search_view;
#line 154 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp13_ = folks_search_view_get_individuals (_tmp12_);
#line 154 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp14_ = _tmp13_;
#line 154 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp15_ = gee_iterable_iterator ((GeeIterable*) _tmp14_);
#line 154 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	iter = _tmp15_;
#line 155 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp16_ = expected_individuals;
#line 155 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp16__length1 = expected_individuals_length1;
#line 1034 "search-view.c"
	{
		gchar** expected_persona_id_collection = NULL;
		gint expected_persona_id_collection_length1 = 0;
		gint _expected_persona_id_collection_size_ = 0;
		gint expected_persona_id_it = 0;
#line 155 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		expected_persona_id_collection = _tmp16_;
#line 155 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		expected_persona_id_collection_length1 = _tmp16__length1;
#line 155 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		for (expected_persona_id_it = 0; expected_persona_id_it < _tmp16__length1; expected_persona_id_it = expected_persona_id_it + 1) {
#line 1046 "search-view.c"
			gchar* _tmp17_ = NULL;
			gchar* expected_persona_id = NULL;
#line 155 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
			_tmp17_ = g_strdup (expected_persona_id_collection[expected_persona_id_it]);
#line 155 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
			expected_persona_id = _tmp17_;
#line 1053 "search-view.c"
			{
				GeeIterator* _tmp18_ = NULL;
				gboolean _tmp19_ = FALSE;
				FolksIndividual* ind = NULL;
				GeeIterator* _tmp20_ = NULL;
				gpointer _tmp21_ = NULL;
				FolksIndividual* _tmp22_ = NULL;
				GeeSet* _tmp23_ = NULL;
				GeeSet* _tmp24_ = NULL;
				gint _tmp25_ = 0;
				gint _tmp26_ = 0;
#line 157 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
				_tmp18_ = iter;
#line 157 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
				_tmp19_ = gee_iterator_next (_tmp18_);
#line 157 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
				_vala_assert (_tmp19_, "iter.next ()");
#line 158 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
				_tmp20_ = iter;
#line 158 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
				_tmp21_ = gee_iterator_get (_tmp20_);
#line 158 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
				ind = (FolksIndividual*) _tmp21_;
#line 160 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
				_tmp22_ = ind;
#line 160 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
				_tmp23_ = folks_individual_get_personas (_tmp22_);
#line 160 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
				_tmp24_ = _tmp23_;
#line 160 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
				_tmp25_ = gee_collection_get_size ((GeeCollection*) _tmp24_);
#line 160 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
				_tmp26_ = _tmp25_;
#line 160 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
				_vala_assert (_tmp26_ == 1, "ind.personas.size == 1");
#line 1089 "search-view.c"
				{
					GeeIterator* _persona_it = NULL;
					FolksIndividual* _tmp27_ = NULL;
					GeeSet* _tmp28_ = NULL;
					GeeSet* _tmp29_ = NULL;
					GeeIterator* _tmp30_ = NULL;
#line 161 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
					_tmp27_ = ind;
#line 161 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
					_tmp28_ = folks_individual_get_personas (_tmp27_);
#line 161 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
					_tmp29_ = _tmp28_;
#line 161 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
					_tmp30_ = gee_iterable_iterator ((GeeIterable*) _tmp29_);
#line 161 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
					_persona_it = _tmp30_;
#line 161 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
					while (TRUE) {
#line 1108 "search-view.c"
						GeeIterator* _tmp31_ = NULL;
						gboolean _tmp32_ = FALSE;
						FolksPersona* persona = NULL;
						GeeIterator* _tmp33_ = NULL;
						gpointer _tmp34_ = NULL;
						const gchar* _tmp35_ = NULL;
						FolksPersona* _tmp36_ = NULL;
						const gchar* _tmp37_ = NULL;
						const gchar* _tmp38_ = NULL;
#line 161 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
						_tmp31_ = _persona_it;
#line 161 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
						_tmp32_ = gee_iterator_next (_tmp31_);
#line 161 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
						if (!_tmp32_) {
#line 161 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
							break;
#line 1126 "search-view.c"
						}
#line 161 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
						_tmp33_ = _persona_it;
#line 161 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
						_tmp34_ = gee_iterator_get (_tmp33_);
#line 161 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
						persona = (FolksPersona*) _tmp34_;
#line 163 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
						_tmp35_ = expected_persona_id;
#line 163 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
						_tmp36_ = persona;
#line 163 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
						_tmp37_ = folks_persona_get_display_id (_tmp36_);
#line 163 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
						_tmp38_ = _tmp37_;
#line 163 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
						_vala_assert (g_strcmp0 (_tmp35_, _tmp38_) == 0, "expected_persona_id == persona.display_id");
#line 161 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
						_g_object_unref0 (persona);
#line 1146 "search-view.c"
					}
#line 161 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
					_g_object_unref0 (_persona_it);
#line 1150 "search-view.c"
				}
#line 155 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
				_g_object_unref0 (ind);
#line 155 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
				_g_free0 (expected_persona_id);
#line 1156 "search-view.c"
			}
		}
	}
#line 167 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp39_ = iter;
#line 167 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp40_ = gee_iterator_has_next (_tmp39_);
#line 167 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_vala_assert (!_tmp40_, "!iter.has_next ()");
#line 169 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp41_ = _data1_->search_view;
#line 169 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	folks_search_view_unprepare (_tmp41_, ___lambda5__gasync_ready_callback, block1_data_ref (_data1_));
#line 181 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp42_ = _data1_->main_loop;
#line 181 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	folks_test_utils_loop_run_with_timeout (_tmp42_, 5);
#line 183 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp43_ = _data1_->search_view;
#line 183 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp44_ = folks_search_view_get_aggregator (_tmp43_);
#line 183 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp45_ = _tmp44_;
#line 183 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	folks_individual_aggregator_unprepare (_tmp45_, ___lambda6__gasync_ready_callback, block1_data_ref (_data1_));
#line 195 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp46_ = _data1_->main_loop;
#line 195 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	folks_test_utils_loop_run_with_timeout (_tmp46_, 5);
#line 197 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_g_object_unref0 (_data1_->search_view);
#line 197 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_data1_->search_view = NULL;
#line 123 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_g_object_unref0 (iter);
#line 123 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_g_object_unref0 (simple_query);
#line 123 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	fields = (g_free (fields), NULL);
#line 123 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	block1_data_unref (_data1_);
#line 123 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_data1_ = NULL;
#line 1200 "search-view.c"
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
#line 200 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	g_atomic_int_inc (&_data2_->_ref_count_);
#line 200 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	return _data2_;
#line 1209 "search-view.c"
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
#line 200 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
#line 1218 "search-view.c"
		SearchViewTests* self;
#line 200 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		self = _data2_->self;
#line 200 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_g_object_unref0 (_data2_->search_view);
#line 200 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_g_object_unref0 (_data2_->store);
#line 200 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_g_object_unref0 (_data2_->unexpected_matches);
#line 200 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_g_object_unref0 (_data2_->expected_non_matches);
#line 200 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_g_object_unref0 (_data2_->expected_matches);
#line 200 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_g_main_loop_unref0 (_data2_->main_loop);
#line 200 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_g_object_unref0 (self);
#line 200 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		g_slice_free (Block2Data, _data2_);
#line 1238 "search-view.c"
	}
}


static void __lambda7_ (Block2Data* _data2_, GObject* s, GAsyncResult* r) {
	SearchViewTests* self;
	FolksBackendStore* _tmp0_ = NULL;
	GAsyncResult* _tmp1_ = NULL;
	GMainLoop* _tmp2_ = NULL;
#line 228 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	self = _data2_->self;
#line 228 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	g_return_if_fail (r != NULL);
#line 230 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp0_ = _data2_->store;
#line 230 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp1_ = r;
#line 230 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	folks_backend_store_prepare_finish (_tmp0_, _tmp1_);
#line 231 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp2_ = _data2_->main_loop;
#line 231 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	g_main_loop_quit (_tmp2_);
#line 1262 "search-view.c"
}


static void ___lambda7__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 228 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	__lambda7_ (self, source_object, res);
#line 228 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	block2_data_unref (self);
#line 1271 "search-view.c"
}


static const gchar** _vala_array_dup2 (const gchar** self, int length) {
#line 238 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	return g_memdup (self, length * sizeof (const gchar*));
#line 1278 "search-view.c"
}


static void _vala_array_add2 (const gchar*** array, int* length, int* size, const gchar* value) {
#line 240 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	if ((*length) == (*size)) {
#line 240 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 240 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		*array = g_renew (const gchar*, *array, (*size) + 1);
#line 1289 "search-view.c"
	}
#line 240 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	(*array)[(*length)++] = value;
#line 240 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	(*array)[*length] = NULL;
#line 1295 "search-view.c"
}


static void __lambda8_ (Block2Data* _data2_, GeeSortedSet* added, GeeSortedSet* removed) {
	SearchViewTests* self;
	GeeSortedSet* _tmp0_ = NULL;
	GMainLoop* _tmp1_ = NULL;
	GeeHashSet* _tmp2_ = NULL;
	GeeHashSet* _tmp3_ = NULL;
	GeeHashSet* _tmp4_ = NULL;
	GeeSortedSet* _tmp5_ = NULL;
	GMainLoop* _tmp6_ = NULL;
	GeeHashSet* _tmp7_ = NULL;
	GeeHashSet* _tmp8_ = NULL;
	GeeHashSet* _tmp9_ = NULL;
#line 244 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	self = _data2_->self;
#line 244 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	g_return_if_fail (added != NULL);
#line 244 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	g_return_if_fail (removed != NULL);
#line 246 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp0_ = added;
#line 246 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp1_ = _data2_->main_loop;
#line 246 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp2_ = _data2_->expected_matches;
#line 246 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp3_ = _data2_->expected_non_matches;
#line 246 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp4_ = _data2_->unexpected_matches;
#line 246 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_search_view_tests_individuals_added (self, (GeeCollection*) _tmp0_, _tmp1_, (GeeSet*) _tmp2_, (GeeSet*) _tmp3_, (GeeSet*) _tmp4_);
#line 248 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp5_ = removed;
#line 248 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp6_ = _data2_->main_loop;
#line 248 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp7_ = _data2_->expected_matches;
#line 248 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp8_ = _data2_->expected_non_matches;
#line 248 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp9_ = _data2_->unexpected_matches;
#line 248 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_search_view_tests_individuals_removed (self, (GeeCollection*) _tmp5_, _tmp6_, (GeeSet*) _tmp7_, (GeeSet*) _tmp8_, (GeeSet*) _tmp9_);
#line 1341 "search-view.c"
}


static void ___lambda8__folks_search_view_individuals_changed_detailed (FolksSearchView* _sender, GeeSortedSet* added, GeeSortedSet* removed, gpointer self) {
#line 244 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	__lambda8_ (self, added, removed);
#line 1348 "search-view.c"
}


static void __lambda9_ (Block2Data* _data2_, GObject* s, GAsyncResult* r) {
	SearchViewTests* self;
	GError * _inner_error_ = NULL;
#line 252 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	self = _data2_->self;
#line 252 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	g_return_if_fail (r != NULL);
#line 1359 "search-view.c"
	{
		FolksSearchView* _tmp0_ = NULL;
		GAsyncResult* _tmp1_ = NULL;
		GMainLoop* _tmp2_ = NULL;
#line 256 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_tmp0_ = _data2_->search_view;
#line 256 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_tmp1_ = r;
#line 256 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		folks_search_view_prepare_finish (_tmp0_, _tmp1_, &_inner_error_);
#line 256 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1372 "search-view.c"
			goto __catch3_g_error;
		}
#line 257 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_tmp2_ = _data2_->main_loop;
#line 257 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		g_main_loop_quit (_tmp2_);
#line 1379 "search-view.c"
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp3_ = NULL;
#line 254 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		e = _inner_error_;
#line 254 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_inner_error_ = NULL;
#line 261 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_tmp3_ = e->message;
#line 261 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		g_error ("search-view.vala:261: Error when calling prepare: %s", _tmp3_);
#line 254 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_g_error_free0 (e);
#line 1396 "search-view.c"
	}
	__finally3:
#line 254 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 254 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 254 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		g_clear_error (&_inner_error_);
#line 254 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		return;
#line 1407 "search-view.c"
	}
}


static void ___lambda9__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 252 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	__lambda9_ (self, source_object, res);
#line 252 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	block2_data_unref (self);
#line 1417 "search-view.c"
}


static const gchar** _vala_array_dup3 (const gchar** self, int length) {
#line 290 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	return g_memdup (self, length * sizeof (const gchar*));
#line 1424 "search-view.c"
}


static void _vala_array_add3 (const gchar*** array, int* length, int* size, const gchar* value) {
#line 292 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	if ((*length) == (*size)) {
#line 292 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 292 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		*array = g_renew (const gchar*, *array, (*size) + 1);
#line 1435 "search-view.c"
	}
#line 292 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	(*array)[(*length)++] = value;
#line 292 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	(*array)[*length] = NULL;
#line 1441 "search-view.c"
}


void search_view_tests_test_search_before_after (SearchViewTests* self) {
	Block2Data* _data2_;
	GMainLoop* _tmp0_ = NULL;
	GeeHashSet* _tmp1_ = NULL;
	GeeHashSet* _tmp2_ = NULL;
	GeeHashSet* _tmp3_ = NULL;
	GeeHashSet* personas = NULL;
	GeeHashSet* _tmp4_ = NULL;
	GeeHashSet* _tmp5_ = NULL;
	FolksDummyFullPersona* _tmp6_ = NULL;
	FolksDummyFullPersona* _tmp7_ = NULL;
	FolksDummyFullPersona* persona1 = NULL;
	FolksDummyPersonaStore* _tmp8_ = NULL;
	gchar** _tmp9_ = NULL;
	gchar** _tmp10_ = NULL;
	gint _tmp10__length1 = 0;
	FolksDummyFullPersona* _tmp11_ = NULL;
	FolksDummyFullPersona* _tmp12_ = NULL;
	FolksDummyFullPersona* _tmp13_ = NULL;
	GeeHashSet* email_addresses = NULL;
	GeeHashSet* _tmp14_ = NULL;
	GeeHashSet* _tmp15_ = NULL;
	FolksEmailFieldDetails* _tmp16_ = NULL;
	FolksEmailFieldDetails* _tmp17_ = NULL;
	FolksDummyFullPersona* _tmp18_ = NULL;
	GeeHashSet* _tmp19_ = NULL;
	GeeHashSet* _tmp20_ = NULL;
	FolksDummyFullPersona* _tmp21_ = NULL;
	GeeHashSet* _tmp22_ = NULL;
	FolksDummyPersonaStore* _tmp23_ = NULL;
	GeeHashSet* _tmp24_ = NULL;
	FolksBackendStore* _tmp25_ = NULL;
	FolksBackendStore* _tmp26_ = NULL;
	GMainLoop* _tmp27_ = NULL;
	FolksIndividualAggregator* aggregator = NULL;
	FolksIndividualAggregator* _tmp28_ = NULL;
	const gchar** fields = NULL;
	const gchar** _tmp29_ = NULL;
	gint _tmp29__length1 = 0;
	gint fields_length1 = 0;
	gint _fields_size_ = 0;
	FolksSimpleQuery* query = NULL;
	const gchar** _tmp32_ = NULL;
	gint _tmp32__length1 = 0;
	FolksSimpleQuery* _tmp33_ = NULL;
	FolksIndividualAggregator* _tmp34_ = NULL;
	FolksSimpleQuery* _tmp35_ = NULL;
	FolksSearchView* _tmp36_ = NULL;
	gulong handler_id = 0UL;
	FolksSearchView* _tmp37_ = NULL;
	gulong _tmp38_ = 0UL;
	FolksSearchView* _tmp39_ = NULL;
	GMainLoop* _tmp40_ = NULL;
	FolksDummyFullPersona* persona2 = NULL;
	FolksDummyPersonaStore* _tmp41_ = NULL;
	gchar** _tmp42_ = NULL;
	gchar** _tmp43_ = NULL;
	gint _tmp43__length1 = 0;
	FolksDummyFullPersona* _tmp44_ = NULL;
	FolksDummyFullPersona* _tmp45_ = NULL;
	FolksDummyFullPersona* _tmp46_ = NULL;
	GeeHashSet* _tmp47_ = NULL;
	GeeHashSet* _tmp48_ = NULL;
	FolksEmailFieldDetails* _tmp49_ = NULL;
	FolksEmailFieldDetails* _tmp50_ = NULL;
	FolksDummyFullPersona* _tmp51_ = NULL;
	GeeHashSet* _tmp52_ = NULL;
	GeeHashSet* _tmp53_ = NULL;
	GeeHashSet* _tmp54_ = NULL;
	FolksDummyFullPersona* _tmp55_ = NULL;
	GeeHashSet* _tmp56_ = NULL;
	FolksDummyPersonaStore* _tmp57_ = NULL;
	GeeHashSet* _tmp58_ = NULL;
	GeeHashSet* _tmp59_ = NULL;
	gint _tmp60_ = 0;
	gint _tmp61_ = 0;
	FolksSearchView* _tmp71_ = NULL;
	gulong _tmp72_ = 0UL;
	const gchar** _tmp73_ = NULL;
	gint _tmp73__length1 = 0;
	const gchar** _tmp76_ = NULL;
	gint _tmp76__length1 = 0;
	FolksSimpleQuery* _tmp77_ = NULL;
	FolksIndividualAggregator* _tmp78_ = NULL;
	FolksSimpleQuery* _tmp79_ = NULL;
	FolksSearchView* _tmp80_ = NULL;
	FolksSearchView* _tmp81_ = NULL;
#line 200 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	g_return_if_fail (self != NULL);
#line 200 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_data2_ = g_slice_new0 (Block2Data);
#line 200 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_data2_->_ref_count_ = 1;
#line 200 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_data2_->self = g_object_ref (self);
#line 202 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp0_ = g_main_loop_new (NULL, FALSE);
#line 202 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_data2_->main_loop = _tmp0_;
#line 203 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp1_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL, NULL, NULL, NULL);
#line 203 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_data2_->expected_matches = _tmp1_;
#line 204 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp2_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL, NULL, NULL, NULL);
#line 204 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_data2_->expected_non_matches = _tmp2_;
#line 205 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp3_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL, NULL, NULL, NULL);
#line 205 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_data2_->unexpected_matches = _tmp3_;
#line 208 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp4_ = gee_hash_set_new (FOLKS_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
#line 208 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	personas = _tmp4_;
#line 209 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp5_ = personas;
#line 209 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp6_ = _search_view_tests_generate_main_persona (self);
#line 209 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp7_ = _tmp6_;
#line 209 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp5_, (FolksPersona*) _tmp7_);
#line 209 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_g_object_unref0 (_tmp7_);
#line 212 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp8_ = ((DummyTestTestCase*) self)->dummy_persona_store;
#line 212 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp9_ = g_new0 (gchar*, 0 + 1);
#line 212 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp10_ = _tmp9_;
#line 212 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp10__length1 = 0;
#line 212 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp11_ = folks_dummy_full_persona_new (_tmp8_, "persona1", FALSE, _tmp10_, 0);
#line 212 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp12_ = _tmp11_;
#line 212 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp10_ = (_vala_array_free (_tmp10_, _tmp10__length1, (GDestroyNotify) g_free), NULL);
#line 212 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	persona1 = _tmp12_;
#line 214 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp13_ = persona1;
#line 214 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	folks_dummy_full_persona_update_full_name (_tmp13_, "Lana Kane");
#line 216 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp14_ = gee_hash_set_new (FOLKS_TYPE_EMAIL_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
#line 216 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	email_addresses = _tmp14_;
#line 217 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp15_ = email_addresses;
#line 217 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp16_ = folks_email_field_details_new ("lana@isis.secret", NULL);
#line 217 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp17_ = _tmp16_;
#line 217 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp15_, _tmp17_);
#line 217 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_g_object_unref0 (_tmp17_);
#line 218 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp18_ = persona1;
#line 218 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp19_ = email_addresses;
#line 218 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	folks_dummy_full_persona_update_email_addresses (_tmp18_, (GeeSet*) _tmp19_);
#line 220 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp20_ = personas;
#line 220 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp21_ = persona1;
#line 220 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp20_, (FolksPersona*) _tmp21_);
#line 224 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp22_ = _data2_->expected_matches;
#line 224 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp22_, "persona0");
#line 225 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp23_ = ((DummyTestTestCase*) self)->dummy_persona_store;
#line 225 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp24_ = personas;
#line 225 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	folks_dummy_persona_store_register_personas (_tmp23_, (GeeSet*) _tmp24_);
#line 227 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp25_ = folks_backend_store_dup ();
#line 227 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_data2_->store = _tmp25_;
#line 228 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp26_ = _data2_->store;
#line 228 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	folks_backend_store_prepare (_tmp26_, ___lambda7__gasync_ready_callback, block2_data_ref (_data2_));
#line 234 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp27_ = _data2_->main_loop;
#line 234 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	folks_test_utils_loop_run_with_timeout (_tmp27_, 5);
#line 236 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp28_ = folks_individual_aggregator_dup ();
#line 236 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	aggregator = _tmp28_;
#line 238 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp29_ = (FOLKS_QUERY_MATCH_FIELDS_NAMES != NULL) ? _vala_array_dup2 (FOLKS_QUERY_MATCH_FIELDS_NAMES, G_N_ELEMENTS (FOLKS_QUERY_MATCH_FIELDS_NAMES)) : ((gpointer) FOLKS_QUERY_MATCH_FIELDS_NAMES);
#line 238 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp29__length1 = G_N_ELEMENTS (FOLKS_QUERY_MATCH_FIELDS_NAMES);
#line 238 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	fields = _tmp29_;
#line 238 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	fields_length1 = _tmp29__length1;
#line 238 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_fields_size_ = fields_length1;
#line 1652 "search-view.c"
	{
		const gchar** field_collection = NULL;
		gint field_collection_length1 = 0;
		gint _field_collection_size_ = 0;
		gint field_it = 0;
#line 239 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		field_collection = FOLKS_QUERY_MATCH_FIELDS_ADDRESSES;
#line 239 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		field_collection_length1 = G_N_ELEMENTS (FOLKS_QUERY_MATCH_FIELDS_ADDRESSES);
#line 239 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		for (field_it = 0; field_it < G_N_ELEMENTS (FOLKS_QUERY_MATCH_FIELDS_ADDRESSES); field_it = field_it + 1) {
#line 1664 "search-view.c"
			const gchar* field = NULL;
#line 239 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
			field = field_collection[field_it];
#line 1668 "search-view.c"
			{
				const gchar** _tmp30_ = NULL;
				gint _tmp30__length1 = 0;
				const gchar* _tmp31_ = NULL;
#line 240 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
				_tmp30_ = fields;
#line 240 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
				_tmp30__length1 = fields_length1;
#line 240 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
				_tmp31_ = field;
#line 240 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
				_vala_array_add2 (&fields, &fields_length1, &_fields_size_, _tmp31_);
#line 1681 "search-view.c"
			}
		}
	}
#line 241 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp32_ = fields;
#line 241 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp32__length1 = fields_length1;
#line 241 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp33_ = folks_simple_query_new ("Mallory", _tmp32_, _tmp32__length1);
#line 241 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	query = _tmp33_;
#line 242 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp34_ = aggregator;
#line 242 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp35_ = query;
#line 242 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp36_ = folks_search_view_new (_tmp34_, (FolksQuery*) _tmp35_);
#line 242 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_data2_->search_view = _tmp36_;
#line 244 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp37_ = _data2_->search_view;
#line 244 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp38_ = g_signal_connect_data (_tmp37_, "individuals-changed-detailed", (GCallback) ___lambda8__folks_search_view_individuals_changed_detailed, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
#line 244 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	handler_id = _tmp38_;
#line 252 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp39_ = _data2_->search_view;
#line 252 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	folks_search_view_prepare (_tmp39_, ___lambda9__gasync_ready_callback, block2_data_ref (_data2_));
#line 265 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp40_ = _data2_->main_loop;
#line 265 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	folks_test_utils_loop_run_with_timeout (_tmp40_, 5);
#line 269 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp41_ = ((DummyTestTestCase*) self)->dummy_persona_store;
#line 269 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp42_ = g_new0 (gchar*, 0 + 1);
#line 269 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp43_ = _tmp42_;
#line 269 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp43__length1 = 0;
#line 269 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp44_ = folks_dummy_full_persona_new (_tmp41_, "persona2", FALSE, _tmp43_, 0);
#line 269 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp45_ = _tmp44_;
#line 269 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp43_ = (_vala_array_free (_tmp43_, _tmp43__length1, (GDestroyNotify) g_free), NULL);
#line 269 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	persona2 = _tmp45_;
#line 271 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp46_ = persona2;
#line 271 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	folks_dummy_full_persona_update_full_name (_tmp46_, "Mallory Archer");
#line 273 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp47_ = gee_hash_set_new (FOLKS_TYPE_EMAIL_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
#line 273 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_g_object_unref0 (email_addresses);
#line 273 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	email_addresses = _tmp47_;
#line 274 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp48_ = email_addresses;
#line 274 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp49_ = folks_email_field_details_new ("mallory@isis.secret", NULL);
#line 274 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp50_ = _tmp49_;
#line 274 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp48_, _tmp50_);
#line 274 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_g_object_unref0 (_tmp50_);
#line 275 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp51_ = persona2;
#line 275 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp52_ = email_addresses;
#line 275 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	folks_dummy_full_persona_update_email_addresses (_tmp51_, (GeeSet*) _tmp52_);
#line 277 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp53_ = gee_hash_set_new (FOLKS_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
#line 277 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_g_object_unref0 (personas);
#line 277 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	personas = _tmp53_;
#line 278 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp54_ = personas;
#line 278 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp55_ = persona2;
#line 278 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp54_, (FolksPersona*) _tmp55_);
#line 279 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp56_ = _data2_->expected_matches;
#line 279 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp56_, "persona2");
#line 281 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp57_ = ((DummyTestTestCase*) self)->dummy_persona_store;
#line 281 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp58_ = personas;
#line 281 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	folks_dummy_persona_store_register_personas (_tmp57_, (GeeSet*) _tmp58_);
#line 283 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp59_ = _data2_->expected_matches;
#line 283 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp60_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp59_);
#line 283 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp61_ = _tmp60_;
#line 283 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_vala_assert (_tmp61_ == 0, "expected_matches.size == 0");
#line 1787 "search-view.c"
	{
		GeeIterator* _unexpected_match_it = NULL;
		GeeHashSet* _tmp62_ = NULL;
		GeeIterator* _tmp63_ = NULL;
#line 284 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_tmp62_ = _data2_->unexpected_matches;
#line 284 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_tmp63_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp62_);
#line 284 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_unexpected_match_it = _tmp63_;
#line 284 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		while (TRUE) {
#line 1800 "search-view.c"
			GeeIterator* _tmp64_ = NULL;
			gboolean _tmp65_ = FALSE;
			gchar* unexpected_match = NULL;
			GeeIterator* _tmp66_ = NULL;
			gpointer _tmp67_ = NULL;
			GeeHashSet* _tmp68_ = NULL;
			const gchar* _tmp69_ = NULL;
			gboolean _tmp70_ = FALSE;
#line 284 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
			_tmp64_ = _unexpected_match_it;
#line 284 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
			_tmp65_ = gee_iterator_next (_tmp64_);
#line 284 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
			if (!_tmp65_) {
#line 284 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
				break;
#line 1817 "search-view.c"
			}
#line 284 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
			_tmp66_ = _unexpected_match_it;
#line 284 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
			_tmp67_ = gee_iterator_get (_tmp66_);
#line 284 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
			unexpected_match = (gchar*) _tmp67_;
#line 285 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
			_tmp68_ = _data2_->expected_non_matches;
#line 285 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
			_tmp69_ = unexpected_match;
#line 285 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
			_tmp70_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp68_, _tmp69_);
#line 285 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
			_vala_assert (!_tmp70_, "!(unexpected_match in expected_non_matches)");
#line 284 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
			_g_free0 (unexpected_match);
#line 1835 "search-view.c"
		}
#line 284 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_g_object_unref0 (_unexpected_match_it);
#line 1839 "search-view.c"
	}
#line 287 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp71_ = _data2_->search_view;
#line 287 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp72_ = handler_id;
#line 287 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	g_signal_handler_disconnect ((GObject*) _tmp71_, _tmp72_);
#line 290 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp73_ = (FOLKS_QUERY_MATCH_FIELDS_NAMES != NULL) ? _vala_array_dup3 (FOLKS_QUERY_MATCH_FIELDS_NAMES, G_N_ELEMENTS (FOLKS_QUERY_MATCH_FIELDS_NAMES)) : ((gpointer) FOLKS_QUERY_MATCH_FIELDS_NAMES);
#line 290 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp73__length1 = G_N_ELEMENTS (FOLKS_QUERY_MATCH_FIELDS_NAMES);
#line 290 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	fields = (g_free (fields), NULL);
#line 290 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	fields = _tmp73_;
#line 290 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	fields_length1 = _tmp73__length1;
#line 290 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_fields_size_ = fields_length1;
#line 1859 "search-view.c"
	{
		const gchar** field_collection = NULL;
		gint field_collection_length1 = 0;
		gint _field_collection_size_ = 0;
		gint field_it = 0;
#line 291 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		field_collection = FOLKS_QUERY_MATCH_FIELDS_ADDRESSES;
#line 291 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		field_collection_length1 = G_N_ELEMENTS (FOLKS_QUERY_MATCH_FIELDS_ADDRESSES);
#line 291 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		for (field_it = 0; field_it < G_N_ELEMENTS (FOLKS_QUERY_MATCH_FIELDS_ADDRESSES); field_it = field_it + 1) {
#line 1871 "search-view.c"
			const gchar* field = NULL;
#line 291 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
			field = field_collection[field_it];
#line 1875 "search-view.c"
			{
				const gchar** _tmp74_ = NULL;
				gint _tmp74__length1 = 0;
				const gchar* _tmp75_ = NULL;
#line 292 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
				_tmp74_ = fields;
#line 292 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
				_tmp74__length1 = fields_length1;
#line 292 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
				_tmp75_ = field;
#line 292 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
				_vala_array_add3 (&fields, &fields_length1, &_fields_size_, _tmp75_);
#line 1888 "search-view.c"
			}
		}
	}
#line 296 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp76_ = fields;
#line 296 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp76__length1 = fields_length1;
#line 296 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp77_ = folks_simple_query_new (" mallorY   sterling   ", _tmp76_, _tmp76__length1);
#line 296 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_g_object_unref0 (query);
#line 296 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	query = _tmp77_;
#line 297 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp78_ = aggregator;
#line 297 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp79_ = query;
#line 297 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp80_ = folks_search_view_new (_tmp78_, (FolksQuery*) _tmp79_);
#line 297 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_g_object_unref0 (_data2_->search_view);
#line 297 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_data2_->search_view = _tmp80_;
#line 298 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp81_ = _data2_->search_view;
#line 298 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_search_view_tests_test_search_with_view_async (self, "persona0", NULL, _tmp81_);
#line 200 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_g_object_unref0 (persona2);
#line 200 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_g_object_unref0 (query);
#line 200 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	fields = (g_free (fields), NULL);
#line 200 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_g_object_unref0 (aggregator);
#line 200 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_g_object_unref0 (email_addresses);
#line 200 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_g_object_unref0 (persona1);
#line 200 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_g_object_unref0 (personas);
#line 200 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	block2_data_unref (_data2_);
#line 200 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_data2_ = NULL;
#line 1934 "search-view.c"
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
#line 301 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	g_atomic_int_inc (&_data3_->_ref_count_);
#line 301 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	return _data3_;
#line 1943 "search-view.c"
}


static void block3_data_unref (void * _userdata_) {
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
#line 301 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
#line 1952 "search-view.c"
		SearchViewTests* self;
#line 301 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		self = _data3_->self;
#line 301 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_g_object_unref0 (_data3_->aggregator);
#line 301 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_g_object_unref0 (_data3_->backend_store);
#line 301 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_g_main_loop_unref0 (_data3_->main_loop);
#line 301 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_g_object_unref0 (self);
#line 301 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		g_slice_free (Block3Data, _data3_);
#line 1966 "search-view.c"
	}
}


static void __lambda12_ (SearchViewTests* self, FolksDummyFullPersona* p) {
	FolksDummyFullPersona* _tmp0_ = NULL;
#line 311 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	g_return_if_fail (p != NULL);
#line 311 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp0_ = p;
#line 311 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	folks_dummy_full_persona_update_full_name (_tmp0_, "full_name");
#line 1979 "search-view.c"
}


static void ___lambda12__search_view_tests_generate_persona_func (FolksDummyFullPersona* persona, gpointer self) {
#line 310 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	__lambda12_ ((SearchViewTests*) self, persona);
#line 1986 "search-view.c"
}


static void __lambda13_ (SearchViewTests* self, FolksDummyFullPersona* p) {
	FolksDummyFullPersona* _tmp0_ = NULL;
#line 313 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	g_return_if_fail (p != NULL);
#line 313 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp0_ = p;
#line 313 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	folks_dummy_full_persona_update_nickname (_tmp0_, "nickname");
#line 1998 "search-view.c"
}


static void ___lambda13__search_view_tests_generate_persona_func (FolksDummyFullPersona* persona, gpointer self) {
#line 312 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	__lambda13_ ((SearchViewTests*) self, persona);
#line 2005 "search-view.c"
}


static void __lambda14_ (SearchViewTests* self, FolksDummyFullPersona* p) {
	FolksDummyFullPersona* _tmp0_ = NULL;
	FolksStructuredName* _tmp1_ = NULL;
	FolksStructuredName* _tmp2_ = NULL;
#line 316 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	g_return_if_fail (p != NULL);
#line 318 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp0_ = p;
#line 318 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp1_ = folks_structured_name_new ("structured_name", NULL, NULL, NULL, NULL);
#line 318 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp2_ = _tmp1_;
#line 318 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	folks_dummy_full_persona_update_structured_name (_tmp0_, _tmp2_);
#line 318 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_g_object_unref0 (_tmp2_);
#line 2025 "search-view.c"
}


static void ___lambda14__search_view_tests_generate_persona_func (FolksDummyFullPersona* persona, gpointer self) {
#line 316 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	__lambda14_ ((SearchViewTests*) self, persona);
#line 2032 "search-view.c"
}


static void __lambda15_ (SearchViewTests* self, FolksDummyFullPersona* p) {
	GeeHashSet* email_addresses = NULL;
	GeeHashSet* _tmp0_ = NULL;
	FolksEmailFieldDetails* _tmp1_ = NULL;
	FolksEmailFieldDetails* _tmp2_ = NULL;
	FolksDummyFullPersona* _tmp3_ = NULL;
#line 321 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	g_return_if_fail (p != NULL);
#line 323 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp0_ = gee_hash_set_new (FOLKS_TYPE_EMAIL_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
#line 323 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	email_addresses = _tmp0_;
#line 324 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp1_ = folks_email_field_details_new ("email_addresses", NULL);
#line 324 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp2_ = _tmp1_;
#line 324 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) email_addresses, _tmp2_);
#line 324 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_g_object_unref0 (_tmp2_);
#line 325 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp3_ = p;
#line 325 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	folks_dummy_full_persona_update_email_addresses (_tmp3_, (GeeSet*) email_addresses);
#line 321 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_g_object_unref0 (email_addresses);
#line 2062 "search-view.c"
}


static void ___lambda15__search_view_tests_generate_persona_func (FolksDummyFullPersona* persona, gpointer self) {
#line 321 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	__lambda15_ ((SearchViewTests*) self, persona);
#line 2069 "search-view.c"
}


static void __lambda16_ (SearchViewTests* self, FolksDummyFullPersona* p) {
	GeeHashMultiMap* im_addresses = NULL;
	GeeHashMultiMap* _tmp0_ = NULL;
	FolksImFieldDetails* _tmp1_ = NULL;
	FolksImFieldDetails* _tmp2_ = NULL;
	FolksDummyFullPersona* _tmp3_ = NULL;
#line 327 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	g_return_if_fail (p != NULL);
#line 329 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp0_ = gee_hash_multi_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, FOLKS_TYPE_IM_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 329 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	im_addresses = _tmp0_;
#line 330 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp1_ = folks_im_field_details_new ("im_addresses", NULL);
#line 330 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp2_ = _tmp1_;
#line 330 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	gee_multi_map_set ((GeeMultiMap*) im_addresses, "jabber", _tmp2_);
#line 330 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_g_object_unref0 (_tmp2_);
#line 331 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp3_ = p;
#line 331 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	folks_dummy_full_persona_update_im_addresses (_tmp3_, (GeeMultiMap*) im_addresses);
#line 327 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_g_object_unref0 (im_addresses);
#line 2099 "search-view.c"
}


static void ___lambda16__search_view_tests_generate_persona_func (FolksDummyFullPersona* persona, gpointer self) {
#line 327 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	__lambda16_ ((SearchViewTests*) self, persona);
#line 2106 "search-view.c"
}


static void __lambda17_ (SearchViewTests* self, FolksDummyFullPersona* p) {
	GeeHashSet* phone_numbers = NULL;
	GeeHashSet* _tmp0_ = NULL;
	FolksPhoneFieldDetails* _tmp1_ = NULL;
	FolksPhoneFieldDetails* _tmp2_ = NULL;
	FolksDummyFullPersona* _tmp3_ = NULL;
#line 333 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	g_return_if_fail (p != NULL);
#line 335 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp0_ = gee_hash_set_new (FOLKS_TYPE_PHONE_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
#line 335 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	phone_numbers = _tmp0_;
#line 336 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp1_ = folks_phone_field_details_new ("phone_numbers", NULL);
#line 336 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp2_ = _tmp1_;
#line 336 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) phone_numbers, _tmp2_);
#line 336 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_g_object_unref0 (_tmp2_);
#line 337 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp3_ = p;
#line 337 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	folks_dummy_full_persona_update_phone_numbers (_tmp3_, (GeeSet*) phone_numbers);
#line 333 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_g_object_unref0 (phone_numbers);
#line 2136 "search-view.c"
}


static void ___lambda17__search_view_tests_generate_persona_func (FolksDummyFullPersona* persona, gpointer self) {
#line 333 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	__lambda17_ ((SearchViewTests*) self, persona);
#line 2143 "search-view.c"
}


static void __lambda18_ (SearchViewTests* self, FolksDummyFullPersona* p) {
	GeeHashSet* postal_addresses = NULL;
	GeeHashSet* _tmp0_ = NULL;
	FolksPostalAddress* pa = NULL;
	FolksPostalAddress* _tmp1_ = NULL;
	FolksPostalAddressFieldDetails* _tmp2_ = NULL;
	FolksPostalAddressFieldDetails* _tmp3_ = NULL;
	FolksDummyFullPersona* _tmp4_ = NULL;
#line 339 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	g_return_if_fail (p != NULL);
#line 341 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp0_ = gee_hash_set_new (FOLKS_TYPE_POSTAL_ADDRESS_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
#line 341 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	postal_addresses = _tmp0_;
#line 342 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp1_ = folks_postal_address_new (NULL, NULL, "postal_addresses", NULL, NULL, NULL, NULL, NULL, NULL);
#line 342 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	pa = _tmp1_;
#line 344 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp2_ = folks_postal_address_field_details_new (pa, NULL);
#line 344 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp3_ = _tmp2_;
#line 344 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) postal_addresses, _tmp3_);
#line 344 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_g_object_unref0 (_tmp3_);
#line 345 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp4_ = p;
#line 345 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	folks_dummy_full_persona_update_postal_addresses (_tmp4_, (GeeSet*) postal_addresses);
#line 339 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_g_object_unref0 (pa);
#line 339 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_g_object_unref0 (postal_addresses);
#line 2181 "search-view.c"
}


static void ___lambda18__search_view_tests_generate_persona_func (FolksDummyFullPersona* persona, gpointer self) {
#line 339 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	__lambda18_ ((SearchViewTests*) self, persona);
#line 2188 "search-view.c"
}


static guint _folks_abstract_field_details_hash_static_gee_hash_data_func (gconstpointer v, gpointer self) {
	guint result;
	result = folks_abstract_field_details_hash_static ((FolksAbstractFieldDetails*) v);
#line 349 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	return result;
#line 2197 "search-view.c"
}


static gboolean _folks_abstract_field_details_equal_static_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gboolean result;
	result = folks_abstract_field_details_equal_static ((FolksAbstractFieldDetails*) a, (FolksAbstractFieldDetails*) b);
#line 349 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	return result;
#line 2206 "search-view.c"
}


static void __lambda19_ (SearchViewTests* self, FolksDummyFullPersona* p) {
	GeeHashMultiMap* wsa = NULL;
	GeeHashMultiMap* _tmp0_ = NULL;
	FolksWebServiceFieldDetails* _tmp1_ = NULL;
	FolksWebServiceFieldDetails* _tmp2_ = NULL;
	FolksDummyFullPersona* _tmp3_ = NULL;
#line 347 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	g_return_if_fail (p != NULL);
#line 349 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp0_ = gee_hash_multi_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, FOLKS_TYPE_WEB_SERVICE_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, _folks_abstract_field_details_hash_static_gee_hash_data_func, NULL, NULL, _folks_abstract_field_details_equal_static_gee_equal_data_func, NULL, NULL);
#line 349 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	wsa = _tmp0_;
#line 353 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp1_ = folks_web_service_field_details_new ("web_service_addresses", NULL);
#line 353 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp2_ = _tmp1_;
#line 353 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	gee_multi_map_set ((GeeMultiMap*) wsa, "twitter", _tmp2_);
#line 353 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_g_object_unref0 (_tmp2_);
#line 355 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp3_ = p;
#line 355 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	folks_dummy_full_persona_update_web_service_addresses (_tmp3_, (GeeMultiMap*) wsa);
#line 347 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_g_object_unref0 (wsa);
#line 2236 "search-view.c"
}


static void ___lambda19__search_view_tests_generate_persona_func (FolksDummyFullPersona* persona, gpointer self) {
#line 347 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	__lambda19_ ((SearchViewTests*) self, persona);
#line 2243 "search-view.c"
}


static void __lambda20_ (SearchViewTests* self, FolksDummyFullPersona* p) {
	GeeHashSet* urls = NULL;
	GeeHashSet* _tmp0_ = NULL;
	FolksUrlFieldDetails* _tmp1_ = NULL;
	FolksUrlFieldDetails* _tmp2_ = NULL;
	FolksDummyFullPersona* _tmp3_ = NULL;
#line 357 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	g_return_if_fail (p != NULL);
#line 359 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp0_ = gee_hash_set_new (FOLKS_TYPE_URL_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
#line 359 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	urls = _tmp0_;
#line 360 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp1_ = folks_url_field_details_new ("urls", NULL);
#line 360 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp2_ = _tmp1_;
#line 360 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) urls, _tmp2_);
#line 360 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_g_object_unref0 (_tmp2_);
#line 361 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp3_ = p;
#line 361 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	folks_dummy_full_persona_update_urls (_tmp3_, (GeeSet*) urls);
#line 357 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_g_object_unref0 (urls);
#line 2273 "search-view.c"
}


static void ___lambda20__search_view_tests_generate_persona_func (FolksDummyFullPersona* persona, gpointer self) {
#line 357 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	__lambda20_ ((SearchViewTests*) self, persona);
#line 2280 "search-view.c"
}


static void __lambda21_ (SearchViewTests* self, FolksDummyFullPersona* p) {
	GeeHashSet* groups = NULL;
	GeeHashSet* _tmp0_ = NULL;
	FolksDummyFullPersona* _tmp1_ = NULL;
#line 363 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	g_return_if_fail (p != NULL);
#line 365 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp0_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL, NULL, NULL, NULL);
#line 365 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	groups = _tmp0_;
#line 366 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) groups, "groups");
#line 367 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp1_ = p;
#line 367 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	folks_dummy_full_persona_update_groups (_tmp1_, (GeeSet*) groups);
#line 363 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_g_object_unref0 (groups);
#line 2302 "search-view.c"
}


static void ___lambda21__search_view_tests_generate_persona_func (FolksDummyFullPersona* persona, gpointer self) {
#line 363 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	__lambda21_ ((SearchViewTests*) self, persona);
#line 2309 "search-view.c"
}


static void __lambda22_ (SearchViewTests* self, FolksDummyFullPersona* p) {
	GeeHashSet* notes = NULL;
	GeeHashSet* _tmp0_ = NULL;
	FolksNoteFieldDetails* _tmp1_ = NULL;
	FolksNoteFieldDetails* _tmp2_ = NULL;
	FolksDummyFullPersona* _tmp3_ = NULL;
#line 369 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	g_return_if_fail (p != NULL);
#line 371 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp0_ = gee_hash_set_new (FOLKS_TYPE_NOTE_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
#line 371 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	notes = _tmp0_;
#line 372 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp1_ = folks_note_field_details_new ("notes", NULL, NULL);
#line 372 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp2_ = _tmp1_;
#line 372 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) notes, _tmp2_);
#line 372 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_g_object_unref0 (_tmp2_);
#line 373 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp3_ = p;
#line 373 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	folks_dummy_full_persona_update_notes (_tmp3_, (GeeSet*) notes);
#line 369 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_g_object_unref0 (notes);
#line 2339 "search-view.c"
}


static void ___lambda22__search_view_tests_generate_persona_func (FolksDummyFullPersona* persona, gpointer self) {
#line 369 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	__lambda22_ ((SearchViewTests*) self, persona);
#line 2346 "search-view.c"
}


static void __lambda23_ (SearchViewTests* self, FolksDummyFullPersona* p) {
	GeeHashSet* roles = NULL;
	GeeHashSet* _tmp0_ = NULL;
	FolksRole* role = NULL;
	FolksRole* _tmp1_ = NULL;
	FolksRoleFieldDetails* _tmp2_ = NULL;
	FolksRoleFieldDetails* _tmp3_ = NULL;
	FolksDummyFullPersona* _tmp4_ = NULL;
#line 375 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	g_return_if_fail (p != NULL);
#line 377 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp0_ = gee_hash_set_new (FOLKS_TYPE_ROLE_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
#line 377 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	roles = _tmp0_;
#line 378 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp1_ = folks_role_new ("roles", NULL, NULL);
#line 378 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	role = _tmp1_;
#line 379 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp2_ = folks_role_field_details_new (role, NULL);
#line 379 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp3_ = _tmp2_;
#line 379 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) roles, _tmp3_);
#line 379 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_g_object_unref0 (_tmp3_);
#line 380 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp4_ = p;
#line 380 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	folks_dummy_full_persona_update_roles (_tmp4_, (GeeSet*) roles);
#line 375 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_g_object_unref0 (role);
#line 375 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_g_object_unref0 (roles);
#line 2384 "search-view.c"
}


static void ___lambda23__search_view_tests_generate_persona_func (FolksDummyFullPersona* persona, gpointer self) {
#line 375 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	__lambda23_ ((SearchViewTests*) self, persona);
#line 2391 "search-view.c"
}


static void __lambda24_ (Block3Data* _data3_, GObject* s, GAsyncResult* r) {
	SearchViewTests* self;
	GAsyncResult* _tmp0_ = NULL;
#line 386 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	self = _data3_->self;
#line 386 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	g_return_if_fail (r != NULL);
#line 388 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp0_ = r;
#line 388 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	folks_backend_store_prepare_finish (_data3_->backend_store, _tmp0_);
#line 389 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	g_main_loop_quit (_data3_->main_loop);
#line 2408 "search-view.c"
}


static void ___lambda24__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 386 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	__lambda24_ (self, source_object, res);
#line 386 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	block3_data_unref (self);
#line 2417 "search-view.c"
}


static void __lambda25_ (Block3Data* _data3_, GObject* s, GAsyncResult* r) {
	SearchViewTests* self;
	GError * _inner_error_ = NULL;
#line 399 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	self = _data3_->self;
#line 399 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	g_return_if_fail (r != NULL);
#line 2428 "search-view.c"
	{
		GAsyncResult* _tmp0_ = NULL;
#line 403 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_tmp0_ = r;
#line 403 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		folks_individual_aggregator_prepare_finish (_data3_->aggregator, _tmp0_, &_inner_error_);
#line 403 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2437 "search-view.c"
			goto __catch4_g_error;
		}
#line 404 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		g_main_loop_quit (_data3_->main_loop);
#line 2442 "search-view.c"
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp1_ = NULL;
#line 401 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		e = _inner_error_;
#line 401 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_inner_error_ = NULL;
#line 408 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_tmp1_ = e->message;
#line 408 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		g_error ("search-view.vala:408: Failed to prepare aggregator: %s", _tmp1_);
#line 401 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_g_error_free0 (e);
#line 2459 "search-view.c"
	}
	__finally4:
#line 401 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 401 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 401 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		g_clear_error (&_inner_error_);
#line 401 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		return;
#line 2470 "search-view.c"
	}
}


static void ___lambda25__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 399 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	__lambda25_ (self, source_object, res);
#line 399 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	block3_data_unref (self);
#line 2480 "search-view.c"
}


void search_view_tests_test_match_each_field (SearchViewTests* self) {
	Block3Data* _data3_;
	GMainLoop* _tmp0_ = NULL;
	GeeHashSet* personas = NULL;
	GeeHashSet* _tmp1_ = NULL;
	FolksDummyFullPersona* _tmp2_ = NULL;
	FolksDummyFullPersona* _tmp3_ = NULL;
	FolksDummyFullPersona* _tmp4_ = NULL;
	FolksDummyFullPersona* _tmp5_ = NULL;
	FolksDummyFullPersona* _tmp6_ = NULL;
	FolksDummyFullPersona* _tmp7_ = NULL;
	FolksDummyFullPersona* _tmp8_ = NULL;
	FolksDummyFullPersona* _tmp9_ = NULL;
	FolksDummyFullPersona* _tmp10_ = NULL;
	FolksDummyFullPersona* _tmp11_ = NULL;
	FolksDummyFullPersona* _tmp12_ = NULL;
	FolksDummyFullPersona* _tmp13_ = NULL;
	FolksDummyFullPersona* _tmp14_ = NULL;
	FolksDummyFullPersona* _tmp15_ = NULL;
	FolksDummyFullPersona* _tmp16_ = NULL;
	FolksDummyFullPersona* _tmp17_ = NULL;
	FolksDummyFullPersona* _tmp18_ = NULL;
	FolksDummyFullPersona* _tmp19_ = NULL;
	FolksDummyFullPersona* _tmp20_ = NULL;
	FolksDummyFullPersona* _tmp21_ = NULL;
	FolksDummyFullPersona* _tmp22_ = NULL;
	FolksDummyFullPersona* _tmp23_ = NULL;
	FolksDummyFullPersona* _tmp24_ = NULL;
	FolksDummyFullPersona* _tmp25_ = NULL;
	FolksBackendStore* _tmp26_ = NULL;
	FolksDummyPersonaStore* _tmp27_ = NULL;
	FolksIndividualAggregator* _tmp28_ = NULL;
#line 301 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	g_return_if_fail (self != NULL);
#line 301 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_data3_ = g_slice_new0 (Block3Data);
#line 301 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_data3_->_ref_count_ = 1;
#line 301 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_data3_->self = g_object_ref (self);
#line 303 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp0_ = g_main_loop_new (NULL, FALSE);
#line 303 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_data3_->main_loop = _tmp0_;
#line 309 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp1_ = gee_hash_set_new (FOLKS_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
#line 309 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	personas = _tmp1_;
#line 310 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp2_ = _search_view_tests_generate_test_contact (self, "full-name", ___lambda12__search_view_tests_generate_persona_func, self);
#line 310 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp3_ = _tmp2_;
#line 310 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) personas, (FolksPersona*) _tmp3_);
#line 310 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_g_object_unref0 (_tmp3_);
#line 312 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp4_ = _search_view_tests_generate_test_contact (self, "nickname", ___lambda13__search_view_tests_generate_persona_func, self);
#line 312 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp5_ = _tmp4_;
#line 312 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) personas, (FolksPersona*) _tmp5_);
#line 312 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_g_object_unref0 (_tmp5_);
#line 316 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp6_ = _search_view_tests_generate_test_contact (self, "structured-name", ___lambda14__search_view_tests_generate_persona_func, self);
#line 316 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp7_ = _tmp6_;
#line 316 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) personas, (FolksPersona*) _tmp7_);
#line 316 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_g_object_unref0 (_tmp7_);
#line 321 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp8_ = _search_view_tests_generate_test_contact (self, "email-addresses", ___lambda15__search_view_tests_generate_persona_func, self);
#line 321 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp9_ = _tmp8_;
#line 321 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) personas, (FolksPersona*) _tmp9_);
#line 321 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_g_object_unref0 (_tmp9_);
#line 327 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp10_ = _search_view_tests_generate_test_contact (self, "im-addresses", ___lambda16__search_view_tests_generate_persona_func, self);
#line 327 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp11_ = _tmp10_;
#line 327 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) personas, (FolksPersona*) _tmp11_);
#line 327 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_g_object_unref0 (_tmp11_);
#line 333 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp12_ = _search_view_tests_generate_test_contact (self, "phone-numbers", ___lambda17__search_view_tests_generate_persona_func, self);
#line 333 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp13_ = _tmp12_;
#line 333 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) personas, (FolksPersona*) _tmp13_);
#line 333 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_g_object_unref0 (_tmp13_);
#line 339 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp14_ = _search_view_tests_generate_test_contact (self, "postal-addresses", ___lambda18__search_view_tests_generate_persona_func, self);
#line 339 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp15_ = _tmp14_;
#line 339 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) personas, (FolksPersona*) _tmp15_);
#line 339 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_g_object_unref0 (_tmp15_);
#line 347 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp16_ = _search_view_tests_generate_test_contact (self, "web-service-addresses", ___lambda19__search_view_tests_generate_persona_func, self);
#line 347 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp17_ = _tmp16_;
#line 347 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) personas, (FolksPersona*) _tmp17_);
#line 347 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_g_object_unref0 (_tmp17_);
#line 357 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp18_ = _search_view_tests_generate_test_contact (self, "urls", ___lambda20__search_view_tests_generate_persona_func, self);
#line 357 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp19_ = _tmp18_;
#line 357 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) personas, (FolksPersona*) _tmp19_);
#line 357 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_g_object_unref0 (_tmp19_);
#line 363 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp20_ = _search_view_tests_generate_test_contact (self, "groups", ___lambda21__search_view_tests_generate_persona_func, self);
#line 363 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp21_ = _tmp20_;
#line 363 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) personas, (FolksPersona*) _tmp21_);
#line 363 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_g_object_unref0 (_tmp21_);
#line 369 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp22_ = _search_view_tests_generate_test_contact (self, "notes", ___lambda22__search_view_tests_generate_persona_func, self);
#line 369 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp23_ = _tmp22_;
#line 369 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) personas, (FolksPersona*) _tmp23_);
#line 369 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_g_object_unref0 (_tmp23_);
#line 375 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp24_ = _search_view_tests_generate_test_contact (self, "roles", ___lambda23__search_view_tests_generate_persona_func, self);
#line 375 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp25_ = _tmp24_;
#line 375 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) personas, (FolksPersona*) _tmp25_);
#line 375 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_g_object_unref0 (_tmp25_);
#line 384 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp26_ = folks_backend_store_dup ();
#line 384 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_data3_->backend_store = _tmp26_;
#line 386 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	folks_backend_store_prepare (_data3_->backend_store, ___lambda24__gasync_ready_callback, block3_data_ref (_data3_));
#line 392 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	folks_test_utils_loop_run_with_timeout (_data3_->main_loop, 5);
#line 394 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp27_ = ((DummyTestTestCase*) self)->dummy_persona_store;
#line 394 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	folks_dummy_persona_store_register_personas (_tmp27_, (GeeSet*) personas);
#line 397 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp28_ = folks_individual_aggregator_dup ();
#line 397 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_data3_->aggregator = _tmp28_;
#line 399 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	folks_individual_aggregator_prepare (_data3_->aggregator, ___lambda25__gasync_ready_callback, block3_data_ref (_data3_));
#line 412 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	folks_test_utils_loop_run_with_timeout (_data3_->main_loop, 5);
#line 415 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_search_view_tests_test_match_each_field_search_for_prop_name (self, _data3_->main_loop, _data3_->aggregator, "full-name", "full_name");
#line 417 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_search_view_tests_test_match_each_field_search_for_prop_name (self, _data3_->main_loop, _data3_->aggregator, "nickname", "nickname");
#line 419 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_search_view_tests_test_match_each_field_search_for_prop_name (self, _data3_->main_loop, _data3_->aggregator, "structured-name", "structured_name");
#line 421 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_search_view_tests_test_match_each_field_search_for_prop_name (self, _data3_->main_loop, _data3_->aggregator, "email-addresses", "email_addresses");
#line 423 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_search_view_tests_test_match_each_field_search_for_prop_name (self, _data3_->main_loop, _data3_->aggregator, "im-addresses", "im_addresses");
#line 425 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_search_view_tests_test_match_each_field_search_for_prop_name (self, _data3_->main_loop, _data3_->aggregator, "phone-numbers", "phone_numbers");
#line 427 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_search_view_tests_test_match_each_field_search_for_prop_name (self, _data3_->main_loop, _data3_->aggregator, "postal-addresses", "postal_addresses");
#line 429 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_search_view_tests_test_match_each_field_search_for_prop_name (self, _data3_->main_loop, _data3_->aggregator, "web-service-addresses", "web_service_addresses");
#line 431 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_search_view_tests_test_match_each_field_search_for_prop_name (self, _data3_->main_loop, _data3_->aggregator, "urls", "urls");
#line 433 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_search_view_tests_test_match_each_field_search_for_prop_name (self, _data3_->main_loop, _data3_->aggregator, "notes", "notes");
#line 435 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_search_view_tests_test_match_each_field_search_for_prop_name (self, _data3_->main_loop, _data3_->aggregator, "roles", "roles");
#line 301 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_g_object_unref0 (personas);
#line 301 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	block3_data_unref (_data3_);
#line 301 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_data3_ = NULL;
#line 2676 "search-view.c"
}


static FolksDummyFullPersona* _search_view_tests_generate_test_contact (SearchViewTests* self, const gchar* contact_id, SearchViewTestsGeneratePersonaFunc generate_persona, void* generate_persona_target) {
	FolksDummyFullPersona* result = NULL;
	FolksDummyFullPersona* persona = NULL;
	FolksDummyPersonaStore* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	FolksDummyFullPersona* _tmp4_ = NULL;
	FolksDummyFullPersona* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	SearchViewTestsGeneratePersonaFunc _tmp7_ = NULL;
	void* _tmp7__target = NULL;
#line 441 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 441 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	g_return_val_if_fail (contact_id != NULL, NULL);
#line 444 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp0_ = ((DummyTestTestCase*) self)->dummy_persona_store;
#line 444 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp1_ = contact_id;
#line 444 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp2_ = g_new0 (gchar*, 0 + 1);
#line 444 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp3_ = _tmp2_;
#line 444 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp3__length1 = 0;
#line 444 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp4_ = folks_dummy_full_persona_new (_tmp0_, _tmp1_, FALSE, _tmp3_, 0);
#line 444 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp5_ = _tmp4_;
#line 444 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp3_ = (_vala_array_free (_tmp3_, _tmp3__length1, (GDestroyNotify) g_free), NULL);
#line 444 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	persona = _tmp5_;
#line 446 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp6_ = contact_id;
#line 446 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	folks_dummy_full_persona_update_full_name (persona, _tmp6_);
#line 447 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp7_ = generate_persona;
#line 447 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp7__target = generate_persona_target;
#line 447 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp7_ (persona, _tmp7__target);
#line 449 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	result = persona;
#line 449 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	return result;
#line 2729 "search-view.c"
}


static gpointer _g_main_loop_ref0 (gpointer self) {
#line 452 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	return self ? g_main_loop_ref (self) : NULL;
#line 2736 "search-view.c"
}


static Block4Data* block4_data_ref (Block4Data* _data4_) {
#line 452 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	g_atomic_int_inc (&_data4_->_ref_count_);
#line 452 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	return _data4_;
#line 2745 "search-view.c"
}


static void block4_data_unref (void * _userdata_) {
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
#line 452 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
#line 2754 "search-view.c"
		SearchViewTests* self;
#line 452 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		self = _data4_->self;
#line 452 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_g_object_unref0 (_data4_->search_view);
#line 452 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_g_object_unref0 (_data4_->unexpected_matches);
#line 452 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_g_object_unref0 (_data4_->expected_non_matches);
#line 452 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_g_object_unref0 (_data4_->expected_matches);
#line 452 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_g_main_loop_unref0 (_data4_->main_loop);
#line 452 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_g_object_unref0 (self);
#line 452 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		g_slice_free (Block4Data, _data4_);
#line 2772 "search-view.c"
	}
}


static void __lambda26_ (Block4Data* _data4_, GeeSortedSet* added, GeeSortedSet* removed) {
	SearchViewTests* self;
	GeeSortedSet* _tmp0_ = NULL;
	GMainLoop* _tmp1_ = NULL;
	GeeSortedSet* _tmp2_ = NULL;
	GMainLoop* _tmp3_ = NULL;
#line 465 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	self = _data4_->self;
#line 465 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	g_return_if_fail (added != NULL);
#line 465 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	g_return_if_fail (removed != NULL);
#line 467 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp0_ = added;
#line 467 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp1_ = _data4_->main_loop;
#line 467 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_search_view_tests_individuals_added (self, (GeeCollection*) _tmp0_, _tmp1_, (GeeSet*) _data4_->expected_matches, (GeeSet*) _data4_->expected_non_matches, (GeeSet*) _data4_->unexpected_matches);
#line 469 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp2_ = removed;
#line 469 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp3_ = _data4_->main_loop;
#line 469 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_search_view_tests_individuals_removed (self, (GeeCollection*) _tmp2_, _tmp3_, (GeeSet*) _data4_->expected_matches, (GeeSet*) _data4_->expected_non_matches, (GeeSet*) _data4_->unexpected_matches);
#line 2801 "search-view.c"
}


static void ___lambda26__folks_search_view_individuals_changed_detailed (FolksSearchView* _sender, GeeSortedSet* added, GeeSortedSet* removed, gpointer self) {
#line 465 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	__lambda26_ (self, added, removed);
#line 2808 "search-view.c"
}


static void __lambda27_ (Block4Data* _data4_, GObject* s, GAsyncResult* r) {
	SearchViewTests* self;
	GError * _inner_error_ = NULL;
#line 473 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	self = _data4_->self;
#line 473 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	g_return_if_fail (r != NULL);
#line 2819 "search-view.c"
	{
		GAsyncResult* _tmp0_ = NULL;
#line 477 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_tmp0_ = r;
#line 477 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		folks_search_view_prepare_finish (_data4_->search_view, _tmp0_, &_inner_error_);
#line 477 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2828 "search-view.c"
			goto __catch5_g_error;
		}
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp1_ = NULL;
#line 475 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		e = _inner_error_;
#line 475 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_inner_error_ = NULL;
#line 481 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_tmp1_ = e->message;
#line 481 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		g_error ("search-view.vala:481: Error when calling prepare: %s", _tmp1_);
#line 475 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_g_error_free0 (e);
#line 2847 "search-view.c"
	}
	__finally5:
#line 475 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 475 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 475 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		g_clear_error (&_inner_error_);
#line 475 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		return;
#line 2858 "search-view.c"
	}
}


static void ___lambda27__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 473 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	__lambda27_ (self, source_object, res);
#line 473 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	block4_data_unref (self);
#line 2868 "search-view.c"
}


static void _search_view_tests_test_match_each_field_search_for_prop_name (SearchViewTests* self, GMainLoop* main_loop, FolksIndividualAggregator* aggregator, const gchar* prop_name, const gchar* query) {
	Block4Data* _data4_;
	GMainLoop* _tmp0_ = NULL;
	GMainLoop* _tmp1_ = NULL;
	GeeHashSet* _tmp2_ = NULL;
	GeeHashSet* _tmp3_ = NULL;
	GeeHashSet* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gchar** fields = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar** _tmp8_ = NULL;
	gint fields_length1 = 0;
	gint _fields_size_ = 0;
	FolksSimpleQuery* simple_query = NULL;
	const gchar* _tmp9_ = NULL;
	FolksSimpleQuery* _tmp10_ = NULL;
	FolksIndividualAggregator* _tmp11_ = NULL;
	FolksSearchView* _tmp12_ = NULL;
	gulong handler_id = 0UL;
	gulong _tmp13_ = 0UL;
	GMainLoop* _tmp14_ = NULL;
	gint _tmp15_ = 0;
	gint _tmp16_ = 0;
#line 452 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	g_return_if_fail (self != NULL);
#line 452 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	g_return_if_fail (main_loop != NULL);
#line 452 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	g_return_if_fail (aggregator != NULL);
#line 452 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	g_return_if_fail (prop_name != NULL);
#line 452 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	g_return_if_fail (query != NULL);
#line 452 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_data4_ = g_slice_new0 (Block4Data);
#line 452 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_data4_->_ref_count_ = 1;
#line 452 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_data4_->self = g_object_ref (self);
#line 452 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp0_ = main_loop;
#line 452 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp1_ = _g_main_loop_ref0 (_tmp0_);
#line 452 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_g_main_loop_unref0 (_data4_->main_loop);
#line 452 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_data4_->main_loop = _tmp1_;
#line 455 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp2_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL, NULL, NULL, NULL);
#line 455 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_data4_->expected_matches = _tmp2_;
#line 456 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp3_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL, NULL, NULL, NULL);
#line 456 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_data4_->expected_non_matches = _tmp3_;
#line 457 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp4_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL, NULL, NULL, NULL);
#line 457 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_data4_->unexpected_matches = _tmp4_;
#line 459 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp5_ = prop_name;
#line 459 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _data4_->expected_matches, _tmp5_);
#line 461 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp6_ = prop_name;
#line 461 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp7_ = g_strdup (_tmp6_);
#line 461 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp8_ = g_new0 (gchar*, 1 + 1);
#line 461 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp8_[0] = _tmp7_;
#line 461 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	fields = _tmp8_;
#line 461 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	fields_length1 = 1;
#line 461 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_fields_size_ = fields_length1;
#line 462 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp9_ = query;
#line 462 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp10_ = folks_simple_query_new (_tmp9_, fields, fields_length1);
#line 462 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	simple_query = _tmp10_;
#line 463 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp11_ = aggregator;
#line 463 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp12_ = folks_search_view_new (_tmp11_, (FolksQuery*) simple_query);
#line 463 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_data4_->search_view = _tmp12_;
#line 465 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp13_ = g_signal_connect_data (_data4_->search_view, "individuals-changed-detailed", (GCallback) ___lambda26__folks_search_view_individuals_changed_detailed, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
#line 465 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	handler_id = _tmp13_;
#line 473 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	folks_search_view_prepare (_data4_->search_view, ___lambda27__gasync_ready_callback, block4_data_ref (_data4_));
#line 485 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp14_ = _data4_->main_loop;
#line 485 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	folks_test_utils_loop_run_with_timeout (_tmp14_, 5);
#line 486 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp15_ = gee_abstract_collection_get_size ((GeeCollection*) _data4_->expected_matches);
#line 486 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp16_ = _tmp15_;
#line 486 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_vala_assert (_tmp16_ == 0, "expected_matches.size == 0");
#line 488 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	g_signal_handler_disconnect ((GObject*) _data4_->search_view, handler_id);
#line 452 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_g_object_unref0 (simple_query);
#line 452 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	fields = (_vala_array_free (fields, fields_length1, (GDestroyNotify) g_free), NULL);
#line 452 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	block4_data_unref (_data4_);
#line 452 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_data4_ = NULL;
#line 2988 "search-view.c"
}


static Block5Data* block5_data_ref (Block5Data* _data5_) {
#line 491 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	g_atomic_int_inc (&_data5_->_ref_count_);
#line 491 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	return _data5_;
#line 2997 "search-view.c"
}


static void block5_data_unref (void * _userdata_) {
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
#line 491 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
#line 3006 "search-view.c"
		SearchViewTests* self;
#line 491 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		self = _data5_->self;
#line 491 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_g_object_unref0 (_data5_->backend_store);
#line 491 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_g_main_loop_unref0 (_data5_->main_loop);
#line 491 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_g_object_unref0 (self);
#line 491 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		g_slice_free (Block5Data, _data5_);
#line 3018 "search-view.c"
	}
}


static void __lambda28_ (Block5Data* _data5_, GObject* s, GAsyncResult* r) {
	SearchViewTests* self;
	GAsyncResult* _tmp0_ = NULL;
#line 501 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	self = _data5_->self;
#line 501 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	g_return_if_fail (r != NULL);
#line 503 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp0_ = r;
#line 503 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	folks_backend_store_prepare_finish (_data5_->backend_store, _tmp0_);
#line 504 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	g_main_loop_quit (_data5_->main_loop);
#line 3036 "search-view.c"
}


static void ___lambda28__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 501 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	__lambda28_ (self, source_object, res);
#line 501 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	block5_data_unref (self);
#line 3045 "search-view.c"
}


static void __lambda29_ (Block5Data* _data5_, GObject* s, GAsyncResult* r) {
	SearchViewTests* self;
	GAsyncResult* _tmp0_ = NULL;
#line 525 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	self = _data5_->self;
#line 525 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	g_return_if_fail (r != NULL);
#line 527 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp0_ = r;
#line 527 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_search_view_tests_change_user_names_finish (self, _tmp0_);
#line 528 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	g_main_loop_quit (_data5_->main_loop);
#line 3062 "search-view.c"
}


static void ___lambda29__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 524 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	__lambda29_ (self, source_object, res);
#line 524 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	block5_data_unref (self);
#line 3071 "search-view.c"
}


void search_view_tests_test_individual_changes (SearchViewTests* self) {
	Block5Data* _data5_;
	GMainLoop* _tmp0_ = NULL;
	GeeHashSet* personas = NULL;
	GeeHashSet* _tmp1_ = NULL;
	FolksDummyFullPersona* _tmp2_ = NULL;
	FolksDummyFullPersona* _tmp3_ = NULL;
	FolksDummyPersonaStore* _tmp4_ = NULL;
	FolksBackendStore* _tmp5_ = NULL;
	FolksIndividualAggregator* aggregator = NULL;
	FolksIndividualAggregator* _tmp6_ = NULL;
	FolksSimpleQuery* query = NULL;
	FolksSimpleQuery* _tmp7_ = NULL;
	FolksSearchView* search_view = NULL;
	FolksSimpleQuery* _tmp8_ = NULL;
	FolksSearchView* _tmp9_ = NULL;
	FolksSearchView* _tmp10_ = NULL;
	FolksStructuredName* new_non_matching_name = NULL;
	FolksStructuredName* _tmp11_ = NULL;
	FolksSimpleQuery* _tmp12_ = NULL;
	FolksSimpleQuery* _tmp13_ = NULL;
	FolksSearchView* _tmp14_ = NULL;
	FolksSearchView* _tmp15_ = NULL;
#line 491 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	g_return_if_fail (self != NULL);
#line 491 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_data5_ = g_slice_new0 (Block5Data);
#line 491 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_data5_->_ref_count_ = 1;
#line 491 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_data5_->self = g_object_ref (self);
#line 493 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp0_ = g_main_loop_new (NULL, FALSE);
#line 493 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_data5_->main_loop = _tmp0_;
#line 495 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp1_ = gee_hash_set_new (FOLKS_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
#line 495 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	personas = _tmp1_;
#line 496 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp2_ = _search_view_tests_generate_main_persona (self);
#line 496 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp3_ = _tmp2_;
#line 496 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) personas, (FolksPersona*) _tmp3_);
#line 496 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_g_object_unref0 (_tmp3_);
#line 498 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp4_ = ((DummyTestTestCase*) self)->dummy_persona_store;
#line 498 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	folks_dummy_persona_store_register_personas (_tmp4_, (GeeSet*) personas);
#line 500 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp5_ = folks_backend_store_dup ();
#line 500 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_data5_->backend_store = _tmp5_;
#line 501 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	folks_backend_store_prepare (_data5_->backend_store, ___lambda28__gasync_ready_callback, block5_data_ref (_data5_));
#line 507 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	folks_test_utils_loop_run_with_timeout (_data5_->main_loop, 5);
#line 509 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp6_ = folks_individual_aggregator_dup ();
#line 509 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	aggregator = _tmp6_;
#line 514 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp7_ = folks_simple_query_new (SEARCH_VIEW_TESTS__FULL_NAME_TOKEN, FOLKS_QUERY_MATCH_FIELDS_NAMES, G_N_ELEMENTS (FOLKS_QUERY_MATCH_FIELDS_NAMES));
#line 514 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	query = _tmp7_;
#line 516 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp8_ = query;
#line 516 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp9_ = folks_search_view_new (aggregator, (FolksQuery*) _tmp8_);
#line 516 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	search_view = _tmp9_;
#line 517 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp10_ = search_view;
#line 517 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_search_view_tests_test_search_with_view_async (self, "persona0", NULL, _tmp10_);
#line 522 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp11_ = folks_structured_name_new ("Cat", "Stimpson", "J.", NULL, NULL);
#line 522 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	new_non_matching_name = _tmp11_;
#line 524 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_search_view_tests_change_user_names (self, SEARCH_VIEW_TESTS__FULL_NAME, new_non_matching_name, aggregator, ___lambda29__gasync_ready_callback, block5_data_ref (_data5_));
#line 531 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	folks_test_utils_loop_run_with_timeout (_data5_->main_loop, 5);
#line 533 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp12_ = folks_simple_query_new (SEARCH_VIEW_TESTS__FULL_NAME_TOKEN, FOLKS_QUERY_MATCH_FIELDS_NAMES, G_N_ELEMENTS (FOLKS_QUERY_MATCH_FIELDS_NAMES));
#line 533 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_g_object_unref0 (query);
#line 533 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	query = _tmp12_;
#line 535 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp13_ = query;
#line 535 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp14_ = folks_search_view_new (aggregator, (FolksQuery*) _tmp13_);
#line 535 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_g_object_unref0 (search_view);
#line 535 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	search_view = _tmp14_;
#line 536 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp15_ = search_view;
#line 536 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_search_view_tests_test_search_with_view_async (self, NULL, "persona0", _tmp15_);
#line 491 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_g_object_unref0 (new_non_matching_name);
#line 491 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_g_object_unref0 (search_view);
#line 491 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_g_object_unref0 (query);
#line 491 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_g_object_unref0 (aggregator);
#line 491 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_g_object_unref0 (personas);
#line 491 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	block5_data_unref (_data5_);
#line 491 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_data5_ = NULL;
#line 3192 "search-view.c"
}


static Block6Data* block6_data_ref (Block6Data* _data6_) {
#line 539 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	g_atomic_int_inc (&_data6_->_ref_count_);
#line 539 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	return _data6_;
#line 3201 "search-view.c"
}


static void block6_data_unref (void * _userdata_) {
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
#line 539 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
#line 3210 "search-view.c"
		SearchViewTests* self;
#line 539 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		self = _data6_->self;
#line 539 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_g_object_unref0 (_data6_->backend_store);
#line 539 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_g_main_loop_unref0 (_data6_->main_loop);
#line 539 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_g_object_unref0 (self);
#line 539 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		g_slice_free (Block6Data, _data6_);
#line 3222 "search-view.c"
	}
}


static void __lambda30_ (Block6Data* _data6_, GObject* s, GAsyncResult* r) {
	SearchViewTests* self;
	GAsyncResult* _tmp0_ = NULL;
#line 549 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	self = _data6_->self;
#line 549 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	g_return_if_fail (r != NULL);
#line 551 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp0_ = r;
#line 551 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	folks_backend_store_prepare_finish (_data6_->backend_store, _tmp0_);
#line 552 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	g_main_loop_quit (_data6_->main_loop);
#line 3240 "search-view.c"
}


static void ___lambda30__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 549 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	__lambda30_ (self, source_object, res);
#line 549 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	block6_data_unref (self);
#line 3249 "search-view.c"
}


void search_view_tests_test_query_changes (SearchViewTests* self) {
	Block6Data* _data6_;
	GMainLoop* _tmp0_ = NULL;
	GeeHashSet* personas = NULL;
	GeeHashSet* _tmp1_ = NULL;
	FolksDummyFullPersona* _tmp2_ = NULL;
	FolksDummyFullPersona* _tmp3_ = NULL;
	FolksDummyPersonaStore* _tmp4_ = NULL;
	FolksBackendStore* _tmp5_ = NULL;
	FolksIndividualAggregator* aggregator = NULL;
	FolksIndividualAggregator* _tmp6_ = NULL;
	FolksSimpleQuery* query = NULL;
	FolksSimpleQuery* _tmp7_ = NULL;
	FolksSearchView* search_view = NULL;
	FolksSearchView* _tmp8_ = NULL;
	FolksSimpleQuery* _tmp9_ = NULL;
	FolksSimpleQuery* _tmp10_ = NULL;
	FolksSimpleQuery* _tmp11_ = NULL;
	FolksSimpleQuery* _tmp12_ = NULL;
	FolksQuery* _tmp13_ = NULL;
	FolksQuery* _tmp14_ = NULL;
	FolksQuery* _tmp15_ = NULL;
	FolksQuery* _tmp16_ = NULL;
#line 539 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	g_return_if_fail (self != NULL);
#line 539 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_data6_ = g_slice_new0 (Block6Data);
#line 539 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_data6_->_ref_count_ = 1;
#line 539 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_data6_->self = g_object_ref (self);
#line 541 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp0_ = g_main_loop_new (NULL, FALSE);
#line 541 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_data6_->main_loop = _tmp0_;
#line 543 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp1_ = gee_hash_set_new (FOLKS_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
#line 543 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	personas = _tmp1_;
#line 544 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp2_ = _search_view_tests_generate_main_persona (self);
#line 544 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp3_ = _tmp2_;
#line 544 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) personas, (FolksPersona*) _tmp3_);
#line 544 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_g_object_unref0 (_tmp3_);
#line 546 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp4_ = ((DummyTestTestCase*) self)->dummy_persona_store;
#line 546 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	folks_dummy_persona_store_register_personas (_tmp4_, (GeeSet*) personas);
#line 548 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp5_ = folks_backend_store_dup ();
#line 548 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_data6_->backend_store = _tmp5_;
#line 549 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	folks_backend_store_prepare (_data6_->backend_store, ___lambda30__gasync_ready_callback, block6_data_ref (_data6_));
#line 555 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	folks_test_utils_loop_run_with_timeout (_data6_->main_loop, 5);
#line 557 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp6_ = folks_individual_aggregator_dup ();
#line 557 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	aggregator = _tmp6_;
#line 562 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp7_ = folks_simple_query_new (SEARCH_VIEW_TESTS__FULL_NAME_TOKEN, FOLKS_QUERY_MATCH_FIELDS_NAMES, G_N_ELEMENTS (FOLKS_QUERY_MATCH_FIELDS_NAMES));
#line 562 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	query = _tmp7_;
#line 564 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp8_ = folks_search_view_new (aggregator, (FolksQuery*) query);
#line 564 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	search_view = _tmp8_;
#line 565 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_search_view_tests_test_search_with_view_async (self, "persona0", NULL, search_view);
#line 570 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp9_ = folks_simple_query_new (SEARCH_VIEW_TESTS__NON_MATCHING_PARTIAL_NAME, FOLKS_QUERY_MATCH_FIELDS_NAMES, G_N_ELEMENTS (FOLKS_QUERY_MATCH_FIELDS_NAMES));
#line 570 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp10_ = _tmp9_;
#line 570 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	folks_search_view_set_query (search_view, (FolksQuery*) _tmp10_);
#line 570 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_g_object_unref0 (_tmp10_);
#line 572 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_search_view_tests_test_search_with_view_async (self, NULL, "persona0", search_view);
#line 578 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp11_ = folks_simple_query_new (SEARCH_VIEW_TESTS__FULL_NAME_PREFIX, FOLKS_QUERY_MATCH_FIELDS_NAMES, G_N_ELEMENTS (FOLKS_QUERY_MATCH_FIELDS_NAMES));
#line 578 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp12_ = _tmp11_;
#line 578 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	folks_search_view_set_query (search_view, (FolksQuery*) _tmp12_);
#line 578 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_g_object_unref0 (_tmp12_);
#line 580 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_search_view_tests_test_search_with_view_async (self, "persona0", NULL, search_view);
#line 585 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp13_ = folks_search_view_get_query (search_view);
#line 585 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp14_ = _tmp13_;
#line 585 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	folks_simple_query_set_query_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, FOLKS_TYPE_SIMPLE_QUERY, FolksSimpleQuery), SEARCH_VIEW_TESTS__NON_MATCHING_PARTIAL_NAME);
#line 587 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_search_view_tests_test_search_with_view_async (self, NULL, "persona0", search_view);
#line 592 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp15_ = folks_search_view_get_query (search_view);
#line 592 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp16_ = _tmp15_;
#line 592 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	folks_simple_query_set_query_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, FOLKS_TYPE_SIMPLE_QUERY, FolksSimpleQuery), SEARCH_VIEW_TESTS__FULL_NAME_PREFIX);
#line 594 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_search_view_tests_test_search_with_view_async (self, "persona0", NULL, search_view);
#line 539 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_g_object_unref0 (search_view);
#line 539 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_g_object_unref0 (query);
#line 539 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_g_object_unref0 (aggregator);
#line 539 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_g_object_unref0 (personas);
#line 539 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	block6_data_unref (_data6_);
#line 539 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_data6_ = NULL;
#line 3374 "search-view.c"
}


static void _search_view_tests_individuals_added (SearchViewTests* self, GeeCollection* added, GMainLoop* main_loop, GeeSet* expected_matches, GeeSet* expected_non_matches, GeeSet* unexpected_matches) {
#line 597 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	g_return_if_fail (self != NULL);
#line 597 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	g_return_if_fail (added != NULL);
#line 597 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	g_return_if_fail (main_loop != NULL);
#line 597 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	g_return_if_fail (expected_matches != NULL);
#line 597 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	g_return_if_fail (expected_non_matches != NULL);
#line 597 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	g_return_if_fail (unexpected_matches != NULL);
#line 3391 "search-view.c"
	{
		GeeIterator* _i_it = NULL;
		GeeCollection* _tmp0_ = NULL;
		GeeIterator* _tmp1_ = NULL;
#line 601 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_tmp0_ = added;
#line 601 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_tmp1_ = gee_iterable_iterator ((GeeIterable*) _tmp0_);
#line 601 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_i_it = _tmp1_;
#line 601 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		while (TRUE) {
#line 3404 "search-view.c"
			GeeIterator* _tmp2_ = NULL;
			gboolean _tmp3_ = FALSE;
			FolksIndividual* i = NULL;
			GeeIterator* _tmp4_ = NULL;
			gpointer _tmp5_ = NULL;
			FolksIndividual* _tmp6_ = NULL;
			GeeSet* _tmp7_ = NULL;
			GeeSet* _tmp8_ = NULL;
			gint _tmp9_ = 0;
			gint _tmp10_ = 0;
#line 601 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
			_tmp2_ = _i_it;
#line 601 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
			_tmp3_ = gee_iterator_next (_tmp2_);
#line 601 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
			if (!_tmp3_) {
#line 601 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
				break;
#line 3423 "search-view.c"
			}
#line 601 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
			_tmp4_ = _i_it;
#line 601 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
			_tmp5_ = gee_iterator_get (_tmp4_);
#line 601 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
			i = (FolksIndividual*) _tmp5_;
#line 603 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
			_tmp6_ = i;
#line 603 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
			_tmp7_ = folks_individual_get_personas (_tmp6_);
#line 603 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
			_tmp8_ = _tmp7_;
#line 603 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
			_tmp9_ = gee_collection_get_size ((GeeCollection*) _tmp8_);
#line 603 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
			_tmp10_ = _tmp9_;
#line 603 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
			_vala_assert (_tmp10_ == 1, "i.personas.size == 1");
#line 3443 "search-view.c"
			{
				GeeIterator* _persona_it = NULL;
				FolksIndividual* _tmp11_ = NULL;
				GeeSet* _tmp12_ = NULL;
				GeeSet* _tmp13_ = NULL;
				GeeIterator* _tmp14_ = NULL;
#line 608 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
				_tmp11_ = i;
#line 608 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
				_tmp12_ = folks_individual_get_personas (_tmp11_);
#line 608 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
				_tmp13_ = _tmp12_;
#line 608 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
				_tmp14_ = gee_iterable_iterator ((GeeIterable*) _tmp13_);
#line 608 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
				_persona_it = _tmp14_;
#line 608 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
				while (TRUE) {
#line 3462 "search-view.c"
					GeeIterator* _tmp15_ = NULL;
					gboolean _tmp16_ = FALSE;
					FolksPersona* persona = NULL;
					GeeIterator* _tmp17_ = NULL;
					gpointer _tmp18_ = NULL;
					gboolean removed_expected = FALSE;
					GeeSet* _tmp19_ = NULL;
					FolksPersona* _tmp20_ = NULL;
					const gchar* _tmp21_ = NULL;
					const gchar* _tmp22_ = NULL;
					gboolean _tmp23_ = FALSE;
					gboolean _tmp33_ = FALSE;
					gboolean _tmp34_ = FALSE;
#line 608 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
					_tmp15_ = _persona_it;
#line 608 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
					_tmp16_ = gee_iterator_next (_tmp15_);
#line 608 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
					if (!_tmp16_) {
#line 608 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
						break;
#line 3484 "search-view.c"
					}
#line 608 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
					_tmp17_ = _persona_it;
#line 608 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
					_tmp18_ = gee_iterator_get (_tmp17_);
#line 608 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
					persona = (FolksPersona*) _tmp18_;
#line 610 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
					removed_expected = FALSE;
#line 612 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
					_tmp19_ = expected_matches;
#line 612 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
					_tmp20_ = persona;
#line 612 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
					_tmp21_ = folks_persona_get_display_id (_tmp20_);
#line 612 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
					_tmp22_ = _tmp21_;
#line 612 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
					_tmp23_ = gee_collection_contains ((GeeCollection*) _tmp19_, _tmp22_);
#line 612 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
					if (_tmp23_) {
#line 3506 "search-view.c"
						GeeSet* _tmp24_ = NULL;
						FolksPersona* _tmp25_ = NULL;
						const gchar* _tmp26_ = NULL;
						const gchar* _tmp27_ = NULL;
						gboolean _tmp28_ = FALSE;
#line 614 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
						_tmp24_ = expected_matches;
#line 614 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
						_tmp25_ = persona;
#line 614 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
						_tmp26_ = folks_persona_get_display_id (_tmp25_);
#line 614 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
						_tmp27_ = _tmp26_;
#line 614 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
						_tmp28_ = gee_collection_remove ((GeeCollection*) _tmp24_, _tmp27_);
#line 614 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
						removed_expected = _tmp28_;
#line 3524 "search-view.c"
					} else {
						GeeSet* _tmp29_ = NULL;
						FolksPersona* _tmp30_ = NULL;
						const gchar* _tmp31_ = NULL;
						const gchar* _tmp32_ = NULL;
#line 619 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
						_tmp29_ = unexpected_matches;
#line 619 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
						_tmp30_ = persona;
#line 619 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
						_tmp31_ = folks_persona_get_display_id (_tmp30_);
#line 619 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
						_tmp32_ = _tmp31_;
#line 619 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
						gee_collection_add ((GeeCollection*) _tmp29_, _tmp32_);
#line 3540 "search-view.c"
					}
#line 622 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
					_tmp34_ = removed_expected;
#line 622 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
					if (_tmp34_) {
#line 3546 "search-view.c"
						GeeSet* _tmp35_ = NULL;
						gint _tmp36_ = 0;
						gint _tmp37_ = 0;
#line 622 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
						_tmp35_ = expected_matches;
#line 622 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
						_tmp36_ = gee_collection_get_size ((GeeCollection*) _tmp35_);
#line 622 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
						_tmp37_ = _tmp36_;
#line 622 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
						_tmp33_ = _tmp37_ == 0;
#line 3558 "search-view.c"
					} else {
#line 622 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
						_tmp33_ = FALSE;
#line 3562 "search-view.c"
					}
#line 622 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
					if (_tmp33_) {
#line 3566 "search-view.c"
						GMainLoop* _tmp38_ = NULL;
#line 623 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
						_tmp38_ = main_loop;
#line 623 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
						g_main_loop_quit (_tmp38_);
#line 3572 "search-view.c"
					}
#line 608 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
					_g_object_unref0 (persona);
#line 3576 "search-view.c"
				}
#line 608 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
				_g_object_unref0 (_persona_it);
#line 3580 "search-view.c"
			}
#line 601 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
			_g_object_unref0 (i);
#line 3584 "search-view.c"
		}
#line 601 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_g_object_unref0 (_i_it);
#line 3588 "search-view.c"
	}
}


static void _search_view_tests_individuals_removed (SearchViewTests* self, GeeCollection* removed, GMainLoop* main_loop, GeeSet* expected_matches, GeeSet* expected_non_matches, GeeSet* unexpected_matches) {
#line 628 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	g_return_if_fail (self != NULL);
#line 628 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	g_return_if_fail (removed != NULL);
#line 628 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	g_return_if_fail (main_loop != NULL);
#line 628 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	g_return_if_fail (expected_matches != NULL);
#line 628 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	g_return_if_fail (expected_non_matches != NULL);
#line 628 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	g_return_if_fail (unexpected_matches != NULL);
#line 3606 "search-view.c"
	{
		GeeIterator* _i_it = NULL;
		GeeCollection* _tmp0_ = NULL;
		GeeIterator* _tmp1_ = NULL;
#line 632 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_tmp0_ = removed;
#line 632 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_tmp1_ = gee_iterable_iterator ((GeeIterable*) _tmp0_);
#line 632 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_i_it = _tmp1_;
#line 632 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		while (TRUE) {
#line 3619 "search-view.c"
			GeeIterator* _tmp2_ = NULL;
			gboolean _tmp3_ = FALSE;
			FolksIndividual* i = NULL;
			GeeIterator* _tmp4_ = NULL;
			gpointer _tmp5_ = NULL;
			FolksIndividual* _tmp6_ = NULL;
			GeeSet* _tmp7_ = NULL;
			GeeSet* _tmp8_ = NULL;
			gint _tmp9_ = 0;
			gint _tmp10_ = 0;
#line 632 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
			_tmp2_ = _i_it;
#line 632 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
			_tmp3_ = gee_iterator_next (_tmp2_);
#line 632 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
			if (!_tmp3_) {
#line 632 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
				break;
#line 3638 "search-view.c"
			}
#line 632 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
			_tmp4_ = _i_it;
#line 632 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
			_tmp5_ = gee_iterator_get (_tmp4_);
#line 632 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
			i = (FolksIndividual*) _tmp5_;
#line 634 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
			_tmp6_ = i;
#line 634 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
			_tmp7_ = folks_individual_get_personas (_tmp6_);
#line 634 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
			_tmp8_ = _tmp7_;
#line 634 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
			_tmp9_ = gee_collection_get_size ((GeeCollection*) _tmp8_);
#line 634 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
			_tmp10_ = _tmp9_;
#line 634 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
			_vala_assert (_tmp10_ == 1, "i.personas.size == 1");
#line 3658 "search-view.c"
			{
				GeeIterator* _persona_it = NULL;
				FolksIndividual* _tmp11_ = NULL;
				GeeSet* _tmp12_ = NULL;
				GeeSet* _tmp13_ = NULL;
				GeeIterator* _tmp14_ = NULL;
#line 639 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
				_tmp11_ = i;
#line 639 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
				_tmp12_ = folks_individual_get_personas (_tmp11_);
#line 639 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
				_tmp13_ = _tmp12_;
#line 639 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
				_tmp14_ = gee_iterable_iterator ((GeeIterable*) _tmp13_);
#line 639 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
				_persona_it = _tmp14_;
#line 639 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
				while (TRUE) {
#line 3677 "search-view.c"
					GeeIterator* _tmp15_ = NULL;
					gboolean _tmp16_ = FALSE;
					FolksPersona* persona = NULL;
					GeeIterator* _tmp17_ = NULL;
					gpointer _tmp18_ = NULL;
					GeeSet* _tmp19_ = NULL;
					FolksPersona* _tmp20_ = NULL;
					const gchar* _tmp21_ = NULL;
					const gchar* _tmp22_ = NULL;
#line 639 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
					_tmp15_ = _persona_it;
#line 639 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
					_tmp16_ = gee_iterator_next (_tmp15_);
#line 639 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
					if (!_tmp16_) {
#line 639 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
						break;
#line 3695 "search-view.c"
					}
#line 639 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
					_tmp17_ = _persona_it;
#line 639 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
					_tmp18_ = gee_iterator_get (_tmp17_);
#line 639 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
					persona = (FolksPersona*) _tmp18_;
#line 648 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
					_tmp19_ = unexpected_matches;
#line 648 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
					_tmp20_ = persona;
#line 648 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
					_tmp21_ = folks_persona_get_display_id (_tmp20_);
#line 648 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
					_tmp22_ = _tmp21_;
#line 648 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
					gee_collection_remove ((GeeCollection*) _tmp19_, _tmp22_);
#line 639 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
					_g_object_unref0 (persona);
#line 3715 "search-view.c"
				}
#line 639 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
				_g_object_unref0 (_persona_it);
#line 3719 "search-view.c"
			}
#line 632 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
			_g_object_unref0 (i);
#line 3723 "search-view.c"
		}
#line 632 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_g_object_unref0 (_i_it);
#line 3727 "search-view.c"
	}
}


static FolksDummyFullPersona* _search_view_tests_generate_main_persona (SearchViewTests* self) {
	FolksDummyFullPersona* result = NULL;
	FolksDummyFullPersona* persona = NULL;
	FolksDummyPersonaStore* _tmp0_ = NULL;
	gchar** _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	FolksDummyFullPersona* _tmp3_ = NULL;
	FolksDummyFullPersona* _tmp4_ = NULL;
	GeeHashSet* email_addresses = NULL;
	GeeHashSet* _tmp5_ = NULL;
	FolksEmailFieldDetails* _tmp6_ = NULL;
	FolksEmailFieldDetails* _tmp7_ = NULL;
	GeeHashSet* phone_numbers = NULL;
	GeeHashSet* _tmp8_ = NULL;
	FolksPhoneFieldDetails* _tmp9_ = NULL;
	FolksPhoneFieldDetails* _tmp10_ = NULL;
#line 654 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 657 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp0_ = ((DummyTestTestCase*) self)->dummy_persona_store;
#line 657 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp1_ = g_new0 (gchar*, 0 + 1);
#line 657 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp2_ = _tmp1_;
#line 657 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp2__length1 = 0;
#line 657 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp3_ = folks_dummy_full_persona_new (_tmp0_, "persona0", FALSE, _tmp2_, 0);
#line 657 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp4_ = _tmp3_;
#line 657 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp2_ = (_vala_array_free (_tmp2_, _tmp2__length1, (GDestroyNotify) g_free), NULL);
#line 657 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	persona = _tmp4_;
#line 660 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	folks_dummy_full_persona_update_full_name (persona, SEARCH_VIEW_TESTS__FULL_NAME);
#line 661 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	folks_dummy_full_persona_update_nickname (persona, "Duchess");
#line 663 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp5_ = gee_hash_set_new (FOLKS_TYPE_EMAIL_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
#line 663 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	email_addresses = _tmp5_;
#line 664 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp6_ = folks_email_field_details_new ("sterling@isis.secret", NULL);
#line 664 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp7_ = _tmp6_;
#line 664 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) email_addresses, _tmp7_);
#line 664 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_g_object_unref0 (_tmp7_);
#line 665 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	folks_dummy_full_persona_update_email_addresses (persona, (GeeSet*) email_addresses);
#line 667 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp8_ = gee_hash_set_new (FOLKS_TYPE_PHONE_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
#line 667 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	phone_numbers = _tmp8_;
#line 668 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp9_ = folks_phone_field_details_new (SEARCH_VIEW_TESTS__PHONE_NUMBER, NULL);
#line 668 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp10_ = _tmp9_;
#line 668 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) phone_numbers, _tmp10_);
#line 668 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_g_object_unref0 (_tmp10_);
#line 669 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	folks_dummy_full_persona_update_phone_numbers (persona, (GeeSet*) phone_numbers);
#line 671 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	result = persona;
#line 671 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_g_object_unref0 (phone_numbers);
#line 671 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_g_object_unref0 (email_addresses);
#line 671 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	return result;
#line 3807 "search-view.c"
}


static void _search_view_tests_change_user_names_data_free (gpointer _data) {
	SearchViewTestsChangeUserNamesData* _data_;
	_data_ = _data;
#line 25 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_g_free0 (_data_->expected_full_name);
#line 25 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_g_object_unref0 (_data_->non_matching_structured_name);
#line 25 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_g_object_unref0 (_data_->aggregator);
#line 25 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_g_object_unref0 (_data_->self);
#line 25 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	g_slice_free (SearchViewTestsChangeUserNamesData, _data_);
#line 3824 "search-view.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 25 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	return self ? g_object_ref (self) : NULL;
#line 3831 "search-view.c"
}


static void _search_view_tests_change_user_names (SearchViewTests* self, const gchar* expected_full_name, FolksStructuredName* non_matching_structured_name, FolksIndividualAggregator* aggregator, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SearchViewTestsChangeUserNamesData* _data_;
	SearchViewTests* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	FolksStructuredName* _tmp3_ = NULL;
	FolksStructuredName* _tmp4_ = NULL;
	FolksIndividualAggregator* _tmp5_ = NULL;
	FolksIndividualAggregator* _tmp6_ = NULL;
#line 25 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_data_ = g_slice_new0 (SearchViewTestsChangeUserNamesData);
#line 25 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, _search_view_tests_change_user_names);
#line 25 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, _search_view_tests_change_user_names_data_free);
#line 25 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 25 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_data_->self = _tmp0_;
#line 25 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp1_ = expected_full_name;
#line 25 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 25 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_g_free0 (_data_->expected_full_name);
#line 25 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_data_->expected_full_name = _tmp2_;
#line 25 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp3_ = non_matching_structured_name;
#line 25 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 25 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_g_object_unref0 (_data_->non_matching_structured_name);
#line 25 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_data_->non_matching_structured_name = _tmp4_;
#line 25 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp5_ = aggregator;
#line 25 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp6_ = _g_object_ref0 (_tmp5_);
#line 25 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_g_object_unref0 (_data_->aggregator);
#line 25 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_data_->aggregator = _tmp6_;
#line 25 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_search_view_tests_change_user_names_co (_data_);
#line 3880 "search-view.c"
}


static void _search_view_tests_change_user_names_finish (SearchViewTests* self, GAsyncResult* _res_) {
	SearchViewTestsChangeUserNamesData* _data_;
#line 25 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 3888 "search-view.c"
}


static void _search_view_tests_change_user_names_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	SearchViewTestsChangeUserNamesData* _data_;
#line 697 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_data_ = _user_data_;
#line 697 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_data_->_source_object_ = source_object;
#line 697 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_data_->_res_ = _res_;
#line 697 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_search_view_tests_change_user_names_co (_data_);
#line 3902 "search-view.c"
}


static gboolean _search_view_tests_change_user_names_co (SearchViewTestsChangeUserNamesData* _data_) {
#line 674 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	switch (_data_->_state_) {
#line 674 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		case 0:
#line 3911 "search-view.c"
		goto _state_0;
#line 674 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		case 1:
#line 3915 "search-view.c"
		goto _state_1;
#line 674 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		case 2:
#line 3919 "search-view.c"
		goto _state_2;
		default:
#line 674 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		g_assert_not_reached ();
#line 3924 "search-view.c"
	}
	_state_0:
#line 679 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_data_->_tmp0_ = NULL;
#line 679 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_data_->_tmp0_ = _data_->non_matching_structured_name;
#line 679 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_data_->_tmp1_ = NULL;
#line 679 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_data_->_tmp1_ = folks_structured_name_get_given_name (_data_->_tmp0_);
#line 679 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_data_->_tmp2_ = NULL;
#line 679 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_data_->_tmp2_ = _data_->_tmp1_;
#line 679 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_data_->_tmp3_ = NULL;
#line 679 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_data_->_tmp3_ = _data_->non_matching_structured_name;
#line 679 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_data_->_tmp4_ = NULL;
#line 679 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_data_->_tmp4_ = folks_structured_name_get_additional_names (_data_->_tmp3_);
#line 679 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_data_->_tmp5_ = NULL;
#line 679 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_data_->_tmp5_ = _data_->_tmp4_;
#line 679 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_data_->_tmp6_ = NULL;
#line 679 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_data_->_tmp6_ = _data_->non_matching_structured_name;
#line 679 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_data_->_tmp7_ = NULL;
#line 679 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_data_->_tmp7_ = folks_structured_name_get_family_name (_data_->_tmp6_);
#line 679 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_data_->_tmp8_ = NULL;
#line 679 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_data_->_tmp8_ = _data_->_tmp7_;
#line 679 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_data_->_tmp9_ = NULL;
#line 679 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_data_->_tmp9_ = g_strdup_printf ("%s %s %s", _data_->_tmp2_, _data_->_tmp5_, _data_->_tmp8_);
#line 679 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_data_->non_matching_full_name = _data_->_tmp9_;
#line 3969 "search-view.c"
	{
#line 684 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_data_->_tmp10_ = NULL;
#line 684 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_data_->_tmp10_ = _data_->aggregator;
#line 684 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_data_->_tmp11_ = NULL;
#line 684 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_data_->_tmp11_ = folks_individual_aggregator_get_individuals (_data_->_tmp10_);
#line 684 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_data_->_tmp12_ = NULL;
#line 684 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_data_->_tmp12_ = _data_->_tmp11_;
#line 684 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_data_->_tmp13_ = NULL;
#line 684 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_data_->_tmp13_ = gee_map_get_values (_data_->_tmp12_);
#line 684 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_data_->_tmp14_ = NULL;
#line 684 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_data_->_tmp14_ = _data_->_tmp13_;
#line 684 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_data_->_tmp15_ = NULL;
#line 684 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_data_->_tmp15_ = _data_->_tmp14_;
#line 684 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_data_->_tmp16_ = NULL;
#line 684 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_data_->_tmp16_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp15_);
#line 684 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_data_->_tmp17_ = NULL;
#line 684 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_data_->_tmp17_ = _data_->_tmp16_;
#line 684 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_g_object_unref0 (_data_->_tmp15_);
#line 684 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_data_->_individual_it = _data_->_tmp17_;
#line 684 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		while (TRUE) {
#line 684 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
			_data_->_tmp18_ = NULL;
#line 684 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
			_data_->_tmp18_ = _data_->_individual_it;
#line 684 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
			_data_->_tmp19_ = FALSE;
#line 684 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
			_data_->_tmp19_ = gee_iterator_next (_data_->_tmp18_);
#line 684 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
			if (!_data_->_tmp19_) {
#line 684 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
				break;
#line 4021 "search-view.c"
			}
#line 684 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
			_data_->_tmp20_ = NULL;
#line 684 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
			_data_->_tmp20_ = _data_->_individual_it;
#line 684 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
			_data_->_tmp21_ = NULL;
#line 684 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
			_data_->_tmp21_ = gee_iterator_get (_data_->_tmp20_);
#line 684 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
			_data_->individual = (FolksIndividual*) _data_->_tmp21_;
#line 686 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
			_data_->_tmp22_ = NULL;
#line 686 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
			_data_->_tmp22_ = _data_->individual;
#line 686 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
			_data_->_tmp23_ = NULL;
#line 686 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
			_data_->_tmp23_ = folks_name_details_get_full_name ((FolksNameDetails*) _data_->_tmp22_);
#line 686 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
			_data_->_tmp24_ = NULL;
#line 686 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
			_data_->_tmp24_ = _data_->_tmp23_;
#line 686 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
			_data_->_tmp25_ = NULL;
#line 686 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
			_data_->_tmp25_ = _data_->expected_full_name;
#line 686 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
			if (g_strcmp0 (_data_->_tmp24_, _data_->_tmp25_) != 0) {
#line 687 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
				_g_object_unref0 (_data_->individual);
#line 687 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
				continue;
#line 4055 "search-view.c"
			}
			{
#line 690 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
				_data_->_tmp26_ = NULL;
#line 690 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
				_data_->_tmp26_ = _data_->individual;
#line 690 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
				_data_->_tmp27_ = NULL;
#line 690 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
				_data_->_tmp27_ = folks_individual_get_personas (_data_->_tmp26_);
#line 690 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
				_data_->_tmp28_ = NULL;
#line 690 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
				_data_->_tmp28_ = _data_->_tmp27_;
#line 690 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
				_data_->_tmp29_ = NULL;
#line 690 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
				_data_->_tmp29_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp28_);
#line 690 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
				_data_->_persona_it = _data_->_tmp29_;
#line 690 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
				while (TRUE) {
#line 690 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
					_data_->_tmp30_ = NULL;
#line 690 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
					_data_->_tmp30_ = _data_->_persona_it;
#line 690 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
					_data_->_tmp31_ = FALSE;
#line 690 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
					_data_->_tmp31_ = gee_iterator_next (_data_->_tmp30_);
#line 690 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
					if (!_data_->_tmp31_) {
#line 690 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
						break;
#line 4090 "search-view.c"
					}
#line 690 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
					_data_->_tmp32_ = NULL;
#line 690 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
					_data_->_tmp32_ = _data_->_persona_it;
#line 690 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
					_data_->_tmp33_ = NULL;
#line 690 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
					_data_->_tmp33_ = gee_iterator_get (_data_->_tmp32_);
#line 690 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
					_data_->persona = (FolksPersona*) _data_->_tmp33_;
#line 692 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
					_data_->_tmp34_ = NULL;
#line 692 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
					_data_->_tmp34_ = _data_->persona;
#line 692 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
					_data_->_tmp35_ = NULL;
#line 692 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
					_data_->_tmp35_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp34_, FOLKS_TYPE_NAME_DETAILS) ? ((FolksNameDetails*) _data_->_tmp34_) : NULL);
#line 692 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
					_data_->name_details = _data_->_tmp35_;
#line 693 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
					_data_->_tmp36_ = NULL;
#line 693 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
					_data_->_tmp36_ = _data_->name_details;
#line 693 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
					_vala_assert (_data_->_tmp36_ != NULL, "name_details != null");
#line 4118 "search-view.c"
					{
#line 697 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
						_data_->_tmp37_ = NULL;
#line 697 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
						_data_->_tmp37_ = _data_->name_details;
#line 697 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
						_data_->_tmp38_ = NULL;
#line 697 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
						_data_->_tmp38_ = _data_->non_matching_full_name;
#line 697 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
						_data_->_state_ = 1;
#line 697 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
						folks_name_details_change_full_name (_data_->_tmp37_, _data_->_tmp38_, _search_view_tests_change_user_names_ready, _data_);
#line 697 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
						return FALSE;
#line 4134 "search-view.c"
						_state_1:
#line 697 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
						folks_name_details_change_full_name_finish (_data_->_tmp37_, _data_->_res_, &_data_->_inner_error_);
#line 697 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
						if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 697 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
							if (_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR) {
#line 4142 "search-view.c"
								goto __catch6_folks_property_error;
							}
#line 697 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
							_g_object_unref0 (_data_->name_details);
#line 697 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
							_g_object_unref0 (_data_->persona);
#line 697 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
							_g_object_unref0 (_data_->_persona_it);
#line 697 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
							_g_object_unref0 (_data_->individual);
#line 697 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
							_g_object_unref0 (_data_->_individual_it);
#line 697 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
							_g_free0 (_data_->non_matching_full_name);
#line 697 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
							g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 697 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
							g_clear_error (&_data_->_inner_error_);
#line 697 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
							return FALSE;
#line 4163 "search-view.c"
						}
#line 699 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
						_data_->_tmp39_ = NULL;
#line 699 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
						_data_->_tmp39_ = _data_->name_details;
#line 699 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
						_data_->_tmp40_ = NULL;
#line 699 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
						_data_->_tmp40_ = _data_->non_matching_structured_name;
#line 699 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
						_data_->_state_ = 2;
#line 699 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
						folks_name_details_change_structured_name (_data_->_tmp39_, _data_->_tmp40_, _search_view_tests_change_user_names_ready, _data_);
#line 699 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
						return FALSE;
#line 4179 "search-view.c"
						_state_2:
#line 699 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
						folks_name_details_change_structured_name_finish (_data_->_tmp39_, _data_->_res_, &_data_->_inner_error_);
#line 699 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
						if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 699 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
							if (_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR) {
#line 4187 "search-view.c"
								goto __catch6_folks_property_error;
							}
#line 699 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
							_g_object_unref0 (_data_->name_details);
#line 699 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
							_g_object_unref0 (_data_->persona);
#line 699 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
							_g_object_unref0 (_data_->_persona_it);
#line 699 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
							_g_object_unref0 (_data_->individual);
#line 699 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
							_g_object_unref0 (_data_->_individual_it);
#line 699 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
							_g_free0 (_data_->non_matching_full_name);
#line 699 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
							g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 699 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
							g_clear_error (&_data_->_inner_error_);
#line 699 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
							return FALSE;
#line 4208 "search-view.c"
						}
#line 701 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
						_g_object_unref0 (_data_->name_details);
#line 701 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
						_g_object_unref0 (_data_->persona);
#line 701 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
						_g_object_unref0 (_data_->_persona_it);
#line 701 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
						_g_object_unref0 (_data_->individual);
#line 701 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
						_g_object_unref0 (_data_->_individual_it);
#line 701 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
						_g_free0 (_data_->non_matching_full_name);
#line 701 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
						if (_data_->_state_ == 0) {
#line 701 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
							g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 4226 "search-view.c"
						} else {
#line 701 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
							g_simple_async_result_complete (_data_->_async_result);
#line 4230 "search-view.c"
						}
#line 701 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
						g_object_unref (_data_->_async_result);
#line 701 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
						return FALSE;
#line 4236 "search-view.c"
					}
					goto __finally6;
					__catch6_folks_property_error:
					{
#line 695 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
						_data_->e = _data_->_inner_error_;
#line 695 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
						_data_->_inner_error_ = NULL;
#line 705 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
						_data_->_tmp41_ = NULL;
#line 705 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
						_data_->_tmp41_ = _data_->e->message;
#line 705 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
						g_error ("search-view.vala:705: %s", _data_->_tmp41_);
#line 695 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
						_g_error_free0 (_data_->e);
#line 4253 "search-view.c"
					}
					__finally6:
#line 695 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
					_g_object_unref0 (_data_->name_details);
#line 695 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
					_g_object_unref0 (_data_->persona);
#line 695 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
					_g_object_unref0 (_data_->_persona_it);
#line 695 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
					_g_object_unref0 (_data_->individual);
#line 695 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
					_g_object_unref0 (_data_->_individual_it);
#line 695 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
					_g_free0 (_data_->non_matching_full_name);
#line 695 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 695 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
					g_clear_error (&_data_->_inner_error_);
#line 695 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
					return FALSE;
#line 4274 "search-view.c"
				}
#line 690 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
				_g_object_unref0 (_data_->_persona_it);
#line 4278 "search-view.c"
			}
#line 684 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
			_g_object_unref0 (_data_->individual);
#line 4282 "search-view.c"
		}
#line 684 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_g_object_unref0 (_data_->_individual_it);
#line 4286 "search-view.c"
	}
#line 710 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	g_assert_not_reached ();
#line 674 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_g_free0 (_data_->non_matching_full_name);
#line 674 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	if (_data_->_state_ == 0) {
#line 674 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 4296 "search-view.c"
	} else {
#line 674 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 4300 "search-view.c"
	}
#line 674 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	g_object_unref (_data_->_async_result);
#line 674 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	return FALSE;
#line 4306 "search-view.c"
}


static Block7Data* block7_data_ref (Block7Data* _data7_) {
#line 713 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	g_atomic_int_inc (&_data7_->_ref_count_);
#line 713 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	return _data7_;
#line 4315 "search-view.c"
}


static void block7_data_unref (void * _userdata_) {
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
#line 713 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
#line 4324 "search-view.c"
		SearchViewTests* self;
#line 713 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		self = _data7_->self;
#line 713 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_g_object_unref0 (_data7_->unexpected_matches);
#line 713 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_g_object_unref0 (_data7_->expected_non_matches);
#line 713 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_g_object_unref0 (_data7_->expected_matches);
#line 713 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_g_main_loop_unref0 (_data7_->main_loop);
#line 713 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_g_object_unref0 (_data7_->search_view);
#line 713 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_g_object_unref0 (self);
#line 713 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		g_slice_free (Block7Data, _data7_);
#line 4342 "search-view.c"
	}
}


static void __lambda10_ (Block7Data* _data7_, GeeSortedSet* added, GeeSortedSet* removed) {
	SearchViewTests* self;
	GeeSortedSet* _tmp0_ = NULL;
	GMainLoop* _tmp1_ = NULL;
	GeeHashSet* _tmp2_ = NULL;
	GeeHashSet* _tmp3_ = NULL;
	GeeHashSet* _tmp4_ = NULL;
	GeeSortedSet* _tmp5_ = NULL;
	GMainLoop* _tmp6_ = NULL;
	GeeHashSet* _tmp7_ = NULL;
	GeeHashSet* _tmp8_ = NULL;
	GeeHashSet* _tmp9_ = NULL;
#line 728 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	self = _data7_->self;
#line 728 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	g_return_if_fail (added != NULL);
#line 728 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	g_return_if_fail (removed != NULL);
#line 730 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp0_ = added;
#line 730 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp1_ = _data7_->main_loop;
#line 730 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp2_ = _data7_->expected_matches;
#line 730 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp3_ = _data7_->expected_non_matches;
#line 730 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp4_ = _data7_->unexpected_matches;
#line 730 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_search_view_tests_individuals_added (self, (GeeCollection*) _tmp0_, _tmp1_, (GeeSet*) _tmp2_, (GeeSet*) _tmp3_, (GeeSet*) _tmp4_);
#line 732 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp5_ = removed;
#line 732 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp6_ = _data7_->main_loop;
#line 732 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp7_ = _data7_->expected_matches;
#line 732 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp8_ = _data7_->expected_non_matches;
#line 732 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp9_ = _data7_->unexpected_matches;
#line 732 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_search_view_tests_individuals_removed (self, (GeeCollection*) _tmp5_, _tmp6_, (GeeSet*) _tmp7_, (GeeSet*) _tmp8_, (GeeSet*) _tmp9_);
#line 4389 "search-view.c"
}


static void ___lambda10__folks_search_view_individuals_changed_detailed (FolksSearchView* _sender, GeeSortedSet* added, GeeSortedSet* removed, gpointer self) {
#line 728 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	__lambda10_ (self, added, removed);
#line 4396 "search-view.c"
}


static void __lambda11_ (Block7Data* _data7_, GObject* s, GAsyncResult* r) {
	SearchViewTests* self;
	GError * _inner_error_ = NULL;
#line 741 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	self = _data7_->self;
#line 741 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	g_return_if_fail (r != NULL);
#line 4407 "search-view.c"
	{
		FolksSearchView* _tmp0_ = NULL;
		GAsyncResult* _tmp1_ = NULL;
		GeeHashSet* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
#line 745 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_tmp0_ = _data7_->search_view;
#line 745 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_tmp1_ = r;
#line 745 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		folks_search_view_prepare_finish (_tmp0_, _tmp1_, &_inner_error_);
#line 745 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 4422 "search-view.c"
			goto __catch7_g_error;
		}
#line 746 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_data7_->is_prepared = TRUE;
#line 748 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_tmp2_ = _data7_->expected_matches;
#line 748 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_tmp3_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp2_);
#line 748 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_tmp4_ = _tmp3_;
#line 748 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		if (_tmp4_ == 0) {
#line 4435 "search-view.c"
			GMainLoop* _tmp5_ = NULL;
#line 749 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
			_tmp5_ = _data7_->main_loop;
#line 749 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
			g_main_loop_quit (_tmp5_);
#line 4441 "search-view.c"
		}
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp6_ = NULL;
#line 743 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		e = _inner_error_;
#line 743 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_inner_error_ = NULL;
#line 753 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_tmp6_ = e->message;
#line 753 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		g_error ("search-view.vala:753: Error when calling prepare: %s", _tmp6_);
#line 743 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_g_error_free0 (e);
#line 4459 "search-view.c"
	}
	__finally7:
#line 743 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 743 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 743 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		g_clear_error (&_inner_error_);
#line 743 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		return;
#line 4470 "search-view.c"
	}
}


static void ___lambda11__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 741 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	__lambda11_ (self, source_object, res);
#line 741 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	block7_data_unref (self);
#line 4480 "search-view.c"
}


static void _search_view_tests_test_search_with_view_async (SearchViewTests* self, const gchar* expected_match_display_id, const gchar* expected_non_match_display_id, FolksSearchView* search_view) {
	Block7Data* _data7_;
	FolksSearchView* _tmp0_ = NULL;
	FolksSearchView* _tmp1_ = NULL;
	GMainLoop* _tmp2_ = NULL;
	GeeHashSet* _tmp3_ = NULL;
	GeeHashSet* _tmp4_ = NULL;
	GeeHashSet* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp9_ = NULL;
	gulong handler_id = 0UL;
	FolksSearchView* _tmp12_ = NULL;
	gulong _tmp13_ = 0UL;
	FolksSearchView* _tmp14_ = NULL;
	GeeSortedSet* _tmp15_ = NULL;
	GeeSortedSet* _tmp16_ = NULL;
	GMainLoop* _tmp17_ = NULL;
	GeeHashSet* _tmp18_ = NULL;
	GeeHashSet* _tmp19_ = NULL;
	GeeHashSet* _tmp20_ = NULL;
	FolksSearchView* _tmp21_ = NULL;
	gboolean _tmp22_ = FALSE;
	GeeHashSet* _tmp23_ = NULL;
	gint _tmp24_ = 0;
	gint _tmp25_ = 0;
	GeeHashSet* _tmp28_ = NULL;
	gint _tmp29_ = 0;
	gint _tmp30_ = 0;
	FolksSearchView* _tmp40_ = NULL;
	gulong _tmp41_ = 0UL;
#line 713 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	g_return_if_fail (self != NULL);
#line 713 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	g_return_if_fail (search_view != NULL);
#line 713 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_data7_ = g_slice_new0 (Block7Data);
#line 713 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_data7_->_ref_count_ = 1;
#line 713 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_data7_->self = g_object_ref (self);
#line 713 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp0_ = search_view;
#line 713 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 713 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_g_object_unref0 (_data7_->search_view);
#line 713 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_data7_->search_view = _tmp1_;
#line 718 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp2_ = g_main_loop_new (NULL, FALSE);
#line 718 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_data7_->main_loop = _tmp2_;
#line 719 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp3_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL, NULL, NULL, NULL);
#line 719 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_data7_->expected_matches = _tmp3_;
#line 720 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp4_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL, NULL, NULL, NULL);
#line 720 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_data7_->expected_non_matches = _tmp4_;
#line 721 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp5_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL, NULL, NULL, NULL);
#line 721 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_data7_->unexpected_matches = _tmp5_;
#line 723 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp6_ = expected_match_display_id;
#line 723 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	if (_tmp6_ != NULL) {
#line 4552 "search-view.c"
		GeeHashSet* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
#line 724 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_tmp7_ = _data7_->expected_matches;
#line 724 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_tmp8_ = expected_match_display_id;
#line 724 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp7_, _tmp8_);
#line 4561 "search-view.c"
	}
#line 725 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp9_ = expected_non_match_display_id;
#line 725 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	if (_tmp9_ != NULL) {
#line 4567 "search-view.c"
		GeeHashSet* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
#line 726 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_tmp10_ = _data7_->expected_non_matches;
#line 726 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_tmp11_ = expected_non_match_display_id;
#line 726 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp10_, _tmp11_);
#line 4576 "search-view.c"
	}
#line 728 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp12_ = _data7_->search_view;
#line 728 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp13_ = g_signal_connect_data (_tmp12_, "individuals-changed-detailed", (GCallback) ___lambda10__folks_search_view_individuals_changed_detailed, block7_data_ref (_data7_), (GClosureNotify) block7_data_unref, 0);
#line 728 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	handler_id = _tmp13_;
#line 737 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp14_ = _data7_->search_view;
#line 737 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp15_ = folks_search_view_get_individuals (_tmp14_);
#line 737 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp16_ = _tmp15_;
#line 737 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp17_ = _data7_->main_loop;
#line 737 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp18_ = _data7_->expected_matches;
#line 737 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp19_ = _data7_->expected_non_matches;
#line 737 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp20_ = _data7_->unexpected_matches;
#line 737 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_search_view_tests_individuals_added (self, (GeeCollection*) _tmp16_, _tmp17_, (GeeSet*) _tmp18_, (GeeSet*) _tmp19_, (GeeSet*) _tmp20_);
#line 740 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_data7_->is_prepared = FALSE;
#line 741 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp21_ = _data7_->search_view;
#line 741 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	folks_search_view_prepare (_tmp21_, ___lambda11__gasync_ready_callback, block7_data_ref (_data7_));
#line 757 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp23_ = _data7_->expected_matches;
#line 757 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp24_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp23_);
#line 757 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp25_ = _tmp24_;
#line 757 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	if (_tmp25_ > 0) {
#line 757 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_tmp22_ = TRUE;
#line 4616 "search-view.c"
	} else {
		gboolean _tmp26_ = FALSE;
#line 757 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_tmp26_ = _data7_->is_prepared;
#line 757 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_tmp22_ = !_tmp26_;
#line 4623 "search-view.c"
	}
#line 757 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	if (_tmp22_) {
#line 4627 "search-view.c"
		GMainLoop* _tmp27_ = NULL;
#line 758 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_tmp27_ = _data7_->main_loop;
#line 758 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		folks_test_utils_loop_run_with_timeout (_tmp27_, 5);
#line 4633 "search-view.c"
	}
#line 760 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp28_ = _data7_->expected_matches;
#line 760 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp29_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp28_);
#line 760 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp30_ = _tmp29_;
#line 760 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_vala_assert (_tmp30_ == 0, "expected_matches.size == 0");
#line 4643 "search-view.c"
	{
		GeeIterator* _unexpected_match_it = NULL;
		GeeHashSet* _tmp31_ = NULL;
		GeeIterator* _tmp32_ = NULL;
#line 761 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_tmp31_ = _data7_->unexpected_matches;
#line 761 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_tmp32_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp31_);
#line 761 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_unexpected_match_it = _tmp32_;
#line 761 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		while (TRUE) {
#line 4656 "search-view.c"
			GeeIterator* _tmp33_ = NULL;
			gboolean _tmp34_ = FALSE;
			gchar* unexpected_match = NULL;
			GeeIterator* _tmp35_ = NULL;
			gpointer _tmp36_ = NULL;
			GeeHashSet* _tmp37_ = NULL;
			const gchar* _tmp38_ = NULL;
			gboolean _tmp39_ = FALSE;
#line 761 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
			_tmp33_ = _unexpected_match_it;
#line 761 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
			_tmp34_ = gee_iterator_next (_tmp33_);
#line 761 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
			if (!_tmp34_) {
#line 761 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
				break;
#line 4673 "search-view.c"
			}
#line 761 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
			_tmp35_ = _unexpected_match_it;
#line 761 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
			_tmp36_ = gee_iterator_get (_tmp35_);
#line 761 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
			unexpected_match = (gchar*) _tmp36_;
#line 762 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
			_tmp37_ = _data7_->expected_non_matches;
#line 762 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
			_tmp38_ = unexpected_match;
#line 762 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
			_tmp39_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp37_, _tmp38_);
#line 762 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
			_vala_assert (!_tmp39_, "!(unexpected_match in expected_non_matches)");
#line 761 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
			_g_free0 (unexpected_match);
#line 4691 "search-view.c"
		}
#line 761 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
		_g_object_unref0 (_unexpected_match_it);
#line 4695 "search-view.c"
	}
#line 764 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp40_ = _data7_->search_view;
#line 764 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp41_ = handler_id;
#line 764 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	g_signal_handler_disconnect ((GObject*) _tmp40_, _tmp41_);
#line 713 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	block7_data_unref (_data7_);
#line 713 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_data7_ = NULL;
#line 4707 "search-view.c"
}


static SearchViewTestsSimpleTestVector* search_view_tests_simple_test_vector_dup (const SearchViewTestsSimpleTestVector* self) {
	SearchViewTestsSimpleTestVector* dup;
#line 54 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	dup = g_new0 (SearchViewTestsSimpleTestVector, 1);
#line 54 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	memcpy (dup, self, sizeof (SearchViewTestsSimpleTestVector));
#line 54 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	return dup;
#line 4719 "search-view.c"
}


static void search_view_tests_simple_test_vector_free (SearchViewTestsSimpleTestVector* self) {
#line 54 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	g_free (self);
#line 4726 "search-view.c"
}


static GType search_view_tests_simple_test_vector_get_type (void) {
	static volatile gsize search_view_tests_simple_test_vector_type_id__volatile = 0;
	if (g_once_init_enter (&search_view_tests_simple_test_vector_type_id__volatile)) {
		GType search_view_tests_simple_test_vector_type_id;
		search_view_tests_simple_test_vector_type_id = g_boxed_type_register_static ("SearchViewTestsSimpleTestVector", (GBoxedCopyFunc) search_view_tests_simple_test_vector_dup, (GBoxedFreeFunc) search_view_tests_simple_test_vector_free);
		g_once_init_leave (&search_view_tests_simple_test_vector_type_id__volatile, search_view_tests_simple_test_vector_type_id);
	}
	return search_view_tests_simple_test_vector_type_id__volatile;
}


static void search_view_tests_class_init (SearchViewTestsClass * klass) {
#line 25 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	search_view_tests_parent_class = g_type_class_peek_parent (klass);
#line 25 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	((DummyTestTestCaseClass *) klass)->configure_primary_store = search_view_tests_real_configure_primary_store;
#line 4746 "search-view.c"
}


static void search_view_tests_instance_init (SearchViewTests * self) {
}


GType search_view_tests_get_type (void) {
	static volatile gsize search_view_tests_type_id__volatile = 0;
	if (g_once_init_enter (&search_view_tests_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SearchViewTestsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) search_view_tests_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SearchViewTests), 0, (GInstanceInitFunc) search_view_tests_instance_init, NULL };
		GType search_view_tests_type_id;
		search_view_tests_type_id = g_type_register_static (DUMMY_TEST_TYPE_TEST_CASE, "SearchViewTests", &g_define_type_info, 0);
		g_once_init_leave (&search_view_tests_type_id__volatile, search_view_tests_type_id);
	}
	return search_view_tests_type_id__volatile;
}


gint _vala_main (gchar** args, int args_length1) {
	gint result = 0;
	SearchViewTests* tests = NULL;
	SearchViewTests* _tmp0_ = NULL;
#line 770 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	g_test_init (&args_length1, &args, NULL);
#line 772 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_tmp0_ = search_view_tests_new ();
#line 772 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	tests = _tmp0_;
#line 773 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	folks_test_case_register ((FolksTestCase*) tests);
#line 774 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	g_test_run ();
#line 775 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	folks_test_case_final_tear_down ((FolksTestCase*) tests);
#line 777 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	result = 0;
#line 777 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	_g_object_unref0 (tests);
#line 777 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	return result;
#line 4788 "search-view.c"
}


int main (int argc, char ** argv) {
#if !GLIB_CHECK_VERSION (2,35,0)
	g_type_init ();
#endif
#line 768 "/opt/gnome3/source/folks/tests/dummy/search-view.vala"
	return _vala_main (argv, argc);
#line 4798 "search-view.c"
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



