/* test-serializer.c generated by valac 0.27.1.15-b1df0, the Vala compiler
 * generated from test-serializer.vala, do not modify */

/*
 * Copyright (C) 2012 Arth Patel
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <locale.h>


#define TYPE_SERIALIZER (serializer_get_type ())
#define SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SERIALIZER, Serializer))
#define SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SERIALIZER, SerializerClass))
#define IS_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SERIALIZER))
#define IS_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SERIALIZER))
#define SERIALIZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SERIALIZER, SerializerClass))

typedef struct _Serializer Serializer;
typedef struct _SerializerClass SerializerClass;

#define TYPE_NUMBER (number_get_type ())
#define NUMBER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NUMBER, Number))
#define NUMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NUMBER, NumberClass))
#define IS_NUMBER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NUMBER))
#define IS_NUMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NUMBER))
#define NUMBER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NUMBER, NumberClass))

typedef struct _Number Number;
typedef struct _NumberClass NumberClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_DISPLAY_FORMAT (display_format_get_type ())

typedef enum  {
	DISPLAY_FORMAT_AUTOMATIC,
	DISPLAY_FORMAT_FIXED,
	DISPLAY_FORMAT_SCIENTIFIC,
	DISPLAY_FORMAT_ENGINEERING
} DisplayFormat;


extern gint fail_count;
gint fail_count = 0;
extern gint pass_count;
gint pass_count = 0;

#define thousand_separator ","
#define radix_string "."
void pass (const gchar* text);
void fail (const gchar* text);
GType serializer_get_type (void) G_GNUC_CONST;
void test_number (Serializer* s, const gchar* number, gint base_value, gint representation_base, const gchar* expected_string);
GType number_get_type (void) G_GNUC_CONST;
Number* mp_set_from_string (const gchar* str, gint default_base);
void serializer_set_base (Serializer* self, gint number_base);
void serializer_set_representation_base (Serializer* self, guint representation_base);
gchar* serializer_to_string (Serializer* self, Number* x);
void test_fixed (Serializer* s);
GType display_format_get_type (void) G_GNUC_CONST;
void serializer_set_number_format (Serializer* self, DisplayFormat format);
void test_automatic (Serializer* s);
void test_scientific (Serializer* s);
void test_engineering (Serializer* s);
void test_base_conversion (Serializer* s);
gint _vala_main (gchar** args, int args_length1);
Serializer* serializer_new (DisplayFormat format, gint number_base, gint trailing_digits);
Serializer* serializer_construct (GType object_type, DisplayFormat format, gint number_base, gint trailing_digits);
void serializer_set_thousands_separator (Serializer* self, gunichar separator);
void serializer_set_radix (Serializer* self, gunichar radix);
void serializer_set_show_thousands_separators (Serializer* self, gboolean visible);
void serializer_set_thousands_separator_count (Serializer* self, gint count);


void pass (const gchar* text) {
	gint _tmp0_ = 0;
#line 19 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	_tmp0_ = pass_count;
#line 19 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	pass_count = _tmp0_ + 1;
#line 93 "test-serializer.c"
}


void fail (const gchar* text) {
	FILE* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
#line 22 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	g_return_if_fail (text != NULL);
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	_tmp0_ = stdout;
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	_tmp1_ = text;
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	fprintf (_tmp0_, "*FAIL: %s\n", _tmp1_);
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	_tmp2_ = fail_count;
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	fail_count = _tmp2_ + 1;
#line 113 "test-serializer.c"
}


void test_number (Serializer* s, const gchar* number, gint base_value, gint representation_base, const gchar* expected_string) {
	Number* n = NULL;
	const gchar* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	Number* _tmp2_ = NULL;
	Serializer* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	Serializer* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	Serializer* _tmp7_ = NULL;
	Number* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	gboolean _tmp12_ = FALSE;
#line 28 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	g_return_if_fail (s != NULL);
#line 28 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	g_return_if_fail (number != NULL);
#line 28 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	g_return_if_fail (expected_string != NULL);
#line 30 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	_tmp0_ = number;
#line 30 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	_tmp1_ = base_value;
#line 30 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	_tmp2_ = mp_set_from_string (_tmp0_, _tmp1_);
#line 30 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	n = _tmp2_;
#line 31 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	_tmp3_ = s;
#line 31 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	_tmp4_ = base_value;
#line 31 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	serializer_set_base (_tmp3_, _tmp4_);
#line 32 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	_tmp5_ = s;
#line 32 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	_tmp6_ = representation_base;
#line 32 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	serializer_set_representation_base (_tmp5_, (guint) _tmp6_);
#line 33 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	_tmp7_ = s;
#line 33 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	_tmp8_ = n;
#line 33 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	_tmp9_ = serializer_to_string (_tmp7_, _tmp8_);
#line 33 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	_tmp10_ = _tmp9_;
#line 33 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	_tmp11_ = expected_string;
#line 33 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	_tmp12_ = g_strcmp0 (_tmp10_, _tmp11_) == 0;
#line 33 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	_g_free0 (_tmp10_);
#line 33 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	if (_tmp12_) {
#line 34 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
		pass (NULL);
#line 176 "test-serializer.c"
	} else {
		Serializer* _tmp13_ = NULL;
		Number* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
		gchar* _tmp18_ = NULL;
		gchar* _tmp19_ = NULL;
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
		_tmp13_ = s;
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
		_tmp14_ = n;
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
		_tmp15_ = serializer_to_string (_tmp13_, _tmp14_);
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
		_tmp16_ = _tmp15_;
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
		_tmp17_ = expected_string;
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
		_tmp18_ = g_strdup_printf ("Serializer returned (%s) => expected value (%s)", _tmp16_, _tmp17_);
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
		_tmp19_ = _tmp18_;
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
		fail (_tmp19_);
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
		_g_free0 (_tmp19_);
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
		_g_free0 (_tmp16_);
#line 205 "test-serializer.c"
	}
#line 28 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	_g_object_unref0 (n);
#line 209 "test-serializer.c"
}


void test_fixed (Serializer* s) {
	Serializer* _tmp0_ = NULL;
	Serializer* _tmp1_ = NULL;
	Serializer* _tmp2_ = NULL;
	Serializer* _tmp3_ = NULL;
	Serializer* _tmp4_ = NULL;
	Serializer* _tmp5_ = NULL;
	Serializer* _tmp6_ = NULL;
	Serializer* _tmp7_ = NULL;
	Serializer* _tmp8_ = NULL;
#line 39 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	g_return_if_fail (s != NULL);
#line 41 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	_tmp0_ = s;
#line 41 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	serializer_set_number_format (_tmp0_, DISPLAY_FORMAT_FIXED);
#line 43 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	_tmp1_ = s;
#line 43 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	test_number (_tmp1_, "123456789012345678901234", 10, 10, "123,456,789,012,345,678,901,234");
#line 44 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	_tmp2_ = s;
#line 44 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	test_number (_tmp2_, "0.1234567890123456789012", 10, 10, "0.123456789");
#line 45 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	_tmp3_ = s;
#line 45 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	test_number (_tmp3_, "101010101010101010101010", 2, 2, "101010101010101010101010");
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	_tmp4_ = s;
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	test_number (_tmp4_, "0.1010101010101010101010", 2, 2, "0.101010101");
#line 47 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	_tmp5_ = s;
#line 47 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	test_number (_tmp5_, "123456701234567012345670", 8, 8, "123456701234567012345670");
#line 48 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	_tmp6_ = s;
#line 48 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	test_number (_tmp6_, "0.1234567012345670123456", 8, 8, "0.123456701");
#line 49 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	_tmp7_ = s;
#line 49 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	test_number (_tmp7_, "123456789ABCDEF012345678", 16, 16, "123456789ABCDEF012345678");
#line 50 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	_tmp8_ = s;
#line 50 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	test_number (_tmp8_, "0.ABCDEF0123456789ABCDEF", 16, 16, "0.ABCDEF012");
#line 261 "test-serializer.c"
}


void test_automatic (Serializer* s) {
	Serializer* _tmp0_ = NULL;
	Serializer* _tmp1_ = NULL;
	Serializer* _tmp2_ = NULL;
	Serializer* _tmp3_ = NULL;
	Serializer* _tmp4_ = NULL;
	Serializer* _tmp5_ = NULL;
	Serializer* _tmp6_ = NULL;
	Serializer* _tmp7_ = NULL;
	Serializer* _tmp8_ = NULL;
	Serializer* _tmp9_ = NULL;
	Serializer* _tmp10_ = NULL;
	Serializer* _tmp11_ = NULL;
	Serializer* _tmp12_ = NULL;
	Serializer* _tmp13_ = NULL;
	Serializer* _tmp14_ = NULL;
	Serializer* _tmp15_ = NULL;
	Serializer* _tmp16_ = NULL;
#line 53 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	g_return_if_fail (s != NULL);
#line 55 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	_tmp0_ = s;
#line 55 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	serializer_set_number_format (_tmp0_, DISPLAY_FORMAT_AUTOMATIC);
#line 57 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	_tmp1_ = s;
#line 57 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	test_number (_tmp1_, "0.10", 10, 10, "0.1");
#line 58 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	_tmp2_ = s;
#line 58 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	test_number (_tmp2_, "0.12345678901234567890", 10, 10, "0.123456789");
#line 59 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	_tmp3_ = s;
#line 59 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	test_number (_tmp3_, "123456789012", 10, 10, "123,456,789,012");
#line 60 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	_tmp4_ = s;
#line 60 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	test_number (_tmp4_, "12345678901234567890", 10, 10, "1.23456789×10¹⁹");
#line 62 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	_tmp5_ = s;
#line 62 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	test_number (_tmp5_, ".10", 2, 2, "0.1");
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	_tmp6_ = s;
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	test_number (_tmp6_, "0.10101010101010101010", 2, 2, "0.101010101");
#line 64 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	_tmp7_ = s;
#line 64 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	test_number (_tmp7_, "1010101010101010101010101010101010101010101010101010101010101010", 2, 2, "1010101010101010101010101010101010101010101010101010101010101010");
#line 65 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	_tmp8_ = s;
#line 65 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	test_number (_tmp8_, "10101010101010101010101010101010101010101010101010101010101010101", 2, 2, "1.010101011×10⁶⁴");
#line 67 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	_tmp9_ = s;
#line 67 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	test_number (_tmp9_, "0.10", 8, 8, "0.1");
#line 68 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	_tmp10_ = s;
#line 68 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	test_number (_tmp10_, "0.12345670123456701234", 8, 8, "0.123456701");
#line 69 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	_tmp11_ = s;
#line 69 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	test_number (_tmp11_, "1234567012345670123456", 8, 8, "1234567012345670123456");
#line 70 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	_tmp12_ = s;
#line 70 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	test_number (_tmp12_, "12345670123456701234567", 8, 8, "1.234567012×10²²");
#line 72 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	_tmp13_ = s;
#line 72 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	test_number (_tmp13_, "0.10", 16, 16, "0.1");
#line 73 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	_tmp14_ = s;
#line 73 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	test_number (_tmp14_, "0.123456789ABCDEF01234", 16, 16, "0.12345678A");
#line 74 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	_tmp15_ = s;
#line 74 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	test_number (_tmp15_, "123456789ABCDEF0", 16, 16, "123456789ABCDEF0");
#line 75 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	_tmp16_ = s;
#line 75 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	test_number (_tmp16_, "123456789ABCEDF01", 16, 16, "1.23456789B×10¹⁶");
#line 353 "test-serializer.c"
}


void test_scientific (Serializer* s) {
	Serializer* _tmp0_ = NULL;
	Serializer* _tmp1_ = NULL;
	Serializer* _tmp2_ = NULL;
	Serializer* _tmp3_ = NULL;
	Serializer* _tmp4_ = NULL;
	Serializer* _tmp5_ = NULL;
	Serializer* _tmp6_ = NULL;
	Serializer* _tmp7_ = NULL;
	Serializer* _tmp8_ = NULL;
	Serializer* _tmp9_ = NULL;
	Serializer* _tmp10_ = NULL;
	Serializer* _tmp11_ = NULL;
#line 78 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	g_return_if_fail (s != NULL);
#line 80 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	_tmp0_ = s;
#line 80 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	serializer_set_number_format (_tmp0_, DISPLAY_FORMAT_SCIENTIFIC);
#line 82 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	_tmp1_ = s;
#line 82 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	test_number (_tmp1_, "1", 10, 10, "1");
#line 83 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	_tmp2_ = s;
#line 83 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	test_number (_tmp2_, "10", 10, 10, "1×10¹");
#line 84 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	_tmp3_ = s;
#line 84 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	test_number (_tmp3_, "1234567890", 10, 10, "1.23456789×10⁹");
#line 85 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	_tmp4_ = s;
#line 85 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	test_number (_tmp4_, "0.1", 10, 10, "1×10⁻¹");
#line 86 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	_tmp5_ = s;
#line 86 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	test_number (_tmp5_, "0.1234567890", 10, 10, "1.23456789×10⁻¹");
#line 88 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	_tmp6_ = s;
#line 88 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	test_number (_tmp6_, "101010", 2, 2, "101010");
#line 89 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	_tmp7_ = s;
#line 89 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	test_number (_tmp7_, "12345670", 8, 8, "12345670");
#line 90 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	_tmp8_ = s;
#line 90 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	test_number (_tmp8_, "123456789ABCDEF0", 16, 16, "123456789ABCDEF0");
#line 91 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	_tmp9_ = s;
#line 91 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	test_number (_tmp9_, "0.010101", 2, 2, "0.010101");
#line 92 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	_tmp10_ = s;
#line 92 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	test_number (_tmp10_, "0.1234567", 8, 8, "0.1234567");
#line 93 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	_tmp11_ = s;
#line 93 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	test_number (_tmp11_, "0.123ABCDEF", 16, 16, "0.123ABCDEF");
#line 420 "test-serializer.c"
}


void test_engineering (Serializer* s) {
	Serializer* _tmp0_ = NULL;
	Serializer* _tmp1_ = NULL;
	Serializer* _tmp2_ = NULL;
	Serializer* _tmp3_ = NULL;
	Serializer* _tmp4_ = NULL;
	Serializer* _tmp5_ = NULL;
	Serializer* _tmp6_ = NULL;
	Serializer* _tmp7_ = NULL;
	Serializer* _tmp8_ = NULL;
	Serializer* _tmp9_ = NULL;
	Serializer* _tmp10_ = NULL;
	Serializer* _tmp11_ = NULL;
#line 96 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	g_return_if_fail (s != NULL);
#line 98 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	_tmp0_ = s;
#line 98 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	serializer_set_number_format (_tmp0_, DISPLAY_FORMAT_ENGINEERING);
#line 100 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	_tmp1_ = s;
#line 100 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	test_number (_tmp1_, "1", 10, 10, "1");
#line 101 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	_tmp2_ = s;
#line 101 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	test_number (_tmp2_, "10", 10, 10, "10");
#line 102 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	_tmp3_ = s;
#line 102 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	test_number (_tmp3_, "1234567890", 10, 10, "1.23456789×10⁹");
#line 103 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	_tmp4_ = s;
#line 103 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	test_number (_tmp4_, "0.1", 10, 10, "100×10⁻³");
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	_tmp5_ = s;
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	test_number (_tmp5_, "0.1234567890", 10, 10, "123.456789×10⁻³");
#line 106 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	_tmp6_ = s;
#line 106 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	test_number (_tmp6_, "101010", 2, 2, "101010");
#line 107 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	_tmp7_ = s;
#line 107 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	test_number (_tmp7_, "12345670", 8, 8, "12345670");
#line 108 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	_tmp8_ = s;
#line 108 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	test_number (_tmp8_, "123456789ABCDEF0", 16, 16, "123456789ABCDEF0");
#line 109 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	_tmp9_ = s;
#line 109 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	test_number (_tmp9_, "0.10101", 2, 2, "0.10101");
#line 110 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	_tmp10_ = s;
#line 110 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	test_number (_tmp10_, "0.1234567", 8, 8, "0.1234567");
#line 111 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	_tmp11_ = s;
#line 111 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	test_number (_tmp11_, "0.123ABCDEF", 16, 16, "0.123ABCDEF");
#line 487 "test-serializer.c"
}


void test_base_conversion (Serializer* s) {
	Serializer* _tmp0_ = NULL;
	Serializer* _tmp1_ = NULL;
	Serializer* _tmp2_ = NULL;
	Serializer* _tmp3_ = NULL;
	Serializer* _tmp4_ = NULL;
	Serializer* _tmp5_ = NULL;
	Serializer* _tmp6_ = NULL;
	Serializer* _tmp7_ = NULL;
	Serializer* _tmp8_ = NULL;
	Serializer* _tmp9_ = NULL;
	Serializer* _tmp10_ = NULL;
	Serializer* _tmp11_ = NULL;
	Serializer* _tmp12_ = NULL;
	Serializer* _tmp13_ = NULL;
	Serializer* _tmp14_ = NULL;
#line 114 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	g_return_if_fail (s != NULL);
#line 116 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	_tmp0_ = s;
#line 116 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	test_number (_tmp0_, "12₈", 10, 2, "1010₂");
#line 117 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	_tmp1_ = s;
#line 117 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	test_number (_tmp1_, "10", 10, 2, "1010₂");
#line 118 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	_tmp2_ = s;
#line 118 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	test_number (_tmp2_, "A₁₆", 10, 2, "1010₂");
#line 119 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	_tmp3_ = s;
#line 119 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	test_number (_tmp3_, "1234567890123456789012345678901234567890", 10, 2, "1110100000110010010010000001110101110000001101101111110011101110001010" \
"110010111100010111111001011011001110001111110000101011010010₂");
#line 121 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	_tmp4_ = s;
#line 121 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	test_number (_tmp4_, "1010₂", 10, 8, "12₈");
#line 122 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	_tmp5_ = s;
#line 122 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	test_number (_tmp5_, "10", 10, 8, "12₈");
#line 123 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	_tmp6_ = s;
#line 123 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	test_number (_tmp6_, "A₁₆", 10, 8, "12₈");
#line 124 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	_tmp7_ = s;
#line 124 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	test_number (_tmp7_, "1234567890123456789012345678901234567890", 10, 8, "16406222016560155763561262742771331617605322₈");
#line 126 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	_tmp8_ = s;
#line 126 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	test_number (_tmp8_, "1010₂", 10, 10, "10");
#line 127 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	_tmp9_ = s;
#line 127 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	test_number (_tmp9_, "12₈", 10, 10, "10");
#line 128 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	_tmp10_ = s;
#line 128 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	test_number (_tmp10_, "A₁₆", 10, 10, "10");
#line 130 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	_tmp11_ = s;
#line 130 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	test_number (_tmp11_, "1010₂", 10, 16, "A₁₆");
#line 131 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	_tmp12_ = s;
#line 131 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	test_number (_tmp12_, "12₈", 10, 16, "A₁₆");
#line 132 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	_tmp13_ = s;
#line 132 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	test_number (_tmp13_, "10", 10, 16, "A₁₆");
#line 133 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	_tmp14_ = s;
#line 133 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	test_number (_tmp14_, "1234567890123456789012345678901234567890", 10, 16, "3A0C92075C0DBF3B8ACBC5F96CE3F0AD2₁₆");
#line 569 "test-serializer.c"
}


static gunichar string_get_char (const gchar* self, glong index) {
	gunichar result = 0U;
	glong _tmp0_ = 0L;
	gunichar _tmp1_ = 0U;
#line 1026 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0U);
#line 1027 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp0_ = index;
#line 1027 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp1_ = g_utf8_get_char (((gchar*) self) + _tmp0_);
#line 1027 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	result = _tmp1_;
#line 1027 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	return result;
#line 587 "test-serializer.c"
}


gint _vala_main (gchar** args, int args_length1) {
	gint result = 0;
	Serializer* serializer = NULL;
	Serializer* _tmp0_ = NULL;
	Serializer* _tmp1_ = NULL;
	gunichar _tmp2_ = 0U;
	Serializer* _tmp3_ = NULL;
	gunichar _tmp4_ = 0U;
	Serializer* _tmp5_ = NULL;
	Serializer* _tmp6_ = NULL;
	Serializer* _tmp7_ = NULL;
	Serializer* _tmp8_ = NULL;
	Serializer* _tmp9_ = NULL;
	Serializer* _tmp10_ = NULL;
	Serializer* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	gint _tmp19_ = 0;
#line 139 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	setlocale (LC_ALL, "C");
#line 140 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	_tmp0_ = serializer_new (DISPLAY_FORMAT_AUTOMATIC, 10, 9);
#line 140 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	serializer = _tmp0_;
#line 141 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	_tmp1_ = serializer;
#line 141 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	_tmp2_ = string_get_char (thousand_separator, (glong) 0);
#line 141 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	serializer_set_thousands_separator (_tmp1_, _tmp2_);
#line 142 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	_tmp3_ = serializer;
#line 142 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	_tmp4_ = string_get_char (radix_string, (glong) 0);
#line 142 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	serializer_set_radix (_tmp3_, _tmp4_);
#line 143 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	_tmp5_ = serializer;
#line 143 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	serializer_set_show_thousands_separators (_tmp5_, TRUE);
#line 144 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	_tmp6_ = serializer;
#line 144 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	serializer_set_thousands_separator_count (_tmp6_, 3);
#line 146 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	_tmp7_ = serializer;
#line 146 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	test_fixed (_tmp7_);
#line 147 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	_tmp8_ = serializer;
#line 147 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	test_automatic (_tmp8_);
#line 148 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	_tmp9_ = serializer;
#line 148 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	test_scientific (_tmp9_);
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	_tmp10_ = serializer;
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	test_engineering (_tmp10_);
#line 151 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	_tmp11_ = serializer;
#line 151 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	test_base_conversion (_tmp11_);
#line 153 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	_tmp12_ = fail_count;
#line 153 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	if (_tmp12_ == 0) {
#line 658 "test-serializer.c"
		FILE* _tmp13_ = NULL;
		gint _tmp14_ = 0;
#line 154 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
		_tmp13_ = stdout;
#line 154 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
		_tmp14_ = pass_count;
#line 154 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
		fprintf (_tmp13_, "Passed all %i tests\n", _tmp14_);
#line 667 "test-serializer.c"
	} else {
		FILE* _tmp15_ = NULL;
		gint _tmp16_ = 0;
		gint _tmp17_ = 0;
		gint _tmp18_ = 0;
#line 156 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
		_tmp15_ = stdout;
#line 156 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
		_tmp16_ = fail_count;
#line 156 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
		_tmp17_ = pass_count;
#line 156 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
		_tmp18_ = fail_count;
#line 156 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
		fprintf (_tmp15_, "Failed %i/%d tests\n", _tmp16_, _tmp17_ + _tmp18_);
#line 683 "test-serializer.c"
	}
#line 158 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	_tmp19_ = fail_count;
#line 158 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	result = _tmp19_;
#line 158 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	_g_object_unref0 (serializer);
#line 158 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	return result;
#line 693 "test-serializer.c"
}


int main (int argc, char ** argv) {
#if !GLIB_CHECK_VERSION (2,35,0)
	g_type_init ();
#endif
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-serializer.vala"
	return _vala_main (argv, argc);
#line 703 "test-serializer.c"
}



