/* dummy-persona-store.c generated by valac 0.27.1.4-8d57, the Vala compiler
 * generated from dummy-persona-store.vala, do not modify */

/*
 * Copyright (C) 2013 Philip Withnall
 * Copyright (C) 2013 Canonical Ltd
 * Copyright (C) 2013 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Philip Withnall <philip@tecnocode.co.uk>
 *       Renato Araujo Oliveira Filho <renato@canonical.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <folks/folks.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gio/gio.h>
#include <folks-internal.h>


#define FOLKS_DUMMY_TYPE_PERSONA_STORE (folks_dummy_persona_store_get_type ())
#define FOLKS_DUMMY_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_DUMMY_TYPE_PERSONA_STORE, FolksDummyPersonaStore))
#define FOLKS_DUMMY_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_DUMMY_TYPE_PERSONA_STORE, FolksDummyPersonaStoreClass))
#define FOLKS_DUMMY_IS_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_DUMMY_TYPE_PERSONA_STORE))
#define FOLKS_DUMMY_IS_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_DUMMY_TYPE_PERSONA_STORE))
#define FOLKS_DUMMY_PERSONA_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_DUMMY_TYPE_PERSONA_STORE, FolksDummyPersonaStoreClass))

typedef struct _FolksDummyPersonaStore FolksDummyPersonaStore;
typedef struct _FolksDummyPersonaStoreClass FolksDummyPersonaStoreClass;
typedef struct _FolksDummyPersonaStorePrivate FolksDummyPersonaStorePrivate;

#define FOLKS_DUMMY_TYPE_PERSONA (folks_dummy_persona_get_type ())
#define FOLKS_DUMMY_PERSONA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_DUMMY_TYPE_PERSONA, FolksDummyPersona))
#define FOLKS_DUMMY_PERSONA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_DUMMY_TYPE_PERSONA, FolksDummyPersonaClass))
#define FOLKS_DUMMY_IS_PERSONA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_DUMMY_TYPE_PERSONA))
#define FOLKS_DUMMY_IS_PERSONA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_DUMMY_TYPE_PERSONA))
#define FOLKS_DUMMY_PERSONA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_DUMMY_TYPE_PERSONA, FolksDummyPersonaClass))

typedef struct _FolksDummyPersona FolksDummyPersona;
typedef struct _FolksDummyPersonaClass FolksDummyPersonaClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _FolksDummyPersonaStoreAddPersonaFromDetailsData FolksDummyPersonaStoreAddPersonaFromDetailsData;
typedef struct _FolksDummyPersonaStoreRemovePersonaData FolksDummyPersonaStoreRemovePersonaData;
typedef struct _FolksDummyPersonaStorePrepareData FolksDummyPersonaStorePrepareData;
typedef struct _Block2Data Block2Data;
typedef struct _FolksDummyPersonaStoreImplementMockDelayData FolksDummyPersonaStoreImplementMockDelayData;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _FolksDummyPersonaStore {
	FolksPersonaStore parent_instance;
	FolksDummyPersonaStorePrivate * priv;
};

struct _FolksDummyPersonaStoreClass {
	FolksPersonaStoreClass parent_class;
};

typedef gint (*FolksDummyPersonaStoreAddPersonaFromDetailsMock) (FolksDummyPersona* persona, void* user_data, GError** error);
typedef gint (*FolksDummyPersonaStoreRemovePersonaMock) (FolksDummyPersona* persona, void* user_data, GError** error);
typedef gint (*FolksDummyPersonaStorePrepareMock) (void* user_data, GError** error);
struct _FolksDummyPersonaStorePrivate {
	gboolean _is_prepared;
	gboolean _prepare_pending;
	gboolean _is_quiescent;
	gboolean _quiescent_on_prepare;
	gint _contact_id;
	FolksMaybeBool _can_add_personas;
	FolksMaybeBool _can_alias_personas;
	FolksMaybeBool _can_remove_personas;
	gchar** _always_writeable_properties;
	gint _always_writeable_properties_length1;
	gint __always_writeable_properties_size_;
	GeeHashMap* _personas;
	GeeMap* _personas_ro;
	GeeHashSet* _pending_persona_registrations;
	GeeHashSet* _pending_persona_unregistrations;
	guint _personas_changed_frozen;
	FolksDummyPersonaStoreAddPersonaFromDetailsMock _add_persona_from_details_mock;
	gpointer _add_persona_from_details_mock_target;
	FolksDummyPersonaStoreRemovePersonaMock _remove_persona_mock;
	gpointer _remove_persona_mock_target;
	FolksDummyPersonaStorePrepareMock _prepare_mock;
	gpointer _prepare_mock_target;
	GType _persona_type;
};

struct _FolksDummyPersonaStoreAddPersonaFromDetailsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksDummyPersonaStore* self;
	GHashTable* details;
	FolksPersona* result;
	gboolean _tmp0_;
	GError* _tmp1_;
	gchar* contact_id;
	gint _tmp2_;
	gchar* _tmp3_;
	gint _tmp4_;
	gchar* uid;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* iid;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	FolksDummyPersona* persona;
	GType _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	GObject* _tmp20_;
	GObject* _tmp21_;
	FolksDummyPersona* _tmp22_;
	FolksDummyPersona* _tmp23_;
	FolksDummyPersona* _tmp24_;
	gchar** _tmp25_;
	gint _tmp25__length1;
	gchar** _tmp26_;
	gint _tmp26__length1;
	GValue* v;
	GHashTable* _tmp27_;
	const gchar* _tmp28_;
	gconstpointer _tmp29_;
	FolksNameDetails* p_name;
	FolksDummyPersona* _tmp30_;
	FolksNameDetails* _tmp31_;
	gboolean _tmp32_;
	FolksNameDetails* _tmp33_;
	GValue* _tmp34_;
	const gchar* _tmp35_;
	GValue* _tmp36_;
	GValue _tmp37_;
	const gchar* _tmp38_;
	gchar* full_name;
	gchar* _tmp39_;
	FolksNameDetails* _tmp40_;
	const gchar* _tmp41_;
	GHashTable* _tmp42_;
	const gchar* _tmp43_;
	gconstpointer _tmp44_;
	gboolean _tmp45_;
	FolksNameDetails* _tmp46_;
	GValue* _tmp47_;
	FolksStructuredName* sname;
	GValue* _tmp48_;
	GValue _tmp49_;
	GObject* _tmp50_;
	FolksStructuredName* _tmp51_;
	FolksStructuredName* _tmp52_;
	FolksNameDetails* _tmp53_;
	FolksStructuredName* _tmp54_;
	GHashTable* _tmp55_;
	const gchar* _tmp56_;
	gconstpointer _tmp57_;
	gboolean _tmp58_;
	FolksNameDetails* _tmp59_;
	GValue* _tmp60_;
	const gchar* _tmp61_;
	GValue* _tmp62_;
	GValue _tmp63_;
	const gchar* _tmp64_;
	gchar* nickname;
	gchar* _tmp65_;
	FolksNameDetails* _tmp66_;
	const gchar* _tmp67_;
	GHashTable* _tmp68_;
	const gchar* _tmp69_;
	gconstpointer _tmp70_;
	FolksEmailDetails* p_email;
	FolksDummyPersona* _tmp71_;
	FolksEmailDetails* _tmp72_;
	gboolean _tmp73_;
	FolksEmailDetails* _tmp74_;
	GValue* _tmp75_;
	GeeSet* email_addresses;
	GValue* _tmp76_;
	GValue _tmp77_;
	GObject* _tmp78_;
	GeeSet* _tmp79_;
	GeeSet* _tmp80_;
	FolksEmailDetails* _tmp81_;
	GeeSet* _tmp82_;
	GHashTable* _tmp83_;
	const gchar* _tmp84_;
	gconstpointer _tmp85_;
	FolksAvatarDetails* p_avatar;
	FolksDummyPersona* _tmp86_;
	FolksAvatarDetails* _tmp87_;
	gboolean _tmp88_;
	FolksAvatarDetails* _tmp89_;
	GValue* _tmp90_;
	GLoadableIcon* avatar;
	GValue* _tmp91_;
	GValue _tmp92_;
	GObject* _tmp93_;
	GLoadableIcon* _tmp94_;
	GLoadableIcon* _tmp95_;
	FolksAvatarDetails* _tmp96_;
	GLoadableIcon* _tmp97_;
	GHashTable* _tmp98_;
	const gchar* _tmp99_;
	gconstpointer _tmp100_;
	FolksImDetails* p_im;
	FolksDummyPersona* _tmp101_;
	FolksImDetails* _tmp102_;
	gboolean _tmp103_;
	FolksImDetails* _tmp104_;
	GValue* _tmp105_;
	GeeMultiMap* im_addresses;
	GValue* _tmp106_;
	GValue _tmp107_;
	GObject* _tmp108_;
	GeeMultiMap* _tmp109_;
	GeeMultiMap* _tmp110_;
	FolksImDetails* _tmp111_;
	GeeMultiMap* _tmp112_;
	GHashTable* _tmp113_;
	const gchar* _tmp114_;
	gconstpointer _tmp115_;
	FolksPhoneDetails* p_phone;
	FolksDummyPersona* _tmp116_;
	FolksPhoneDetails* _tmp117_;
	gboolean _tmp118_;
	FolksPhoneDetails* _tmp119_;
	GValue* _tmp120_;
	GeeSet* phone_numbers;
	GValue* _tmp121_;
	GValue _tmp122_;
	GObject* _tmp123_;
	GeeSet* _tmp124_;
	GeeSet* _tmp125_;
	FolksPhoneDetails* _tmp126_;
	GeeSet* _tmp127_;
	GHashTable* _tmp128_;
	const gchar* _tmp129_;
	gconstpointer _tmp130_;
	FolksPostalAddressDetails* p_postal;
	FolksDummyPersona* _tmp131_;
	FolksPostalAddressDetails* _tmp132_;
	gboolean _tmp133_;
	FolksPostalAddressDetails* _tmp134_;
	GValue* _tmp135_;
	GeeSet* postal_fds;
	GValue* _tmp136_;
	GValue _tmp137_;
	GObject* _tmp138_;
	GeeSet* _tmp139_;
	GeeSet* _tmp140_;
	FolksPostalAddressDetails* _tmp141_;
	GeeSet* _tmp142_;
	GHashTable* _tmp143_;
	const gchar* _tmp144_;
	gconstpointer _tmp145_;
	FolksLocalIdDetails* p_local;
	FolksDummyPersona* _tmp146_;
	FolksLocalIdDetails* _tmp147_;
	gboolean _tmp148_;
	FolksLocalIdDetails* _tmp149_;
	GValue* _tmp150_;
	GeeSet* local_ids;
	GValue* _tmp151_;
	GValue _tmp152_;
	GObject* _tmp153_;
	GeeSet* _tmp154_;
	GeeSet* _tmp155_;
	FolksLocalIdDetails* _tmp156_;
	GeeSet* _tmp157_;
	GHashTable* _tmp158_;
	const gchar* _tmp159_;
	gconstpointer _tmp160_;
	FolksWebServiceDetails* p_web;
	FolksDummyPersona* _tmp161_;
	FolksWebServiceDetails* _tmp162_;
	gboolean _tmp163_;
	FolksWebServiceDetails* _tmp164_;
	GValue* _tmp165_;
	GeeHashMultiMap* addrs;
	GValue* _tmp166_;
	GValue _tmp167_;
	GObject* _tmp168_;
	GeeHashMultiMap* _tmp169_;
	GeeHashMultiMap* _tmp170_;
	FolksWebServiceDetails* _tmp171_;
	GeeHashMultiMap* _tmp172_;
	GHashTable* _tmp173_;
	const gchar* _tmp174_;
	gconstpointer _tmp175_;
	FolksNoteDetails* p_note;
	FolksDummyPersona* _tmp176_;
	FolksNoteDetails* _tmp177_;
	gboolean _tmp178_;
	FolksNoteDetails* _tmp179_;
	GValue* _tmp180_;
	GeeHashSet* notes;
	GValue* _tmp181_;
	GValue _tmp182_;
	GObject* _tmp183_;
	GeeHashSet* _tmp184_;
	GeeHashSet* _tmp185_;
	FolksNoteDetails* _tmp186_;
	GeeHashSet* _tmp187_;
	GHashTable* _tmp188_;
	const gchar* _tmp189_;
	gconstpointer _tmp190_;
	FolksGenderDetails* p_gender;
	FolksDummyPersona* _tmp191_;
	FolksGenderDetails* _tmp192_;
	gboolean _tmp193_;
	FolksGenderDetails* _tmp194_;
	GValue* _tmp195_;
	FolksGender gender;
	GValue* _tmp196_;
	GValue _tmp197_;
	gint _tmp198_;
	FolksGenderDetails* _tmp199_;
	FolksGender _tmp200_;
	GHashTable* _tmp201_;
	const gchar* _tmp202_;
	gconstpointer _tmp203_;
	FolksUrlDetails* p_url;
	FolksDummyPersona* _tmp204_;
	FolksUrlDetails* _tmp205_;
	gboolean _tmp206_;
	FolksUrlDetails* _tmp207_;
	GValue* _tmp208_;
	GeeSet* urls;
	GValue* _tmp209_;
	GValue _tmp210_;
	GObject* _tmp211_;
	GeeSet* _tmp212_;
	GeeSet* _tmp213_;
	FolksUrlDetails* _tmp214_;
	GeeSet* _tmp215_;
	GHashTable* _tmp216_;
	const gchar* _tmp217_;
	gconstpointer _tmp218_;
	FolksBirthdayDetails* p_birthday;
	FolksDummyPersona* _tmp219_;
	FolksBirthdayDetails* _tmp220_;
	gboolean _tmp221_;
	FolksBirthdayDetails* _tmp222_;
	GValue* _tmp223_;
	GDateTime* birthday;
	GValue* _tmp224_;
	GValue _tmp225_;
	void* _tmp226_;
	GDateTime* _tmp227_;
	GDateTime* _tmp228_;
	FolksBirthdayDetails* _tmp229_;
	GDateTime* _tmp230_;
	GHashTable* _tmp231_;
	const gchar* _tmp232_;
	gconstpointer _tmp233_;
	FolksRoleDetails* p_role;
	FolksDummyPersona* _tmp234_;
	FolksRoleDetails* _tmp235_;
	gboolean _tmp236_;
	FolksRoleDetails* _tmp237_;
	GValue* _tmp238_;
	GeeSet* roles;
	GValue* _tmp239_;
	GValue _tmp240_;
	GObject* _tmp241_;
	GeeSet* _tmp242_;
	GeeSet* _tmp243_;
	FolksRoleDetails* _tmp244_;
	GeeSet* _tmp245_;
	GHashTable* _tmp246_;
	const gchar* _tmp247_;
	gconstpointer _tmp248_;
	FolksFavouriteDetails* p_favourite;
	FolksDummyPersona* _tmp249_;
	FolksFavouriteDetails* _tmp250_;
	gboolean _tmp251_;
	FolksFavouriteDetails* _tmp252_;
	GValue* _tmp253_;
	gboolean is_fav;
	GValue* _tmp254_;
	GValue _tmp255_;
	gboolean _tmp256_;
	FolksFavouriteDetails* _tmp257_;
	gboolean _tmp258_;
	GError* e1;
	GError* _tmp259_;
	const gchar* _tmp260_;
	GError* _tmp261_;
	FolksDummyPersonaStoreAddPersonaFromDetailsMock _tmp262_;
	void* _tmp262__target;
	FolksDummyPersonaStoreAddPersonaFromDetailsMock _tmp263_;
	void* _tmp263__target;
	gint delay;
	FolksDummyPersonaStoreAddPersonaFromDetailsMock _tmp264_;
	void* _tmp264__target;
	FolksDummyPersonaStoreAddPersonaFromDetailsMock _tmp265_;
	void* _tmp265__target;
	FolksDummyPersona* _tmp266_;
	gint _tmp267_;
	gint _tmp268_;
	GeeHashMap* _tmp269_;
	FolksDummyPersona* _tmp270_;
	const gchar* _tmp271_;
	const gchar* _tmp272_;
	FolksDummyPersona* _tmp273_;
	GeeHashSet* added_personas;
	GeeHashSet* _tmp274_;
	GeeHashSet* _tmp275_;
	FolksDummyPersona* _tmp276_;
	GeeHashSet* _tmp277_;
	GError * _inner_error_;
};

struct _FolksDummyPersonaStoreRemovePersonaData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksDummyPersonaStore* self;
	FolksPersona* persona;
	FolksPersona* _tmp0_;
	gboolean _tmp1_;
	GError* _tmp2_;
	FolksDummyPersonaStoreRemovePersonaMock _tmp3_;
	void* _tmp3__target;
	FolksDummyPersonaStoreRemovePersonaMock _tmp4_;
	void* _tmp4__target;
	gint delay;
	FolksDummyPersonaStoreRemovePersonaMock _tmp5_;
	void* _tmp5__target;
	FolksDummyPersonaStoreRemovePersonaMock _tmp6_;
	void* _tmp6__target;
	FolksPersona* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	FolksDummyPersona* _persona;
	GeeHashMap* _tmp10_;
	FolksPersona* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	gpointer _tmp14_;
	FolksDummyPersona* _tmp15_;
	GeeHashMap* _tmp16_;
	FolksPersona* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	GeeHashSet* _tmp20_;
	FolksDummyPersona* _tmp21_;
	GeeHashSet* _tmp22_;
	FolksDummyPersona* _tmp23_;
	GeeHashSet* removed_personas;
	GeeHashSet* _tmp24_;
	GeeHashSet* _tmp25_;
	FolksPersona* _tmp26_;
	GeeHashSet* _tmp27_;
	GError * _inner_error_;
};

struct _FolksDummyPersonaStorePrepareData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksDummyPersonaStore* self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	FolksDummyPersonaStorePrepareMock _tmp5_;
	void* _tmp5__target;
	FolksDummyPersonaStorePrepareMock _tmp6_;
	void* _tmp6__target;
	gint delay;
	FolksDummyPersonaStorePrepareMock _tmp7_;
	void* _tmp7__target;
	FolksDummyPersonaStorePrepareMock _tmp8_;
	void* _tmp8__target;
	gint _tmp9_;
	gint _tmp10_;
	gboolean _tmp11_;
	GError * _inner_error_;
};

struct _Block2Data {
	int _ref_count_;
	FolksDummyPersonaStore* self;
	gpointer _async_data_;
};

struct _FolksDummyPersonaStoreImplementMockDelayData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksDummyPersonaStore* self;
	gint delay;
	Block2Data* _data2_;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
};


static gpointer folks_dummy_persona_store_parent_class = NULL;
static gchar** folks_dummy_persona_store__always_writeable_properties_empty;
static gint folks_dummy_persona_store__always_writeable_properties_empty_length1;
static gchar** folks_dummy_persona_store__always_writeable_properties_empty = NULL;
static gint folks_dummy_persona_store__always_writeable_properties_empty_length1 = 0;
static gint _folks_dummy_persona_store__always_writeable_properties_empty_size_ = 0;

GType folks_dummy_persona_store_get_type (void) G_GNUC_CONST;
GType folks_dummy_persona_get_type (void) G_GNUC_CONST;
#define FOLKS_DUMMY_PERSONA_STORE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), FOLKS_DUMMY_TYPE_PERSONA_STORE, FolksDummyPersonaStorePrivate))
enum  {
	FOLKS_DUMMY_PERSONA_STORE_DUMMY_PROPERTY,
	FOLKS_DUMMY_PERSONA_STORE_TYPE_ID,
	FOLKS_DUMMY_PERSONA_STORE_CAN_ADD_PERSONAS,
	FOLKS_DUMMY_PERSONA_STORE_CAN_ALIAS_PERSONAS,
	FOLKS_DUMMY_PERSONA_STORE_CAN_GROUP_PERSONAS,
	FOLKS_DUMMY_PERSONA_STORE_CAN_REMOVE_PERSONAS,
	FOLKS_DUMMY_PERSONA_STORE_IS_PREPARED,
	FOLKS_DUMMY_PERSONA_STORE_ALWAYS_WRITEABLE_PROPERTIES,
	FOLKS_DUMMY_PERSONA_STORE_IS_QUIESCENT,
	FOLKS_DUMMY_PERSONA_STORE_PERSONAS,
	FOLKS_DUMMY_PERSONA_STORE_PERSONA_TYPE
};
FolksDummyPersonaStore* folks_dummy_persona_store_new (const gchar* id, const gchar* display_name, gchar** always_writeable_properties, int always_writeable_properties_length1);
FolksDummyPersonaStore* folks_dummy_persona_store_construct (GType object_type, const gchar* id, const gchar* display_name, gchar** always_writeable_properties, int always_writeable_properties_length1);
static gchar** _vala_array_dup4 (gchar** self, int length);
static void folks_dummy_persona_store_real_add_persona_from_details_data_free (gpointer _data);
static void folks_dummy_persona_store_real_add_persona_from_details (FolksPersonaStore* base, GHashTable* details, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean folks_dummy_persona_store_real_add_persona_from_details_co (FolksDummyPersonaStoreAddPersonaFromDetailsData* _data_);
void folks_dummy_persona_update_writeable_properties (FolksDummyPersona* self, gchar** writeable_properties, int writeable_properties_length1);
static void folks_dummy_persona_store_add_persona_from_details_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
FolksDummyPersonaStoreAddPersonaFromDetailsMock folks_dummy_persona_store_get_add_persona_from_details_mock (FolksDummyPersonaStore* self, gpointer* result_target);
static void _folks_dummy_persona_store_implement_mock_delay (FolksDummyPersonaStore* self, gint delay, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void _folks_dummy_persona_store_implement_mock_delay_finish (FolksDummyPersonaStore* self, GAsyncResult* _res_);
static void folks_dummy_persona_store_real_remove_persona_data_free (gpointer _data);
static void folks_dummy_persona_store_real_remove_persona (FolksPersonaStore* base, FolksPersona* persona, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean folks_dummy_persona_store_real_remove_persona_co (FolksDummyPersonaStoreRemovePersonaData* _data_);
FolksDummyPersonaStoreRemovePersonaMock folks_dummy_persona_store_get_remove_persona_mock (FolksDummyPersonaStore* self, gpointer* result_target);
static void folks_dummy_persona_store_remove_persona_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void folks_dummy_persona_store_real_prepare_data_free (gpointer _data);
static void folks_dummy_persona_store_real_prepare (FolksPersonaStore* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean folks_dummy_persona_store_real_prepare_co (FolksDummyPersonaStorePrepareData* _data_);
FolksDummyPersonaStorePrepareMock folks_dummy_persona_store_get_prepare_mock (FolksDummyPersonaStore* self, gpointer* result_target);
static void folks_dummy_persona_store_prepare_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void folks_dummy_persona_store_reach_quiescence (FolksDummyPersonaStore* self);
static void _folks_dummy_persona_store_implement_mock_delay_data_free (gpointer _data);
static gboolean _folks_dummy_persona_store_implement_mock_delay_co (FolksDummyPersonaStoreImplementMockDelayData* _data_);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static gboolean ____lambda6_ (Block2Data* _data2_);
static gboolean _____lambda6__gsource_func (gpointer self);
static gboolean ____lambda7_ (Block2Data* _data2_);
static gboolean _____lambda7__gsource_func (gpointer self);
void folks_dummy_persona_store_update_capabilities (FolksDummyPersonaStore* self, FolksMaybeBool can_add_personas, FolksMaybeBool can_alias_personas, FolksMaybeBool can_remove_personas);
void folks_dummy_persona_store_freeze_personas_changed (FolksDummyPersonaStore* self);
void folks_dummy_persona_store_thaw_personas_changed (FolksDummyPersonaStore* self);
void folks_dummy_persona_store_register_personas (FolksDummyPersonaStore* self, GeeSet* personas);
void folks_dummy_persona_store_unregister_personas (FolksDummyPersonaStore* self, GeeSet* personas);
void folks_dummy_persona_store_update_is_user_set_default (FolksDummyPersonaStore* self, gboolean is_user_set_default);
void folks_dummy_persona_store_update_trust_level (FolksDummyPersonaStore* self, FolksPersonaStoreTrust trust_level);
static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle);
void folks_dummy_persona_store_set_add_persona_from_details_mock (FolksDummyPersonaStore* self, FolksDummyPersonaStoreAddPersonaFromDetailsMock value, gpointer value_target);
void folks_dummy_persona_store_set_remove_persona_mock (FolksDummyPersonaStore* self, FolksDummyPersonaStoreRemovePersonaMock value, gpointer value_target);
void folks_dummy_persona_store_set_prepare_mock (FolksDummyPersonaStore* self, FolksDummyPersonaStorePrepareMock value, gpointer value_target);
GType folks_dummy_persona_store_get_persona_type (FolksDummyPersonaStore* self);
void folks_dummy_persona_store_set_persona_type (FolksDummyPersonaStore* self, GType value);
static GObject * folks_dummy_persona_store_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void folks_dummy_persona_store_finalize (GObject* obj);
static void _vala_folks_dummy_persona_store_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_folks_dummy_persona_store_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


/**
   * Create a new persona store.
   *
   * This store will have no personas to begin with; use
   * {@link FolksDummy.PersonaStore.register_personas} to add some, then call
   * {@link FolksDummy.PersonaStore.reach_quiescence} to signal the store
   * reaching quiescence.
   *
   * @param id The new store's ID.
   * @param display_name The new store's display name.
   * @param always_writeable_properties The set of always writeable properties.
   *
   * @since 0.9.7
   */
static gchar** _vala_array_dup4 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


FolksDummyPersonaStore* folks_dummy_persona_store_construct (GType object_type, const gchar* id, const gchar* display_name, gchar** always_writeable_properties, int always_writeable_properties_length1) {
	FolksDummyPersonaStore * self = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (display_name != NULL, NULL);
	_tmp0_ = id;
	_tmp1_ = display_name;
	self = (FolksDummyPersonaStore*) g_object_new (object_type, "id", _tmp0_, "display-name", _tmp1_, NULL);
	_tmp2_ = always_writeable_properties;
	_tmp2__length1 = always_writeable_properties_length1;
	_tmp3_ = (_tmp2_ != NULL) ? _vala_array_dup4 (_tmp2_, _tmp2__length1) : ((gpointer) _tmp2_);
	_tmp3__length1 = _tmp2__length1;
	self->priv->_always_writeable_properties = (_vala_array_free (self->priv->_always_writeable_properties, self->priv->_always_writeable_properties_length1, (GDestroyNotify) g_free), NULL);
	self->priv->_always_writeable_properties = _tmp3_;
	self->priv->_always_writeable_properties_length1 = _tmp3__length1;
	self->priv->__always_writeable_properties_size_ = self->priv->_always_writeable_properties_length1;
	return self;
}


FolksDummyPersonaStore* folks_dummy_persona_store_new (const gchar* id, const gchar* display_name, gchar** always_writeable_properties, int always_writeable_properties_length1) {
	return folks_dummy_persona_store_construct (FOLKS_DUMMY_TYPE_PERSONA_STORE, id, display_name, always_writeable_properties, always_writeable_properties_length1);
}


static void folks_dummy_persona_store_real_add_persona_from_details_data_free (gpointer _data) {
	FolksDummyPersonaStoreAddPersonaFromDetailsData* _data_;
	_data_ = _data;
	_g_hash_table_unref0 (_data_->details);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksDummyPersonaStoreAddPersonaFromDetailsData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gpointer _g_hash_table_ref0 (gpointer self) {
	return self ? g_hash_table_ref (self) : NULL;
}


static void folks_dummy_persona_store_real_add_persona_from_details (FolksPersonaStore* base, GHashTable* details, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksDummyPersonaStore * self;
	FolksDummyPersonaStoreAddPersonaFromDetailsData* _data_;
	FolksDummyPersonaStore* _tmp0_ = NULL;
	GHashTable* _tmp1_ = NULL;
	GHashTable* _tmp2_ = NULL;
	self = (FolksDummyPersonaStore*) base;
	_data_ = g_slice_new0 (FolksDummyPersonaStoreAddPersonaFromDetailsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_dummy_persona_store_real_add_persona_from_details);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_dummy_persona_store_real_add_persona_from_details_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = details;
	_tmp2_ = _g_hash_table_ref0 (_tmp1_);
	_g_hash_table_unref0 (_data_->details);
	_data_->details = _tmp2_;
	folks_dummy_persona_store_real_add_persona_from_details_co (_data_);
}


static FolksPersona* folks_dummy_persona_store_real_add_persona_from_details_finish (FolksPersonaStore* base, GAsyncResult* _res_, GError** error) {
	FolksPersona* result;
	FolksDummyPersonaStoreAddPersonaFromDetailsData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


/**
   * Add a new {@link Persona} to the PersonaStore.
   *
   * Accepted keys for ``details`` are:
   * - PersonaStore.detail_key (PersonaDetail.AVATAR)
   * - PersonaStore.detail_key (PersonaDetail.BIRTHDAY)
   * - PersonaStore.detail_key (PersonaDetail.EMAIL_ADDRESSES)
   * - PersonaStore.detail_key (PersonaDetail.FULL_NAME)
   * - PersonaStore.detail_key (PersonaDetail.GENDER)
   * - PersonaStore.detail_key (PersonaDetail.IM_ADDRESSES)
   * - PersonaStore.detail_key (PersonaDetail.IS_FAVOURITE)
   * - PersonaStore.detail_key (PersonaDetail.PHONE_NUMBERS)
   * - PersonaStore.detail_key (PersonaDetail.POSTAL_ADDRESSES)
   * - PersonaStore.detail_key (PersonaDetail.ROLES)
   * - PersonaStore.detail_key (PersonaDetail.STRUCTURED_NAME)
   * - PersonaStore.detail_key (PersonaDetail.LOCAL_IDS)
   * - PersonaStore.detail_key (PersonaDetail.WEB_SERVICE_ADDRESSES)
   * - PersonaStore.detail_key (PersonaDetail.NOTES)
   * - PersonaStore.detail_key (PersonaDetail.URLS)
   *
   * See {@link Folks.PersonaStore.add_persona_from_details}.
   *
   * @param details key–value pairs giving the new persona’s details
   * @throws Folks.PersonaStoreError.STORE_OFFLINE if the store hasn’t been
   * prepared
   * @throws Folks.PersonaStoreError.CREATE_FAILED if creating the persona in
   * the dummy store failed
   *
   * @since 0.9.7
   */
static void folks_dummy_persona_store_add_persona_from_details_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksDummyPersonaStoreAddPersonaFromDetailsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	folks_dummy_persona_store_real_add_persona_from_details_co (_data_);
}


static gpointer _g_date_time_ref0 (gpointer self) {
	return self ? g_date_time_ref (self) : NULL;
}


static gboolean folks_dummy_persona_store_real_add_persona_from_details_co (FolksDummyPersonaStoreAddPersonaFromDetailsData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		case 5:
		goto _state_5;
		case 6:
		goto _state_6;
		case 7:
		goto _state_7;
		case 8:
		goto _state_8;
		case 9:
		goto _state_9;
		case 10:
		goto _state_10;
		case 11:
		goto _state_11;
		case 12:
		goto _state_12;
		case 13:
		goto _state_13;
		case 14:
		goto _state_14;
		case 15:
		goto _state_15;
		case 16:
		goto _state_16;
		case 17:
		goto _state_17;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = FALSE;
	_data_->_tmp0_ = _data_->self->priv->_is_prepared;
	if (!_data_->_tmp0_) {
		_data_->_tmp1_ = NULL;
		_data_->_tmp1_ = g_error_new_literal (FOLKS_PERSONA_STORE_ERROR, FOLKS_PERSONA_STORE_ERROR_STORE_OFFLINE, "Persona store has not yet been prepared.");
		_data_->_inner_error_ = _data_->_tmp1_;
		if (_data_->_inner_error_->domain == FOLKS_PERSONA_STORE_ERROR) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	_data_->_tmp2_ = 0;
	_data_->_tmp2_ = _data_->self->priv->_contact_id;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = g_strdup_printf ("%i", _data_->_tmp2_);
	_data_->contact_id = _data_->_tmp3_;
	_data_->_tmp4_ = 0;
	_data_->_tmp4_ = _data_->self->priv->_contact_id;
	_data_->self->priv->_contact_id = _data_->_tmp4_ + 1;
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = folks_persona_store_get_id ((FolksPersonaStore*) _data_->self);
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = _data_->_tmp5_;
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = _data_->contact_id;
	_data_->_tmp8_ = NULL;
	_data_->_tmp8_ = folks_persona_build_uid (BACKEND_NAME, _data_->_tmp6_, _data_->_tmp7_);
	_data_->uid = _data_->_tmp8_;
	_data_->_tmp9_ = NULL;
	_data_->_tmp9_ = folks_persona_store_get_id ((FolksPersonaStore*) _data_->self);
	_data_->_tmp10_ = NULL;
	_data_->_tmp10_ = _data_->_tmp9_;
	_data_->_tmp11_ = NULL;
	_data_->_tmp11_ = g_strconcat (_data_->_tmp10_, ":", NULL);
	_data_->_tmp12_ = NULL;
	_data_->_tmp12_ = _data_->_tmp11_;
	_data_->_tmp13_ = NULL;
	_data_->_tmp13_ = _data_->contact_id;
	_data_->_tmp14_ = NULL;
	_data_->_tmp14_ = g_strconcat (_data_->_tmp12_, _data_->_tmp13_, NULL);
	_data_->_tmp15_ = NULL;
	_data_->_tmp15_ = _data_->_tmp14_;
	_g_free0 (_data_->_tmp12_);
	_data_->iid = _data_->_tmp15_;
	_data_->_tmp16_ = 0UL;
	_data_->_tmp16_ = _data_->self->priv->_persona_type;
	_data_->_tmp17_ = NULL;
	_data_->_tmp17_ = _data_->contact_id;
	_data_->_tmp18_ = NULL;
	_data_->_tmp18_ = _data_->uid;
	_data_->_tmp19_ = NULL;
	_data_->_tmp19_ = _data_->iid;
	_data_->_tmp20_ = NULL;
	_data_->_tmp20_ = g_object_new (_data_->_tmp16_, "display-id", _data_->_tmp17_, "uid", _data_->_tmp18_, "iid", _data_->_tmp19_, "store", _data_->self, "is-user", FALSE, NULL, NULL);
	_data_->_tmp21_ = NULL;
	_data_->_tmp21_ = G_IS_INITIALLY_UNOWNED (_data_->_tmp20_) ? g_object_ref_sink (_data_->_tmp20_) : _data_->_tmp20_;
	_data_->_tmp22_ = NULL;
	_data_->_tmp22_ = G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp21_, FOLKS_DUMMY_TYPE_PERSONA) ? ((FolksDummyPersona*) _data_->_tmp21_) : NULL;
	if (_data_->_tmp22_ == NULL) {
		_g_object_unref0 (_data_->_tmp21_);
	}
	_data_->persona = _data_->_tmp22_;
	_data_->_tmp23_ = NULL;
	_data_->_tmp23_ = _data_->persona;
	_vala_assert (_data_->_tmp23_ != NULL, "persona != null");
	_data_->_tmp24_ = NULL;
	_data_->_tmp24_ = _data_->persona;
	_data_->_tmp25_ = NULL;
	_data_->_tmp25__length1 = 0;
	_data_->_tmp25_ = folks_persona_store_get_always_writeable_properties ((FolksPersonaStore*) _data_->self, &_data_->_tmp25__length1);
	_data_->_tmp26_ = NULL;
	_data_->_tmp26__length1 = 0;
	_data_->_tmp26_ = _data_->_tmp25_;
	_data_->_tmp26__length1 = _data_->_tmp25__length1;
	folks_dummy_persona_update_writeable_properties (_data_->_tmp24_, _data_->_tmp26_, _data_->_tmp26__length1);
	{
		_data_->_tmp27_ = NULL;
		_data_->_tmp27_ = _data_->details;
		_data_->_tmp28_ = NULL;
		_data_->_tmp28_ = folks_persona_store_detail_key (FOLKS_PERSONA_DETAIL_FULL_NAME);
		_data_->_tmp29_ = NULL;
		_data_->_tmp29_ = g_hash_table_lookup (_data_->_tmp27_, _data_->_tmp28_);
		_data_->v = (GValue*) _data_->_tmp29_;
		_data_->_tmp30_ = NULL;
		_data_->_tmp30_ = _data_->persona;
		_data_->_tmp31_ = NULL;
		_data_->_tmp31_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp30_, FOLKS_TYPE_NAME_DETAILS) ? ((FolksNameDetails*) _data_->_tmp30_) : NULL);
		_data_->p_name = _data_->_tmp31_;
		_data_->_tmp33_ = NULL;
		_data_->_tmp33_ = _data_->p_name;
		if (_data_->_tmp33_ != NULL) {
			_data_->_tmp34_ = NULL;
			_data_->_tmp34_ = _data_->v;
			_data_->_tmp32_ = _data_->_tmp34_ != NULL;
		} else {
			_data_->_tmp32_ = FALSE;
		}
		if (_data_->_tmp32_) {
			_data_->_tmp36_ = NULL;
			_data_->_tmp36_ = _data_->v;
			memset (&_data_->_tmp37_, 0, sizeof (GValue));
			_data_->_tmp37_ = (GValue) (*_data_->_tmp36_);
			_data_->_tmp38_ = NULL;
			_data_->_tmp38_ = g_value_get_string (&_data_->_tmp37_);
			_data_->_tmp35_ = _data_->_tmp38_;
			if (_data_->_tmp35_ == NULL) {
				_data_->_tmp35_ = "";
			}
			_data_->_tmp39_ = NULL;
			_data_->_tmp39_ = g_strdup (_data_->_tmp35_);
			_data_->full_name = _data_->_tmp39_;
			_data_->_tmp40_ = NULL;
			_data_->_tmp40_ = _data_->p_name;
			_data_->_tmp41_ = NULL;
			_data_->_tmp41_ = _data_->full_name;
			_data_->_state_ = 1;
			folks_name_details_change_full_name (_data_->_tmp40_, _data_->_tmp41_, folks_dummy_persona_store_add_persona_from_details_ready, _data_);
			return FALSE;
			_state_1:
			folks_name_details_change_full_name_finish (_data_->_tmp40_, _data_->_res_, &_data_->_inner_error_);
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
				_g_free0 (_data_->full_name);
				_g_object_unref0 (_data_->p_name);
				if (_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR) {
					goto __catch2_folks_property_error;
				}
				_g_free0 (_data_->full_name);
				_g_object_unref0 (_data_->p_name);
				_g_object_unref0 (_data_->persona);
				_g_free0 (_data_->iid);
				_g_free0 (_data_->uid);
				_g_free0 (_data_->contact_id);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
				g_clear_error (&_data_->_inner_error_);
				return FALSE;
			}
			_g_free0 (_data_->full_name);
		}
		_data_->_tmp42_ = NULL;
		_data_->_tmp42_ = _data_->details;
		_data_->_tmp43_ = NULL;
		_data_->_tmp43_ = folks_persona_store_detail_key (FOLKS_PERSONA_DETAIL_STRUCTURED_NAME);
		_data_->_tmp44_ = NULL;
		_data_->_tmp44_ = g_hash_table_lookup (_data_->_tmp42_, _data_->_tmp43_);
		_data_->v = (GValue*) _data_->_tmp44_;
		_data_->_tmp46_ = NULL;
		_data_->_tmp46_ = _data_->p_name;
		if (_data_->_tmp46_ != NULL) {
			_data_->_tmp47_ = NULL;
			_data_->_tmp47_ = _data_->v;
			_data_->_tmp45_ = _data_->_tmp47_ != NULL;
		} else {
			_data_->_tmp45_ = FALSE;
		}
		if (_data_->_tmp45_) {
			_data_->_tmp48_ = NULL;
			_data_->_tmp48_ = _data_->v;
			memset (&_data_->_tmp49_, 0, sizeof (GValue));
			_data_->_tmp49_ = (GValue) (*_data_->_tmp48_);
			_data_->_tmp50_ = NULL;
			_data_->_tmp50_ = g_value_get_object (&_data_->_tmp49_);
			_data_->_tmp51_ = NULL;
			_data_->_tmp51_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp50_, FOLKS_TYPE_STRUCTURED_NAME, FolksStructuredName));
			_data_->sname = _data_->_tmp51_;
			_data_->_tmp52_ = NULL;
			_data_->_tmp52_ = _data_->sname;
			if (_data_->_tmp52_ != NULL) {
				_data_->_tmp53_ = NULL;
				_data_->_tmp53_ = _data_->p_name;
				_data_->_tmp54_ = NULL;
				_data_->_tmp54_ = _data_->sname;
				_data_->_state_ = 2;
				folks_name_details_change_structured_name (_data_->_tmp53_, _data_->_tmp54_, folks_dummy_persona_store_add_persona_from_details_ready, _data_);
				return FALSE;
				_state_2:
				folks_name_details_change_structured_name_finish (_data_->_tmp53_, _data_->_res_, &_data_->_inner_error_);
				if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
					_g_object_unref0 (_data_->sname);
					_g_object_unref0 (_data_->p_name);
					if (_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR) {
						goto __catch2_folks_property_error;
					}
					_g_object_unref0 (_data_->sname);
					_g_object_unref0 (_data_->p_name);
					_g_object_unref0 (_data_->persona);
					_g_free0 (_data_->iid);
					_g_free0 (_data_->uid);
					_g_free0 (_data_->contact_id);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
					g_clear_error (&_data_->_inner_error_);
					return FALSE;
				}
			}
			_g_object_unref0 (_data_->sname);
		}
		_data_->_tmp55_ = NULL;
		_data_->_tmp55_ = _data_->details;
		_data_->_tmp56_ = NULL;
		_data_->_tmp56_ = folks_persona_store_detail_key (FOLKS_PERSONA_DETAIL_NICKNAME);
		_data_->_tmp57_ = NULL;
		_data_->_tmp57_ = g_hash_table_lookup (_data_->_tmp55_, _data_->_tmp56_);
		_data_->v = (GValue*) _data_->_tmp57_;
		_data_->_tmp59_ = NULL;
		_data_->_tmp59_ = _data_->p_name;
		if (_data_->_tmp59_ != NULL) {
			_data_->_tmp60_ = NULL;
			_data_->_tmp60_ = _data_->v;
			_data_->_tmp58_ = _data_->_tmp60_ != NULL;
		} else {
			_data_->_tmp58_ = FALSE;
		}
		if (_data_->_tmp58_) {
			_data_->_tmp62_ = NULL;
			_data_->_tmp62_ = _data_->v;
			memset (&_data_->_tmp63_, 0, sizeof (GValue));
			_data_->_tmp63_ = (GValue) (*_data_->_tmp62_);
			_data_->_tmp64_ = NULL;
			_data_->_tmp64_ = g_value_get_string (&_data_->_tmp63_);
			_data_->_tmp61_ = _data_->_tmp64_;
			if (_data_->_tmp61_ == NULL) {
				_data_->_tmp61_ = "";
			}
			_data_->_tmp65_ = NULL;
			_data_->_tmp65_ = g_strdup (_data_->_tmp61_);
			_data_->nickname = _data_->_tmp65_;
			_data_->_tmp66_ = NULL;
			_data_->_tmp66_ = _data_->p_name;
			_data_->_tmp67_ = NULL;
			_data_->_tmp67_ = _data_->nickname;
			_data_->_state_ = 3;
			folks_name_details_change_nickname (_data_->_tmp66_, _data_->_tmp67_, folks_dummy_persona_store_add_persona_from_details_ready, _data_);
			return FALSE;
			_state_3:
			folks_name_details_change_nickname_finish (_data_->_tmp66_, _data_->_res_, &_data_->_inner_error_);
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
				_g_free0 (_data_->nickname);
				_g_object_unref0 (_data_->p_name);
				if (_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR) {
					goto __catch2_folks_property_error;
				}
				_g_free0 (_data_->nickname);
				_g_object_unref0 (_data_->p_name);
				_g_object_unref0 (_data_->persona);
				_g_free0 (_data_->iid);
				_g_free0 (_data_->uid);
				_g_free0 (_data_->contact_id);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
				g_clear_error (&_data_->_inner_error_);
				return FALSE;
			}
			_g_free0 (_data_->nickname);
		}
		_data_->_tmp68_ = NULL;
		_data_->_tmp68_ = _data_->details;
		_data_->_tmp69_ = NULL;
		_data_->_tmp69_ = folks_persona_store_detail_key (FOLKS_PERSONA_DETAIL_EMAIL_ADDRESSES);
		_data_->_tmp70_ = NULL;
		_data_->_tmp70_ = g_hash_table_lookup (_data_->_tmp68_, _data_->_tmp69_);
		_data_->v = (GValue*) _data_->_tmp70_;
		_data_->_tmp71_ = NULL;
		_data_->_tmp71_ = _data_->persona;
		_data_->_tmp72_ = NULL;
		_data_->_tmp72_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp71_, FOLKS_TYPE_EMAIL_DETAILS) ? ((FolksEmailDetails*) _data_->_tmp71_) : NULL);
		_data_->p_email = _data_->_tmp72_;
		_data_->_tmp74_ = NULL;
		_data_->_tmp74_ = _data_->p_email;
		if (_data_->_tmp74_ != NULL) {
			_data_->_tmp75_ = NULL;
			_data_->_tmp75_ = _data_->v;
			_data_->_tmp73_ = _data_->_tmp75_ != NULL;
		} else {
			_data_->_tmp73_ = FALSE;
		}
		if (_data_->_tmp73_) {
			_data_->_tmp76_ = NULL;
			_data_->_tmp76_ = _data_->v;
			memset (&_data_->_tmp77_, 0, sizeof (GValue));
			_data_->_tmp77_ = (GValue) (*_data_->_tmp76_);
			_data_->_tmp78_ = NULL;
			_data_->_tmp78_ = g_value_get_object (&_data_->_tmp77_);
			_data_->_tmp79_ = NULL;
			_data_->_tmp79_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp78_, GEE_TYPE_SET, GeeSet));
			_data_->email_addresses = _data_->_tmp79_;
			_data_->_tmp80_ = NULL;
			_data_->_tmp80_ = _data_->email_addresses;
			if (_data_->_tmp80_ != NULL) {
				_data_->_tmp81_ = NULL;
				_data_->_tmp81_ = _data_->p_email;
				_data_->_tmp82_ = NULL;
				_data_->_tmp82_ = _data_->email_addresses;
				_data_->_state_ = 4;
				folks_email_details_change_email_addresses (_data_->_tmp81_, _data_->_tmp82_, folks_dummy_persona_store_add_persona_from_details_ready, _data_);
				return FALSE;
				_state_4:
				folks_email_details_change_email_addresses_finish (_data_->_tmp81_, _data_->_res_, &_data_->_inner_error_);
				if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
					_g_object_unref0 (_data_->email_addresses);
					_g_object_unref0 (_data_->p_email);
					_g_object_unref0 (_data_->p_name);
					if (_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR) {
						goto __catch2_folks_property_error;
					}
					_g_object_unref0 (_data_->email_addresses);
					_g_object_unref0 (_data_->p_email);
					_g_object_unref0 (_data_->p_name);
					_g_object_unref0 (_data_->persona);
					_g_free0 (_data_->iid);
					_g_free0 (_data_->uid);
					_g_free0 (_data_->contact_id);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
					g_clear_error (&_data_->_inner_error_);
					return FALSE;
				}
			}
			_g_object_unref0 (_data_->email_addresses);
		}
		_data_->_tmp83_ = NULL;
		_data_->_tmp83_ = _data_->details;
		_data_->_tmp84_ = NULL;
		_data_->_tmp84_ = folks_persona_store_detail_key (FOLKS_PERSONA_DETAIL_AVATAR);
		_data_->_tmp85_ = NULL;
		_data_->_tmp85_ = g_hash_table_lookup (_data_->_tmp83_, _data_->_tmp84_);
		_data_->v = (GValue*) _data_->_tmp85_;
		_data_->_tmp86_ = NULL;
		_data_->_tmp86_ = _data_->persona;
		_data_->_tmp87_ = NULL;
		_data_->_tmp87_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp86_, FOLKS_TYPE_AVATAR_DETAILS) ? ((FolksAvatarDetails*) _data_->_tmp86_) : NULL);
		_data_->p_avatar = _data_->_tmp87_;
		_data_->_tmp89_ = NULL;
		_data_->_tmp89_ = _data_->p_avatar;
		if (_data_->_tmp89_ != NULL) {
			_data_->_tmp90_ = NULL;
			_data_->_tmp90_ = _data_->v;
			_data_->_tmp88_ = _data_->_tmp90_ != NULL;
		} else {
			_data_->_tmp88_ = FALSE;
		}
		if (_data_->_tmp88_) {
			_data_->_tmp91_ = NULL;
			_data_->_tmp91_ = _data_->v;
			memset (&_data_->_tmp92_, 0, sizeof (GValue));
			_data_->_tmp92_ = (GValue) (*_data_->_tmp91_);
			_data_->_tmp93_ = NULL;
			_data_->_tmp93_ = g_value_get_object (&_data_->_tmp92_);
			_data_->_tmp94_ = NULL;
			_data_->_tmp94_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp93_, g_loadable_icon_get_type (), GLoadableIcon));
			_data_->avatar = _data_->_tmp94_;
			_data_->_tmp95_ = NULL;
			_data_->_tmp95_ = _data_->avatar;
			if (_data_->_tmp95_ != NULL) {
				_data_->_tmp96_ = NULL;
				_data_->_tmp96_ = _data_->p_avatar;
				_data_->_tmp97_ = NULL;
				_data_->_tmp97_ = _data_->avatar;
				_data_->_state_ = 5;
				folks_avatar_details_change_avatar (_data_->_tmp96_, _data_->_tmp97_, folks_dummy_persona_store_add_persona_from_details_ready, _data_);
				return FALSE;
				_state_5:
				folks_avatar_details_change_avatar_finish (_data_->_tmp96_, _data_->_res_, &_data_->_inner_error_);
				if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
					_g_object_unref0 (_data_->avatar);
					_g_object_unref0 (_data_->p_avatar);
					_g_object_unref0 (_data_->p_email);
					_g_object_unref0 (_data_->p_name);
					if (_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR) {
						goto __catch2_folks_property_error;
					}
					_g_object_unref0 (_data_->avatar);
					_g_object_unref0 (_data_->p_avatar);
					_g_object_unref0 (_data_->p_email);
					_g_object_unref0 (_data_->p_name);
					_g_object_unref0 (_data_->persona);
					_g_free0 (_data_->iid);
					_g_free0 (_data_->uid);
					_g_free0 (_data_->contact_id);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
					g_clear_error (&_data_->_inner_error_);
					return FALSE;
				}
			}
			_g_object_unref0 (_data_->avatar);
		}
		_data_->_tmp98_ = NULL;
		_data_->_tmp98_ = _data_->details;
		_data_->_tmp99_ = NULL;
		_data_->_tmp99_ = folks_persona_store_detail_key (FOLKS_PERSONA_DETAIL_IM_ADDRESSES);
		_data_->_tmp100_ = NULL;
		_data_->_tmp100_ = g_hash_table_lookup (_data_->_tmp98_, _data_->_tmp99_);
		_data_->v = (GValue*) _data_->_tmp100_;
		_data_->_tmp101_ = NULL;
		_data_->_tmp101_ = _data_->persona;
		_data_->_tmp102_ = NULL;
		_data_->_tmp102_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp101_, FOLKS_TYPE_IM_DETAILS) ? ((FolksImDetails*) _data_->_tmp101_) : NULL);
		_data_->p_im = _data_->_tmp102_;
		_data_->_tmp104_ = NULL;
		_data_->_tmp104_ = _data_->p_im;
		if (_data_->_tmp104_ != NULL) {
			_data_->_tmp105_ = NULL;
			_data_->_tmp105_ = _data_->v;
			_data_->_tmp103_ = _data_->_tmp105_ != NULL;
		} else {
			_data_->_tmp103_ = FALSE;
		}
		if (_data_->_tmp103_) {
			_data_->_tmp106_ = NULL;
			_data_->_tmp106_ = _data_->v;
			memset (&_data_->_tmp107_, 0, sizeof (GValue));
			_data_->_tmp107_ = (GValue) (*_data_->_tmp106_);
			_data_->_tmp108_ = NULL;
			_data_->_tmp108_ = g_value_get_object (&_data_->_tmp107_);
			_data_->_tmp109_ = NULL;
			_data_->_tmp109_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp108_, GEE_TYPE_MULTI_MAP, GeeMultiMap));
			_data_->im_addresses = _data_->_tmp109_;
			_data_->_tmp110_ = NULL;
			_data_->_tmp110_ = _data_->im_addresses;
			if (_data_->_tmp110_ != NULL) {
				_data_->_tmp111_ = NULL;
				_data_->_tmp111_ = _data_->p_im;
				_data_->_tmp112_ = NULL;
				_data_->_tmp112_ = _data_->im_addresses;
				_data_->_state_ = 6;
				folks_im_details_change_im_addresses (_data_->_tmp111_, _data_->_tmp112_, folks_dummy_persona_store_add_persona_from_details_ready, _data_);
				return FALSE;
				_state_6:
				folks_im_details_change_im_addresses_finish (_data_->_tmp111_, _data_->_res_, &_data_->_inner_error_);
				if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
					_g_object_unref0 (_data_->im_addresses);
					_g_object_unref0 (_data_->p_im);
					_g_object_unref0 (_data_->p_avatar);
					_g_object_unref0 (_data_->p_email);
					_g_object_unref0 (_data_->p_name);
					if (_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR) {
						goto __catch2_folks_property_error;
					}
					_g_object_unref0 (_data_->im_addresses);
					_g_object_unref0 (_data_->p_im);
					_g_object_unref0 (_data_->p_avatar);
					_g_object_unref0 (_data_->p_email);
					_g_object_unref0 (_data_->p_name);
					_g_object_unref0 (_data_->persona);
					_g_free0 (_data_->iid);
					_g_free0 (_data_->uid);
					_g_free0 (_data_->contact_id);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
					g_clear_error (&_data_->_inner_error_);
					return FALSE;
				}
			}
			_g_object_unref0 (_data_->im_addresses);
		}
		_data_->_tmp113_ = NULL;
		_data_->_tmp113_ = _data_->details;
		_data_->_tmp114_ = NULL;
		_data_->_tmp114_ = folks_persona_store_detail_key (FOLKS_PERSONA_DETAIL_PHONE_NUMBERS);
		_data_->_tmp115_ = NULL;
		_data_->_tmp115_ = g_hash_table_lookup (_data_->_tmp113_, _data_->_tmp114_);
		_data_->v = (GValue*) _data_->_tmp115_;
		_data_->_tmp116_ = NULL;
		_data_->_tmp116_ = _data_->persona;
		_data_->_tmp117_ = NULL;
		_data_->_tmp117_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp116_, FOLKS_TYPE_PHONE_DETAILS) ? ((FolksPhoneDetails*) _data_->_tmp116_) : NULL);
		_data_->p_phone = _data_->_tmp117_;
		_data_->_tmp119_ = NULL;
		_data_->_tmp119_ = _data_->p_phone;
		if (_data_->_tmp119_ != NULL) {
			_data_->_tmp120_ = NULL;
			_data_->_tmp120_ = _data_->v;
			_data_->_tmp118_ = _data_->_tmp120_ != NULL;
		} else {
			_data_->_tmp118_ = FALSE;
		}
		if (_data_->_tmp118_) {
			_data_->_tmp121_ = NULL;
			_data_->_tmp121_ = _data_->v;
			memset (&_data_->_tmp122_, 0, sizeof (GValue));
			_data_->_tmp122_ = (GValue) (*_data_->_tmp121_);
			_data_->_tmp123_ = NULL;
			_data_->_tmp123_ = g_value_get_object (&_data_->_tmp122_);
			_data_->_tmp124_ = NULL;
			_data_->_tmp124_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp123_, GEE_TYPE_SET, GeeSet));
			_data_->phone_numbers = _data_->_tmp124_;
			_data_->_tmp125_ = NULL;
			_data_->_tmp125_ = _data_->phone_numbers;
			if (_data_->_tmp125_ != NULL) {
				_data_->_tmp126_ = NULL;
				_data_->_tmp126_ = _data_->p_phone;
				_data_->_tmp127_ = NULL;
				_data_->_tmp127_ = _data_->phone_numbers;
				_data_->_state_ = 7;
				folks_phone_details_change_phone_numbers (_data_->_tmp126_, _data_->_tmp127_, folks_dummy_persona_store_add_persona_from_details_ready, _data_);
				return FALSE;
				_state_7:
				folks_phone_details_change_phone_numbers_finish (_data_->_tmp126_, _data_->_res_, &_data_->_inner_error_);
				if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
					_g_object_unref0 (_data_->phone_numbers);
					_g_object_unref0 (_data_->p_phone);
					_g_object_unref0 (_data_->p_im);
					_g_object_unref0 (_data_->p_avatar);
					_g_object_unref0 (_data_->p_email);
					_g_object_unref0 (_data_->p_name);
					if (_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR) {
						goto __catch2_folks_property_error;
					}
					_g_object_unref0 (_data_->phone_numbers);
					_g_object_unref0 (_data_->p_phone);
					_g_object_unref0 (_data_->p_im);
					_g_object_unref0 (_data_->p_avatar);
					_g_object_unref0 (_data_->p_email);
					_g_object_unref0 (_data_->p_name);
					_g_object_unref0 (_data_->persona);
					_g_free0 (_data_->iid);
					_g_free0 (_data_->uid);
					_g_free0 (_data_->contact_id);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
					g_clear_error (&_data_->_inner_error_);
					return FALSE;
				}
			}
			_g_object_unref0 (_data_->phone_numbers);
		}
		_data_->_tmp128_ = NULL;
		_data_->_tmp128_ = _data_->details;
		_data_->_tmp129_ = NULL;
		_data_->_tmp129_ = folks_persona_store_detail_key (FOLKS_PERSONA_DETAIL_POSTAL_ADDRESSES);
		_data_->_tmp130_ = NULL;
		_data_->_tmp130_ = g_hash_table_lookup (_data_->_tmp128_, _data_->_tmp129_);
		_data_->v = (GValue*) _data_->_tmp130_;
		_data_->_tmp131_ = NULL;
		_data_->_tmp131_ = _data_->persona;
		_data_->_tmp132_ = NULL;
		_data_->_tmp132_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp131_, FOLKS_TYPE_POSTAL_ADDRESS_DETAILS) ? ((FolksPostalAddressDetails*) _data_->_tmp131_) : NULL);
		_data_->p_postal = _data_->_tmp132_;
		_data_->_tmp134_ = NULL;
		_data_->_tmp134_ = _data_->p_postal;
		if (_data_->_tmp134_ != NULL) {
			_data_->_tmp135_ = NULL;
			_data_->_tmp135_ = _data_->v;
			_data_->_tmp133_ = _data_->_tmp135_ != NULL;
		} else {
			_data_->_tmp133_ = FALSE;
		}
		if (_data_->_tmp133_) {
			_data_->_tmp136_ = NULL;
			_data_->_tmp136_ = _data_->v;
			memset (&_data_->_tmp137_, 0, sizeof (GValue));
			_data_->_tmp137_ = (GValue) (*_data_->_tmp136_);
			_data_->_tmp138_ = NULL;
			_data_->_tmp138_ = g_value_get_object (&_data_->_tmp137_);
			_data_->_tmp139_ = NULL;
			_data_->_tmp139_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp138_, GEE_TYPE_SET, GeeSet));
			_data_->postal_fds = _data_->_tmp139_;
			_data_->_tmp140_ = NULL;
			_data_->_tmp140_ = _data_->postal_fds;
			if (_data_->_tmp140_ != NULL) {
				_data_->_tmp141_ = NULL;
				_data_->_tmp141_ = _data_->p_postal;
				_data_->_tmp142_ = NULL;
				_data_->_tmp142_ = _data_->postal_fds;
				_data_->_state_ = 8;
				folks_postal_address_details_change_postal_addresses (_data_->_tmp141_, _data_->_tmp142_, folks_dummy_persona_store_add_persona_from_details_ready, _data_);
				return FALSE;
				_state_8:
				folks_postal_address_details_change_postal_addresses_finish (_data_->_tmp141_, _data_->_res_, &_data_->_inner_error_);
				if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
					_g_object_unref0 (_data_->postal_fds);
					_g_object_unref0 (_data_->p_postal);
					_g_object_unref0 (_data_->p_phone);
					_g_object_unref0 (_data_->p_im);
					_g_object_unref0 (_data_->p_avatar);
					_g_object_unref0 (_data_->p_email);
					_g_object_unref0 (_data_->p_name);
					if (_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR) {
						goto __catch2_folks_property_error;
					}
					_g_object_unref0 (_data_->postal_fds);
					_g_object_unref0 (_data_->p_postal);
					_g_object_unref0 (_data_->p_phone);
					_g_object_unref0 (_data_->p_im);
					_g_object_unref0 (_data_->p_avatar);
					_g_object_unref0 (_data_->p_email);
					_g_object_unref0 (_data_->p_name);
					_g_object_unref0 (_data_->persona);
					_g_free0 (_data_->iid);
					_g_free0 (_data_->uid);
					_g_free0 (_data_->contact_id);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
					g_clear_error (&_data_->_inner_error_);
					return FALSE;
				}
			}
			_g_object_unref0 (_data_->postal_fds);
		}
		_data_->_tmp143_ = NULL;
		_data_->_tmp143_ = _data_->details;
		_data_->_tmp144_ = NULL;
		_data_->_tmp144_ = folks_persona_store_detail_key (FOLKS_PERSONA_DETAIL_LOCAL_IDS);
		_data_->_tmp145_ = NULL;
		_data_->_tmp145_ = g_hash_table_lookup (_data_->_tmp143_, _data_->_tmp144_);
		_data_->v = (GValue*) _data_->_tmp145_;
		_data_->_tmp146_ = NULL;
		_data_->_tmp146_ = _data_->persona;
		_data_->_tmp147_ = NULL;
		_data_->_tmp147_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp146_, FOLKS_TYPE_LOCAL_ID_DETAILS) ? ((FolksLocalIdDetails*) _data_->_tmp146_) : NULL);
		_data_->p_local = _data_->_tmp147_;
		_data_->_tmp149_ = NULL;
		_data_->_tmp149_ = _data_->p_local;
		if (_data_->_tmp149_ != NULL) {
			_data_->_tmp150_ = NULL;
			_data_->_tmp150_ = _data_->v;
			_data_->_tmp148_ = _data_->_tmp150_ != NULL;
		} else {
			_data_->_tmp148_ = FALSE;
		}
		if (_data_->_tmp148_) {
			_data_->_tmp151_ = NULL;
			_data_->_tmp151_ = _data_->v;
			memset (&_data_->_tmp152_, 0, sizeof (GValue));
			_data_->_tmp152_ = (GValue) (*_data_->_tmp151_);
			_data_->_tmp153_ = NULL;
			_data_->_tmp153_ = g_value_get_object (&_data_->_tmp152_);
			_data_->_tmp154_ = NULL;
			_data_->_tmp154_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp153_, GEE_TYPE_SET, GeeSet));
			_data_->local_ids = _data_->_tmp154_;
			_data_->_tmp155_ = NULL;
			_data_->_tmp155_ = _data_->local_ids;
			if (_data_->_tmp155_ != NULL) {
				_data_->_tmp156_ = NULL;
				_data_->_tmp156_ = _data_->p_local;
				_data_->_tmp157_ = NULL;
				_data_->_tmp157_ = _data_->local_ids;
				_data_->_state_ = 9;
				folks_local_id_details_change_local_ids (_data_->_tmp156_, _data_->_tmp157_, folks_dummy_persona_store_add_persona_from_details_ready, _data_);
				return FALSE;
				_state_9:
				folks_local_id_details_change_local_ids_finish (_data_->_tmp156_, _data_->_res_, &_data_->_inner_error_);
				if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
					_g_object_unref0 (_data_->local_ids);
					_g_object_unref0 (_data_->p_local);
					_g_object_unref0 (_data_->p_postal);
					_g_object_unref0 (_data_->p_phone);
					_g_object_unref0 (_data_->p_im);
					_g_object_unref0 (_data_->p_avatar);
					_g_object_unref0 (_data_->p_email);
					_g_object_unref0 (_data_->p_name);
					if (_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR) {
						goto __catch2_folks_property_error;
					}
					_g_object_unref0 (_data_->local_ids);
					_g_object_unref0 (_data_->p_local);
					_g_object_unref0 (_data_->p_postal);
					_g_object_unref0 (_data_->p_phone);
					_g_object_unref0 (_data_->p_im);
					_g_object_unref0 (_data_->p_avatar);
					_g_object_unref0 (_data_->p_email);
					_g_object_unref0 (_data_->p_name);
					_g_object_unref0 (_data_->persona);
					_g_free0 (_data_->iid);
					_g_free0 (_data_->uid);
					_g_free0 (_data_->contact_id);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
					g_clear_error (&_data_->_inner_error_);
					return FALSE;
				}
			}
			_g_object_unref0 (_data_->local_ids);
		}
		_data_->_tmp158_ = NULL;
		_data_->_tmp158_ = _data_->details;
		_data_->_tmp159_ = NULL;
		_data_->_tmp159_ = folks_persona_store_detail_key (FOLKS_PERSONA_DETAIL_WEB_SERVICE_ADDRESSES);
		_data_->_tmp160_ = NULL;
		_data_->_tmp160_ = g_hash_table_lookup (_data_->_tmp158_, _data_->_tmp159_);
		_data_->v = (GValue*) _data_->_tmp160_;
		_data_->_tmp161_ = NULL;
		_data_->_tmp161_ = _data_->persona;
		_data_->_tmp162_ = NULL;
		_data_->_tmp162_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp161_, FOLKS_TYPE_WEB_SERVICE_DETAILS) ? ((FolksWebServiceDetails*) _data_->_tmp161_) : NULL);
		_data_->p_web = _data_->_tmp162_;
		_data_->_tmp164_ = NULL;
		_data_->_tmp164_ = _data_->p_web;
		if (_data_->_tmp164_ != NULL) {
			_data_->_tmp165_ = NULL;
			_data_->_tmp165_ = _data_->v;
			_data_->_tmp163_ = _data_->_tmp165_ != NULL;
		} else {
			_data_->_tmp163_ = FALSE;
		}
		if (_data_->_tmp163_) {
			_data_->_tmp166_ = NULL;
			_data_->_tmp166_ = _data_->v;
			memset (&_data_->_tmp167_, 0, sizeof (GValue));
			_data_->_tmp167_ = (GValue) (*_data_->_tmp166_);
			_data_->_tmp168_ = NULL;
			_data_->_tmp168_ = g_value_get_object (&_data_->_tmp167_);
			_data_->_tmp169_ = NULL;
			_data_->_tmp169_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp168_, GEE_TYPE_HASH_MULTI_MAP, GeeHashMultiMap));
			_data_->addrs = _data_->_tmp169_;
			_data_->_tmp170_ = NULL;
			_data_->_tmp170_ = _data_->addrs;
			if (_data_->_tmp170_ != NULL) {
				_data_->_tmp171_ = NULL;
				_data_->_tmp171_ = _data_->p_web;
				_data_->_tmp172_ = NULL;
				_data_->_tmp172_ = _data_->addrs;
				_data_->_state_ = 10;
				folks_web_service_details_change_web_service_addresses (_data_->_tmp171_, (GeeMultiMap*) _data_->_tmp172_, folks_dummy_persona_store_add_persona_from_details_ready, _data_);
				return FALSE;
				_state_10:
				folks_web_service_details_change_web_service_addresses_finish (_data_->_tmp171_, _data_->_res_, &_data_->_inner_error_);
				if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
					_g_object_unref0 (_data_->addrs);
					_g_object_unref0 (_data_->p_web);
					_g_object_unref0 (_data_->p_local);
					_g_object_unref0 (_data_->p_postal);
					_g_object_unref0 (_data_->p_phone);
					_g_object_unref0 (_data_->p_im);
					_g_object_unref0 (_data_->p_avatar);
					_g_object_unref0 (_data_->p_email);
					_g_object_unref0 (_data_->p_name);
					if (_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR) {
						goto __catch2_folks_property_error;
					}
					_g_object_unref0 (_data_->addrs);
					_g_object_unref0 (_data_->p_web);
					_g_object_unref0 (_data_->p_local);
					_g_object_unref0 (_data_->p_postal);
					_g_object_unref0 (_data_->p_phone);
					_g_object_unref0 (_data_->p_im);
					_g_object_unref0 (_data_->p_avatar);
					_g_object_unref0 (_data_->p_email);
					_g_object_unref0 (_data_->p_name);
					_g_object_unref0 (_data_->persona);
					_g_free0 (_data_->iid);
					_g_free0 (_data_->uid);
					_g_free0 (_data_->contact_id);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
					g_clear_error (&_data_->_inner_error_);
					return FALSE;
				}
			}
			_g_object_unref0 (_data_->addrs);
		}
		_data_->_tmp173_ = NULL;
		_data_->_tmp173_ = _data_->details;
		_data_->_tmp174_ = NULL;
		_data_->_tmp174_ = folks_persona_store_detail_key (FOLKS_PERSONA_DETAIL_NOTES);
		_data_->_tmp175_ = NULL;
		_data_->_tmp175_ = g_hash_table_lookup (_data_->_tmp173_, _data_->_tmp174_);
		_data_->v = (GValue*) _data_->_tmp175_;
		_data_->_tmp176_ = NULL;
		_data_->_tmp176_ = _data_->persona;
		_data_->_tmp177_ = NULL;
		_data_->_tmp177_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp176_, FOLKS_TYPE_NOTE_DETAILS) ? ((FolksNoteDetails*) _data_->_tmp176_) : NULL);
		_data_->p_note = _data_->_tmp177_;
		_data_->_tmp179_ = NULL;
		_data_->_tmp179_ = _data_->p_note;
		if (_data_->_tmp179_ != NULL) {
			_data_->_tmp180_ = NULL;
			_data_->_tmp180_ = _data_->v;
			_data_->_tmp178_ = _data_->_tmp180_ != NULL;
		} else {
			_data_->_tmp178_ = FALSE;
		}
		if (_data_->_tmp178_) {
			_data_->_tmp181_ = NULL;
			_data_->_tmp181_ = _data_->v;
			memset (&_data_->_tmp182_, 0, sizeof (GValue));
			_data_->_tmp182_ = (GValue) (*_data_->_tmp181_);
			_data_->_tmp183_ = NULL;
			_data_->_tmp183_ = g_value_get_object (&_data_->_tmp182_);
			_data_->_tmp184_ = NULL;
			_data_->_tmp184_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp183_, GEE_TYPE_HASH_SET, GeeHashSet));
			_data_->notes = _data_->_tmp184_;
			_data_->_tmp185_ = NULL;
			_data_->_tmp185_ = _data_->notes;
			if (_data_->_tmp185_ != NULL) {
				_data_->_tmp186_ = NULL;
				_data_->_tmp186_ = _data_->p_note;
				_data_->_tmp187_ = NULL;
				_data_->_tmp187_ = _data_->notes;
				_data_->_state_ = 11;
				folks_note_details_change_notes (_data_->_tmp186_, (GeeSet*) _data_->_tmp187_, folks_dummy_persona_store_add_persona_from_details_ready, _data_);
				return FALSE;
				_state_11:
				folks_note_details_change_notes_finish (_data_->_tmp186_, _data_->_res_, &_data_->_inner_error_);
				if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
					_g_object_unref0 (_data_->notes);
					_g_object_unref0 (_data_->p_note);
					_g_object_unref0 (_data_->p_web);
					_g_object_unref0 (_data_->p_local);
					_g_object_unref0 (_data_->p_postal);
					_g_object_unref0 (_data_->p_phone);
					_g_object_unref0 (_data_->p_im);
					_g_object_unref0 (_data_->p_avatar);
					_g_object_unref0 (_data_->p_email);
					_g_object_unref0 (_data_->p_name);
					if (_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR) {
						goto __catch2_folks_property_error;
					}
					_g_object_unref0 (_data_->notes);
					_g_object_unref0 (_data_->p_note);
					_g_object_unref0 (_data_->p_web);
					_g_object_unref0 (_data_->p_local);
					_g_object_unref0 (_data_->p_postal);
					_g_object_unref0 (_data_->p_phone);
					_g_object_unref0 (_data_->p_im);
					_g_object_unref0 (_data_->p_avatar);
					_g_object_unref0 (_data_->p_email);
					_g_object_unref0 (_data_->p_name);
					_g_object_unref0 (_data_->persona);
					_g_free0 (_data_->iid);
					_g_free0 (_data_->uid);
					_g_free0 (_data_->contact_id);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
					g_clear_error (&_data_->_inner_error_);
					return FALSE;
				}
			}
			_g_object_unref0 (_data_->notes);
		}
		_data_->_tmp188_ = NULL;
		_data_->_tmp188_ = _data_->details;
		_data_->_tmp189_ = NULL;
		_data_->_tmp189_ = folks_persona_store_detail_key (FOLKS_PERSONA_DETAIL_GENDER);
		_data_->_tmp190_ = NULL;
		_data_->_tmp190_ = g_hash_table_lookup (_data_->_tmp188_, _data_->_tmp189_);
		_data_->v = (GValue*) _data_->_tmp190_;
		_data_->_tmp191_ = NULL;
		_data_->_tmp191_ = _data_->persona;
		_data_->_tmp192_ = NULL;
		_data_->_tmp192_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp191_, FOLKS_TYPE_GENDER_DETAILS) ? ((FolksGenderDetails*) _data_->_tmp191_) : NULL);
		_data_->p_gender = _data_->_tmp192_;
		_data_->_tmp194_ = NULL;
		_data_->_tmp194_ = _data_->p_gender;
		if (_data_->_tmp194_ != NULL) {
			_data_->_tmp195_ = NULL;
			_data_->_tmp195_ = _data_->v;
			_data_->_tmp193_ = _data_->_tmp195_ != NULL;
		} else {
			_data_->_tmp193_ = FALSE;
		}
		if (_data_->_tmp193_) {
			_data_->_tmp196_ = NULL;
			_data_->_tmp196_ = _data_->v;
			memset (&_data_->_tmp197_, 0, sizeof (GValue));
			_data_->_tmp197_ = (GValue) (*_data_->_tmp196_);
			_data_->_tmp198_ = 0;
			_data_->_tmp198_ = g_value_get_enum (&_data_->_tmp197_);
			_data_->gender = (FolksGender) _data_->_tmp198_;
			_data_->_tmp199_ = NULL;
			_data_->_tmp199_ = _data_->p_gender;
			_data_->_tmp200_ = 0;
			_data_->_tmp200_ = _data_->gender;
			_data_->_state_ = 12;
			folks_gender_details_change_gender (_data_->_tmp199_, _data_->_tmp200_, folks_dummy_persona_store_add_persona_from_details_ready, _data_);
			return FALSE;
			_state_12:
			folks_gender_details_change_gender_finish (_data_->_tmp199_, _data_->_res_, &_data_->_inner_error_);
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
				_g_object_unref0 (_data_->p_gender);
				_g_object_unref0 (_data_->p_note);
				_g_object_unref0 (_data_->p_web);
				_g_object_unref0 (_data_->p_local);
				_g_object_unref0 (_data_->p_postal);
				_g_object_unref0 (_data_->p_phone);
				_g_object_unref0 (_data_->p_im);
				_g_object_unref0 (_data_->p_avatar);
				_g_object_unref0 (_data_->p_email);
				_g_object_unref0 (_data_->p_name);
				if (_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR) {
					goto __catch2_folks_property_error;
				}
				_g_object_unref0 (_data_->p_gender);
				_g_object_unref0 (_data_->p_note);
				_g_object_unref0 (_data_->p_web);
				_g_object_unref0 (_data_->p_local);
				_g_object_unref0 (_data_->p_postal);
				_g_object_unref0 (_data_->p_phone);
				_g_object_unref0 (_data_->p_im);
				_g_object_unref0 (_data_->p_avatar);
				_g_object_unref0 (_data_->p_email);
				_g_object_unref0 (_data_->p_name);
				_g_object_unref0 (_data_->persona);
				_g_free0 (_data_->iid);
				_g_free0 (_data_->uid);
				_g_free0 (_data_->contact_id);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
				g_clear_error (&_data_->_inner_error_);
				return FALSE;
			}
		}
		_data_->_tmp201_ = NULL;
		_data_->_tmp201_ = _data_->details;
		_data_->_tmp202_ = NULL;
		_data_->_tmp202_ = folks_persona_store_detail_key (FOLKS_PERSONA_DETAIL_URLS);
		_data_->_tmp203_ = NULL;
		_data_->_tmp203_ = g_hash_table_lookup (_data_->_tmp201_, _data_->_tmp202_);
		_data_->v = (GValue*) _data_->_tmp203_;
		_data_->_tmp204_ = NULL;
		_data_->_tmp204_ = _data_->persona;
		_data_->_tmp205_ = NULL;
		_data_->_tmp205_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp204_, FOLKS_TYPE_URL_DETAILS) ? ((FolksUrlDetails*) _data_->_tmp204_) : NULL);
		_data_->p_url = _data_->_tmp205_;
		_data_->_tmp207_ = NULL;
		_data_->_tmp207_ = _data_->p_url;
		if (_data_->_tmp207_ != NULL) {
			_data_->_tmp208_ = NULL;
			_data_->_tmp208_ = _data_->v;
			_data_->_tmp206_ = _data_->_tmp208_ != NULL;
		} else {
			_data_->_tmp206_ = FALSE;
		}
		if (_data_->_tmp206_) {
			_data_->_tmp209_ = NULL;
			_data_->_tmp209_ = _data_->v;
			memset (&_data_->_tmp210_, 0, sizeof (GValue));
			_data_->_tmp210_ = (GValue) (*_data_->_tmp209_);
			_data_->_tmp211_ = NULL;
			_data_->_tmp211_ = g_value_get_object (&_data_->_tmp210_);
			_data_->_tmp212_ = NULL;
			_data_->_tmp212_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp211_, GEE_TYPE_SET, GeeSet));
			_data_->urls = _data_->_tmp212_;
			_data_->_tmp213_ = NULL;
			_data_->_tmp213_ = _data_->urls;
			if (_data_->_tmp213_ != NULL) {
				_data_->_tmp214_ = NULL;
				_data_->_tmp214_ = _data_->p_url;
				_data_->_tmp215_ = NULL;
				_data_->_tmp215_ = _data_->urls;
				_data_->_state_ = 13;
				folks_url_details_change_urls (_data_->_tmp214_, _data_->_tmp215_, folks_dummy_persona_store_add_persona_from_details_ready, _data_);
				return FALSE;
				_state_13:
				folks_url_details_change_urls_finish (_data_->_tmp214_, _data_->_res_, &_data_->_inner_error_);
				if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
					_g_object_unref0 (_data_->urls);
					_g_object_unref0 (_data_->p_url);
					_g_object_unref0 (_data_->p_gender);
					_g_object_unref0 (_data_->p_note);
					_g_object_unref0 (_data_->p_web);
					_g_object_unref0 (_data_->p_local);
					_g_object_unref0 (_data_->p_postal);
					_g_object_unref0 (_data_->p_phone);
					_g_object_unref0 (_data_->p_im);
					_g_object_unref0 (_data_->p_avatar);
					_g_object_unref0 (_data_->p_email);
					_g_object_unref0 (_data_->p_name);
					if (_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR) {
						goto __catch2_folks_property_error;
					}
					_g_object_unref0 (_data_->urls);
					_g_object_unref0 (_data_->p_url);
					_g_object_unref0 (_data_->p_gender);
					_g_object_unref0 (_data_->p_note);
					_g_object_unref0 (_data_->p_web);
					_g_object_unref0 (_data_->p_local);
					_g_object_unref0 (_data_->p_postal);
					_g_object_unref0 (_data_->p_phone);
					_g_object_unref0 (_data_->p_im);
					_g_object_unref0 (_data_->p_avatar);
					_g_object_unref0 (_data_->p_email);
					_g_object_unref0 (_data_->p_name);
					_g_object_unref0 (_data_->persona);
					_g_free0 (_data_->iid);
					_g_free0 (_data_->uid);
					_g_free0 (_data_->contact_id);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
					g_clear_error (&_data_->_inner_error_);
					return FALSE;
				}
			}
			_g_object_unref0 (_data_->urls);
		}
		_data_->_tmp216_ = NULL;
		_data_->_tmp216_ = _data_->details;
		_data_->_tmp217_ = NULL;
		_data_->_tmp217_ = folks_persona_store_detail_key (FOLKS_PERSONA_DETAIL_BIRTHDAY);
		_data_->_tmp218_ = NULL;
		_data_->_tmp218_ = g_hash_table_lookup (_data_->_tmp216_, _data_->_tmp217_);
		_data_->v = (GValue*) _data_->_tmp218_;
		_data_->_tmp219_ = NULL;
		_data_->_tmp219_ = _data_->persona;
		_data_->_tmp220_ = NULL;
		_data_->_tmp220_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp219_, FOLKS_TYPE_BIRTHDAY_DETAILS) ? ((FolksBirthdayDetails*) _data_->_tmp219_) : NULL);
		_data_->p_birthday = _data_->_tmp220_;
		_data_->_tmp222_ = NULL;
		_data_->_tmp222_ = _data_->p_birthday;
		if (_data_->_tmp222_ != NULL) {
			_data_->_tmp223_ = NULL;
			_data_->_tmp223_ = _data_->v;
			_data_->_tmp221_ = _data_->_tmp223_ != NULL;
		} else {
			_data_->_tmp221_ = FALSE;
		}
		if (_data_->_tmp221_) {
			_data_->_tmp224_ = NULL;
			_data_->_tmp224_ = _data_->v;
			memset (&_data_->_tmp225_, 0, sizeof (GValue));
			_data_->_tmp225_ = (GValue) (*_data_->_tmp224_);
			_data_->_tmp226_ = NULL;
			_data_->_tmp226_ = g_value_get_boxed (&_data_->_tmp225_);
			_data_->_tmp227_ = NULL;
			_data_->_tmp227_ = _g_date_time_ref0 ((GDateTime*) _data_->_tmp226_);
			_data_->birthday = _data_->_tmp227_;
			_data_->_tmp228_ = NULL;
			_data_->_tmp228_ = _data_->birthday;
			if (_data_->_tmp228_ != NULL) {
				_data_->_tmp229_ = NULL;
				_data_->_tmp229_ = _data_->p_birthday;
				_data_->_tmp230_ = NULL;
				_data_->_tmp230_ = _data_->birthday;
				_data_->_state_ = 14;
				folks_birthday_details_change_birthday (_data_->_tmp229_, _data_->_tmp230_, folks_dummy_persona_store_add_persona_from_details_ready, _data_);
				return FALSE;
				_state_14:
				folks_birthday_details_change_birthday_finish (_data_->_tmp229_, _data_->_res_, &_data_->_inner_error_);
				if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
					_g_date_time_unref0 (_data_->birthday);
					_g_object_unref0 (_data_->p_birthday);
					_g_object_unref0 (_data_->p_url);
					_g_object_unref0 (_data_->p_gender);
					_g_object_unref0 (_data_->p_note);
					_g_object_unref0 (_data_->p_web);
					_g_object_unref0 (_data_->p_local);
					_g_object_unref0 (_data_->p_postal);
					_g_object_unref0 (_data_->p_phone);
					_g_object_unref0 (_data_->p_im);
					_g_object_unref0 (_data_->p_avatar);
					_g_object_unref0 (_data_->p_email);
					_g_object_unref0 (_data_->p_name);
					if (_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR) {
						goto __catch2_folks_property_error;
					}
					_g_date_time_unref0 (_data_->birthday);
					_g_object_unref0 (_data_->p_birthday);
					_g_object_unref0 (_data_->p_url);
					_g_object_unref0 (_data_->p_gender);
					_g_object_unref0 (_data_->p_note);
					_g_object_unref0 (_data_->p_web);
					_g_object_unref0 (_data_->p_local);
					_g_object_unref0 (_data_->p_postal);
					_g_object_unref0 (_data_->p_phone);
					_g_object_unref0 (_data_->p_im);
					_g_object_unref0 (_data_->p_avatar);
					_g_object_unref0 (_data_->p_email);
					_g_object_unref0 (_data_->p_name);
					_g_object_unref0 (_data_->persona);
					_g_free0 (_data_->iid);
					_g_free0 (_data_->uid);
					_g_free0 (_data_->contact_id);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
					g_clear_error (&_data_->_inner_error_);
					return FALSE;
				}
			}
			_g_date_time_unref0 (_data_->birthday);
		}
		_data_->_tmp231_ = NULL;
		_data_->_tmp231_ = _data_->details;
		_data_->_tmp232_ = NULL;
		_data_->_tmp232_ = folks_persona_store_detail_key (FOLKS_PERSONA_DETAIL_ROLES);
		_data_->_tmp233_ = NULL;
		_data_->_tmp233_ = g_hash_table_lookup (_data_->_tmp231_, _data_->_tmp232_);
		_data_->v = (GValue*) _data_->_tmp233_;
		_data_->_tmp234_ = NULL;
		_data_->_tmp234_ = _data_->persona;
		_data_->_tmp235_ = NULL;
		_data_->_tmp235_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp234_, FOLKS_TYPE_ROLE_DETAILS) ? ((FolksRoleDetails*) _data_->_tmp234_) : NULL);
		_data_->p_role = _data_->_tmp235_;
		_data_->_tmp237_ = NULL;
		_data_->_tmp237_ = _data_->p_role;
		if (_data_->_tmp237_ != NULL) {
			_data_->_tmp238_ = NULL;
			_data_->_tmp238_ = _data_->v;
			_data_->_tmp236_ = _data_->_tmp238_ != NULL;
		} else {
			_data_->_tmp236_ = FALSE;
		}
		if (_data_->_tmp236_) {
			_data_->_tmp239_ = NULL;
			_data_->_tmp239_ = _data_->v;
			memset (&_data_->_tmp240_, 0, sizeof (GValue));
			_data_->_tmp240_ = (GValue) (*_data_->_tmp239_);
			_data_->_tmp241_ = NULL;
			_data_->_tmp241_ = g_value_get_object (&_data_->_tmp240_);
			_data_->_tmp242_ = NULL;
			_data_->_tmp242_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp241_, GEE_TYPE_SET, GeeSet));
			_data_->roles = _data_->_tmp242_;
			_data_->_tmp243_ = NULL;
			_data_->_tmp243_ = _data_->roles;
			if (_data_->_tmp243_ != NULL) {
				_data_->_tmp244_ = NULL;
				_data_->_tmp244_ = _data_->p_role;
				_data_->_tmp245_ = NULL;
				_data_->_tmp245_ = _data_->roles;
				_data_->_state_ = 15;
				folks_role_details_change_roles (_data_->_tmp244_, _data_->_tmp245_, folks_dummy_persona_store_add_persona_from_details_ready, _data_);
				return FALSE;
				_state_15:
				folks_role_details_change_roles_finish (_data_->_tmp244_, _data_->_res_, &_data_->_inner_error_);
				if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
					_g_object_unref0 (_data_->roles);
					_g_object_unref0 (_data_->p_role);
					_g_object_unref0 (_data_->p_birthday);
					_g_object_unref0 (_data_->p_url);
					_g_object_unref0 (_data_->p_gender);
					_g_object_unref0 (_data_->p_note);
					_g_object_unref0 (_data_->p_web);
					_g_object_unref0 (_data_->p_local);
					_g_object_unref0 (_data_->p_postal);
					_g_object_unref0 (_data_->p_phone);
					_g_object_unref0 (_data_->p_im);
					_g_object_unref0 (_data_->p_avatar);
					_g_object_unref0 (_data_->p_email);
					_g_object_unref0 (_data_->p_name);
					if (_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR) {
						goto __catch2_folks_property_error;
					}
					_g_object_unref0 (_data_->roles);
					_g_object_unref0 (_data_->p_role);
					_g_object_unref0 (_data_->p_birthday);
					_g_object_unref0 (_data_->p_url);
					_g_object_unref0 (_data_->p_gender);
					_g_object_unref0 (_data_->p_note);
					_g_object_unref0 (_data_->p_web);
					_g_object_unref0 (_data_->p_local);
					_g_object_unref0 (_data_->p_postal);
					_g_object_unref0 (_data_->p_phone);
					_g_object_unref0 (_data_->p_im);
					_g_object_unref0 (_data_->p_avatar);
					_g_object_unref0 (_data_->p_email);
					_g_object_unref0 (_data_->p_name);
					_g_object_unref0 (_data_->persona);
					_g_free0 (_data_->iid);
					_g_free0 (_data_->uid);
					_g_free0 (_data_->contact_id);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
					g_clear_error (&_data_->_inner_error_);
					return FALSE;
				}
			}
			_g_object_unref0 (_data_->roles);
		}
		_data_->_tmp246_ = NULL;
		_data_->_tmp246_ = _data_->details;
		_data_->_tmp247_ = NULL;
		_data_->_tmp247_ = folks_persona_store_detail_key (FOLKS_PERSONA_DETAIL_IS_FAVOURITE);
		_data_->_tmp248_ = NULL;
		_data_->_tmp248_ = g_hash_table_lookup (_data_->_tmp246_, _data_->_tmp247_);
		_data_->v = (GValue*) _data_->_tmp248_;
		_data_->_tmp249_ = NULL;
		_data_->_tmp249_ = _data_->persona;
		_data_->_tmp250_ = NULL;
		_data_->_tmp250_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp249_, FOLKS_TYPE_FAVOURITE_DETAILS) ? ((FolksFavouriteDetails*) _data_->_tmp249_) : NULL);
		_data_->p_favourite = _data_->_tmp250_;
		_data_->_tmp252_ = NULL;
		_data_->_tmp252_ = _data_->p_favourite;
		if (_data_->_tmp252_ != NULL) {
			_data_->_tmp253_ = NULL;
			_data_->_tmp253_ = _data_->v;
			_data_->_tmp251_ = _data_->_tmp253_ != NULL;
		} else {
			_data_->_tmp251_ = FALSE;
		}
		if (_data_->_tmp251_) {
			_data_->_tmp254_ = NULL;
			_data_->_tmp254_ = _data_->v;
			memset (&_data_->_tmp255_, 0, sizeof (GValue));
			_data_->_tmp255_ = (GValue) (*_data_->_tmp254_);
			_data_->_tmp256_ = FALSE;
			_data_->_tmp256_ = g_value_get_boolean (&_data_->_tmp255_);
			_data_->is_fav = _data_->_tmp256_;
			_data_->_tmp257_ = NULL;
			_data_->_tmp257_ = _data_->p_favourite;
			_data_->_tmp258_ = FALSE;
			_data_->_tmp258_ = _data_->is_fav;
			_data_->_state_ = 16;
			folks_favourite_details_change_is_favourite (_data_->_tmp257_, _data_->_tmp258_, folks_dummy_persona_store_add_persona_from_details_ready, _data_);
			return FALSE;
			_state_16:
			folks_favourite_details_change_is_favourite_finish (_data_->_tmp257_, _data_->_res_, &_data_->_inner_error_);
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
				_g_object_unref0 (_data_->p_favourite);
				_g_object_unref0 (_data_->p_role);
				_g_object_unref0 (_data_->p_birthday);
				_g_object_unref0 (_data_->p_url);
				_g_object_unref0 (_data_->p_gender);
				_g_object_unref0 (_data_->p_note);
				_g_object_unref0 (_data_->p_web);
				_g_object_unref0 (_data_->p_local);
				_g_object_unref0 (_data_->p_postal);
				_g_object_unref0 (_data_->p_phone);
				_g_object_unref0 (_data_->p_im);
				_g_object_unref0 (_data_->p_avatar);
				_g_object_unref0 (_data_->p_email);
				_g_object_unref0 (_data_->p_name);
				if (_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR) {
					goto __catch2_folks_property_error;
				}
				_g_object_unref0 (_data_->p_favourite);
				_g_object_unref0 (_data_->p_role);
				_g_object_unref0 (_data_->p_birthday);
				_g_object_unref0 (_data_->p_url);
				_g_object_unref0 (_data_->p_gender);
				_g_object_unref0 (_data_->p_note);
				_g_object_unref0 (_data_->p_web);
				_g_object_unref0 (_data_->p_local);
				_g_object_unref0 (_data_->p_postal);
				_g_object_unref0 (_data_->p_phone);
				_g_object_unref0 (_data_->p_im);
				_g_object_unref0 (_data_->p_avatar);
				_g_object_unref0 (_data_->p_email);
				_g_object_unref0 (_data_->p_name);
				_g_object_unref0 (_data_->persona);
				_g_free0 (_data_->iid);
				_g_free0 (_data_->uid);
				_g_free0 (_data_->contact_id);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
				g_clear_error (&_data_->_inner_error_);
				return FALSE;
			}
		}
		_g_object_unref0 (_data_->p_favourite);
		_g_object_unref0 (_data_->p_role);
		_g_object_unref0 (_data_->p_birthday);
		_g_object_unref0 (_data_->p_url);
		_g_object_unref0 (_data_->p_gender);
		_g_object_unref0 (_data_->p_note);
		_g_object_unref0 (_data_->p_web);
		_g_object_unref0 (_data_->p_local);
		_g_object_unref0 (_data_->p_postal);
		_g_object_unref0 (_data_->p_phone);
		_g_object_unref0 (_data_->p_im);
		_g_object_unref0 (_data_->p_avatar);
		_g_object_unref0 (_data_->p_email);
		_g_object_unref0 (_data_->p_name);
	}
	goto __finally2;
	__catch2_folks_property_error:
	{
		_data_->e1 = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp259_ = NULL;
		_data_->_tmp259_ = _data_->e1;
		_data_->_tmp260_ = NULL;
		_data_->_tmp260_ = _data_->_tmp259_->message;
		_data_->_tmp261_ = NULL;
		_data_->_tmp261_ = g_error_new (FOLKS_PERSONA_STORE_ERROR, FOLKS_PERSONA_STORE_ERROR_CREATE_FAILED, "Setting a property on the new persona failed: %s", _data_->_tmp260_);
		_data_->_inner_error_ = _data_->_tmp261_;
		_g_error_free0 (_data_->e1);
		goto __finally2;
	}
	__finally2:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		if (_data_->_inner_error_->domain == FOLKS_PERSONA_STORE_ERROR) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_object_unref0 (_data_->persona);
			_g_free0 (_data_->iid);
			_g_free0 (_data_->uid);
			_g_free0 (_data_->contact_id);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_object_unref0 (_data_->persona);
			_g_free0 (_data_->iid);
			_g_free0 (_data_->uid);
			_g_free0 (_data_->contact_id);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	_data_->_tmp262_ = NULL;
	_data_->_tmp262__target = NULL;
	_data_->_tmp262_ = folks_dummy_persona_store_get_add_persona_from_details_mock (_data_->self, &_data_->_tmp262__target);
	_data_->_tmp263_ = NULL;
	_data_->_tmp263__target = NULL;
	_data_->_tmp263_ = _data_->_tmp262_;
	_data_->_tmp263__target = _data_->_tmp262__target;
	if (_data_->_tmp263_ != NULL) {
		_data_->_tmp264_ = NULL;
		_data_->_tmp264__target = NULL;
		_data_->_tmp264_ = folks_dummy_persona_store_get_add_persona_from_details_mock (_data_->self, &_data_->_tmp264__target);
		_data_->_tmp265_ = NULL;
		_data_->_tmp265__target = NULL;
		_data_->_tmp265_ = _data_->_tmp264_;
		_data_->_tmp265__target = _data_->_tmp264__target;
		_data_->_tmp266_ = NULL;
		_data_->_tmp266_ = _data_->persona;
		_data_->_tmp267_ = 0;
		_data_->_tmp267_ = _data_->_tmp265_ (_data_->_tmp266_, _data_->_tmp265__target, &_data_->_inner_error_);
		_data_->delay = _data_->_tmp267_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			if (_data_->_inner_error_->domain == FOLKS_PERSONA_STORE_ERROR) {
				g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
				g_error_free (_data_->_inner_error_);
				_g_object_unref0 (_data_->persona);
				_g_free0 (_data_->iid);
				_g_free0 (_data_->uid);
				_g_free0 (_data_->contact_id);
				if (_data_->_state_ == 0) {
					g_simple_async_result_complete_in_idle (_data_->_async_result);
				} else {
					g_simple_async_result_complete (_data_->_async_result);
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			} else {
				_g_object_unref0 (_data_->persona);
				_g_free0 (_data_->iid);
				_g_free0 (_data_->uid);
				_g_free0 (_data_->contact_id);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
				g_clear_error (&_data_->_inner_error_);
				return FALSE;
			}
		}
		_data_->_tmp268_ = 0;
		_data_->_tmp268_ = _data_->delay;
		_data_->_state_ = 17;
		_folks_dummy_persona_store_implement_mock_delay (_data_->self, _data_->_tmp268_, folks_dummy_persona_store_add_persona_from_details_ready, _data_);
		return FALSE;
		_state_17:
		_folks_dummy_persona_store_implement_mock_delay_finish (_data_->self, _data_->_res_);
	}
	_data_->_tmp269_ = NULL;
	_data_->_tmp269_ = _data_->self->priv->_personas;
	_data_->_tmp270_ = NULL;
	_data_->_tmp270_ = _data_->persona;
	_data_->_tmp271_ = NULL;
	_data_->_tmp271_ = folks_persona_get_iid ((FolksPersona*) _data_->_tmp270_);
	_data_->_tmp272_ = NULL;
	_data_->_tmp272_ = _data_->_tmp271_;
	_data_->_tmp273_ = NULL;
	_data_->_tmp273_ = _data_->persona;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->_tmp269_, _data_->_tmp272_, _data_->_tmp273_);
	_data_->_tmp274_ = NULL;
	_data_->_tmp274_ = gee_hash_set_new (FOLKS_DUMMY_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	_data_->added_personas = _data_->_tmp274_;
	_data_->_tmp275_ = NULL;
	_data_->_tmp275_ = _data_->added_personas;
	_data_->_tmp276_ = NULL;
	_data_->_tmp276_ = _data_->persona;
	gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp275_, _data_->_tmp276_);
	_data_->_tmp277_ = NULL;
	_data_->_tmp277_ = _data_->added_personas;
	_folks_persona_store_emit_personas_changed ((FolksPersonaStore*) _data_->self, (GeeSet*) _data_->_tmp277_, NULL, NULL, NULL, FOLKS_GROUP_DETAILS_CHANGE_REASON_NONE);
	_data_->result = (FolksPersona*) _data_->persona;
	_g_object_unref0 (_data_->added_personas);
	_g_free0 (_data_->iid);
	_g_free0 (_data_->uid);
	_g_free0 (_data_->contact_id);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_g_object_unref0 (_data_->added_personas);
	_g_object_unref0 (_data_->persona);
	_g_free0 (_data_->iid);
	_g_free0 (_data_->uid);
	_g_free0 (_data_->contact_id);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void folks_dummy_persona_store_real_remove_persona_data_free (gpointer _data) {
	FolksDummyPersonaStoreRemovePersonaData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->persona);
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksDummyPersonaStoreRemovePersonaData, _data_);
}


static void folks_dummy_persona_store_real_remove_persona (FolksPersonaStore* base, FolksPersona* persona, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksDummyPersonaStore * self;
	FolksDummyPersonaStoreRemovePersonaData* _data_;
	FolksDummyPersonaStore* _tmp0_ = NULL;
	FolksPersona* _tmp1_ = NULL;
	FolksPersona* _tmp2_ = NULL;
	self = (FolksDummyPersonaStore*) base;
	_data_ = g_slice_new0 (FolksDummyPersonaStoreRemovePersonaData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_dummy_persona_store_real_remove_persona);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_dummy_persona_store_real_remove_persona_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = persona;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->persona);
	_data_->persona = _tmp2_;
	folks_dummy_persona_store_real_remove_persona_co (_data_);
}


static void folks_dummy_persona_store_real_remove_persona_finish (FolksPersonaStore* base, GAsyncResult* _res_, GError** error) {
	FolksDummyPersonaStoreRemovePersonaData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * Remove a {@link Persona} from the PersonaStore.
   *
   * See {@link Folks.PersonaStore.remove_persona}.
   *
   * @param persona the persona that should be removed
   * @throws Folks.PersonaStoreError.STORE_OFFLINE if the store hasn’t been
   * prepared or has gone offline
   * @throws Folks.PersonaStoreError.PERMISSION_DENIED if the store denied
   * permission to delete the contact
   * @throws Folks.PersonaStoreError.READ_ONLY if the store is read only
   * @throws Folks.PersonaStoreError.REMOVE_FAILED if any other errors happened
   * in the store
   *
   * @since 0.9.7
   */
static void folks_dummy_persona_store_remove_persona_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksDummyPersonaStoreRemovePersonaData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	folks_dummy_persona_store_real_remove_persona_co (_data_);
}


static gboolean folks_dummy_persona_store_real_remove_persona_co (FolksDummyPersonaStoreRemovePersonaData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->persona;
	_vala_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp0_, FOLKS_DUMMY_TYPE_PERSONA), "persona is FolksDummy.Persona", FALSE);
	_data_->_tmp1_ = FALSE;
	_data_->_tmp1_ = _data_->self->priv->_is_prepared;
	if (!_data_->_tmp1_) {
		_data_->_tmp2_ = NULL;
		_data_->_tmp2_ = g_error_new_literal (FOLKS_PERSONA_STORE_ERROR, FOLKS_PERSONA_STORE_ERROR_STORE_OFFLINE, "Persona store has not yet been prepared.");
		_data_->_inner_error_ = _data_->_tmp2_;
		if (_data_->_inner_error_->domain == FOLKS_PERSONA_STORE_ERROR) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	_data_->_tmp3_ = NULL;
	_data_->_tmp3__target = NULL;
	_data_->_tmp3_ = folks_dummy_persona_store_get_remove_persona_mock (_data_->self, &_data_->_tmp3__target);
	_data_->_tmp4_ = NULL;
	_data_->_tmp4__target = NULL;
	_data_->_tmp4_ = _data_->_tmp3_;
	_data_->_tmp4__target = _data_->_tmp3__target;
	if (_data_->_tmp4_ != NULL) {
		_data_->_tmp5_ = NULL;
		_data_->_tmp5__target = NULL;
		_data_->_tmp5_ = folks_dummy_persona_store_get_remove_persona_mock (_data_->self, &_data_->_tmp5__target);
		_data_->_tmp6_ = NULL;
		_data_->_tmp6__target = NULL;
		_data_->_tmp6_ = _data_->_tmp5_;
		_data_->_tmp6__target = _data_->_tmp5__target;
		_data_->_tmp7_ = NULL;
		_data_->_tmp7_ = _data_->persona;
		_data_->_tmp8_ = 0;
		_data_->_tmp8_ = _data_->_tmp6_ (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp7_, FOLKS_DUMMY_TYPE_PERSONA, FolksDummyPersona), _data_->_tmp6__target, &_data_->_inner_error_);
		_data_->delay = _data_->_tmp8_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			if (_data_->_inner_error_->domain == FOLKS_PERSONA_STORE_ERROR) {
				g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
				g_error_free (_data_->_inner_error_);
				if (_data_->_state_ == 0) {
					g_simple_async_result_complete_in_idle (_data_->_async_result);
				} else {
					g_simple_async_result_complete (_data_->_async_result);
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
				g_clear_error (&_data_->_inner_error_);
				return FALSE;
			}
		}
		_data_->_tmp9_ = 0;
		_data_->_tmp9_ = _data_->delay;
		_data_->_state_ = 1;
		_folks_dummy_persona_store_implement_mock_delay (_data_->self, _data_->_tmp9_, folks_dummy_persona_store_remove_persona_ready, _data_);
		return FALSE;
		_state_1:
		_folks_dummy_persona_store_implement_mock_delay_finish (_data_->self, _data_->_res_);
	}
	_data_->_tmp10_ = NULL;
	_data_->_tmp10_ = _data_->self->priv->_personas;
	_data_->_tmp11_ = NULL;
	_data_->_tmp11_ = _data_->persona;
	_data_->_tmp12_ = NULL;
	_data_->_tmp12_ = folks_persona_get_iid (_data_->_tmp11_);
	_data_->_tmp13_ = NULL;
	_data_->_tmp13_ = _data_->_tmp12_;
	_data_->_tmp14_ = NULL;
	_data_->_tmp14_ = gee_abstract_map_get ((GeeAbstractMap*) _data_->_tmp10_, _data_->_tmp13_);
	_data_->_persona = (FolksDummyPersona*) _data_->_tmp14_;
	_data_->_tmp15_ = NULL;
	_data_->_tmp15_ = _data_->_persona;
	if (_data_->_tmp15_ != NULL) {
		_data_->_tmp16_ = NULL;
		_data_->_tmp16_ = _data_->self->priv->_personas;
		_data_->_tmp17_ = NULL;
		_data_->_tmp17_ = _data_->persona;
		_data_->_tmp18_ = NULL;
		_data_->_tmp18_ = folks_persona_get_iid (_data_->_tmp17_);
		_data_->_tmp19_ = NULL;
		_data_->_tmp19_ = _data_->_tmp18_;
		gee_abstract_map_unset ((GeeAbstractMap*) _data_->_tmp16_, _data_->_tmp19_, NULL);
		_data_->_tmp20_ = NULL;
		_data_->_tmp20_ = _data_->self->priv->_pending_persona_registrations;
		_data_->_tmp21_ = NULL;
		_data_->_tmp21_ = _data_->_persona;
		gee_abstract_collection_remove ((GeeAbstractCollection*) _data_->_tmp20_, G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp21_, FOLKS_DUMMY_TYPE_PERSONA, FolksDummyPersona));
		_data_->_tmp22_ = NULL;
		_data_->_tmp22_ = _data_->self->priv->_pending_persona_unregistrations;
		_data_->_tmp23_ = NULL;
		_data_->_tmp23_ = _data_->_persona;
		gee_abstract_collection_remove ((GeeAbstractCollection*) _data_->_tmp22_, G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp23_, FOLKS_DUMMY_TYPE_PERSONA, FolksDummyPersona));
		_data_->_tmp24_ = NULL;
		_data_->_tmp24_ = gee_hash_set_new (FOLKS_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
		_data_->removed_personas = _data_->_tmp24_;
		_data_->_tmp25_ = NULL;
		_data_->_tmp25_ = _data_->removed_personas;
		_data_->_tmp26_ = NULL;
		_data_->_tmp26_ = _data_->persona;
		gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp25_, G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp26_, FOLKS_TYPE_PERSONA, FolksPersona));
		_data_->_tmp27_ = NULL;
		_data_->_tmp27_ = _data_->removed_personas;
		_folks_persona_store_emit_personas_changed ((FolksPersonaStore*) _data_->self, NULL, (GeeSet*) _data_->_tmp27_, NULL, NULL, FOLKS_GROUP_DETAILS_CHANGE_REASON_NONE);
		_g_object_unref0 (_data_->removed_personas);
	}
	_g_object_unref0 (_data_->_persona);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void folks_dummy_persona_store_real_prepare_data_free (gpointer _data) {
	FolksDummyPersonaStorePrepareData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksDummyPersonaStorePrepareData, _data_);
}


static void folks_dummy_persona_store_real_prepare (FolksPersonaStore* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksDummyPersonaStore * self;
	FolksDummyPersonaStorePrepareData* _data_;
	FolksDummyPersonaStore* _tmp0_ = NULL;
	self = (FolksDummyPersonaStore*) base;
	_data_ = g_slice_new0 (FolksDummyPersonaStorePrepareData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_dummy_persona_store_real_prepare);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_dummy_persona_store_real_prepare_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	folks_dummy_persona_store_real_prepare_co (_data_);
}


static void folks_dummy_persona_store_real_prepare_finish (FolksPersonaStore* base, GAsyncResult* _res_, GError** error) {
	FolksDummyPersonaStorePrepareData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * Prepare the PersonaStore for use.
   *
   * See {@link Folks.PersonaStore.prepare}.
   *
   * @throws Folks.PersonaStoreError.STORE_OFFLINE if the store is offline
   * @throws Folks.PersonaStoreError.PERMISSION_DENIED if permission was denied
   * to open the store
   * @throws Folks.PersonaStoreError.INVALID_ARGUMENT if any other error
   * occurred in the store
   *
   * @since 0.9.7
   */
static void folks_dummy_persona_store_prepare_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksDummyPersonaStorePrepareData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	folks_dummy_persona_store_real_prepare_co (_data_);
}


static gboolean folks_dummy_persona_store_real_prepare_co (FolksDummyPersonaStorePrepareData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = folks_persona_store_get_id ((FolksPersonaStore*) _data_->self);
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->_tmp0_;
	folks_internal_profiling_start ("preparing Dummy.PersonaStore (ID: %s)", _data_->_tmp1_, NULL);
	_data_->_tmp3_ = FALSE;
	_data_->_tmp3_ = _data_->self->priv->_is_prepared;
	if (_data_->_tmp3_ == TRUE) {
		_data_->_tmp2_ = TRUE;
	} else {
		_data_->_tmp4_ = FALSE;
		_data_->_tmp4_ = _data_->self->priv->_prepare_pending;
		_data_->_tmp2_ = _data_->_tmp4_ == TRUE;
	}
	if (_data_->_tmp2_) {
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->self->priv->_prepare_pending = TRUE;
		_data_->_tmp5_ = NULL;
		_data_->_tmp5__target = NULL;
		_data_->_tmp5_ = folks_dummy_persona_store_get_prepare_mock (_data_->self, &_data_->_tmp5__target);
		_data_->_tmp6_ = NULL;
		_data_->_tmp6__target = NULL;
		_data_->_tmp6_ = _data_->_tmp5_;
		_data_->_tmp6__target = _data_->_tmp5__target;
		if (_data_->_tmp6_ != NULL) {
			_data_->_tmp7_ = NULL;
			_data_->_tmp7__target = NULL;
			_data_->_tmp7_ = folks_dummy_persona_store_get_prepare_mock (_data_->self, &_data_->_tmp7__target);
			_data_->_tmp8_ = NULL;
			_data_->_tmp8__target = NULL;
			_data_->_tmp8_ = _data_->_tmp7_;
			_data_->_tmp8__target = _data_->_tmp7__target;
			_data_->_tmp9_ = 0;
			_data_->_tmp9_ = _data_->_tmp8_ (_data_->_tmp8__target, &_data_->_inner_error_);
			_data_->delay = _data_->_tmp9_;
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
				goto __finally3;
			}
			_data_->_tmp10_ = 0;
			_data_->_tmp10_ = _data_->delay;
			_data_->_state_ = 1;
			_folks_dummy_persona_store_implement_mock_delay (_data_->self, _data_->_tmp10_, folks_dummy_persona_store_prepare_ready, _data_);
			return FALSE;
			_state_1:
			_folks_dummy_persona_store_implement_mock_delay_finish (_data_->self, _data_->_res_);
		}
		_data_->self->priv->_is_prepared = TRUE;
		g_object_notify ((GObject*) _data_->self, "is-prepared");
		_data_->_tmp11_ = FALSE;
		_data_->_tmp11_ = _data_->self->priv->_quiescent_on_prepare;
		if (_data_->_tmp11_ == TRUE) {
			folks_dummy_persona_store_reach_quiescence (_data_->self);
		}
	}
	__finally3:
	{
		_data_->self->priv->_prepare_pending = FALSE;
	}
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		if (_data_->_inner_error_->domain == FOLKS_PERSONA_STORE_ERROR) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	folks_internal_profiling_end ("preparing Dummy.PersonaStore", NULL);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void _folks_dummy_persona_store_implement_mock_delay_data_free (gpointer _data) {
	FolksDummyPersonaStoreImplementMockDelayData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksDummyPersonaStoreImplementMockDelayData, _data_);
}


static void _folks_dummy_persona_store_implement_mock_delay (FolksDummyPersonaStore* self, gint delay, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksDummyPersonaStoreImplementMockDelayData* _data_;
	FolksDummyPersonaStore* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	_data_ = g_slice_new0 (FolksDummyPersonaStoreImplementMockDelayData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, _folks_dummy_persona_store_implement_mock_delay);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, _folks_dummy_persona_store_implement_mock_delay_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = delay;
	_data_->delay = _tmp1_;
	_folks_dummy_persona_store_implement_mock_delay_co (_data_);
}


static void _folks_dummy_persona_store_implement_mock_delay_finish (FolksDummyPersonaStore* self, GAsyncResult* _res_) {
	FolksDummyPersonaStoreImplementMockDelayData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * Delay for the given number of milliseconds.
   *
   * This implements an asynchronous delay (which should be yielded on) until
   * the given number of milliseconds has elapsed.
   *
   * If ``delay`` is negative, this function returns immediately. If it is
   * zero, this function returns in an idle callback.
   *
   * @param delay number of milliseconds to delay for
   *
   * @since 0.9.7
   */
static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		FolksDummyPersonaStore* self;
		self = _data2_->self;
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}


static gboolean ____lambda6_ (Block2Data* _data2_) {
	FolksDummyPersonaStore* self;
	gboolean result = FALSE;
	self = _data2_->self;
	_folks_dummy_persona_store_implement_mock_delay_co (_data2_->_async_data_);
	result = FALSE;
	return result;
}


static gboolean _____lambda6__gsource_func (gpointer self) {
	gboolean result;
	result = ____lambda6_ (self);
	return result;
}


static gboolean ____lambda7_ (Block2Data* _data2_) {
	FolksDummyPersonaStore* self;
	gboolean result = FALSE;
	self = _data2_->self;
	_folks_dummy_persona_store_implement_mock_delay_co (_data2_->_async_data_);
	result = FALSE;
	return result;
}


static gboolean _____lambda7__gsource_func (gpointer self) {
	gboolean result;
	result = ____lambda7_ (self);
	return result;
}


static gboolean _folks_dummy_persona_store_implement_mock_delay_co (FolksDummyPersonaStoreImplementMockDelayData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data2_ = g_slice_new0 (Block2Data);
	_data_->_data2_->_ref_count_ = 1;
	_data_->_data2_->self = g_object_ref (_data_->self);
	_data_->_data2_->_async_data_ = _data_;
	_data_->_tmp0_ = 0;
	_data_->_tmp0_ = _data_->delay;
	if (_data_->_tmp0_ < 0) {
		block2_data_unref (_data_->_data2_);
		_data_->_data2_ = NULL;
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		_data_->_tmp1_ = 0;
		_data_->_tmp1_ = _data_->delay;
		if (_data_->_tmp1_ == 0) {
			g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _____lambda6__gsource_func, block2_data_ref (_data_->_data2_), block2_data_unref);
			_data_->_state_ = 1;
			return FALSE;
			_state_1:
			;
		} else {
			_data_->_tmp2_ = 0;
			_data_->_tmp2_ = _data_->delay;
			g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) _data_->_tmp2_, _____lambda7__gsource_func, block2_data_ref (_data_->_data2_), block2_data_unref);
			_data_->_state_ = 2;
			return FALSE;
			_state_2:
			;
		}
	}
	block2_data_unref (_data_->_data2_);
	_data_->_data2_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


/**
   * Set capabilities of the persona store.
   *
   * This sets the capabilities of the store, as if they were changed on a
   * backing store somewhere. This is intended to be used for testing code which
   * depends on the values of {@link Folks.PersonaStore.can_add_personas},
   * {@link Folks.PersonaStore.can_alias_personas} and
   * {@link Folks.PersonaStore.can_remove_personas}.
   *
   * @param can_add_personas whether the store can handle adding personas
   * @param can_alias_personas whether the store can handle and update
   * user-specified persona aliases
   * @param can_remove_personas whether the store can handle removing personas
   *
   * @since 0.9.7
   */
void folks_dummy_persona_store_update_capabilities (FolksDummyPersonaStore* self, FolksMaybeBool can_add_personas, FolksMaybeBool can_alias_personas, FolksMaybeBool can_remove_personas) {
	FolksMaybeBool _tmp0_ = 0;
	FolksMaybeBool _tmp1_ = 0;
	FolksMaybeBool _tmp3_ = 0;
	FolksMaybeBool _tmp4_ = 0;
	FolksMaybeBool _tmp6_ = 0;
	FolksMaybeBool _tmp7_ = 0;
	g_return_if_fail (self != NULL);
	g_object_freeze_notify ((GObject*) self);
	_tmp0_ = can_add_personas;
	_tmp1_ = self->priv->_can_add_personas;
	if (_tmp0_ != _tmp1_) {
		FolksMaybeBool _tmp2_ = 0;
		_tmp2_ = can_add_personas;
		self->priv->_can_add_personas = _tmp2_;
		g_object_notify ((GObject*) self, "can-add-personas");
	}
	_tmp3_ = can_alias_personas;
	_tmp4_ = self->priv->_can_alias_personas;
	if (_tmp3_ != _tmp4_) {
		FolksMaybeBool _tmp5_ = 0;
		_tmp5_ = can_alias_personas;
		self->priv->_can_alias_personas = _tmp5_;
		g_object_notify ((GObject*) self, "can-alias-personas");
	}
	_tmp6_ = can_remove_personas;
	_tmp7_ = self->priv->_can_remove_personas;
	if (_tmp6_ != _tmp7_) {
		FolksMaybeBool _tmp8_ = 0;
		_tmp8_ = can_remove_personas;
		self->priv->_can_remove_personas = _tmp8_;
		g_object_notify ((GObject*) self, "can-remove-personas");
	}
	g_object_thaw_notify ((GObject*) self);
}


/**
   * Freeze persona changes in the store.
   *
   * This freezes externally-visible changes to the set of personas in the store
   * until {@link FolksDummy.PersonaStore.thaw_personas_changed} is called, at
   * which point all pending changes are made visible in the
   * {@link Folks.PersonaStore.personas} property and by emitting
   * {@link Folks.PersonaStore.personas_changed}.
   *
   * Calls to {@link FolksDummy.PersonaStore.freeze_personas_changed} and
   * {@link FolksDummy.PersonaStore.thaw_personas_changed} must be well-nested.
   * Pending changes will only be committed after the final call to
   * {@link FolksDummy.PersonaStore.thaw_personas_changed}.
   *
   * @see PersonaStore.thaw_personas_changed
   * @since 0.9.7
   */
void folks_dummy_persona_store_freeze_personas_changed (FolksDummyPersonaStore* self) {
	guint _tmp0_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_personas_changed_frozen;
	self->priv->_personas_changed_frozen = _tmp0_ + 1;
}


/**
   * Thaw persona changes in the store.
   *
   * This thaws externally-visible changes to the set of personas in the store.
   * If the number of calls to
   * {@link FolksDummy.PersonaStore.thaw_personas_changed} matches the number of
   * calls to {@link FolksDummy.PersonaStore.freeze_personas_changed}, all
   * pending changes are committed and made externally-visible.
   *
   * @see PersonaStore.freeze_personas_changed
   * @since 0.9.7
   */
void folks_dummy_persona_store_thaw_personas_changed (FolksDummyPersonaStore* self) {
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
	guint _tmp2_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_personas_changed_frozen;
	_vala_assert (_tmp0_ > ((guint) 0), "this._personas_changed_frozen > 0");
	_tmp1_ = self->priv->_personas_changed_frozen;
	self->priv->_personas_changed_frozen = _tmp1_ - 1;
	_tmp2_ = self->priv->_personas_changed_frozen;
	if (_tmp2_ == ((guint) 0)) {
		GeeHashSet* _tmp3_ = NULL;
		GeeHashSet* _tmp4_ = NULL;
		GeeHashSet* _tmp5_ = NULL;
		GeeHashSet* _tmp6_ = NULL;
		_tmp3_ = self->priv->_pending_persona_registrations;
		_tmp4_ = self->priv->_pending_persona_unregistrations;
		_folks_persona_store_emit_personas_changed ((FolksPersonaStore*) self, (GeeSet*) _tmp3_, (GeeSet*) _tmp4_, NULL, NULL, FOLKS_GROUP_DETAILS_CHANGE_REASON_NONE);
		_tmp5_ = self->priv->_pending_persona_registrations;
		gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp5_);
		_tmp6_ = self->priv->_pending_persona_unregistrations;
		gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp6_);
	}
}


/**
   * Register new personas with the persona store.
   *
   * This registers a set of personas as if they had just appeared in the
   * backing store. If the persona store is not frozen (see
   * {@link FolksDummy.PersonaStore.freeze_personas_changed}) the changes are
   * made externally visible on the store immediately (e.g. in the
   * {@link Folks.PersonaStore.personas} property and through a
   * {@link Folks.PersonaStore.personas_changed} signal). If the store is
   * frozen, the changes will be pending until the store is next unfrozen.
   *
   * All elements in the @personas set be of type
   * {@link FolksDummy.PersonaStore.persona_type}.
   *
   * @param personas set of personas to register
   *
   * @since 0.9.7
   */
void folks_dummy_persona_store_register_personas (FolksDummyPersonaStore* self, GeeSet* personas) {
	GeeSet* added_personas = NULL;
	gboolean emit_notifications = FALSE;
	guint _tmp0_ = 0U;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp35_ = FALSE;
	GeeSet* _tmp36_ = NULL;
	gint _tmp37_ = 0;
	gint _tmp38_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (personas != NULL);
	_tmp0_ = self->priv->_personas_changed_frozen;
	emit_notifications = _tmp0_ == ((guint) 0);
	_tmp1_ = emit_notifications;
	if (_tmp1_ == FALSE) {
		GeeHashSet* _tmp2_ = NULL;
		GeeSet* _tmp3_ = NULL;
		_tmp2_ = self->priv->_pending_persona_registrations;
		_tmp3_ = _g_object_ref0 ((GeeSet*) _tmp2_);
		_g_object_unref0 (added_personas);
		added_personas = _tmp3_;
	} else {
		GeeHashSet* _tmp4_ = NULL;
		_tmp4_ = gee_hash_set_new (FOLKS_DUMMY_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
		_g_object_unref0 (added_personas);
		added_personas = (GeeSet*) _tmp4_;
	}
	{
		GeeIterator* _persona_it = NULL;
		GeeSet* _tmp5_ = NULL;
		GeeIterator* _tmp6_ = NULL;
		_tmp5_ = personas;
		_tmp6_ = gee_iterable_iterator ((GeeIterable*) _tmp5_);
		_persona_it = _tmp6_;
		while (TRUE) {
			GeeIterator* _tmp7_ = NULL;
			gboolean _tmp8_ = FALSE;
			FolksDummyPersona* persona = NULL;
			GeeIterator* _tmp9_ = NULL;
			gpointer _tmp10_ = NULL;
			FolksDummyPersona* _tmp11_ = NULL;
			GType _tmp12_ = 0UL;
			GType _tmp13_ = 0UL;
			gboolean _tmp14_ = FALSE;
			GeeHashSet* _tmp15_ = NULL;
			FolksDummyPersona* _tmp16_ = NULL;
			gboolean _tmp17_ = FALSE;
			GeeHashMap* _tmp22_ = NULL;
			FolksDummyPersona* _tmp23_ = NULL;
			const gchar* _tmp24_ = NULL;
			const gchar* _tmp25_ = NULL;
			gboolean _tmp26_ = FALSE;
			GeeSet* _tmp27_ = NULL;
			FolksDummyPersona* _tmp28_ = NULL;
			gboolean _tmp29_ = FALSE;
			_tmp7_ = _persona_it;
			_tmp8_ = gee_iterator_next (_tmp7_);
			if (!_tmp8_) {
				break;
			}
			_tmp9_ = _persona_it;
			_tmp10_ = gee_iterator_get (_tmp9_);
			persona = (FolksDummyPersona*) _tmp10_;
			_tmp11_ = persona;
			_tmp12_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp11_);
			_tmp13_ = self->priv->_persona_type;
			_tmp14_ = g_type_is_a (_tmp12_, _tmp13_);
			_vala_assert (_tmp14_, "persona.get_type ().is_a (this._persona_type)");
			_tmp15_ = self->priv->_pending_persona_unregistrations;
			_tmp16_ = persona;
			_tmp17_ = gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp15_, _tmp16_);
			if (_tmp17_) {
				GeeHashMap* _tmp18_ = NULL;
				FolksDummyPersona* _tmp19_ = NULL;
				const gchar* _tmp20_ = NULL;
				const gchar* _tmp21_ = NULL;
				_tmp18_ = self->priv->_personas;
				_tmp19_ = persona;
				_tmp20_ = folks_persona_get_iid ((FolksPersona*) _tmp19_);
				_tmp21_ = _tmp20_;
				gee_abstract_map_unset ((GeeAbstractMap*) _tmp18_, _tmp21_, NULL);
			}
			_tmp22_ = self->priv->_personas;
			_tmp23_ = persona;
			_tmp24_ = folks_persona_get_iid ((FolksPersona*) _tmp23_);
			_tmp25_ = _tmp24_;
			_tmp26_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp22_, _tmp25_);
			if (_tmp26_) {
				_g_object_unref0 (persona);
				continue;
			}
			_tmp27_ = added_personas;
			_tmp28_ = persona;
			gee_collection_add ((GeeCollection*) _tmp27_, _tmp28_);
			_tmp29_ = emit_notifications;
			if (_tmp29_ == TRUE) {
				GeeHashMap* _tmp30_ = NULL;
				FolksDummyPersona* _tmp31_ = NULL;
				const gchar* _tmp32_ = NULL;
				const gchar* _tmp33_ = NULL;
				FolksDummyPersona* _tmp34_ = NULL;
				_tmp30_ = self->priv->_personas;
				_tmp31_ = persona;
				_tmp32_ = folks_persona_get_iid ((FolksPersona*) _tmp31_);
				_tmp33_ = _tmp32_;
				_tmp34_ = persona;
				gee_abstract_map_set ((GeeAbstractMap*) _tmp30_, _tmp33_, _tmp34_);
			}
			_g_object_unref0 (persona);
		}
		_g_object_unref0 (_persona_it);
	}
	_tmp36_ = added_personas;
	_tmp37_ = gee_collection_get_size ((GeeCollection*) _tmp36_);
	_tmp38_ = _tmp37_;
	if (_tmp38_ > 0) {
		gboolean _tmp39_ = FALSE;
		_tmp39_ = emit_notifications;
		_tmp35_ = _tmp39_ == TRUE;
	} else {
		_tmp35_ = FALSE;
	}
	if (_tmp35_) {
		GeeSet* _tmp40_ = NULL;
		_tmp40_ = added_personas;
		_folks_persona_store_emit_personas_changed ((FolksPersonaStore*) self, _tmp40_, NULL, NULL, NULL, FOLKS_GROUP_DETAILS_CHANGE_REASON_NONE);
	}
	_g_object_unref0 (added_personas);
}


/**
   * Unregister existing personas with the persona store.
   *
   * This unregisters a set of personas as if they had just disappeared from the
   * backing store. If the persona store is not frozen (see
   * {@link FolksDummy.PersonaStore.freeze_personas_changed}) the changes are
   * made externally visible on the store immediately (e.g. in the
   * {@link Folks.PersonaStore.personas} property and through a
   * {@link Folks.PersonaStore.personas_changed} signal). If the store is
   * frozen, the changes will be pending until the store is next unfrozen.
   *
   * @param personas set of personas to unregister
   *
   * @since 0.9.7
   */
void folks_dummy_persona_store_unregister_personas (FolksDummyPersonaStore* self, GeeSet* personas) {
	GeeSet* removed_personas = NULL;
	gboolean emit_notifications = FALSE;
	guint _tmp0_ = 0U;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp21_ = FALSE;
	GeeSet* _tmp22_ = NULL;
	gint _tmp23_ = 0;
	gint _tmp24_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (personas != NULL);
	_tmp0_ = self->priv->_personas_changed_frozen;
	emit_notifications = _tmp0_ == ((guint) 0);
	_tmp1_ = emit_notifications;
	if (_tmp1_ == FALSE) {
		GeeHashSet* _tmp2_ = NULL;
		GeeSet* _tmp3_ = NULL;
		_tmp2_ = self->priv->_pending_persona_unregistrations;
		_tmp3_ = _g_object_ref0 ((GeeSet*) _tmp2_);
		_g_object_unref0 (removed_personas);
		removed_personas = _tmp3_;
	} else {
		GeeHashSet* _tmp4_ = NULL;
		_tmp4_ = gee_hash_set_new (FOLKS_DUMMY_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
		_g_object_unref0 (removed_personas);
		removed_personas = (GeeSet*) _tmp4_;
	}
	{
		GeeIterator* __persona_it = NULL;
		GeeSet* _tmp5_ = NULL;
		GeeIterator* _tmp6_ = NULL;
		_tmp5_ = personas;
		_tmp6_ = gee_iterable_iterator ((GeeIterable*) _tmp5_);
		__persona_it = _tmp6_;
		while (TRUE) {
			GeeIterator* _tmp7_ = NULL;
			gboolean _tmp8_ = FALSE;
			FolksDummyPersona* _persona = NULL;
			GeeIterator* _tmp9_ = NULL;
			gpointer _tmp10_ = NULL;
			GeeHashSet* _tmp11_ = NULL;
			FolksDummyPersona* _tmp12_ = NULL;
			FolksDummyPersona* persona = NULL;
			GeeHashMap* _tmp13_ = NULL;
			FolksDummyPersona* _tmp14_ = NULL;
			const gchar* _tmp15_ = NULL;
			const gchar* _tmp16_ = NULL;
			gpointer _tmp17_ = NULL;
			FolksDummyPersona* _tmp18_ = NULL;
			GeeSet* _tmp19_ = NULL;
			FolksDummyPersona* _tmp20_ = NULL;
			_tmp7_ = __persona_it;
			_tmp8_ = gee_iterator_next (_tmp7_);
			if (!_tmp8_) {
				break;
			}
			_tmp9_ = __persona_it;
			_tmp10_ = gee_iterator_get (_tmp9_);
			_persona = (FolksDummyPersona*) _tmp10_;
			_tmp11_ = self->priv->_pending_persona_registrations;
			_tmp12_ = _persona;
			gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp11_, _tmp12_);
			_tmp13_ = self->priv->_personas;
			_tmp14_ = _persona;
			_tmp15_ = folks_persona_get_iid ((FolksPersona*) _tmp14_);
			_tmp16_ = _tmp15_;
			_tmp17_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp13_, _tmp16_);
			persona = (FolksDummyPersona*) _tmp17_;
			_tmp18_ = persona;
			if (_tmp18_ == NULL) {
				_g_object_unref0 (persona);
				_g_object_unref0 (_persona);
				continue;
			}
			_tmp19_ = removed_personas;
			_tmp20_ = persona;
			gee_collection_add ((GeeCollection*) _tmp19_, G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, FOLKS_DUMMY_TYPE_PERSONA, FolksDummyPersona));
			_g_object_unref0 (persona);
			_g_object_unref0 (_persona);
		}
		_g_object_unref0 (__persona_it);
	}
	_tmp22_ = removed_personas;
	_tmp23_ = gee_collection_get_size ((GeeCollection*) _tmp22_);
	_tmp24_ = _tmp23_;
	if (_tmp24_ > 0) {
		gboolean _tmp25_ = FALSE;
		_tmp25_ = emit_notifications;
		_tmp21_ = _tmp25_ == TRUE;
	} else {
		_tmp21_ = FALSE;
	}
	if (_tmp21_) {
		GeeSet* _tmp36_ = NULL;
		{
			GeeIterator* __persona_it = NULL;
			GeeSet* _tmp26_ = NULL;
			GeeIterator* _tmp27_ = NULL;
			_tmp26_ = removed_personas;
			_tmp27_ = gee_iterable_iterator ((GeeIterable*) _tmp26_);
			__persona_it = _tmp27_;
			while (TRUE) {
				GeeIterator* _tmp28_ = NULL;
				gboolean _tmp29_ = FALSE;
				FolksDummyPersona* _persona = NULL;
				GeeIterator* _tmp30_ = NULL;
				gpointer _tmp31_ = NULL;
				GeeHashMap* _tmp32_ = NULL;
				FolksDummyPersona* _tmp33_ = NULL;
				const gchar* _tmp34_ = NULL;
				const gchar* _tmp35_ = NULL;
				_tmp28_ = __persona_it;
				_tmp29_ = gee_iterator_next (_tmp28_);
				if (!_tmp29_) {
					break;
				}
				_tmp30_ = __persona_it;
				_tmp31_ = gee_iterator_get (_tmp30_);
				_persona = (FolksDummyPersona*) _tmp31_;
				_tmp32_ = self->priv->_personas;
				_tmp33_ = _persona;
				_tmp34_ = folks_persona_get_iid ((FolksPersona*) _tmp33_);
				_tmp35_ = _tmp34_;
				gee_abstract_map_unset ((GeeAbstractMap*) _tmp32_, _tmp35_, NULL);
				_g_object_unref0 (_persona);
			}
			_g_object_unref0 (__persona_it);
		}
		_tmp36_ = removed_personas;
		_folks_persona_store_emit_personas_changed ((FolksPersonaStore*) self, NULL, _tmp36_, NULL, NULL, FOLKS_GROUP_DETAILS_CHANGE_REASON_NONE);
	}
	_g_object_unref0 (removed_personas);
}


/**
   * Reach quiescence on the store.
   *
   * If the {@link Folks.PersonaStore.prepare} method has already been called on
   * the store, this causes the store to signal that it has reached quiescence
   * immediately. If the store has not yet been prepared, this will set a flag
   * to ensure that quiescence is reached as soon as
   * {@link Folks.PersonaStore.prepare} is called.
   *
   * This must be called before the store will reach quiescence.
   *
   * @since 0.9.7
   */
void folks_dummy_persona_store_reach_quiescence (FolksDummyPersonaStore* self) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_is_prepared;
	if (_tmp0_ == FALSE) {
		self->priv->_quiescent_on_prepare = TRUE;
		return;
	}
	_tmp1_ = self->priv->_is_quiescent;
	if (_tmp1_ == FALSE) {
		self->priv->_is_quiescent = TRUE;
		g_object_notify ((GObject*) self, "is-quiescent");
	}
}


/**
   * Update the {@link Folks.PersonaStore.is_user_set_default} property.
   *
   * Backend method for use by test code to simulate a backing-store-driven
   * change in the {@link Folks.PersonaStore.is_user_set_default} property.
   *
   * @param is_user_set_default new value for the property
   *
   * @since 0.9.7
   */
void folks_dummy_persona_store_update_is_user_set_default (FolksDummyPersonaStore* self, gboolean is_user_set_default) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = is_user_set_default;
	folks_persona_store_set_is_user_set_default ((FolksPersonaStore*) self, _tmp0_);
}


/**
   * Update the {@link Folks.PersonaStore.trust_level} property.
   *
   * Backend method for use by test code to simulate a backing-store-driven
   * change in the {@link Folks.PersonaStore.trust_level} property.
   *
   * @param trust_level new value for the property
   *
   * @since 0.9.7
   */
void folks_dummy_persona_store_update_trust_level (FolksDummyPersonaStore* self, FolksPersonaStoreTrust trust_level) {
	FolksPersonaStoreTrust _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = trust_level;
	folks_persona_store_set_trust_level ((FolksPersonaStore*) self, _tmp0_);
}


static const gchar* folks_dummy_persona_store_real_get_type_id (FolksPersonaStore* base) {
	const gchar* result;
	FolksDummyPersonaStore* self;
	self = (FolksDummyPersonaStore*) base;
	result = BACKEND_NAME;
	return result;
}


static FolksMaybeBool folks_dummy_persona_store_real_get_can_add_personas (FolksPersonaStore* base) {
	FolksMaybeBool result;
	FolksDummyPersonaStore* self;
	gboolean _tmp0_ = FALSE;
	FolksMaybeBool _tmp1_ = 0;
	self = (FolksDummyPersonaStore*) base;
	_tmp0_ = self->priv->_is_prepared;
	if (!_tmp0_) {
		result = FOLKS_MAYBE_BOOL_FALSE;
		return result;
	}
	_tmp1_ = self->priv->_can_add_personas;
	result = _tmp1_;
	return result;
}


static FolksMaybeBool folks_dummy_persona_store_real_get_can_alias_personas (FolksPersonaStore* base) {
	FolksMaybeBool result;
	FolksDummyPersonaStore* self;
	gboolean _tmp0_ = FALSE;
	FolksMaybeBool _tmp1_ = 0;
	self = (FolksDummyPersonaStore*) base;
	_tmp0_ = self->priv->_is_prepared;
	if (!_tmp0_) {
		result = FOLKS_MAYBE_BOOL_FALSE;
		return result;
	}
	_tmp1_ = self->priv->_can_alias_personas;
	result = _tmp1_;
	return result;
}


static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle) {
	int i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}


static FolksMaybeBool folks_dummy_persona_store_real_get_can_group_personas (FolksPersonaStore* base) {
	FolksMaybeBool result;
	FolksDummyPersonaStore* self;
	FolksMaybeBool _tmp0_ = 0;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	self = (FolksDummyPersonaStore*) base;
	_tmp1_ = self->priv->_always_writeable_properties;
	_tmp1__length1 = self->priv->_always_writeable_properties_length1;
	if (_vala_string_array_contains (_tmp1_, _tmp1__length1, "groups")) {
		_tmp0_ = FOLKS_MAYBE_BOOL_TRUE;
	} else {
		_tmp0_ = FOLKS_MAYBE_BOOL_FALSE;
	}
	result = _tmp0_;
	return result;
}


static FolksMaybeBool folks_dummy_persona_store_real_get_can_remove_personas (FolksPersonaStore* base) {
	FolksMaybeBool result;
	FolksDummyPersonaStore* self;
	gboolean _tmp0_ = FALSE;
	FolksMaybeBool _tmp1_ = 0;
	self = (FolksDummyPersonaStore*) base;
	_tmp0_ = self->priv->_is_prepared;
	if (!_tmp0_) {
		result = FOLKS_MAYBE_BOOL_FALSE;
		return result;
	}
	_tmp1_ = self->priv->_can_remove_personas;
	result = _tmp1_;
	return result;
}


static gboolean folks_dummy_persona_store_real_get_is_prepared (FolksPersonaStore* base) {
	gboolean result;
	FolksDummyPersonaStore* self;
	gboolean _tmp0_ = FALSE;
	self = (FolksDummyPersonaStore*) base;
	_tmp0_ = self->priv->_is_prepared;
	result = _tmp0_;
	return result;
}


static gchar** folks_dummy_persona_store_real_get_always_writeable_properties (FolksPersonaStore* base, int* result_length1) {
	gchar** result;
	FolksDummyPersonaStore* self;
	gboolean _tmp0_ = FALSE;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	gchar** _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	self = (FolksDummyPersonaStore*) base;
	_tmp0_ = self->priv->_is_prepared;
	if (!_tmp0_) {
		gchar** _tmp1_ = NULL;
		gint _tmp1__length1 = 0;
		gchar** _tmp2_ = NULL;
		gint _tmp2__length1 = 0;
		_tmp1_ = folks_dummy_persona_store__always_writeable_properties_empty;
		_tmp1__length1 = folks_dummy_persona_store__always_writeable_properties_empty_length1;
		_tmp2_ = _tmp1_;
		_tmp2__length1 = _tmp1__length1;
		if (result_length1) {
			*result_length1 = _tmp2__length1;
		}
		result = _tmp2_;
		return result;
	}
	_tmp3_ = self->priv->_always_writeable_properties;
	_tmp3__length1 = self->priv->_always_writeable_properties_length1;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	return result;
}


static gboolean folks_dummy_persona_store_real_get_is_quiescent (FolksPersonaStore* base) {
	gboolean result;
	FolksDummyPersonaStore* self;
	gboolean _tmp0_ = FALSE;
	self = (FolksDummyPersonaStore*) base;
	_tmp0_ = self->priv->_is_quiescent;
	result = _tmp0_;
	return result;
}


static GeeMap* folks_dummy_persona_store_real_get_personas (FolksPersonaStore* base) {
	GeeMap* result;
	FolksDummyPersonaStore* self;
	GeeMap* _tmp0_ = NULL;
	self = (FolksDummyPersonaStore*) base;
	_tmp0_ = self->priv->_personas_ro;
	result = _tmp0_;
	return result;
}


FolksDummyPersonaStoreAddPersonaFromDetailsMock folks_dummy_persona_store_get_add_persona_from_details_mock (FolksDummyPersonaStore* self, gpointer* result_target) {
	FolksDummyPersonaStoreAddPersonaFromDetailsMock result;
	FolksDummyPersonaStoreAddPersonaFromDetailsMock _tmp0_ = NULL;
	void* _tmp0__target = NULL;
	FolksDummyPersonaStoreAddPersonaFromDetailsMock _tmp1_ = NULL;
	void* _tmp1__target = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_add_persona_from_details_mock;
	_tmp0__target = self->priv->_add_persona_from_details_mock_target;
	_tmp1_ = _tmp0_;
	_tmp1__target = _tmp0__target;
	*result_target = _tmp1__target;
	result = _tmp1_;
	return result;
}


void folks_dummy_persona_store_set_add_persona_from_details_mock (FolksDummyPersonaStore* self, FolksDummyPersonaStoreAddPersonaFromDetailsMock value, gpointer value_target) {
	FolksDummyPersonaStoreAddPersonaFromDetailsMock _tmp0_ = NULL;
	void* _tmp0__target = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp0__target = value_target;
	self->priv->_add_persona_from_details_mock = _tmp0_;
	self->priv->_add_persona_from_details_mock_target = _tmp0__target;
}


FolksDummyPersonaStoreRemovePersonaMock folks_dummy_persona_store_get_remove_persona_mock (FolksDummyPersonaStore* self, gpointer* result_target) {
	FolksDummyPersonaStoreRemovePersonaMock result;
	FolksDummyPersonaStoreRemovePersonaMock _tmp0_ = NULL;
	void* _tmp0__target = NULL;
	FolksDummyPersonaStoreRemovePersonaMock _tmp1_ = NULL;
	void* _tmp1__target = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_remove_persona_mock;
	_tmp0__target = self->priv->_remove_persona_mock_target;
	_tmp1_ = _tmp0_;
	_tmp1__target = _tmp0__target;
	*result_target = _tmp1__target;
	result = _tmp1_;
	return result;
}


void folks_dummy_persona_store_set_remove_persona_mock (FolksDummyPersonaStore* self, FolksDummyPersonaStoreRemovePersonaMock value, gpointer value_target) {
	FolksDummyPersonaStoreRemovePersonaMock _tmp0_ = NULL;
	void* _tmp0__target = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp0__target = value_target;
	self->priv->_remove_persona_mock = _tmp0_;
	self->priv->_remove_persona_mock_target = _tmp0__target;
}


FolksDummyPersonaStorePrepareMock folks_dummy_persona_store_get_prepare_mock (FolksDummyPersonaStore* self, gpointer* result_target) {
	FolksDummyPersonaStorePrepareMock result;
	FolksDummyPersonaStorePrepareMock _tmp0_ = NULL;
	void* _tmp0__target = NULL;
	FolksDummyPersonaStorePrepareMock _tmp1_ = NULL;
	void* _tmp1__target = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_prepare_mock;
	_tmp0__target = self->priv->_prepare_mock_target;
	_tmp1_ = _tmp0_;
	_tmp1__target = _tmp0__target;
	*result_target = _tmp1__target;
	result = _tmp1_;
	return result;
}


void folks_dummy_persona_store_set_prepare_mock (FolksDummyPersonaStore* self, FolksDummyPersonaStorePrepareMock value, gpointer value_target) {
	FolksDummyPersonaStorePrepareMock _tmp0_ = NULL;
	void* _tmp0__target = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp0__target = value_target;
	self->priv->_prepare_mock = _tmp0_;
	self->priv->_prepare_mock_target = _tmp0__target;
}


GType folks_dummy_persona_store_get_persona_type (FolksDummyPersonaStore* self) {
	GType result;
	GType _tmp0_ = 0UL;
	g_return_val_if_fail (self != NULL, 0UL);
	_tmp0_ = self->priv->_persona_type;
	result = _tmp0_;
	return result;
}


void folks_dummy_persona_store_set_persona_type (FolksDummyPersonaStore* self, GType value) {
	GType _tmp0_ = 0UL;
	gboolean _tmp1_ = FALSE;
	GType _tmp2_ = 0UL;
	GType _tmp3_ = 0UL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_type_is_a (_tmp0_, FOLKS_DUMMY_TYPE_PERSONA);
	_vala_assert (_tmp1_, "value.is_a (typeof (FolksDummy.Persona))");
	_tmp2_ = self->priv->_persona_type;
	_tmp3_ = value;
	if (_tmp2_ != _tmp3_) {
		GType _tmp4_ = 0UL;
		_tmp4_ = value;
		self->priv->_persona_type = _tmp4_;
		g_object_notify ((GObject*) self, "persona-type");
	}
	g_object_notify ((GObject *) self, "persona-type");
}


static GObject * folks_dummy_persona_store_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	FolksDummyPersonaStore * self;
	GeeHashMap* _tmp0_ = NULL;
	GeeHashMap* _tmp1_ = NULL;
	GeeMap* _tmp2_ = NULL;
	GeeMap* _tmp3_ = NULL;
	GeeHashSet* _tmp4_ = NULL;
	GeeHashSet* _tmp5_ = NULL;
	parent_class = G_OBJECT_CLASS (folks_dummy_persona_store_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FOLKS_DUMMY_TYPE_PERSONA_STORE, FolksDummyPersonaStore);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, FOLKS_DUMMY_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_personas);
	self->priv->_personas = _tmp0_;
	_tmp1_ = self->priv->_personas;
	_tmp2_ = gee_abstract_map_get_read_only_view ((GeeAbstractMap*) _tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (self->priv->_personas_ro);
	self->priv->_personas_ro = _tmp3_;
	_tmp4_ = gee_hash_set_new (FOLKS_DUMMY_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_pending_persona_registrations);
	self->priv->_pending_persona_registrations = _tmp4_;
	_tmp5_ = gee_hash_set_new (FOLKS_DUMMY_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_pending_persona_unregistrations);
	self->priv->_pending_persona_unregistrations = _tmp5_;
	return obj;
}


static void folks_dummy_persona_store_class_init (FolksDummyPersonaStoreClass * klass) {
	gchar** _tmp0_ = NULL;
	folks_dummy_persona_store_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (FolksDummyPersonaStorePrivate));
	((FolksPersonaStoreClass *) klass)->add_persona_from_details = folks_dummy_persona_store_real_add_persona_from_details;
	((FolksPersonaStoreClass *) klass)->add_persona_from_details_finish = folks_dummy_persona_store_real_add_persona_from_details_finish;
	((FolksPersonaStoreClass *) klass)->remove_persona = folks_dummy_persona_store_real_remove_persona;
	((FolksPersonaStoreClass *) klass)->remove_persona_finish = folks_dummy_persona_store_real_remove_persona_finish;
	((FolksPersonaStoreClass *) klass)->prepare = folks_dummy_persona_store_real_prepare;
	((FolksPersonaStoreClass *) klass)->prepare_finish = folks_dummy_persona_store_real_prepare_finish;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_type_id = folks_dummy_persona_store_real_get_type_id;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_can_add_personas = folks_dummy_persona_store_real_get_can_add_personas;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_can_alias_personas = folks_dummy_persona_store_real_get_can_alias_personas;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_can_group_personas = folks_dummy_persona_store_real_get_can_group_personas;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_can_remove_personas = folks_dummy_persona_store_real_get_can_remove_personas;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_is_prepared = folks_dummy_persona_store_real_get_is_prepared;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_always_writeable_properties = folks_dummy_persona_store_real_get_always_writeable_properties;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_is_quiescent = folks_dummy_persona_store_real_get_is_quiescent;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_personas = folks_dummy_persona_store_real_get_personas;
	G_OBJECT_CLASS (klass)->get_property = _vala_folks_dummy_persona_store_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_folks_dummy_persona_store_set_property;
	G_OBJECT_CLASS (klass)->constructor = folks_dummy_persona_store_constructor;
	G_OBJECT_CLASS (klass)->finalize = folks_dummy_persona_store_finalize;
	/**
	   * The type of persona store this is.
	   *
	   * See {@link Folks.PersonaStore.type_id}.
	   *
	   * @since 0.9.7
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_DUMMY_PERSONA_STORE_TYPE_ID, g_param_spec_string ("type-id", "type-id", "type-id", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * Whether this PersonaStore can add {@link Folks.Persona}s.
	   *
	   * See {@link Folks.PersonaStore.can_add_personas}.
	   *
	   * @since 0.9.7
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_DUMMY_PERSONA_STORE_CAN_ADD_PERSONAS, g_param_spec_enum ("can-add-personas", "can-add-personas", "can-add-personas", FOLKS_TYPE_MAYBE_BOOL, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * Whether this PersonaStore can set the alias of {@link Folks.Persona}s.
	   *
	   * See {@link Folks.PersonaStore.can_alias_personas}.
	   *
	   * @since 0.9.7
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_DUMMY_PERSONA_STORE_CAN_ALIAS_PERSONAS, g_param_spec_enum ("can-alias-personas", "can-alias-personas", "can-alias-personas", FOLKS_TYPE_MAYBE_BOOL, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * Whether this PersonaStore can set the groups of {@link Folks.Persona}s.
	   *
	   * See {@link Folks.PersonaStore.can_group_personas}.
	   *
	   * @since 0.9.7
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_DUMMY_PERSONA_STORE_CAN_GROUP_PERSONAS, g_param_spec_enum ("can-group-personas", "can-group-personas", "can-group-personas", FOLKS_TYPE_MAYBE_BOOL, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * Whether this PersonaStore can remove {@link Folks.Persona}s.
	   *
	   * See {@link Folks.PersonaStore.can_remove_personas}.
	   *
	   * @since 0.9.7
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_DUMMY_PERSONA_STORE_CAN_REMOVE_PERSONAS, g_param_spec_enum ("can-remove-personas", "can-remove-personas", "can-remove-personas", FOLKS_TYPE_MAYBE_BOOL, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * Whether this PersonaStore has been prepared.
	   *
	   * See {@link Folks.PersonaStore.is_prepared}.
	   *
	   * @since 0.9.7
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_DUMMY_PERSONA_STORE_IS_PREPARED, g_param_spec_boolean ("is-prepared", "is-prepared", "is-prepared", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * {@inheritDoc}
	   *
	   * @since 0.9.7
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_DUMMY_PERSONA_STORE_ALWAYS_WRITEABLE_PROPERTIES, g_param_spec_boxed ("always-writeable-properties", "always-writeable-properties", "always-writeable-properties", G_TYPE_STRV, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_DUMMY_PERSONA_STORE_IS_QUIESCENT, g_param_spec_boolean ("is-quiescent", "is-quiescent", "is-quiescent", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * The {@link Persona}s exposed by this PersonaStore.
	   *
	   * See {@link Folks.PersonaStore.personas}.
	   *
	   * @since 0.9.7
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_DUMMY_PERSONA_STORE_PERSONAS, g_param_spec_object ("personas", "personas", "personas", GEE_TYPE_MAP, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * Type of programmatically created personas.
	   *
	   * This is the type used to create new personas when
	   * {@link Folks.PersonaStore.add_persona_from_details} is called. It must be a
	   * subtype of {@link FolksDummy.Persona}.
	   *
	   * This may be modified at any time, with modifications taking effect for the
	   * next call to {@link Folks.PersonaStore.add_persona_from_details} or
	   * {@link FolksDummy.PersonaStore.register_personas}.
	   *
	   * @since 0.9.7
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_DUMMY_PERSONA_STORE_PERSONA_TYPE, g_param_spec_gtype ("persona-type", "persona-type", "persona-type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	folks_dummy_persona_store__always_writeable_properties_empty = _tmp0_;
	folks_dummy_persona_store__always_writeable_properties_empty_length1 = 0;
}


static void folks_dummy_persona_store_instance_init (FolksDummyPersonaStore * self) {
	gchar** _tmp0_ = NULL;
	self->priv = FOLKS_DUMMY_PERSONA_STORE_GET_PRIVATE (self);
	self->priv->_is_prepared = FALSE;
	self->priv->_prepare_pending = FALSE;
	self->priv->_is_quiescent = FALSE;
	self->priv->_quiescent_on_prepare = FALSE;
	self->priv->_contact_id = 0;
	self->priv->_can_add_personas = FOLKS_MAYBE_BOOL_FALSE;
	self->priv->_can_alias_personas = FOLKS_MAYBE_BOOL_FALSE;
	self->priv->_can_remove_personas = FOLKS_MAYBE_BOOL_FALSE;
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	self->priv->_always_writeable_properties = _tmp0_;
	self->priv->_always_writeable_properties_length1 = 0;
	self->priv->__always_writeable_properties_size_ = self->priv->_always_writeable_properties_length1;
	self->priv->_personas_changed_frozen = (guint) 0;
	self->priv->_add_persona_from_details_mock = NULL;
	self->priv->_remove_persona_mock = NULL;
	self->priv->_prepare_mock = NULL;
	self->priv->_persona_type = FOLKS_DUMMY_TYPE_PERSONA;
}


static void folks_dummy_persona_store_finalize (GObject* obj) {
	FolksDummyPersonaStore * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FOLKS_DUMMY_TYPE_PERSONA_STORE, FolksDummyPersonaStore);
	self->priv->_always_writeable_properties = (_vala_array_free (self->priv->_always_writeable_properties, self->priv->_always_writeable_properties_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (self->priv->_personas);
	_g_object_unref0 (self->priv->_personas_ro);
	_g_object_unref0 (self->priv->_pending_persona_registrations);
	_g_object_unref0 (self->priv->_pending_persona_unregistrations);
	G_OBJECT_CLASS (folks_dummy_persona_store_parent_class)->finalize (obj);
}


/**
 * A persona store which allows {@link FolksDummy.Persona}s to be
 * programmatically created and manipulated, for the purposes of testing the
 * core of libfolks itself. This should not be used in user-visible
 * applications.
 *
 * There are two sides to this class’ interface: the methods and properties
 * declared by {@link Folks.PersonaStore}, which form the normal libfolks
 * persona store API; and the mock methods and properties (such as
 * {@link FolksDummy.PersonaStore.add_persona_from_details_mock}) which are
 * intended to be used by test driver code to simulate the behaviour of a real
 * backing store. Calls to these mock methods effect state changes in the store
 * which are visible in the normal libfolks API. The ``update_``, ``register_``
 * and ``unregister_`` prefixes and the ``mock`` suffix are commonly used for
 * backing store methods.
 *
 * The main action performed with a dummy persona store is to change its set of
 * personas, adding and removing them dynamically to test client-side behaviour.
 * The client-side APIs ({@link Folks.PersonaStore.add_persona_from_details} and
 * {@link Folks.PersonaStore.remove_persona}) should //not// be used for this.
 * Instead, the mock APIs should be used:
 * {@link FolksDummy.PersonaStore.freeze_personas_changed},
 * {@link FolksDummy.PersonaStore.register_personas},
 * {@link FolksDummy.PersonaStore.unregister_personas} and
 * {@link FolksDummy.PersonaStore.thaw_personas_changed}. These can be used to
 * build up complex {@link Folks.PersonaStore.personas_changed} signal
 * emissions, which are only emitted after the final call to
 * {@link FolksDummy.PersonaStore.thaw_personas_changed}.
 *
 * The API in {@link FolksDummy} is unstable and may change wildly. It is
 * designed mostly for use by libfolks unit tests.
 *
 * @since 0.9.7
 */
GType folks_dummy_persona_store_get_type (void) {
	static volatile gsize folks_dummy_persona_store_type_id__volatile = 0;
	if (g_once_init_enter (&folks_dummy_persona_store_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksDummyPersonaStoreClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_dummy_persona_store_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksDummyPersonaStore), 0, (GInstanceInitFunc) folks_dummy_persona_store_instance_init, NULL };
		GType folks_dummy_persona_store_type_id;
		folks_dummy_persona_store_type_id = g_type_register_static (FOLKS_TYPE_PERSONA_STORE, "FolksDummyPersonaStore", &g_define_type_info, 0);
		g_once_init_leave (&folks_dummy_persona_store_type_id__volatile, folks_dummy_persona_store_type_id);
	}
	return folks_dummy_persona_store_type_id__volatile;
}


static void _vala_folks_dummy_persona_store_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	FolksDummyPersonaStore * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FOLKS_DUMMY_TYPE_PERSONA_STORE, FolksDummyPersonaStore);
	switch (property_id) {
		case FOLKS_DUMMY_PERSONA_STORE_TYPE_ID:
		g_value_set_string (value, folks_persona_store_get_type_id ((FolksPersonaStore*) self));
		break;
		case FOLKS_DUMMY_PERSONA_STORE_CAN_ADD_PERSONAS:
		g_value_set_enum (value, folks_persona_store_get_can_add_personas ((FolksPersonaStore*) self));
		break;
		case FOLKS_DUMMY_PERSONA_STORE_CAN_ALIAS_PERSONAS:
		g_value_set_enum (value, folks_persona_store_get_can_alias_personas ((FolksPersonaStore*) self));
		break;
		case FOLKS_DUMMY_PERSONA_STORE_CAN_GROUP_PERSONAS:
		g_value_set_enum (value, folks_persona_store_get_can_group_personas ((FolksPersonaStore*) self));
		break;
		case FOLKS_DUMMY_PERSONA_STORE_CAN_REMOVE_PERSONAS:
		g_value_set_enum (value, folks_persona_store_get_can_remove_personas ((FolksPersonaStore*) self));
		break;
		case FOLKS_DUMMY_PERSONA_STORE_IS_PREPARED:
		g_value_set_boolean (value, folks_persona_store_get_is_prepared ((FolksPersonaStore*) self));
		break;
		case FOLKS_DUMMY_PERSONA_STORE_ALWAYS_WRITEABLE_PROPERTIES:
		{
			int length;
			g_value_set_boxed (value, folks_persona_store_get_always_writeable_properties ((FolksPersonaStore*) self, &length));
		}
		break;
		case FOLKS_DUMMY_PERSONA_STORE_IS_QUIESCENT:
		g_value_set_boolean (value, folks_persona_store_get_is_quiescent ((FolksPersonaStore*) self));
		break;
		case FOLKS_DUMMY_PERSONA_STORE_PERSONAS:
		g_value_set_object (value, folks_persona_store_get_personas ((FolksPersonaStore*) self));
		break;
		case FOLKS_DUMMY_PERSONA_STORE_PERSONA_TYPE:
		g_value_set_gtype (value, folks_dummy_persona_store_get_persona_type (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_folks_dummy_persona_store_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	FolksDummyPersonaStore * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FOLKS_DUMMY_TYPE_PERSONA_STORE, FolksDummyPersonaStore);
	switch (property_id) {
		case FOLKS_DUMMY_PERSONA_STORE_PERSONA_TYPE:
		folks_dummy_persona_store_set_persona_type (self, g_value_get_gtype (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



