/* local-id-details.c generated by valac 0.27.1.7-1a9de, the Vala compiler
 * generated from local-id-details.vala, do not modify */

/*
 * Copyright (C) 2011 Collabora Ltd.
 * Copyright (C) 2011 Philip Withnall
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Raul Gutierrez Segales <raul.gutierrez.segales@collabora.co.uk>
 *       Philip Withnall <philip@tecnocode.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>


#define FOLKS_TYPE_LOCAL_ID_DETAILS (folks_local_id_details_get_type ())
#define FOLKS_LOCAL_ID_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_LOCAL_ID_DETAILS, FolksLocalIdDetails))
#define FOLKS_IS_LOCAL_ID_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_LOCAL_ID_DETAILS))
#define FOLKS_LOCAL_ID_DETAILS_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), FOLKS_TYPE_LOCAL_ID_DETAILS, FolksLocalIdDetailsIface))

typedef struct _FolksLocalIdDetails FolksLocalIdDetails;
typedef struct _FolksLocalIdDetailsIface FolksLocalIdDetailsIface;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _FolksLocalIdDetailsChangeLocalIdsData FolksLocalIdDetailsChangeLocalIdsData;

typedef enum  {
	FOLKS_PROPERTY_ERROR_NOT_WRITEABLE,
	FOLKS_PROPERTY_ERROR_INVALID_VALUE,
	FOLKS_PROPERTY_ERROR_UNKNOWN_ERROR,
	FOLKS_PROPERTY_ERROR_UNAVAILABLE
} FolksPropertyError;
#define FOLKS_PROPERTY_ERROR folks_property_error_quark ()
struct _FolksLocalIdDetailsIface {
	GTypeInterface parent_iface;
	void (*change_local_ids) (FolksLocalIdDetails* self, GeeSet* local_ids, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*change_local_ids_finish) (FolksLocalIdDetails* self, GAsyncResult* _res_, GError** error);
	GeeSet* (*get_local_ids) (FolksLocalIdDetails* self);
	void (*set_local_ids) (FolksLocalIdDetails* self, GeeSet* value);
};

struct _FolksLocalIdDetailsChangeLocalIdsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksLocalIdDetails* self;
	GeeSet* local_ids;
	const gchar* _tmp0_;
	GError* _tmp1_;
	GError * _inner_error_;
};



GQuark folks_property_error_quark (void);
GType folks_local_id_details_get_type (void) G_GNUC_CONST;
static void folks_local_id_details_real_change_local_ids_data_free (gpointer _data);
static void folks_local_id_details_real_change_local_ids (FolksLocalIdDetails* self, GeeSet* local_ids, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_local_id_details_change_local_ids (FolksLocalIdDetails* self, GeeSet* local_ids, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_local_id_details_change_local_ids_finish (FolksLocalIdDetails* self, GAsyncResult* _res_, GError** error);
static gboolean folks_local_id_details_real_change_local_ids_co (FolksLocalIdDetailsChangeLocalIdsData* _data_);
GeeSet* folks_local_id_details_get_local_ids (FolksLocalIdDetails* self);
void folks_local_id_details_set_local_ids (FolksLocalIdDetails* self, GeeSet* value);


static void folks_local_id_details_real_change_local_ids_data_free (gpointer _data) {
	FolksLocalIdDetailsChangeLocalIdsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->local_ids);
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksLocalIdDetailsChangeLocalIdsData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void folks_local_id_details_real_change_local_ids (FolksLocalIdDetails* self, GeeSet* local_ids, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksLocalIdDetailsChangeLocalIdsData* _data_;
	FolksLocalIdDetails* _tmp0_ = NULL;
	GeeSet* _tmp1_ = NULL;
	GeeSet* _tmp2_ = NULL;
	_data_ = g_slice_new0 (FolksLocalIdDetailsChangeLocalIdsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_local_id_details_real_change_local_ids);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_local_id_details_real_change_local_ids_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = local_ids;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->local_ids);
	_data_->local_ids = _tmp2_;
	folks_local_id_details_real_change_local_ids_co (_data_);
}


static void folks_local_id_details_real_change_local_ids_finish (FolksLocalIdDetails* self, GAsyncResult* _res_, GError** error) {
	FolksLocalIdDetailsChangeLocalIdsData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * Change the contact's local IDs.
   *
   * It's preferred to call this rather than setting
   * {@link LocalIdDetails.local_ids} directly, as this method gives error
   * notification and will only return once the local IDs have been written to
   * the relevant backing store (or the operation's failed).
   *
   * @param local_ids the set of local IDs
   * @throws PropertyError if setting the local IDs failed
   * @since 0.6.2
   */
static gboolean folks_local_id_details_real_change_local_ids_co (FolksLocalIdDetailsChangeLocalIdsData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _ ("Local IDs are not writeable on this contact.");
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = g_error_new_literal (FOLKS_PROPERTY_ERROR, FOLKS_PROPERTY_ERROR_NOT_WRITEABLE, _data_->_tmp0_);
	_data_->_inner_error_ = _data_->_tmp1_;
	if (_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


void folks_local_id_details_change_local_ids (FolksLocalIdDetails* self, GeeSet* local_ids, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FOLKS_LOCAL_ID_DETAILS_GET_INTERFACE (self)->change_local_ids (self, local_ids, _callback_, _user_data_);
}


void folks_local_id_details_change_local_ids_finish (FolksLocalIdDetails* self, GAsyncResult* _res_, GError** error) {
	FOLKS_LOCAL_ID_DETAILS_GET_INTERFACE (self)->change_local_ids_finish (self, _res_, error);
}


GeeSet* folks_local_id_details_get_local_ids (FolksLocalIdDetails* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return FOLKS_LOCAL_ID_DETAILS_GET_INTERFACE (self)->get_local_ids (self);
}


void folks_local_id_details_set_local_ids (FolksLocalIdDetails* self, GeeSet* value) {
	g_return_if_fail (self != NULL);
	FOLKS_LOCAL_ID_DETAILS_GET_INTERFACE (self)->set_local_ids (self, value);
}


static void folks_local_id_details_base_init (FolksLocalIdDetailsIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		/**
		   * The IIDs corresponding to {@link Persona}s in a
		   * backend that we fully trust.
		   *
		   * @since 0.5.1
		   */
		g_object_interface_install_property (iface, g_param_spec_object ("local-ids", "local-ids", "local-ids", GEE_TYPE_SET, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
		iface->change_local_ids = folks_local_id_details_real_change_local_ids;
		iface->change_local_ids_finish = folks_local_id_details_real_change_local_ids_finish;
	}
}


/**
 * This interface represents the list of {@link Persona.iid}s
 * corresponding to {@link Persona}s from backends with write
 * support so that they can be linked.
 *
 * This is necessary so that personas from the same backend
 * can be linked together even if they have no other linkeable
 * properties set.
 *
 * @since 0.5.0
 */
GType folks_local_id_details_get_type (void) {
	static volatile gsize folks_local_id_details_type_id__volatile = 0;
	if (g_once_init_enter (&folks_local_id_details_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksLocalIdDetailsIface), (GBaseInitFunc) folks_local_id_details_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType folks_local_id_details_type_id;
		folks_local_id_details_type_id = g_type_register_static (G_TYPE_INTERFACE, "FolksLocalIdDetails", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (folks_local_id_details_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&folks_local_id_details_type_id__volatile, folks_local_id_details_type_id);
	}
	return folks_local_id_details_type_id__volatile;
}



