/* trf-persona.c generated by valac 0.27.1.4-8d57, the Vala compiler
 * generated from trf-persona.vala, do not modify */

/*
 * Copyright (C) 2011 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *         Travis Reitter <travis.reitter@collabora.co.uk>
 *         Marco Barisione <marco.barisione@collabora.co.uk>
 *         Raul Gutierrez Segales <raul.gutierrez.segales@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <folks/folks.h>
#include <stdlib.h>
#include <string.h>
#include <folks/small-set.h>
#include <gee.h>
#include <libtracker-sparql/tracker-sparql.h>
#include <gio/gio.h>
#include <folks/small-set-internal.h>


#define TRF_TYPE_PERSONA (trf_persona_get_type ())
#define TRF_PERSONA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRF_TYPE_PERSONA, TrfPersona))
#define TRF_PERSONA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRF_TYPE_PERSONA, TrfPersonaClass))
#define TRF_IS_PERSONA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRF_TYPE_PERSONA))
#define TRF_IS_PERSONA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRF_TYPE_PERSONA))
#define TRF_PERSONA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRF_TYPE_PERSONA, TrfPersonaClass))

typedef struct _TrfPersona TrfPersona;
typedef struct _TrfPersonaClass TrfPersonaClass;
typedef struct _TrfPersonaPrivate TrfPersonaPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

#define TRF_TYPE_PERSONA_STORE (trf_persona_store_get_type ())
#define TRF_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRF_TYPE_PERSONA_STORE, TrfPersonaStore))
#define TRF_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRF_TYPE_PERSONA_STORE, TrfPersonaStoreClass))
#define TRF_IS_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRF_TYPE_PERSONA_STORE))
#define TRF_IS_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRF_TYPE_PERSONA_STORE))
#define TRF_PERSONA_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRF_TYPE_PERSONA_STORE, TrfPersonaStoreClass))

typedef struct _TrfPersonaStore TrfPersonaStore;
typedef struct _TrfPersonaStoreClass TrfPersonaStoreClass;
typedef struct _TrfPersonaChangeNicknameData TrfPersonaChangeNicknameData;
typedef struct _TrfPersonaChangePhoneNumbersData TrfPersonaChangePhoneNumbersData;
typedef struct _TrfPersonaChangeEmailAddressesData TrfPersonaChangeEmailAddressesData;
typedef struct _TrfPersonaChangeAvatarData TrfPersonaChangeAvatarData;
typedef struct _TrfPersonaChangeStructuredNameData TrfPersonaChangeStructuredNameData;
typedef struct _TrfPersonaChangeFullNameData TrfPersonaChangeFullNameData;
typedef struct _TrfPersonaChangeGenderData TrfPersonaChangeGenderData;
typedef struct _TrfPersonaChangeBirthdayData TrfPersonaChangeBirthdayData;
typedef struct _TrfPersonaChangeRolesData TrfPersonaChangeRolesData;
typedef struct _TrfPersonaChangeNotesData TrfPersonaChangeNotesData;
typedef struct _TrfPersonaChangeUrlsData TrfPersonaChangeUrlsData;
typedef struct _TrfPersonaChangePostalAddressesData TrfPersonaChangePostalAddressesData;
typedef struct _TrfPersonaChangeImAddressesData TrfPersonaChangeImAddressesData;
typedef struct _TrfPersonaChangeIsFavouriteData TrfPersonaChangeIsFavouriteData;
typedef struct _TrfPersonaChangeLocalIdsData TrfPersonaChangeLocalIdsData;
typedef struct _TrfPersonaChangeWebServiceAddressesData TrfPersonaChangeWebServiceAddressesData;

#define TRF_TYPE_FIELDS (trf_fields_get_type ())

#define TRF_TYPE_POSTAL_ADDRESS_FIELDS (trf_postal_address_fields_get_type ())

#define TRF_TYPE_ROLE_FIELDS (trf_role_fields_get_type ())

#define TRF_TYPE_IM_FIELDS (trf_im_fields_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TRF_TYPE_PHONE_FIELDS (trf_phone_fields_get_type ())

#define TRF_TYPE_EMAIL_FIELDS (trf_email_fields_get_type ())

#define TRF_TYPE_URLS_FIELDS (trf_urls_fields_get_type ())

struct _TrfPersona {
	FolksPersona parent_instance;
	TrfPersonaPrivate * priv;
};

struct _TrfPersonaClass {
	FolksPersonaClass parent_class;
};

struct _TrfPersonaPrivate {
	gchar* _nickname;
	gboolean _is_favourite;
	FolksSmallSet* _phone_numbers;
	GeeSet* _phone_numbers_ro;
	FolksSmallSet* _email_addresses;
	GeeSet* _email_addresses_ro;
	TrackerSparqlCursor* _cursor;
	gchar* _tracker_id;
	GLoadableIcon* _avatar;
	FolksStructuredName* _structured_name;
	gchar* _full_name;
	FolksGender _gender;
	GDateTime* _birthday;
	FolksSmallSet* _roles;
	GeeSet* _roles_ro;
	FolksSmallSet* _notes;
	GeeSet* _notes_ro;
	FolksSmallSet* _urls;
	GeeSet* _urls_ro;
	FolksSmallSet* _postal_addresses;
	GeeSet* _postal_addresses_ro;
	GeeHashMap* _tracker_ids_ims;
	GeeHashMultiMap* _im_addresses;
	GeeHashSet* _local_ids;
	GeeSet* _local_ids_ro;
	GeeHashMultiMap* _web_service_addresses;
};

struct _TrfPersonaChangeNicknameData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrfPersona* self;
	gchar* nickname;
	FolksPersonaStore* _tmp0_;
	FolksPersonaStore* _tmp1_;
	const gchar* _tmp2_;
};

struct _TrfPersonaChangePhoneNumbersData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrfPersona* self;
	GeeSet* phone_numbers;
	FolksPersonaStore* _tmp0_;
	FolksPersonaStore* _tmp1_;
	GeeSet* _tmp2_;
};

struct _TrfPersonaChangeEmailAddressesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrfPersona* self;
	GeeSet* email_addresses;
	FolksPersonaStore* _tmp0_;
	FolksPersonaStore* _tmp1_;
	GeeSet* _tmp2_;
};

struct _TrfPersonaChangeAvatarData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrfPersona* self;
	GLoadableIcon* avatar;
	FolksPersonaStore* _tmp0_;
	FolksPersonaStore* _tmp1_;
	GLoadableIcon* _tmp2_;
};

struct _TrfPersonaChangeStructuredNameData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrfPersona* self;
	FolksStructuredName* structured_name;
	FolksPersonaStore* _tmp0_;
	FolksPersonaStore* _tmp1_;
	FolksStructuredName* _tmp2_;
};

struct _TrfPersonaChangeFullNameData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrfPersona* self;
	gchar* full_name;
	FolksPersonaStore* _tmp0_;
	FolksPersonaStore* _tmp1_;
	const gchar* _tmp2_;
};

struct _TrfPersonaChangeGenderData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrfPersona* self;
	FolksGender gender;
	FolksPersonaStore* _tmp0_;
	FolksPersonaStore* _tmp1_;
	FolksGender _tmp2_;
};

struct _TrfPersonaChangeBirthdayData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrfPersona* self;
	GDateTime* birthday;
	FolksPersonaStore* _tmp0_;
	FolksPersonaStore* _tmp1_;
	GDateTime* _tmp2_;
	GDateTime* _tmp3_;
};

struct _TrfPersonaChangeRolesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrfPersona* self;
	GeeSet* roles;
	FolksPersonaStore* _tmp0_;
	FolksPersonaStore* _tmp1_;
	GeeSet* _tmp2_;
};

struct _TrfPersonaChangeNotesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrfPersona* self;
	GeeSet* notes;
	FolksPersonaStore* _tmp0_;
	FolksPersonaStore* _tmp1_;
	GeeSet* _tmp2_;
};

struct _TrfPersonaChangeUrlsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrfPersona* self;
	GeeSet* urls;
	FolksPersonaStore* _tmp0_;
	FolksPersonaStore* _tmp1_;
	GeeSet* _tmp2_;
};

struct _TrfPersonaChangePostalAddressesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrfPersona* self;
	GeeSet* postal_addresses;
	FolksPersonaStore* _tmp0_;
	FolksPersonaStore* _tmp1_;
	GeeSet* _tmp2_;
};

struct _TrfPersonaChangeImAddressesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrfPersona* self;
	GeeMultiMap* im_addresses;
	FolksPersonaStore* _tmp0_;
	FolksPersonaStore* _tmp1_;
	GeeMultiMap* _tmp2_;
};

struct _TrfPersonaChangeIsFavouriteData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrfPersona* self;
	gboolean is_favourite;
	gboolean _tmp0_;
	gboolean _tmp1_;
	FolksPersonaStore* _tmp2_;
	FolksPersonaStore* _tmp3_;
	gboolean _tmp4_;
};

struct _TrfPersonaChangeLocalIdsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrfPersona* self;
	GeeSet* local_ids;
	GeeSet* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gboolean _tmp3_;
	GeeSet* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	FolksPersonaStore* _tmp7_;
	FolksPersonaStore* _tmp8_;
	GeeSet* _tmp9_;
};

struct _TrfPersonaChangeWebServiceAddressesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrfPersona* self;
	GeeMultiMap* web_service_addresses;
	FolksPersonaStore* _tmp0_;
	FolksPersonaStore* _tmp1_;
	GeeMultiMap* _tmp2_;
};

typedef enum  {
	TRF_FIELDS_TRACKER_ID,
	TRF_FIELDS_FULL_NAME,
	TRF_FIELDS_FAMILY_NAME,
	TRF_FIELDS_GIVEN_NAME,
	TRF_FIELDS_ADDITIONAL_NAMES,
	TRF_FIELDS_PREFIXES,
	TRF_FIELDS_SUFFIXES,
	TRF_FIELDS_NICKNAME,
	TRF_FIELDS_BIRTHDAY,
	TRF_FIELDS_AVATAR_URL,
	TRF_FIELDS_IM_ADDRESSES,
	TRF_FIELDS_PHONES,
	TRF_FIELDS_EMAILS,
	TRF_FIELDS_URLS,
	TRF_FIELDS_FAVOURITE,
	TRF_FIELDS_CONTACT_URN,
	TRF_FIELDS_ROLES,
	TRF_FIELDS_NOTE,
	TRF_FIELDS_GENDER,
	TRF_FIELDS_POSTAL_ADDRESS,
	TRF_FIELDS_LOCAL_IDS_PROPERTY
} TrfFields;

typedef enum  {
	TRF_POSTAL_ADDRESS_FIELDS_TRACKER_ID,
	TRF_POSTAL_ADDRESS_FIELDS_POBOX,
	TRF_POSTAL_ADDRESS_FIELDS_DISTRICT,
	TRF_POSTAL_ADDRESS_FIELDS_COUNTY,
	TRF_POSTAL_ADDRESS_FIELDS_LOCALITY,
	TRF_POSTAL_ADDRESS_FIELDS_POSTALCODE,
	TRF_POSTAL_ADDRESS_FIELDS_STREET_ADDRESS,
	TRF_POSTAL_ADDRESS_FIELDS_ADDRESS_LOCATION,
	TRF_POSTAL_ADDRESS_FIELDS_EXTENDED_ADDRESS,
	TRF_POSTAL_ADDRESS_FIELDS_COUNTRY,
	TRF_POSTAL_ADDRESS_FIELDS_REGION
} TrfPostalAddressFields;

typedef enum  {
	TRF_ROLE_FIELDS_TRACKER_ID,
	TRF_ROLE_FIELDS_ROLE,
	TRF_ROLE_FIELDS_DEPARTMENT,
	TRF_ROLE_FIELDS_TITLE
} TrfRoleFields;

typedef enum  {
	TRF_IM_FIELDS_TRACKER_ID,
	TRF_IM_FIELDS_PROTO,
	TRF_IM_FIELDS_ID,
	TRF_IM_FIELDS_IM_NICKNAME
} TrfIMFields;

typedef enum  {
	TRF_PHONE_FIELDS_TRACKER_ID,
	TRF_PHONE_FIELDS_PHONE
} TrfPhoneFields;

typedef enum  {
	TRF_EMAIL_FIELDS_TRACKER_ID,
	TRF_EMAIL_FIELDS_EMAIL
} TrfEmailFields;

typedef enum  {
	TRF_URLS_FIELDS_TRACKER_ID,
	TRF_URLS_FIELDS_BLOG,
	TRF_URLS_FIELDS_WEBSITE,
	TRF_URLS_FIELDS_URL
} TrfUrlsFields;


static gpointer trf_persona_parent_class = NULL;
static FolksAvatarDetailsIface* trf_persona_folks_avatar_details_parent_iface = NULL;
static FolksBirthdayDetailsIface* trf_persona_folks_birthday_details_parent_iface = NULL;
static FolksEmailDetailsIface* trf_persona_folks_email_details_parent_iface = NULL;
static FolksFavouriteDetailsIface* trf_persona_folks_favourite_details_parent_iface = NULL;
static FolksGenderDetailsIface* trf_persona_folks_gender_details_parent_iface = NULL;
static FolksImDetailsIface* trf_persona_folks_im_details_parent_iface = NULL;
static FolksLocalIdDetailsIface* trf_persona_folks_local_id_details_parent_iface = NULL;
static FolksNameDetailsIface* trf_persona_folks_name_details_parent_iface = NULL;
static FolksNoteDetailsIface* trf_persona_folks_note_details_parent_iface = NULL;
static FolksPhoneDetailsIface* trf_persona_folks_phone_details_parent_iface = NULL;
static FolksPostalAddressDetailsIface* trf_persona_folks_postal_address_details_parent_iface = NULL;
static FolksRoleDetailsIface* trf_persona_folks_role_details_parent_iface = NULL;
static FolksUrlDetailsIface* trf_persona_folks_url_details_parent_iface = NULL;
static FolksWebServiceDetailsIface* trf_persona_folks_web_service_details_parent_iface = NULL;

GType trf_persona_get_type (void) G_GNUC_CONST;
#define TRF_PERSONA_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TRF_TYPE_PERSONA, TrfPersonaPrivate))
enum  {
	TRF_PERSONA_DUMMY_PROPERTY,
	TRF_PERSONA_NICKNAME,
	TRF_PERSONA_PHONE_NUMBERS,
	TRF_PERSONA_EMAIL_ADDRESSES,
	TRF_PERSONA_LINKABLE_PROPERTIES,
	TRF_PERSONA_WRITEABLE_PROPERTIES,
	TRF_PERSONA_AVATAR,
	TRF_PERSONA_STRUCTURED_NAME,
	TRF_PERSONA_FULL_NAME,
	TRF_PERSONA_GENDER,
	TRF_PERSONA_BIRTHDAY,
	TRF_PERSONA_CALENDAR_EVENT_ID,
	TRF_PERSONA_ROLES,
	TRF_PERSONA_NOTES,
	TRF_PERSONA_URLS,
	TRF_PERSONA_POSTAL_ADDRESSES,
	TRF_PERSONA_IM_ADDRESSES,
	TRF_PERSONA_IS_FAVOURITE,
	TRF_PERSONA_LOCAL_IDS,
	TRF_PERSONA_WEB_SERVICE_ADDRESSES,
	TRF_PERSONA_TRACKER_ID,
	TRF_PERSONA_CURSOR
};
static guint _folks_abstract_field_details_hash_static_gee_hash_data_func (gconstpointer v, gpointer self);
static gboolean _folks_abstract_field_details_equal_static_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self);
static void trf_persona_real_change_nickname_data_free (gpointer _data);
static void trf_persona_real_change_nickname (FolksNameDetails* base, const gchar* nickname, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean trf_persona_real_change_nickname_co (TrfPersonaChangeNicknameData* _data_);
GType trf_persona_store_get_type (void) G_GNUC_CONST;
void _trf_persona_store_set_nickname (TrfPersonaStore* self, TrfPersona* persona, const gchar* nickname, GAsyncReadyCallback _callback_, gpointer _user_data_);
void _trf_persona_store_set_nickname_finish (TrfPersonaStore* self, GAsyncResult* _res_);
static void trf_persona_change_nickname_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void trf_persona_real_change_phone_numbers_data_free (gpointer _data);
static void trf_persona_real_change_phone_numbers (FolksPhoneDetails* base, GeeSet* phone_numbers, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean trf_persona_real_change_phone_numbers_co (TrfPersonaChangePhoneNumbersData* _data_);
void _trf_persona_store_set_phones (TrfPersonaStore* self, FolksPersona* persona, GeeSet* phone_numbers, GAsyncReadyCallback _callback_, gpointer _user_data_);
void _trf_persona_store_set_phones_finish (TrfPersonaStore* self, GAsyncResult* _res_);
static void trf_persona_change_phone_numbers_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void trf_persona_real_change_email_addresses_data_free (gpointer _data);
static void trf_persona_real_change_email_addresses (FolksEmailDetails* base, GeeSet* email_addresses, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean trf_persona_real_change_email_addresses_co (TrfPersonaChangeEmailAddressesData* _data_);
void _trf_persona_store_set_emails (TrfPersonaStore* self, FolksPersona* persona, GeeSet* emails, GAsyncReadyCallback _callback_, gpointer _user_data_);
void _trf_persona_store_set_emails_finish (TrfPersonaStore* self, GAsyncResult* _res_);
static void trf_persona_change_email_addresses_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void trf_persona_real_change_avatar_data_free (gpointer _data);
static void trf_persona_real_change_avatar (FolksAvatarDetails* base, GLoadableIcon* avatar, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean trf_persona_real_change_avatar_co (TrfPersonaChangeAvatarData* _data_);
void _trf_persona_store_set_avatar (TrfPersonaStore* self, FolksPersona* persona, GLoadableIcon* avatar, GAsyncReadyCallback _callback_, gpointer _user_data_);
void _trf_persona_store_set_avatar_finish (TrfPersonaStore* self, GAsyncResult* _res_);
static void trf_persona_change_avatar_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void trf_persona_real_change_structured_name_data_free (gpointer _data);
static void trf_persona_real_change_structured_name (FolksNameDetails* base, FolksStructuredName* structured_name, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean trf_persona_real_change_structured_name_co (TrfPersonaChangeStructuredNameData* _data_);
void _trf_persona_store_set_structured_name (TrfPersonaStore* self, FolksPersona* persona, FolksStructuredName* sname, GAsyncReadyCallback _callback_, gpointer _user_data_);
void _trf_persona_store_set_structured_name_finish (TrfPersonaStore* self, GAsyncResult* _res_);
static void trf_persona_change_structured_name_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void trf_persona_real_change_full_name_data_free (gpointer _data);
static void trf_persona_real_change_full_name (FolksNameDetails* base, const gchar* full_name, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean trf_persona_real_change_full_name_co (TrfPersonaChangeFullNameData* _data_);
void _trf_persona_store_set_full_name (TrfPersonaStore* self, FolksPersona* persona, const gchar* full_name, GAsyncReadyCallback _callback_, gpointer _user_data_);
void _trf_persona_store_set_full_name_finish (TrfPersonaStore* self, GAsyncResult* _res_);
static void trf_persona_change_full_name_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void trf_persona_real_change_gender_data_free (gpointer _data);
static void trf_persona_real_change_gender (FolksGenderDetails* base, FolksGender gender, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean trf_persona_real_change_gender_co (TrfPersonaChangeGenderData* _data_);
void _trf_persona_store_set_gender (TrfPersonaStore* self, FolksPersona* persona, FolksGender gender, GAsyncReadyCallback _callback_, gpointer _user_data_);
void _trf_persona_store_set_gender_finish (TrfPersonaStore* self, GAsyncResult* _res_);
static void trf_persona_change_gender_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void trf_persona_real_change_birthday_data_free (gpointer _data);
static void trf_persona_real_change_birthday (FolksBirthdayDetails* base, GDateTime* birthday, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean trf_persona_real_change_birthday_co (TrfPersonaChangeBirthdayData* _data_);
void _trf_persona_store_set_birthday (TrfPersonaStore* self, FolksPersona* persona, GDateTime* bday, GAsyncReadyCallback _callback_, gpointer _user_data_);
void _trf_persona_store_set_birthday_finish (TrfPersonaStore* self, GAsyncResult* _res_);
static void trf_persona_change_birthday_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void trf_persona_real_change_roles_data_free (gpointer _data);
static void trf_persona_real_change_roles (FolksRoleDetails* base, GeeSet* roles, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean trf_persona_real_change_roles_co (TrfPersonaChangeRolesData* _data_);
void _trf_persona_store_set_roles (TrfPersonaStore* self, FolksPersona* persona, GeeSet* roles, GAsyncReadyCallback _callback_, gpointer _user_data_);
void _trf_persona_store_set_roles_finish (TrfPersonaStore* self, GAsyncResult* _res_);
static void trf_persona_change_roles_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void trf_persona_real_change_notes_data_free (gpointer _data);
static void trf_persona_real_change_notes (FolksNoteDetails* base, GeeSet* notes, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean trf_persona_real_change_notes_co (TrfPersonaChangeNotesData* _data_);
void _trf_persona_store_set_notes (TrfPersonaStore* self, FolksPersona* persona, GeeSet* notes, GAsyncReadyCallback _callback_, gpointer _user_data_);
void _trf_persona_store_set_notes_finish (TrfPersonaStore* self, GAsyncResult* _res_);
static void trf_persona_change_notes_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void trf_persona_real_change_urls_data_free (gpointer _data);
static void trf_persona_real_change_urls (FolksUrlDetails* base, GeeSet* urls, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean trf_persona_real_change_urls_co (TrfPersonaChangeUrlsData* _data_);
void _trf_persona_store_set_urls (TrfPersonaStore* self, FolksPersona* persona, GeeSet* urls, GAsyncReadyCallback _callback_, gpointer _user_data_);
void _trf_persona_store_set_urls_finish (TrfPersonaStore* self, GAsyncResult* _res_);
static void trf_persona_change_urls_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void trf_persona_real_change_postal_addresses_data_free (gpointer _data);
static void trf_persona_real_change_postal_addresses (FolksPostalAddressDetails* base, GeeSet* postal_addresses, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean trf_persona_real_change_postal_addresses_co (TrfPersonaChangePostalAddressesData* _data_);
void _trf_persona_store_set_postal_addresses (TrfPersonaStore* self, FolksPersona* persona, GeeSet* postal_addresses, GAsyncReadyCallback _callback_, gpointer _user_data_);
void _trf_persona_store_set_postal_addresses_finish (TrfPersonaStore* self, GAsyncResult* _res_);
static void trf_persona_change_postal_addresses_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void trf_persona_real_change_im_addresses_data_free (gpointer _data);
static void trf_persona_real_change_im_addresses (FolksImDetails* base, GeeMultiMap* im_addresses, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean trf_persona_real_change_im_addresses_co (TrfPersonaChangeImAddressesData* _data_);
void _trf_persona_store_set_im_addresses (TrfPersonaStore* self, FolksPersona* persona, GeeMultiMap* im_addresses, GAsyncReadyCallback _callback_, gpointer _user_data_);
void _trf_persona_store_set_im_addresses_finish (TrfPersonaStore* self, GAsyncResult* _res_);
static void trf_persona_change_im_addresses_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void trf_persona_real_change_is_favourite_data_free (gpointer _data);
static void trf_persona_real_change_is_favourite (FolksFavouriteDetails* base, gboolean is_favourite, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean trf_persona_real_change_is_favourite_co (TrfPersonaChangeIsFavouriteData* _data_);
void _trf_persona_store_set_is_favourite (TrfPersonaStore* self, FolksPersona* persona, gboolean is_favourite, GAsyncReadyCallback _callback_, gpointer _user_data_);
void _trf_persona_store_set_is_favourite_finish (TrfPersonaStore* self, GAsyncResult* _res_);
static void trf_persona_change_is_favourite_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void trf_persona_real_change_local_ids_data_free (gpointer _data);
static void trf_persona_real_change_local_ids (FolksLocalIdDetails* base, GeeSet* local_ids, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean trf_persona_real_change_local_ids_co (TrfPersonaChangeLocalIdsData* _data_);
void _trf_persona_store_set_local_ids (TrfPersonaStore* self, TrfPersona* persona, GeeSet* local_ids, GAsyncReadyCallback _callback_, gpointer _user_data_);
void _trf_persona_store_set_local_ids_finish (TrfPersonaStore* self, GAsyncResult* _res_);
static void trf_persona_change_local_ids_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void trf_persona_real_change_web_service_addresses_data_free (gpointer _data);
static void trf_persona_real_change_web_service_addresses (FolksWebServiceDetails* base, GeeMultiMap* web_service_addresses, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean trf_persona_real_change_web_service_addresses_co (TrfPersonaChangeWebServiceAddressesData* _data_);
void _trf_persona_store_set_web_service_addrs (TrfPersonaStore* self, TrfPersona* persona, GeeMultiMap* ws_obj, GAsyncReadyCallback _callback_, gpointer _user_data_);
void _trf_persona_store_set_web_service_addrs_finish (TrfPersonaStore* self, GAsyncResult* _res_);
static void trf_persona_change_web_service_addresses_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
gchar* trf_persona_build_iid (const gchar* store_id, const gchar* tracker_id);
TrfPersona* trf_persona_new (TrfPersonaStore* store, const gchar* tracker_id, TrackerSparqlCursor* cursor);
TrfPersona* trf_persona_construct (GType object_type, TrfPersonaStore* store, const gchar* tracker_id, TrackerSparqlCursor* cursor);
GType trf_fields_get_type (void) G_GNUC_CONST;
#define TRF_ONTOLOGY_DEFS_DEFAULT_CONTACT_URN "http://www.semanticdesktop.org/ontologies/2007/03/22/nco#default-conta" \
"ct-me"
static void trf_persona_real_linkable_property_to_links (FolksPersona* base, const gchar* prop_name, FolksPersonaLinkablePropertyCallback callback, void* callback_target);
void _trf_persona_update_full_name (TrfPersona* self, const gchar* fn);
void _trf_persona_update_nickname (TrfPersona* self, const gchar* nickname);
void _trf_persona_update_family_name (TrfPersona* self, const gchar* family_name);
void _trf_persona_update_given_name (TrfPersona* self, const gchar* given_name);
void _trf_persona_update_additional_names (TrfPersona* self, const gchar* additional_names);
void _trf_persona_update_prefixes (TrfPersona* self, const gchar* prefixes);
void _trf_persona_update_suffixes (TrfPersona* self, const gchar* suffixes);
static void _trf_persona_update_postal_addresses (TrfPersona* self);
GType trf_postal_address_fields_get_type (void) G_GNUC_CONST;
static void _trf_persona_update_local_ids (TrfPersona* self);
gboolean _trf_persona_set_local_ids (TrfPersona* self, const gchar* local_ids);
gboolean _trf_persona_add_postal_address (TrfPersona* self, FolksPostalAddressFieldDetails* postal_address_fd);
gboolean _trf_persona_remove_postal_address (TrfPersona* self, const gchar* tracker_id);
static void _trf_persona_update_gender (TrfPersona* self);
void _trf_persona_set_gender (TrfPersona* self, gint gender_id);
gint trf_persona_store_get_gender_male_id (TrfPersonaStore* self);
gint trf_persona_store_get_gender_female_id (TrfPersonaStore* self);
static void _trf_persona_update_note (TrfPersona* self);
void _trf_persona_set_note (TrfPersona* self, const gchar* note_content);
static void _trf_persona_update_bday (TrfPersona* self);
void _trf_persona_set_birthday (TrfPersona* self, const gchar* birthday);
static void _trf_persona_update_roles (TrfPersona* self);
GType trf_role_fields_get_type (void) G_GNUC_CONST;
gboolean _trf_persona_add_role (TrfPersona* self, const gchar* tracker_id, const gchar* role, const gchar* title, const gchar* org);
gboolean _trf_persona_remove_role (TrfPersona* self, const gchar* tracker_id);
static void _trf_persona_update_names (TrfPersona* self);
static void _trf_persona_update_avatar (TrfPersona* self);
gboolean _trf_persona_set_avatar_from_uri (TrfPersona* self, const gchar* avatar_url);
gboolean _trf_persona_set_avatar (TrfPersona* self, GLoadableIcon* avatar);
GeeSet* trf_persona_store_unserialize_local_ids (const gchar* local_ids);
gboolean _trf_persona_set_web_service_addrs (TrfPersona* self, const gchar* ws_addrs);
GeeMultiMap* trf_persona_store_unserialize_web_services (const gchar* ws_addrs);
static void _trf_persona_update_im_addresses (TrfPersona* self);
GType trf_im_fields_get_type (void) G_GNUC_CONST;
gboolean _trf_persona_add_im_address (TrfPersona* self, const gchar* tracker_id, const gchar* im_proto, const gchar* account_id, gboolean notify);
gboolean _trf_persona_remove_im_address (TrfPersona* self, const gchar* tracker_id, gboolean notify);
static void _trf_persona_update_phones (TrfPersona* self);
GType trf_phone_fields_get_type (void) G_GNUC_CONST;
gboolean _trf_persona_add_phone (TrfPersona* self, const gchar* phone, const gchar* tracker_id);
gboolean _trf_persona_remove_phone (TrfPersona* self, const gchar* tracker_id);
gboolean _trf_persona_add_email (TrfPersona* self, const gchar* addr, const gchar* tracker_id);
gboolean _trf_persona_remove_email (TrfPersona* self, const gchar* tracker_id);
static void _trf_persona_update_email_addresses (TrfPersona* self);
GType trf_email_fields_get_type (void) G_GNUC_CONST;
static void _trf_persona_update_urls (TrfPersona* self);
GType trf_urls_fields_get_type (void) G_GNUC_CONST;
gboolean _trf_persona_add_url (TrfPersona* self, const gchar* url, const gchar* tracker_id, const gchar* type);
gboolean _trf_persona_remove_url (TrfPersona* self, const gchar* tracker_id);
static void _trf_persona_update_favourite (TrfPersona* self);
gint trf_persona_store_get_favorite_id (TrfPersonaStore* self);
void _trf_persona_set_favourite (TrfPersona* self, gboolean is_fav);
const gchar* trf_persona_get_tracker_id (TrfPersona* self);
static void trf_persona_set_tracker_id (TrfPersona* self, const gchar* value);
TrackerSparqlCursor* trf_persona_get_cursor (TrfPersona* self);
static void trf_persona_set_cursor (TrfPersona* self, TrackerSparqlCursor* value);
static GObject * trf_persona_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void trf_persona_finalize (GObject* obj);
static void _vala_trf_persona_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_trf_persona_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const gchar* TRF_PERSONA__linkable_properties[4] = {"im-addresses", "local-ids", "web-service-addresses", NULL};
static const gchar* TRF_PERSONA__writeable_properties[15] = {"phone-numbers", "email-addresses", "avatar", "structured-name", "full-name", "gender", "birthday", "roles", "notes", "urls", "im-addresses", "is-favourite", "local-ids", "web-service-addresses", NULL};

static guint _folks_abstract_field_details_hash_static_gee_hash_data_func (gconstpointer v, gpointer self) {
	guint result;
	result = folks_abstract_field_details_hash_static ((FolksAbstractFieldDetails*) v);
	return result;
}


static gboolean _folks_abstract_field_details_equal_static_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gboolean result;
	result = folks_abstract_field_details_equal_static ((FolksAbstractFieldDetails*) a, (FolksAbstractFieldDetails*) b);
	return result;
}


static void trf_persona_real_change_nickname_data_free (gpointer _data) {
	TrfPersonaChangeNicknameData* _data_;
	_data_ = _data;
	_g_free0 (_data_->nickname);
	_g_object_unref0 (_data_->self);
	g_slice_free (TrfPersonaChangeNicknameData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void trf_persona_real_change_nickname (FolksNameDetails* base, const gchar* nickname, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrfPersona * self;
	TrfPersonaChangeNicknameData* _data_;
	TrfPersona* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	self = (TrfPersona*) base;
	_data_ = g_slice_new0 (TrfPersonaChangeNicknameData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, trf_persona_real_change_nickname);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, trf_persona_real_change_nickname_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = nickname;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (_data_->nickname);
	_data_->nickname = _tmp2_;
	trf_persona_real_change_nickname_co (_data_);
}


static void trf_persona_real_change_nickname_finish (FolksNameDetails* base, GAsyncResult* _res_, GError** error) {
	TrfPersonaChangeNicknameData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * {@inheritDoc}
   *
   * @since 0.6.2
   */
static void trf_persona_change_nickname_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrfPersonaChangeNicknameData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	trf_persona_real_change_nickname_co (_data_);
}


static gboolean trf_persona_real_change_nickname_co (TrfPersonaChangeNicknameData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = folks_persona_get_store ((FolksPersona*) _data_->self);
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _data_->nickname;
	_data_->_state_ = 1;
	_trf_persona_store_set_nickname (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp1_, TRF_TYPE_PERSONA_STORE, TrfPersonaStore), _data_->self, _data_->_tmp2_, trf_persona_change_nickname_ready, _data_);
	return FALSE;
	_state_1:
	_trf_persona_store_set_nickname_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp1_, TRF_TYPE_PERSONA_STORE, TrfPersonaStore), _data_->_res_);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void trf_persona_real_change_phone_numbers_data_free (gpointer _data) {
	TrfPersonaChangePhoneNumbersData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->phone_numbers);
	_g_object_unref0 (_data_->self);
	g_slice_free (TrfPersonaChangePhoneNumbersData, _data_);
}


static void trf_persona_real_change_phone_numbers (FolksPhoneDetails* base, GeeSet* phone_numbers, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrfPersona * self;
	TrfPersonaChangePhoneNumbersData* _data_;
	TrfPersona* _tmp0_ = NULL;
	GeeSet* _tmp1_ = NULL;
	GeeSet* _tmp2_ = NULL;
	self = (TrfPersona*) base;
	_data_ = g_slice_new0 (TrfPersonaChangePhoneNumbersData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, trf_persona_real_change_phone_numbers);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, trf_persona_real_change_phone_numbers_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = phone_numbers;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->phone_numbers);
	_data_->phone_numbers = _tmp2_;
	trf_persona_real_change_phone_numbers_co (_data_);
}


static void trf_persona_real_change_phone_numbers_finish (FolksPhoneDetails* base, GAsyncResult* _res_, GError** error) {
	TrfPersonaChangePhoneNumbersData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * {@inheritDoc}
   *
   * @since 0.6.2
   */
static void trf_persona_change_phone_numbers_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrfPersonaChangePhoneNumbersData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	trf_persona_real_change_phone_numbers_co (_data_);
}


static gboolean trf_persona_real_change_phone_numbers_co (TrfPersonaChangePhoneNumbersData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = folks_persona_get_store ((FolksPersona*) _data_->self);
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _data_->phone_numbers;
	_data_->_state_ = 1;
	_trf_persona_store_set_phones (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp1_, TRF_TYPE_PERSONA_STORE, TrfPersonaStore), (FolksPersona*) _data_->self, _data_->_tmp2_, trf_persona_change_phone_numbers_ready, _data_);
	return FALSE;
	_state_1:
	_trf_persona_store_set_phones_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp1_, TRF_TYPE_PERSONA_STORE, TrfPersonaStore), _data_->_res_);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void trf_persona_real_change_email_addresses_data_free (gpointer _data) {
	TrfPersonaChangeEmailAddressesData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->email_addresses);
	_g_object_unref0 (_data_->self);
	g_slice_free (TrfPersonaChangeEmailAddressesData, _data_);
}


static void trf_persona_real_change_email_addresses (FolksEmailDetails* base, GeeSet* email_addresses, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrfPersona * self;
	TrfPersonaChangeEmailAddressesData* _data_;
	TrfPersona* _tmp0_ = NULL;
	GeeSet* _tmp1_ = NULL;
	GeeSet* _tmp2_ = NULL;
	self = (TrfPersona*) base;
	_data_ = g_slice_new0 (TrfPersonaChangeEmailAddressesData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, trf_persona_real_change_email_addresses);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, trf_persona_real_change_email_addresses_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = email_addresses;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->email_addresses);
	_data_->email_addresses = _tmp2_;
	trf_persona_real_change_email_addresses_co (_data_);
}


static void trf_persona_real_change_email_addresses_finish (FolksEmailDetails* base, GAsyncResult* _res_, GError** error) {
	TrfPersonaChangeEmailAddressesData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * {@inheritDoc}
   *
   * @since 0.6.2
   */
static void trf_persona_change_email_addresses_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrfPersonaChangeEmailAddressesData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	trf_persona_real_change_email_addresses_co (_data_);
}


static gboolean trf_persona_real_change_email_addresses_co (TrfPersonaChangeEmailAddressesData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = folks_persona_get_store ((FolksPersona*) _data_->self);
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _data_->email_addresses;
	_data_->_state_ = 1;
	_trf_persona_store_set_emails (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp1_, TRF_TYPE_PERSONA_STORE, TrfPersonaStore), (FolksPersona*) _data_->self, _data_->_tmp2_, trf_persona_change_email_addresses_ready, _data_);
	return FALSE;
	_state_1:
	_trf_persona_store_set_emails_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp1_, TRF_TYPE_PERSONA_STORE, TrfPersonaStore), _data_->_res_);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void trf_persona_real_change_avatar_data_free (gpointer _data) {
	TrfPersonaChangeAvatarData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->avatar);
	_g_object_unref0 (_data_->self);
	g_slice_free (TrfPersonaChangeAvatarData, _data_);
}


static void trf_persona_real_change_avatar (FolksAvatarDetails* base, GLoadableIcon* avatar, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrfPersona * self;
	TrfPersonaChangeAvatarData* _data_;
	TrfPersona* _tmp0_ = NULL;
	GLoadableIcon* _tmp1_ = NULL;
	GLoadableIcon* _tmp2_ = NULL;
	self = (TrfPersona*) base;
	_data_ = g_slice_new0 (TrfPersonaChangeAvatarData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, trf_persona_real_change_avatar);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, trf_persona_real_change_avatar_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = avatar;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->avatar);
	_data_->avatar = _tmp2_;
	trf_persona_real_change_avatar_co (_data_);
}


static void trf_persona_real_change_avatar_finish (FolksAvatarDetails* base, GAsyncResult* _res_, GError** error) {
	TrfPersonaChangeAvatarData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * {@inheritDoc}
   *
   * @since 0.6.2
   */
static void trf_persona_change_avatar_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrfPersonaChangeAvatarData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	trf_persona_real_change_avatar_co (_data_);
}


static gboolean trf_persona_real_change_avatar_co (TrfPersonaChangeAvatarData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = folks_persona_get_store ((FolksPersona*) _data_->self);
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _data_->avatar;
	_data_->_state_ = 1;
	_trf_persona_store_set_avatar (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp1_, TRF_TYPE_PERSONA_STORE, TrfPersonaStore), (FolksPersona*) _data_->self, _data_->_tmp2_, trf_persona_change_avatar_ready, _data_);
	return FALSE;
	_state_1:
	_trf_persona_store_set_avatar_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp1_, TRF_TYPE_PERSONA_STORE, TrfPersonaStore), _data_->_res_);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void trf_persona_real_change_structured_name_data_free (gpointer _data) {
	TrfPersonaChangeStructuredNameData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->structured_name);
	_g_object_unref0 (_data_->self);
	g_slice_free (TrfPersonaChangeStructuredNameData, _data_);
}


static void trf_persona_real_change_structured_name (FolksNameDetails* base, FolksStructuredName* structured_name, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrfPersona * self;
	TrfPersonaChangeStructuredNameData* _data_;
	TrfPersona* _tmp0_ = NULL;
	FolksStructuredName* _tmp1_ = NULL;
	FolksStructuredName* _tmp2_ = NULL;
	self = (TrfPersona*) base;
	_data_ = g_slice_new0 (TrfPersonaChangeStructuredNameData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, trf_persona_real_change_structured_name);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, trf_persona_real_change_structured_name_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = structured_name;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->structured_name);
	_data_->structured_name = _tmp2_;
	trf_persona_real_change_structured_name_co (_data_);
}


static void trf_persona_real_change_structured_name_finish (FolksNameDetails* base, GAsyncResult* _res_, GError** error) {
	TrfPersonaChangeStructuredNameData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * {@inheritDoc}
   *
   * @since 0.6.2
   */
static void trf_persona_change_structured_name_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrfPersonaChangeStructuredNameData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	trf_persona_real_change_structured_name_co (_data_);
}


static gboolean trf_persona_real_change_structured_name_co (TrfPersonaChangeStructuredNameData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = folks_persona_get_store ((FolksPersona*) _data_->self);
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _data_->structured_name;
	_data_->_state_ = 1;
	_trf_persona_store_set_structured_name (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp1_, TRF_TYPE_PERSONA_STORE, TrfPersonaStore), (FolksPersona*) _data_->self, _data_->_tmp2_, trf_persona_change_structured_name_ready, _data_);
	return FALSE;
	_state_1:
	_trf_persona_store_set_structured_name_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp1_, TRF_TYPE_PERSONA_STORE, TrfPersonaStore), _data_->_res_);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void trf_persona_real_change_full_name_data_free (gpointer _data) {
	TrfPersonaChangeFullNameData* _data_;
	_data_ = _data;
	_g_free0 (_data_->full_name);
	_g_object_unref0 (_data_->self);
	g_slice_free (TrfPersonaChangeFullNameData, _data_);
}


static void trf_persona_real_change_full_name (FolksNameDetails* base, const gchar* full_name, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrfPersona * self;
	TrfPersonaChangeFullNameData* _data_;
	TrfPersona* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	self = (TrfPersona*) base;
	_data_ = g_slice_new0 (TrfPersonaChangeFullNameData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, trf_persona_real_change_full_name);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, trf_persona_real_change_full_name_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = full_name;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (_data_->full_name);
	_data_->full_name = _tmp2_;
	trf_persona_real_change_full_name_co (_data_);
}


static void trf_persona_real_change_full_name_finish (FolksNameDetails* base, GAsyncResult* _res_, GError** error) {
	TrfPersonaChangeFullNameData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * {@inheritDoc}
   *
   * @since 0.6.2
   */
static void trf_persona_change_full_name_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrfPersonaChangeFullNameData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	trf_persona_real_change_full_name_co (_data_);
}


static gboolean trf_persona_real_change_full_name_co (TrfPersonaChangeFullNameData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = folks_persona_get_store ((FolksPersona*) _data_->self);
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _data_->full_name;
	_data_->_state_ = 1;
	_trf_persona_store_set_full_name (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp1_, TRF_TYPE_PERSONA_STORE, TrfPersonaStore), (FolksPersona*) _data_->self, _data_->_tmp2_, trf_persona_change_full_name_ready, _data_);
	return FALSE;
	_state_1:
	_trf_persona_store_set_full_name_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp1_, TRF_TYPE_PERSONA_STORE, TrfPersonaStore), _data_->_res_);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void trf_persona_real_change_gender_data_free (gpointer _data) {
	TrfPersonaChangeGenderData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (TrfPersonaChangeGenderData, _data_);
}


static void trf_persona_real_change_gender (FolksGenderDetails* base, FolksGender gender, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrfPersona * self;
	TrfPersonaChangeGenderData* _data_;
	TrfPersona* _tmp0_ = NULL;
	FolksGender _tmp1_ = 0;
	self = (TrfPersona*) base;
	_data_ = g_slice_new0 (TrfPersonaChangeGenderData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, trf_persona_real_change_gender);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, trf_persona_real_change_gender_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = gender;
	_data_->gender = _tmp1_;
	trf_persona_real_change_gender_co (_data_);
}


static void trf_persona_real_change_gender_finish (FolksGenderDetails* base, GAsyncResult* _res_, GError** error) {
	TrfPersonaChangeGenderData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * {@inheritDoc}
   *
   * @since 0.6.2
   */
static void trf_persona_change_gender_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrfPersonaChangeGenderData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	trf_persona_real_change_gender_co (_data_);
}


static gboolean trf_persona_real_change_gender_co (TrfPersonaChangeGenderData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = folks_persona_get_store ((FolksPersona*) _data_->self);
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = 0;
	_data_->_tmp2_ = _data_->gender;
	_data_->_state_ = 1;
	_trf_persona_store_set_gender (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp1_, TRF_TYPE_PERSONA_STORE, TrfPersonaStore), (FolksPersona*) _data_->self, _data_->_tmp2_, trf_persona_change_gender_ready, _data_);
	return FALSE;
	_state_1:
	_trf_persona_store_set_gender_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp1_, TRF_TYPE_PERSONA_STORE, TrfPersonaStore), _data_->_res_);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void trf_persona_real_change_birthday_data_free (gpointer _data) {
	TrfPersonaChangeBirthdayData* _data_;
	_data_ = _data;
	_g_date_time_unref0 (_data_->birthday);
	_g_object_unref0 (_data_->self);
	g_slice_free (TrfPersonaChangeBirthdayData, _data_);
}


static gpointer _g_date_time_ref0 (gpointer self) {
	return self ? g_date_time_ref (self) : NULL;
}


static void trf_persona_real_change_birthday (FolksBirthdayDetails* base, GDateTime* birthday, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrfPersona * self;
	TrfPersonaChangeBirthdayData* _data_;
	TrfPersona* _tmp0_ = NULL;
	GDateTime* _tmp1_ = NULL;
	GDateTime* _tmp2_ = NULL;
	self = (TrfPersona*) base;
	_data_ = g_slice_new0 (TrfPersonaChangeBirthdayData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, trf_persona_real_change_birthday);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, trf_persona_real_change_birthday_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = birthday;
	_tmp2_ = _g_date_time_ref0 (_tmp1_);
	_g_date_time_unref0 (_data_->birthday);
	_data_->birthday = _tmp2_;
	trf_persona_real_change_birthday_co (_data_);
}


static void trf_persona_real_change_birthday_finish (FolksBirthdayDetails* base, GAsyncResult* _res_, GError** error) {
	TrfPersonaChangeBirthdayData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * {@inheritDoc}
   *
   * @since 0.6.2
   */
static void trf_persona_change_birthday_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrfPersonaChangeBirthdayData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	trf_persona_real_change_birthday_co (_data_);
}


static gboolean trf_persona_real_change_birthday_co (TrfPersonaChangeBirthdayData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = folks_persona_get_store ((FolksPersona*) _data_->self);
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _data_->birthday;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = _g_date_time_ref0 (_data_->_tmp2_);
	_data_->_state_ = 1;
	_trf_persona_store_set_birthday (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp1_, TRF_TYPE_PERSONA_STORE, TrfPersonaStore), (FolksPersona*) _data_->self, _data_->_tmp3_, trf_persona_change_birthday_ready, _data_);
	return FALSE;
	_state_1:
	_trf_persona_store_set_birthday_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp1_, TRF_TYPE_PERSONA_STORE, TrfPersonaStore), _data_->_res_);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void trf_persona_real_change_roles_data_free (gpointer _data) {
	TrfPersonaChangeRolesData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->roles);
	_g_object_unref0 (_data_->self);
	g_slice_free (TrfPersonaChangeRolesData, _data_);
}


static void trf_persona_real_change_roles (FolksRoleDetails* base, GeeSet* roles, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrfPersona * self;
	TrfPersonaChangeRolesData* _data_;
	TrfPersona* _tmp0_ = NULL;
	GeeSet* _tmp1_ = NULL;
	GeeSet* _tmp2_ = NULL;
	self = (TrfPersona*) base;
	_data_ = g_slice_new0 (TrfPersonaChangeRolesData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, trf_persona_real_change_roles);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, trf_persona_real_change_roles_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = roles;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->roles);
	_data_->roles = _tmp2_;
	trf_persona_real_change_roles_co (_data_);
}


static void trf_persona_real_change_roles_finish (FolksRoleDetails* base, GAsyncResult* _res_, GError** error) {
	TrfPersonaChangeRolesData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * {@inheritDoc}
   *
   * @since 0.6.2
   */
static void trf_persona_change_roles_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrfPersonaChangeRolesData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	trf_persona_real_change_roles_co (_data_);
}


static gboolean trf_persona_real_change_roles_co (TrfPersonaChangeRolesData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = folks_persona_get_store ((FolksPersona*) _data_->self);
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _data_->roles;
	_data_->_state_ = 1;
	_trf_persona_store_set_roles (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp1_, TRF_TYPE_PERSONA_STORE, TrfPersonaStore), (FolksPersona*) _data_->self, _data_->_tmp2_, trf_persona_change_roles_ready, _data_);
	return FALSE;
	_state_1:
	_trf_persona_store_set_roles_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp1_, TRF_TYPE_PERSONA_STORE, TrfPersonaStore), _data_->_res_);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void trf_persona_real_change_notes_data_free (gpointer _data) {
	TrfPersonaChangeNotesData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->notes);
	_g_object_unref0 (_data_->self);
	g_slice_free (TrfPersonaChangeNotesData, _data_);
}


static void trf_persona_real_change_notes (FolksNoteDetails* base, GeeSet* notes, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrfPersona * self;
	TrfPersonaChangeNotesData* _data_;
	TrfPersona* _tmp0_ = NULL;
	GeeSet* _tmp1_ = NULL;
	GeeSet* _tmp2_ = NULL;
	self = (TrfPersona*) base;
	_data_ = g_slice_new0 (TrfPersonaChangeNotesData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, trf_persona_real_change_notes);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, trf_persona_real_change_notes_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = notes;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->notes);
	_data_->notes = _tmp2_;
	trf_persona_real_change_notes_co (_data_);
}


static void trf_persona_real_change_notes_finish (FolksNoteDetails* base, GAsyncResult* _res_, GError** error) {
	TrfPersonaChangeNotesData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * {@inheritDoc}
   *
   * @since 0.6.2
   */
static void trf_persona_change_notes_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrfPersonaChangeNotesData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	trf_persona_real_change_notes_co (_data_);
}


static gboolean trf_persona_real_change_notes_co (TrfPersonaChangeNotesData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = folks_persona_get_store ((FolksPersona*) _data_->self);
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _data_->notes;
	_data_->_state_ = 1;
	_trf_persona_store_set_notes (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp1_, TRF_TYPE_PERSONA_STORE, TrfPersonaStore), (FolksPersona*) _data_->self, _data_->_tmp2_, trf_persona_change_notes_ready, _data_);
	return FALSE;
	_state_1:
	_trf_persona_store_set_notes_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp1_, TRF_TYPE_PERSONA_STORE, TrfPersonaStore), _data_->_res_);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void trf_persona_real_change_urls_data_free (gpointer _data) {
	TrfPersonaChangeUrlsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->urls);
	_g_object_unref0 (_data_->self);
	g_slice_free (TrfPersonaChangeUrlsData, _data_);
}


static void trf_persona_real_change_urls (FolksUrlDetails* base, GeeSet* urls, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrfPersona * self;
	TrfPersonaChangeUrlsData* _data_;
	TrfPersona* _tmp0_ = NULL;
	GeeSet* _tmp1_ = NULL;
	GeeSet* _tmp2_ = NULL;
	self = (TrfPersona*) base;
	_data_ = g_slice_new0 (TrfPersonaChangeUrlsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, trf_persona_real_change_urls);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, trf_persona_real_change_urls_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = urls;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->urls);
	_data_->urls = _tmp2_;
	trf_persona_real_change_urls_co (_data_);
}


static void trf_persona_real_change_urls_finish (FolksUrlDetails* base, GAsyncResult* _res_, GError** error) {
	TrfPersonaChangeUrlsData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * {@inheritDoc}
   *
   * @since 0.6.2
   */
static void trf_persona_change_urls_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrfPersonaChangeUrlsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	trf_persona_real_change_urls_co (_data_);
}


static gboolean trf_persona_real_change_urls_co (TrfPersonaChangeUrlsData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = folks_persona_get_store ((FolksPersona*) _data_->self);
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _data_->urls;
	_data_->_state_ = 1;
	_trf_persona_store_set_urls (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp1_, TRF_TYPE_PERSONA_STORE, TrfPersonaStore), (FolksPersona*) _data_->self, _data_->_tmp2_, trf_persona_change_urls_ready, _data_);
	return FALSE;
	_state_1:
	_trf_persona_store_set_urls_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp1_, TRF_TYPE_PERSONA_STORE, TrfPersonaStore), _data_->_res_);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void trf_persona_real_change_postal_addresses_data_free (gpointer _data) {
	TrfPersonaChangePostalAddressesData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->postal_addresses);
	_g_object_unref0 (_data_->self);
	g_slice_free (TrfPersonaChangePostalAddressesData, _data_);
}


static void trf_persona_real_change_postal_addresses (FolksPostalAddressDetails* base, GeeSet* postal_addresses, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrfPersona * self;
	TrfPersonaChangePostalAddressesData* _data_;
	TrfPersona* _tmp0_ = NULL;
	GeeSet* _tmp1_ = NULL;
	GeeSet* _tmp2_ = NULL;
	self = (TrfPersona*) base;
	_data_ = g_slice_new0 (TrfPersonaChangePostalAddressesData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, trf_persona_real_change_postal_addresses);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, trf_persona_real_change_postal_addresses_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = postal_addresses;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->postal_addresses);
	_data_->postal_addresses = _tmp2_;
	trf_persona_real_change_postal_addresses_co (_data_);
}


static void trf_persona_real_change_postal_addresses_finish (FolksPostalAddressDetails* base, GAsyncResult* _res_, GError** error) {
	TrfPersonaChangePostalAddressesData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * {@inheritDoc}
   *
   * @since 0.6.2
   */
static void trf_persona_change_postal_addresses_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrfPersonaChangePostalAddressesData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	trf_persona_real_change_postal_addresses_co (_data_);
}


static gboolean trf_persona_real_change_postal_addresses_co (TrfPersonaChangePostalAddressesData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = folks_persona_get_store ((FolksPersona*) _data_->self);
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _data_->postal_addresses;
	_data_->_state_ = 1;
	_trf_persona_store_set_postal_addresses (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp1_, TRF_TYPE_PERSONA_STORE, TrfPersonaStore), (FolksPersona*) _data_->self, _data_->_tmp2_, trf_persona_change_postal_addresses_ready, _data_);
	return FALSE;
	_state_1:
	_trf_persona_store_set_postal_addresses_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp1_, TRF_TYPE_PERSONA_STORE, TrfPersonaStore), _data_->_res_);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void trf_persona_real_change_im_addresses_data_free (gpointer _data) {
	TrfPersonaChangeImAddressesData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->im_addresses);
	_g_object_unref0 (_data_->self);
	g_slice_free (TrfPersonaChangeImAddressesData, _data_);
}


static void trf_persona_real_change_im_addresses (FolksImDetails* base, GeeMultiMap* im_addresses, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrfPersona * self;
	TrfPersonaChangeImAddressesData* _data_;
	TrfPersona* _tmp0_ = NULL;
	GeeMultiMap* _tmp1_ = NULL;
	GeeMultiMap* _tmp2_ = NULL;
	self = (TrfPersona*) base;
	_data_ = g_slice_new0 (TrfPersonaChangeImAddressesData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, trf_persona_real_change_im_addresses);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, trf_persona_real_change_im_addresses_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = im_addresses;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->im_addresses);
	_data_->im_addresses = _tmp2_;
	trf_persona_real_change_im_addresses_co (_data_);
}


static void trf_persona_real_change_im_addresses_finish (FolksImDetails* base, GAsyncResult* _res_, GError** error) {
	TrfPersonaChangeImAddressesData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * {@inheritDoc}
   *
   * @since 0.6.2
   */
static void trf_persona_change_im_addresses_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrfPersonaChangeImAddressesData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	trf_persona_real_change_im_addresses_co (_data_);
}


static gboolean trf_persona_real_change_im_addresses_co (TrfPersonaChangeImAddressesData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = folks_persona_get_store ((FolksPersona*) _data_->self);
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _data_->im_addresses;
	_data_->_state_ = 1;
	_trf_persona_store_set_im_addresses (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp1_, TRF_TYPE_PERSONA_STORE, TrfPersonaStore), (FolksPersona*) _data_->self, _data_->_tmp2_, trf_persona_change_im_addresses_ready, _data_);
	return FALSE;
	_state_1:
	_trf_persona_store_set_im_addresses_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp1_, TRF_TYPE_PERSONA_STORE, TrfPersonaStore), _data_->_res_);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void trf_persona_real_change_is_favourite_data_free (gpointer _data) {
	TrfPersonaChangeIsFavouriteData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (TrfPersonaChangeIsFavouriteData, _data_);
}


static void trf_persona_real_change_is_favourite (FolksFavouriteDetails* base, gboolean is_favourite, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrfPersona * self;
	TrfPersonaChangeIsFavouriteData* _data_;
	TrfPersona* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	self = (TrfPersona*) base;
	_data_ = g_slice_new0 (TrfPersonaChangeIsFavouriteData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, trf_persona_real_change_is_favourite);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, trf_persona_real_change_is_favourite_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = is_favourite;
	_data_->is_favourite = _tmp1_;
	trf_persona_real_change_is_favourite_co (_data_);
}


static void trf_persona_real_change_is_favourite_finish (FolksFavouriteDetails* base, GAsyncResult* _res_, GError** error) {
	TrfPersonaChangeIsFavouriteData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * {@inheritDoc}
   *
   * @since 0.6.2
   */
static void trf_persona_change_is_favourite_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrfPersonaChangeIsFavouriteData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	trf_persona_real_change_is_favourite_co (_data_);
}


static gboolean trf_persona_real_change_is_favourite_co (TrfPersonaChangeIsFavouriteData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = FALSE;
	_data_->_tmp0_ = _data_->self->priv->_is_favourite;
	_data_->_tmp1_ = FALSE;
	_data_->_tmp1_ = _data_->is_favourite;
	if (_data_->_tmp0_ == _data_->_tmp1_) {
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = folks_persona_get_store ((FolksPersona*) _data_->self);
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = _data_->_tmp2_;
	_data_->_tmp4_ = FALSE;
	_data_->_tmp4_ = _data_->is_favourite;
	_data_->_state_ = 1;
	_trf_persona_store_set_is_favourite (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp3_, TRF_TYPE_PERSONA_STORE, TrfPersonaStore), (FolksPersona*) _data_->self, _data_->_tmp4_, trf_persona_change_is_favourite_ready, _data_);
	return FALSE;
	_state_1:
	_trf_persona_store_set_is_favourite_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp3_, TRF_TYPE_PERSONA_STORE, TrfPersonaStore), _data_->_res_);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void trf_persona_real_change_local_ids_data_free (gpointer _data) {
	TrfPersonaChangeLocalIdsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->local_ids);
	_g_object_unref0 (_data_->self);
	g_slice_free (TrfPersonaChangeLocalIdsData, _data_);
}


static void trf_persona_real_change_local_ids (FolksLocalIdDetails* base, GeeSet* local_ids, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrfPersona * self;
	TrfPersonaChangeLocalIdsData* _data_;
	TrfPersona* _tmp0_ = NULL;
	GeeSet* _tmp1_ = NULL;
	GeeSet* _tmp2_ = NULL;
	self = (TrfPersona*) base;
	_data_ = g_slice_new0 (TrfPersonaChangeLocalIdsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, trf_persona_real_change_local_ids);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, trf_persona_real_change_local_ids_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = local_ids;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->local_ids);
	_data_->local_ids = _tmp2_;
	trf_persona_real_change_local_ids_co (_data_);
}


static void trf_persona_real_change_local_ids_finish (FolksLocalIdDetails* base, GAsyncResult* _res_, GError** error) {
	TrfPersonaChangeLocalIdsData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * {@inheritDoc}
   *
   * @since 0.6.2
   */
static void trf_persona_change_local_ids_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrfPersonaChangeLocalIdsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	trf_persona_real_change_local_ids_co (_data_);
}


static gboolean trf_persona_real_change_local_ids_co (TrfPersonaChangeLocalIdsData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->local_ids;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = folks_persona_get_uid ((FolksPersona*) _data_->self);
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp3_ = FALSE;
	_data_->_tmp3_ = gee_collection_contains ((GeeCollection*) _data_->_tmp0_, _data_->_tmp2_);
	if (_data_->_tmp3_ == FALSE) {
		_data_->_tmp4_ = NULL;
		_data_->_tmp4_ = _data_->local_ids;
		_data_->_tmp5_ = NULL;
		_data_->_tmp5_ = folks_persona_get_uid ((FolksPersona*) _data_->self);
		_data_->_tmp6_ = NULL;
		_data_->_tmp6_ = _data_->_tmp5_;
		gee_collection_add ((GeeCollection*) _data_->_tmp4_, _data_->_tmp6_);
	}
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = folks_persona_get_store ((FolksPersona*) _data_->self);
	_data_->_tmp8_ = NULL;
	_data_->_tmp8_ = _data_->_tmp7_;
	_data_->_tmp9_ = NULL;
	_data_->_tmp9_ = _data_->local_ids;
	_data_->_state_ = 1;
	_trf_persona_store_set_local_ids (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp8_, TRF_TYPE_PERSONA_STORE, TrfPersonaStore), _data_->self, _data_->_tmp9_, trf_persona_change_local_ids_ready, _data_);
	return FALSE;
	_state_1:
	_trf_persona_store_set_local_ids_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp8_, TRF_TYPE_PERSONA_STORE, TrfPersonaStore), _data_->_res_);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void trf_persona_real_change_web_service_addresses_data_free (gpointer _data) {
	TrfPersonaChangeWebServiceAddressesData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->web_service_addresses);
	_g_object_unref0 (_data_->self);
	g_slice_free (TrfPersonaChangeWebServiceAddressesData, _data_);
}


static void trf_persona_real_change_web_service_addresses (FolksWebServiceDetails* base, GeeMultiMap* web_service_addresses, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrfPersona * self;
	TrfPersonaChangeWebServiceAddressesData* _data_;
	TrfPersona* _tmp0_ = NULL;
	GeeMultiMap* _tmp1_ = NULL;
	GeeMultiMap* _tmp2_ = NULL;
	self = (TrfPersona*) base;
	_data_ = g_slice_new0 (TrfPersonaChangeWebServiceAddressesData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, trf_persona_real_change_web_service_addresses);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, trf_persona_real_change_web_service_addresses_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = web_service_addresses;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->web_service_addresses);
	_data_->web_service_addresses = _tmp2_;
	trf_persona_real_change_web_service_addresses_co (_data_);
}


static void trf_persona_real_change_web_service_addresses_finish (FolksWebServiceDetails* base, GAsyncResult* _res_, GError** error) {
	TrfPersonaChangeWebServiceAddressesData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * {@inheritDoc}
   *
   * @since 0.6.2
   */
static void trf_persona_change_web_service_addresses_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrfPersonaChangeWebServiceAddressesData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	trf_persona_real_change_web_service_addresses_co (_data_);
}


static gboolean trf_persona_real_change_web_service_addresses_co (TrfPersonaChangeWebServiceAddressesData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = folks_persona_get_store ((FolksPersona*) _data_->self);
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _data_->web_service_addresses;
	_data_->_state_ = 1;
	_trf_persona_store_set_web_service_addrs (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp1_, TRF_TYPE_PERSONA_STORE, TrfPersonaStore), _data_->self, _data_->_tmp2_, trf_persona_change_web_service_addresses_ready, _data_);
	return FALSE;
	_state_1:
	_trf_persona_store_set_web_service_addrs_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp1_, TRF_TYPE_PERSONA_STORE, TrfPersonaStore), _data_->_res_);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


/**
   * Build a IID.
   *
   * @param store_id the {@link PersonaStore.id}
   * @param tracker_id the tracker id belonging to nco:PersonContact
   * @return a valid IID
   *
   * @since 0.5.0
   */
gchar* trf_persona_build_iid (const gchar* store_id, const gchar* tracker_id) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	g_return_val_if_fail (store_id != NULL, NULL);
	g_return_val_if_fail (tracker_id != NULL, NULL);
	_tmp0_ = store_id;
	_tmp1_ = tracker_id;
	_tmp2_ = g_strdup_printf ("%s:%s", _tmp0_, _tmp1_);
	result = _tmp2_;
	return result;
}


/**
   * Create a new persona.
   *
   * Create a new persona for the {@link PersonaStore} ``store``, representing
   * the nco:Contact whose details are stored in the cursor.
   */
TrfPersona* trf_persona_construct (GType object_type, TrfPersonaStore* store, const gchar* tracker_id, TrackerSparqlCursor* cursor) {
	TrfPersona * self = NULL;
	gchar* uid = NULL;
	TrfPersonaStore* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* iid = NULL;
	TrfPersonaStore* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gboolean is_user = FALSE;
	TrackerSparqlCursor* _tmp10_ = NULL;
	const gchar* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	const gchar* _tmp17_ = NULL;
	TrfPersonaStore* _tmp18_ = NULL;
	gboolean _tmp19_ = FALSE;
	const gchar* _tmp20_ = NULL;
	TrackerSparqlCursor* _tmp21_ = NULL;
	g_return_val_if_fail (store != NULL, NULL);
	g_return_val_if_fail (tracker_id != NULL, NULL);
	_tmp0_ = store;
	_tmp1_ = folks_persona_store_get_id ((FolksPersonaStore*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = tracker_id;
	_tmp4_ = folks_persona_build_uid (BACKEND_NAME, _tmp2_, _tmp3_);
	uid = _tmp4_;
	_tmp5_ = store;
	_tmp6_ = folks_persona_store_get_id ((FolksPersonaStore*) _tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = tracker_id;
	_tmp9_ = trf_persona_build_iid (_tmp7_, _tmp8_);
	iid = _tmp9_;
	is_user = FALSE;
	_tmp10_ = cursor;
	if (_tmp10_ != NULL) {
		gchar* contact_urn = NULL;
		TrackerSparqlCursor* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		_tmp11_ = cursor;
		_tmp12_ = tracker_sparql_cursor_get_string (_tmp11_, (gint) TRF_FIELDS_CONTACT_URN, NULL);
		_tmp13_ = g_strdup (_tmp12_);
		contact_urn = _tmp13_;
		_tmp14_ = contact_urn;
		if (g_strcmp0 (_tmp14_, TRF_ONTOLOGY_DEFS_DEFAULT_CONTACT_URN) == 0) {
			is_user = TRUE;
		}
		_g_free0 (contact_urn);
	}
	_tmp15_ = iid;
	_tmp16_ = uid;
	_tmp17_ = iid;
	_tmp18_ = store;
	_tmp19_ = is_user;
	_tmp20_ = tracker_id;
	_tmp21_ = cursor;
	self = (TrfPersona*) g_object_new (object_type, "display-id", _tmp15_, "uid", _tmp16_, "iid", _tmp17_, "store", _tmp18_, "is-user", _tmp19_, "tracker-id", _tmp20_, "cursor", _tmp21_, NULL);
	_g_free0 (iid);
	_g_free0 (uid);
	return self;
}


TrfPersona* trf_persona_new (TrfPersonaStore* store, const gchar* tracker_id, TrackerSparqlCursor* cursor) {
	return trf_persona_construct (TRF_TYPE_PERSONA, store, tracker_id, cursor);
}


/**
   * {@inheritDoc}
   */
static void trf_persona_real_linkable_property_to_links (FolksPersona* base, const gchar* prop_name, FolksPersonaLinkablePropertyCallback callback, void* callback_target) {
	TrfPersona * self;
	const gchar* _tmp0_ = NULL;
	self = (TrfPersona*) base;
	g_return_if_fail (prop_name != NULL);
	_tmp0_ = prop_name;
	if (g_strcmp0 (_tmp0_, "im-addresses") == 0) {
		{
			GeeIterator* _protocol_it = NULL;
			GeeHashMultiMap* _tmp1_ = NULL;
			GeeSet* _tmp2_ = NULL;
			GeeSet* _tmp3_ = NULL;
			GeeIterator* _tmp4_ = NULL;
			GeeIterator* _tmp5_ = NULL;
			_tmp1_ = self->priv->_im_addresses;
			_tmp2_ = gee_multi_map_get_keys ((GeeMultiMap*) _tmp1_);
			_tmp3_ = _tmp2_;
			_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
			_tmp5_ = _tmp4_;
			_g_object_unref0 (_tmp3_);
			_protocol_it = _tmp5_;
			while (TRUE) {
				GeeIterator* _tmp6_ = NULL;
				gboolean _tmp7_ = FALSE;
				gchar* protocol = NULL;
				GeeIterator* _tmp8_ = NULL;
				gpointer _tmp9_ = NULL;
				GeeCollection* im_fds = NULL;
				GeeHashMultiMap* _tmp10_ = NULL;
				const gchar* _tmp11_ = NULL;
				GeeCollection* _tmp12_ = NULL;
				_tmp6_ = _protocol_it;
				_tmp7_ = gee_iterator_next (_tmp6_);
				if (!_tmp7_) {
					break;
				}
				_tmp8_ = _protocol_it;
				_tmp9_ = gee_iterator_get (_tmp8_);
				protocol = (gchar*) _tmp9_;
				_tmp10_ = self->priv->_im_addresses;
				_tmp11_ = protocol;
				_tmp12_ = gee_multi_map_get ((GeeMultiMap*) _tmp10_, _tmp11_);
				im_fds = _tmp12_;
				{
					GeeIterator* _im_fd_it = NULL;
					GeeCollection* _tmp13_ = NULL;
					GeeIterator* _tmp14_ = NULL;
					_tmp13_ = im_fds;
					_tmp14_ = gee_iterable_iterator ((GeeIterable*) _tmp13_);
					_im_fd_it = _tmp14_;
					while (TRUE) {
						GeeIterator* _tmp15_ = NULL;
						gboolean _tmp16_ = FALSE;
						FolksImFieldDetails* im_fd = NULL;
						GeeIterator* _tmp17_ = NULL;
						gpointer _tmp18_ = NULL;
						FolksPersonaLinkablePropertyCallback _tmp19_ = NULL;
						void* _tmp19__target = NULL;
						const gchar* _tmp20_ = NULL;
						gchar* _tmp21_ = NULL;
						gchar* _tmp22_ = NULL;
						FolksImFieldDetails* _tmp23_ = NULL;
						gconstpointer _tmp24_ = NULL;
						const gchar* _tmp25_ = NULL;
						gchar* _tmp26_ = NULL;
						gchar* _tmp27_ = NULL;
						_tmp15_ = _im_fd_it;
						_tmp16_ = gee_iterator_next (_tmp15_);
						if (!_tmp16_) {
							break;
						}
						_tmp17_ = _im_fd_it;
						_tmp18_ = gee_iterator_get (_tmp17_);
						im_fd = (FolksImFieldDetails*) _tmp18_;
						_tmp19_ = callback;
						_tmp19__target = callback_target;
						_tmp20_ = protocol;
						_tmp21_ = g_strconcat (_tmp20_, ":", NULL);
						_tmp22_ = _tmp21_;
						_tmp23_ = im_fd;
						_tmp24_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp23_);
						_tmp25_ = _tmp24_;
						_tmp26_ = g_strconcat (_tmp22_, (const gchar*) _tmp25_, NULL);
						_tmp27_ = _tmp26_;
						_tmp19_ (_tmp27_, _tmp19__target);
						_g_free0 (_tmp27_);
						_g_free0 (_tmp22_);
						_g_object_unref0 (im_fd);
					}
					_g_object_unref0 (_im_fd_it);
				}
				_g_object_unref0 (im_fds);
				_g_free0 (protocol);
			}
			_g_object_unref0 (_protocol_it);
		}
	} else {
		const gchar* _tmp28_ = NULL;
		_tmp28_ = prop_name;
		if (g_strcmp0 (_tmp28_, "local-ids") == 0) {
			{
				GeeIterator* _id_it = NULL;
				GeeHashSet* _tmp29_ = NULL;
				GeeIterator* _tmp30_ = NULL;
				_tmp29_ = self->priv->_local_ids;
				_tmp30_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp29_);
				_id_it = _tmp30_;
				while (TRUE) {
					GeeIterator* _tmp31_ = NULL;
					gboolean _tmp32_ = FALSE;
					gchar* id = NULL;
					GeeIterator* _tmp33_ = NULL;
					gpointer _tmp34_ = NULL;
					FolksPersonaLinkablePropertyCallback _tmp35_ = NULL;
					void* _tmp35__target = NULL;
					const gchar* _tmp36_ = NULL;
					_tmp31_ = _id_it;
					_tmp32_ = gee_iterator_next (_tmp31_);
					if (!_tmp32_) {
						break;
					}
					_tmp33_ = _id_it;
					_tmp34_ = gee_iterator_get (_tmp33_);
					id = (gchar*) _tmp34_;
					_tmp35_ = callback;
					_tmp35__target = callback_target;
					_tmp36_ = id;
					_tmp35_ (_tmp36_, _tmp35__target);
					_g_free0 (id);
				}
				_g_object_unref0 (_id_it);
			}
		} else {
			const gchar* _tmp37_ = NULL;
			_tmp37_ = prop_name;
			if (g_strcmp0 (_tmp37_, "web-service-addresses") == 0) {
				{
					GeeIterator* _web_service_it = NULL;
					GeeHashMultiMap* _tmp38_ = NULL;
					GeeSet* _tmp39_ = NULL;
					GeeSet* _tmp40_ = NULL;
					GeeIterator* _tmp41_ = NULL;
					GeeIterator* _tmp42_ = NULL;
					_tmp38_ = self->priv->_web_service_addresses;
					_tmp39_ = gee_multi_map_get_keys ((GeeMultiMap*) _tmp38_);
					_tmp40_ = _tmp39_;
					_tmp41_ = gee_iterable_iterator ((GeeIterable*) _tmp40_);
					_tmp42_ = _tmp41_;
					_g_object_unref0 (_tmp40_);
					_web_service_it = _tmp42_;
					while (TRUE) {
						GeeIterator* _tmp43_ = NULL;
						gboolean _tmp44_ = FALSE;
						gchar* web_service = NULL;
						GeeIterator* _tmp45_ = NULL;
						gpointer _tmp46_ = NULL;
						GeeCollection* web_service_addresses = NULL;
						GeeHashMultiMap* _tmp47_ = NULL;
						const gchar* _tmp48_ = NULL;
						GeeCollection* _tmp49_ = NULL;
						_tmp43_ = _web_service_it;
						_tmp44_ = gee_iterator_next (_tmp43_);
						if (!_tmp44_) {
							break;
						}
						_tmp45_ = _web_service_it;
						_tmp46_ = gee_iterator_get (_tmp45_);
						web_service = (gchar*) _tmp46_;
						_tmp47_ = self->priv->_web_service_addresses;
						_tmp48_ = web_service;
						_tmp49_ = gee_multi_map_get ((GeeMultiMap*) _tmp47_, _tmp48_);
						web_service_addresses = _tmp49_;
						{
							GeeIterator* _ws_fd_it = NULL;
							GeeCollection* _tmp50_ = NULL;
							GeeIterator* _tmp51_ = NULL;
							_tmp50_ = web_service_addresses;
							_tmp51_ = gee_iterable_iterator ((GeeIterable*) _tmp50_);
							_ws_fd_it = _tmp51_;
							while (TRUE) {
								GeeIterator* _tmp52_ = NULL;
								gboolean _tmp53_ = FALSE;
								FolksWebServiceFieldDetails* ws_fd = NULL;
								GeeIterator* _tmp54_ = NULL;
								gpointer _tmp55_ = NULL;
								FolksPersonaLinkablePropertyCallback _tmp56_ = NULL;
								void* _tmp56__target = NULL;
								const gchar* _tmp57_ = NULL;
								gchar* _tmp58_ = NULL;
								gchar* _tmp59_ = NULL;
								FolksWebServiceFieldDetails* _tmp60_ = NULL;
								gconstpointer _tmp61_ = NULL;
								const gchar* _tmp62_ = NULL;
								gchar* _tmp63_ = NULL;
								gchar* _tmp64_ = NULL;
								_tmp52_ = _ws_fd_it;
								_tmp53_ = gee_iterator_next (_tmp52_);
								if (!_tmp53_) {
									break;
								}
								_tmp54_ = _ws_fd_it;
								_tmp55_ = gee_iterator_get (_tmp54_);
								ws_fd = (FolksWebServiceFieldDetails*) _tmp55_;
								_tmp56_ = callback;
								_tmp56__target = callback_target;
								_tmp57_ = web_service;
								_tmp58_ = g_strconcat (_tmp57_, ":", NULL);
								_tmp59_ = _tmp58_;
								_tmp60_ = ws_fd;
								_tmp61_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp60_);
								_tmp62_ = _tmp61_;
								_tmp63_ = g_strconcat (_tmp59_, (const gchar*) _tmp62_, NULL);
								_tmp64_ = _tmp63_;
								_tmp56_ (_tmp64_, _tmp56__target);
								_g_free0 (_tmp64_);
								_g_free0 (_tmp59_);
								_g_object_unref0 (ws_fd);
							}
							_g_object_unref0 (_ws_fd_it);
						}
						_g_object_unref0 (web_service_addresses);
						_g_free0 (web_service);
					}
					_g_object_unref0 (_web_service_it);
				}
			} else {
				const gchar* _tmp65_ = NULL;
				FolksPersonaLinkablePropertyCallback _tmp66_ = NULL;
				void* _tmp66__target = NULL;
				_tmp65_ = prop_name;
				_tmp66_ = callback;
				_tmp66__target = callback_target;
				FOLKS_PERSONA_CLASS (trf_persona_parent_class)->linkable_property_to_links (G_TYPE_CHECK_INSTANCE_CAST (self, FOLKS_TYPE_PERSONA, FolksPersona), _tmp65_, _tmp66_, _tmp66__target);
			}
		}
	}
}


void _trf_persona_update_full_name (TrfPersona* self, const gchar* fn) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = fn;
	if (_tmp0_ == NULL) {
		fn = "";
	}
	_tmp1_ = self->priv->_full_name;
	_tmp2_ = fn;
	if (g_strcmp0 (_tmp1_, _tmp2_) != 0) {
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		_tmp3_ = fn;
		_tmp4_ = g_strdup (_tmp3_);
		_g_free0 (self->priv->_full_name);
		self->priv->_full_name = _tmp4_;
		g_object_notify ((GObject*) self, "full-name");
	}
}


void _trf_persona_update_nickname (TrfPersona* self, const gchar* nickname) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = nickname;
	if (_tmp0_ == NULL) {
		nickname = "";
	}
	_tmp1_ = self->priv->_nickname;
	_tmp2_ = nickname;
	if (g_strcmp0 (_tmp1_, _tmp2_) != 0) {
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		_tmp3_ = nickname;
		_tmp4_ = g_strdup (_tmp3_);
		_g_free0 (self->priv->_nickname);
		self->priv->_nickname = _tmp4_;
		g_object_notify ((GObject*) self, "nickname");
	}
}


void _trf_persona_update_family_name (TrfPersona* self, const gchar* family_name) {
	const gchar* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = family_name;
	if (_tmp0_ != NULL) {
		FolksStructuredName* _tmp1_ = NULL;
		_tmp1_ = self->priv->_structured_name;
		if (_tmp1_ == NULL) {
			const gchar* _tmp2_ = NULL;
			FolksStructuredName* _tmp3_ = NULL;
			_tmp2_ = family_name;
			_tmp3_ = folks_structured_name_new (_tmp2_, NULL, NULL, NULL, NULL);
			_g_object_unref0 (self->priv->_structured_name);
			self->priv->_structured_name = _tmp3_;
		} else {
			FolksStructuredName* _tmp4_ = NULL;
			const gchar* _tmp5_ = NULL;
			_tmp4_ = self->priv->_structured_name;
			_tmp5_ = family_name;
			folks_structured_name_set_family_name (_tmp4_, _tmp5_);
		}
		g_object_notify ((GObject*) self, "structured-name");
	}
}


void _trf_persona_update_given_name (TrfPersona* self, const gchar* given_name) {
	const gchar* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = given_name;
	if (_tmp0_ != NULL) {
		FolksStructuredName* _tmp1_ = NULL;
		_tmp1_ = self->priv->_structured_name;
		if (_tmp1_ == NULL) {
			const gchar* _tmp2_ = NULL;
			FolksStructuredName* _tmp3_ = NULL;
			_tmp2_ = given_name;
			_tmp3_ = folks_structured_name_new (NULL, _tmp2_, NULL, NULL, NULL);
			_g_object_unref0 (self->priv->_structured_name);
			self->priv->_structured_name = _tmp3_;
		} else {
			FolksStructuredName* _tmp4_ = NULL;
			const gchar* _tmp5_ = NULL;
			_tmp4_ = self->priv->_structured_name;
			_tmp5_ = given_name;
			folks_structured_name_set_given_name (_tmp4_, _tmp5_);
		}
		g_object_notify ((GObject*) self, "structured-name");
	}
}


void _trf_persona_update_additional_names (TrfPersona* self, const gchar* additional_names) {
	const gchar* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = additional_names;
	if (_tmp0_ != NULL) {
		FolksStructuredName* _tmp1_ = NULL;
		_tmp1_ = self->priv->_structured_name;
		if (_tmp1_ == NULL) {
			const gchar* _tmp2_ = NULL;
			FolksStructuredName* _tmp3_ = NULL;
			_tmp2_ = additional_names;
			_tmp3_ = folks_structured_name_new (NULL, NULL, _tmp2_, NULL, NULL);
			_g_object_unref0 (self->priv->_structured_name);
			self->priv->_structured_name = _tmp3_;
		} else {
			FolksStructuredName* _tmp4_ = NULL;
			const gchar* _tmp5_ = NULL;
			_tmp4_ = self->priv->_structured_name;
			_tmp5_ = additional_names;
			folks_structured_name_set_additional_names (_tmp4_, _tmp5_);
		}
		g_object_notify ((GObject*) self, "structured-name");
	}
}


void _trf_persona_update_prefixes (TrfPersona* self, const gchar* prefixes) {
	const gchar* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = prefixes;
	if (_tmp0_ != NULL) {
		FolksStructuredName* _tmp1_ = NULL;
		_tmp1_ = self->priv->_structured_name;
		if (_tmp1_ == NULL) {
			const gchar* _tmp2_ = NULL;
			FolksStructuredName* _tmp3_ = NULL;
			_tmp2_ = prefixes;
			_tmp3_ = folks_structured_name_new (NULL, NULL, NULL, _tmp2_, NULL);
			_g_object_unref0 (self->priv->_structured_name);
			self->priv->_structured_name = _tmp3_;
		} else {
			FolksStructuredName* _tmp4_ = NULL;
			const gchar* _tmp5_ = NULL;
			_tmp4_ = self->priv->_structured_name;
			_tmp5_ = prefixes;
			folks_structured_name_set_prefixes (_tmp4_, _tmp5_);
		}
		g_object_notify ((GObject*) self, "structured-name");
	}
}


void _trf_persona_update_suffixes (TrfPersona* self, const gchar* suffixes) {
	const gchar* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = suffixes;
	if (_tmp0_ != NULL) {
		FolksStructuredName* _tmp1_ = NULL;
		_tmp1_ = self->priv->_structured_name;
		if (_tmp1_ == NULL) {
			const gchar* _tmp2_ = NULL;
			FolksStructuredName* _tmp3_ = NULL;
			_tmp2_ = suffixes;
			_tmp3_ = folks_structured_name_new (NULL, NULL, NULL, NULL, _tmp2_);
			_g_object_unref0 (self->priv->_structured_name);
			self->priv->_structured_name = _tmp3_;
		} else {
			FolksStructuredName* _tmp4_ = NULL;
			const gchar* _tmp5_ = NULL;
			_tmp4_ = self->priv->_structured_name;
			_tmp5_ = suffixes;
			folks_structured_name_set_suffixes (_tmp4_, _tmp5_);
		}
		g_object_notify ((GObject*) self, "structured-name");
	}
}


static void _trf_persona_update_postal_addresses (TrfPersona* self) {
	gchar* postal_field = NULL;
	TrackerSparqlCursor* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	FolksSmallSet* postal_addresses = NULL;
	FolksSmallSet* _tmp4_ = NULL;
	gchar** addresses_a = NULL;
	const gchar* _tmp5_ = NULL;
	gchar** _tmp6_ = NULL;
	gchar** _tmp7_ = NULL;
	gint addresses_a_length1 = 0;
	gint _addresses_a_size_ = 0;
	gchar** _tmp8_ = NULL;
	gint _tmp8__length1 = 0;
	FolksSmallSet* _tmp49_ = NULL;
	FolksSmallSet* _tmp50_ = NULL;
	FolksSmallSet* _tmp51_ = NULL;
	GeeSet* _tmp52_ = NULL;
	GeeSet* _tmp53_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_cursor;
	_tmp1_ = tracker_sparql_cursor_get_string (_tmp0_, (gint) TRF_FIELDS_POSTAL_ADDRESS, NULL);
	_tmp2_ = g_strdup (_tmp1_);
	postal_field = _tmp2_;
	_tmp3_ = postal_field;
	if (_tmp3_ == NULL) {
		_g_free0 (postal_field);
		return;
	}
	_tmp4_ = folks_small_set_new (FOLKS_TYPE_POSTAL_ADDRESS_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, _folks_abstract_field_details_hash_static_gee_hash_data_func, NULL, NULL, _folks_abstract_field_details_equal_static_gee_equal_data_func, NULL, NULL);
	postal_addresses = _tmp4_;
	_tmp5_ = postal_field;
	_tmp7_ = _tmp6_ = g_strsplit (_tmp5_, "\n", 0);
	addresses_a = _tmp7_;
	addresses_a_length1 = _vala_array_length (_tmp6_);
	_addresses_a_size_ = addresses_a_length1;
	_tmp8_ = addresses_a;
	_tmp8__length1 = addresses_a_length1;
	{
		gchar** a_collection = NULL;
		gint a_collection_length1 = 0;
		gint _a_collection_size_ = 0;
		gint a_it = 0;
		a_collection = _tmp8_;
		a_collection_length1 = _tmp8__length1;
		for (a_it = 0; a_it < _tmp8__length1; a_it = a_it + 1) {
			gchar* _tmp9_ = NULL;
			gchar* a = NULL;
			_tmp9_ = g_strdup (a_collection[a_it]);
			a = _tmp9_;
			{
				gboolean address_empty = FALSE;
				gchar** a_info = NULL;
				const gchar* _tmp10_ = NULL;
				gchar** _tmp11_ = NULL;
				gchar** _tmp12_ = NULL;
				gint a_info_length1 = 0;
				gint _a_info_size_ = 0;
				gboolean _tmp24_ = FALSE;
				FolksPostalAddress* pa = NULL;
				gchar** _tmp25_ = NULL;
				gint _tmp25__length1 = 0;
				const gchar* _tmp26_ = NULL;
				gchar** _tmp27_ = NULL;
				gint _tmp27__length1 = 0;
				const gchar* _tmp28_ = NULL;
				gchar** _tmp29_ = NULL;
				gint _tmp29__length1 = 0;
				const gchar* _tmp30_ = NULL;
				gchar** _tmp31_ = NULL;
				gint _tmp31__length1 = 0;
				const gchar* _tmp32_ = NULL;
				gchar** _tmp33_ = NULL;
				gint _tmp33__length1 = 0;
				const gchar* _tmp34_ = NULL;
				gchar** _tmp35_ = NULL;
				gint _tmp35__length1 = 0;
				const gchar* _tmp36_ = NULL;
				gchar** _tmp37_ = NULL;
				gint _tmp37__length1 = 0;
				const gchar* _tmp38_ = NULL;
				FolksPostalAddress* _tmp39_ = NULL;
				FolksPostalAddress* _tmp40_ = NULL;
				gboolean _tmp41_ = FALSE;
				address_empty = TRUE;
				_tmp10_ = a;
				_tmp12_ = _tmp11_ = g_strsplit (_tmp10_, "\t", 0);
				a_info = _tmp12_;
				a_info_length1 = _vala_array_length (_tmp11_);
				_a_info_size_ = a_info_length1;
				{
					gint i = 0;
					i = 0;
					{
						gboolean _tmp13_ = FALSE;
						_tmp13_ = TRUE;
						while (TRUE) {
							gint _tmp15_ = 0;
							gchar** _tmp16_ = NULL;
							gint _tmp16__length1 = 0;
							gboolean _tmp17_ = FALSE;
							gchar** _tmp18_ = NULL;
							gint _tmp18__length1 = 0;
							gint _tmp19_ = 0;
							const gchar* _tmp20_ = NULL;
							if (!_tmp13_) {
								gint _tmp14_ = 0;
								_tmp14_ = i;
								i = _tmp14_ + 1;
							}
							_tmp13_ = FALSE;
							_tmp15_ = i;
							_tmp16_ = a_info;
							_tmp16__length1 = a_info_length1;
							if (!(_tmp15_ < _tmp16__length1)) {
								break;
							}
							_tmp18_ = a_info;
							_tmp18__length1 = a_info_length1;
							_tmp19_ = i;
							_tmp20_ = _tmp18_[_tmp19_];
							if (_tmp20_ != NULL) {
								gchar** _tmp21_ = NULL;
								gint _tmp21__length1 = 0;
								gint _tmp22_ = 0;
								const gchar* _tmp23_ = NULL;
								_tmp21_ = a_info;
								_tmp21__length1 = a_info_length1;
								_tmp22_ = i;
								_tmp23_ = _tmp21_[_tmp22_];
								_tmp17_ = g_strcmp0 (_tmp23_, "") != 0;
							} else {
								_tmp17_ = FALSE;
							}
							if (_tmp17_) {
								address_empty = FALSE;
								break;
							}
						}
					}
				}
				_tmp24_ = address_empty;
				if (_tmp24_) {
					a_info = (_vala_array_free (a_info, a_info_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (a);
					continue;
				}
				_tmp25_ = a_info;
				_tmp25__length1 = a_info_length1;
				_tmp26_ = _tmp25_[TRF_POSTAL_ADDRESS_FIELDS_POBOX];
				_tmp27_ = a_info;
				_tmp27__length1 = a_info_length1;
				_tmp28_ = _tmp27_[TRF_POSTAL_ADDRESS_FIELDS_EXTENDED_ADDRESS];
				_tmp29_ = a_info;
				_tmp29__length1 = a_info_length1;
				_tmp30_ = _tmp29_[TRF_POSTAL_ADDRESS_FIELDS_STREET_ADDRESS];
				_tmp31_ = a_info;
				_tmp31__length1 = a_info_length1;
				_tmp32_ = _tmp31_[TRF_POSTAL_ADDRESS_FIELDS_LOCALITY];
				_tmp33_ = a_info;
				_tmp33__length1 = a_info_length1;
				_tmp34_ = _tmp33_[TRF_POSTAL_ADDRESS_FIELDS_REGION];
				_tmp35_ = a_info;
				_tmp35__length1 = a_info_length1;
				_tmp36_ = _tmp35_[TRF_POSTAL_ADDRESS_FIELDS_POSTALCODE];
				_tmp37_ = a_info;
				_tmp37__length1 = a_info_length1;
				_tmp38_ = _tmp37_[TRF_POSTAL_ADDRESS_FIELDS_COUNTRY];
				_tmp39_ = folks_postal_address_new (_tmp26_, _tmp28_, _tmp30_, _tmp32_, _tmp34_, _tmp36_, _tmp38_, NULL, NULL);
				pa = _tmp39_;
				_tmp40_ = pa;
				_tmp41_ = folks_postal_address_is_empty (_tmp40_);
				if (!_tmp41_) {
					FolksPostalAddressFieldDetails* pafd = NULL;
					FolksPostalAddress* _tmp42_ = NULL;
					FolksPostalAddressFieldDetails* _tmp43_ = NULL;
					FolksPostalAddressFieldDetails* _tmp44_ = NULL;
					gchar** _tmp45_ = NULL;
					gint _tmp45__length1 = 0;
					const gchar* _tmp46_ = NULL;
					FolksSmallSet* _tmp47_ = NULL;
					FolksPostalAddressFieldDetails* _tmp48_ = NULL;
					_tmp42_ = pa;
					_tmp43_ = folks_postal_address_field_details_new (_tmp42_, NULL);
					pafd = _tmp43_;
					_tmp44_ = pafd;
					_tmp45_ = a_info;
					_tmp45__length1 = a_info_length1;
					_tmp46_ = _tmp45_[TRF_POSTAL_ADDRESS_FIELDS_TRACKER_ID];
					folks_abstract_field_details_set_id ((FolksAbstractFieldDetails*) _tmp44_, _tmp46_);
					_tmp47_ = postal_addresses;
					_tmp48_ = pafd;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp47_, _tmp48_);
					_g_object_unref0 (pafd);
				}
				_g_object_unref0 (pa);
				a_info = (_vala_array_free (a_info, a_info_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (a);
			}
		}
	}
	_tmp49_ = postal_addresses;
	_tmp50_ = _g_object_ref0 (_tmp49_);
	_g_object_unref0 (self->priv->_postal_addresses);
	self->priv->_postal_addresses = _tmp50_;
	_tmp51_ = self->priv->_postal_addresses;
	_tmp52_ = gee_abstract_set_get_read_only_view ((GeeAbstractSet*) _tmp51_);
	_tmp53_ = _tmp52_;
	_g_object_unref0 (self->priv->_postal_addresses_ro);
	self->priv->_postal_addresses_ro = _tmp53_;
	g_object_notify ((GObject*) self, "postal-addresses");
	addresses_a = (_vala_array_free (addresses_a, addresses_a_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (postal_addresses);
	_g_free0 (postal_field);
}


static void _trf_persona_update_local_ids (TrfPersona* self) {
	gchar* local_ids = NULL;
	TrackerSparqlCursor* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_cursor;
	_tmp1_ = tracker_sparql_cursor_get_string (_tmp0_, (gint) TRF_FIELDS_LOCAL_IDS_PROPERTY, NULL);
	_tmp2_ = g_strdup (_tmp1_);
	local_ids = _tmp2_;
	_tmp3_ = local_ids;
	if (_tmp3_ == NULL) {
		_g_free0 (local_ids);
		return;
	}
	_tmp4_ = local_ids;
	_trf_persona_set_local_ids (self, _tmp4_);
	_g_free0 (local_ids);
}


gboolean _trf_persona_add_postal_address (TrfPersona* self, FolksPostalAddressFieldDetails* postal_address_fd) {
	gboolean result = FALSE;
	FolksSmallSet* _tmp19_ = NULL;
	FolksPostalAddressFieldDetails* _tmp20_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (postal_address_fd != NULL, FALSE);
	{
		FolksSmallSet* _pafd_cur_list = NULL;
		FolksSmallSet* _tmp0_ = NULL;
		FolksSmallSet* _tmp1_ = NULL;
		gint _pafd_cur_size = 0;
		FolksSmallSet* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _pafd_cur_index = 0;
		_tmp0_ = self->priv->_postal_addresses;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_pafd_cur_list = _tmp1_;
		_tmp2_ = _pafd_cur_list;
		_tmp3_ = gee_collection_get_size ((GeeCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_pafd_cur_size = _tmp4_;
		_pafd_cur_index = -1;
		while (TRUE) {
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			FolksPostalAddressFieldDetails* pafd_cur = NULL;
			FolksSmallSet* _tmp8_ = NULL;
			gint _tmp9_ = 0;
			gconstpointer _tmp10_ = NULL;
			FolksPostalAddressFieldDetails* _tmp11_ = NULL;
			FolksPostalAddressFieldDetails* _tmp12_ = NULL;
			gconstpointer _tmp13_ = NULL;
			FolksPostalAddress* _tmp14_ = NULL;
			FolksPostalAddressFieldDetails* _tmp15_ = NULL;
			gconstpointer _tmp16_ = NULL;
			FolksPostalAddress* _tmp17_ = NULL;
			gboolean _tmp18_ = FALSE;
			_tmp5_ = _pafd_cur_index;
			_pafd_cur_index = _tmp5_ + 1;
			_tmp6_ = _pafd_cur_index;
			_tmp7_ = _pafd_cur_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _pafd_cur_list;
			_tmp9_ = _pafd_cur_index;
			_tmp10_ = folks_small_set_get (_tmp8_, _tmp9_);
			_tmp11_ = _g_object_ref0 ((FolksPostalAddressFieldDetails*) _tmp10_);
			pafd_cur = _tmp11_;
			_tmp12_ = postal_address_fd;
			_tmp13_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = pafd_cur;
			_tmp16_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp15_);
			_tmp17_ = _tmp16_;
			_tmp18_ = folks_postal_address_equal ((FolksPostalAddress*) _tmp14_, (FolksPostalAddress*) _tmp17_);
			if (_tmp18_) {
				result = FALSE;
				_g_object_unref0 (pafd_cur);
				_g_object_unref0 (_pafd_cur_list);
				return result;
			}
			_g_object_unref0 (pafd_cur);
		}
		_g_object_unref0 (_pafd_cur_list);
	}
	_tmp19_ = self->priv->_postal_addresses;
	_tmp20_ = postal_address_fd;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp19_, _tmp20_);
	g_object_notify ((GObject*) self, "postal-addresses");
	result = TRUE;
	return result;
}


gboolean _trf_persona_remove_postal_address (TrfPersona* self, const gchar* tracker_id) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (tracker_id != NULL, FALSE);
	{
		FolksSmallSet* _pafd_list = NULL;
		FolksSmallSet* _tmp0_ = NULL;
		FolksSmallSet* _tmp1_ = NULL;
		gint _pafd_size = 0;
		FolksSmallSet* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _pafd_index = 0;
		_tmp0_ = self->priv->_postal_addresses;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_pafd_list = _tmp1_;
		_tmp2_ = _pafd_list;
		_tmp3_ = gee_collection_get_size ((GeeCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_pafd_size = _tmp4_;
		_pafd_index = -1;
		while (TRUE) {
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			FolksPostalAddressFieldDetails* pafd = NULL;
			FolksSmallSet* _tmp8_ = NULL;
			gint _tmp9_ = 0;
			gconstpointer _tmp10_ = NULL;
			FolksPostalAddressFieldDetails* _tmp11_ = NULL;
			FolksPostalAddressFieldDetails* _tmp12_ = NULL;
			const gchar* _tmp13_ = NULL;
			const gchar* _tmp14_ = NULL;
			const gchar* _tmp15_ = NULL;
			_tmp5_ = _pafd_index;
			_pafd_index = _tmp5_ + 1;
			_tmp6_ = _pafd_index;
			_tmp7_ = _pafd_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _pafd_list;
			_tmp9_ = _pafd_index;
			_tmp10_ = folks_small_set_get (_tmp8_, _tmp9_);
			_tmp11_ = _g_object_ref0 ((FolksPostalAddressFieldDetails*) _tmp10_);
			pafd = _tmp11_;
			_tmp12_ = pafd;
			_tmp13_ = folks_abstract_field_details_get_id ((FolksAbstractFieldDetails*) _tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = tracker_id;
			if (g_strcmp0 (_tmp14_, _tmp15_) == 0) {
				FolksSmallSet* _tmp16_ = NULL;
				FolksPostalAddressFieldDetails* _tmp17_ = NULL;
				_tmp16_ = self->priv->_postal_addresses;
				_tmp17_ = pafd;
				gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp16_, _tmp17_);
				g_object_notify ((GObject*) self, "postal-addresses");
				result = TRUE;
				_g_object_unref0 (pafd);
				_g_object_unref0 (_pafd_list);
				return result;
			}
			_g_object_unref0 (pafd);
		}
		_g_object_unref0 (_pafd_list);
	}
	result = FALSE;
	return result;
}


static void _trf_persona_update_gender (TrfPersona* self) {
	gchar* gender = NULL;
	TrackerSparqlCursor* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gint gender_id = 0;
	const gchar* _tmp3_ = NULL;
	gint _tmp6_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_cursor;
	_tmp1_ = tracker_sparql_cursor_get_string (_tmp0_, (gint) TRF_FIELDS_GENDER, NULL);
	_tmp2_ = g_strdup (_tmp1_);
	gender = _tmp2_;
	gender_id = 0;
	_tmp3_ = gender;
	if (_tmp3_ != NULL) {
		const gchar* _tmp4_ = NULL;
		gint _tmp5_ = 0;
		_tmp4_ = gender;
		_tmp5_ = atoi (_tmp4_);
		gender_id = _tmp5_;
	}
	_tmp6_ = gender_id;
	_trf_persona_set_gender (self, _tmp6_);
	_g_free0 (gender);
}


void _trf_persona_set_gender (TrfPersona* self, gint gender_id) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = gender_id;
	if (_tmp0_ == 0) {
		self->priv->_gender = FOLKS_GENDER_UNSPECIFIED;
	} else {
		TrfPersonaStore* trf_store = NULL;
		FolksPersonaStore* _tmp1_ = NULL;
		FolksPersonaStore* _tmp2_ = NULL;
		TrfPersonaStore* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		TrfPersonaStore* _tmp5_ = NULL;
		gint _tmp6_ = 0;
		_tmp1_ = folks_persona_get_store ((FolksPersona*) self);
		_tmp2_ = _tmp1_;
		_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TRF_TYPE_PERSONA_STORE, TrfPersonaStore));
		trf_store = _tmp3_;
		_tmp4_ = gender_id;
		_tmp5_ = trf_store;
		_tmp6_ = trf_persona_store_get_gender_male_id (_tmp5_);
		if (_tmp4_ == _tmp6_) {
			self->priv->_gender = FOLKS_GENDER_MALE;
		} else {
			gint _tmp7_ = 0;
			TrfPersonaStore* _tmp8_ = NULL;
			gint _tmp9_ = 0;
			_tmp7_ = gender_id;
			_tmp8_ = trf_store;
			_tmp9_ = trf_persona_store_get_gender_female_id (_tmp8_);
			if (_tmp7_ == _tmp9_) {
				self->priv->_gender = FOLKS_GENDER_FEMALE;
			}
		}
		_g_object_unref0 (trf_store);
	}
	g_object_notify ((GObject*) self, "gender");
}


static void _trf_persona_update_note (TrfPersona* self) {
	gchar* note = NULL;
	TrackerSparqlCursor* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_cursor;
	_tmp1_ = tracker_sparql_cursor_get_string (_tmp0_, (gint) TRF_FIELDS_NOTE, NULL);
	_tmp2_ = g_strdup (_tmp1_);
	note = _tmp2_;
	_trf_persona_set_note (self, note);
	_g_free0 (note);
}


void _trf_persona_set_note (TrfPersona* self, const gchar* note_content) {
	const gchar* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = note_content;
	if (_tmp0_ != NULL) {
		FolksNoteFieldDetails* note = NULL;
		const gchar* _tmp1_ = NULL;
		FolksNoteFieldDetails* _tmp2_ = NULL;
		FolksSmallSet* _tmp3_ = NULL;
		FolksNoteFieldDetails* _tmp4_ = NULL;
		FolksNoteFieldDetails* _tmp5_ = NULL;
		_tmp1_ = note_content;
		_tmp2_ = folks_note_field_details_new (_tmp1_, NULL, NULL);
		note = _tmp2_;
		_tmp3_ = self->priv->_notes;
		_tmp4_ = note;
		note = NULL;
		_tmp5_ = _tmp4_;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp3_, _tmp5_);
		_g_object_unref0 (_tmp5_);
		_g_object_unref0 (note);
	} else {
		FolksSmallSet* _tmp6_ = NULL;
		_tmp6_ = self->priv->_notes;
		gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp6_);
	}
	g_object_notify ((GObject*) self, "notes");
}


static void _trf_persona_update_bday (TrfPersona* self) {
	gchar* bday = NULL;
	TrackerSparqlCursor* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_cursor;
	_tmp1_ = tracker_sparql_cursor_get_string (_tmp0_, (gint) TRF_FIELDS_BIRTHDAY, NULL);
	_tmp2_ = g_strdup (_tmp1_);
	bday = _tmp2_;
	_trf_persona_set_birthday (self, bday);
	_g_free0 (bday);
}


void _trf_persona_set_birthday (TrfPersona* self, const gchar* birthday) {
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp1_ = birthday;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_ = NULL;
		_tmp2_ = birthday;
		_tmp0_ = g_strcmp0 (_tmp2_, "") != 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GTimeVal t = {0};
		const gchar* _tmp3_ = NULL;
		gboolean _tmp4_ = FALSE;
		g_get_current_time (&t);
		_tmp3_ = birthday;
		_tmp4_ = g_time_val_from_iso8601 (_tmp3_, &t);
		if (_tmp4_) {
			GTimeVal _tmp5_ = {0};
			GDateTime* _tmp6_ = NULL;
			_tmp5_ = t;
			_tmp6_ = g_date_time_new_from_timeval_utc (&_tmp5_);
			_g_date_time_unref0 (self->priv->_birthday);
			self->priv->_birthday = _tmp6_;
			g_object_notify ((GObject*) self, "birthday");
		}
	} else {
		GDateTime* _tmp7_ = NULL;
		_tmp7_ = self->priv->_birthday;
		if (_tmp7_ != NULL) {
			_g_date_time_unref0 (self->priv->_birthday);
			self->priv->_birthday = NULL;
			g_object_notify ((GObject*) self, "birthday");
		}
	}
}


static void _trf_persona_update_roles (TrfPersona* self) {
	gchar* roles_field = NULL;
	TrackerSparqlCursor* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	FolksSmallSet* role_fds = NULL;
	FolksSmallSet* _tmp4_ = NULL;
	gchar** roles_a = NULL;
	const gchar* _tmp5_ = NULL;
	gchar** _tmp6_ = NULL;
	gchar** _tmp7_ = NULL;
	gint roles_a_length1 = 0;
	gint _roles_a_size_ = 0;
	gchar** _tmp8_ = NULL;
	gint _tmp8__length1 = 0;
	FolksSmallSet* _tmp38_ = NULL;
	FolksSmallSet* _tmp39_ = NULL;
	FolksSmallSet* _tmp40_ = NULL;
	GeeSet* _tmp41_ = NULL;
	GeeSet* _tmp42_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_cursor;
	_tmp1_ = tracker_sparql_cursor_get_string (_tmp0_, (gint) TRF_FIELDS_ROLES, NULL);
	_tmp2_ = g_strdup (_tmp1_);
	roles_field = _tmp2_;
	_tmp3_ = roles_field;
	if (_tmp3_ == NULL) {
		_g_free0 (roles_field);
		return;
	}
	_tmp4_ = folks_small_set_new (FOLKS_TYPE_ROLE_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, _folks_abstract_field_details_hash_static_gee_hash_data_func, NULL, NULL, _folks_abstract_field_details_equal_static_gee_equal_data_func, NULL, NULL);
	role_fds = _tmp4_;
	_tmp5_ = roles_field;
	_tmp7_ = _tmp6_ = g_strsplit (_tmp5_, "\n", 0);
	roles_a = _tmp7_;
	roles_a_length1 = _vala_array_length (_tmp6_);
	_roles_a_size_ = roles_a_length1;
	_tmp8_ = roles_a;
	_tmp8__length1 = roles_a_length1;
	{
		gchar** r_collection = NULL;
		gint r_collection_length1 = 0;
		gint _r_collection_size_ = 0;
		gint r_it = 0;
		r_collection = _tmp8_;
		r_collection_length1 = _tmp8__length1;
		for (r_it = 0; r_it < _tmp8__length1; r_it = r_it + 1) {
			gchar* _tmp9_ = NULL;
			gchar* r = NULL;
			_tmp9_ = g_strdup (r_collection[r_it]);
			r = _tmp9_;
			{
				gchar** r_info = NULL;
				const gchar* _tmp10_ = NULL;
				gchar** _tmp11_ = NULL;
				gchar** _tmp12_ = NULL;
				gint r_info_length1 = 0;
				gint _r_info_size_ = 0;
				gchar* tracker_id = NULL;
				gchar** _tmp13_ = NULL;
				gint _tmp13__length1 = 0;
				const gchar* _tmp14_ = NULL;
				gchar* _tmp15_ = NULL;
				gchar* role = NULL;
				gchar** _tmp16_ = NULL;
				gint _tmp16__length1 = 0;
				const gchar* _tmp17_ = NULL;
				gchar* _tmp18_ = NULL;
				gchar* title = NULL;
				gchar** _tmp19_ = NULL;
				gint _tmp19__length1 = 0;
				const gchar* _tmp20_ = NULL;
				gchar* _tmp21_ = NULL;
				gchar* organisation = NULL;
				gchar** _tmp22_ = NULL;
				gint _tmp22__length1 = 0;
				const gchar* _tmp23_ = NULL;
				gchar* _tmp24_ = NULL;
				FolksRole* new_role = NULL;
				const gchar* _tmp25_ = NULL;
				const gchar* _tmp26_ = NULL;
				FolksRole* _tmp27_ = NULL;
				FolksRole* _tmp28_ = NULL;
				const gchar* _tmp29_ = NULL;
				FolksRole* _tmp30_ = NULL;
				gboolean _tmp31_ = FALSE;
				_tmp10_ = r;
				_tmp12_ = _tmp11_ = g_strsplit (_tmp10_, "\t", 0);
				r_info = _tmp12_;
				r_info_length1 = _vala_array_length (_tmp11_);
				_r_info_size_ = r_info_length1;
				_tmp13_ = r_info;
				_tmp13__length1 = r_info_length1;
				_tmp14_ = _tmp13_[TRF_ROLE_FIELDS_TRACKER_ID];
				_tmp15_ = g_strdup (_tmp14_);
				tracker_id = _tmp15_;
				_tmp16_ = r_info;
				_tmp16__length1 = r_info_length1;
				_tmp17_ = _tmp16_[TRF_ROLE_FIELDS_ROLE];
				_tmp18_ = g_strdup (_tmp17_);
				role = _tmp18_;
				_tmp19_ = r_info;
				_tmp19__length1 = r_info_length1;
				_tmp20_ = _tmp19_[TRF_ROLE_FIELDS_TITLE];
				_tmp21_ = g_strdup (_tmp20_);
				title = _tmp21_;
				_tmp22_ = r_info;
				_tmp22__length1 = r_info_length1;
				_tmp23_ = _tmp22_[TRF_ROLE_FIELDS_DEPARTMENT];
				_tmp24_ = g_strdup (_tmp23_);
				organisation = _tmp24_;
				_tmp25_ = title;
				_tmp26_ = organisation;
				_tmp27_ = folks_role_new (_tmp25_, _tmp26_, NULL);
				new_role = _tmp27_;
				_tmp28_ = new_role;
				_tmp29_ = role;
				folks_role_set_role (_tmp28_, _tmp29_);
				_tmp30_ = new_role;
				_tmp31_ = folks_role_is_empty (_tmp30_);
				if (!_tmp31_) {
					FolksRoleFieldDetails* role_fd = NULL;
					FolksRole* _tmp32_ = NULL;
					FolksRoleFieldDetails* _tmp33_ = NULL;
					FolksRoleFieldDetails* _tmp34_ = NULL;
					const gchar* _tmp35_ = NULL;
					FolksSmallSet* _tmp36_ = NULL;
					FolksRoleFieldDetails* _tmp37_ = NULL;
					_tmp32_ = new_role;
					_tmp33_ = folks_role_field_details_new (_tmp32_, NULL);
					role_fd = _tmp33_;
					_tmp34_ = role_fd;
					_tmp35_ = tracker_id;
					folks_abstract_field_details_set_id ((FolksAbstractFieldDetails*) _tmp34_, _tmp35_);
					_tmp36_ = role_fds;
					_tmp37_ = role_fd;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp36_, _tmp37_);
					_g_object_unref0 (role_fd);
				}
				_g_object_unref0 (new_role);
				_g_free0 (organisation);
				_g_free0 (title);
				_g_free0 (role);
				_g_free0 (tracker_id);
				r_info = (_vala_array_free (r_info, r_info_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (r);
			}
		}
	}
	_tmp38_ = role_fds;
	_tmp39_ = _g_object_ref0 (_tmp38_);
	_g_object_unref0 (self->priv->_roles);
	self->priv->_roles = _tmp39_;
	_tmp40_ = self->priv->_roles;
	_tmp41_ = gee_abstract_set_get_read_only_view ((GeeAbstractSet*) _tmp40_);
	_tmp42_ = _tmp41_;
	_g_object_unref0 (self->priv->_roles_ro);
	self->priv->_roles_ro = _tmp42_;
	g_object_notify ((GObject*) self, "roles");
	roles_a = (_vala_array_free (roles_a, roles_a_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (role_fds);
	_g_free0 (roles_field);
}


gboolean _trf_persona_add_role (TrfPersona* self, const gchar* tracker_id, const gchar* role, const gchar* title, const gchar* org) {
	gboolean result = FALSE;
	FolksRole* new_role = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	FolksRole* _tmp2_ = NULL;
	FolksRole* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	FolksRole* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (tracker_id != NULL, FALSE);
	_tmp0_ = title;
	_tmp1_ = org;
	_tmp2_ = folks_role_new (_tmp0_, _tmp1_, NULL);
	new_role = _tmp2_;
	_tmp3_ = new_role;
	_tmp4_ = role;
	folks_role_set_role (_tmp3_, _tmp4_);
	_tmp5_ = new_role;
	_tmp6_ = folks_role_is_empty (_tmp5_);
	if (!_tmp6_) {
		FolksRoleFieldDetails* role_fd = NULL;
		FolksRole* _tmp7_ = NULL;
		FolksRoleFieldDetails* _tmp8_ = NULL;
		FolksRoleFieldDetails* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		FolksSmallSet* _tmp11_ = NULL;
		FolksRoleFieldDetails* _tmp12_ = NULL;
		gboolean _tmp13_ = FALSE;
		_tmp7_ = new_role;
		_tmp8_ = folks_role_field_details_new (_tmp7_, NULL);
		role_fd = _tmp8_;
		_tmp9_ = role_fd;
		_tmp10_ = tracker_id;
		folks_abstract_field_details_set_id ((FolksAbstractFieldDetails*) _tmp9_, _tmp10_);
		_tmp11_ = self->priv->_roles;
		_tmp12_ = role_fd;
		_tmp13_ = gee_abstract_collection_add ((GeeAbstractCollection*) _tmp11_, _tmp12_);
		if (_tmp13_) {
			g_object_notify ((GObject*) self, "roles");
			result = TRUE;
			_g_object_unref0 (role_fd);
			_g_object_unref0 (new_role);
			return result;
		}
		_g_object_unref0 (role_fd);
	}
	result = FALSE;
	_g_object_unref0 (new_role);
	return result;
}


gboolean _trf_persona_remove_role (TrfPersona* self, const gchar* tracker_id) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (tracker_id != NULL, FALSE);
	{
		FolksSmallSet* _role_fd_list = NULL;
		FolksSmallSet* _tmp0_ = NULL;
		FolksSmallSet* _tmp1_ = NULL;
		gint _role_fd_size = 0;
		FolksSmallSet* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _role_fd_index = 0;
		_tmp0_ = self->priv->_roles;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_role_fd_list = _tmp1_;
		_tmp2_ = _role_fd_list;
		_tmp3_ = gee_collection_get_size ((GeeCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_role_fd_size = _tmp4_;
		_role_fd_index = -1;
		while (TRUE) {
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			FolksRoleFieldDetails* role_fd = NULL;
			FolksSmallSet* _tmp8_ = NULL;
			gint _tmp9_ = 0;
			gconstpointer _tmp10_ = NULL;
			FolksRoleFieldDetails* _tmp11_ = NULL;
			FolksRoleFieldDetails* _tmp12_ = NULL;
			const gchar* _tmp13_ = NULL;
			const gchar* _tmp14_ = NULL;
			const gchar* _tmp15_ = NULL;
			_tmp5_ = _role_fd_index;
			_role_fd_index = _tmp5_ + 1;
			_tmp6_ = _role_fd_index;
			_tmp7_ = _role_fd_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _role_fd_list;
			_tmp9_ = _role_fd_index;
			_tmp10_ = folks_small_set_get (_tmp8_, _tmp9_);
			_tmp11_ = _g_object_ref0 ((FolksRoleFieldDetails*) _tmp10_);
			role_fd = _tmp11_;
			_tmp12_ = role_fd;
			_tmp13_ = folks_abstract_field_details_get_id ((FolksAbstractFieldDetails*) _tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = tracker_id;
			if (g_strcmp0 (_tmp14_, _tmp15_) == 0) {
				FolksSmallSet* _tmp16_ = NULL;
				FolksRoleFieldDetails* _tmp17_ = NULL;
				_tmp16_ = self->priv->_roles;
				_tmp17_ = role_fd;
				gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp16_, _tmp17_);
				g_object_notify ((GObject*) self, "roles");
				result = TRUE;
				_g_object_unref0 (role_fd);
				_g_object_unref0 (_role_fd_list);
				return result;
			}
			_g_object_unref0 (role_fd);
		}
		_g_object_unref0 (_role_fd_list);
	}
	result = FALSE;
	return result;
}


static void _trf_persona_update_names (TrfPersona* self) {
	gchar* fullname = NULL;
	TrackerSparqlCursor* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* nickname = NULL;
	TrackerSparqlCursor* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* family_name = NULL;
	TrackerSparqlCursor* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* given_name = NULL;
	TrackerSparqlCursor* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* additional_names = NULL;
	TrackerSparqlCursor* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	gchar* prefixes = NULL;
	TrackerSparqlCursor* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	gchar* suffixes = NULL;
	TrackerSparqlCursor* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_cursor;
	_tmp1_ = tracker_sparql_cursor_get_string (_tmp0_, (gint) TRF_FIELDS_FULL_NAME, NULL);
	_tmp2_ = g_strdup (_tmp1_);
	fullname = _tmp2_;
	_trf_persona_update_full_name (self, fullname);
	_tmp3_ = self->priv->_cursor;
	_tmp4_ = tracker_sparql_cursor_get_string (_tmp3_, (gint) TRF_FIELDS_NICKNAME, NULL);
	_tmp5_ = g_strdup (_tmp4_);
	nickname = _tmp5_;
	_trf_persona_update_nickname (self, nickname);
	_tmp6_ = self->priv->_cursor;
	_tmp7_ = tracker_sparql_cursor_get_string (_tmp6_, (gint) TRF_FIELDS_FAMILY_NAME, NULL);
	_tmp8_ = g_strdup (_tmp7_);
	family_name = _tmp8_;
	_trf_persona_update_family_name (self, family_name);
	_tmp9_ = self->priv->_cursor;
	_tmp10_ = tracker_sparql_cursor_get_string (_tmp9_, (gint) TRF_FIELDS_GIVEN_NAME, NULL);
	_tmp11_ = g_strdup (_tmp10_);
	given_name = _tmp11_;
	_trf_persona_update_given_name (self, given_name);
	_tmp12_ = self->priv->_cursor;
	_tmp13_ = tracker_sparql_cursor_get_string (_tmp12_, (gint) TRF_FIELDS_ADDITIONAL_NAMES, NULL);
	_tmp14_ = g_strdup (_tmp13_);
	additional_names = _tmp14_;
	_trf_persona_update_additional_names (self, additional_names);
	_tmp15_ = self->priv->_cursor;
	_tmp16_ = tracker_sparql_cursor_get_string (_tmp15_, (gint) TRF_FIELDS_PREFIXES, NULL);
	_tmp17_ = g_strdup (_tmp16_);
	prefixes = _tmp17_;
	_trf_persona_update_prefixes (self, prefixes);
	_tmp18_ = self->priv->_cursor;
	_tmp19_ = tracker_sparql_cursor_get_string (_tmp18_, (gint) TRF_FIELDS_SUFFIXES, NULL);
	_tmp20_ = g_strdup (_tmp19_);
	suffixes = _tmp20_;
	_trf_persona_update_suffixes (self, suffixes);
	_g_free0 (suffixes);
	_g_free0 (prefixes);
	_g_free0 (additional_names);
	_g_free0 (given_name);
	_g_free0 (family_name);
	_g_free0 (nickname);
	_g_free0 (fullname);
}


static void _trf_persona_update_avatar (TrfPersona* self) {
	gchar* avatar_url = NULL;
	TrackerSparqlCursor* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_cursor;
	_tmp1_ = tracker_sparql_cursor_get_string (_tmp0_, (gint) TRF_FIELDS_AVATAR_URL, NULL);
	_tmp2_ = g_strdup (_tmp1_);
	avatar_url = _tmp2_;
	_trf_persona_set_avatar_from_uri (self, avatar_url);
	_g_free0 (avatar_url);
}


gboolean _trf_persona_set_avatar_from_uri (TrfPersona* self, const gchar* avatar_url) {
	gboolean result = FALSE;
	GLoadableIcon* _avatar = NULL;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
	GLoadableIcon* _tmp7_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_avatar = NULL;
	_tmp1_ = avatar_url;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_ = NULL;
		_tmp2_ = avatar_url;
		_tmp0_ = g_strcmp0 (_tmp2_, "") != 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		const gchar* _tmp3_ = NULL;
		GFile* _tmp4_ = NULL;
		GFile* _tmp5_ = NULL;
		GFileIcon* _tmp6_ = NULL;
		_tmp3_ = avatar_url;
		_tmp4_ = g_file_new_for_uri (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = (GFileIcon*) g_file_icon_new (_tmp5_);
		_g_object_unref0 (_avatar);
		_avatar = (GLoadableIcon*) _tmp6_;
		_g_object_unref0 (_tmp5_);
	}
	_tmp7_ = _avatar;
	_trf_persona_set_avatar (self, _tmp7_);
	result = TRUE;
	_g_object_unref0 (_avatar);
	return result;
}


gboolean _trf_persona_set_avatar (TrfPersona* self, GLoadableIcon* avatar) {
	gboolean result = FALSE;
	GLoadableIcon* _tmp0_ = NULL;
	GLoadableIcon* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = avatar;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_avatar);
	self->priv->_avatar = _tmp1_;
	g_object_notify ((GObject*) self, "avatar");
	result = TRUE;
	return result;
}


gboolean _trf_persona_set_local_ids (TrfPersona* self, const gchar* local_ids) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	GeeSet* _tmp1_ = NULL;
	GeeHashSet* _tmp2_ = NULL;
	GeeSet* _tmp3_ = NULL;
	GeeSet* _tmp4_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (local_ids != NULL, FALSE);
	_tmp0_ = local_ids;
	_tmp1_ = trf_persona_store_unserialize_local_ids (_tmp0_);
	_g_object_unref0 (self->priv->_local_ids);
	self->priv->_local_ids = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_HASH_SET, GeeHashSet);
	_tmp2_ = self->priv->_local_ids;
	_tmp3_ = gee_abstract_set_get_read_only_view ((GeeAbstractSet*) _tmp2_);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (self->priv->_local_ids_ro);
	self->priv->_local_ids_ro = _tmp4_;
	g_object_notify ((GObject*) self, "local-ids");
	result = TRUE;
	return result;
}


gboolean _trf_persona_set_web_service_addrs (TrfPersona* self, const gchar* ws_addrs) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	GeeMultiMap* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (ws_addrs != NULL, FALSE);
	_tmp0_ = ws_addrs;
	_tmp1_ = trf_persona_store_unserialize_web_services (_tmp0_);
	_g_object_unref0 (self->priv->_web_service_addresses);
	self->priv->_web_service_addresses = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_HASH_MULTI_MAP, GeeHashMultiMap);
	g_object_notify ((GObject*) self, "web-service-addresses");
	result = TRUE;
	return result;
}


static void _trf_persona_update_im_addresses (TrfPersona* self) {
	gchar* addresses = NULL;
	TrackerSparqlCursor* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	GeeHashMultiMap* _tmp4_ = NULL;
	gchar** addresses_a = NULL;
	const gchar* _tmp5_ = NULL;
	gchar** _tmp6_ = NULL;
	gchar** _tmp7_ = NULL;
	gint addresses_a_length1 = 0;
	gint _addresses_a_size_ = 0;
	gchar** _tmp8_ = NULL;
	gint _tmp8__length1 = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_cursor;
	_tmp1_ = tracker_sparql_cursor_get_string (_tmp0_, (gint) TRF_FIELDS_IM_ADDRESSES, NULL);
	_tmp2_ = g_strdup (_tmp1_);
	addresses = _tmp2_;
	_tmp3_ = addresses;
	if (_tmp3_ == NULL) {
		_g_free0 (addresses);
		return;
	}
	_tmp4_ = self->priv->_im_addresses;
	gee_multi_map_clear ((GeeMultiMap*) _tmp4_);
	_tmp5_ = addresses;
	_tmp7_ = _tmp6_ = g_strsplit (_tmp5_, "\n", 0);
	addresses_a = _tmp7_;
	addresses_a_length1 = _vala_array_length (_tmp6_);
	_addresses_a_size_ = addresses_a_length1;
	_tmp8_ = addresses_a;
	_tmp8__length1 = addresses_a_length1;
	{
		gchar** addr_collection = NULL;
		gint addr_collection_length1 = 0;
		gint _addr_collection_size_ = 0;
		gint addr_it = 0;
		addr_collection = _tmp8_;
		addr_collection_length1 = _tmp8__length1;
		for (addr_it = 0; addr_it < _tmp8__length1; addr_it = addr_it + 1) {
			gchar* _tmp9_ = NULL;
			gchar* addr = NULL;
			_tmp9_ = g_strdup (addr_collection[addr_it]);
			addr = _tmp9_;
			{
				gchar** addr_info = NULL;
				const gchar* _tmp10_ = NULL;
				gchar** _tmp11_ = NULL;
				gchar** _tmp12_ = NULL;
				gint addr_info_length1 = 0;
				gint _addr_info_size_ = 0;
				gchar* tracker_id = NULL;
				gchar** _tmp13_ = NULL;
				gint _tmp13__length1 = 0;
				const gchar* _tmp14_ = NULL;
				gchar* _tmp15_ = NULL;
				gchar* proto = NULL;
				gchar** _tmp16_ = NULL;
				gint _tmp16__length1 = 0;
				const gchar* _tmp17_ = NULL;
				gchar* _tmp18_ = NULL;
				gchar* account_id = NULL;
				gchar** _tmp19_ = NULL;
				gint _tmp19__length1 = 0;
				const gchar* _tmp20_ = NULL;
				gchar* _tmp21_ = NULL;
				gchar* nickname = NULL;
				gchar** _tmp22_ = NULL;
				gint _tmp22__length1 = 0;
				const gchar* _tmp23_ = NULL;
				gchar* _tmp24_ = NULL;
				const gchar* _tmp25_ = NULL;
				const gchar* _tmp27_ = NULL;
				const gchar* _tmp28_ = NULL;
				const gchar* _tmp29_ = NULL;
				const gchar* _tmp30_ = NULL;
				_tmp10_ = addr;
				_tmp12_ = _tmp11_ = g_strsplit (_tmp10_, "\t", 0);
				addr_info = _tmp12_;
				addr_info_length1 = _vala_array_length (_tmp11_);
				_addr_info_size_ = addr_info_length1;
				_tmp13_ = addr_info;
				_tmp13__length1 = addr_info_length1;
				_tmp14_ = _tmp13_[TRF_IM_FIELDS_TRACKER_ID];
				_tmp15_ = g_strdup (_tmp14_);
				tracker_id = _tmp15_;
				_tmp16_ = addr_info;
				_tmp16__length1 = addr_info_length1;
				_tmp17_ = _tmp16_[TRF_IM_FIELDS_PROTO];
				_tmp18_ = g_strdup (_tmp17_);
				proto = _tmp18_;
				_tmp19_ = addr_info;
				_tmp19__length1 = addr_info_length1;
				_tmp20_ = _tmp19_[TRF_IM_FIELDS_ID];
				_tmp21_ = g_strdup (_tmp20_);
				account_id = _tmp21_;
				_tmp22_ = addr_info;
				_tmp22__length1 = addr_info_length1;
				_tmp23_ = _tmp22_[TRF_IM_FIELDS_IM_NICKNAME];
				_tmp24_ = g_strdup (_tmp23_);
				nickname = _tmp24_;
				_tmp25_ = nickname;
				if (_tmp25_ == NULL) {
					gchar* _tmp26_ = NULL;
					_tmp26_ = g_strdup ("");
					_g_free0 (nickname);
					nickname = _tmp26_;
				}
				_tmp27_ = nickname;
				_trf_persona_update_nickname (self, _tmp27_);
				_tmp28_ = tracker_id;
				_tmp29_ = proto;
				_tmp30_ = account_id;
				_trf_persona_add_im_address (self, _tmp28_, _tmp29_, _tmp30_, FALSE);
				_g_free0 (nickname);
				_g_free0 (account_id);
				_g_free0 (proto);
				_g_free0 (tracker_id);
				addr_info = (_vala_array_free (addr_info, addr_info_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (addr);
			}
		}
	}
	g_object_notify ((GObject*) self, "im-addresses");
	addresses_a = (_vala_array_free (addresses_a, addresses_a_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (addresses);
}


gboolean _trf_persona_add_im_address (TrfPersona* self, const gchar* tracker_id, const gchar* im_proto, const gchar* account_id, gboolean notify) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (tracker_id != NULL, FALSE);
	g_return_val_if_fail (im_proto != NULL, FALSE);
	g_return_val_if_fail (account_id != NULL, FALSE);
	{
		gchar* normalised_addr = NULL;
		const gchar* _tmp0_ = NULL;
		const gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		FolksImFieldDetails* im_fd = NULL;
		FolksImFieldDetails* _tmp3_ = NULL;
		GeeHashMultiMap* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		FolksImFieldDetails* _tmp6_ = NULL;
		GeeHashMap* im_proto_map = NULL;
		GeeHashMap* _tmp7_ = NULL;
		GeeHashMap* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		GeeHashMap* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		GeeHashMap* _tmp13_ = NULL;
		gboolean _tmp14_ = FALSE;
		_tmp0_ = account_id;
		_tmp1_ = im_proto;
		_tmp2_ = folks_im_details_normalise_im_address (_tmp0_, _tmp1_, &_inner_error_);
		normalised_addr = _tmp2_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == FOLKS_IM_DETAILS_ERROR) {
				goto __catch0_folks_im_details_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		_tmp3_ = folks_im_field_details_new (normalised_addr, NULL);
		im_fd = _tmp3_;
		_tmp4_ = self->priv->_im_addresses;
		_tmp5_ = im_proto;
		_tmp6_ = im_fd;
		gee_multi_map_set ((GeeMultiMap*) _tmp4_, _tmp5_, _tmp6_);
		_tmp7_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
		im_proto_map = _tmp7_;
		_tmp8_ = im_proto_map;
		_tmp9_ = im_proto;
		_tmp10_ = account_id;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp8_, _tmp9_, _tmp10_);
		_tmp11_ = self->priv->_tracker_ids_ims;
		_tmp12_ = tracker_id;
		_tmp13_ = im_proto_map;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp11_, _tmp12_, _tmp13_);
		_tmp14_ = notify;
		if (_tmp14_) {
			g_object_notify ((GObject*) self, "im-addresses");
		}
		_g_object_unref0 (im_proto_map);
		_g_object_unref0 (im_fd);
		_g_free0 (normalised_addr);
	}
	goto __finally0;
	__catch0_folks_im_details_error:
	{
		GError* e = NULL;
		GError* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp15_ = e;
		_tmp16_ = _tmp15_->message;
		g_warning ("trf-persona.vala:1179: Problem when trying to normalise address: %s\n", _tmp16_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = TRUE;
	return result;
}


gboolean _trf_persona_remove_im_address (TrfPersona* self, const gchar* tracker_id, gboolean notify) {
	gboolean result = FALSE;
	GeeHashMap* proto_im = NULL;
	GeeHashMap* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gpointer _tmp2_ = NULL;
	GeeHashMap* _tmp3_ = NULL;
	gchar* proto = NULL;
	gchar* im_addr = NULL;
	FolksImFieldDetails* im_fd = NULL;
	const gchar* _tmp19_ = NULL;
	FolksImFieldDetails* _tmp20_ = NULL;
	gboolean _tmp21_ = FALSE;
	gboolean _tmp22_ = FALSE;
	const gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (tracker_id != NULL, FALSE);
	_tmp0_ = self->priv->_tracker_ids_ims;
	_tmp1_ = tracker_id;
	_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, _tmp1_);
	proto_im = (GeeHashMap*) _tmp2_;
	_tmp3_ = proto_im;
	if (_tmp3_ == NULL) {
		result = FALSE;
		_g_object_unref0 (proto_im);
		return result;
	}
	proto = NULL;
	im_addr = NULL;
	{
		GeeIterator* _pr_it = NULL;
		GeeHashMap* _tmp4_ = NULL;
		GeeSet* _tmp5_ = NULL;
		GeeSet* _tmp6_ = NULL;
		GeeSet* _tmp7_ = NULL;
		GeeIterator* _tmp8_ = NULL;
		GeeIterator* _tmp9_ = NULL;
		_tmp4_ = proto_im;
		_tmp5_ = gee_abstract_map_get_keys ((GeeMap*) _tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = _tmp6_;
		_tmp8_ = gee_iterable_iterator ((GeeIterable*) _tmp7_);
		_tmp9_ = _tmp8_;
		_g_object_unref0 (_tmp7_);
		_pr_it = _tmp9_;
		while (TRUE) {
			GeeIterator* _tmp10_ = NULL;
			gboolean _tmp11_ = FALSE;
			gchar* pr = NULL;
			GeeIterator* _tmp12_ = NULL;
			gpointer _tmp13_ = NULL;
			const gchar* _tmp14_ = NULL;
			gchar* _tmp15_ = NULL;
			GeeHashMap* _tmp16_ = NULL;
			const gchar* _tmp17_ = NULL;
			gpointer _tmp18_ = NULL;
			_tmp10_ = _pr_it;
			_tmp11_ = gee_iterator_next (_tmp10_);
			if (!_tmp11_) {
				break;
			}
			_tmp12_ = _pr_it;
			_tmp13_ = gee_iterator_get (_tmp12_);
			pr = (gchar*) _tmp13_;
			_tmp14_ = pr;
			_tmp15_ = g_strdup (_tmp14_);
			_g_free0 (proto);
			proto = _tmp15_;
			_tmp16_ = proto_im;
			_tmp17_ = proto;
			_tmp18_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp16_, _tmp17_);
			_g_free0 (im_addr);
			im_addr = (gchar*) _tmp18_;
			_g_free0 (pr);
			break;
		}
		_g_object_unref0 (_pr_it);
	}
	_tmp19_ = im_addr;
	_tmp20_ = folks_im_field_details_new (_tmp19_, NULL);
	im_fd = _tmp20_;
	_tmp23_ = proto;
	if (_tmp23_ != NULL) {
		const gchar* _tmp24_ = NULL;
		_tmp24_ = im_addr;
		_tmp22_ = _tmp24_ != NULL;
	} else {
		_tmp22_ = FALSE;
	}
	if (_tmp22_) {
		GeeHashMultiMap* _tmp25_ = NULL;
		const gchar* _tmp26_ = NULL;
		FolksImFieldDetails* _tmp27_ = NULL;
		gboolean _tmp28_ = FALSE;
		_tmp25_ = self->priv->_im_addresses;
		_tmp26_ = proto;
		_tmp27_ = im_fd;
		_tmp28_ = gee_multi_map_remove ((GeeMultiMap*) _tmp25_, _tmp26_, _tmp27_);
		_tmp21_ = _tmp28_;
	} else {
		_tmp21_ = FALSE;
	}
	if (_tmp21_) {
		GeeHashMap* _tmp29_ = NULL;
		const gchar* _tmp30_ = NULL;
		gboolean _tmp31_ = FALSE;
		_tmp29_ = self->priv->_tracker_ids_ims;
		_tmp30_ = tracker_id;
		gee_abstract_map_unset ((GeeAbstractMap*) _tmp29_, _tmp30_, NULL);
		_tmp31_ = notify;
		if (_tmp31_) {
			g_object_notify ((GObject*) self, "im-addresses");
		}
		result = TRUE;
		_g_object_unref0 (im_fd);
		_g_free0 (im_addr);
		_g_free0 (proto);
		_g_object_unref0 (proto_im);
		return result;
	}
	result = FALSE;
	_g_object_unref0 (im_fd);
	_g_free0 (im_addr);
	_g_free0 (proto);
	_g_object_unref0 (proto_im);
	return result;
}


static void _trf_persona_update_phones (TrfPersona* self) {
	gchar* phones_field = NULL;
	TrackerSparqlCursor* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	FolksSmallSet* phones = NULL;
	FolksSmallSet* _tmp4_ = NULL;
	gchar** phones_a = NULL;
	const gchar* _tmp5_ = NULL;
	gchar** _tmp6_ = NULL;
	gchar** _tmp7_ = NULL;
	gint phones_a_length1 = 0;
	gint _phones_a_size_ = 0;
	gchar** _tmp8_ = NULL;
	gint _tmp8__length1 = 0;
	FolksSmallSet* _tmp24_ = NULL;
	FolksSmallSet* _tmp25_ = NULL;
	FolksSmallSet* _tmp26_ = NULL;
	GeeSet* _tmp27_ = NULL;
	GeeSet* _tmp28_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_cursor;
	_tmp1_ = tracker_sparql_cursor_get_string (_tmp0_, (gint) TRF_FIELDS_PHONES, NULL);
	_tmp2_ = g_strdup (_tmp1_);
	phones_field = _tmp2_;
	_tmp3_ = phones_field;
	if (_tmp3_ == NULL) {
		_g_free0 (phones_field);
		return;
	}
	_tmp4_ = folks_small_set_new (FOLKS_TYPE_PHONE_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, _folks_abstract_field_details_hash_static_gee_hash_data_func, NULL, NULL, _folks_abstract_field_details_equal_static_gee_equal_data_func, NULL, NULL);
	phones = _tmp4_;
	_tmp5_ = phones_field;
	_tmp7_ = _tmp6_ = g_strsplit (_tmp5_, "\n", 0);
	phones_a = _tmp7_;
	phones_a_length1 = _vala_array_length (_tmp6_);
	_phones_a_size_ = phones_a_length1;
	_tmp8_ = phones_a;
	_tmp8__length1 = phones_a_length1;
	{
		gchar** p_collection = NULL;
		gint p_collection_length1 = 0;
		gint _p_collection_size_ = 0;
		gint p_it = 0;
		p_collection = _tmp8_;
		p_collection_length1 = _tmp8__length1;
		for (p_it = 0; p_it < _tmp8__length1; p_it = p_it + 1) {
			gchar* _tmp9_ = NULL;
			gchar* p = NULL;
			_tmp9_ = g_strdup (p_collection[p_it]);
			p = _tmp9_;
			{
				gboolean _tmp10_ = FALSE;
				const gchar* _tmp11_ = NULL;
				_tmp11_ = p;
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_ = NULL;
					_tmp12_ = p;
					_tmp10_ = g_strcmp0 (_tmp12_, "") != 0;
				} else {
					_tmp10_ = FALSE;
				}
				if (_tmp10_) {
					gchar** p_info = NULL;
					const gchar* _tmp13_ = NULL;
					gchar** _tmp14_ = NULL;
					gchar** _tmp15_ = NULL;
					gint p_info_length1 = 0;
					gint _p_info_size_ = 0;
					FolksPhoneFieldDetails* phone_fd = NULL;
					gchar** _tmp16_ = NULL;
					gint _tmp16__length1 = 0;
					const gchar* _tmp17_ = NULL;
					FolksPhoneFieldDetails* _tmp18_ = NULL;
					FolksPhoneFieldDetails* _tmp19_ = NULL;
					gchar** _tmp20_ = NULL;
					gint _tmp20__length1 = 0;
					const gchar* _tmp21_ = NULL;
					FolksSmallSet* _tmp22_ = NULL;
					FolksPhoneFieldDetails* _tmp23_ = NULL;
					_tmp13_ = p;
					_tmp15_ = _tmp14_ = g_strsplit (_tmp13_, "\t", 0);
					p_info = _tmp15_;
					p_info_length1 = _vala_array_length (_tmp14_);
					_p_info_size_ = p_info_length1;
					_tmp16_ = p_info;
					_tmp16__length1 = p_info_length1;
					_tmp17_ = _tmp16_[TRF_PHONE_FIELDS_PHONE];
					_tmp18_ = folks_phone_field_details_new (_tmp17_, NULL);
					phone_fd = _tmp18_;
					_tmp19_ = phone_fd;
					_tmp20_ = p_info;
					_tmp20__length1 = p_info_length1;
					_tmp21_ = _tmp20_[TRF_PHONE_FIELDS_TRACKER_ID];
					folks_abstract_field_details_set_id ((FolksAbstractFieldDetails*) _tmp19_, _tmp21_);
					_tmp22_ = phones;
					_tmp23_ = phone_fd;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp22_, _tmp23_);
					_g_object_unref0 (phone_fd);
					p_info = (_vala_array_free (p_info, p_info_length1, (GDestroyNotify) g_free), NULL);
				}
				_g_free0 (p);
			}
		}
	}
	_tmp24_ = phones;
	_tmp25_ = _g_object_ref0 (_tmp24_);
	_g_object_unref0 (self->priv->_phone_numbers);
	self->priv->_phone_numbers = _tmp25_;
	_tmp26_ = self->priv->_phone_numbers;
	_tmp27_ = gee_abstract_set_get_read_only_view ((GeeAbstractSet*) _tmp26_);
	_tmp28_ = _tmp27_;
	_g_object_unref0 (self->priv->_phone_numbers_ro);
	self->priv->_phone_numbers_ro = _tmp28_;
	g_object_notify ((GObject*) self, "phone-numbers");
	phones_a = (_vala_array_free (phones_a, phones_a_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (phones);
	_g_free0 (phones_field);
}


gboolean _trf_persona_add_phone (TrfPersona* self, const gchar* phone, const gchar* tracker_id) {
	gboolean result = FALSE;
	gboolean found = FALSE;
	gboolean _tmp16_ = FALSE;
	gboolean _tmp23_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (phone != NULL, FALSE);
	g_return_val_if_fail (tracker_id != NULL, FALSE);
	found = FALSE;
	{
		FolksSmallSet* _p_list = NULL;
		FolksSmallSet* _tmp0_ = NULL;
		FolksSmallSet* _tmp1_ = NULL;
		gint _p_size = 0;
		FolksSmallSet* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _p_index = 0;
		_tmp0_ = self->priv->_phone_numbers;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_p_list = _tmp1_;
		_tmp2_ = _p_list;
		_tmp3_ = gee_collection_get_size ((GeeCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_p_size = _tmp4_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			FolksPhoneFieldDetails* p = NULL;
			FolksSmallSet* _tmp8_ = NULL;
			gint _tmp9_ = 0;
			gconstpointer _tmp10_ = NULL;
			FolksPhoneFieldDetails* _tmp11_ = NULL;
			FolksPhoneFieldDetails* _tmp12_ = NULL;
			const gchar* _tmp13_ = NULL;
			const gchar* _tmp14_ = NULL;
			const gchar* _tmp15_ = NULL;
			_tmp5_ = _p_index;
			_p_index = _tmp5_ + 1;
			_tmp6_ = _p_index;
			_tmp7_ = _p_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _p_list;
			_tmp9_ = _p_index;
			_tmp10_ = folks_small_set_get (_tmp8_, _tmp9_);
			_tmp11_ = _g_object_ref0 ((FolksPhoneFieldDetails*) _tmp10_);
			p = _tmp11_;
			_tmp12_ = p;
			_tmp13_ = folks_abstract_field_details_get_id ((FolksAbstractFieldDetails*) _tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = tracker_id;
			if (g_strcmp0 (_tmp14_, _tmp15_) == 0) {
				found = TRUE;
				_g_object_unref0 (p);
				break;
			}
			_g_object_unref0 (p);
		}
		_g_object_unref0 (_p_list);
	}
	_tmp16_ = found;
	if (!_tmp16_) {
		FolksPhoneFieldDetails* phone_fd = NULL;
		const gchar* _tmp17_ = NULL;
		FolksPhoneFieldDetails* _tmp18_ = NULL;
		FolksPhoneFieldDetails* _tmp19_ = NULL;
		const gchar* _tmp20_ = NULL;
		FolksSmallSet* _tmp21_ = NULL;
		FolksPhoneFieldDetails* _tmp22_ = NULL;
		_tmp17_ = phone;
		_tmp18_ = folks_phone_field_details_new (_tmp17_, NULL);
		phone_fd = _tmp18_;
		_tmp19_ = phone_fd;
		_tmp20_ = tracker_id;
		folks_abstract_field_details_set_id ((FolksAbstractFieldDetails*) _tmp19_, _tmp20_);
		_tmp21_ = self->priv->_phone_numbers;
		_tmp22_ = phone_fd;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp21_, _tmp22_);
		g_object_notify ((GObject*) self, "phone-numbers");
		_g_object_unref0 (phone_fd);
	}
	_tmp23_ = found;
	result = !_tmp23_;
	return result;
}


gboolean _trf_persona_remove_phone (TrfPersona* self, const gchar* tracker_id) {
	gboolean result = FALSE;
	gboolean found = FALSE;
	gboolean _tmp18_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (tracker_id != NULL, FALSE);
	found = FALSE;
	{
		FolksSmallSet* _p_list = NULL;
		FolksSmallSet* _tmp0_ = NULL;
		FolksSmallSet* _tmp1_ = NULL;
		gint _p_size = 0;
		FolksSmallSet* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _p_index = 0;
		_tmp0_ = self->priv->_phone_numbers;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_p_list = _tmp1_;
		_tmp2_ = _p_list;
		_tmp3_ = gee_collection_get_size ((GeeCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_p_size = _tmp4_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			FolksPhoneFieldDetails* p = NULL;
			FolksSmallSet* _tmp8_ = NULL;
			gint _tmp9_ = 0;
			gconstpointer _tmp10_ = NULL;
			FolksPhoneFieldDetails* _tmp11_ = NULL;
			FolksPhoneFieldDetails* _tmp12_ = NULL;
			const gchar* _tmp13_ = NULL;
			const gchar* _tmp14_ = NULL;
			const gchar* _tmp15_ = NULL;
			_tmp5_ = _p_index;
			_p_index = _tmp5_ + 1;
			_tmp6_ = _p_index;
			_tmp7_ = _p_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _p_list;
			_tmp9_ = _p_index;
			_tmp10_ = folks_small_set_get (_tmp8_, _tmp9_);
			_tmp11_ = _g_object_ref0 ((FolksPhoneFieldDetails*) _tmp10_);
			p = _tmp11_;
			_tmp12_ = p;
			_tmp13_ = folks_abstract_field_details_get_id ((FolksAbstractFieldDetails*) _tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = tracker_id;
			if (g_strcmp0 (_tmp14_, _tmp15_) == 0) {
				FolksSmallSet* _tmp16_ = NULL;
				FolksPhoneFieldDetails* _tmp17_ = NULL;
				_tmp16_ = self->priv->_phone_numbers;
				_tmp17_ = p;
				gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp16_, _tmp17_);
				found = TRUE;
				_g_object_unref0 (p);
				break;
			}
			_g_object_unref0 (p);
		}
		_g_object_unref0 (_p_list);
	}
	_tmp18_ = found;
	if (_tmp18_) {
		g_object_notify ((GObject*) self, "phone-numbers");
	}
	result = found;
	return result;
}


gboolean _trf_persona_add_email (TrfPersona* self, const gchar* addr, const gchar* tracker_id) {
	gboolean result = FALSE;
	gboolean found = FALSE;
	gboolean _tmp18_ = FALSE;
	gboolean _tmp25_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (addr != NULL, FALSE);
	g_return_val_if_fail (tracker_id != NULL, FALSE);
	found = FALSE;
	{
		FolksSmallSet* _email_fd_list = NULL;
		FolksSmallSet* _tmp0_ = NULL;
		FolksSmallSet* _tmp1_ = NULL;
		gint _email_fd_size = 0;
		FolksSmallSet* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _email_fd_index = 0;
		_tmp0_ = self->priv->_email_addresses;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_email_fd_list = _tmp1_;
		_tmp2_ = _email_fd_list;
		_tmp3_ = gee_collection_get_size ((GeeCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_email_fd_size = _tmp4_;
		_email_fd_index = -1;
		while (TRUE) {
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			FolksEmailFieldDetails* email_fd = NULL;
			FolksSmallSet* _tmp8_ = NULL;
			gint _tmp9_ = 0;
			gconstpointer _tmp10_ = NULL;
			FolksEmailFieldDetails* _tmp11_ = NULL;
			FolksEmailFieldDetails* _tmp12_ = NULL;
			GeeCollection* _tmp13_ = NULL;
			GeeCollection* _tmp14_ = NULL;
			const gchar* _tmp15_ = NULL;
			gboolean _tmp16_ = FALSE;
			gboolean _tmp17_ = FALSE;
			_tmp5_ = _email_fd_index;
			_email_fd_index = _tmp5_ + 1;
			_tmp6_ = _email_fd_index;
			_tmp7_ = _email_fd_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _email_fd_list;
			_tmp9_ = _email_fd_index;
			_tmp10_ = folks_small_set_get (_tmp8_, _tmp9_);
			_tmp11_ = _g_object_ref0 ((FolksEmailFieldDetails*) _tmp10_);
			email_fd = _tmp11_;
			_tmp12_ = email_fd;
			_tmp13_ = folks_abstract_field_details_get_parameter_values ((FolksAbstractFieldDetails*) _tmp12_, "tracker_id");
			_tmp14_ = _tmp13_;
			_tmp15_ = tracker_id;
			_tmp16_ = gee_collection_contains (_tmp14_, _tmp15_);
			_tmp17_ = _tmp16_;
			_g_object_unref0 (_tmp14_);
			if (_tmp17_) {
				found = TRUE;
				_g_object_unref0 (email_fd);
				break;
			}
			_g_object_unref0 (email_fd);
		}
		_g_object_unref0 (_email_fd_list);
	}
	_tmp18_ = found;
	if (!_tmp18_) {
		FolksEmailFieldDetails* email_fd = NULL;
		const gchar* _tmp19_ = NULL;
		FolksEmailFieldDetails* _tmp20_ = NULL;
		FolksEmailFieldDetails* _tmp21_ = NULL;
		const gchar* _tmp22_ = NULL;
		FolksSmallSet* _tmp23_ = NULL;
		FolksEmailFieldDetails* _tmp24_ = NULL;
		_tmp19_ = addr;
		_tmp20_ = folks_email_field_details_new (_tmp19_, NULL);
		email_fd = _tmp20_;
		_tmp21_ = email_fd;
		_tmp22_ = tracker_id;
		folks_abstract_field_details_set_parameter ((FolksAbstractFieldDetails*) _tmp21_, "tracker_id", _tmp22_);
		_tmp23_ = self->priv->_email_addresses;
		_tmp24_ = email_fd;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp23_, _tmp24_);
		g_object_notify ((GObject*) self, "email-addresses");
		_g_object_unref0 (email_fd);
	}
	_tmp25_ = found;
	result = !_tmp25_;
	return result;
}


gboolean _trf_persona_remove_email (TrfPersona* self, const gchar* tracker_id) {
	gboolean result = FALSE;
	gboolean found = FALSE;
	gboolean _tmp20_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (tracker_id != NULL, FALSE);
	found = FALSE;
	{
		FolksSmallSet* _email_fd_list = NULL;
		FolksSmallSet* _tmp0_ = NULL;
		FolksSmallSet* _tmp1_ = NULL;
		gint _email_fd_size = 0;
		FolksSmallSet* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _email_fd_index = 0;
		_tmp0_ = self->priv->_email_addresses;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_email_fd_list = _tmp1_;
		_tmp2_ = _email_fd_list;
		_tmp3_ = gee_collection_get_size ((GeeCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_email_fd_size = _tmp4_;
		_email_fd_index = -1;
		while (TRUE) {
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			FolksEmailFieldDetails* email_fd = NULL;
			FolksSmallSet* _tmp8_ = NULL;
			gint _tmp9_ = 0;
			gconstpointer _tmp10_ = NULL;
			FolksEmailFieldDetails* _tmp11_ = NULL;
			FolksEmailFieldDetails* _tmp12_ = NULL;
			GeeCollection* _tmp13_ = NULL;
			GeeCollection* _tmp14_ = NULL;
			const gchar* _tmp15_ = NULL;
			gboolean _tmp16_ = FALSE;
			gboolean _tmp17_ = FALSE;
			_tmp5_ = _email_fd_index;
			_email_fd_index = _tmp5_ + 1;
			_tmp6_ = _email_fd_index;
			_tmp7_ = _email_fd_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _email_fd_list;
			_tmp9_ = _email_fd_index;
			_tmp10_ = folks_small_set_get (_tmp8_, _tmp9_);
			_tmp11_ = _g_object_ref0 ((FolksEmailFieldDetails*) _tmp10_);
			email_fd = _tmp11_;
			_tmp12_ = email_fd;
			_tmp13_ = folks_abstract_field_details_get_parameter_values ((FolksAbstractFieldDetails*) _tmp12_, "tracker_id");
			_tmp14_ = _tmp13_;
			_tmp15_ = tracker_id;
			_tmp16_ = gee_collection_contains (_tmp14_, _tmp15_);
			_tmp17_ = _tmp16_;
			_g_object_unref0 (_tmp14_);
			if (_tmp17_) {
				FolksSmallSet* _tmp18_ = NULL;
				FolksEmailFieldDetails* _tmp19_ = NULL;
				_tmp18_ = self->priv->_email_addresses;
				_tmp19_ = email_fd;
				gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp18_, _tmp19_);
				found = TRUE;
				_g_object_unref0 (email_fd);
				break;
			}
			_g_object_unref0 (email_fd);
		}
		_g_object_unref0 (_email_fd_list);
	}
	_tmp20_ = found;
	if (_tmp20_) {
		g_object_notify ((GObject*) self, "email-addresses");
	}
	result = found;
	return result;
}


static void _trf_persona_update_email_addresses (TrfPersona* self) {
	gchar* emails_field = NULL;
	TrackerSparqlCursor* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	FolksSmallSet* email_addresses = NULL;
	FolksSmallSet* _tmp4_ = NULL;
	gchar** emails_a = NULL;
	const gchar* _tmp5_ = NULL;
	gchar** _tmp6_ = NULL;
	gchar** _tmp7_ = NULL;
	gint emails_a_length1 = 0;
	gint _emails_a_size_ = 0;
	gchar** _tmp8_ = NULL;
	gint _tmp8__length1 = 0;
	FolksSmallSet* _tmp24_ = NULL;
	FolksSmallSet* _tmp25_ = NULL;
	FolksSmallSet* _tmp26_ = NULL;
	GeeSet* _tmp27_ = NULL;
	GeeSet* _tmp28_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_cursor;
	_tmp1_ = tracker_sparql_cursor_get_string (_tmp0_, (gint) TRF_FIELDS_EMAILS, NULL);
	_tmp2_ = g_strdup (_tmp1_);
	emails_field = _tmp2_;
	_tmp3_ = emails_field;
	if (_tmp3_ == NULL) {
		_g_free0 (emails_field);
		return;
	}
	_tmp4_ = folks_small_set_new (FOLKS_TYPE_EMAIL_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, _folks_abstract_field_details_hash_static_gee_hash_data_func, NULL, NULL, _folks_abstract_field_details_equal_static_gee_equal_data_func, NULL, NULL);
	email_addresses = _tmp4_;
	_tmp5_ = emails_field;
	_tmp7_ = _tmp6_ = g_strsplit (_tmp5_, ",", 0);
	emails_a = _tmp7_;
	emails_a_length1 = _vala_array_length (_tmp6_);
	_emails_a_size_ = emails_a_length1;
	_tmp8_ = emails_a;
	_tmp8__length1 = emails_a_length1;
	{
		gchar** e_collection = NULL;
		gint e_collection_length1 = 0;
		gint _e_collection_size_ = 0;
		gint e_it = 0;
		e_collection = _tmp8_;
		e_collection_length1 = _tmp8__length1;
		for (e_it = 0; e_it < _tmp8__length1; e_it = e_it + 1) {
			gchar* _tmp9_ = NULL;
			gchar* e = NULL;
			_tmp9_ = g_strdup (e_collection[e_it]);
			e = _tmp9_;
			{
				gboolean _tmp10_ = FALSE;
				const gchar* _tmp11_ = NULL;
				_tmp11_ = e;
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_ = NULL;
					_tmp12_ = e;
					_tmp10_ = g_strcmp0 (_tmp12_, "") != 0;
				} else {
					_tmp10_ = FALSE;
				}
				if (_tmp10_) {
					gchar** id_addr = NULL;
					const gchar* _tmp13_ = NULL;
					gchar** _tmp14_ = NULL;
					gchar** _tmp15_ = NULL;
					gint id_addr_length1 = 0;
					gint _id_addr_size_ = 0;
					FolksEmailFieldDetails* fd = NULL;
					gchar** _tmp16_ = NULL;
					gint _tmp16__length1 = 0;
					const gchar* _tmp17_ = NULL;
					FolksEmailFieldDetails* _tmp18_ = NULL;
					FolksEmailFieldDetails* _tmp19_ = NULL;
					gchar** _tmp20_ = NULL;
					gint _tmp20__length1 = 0;
					const gchar* _tmp21_ = NULL;
					FolksSmallSet* _tmp22_ = NULL;
					FolksEmailFieldDetails* _tmp23_ = NULL;
					_tmp13_ = e;
					_tmp15_ = _tmp14_ = g_strsplit (_tmp13_, "\t", 0);
					id_addr = _tmp15_;
					id_addr_length1 = _vala_array_length (_tmp14_);
					_id_addr_size_ = id_addr_length1;
					_tmp16_ = id_addr;
					_tmp16__length1 = id_addr_length1;
					_tmp17_ = _tmp16_[TRF_EMAIL_FIELDS_EMAIL];
					_tmp18_ = folks_email_field_details_new (_tmp17_, NULL);
					fd = _tmp18_;
					_tmp19_ = fd;
					_tmp20_ = id_addr;
					_tmp20__length1 = id_addr_length1;
					_tmp21_ = _tmp20_[TRF_EMAIL_FIELDS_TRACKER_ID];
					folks_abstract_field_details_set_parameter ((FolksAbstractFieldDetails*) _tmp19_, "tracker_id", _tmp21_);
					_tmp22_ = email_addresses;
					_tmp23_ = fd;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp22_, _tmp23_);
					_g_object_unref0 (fd);
					id_addr = (_vala_array_free (id_addr, id_addr_length1, (GDestroyNotify) g_free), NULL);
				}
				_g_free0 (e);
			}
		}
	}
	_tmp24_ = email_addresses;
	_tmp25_ = _g_object_ref0 (_tmp24_);
	_g_object_unref0 (self->priv->_email_addresses);
	self->priv->_email_addresses = _tmp25_;
	_tmp26_ = self->priv->_email_addresses;
	_tmp27_ = gee_abstract_set_get_read_only_view ((GeeAbstractSet*) _tmp26_);
	_tmp28_ = _tmp27_;
	_g_object_unref0 (self->priv->_email_addresses_ro);
	self->priv->_email_addresses_ro = _tmp28_;
	g_object_notify ((GObject*) self, "email-addresses");
	emails_a = (_vala_array_free (emails_a, emails_a_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (email_addresses);
	_g_free0 (emails_field);
}


static void _trf_persona_update_urls (TrfPersona* self) {
	FolksSmallSet* url_fds = NULL;
	FolksSmallSet* _tmp0_ = NULL;
	gchar* _urls_field = NULL;
	TrackerSparqlCursor* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar** urls_table = NULL;
	const gchar* _tmp5_ = NULL;
	gchar** _tmp6_ = NULL;
	gchar** _tmp7_ = NULL;
	gint urls_table_length1 = 0;
	gint _urls_table_size_ = 0;
	gchar** _tmp8_ = NULL;
	gint _tmp8__length1 = 0;
	FolksSmallSet* _tmp41_ = NULL;
	FolksSmallSet* _tmp42_ = NULL;
	FolksSmallSet* _tmp43_ = NULL;
	GeeSet* _tmp44_ = NULL;
	GeeSet* _tmp45_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = folks_small_set_new (FOLKS_TYPE_URL_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, _folks_abstract_field_details_hash_static_gee_hash_data_func, NULL, NULL, _folks_abstract_field_details_equal_static_gee_equal_data_func, NULL, NULL);
	url_fds = _tmp0_;
	_tmp1_ = self->priv->_cursor;
	_tmp2_ = tracker_sparql_cursor_get_string (_tmp1_, (gint) TRF_FIELDS_URLS, NULL);
	_tmp3_ = g_strdup (_tmp2_);
	_urls_field = _tmp3_;
	_tmp4_ = _urls_field;
	if (_tmp4_ == NULL) {
		_g_free0 (_urls_field);
		_g_object_unref0 (url_fds);
		return;
	}
	_tmp5_ = _urls_field;
	_tmp7_ = _tmp6_ = g_strsplit (_tmp5_, "\n", 0);
	urls_table = _tmp7_;
	urls_table_length1 = _vala_array_length (_tmp6_);
	_urls_table_size_ = urls_table_length1;
	_tmp8_ = urls_table;
	_tmp8__length1 = urls_table_length1;
	{
		gchar** row_collection = NULL;
		gint row_collection_length1 = 0;
		gint _row_collection_size_ = 0;
		gint row_it = 0;
		row_collection = _tmp8_;
		row_collection_length1 = _tmp8__length1;
		for (row_it = 0; row_it < _tmp8__length1; row_it = row_it + 1) {
			gchar* _tmp9_ = NULL;
			gchar* row = NULL;
			_tmp9_ = g_strdup (row_collection[row_it]);
			row = _tmp9_;
			{
				gchar** u = NULL;
				const gchar* _tmp10_ = NULL;
				gchar** _tmp11_ = NULL;
				gchar** _tmp12_ = NULL;
				gint u_length1 = 0;
				gint _u_size_ = 0;
				gchar* tracker_id = NULL;
				gchar** _tmp13_ = NULL;
				gint _tmp13__length1 = 0;
				const gchar* _tmp14_ = NULL;
				gchar* _tmp15_ = NULL;
				_tmp10_ = row;
				_tmp12_ = _tmp11_ = g_strsplit (_tmp10_, "\t", 0);
				u = _tmp12_;
				u_length1 = _vala_array_length (_tmp11_);
				_u_size_ = u_length1;
				_tmp13_ = u;
				_tmp13__length1 = u_length1;
				_tmp14_ = _tmp13_[TRF_URLS_FIELDS_TRACKER_ID];
				_tmp15_ = g_strdup (_tmp14_);
				tracker_id = _tmp15_;
				{
					gint i = 0;
					i = 1;
					{
						gboolean _tmp16_ = FALSE;
						_tmp16_ = TRUE;
						while (TRUE) {
							gint _tmp18_ = 0;
							gchar** _tmp19_ = NULL;
							gint _tmp19__length1 = 0;
							gboolean _tmp20_ = FALSE;
							gchar** _tmp21_ = NULL;
							gint _tmp21__length1 = 0;
							gint _tmp22_ = 0;
							const gchar* _tmp23_ = NULL;
							gchar* type = NULL;
							gint _tmp27_ = 0;
							FolksUrlFieldDetails* url_fd = NULL;
							gchar** _tmp30_ = NULL;
							gint _tmp30__length1 = 0;
							gint _tmp31_ = 0;
							const gchar* _tmp32_ = NULL;
							FolksUrlFieldDetails* _tmp33_ = NULL;
							FolksUrlFieldDetails* _tmp34_ = NULL;
							const gchar* _tmp35_ = NULL;
							const gchar* _tmp36_ = NULL;
							FolksSmallSet* _tmp39_ = NULL;
							FolksUrlFieldDetails* _tmp40_ = NULL;
							if (!_tmp16_) {
								gint _tmp17_ = 0;
								_tmp17_ = i;
								i = _tmp17_ + 1;
							}
							_tmp16_ = FALSE;
							_tmp18_ = i;
							_tmp19_ = u;
							_tmp19__length1 = u_length1;
							if (!(_tmp18_ < _tmp19__length1)) {
								break;
							}
							_tmp21_ = u;
							_tmp21__length1 = u_length1;
							_tmp22_ = i;
							_tmp23_ = _tmp21_[_tmp22_];
							if (_tmp23_ == NULL) {
								_tmp20_ = TRUE;
							} else {
								gchar** _tmp24_ = NULL;
								gint _tmp24__length1 = 0;
								gint _tmp25_ = 0;
								const gchar* _tmp26_ = NULL;
								_tmp24_ = u;
								_tmp24__length1 = u_length1;
								_tmp25_ = i;
								_tmp26_ = _tmp24_[_tmp25_];
								_tmp20_ = g_strcmp0 (_tmp26_, "") == 0;
							}
							if (_tmp20_) {
								continue;
							}
							type = NULL;
							_tmp27_ = i;
							switch (_tmp27_) {
								case TRF_URLS_FIELDS_BLOG:
								{
									gchar* _tmp28_ = NULL;
									_tmp28_ = g_strdup (FOLKS_URL_FIELD_DETAILS_PARAM_TYPE_BLOG);
									_g_free0 (type);
									type = _tmp28_;
									break;
								}
								case TRF_URLS_FIELDS_WEBSITE:
								{
									gchar* _tmp29_ = NULL;
									_tmp29_ = g_strdup (FOLKS_URL_FIELD_DETAILS_PARAM_TYPE_HOME_PAGE);
									_g_free0 (type);
									type = _tmp29_;
									break;
								}
								case TRF_URLS_FIELDS_URL:
								{
									break;
								}
								default:
								break;
							}
							_tmp30_ = u;
							_tmp30__length1 = u_length1;
							_tmp31_ = i;
							_tmp32_ = _tmp30_[_tmp31_];
							_tmp33_ = folks_url_field_details_new (_tmp32_, NULL);
							url_fd = _tmp33_;
							_tmp34_ = url_fd;
							_tmp35_ = tracker_id;
							folks_abstract_field_details_set_parameter ((FolksAbstractFieldDetails*) _tmp34_, "tracker_id", _tmp35_);
							_tmp36_ = type;
							if (_tmp36_ != NULL) {
								FolksUrlFieldDetails* _tmp37_ = NULL;
								const gchar* _tmp38_ = NULL;
								_tmp37_ = url_fd;
								_tmp38_ = type;
								folks_abstract_field_details_set_parameter ((FolksAbstractFieldDetails*) _tmp37_, FOLKS_ABSTRACT_FIELD_DETAILS_PARAM_TYPE, _tmp38_);
							}
							_tmp39_ = url_fds;
							_tmp40_ = url_fd;
							gee_abstract_collection_add ((GeeAbstractCollection*) _tmp39_, _tmp40_);
							_g_object_unref0 (url_fd);
							_g_free0 (type);
						}
					}
				}
				_g_free0 (tracker_id);
				u = (_vala_array_free (u, u_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (row);
			}
		}
	}
	_tmp41_ = url_fds;
	_tmp42_ = _g_object_ref0 (_tmp41_);
	_g_object_unref0 (self->priv->_urls);
	self->priv->_urls = _tmp42_;
	_tmp43_ = self->priv->_urls;
	_tmp44_ = gee_abstract_set_get_read_only_view ((GeeAbstractSet*) _tmp43_);
	_tmp45_ = _tmp44_;
	_g_object_unref0 (self->priv->_urls_ro);
	self->priv->_urls_ro = _tmp45_;
	g_object_notify ((GObject*) self, "urls");
	urls_table = (_vala_array_free (urls_table, urls_table_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (_urls_field);
	_g_object_unref0 (url_fds);
}


gboolean _trf_persona_add_url (TrfPersona* self, const gchar* url, const gchar* tracker_id, const gchar* type) {
	gboolean result = FALSE;
	gboolean found = FALSE;
	gboolean _tmp18_ = FALSE;
	gboolean _tmp28_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (url != NULL, FALSE);
	g_return_val_if_fail (tracker_id != NULL, FALSE);
	found = FALSE;
	{
		FolksSmallSet* _url_fd_list = NULL;
		FolksSmallSet* _tmp0_ = NULL;
		FolksSmallSet* _tmp1_ = NULL;
		gint _url_fd_size = 0;
		FolksSmallSet* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _url_fd_index = 0;
		_tmp0_ = self->priv->_urls;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_url_fd_list = _tmp1_;
		_tmp2_ = _url_fd_list;
		_tmp3_ = gee_collection_get_size ((GeeCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_url_fd_size = _tmp4_;
		_url_fd_index = -1;
		while (TRUE) {
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			FolksUrlFieldDetails* url_fd = NULL;
			FolksSmallSet* _tmp8_ = NULL;
			gint _tmp9_ = 0;
			gconstpointer _tmp10_ = NULL;
			FolksUrlFieldDetails* _tmp11_ = NULL;
			FolksUrlFieldDetails* _tmp12_ = NULL;
			GeeCollection* _tmp13_ = NULL;
			GeeCollection* _tmp14_ = NULL;
			const gchar* _tmp15_ = NULL;
			gboolean _tmp16_ = FALSE;
			gboolean _tmp17_ = FALSE;
			_tmp5_ = _url_fd_index;
			_url_fd_index = _tmp5_ + 1;
			_tmp6_ = _url_fd_index;
			_tmp7_ = _url_fd_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _url_fd_list;
			_tmp9_ = _url_fd_index;
			_tmp10_ = folks_small_set_get (_tmp8_, _tmp9_);
			_tmp11_ = _g_object_ref0 ((FolksUrlFieldDetails*) _tmp10_);
			url_fd = _tmp11_;
			_tmp12_ = url_fd;
			_tmp13_ = folks_abstract_field_details_get_parameter_values ((FolksAbstractFieldDetails*) _tmp12_, "tracker_id");
			_tmp14_ = _tmp13_;
			_tmp15_ = tracker_id;
			_tmp16_ = gee_collection_contains (_tmp14_, _tmp15_);
			_tmp17_ = _tmp16_;
			_g_object_unref0 (_tmp14_);
			if (_tmp17_) {
				found = TRUE;
				_g_object_unref0 (url_fd);
				break;
			}
			_g_object_unref0 (url_fd);
		}
		_g_object_unref0 (_url_fd_list);
	}
	_tmp18_ = found;
	if (!_tmp18_) {
		FolksUrlFieldDetails* url_fd = NULL;
		const gchar* _tmp19_ = NULL;
		FolksUrlFieldDetails* _tmp20_ = NULL;
		FolksUrlFieldDetails* _tmp21_ = NULL;
		const gchar* _tmp22_ = NULL;
		const gchar* _tmp23_ = NULL;
		FolksSmallSet* _tmp26_ = NULL;
		FolksUrlFieldDetails* _tmp27_ = NULL;
		_tmp19_ = url;
		_tmp20_ = folks_url_field_details_new (_tmp19_, NULL);
		url_fd = _tmp20_;
		_tmp21_ = url_fd;
		_tmp22_ = tracker_id;
		folks_abstract_field_details_set_parameter ((FolksAbstractFieldDetails*) _tmp21_, "tracker_id", _tmp22_);
		_tmp23_ = type;
		if (_tmp23_ != NULL) {
			FolksUrlFieldDetails* _tmp24_ = NULL;
			const gchar* _tmp25_ = NULL;
			_tmp24_ = url_fd;
			_tmp25_ = type;
			folks_abstract_field_details_set_parameter ((FolksAbstractFieldDetails*) _tmp24_, FOLKS_ABSTRACT_FIELD_DETAILS_PARAM_TYPE, _tmp25_);
		}
		_tmp26_ = self->priv->_urls;
		_tmp27_ = url_fd;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp26_, _tmp27_);
		g_object_notify ((GObject*) self, "urls");
		_g_object_unref0 (url_fd);
	}
	_tmp28_ = found;
	result = !_tmp28_;
	return result;
}


gboolean _trf_persona_remove_url (TrfPersona* self, const gchar* tracker_id) {
	gboolean result = FALSE;
	gboolean found = FALSE;
	gboolean _tmp20_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (tracker_id != NULL, FALSE);
	found = FALSE;
	{
		FolksSmallSet* _url_fd_list = NULL;
		FolksSmallSet* _tmp0_ = NULL;
		FolksSmallSet* _tmp1_ = NULL;
		gint _url_fd_size = 0;
		FolksSmallSet* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _url_fd_index = 0;
		_tmp0_ = self->priv->_urls;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_url_fd_list = _tmp1_;
		_tmp2_ = _url_fd_list;
		_tmp3_ = gee_collection_get_size ((GeeCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_url_fd_size = _tmp4_;
		_url_fd_index = -1;
		while (TRUE) {
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			FolksUrlFieldDetails* url_fd = NULL;
			FolksSmallSet* _tmp8_ = NULL;
			gint _tmp9_ = 0;
			gconstpointer _tmp10_ = NULL;
			FolksUrlFieldDetails* _tmp11_ = NULL;
			FolksUrlFieldDetails* _tmp12_ = NULL;
			GeeCollection* _tmp13_ = NULL;
			GeeCollection* _tmp14_ = NULL;
			const gchar* _tmp15_ = NULL;
			gboolean _tmp16_ = FALSE;
			gboolean _tmp17_ = FALSE;
			_tmp5_ = _url_fd_index;
			_url_fd_index = _tmp5_ + 1;
			_tmp6_ = _url_fd_index;
			_tmp7_ = _url_fd_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _url_fd_list;
			_tmp9_ = _url_fd_index;
			_tmp10_ = folks_small_set_get (_tmp8_, _tmp9_);
			_tmp11_ = _g_object_ref0 ((FolksUrlFieldDetails*) _tmp10_);
			url_fd = _tmp11_;
			_tmp12_ = url_fd;
			_tmp13_ = folks_abstract_field_details_get_parameter_values ((FolksAbstractFieldDetails*) _tmp12_, "tracker_id");
			_tmp14_ = _tmp13_;
			_tmp15_ = tracker_id;
			_tmp16_ = gee_collection_contains (_tmp14_, _tmp15_);
			_tmp17_ = _tmp16_;
			_g_object_unref0 (_tmp14_);
			if (_tmp17_) {
				FolksSmallSet* _tmp18_ = NULL;
				FolksUrlFieldDetails* _tmp19_ = NULL;
				_tmp18_ = self->priv->_urls;
				_tmp19_ = url_fd;
				gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp18_, _tmp19_);
				found = TRUE;
			}
			_g_object_unref0 (url_fd);
		}
		_g_object_unref0 (_url_fd_list);
	}
	_tmp20_ = found;
	if (_tmp20_) {
		g_object_notify ((GObject*) self, "urls");
	}
	result = found;
	return result;
}


static void _trf_persona_update_favourite (TrfPersona* self) {
	gchar* favourite = NULL;
	TrackerSparqlCursor* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gboolean is_favourite = FALSE;
	const gchar* _tmp3_ = NULL;
	gboolean _tmp16_ = FALSE;
	gboolean _tmp17_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_cursor;
	_tmp1_ = tracker_sparql_cursor_get_string (_tmp0_, (gint) TRF_FIELDS_FAVOURITE, NULL);
	_tmp2_ = g_strdup (_tmp1_);
	favourite = _tmp2_;
	is_favourite = FALSE;
	_tmp3_ = favourite;
	if (_tmp3_ != NULL) {
		TrfPersonaStore* trf_store = NULL;
		FolksPersonaStore* _tmp4_ = NULL;
		FolksPersonaStore* _tmp5_ = NULL;
		TrfPersonaStore* _tmp6_ = NULL;
		gint favorite_tracker_id = 0;
		TrfPersonaStore* _tmp7_ = NULL;
		gint _tmp8_ = 0;
		const gchar* _tmp9_ = NULL;
		gchar** _tmp10_ = NULL;
		gchar** _tmp11_ = NULL;
		_tmp4_ = folks_persona_get_store ((FolksPersona*) self);
		_tmp5_ = _tmp4_;
		_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, TRF_TYPE_PERSONA_STORE, TrfPersonaStore));
		trf_store = _tmp6_;
		_tmp7_ = trf_store;
		_tmp8_ = trf_persona_store_get_favorite_id (_tmp7_);
		favorite_tracker_id = _tmp8_;
		_tmp9_ = favourite;
		_tmp11_ = _tmp10_ = g_strsplit (_tmp9_, ",", 0);
		{
			gchar** tag_collection = NULL;
			gint tag_collection_length1 = 0;
			gint _tag_collection_size_ = 0;
			gint tag_it = 0;
			tag_collection = _tmp11_;
			tag_collection_length1 = _vala_array_length (_tmp10_);
			for (tag_it = 0; tag_it < _vala_array_length (_tmp10_); tag_it = tag_it + 1) {
				gchar* _tmp12_ = NULL;
				gchar* tag = NULL;
				_tmp12_ = g_strdup (tag_collection[tag_it]);
				tag = _tmp12_;
				{
					const gchar* _tmp13_ = NULL;
					gint _tmp14_ = 0;
					gint _tmp15_ = 0;
					_tmp13_ = tag;
					_tmp14_ = atoi (_tmp13_);
					_tmp15_ = favorite_tracker_id;
					if (_tmp14_ == _tmp15_) {
						is_favourite = TRUE;
					}
					_g_free0 (tag);
				}
			}
			tag_collection = (_vala_array_free (tag_collection, tag_collection_length1, (GDestroyNotify) g_free), NULL);
		}
		_g_object_unref0 (trf_store);
	}
	_tmp16_ = is_favourite;
	_tmp17_ = self->priv->_is_favourite;
	if (_tmp16_ != _tmp17_) {
		gboolean _tmp18_ = FALSE;
		_tmp18_ = is_favourite;
		self->priv->_is_favourite = _tmp18_;
		g_object_notify ((GObject*) self, "is-favourite");
	}
	_g_free0 (favourite);
}


/**
   * This method sets the is_favourite attribute internally.
   * That is, it should be used as a result of an event fired by
   * Tracker since this method doesn't propagate changes back
   * to Tracker again.
   */
void _trf_persona_set_favourite (TrfPersona* self, gboolean is_fav) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = is_fav;
	self->priv->_is_favourite = _tmp0_;
	g_object_notify ((GObject*) self, "is-favourite");
}


static const gchar* trf_persona_real_get_nickname (FolksNameDetails* base) {
	const gchar* result;
	TrfPersona* self;
	const gchar* _tmp0_ = NULL;
	self = (TrfPersona*) base;
	_tmp0_ = self->priv->_nickname;
	result = _tmp0_;
	return result;
}


static void trf_persona_real_set_nickname (FolksNameDetails* base, const gchar* value) {
	TrfPersona* self;
	const gchar* _tmp0_ = NULL;
	self = (TrfPersona*) base;
	_tmp0_ = value;
	folks_name_details_change_nickname ((FolksNameDetails*) self, _tmp0_, NULL, NULL);
}


static GeeSet* trf_persona_real_get_phone_numbers (FolksPhoneDetails* base) {
	GeeSet* result;
	TrfPersona* self;
	GeeSet* _tmp0_ = NULL;
	self = (TrfPersona*) base;
	_tmp0_ = self->priv->_phone_numbers_ro;
	result = _tmp0_;
	return result;
}


static void trf_persona_real_set_phone_numbers (FolksPhoneDetails* base, GeeSet* value) {
	TrfPersona* self;
	GeeSet* _tmp0_ = NULL;
	self = (TrfPersona*) base;
	_tmp0_ = value;
	folks_phone_details_change_phone_numbers ((FolksPhoneDetails*) self, _tmp0_, NULL, NULL);
}


static GeeSet* trf_persona_real_get_email_addresses (FolksEmailDetails* base) {
	GeeSet* result;
	TrfPersona* self;
	GeeSet* _tmp0_ = NULL;
	self = (TrfPersona*) base;
	_tmp0_ = self->priv->_email_addresses_ro;
	result = _tmp0_;
	return result;
}


static void trf_persona_real_set_email_addresses (FolksEmailDetails* base, GeeSet* value) {
	TrfPersona* self;
	GeeSet* _tmp0_ = NULL;
	self = (TrfPersona*) base;
	_tmp0_ = value;
	folks_email_details_change_email_addresses ((FolksEmailDetails*) self, _tmp0_, NULL, NULL);
}


static gchar** trf_persona_real_get_linkable_properties (FolksPersona* base, int* result_length1) {
	gchar** result;
	TrfPersona* self;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	self = (TrfPersona*) base;
	_tmp0_ = TRF_PERSONA__linkable_properties;
	_tmp0__length1 = G_N_ELEMENTS (TRF_PERSONA__linkable_properties);
	if (result_length1) {
		*result_length1 = _tmp0__length1;
	}
	result = _tmp0_;
	return result;
}


static gchar** trf_persona_real_get_writeable_properties (FolksPersona* base, int* result_length1) {
	gchar** result;
	TrfPersona* self;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	self = (TrfPersona*) base;
	_tmp0_ = TRF_PERSONA__writeable_properties;
	_tmp0__length1 = G_N_ELEMENTS (TRF_PERSONA__writeable_properties);
	if (result_length1) {
		*result_length1 = _tmp0__length1;
	}
	result = _tmp0_;
	return result;
}


static GLoadableIcon* trf_persona_real_get_avatar (FolksAvatarDetails* base) {
	GLoadableIcon* result;
	TrfPersona* self;
	GLoadableIcon* _tmp0_ = NULL;
	self = (TrfPersona*) base;
	_tmp0_ = self->priv->_avatar;
	result = _tmp0_;
	return result;
}


static void trf_persona_real_set_avatar (FolksAvatarDetails* base, GLoadableIcon* value) {
	TrfPersona* self;
	GLoadableIcon* _tmp0_ = NULL;
	self = (TrfPersona*) base;
	_tmp0_ = value;
	folks_avatar_details_change_avatar ((FolksAvatarDetails*) self, _tmp0_, NULL, NULL);
}


static FolksStructuredName* trf_persona_real_get_structured_name (FolksNameDetails* base) {
	FolksStructuredName* result;
	TrfPersona* self;
	FolksStructuredName* _tmp0_ = NULL;
	self = (TrfPersona*) base;
	_tmp0_ = self->priv->_structured_name;
	result = _tmp0_;
	return result;
}


static void trf_persona_real_set_structured_name (FolksNameDetails* base, FolksStructuredName* value) {
	TrfPersona* self;
	FolksStructuredName* _tmp0_ = NULL;
	self = (TrfPersona*) base;
	_tmp0_ = value;
	folks_name_details_change_structured_name ((FolksNameDetails*) self, _tmp0_, NULL, NULL);
}


static const gchar* trf_persona_real_get_full_name (FolksNameDetails* base) {
	const gchar* result;
	TrfPersona* self;
	const gchar* _tmp0_ = NULL;
	self = (TrfPersona*) base;
	_tmp0_ = self->priv->_full_name;
	result = _tmp0_;
	return result;
}


static void trf_persona_real_set_full_name (FolksNameDetails* base, const gchar* value) {
	TrfPersona* self;
	const gchar* _tmp0_ = NULL;
	self = (TrfPersona*) base;
	_tmp0_ = value;
	folks_name_details_change_full_name ((FolksNameDetails*) self, _tmp0_, NULL, NULL);
}


static FolksGender trf_persona_real_get_gender (FolksGenderDetails* base) {
	FolksGender result;
	TrfPersona* self;
	FolksGender _tmp0_ = 0;
	self = (TrfPersona*) base;
	_tmp0_ = self->priv->_gender;
	result = _tmp0_;
	return result;
}


static void trf_persona_real_set_gender (FolksGenderDetails* base, FolksGender value) {
	TrfPersona* self;
	FolksGender _tmp0_ = 0;
	self = (TrfPersona*) base;
	_tmp0_ = value;
	folks_gender_details_change_gender ((FolksGenderDetails*) self, _tmp0_, NULL, NULL);
}


static GDateTime* trf_persona_real_get_birthday (FolksBirthdayDetails* base) {
	GDateTime* result;
	TrfPersona* self;
	GDateTime* _tmp0_ = NULL;
	self = (TrfPersona*) base;
	_tmp0_ = self->priv->_birthday;
	result = _tmp0_;
	return result;
}


static void trf_persona_real_set_birthday (FolksBirthdayDetails* base, GDateTime* value) {
	TrfPersona* self;
	GDateTime* _tmp0_ = NULL;
	self = (TrfPersona*) base;
	_tmp0_ = value;
	folks_birthday_details_change_birthday ((FolksBirthdayDetails*) self, _tmp0_, NULL, NULL);
}


static const gchar* trf_persona_real_get_calendar_event_id (FolksBirthdayDetails* base) {
	const gchar* result;
	TrfPersona* self;
	self = (TrfPersona*) base;
	result = NULL;
	return result;
}


static void trf_persona_real_set_calendar_event_id (FolksBirthdayDetails* base, const gchar* value) {
	TrfPersona* self;
	const gchar* _tmp0_ = NULL;
	self = (TrfPersona*) base;
	_tmp0_ = value;
	folks_birthday_details_change_calendar_event_id ((FolksBirthdayDetails*) self, _tmp0_, NULL, NULL);
}


static GeeSet* trf_persona_real_get_roles (FolksRoleDetails* base) {
	GeeSet* result;
	TrfPersona* self;
	GeeSet* _tmp0_ = NULL;
	self = (TrfPersona*) base;
	_tmp0_ = self->priv->_roles_ro;
	result = _tmp0_;
	return result;
}


static void trf_persona_real_set_roles (FolksRoleDetails* base, GeeSet* value) {
	TrfPersona* self;
	GeeSet* _tmp0_ = NULL;
	self = (TrfPersona*) base;
	_tmp0_ = value;
	folks_role_details_change_roles ((FolksRoleDetails*) self, _tmp0_, NULL, NULL);
}


static GeeSet* trf_persona_real_get_notes (FolksNoteDetails* base) {
	GeeSet* result;
	TrfPersona* self;
	GeeSet* _tmp0_ = NULL;
	self = (TrfPersona*) base;
	_tmp0_ = self->priv->_notes_ro;
	result = _tmp0_;
	return result;
}


static void trf_persona_real_set_notes (FolksNoteDetails* base, GeeSet* value) {
	TrfPersona* self;
	GeeSet* _tmp0_ = NULL;
	self = (TrfPersona*) base;
	_tmp0_ = value;
	folks_note_details_change_notes ((FolksNoteDetails*) self, _tmp0_, NULL, NULL);
}


static GeeSet* trf_persona_real_get_urls (FolksUrlDetails* base) {
	GeeSet* result;
	TrfPersona* self;
	GeeSet* _tmp0_ = NULL;
	self = (TrfPersona*) base;
	_tmp0_ = self->priv->_urls_ro;
	result = _tmp0_;
	return result;
}


static void trf_persona_real_set_urls (FolksUrlDetails* base, GeeSet* value) {
	TrfPersona* self;
	GeeSet* _tmp0_ = NULL;
	self = (TrfPersona*) base;
	_tmp0_ = value;
	folks_url_details_change_urls ((FolksUrlDetails*) self, _tmp0_, NULL, NULL);
}


static GeeSet* trf_persona_real_get_postal_addresses (FolksPostalAddressDetails* base) {
	GeeSet* result;
	TrfPersona* self;
	GeeSet* _tmp0_ = NULL;
	self = (TrfPersona*) base;
	_tmp0_ = self->priv->_postal_addresses_ro;
	result = _tmp0_;
	return result;
}


static void trf_persona_real_set_postal_addresses (FolksPostalAddressDetails* base, GeeSet* value) {
	TrfPersona* self;
	GeeSet* _tmp0_ = NULL;
	self = (TrfPersona*) base;
	_tmp0_ = value;
	folks_postal_address_details_change_postal_addresses ((FolksPostalAddressDetails*) self, _tmp0_, NULL, NULL);
}


static GeeMultiMap* trf_persona_real_get_im_addresses (FolksImDetails* base) {
	GeeMultiMap* result;
	TrfPersona* self;
	GeeHashMultiMap* _tmp0_ = NULL;
	self = (TrfPersona*) base;
	_tmp0_ = self->priv->_im_addresses;
	result = (GeeMultiMap*) _tmp0_;
	return result;
}


static void trf_persona_real_set_im_addresses (FolksImDetails* base, GeeMultiMap* value) {
	TrfPersona* self;
	GeeMultiMap* _tmp0_ = NULL;
	self = (TrfPersona*) base;
	_tmp0_ = value;
	folks_im_details_change_im_addresses ((FolksImDetails*) self, _tmp0_, NULL, NULL);
}


static gboolean trf_persona_real_get_is_favourite (FolksFavouriteDetails* base) {
	gboolean result;
	TrfPersona* self;
	gboolean _tmp0_ = FALSE;
	self = (TrfPersona*) base;
	_tmp0_ = self->priv->_is_favourite;
	result = _tmp0_;
	return result;
}


static void trf_persona_real_set_is_favourite (FolksFavouriteDetails* base, gboolean value) {
	TrfPersona* self;
	gboolean _tmp0_ = FALSE;
	self = (TrfPersona*) base;
	_tmp0_ = value;
	folks_favourite_details_change_is_favourite ((FolksFavouriteDetails*) self, _tmp0_, NULL, NULL);
}


static GeeSet* trf_persona_real_get_local_ids (FolksLocalIdDetails* base) {
	GeeSet* result;
	TrfPersona* self;
	GeeHashSet* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	GeeSet* _tmp7_ = NULL;
	self = (TrfPersona*) base;
	_tmp0_ = self->priv->_local_ids;
	_tmp1_ = folks_persona_get_iid ((FolksPersona*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp0_, _tmp2_);
	if (_tmp3_ == FALSE) {
		GeeHashSet* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		_tmp4_ = self->priv->_local_ids;
		_tmp5_ = folks_persona_get_iid ((FolksPersona*) self);
		_tmp6_ = _tmp5_;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp4_, _tmp6_);
	}
	_tmp7_ = self->priv->_local_ids_ro;
	result = _tmp7_;
	return result;
}


static void trf_persona_real_set_local_ids (FolksLocalIdDetails* base, GeeSet* value) {
	TrfPersona* self;
	GeeSet* _tmp0_ = NULL;
	self = (TrfPersona*) base;
	_tmp0_ = value;
	folks_local_id_details_change_local_ids ((FolksLocalIdDetails*) self, _tmp0_, NULL, NULL);
}


static GeeMultiMap* trf_persona_real_get_web_service_addresses (FolksWebServiceDetails* base) {
	GeeMultiMap* result;
	TrfPersona* self;
	GeeHashMultiMap* _tmp0_ = NULL;
	self = (TrfPersona*) base;
	_tmp0_ = self->priv->_web_service_addresses;
	result = (GeeMultiMap*) _tmp0_;
	return result;
}


static void trf_persona_real_set_web_service_addresses (FolksWebServiceDetails* base, GeeMultiMap* value) {
	TrfPersona* self;
	GeeMultiMap* _tmp0_ = NULL;
	self = (TrfPersona*) base;
	_tmp0_ = value;
	folks_web_service_details_change_web_service_addresses ((FolksWebServiceDetails*) self, _tmp0_, NULL, NULL);
}


const gchar* trf_persona_get_tracker_id (TrfPersona* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_tracker_id;
	result = _tmp0_;
	return result;
}


static void trf_persona_set_tracker_id (TrfPersona* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_tracker_id);
	self->priv->_tracker_id = _tmp1_;
	g_object_notify ((GObject *) self, "tracker-id");
}


TrackerSparqlCursor* trf_persona_get_cursor (TrfPersona* self) {
	TrackerSparqlCursor* result;
	TrackerSparqlCursor* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_cursor;
	result = _tmp0_;
	return result;
}


static void trf_persona_set_cursor (TrfPersona* self, TrackerSparqlCursor* value) {
	TrackerSparqlCursor* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_cursor = _tmp0_;
	g_object_notify ((GObject *) self, "cursor");
}


static GObject * trf_persona_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	TrfPersona * self;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	FolksSmallSet* _tmp4_ = NULL;
	FolksSmallSet* _tmp5_ = NULL;
	GeeSet* _tmp6_ = NULL;
	GeeSet* _tmp7_ = NULL;
	FolksSmallSet* _tmp8_ = NULL;
	FolksSmallSet* _tmp9_ = NULL;
	GeeSet* _tmp10_ = NULL;
	GeeSet* _tmp11_ = NULL;
	FolksSmallSet* _tmp12_ = NULL;
	FolksSmallSet* _tmp13_ = NULL;
	GeeSet* _tmp14_ = NULL;
	GeeSet* _tmp15_ = NULL;
	FolksSmallSet* _tmp16_ = NULL;
	FolksSmallSet* _tmp17_ = NULL;
	GeeSet* _tmp18_ = NULL;
	GeeSet* _tmp19_ = NULL;
	FolksSmallSet* _tmp20_ = NULL;
	FolksSmallSet* _tmp21_ = NULL;
	GeeSet* _tmp22_ = NULL;
	GeeSet* _tmp23_ = NULL;
	FolksSmallSet* _tmp24_ = NULL;
	FolksSmallSet* _tmp25_ = NULL;
	GeeSet* _tmp26_ = NULL;
	GeeSet* _tmp27_ = NULL;
	GeeHashSet* _tmp28_ = NULL;
	GeeHashSet* _tmp29_ = NULL;
	GeeSet* _tmp30_ = NULL;
	GeeSet* _tmp31_ = NULL;
	TrackerSparqlCursor* _tmp32_ = NULL;
	parent_class = G_OBJECT_CLASS (trf_persona_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRF_TYPE_PERSONA, TrfPersona);
	_tmp0_ = folks_persona_get_iid ((FolksPersona*) self);
	_tmp1_ = _tmp0_;
	g_debug ("trf-persona.vala:555: Creating new Trf.Persona with iid '%s'", _tmp1_);
	self->priv->_gender = FOLKS_GENDER_UNSPECIFIED;
	_tmp2_ = g_strdup ("");
	_g_free0 (self->priv->_full_name);
	self->priv->_full_name = _tmp2_;
	_g_object_unref0 (self->priv->_structured_name);
	self->priv->_structured_name = NULL;
	_tmp3_ = g_strdup ("");
	_g_free0 (self->priv->_nickname);
	self->priv->_nickname = _tmp3_;
	self->priv->_is_favourite = FALSE;
	_tmp4_ = folks_small_set_new (FOLKS_TYPE_PHONE_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, _folks_abstract_field_details_hash_static_gee_hash_data_func, NULL, NULL, _folks_abstract_field_details_equal_static_gee_equal_data_func, NULL, NULL);
	_g_object_unref0 (self->priv->_phone_numbers);
	self->priv->_phone_numbers = _tmp4_;
	_tmp5_ = self->priv->_phone_numbers;
	_tmp6_ = gee_abstract_set_get_read_only_view ((GeeAbstractSet*) _tmp5_);
	_tmp7_ = _tmp6_;
	_g_object_unref0 (self->priv->_phone_numbers_ro);
	self->priv->_phone_numbers_ro = _tmp7_;
	_tmp8_ = folks_small_set_new (FOLKS_TYPE_EMAIL_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, _folks_abstract_field_details_hash_static_gee_hash_data_func, NULL, NULL, _folks_abstract_field_details_equal_static_gee_equal_data_func, NULL, NULL);
	_g_object_unref0 (self->priv->_email_addresses);
	self->priv->_email_addresses = _tmp8_;
	_tmp9_ = self->priv->_email_addresses;
	_tmp10_ = gee_abstract_set_get_read_only_view ((GeeAbstractSet*) _tmp9_);
	_tmp11_ = _tmp10_;
	_g_object_unref0 (self->priv->_email_addresses_ro);
	self->priv->_email_addresses_ro = _tmp11_;
	_tmp12_ = folks_small_set_new (FOLKS_TYPE_ROLE_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, _folks_abstract_field_details_hash_static_gee_hash_data_func, NULL, NULL, _folks_abstract_field_details_equal_static_gee_equal_data_func, NULL, NULL);
	_g_object_unref0 (self->priv->_roles);
	self->priv->_roles = _tmp12_;
	_tmp13_ = self->priv->_roles;
	_tmp14_ = gee_abstract_set_get_read_only_view ((GeeAbstractSet*) _tmp13_);
	_tmp15_ = _tmp14_;
	_g_object_unref0 (self->priv->_roles_ro);
	self->priv->_roles_ro = _tmp15_;
	_tmp16_ = folks_small_set_new (FOLKS_TYPE_NOTE_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, _folks_abstract_field_details_hash_static_gee_hash_data_func, NULL, NULL, _folks_abstract_field_details_equal_static_gee_equal_data_func, NULL, NULL);
	_g_object_unref0 (self->priv->_notes);
	self->priv->_notes = _tmp16_;
	_tmp17_ = self->priv->_notes;
	_tmp18_ = gee_abstract_set_get_read_only_view ((GeeAbstractSet*) _tmp17_);
	_tmp19_ = _tmp18_;
	_g_object_unref0 (self->priv->_notes_ro);
	self->priv->_notes_ro = _tmp19_;
	_tmp20_ = folks_small_set_new (FOLKS_TYPE_URL_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, _folks_abstract_field_details_hash_static_gee_hash_data_func, NULL, NULL, _folks_abstract_field_details_equal_static_gee_equal_data_func, NULL, NULL);
	_g_object_unref0 (self->priv->_urls);
	self->priv->_urls = _tmp20_;
	_tmp21_ = self->priv->_urls;
	_tmp22_ = gee_abstract_set_get_read_only_view ((GeeAbstractSet*) _tmp21_);
	_tmp23_ = _tmp22_;
	_g_object_unref0 (self->priv->_urls_ro);
	self->priv->_urls_ro = _tmp23_;
	_tmp24_ = folks_small_set_new (FOLKS_TYPE_POSTAL_ADDRESS_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, _folks_abstract_field_details_hash_static_gee_hash_data_func, NULL, NULL, _folks_abstract_field_details_equal_static_gee_equal_data_func, NULL, NULL);
	_g_object_unref0 (self->priv->_postal_addresses);
	self->priv->_postal_addresses = _tmp24_;
	_tmp25_ = self->priv->_postal_addresses;
	_tmp26_ = gee_abstract_set_get_read_only_view ((GeeAbstractSet*) _tmp25_);
	_tmp27_ = _tmp26_;
	_g_object_unref0 (self->priv->_postal_addresses_ro);
	self->priv->_postal_addresses_ro = _tmp27_;
	_tmp28_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_local_ids);
	self->priv->_local_ids = _tmp28_;
	_tmp29_ = self->priv->_local_ids;
	_tmp30_ = gee_abstract_set_get_read_only_view ((GeeAbstractSet*) _tmp29_);
	_tmp31_ = _tmp30_;
	_g_object_unref0 (self->priv->_local_ids_ro);
	self->priv->_local_ids_ro = _tmp31_;
	_tmp32_ = self->priv->_cursor;
	if (_tmp32_ != NULL) {
		_trf_persona_update_names (self);
		_trf_persona_update_avatar (self);
		_trf_persona_update_im_addresses (self);
		_trf_persona_update_phones (self);
		_trf_persona_update_email_addresses (self);
		_trf_persona_update_urls (self);
		_trf_persona_update_favourite (self);
		_trf_persona_update_roles (self);
		_trf_persona_update_bday (self);
		_trf_persona_update_note (self);
		_trf_persona_update_gender (self);
		_trf_persona_update_postal_addresses (self);
		_trf_persona_update_local_ids (self);
	}
	return obj;
}


static void trf_persona_class_init (TrfPersonaClass * klass) {
	trf_persona_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (TrfPersonaPrivate));
	((FolksPersonaClass *) klass)->linkable_property_to_links = trf_persona_real_linkable_property_to_links;
	FOLKS_PERSONA_CLASS (klass)->get_linkable_properties = trf_persona_real_get_linkable_properties;
	FOLKS_PERSONA_CLASS (klass)->get_writeable_properties = trf_persona_real_get_writeable_properties;
	G_OBJECT_CLASS (klass)->get_property = _vala_trf_persona_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_trf_persona_set_property;
	G_OBJECT_CLASS (klass)->constructor = trf_persona_constructor;
	G_OBJECT_CLASS (klass)->finalize = trf_persona_finalize;
	/**
	   * A nickname for the Persona.
	   *
	   * See {@link Folks.NameDetails.nickname}.
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRF_PERSONA_NICKNAME, g_param_spec_string ("nickname", "nickname", "nickname", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * {@inheritDoc}
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRF_PERSONA_PHONE_NUMBERS, g_param_spec_object ("phone-numbers", "phone-numbers", "phone-numbers", GEE_TYPE_SET, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * {@inheritDoc}
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRF_PERSONA_EMAIL_ADDRESSES, g_param_spec_object ("email-addresses", "email-addresses", "email-addresses", GEE_TYPE_SET, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * {@inheritDoc}
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRF_PERSONA_LINKABLE_PROPERTIES, g_param_spec_boxed ("linkable-properties", "linkable-properties", "linkable-properties", G_TYPE_STRV, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * {@inheritDoc}
	   *
	   * @since 0.6.0
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRF_PERSONA_WRITEABLE_PROPERTIES, g_param_spec_boxed ("writeable-properties", "writeable-properties", "writeable-properties", G_TYPE_STRV, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * An avatar for the Persona.
	   *
	   * See {@link Folks.AvatarDetails.avatar}.
	   *
	   * @since 0.6.0
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRF_PERSONA_AVATAR, g_param_spec_object ("avatar", "avatar", "avatar", g_loadable_icon_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * {@inheritDoc}
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRF_PERSONA_STRUCTURED_NAME, g_param_spec_object ("structured-name", "structured-name", "structured-name", FOLKS_TYPE_STRUCTURED_NAME, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * {@inheritDoc}
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRF_PERSONA_FULL_NAME, g_param_spec_string ("full-name", "full-name", "full-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * {@inheritDoc}
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRF_PERSONA_GENDER, g_param_spec_enum ("gender", "gender", "gender", FOLKS_TYPE_GENDER, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * {@inheritDoc}
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRF_PERSONA_BIRTHDAY, g_param_spec_boxed ("birthday", "birthday", "birthday", G_TYPE_DATE_TIME, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * {@inheritDoc}
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRF_PERSONA_CALENDAR_EVENT_ID, g_param_spec_string ("calendar-event-id", "calendar-event-id", "calendar-event-id", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * {@inheritDoc}
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRF_PERSONA_ROLES, g_param_spec_object ("roles", "roles", "roles", GEE_TYPE_SET, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * {@inheritDoc}
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRF_PERSONA_NOTES, g_param_spec_object ("notes", "notes", "notes", GEE_TYPE_SET, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * {@inheritDoc}
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRF_PERSONA_URLS, g_param_spec_object ("urls", "urls", "urls", GEE_TYPE_SET, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * {@inheritDoc}
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRF_PERSONA_POSTAL_ADDRESSES, g_param_spec_object ("postal-addresses", "postal-addresses", "postal-addresses", GEE_TYPE_SET, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * {@inheritDoc}
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRF_PERSONA_IM_ADDRESSES, g_param_spec_object ("im-addresses", "im-addresses", "im-addresses", GEE_TYPE_MULTI_MAP, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * Whether this contact is a user-defined favourite.
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRF_PERSONA_IS_FAVOURITE, g_param_spec_boolean ("is-favourite", "is-favourite", "is-favourite", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * IDs used to link {@link Trf.Persona}s.
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRF_PERSONA_LOCAL_IDS, g_param_spec_object ("local-ids", "local-ids", "local-ids", GEE_TYPE_SET, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * {@inheritDoc}
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRF_PERSONA_WEB_SERVICE_ADDRESSES, g_param_spec_object ("web-service-addresses", "web-service-addresses", "web-service-addresses", GEE_TYPE_MULTI_MAP, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * ID of the {@link Trf.Persona} in Tracker.
	   *
	   * @since 0.6.6
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRF_PERSONA_TRACKER_ID, g_param_spec_string ("tracker-id", "tracker-id", "tracker-id", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	   * A {@link Sparql.Cursor} representing the persona in a set of query results.
	   *
	   * This is an internal (read: horrible) API which shouldn't be used by client
	   * code. It's only exposed publicly due to the design of libfolks’ Tracker
	   * backend.
	   *
	   * @since 0.6.6
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRF_PERSONA_CURSOR, g_param_spec_object ("cursor", "cursor", "cursor", TRACKER_SPARQL_TYPE_CURSOR, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void trf_persona_folks_avatar_details_interface_init (FolksAvatarDetailsIface * iface) {
	trf_persona_folks_avatar_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->change_avatar = (void (*)(FolksAvatarDetails*, GLoadableIcon*, GError**)) trf_persona_real_change_avatar;
	iface->change_avatar_finish = trf_persona_real_change_avatar_finish;
	iface->get_avatar = trf_persona_real_get_avatar;
	iface->set_avatar = trf_persona_real_set_avatar;
}


static void trf_persona_folks_birthday_details_interface_init (FolksBirthdayDetailsIface * iface) {
	trf_persona_folks_birthday_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->change_birthday = (void (*)(FolksBirthdayDetails*, GDateTime*, GError**)) trf_persona_real_change_birthday;
	iface->change_birthday_finish = trf_persona_real_change_birthday_finish;
	iface->get_birthday = trf_persona_real_get_birthday;
	iface->set_birthday = trf_persona_real_set_birthday;
	iface->get_calendar_event_id = trf_persona_real_get_calendar_event_id;
	iface->set_calendar_event_id = trf_persona_real_set_calendar_event_id;
}


static void trf_persona_folks_email_details_interface_init (FolksEmailDetailsIface * iface) {
	trf_persona_folks_email_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->change_email_addresses = (void (*)(FolksEmailDetails*, GeeSet*, GError**)) trf_persona_real_change_email_addresses;
	iface->change_email_addresses_finish = trf_persona_real_change_email_addresses_finish;
	iface->get_email_addresses = trf_persona_real_get_email_addresses;
	iface->set_email_addresses = trf_persona_real_set_email_addresses;
}


static void trf_persona_folks_favourite_details_interface_init (FolksFavouriteDetailsIface * iface) {
	trf_persona_folks_favourite_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->change_is_favourite = (void (*)(FolksFavouriteDetails*, gboolean, GError**)) trf_persona_real_change_is_favourite;
	iface->change_is_favourite_finish = trf_persona_real_change_is_favourite_finish;
	iface->get_is_favourite = trf_persona_real_get_is_favourite;
	iface->set_is_favourite = trf_persona_real_set_is_favourite;
}


static void trf_persona_folks_gender_details_interface_init (FolksGenderDetailsIface * iface) {
	trf_persona_folks_gender_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->change_gender = (void (*)(FolksGenderDetails*, FolksGender, GError**)) trf_persona_real_change_gender;
	iface->change_gender_finish = trf_persona_real_change_gender_finish;
	iface->get_gender = trf_persona_real_get_gender;
	iface->set_gender = trf_persona_real_set_gender;
}


static void trf_persona_folks_im_details_interface_init (FolksImDetailsIface * iface) {
	trf_persona_folks_im_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->change_im_addresses = (void (*)(FolksImDetails*, GeeMultiMap*, GError**)) trf_persona_real_change_im_addresses;
	iface->change_im_addresses_finish = trf_persona_real_change_im_addresses_finish;
	iface->get_im_addresses = trf_persona_real_get_im_addresses;
	iface->set_im_addresses = trf_persona_real_set_im_addresses;
}


static void trf_persona_folks_local_id_details_interface_init (FolksLocalIdDetailsIface * iface) {
	trf_persona_folks_local_id_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->change_local_ids = (void (*)(FolksLocalIdDetails*, GeeSet*, GError**)) trf_persona_real_change_local_ids;
	iface->change_local_ids_finish = trf_persona_real_change_local_ids_finish;
	iface->get_local_ids = trf_persona_real_get_local_ids;
	iface->set_local_ids = trf_persona_real_set_local_ids;
}


static void trf_persona_folks_name_details_interface_init (FolksNameDetailsIface * iface) {
	trf_persona_folks_name_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->change_nickname = (void (*)(FolksNameDetails*, const gchar*, GError**)) trf_persona_real_change_nickname;
	iface->change_nickname_finish = trf_persona_real_change_nickname_finish;
	iface->change_structured_name = (void (*)(FolksNameDetails*, FolksStructuredName*, GError**)) trf_persona_real_change_structured_name;
	iface->change_structured_name_finish = trf_persona_real_change_structured_name_finish;
	iface->change_full_name = (void (*)(FolksNameDetails*, const gchar*, GError**)) trf_persona_real_change_full_name;
	iface->change_full_name_finish = trf_persona_real_change_full_name_finish;
	iface->get_nickname = trf_persona_real_get_nickname;
	iface->set_nickname = trf_persona_real_set_nickname;
	iface->get_structured_name = trf_persona_real_get_structured_name;
	iface->set_structured_name = trf_persona_real_set_structured_name;
	iface->get_full_name = trf_persona_real_get_full_name;
	iface->set_full_name = trf_persona_real_set_full_name;
}


static void trf_persona_folks_note_details_interface_init (FolksNoteDetailsIface * iface) {
	trf_persona_folks_note_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->change_notes = (void (*)(FolksNoteDetails*, GeeSet*, GError**)) trf_persona_real_change_notes;
	iface->change_notes_finish = trf_persona_real_change_notes_finish;
	iface->get_notes = trf_persona_real_get_notes;
	iface->set_notes = trf_persona_real_set_notes;
}


static void trf_persona_folks_phone_details_interface_init (FolksPhoneDetailsIface * iface) {
	trf_persona_folks_phone_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->change_phone_numbers = (void (*)(FolksPhoneDetails*, GeeSet*, GError**)) trf_persona_real_change_phone_numbers;
	iface->change_phone_numbers_finish = trf_persona_real_change_phone_numbers_finish;
	iface->get_phone_numbers = trf_persona_real_get_phone_numbers;
	iface->set_phone_numbers = trf_persona_real_set_phone_numbers;
}


static void trf_persona_folks_postal_address_details_interface_init (FolksPostalAddressDetailsIface * iface) {
	trf_persona_folks_postal_address_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->change_postal_addresses = (void (*)(FolksPostalAddressDetails*, GeeSet*, GError**)) trf_persona_real_change_postal_addresses;
	iface->change_postal_addresses_finish = trf_persona_real_change_postal_addresses_finish;
	iface->get_postal_addresses = trf_persona_real_get_postal_addresses;
	iface->set_postal_addresses = trf_persona_real_set_postal_addresses;
}


static void trf_persona_folks_role_details_interface_init (FolksRoleDetailsIface * iface) {
	trf_persona_folks_role_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->change_roles = (void (*)(FolksRoleDetails*, GeeSet*, GError**)) trf_persona_real_change_roles;
	iface->change_roles_finish = trf_persona_real_change_roles_finish;
	iface->get_roles = trf_persona_real_get_roles;
	iface->set_roles = trf_persona_real_set_roles;
}


static void trf_persona_folks_url_details_interface_init (FolksUrlDetailsIface * iface) {
	trf_persona_folks_url_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->change_urls = (void (*)(FolksUrlDetails*, GeeSet*, GError**)) trf_persona_real_change_urls;
	iface->change_urls_finish = trf_persona_real_change_urls_finish;
	iface->get_urls = trf_persona_real_get_urls;
	iface->set_urls = trf_persona_real_set_urls;
}


static void trf_persona_folks_web_service_details_interface_init (FolksWebServiceDetailsIface * iface) {
	trf_persona_folks_web_service_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->change_web_service_addresses = (void (*)(FolksWebServiceDetails*, GeeMultiMap*, GError**)) trf_persona_real_change_web_service_addresses;
	iface->change_web_service_addresses_finish = trf_persona_real_change_web_service_addresses_finish;
	iface->get_web_service_addresses = trf_persona_real_get_web_service_addresses;
	iface->set_web_service_addresses = trf_persona_real_set_web_service_addresses;
}


static void trf_persona_instance_init (TrfPersona * self) {
	gchar* _tmp0_ = NULL;
	GeeHashMap* _tmp1_ = NULL;
	GeeHashMultiMap* _tmp2_ = NULL;
	GeeHashMultiMap* _tmp3_ = NULL;
	self->priv = TRF_PERSONA_GET_PRIVATE (self);
	self->priv->_avatar = NULL;
	self->priv->_structured_name = NULL;
	_tmp0_ = g_strdup ("");
	self->priv->_full_name = _tmp0_;
	self->priv->_birthday = NULL;
	_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, GEE_TYPE_HASH_MAP, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->_tracker_ids_ims = _tmp1_;
	_tmp2_ = gee_hash_multi_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, FOLKS_TYPE_IM_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, _folks_abstract_field_details_hash_static_gee_hash_data_func, NULL, NULL, _folks_abstract_field_details_equal_static_gee_equal_data_func, NULL, NULL);
	self->priv->_im_addresses = _tmp2_;
	_tmp3_ = gee_hash_multi_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, FOLKS_TYPE_WEB_SERVICE_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, _folks_abstract_field_details_hash_static_gee_hash_data_func, NULL, NULL, _folks_abstract_field_details_equal_static_gee_equal_data_func, NULL, NULL);
	self->priv->_web_service_addresses = _tmp3_;
}


static void trf_persona_finalize (GObject* obj) {
	TrfPersona * self;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRF_TYPE_PERSONA, TrfPersona);
	_tmp0_ = folks_persona_get_uid ((FolksPersona*) self);
	_tmp1_ = _tmp0_;
	g_debug ("trf-persona.vala:677: Destroying Trf.Persona '%s': %p", _tmp1_, self);
	_g_free0 (self->priv->_nickname);
	_g_object_unref0 (self->priv->_phone_numbers);
	_g_object_unref0 (self->priv->_phone_numbers_ro);
	_g_object_unref0 (self->priv->_email_addresses);
	_g_object_unref0 (self->priv->_email_addresses_ro);
	_g_free0 (self->priv->_tracker_id);
	_g_object_unref0 (self->priv->_avatar);
	_g_object_unref0 (self->priv->_structured_name);
	_g_free0 (self->priv->_full_name);
	_g_date_time_unref0 (self->priv->_birthday);
	_g_object_unref0 (self->priv->_roles);
	_g_object_unref0 (self->priv->_roles_ro);
	_g_object_unref0 (self->priv->_notes);
	_g_object_unref0 (self->priv->_notes_ro);
	_g_object_unref0 (self->priv->_urls);
	_g_object_unref0 (self->priv->_urls_ro);
	_g_object_unref0 (self->priv->_postal_addresses);
	_g_object_unref0 (self->priv->_postal_addresses_ro);
	_g_object_unref0 (self->priv->_tracker_ids_ims);
	_g_object_unref0 (self->priv->_im_addresses);
	_g_object_unref0 (self->priv->_local_ids);
	_g_object_unref0 (self->priv->_local_ids_ro);
	_g_object_unref0 (self->priv->_web_service_addresses);
	G_OBJECT_CLASS (trf_persona_parent_class)->finalize (obj);
}


/**
 * A persona subclass which represents a single nco:Contact.
 */
GType trf_persona_get_type (void) {
	static volatile gsize trf_persona_type_id__volatile = 0;
	if (g_once_init_enter (&trf_persona_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrfPersonaClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) trf_persona_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrfPersona), 0, (GInstanceInitFunc) trf_persona_instance_init, NULL };
		static const GInterfaceInfo folks_avatar_details_info = { (GInterfaceInitFunc) trf_persona_folks_avatar_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_birthday_details_info = { (GInterfaceInitFunc) trf_persona_folks_birthday_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_email_details_info = { (GInterfaceInitFunc) trf_persona_folks_email_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_favourite_details_info = { (GInterfaceInitFunc) trf_persona_folks_favourite_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_gender_details_info = { (GInterfaceInitFunc) trf_persona_folks_gender_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_im_details_info = { (GInterfaceInitFunc) trf_persona_folks_im_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_local_id_details_info = { (GInterfaceInitFunc) trf_persona_folks_local_id_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_name_details_info = { (GInterfaceInitFunc) trf_persona_folks_name_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_note_details_info = { (GInterfaceInitFunc) trf_persona_folks_note_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_phone_details_info = { (GInterfaceInitFunc) trf_persona_folks_phone_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_postal_address_details_info = { (GInterfaceInitFunc) trf_persona_folks_postal_address_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_role_details_info = { (GInterfaceInitFunc) trf_persona_folks_role_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_url_details_info = { (GInterfaceInitFunc) trf_persona_folks_url_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_web_service_details_info = { (GInterfaceInitFunc) trf_persona_folks_web_service_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType trf_persona_type_id;
		trf_persona_type_id = g_type_register_static (FOLKS_TYPE_PERSONA, "TrfPersona", &g_define_type_info, 0);
		g_type_add_interface_static (trf_persona_type_id, FOLKS_TYPE_AVATAR_DETAILS, &folks_avatar_details_info);
		g_type_add_interface_static (trf_persona_type_id, FOLKS_TYPE_BIRTHDAY_DETAILS, &folks_birthday_details_info);
		g_type_add_interface_static (trf_persona_type_id, FOLKS_TYPE_EMAIL_DETAILS, &folks_email_details_info);
		g_type_add_interface_static (trf_persona_type_id, FOLKS_TYPE_FAVOURITE_DETAILS, &folks_favourite_details_info);
		g_type_add_interface_static (trf_persona_type_id, FOLKS_TYPE_GENDER_DETAILS, &folks_gender_details_info);
		g_type_add_interface_static (trf_persona_type_id, FOLKS_TYPE_IM_DETAILS, &folks_im_details_info);
		g_type_add_interface_static (trf_persona_type_id, FOLKS_TYPE_LOCAL_ID_DETAILS, &folks_local_id_details_info);
		g_type_add_interface_static (trf_persona_type_id, FOLKS_TYPE_NAME_DETAILS, &folks_name_details_info);
		g_type_add_interface_static (trf_persona_type_id, FOLKS_TYPE_NOTE_DETAILS, &folks_note_details_info);
		g_type_add_interface_static (trf_persona_type_id, FOLKS_TYPE_PHONE_DETAILS, &folks_phone_details_info);
		g_type_add_interface_static (trf_persona_type_id, FOLKS_TYPE_POSTAL_ADDRESS_DETAILS, &folks_postal_address_details_info);
		g_type_add_interface_static (trf_persona_type_id, FOLKS_TYPE_ROLE_DETAILS, &folks_role_details_info);
		g_type_add_interface_static (trf_persona_type_id, FOLKS_TYPE_URL_DETAILS, &folks_url_details_info);
		g_type_add_interface_static (trf_persona_type_id, FOLKS_TYPE_WEB_SERVICE_DETAILS, &folks_web_service_details_info);
		g_once_init_leave (&trf_persona_type_id__volatile, trf_persona_type_id);
	}
	return trf_persona_type_id__volatile;
}


static void _vala_trf_persona_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	TrfPersona * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TRF_TYPE_PERSONA, TrfPersona);
	switch (property_id) {
		case TRF_PERSONA_NICKNAME:
		g_value_set_string (value, folks_name_details_get_nickname ((FolksNameDetails*) self));
		break;
		case TRF_PERSONA_PHONE_NUMBERS:
		g_value_set_object (value, folks_phone_details_get_phone_numbers ((FolksPhoneDetails*) self));
		break;
		case TRF_PERSONA_EMAIL_ADDRESSES:
		g_value_set_object (value, folks_email_details_get_email_addresses ((FolksEmailDetails*) self));
		break;
		case TRF_PERSONA_LINKABLE_PROPERTIES:
		{
			int length;
			g_value_set_boxed (value, folks_persona_get_linkable_properties ((FolksPersona*) self, &length));
		}
		break;
		case TRF_PERSONA_WRITEABLE_PROPERTIES:
		{
			int length;
			g_value_set_boxed (value, folks_persona_get_writeable_properties ((FolksPersona*) self, &length));
		}
		break;
		case TRF_PERSONA_AVATAR:
		g_value_set_object (value, folks_avatar_details_get_avatar ((FolksAvatarDetails*) self));
		break;
		case TRF_PERSONA_STRUCTURED_NAME:
		g_value_set_object (value, folks_name_details_get_structured_name ((FolksNameDetails*) self));
		break;
		case TRF_PERSONA_FULL_NAME:
		g_value_set_string (value, folks_name_details_get_full_name ((FolksNameDetails*) self));
		break;
		case TRF_PERSONA_GENDER:
		g_value_set_enum (value, folks_gender_details_get_gender ((FolksGenderDetails*) self));
		break;
		case TRF_PERSONA_BIRTHDAY:
		g_value_set_boxed (value, folks_birthday_details_get_birthday ((FolksBirthdayDetails*) self));
		break;
		case TRF_PERSONA_CALENDAR_EVENT_ID:
		g_value_set_string (value, folks_birthday_details_get_calendar_event_id ((FolksBirthdayDetails*) self));
		break;
		case TRF_PERSONA_ROLES:
		g_value_set_object (value, folks_role_details_get_roles ((FolksRoleDetails*) self));
		break;
		case TRF_PERSONA_NOTES:
		g_value_set_object (value, folks_note_details_get_notes ((FolksNoteDetails*) self));
		break;
		case TRF_PERSONA_URLS:
		g_value_set_object (value, folks_url_details_get_urls ((FolksUrlDetails*) self));
		break;
		case TRF_PERSONA_POSTAL_ADDRESSES:
		g_value_set_object (value, folks_postal_address_details_get_postal_addresses ((FolksPostalAddressDetails*) self));
		break;
		case TRF_PERSONA_IM_ADDRESSES:
		g_value_set_object (value, folks_im_details_get_im_addresses ((FolksImDetails*) self));
		break;
		case TRF_PERSONA_IS_FAVOURITE:
		g_value_set_boolean (value, folks_favourite_details_get_is_favourite ((FolksFavouriteDetails*) self));
		break;
		case TRF_PERSONA_LOCAL_IDS:
		g_value_set_object (value, folks_local_id_details_get_local_ids ((FolksLocalIdDetails*) self));
		break;
		case TRF_PERSONA_WEB_SERVICE_ADDRESSES:
		g_value_set_object (value, folks_web_service_details_get_web_service_addresses ((FolksWebServiceDetails*) self));
		break;
		case TRF_PERSONA_TRACKER_ID:
		g_value_set_string (value, trf_persona_get_tracker_id (self));
		break;
		case TRF_PERSONA_CURSOR:
		g_value_set_object (value, trf_persona_get_cursor (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_trf_persona_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	TrfPersona * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TRF_TYPE_PERSONA, TrfPersona);
	switch (property_id) {
		case TRF_PERSONA_NICKNAME:
		folks_name_details_set_nickname ((FolksNameDetails*) self, g_value_get_string (value));
		break;
		case TRF_PERSONA_PHONE_NUMBERS:
		folks_phone_details_set_phone_numbers ((FolksPhoneDetails*) self, g_value_get_object (value));
		break;
		case TRF_PERSONA_EMAIL_ADDRESSES:
		folks_email_details_set_email_addresses ((FolksEmailDetails*) self, g_value_get_object (value));
		break;
		case TRF_PERSONA_AVATAR:
		folks_avatar_details_set_avatar ((FolksAvatarDetails*) self, g_value_get_object (value));
		break;
		case TRF_PERSONA_STRUCTURED_NAME:
		folks_name_details_set_structured_name ((FolksNameDetails*) self, g_value_get_object (value));
		break;
		case TRF_PERSONA_FULL_NAME:
		folks_name_details_set_full_name ((FolksNameDetails*) self, g_value_get_string (value));
		break;
		case TRF_PERSONA_GENDER:
		folks_gender_details_set_gender ((FolksGenderDetails*) self, g_value_get_enum (value));
		break;
		case TRF_PERSONA_BIRTHDAY:
		folks_birthday_details_set_birthday ((FolksBirthdayDetails*) self, g_value_get_boxed (value));
		break;
		case TRF_PERSONA_CALENDAR_EVENT_ID:
		folks_birthday_details_set_calendar_event_id ((FolksBirthdayDetails*) self, g_value_get_string (value));
		break;
		case TRF_PERSONA_ROLES:
		folks_role_details_set_roles ((FolksRoleDetails*) self, g_value_get_object (value));
		break;
		case TRF_PERSONA_NOTES:
		folks_note_details_set_notes ((FolksNoteDetails*) self, g_value_get_object (value));
		break;
		case TRF_PERSONA_URLS:
		folks_url_details_set_urls ((FolksUrlDetails*) self, g_value_get_object (value));
		break;
		case TRF_PERSONA_POSTAL_ADDRESSES:
		folks_postal_address_details_set_postal_addresses ((FolksPostalAddressDetails*) self, g_value_get_object (value));
		break;
		case TRF_PERSONA_IM_ADDRESSES:
		folks_im_details_set_im_addresses ((FolksImDetails*) self, g_value_get_object (value));
		break;
		case TRF_PERSONA_IS_FAVOURITE:
		folks_favourite_details_set_is_favourite ((FolksFavouriteDetails*) self, g_value_get_boolean (value));
		break;
		case TRF_PERSONA_LOCAL_IDS:
		folks_local_id_details_set_local_ids ((FolksLocalIdDetails*) self, g_value_get_object (value));
		break;
		case TRF_PERSONA_WEB_SERVICE_ADDRESSES:
		folks_web_service_details_set_web_service_addresses ((FolksWebServiceDetails*) self, g_value_get_object (value));
		break;
		case TRF_PERSONA_TRACKER_ID:
		trf_persona_set_tracker_id (self, g_value_get_string (value));
		break;
		case TRF_PERSONA_CURSOR:
		trf_persona_set_cursor (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



