/* bluez-persona.c generated by valac 0.27.1.4-8d57, the Vala compiler
 * generated from bluez-persona.vala, do not modify */

/*
 * Copyright (C) 2010-2013 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *          Arun Raghavan <arun.raghavan@collabora.co.uk>
 *          Jeremy Whiting <jeremy.whiting@collabora.com>
 *          Simon McVittie <simon.mcvittie@collabora.co.uk>
 *          Matthieu Bouron <matthieu.bouron@collabora.com>
 *
 * Based on kf-persona.vala by:
 *       Philip Withnall <philip.withnall@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <folks/folks.h>
#include <folks/small-set.h>
#include <gee.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <libebook-contacts/libebook-contacts.h>
#include <folks-internal.h>
#include <folks/small-set-internal.h>


#define FOLKS_BACKENDS_BLUE_Z_TYPE_PERSONA (folks_backends_blue_z_persona_get_type ())
#define FOLKS_BACKENDS_BLUE_Z_PERSONA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_BACKENDS_BLUE_Z_TYPE_PERSONA, FolksBackendsBlueZPersona))
#define FOLKS_BACKENDS_BLUE_Z_PERSONA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_BACKENDS_BLUE_Z_TYPE_PERSONA, FolksBackendsBlueZPersonaClass))
#define FOLKS_BACKENDS_BLUE_Z_IS_PERSONA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_BACKENDS_BLUE_Z_TYPE_PERSONA))
#define FOLKS_BACKENDS_BLUE_Z_IS_PERSONA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_BACKENDS_BLUE_Z_TYPE_PERSONA))
#define FOLKS_BACKENDS_BLUE_Z_PERSONA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_BACKENDS_BLUE_Z_TYPE_PERSONA, FolksBackendsBlueZPersonaClass))

typedef struct _FolksBackendsBlueZPersona FolksBackendsBlueZPersona;
typedef struct _FolksBackendsBlueZPersonaClass FolksBackendsBlueZPersonaClass;
typedef struct _FolksBackendsBlueZPersonaPrivate FolksBackendsBlueZPersonaPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_bytes_unref0(var) ((var == NULL) ? NULL : (var = (g_bytes_unref (var), NULL)))

struct _FolksBackendsBlueZPersona {
	FolksPersona parent_instance;
	FolksBackendsBlueZPersonaPrivate * priv;
};

struct _FolksBackendsBlueZPersonaClass {
	FolksPersonaClass parent_class;
};

struct _FolksBackendsBlueZPersonaPrivate {
	FolksSmallSet* _urls;
	GeeSet* _urls_ro;
	GLoadableIcon* _avatar;
	FolksSmallSet* _phone_numbers;
	GeeSet* _phone_numbers_ro;
	FolksStructuredName* _structured_name;
	gchar* _full_name;
	gchar* _nickname;
	FolksSmallSet* _email_addresses;
	GeeSet* _email_addresses_ro;
};


static gpointer folks_backends_blue_z_persona_parent_class = NULL;
static gchar** folks_backends_blue_z_persona__writeable_properties;
static gint folks_backends_blue_z_persona__writeable_properties_length1;
static gchar** folks_backends_blue_z_persona__writeable_properties = NULL;
static gint folks_backends_blue_z_persona__writeable_properties_length1 = 0;
static gint _folks_backends_blue_z_persona__writeable_properties_size_ = 0;
static FolksAvatarDetailsIface* folks_backends_blue_z_persona_folks_avatar_details_parent_iface = NULL;
static FolksEmailDetailsIface* folks_backends_blue_z_persona_folks_email_details_parent_iface = NULL;
static FolksNameDetailsIface* folks_backends_blue_z_persona_folks_name_details_parent_iface = NULL;
static FolksPhoneDetailsIface* folks_backends_blue_z_persona_folks_phone_details_parent_iface = NULL;
static FolksUrlDetailsIface* folks_backends_blue_z_persona_folks_url_details_parent_iface = NULL;

GType folks_backends_blue_z_persona_get_type (void) G_GNUC_CONST;
#define FOLKS_BACKENDS_BLUE_Z_PERSONA_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), FOLKS_BACKENDS_BLUE_Z_TYPE_PERSONA, FolksBackendsBlueZPersonaPrivate))
enum  {
	FOLKS_BACKENDS_BLUE_Z_PERSONA_DUMMY_PROPERTY,
	FOLKS_BACKENDS_BLUE_Z_PERSONA_LINKABLE_PROPERTIES,
	FOLKS_BACKENDS_BLUE_Z_PERSONA_URLS,
	FOLKS_BACKENDS_BLUE_Z_PERSONA_AVATAR,
	FOLKS_BACKENDS_BLUE_Z_PERSONA_WRITEABLE_PROPERTIES,
	FOLKS_BACKENDS_BLUE_Z_PERSONA_PHONE_NUMBERS,
	FOLKS_BACKENDS_BLUE_Z_PERSONA_STRUCTURED_NAME,
	FOLKS_BACKENDS_BLUE_Z_PERSONA_FULL_NAME,
	FOLKS_BACKENDS_BLUE_Z_PERSONA_NICKNAME,
	FOLKS_BACKENDS_BLUE_Z_PERSONA_EMAIL_ADDRESSES
};
FolksBackendsBlueZPersona* folks_backends_blue_z_persona_new (const gchar* vcard, EVCard* card, FolksPersonaStore* store, gboolean is_user, const gchar* iid);
FolksBackendsBlueZPersona* folks_backends_blue_z_persona_construct (GType object_type, const gchar* vcard, EVCard* card, FolksPersonaStore* store, gboolean is_user, const gchar* iid);
gboolean folks_backends_blue_z_persona_update_from_vcard (FolksBackendsBlueZPersona* self, EVCard* card);
static void _folks_backends_blue_z_persona_update_params (FolksBackendsBlueZPersona* self, FolksAbstractFieldDetails* details, EVCardAttribute* attr);
static guint _folks_abstract_field_details_hash_static_gee_hash_data_func (gconstpointer v, gpointer self);
static gboolean _folks_abstract_field_details_equal_static_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self);
static void folks_backends_blue_z_persona_real_linkable_property_to_links (FolksPersona* base, const gchar* prop_name, FolksPersonaLinkablePropertyCallback callback, void* callback_target);
static GObject * folks_backends_blue_z_persona_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void folks_backends_blue_z_persona_finalize (GObject* obj);
static void _vala_folks_backends_blue_z_persona_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_folks_backends_blue_z_persona_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);

static const gchar* FOLKS_BACKENDS_BLUE_Z_PERSONA__linkable_properties[2] = {"phone-numbers", "email-addresses"};

/**
   * Create a new persona.
   *
   * Create a new persona for the {@link PersonaStore} ``store``, representing
   * the Persona in the given ``vcard``.
   *
   * @param vcard the vCard stored as a string
   * @param card a parsed version of the vCard
   * @param store the store to which the Persona belongs.
   * @param is_user whether the Persona is the user itself or not.
   * @param iid pre-calculated IID for the persona
   *
   * @since 0.9.6
   */
FolksBackendsBlueZPersona* folks_backends_blue_z_persona_construct (GType object_type, const gchar* vcard, EVCard* card, FolksPersonaStore* store, gboolean is_user, const gchar* iid) {
	FolksBackendsBlueZPersona * self = NULL;
	gchar* uid = NULL;
	FolksPersonaStore* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	FolksPersonaStore* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	EVCard* _tmp9_ = NULL;
	g_return_val_if_fail (vcard != NULL, NULL);
	g_return_val_if_fail (card != NULL, NULL);
	g_return_val_if_fail (store != NULL, NULL);
	g_return_val_if_fail (iid != NULL, NULL);
	_tmp0_ = store;
	_tmp1_ = folks_persona_store_get_id (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = iid;
	_tmp4_ = folks_persona_build_uid ("bluez", _tmp2_, _tmp3_);
	uid = _tmp4_;
	_tmp5_ = iid;
	_tmp6_ = iid;
	_tmp7_ = store;
	_tmp8_ = is_user;
	self = (FolksBackendsBlueZPersona*) g_object_new (object_type, "display-id", _tmp5_, "iid", _tmp6_, "uid", uid, "store", _tmp7_, "is-user", _tmp8_, NULL);
	_tmp9_ = card;
	folks_backends_blue_z_persona_update_from_vcard (self, _tmp9_);
	_g_free0 (uid);
	return self;
}


FolksBackendsBlueZPersona* folks_backends_blue_z_persona_new (const gchar* vcard, EVCard* card, FolksPersonaStore* store, gboolean is_user, const gchar* iid) {
	return folks_backends_blue_z_persona_construct (FOLKS_BACKENDS_BLUE_Z_TYPE_PERSONA, vcard, card, store, is_user, iid);
}


static void _folks_backends_blue_z_persona_update_params (FolksBackendsBlueZPersona* self, FolksAbstractFieldDetails* details, EVCardAttribute* attr) {
	EVCardAttribute* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (details != NULL);
	g_return_if_fail (attr != NULL);
	_tmp0_ = attr;
	_tmp1_ = e_vcard_attribute_get_params (_tmp0_);
	{
		GList* param_collection = NULL;
		GList* param_it = NULL;
		param_collection = _tmp1_;
		for (param_it = param_collection; param_it != NULL; param_it = param_it->next) {
			EVCardAttributeParam* param = NULL;
			param = (EVCardAttributeParam*) param_it->data;
			{
				EVCardAttributeParam* _tmp2_ = NULL;
				GList* _tmp3_ = NULL;
				_tmp2_ = param;
				_tmp3_ = e_vcard_attribute_param_get_values (_tmp2_);
				{
					GList* param_value_collection = NULL;
					GList* param_value_it = NULL;
					param_value_collection = _tmp3_;
					for (param_value_it = param_value_collection; param_value_it != NULL; param_value_it = param_value_it->next) {
						const gchar* param_value = NULL;
						param_value = (const gchar*) param_value_it->data;
						{
							FolksAbstractFieldDetails* _tmp4_ = NULL;
							EVCardAttributeParam* _tmp5_ = NULL;
							const gchar* _tmp6_ = NULL;
							gchar* _tmp7_ = NULL;
							gchar* _tmp8_ = NULL;
							const gchar* _tmp9_ = NULL;
							gchar* _tmp10_ = NULL;
							gchar* _tmp11_ = NULL;
							_tmp4_ = details;
							_tmp5_ = param;
							_tmp6_ = e_vcard_attribute_param_get_name (_tmp5_);
							_tmp7_ = g_utf8_strdown (_tmp6_, (gssize) (-1));
							_tmp8_ = _tmp7_;
							_tmp9_ = param_value;
							_tmp10_ = g_utf8_strdown (_tmp9_, (gssize) (-1));
							_tmp11_ = _tmp10_;
							folks_abstract_field_details_add_parameter (_tmp4_, _tmp8_, _tmp11_);
							_g_free0 (_tmp11_);
							_g_free0 (_tmp8_);
						}
					}
				}
			}
		}
	}
}


/**
   * Update the Persona’s properties from a vCard.
   *
   * Parse the given ``vcard`` and set the persona’s properties from it. This
   * emits property change notifications as appropriate.
   *
   * @param vcard pre-parsed vCard
   * @return ``true`` if any properties were changed, ``false`` otherwise
   *
   * @since 0.9.7
   */
static guint _folks_abstract_field_details_hash_static_gee_hash_data_func (gconstpointer v, gpointer self) {
	guint result;
	result = folks_abstract_field_details_hash_static ((FolksAbstractFieldDetails*) v);
	return result;
}


static gboolean _folks_abstract_field_details_equal_static_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gboolean result;
	result = folks_abstract_field_details_equal_static ((FolksAbstractFieldDetails*) a, (FolksAbstractFieldDetails*) b);
	return result;
}


static guint8* string_get_data (const gchar* self, int* result_length1) {
	guint8* result;
	guint8* res = NULL;
	gint res_length1 = 0;
	gint _res_size_ = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	guint8* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	guint8* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res_length1;
	_tmp3_ = res;
	_tmp3__length1 = res_length1;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


gboolean folks_backends_blue_z_persona_update_from_vcard (FolksBackendsBlueZPersona* self, EVCard* card) {
	gboolean result = FALSE;
	gboolean properties_changed = FALSE;
	FolksSmallSet* new_phone_numbers = NULL;
	FolksSmallSet* _tmp0_ = NULL;
	FolksSmallSet* new_uris = NULL;
	FolksSmallSet* _tmp1_ = NULL;
	FolksSmallSet* new_email_addresses = NULL;
	FolksSmallSet* _tmp2_ = NULL;
	GBytesIcon* new_avatar = NULL;
	gchar* new_full_name = NULL;
	gchar* _tmp3_ = NULL;
	gchar* new_nickname = NULL;
	gchar* _tmp4_ = NULL;
	FolksStructuredName* new_structured_name = NULL;
	GList* attrs = NULL;
	EVCard* _tmp5_ = NULL;
	GList* _tmp6_ = NULL;
	GList* _tmp7_ = NULL;
	FolksSmallSet* _tmp113_ = NULL;
	FolksSmallSet* _tmp114_ = NULL;
	gboolean _tmp115_ = FALSE;
	FolksSmallSet* _tmp121_ = NULL;
	FolksSmallSet* _tmp122_ = NULL;
	gboolean _tmp123_ = FALSE;
	FolksSmallSet* _tmp129_ = NULL;
	FolksSmallSet* _tmp130_ = NULL;
	gboolean _tmp131_ = FALSE;
	gboolean _tmp137_ = FALSE;
	GBytesIcon* _tmp138_ = NULL;
	GLoadableIcon* _tmp139_ = NULL;
	const gchar* _tmp149_ = NULL;
	const gchar* _tmp150_ = NULL;
	const gchar* _tmp153_ = NULL;
	const gchar* _tmp154_ = NULL;
	gboolean _tmp157_ = FALSE;
	FolksStructuredName* _tmp158_ = NULL;
	FolksStructuredName* _tmp159_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (card != NULL, FALSE);
	properties_changed = FALSE;
	_tmp0_ = folks_small_set_new (FOLKS_TYPE_PHONE_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, _folks_abstract_field_details_hash_static_gee_hash_data_func, NULL, NULL, _folks_abstract_field_details_equal_static_gee_equal_data_func, NULL, NULL);
	new_phone_numbers = _tmp0_;
	_tmp1_ = folks_small_set_new (FOLKS_TYPE_URL_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, _folks_abstract_field_details_hash_static_gee_hash_data_func, NULL, NULL, _folks_abstract_field_details_equal_static_gee_equal_data_func, NULL, NULL);
	new_uris = _tmp1_;
	_tmp2_ = folks_small_set_new (FOLKS_TYPE_EMAIL_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, _folks_abstract_field_details_hash_static_gee_hash_data_func, NULL, NULL, _folks_abstract_field_details_equal_static_gee_equal_data_func, NULL, NULL);
	new_email_addresses = _tmp2_;
	new_avatar = NULL;
	_tmp3_ = g_strdup ("");
	new_full_name = _tmp3_;
	_tmp4_ = g_strdup ("");
	new_nickname = _tmp4_;
	new_structured_name = NULL;
	_tmp5_ = card;
	_tmp6_ = e_vcard_get_attributes (_tmp5_);
	attrs = _tmp6_;
	_tmp7_ = attrs;
	{
		GList* attr_collection = NULL;
		GList* attr_it = NULL;
		attr_collection = _tmp7_;
		for (attr_it = attr_collection; attr_it != NULL; attr_it = attr_it->next) {
			EVCardAttribute* attr = NULL;
			attr = (EVCardAttribute*) attr_it->data;
			{
				const gchar* attr_name = NULL;
				EVCardAttribute* _tmp8_ = NULL;
				const gchar* _tmp9_ = NULL;
				const gchar* _tmp10_ = NULL;
				_tmp8_ = attr;
				_tmp9_ = e_vcard_attribute_get_name (_tmp8_);
				attr_name = _tmp9_;
				_tmp10_ = attr_name;
				if (g_strcmp0 (_tmp10_, "TEL") == 0) {
					gchar* val = NULL;
					EVCardAttribute* _tmp11_ = NULL;
					gchar* _tmp12_ = NULL;
					gboolean _tmp13_ = FALSE;
					const gchar* _tmp14_ = NULL;
					FolksPhoneFieldDetails* new_field_details = NULL;
					const gchar* _tmp16_ = NULL;
					FolksPhoneFieldDetails* _tmp17_ = NULL;
					FolksPhoneFieldDetails* _tmp18_ = NULL;
					EVCardAttribute* _tmp19_ = NULL;
					FolksSmallSet* _tmp20_ = NULL;
					FolksPhoneFieldDetails* _tmp21_ = NULL;
					_tmp11_ = attr;
					_tmp12_ = e_vcard_attribute_get_value (_tmp11_);
					val = _tmp12_;
					_tmp14_ = val;
					if (_tmp14_ == NULL) {
						_tmp13_ = TRUE;
					} else {
						const gchar* _tmp15_ = NULL;
						_tmp15_ = val;
						_tmp13_ = g_strcmp0 ((const gchar*) _tmp15_, "") == 0;
					}
					if (_tmp13_) {
						_g_free0 (val);
						continue;
					}
					_tmp16_ = val;
					_tmp17_ = folks_phone_field_details_new ((const gchar*) _tmp16_, NULL);
					new_field_details = _tmp17_;
					_tmp18_ = new_field_details;
					_tmp19_ = attr;
					_folks_backends_blue_z_persona_update_params (self, (FolksAbstractFieldDetails*) _tmp18_, _tmp19_);
					_tmp20_ = new_phone_numbers;
					_tmp21_ = new_field_details;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp20_, _tmp21_);
					_g_object_unref0 (new_field_details);
					_g_free0 (val);
				} else {
					const gchar* _tmp22_ = NULL;
					_tmp22_ = attr_name;
					if (g_strcmp0 (_tmp22_, "URL") == 0) {
						gchar* val = NULL;
						EVCardAttribute* _tmp23_ = NULL;
						gchar* _tmp24_ = NULL;
						gboolean _tmp25_ = FALSE;
						const gchar* _tmp26_ = NULL;
						FolksUrlFieldDetails* new_field_details = NULL;
						const gchar* _tmp28_ = NULL;
						FolksUrlFieldDetails* _tmp29_ = NULL;
						FolksUrlFieldDetails* _tmp30_ = NULL;
						EVCardAttribute* _tmp31_ = NULL;
						FolksSmallSet* _tmp32_ = NULL;
						FolksUrlFieldDetails* _tmp33_ = NULL;
						_tmp23_ = attr;
						_tmp24_ = e_vcard_attribute_get_value (_tmp23_);
						val = _tmp24_;
						_tmp26_ = val;
						if (_tmp26_ == NULL) {
							_tmp25_ = TRUE;
						} else {
							const gchar* _tmp27_ = NULL;
							_tmp27_ = val;
							_tmp25_ = g_strcmp0 ((const gchar*) _tmp27_, "") == 0;
						}
						if (_tmp25_) {
							_g_free0 (val);
							continue;
						}
						_tmp28_ = val;
						_tmp29_ = folks_url_field_details_new ((const gchar*) _tmp28_, NULL);
						new_field_details = _tmp29_;
						_tmp30_ = new_field_details;
						_tmp31_ = attr;
						_folks_backends_blue_z_persona_update_params (self, (FolksAbstractFieldDetails*) _tmp30_, _tmp31_);
						_tmp32_ = new_uris;
						_tmp33_ = new_field_details;
						gee_abstract_collection_add ((GeeAbstractCollection*) _tmp32_, _tmp33_);
						_g_object_unref0 (new_field_details);
						_g_free0 (val);
					} else {
						const gchar* _tmp34_ = NULL;
						_tmp34_ = attr_name;
						if (g_strcmp0 (_tmp34_, "EMAIL") == 0) {
							gchar* val = NULL;
							EVCardAttribute* _tmp35_ = NULL;
							gchar* _tmp36_ = NULL;
							gboolean _tmp37_ = FALSE;
							const gchar* _tmp38_ = NULL;
							FolksEmailFieldDetails* new_field_details = NULL;
							const gchar* _tmp40_ = NULL;
							FolksEmailFieldDetails* _tmp41_ = NULL;
							FolksEmailFieldDetails* _tmp42_ = NULL;
							EVCardAttribute* _tmp43_ = NULL;
							FolksSmallSet* _tmp44_ = NULL;
							FolksEmailFieldDetails* _tmp45_ = NULL;
							_tmp35_ = attr;
							_tmp36_ = e_vcard_attribute_get_value (_tmp35_);
							val = _tmp36_;
							_tmp38_ = val;
							if (_tmp38_ == NULL) {
								_tmp37_ = TRUE;
							} else {
								const gchar* _tmp39_ = NULL;
								_tmp39_ = val;
								_tmp37_ = g_strcmp0 ((const gchar*) _tmp39_, "") == 0;
							}
							if (_tmp37_) {
								_g_free0 (val);
								continue;
							}
							_tmp40_ = val;
							_tmp41_ = folks_email_field_details_new ((const gchar*) _tmp40_, NULL);
							new_field_details = _tmp41_;
							_tmp42_ = new_field_details;
							_tmp43_ = attr;
							_folks_backends_blue_z_persona_update_params (self, (FolksAbstractFieldDetails*) _tmp42_, _tmp43_);
							_tmp44_ = new_email_addresses;
							_tmp45_ = new_field_details;
							gee_abstract_collection_add ((GeeAbstractCollection*) _tmp44_, _tmp45_);
							_g_object_unref0 (new_field_details);
							_g_free0 (val);
						} else {
							const gchar* _tmp46_ = NULL;
							_tmp46_ = attr_name;
							if (g_strcmp0 (_tmp46_, "PHOTO") == 0) {
								gchar* encoded_data = NULL;
								EVCardAttribute* _tmp47_ = NULL;
								gchar* _tmp48_ = NULL;
								gchar* _tmp49_ = NULL;
								guint8* _tmp50_ = NULL;
								gint _tmp50__length1 = 0;
								guint8* _tmp51_ = NULL;
								gint _tmp51__length1 = 0;
								gchar* _tmp52_ = NULL;
								gchar* _tmp53_ = NULL;
								GBytes* bytes = NULL;
								const gchar* _tmp54_ = NULL;
								size_t _tmp55_;
								guchar* _tmp56_ = NULL;
								guchar* _tmp57_ = NULL;
								gint _tmp57__length1 = 0;
								GBytes* _tmp58_ = NULL;
								GBytes* _tmp59_ = NULL;
								GBytes* _tmp60_ = NULL;
								GBytesIcon* _tmp61_ = NULL;
								_tmp47_ = attr;
								_tmp48_ = e_vcard_attribute_get_value (_tmp47_);
								_tmp49_ = _tmp48_;
								_tmp50_ = string_get_data (_tmp49_, &_tmp50__length1);
								_tmp51_ = _tmp50_;
								_tmp51__length1 = _tmp50__length1;
								_tmp52_ = g_strdup ((const gchar*) _tmp51_);
								_tmp53_ = _tmp52_;
								_g_free0 (_tmp49_);
								encoded_data = _tmp53_;
								_tmp54_ = encoded_data;
								_tmp56_ = g_base64_decode (_tmp54_, &_tmp55_);
								_tmp57_ = _tmp56_;
								_tmp57__length1 = _tmp55_;
								_tmp58_ = g_bytes_new (_tmp57_, _tmp55_);
								_tmp59_ = _tmp58_;
								_tmp57_ = (g_free (_tmp57_), NULL);
								bytes = _tmp59_;
								_tmp60_ = bytes;
								_tmp61_ = (GBytesIcon*) g_bytes_icon_new (_tmp60_);
								_g_object_unref0 (new_avatar);
								new_avatar = _tmp61_;
								_g_bytes_unref0 (bytes);
								_g_free0 (encoded_data);
							} else {
								const gchar* _tmp62_ = NULL;
								_tmp62_ = attr_name;
								if (g_strcmp0 (_tmp62_, "FN") == 0) {
									EVCardAttribute* _tmp63_ = NULL;
									gchar* _tmp64_ = NULL;
									_tmp63_ = attr;
									_tmp64_ = e_vcard_attribute_get_value (_tmp63_);
									_g_free0 (new_full_name);
									new_full_name = _tmp64_;
								} else {
									const gchar* _tmp65_ = NULL;
									_tmp65_ = attr_name;
									if (g_strcmp0 (_tmp65_, "NICKNAME") == 0) {
										EVCardAttribute* _tmp66_ = NULL;
										gchar* _tmp67_ = NULL;
										_tmp66_ = attr;
										_tmp67_ = e_vcard_attribute_get_value (_tmp66_);
										_g_free0 (new_nickname);
										new_nickname = _tmp67_;
									} else {
										const gchar* _tmp68_ = NULL;
										_tmp68_ = attr_name;
										if (g_strcmp0 (_tmp68_, "N") == 0) {
											GList* values = NULL;
											EVCardAttribute* _tmp69_ = NULL;
											GList* _tmp70_ = NULL;
											const gchar* family_name = NULL;
											const gchar* given_name = NULL;
											const gchar* additional_names = NULL;
											const gchar* prefixes = NULL;
											const gchar* suffixes = NULL;
											GList* _tmp71_ = NULL;
											GList* _tmp76_ = NULL;
											GList* _tmp81_ = NULL;
											GList* _tmp86_ = NULL;
											GList* _tmp91_ = NULL;
											gboolean _tmp96_ = FALSE;
											const gchar* _tmp97_ = NULL;
											const gchar* _tmp101_ = NULL;
											const gchar* _tmp102_ = NULL;
											const gchar* _tmp103_ = NULL;
											const gchar* _tmp104_ = NULL;
											const gchar* _tmp105_ = NULL;
											FolksStructuredName* _tmp106_ = NULL;
											_tmp69_ = attr;
											_tmp70_ = e_vcard_attribute_get_values (_tmp69_);
											values = _tmp70_;
											family_name = NULL;
											given_name = NULL;
											additional_names = NULL;
											prefixes = NULL;
											suffixes = NULL;
											_tmp71_ = values;
											if (_tmp71_ != NULL) {
												GList* _tmp72_ = NULL;
												gconstpointer _tmp73_ = NULL;
												GList* _tmp74_ = NULL;
												GList* _tmp75_ = NULL;
												_tmp72_ = values;
												_tmp73_ = _tmp72_->data;
												family_name = (const gchar*) _tmp73_;
												_tmp74_ = values;
												_tmp75_ = _tmp74_->next;
												values = _tmp75_;
											}
											_tmp76_ = values;
											if (_tmp76_ != NULL) {
												GList* _tmp77_ = NULL;
												gconstpointer _tmp78_ = NULL;
												GList* _tmp79_ = NULL;
												GList* _tmp80_ = NULL;
												_tmp77_ = values;
												_tmp78_ = _tmp77_->data;
												given_name = (const gchar*) _tmp78_;
												_tmp79_ = values;
												_tmp80_ = _tmp79_->next;
												values = _tmp80_;
											}
											_tmp81_ = values;
											if (_tmp81_ != NULL) {
												GList* _tmp82_ = NULL;
												gconstpointer _tmp83_ = NULL;
												GList* _tmp84_ = NULL;
												GList* _tmp85_ = NULL;
												_tmp82_ = values;
												_tmp83_ = _tmp82_->data;
												additional_names = (const gchar*) _tmp83_;
												_tmp84_ = values;
												_tmp85_ = _tmp84_->next;
												values = _tmp85_;
											}
											_tmp86_ = values;
											if (_tmp86_ != NULL) {
												GList* _tmp87_ = NULL;
												gconstpointer _tmp88_ = NULL;
												GList* _tmp89_ = NULL;
												GList* _tmp90_ = NULL;
												_tmp87_ = values;
												_tmp88_ = _tmp87_->data;
												prefixes = (const gchar*) _tmp88_;
												_tmp89_ = values;
												_tmp90_ = _tmp89_->next;
												values = _tmp90_;
											}
											_tmp91_ = values;
											if (_tmp91_ != NULL) {
												GList* _tmp92_ = NULL;
												gconstpointer _tmp93_ = NULL;
												GList* _tmp94_ = NULL;
												GList* _tmp95_ = NULL;
												_tmp92_ = values;
												_tmp93_ = _tmp92_->data;
												suffixes = (const gchar*) _tmp93_;
												_tmp94_ = values;
												_tmp95_ = _tmp94_->next;
												values = _tmp95_;
											}
											_tmp97_ = suffixes;
											if (_tmp97_ == NULL) {
												_tmp96_ = TRUE;
											} else {
												GList* _tmp98_ = NULL;
												_tmp98_ = values;
												_tmp96_ = _tmp98_ != NULL;
											}
											if (_tmp96_) {
												const gchar* _tmp99_ = NULL;
												const gchar* _tmp100_ = NULL;
												_tmp100_ = suffixes;
												if (_tmp100_ == NULL) {
													_tmp99_ = "fewer";
												} else {
													_tmp99_ = "more";
												}
												g_debug ("Expected 5 components in N attribute of vCard, " "but got %s.", _tmp99_);
											}
											_tmp101_ = family_name;
											_tmp102_ = given_name;
											_tmp103_ = additional_names;
											_tmp104_ = prefixes;
											_tmp105_ = suffixes;
											_tmp106_ = folks_structured_name_new (_tmp101_, _tmp102_, _tmp103_, _tmp104_, _tmp105_);
											_g_object_unref0 (new_structured_name);
											new_structured_name = _tmp106_;
										} else {
											gboolean _tmp107_ = FALSE;
											const gchar* _tmp108_ = NULL;
											_tmp108_ = attr_name;
											if (g_strcmp0 (_tmp108_, "VERSION") != 0) {
												const gchar* _tmp109_ = NULL;
												_tmp109_ = attr_name;
												_tmp107_ = g_strcmp0 (_tmp109_, "UID") != 0;
											} else {
												_tmp107_ = FALSE;
											}
											if (_tmp107_) {
												const gchar* _tmp110_ = NULL;
												const gchar* _tmp111_ = NULL;
												const gchar* _tmp112_ = NULL;
												_tmp110_ = attr_name;
												_tmp111_ = folks_persona_get_uid ((FolksPersona*) self);
												_tmp112_ = _tmp111_;
												g_warning ("bluez-persona.vala:360: Unknown attribute ‘%s’ in vCard for persona %s" \
".", _tmp110_, _tmp112_);
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	g_object_freeze_notify ((GObject*) self);
	_tmp113_ = self->priv->_phone_numbers;
	_tmp114_ = new_phone_numbers;
	_tmp115_ = folks_utils_set_string_afd_equal ((GeeSet*) _tmp113_, (GeeSet*) _tmp114_);
	if (!_tmp115_) {
		FolksSmallSet* _tmp116_ = NULL;
		FolksSmallSet* _tmp117_ = NULL;
		FolksSmallSet* _tmp118_ = NULL;
		GeeSet* _tmp119_ = NULL;
		GeeSet* _tmp120_ = NULL;
		_tmp116_ = new_phone_numbers;
		_tmp117_ = _g_object_ref0 (_tmp116_);
		_g_object_unref0 (self->priv->_phone_numbers);
		self->priv->_phone_numbers = _tmp117_;
		_tmp118_ = new_phone_numbers;
		_tmp119_ = gee_abstract_set_get_read_only_view ((GeeAbstractSet*) _tmp118_);
		_tmp120_ = _tmp119_;
		_g_object_unref0 (self->priv->_phone_numbers_ro);
		self->priv->_phone_numbers_ro = _tmp120_;
		g_object_notify ((GObject*) self, "phone-numbers");
		properties_changed = TRUE;
	}
	_tmp121_ = self->priv->_urls;
	_tmp122_ = new_uris;
	_tmp123_ = folks_internal_equal_sets (FOLKS_TYPE_URL_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, (GeeSet*) _tmp121_, (GeeSet*) _tmp122_);
	if (!_tmp123_) {
		FolksSmallSet* _tmp124_ = NULL;
		FolksSmallSet* _tmp125_ = NULL;
		FolksSmallSet* _tmp126_ = NULL;
		GeeSet* _tmp127_ = NULL;
		GeeSet* _tmp128_ = NULL;
		_tmp124_ = new_uris;
		_tmp125_ = _g_object_ref0 (_tmp124_);
		_g_object_unref0 (self->priv->_urls);
		self->priv->_urls = _tmp125_;
		_tmp126_ = new_uris;
		_tmp127_ = gee_abstract_set_get_read_only_view ((GeeAbstractSet*) _tmp126_);
		_tmp128_ = _tmp127_;
		_g_object_unref0 (self->priv->_urls_ro);
		self->priv->_urls_ro = _tmp128_;
		g_object_notify ((GObject*) self, "urls");
		properties_changed = TRUE;
	}
	_tmp129_ = self->priv->_email_addresses;
	_tmp130_ = new_email_addresses;
	_tmp131_ = folks_internal_equal_sets (FOLKS_TYPE_EMAIL_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, (GeeSet*) _tmp129_, (GeeSet*) _tmp130_);
	if (!_tmp131_) {
		FolksSmallSet* _tmp132_ = NULL;
		FolksSmallSet* _tmp133_ = NULL;
		FolksSmallSet* _tmp134_ = NULL;
		GeeSet* _tmp135_ = NULL;
		GeeSet* _tmp136_ = NULL;
		_tmp132_ = new_email_addresses;
		_tmp133_ = _g_object_ref0 (_tmp132_);
		_g_object_unref0 (self->priv->_email_addresses);
		self->priv->_email_addresses = _tmp133_;
		_tmp134_ = new_email_addresses;
		_tmp135_ = gee_abstract_set_get_read_only_view ((GeeAbstractSet*) _tmp134_);
		_tmp136_ = _tmp135_;
		_g_object_unref0 (self->priv->_email_addresses_ro);
		self->priv->_email_addresses_ro = _tmp136_;
		g_object_notify ((GObject*) self, "email-addresses");
		properties_changed = TRUE;
	}
	_tmp138_ = new_avatar;
	_tmp139_ = self->priv->_avatar;
	if ((_tmp138_ == NULL) != (_tmp139_ == NULL)) {
		_tmp137_ = TRUE;
	} else {
		gboolean _tmp140_ = FALSE;
		gboolean _tmp141_ = FALSE;
		GBytesIcon* _tmp142_ = NULL;
		_tmp142_ = new_avatar;
		if (_tmp142_ != NULL) {
			GLoadableIcon* _tmp143_ = NULL;
			_tmp143_ = self->priv->_avatar;
			_tmp141_ = _tmp143_ != NULL;
		} else {
			_tmp141_ = FALSE;
		}
		if (_tmp141_) {
			GBytesIcon* _tmp144_ = NULL;
			GLoadableIcon* _tmp145_ = NULL;
			gboolean _tmp146_ = FALSE;
			_tmp144_ = new_avatar;
			_tmp145_ = self->priv->_avatar;
			_tmp146_ = g_icon_equal ((GIcon*) _tmp144_, (GIcon*) _tmp145_);
			_tmp140_ = !_tmp146_;
		} else {
			_tmp140_ = FALSE;
		}
		_tmp137_ = _tmp140_;
	}
	if (_tmp137_) {
		GBytesIcon* _tmp147_ = NULL;
		GLoadableIcon* _tmp148_ = NULL;
		_tmp147_ = new_avatar;
		_tmp148_ = _g_object_ref0 ((GLoadableIcon*) _tmp147_);
		_g_object_unref0 (self->priv->_avatar);
		self->priv->_avatar = _tmp148_;
		g_object_notify ((GObject*) self, "avatar");
		properties_changed = TRUE;
	}
	_tmp149_ = self->priv->_full_name;
	_tmp150_ = new_full_name;
	if (g_strcmp0 (_tmp149_, _tmp150_) != 0) {
		const gchar* _tmp151_ = NULL;
		gchar* _tmp152_ = NULL;
		_tmp151_ = new_full_name;
		_tmp152_ = g_strdup (_tmp151_);
		_g_free0 (self->priv->_full_name);
		self->priv->_full_name = _tmp152_;
		g_object_notify ((GObject*) self, "full-name");
		properties_changed = TRUE;
	}
	_tmp153_ = self->priv->_nickname;
	_tmp154_ = new_nickname;
	if (g_strcmp0 (_tmp153_, _tmp154_) != 0) {
		const gchar* _tmp155_ = NULL;
		gchar* _tmp156_ = NULL;
		_tmp155_ = new_nickname;
		_tmp156_ = g_strdup (_tmp155_);
		_g_free0 (self->priv->_nickname);
		self->priv->_nickname = _tmp156_;
		g_object_notify ((GObject*) self, "nickname");
		properties_changed = TRUE;
	}
	_tmp158_ = new_structured_name;
	_tmp159_ = self->priv->_structured_name;
	if ((_tmp158_ == NULL) != (_tmp159_ == NULL)) {
		_tmp157_ = TRUE;
	} else {
		gboolean _tmp160_ = FALSE;
		gboolean _tmp161_ = FALSE;
		FolksStructuredName* _tmp162_ = NULL;
		_tmp162_ = new_structured_name;
		if (_tmp162_ != NULL) {
			FolksStructuredName* _tmp163_ = NULL;
			_tmp163_ = self->priv->_structured_name;
			_tmp161_ = _tmp163_ != NULL;
		} else {
			_tmp161_ = FALSE;
		}
		if (_tmp161_) {
			FolksStructuredName* _tmp164_ = NULL;
			FolksStructuredName* _tmp165_ = NULL;
			gboolean _tmp166_ = FALSE;
			_tmp164_ = new_structured_name;
			_tmp165_ = self->priv->_structured_name;
			_tmp166_ = folks_structured_name_equal (_tmp164_, _tmp165_);
			_tmp160_ = !_tmp166_;
		} else {
			_tmp160_ = FALSE;
		}
		_tmp157_ = _tmp160_;
	}
	if (_tmp157_) {
		FolksStructuredName* _tmp167_ = NULL;
		FolksStructuredName* _tmp168_ = NULL;
		_tmp167_ = new_structured_name;
		_tmp168_ = _g_object_ref0 (_tmp167_);
		_g_object_unref0 (self->priv->_structured_name);
		self->priv->_structured_name = _tmp168_;
		g_object_notify ((GObject*) self, "structured-name");
		properties_changed = TRUE;
	}
	g_object_thaw_notify ((GObject*) self);
	result = properties_changed;
	_g_object_unref0 (new_structured_name);
	_g_free0 (new_nickname);
	_g_free0 (new_full_name);
	_g_object_unref0 (new_avatar);
	_g_object_unref0 (new_email_addresses);
	_g_object_unref0 (new_uris);
	_g_object_unref0 (new_phone_numbers);
	return result;
}


/**
   * {@inheritDoc}
   *
   * @since 0.9.6
   */
static void folks_backends_blue_z_persona_real_linkable_property_to_links (FolksPersona* base, const gchar* prop_name, FolksPersonaLinkablePropertyCallback callback, void* callback_target) {
	FolksBackendsBlueZPersona * self;
	const gchar* _tmp0_ = NULL;
	self = (FolksBackendsBlueZPersona*) base;
	g_return_if_fail (prop_name != NULL);
	_tmp0_ = prop_name;
	if (g_strcmp0 (_tmp0_, "phone-numbers") == 0) {
		{
			FolksSmallSet* _phone_number_list = NULL;
			FolksSmallSet* _tmp1_ = NULL;
			FolksSmallSet* _tmp2_ = NULL;
			gint _phone_number_size = 0;
			FolksSmallSet* _tmp3_ = NULL;
			gint _tmp4_ = 0;
			gint _tmp5_ = 0;
			gint _phone_number_index = 0;
			_tmp1_ = self->priv->_phone_numbers;
			_tmp2_ = _g_object_ref0 (_tmp1_);
			_phone_number_list = _tmp2_;
			_tmp3_ = _phone_number_list;
			_tmp4_ = gee_collection_get_size ((GeeCollection*) _tmp3_);
			_tmp5_ = _tmp4_;
			_phone_number_size = _tmp5_;
			_phone_number_index = -1;
			while (TRUE) {
				gint _tmp6_ = 0;
				gint _tmp7_ = 0;
				gint _tmp8_ = 0;
				FolksPhoneFieldDetails* phone_number = NULL;
				FolksSmallSet* _tmp9_ = NULL;
				gint _tmp10_ = 0;
				gconstpointer _tmp11_ = NULL;
				FolksPhoneFieldDetails* _tmp12_ = NULL;
				FolksPhoneFieldDetails* _tmp13_ = NULL;
				gconstpointer _tmp14_ = NULL;
				const gchar* _tmp15_ = NULL;
				_tmp6_ = _phone_number_index;
				_phone_number_index = _tmp6_ + 1;
				_tmp7_ = _phone_number_index;
				_tmp8_ = _phone_number_size;
				if (!(_tmp7_ < _tmp8_)) {
					break;
				}
				_tmp9_ = _phone_number_list;
				_tmp10_ = _phone_number_index;
				_tmp11_ = folks_small_set_get (_tmp9_, _tmp10_);
				_tmp12_ = _g_object_ref0 ((FolksPhoneFieldDetails*) _tmp11_);
				phone_number = _tmp12_;
				_tmp13_ = phone_number;
				_tmp14_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp13_);
				_tmp15_ = _tmp14_;
				if (((const gchar*) _tmp15_) != NULL) {
					FolksPersonaLinkablePropertyCallback _tmp16_ = NULL;
					void* _tmp16__target = NULL;
					FolksPhoneFieldDetails* _tmp17_ = NULL;
					gconstpointer _tmp18_ = NULL;
					const gchar* _tmp19_ = NULL;
					_tmp16_ = callback;
					_tmp16__target = callback_target;
					_tmp17_ = phone_number;
					_tmp18_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp17_);
					_tmp19_ = _tmp18_;
					_tmp16_ ((const gchar*) _tmp19_, _tmp16__target);
				}
				_g_object_unref0 (phone_number);
			}
			_g_object_unref0 (_phone_number_list);
		}
	} else {
		const gchar* _tmp20_ = NULL;
		_tmp20_ = prop_name;
		if (g_strcmp0 (_tmp20_, "email-addresses") == 0) {
			{
				FolksSmallSet* _email_address_list = NULL;
				FolksSmallSet* _tmp21_ = NULL;
				FolksSmallSet* _tmp22_ = NULL;
				gint _email_address_size = 0;
				FolksSmallSet* _tmp23_ = NULL;
				gint _tmp24_ = 0;
				gint _tmp25_ = 0;
				gint _email_address_index = 0;
				_tmp21_ = self->priv->_email_addresses;
				_tmp22_ = _g_object_ref0 (_tmp21_);
				_email_address_list = _tmp22_;
				_tmp23_ = _email_address_list;
				_tmp24_ = gee_collection_get_size ((GeeCollection*) _tmp23_);
				_tmp25_ = _tmp24_;
				_email_address_size = _tmp25_;
				_email_address_index = -1;
				while (TRUE) {
					gint _tmp26_ = 0;
					gint _tmp27_ = 0;
					gint _tmp28_ = 0;
					FolksEmailFieldDetails* email_address = NULL;
					FolksSmallSet* _tmp29_ = NULL;
					gint _tmp30_ = 0;
					gconstpointer _tmp31_ = NULL;
					FolksEmailFieldDetails* _tmp32_ = NULL;
					FolksEmailFieldDetails* _tmp33_ = NULL;
					gconstpointer _tmp34_ = NULL;
					const gchar* _tmp35_ = NULL;
					_tmp26_ = _email_address_index;
					_email_address_index = _tmp26_ + 1;
					_tmp27_ = _email_address_index;
					_tmp28_ = _email_address_size;
					if (!(_tmp27_ < _tmp28_)) {
						break;
					}
					_tmp29_ = _email_address_list;
					_tmp30_ = _email_address_index;
					_tmp31_ = folks_small_set_get (_tmp29_, _tmp30_);
					_tmp32_ = _g_object_ref0 ((FolksEmailFieldDetails*) _tmp31_);
					email_address = _tmp32_;
					_tmp33_ = email_address;
					_tmp34_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp33_);
					_tmp35_ = _tmp34_;
					if (((const gchar*) _tmp35_) != NULL) {
						FolksPersonaLinkablePropertyCallback _tmp36_ = NULL;
						void* _tmp36__target = NULL;
						FolksEmailFieldDetails* _tmp37_ = NULL;
						gconstpointer _tmp38_ = NULL;
						const gchar* _tmp39_ = NULL;
						_tmp36_ = callback;
						_tmp36__target = callback_target;
						_tmp37_ = email_address;
						_tmp38_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp37_);
						_tmp39_ = _tmp38_;
						_tmp36_ ((const gchar*) _tmp39_, _tmp36__target);
					}
					_g_object_unref0 (email_address);
				}
				_g_object_unref0 (_email_address_list);
			}
		} else {
			const gchar* _tmp40_ = NULL;
			FolksPersonaLinkablePropertyCallback _tmp41_ = NULL;
			void* _tmp41__target = NULL;
			_tmp40_ = prop_name;
			_tmp41_ = callback;
			_tmp41__target = callback_target;
			FOLKS_PERSONA_CLASS (folks_backends_blue_z_persona_parent_class)->linkable_property_to_links (G_TYPE_CHECK_INSTANCE_CAST (self, FOLKS_TYPE_PERSONA, FolksPersona), _tmp40_, _tmp41_, _tmp41__target);
		}
	}
}


static gchar** folks_backends_blue_z_persona_real_get_linkable_properties (FolksPersona* base, int* result_length1) {
	gchar** result;
	FolksBackendsBlueZPersona* self;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	self = (FolksBackendsBlueZPersona*) base;
	_tmp0_ = FOLKS_BACKENDS_BLUE_Z_PERSONA__linkable_properties;
	_tmp0__length1 = G_N_ELEMENTS (FOLKS_BACKENDS_BLUE_Z_PERSONA__linkable_properties);
	if (result_length1) {
		*result_length1 = _tmp0__length1;
	}
	result = _tmp0_;
	return result;
}


static GeeSet* folks_backends_blue_z_persona_real_get_urls (FolksUrlDetails* base) {
	GeeSet* result;
	FolksBackendsBlueZPersona* self;
	GeeSet* _tmp0_ = NULL;
	self = (FolksBackendsBlueZPersona*) base;
	_tmp0_ = self->priv->_urls_ro;
	result = _tmp0_;
	return result;
}


static void folks_backends_blue_z_persona_real_set_urls (FolksUrlDetails* base, GeeSet* value) {
	FolksBackendsBlueZPersona* self;
	GeeSet* _tmp0_ = NULL;
	self = (FolksBackendsBlueZPersona*) base;
	_tmp0_ = value;
	folks_url_details_change_urls ((FolksUrlDetails*) self, _tmp0_, NULL, NULL);
}


static GLoadableIcon* folks_backends_blue_z_persona_real_get_avatar (FolksAvatarDetails* base) {
	GLoadableIcon* result;
	FolksBackendsBlueZPersona* self;
	GLoadableIcon* _tmp0_ = NULL;
	self = (FolksBackendsBlueZPersona*) base;
	_tmp0_ = self->priv->_avatar;
	result = _tmp0_;
	return result;
}


static void folks_backends_blue_z_persona_real_set_avatar (FolksAvatarDetails* base, GLoadableIcon* value) {
	FolksBackendsBlueZPersona* self;
	GLoadableIcon* _tmp0_ = NULL;
	self = (FolksBackendsBlueZPersona*) base;
	_tmp0_ = value;
	folks_avatar_details_change_avatar ((FolksAvatarDetails*) self, _tmp0_, NULL, NULL);
}


static gchar** folks_backends_blue_z_persona_real_get_writeable_properties (FolksPersona* base, int* result_length1) {
	gchar** result;
	FolksBackendsBlueZPersona* self;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	self = (FolksBackendsBlueZPersona*) base;
	_tmp0_ = folks_backends_blue_z_persona__writeable_properties;
	_tmp0__length1 = folks_backends_blue_z_persona__writeable_properties_length1;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}


static GeeSet* folks_backends_blue_z_persona_real_get_phone_numbers (FolksPhoneDetails* base) {
	GeeSet* result;
	FolksBackendsBlueZPersona* self;
	GeeSet* _tmp0_ = NULL;
	self = (FolksBackendsBlueZPersona*) base;
	_tmp0_ = self->priv->_phone_numbers_ro;
	result = _tmp0_;
	return result;
}


static void folks_backends_blue_z_persona_real_set_phone_numbers (FolksPhoneDetails* base, GeeSet* value) {
	FolksBackendsBlueZPersona* self;
	GeeSet* _tmp0_ = NULL;
	self = (FolksBackendsBlueZPersona*) base;
	_tmp0_ = value;
	folks_phone_details_change_phone_numbers ((FolksPhoneDetails*) self, _tmp0_, NULL, NULL);
}


static FolksStructuredName* folks_backends_blue_z_persona_real_get_structured_name (FolksNameDetails* base) {
	FolksStructuredName* result;
	FolksBackendsBlueZPersona* self;
	FolksStructuredName* _tmp0_ = NULL;
	self = (FolksBackendsBlueZPersona*) base;
	_tmp0_ = self->priv->_structured_name;
	result = _tmp0_;
	return result;
}


static void folks_backends_blue_z_persona_real_set_structured_name (FolksNameDetails* base, FolksStructuredName* value) {
	FolksBackendsBlueZPersona* self;
	FolksStructuredName* _tmp0_ = NULL;
	self = (FolksBackendsBlueZPersona*) base;
	_tmp0_ = value;
	folks_name_details_change_structured_name ((FolksNameDetails*) self, _tmp0_, NULL, NULL);
}


static const gchar* folks_backends_blue_z_persona_real_get_full_name (FolksNameDetails* base) {
	const gchar* result;
	FolksBackendsBlueZPersona* self;
	const gchar* _tmp0_ = NULL;
	self = (FolksBackendsBlueZPersona*) base;
	_tmp0_ = self->priv->_full_name;
	result = _tmp0_;
	return result;
}


static void folks_backends_blue_z_persona_real_set_full_name (FolksNameDetails* base, const gchar* value) {
	FolksBackendsBlueZPersona* self;
	const gchar* _tmp0_ = NULL;
	self = (FolksBackendsBlueZPersona*) base;
	_tmp0_ = value;
	folks_name_details_change_full_name ((FolksNameDetails*) self, _tmp0_, NULL, NULL);
}


static const gchar* folks_backends_blue_z_persona_real_get_nickname (FolksNameDetails* base) {
	const gchar* result;
	FolksBackendsBlueZPersona* self;
	const gchar* _tmp0_ = NULL;
	self = (FolksBackendsBlueZPersona*) base;
	_tmp0_ = self->priv->_nickname;
	result = _tmp0_;
	return result;
}


static void folks_backends_blue_z_persona_real_set_nickname (FolksNameDetails* base, const gchar* value) {
	FolksBackendsBlueZPersona* self;
	const gchar* _tmp0_ = NULL;
	self = (FolksBackendsBlueZPersona*) base;
	_tmp0_ = value;
	folks_name_details_change_nickname ((FolksNameDetails*) self, _tmp0_, NULL, NULL);
}


static GeeSet* folks_backends_blue_z_persona_real_get_email_addresses (FolksEmailDetails* base) {
	GeeSet* result;
	FolksBackendsBlueZPersona* self;
	GeeSet* _tmp0_ = NULL;
	self = (FolksBackendsBlueZPersona*) base;
	_tmp0_ = self->priv->_email_addresses_ro;
	result = _tmp0_;
	return result;
}


static void folks_backends_blue_z_persona_real_set_email_addresses (FolksEmailDetails* base, GeeSet* value) {
	FolksBackendsBlueZPersona* self;
	GeeSet* _tmp0_ = NULL;
	self = (FolksBackendsBlueZPersona*) base;
	_tmp0_ = value;
	folks_email_details_change_email_addresses ((FolksEmailDetails*) self, _tmp0_, NULL, NULL);
}


static GObject * folks_backends_blue_z_persona_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	FolksBackendsBlueZPersona * self;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	FolksSmallSet* _tmp4_ = NULL;
	FolksSmallSet* _tmp5_ = NULL;
	GeeSet* _tmp6_ = NULL;
	GeeSet* _tmp7_ = NULL;
	FolksSmallSet* _tmp8_ = NULL;
	FolksSmallSet* _tmp9_ = NULL;
	GeeSet* _tmp10_ = NULL;
	GeeSet* _tmp11_ = NULL;
	FolksSmallSet* _tmp12_ = NULL;
	FolksSmallSet* _tmp13_ = NULL;
	GeeSet* _tmp14_ = NULL;
	GeeSet* _tmp15_ = NULL;
	parent_class = G_OBJECT_CLASS (folks_backends_blue_z_persona_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FOLKS_BACKENDS_BLUE_Z_TYPE_PERSONA, FolksBackendsBlueZPersona);
	_tmp0_ = folks_persona_get_uid ((FolksPersona*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = folks_persona_get_iid ((FolksPersona*) self);
	_tmp3_ = _tmp2_;
	g_debug ("bluez-persona.vala:204: Adding BlueZ Persona '%s' (IID '%s')", _tmp1_, _tmp3_);
	_tmp4_ = folks_small_set_new (FOLKS_TYPE_PHONE_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, _folks_abstract_field_details_hash_static_gee_hash_data_func, NULL, NULL, _folks_abstract_field_details_equal_static_gee_equal_data_func, NULL, NULL);
	_g_object_unref0 (self->priv->_phone_numbers);
	self->priv->_phone_numbers = _tmp4_;
	_tmp5_ = self->priv->_phone_numbers;
	_tmp6_ = gee_abstract_set_get_read_only_view ((GeeAbstractSet*) _tmp5_);
	_tmp7_ = _tmp6_;
	_g_object_unref0 (self->priv->_phone_numbers_ro);
	self->priv->_phone_numbers_ro = _tmp7_;
	_tmp8_ = folks_small_set_new (FOLKS_TYPE_EMAIL_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, _folks_abstract_field_details_hash_static_gee_hash_data_func, NULL, NULL, _folks_abstract_field_details_equal_static_gee_equal_data_func, NULL, NULL);
	_g_object_unref0 (self->priv->_email_addresses);
	self->priv->_email_addresses = _tmp8_;
	_tmp9_ = self->priv->_email_addresses;
	_tmp10_ = gee_abstract_set_get_read_only_view ((GeeAbstractSet*) _tmp9_);
	_tmp11_ = _tmp10_;
	_g_object_unref0 (self->priv->_email_addresses_ro);
	self->priv->_email_addresses_ro = _tmp11_;
	_tmp12_ = folks_small_set_new (FOLKS_TYPE_URL_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, _folks_abstract_field_details_hash_static_gee_hash_data_func, NULL, NULL, _folks_abstract_field_details_equal_static_gee_equal_data_func, NULL, NULL);
	_g_object_unref0 (self->priv->_urls);
	self->priv->_urls = _tmp12_;
	_tmp13_ = self->priv->_urls;
	_tmp14_ = gee_abstract_set_get_read_only_view ((GeeAbstractSet*) _tmp13_);
	_tmp15_ = _tmp14_;
	_g_object_unref0 (self->priv->_urls_ro);
	self->priv->_urls_ro = _tmp15_;
	return obj;
}


static void folks_backends_blue_z_persona_class_init (FolksBackendsBlueZPersonaClass * klass) {
	gchar** _tmp0_ = NULL;
	folks_backends_blue_z_persona_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (FolksBackendsBlueZPersonaPrivate));
	((FolksPersonaClass *) klass)->linkable_property_to_links = folks_backends_blue_z_persona_real_linkable_property_to_links;
	FOLKS_PERSONA_CLASS (klass)->get_linkable_properties = folks_backends_blue_z_persona_real_get_linkable_properties;
	FOLKS_PERSONA_CLASS (klass)->get_writeable_properties = folks_backends_blue_z_persona_real_get_writeable_properties;
	G_OBJECT_CLASS (klass)->get_property = _vala_folks_backends_blue_z_persona_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_folks_backends_blue_z_persona_set_property;
	G_OBJECT_CLASS (klass)->constructor = folks_backends_blue_z_persona_constructor;
	G_OBJECT_CLASS (klass)->finalize = folks_backends_blue_z_persona_finalize;
	/**
	   * {@inheritDoc}
	   *
	   * @since 0.9.6
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_BLUE_Z_PERSONA_LINKABLE_PROPERTIES, g_param_spec_boxed ("linkable-properties", "linkable-properties", "linkable-properties", G_TYPE_STRV, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * {@inheritDoc}
	   *
	   * @since 0.9.6
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_BLUE_Z_PERSONA_URLS, g_param_spec_object ("urls", "urls", "urls", GEE_TYPE_SET, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	  * {@inheritDoc}
	  *
	  * @since 0.9.6
	  */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_BLUE_Z_PERSONA_AVATAR, g_param_spec_object ("avatar", "avatar", "avatar", g_loadable_icon_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	  * {@inheritDoc}
	  *
	  * @since 0.9.6
	  */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_BLUE_Z_PERSONA_WRITEABLE_PROPERTIES, g_param_spec_boxed ("writeable-properties", "writeable-properties", "writeable-properties", G_TYPE_STRV, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * {@inheritDoc}
	   *
	   * @since 0.9.6
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_BLUE_Z_PERSONA_PHONE_NUMBERS, g_param_spec_object ("phone-numbers", "phone-numbers", "phone-numbers", GEE_TYPE_SET, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * {@inheritDoc}
	   *
	   * @since 0.9.6
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_BLUE_Z_PERSONA_STRUCTURED_NAME, g_param_spec_object ("structured-name", "structured-name", "structured-name", FOLKS_TYPE_STRUCTURED_NAME, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * {@inheritDoc}
	   *
	   * @since 0.9.6
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_BLUE_Z_PERSONA_FULL_NAME, g_param_spec_string ("full-name", "full-name", "full-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * {@inheritDoc}
	   *
	   * @since 0.9.6
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_BLUE_Z_PERSONA_NICKNAME, g_param_spec_string ("nickname", "nickname", "nickname", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * {@inheritDoc}
	   *
	   * @since 0.9.6
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_BLUE_Z_PERSONA_EMAIL_ADDRESSES, g_param_spec_object ("email-addresses", "email-addresses", "email-addresses", GEE_TYPE_SET, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	folks_backends_blue_z_persona__writeable_properties = _tmp0_;
	folks_backends_blue_z_persona__writeable_properties_length1 = 0;
}


static void folks_backends_blue_z_persona_folks_avatar_details_interface_init (FolksAvatarDetailsIface * iface) {
	folks_backends_blue_z_persona_folks_avatar_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_avatar = folks_backends_blue_z_persona_real_get_avatar;
	iface->set_avatar = folks_backends_blue_z_persona_real_set_avatar;
}


static void folks_backends_blue_z_persona_folks_email_details_interface_init (FolksEmailDetailsIface * iface) {
	folks_backends_blue_z_persona_folks_email_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_email_addresses = folks_backends_blue_z_persona_real_get_email_addresses;
	iface->set_email_addresses = folks_backends_blue_z_persona_real_set_email_addresses;
}


static void folks_backends_blue_z_persona_folks_name_details_interface_init (FolksNameDetailsIface * iface) {
	folks_backends_blue_z_persona_folks_name_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_structured_name = folks_backends_blue_z_persona_real_get_structured_name;
	iface->set_structured_name = folks_backends_blue_z_persona_real_set_structured_name;
	iface->get_full_name = folks_backends_blue_z_persona_real_get_full_name;
	iface->set_full_name = folks_backends_blue_z_persona_real_set_full_name;
	iface->get_nickname = folks_backends_blue_z_persona_real_get_nickname;
	iface->set_nickname = folks_backends_blue_z_persona_real_set_nickname;
}


static void folks_backends_blue_z_persona_folks_phone_details_interface_init (FolksPhoneDetailsIface * iface) {
	folks_backends_blue_z_persona_folks_phone_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_phone_numbers = folks_backends_blue_z_persona_real_get_phone_numbers;
	iface->set_phone_numbers = folks_backends_blue_z_persona_real_set_phone_numbers;
}


static void folks_backends_blue_z_persona_folks_url_details_interface_init (FolksUrlDetailsIface * iface) {
	folks_backends_blue_z_persona_folks_url_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_urls = folks_backends_blue_z_persona_real_get_urls;
	iface->set_urls = folks_backends_blue_z_persona_real_set_urls;
}


static void folks_backends_blue_z_persona_instance_init (FolksBackendsBlueZPersona * self) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	self->priv = FOLKS_BACKENDS_BLUE_Z_PERSONA_GET_PRIVATE (self);
	self->priv->_urls = NULL;
	self->priv->_avatar = NULL;
	self->priv->_phone_numbers = NULL;
	self->priv->_structured_name = NULL;
	_tmp0_ = g_strdup ("");
	self->priv->_full_name = _tmp0_;
	_tmp1_ = g_strdup ("");
	self->priv->_nickname = _tmp1_;
	self->priv->_email_addresses = NULL;
}


static void folks_backends_blue_z_persona_finalize (GObject* obj) {
	FolksBackendsBlueZPersona * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FOLKS_BACKENDS_BLUE_Z_TYPE_PERSONA, FolksBackendsBlueZPersona);
	_g_object_unref0 (self->priv->_urls);
	_g_object_unref0 (self->priv->_urls_ro);
	_g_object_unref0 (self->priv->_avatar);
	_g_object_unref0 (self->priv->_phone_numbers);
	_g_object_unref0 (self->priv->_phone_numbers_ro);
	_g_object_unref0 (self->priv->_structured_name);
	_g_free0 (self->priv->_full_name);
	_g_free0 (self->priv->_nickname);
	_g_object_unref0 (self->priv->_email_addresses);
	_g_object_unref0 (self->priv->_email_addresses_ro);
	G_OBJECT_CLASS (folks_backends_blue_z_persona_parent_class)->finalize (obj);
}


/**
 * A persona subclass which represents a single persona from a simple key file.
 *
 * @since 0.9.6
 */
GType folks_backends_blue_z_persona_get_type (void) {
	static volatile gsize folks_backends_blue_z_persona_type_id__volatile = 0;
	if (g_once_init_enter (&folks_backends_blue_z_persona_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksBackendsBlueZPersonaClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_backends_blue_z_persona_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksBackendsBlueZPersona), 0, (GInstanceInitFunc) folks_backends_blue_z_persona_instance_init, NULL };
		static const GInterfaceInfo folks_avatar_details_info = { (GInterfaceInitFunc) folks_backends_blue_z_persona_folks_avatar_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_email_details_info = { (GInterfaceInitFunc) folks_backends_blue_z_persona_folks_email_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_name_details_info = { (GInterfaceInitFunc) folks_backends_blue_z_persona_folks_name_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_phone_details_info = { (GInterfaceInitFunc) folks_backends_blue_z_persona_folks_phone_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_url_details_info = { (GInterfaceInitFunc) folks_backends_blue_z_persona_folks_url_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType folks_backends_blue_z_persona_type_id;
		folks_backends_blue_z_persona_type_id = g_type_register_static (FOLKS_TYPE_PERSONA, "FolksBackendsBlueZPersona", &g_define_type_info, 0);
		g_type_add_interface_static (folks_backends_blue_z_persona_type_id, FOLKS_TYPE_AVATAR_DETAILS, &folks_avatar_details_info);
		g_type_add_interface_static (folks_backends_blue_z_persona_type_id, FOLKS_TYPE_EMAIL_DETAILS, &folks_email_details_info);
		g_type_add_interface_static (folks_backends_blue_z_persona_type_id, FOLKS_TYPE_NAME_DETAILS, &folks_name_details_info);
		g_type_add_interface_static (folks_backends_blue_z_persona_type_id, FOLKS_TYPE_PHONE_DETAILS, &folks_phone_details_info);
		g_type_add_interface_static (folks_backends_blue_z_persona_type_id, FOLKS_TYPE_URL_DETAILS, &folks_url_details_info);
		g_once_init_leave (&folks_backends_blue_z_persona_type_id__volatile, folks_backends_blue_z_persona_type_id);
	}
	return folks_backends_blue_z_persona_type_id__volatile;
}


static void _vala_folks_backends_blue_z_persona_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	FolksBackendsBlueZPersona * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FOLKS_BACKENDS_BLUE_Z_TYPE_PERSONA, FolksBackendsBlueZPersona);
	switch (property_id) {
		case FOLKS_BACKENDS_BLUE_Z_PERSONA_LINKABLE_PROPERTIES:
		{
			int length;
			g_value_set_boxed (value, folks_persona_get_linkable_properties ((FolksPersona*) self, &length));
		}
		break;
		case FOLKS_BACKENDS_BLUE_Z_PERSONA_URLS:
		g_value_set_object (value, folks_url_details_get_urls ((FolksUrlDetails*) self));
		break;
		case FOLKS_BACKENDS_BLUE_Z_PERSONA_AVATAR:
		g_value_set_object (value, folks_avatar_details_get_avatar ((FolksAvatarDetails*) self));
		break;
		case FOLKS_BACKENDS_BLUE_Z_PERSONA_WRITEABLE_PROPERTIES:
		{
			int length;
			g_value_set_boxed (value, folks_persona_get_writeable_properties ((FolksPersona*) self, &length));
		}
		break;
		case FOLKS_BACKENDS_BLUE_Z_PERSONA_PHONE_NUMBERS:
		g_value_set_object (value, folks_phone_details_get_phone_numbers ((FolksPhoneDetails*) self));
		break;
		case FOLKS_BACKENDS_BLUE_Z_PERSONA_STRUCTURED_NAME:
		g_value_set_object (value, folks_name_details_get_structured_name ((FolksNameDetails*) self));
		break;
		case FOLKS_BACKENDS_BLUE_Z_PERSONA_FULL_NAME:
		g_value_set_string (value, folks_name_details_get_full_name ((FolksNameDetails*) self));
		break;
		case FOLKS_BACKENDS_BLUE_Z_PERSONA_NICKNAME:
		g_value_set_string (value, folks_name_details_get_nickname ((FolksNameDetails*) self));
		break;
		case FOLKS_BACKENDS_BLUE_Z_PERSONA_EMAIL_ADDRESSES:
		g_value_set_object (value, folks_email_details_get_email_addresses ((FolksEmailDetails*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_folks_backends_blue_z_persona_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	FolksBackendsBlueZPersona * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FOLKS_BACKENDS_BLUE_Z_TYPE_PERSONA, FolksBackendsBlueZPersona);
	switch (property_id) {
		case FOLKS_BACKENDS_BLUE_Z_PERSONA_URLS:
		folks_url_details_set_urls ((FolksUrlDetails*) self, g_value_get_object (value));
		break;
		case FOLKS_BACKENDS_BLUE_Z_PERSONA_AVATAR:
		folks_avatar_details_set_avatar ((FolksAvatarDetails*) self, g_value_get_object (value));
		break;
		case FOLKS_BACKENDS_BLUE_Z_PERSONA_PHONE_NUMBERS:
		folks_phone_details_set_phone_numbers ((FolksPhoneDetails*) self, g_value_get_object (value));
		break;
		case FOLKS_BACKENDS_BLUE_Z_PERSONA_STRUCTURED_NAME:
		folks_name_details_set_structured_name ((FolksNameDetails*) self, g_value_get_object (value));
		break;
		case FOLKS_BACKENDS_BLUE_Z_PERSONA_FULL_NAME:
		folks_name_details_set_full_name ((FolksNameDetails*) self, g_value_get_string (value));
		break;
		case FOLKS_BACKENDS_BLUE_Z_PERSONA_NICKNAME:
		folks_name_details_set_nickname ((FolksNameDetails*) self, g_value_get_string (value));
		break;
		case FOLKS_BACKENDS_BLUE_Z_PERSONA_EMAIL_ADDRESSES:
		folks_email_details_set_email_addresses ((FolksEmailDetails*) self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



