/* math-window.c generated by valac 0.24.0, the Vala compiler
 * generated from math-window.vala, do not modify */

/*
 * Copyright (C) 1987-2008 Sun Microsystems, Inc. All Rights Reserved.
 * Copyright (C) 2008-2012 Robert Ancell.
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gtksourceview/gtksource.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>


#define TYPE_MATH_WINDOW (math_window_get_type ())
#define MATH_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_WINDOW, MathWindow))
#define MATH_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_WINDOW, MathWindowClass))
#define IS_MATH_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_WINDOW))
#define IS_MATH_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_WINDOW))
#define MATH_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_WINDOW, MathWindowClass))

typedef struct _MathWindow MathWindow;
typedef struct _MathWindowClass MathWindowClass;
typedef struct _MathWindowPrivate MathWindowPrivate;

#define TYPE_MATH_EQUATION (math_equation_get_type ())
#define MATH_EQUATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_EQUATION, MathEquation))
#define MATH_EQUATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_EQUATION, MathEquationClass))
#define IS_MATH_EQUATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_EQUATION))
#define IS_MATH_EQUATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_EQUATION))
#define MATH_EQUATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_EQUATION, MathEquationClass))

typedef struct _MathEquation MathEquation;
typedef struct _MathEquationClass MathEquationClass;

#define TYPE_MATH_DISPLAY (math_display_get_type ())
#define MATH_DISPLAY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_DISPLAY, MathDisplay))
#define MATH_DISPLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_DISPLAY, MathDisplayClass))
#define IS_MATH_DISPLAY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_DISPLAY))
#define IS_MATH_DISPLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_DISPLAY))
#define MATH_DISPLAY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_DISPLAY, MathDisplayClass))

typedef struct _MathDisplay MathDisplay;
typedef struct _MathDisplayClass MathDisplayClass;

#define TYPE_MATH_BUTTONS (math_buttons_get_type ())
#define MATH_BUTTONS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_BUTTONS, MathButtons))
#define MATH_BUTTONS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_BUTTONS, MathButtonsClass))
#define IS_MATH_BUTTONS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_BUTTONS))
#define IS_MATH_BUTTONS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_BUTTONS))
#define MATH_BUTTONS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_BUTTONS, MathButtonsClass))

typedef struct _MathButtons MathButtons;
typedef struct _MathButtonsClass MathButtonsClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_BUTTON_MODE (button_mode_get_type ())
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _MathWindow {
	GtkApplicationWindow parent_instance;
	MathWindowPrivate * priv;
};

struct _MathWindowClass {
	GtkApplicationWindowClass parent_class;
};

struct _MathWindowPrivate {
	MathEquation* _equation;
	MathDisplay* _display;
	MathButtons* _buttons;
	gboolean right_aligned;
	GtkHeaderBar* headerbar;
};

typedef enum  {
	BUTTON_MODE_BASIC,
	BUTTON_MODE_ADVANCED,
	BUTTON_MODE_FINANCIAL,
	BUTTON_MODE_PROGRAMMING
} ButtonMode;


static gpointer math_window_parent_class = NULL;

GType math_window_get_type (void) G_GNUC_CONST;
GType math_equation_get_type (void) G_GNUC_CONST;
GType math_display_get_type (void) G_GNUC_CONST;
GType math_buttons_get_type (void) G_GNUC_CONST;
#define MATH_WINDOW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MATH_WINDOW, MathWindowPrivate))
enum  {
	MATH_WINDOW_DUMMY_PROPERTY,
	MATH_WINDOW_EQUATION,
	MATH_WINDOW_DISPLAY,
	MATH_WINDOW_BUTTONS
};
static void math_window_copy_cb (MathWindow* self);
static void _math_window_copy_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void math_window_paste_cb (MathWindow* self);
static void _math_window_paste_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void math_window_undo_cb (MathWindow* self);
static void _math_window_undo_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void math_window_redo_cb (MathWindow* self);
static void _math_window_redo_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void math_window_mode_cb (MathWindow* self, GSimpleAction* action, GVariant* parameter);
static void _math_window_mode_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
MathWindow* math_window_new (GtkApplication* app, MathEquation* equation);
MathWindow* math_window_construct (GType object_type, GtkApplication* app, MathEquation* equation);
static void math_window_scroll_changed_cb (MathWindow* self, GtkAdjustment* adjustment);
static void _math_window_scroll_changed_cb_gtk_adjustment_changed (GtkAdjustment* _sender, gpointer self);
static void math_window_scroll_value_changed_cb (MathWindow* self, GtkAdjustment* adjustment);
static void _math_window_scroll_value_changed_cb_gtk_adjustment_value_changed (GtkAdjustment* _sender, gpointer self);
MathDisplay* math_display_new (MathEquation* equation);
MathDisplay* math_display_construct (GType object_type, MathEquation* equation);
MathDisplay* math_window_get_display (MathWindow* self);
MathButtons* math_buttons_new (MathEquation* equation);
MathButtons* math_buttons_construct (GType object_type, MathEquation* equation);
MathButtons* math_window_get_buttons (MathWindow* self);
static void math_window_mode_changed_cb (MathWindow* self);
static void _math_window_mode_changed_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
GType button_mode_get_type (void) G_GNUC_CONST;
ButtonMode math_buttons_get_mode (MathButtons* self);
void math_window_critical_error (MathWindow* self, const gchar* title, const gchar* contents);
static gboolean math_window_real_key_press_event (GtkWidget* base, GdkEventKey* event);
MathEquation* math_window_get_equation (MathWindow* self);
void math_equation_set_number_base (MathEquation* self, gint value);
void math_equation_copy (MathEquation* self);
void math_equation_paste (MathEquation* self);
void math_buttons_set_mode (MathButtons* self, ButtonMode value);
static void math_window_finalize (GObject* obj);
static void _vala_math_window_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);

static const GActionEntry MATH_WINDOW_window_entries[5] = {{"copy", _math_window_copy_cb_gsimple_action_activate_callback, NULL, NULL, NULL}, {"paste", _math_window_paste_cb_gsimple_action_activate_callback, NULL, NULL, NULL}, {"undo", _math_window_undo_cb_gsimple_action_activate_callback, NULL, NULL, NULL}, {"redo", _math_window_redo_cb_gsimple_action_activate_callback, NULL, NULL, NULL}, {"mode", _math_window_mode_cb_gsimple_action_activate_callback, "s", "\"basic\"", NULL}};

static void _math_window_copy_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	math_window_copy_cb ((MathWindow*) self);
}


static void _math_window_paste_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	math_window_paste_cb ((MathWindow*) self);
}


static void _math_window_undo_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	math_window_undo_cb ((MathWindow*) self);
}


static void _math_window_redo_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	math_window_redo_cb ((MathWindow*) self);
}


static void _math_window_mode_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	math_window_mode_cb ((MathWindow*) self, action, parameter);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _math_window_scroll_changed_cb_gtk_adjustment_changed (GtkAdjustment* _sender, gpointer self) {
	math_window_scroll_changed_cb ((MathWindow*) self, _sender);
}


static void _math_window_scroll_value_changed_cb_gtk_adjustment_value_changed (GtkAdjustment* _sender, gpointer self) {
	math_window_scroll_value_changed_cb ((MathWindow*) self, _sender);
}


static void _math_window_mode_changed_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	math_window_mode_changed_cb ((MathWindow*) self);
}


MathWindow* math_window_construct (GType object_type, GtkApplication* app, MathEquation* equation) {
	MathWindow * self = NULL;
	GtkApplication* _tmp0_ = NULL;
	MathEquation* _tmp1_ = NULL;
	MathEquation* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	GtkBuilder* builder = NULL;
	GtkBuilder* _tmp4_ = NULL;
	GMenuModel* menu = NULL;
	GObject* _tmp6_ = NULL;
	GMenuModel* _tmp7_ = NULL;
	GtkMenuButton* gear_menu_button = NULL;
	GtkMenuButton* _tmp8_ = NULL;
	GtkImage* _tmp9_ = NULL;
	GtkImage* _tmp10_ = NULL;
	GtkStyleContext* _tmp11_ = NULL;
	GtkHeaderBar* _tmp12_ = NULL;
	GtkHeaderBar* _tmp13_ = NULL;
	GtkHeaderBar* _tmp14_ = NULL;
	GtkHeaderBar* _tmp15_ = NULL;
	GtkHeaderBar* _tmp16_ = NULL;
	GtkBox* main_vbox = NULL;
	GtkBox* _tmp17_ = NULL;
	GtkBox* vbox = NULL;
	GtkBox* _tmp18_ = NULL;
	GtkScrolledWindow* scrolled_window = NULL;
	GtkScrolledWindow* _tmp19_ = NULL;
	GtkAdjustment* _tmp20_ = NULL;
	GtkAdjustment* _tmp21_ = NULL;
	MathEquation* _tmp22_ = NULL;
	MathDisplay* _tmp23_ = NULL;
	MathDisplay* _tmp24_ = NULL;
	MathDisplay* _tmp25_ = NULL;
	MathDisplay* _tmp26_ = NULL;
	MathDisplay* _tmp27_ = NULL;
	MathEquation* _tmp28_ = NULL;
	MathButtons* _tmp29_ = NULL;
	MathButtons* _tmp30_ = NULL;
	MathButtons* _tmp31_ = NULL;
	MathButtons* _tmp32_ = NULL;
	MathButtons* _tmp33_ = NULL;
	MathButtons* _tmp34_ = NULL;
	MathButtons* _tmp35_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (app != NULL, NULL);
	g_return_val_if_fail (equation != NULL, NULL);
	_tmp0_ = app;
	self = (MathWindow*) g_object_new (object_type, "application", _tmp0_, NULL);
	_tmp1_ = equation;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (self->priv->_equation);
	self->priv->_equation = _tmp2_;
	_tmp3_ = _ ("Calculator");
	gtk_window_set_title ((GtkWindow*) self, _tmp3_);
	gtk_window_set_role ((GtkWindow*) self, "gnome-calculator");
	gtk_window_set_resizable ((GtkWindow*) self, FALSE);
	g_action_map_add_action_entries ((GActionMap*) self, MATH_WINDOW_window_entries, G_N_ELEMENTS (MATH_WINDOW_window_entries), self);
	_tmp4_ = gtk_builder_new ();
	builder = _tmp4_;
	{
		gtk_builder_add_from_resource (builder, "/org/gnome/calculator/menu.ui", &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch12_g_error;
		}
	}
	goto __finally12;
	__catch12_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp5_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp5_ = e->message;
		g_error ("math-window.vala:54: Error loading menu UI: %s", _tmp5_);
		_g_error_free0 (e);
	}
	__finally12:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (builder);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp6_ = gtk_builder_get_object (builder, "window-menu");
	_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, g_menu_model_get_type ()) ? ((GMenuModel*) _tmp6_) : NULL);
	menu = _tmp7_;
	_tmp8_ = (GtkMenuButton*) gtk_menu_button_new ();
	g_object_ref_sink (_tmp8_);
	gear_menu_button = _tmp8_;
	gtk_widget_set_valign ((GtkWidget*) gear_menu_button, GTK_ALIGN_CENTER);
	_tmp9_ = (GtkImage*) gtk_image_new_from_icon_name ("emblem-system-symbolic", GTK_ICON_SIZE_BUTTON);
	g_object_ref_sink (_tmp9_);
	_tmp10_ = _tmp9_;
	gtk_button_set_image ((GtkButton*) gear_menu_button, (GtkWidget*) _tmp10_);
	_g_object_unref0 (_tmp10_);
	gtk_menu_button_set_menu_model (gear_menu_button, menu);
	_tmp11_ = gtk_widget_get_style_context ((GtkWidget*) gear_menu_button);
	gtk_style_context_add_class (_tmp11_, "image-button");
	gtk_widget_show ((GtkWidget*) gear_menu_button);
	_tmp12_ = (GtkHeaderBar*) gtk_header_bar_new ();
	g_object_ref_sink (_tmp12_);
	_g_object_unref0 (self->priv->headerbar);
	self->priv->headerbar = _tmp12_;
	_tmp13_ = self->priv->headerbar;
	gtk_header_bar_set_show_close_button (_tmp13_, TRUE);
	_tmp14_ = self->priv->headerbar;
	gtk_header_bar_pack_start (_tmp14_, (GtkWidget*) gear_menu_button);
	_tmp15_ = self->priv->headerbar;
	gtk_widget_show ((GtkWidget*) _tmp15_);
	_tmp16_ = self->priv->headerbar;
	gtk_window_set_titlebar ((GtkWindow*) self, (GtkWidget*) _tmp16_);
	_tmp17_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp17_);
	main_vbox = _tmp17_;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) main_vbox);
	gtk_widget_show ((GtkWidget*) main_vbox);
	_tmp18_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 6);
	g_object_ref_sink (_tmp18_);
	vbox = _tmp18_;
	gtk_container_set_border_width ((GtkContainer*) vbox, (guint) 6);
	gtk_box_pack_start (main_vbox, (GtkWidget*) vbox, TRUE, TRUE, (guint) 0);
	gtk_widget_show ((GtkWidget*) vbox);
	_tmp19_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	g_object_ref_sink (_tmp19_);
	scrolled_window = _tmp19_;
	gtk_scrolled_window_set_policy (scrolled_window, GTK_POLICY_AUTOMATIC, GTK_POLICY_NEVER);
	gtk_scrolled_window_set_shadow_type (scrolled_window, GTK_SHADOW_IN);
	gtk_box_pack_start (vbox, (GtkWidget*) scrolled_window, FALSE, FALSE, (guint) 0);
	_tmp20_ = gtk_scrolled_window_get_hadjustment (scrolled_window);
	g_signal_connect_object (_tmp20_, "changed", (GCallback) _math_window_scroll_changed_cb_gtk_adjustment_changed, self, 0);
	_tmp21_ = gtk_scrolled_window_get_hadjustment (scrolled_window);
	g_signal_connect_object (_tmp21_, "value-changed", (GCallback) _math_window_scroll_value_changed_cb_gtk_adjustment_value_changed, self, 0);
	self->priv->right_aligned = TRUE;
	gtk_widget_show ((GtkWidget*) scrolled_window);
	_tmp22_ = equation;
	_tmp23_ = math_display_new (_tmp22_);
	g_object_ref_sink (_tmp23_);
	_g_object_unref0 (self->priv->_display);
	self->priv->_display = _tmp23_;
	_tmp24_ = math_window_get_display (self);
	_tmp25_ = _tmp24_;
	gtk_container_add ((GtkContainer*) scrolled_window, (GtkWidget*) _tmp25_);
	_tmp26_ = math_window_get_display (self);
	_tmp27_ = _tmp26_;
	gtk_widget_show ((GtkWidget*) _tmp27_);
	_tmp28_ = equation;
	_tmp29_ = math_buttons_new (_tmp28_);
	g_object_ref_sink (_tmp29_);
	_g_object_unref0 (self->priv->_buttons);
	self->priv->_buttons = _tmp29_;
	_tmp30_ = math_window_get_buttons (self);
	_tmp31_ = _tmp30_;
	gtk_box_pack_start (vbox, (GtkWidget*) _tmp31_, TRUE, TRUE, (guint) 0);
	_tmp32_ = math_window_get_buttons (self);
	_tmp33_ = _tmp32_;
	gtk_widget_show ((GtkWidget*) _tmp33_);
	_tmp34_ = math_window_get_buttons (self);
	_tmp35_ = _tmp34_;
	g_signal_connect_object ((GObject*) _tmp35_, "notify::mode", (GCallback) _math_window_mode_changed_cb_g_object_notify, self, 0);
	math_window_mode_changed_cb (self);
	_g_object_unref0 (scrolled_window);
	_g_object_unref0 (vbox);
	_g_object_unref0 (main_vbox);
	_g_object_unref0 (gear_menu_button);
	_g_object_unref0 (menu);
	_g_object_unref0 (builder);
	return self;
}


MathWindow* math_window_new (GtkApplication* app, MathEquation* equation) {
	return math_window_construct (TYPE_MATH_WINDOW, app, equation);
}


static void math_window_mode_changed_cb (MathWindow* self) {
	GSimpleAction* action = NULL;
	GAction* _tmp0_ = NULL;
	GSimpleAction* _tmp1_ = NULL;
	MathButtons* _tmp2_ = NULL;
	MathButtons* _tmp3_ = NULL;
	ButtonMode _tmp4_ = 0;
	ButtonMode _tmp5_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_action_map_lookup_action ((GActionMap*) self, "mode");
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, g_simple_action_get_type (), GSimpleAction));
	action = _tmp1_;
	_tmp2_ = math_window_get_buttons (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = math_buttons_get_mode (_tmp3_);
	_tmp5_ = _tmp4_;
	switch (_tmp5_) {
		default:
		case BUTTON_MODE_BASIC:
		{
			GtkHeaderBar* _tmp6_ = NULL;
			const gchar* _tmp7_ = NULL;
			GSimpleAction* _tmp8_ = NULL;
			GVariant* _tmp9_ = NULL;
			GVariant* _tmp10_ = NULL;
			_tmp6_ = self->priv->headerbar;
			_tmp7_ = _ ("Basic Mode");
			gtk_header_bar_set_title (_tmp6_, _tmp7_);
			_tmp8_ = action;
			_tmp9_ = g_variant_new_string ("basic");
			g_variant_ref_sink (_tmp9_);
			_tmp10_ = _tmp9_;
			g_simple_action_set_state (_tmp8_, _tmp10_);
			_g_variant_unref0 (_tmp10_);
			break;
		}
		case BUTTON_MODE_ADVANCED:
		{
			GtkHeaderBar* _tmp11_ = NULL;
			const gchar* _tmp12_ = NULL;
			GSimpleAction* _tmp13_ = NULL;
			GVariant* _tmp14_ = NULL;
			GVariant* _tmp15_ = NULL;
			_tmp11_ = self->priv->headerbar;
			_tmp12_ = _ ("Advanced Mode");
			gtk_header_bar_set_title (_tmp11_, _tmp12_);
			_tmp13_ = action;
			_tmp14_ = g_variant_new_string ("advanced");
			g_variant_ref_sink (_tmp14_);
			_tmp15_ = _tmp14_;
			g_simple_action_set_state (_tmp13_, _tmp15_);
			_g_variant_unref0 (_tmp15_);
			break;
		}
		case BUTTON_MODE_FINANCIAL:
		{
			GtkHeaderBar* _tmp16_ = NULL;
			const gchar* _tmp17_ = NULL;
			GSimpleAction* _tmp18_ = NULL;
			GVariant* _tmp19_ = NULL;
			GVariant* _tmp20_ = NULL;
			_tmp16_ = self->priv->headerbar;
			_tmp17_ = _ ("Financial Mode");
			gtk_header_bar_set_title (_tmp16_, _tmp17_);
			_tmp18_ = action;
			_tmp19_ = g_variant_new_string ("financial");
			g_variant_ref_sink (_tmp19_);
			_tmp20_ = _tmp19_;
			g_simple_action_set_state (_tmp18_, _tmp20_);
			_g_variant_unref0 (_tmp20_);
			break;
		}
		case BUTTON_MODE_PROGRAMMING:
		{
			GtkHeaderBar* _tmp21_ = NULL;
			const gchar* _tmp22_ = NULL;
			GSimpleAction* _tmp23_ = NULL;
			GVariant* _tmp24_ = NULL;
			GVariant* _tmp25_ = NULL;
			_tmp21_ = self->priv->headerbar;
			_tmp22_ = _ ("Programming Mode");
			gtk_header_bar_set_title (_tmp21_, _tmp22_);
			_tmp23_ = action;
			_tmp24_ = g_variant_new_string ("programming");
			g_variant_ref_sink (_tmp24_);
			_tmp25_ = _tmp24_;
			g_simple_action_set_state (_tmp23_, _tmp25_);
			_g_variant_unref0 (_tmp25_);
			break;
		}
	}
	_g_object_unref0 (action);
}


void math_window_critical_error (MathWindow* self, const gchar* title, const gchar* contents) {
	GtkMessageDialog* dialog = NULL;
	const gchar* _tmp0_ = NULL;
	GtkMessageDialog* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (title != NULL);
	g_return_if_fail (contents != NULL);
	_tmp0_ = title;
	_tmp1_ = (GtkMessageDialog*) gtk_message_dialog_new (NULL, 0, GTK_MESSAGE_ERROR, GTK_BUTTONS_NONE, "%s", _tmp0_);
	g_object_ref_sink (_tmp1_);
	dialog = _tmp1_;
	_tmp2_ = contents;
	gtk_message_dialog_format_secondary_text (dialog, "%s", _tmp2_);
	_tmp3_ = _ ("_Quit");
	gtk_dialog_add_buttons ((GtkDialog*) dialog, _tmp3_, GTK_RESPONSE_ACCEPT, NULL);
	gtk_dialog_run ((GtkDialog*) dialog);
	gtk_widget_destroy ((GtkWidget*) self);
	_g_object_unref0 (dialog);
}


static gboolean math_window_real_key_press_event (GtkWidget* base, GdkEventKey* event) {
	MathWindow * self;
	gboolean result = FALSE;
	gboolean _result_ = FALSE;
	GdkEventKey* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	MathButtons* _tmp3_ = NULL;
	MathButtons* _tmp4_ = NULL;
	ButtonMode _tmp5_ = 0;
	ButtonMode _tmp6_ = 0;
	self = (MathWindow*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = event;
	_tmp1_ = GTK_WIDGET_CLASS (math_window_parent_class)->key_press_event ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_APPLICATION_WINDOW, GtkApplicationWindow), _tmp0_);
	_result_ = _tmp1_;
	_tmp3_ = math_window_get_buttons (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = math_buttons_get_mode (_tmp4_);
	_tmp6_ = _tmp5_;
	if (_tmp6_ == BUTTON_MODE_PROGRAMMING) {
		GdkEventKey* _tmp7_ = NULL;
		GdkModifierType _tmp8_ = 0;
		_tmp7_ = event;
		_tmp8_ = _tmp7_->state;
		_tmp2_ = (_tmp8_ & GDK_CONTROL_MASK) == GDK_CONTROL_MASK;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		GdkEventKey* _tmp9_ = NULL;
		guint _tmp10_ = 0U;
		_tmp9_ = event;
		_tmp10_ = _tmp9_->keyval;
		switch (_tmp10_) {
			case GDK_KEY_b:
			{
				MathEquation* _tmp11_ = NULL;
				MathEquation* _tmp12_ = NULL;
				_tmp11_ = math_window_get_equation (self);
				_tmp12_ = _tmp11_;
				math_equation_set_number_base (_tmp12_, 2);
				result = TRUE;
				return result;
			}
			case GDK_KEY_o:
			{
				MathEquation* _tmp13_ = NULL;
				MathEquation* _tmp14_ = NULL;
				_tmp13_ = math_window_get_equation (self);
				_tmp14_ = _tmp13_;
				math_equation_set_number_base (_tmp14_, 8);
				result = TRUE;
				return result;
			}
			case GDK_KEY_d:
			{
				MathEquation* _tmp15_ = NULL;
				MathEquation* _tmp16_ = NULL;
				_tmp15_ = math_window_get_equation (self);
				_tmp16_ = _tmp15_;
				math_equation_set_number_base (_tmp16_, 10);
				result = TRUE;
				return result;
			}
			case GDK_KEY_h:
			{
				MathEquation* _tmp17_ = NULL;
				MathEquation* _tmp18_ = NULL;
				_tmp17_ = math_window_get_equation (self);
				_tmp18_ = _tmp17_;
				math_equation_set_number_base (_tmp18_, 16);
				result = TRUE;
				return result;
			}
			default:
			break;
		}
	}
	result = _result_;
	return result;
}


static void math_window_scroll_changed_cb (MathWindow* self, GtkAdjustment* adjustment) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (adjustment != NULL);
	_tmp0_ = self->priv->right_aligned;
	if (_tmp0_) {
		GtkAdjustment* _tmp1_ = NULL;
		GtkAdjustment* _tmp2_ = NULL;
		gdouble _tmp3_ = 0.0;
		GtkAdjustment* _tmp4_ = NULL;
		gdouble _tmp5_ = 0.0;
		_tmp1_ = adjustment;
		_tmp2_ = adjustment;
		_tmp3_ = gtk_adjustment_get_upper (_tmp2_);
		_tmp4_ = adjustment;
		_tmp5_ = gtk_adjustment_get_page_size (_tmp4_);
		gtk_adjustment_set_value (_tmp1_, _tmp3_ - _tmp5_);
	}
}


static void math_window_scroll_value_changed_cb (MathWindow* self, GtkAdjustment* adjustment) {
	GtkAdjustment* _tmp0_ = NULL;
	gdouble _tmp1_ = 0.0;
	GtkAdjustment* _tmp2_ = NULL;
	gdouble _tmp3_ = 0.0;
	GtkAdjustment* _tmp4_ = NULL;
	gdouble _tmp5_ = 0.0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (adjustment != NULL);
	_tmp0_ = adjustment;
	_tmp1_ = gtk_adjustment_get_value (_tmp0_);
	_tmp2_ = adjustment;
	_tmp3_ = gtk_adjustment_get_upper (_tmp2_);
	_tmp4_ = adjustment;
	_tmp5_ = gtk_adjustment_get_page_size (_tmp4_);
	if (_tmp1_ == (_tmp3_ - _tmp5_)) {
		self->priv->right_aligned = TRUE;
	} else {
		self->priv->right_aligned = FALSE;
	}
}


static void math_window_copy_cb (MathWindow* self) {
	MathEquation* _tmp0_ = NULL;
	MathEquation* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = math_window_get_equation (self);
	_tmp1_ = _tmp0_;
	math_equation_copy (_tmp1_);
}


static void math_window_paste_cb (MathWindow* self) {
	MathEquation* _tmp0_ = NULL;
	MathEquation* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = math_window_get_equation (self);
	_tmp1_ = _tmp0_;
	math_equation_paste (_tmp1_);
}


static void math_window_undo_cb (MathWindow* self) {
	MathEquation* _tmp0_ = NULL;
	MathEquation* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = math_window_get_equation (self);
	_tmp1_ = _tmp0_;
	gtk_source_buffer_undo ((GtkSourceBuffer*) _tmp1_);
}


static void math_window_redo_cb (MathWindow* self) {
	MathEquation* _tmp0_ = NULL;
	MathEquation* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = math_window_get_equation (self);
	_tmp1_ = _tmp0_;
	gtk_source_buffer_redo ((GtkSourceBuffer*) _tmp1_);
}


static void math_window_mode_cb (MathWindow* self, GSimpleAction* action, GVariant* parameter) {
	GVariant* _tmp0_ = NULL;
	GVariant* _tmp1_ = NULL;
	const GVariantType* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	ButtonMode mode = 0;
	gchar* mode_str = NULL;
	GVariant* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	MathButtons* _tmp11_ = NULL;
	MathButtons* _tmp12_ = NULL;
	ButtonMode _tmp13_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = parameter;
	g_return_if_fail (_tmp0_ != NULL);
	_tmp1_ = parameter;
	_tmp2_ = G_VARIANT_TYPE_STRING;
	_tmp3_ = g_variant_is_of_type (_tmp1_, _tmp2_);
	g_return_if_fail (_tmp3_);
	mode = BUTTON_MODE_BASIC;
	_tmp4_ = parameter;
	_tmp5_ = g_variant_get_string (_tmp4_, NULL);
	_tmp6_ = g_strdup (_tmp5_);
	mode_str = _tmp6_;
	_tmp7_ = mode_str;
	if (g_strcmp0 (_tmp7_, "basic") == 0) {
		mode = BUTTON_MODE_BASIC;
	} else {
		const gchar* _tmp8_ = NULL;
		_tmp8_ = mode_str;
		if (g_strcmp0 (_tmp8_, "advanced") == 0) {
			mode = BUTTON_MODE_ADVANCED;
		} else {
			const gchar* _tmp9_ = NULL;
			_tmp9_ = mode_str;
			if (g_strcmp0 (_tmp9_, "financial") == 0) {
				mode = BUTTON_MODE_FINANCIAL;
			} else {
				const gchar* _tmp10_ = NULL;
				_tmp10_ = mode_str;
				if (g_strcmp0 (_tmp10_, "programming") == 0) {
					mode = BUTTON_MODE_PROGRAMMING;
				} else {
					g_assert_not_reached ();
				}
			}
		}
	}
	_tmp11_ = math_window_get_buttons (self);
	_tmp12_ = _tmp11_;
	_tmp13_ = mode;
	math_buttons_set_mode (_tmp12_, _tmp13_);
	_g_free0 (mode_str);
}


MathEquation* math_window_get_equation (MathWindow* self) {
	MathEquation* result;
	MathEquation* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_equation;
	result = _tmp0_;
	return result;
}


MathDisplay* math_window_get_display (MathWindow* self) {
	MathDisplay* result;
	MathDisplay* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_display;
	result = _tmp0_;
	return result;
}


MathButtons* math_window_get_buttons (MathWindow* self) {
	MathButtons* result;
	MathButtons* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_buttons;
	result = _tmp0_;
	return result;
}


static void math_window_class_init (MathWindowClass * klass) {
	math_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (MathWindowPrivate));
	GTK_WIDGET_CLASS (klass)->key_press_event = math_window_real_key_press_event;
	G_OBJECT_CLASS (klass)->get_property = _vala_math_window_get_property;
	G_OBJECT_CLASS (klass)->finalize = math_window_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_WINDOW_EQUATION, g_param_spec_object ("equation", "equation", "equation", TYPE_MATH_EQUATION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_WINDOW_DISPLAY, g_param_spec_object ("display", "display", "display", TYPE_MATH_DISPLAY, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_WINDOW_BUTTONS, g_param_spec_object ("buttons", "buttons", "buttons", TYPE_MATH_BUTTONS, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void math_window_instance_init (MathWindow * self) {
	self->priv = MATH_WINDOW_GET_PRIVATE (self);
}


static void math_window_finalize (GObject* obj) {
	MathWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MATH_WINDOW, MathWindow);
	_g_object_unref0 (self->priv->_equation);
	_g_object_unref0 (self->priv->_display);
	_g_object_unref0 (self->priv->_buttons);
	_g_object_unref0 (self->priv->headerbar);
	G_OBJECT_CLASS (math_window_parent_class)->finalize (obj);
}


GType math_window_get_type (void) {
	static volatile gsize math_window_type_id__volatile = 0;
	if (g_once_init_enter (&math_window_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MathWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) math_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MathWindow), 0, (GInstanceInitFunc) math_window_instance_init, NULL };
		GType math_window_type_id;
		math_window_type_id = g_type_register_static (GTK_TYPE_APPLICATION_WINDOW, "MathWindow", &g_define_type_info, 0);
		g_once_init_leave (&math_window_type_id__volatile, math_window_type_id);
	}
	return math_window_type_id__volatile;
}


static void _vala_math_window_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	MathWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MATH_WINDOW, MathWindow);
	switch (property_id) {
		case MATH_WINDOW_EQUATION:
		g_value_set_object (value, math_window_get_equation (self));
		break;
		case MATH_WINDOW_DISPLAY:
		g_value_set_object (value, math_window_get_display (self));
		break;
		case MATH_WINDOW_BUTTONS:
		g_value_set_object (value, math_window_get_buttons (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



