/* math-buttons.c generated by valac 0.22.1, the Vala compiler
 * generated from math-buttons.vala, do not modify */

/*
 * Copyright (C) 2008-2012 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gtksourceview/gtksource.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include <atk/atk.h>


#define TYPE_BUTTON_MODE (button_mode_get_type ())

#define TYPE_MATH_BUTTONS (math_buttons_get_type ())
#define MATH_BUTTONS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_BUTTONS, MathButtons))
#define MATH_BUTTONS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_BUTTONS, MathButtonsClass))
#define IS_MATH_BUTTONS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_BUTTONS))
#define IS_MATH_BUTTONS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_BUTTONS))
#define MATH_BUTTONS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_BUTTONS, MathButtonsClass))

typedef struct _MathButtons MathButtons;
typedef struct _MathButtonsClass MathButtonsClass;
typedef struct _MathButtonsPrivate MathButtonsPrivate;

#define TYPE_MATH_EQUATION (math_equation_get_type ())
#define MATH_EQUATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_EQUATION, MathEquation))
#define MATH_EQUATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_EQUATION, MathEquationClass))
#define IS_MATH_EQUATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_EQUATION))
#define IS_MATH_EQUATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_EQUATION))
#define MATH_EQUATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_EQUATION, MathEquationClass))

typedef struct _MathEquation MathEquation;
typedef struct _MathEquationClass MathEquationClass;

#define TYPE_MATH_CONVERTER (math_converter_get_type ())
#define MATH_CONVERTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_CONVERTER, MathConverter))
#define MATH_CONVERTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_CONVERTER, MathConverterClass))
#define IS_MATH_CONVERTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_CONVERTER))
#define IS_MATH_CONVERTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_CONVERTER))
#define MATH_CONVERTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_CONVERTER, MathConverterClass))

typedef struct _MathConverter MathConverter;
typedef struct _MathConverterClass MathConverterClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))

#define TYPE_FINANCIAL_DIALOG (financial_dialog_get_type ())

#define TYPE_NUMBER (number_get_type ())
#define NUMBER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NUMBER, Number))
#define NUMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NUMBER, NumberClass))
#define IS_NUMBER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NUMBER))
#define IS_NUMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NUMBER))
#define NUMBER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NUMBER, NumberClass))

typedef struct _Number Number;
typedef struct _NumberClass NumberClass;
#define _number_unref0(var) ((var == NULL) ? NULL : (var = (number_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_SERIALIZER (serializer_get_type ())
#define SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SERIALIZER, Serializer))
#define SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SERIALIZER, SerializerClass))
#define IS_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SERIALIZER))
#define IS_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SERIALIZER))
#define SERIALIZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SERIALIZER, SerializerClass))

typedef struct _Serializer Serializer;
typedef struct _SerializerClass SerializerClass;

#define TYPE_NUMBER_MODE (number_mode_get_type ())

#define TYPE_UNIT (unit_get_type ())
#define UNIT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNIT, Unit))
#define UNIT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNIT, UnitClass))
#define IS_UNIT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNIT))
#define IS_UNIT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNIT))
#define UNIT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNIT, UnitClass))

typedef struct _Unit Unit;
typedef struct _UnitClass UnitClass;

#define TYPE_MATH_VARIABLE_POPUP (math_variable_popup_get_type ())
#define MATH_VARIABLE_POPUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_VARIABLE_POPUP, MathVariablePopup))
#define MATH_VARIABLE_POPUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_VARIABLE_POPUP, MathVariablePopupClass))
#define IS_MATH_VARIABLE_POPUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_VARIABLE_POPUP))
#define IS_MATH_VARIABLE_POPUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_VARIABLE_POPUP))
#define MATH_VARIABLE_POPUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_VARIABLE_POPUP, MathVariablePopupClass))

typedef struct _MathVariablePopup MathVariablePopup;
typedef struct _MathVariablePopupClass MathVariablePopupClass;

#define TYPE_MATH_FUNCTION_POPUP (math_function_popup_get_type ())
#define MATH_FUNCTION_POPUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_FUNCTION_POPUP, MathFunctionPopup))
#define MATH_FUNCTION_POPUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_FUNCTION_POPUP, MathFunctionPopupClass))
#define IS_MATH_FUNCTION_POPUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_FUNCTION_POPUP))
#define IS_MATH_FUNCTION_POPUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_FUNCTION_POPUP))
#define MATH_FUNCTION_POPUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_FUNCTION_POPUP, MathFunctionPopupClass))

typedef struct _MathFunctionPopup MathFunctionPopup;
typedef struct _MathFunctionPopupClass MathFunctionPopupClass;

typedef enum  {
	BUTTON_MODE_BASIC,
	BUTTON_MODE_ADVANCED,
	BUTTON_MODE_FINANCIAL,
	BUTTON_MODE_PROGRAMMING
} ButtonMode;

struct _MathButtons {
	GtkBox parent_instance;
	MathButtonsPrivate * priv;
};

struct _MathButtonsClass {
	GtkBoxClass parent_class;
};

struct _MathButtonsPrivate {
	MathEquation* equation;
	ButtonMode _mode;
	gint _programming_base;
	MathConverter* converter;
	GtkBuilder* basic_ui;
	GtkBuilder* advanced_ui;
	GtkBuilder* financial_ui;
	GtkBuilder* programming_ui;
	GtkWidget* bas_panel;
	GtkWidget* adv_panel;
	GtkWidget* fin_panel;
	GtkWidget* prog_panel;
	GtkWidget* active_panel;
	GtkMenu* shift_left_menu;
	GtkMenu* shift_right_menu;
	GList* superscript_toggles;
	GList* subscript_toggles;
	GtkComboBox* base_combo;
	GtkLabel* base_label;
	GtkWidget* bit_panel;
	GList* bit_labels;
	GtkDialog* character_code_dialog;
	GtkEntry* character_code_entry;
};

typedef enum  {
	FINANCIAL_DIALOG_CTRM_DIALOG,
	FINANCIAL_DIALOG_DDB_DIALOG,
	FINANCIAL_DIALOG_FV_DIALOG,
	FINANCIAL_DIALOG_GPM_DIALOG,
	FINANCIAL_DIALOG_PMT_DIALOG,
	FINANCIAL_DIALOG_PV_DIALOG,
	FINANCIAL_DIALOG_RATE_DIALOG,
	FINANCIAL_DIALOG_SLN_DIALOG,
	FINANCIAL_DIALOG_SYD_DIALOG,
	FINANCIAL_DIALOG_TERM_DIALOG
} FinancialDialog;

typedef enum  {
	NUMBER_MODE_NORMAL,
	NUMBER_MODE_SUPERSCRIPT,
	NUMBER_MODE_SUBSCRIPT
} NumberMode;


static gpointer math_buttons_parent_class = NULL;

GType button_mode_get_type (void) G_GNUC_CONST;
GType math_buttons_get_type (void) G_GNUC_CONST;
GType math_equation_get_type (void) G_GNUC_CONST;
GType math_converter_get_type (void) G_GNUC_CONST;
#define MATH_BUTTONS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MATH_BUTTONS, MathButtonsPrivate))
enum  {
	MATH_BUTTONS_DUMMY_PROPERTY,
	MATH_BUTTONS_MODE,
	MATH_BUTTONS_PROGRAMMING_BASE
};
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
MathButtons* math_buttons_new (MathEquation* equation);
MathButtons* math_buttons_construct (GType object_type, MathEquation* equation);
static void math_buttons_load_buttons (MathButtons* self);
static void _math_buttons_load_buttons_gtk_widget_show (GtkWidget* _sender, gpointer self);
static void __lambda28_ (MathButtons* self, GParamSpec* pspec);
static void math_buttons_update_bit_panel (MathButtons* self);
static void ___lambda28__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void __lambda29_ (MathButtons* self, GParamSpec* pspec);
static void math_buttons_number_mode_changed_cb (MathButtons* self);
static void ___lambda29__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void __lambda30_ (MathButtons* self, GParamSpec* pspec);
static void ___lambda30__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void __lambda31_ (MathButtons* self, GParamSpec* pspec);
static void ___lambda31__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void math_buttons_load_finc_dialogs (MathButtons* self);
GType financial_dialog_get_type (void) G_GNUC_CONST;
static void math_buttons_load_finc_dialog (MathButtons* self, const gchar* name, gchar** entry_names, int entry_names_length1, FinancialDialog function);
static void math_buttons_finc_response_cb (MathButtons* self, GtkWidget* widget, gint response_id);
static void _math_buttons_finc_response_cb_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
static void math_buttons_finc_activate_cb (MathButtons* self, GtkWidget* widget);
static void _math_buttons_finc_activate_cb_gtk_entry_activate (GtkEntry* _sender, gpointer self);
gpointer number_ref (gpointer instance);
void number_unref (gpointer instance);
GParamSpec* param_spec_number (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_number (GValue* value, gpointer v_object);
void value_take_number (GValue* value, gpointer v_object);
gpointer value_get_number (const GValue* value);
GType number_get_type (void) G_GNUC_CONST;
Number* math_equation_get_number (MathEquation* self);
Number* number_new_unsigned_integer (guint64 x);
Number* number_construct_unsigned_integer (GType object_type, guint64 x);
Number* number_fractional_part (Number* self);
gboolean number_is_negative (Number* self);
gint number_compare (Number* self, Number* y);
gboolean number_is_zero (Number* self);
guint64 number_to_unsigned_integer (Number* self);
gint math_equation_get_number_base (MathEquation* self);
static void math_buttons_base_combobox_changed_cb (MathButtons* self, GtkComboBox* combo);
void math_buttons_set_programming_base (MathButtons* self, gint value);
static void math_buttons_base_changed_cb (MathButtons* self);
ButtonMode math_buttons_get_mode (MathButtons* self);
gint math_buttons_get_programming_base (MathButtons* self);
static GtkWidget* math_buttons_load_mode (MathButtons* self, ButtonMode mode);
static void math_buttons_setup_button (MathButtons* self, GtkBuilder* builder, const gchar* name, const gchar* data, const gchar* tooltip, gboolean connect);
gunichar math_equation_get_digit_text (MathEquation* self, guint digit);
static void ______lambda14_ (MathButtons* self, GtkButton* widget);
void math_equation_insert_digit (MathEquation* self, guint digit);
static void _______lambda14__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void ___lambda15_ (MathButtons* self);
void math_equation_insert_subtract (MathEquation* self);
static void ____lambda15__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void ___lambda16_ (MathButtons* self);
void math_equation_insert_square (MathEquation* self);
static void ____lambda16__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void ___lambda17_ (MathButtons* self);
static void ____lambda17__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void ___lambda18_ (MathButtons* self);
void math_equation_solve (MathEquation* self);
static void ____lambda18__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void ___lambda19_ (MathButtons* self);
void math_equation_clear (MathEquation* self);
static void ____lambda19__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void math_buttons_memory_cb (MathButtons* self, GtkWidget* widget);
static void _math_buttons_memory_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void math_buttons_function_cb (MathButtons* self, GtkWidget* widget);
static void _math_buttons_function_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void ___lambda22_ (MathButtons* self);
void math_equation_factorize (MathEquation* self);
static void ____lambda22__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void ___lambda23_ (MathButtons* self);
void math_equation_insert_exponent (MathEquation* self);
static void ____lambda23__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void math_buttons_shift_left_cb (MathButtons* self, GtkButton* button);
static void _math_buttons_shift_left_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void math_buttons_shift_right_cb (MathButtons* self, GtkButton* button);
static void _math_buttons_shift_right_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void math_buttons_insert_character_code_cb (MathButtons* self, GtkWidget* widget);
static void _math_buttons_insert_character_code_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
GType serializer_get_type (void) G_GNUC_CONST;
Serializer* math_equation_get_serializer (MathEquation* self);
gunichar serializer_get_radix (Serializer* self);
static void ___lambda26_ (MathButtons* self);
void math_equation_insert_numeric_point (MathEquation* self);
static void ____lambda26__gtk_button_clicked (GtkButton* _sender, gpointer self);
GType number_mode_get_type (void) G_GNUC_CONST;
NumberMode math_equation_get_number_mode (MathEquation* self);
static void math_buttons_set_superscript_cb (MathButtons* self, GtkButton* widget);
static void _math_buttons_set_superscript_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void math_buttons_set_subscript_cb (MathButtons* self, GtkButton* widget);
static void _math_buttons_set_subscript_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void math_buttons_character_code_dialog_response_cb (MathButtons* self, GtkWidget* dialog, gint response_id);
static void _math_buttons_character_code_dialog_response_cb_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
static gboolean math_buttons_character_code_dialog_delete_cb (MathButtons* self, GtkWidget* dialog, GdkEventAny* event);
static gboolean _math_buttons_character_code_dialog_delete_cb_gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self);
static void math_buttons_character_code_dialog_activate_cb (MathButtons* self, GtkWidget* entry);
static void _math_buttons_character_code_dialog_activate_cb_gtk_entry_activate (GtkEntry* _sender, gpointer self);
static gboolean math_buttons_bit_toggle_cb (MathButtons* self, GtkWidget* event_box, GdkEventButton* event);
static gboolean _math_buttons_bit_toggle_cb_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static void _math_buttons_base_combobox_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self);
static void ___lambda27_ (MathButtons* self, GParamSpec* pspec);
static void ____lambda27__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void math_buttons_finc_cb (MathButtons* self, GtkWidget* widget);
static void _math_buttons_finc_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void ____lambda13_ (MathButtons* self, GtkButton* widget);
void math_equation_insert (MathEquation* self, const gchar* text);
static void _____lambda13__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void math_buttons_converter_changed_cb (MathButtons* self);
GType unit_get_type (void) G_GNUC_CONST;
void math_converter_get_conversion (MathConverter* self, Unit** from_unit, Unit** to_unit);
gchar* unit_get_name (Unit* self);
void math_equation_set_source_currency (MathEquation* self, const gchar* value);
void math_equation_set_target_currency (MathEquation* self, const gchar* value);
void math_equation_set_source_units (MathEquation* self, const gchar* value);
void math_equation_set_target_units (MathEquation* self, const gchar* value);
MathConverter* math_converter_new (MathEquation* equation);
MathConverter* math_converter_construct (GType object_type, MathEquation* equation);
static void _math_buttons_converter_changed_cb_math_converter_changed (MathConverter* _sender, gpointer self);
static void math_buttons_popup_button_menu (MathButtons* self, GtkButton* button, GtkMenu* menu);
static void math_buttons_button_menu_position_func (MathButtons* self, GtkMenu* menu, gint* x, gint* y, gboolean* push_in);
static void _math_buttons_button_menu_position_func_gtk_menu_position_func (GtkMenu* menu, gint* x, gint* y, gboolean* push_in, gpointer self);
GType math_variable_popup_get_type (void) G_GNUC_CONST;
MathVariablePopup* math_variable_popup_new (MathEquation* equation);
MathVariablePopup* math_variable_popup_construct (GType object_type, MathEquation* equation);
static void ______lambda24_ (MathButtons* self, GtkMenuItem* widget);
void math_equation_shift (MathEquation* self, gint count);
static void _______lambda24__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void ______lambda25_ (MathButtons* self, GtkMenuItem* widget);
static void _______lambda25__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
GType math_function_popup_get_type (void) G_GNUC_CONST;
MathFunctionPopup* math_function_popup_new (MathEquation* equation);
MathFunctionPopup* math_function_popup_construct (GType object_type, MathEquation* equation);
static gchar** _vala_array_dup1 (gchar** self, int length);
static gchar** _vala_array_dup2 (gchar** self, int length);
static gchar** _vala_array_dup3 (gchar** self, int length);
static gchar** _vala_array_dup4 (gchar** self, int length);
static gchar** _vala_array_dup5 (gchar** self, int length);
static gchar** _vala_array_dup6 (gchar** self, int length);
static gchar** _vala_array_dup7 (gchar** self, int length);
static gchar** _vala_array_dup8 (gchar** self, int length);
static gchar** _vala_array_dup9 (gchar** self, int length);
static gchar** _vala_array_dup10 (gchar** self, int length);
Number* number_new_integer (gint64 value);
Number* number_construct_integer (GType object_type, gint64 value);
Number* mp_set_from_string (const gchar* str, gint default_base);
void do_finc_expression (MathEquation* equation, FinancialDialog function, Number* arg1, Number* arg2, Number* arg3, Number* arg4);
Number* number_add (Number* self, Number* y);
Number* number_shift (Number* self, gint count);
void math_equation_insert_number (MathEquation* self, Number* x);
void math_equation_toggle_bit (MathEquation* self, guint bit);
static void math_buttons_remove_trailing_spaces (MathButtons* self);
void math_equation_set_number_mode (MathEquation* self, NumberMode value);
void math_buttons_set_mode (MathButtons* self, ButtonMode value);
void math_equation_set_number_base (MathEquation* self, gint value);
void math_converter_set_category (MathConverter* self, const gchar* category);
void math_converter_set_conversion (MathConverter* self, const gchar* unit_a, const gchar* unit_b);
gchar* math_equation_get_source_units (MathEquation* self);
gchar* math_equation_get_target_units (MathEquation* self);
gchar* math_equation_get_source_currency (MathEquation* self);
gchar* math_equation_get_target_currency (MathEquation* self);
static void math_buttons_finalize (GObject* obj);
static void _vala_math_buttons_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_math_buttons_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const gchar* MATH_BUTTONS_ctrm_entries[3] = {"ctrm_pint", "ctrm_fv", "ctrm_pv"};
static const gchar* MATH_BUTTONS_ddb_entries[3] = {"ddb_cost", "ddb_life", "ddb_period"};
static const gchar* MATH_BUTTONS_fv_entries[3] = {"fv_pmt", "fv_pint", "fv_n"};
static const gchar* MATH_BUTTONS_gpm_entries[2] = {"gpm_cost", "gpm_margin"};
static const gchar* MATH_BUTTONS_pmt_entries[3] = {"pmt_prin", "pmt_pint", "pmt_n"};
static const gchar* MATH_BUTTONS_pv_entries[3] = {"pv_pmt", "pv_pint", "pv_n"};
static const gchar* MATH_BUTTONS_rate_entries[3] = {"rate_fv", "rate_pv", "rate_n"};
static const gchar* MATH_BUTTONS_sln_entries[3] = {"sln_cost", "sln_salvage", "sln_life"};
static const gchar* MATH_BUTTONS_syd_entries[3] = {"syd_cost", "syd_salvage", "syd_life"};
static const gchar* MATH_BUTTONS_term_entries[3] = {"term_pmt", "term_fv", "term_pint"};

GType button_mode_get_type (void) {
	static volatile gsize button_mode_type_id__volatile = 0;
	if (g_once_init_enter (&button_mode_type_id__volatile)) {
		static const GEnumValue values[] = {{BUTTON_MODE_BASIC, "BUTTON_MODE_BASIC", "basic"}, {BUTTON_MODE_ADVANCED, "BUTTON_MODE_ADVANCED", "advanced"}, {BUTTON_MODE_FINANCIAL, "BUTTON_MODE_FINANCIAL", "financial"}, {BUTTON_MODE_PROGRAMMING, "BUTTON_MODE_PROGRAMMING", "programming"}, {0, NULL, NULL}};
		GType button_mode_type_id;
		button_mode_type_id = g_enum_register_static ("ButtonMode", values);
		g_once_init_leave (&button_mode_type_id__volatile, button_mode_type_id);
	}
	return button_mode_type_id__volatile;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static void _math_buttons_load_buttons_gtk_widget_show (GtkWidget* _sender, gpointer self) {
	math_buttons_load_buttons (self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void __lambda28_ (MathButtons* self, GParamSpec* pspec) {
	g_return_if_fail (pspec != NULL);
	math_buttons_update_bit_panel (self);
}


static void ___lambda28__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda28_ (self, pspec);
}


static void __lambda29_ (MathButtons* self, GParamSpec* pspec) {
	g_return_if_fail (pspec != NULL);
	math_buttons_number_mode_changed_cb (self);
}


static void ___lambda29__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda29_ (self, pspec);
}


static void __lambda30_ (MathButtons* self, GParamSpec* pspec) {
	g_return_if_fail (pspec != NULL);
	math_buttons_update_bit_panel (self);
}


static void ___lambda30__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda30_ (self, pspec);
}


static void __lambda31_ (MathButtons* self, GParamSpec* pspec) {
	g_return_if_fail (pspec != NULL);
	math_buttons_update_bit_panel (self);
}


static void ___lambda31__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda31_ (self, pspec);
}


MathButtons* math_buttons_construct (GType object_type, MathEquation* equation) {
	MathButtons * self = NULL;
	MathEquation* _tmp0_ = NULL;
	MathEquation* _tmp1_ = NULL;
	MathEquation* _tmp2_ = NULL;
	MathEquation* _tmp3_ = NULL;
	MathEquation* _tmp4_ = NULL;
	MathEquation* _tmp5_ = NULL;
	g_return_val_if_fail (equation != NULL, NULL);
	self = (MathButtons*) g_object_new (object_type, "orientation", GTK_ORIENTATION_VERTICAL, NULL);
	gtk_box_set_spacing ((GtkBox*) self, 6);
	g_signal_connect_object ((GtkWidget*) self, "show", (GCallback) _math_buttons_load_buttons_gtk_widget_show, self, 0);
	_tmp0_ = equation;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->equation);
	self->priv->equation = _tmp1_;
	_tmp2_ = equation;
	g_signal_connect_object ((GObject*) _tmp2_, "notify::display", (GCallback) ___lambda28__g_object_notify, self, 0);
	_tmp3_ = equation;
	g_signal_connect_object ((GObject*) _tmp3_, "notify::number-mode", (GCallback) ___lambda29__g_object_notify, self, 0);
	_tmp4_ = equation;
	g_signal_connect_object ((GObject*) _tmp4_, "notify::angle-units", (GCallback) ___lambda30__g_object_notify, self, 0);
	_tmp5_ = equation;
	g_signal_connect_object ((GObject*) _tmp5_, "notify::number-format", (GCallback) ___lambda31__g_object_notify, self, 0);
	math_buttons_number_mode_changed_cb (self);
	math_buttons_update_bit_panel (self);
	return self;
}


MathButtons* math_buttons_new (MathEquation* equation) {
	return math_buttons_construct (TYPE_MATH_BUTTONS, equation);
}


static void math_buttons_load_finc_dialogs (MathButtons* self) {
	g_return_if_fail (self != NULL);
	math_buttons_load_finc_dialog (self, "ctrm_dialog", MATH_BUTTONS_ctrm_entries, G_N_ELEMENTS (MATH_BUTTONS_ctrm_entries), FINANCIAL_DIALOG_CTRM_DIALOG);
	math_buttons_load_finc_dialog (self, "ddb_dialog", MATH_BUTTONS_ddb_entries, G_N_ELEMENTS (MATH_BUTTONS_ddb_entries), FINANCIAL_DIALOG_DDB_DIALOG);
	math_buttons_load_finc_dialog (self, "fv_dialog", MATH_BUTTONS_fv_entries, G_N_ELEMENTS (MATH_BUTTONS_fv_entries), FINANCIAL_DIALOG_FV_DIALOG);
	math_buttons_load_finc_dialog (self, "gpm_dialog", MATH_BUTTONS_gpm_entries, G_N_ELEMENTS (MATH_BUTTONS_gpm_entries), FINANCIAL_DIALOG_GPM_DIALOG);
	math_buttons_load_finc_dialog (self, "pmt_dialog", MATH_BUTTONS_pmt_entries, G_N_ELEMENTS (MATH_BUTTONS_pmt_entries), FINANCIAL_DIALOG_PMT_DIALOG);
	math_buttons_load_finc_dialog (self, "pv_dialog", MATH_BUTTONS_pv_entries, G_N_ELEMENTS (MATH_BUTTONS_pv_entries), FINANCIAL_DIALOG_PV_DIALOG);
	math_buttons_load_finc_dialog (self, "rate_dialog", MATH_BUTTONS_rate_entries, G_N_ELEMENTS (MATH_BUTTONS_rate_entries), FINANCIAL_DIALOG_RATE_DIALOG);
	math_buttons_load_finc_dialog (self, "sln_dialog", MATH_BUTTONS_sln_entries, G_N_ELEMENTS (MATH_BUTTONS_sln_entries), FINANCIAL_DIALOG_SLN_DIALOG);
	math_buttons_load_finc_dialog (self, "syd_dialog", MATH_BUTTONS_syd_entries, G_N_ELEMENTS (MATH_BUTTONS_syd_entries), FINANCIAL_DIALOG_SYD_DIALOG);
	math_buttons_load_finc_dialog (self, "term_dialog", MATH_BUTTONS_term_entries, G_N_ELEMENTS (MATH_BUTTONS_term_entries), FINANCIAL_DIALOG_TERM_DIALOG);
}


static void _math_buttons_finc_response_cb_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	math_buttons_finc_response_cb (self, _sender, response_id);
}


static void _math_buttons_finc_activate_cb_gtk_entry_activate (GtkEntry* _sender, gpointer self) {
	math_buttons_finc_activate_cb (self, _sender);
}


static void math_buttons_load_finc_dialog (MathButtons* self, const gchar* name, gchar** entry_names, int entry_names_length1, FinancialDialog function) {
	GtkDialog* dialog = NULL;
	GtkBuilder* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GObject* _tmp2_ = NULL;
	GtkDialog* _tmp3_ = NULL;
	GtkDialog* _tmp4_ = NULL;
	FinancialDialog _tmp5_ = 0;
	GtkDialog* _tmp6_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = self->priv->financial_ui;
	_tmp1_ = name;
	_tmp2_ = gtk_builder_get_object (_tmp0_, _tmp1_);
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, GTK_TYPE_DIALOG) ? ((GtkDialog*) _tmp2_) : NULL);
	dialog = _tmp3_;
	_tmp4_ = dialog;
	_tmp5_ = function;
	g_object_set_data_full ((GObject*) _tmp4_, "finc-function", (gpointer) ((gintptr) ((gint) _tmp5_)), NULL);
	_tmp6_ = dialog;
	g_signal_connect_object (_tmp6_, "response", (GCallback) _math_buttons_finc_response_cb_gtk_dialog_response, self, 0);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp7_ = FALSE;
			_tmp7_ = TRUE;
			while (TRUE) {
				gboolean _tmp8_ = FALSE;
				gint _tmp10_ = 0;
				gchar** _tmp11_ = NULL;
				gint _tmp11__length1 = 0;
				GtkEntry* entry = NULL;
				GtkBuilder* _tmp12_ = NULL;
				gchar** _tmp13_ = NULL;
				gint _tmp13__length1 = 0;
				gint _tmp14_ = 0;
				const gchar* _tmp15_ = NULL;
				GObject* _tmp16_ = NULL;
				GtkEntry* _tmp17_ = NULL;
				gint _tmp18_ = 0;
				GtkEntry* _tmp26_ = NULL;
				_tmp8_ = _tmp7_;
				if (!_tmp8_) {
					gint _tmp9_ = 0;
					_tmp9_ = i;
					i = _tmp9_ + 1;
				}
				_tmp7_ = FALSE;
				_tmp10_ = i;
				_tmp11_ = entry_names;
				_tmp11__length1 = entry_names_length1;
				if (!(_tmp10_ < _tmp11__length1)) {
					break;
				}
				_tmp12_ = self->priv->financial_ui;
				_tmp13_ = entry_names;
				_tmp13__length1 = entry_names_length1;
				_tmp14_ = i;
				_tmp15_ = _tmp13_[_tmp14_];
				_tmp16_ = gtk_builder_get_object (_tmp12_, _tmp15_);
				_tmp17_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, GTK_TYPE_ENTRY) ? ((GtkEntry*) _tmp16_) : NULL);
				entry = _tmp17_;
				_tmp18_ = i;
				if (_tmp18_ != (G_N_ELEMENTS (MATH_BUTTONS_ctrm_entries) - 1)) {
					GtkEntry* _tmp19_ = NULL;
					GtkBuilder* _tmp20_ = NULL;
					gchar** _tmp21_ = NULL;
					gint _tmp21__length1 = 0;
					gint _tmp22_ = 0;
					const gchar* _tmp23_ = NULL;
					GObject* _tmp24_ = NULL;
					GtkEntry* _tmp25_ = NULL;
					_tmp19_ = entry;
					_tmp20_ = self->priv->financial_ui;
					_tmp21_ = entry_names;
					_tmp21__length1 = entry_names_length1;
					_tmp22_ = i;
					_tmp23_ = _tmp21_[_tmp22_ + 1];
					_tmp24_ = gtk_builder_get_object (_tmp20_, _tmp23_);
					_tmp25_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp24_, GTK_TYPE_ENTRY) ? ((GtkEntry*) _tmp24_) : NULL);
					g_object_set_data_full ((GObject*) _tmp19_, "next-entry", _tmp25_, g_object_unref);
				}
				_tmp26_ = entry;
				g_signal_connect_object (_tmp26_, "activate", (GCallback) _math_buttons_finc_activate_cb_gtk_entry_activate, self, 0);
				_g_object_unref0 (entry);
			}
		}
	}
	_g_object_unref0 (dialog);
}


static void math_buttons_update_bit_panel (MathButtons* self) {
	GtkWidget* _tmp0_ = NULL;
	Number* x = NULL;
	MathEquation* _tmp1_ = NULL;
	Number* _tmp2_ = NULL;
	Number* _tmp3_ = NULL;
	guint64 bits = 0ULL;
	gboolean enabled = FALSE;
	Number* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	GtkWidget* _tmp23_ = NULL;
	gboolean _tmp24_ = FALSE;
	GtkLabel* _tmp25_ = NULL;
	gboolean _tmp26_ = FALSE;
	gboolean _tmp27_ = FALSE;
	gint i = 0;
	GList* _tmp28_ = NULL;
	gint number_base = 0;
	MathEquation* _tmp37_ = NULL;
	gint _tmp38_ = 0;
	gint _tmp39_ = 0;
	gchar* label = NULL;
	gchar* _tmp40_ = NULL;
	gint _tmp41_ = 0;
	gint _tmp47_ = 0;
	gint _tmp56_ = 0;
	GtkLabel* _tmp65_ = NULL;
	const gchar* _tmp66_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->bit_panel;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->equation;
	_tmp2_ = math_equation_get_number (_tmp1_);
	_tmp3_ = _tmp2_;
	x = _tmp3_;
	bits = (guint64) 0;
	_tmp4_ = x;
	enabled = _tmp4_ != NULL;
	_tmp5_ = enabled;
	if (_tmp5_) {
		Number* max = NULL;
		guint64 _tmp6_ = 0ULL;
		Number* _tmp7_ = NULL;
		Number* fraction = NULL;
		Number* _tmp8_ = NULL;
		Number* _tmp9_ = NULL;
		gboolean _tmp10_ = FALSE;
		gboolean _tmp11_ = FALSE;
		Number* _tmp12_ = NULL;
		gboolean _tmp13_ = FALSE;
		gboolean _tmp17_ = FALSE;
		gboolean _tmp20_ = FALSE;
		_tmp6_ = G_MAXUINT64;
		_tmp7_ = number_new_unsigned_integer (_tmp6_);
		max = _tmp7_;
		_tmp8_ = x;
		_tmp9_ = number_fractional_part (_tmp8_);
		fraction = _tmp9_;
		_tmp12_ = x;
		_tmp13_ = number_is_negative (_tmp12_);
		if (_tmp13_) {
			_tmp11_ = TRUE;
		} else {
			Number* _tmp14_ = NULL;
			Number* _tmp15_ = NULL;
			gint _tmp16_ = 0;
			_tmp14_ = x;
			_tmp15_ = max;
			_tmp16_ = number_compare (_tmp14_, _tmp15_);
			_tmp11_ = _tmp16_ > 0;
		}
		_tmp17_ = _tmp11_;
		if (_tmp17_) {
			_tmp10_ = TRUE;
		} else {
			Number* _tmp18_ = NULL;
			gboolean _tmp19_ = FALSE;
			_tmp18_ = fraction;
			_tmp19_ = number_is_zero (_tmp18_);
			_tmp10_ = !_tmp19_;
		}
		_tmp20_ = _tmp10_;
		if (_tmp20_) {
			enabled = FALSE;
		} else {
			Number* _tmp21_ = NULL;
			guint64 _tmp22_ = 0ULL;
			_tmp21_ = x;
			_tmp22_ = number_to_unsigned_integer (_tmp21_);
			bits = _tmp22_;
		}
		_number_unref0 (fraction);
		_number_unref0 (max);
	}
	_tmp23_ = self->priv->bit_panel;
	_tmp24_ = enabled;
	gtk_widget_set_sensitive (_tmp23_, _tmp24_);
	_tmp25_ = self->priv->base_label;
	_tmp26_ = enabled;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp25_, _tmp26_);
	_tmp27_ = enabled;
	if (!_tmp27_) {
		_number_unref0 (x);
		return;
	}
	i = 0;
	_tmp28_ = self->priv->bit_labels;
	{
		GList* label_collection = NULL;
		GList* label_it = NULL;
		label_collection = _tmp28_;
		for (label_it = label_collection; label_it != NULL; label_it = label_it->next) {
			GtkLabel* _tmp29_ = NULL;
			GtkLabel* label = NULL;
			_tmp29_ = _g_object_ref0 ((GtkLabel*) label_it->data);
			label = _tmp29_;
			{
				gchar* text = NULL;
				gchar* _tmp30_ = NULL;
				guint64 _tmp31_ = 0ULL;
				gint _tmp32_ = 0;
				GtkLabel* _tmp34_ = NULL;
				const gchar* _tmp35_ = NULL;
				gint _tmp36_ = 0;
				_tmp30_ = g_strdup (" 0");
				text = _tmp30_;
				_tmp31_ = bits;
				_tmp32_ = i;
				if ((_tmp31_ & (1LL << _tmp32_)) != ((guint64) 0)) {
					gchar* _tmp33_ = NULL;
					_tmp33_ = g_strdup (" 1");
					_g_free0 (text);
					text = _tmp33_;
				}
				_tmp34_ = label;
				_tmp35_ = text;
				gtk_label_set_text (_tmp34_, _tmp35_);
				_tmp36_ = i;
				i = _tmp36_ + 1;
				_g_free0 (text);
				_g_object_unref0 (label);
			}
		}
	}
	_tmp37_ = self->priv->equation;
	_tmp38_ = math_equation_get_number_base (_tmp37_);
	_tmp39_ = _tmp38_;
	number_base = _tmp39_;
	_tmp40_ = g_strdup ("");
	label = _tmp40_;
	_tmp41_ = number_base;
	if (_tmp41_ != 8) {
		const gchar* _tmp42_ = NULL;
		guint64 _tmp43_ = 0ULL;
		gchar* _tmp44_ = NULL;
		gchar* _tmp45_ = NULL;
		gchar* _tmp46_ = NULL;
		_tmp42_ = label;
		_tmp43_ = bits;
		_tmp44_ = g_strdup_printf ("%llo₈", _tmp43_);
		_tmp45_ = _tmp44_;
		_tmp46_ = g_strconcat (_tmp42_, _tmp45_, NULL);
		_g_free0 (label);
		label = _tmp46_;
		_g_free0 (_tmp45_);
	}
	_tmp47_ = number_base;
	if (_tmp47_ != 10) {
		const gchar* _tmp48_ = NULL;
		const gchar* _tmp51_ = NULL;
		guint64 _tmp52_ = 0ULL;
		gchar* _tmp53_ = NULL;
		gchar* _tmp54_ = NULL;
		gchar* _tmp55_ = NULL;
		_tmp48_ = label;
		if (g_strcmp0 (_tmp48_, "") != 0) {
			const gchar* _tmp49_ = NULL;
			gchar* _tmp50_ = NULL;
			_tmp49_ = label;
			_tmp50_ = g_strconcat (_tmp49_, " = ", NULL);
			_g_free0 (label);
			label = _tmp50_;
		}
		_tmp51_ = label;
		_tmp52_ = bits;
		_tmp53_ = g_strdup_printf ("%llu₁₀", _tmp52_);
		_tmp54_ = _tmp53_;
		_tmp55_ = g_strconcat (_tmp51_, _tmp54_, NULL);
		_g_free0 (label);
		label = _tmp55_;
		_g_free0 (_tmp54_);
	}
	_tmp56_ = number_base;
	if (_tmp56_ != 16) {
		const gchar* _tmp57_ = NULL;
		const gchar* _tmp60_ = NULL;
		guint64 _tmp61_ = 0ULL;
		gchar* _tmp62_ = NULL;
		gchar* _tmp63_ = NULL;
		gchar* _tmp64_ = NULL;
		_tmp57_ = label;
		if (g_strcmp0 (_tmp57_, "") != 0) {
			const gchar* _tmp58_ = NULL;
			gchar* _tmp59_ = NULL;
			_tmp58_ = label;
			_tmp59_ = g_strconcat (_tmp58_, " = ", NULL);
			_g_free0 (label);
			label = _tmp59_;
		}
		_tmp60_ = label;
		_tmp61_ = bits;
		_tmp62_ = g_strdup_printf ("%llX₁₆", _tmp61_);
		_tmp63_ = _tmp62_;
		_tmp64_ = g_strconcat (_tmp60_, _tmp63_, NULL);
		_g_free0 (label);
		label = _tmp64_;
		_g_free0 (_tmp63_);
	}
	_tmp65_ = self->priv->base_label;
	_tmp66_ = label;
	gtk_label_set_text (_tmp65_, _tmp66_);
	_g_free0 (label);
	_number_unref0 (x);
}


static void math_buttons_base_combobox_changed_cb (MathButtons* self, GtkComboBox* combo) {
	GtkTreeModel* model = NULL;
	GtkComboBox* _tmp0_ = NULL;
	GtkTreeModel* _tmp1_ = NULL;
	GtkTreeModel* _tmp2_ = NULL;
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp3_ = NULL;
	GtkTreeIter _tmp4_ = {0};
	gint value = 0;
	GtkTreeIter _tmp5_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo != NULL);
	_tmp0_ = combo;
	_tmp1_ = gtk_combo_box_get_model (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	model = _tmp2_;
	_tmp3_ = combo;
	gtk_combo_box_get_active_iter (_tmp3_, &_tmp4_);
	iter = _tmp4_;
	_tmp5_ = iter;
	gtk_tree_model_get (model, &_tmp5_, 1, &value, -1, -1);
	math_buttons_set_programming_base (self, value);
	_g_object_unref0 (model);
}


static void math_buttons_base_changed_cb (MathButtons* self) {
	ButtonMode _tmp0_ = 0;
	ButtonMode _tmp1_ = 0;
	MathEquation* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	GtkTreeModel* model = NULL;
	GtkComboBox* _tmp5_ = NULL;
	GtkTreeModel* _tmp6_ = NULL;
	GtkTreeModel* _tmp7_ = NULL;
	GtkTreeIter iter = {0};
	gboolean valid = FALSE;
	GtkTreeModel* _tmp8_ = NULL;
	GtkTreeIter _tmp9_ = {0};
	gboolean _tmp10_ = FALSE;
	gboolean _tmp19_ = FALSE;
	GtkComboBox* _tmp23_ = NULL;
	GtkTreeIter _tmp24_ = {0};
	g_return_if_fail (self != NULL);
	_tmp0_ = math_buttons_get_mode (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != BUTTON_MODE_PROGRAMMING) {
		return;
	}
	_tmp2_ = self->priv->equation;
	_tmp3_ = math_equation_get_number_base (_tmp2_);
	_tmp4_ = _tmp3_;
	self->priv->_programming_base = _tmp4_;
	_tmp5_ = self->priv->base_combo;
	_tmp6_ = gtk_combo_box_get_model (_tmp5_);
	_tmp7_ = _g_object_ref0 (_tmp6_);
	model = _tmp7_;
	_tmp8_ = model;
	_tmp10_ = gtk_tree_model_get_iter_first (_tmp8_, &_tmp9_);
	iter = _tmp9_;
	valid = _tmp10_;
	while (TRUE) {
		gboolean _tmp11_ = FALSE;
		gint v = 0;
		GtkTreeModel* _tmp12_ = NULL;
		GtkTreeIter _tmp13_ = {0};
		gint _tmp14_ = 0;
		gint _tmp15_ = 0;
		gint _tmp16_ = 0;
		GtkTreeModel* _tmp17_ = NULL;
		gboolean _tmp18_ = FALSE;
		_tmp11_ = valid;
		if (!_tmp11_) {
			break;
		}
		_tmp12_ = model;
		_tmp13_ = iter;
		gtk_tree_model_get (_tmp12_, &_tmp13_, 1, &v, -1, -1);
		_tmp14_ = v;
		_tmp15_ = math_buttons_get_programming_base (self);
		_tmp16_ = _tmp15_;
		if (_tmp14_ == _tmp16_) {
			break;
		}
		_tmp17_ = model;
		_tmp18_ = gtk_tree_model_iter_next (_tmp17_, &iter);
		valid = _tmp18_;
	}
	_tmp19_ = valid;
	if (!_tmp19_) {
		GtkTreeModel* _tmp20_ = NULL;
		GtkTreeIter _tmp21_ = {0};
		gboolean _tmp22_ = FALSE;
		_tmp20_ = model;
		_tmp22_ = gtk_tree_model_get_iter_first (_tmp20_, &_tmp21_);
		iter = _tmp21_;
		valid = _tmp22_;
	}
	_tmp23_ = self->priv->base_combo;
	_tmp24_ = iter;
	gtk_combo_box_set_active_iter (_tmp23_, &_tmp24_);
	_g_object_unref0 (model);
}


static gchar* g_unichar_to_string (gunichar self) {
	gchar* result = NULL;
	gchar* str = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	_tmp0_ = g_new0 (gchar, 7);
	str = (gchar*) _tmp0_;
	_tmp1_ = str;
	g_unichar_to_utf8 (self, _tmp1_);
	result = str;
	return result;
}


static void ______lambda14_ (MathButtons* self, GtkButton* widget) {
	MathEquation* _tmp0_ = NULL;
	GtkButton* _tmp1_ = NULL;
	gconstpointer _tmp2_ = NULL;
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->equation;
	_tmp1_ = widget;
	_tmp2_ = g_object_get_data ((GObject*) _tmp1_, "calc_digit");
	math_equation_insert_digit (_tmp0_, (guint) ((gint) ((gintptr) _tmp2_)));
}


static void _______lambda14__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	______lambda14_ (self, _sender);
}


static void ___lambda15_ (MathButtons* self) {
	MathEquation* _tmp0_ = NULL;
	_tmp0_ = self->priv->equation;
	math_equation_insert_subtract (_tmp0_);
}


static void ____lambda15__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	___lambda15_ (self);
}


static void ___lambda16_ (MathButtons* self) {
	MathEquation* _tmp0_ = NULL;
	_tmp0_ = self->priv->equation;
	math_equation_insert_square (_tmp0_);
}


static void ____lambda16__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	___lambda16_ (self);
}


static void ___lambda17_ (MathButtons* self) {
	MathEquation* _tmp0_ = NULL;
	_tmp0_ = self->priv->equation;
	gtk_source_buffer_undo ((GtkSourceBuffer*) _tmp0_);
}


static void ____lambda17__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	___lambda17_ (self);
}


static void ___lambda18_ (MathButtons* self) {
	MathEquation* _tmp0_ = NULL;
	_tmp0_ = self->priv->equation;
	math_equation_solve (_tmp0_);
}


static void ____lambda18__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	___lambda18_ (self);
}


static void ___lambda19_ (MathButtons* self) {
	MathEquation* _tmp0_ = NULL;
	_tmp0_ = self->priv->equation;
	math_equation_clear (_tmp0_);
}


static void ____lambda19__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	___lambda19_ (self);
}


static void _math_buttons_memory_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	math_buttons_memory_cb (self, _sender);
}


static void _math_buttons_function_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	math_buttons_function_cb (self, _sender);
}


static void ___lambda22_ (MathButtons* self) {
	MathEquation* _tmp0_ = NULL;
	_tmp0_ = self->priv->equation;
	math_equation_factorize (_tmp0_);
}


static void ____lambda22__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	___lambda22_ (self);
}


static void ___lambda23_ (MathButtons* self) {
	MathEquation* _tmp0_ = NULL;
	_tmp0_ = self->priv->equation;
	math_equation_insert_exponent (_tmp0_);
}


static void ____lambda23__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	___lambda23_ (self);
}


static void _math_buttons_shift_left_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	math_buttons_shift_left_cb (self, _sender);
}


static void _math_buttons_shift_right_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	math_buttons_shift_right_cb (self, _sender);
}


static void _math_buttons_insert_character_code_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	math_buttons_insert_character_code_cb (self, _sender);
}


static void ___lambda26_ (MathButtons* self) {
	MathEquation* _tmp0_ = NULL;
	_tmp0_ = self->priv->equation;
	math_equation_insert_numeric_point (_tmp0_);
}


static void ____lambda26__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	___lambda26_ (self);
}


static void _math_buttons_set_superscript_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	math_buttons_set_superscript_cb (self, _sender);
}


static void _math_buttons_set_subscript_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	math_buttons_set_subscript_cb (self, _sender);
}


static void _math_buttons_character_code_dialog_response_cb_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	math_buttons_character_code_dialog_response_cb (self, _sender, response_id);
}


static gboolean _math_buttons_character_code_dialog_delete_cb_gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self) {
	gboolean result;
	result = math_buttons_character_code_dialog_delete_cb (self, _sender, event);
	return result;
}


static void _math_buttons_character_code_dialog_activate_cb_gtk_entry_activate (GtkEntry* _sender, gpointer self) {
	math_buttons_character_code_dialog_activate_cb (self, _sender);
}


static gboolean _math_buttons_bit_toggle_cb_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = math_buttons_bit_toggle_cb (self, _sender, event);
	return result;
}


static void _math_buttons_base_combobox_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self) {
	math_buttons_base_combobox_changed_cb (self, _sender);
}


static void ___lambda27_ (MathButtons* self, GParamSpec* pspec) {
	g_return_if_fail (pspec != NULL);
	math_buttons_base_changed_cb (self);
}


static void ____lambda27__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	___lambda27_ (self, pspec);
}


static void _math_buttons_finc_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	math_buttons_finc_cb (self, _sender);
}


static GtkWidget* math_buttons_load_mode (MathButtons* self, ButtonMode mode) {
	GtkWidget* result = NULL;
	GtkBuilder* builder = NULL;
	gchar* builder_resource = NULL;
	ButtonMode _tmp0_ = 0;
	GtkWidget* panel = NULL;
	GtkBuilder* _tmp34_ = NULL;
	GObject* _tmp35_ = NULL;
	GtkWidget* _tmp36_ = NULL;
	GtkWidget* _tmp37_ = NULL;
	ButtonMode _tmp38_ = 0;
	GtkBuilder* _tmp47_ = NULL;
	const gchar* _tmp48_ = NULL;
	GtkBuilder* _tmp49_ = NULL;
	const gchar* _tmp50_ = NULL;
	GtkBuilder* _tmp51_ = NULL;
	GtkBuilder* _tmp52_ = NULL;
	GtkBuilder* _tmp53_ = NULL;
	const gchar* _tmp54_ = NULL;
	GtkBuilder* _tmp55_ = NULL;
	const gchar* _tmp56_ = NULL;
	GtkBuilder* _tmp57_ = NULL;
	const gchar* _tmp58_ = NULL;
	GtkBuilder* _tmp59_ = NULL;
	const gchar* _tmp60_ = NULL;
	GtkBuilder* _tmp61_ = NULL;
	const gchar* _tmp62_ = NULL;
	GtkBuilder* _tmp63_ = NULL;
	const gchar* _tmp64_ = NULL;
	GtkBuilder* _tmp65_ = NULL;
	const gchar* _tmp66_ = NULL;
	GtkBuilder* _tmp67_ = NULL;
	const gchar* _tmp68_ = NULL;
	GtkBuilder* _tmp69_ = NULL;
	const gchar* _tmp70_ = NULL;
	GtkBuilder* _tmp71_ = NULL;
	const gchar* _tmp72_ = NULL;
	GtkBuilder* _tmp73_ = NULL;
	const gchar* _tmp74_ = NULL;
	GtkBuilder* _tmp75_ = NULL;
	const gchar* _tmp76_ = NULL;
	GtkBuilder* _tmp77_ = NULL;
	const gchar* _tmp78_ = NULL;
	GtkBuilder* _tmp79_ = NULL;
	const gchar* _tmp80_ = NULL;
	GtkBuilder* _tmp81_ = NULL;
	const gchar* _tmp82_ = NULL;
	GtkBuilder* _tmp83_ = NULL;
	const gchar* _tmp84_ = NULL;
	GtkBuilder* _tmp85_ = NULL;
	const gchar* _tmp86_ = NULL;
	GtkBuilder* _tmp87_ = NULL;
	const gchar* _tmp88_ = NULL;
	GtkBuilder* _tmp89_ = NULL;
	const gchar* _tmp90_ = NULL;
	GtkBuilder* _tmp91_ = NULL;
	const gchar* _tmp92_ = NULL;
	GtkBuilder* _tmp93_ = NULL;
	const gchar* _tmp94_ = NULL;
	GtkBuilder* _tmp95_ = NULL;
	const gchar* _tmp96_ = NULL;
	GtkBuilder* _tmp97_ = NULL;
	const gchar* _tmp98_ = NULL;
	GtkBuilder* _tmp99_ = NULL;
	const gchar* _tmp100_ = NULL;
	GtkBuilder* _tmp101_ = NULL;
	const gchar* _tmp102_ = NULL;
	GtkBuilder* _tmp103_ = NULL;
	const gchar* _tmp104_ = NULL;
	GtkBuilder* _tmp105_ = NULL;
	const gchar* _tmp106_ = NULL;
	GtkBuilder* _tmp107_ = NULL;
	const gchar* _tmp108_ = NULL;
	GtkBuilder* _tmp109_ = NULL;
	const gchar* _tmp110_ = NULL;
	GtkBuilder* _tmp111_ = NULL;
	const gchar* _tmp112_ = NULL;
	GtkBuilder* _tmp113_ = NULL;
	const gchar* _tmp114_ = NULL;
	GtkBuilder* _tmp115_ = NULL;
	const gchar* _tmp116_ = NULL;
	GtkBuilder* _tmp117_ = NULL;
	const gchar* _tmp118_ = NULL;
	GtkBuilder* _tmp119_ = NULL;
	const gchar* _tmp120_ = NULL;
	GtkBuilder* _tmp121_ = NULL;
	const gchar* _tmp122_ = NULL;
	GtkBuilder* _tmp123_ = NULL;
	const gchar* _tmp124_ = NULL;
	GtkBuilder* _tmp125_ = NULL;
	const gchar* _tmp126_ = NULL;
	GtkBuilder* _tmp127_ = NULL;
	const gchar* _tmp128_ = NULL;
	GtkBuilder* _tmp129_ = NULL;
	const gchar* _tmp130_ = NULL;
	GtkBuilder* _tmp131_ = NULL;
	const gchar* _tmp132_ = NULL;
	GtkBuilder* _tmp133_ = NULL;
	const gchar* _tmp134_ = NULL;
	GtkBuilder* _tmp135_ = NULL;
	const gchar* _tmp136_ = NULL;
	GtkBuilder* _tmp137_ = NULL;
	const gchar* _tmp138_ = NULL;
	GtkBuilder* _tmp139_ = NULL;
	const gchar* _tmp140_ = NULL;
	GtkBuilder* _tmp141_ = NULL;
	const gchar* _tmp142_ = NULL;
	GtkBuilder* _tmp143_ = NULL;
	const gchar* _tmp144_ = NULL;
	GtkBuilder* _tmp145_ = NULL;
	const gchar* _tmp146_ = NULL;
	GtkBuilder* _tmp147_ = NULL;
	const gchar* _tmp148_ = NULL;
	GtkBuilder* _tmp149_ = NULL;
	const gchar* _tmp150_ = NULL;
	GtkBuilder* _tmp151_ = NULL;
	const gchar* _tmp152_ = NULL;
	GtkBuilder* _tmp153_ = NULL;
	const gchar* _tmp154_ = NULL;
	GtkBuilder* _tmp155_ = NULL;
	const gchar* _tmp156_ = NULL;
	GtkBuilder* _tmp157_ = NULL;
	const gchar* _tmp158_ = NULL;
	GtkBuilder* _tmp159_ = NULL;
	const gchar* _tmp160_ = NULL;
	GtkBuilder* _tmp161_ = NULL;
	const gchar* _tmp162_ = NULL;
	GtkBuilder* _tmp163_ = NULL;
	const gchar* _tmp164_ = NULL;
	GtkBuilder* _tmp165_ = NULL;
	const gchar* _tmp166_ = NULL;
	GtkButton* button = NULL;
	GtkBuilder* _tmp187_ = NULL;
	GObject* _tmp188_ = NULL;
	GtkButton* _tmp189_ = NULL;
	GtkButton* _tmp190_ = NULL;
	GtkBuilder* _tmp192_ = NULL;
	GObject* _tmp193_ = NULL;
	GtkButton* _tmp194_ = NULL;
	GtkButton* _tmp195_ = NULL;
	GtkBuilder* _tmp199_ = NULL;
	GObject* _tmp200_ = NULL;
	GtkButton* _tmp201_ = NULL;
	GtkButton* _tmp202_ = NULL;
	GtkBuilder* _tmp204_ = NULL;
	GObject* _tmp205_ = NULL;
	GtkButton* _tmp206_ = NULL;
	GtkButton* _tmp207_ = NULL;
	GtkBuilder* _tmp209_ = NULL;
	GObject* _tmp210_ = NULL;
	GtkButton* _tmp211_ = NULL;
	GtkButton* _tmp212_ = NULL;
	GtkBuilder* _tmp214_ = NULL;
	GObject* _tmp215_ = NULL;
	GtkButton* _tmp216_ = NULL;
	GtkButton* _tmp217_ = NULL;
	GtkBuilder* _tmp219_ = NULL;
	GObject* _tmp220_ = NULL;
	GtkButton* _tmp221_ = NULL;
	GtkButton* _tmp222_ = NULL;
	GtkBuilder* _tmp224_ = NULL;
	GObject* _tmp225_ = NULL;
	GtkButton* _tmp226_ = NULL;
	GtkButton* _tmp227_ = NULL;
	GtkBuilder* _tmp229_ = NULL;
	GObject* _tmp230_ = NULL;
	GtkButton* _tmp231_ = NULL;
	GtkButton* _tmp232_ = NULL;
	GtkBuilder* _tmp234_ = NULL;
	GObject* _tmp235_ = NULL;
	GtkButton* _tmp236_ = NULL;
	GtkButton* _tmp237_ = NULL;
	GtkBuilder* _tmp239_ = NULL;
	GObject* _tmp240_ = NULL;
	GtkButton* _tmp241_ = NULL;
	GtkButton* _tmp242_ = NULL;
	GtkBuilder* _tmp244_ = NULL;
	GObject* _tmp245_ = NULL;
	GtkButton* _tmp246_ = NULL;
	GtkButton* _tmp247_ = NULL;
	GtkBuilder* _tmp249_ = NULL;
	GObject* _tmp250_ = NULL;
	GtkButton* _tmp251_ = NULL;
	GtkButton* _tmp252_ = NULL;
	GtkToggleButton* toggle_button = NULL;
	GtkBuilder* _tmp261_ = NULL;
	GObject* _tmp262_ = NULL;
	GtkToggleButton* _tmp263_ = NULL;
	GtkToggleButton* _tmp264_ = NULL;
	GtkBuilder* _tmp272_ = NULL;
	GObject* _tmp273_ = NULL;
	GtkToggleButton* _tmp274_ = NULL;
	GtkToggleButton* _tmp275_ = NULL;
	ButtonMode _tmp283_ = 0;
	ButtonMode _tmp351_ = 0;
	GtkBuilder* _tmp422_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = mode;
	switch (_tmp0_) {
		default:
		case BUTTON_MODE_BASIC:
		{
			GtkWidget* _tmp1_ = NULL;
			GtkBuilder* _tmp4_ = NULL;
			GtkBuilder* _tmp5_ = NULL;
			GtkBuilder* _tmp6_ = NULL;
			gchar* _tmp7_ = NULL;
			_tmp1_ = self->priv->bas_panel;
			if (_tmp1_ != NULL) {
				GtkWidget* _tmp2_ = NULL;
				GtkWidget* _tmp3_ = NULL;
				_tmp2_ = self->priv->bas_panel;
				_tmp3_ = _g_object_ref0 (_tmp2_);
				result = _tmp3_;
				_g_free0 (builder_resource);
				_g_object_unref0 (builder);
				return result;
			}
			_tmp4_ = gtk_builder_new ();
			_g_object_unref0 (self->priv->basic_ui);
			self->priv->basic_ui = _tmp4_;
			_tmp5_ = self->priv->basic_ui;
			_tmp6_ = _g_object_ref0 (_tmp5_);
			_g_object_unref0 (builder);
			builder = _tmp6_;
			_tmp7_ = g_strdup ("buttons-basic.ui");
			_g_free0 (builder_resource);
			builder_resource = _tmp7_;
			break;
		}
		case BUTTON_MODE_ADVANCED:
		{
			GtkWidget* _tmp8_ = NULL;
			GtkBuilder* _tmp11_ = NULL;
			GtkBuilder* _tmp12_ = NULL;
			GtkBuilder* _tmp13_ = NULL;
			gchar* _tmp14_ = NULL;
			_tmp8_ = self->priv->adv_panel;
			if (_tmp8_ != NULL) {
				GtkWidget* _tmp9_ = NULL;
				GtkWidget* _tmp10_ = NULL;
				_tmp9_ = self->priv->adv_panel;
				_tmp10_ = _g_object_ref0 (_tmp9_);
				result = _tmp10_;
				_g_free0 (builder_resource);
				_g_object_unref0 (builder);
				return result;
			}
			_tmp11_ = gtk_builder_new ();
			_g_object_unref0 (self->priv->advanced_ui);
			self->priv->advanced_ui = _tmp11_;
			_tmp12_ = self->priv->advanced_ui;
			_tmp13_ = _g_object_ref0 (_tmp12_);
			_g_object_unref0 (builder);
			builder = _tmp13_;
			_tmp14_ = g_strdup ("buttons-advanced.ui");
			_g_free0 (builder_resource);
			builder_resource = _tmp14_;
			break;
		}
		case BUTTON_MODE_FINANCIAL:
		{
			GtkWidget* _tmp15_ = NULL;
			GtkBuilder* _tmp18_ = NULL;
			GtkBuilder* _tmp19_ = NULL;
			GtkBuilder* _tmp20_ = NULL;
			gchar* _tmp21_ = NULL;
			_tmp15_ = self->priv->fin_panel;
			if (_tmp15_ != NULL) {
				GtkWidget* _tmp16_ = NULL;
				GtkWidget* _tmp17_ = NULL;
				_tmp16_ = self->priv->fin_panel;
				_tmp17_ = _g_object_ref0 (_tmp16_);
				result = _tmp17_;
				_g_free0 (builder_resource);
				_g_object_unref0 (builder);
				return result;
			}
			_tmp18_ = gtk_builder_new ();
			_g_object_unref0 (self->priv->financial_ui);
			self->priv->financial_ui = _tmp18_;
			_tmp19_ = self->priv->financial_ui;
			_tmp20_ = _g_object_ref0 (_tmp19_);
			_g_object_unref0 (builder);
			builder = _tmp20_;
			_tmp21_ = g_strdup ("buttons-financial.ui");
			_g_free0 (builder_resource);
			builder_resource = _tmp21_;
			break;
		}
		case BUTTON_MODE_PROGRAMMING:
		{
			GtkWidget* _tmp22_ = NULL;
			GtkBuilder* _tmp25_ = NULL;
			GtkBuilder* _tmp26_ = NULL;
			GtkBuilder* _tmp27_ = NULL;
			gchar* _tmp28_ = NULL;
			_tmp22_ = self->priv->prog_panel;
			if (_tmp22_ != NULL) {
				GtkWidget* _tmp23_ = NULL;
				GtkWidget* _tmp24_ = NULL;
				_tmp23_ = self->priv->prog_panel;
				_tmp24_ = _g_object_ref0 (_tmp23_);
				result = _tmp24_;
				_g_free0 (builder_resource);
				_g_object_unref0 (builder);
				return result;
			}
			_tmp25_ = gtk_builder_new ();
			_g_object_unref0 (self->priv->programming_ui);
			self->priv->programming_ui = _tmp25_;
			_tmp26_ = self->priv->programming_ui;
			_tmp27_ = _g_object_ref0 (_tmp26_);
			_g_object_unref0 (builder);
			builder = _tmp27_;
			_tmp28_ = g_strdup ("buttons-programming.ui");
			_g_free0 (builder_resource);
			builder_resource = _tmp28_;
			break;
		}
	}
	{
		GtkBuilder* _tmp29_ = NULL;
		const gchar* _tmp30_ = NULL;
		gchar* _tmp31_ = NULL;
		gchar* _tmp32_ = NULL;
		_tmp29_ = builder;
		_tmp30_ = builder_resource;
		_tmp31_ = g_strdup_printf ("/org/gnome/calculator/%s", _tmp30_);
		_tmp32_ = _tmp31_;
		gtk_builder_add_from_resource (_tmp29_, _tmp32_, &_inner_error_);
		_g_free0 (_tmp32_);
		if (_inner_error_ != NULL) {
			goto __catch8_g_error;
		}
	}
	goto __finally8;
	__catch8_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp33_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp33_ = e->message;
		g_error ("math-buttons.vala:266: Error loading button UI: %s", _tmp33_);
		_g_error_free0 (e);
	}
	__finally8:
	if (_inner_error_ != NULL) {
		_g_free0 (builder_resource);
		_g_object_unref0 (builder);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp34_ = builder;
	_tmp35_ = gtk_builder_get_object (_tmp34_, "button_panel");
	_tmp36_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp35_, GTK_TYPE_WIDGET) ? ((GtkWidget*) _tmp35_) : NULL);
	panel = _tmp36_;
	_tmp37_ = panel;
	gtk_box_pack_end ((GtkBox*) self, _tmp37_, TRUE, TRUE, (guint) 0);
	_tmp38_ = mode;
	switch (_tmp38_) {
		default:
		case BUTTON_MODE_BASIC:
		{
			GtkWidget* _tmp39_ = NULL;
			GtkWidget* _tmp40_ = NULL;
			_tmp39_ = panel;
			_tmp40_ = _g_object_ref0 (_tmp39_);
			_g_object_unref0 (self->priv->bas_panel);
			self->priv->bas_panel = _tmp40_;
			break;
		}
		case BUTTON_MODE_ADVANCED:
		{
			GtkWidget* _tmp41_ = NULL;
			GtkWidget* _tmp42_ = NULL;
			_tmp41_ = panel;
			_tmp42_ = _g_object_ref0 (_tmp41_);
			_g_object_unref0 (self->priv->adv_panel);
			self->priv->adv_panel = _tmp42_;
			break;
		}
		case BUTTON_MODE_FINANCIAL:
		{
			GtkWidget* _tmp43_ = NULL;
			GtkWidget* _tmp44_ = NULL;
			_tmp43_ = panel;
			_tmp44_ = _g_object_ref0 (_tmp43_);
			_g_object_unref0 (self->priv->fin_panel);
			self->priv->fin_panel = _tmp44_;
			break;
		}
		case BUTTON_MODE_PROGRAMMING:
		{
			GtkWidget* _tmp45_ = NULL;
			GtkWidget* _tmp46_ = NULL;
			_tmp45_ = panel;
			_tmp46_ = _g_object_ref0 (_tmp45_);
			_g_object_unref0 (self->priv->prog_panel);
			self->priv->prog_panel = _tmp46_;
			break;
		}
	}
	_tmp47_ = builder;
	_tmp48_ = _ ("Pi [Ctrl+P]");
	math_buttons_setup_button (self, _tmp47_, "pi", "π", _tmp48_, TRUE);
	_tmp49_ = builder;
	_tmp50_ = _ ("Euler’s Number");
	math_buttons_setup_button (self, _tmp49_, "eulers_number", "e", _tmp50_, TRUE);
	_tmp51_ = builder;
	math_buttons_setup_button (self, _tmp51_, "imaginary", "i", NULL, TRUE);
	_tmp52_ = builder;
	math_buttons_setup_button (self, _tmp52_, "numeric_point", NULL, NULL, TRUE);
	_tmp53_ = builder;
	_tmp54_ = _ ("Subscript mode [Alt]");
	math_buttons_setup_button (self, _tmp53_, "subscript", NULL, _tmp54_, TRUE);
	_tmp55_ = builder;
	_tmp56_ = _ ("Superscript mode [Ctrl]");
	math_buttons_setup_button (self, _tmp55_, "superscript", NULL, _tmp56_, TRUE);
	_tmp57_ = builder;
	_tmp58_ = _ ("Scientific exponent [Ctrl+E]");
	math_buttons_setup_button (self, _tmp57_, "exponential", NULL, _tmp58_, TRUE);
	_tmp59_ = builder;
	_tmp60_ = _ ("Add [+]");
	math_buttons_setup_button (self, _tmp59_, "add", "+", _tmp60_, TRUE);
	_tmp61_ = builder;
	_tmp62_ = _ ("Subtract [-]");
	math_buttons_setup_button (self, _tmp61_, "subtract", "−", _tmp62_, FALSE);
	_tmp63_ = builder;
	_tmp64_ = _ ("Multiply [*]");
	math_buttons_setup_button (self, _tmp63_, "multiply", "×", _tmp64_, TRUE);
	_tmp65_ = builder;
	_tmp66_ = _ ("Divide [/]");
	math_buttons_setup_button (self, _tmp65_, "divide", "÷", _tmp66_, TRUE);
	_tmp67_ = builder;
	_tmp68_ = _ ("Modulus divide");
	math_buttons_setup_button (self, _tmp67_, "modulus_divide", " mod ", _tmp68_, TRUE);
	_tmp69_ = builder;
	_tmp70_ = _ ("Additional Functions");
	math_buttons_setup_button (self, _tmp69_, "function", NULL, _tmp70_, TRUE);
	_tmp71_ = builder;
	_tmp72_ = _ ("Exponent [^ or **]");
	math_buttons_setup_button (self, _tmp71_, "x_pow_y", "^", _tmp72_, TRUE);
	_tmp73_ = builder;
	_tmp74_ = _ ("Percentage [%]");
	math_buttons_setup_button (self, _tmp73_, "percentage", "%", _tmp74_, TRUE);
	_tmp75_ = builder;
	_tmp76_ = _ ("Factorial [!]");
	math_buttons_setup_button (self, _tmp75_, "factorial", "!", _tmp76_, TRUE);
	_tmp77_ = builder;
	_tmp78_ = _ ("Absolute value [|]");
	math_buttons_setup_button (self, _tmp77_, "abs", "|", _tmp78_, TRUE);
	_tmp79_ = builder;
	_tmp80_ = _ ("Complex argument");
	math_buttons_setup_button (self, _tmp79_, "arg", "Arg ", _tmp80_, TRUE);
	_tmp81_ = builder;
	_tmp82_ = _ ("Complex conjugate");
	math_buttons_setup_button (self, _tmp81_, "conjugate", "conj ", _tmp82_, TRUE);
	_tmp83_ = builder;
	_tmp84_ = _ ("Root [Ctrl+R]");
	math_buttons_setup_button (self, _tmp83_, "root", "√", _tmp84_, TRUE);
	_tmp85_ = builder;
	_tmp86_ = _ ("Square root [Ctrl+R]");
	math_buttons_setup_button (self, _tmp85_, "square_root", "√", _tmp86_, TRUE);
	_tmp87_ = builder;
	_tmp88_ = _ ("Logarithm");
	math_buttons_setup_button (self, _tmp87_, "logarithm", "log ", _tmp88_, TRUE);
	_tmp89_ = builder;
	_tmp90_ = _ ("Natural Logarithm");
	math_buttons_setup_button (self, _tmp89_, "natural_logarithm", "ln ", _tmp90_, TRUE);
	_tmp91_ = builder;
	_tmp92_ = _ ("Sine");
	math_buttons_setup_button (self, _tmp91_, "sine", "sin ", _tmp92_, TRUE);
	_tmp93_ = builder;
	_tmp94_ = _ ("Cosine");
	math_buttons_setup_button (self, _tmp93_, "cosine", "cos ", _tmp94_, TRUE);
	_tmp95_ = builder;
	_tmp96_ = _ ("Tangent");
	math_buttons_setup_button (self, _tmp95_, "tangent", "tan ", _tmp96_, TRUE);
	_tmp97_ = builder;
	_tmp98_ = _ ("Hyperbolic Sine");
	math_buttons_setup_button (self, _tmp97_, "hyperbolic_sine", "sinh ", _tmp98_, TRUE);
	_tmp99_ = builder;
	_tmp100_ = _ ("Hyperbolic Cosine");
	math_buttons_setup_button (self, _tmp99_, "hyperbolic_cosine", "cosh ", _tmp100_, TRUE);
	_tmp101_ = builder;
	_tmp102_ = _ ("Hyperbolic Tangent");
	math_buttons_setup_button (self, _tmp101_, "hyperbolic_tangent", "tanh ", _tmp102_, TRUE);
	_tmp103_ = builder;
	_tmp104_ = _ ("Inverse [Ctrl+I]");
	math_buttons_setup_button (self, _tmp103_, "inverse", "⁻¹", _tmp104_, TRUE);
	_tmp105_ = builder;
	_tmp106_ = _ ("Boolean AND");
	math_buttons_setup_button (self, _tmp105_, "and", "∧", _tmp106_, TRUE);
	_tmp107_ = builder;
	_tmp108_ = _ ("Boolean OR");
	math_buttons_setup_button (self, _tmp107_, "or", "∨", _tmp108_, TRUE);
	_tmp109_ = builder;
	_tmp110_ = _ ("Boolean Exclusive OR");
	math_buttons_setup_button (self, _tmp109_, "xor", "⊻", _tmp110_, TRUE);
	_tmp111_ = builder;
	_tmp112_ = _ ("Boolean NOT");
	math_buttons_setup_button (self, _tmp111_, "not", "¬", _tmp112_, TRUE);
	_tmp113_ = builder;
	_tmp114_ = _ ("Integer Component");
	math_buttons_setup_button (self, _tmp113_, "integer_portion", "int ", _tmp114_, TRUE);
	_tmp115_ = builder;
	_tmp116_ = _ ("Fractional Component");
	math_buttons_setup_button (self, _tmp115_, "fractional_portion", "frac ", _tmp116_, TRUE);
	_tmp117_ = builder;
	_tmp118_ = _ ("Real Component");
	math_buttons_setup_button (self, _tmp117_, "real_portion", "Re ", _tmp118_, TRUE);
	_tmp119_ = builder;
	_tmp120_ = _ ("Imaginary Component");
	math_buttons_setup_button (self, _tmp119_, "imaginary_portion", "Im ", _tmp120_, TRUE);
	_tmp121_ = builder;
	_tmp122_ = _ ("Ones' Complement");
	math_buttons_setup_button (self, _tmp121_, "ones_complement", "ones ", _tmp122_, TRUE);
	_tmp123_ = builder;
	_tmp124_ = _ ("Two's Complement");
	math_buttons_setup_button (self, _tmp123_, "twos_complement", "twos ", _tmp124_, TRUE);
	_tmp125_ = builder;
	_tmp126_ = _ ("Truncate");
	math_buttons_setup_button (self, _tmp125_, "trunc", "trunc ", _tmp126_, TRUE);
	_tmp127_ = builder;
	_tmp128_ = _ ("Start Group [(]");
	math_buttons_setup_button (self, _tmp127_, "start_group", "(", _tmp128_, TRUE);
	_tmp129_ = builder;
	_tmp130_ = _ ("End Group [)]");
	math_buttons_setup_button (self, _tmp129_, "end_group", ")", _tmp130_, TRUE);
	_tmp131_ = builder;
	_tmp132_ = _ ("Memory");
	math_buttons_setup_button (self, _tmp131_, "memory", NULL, _tmp132_, TRUE);
	_tmp133_ = builder;
	_tmp134_ = _ ("Insert Character Code");
	math_buttons_setup_button (self, _tmp133_, "character", NULL, _tmp134_, TRUE);
	_tmp135_ = builder;
	_tmp136_ = _ ("Calculate Result");
	math_buttons_setup_button (self, _tmp135_, "result", NULL, _tmp136_, TRUE);
	_tmp137_ = builder;
	_tmp138_ = _ ("Factorize [Ctrl+F]");
	math_buttons_setup_button (self, _tmp137_, "factor", NULL, _tmp138_, TRUE);
	_tmp139_ = builder;
	_tmp140_ = _ ("Clear Display [Escape]");
	math_buttons_setup_button (self, _tmp139_, "clear", NULL, _tmp140_, TRUE);
	_tmp141_ = builder;
	_tmp142_ = _ ("Undo [Ctrl+Z]");
	math_buttons_setup_button (self, _tmp141_, "undo", NULL, _tmp142_, TRUE);
	_tmp143_ = builder;
	_tmp144_ = _ ("Shift Left");
	math_buttons_setup_button (self, _tmp143_, "shift_left", NULL, _tmp144_, TRUE);
	_tmp145_ = builder;
	_tmp146_ = _ ("Shift Right");
	math_buttons_setup_button (self, _tmp145_, "shift_right", NULL, _tmp146_, TRUE);
	_tmp147_ = builder;
	_tmp148_ = _ ("Compounding Term");
	math_buttons_setup_button (self, _tmp147_, "finc_compounding_term", NULL, _tmp148_, TRUE);
	_tmp149_ = builder;
	_tmp150_ = _ ("Double Declining Depreciation");
	math_buttons_setup_button (self, _tmp149_, "finc_double_declining_depreciation", NULL, _tmp150_, TRUE);
	_tmp151_ = builder;
	_tmp152_ = _ ("Future Value");
	math_buttons_setup_button (self, _tmp151_, "finc_future_value", NULL, _tmp152_, TRUE);
	_tmp153_ = builder;
	_tmp154_ = _ ("Financial Term");
	math_buttons_setup_button (self, _tmp153_, "finc_term", NULL, _tmp154_, TRUE);
	_tmp155_ = builder;
	_tmp156_ = _ ("Sum of the Years Digits Depreciation");
	math_buttons_setup_button (self, _tmp155_, "finc_sum_of_the_years_digits_depreciation", NULL, _tmp156_, TRUE);
	_tmp157_ = builder;
	_tmp158_ = _ ("Straight Line Depreciation");
	math_buttons_setup_button (self, _tmp157_, "finc_straight_line_depreciation", NULL, _tmp158_, TRUE);
	_tmp159_ = builder;
	_tmp160_ = _ ("Periodic Interest Rate");
	math_buttons_setup_button (self, _tmp159_, "finc_periodic_interest_rate", NULL, _tmp160_, TRUE);
	_tmp161_ = builder;
	_tmp162_ = _ ("Present Value");
	math_buttons_setup_button (self, _tmp161_, "finc_present_value", NULL, _tmp162_, TRUE);
	_tmp163_ = builder;
	_tmp164_ = _ ("Periodic Payment");
	math_buttons_setup_button (self, _tmp163_, "finc_periodic_payment", NULL, _tmp164_, TRUE);
	_tmp165_ = builder;
	_tmp166_ = _ ("Gross Profit Margin");
	math_buttons_setup_button (self, _tmp165_, "finc_gross_profit_margin", NULL, _tmp166_, TRUE);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp167_ = FALSE;
			_tmp167_ = TRUE;
			while (TRUE) {
				gboolean _tmp168_ = FALSE;
				gint _tmp170_ = 0;
				gchar* name = NULL;
				gint _tmp171_ = 0;
				gchar* _tmp172_ = NULL;
				GtkButton* button = NULL;
				GtkBuilder* _tmp173_ = NULL;
				const gchar* _tmp174_ = NULL;
				GObject* _tmp175_ = NULL;
				GtkButton* _tmp176_ = NULL;
				GtkButton* _tmp177_ = NULL;
				_tmp168_ = _tmp167_;
				if (!_tmp168_) {
					gint _tmp169_ = 0;
					_tmp169_ = i;
					i = _tmp169_ + 1;
				}
				_tmp167_ = FALSE;
				_tmp170_ = i;
				if (!(_tmp170_ < 16)) {
					break;
				}
				_tmp171_ = i;
				_tmp172_ = g_strdup_printf ("calc_%d_button", _tmp171_);
				name = _tmp172_;
				_tmp173_ = builder;
				_tmp174_ = name;
				_tmp175_ = gtk_builder_get_object (_tmp173_, _tmp174_);
				_tmp176_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp175_, GTK_TYPE_BUTTON) ? ((GtkButton*) _tmp175_) : NULL);
				button = _tmp176_;
				_tmp177_ = button;
				if (_tmp177_ != NULL) {
					GtkButton* _tmp178_ = NULL;
					gint _tmp179_ = 0;
					GtkButton* _tmp180_ = NULL;
					MathEquation* _tmp181_ = NULL;
					gint _tmp182_ = 0;
					gunichar _tmp183_ = 0U;
					gchar* _tmp184_ = NULL;
					gchar* _tmp185_ = NULL;
					GtkButton* _tmp186_ = NULL;
					_tmp178_ = button;
					_tmp179_ = i;
					g_object_set_data_full ((GObject*) _tmp178_, "calc_digit", (gpointer) ((gintptr) _tmp179_), NULL);
					_tmp180_ = button;
					_tmp181_ = self->priv->equation;
					_tmp182_ = i;
					_tmp183_ = math_equation_get_digit_text (_tmp181_, (guint) _tmp182_);
					_tmp184_ = g_unichar_to_string (_tmp183_);
					_tmp185_ = _tmp184_;
					gtk_button_set_label (_tmp180_, _tmp185_);
					_g_free0 (_tmp185_);
					_tmp186_ = button;
					g_signal_connect_object (_tmp186_, "clicked", (GCallback) _______lambda14__gtk_button_clicked, self, 0);
				}
				_g_object_unref0 (button);
				_g_free0 (name);
			}
		}
	}
	_tmp187_ = builder;
	_tmp188_ = gtk_builder_get_object (_tmp187_, "calc_subtract_button");
	_tmp189_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp188_, GTK_TYPE_BUTTON) ? ((GtkButton*) _tmp188_) : NULL);
	button = _tmp189_;
	_tmp190_ = button;
	if (_tmp190_ != NULL) {
		GtkButton* _tmp191_ = NULL;
		_tmp191_ = button;
		g_signal_connect_object (_tmp191_, "clicked", (GCallback) ____lambda15__gtk_button_clicked, self, 0);
	}
	_tmp192_ = builder;
	_tmp193_ = gtk_builder_get_object (_tmp192_, "calc_x_squared_button");
	_tmp194_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp193_, GTK_TYPE_BUTTON) ? ((GtkButton*) _tmp193_) : NULL);
	_g_object_unref0 (button);
	button = _tmp194_;
	_tmp195_ = button;
	if (_tmp195_ != NULL) {
		GtkButton* _tmp196_ = NULL;
		GtkButton* _tmp197_ = NULL;
		const gchar* _tmp198_ = NULL;
		_tmp196_ = button;
		g_signal_connect_object (_tmp196_, "clicked", (GCallback) ____lambda16__gtk_button_clicked, self, 0);
		_tmp197_ = button;
		_tmp198_ = _ ("Square [Ctrl+2]");
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp197_, _tmp198_);
	}
	_tmp199_ = builder;
	_tmp200_ = gtk_builder_get_object (_tmp199_, "calc_undo_button");
	_tmp201_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp200_, GTK_TYPE_BUTTON) ? ((GtkButton*) _tmp200_) : NULL);
	_g_object_unref0 (button);
	button = _tmp201_;
	_tmp202_ = button;
	if (_tmp202_ != NULL) {
		GtkButton* _tmp203_ = NULL;
		_tmp203_ = button;
		g_signal_connect_object (_tmp203_, "clicked", (GCallback) ____lambda17__gtk_button_clicked, self, 0);
	}
	_tmp204_ = builder;
	_tmp205_ = gtk_builder_get_object (_tmp204_, "calc_result_button");
	_tmp206_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp205_, GTK_TYPE_BUTTON) ? ((GtkButton*) _tmp205_) : NULL);
	_g_object_unref0 (button);
	button = _tmp206_;
	_tmp207_ = button;
	if (_tmp207_ != NULL) {
		GtkButton* _tmp208_ = NULL;
		_tmp208_ = button;
		g_signal_connect_object (_tmp208_, "clicked", (GCallback) ____lambda18__gtk_button_clicked, self, 0);
	}
	_tmp209_ = builder;
	_tmp210_ = gtk_builder_get_object (_tmp209_, "calc_clear_button");
	_tmp211_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp210_, GTK_TYPE_BUTTON) ? ((GtkButton*) _tmp210_) : NULL);
	_g_object_unref0 (button);
	button = _tmp211_;
	_tmp212_ = button;
	if (_tmp212_ != NULL) {
		GtkButton* _tmp213_ = NULL;
		_tmp213_ = button;
		g_signal_connect_object (_tmp213_, "clicked", (GCallback) ____lambda19__gtk_button_clicked, self, 0);
	}
	_tmp214_ = builder;
	_tmp215_ = gtk_builder_get_object (_tmp214_, "calc_memory_button");
	_tmp216_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp215_, GTK_TYPE_BUTTON) ? ((GtkButton*) _tmp215_) : NULL);
	_g_object_unref0 (button);
	button = _tmp216_;
	_tmp217_ = button;
	if (_tmp217_ != NULL) {
		GtkButton* _tmp218_ = NULL;
		_tmp218_ = button;
		g_signal_connect_object (_tmp218_, "clicked", (GCallback) _math_buttons_memory_cb_gtk_button_clicked, self, 0);
	}
	_tmp219_ = builder;
	_tmp220_ = gtk_builder_get_object (_tmp219_, "calc_function_button");
	_tmp221_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp220_, GTK_TYPE_BUTTON) ? ((GtkButton*) _tmp220_) : NULL);
	_g_object_unref0 (button);
	button = _tmp221_;
	_tmp222_ = button;
	if (_tmp222_ != NULL) {
		GtkButton* _tmp223_ = NULL;
		_tmp223_ = button;
		g_signal_connect_object (_tmp223_, "clicked", (GCallback) _math_buttons_function_cb_gtk_button_clicked, self, 0);
	}
	_tmp224_ = builder;
	_tmp225_ = gtk_builder_get_object (_tmp224_, "calc_factor_button");
	_tmp226_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp225_, GTK_TYPE_BUTTON) ? ((GtkButton*) _tmp225_) : NULL);
	_g_object_unref0 (button);
	button = _tmp226_;
	_tmp227_ = button;
	if (_tmp227_ != NULL) {
		GtkButton* _tmp228_ = NULL;
		_tmp228_ = button;
		g_signal_connect_object (_tmp228_, "clicked", (GCallback) ____lambda22__gtk_button_clicked, self, 0);
	}
	_tmp229_ = builder;
	_tmp230_ = gtk_builder_get_object (_tmp229_, "calc_exponential_button");
	_tmp231_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp230_, GTK_TYPE_BUTTON) ? ((GtkButton*) _tmp230_) : NULL);
	_g_object_unref0 (button);
	button = _tmp231_;
	_tmp232_ = button;
	if (_tmp232_ != NULL) {
		GtkButton* _tmp233_ = NULL;
		_tmp233_ = button;
		g_signal_connect_object (_tmp233_, "clicked", (GCallback) ____lambda23__gtk_button_clicked, self, 0);
	}
	_tmp234_ = builder;
	_tmp235_ = gtk_builder_get_object (_tmp234_, "calc_shift_left_button");
	_tmp236_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp235_, GTK_TYPE_BUTTON) ? ((GtkButton*) _tmp235_) : NULL);
	_g_object_unref0 (button);
	button = _tmp236_;
	_tmp237_ = button;
	if (_tmp237_ != NULL) {
		GtkButton* _tmp238_ = NULL;
		_tmp238_ = button;
		g_signal_connect_object (_tmp238_, "clicked", (GCallback) _math_buttons_shift_left_cb_gtk_button_clicked, self, 0);
	}
	_tmp239_ = builder;
	_tmp240_ = gtk_builder_get_object (_tmp239_, "calc_shift_right_button");
	_tmp241_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp240_, GTK_TYPE_BUTTON) ? ((GtkButton*) _tmp240_) : NULL);
	_g_object_unref0 (button);
	button = _tmp241_;
	_tmp242_ = button;
	if (_tmp242_ != NULL) {
		GtkButton* _tmp243_ = NULL;
		_tmp243_ = button;
		g_signal_connect_object (_tmp243_, "clicked", (GCallback) _math_buttons_shift_right_cb_gtk_button_clicked, self, 0);
	}
	_tmp244_ = builder;
	_tmp245_ = gtk_builder_get_object (_tmp244_, "calc_character_button");
	_tmp246_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp245_, GTK_TYPE_BUTTON) ? ((GtkButton*) _tmp245_) : NULL);
	_g_object_unref0 (button);
	button = _tmp246_;
	_tmp247_ = button;
	if (_tmp247_ != NULL) {
		GtkButton* _tmp248_ = NULL;
		_tmp248_ = button;
		g_signal_connect_object (_tmp248_, "clicked", (GCallback) _math_buttons_insert_character_code_cb_gtk_button_clicked, self, 0);
	}
	_tmp249_ = builder;
	_tmp250_ = gtk_builder_get_object (_tmp249_, "calc_numeric_point_button");
	_tmp251_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp250_, GTK_TYPE_BUTTON) ? ((GtkButton*) _tmp250_) : NULL);
	_g_object_unref0 (button);
	button = _tmp251_;
	_tmp252_ = button;
	if (_tmp252_ != NULL) {
		GtkButton* _tmp253_ = NULL;
		MathEquation* _tmp254_ = NULL;
		Serializer* _tmp255_ = NULL;
		Serializer* _tmp256_ = NULL;
		gunichar _tmp257_ = 0U;
		gchar* _tmp258_ = NULL;
		gchar* _tmp259_ = NULL;
		GtkButton* _tmp260_ = NULL;
		_tmp253_ = button;
		_tmp254_ = self->priv->equation;
		_tmp255_ = math_equation_get_serializer (_tmp254_);
		_tmp256_ = _tmp255_;
		_tmp257_ = serializer_get_radix (_tmp256_);
		_tmp258_ = g_unichar_to_string (_tmp257_);
		_tmp259_ = _tmp258_;
		gtk_button_set_label (_tmp253_, _tmp259_);
		_g_free0 (_tmp259_);
		_tmp260_ = button;
		g_signal_connect_object (_tmp260_, "clicked", (GCallback) ____lambda26__gtk_button_clicked, self, 0);
	}
	_tmp261_ = builder;
	_tmp262_ = gtk_builder_get_object (_tmp261_, "calc_superscript_button");
	_tmp263_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp262_, GTK_TYPE_TOGGLE_BUTTON) ? ((GtkToggleButton*) _tmp262_) : NULL);
	toggle_button = _tmp263_;
	_tmp264_ = toggle_button;
	if (_tmp264_ != NULL) {
		GtkToggleButton* _tmp265_ = NULL;
		GtkToggleButton* _tmp266_ = NULL;
		MathEquation* _tmp267_ = NULL;
		NumberMode _tmp268_ = 0;
		NumberMode _tmp269_ = 0;
		GtkToggleButton* _tmp271_ = NULL;
		_tmp265_ = toggle_button;
		_tmp266_ = _g_object_ref0 (_tmp265_);
		self->priv->superscript_toggles = g_list_append (self->priv->superscript_toggles, _tmp266_);
		_tmp267_ = self->priv->equation;
		_tmp268_ = math_equation_get_number_mode (_tmp267_);
		_tmp269_ = _tmp268_;
		if (_tmp269_ == NUMBER_MODE_SUPERSCRIPT) {
			GtkToggleButton* _tmp270_ = NULL;
			_tmp270_ = toggle_button;
			gtk_toggle_button_set_active (_tmp270_, TRUE);
		}
		_tmp271_ = toggle_button;
		g_signal_connect_object ((GtkButton*) _tmp271_, "clicked", (GCallback) _math_buttons_set_superscript_cb_gtk_button_clicked, self, 0);
	}
	_tmp272_ = builder;
	_tmp273_ = gtk_builder_get_object (_tmp272_, "calc_subscript_button");
	_tmp274_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp273_, GTK_TYPE_TOGGLE_BUTTON) ? ((GtkToggleButton*) _tmp273_) : NULL);
	_g_object_unref0 (toggle_button);
	toggle_button = _tmp274_;
	_tmp275_ = toggle_button;
	if (_tmp275_ != NULL) {
		GtkToggleButton* _tmp276_ = NULL;
		GtkToggleButton* _tmp277_ = NULL;
		MathEquation* _tmp278_ = NULL;
		NumberMode _tmp279_ = 0;
		NumberMode _tmp280_ = 0;
		GtkToggleButton* _tmp282_ = NULL;
		_tmp276_ = toggle_button;
		_tmp277_ = _g_object_ref0 (_tmp276_);
		self->priv->subscript_toggles = g_list_append (self->priv->subscript_toggles, _tmp277_);
		_tmp278_ = self->priv->equation;
		_tmp279_ = math_equation_get_number_mode (_tmp278_);
		_tmp280_ = _tmp279_;
		if (_tmp280_ == NUMBER_MODE_SUBSCRIPT) {
			GtkToggleButton* _tmp281_ = NULL;
			_tmp281_ = toggle_button;
			gtk_toggle_button_set_active (_tmp281_, TRUE);
		}
		_tmp282_ = toggle_button;
		g_signal_connect_object ((GtkButton*) _tmp282_, "clicked", (GCallback) _math_buttons_set_subscript_cb_gtk_button_clicked, self, 0);
	}
	_tmp283_ = mode;
	if (_tmp283_ == BUTTON_MODE_PROGRAMMING) {
		GtkBuilder* _tmp284_ = NULL;
		GObject* _tmp285_ = NULL;
		GtkLabel* _tmp286_ = NULL;
		GtkBuilder* _tmp287_ = NULL;
		GObject* _tmp288_ = NULL;
		GtkDialog* _tmp289_ = NULL;
		GtkDialog* _tmp290_ = NULL;
		GtkDialog* _tmp291_ = NULL;
		GtkBuilder* _tmp292_ = NULL;
		GObject* _tmp293_ = NULL;
		GtkEntry* _tmp294_ = NULL;
		GtkEntry* _tmp295_ = NULL;
		GtkBuilder* _tmp296_ = NULL;
		GObject* _tmp297_ = NULL;
		GtkWidget* _tmp298_ = NULL;
		gint i = 0;
		GtkBuilder* _tmp318_ = NULL;
		GObject* _tmp319_ = NULL;
		GtkComboBox* _tmp320_ = NULL;
		GtkListStore* model = NULL;
		GtkListStore* _tmp321_ = NULL;
		GtkComboBox* _tmp322_ = NULL;
		GtkListStore* _tmp323_ = NULL;
		GtkTreeIter iter = {0};
		GtkListStore* _tmp324_ = NULL;
		GtkTreeIter _tmp325_ = {0};
		GtkListStore* _tmp326_ = NULL;
		GtkTreeIter _tmp327_ = {0};
		const gchar* _tmp328_ = NULL;
		GtkListStore* _tmp329_ = NULL;
		GtkTreeIter _tmp330_ = {0};
		GtkListStore* _tmp331_ = NULL;
		GtkTreeIter _tmp332_ = {0};
		const gchar* _tmp333_ = NULL;
		GtkListStore* _tmp334_ = NULL;
		GtkTreeIter _tmp335_ = {0};
		GtkListStore* _tmp336_ = NULL;
		GtkTreeIter _tmp337_ = {0};
		const gchar* _tmp338_ = NULL;
		GtkListStore* _tmp339_ = NULL;
		GtkTreeIter _tmp340_ = {0};
		GtkListStore* _tmp341_ = NULL;
		GtkTreeIter _tmp342_ = {0};
		const gchar* _tmp343_ = NULL;
		GtkCellRendererText* renderer = NULL;
		GtkCellRendererText* _tmp344_ = NULL;
		GtkComboBox* _tmp345_ = NULL;
		GtkCellRendererText* _tmp346_ = NULL;
		GtkComboBox* _tmp347_ = NULL;
		GtkCellRendererText* _tmp348_ = NULL;
		GtkComboBox* _tmp349_ = NULL;
		MathEquation* _tmp350_ = NULL;
		_tmp284_ = builder;
		_tmp285_ = gtk_builder_get_object (_tmp284_, "base_label");
		_tmp286_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp285_, GTK_TYPE_LABEL) ? ((GtkLabel*) _tmp285_) : NULL);
		_g_object_unref0 (self->priv->base_label);
		self->priv->base_label = _tmp286_;
		_tmp287_ = builder;
		_tmp288_ = gtk_builder_get_object (_tmp287_, "character_code_dialog");
		_tmp289_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp288_, GTK_TYPE_DIALOG) ? ((GtkDialog*) _tmp288_) : NULL);
		_g_object_unref0 (self->priv->character_code_dialog);
		self->priv->character_code_dialog = _tmp289_;
		_tmp290_ = self->priv->character_code_dialog;
		g_signal_connect_object (_tmp290_, "response", (GCallback) _math_buttons_character_code_dialog_response_cb_gtk_dialog_response, self, 0);
		_tmp291_ = self->priv->character_code_dialog;
		g_signal_connect_object ((GtkWidget*) _tmp291_, "delete-event", (GCallback) _math_buttons_character_code_dialog_delete_cb_gtk_widget_delete_event, self, 0);
		_tmp292_ = builder;
		_tmp293_ = gtk_builder_get_object (_tmp292_, "character_code_entry");
		_tmp294_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp293_, GTK_TYPE_ENTRY) ? ((GtkEntry*) _tmp293_) : NULL);
		_g_object_unref0 (self->priv->character_code_entry);
		self->priv->character_code_entry = _tmp294_;
		_tmp295_ = self->priv->character_code_entry;
		g_signal_connect_object (_tmp295_, "activate", (GCallback) _math_buttons_character_code_dialog_activate_cb_gtk_entry_activate, self, 0);
		_tmp296_ = builder;
		_tmp297_ = gtk_builder_get_object (_tmp296_, "bit_table");
		_tmp298_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp297_, GTK_TYPE_WIDGET) ? ((GtkWidget*) _tmp297_) : NULL);
		_g_object_unref0 (self->priv->bit_panel);
		self->priv->bit_panel = _tmp298_;
		__g_list_free__g_object_unref0_0 (self->priv->bit_labels);
		self->priv->bit_labels = NULL;
		i = 0;
		while (TRUE) {
			gchar* name = NULL;
			gint _tmp299_ = 0;
			gchar* _tmp300_ = NULL;
			GtkLabel* label = NULL;
			GtkBuilder* _tmp301_ = NULL;
			const gchar* _tmp302_ = NULL;
			GObject* _tmp303_ = NULL;
			GtkLabel* _tmp304_ = NULL;
			GtkLabel* _tmp305_ = NULL;
			GtkLabel* _tmp306_ = NULL;
			GtkLabel* _tmp307_ = NULL;
			gint _tmp308_ = 0;
			gchar* _tmp309_ = NULL;
			GtkEventBox* box = NULL;
			GtkBuilder* _tmp310_ = NULL;
			const gchar* _tmp311_ = NULL;
			GObject* _tmp312_ = NULL;
			GtkEventBox* _tmp313_ = NULL;
			GtkEventBox* _tmp314_ = NULL;
			gint _tmp315_ = 0;
			GtkEventBox* _tmp316_ = NULL;
			gint _tmp317_ = 0;
			_tmp299_ = i;
			_tmp300_ = g_strdup_printf ("bit_label_%d", _tmp299_);
			name = _tmp300_;
			_tmp301_ = builder;
			_tmp302_ = name;
			_tmp303_ = gtk_builder_get_object (_tmp301_, _tmp302_);
			_tmp304_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp303_, GTK_TYPE_LABEL) ? ((GtkLabel*) _tmp303_) : NULL);
			label = _tmp304_;
			_tmp305_ = label;
			if (_tmp305_ == NULL) {
				_g_object_unref0 (label);
				_g_free0 (name);
				break;
			}
			_tmp306_ = label;
			_tmp307_ = _g_object_ref0 (_tmp306_);
			self->priv->bit_labels = g_list_append (self->priv->bit_labels, _tmp307_);
			_tmp308_ = i;
			_tmp309_ = g_strdup_printf ("bit_eventbox_%d", _tmp308_);
			_g_free0 (name);
			name = _tmp309_;
			_tmp310_ = builder;
			_tmp311_ = name;
			_tmp312_ = gtk_builder_get_object (_tmp310_, _tmp311_);
			_tmp313_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp312_, GTK_TYPE_EVENT_BOX) ? ((GtkEventBox*) _tmp312_) : NULL);
			box = _tmp313_;
			_tmp314_ = box;
			_tmp315_ = i;
			g_object_set_data_full ((GObject*) _tmp314_, "bit_index", (gpointer) ((gintptr) _tmp315_), NULL);
			_tmp316_ = box;
			g_signal_connect_object ((GtkWidget*) _tmp316_, "button-press-event", (GCallback) _math_buttons_bit_toggle_cb_gtk_widget_button_press_event, self, 0);
			_tmp317_ = i;
			i = _tmp317_ + 1;
			_g_object_unref0 (box);
			_g_object_unref0 (label);
			_g_free0 (name);
		}
		self->priv->bit_labels = g_list_reverse (self->priv->bit_labels);
		_tmp318_ = builder;
		_tmp319_ = gtk_builder_get_object (_tmp318_, "base_combo");
		_tmp320_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp319_, GTK_TYPE_COMBO_BOX) ? ((GtkComboBox*) _tmp319_) : NULL);
		_g_object_unref0 (self->priv->base_combo);
		self->priv->base_combo = _tmp320_;
		_tmp321_ = gtk_list_store_new (2, G_TYPE_STRING, G_TYPE_INT);
		model = _tmp321_;
		_tmp322_ = self->priv->base_combo;
		_tmp323_ = model;
		gtk_combo_box_set_model (_tmp322_, (GtkTreeModel*) _tmp323_);
		_tmp324_ = model;
		gtk_list_store_append (_tmp324_, &_tmp325_);
		iter = _tmp325_;
		_tmp326_ = model;
		_tmp327_ = iter;
		_tmp328_ = _ ("Binary");
		gtk_list_store_set (_tmp326_, &_tmp327_, 0, _tmp328_, 1, 2, -1, -1);
		_tmp329_ = model;
		gtk_list_store_append (_tmp329_, &_tmp330_);
		iter = _tmp330_;
		_tmp331_ = model;
		_tmp332_ = iter;
		_tmp333_ = _ ("Octal");
		gtk_list_store_set (_tmp331_, &_tmp332_, 0, _tmp333_, 1, 8, -1, -1);
		_tmp334_ = model;
		gtk_list_store_append (_tmp334_, &_tmp335_);
		iter = _tmp335_;
		_tmp336_ = model;
		_tmp337_ = iter;
		_tmp338_ = _ ("Decimal");
		gtk_list_store_set (_tmp336_, &_tmp337_, 0, _tmp338_, 1, 10, -1, -1);
		_tmp339_ = model;
		gtk_list_store_append (_tmp339_, &_tmp340_);
		iter = _tmp340_;
		_tmp341_ = model;
		_tmp342_ = iter;
		_tmp343_ = _ ("Hexadecimal");
		gtk_list_store_set (_tmp341_, &_tmp342_, 0, _tmp343_, 1, 16, -1, -1);
		_tmp344_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
		g_object_ref_sink (_tmp344_);
		renderer = _tmp344_;
		_tmp345_ = self->priv->base_combo;
		_tmp346_ = renderer;
		gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp345_, (GtkCellRenderer*) _tmp346_, TRUE);
		_tmp347_ = self->priv->base_combo;
		_tmp348_ = renderer;
		gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp347_, (GtkCellRenderer*) _tmp348_, "text", 0);
		_tmp349_ = self->priv->base_combo;
		g_signal_connect_object (_tmp349_, "changed", (GCallback) _math_buttons_base_combobox_changed_cb_gtk_combo_box_changed, self, 0);
		_tmp350_ = self->priv->equation;
		g_signal_connect_object ((GObject*) _tmp350_, "notify::number-base", (GCallback) ____lambda27__g_object_notify, self, 0);
		math_buttons_base_changed_cb (self);
		_g_object_unref0 (renderer);
		_g_object_unref0 (model);
	}
	_tmp351_ = mode;
	if (_tmp351_ == BUTTON_MODE_FINANCIAL) {
		GtkBuilder* _tmp352_ = NULL;
		GObject* _tmp353_ = NULL;
		GtkButton* _tmp354_ = NULL;
		GtkButton* _tmp355_ = NULL;
		GtkBuilder* _tmp359_ = NULL;
		GObject* _tmp360_ = NULL;
		GtkButton* _tmp361_ = NULL;
		GtkButton* _tmp362_ = NULL;
		GtkBuilder* _tmp366_ = NULL;
		GObject* _tmp367_ = NULL;
		GtkButton* _tmp368_ = NULL;
		GtkButton* _tmp369_ = NULL;
		GtkBuilder* _tmp373_ = NULL;
		GObject* _tmp374_ = NULL;
		GtkButton* _tmp375_ = NULL;
		GtkButton* _tmp376_ = NULL;
		GtkBuilder* _tmp380_ = NULL;
		GObject* _tmp381_ = NULL;
		GtkButton* _tmp382_ = NULL;
		GtkButton* _tmp383_ = NULL;
		GtkBuilder* _tmp387_ = NULL;
		GObject* _tmp388_ = NULL;
		GtkButton* _tmp389_ = NULL;
		GtkButton* _tmp390_ = NULL;
		GtkBuilder* _tmp394_ = NULL;
		GObject* _tmp395_ = NULL;
		GtkButton* _tmp396_ = NULL;
		GtkButton* _tmp397_ = NULL;
		GtkBuilder* _tmp401_ = NULL;
		GObject* _tmp402_ = NULL;
		GtkButton* _tmp403_ = NULL;
		GtkButton* _tmp404_ = NULL;
		GtkBuilder* _tmp408_ = NULL;
		GObject* _tmp409_ = NULL;
		GtkButton* _tmp410_ = NULL;
		GtkButton* _tmp411_ = NULL;
		GtkBuilder* _tmp415_ = NULL;
		GObject* _tmp416_ = NULL;
		GtkButton* _tmp417_ = NULL;
		GtkButton* _tmp418_ = NULL;
		math_buttons_load_finc_dialogs (self);
		_tmp352_ = builder;
		_tmp353_ = gtk_builder_get_object (_tmp352_, "calc_finc_compounding_term_button");
		_tmp354_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp353_, GTK_TYPE_BUTTON) ? ((GtkButton*) _tmp353_) : NULL);
		_g_object_unref0 (button);
		button = _tmp354_;
		_tmp355_ = button;
		if (_tmp355_ != NULL) {
			GtkButton* _tmp356_ = NULL;
			gchar* _tmp357_ = NULL;
			GtkButton* _tmp358_ = NULL;
			_tmp356_ = button;
			_tmp357_ = g_strdup ("ctrm_dialog");
			g_object_set_data_full ((GObject*) _tmp356_, "finc-dialog-name", _tmp357_, g_free);
			_tmp358_ = button;
			g_signal_connect_object (_tmp358_, "clicked", (GCallback) _math_buttons_finc_cb_gtk_button_clicked, self, 0);
		}
		_tmp359_ = builder;
		_tmp360_ = gtk_builder_get_object (_tmp359_, "calc_finc_double_declining_depreciation_button");
		_tmp361_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp360_, GTK_TYPE_BUTTON) ? ((GtkButton*) _tmp360_) : NULL);
		_g_object_unref0 (button);
		button = _tmp361_;
		_tmp362_ = button;
		if (_tmp362_ != NULL) {
			GtkButton* _tmp363_ = NULL;
			gchar* _tmp364_ = NULL;
			GtkButton* _tmp365_ = NULL;
			_tmp363_ = button;
			_tmp364_ = g_strdup ("ddb_dialog");
			g_object_set_data_full ((GObject*) _tmp363_, "finc-dialog-name", _tmp364_, g_free);
			_tmp365_ = button;
			g_signal_connect_object (_tmp365_, "clicked", (GCallback) _math_buttons_finc_cb_gtk_button_clicked, self, 0);
		}
		_tmp366_ = builder;
		_tmp367_ = gtk_builder_get_object (_tmp366_, "calc_finc_future_value_button");
		_tmp368_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp367_, GTK_TYPE_BUTTON) ? ((GtkButton*) _tmp367_) : NULL);
		_g_object_unref0 (button);
		button = _tmp368_;
		_tmp369_ = button;
		if (_tmp369_ != NULL) {
			GtkButton* _tmp370_ = NULL;
			gchar* _tmp371_ = NULL;
			GtkButton* _tmp372_ = NULL;
			_tmp370_ = button;
			_tmp371_ = g_strdup ("fv_dialog");
			g_object_set_data_full ((GObject*) _tmp370_, "finc-dialog-name", _tmp371_, g_free);
			_tmp372_ = button;
			g_signal_connect_object (_tmp372_, "clicked", (GCallback) _math_buttons_finc_cb_gtk_button_clicked, self, 0);
		}
		_tmp373_ = builder;
		_tmp374_ = gtk_builder_get_object (_tmp373_, "calc_finc_gross_profit_margin_button");
		_tmp375_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp374_, GTK_TYPE_BUTTON) ? ((GtkButton*) _tmp374_) : NULL);
		_g_object_unref0 (button);
		button = _tmp375_;
		_tmp376_ = button;
		if (_tmp376_ != NULL) {
			GtkButton* _tmp377_ = NULL;
			gchar* _tmp378_ = NULL;
			GtkButton* _tmp379_ = NULL;
			_tmp377_ = button;
			_tmp378_ = g_strdup ("gpm_dialog");
			g_object_set_data_full ((GObject*) _tmp377_, "finc-dialog-name", _tmp378_, g_free);
			_tmp379_ = button;
			g_signal_connect_object (_tmp379_, "clicked", (GCallback) _math_buttons_finc_cb_gtk_button_clicked, self, 0);
		}
		_tmp380_ = builder;
		_tmp381_ = gtk_builder_get_object (_tmp380_, "calc_finc_periodic_payment_button");
		_tmp382_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp381_, GTK_TYPE_BUTTON) ? ((GtkButton*) _tmp381_) : NULL);
		_g_object_unref0 (button);
		button = _tmp382_;
		_tmp383_ = button;
		if (_tmp383_ != NULL) {
			GtkButton* _tmp384_ = NULL;
			gchar* _tmp385_ = NULL;
			GtkButton* _tmp386_ = NULL;
			_tmp384_ = button;
			_tmp385_ = g_strdup ("pmt_dialog");
			g_object_set_data_full ((GObject*) _tmp384_, "finc-dialog-name", _tmp385_, g_free);
			_tmp386_ = button;
			g_signal_connect_object (_tmp386_, "clicked", (GCallback) _math_buttons_finc_cb_gtk_button_clicked, self, 0);
		}
		_tmp387_ = builder;
		_tmp388_ = gtk_builder_get_object (_tmp387_, "calc_finc_present_value_button");
		_tmp389_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp388_, GTK_TYPE_BUTTON) ? ((GtkButton*) _tmp388_) : NULL);
		_g_object_unref0 (button);
		button = _tmp389_;
		_tmp390_ = button;
		if (_tmp390_ != NULL) {
			GtkButton* _tmp391_ = NULL;
			gchar* _tmp392_ = NULL;
			GtkButton* _tmp393_ = NULL;
			_tmp391_ = button;
			_tmp392_ = g_strdup ("pv_dialog");
			g_object_set_data_full ((GObject*) _tmp391_, "finc-dialog-name", _tmp392_, g_free);
			_tmp393_ = button;
			g_signal_connect_object (_tmp393_, "clicked", (GCallback) _math_buttons_finc_cb_gtk_button_clicked, self, 0);
		}
		_tmp394_ = builder;
		_tmp395_ = gtk_builder_get_object (_tmp394_, "calc_finc_periodic_interest_rate_button");
		_tmp396_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp395_, GTK_TYPE_BUTTON) ? ((GtkButton*) _tmp395_) : NULL);
		_g_object_unref0 (button);
		button = _tmp396_;
		_tmp397_ = button;
		if (_tmp397_ != NULL) {
			GtkButton* _tmp398_ = NULL;
			gchar* _tmp399_ = NULL;
			GtkButton* _tmp400_ = NULL;
			_tmp398_ = button;
			_tmp399_ = g_strdup ("rate_dialog");
			g_object_set_data_full ((GObject*) _tmp398_, "finc-dialog-name", _tmp399_, g_free);
			_tmp400_ = button;
			g_signal_connect_object (_tmp400_, "clicked", (GCallback) _math_buttons_finc_cb_gtk_button_clicked, self, 0);
		}
		_tmp401_ = builder;
		_tmp402_ = gtk_builder_get_object (_tmp401_, "calc_finc_straight_line_depreciation_button");
		_tmp403_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp402_, GTK_TYPE_BUTTON) ? ((GtkButton*) _tmp402_) : NULL);
		_g_object_unref0 (button);
		button = _tmp403_;
		_tmp404_ = button;
		if (_tmp404_ != NULL) {
			GtkButton* _tmp405_ = NULL;
			gchar* _tmp406_ = NULL;
			GtkButton* _tmp407_ = NULL;
			_tmp405_ = button;
			_tmp406_ = g_strdup ("sln_dialog");
			g_object_set_data_full ((GObject*) _tmp405_, "finc-dialog-name", _tmp406_, g_free);
			_tmp407_ = button;
			g_signal_connect_object (_tmp407_, "clicked", (GCallback) _math_buttons_finc_cb_gtk_button_clicked, self, 0);
		}
		_tmp408_ = builder;
		_tmp409_ = gtk_builder_get_object (_tmp408_, "calc_finc_sum_of_the_years_digits_depreciation_button");
		_tmp410_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp409_, GTK_TYPE_BUTTON) ? ((GtkButton*) _tmp409_) : NULL);
		_g_object_unref0 (button);
		button = _tmp410_;
		_tmp411_ = button;
		if (_tmp411_ != NULL) {
			GtkButton* _tmp412_ = NULL;
			gchar* _tmp413_ = NULL;
			GtkButton* _tmp414_ = NULL;
			_tmp412_ = button;
			_tmp413_ = g_strdup ("syd_dialog");
			g_object_set_data_full ((GObject*) _tmp412_, "finc-dialog-name", _tmp413_, g_free);
			_tmp414_ = button;
			g_signal_connect_object (_tmp414_, "clicked", (GCallback) _math_buttons_finc_cb_gtk_button_clicked, self, 0);
		}
		_tmp415_ = builder;
		_tmp416_ = gtk_builder_get_object (_tmp415_, "calc_finc_term_button");
		_tmp417_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp416_, GTK_TYPE_BUTTON) ? ((GtkButton*) _tmp416_) : NULL);
		_g_object_unref0 (button);
		button = _tmp417_;
		_tmp418_ = button;
		if (_tmp418_ != NULL) {
			GtkButton* _tmp419_ = NULL;
			gchar* _tmp420_ = NULL;
			GtkButton* _tmp421_ = NULL;
			_tmp419_ = button;
			_tmp420_ = g_strdup ("term_dialog");
			g_object_set_data_full ((GObject*) _tmp419_, "finc-dialog-name", _tmp420_, g_free);
			_tmp421_ = button;
			g_signal_connect_object (_tmp421_, "clicked", (GCallback) _math_buttons_finc_cb_gtk_button_clicked, self, 0);
		}
	}
	_tmp422_ = builder;
	gtk_builder_connect_signals (_tmp422_, self);
	math_buttons_update_bit_panel (self);
	result = panel;
	_g_object_unref0 (toggle_button);
	_g_object_unref0 (button);
	_g_free0 (builder_resource);
	_g_object_unref0 (builder);
	return result;
}


static void ____lambda13_ (MathButtons* self, GtkButton* widget) {
	MathEquation* _tmp0_ = NULL;
	GtkButton* _tmp1_ = NULL;
	gconstpointer _tmp2_ = NULL;
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->equation;
	_tmp1_ = widget;
	_tmp2_ = g_object_get_data ((GObject*) _tmp1_, "calc_text");
	math_equation_insert (_tmp0_, (const gchar*) _tmp2_);
}


static void _____lambda13__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	____lambda13_ (self, _sender);
}


static void math_buttons_setup_button (MathButtons* self, GtkBuilder* builder, const gchar* name, const gchar* data, const gchar* tooltip, gboolean connect) {
	gchar* widget_name = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	GtkButton* button = NULL;
	GtkBuilder* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	GObject* _tmp4_ = NULL;
	GtkButton* _tmp5_ = NULL;
	GtkButton* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp13_ = NULL;
	GtkButton* _tmp16_ = NULL;
	AtkObject* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (builder != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = name;
	_tmp1_ = g_strdup_printf ("calc_%s_button", _tmp0_);
	widget_name = _tmp1_;
	_tmp2_ = builder;
	_tmp3_ = widget_name;
	_tmp4_ = gtk_builder_get_object (_tmp2_, _tmp3_);
	_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, GTK_TYPE_BUTTON) ? ((GtkButton*) _tmp4_) : NULL);
	button = _tmp5_;
	_tmp6_ = button;
	if (_tmp6_ == NULL) {
		_g_object_unref0 (button);
		_g_free0 (widget_name);
		return;
	}
	_tmp7_ = data;
	if (_tmp7_ != NULL) {
		GtkButton* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		gboolean _tmp11_ = FALSE;
		_tmp8_ = button;
		_tmp9_ = data;
		_tmp10_ = g_strdup (_tmp9_);
		g_object_set_data_full ((GObject*) _tmp8_, "calc_text", _tmp10_, g_free);
		_tmp11_ = connect;
		if (_tmp11_) {
			GtkButton* _tmp12_ = NULL;
			_tmp12_ = button;
			g_signal_connect_object (_tmp12_, "clicked", (GCallback) _____lambda13__gtk_button_clicked, self, 0);
		}
	}
	_tmp13_ = tooltip;
	if (_tmp13_ != NULL) {
		GtkButton* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
		_tmp14_ = button;
		_tmp15_ = tooltip;
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp14_, _tmp15_);
	}
	_tmp16_ = button;
	_tmp17_ = gtk_widget_get_accessible ((GtkWidget*) _tmp16_);
	_tmp18_ = name;
	atk_object_set_name (_tmp17_, _tmp18_);
	_g_object_unref0 (button);
	_g_free0 (widget_name);
}


static void math_buttons_converter_changed_cb (MathButtons* self) {
	Unit* from_unit = NULL;
	Unit* to_unit = NULL;
	MathConverter* _tmp0_ = NULL;
	Unit* _tmp1_ = NULL;
	Unit* _tmp2_ = NULL;
	ButtonMode _tmp3_ = 0;
	ButtonMode _tmp4_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->converter;
	math_converter_get_conversion (_tmp0_, &_tmp1_, &_tmp2_);
	_g_object_unref0 (from_unit);
	from_unit = _tmp1_;
	_g_object_unref0 (to_unit);
	to_unit = _tmp2_;
	_tmp3_ = math_buttons_get_mode (self);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == BUTTON_MODE_FINANCIAL) {
		MathEquation* _tmp5_ = NULL;
		Unit* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		MathEquation* _tmp10_ = NULL;
		Unit* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		_tmp5_ = self->priv->equation;
		_tmp6_ = from_unit;
		_tmp7_ = unit_get_name (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = _tmp8_;
		math_equation_set_source_currency (_tmp5_, _tmp9_);
		_g_free0 (_tmp9_);
		_tmp10_ = self->priv->equation;
		_tmp11_ = to_unit;
		_tmp12_ = unit_get_name (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = _tmp13_;
		math_equation_set_target_currency (_tmp10_, _tmp14_);
		_g_free0 (_tmp14_);
	} else {
		MathEquation* _tmp15_ = NULL;
		Unit* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
		gchar* _tmp18_ = NULL;
		gchar* _tmp19_ = NULL;
		MathEquation* _tmp20_ = NULL;
		Unit* _tmp21_ = NULL;
		gchar* _tmp22_ = NULL;
		gchar* _tmp23_ = NULL;
		gchar* _tmp24_ = NULL;
		_tmp15_ = self->priv->equation;
		_tmp16_ = from_unit;
		_tmp17_ = unit_get_name (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = _tmp18_;
		math_equation_set_source_units (_tmp15_, _tmp19_);
		_g_free0 (_tmp19_);
		_tmp20_ = self->priv->equation;
		_tmp21_ = to_unit;
		_tmp22_ = unit_get_name (_tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = _tmp23_;
		math_equation_set_target_units (_tmp20_, _tmp24_);
		_g_free0 (_tmp24_);
	}
	_g_object_unref0 (to_unit);
	_g_object_unref0 (from_unit);
}


static void _math_buttons_converter_changed_cb_math_converter_changed (MathConverter* _sender, gpointer self) {
	math_buttons_converter_changed_cb (self);
}


static void math_buttons_load_buttons (MathButtons* self) {
	gboolean _tmp0_ = FALSE;
	MathConverter* _tmp1_ = NULL;
	GtkWidget* panel = NULL;
	ButtonMode _tmp6_ = 0;
	ButtonMode _tmp7_ = 0;
	GtkWidget* _tmp8_ = NULL;
	GtkWidget* _tmp9_ = NULL;
	GtkWidget* _tmp10_ = NULL;
	GtkWidget* _tmp11_ = NULL;
	GtkWidget* _tmp13_ = NULL;
	GtkWidget* _tmp14_ = NULL;
	GtkWidget* _tmp15_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_widget_get_visible ((GtkWidget*) self);
	if (!_tmp0_) {
		return;
	}
	_tmp1_ = self->priv->converter;
	if (_tmp1_ == NULL) {
		MathEquation* _tmp2_ = NULL;
		MathConverter* _tmp3_ = NULL;
		MathConverter* _tmp4_ = NULL;
		MathConverter* _tmp5_ = NULL;
		_tmp2_ = self->priv->equation;
		_tmp3_ = math_converter_new (_tmp2_);
		g_object_ref_sink (_tmp3_);
		_g_object_unref0 (self->priv->converter);
		self->priv->converter = _tmp3_;
		_tmp4_ = self->priv->converter;
		g_signal_connect_object (_tmp4_, "changed", (GCallback) _math_buttons_converter_changed_cb_math_converter_changed, self, 0);
		_tmp5_ = self->priv->converter;
		gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp5_, FALSE, TRUE, (guint) 0);
	}
	_tmp6_ = math_buttons_get_mode (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = math_buttons_load_mode (self, _tmp7_);
	panel = _tmp8_;
	_tmp9_ = self->priv->active_panel;
	_tmp10_ = panel;
	if (_tmp9_ == _tmp10_) {
		_g_object_unref0 (panel);
		return;
	}
	_tmp11_ = self->priv->active_panel;
	if (_tmp11_ != NULL) {
		GtkWidget* _tmp12_ = NULL;
		_tmp12_ = self->priv->active_panel;
		gtk_widget_hide (_tmp12_);
	}
	_tmp13_ = panel;
	_tmp14_ = _g_object_ref0 (_tmp13_);
	_g_object_unref0 (self->priv->active_panel);
	self->priv->active_panel = _tmp14_;
	_tmp15_ = panel;
	if (_tmp15_ != NULL) {
		GtkWidget* _tmp16_ = NULL;
		_tmp16_ = panel;
		gtk_widget_show (_tmp16_);
	}
	_g_object_unref0 (panel);
}


static void _math_buttons_button_menu_position_func_gtk_menu_position_func (GtkMenu* menu, gint* x, gint* y, gboolean* push_in, gpointer self) {
	math_buttons_button_menu_position_func (self, menu, x, y, push_in);
}


static void math_buttons_popup_button_menu (MathButtons* self, GtkButton* button, GtkMenu* menu) {
	GtkMenu* _tmp0_ = NULL;
	GtkButton* _tmp1_ = NULL;
	GtkWidget* _tmp2_ = NULL;
	GtkMenu* _tmp3_ = NULL;
	guint32 _tmp4_ = 0U;
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	g_return_if_fail (menu != NULL);
	_tmp0_ = menu;
	_tmp1_ = button;
	_tmp2_ = _g_object_ref0 ((GtkWidget*) _tmp1_);
	g_object_set_data_full ((GObject*) _tmp0_, "button", _tmp2_, g_object_unref);
	_tmp3_ = menu;
	_tmp4_ = gtk_get_current_event_time ();
	gtk_menu_popup (_tmp3_, NULL, NULL, _math_buttons_button_menu_position_func_gtk_menu_position_func, self, (guint) 1, _tmp4_);
}


static void math_buttons_button_menu_position_func (MathButtons* self, GtkMenu* menu, gint* x, gint* y, gboolean* push_in) {
	gint _vala_x = 0;
	gint _vala_y = 0;
	gboolean _vala_push_in = FALSE;
	GtkButton* button = NULL;
	GtkMenu* _tmp0_ = NULL;
	gconstpointer _tmp1_ = NULL;
	GtkButton* _tmp2_ = NULL;
	gint origin_x = 0;
	gint origin_y = 0;
	GdkWindow* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	guint border = 0U;
	guint _tmp6_ = 0U;
	GtkAllocation allocation = {0};
	GtkAllocation _tmp7_ = {0};
	GtkAllocation _tmp8_ = {0};
	gint _tmp9_ = 0;
	GtkAllocation _tmp10_ = {0};
	gint _tmp11_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (menu != NULL);
	_tmp0_ = menu;
	_tmp1_ = g_object_get_data ((GObject*) _tmp0_, "button");
	_tmp2_ = _g_object_ref0 ((GtkButton*) _tmp1_);
	button = _tmp2_;
	_tmp3_ = gtk_widget_get_window ((GtkWidget*) button);
	gdk_window_get_origin (_tmp3_, &_tmp4_, &_tmp5_);
	origin_x = _tmp4_;
	origin_y = _tmp5_;
	_tmp6_ = gtk_container_get_border_width ((GtkContainer*) button);
	border = _tmp6_;
	gtk_widget_get_allocation ((GtkWidget*) button, &_tmp7_);
	allocation = _tmp7_;
	_tmp8_ = allocation;
	_tmp9_ = _tmp8_.x;
	_vala_x = (gint) ((origin_x + _tmp9_) + border);
	_tmp10_ = allocation;
	_tmp11_ = _tmp10_.y;
	_vala_y = (gint) ((origin_y + _tmp11_) + border);
	_vala_push_in = FALSE;
	_g_object_unref0 (button);
	if (x) {
		*x = _vala_x;
	}
	if (y) {
		*y = _vala_y;
	}
	if (push_in) {
		*push_in = _vala_push_in;
	}
}


static void math_buttons_memory_cb (MathButtons* self, GtkWidget* widget) {
	MathVariablePopup* popup = NULL;
	MathEquation* _tmp0_ = NULL;
	MathVariablePopup* _tmp1_ = NULL;
	GtkWidget* _tmp2_ = NULL;
	GtkWidget* _tmp3_ = NULL;
	GtkAllocation allocation = {0};
	GtkWidget* _tmp4_ = NULL;
	GtkAllocation _tmp5_ = {0};
	gint x = 0;
	gint y = 0;
	GtkWidget* _tmp6_ = NULL;
	GdkWindow* _tmp7_ = NULL;
	GtkAllocation _tmp8_ = {0};
	gint _tmp9_ = 0;
	GtkAllocation _tmp10_ = {0};
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->equation;
	_tmp1_ = math_variable_popup_new (_tmp0_);
	g_object_ref_sink (_tmp1_);
	popup = _tmp1_;
	_tmp2_ = widget;
	_tmp3_ = gtk_widget_get_toplevel (_tmp2_);
	gtk_window_set_transient_for ((GtkWindow*) popup, G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, GTK_TYPE_WINDOW) ? ((GtkWindow*) _tmp3_) : NULL);
	_tmp4_ = widget;
	gtk_widget_get_allocation (_tmp4_, &_tmp5_);
	allocation = _tmp5_;
	_tmp6_ = widget;
	_tmp7_ = gtk_widget_get_window (_tmp6_);
	_tmp8_ = allocation;
	_tmp9_ = _tmp8_.x;
	_tmp10_ = allocation;
	_tmp11_ = _tmp10_.y;
	gdk_window_get_root_coords (_tmp7_, _tmp9_, _tmp11_, &_tmp12_, &_tmp13_);
	x = _tmp12_;
	y = _tmp13_;
	gtk_window_move ((GtkWindow*) popup, x, y);
	gtk_widget_show ((GtkWidget*) popup);
	_g_object_unref0 (popup);
}


static void ______lambda24_ (MathButtons* self, GtkMenuItem* widget) {
	MathEquation* _tmp0_ = NULL;
	GtkMenuItem* _tmp1_ = NULL;
	gconstpointer _tmp2_ = NULL;
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->equation;
	_tmp1_ = widget;
	_tmp2_ = g_object_get_data ((GObject*) _tmp1_, "shiftcount");
	math_equation_shift (_tmp0_, (gint) ((gintptr) _tmp2_));
}


static void _______lambda24__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	______lambda24_ (self, _sender);
}


static void math_buttons_shift_left_cb (MathButtons* self, GtkButton* button) {
	GtkMenu* _tmp0_ = NULL;
	GtkButton* _tmp29_ = NULL;
	GtkMenu* _tmp30_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	_tmp0_ = self->priv->shift_left_menu;
	if (_tmp0_ == NULL) {
		GtkMenu* _tmp1_ = NULL;
		GtkMenu* _tmp2_ = NULL;
		_tmp1_ = (GtkMenu*) gtk_menu_new ();
		g_object_ref_sink (_tmp1_);
		_g_object_unref0 (self->priv->shift_left_menu);
		self->priv->shift_left_menu = _tmp1_;
		_tmp2_ = self->priv->shift_left_menu;
		gtk_menu_set_reserve_toggle_size (_tmp2_, FALSE);
		{
			gint i = 0;
			i = 1;
			{
				gboolean _tmp3_ = FALSE;
				_tmp3_ = TRUE;
				while (TRUE) {
					gboolean _tmp4_ = FALSE;
					gint _tmp6_ = 0;
					gchar* format = NULL;
					gint _tmp7_ = 0;
					gchar* text = NULL;
					const gchar* _tmp14_ = NULL;
					gint _tmp15_ = 0;
					gchar* _tmp16_ = NULL;
					GtkLabel* label = NULL;
					const gchar* _tmp17_ = NULL;
					GtkLabel* _tmp18_ = NULL;
					GtkMenuItem* item = NULL;
					GtkMenuItem* _tmp19_ = NULL;
					GtkMenuItem* _tmp20_ = NULL;
					gint _tmp21_ = 0;
					GtkMenuItem* _tmp22_ = NULL;
					GtkLabel* _tmp23_ = NULL;
					GtkMenu* _tmp24_ = NULL;
					GtkMenuItem* _tmp25_ = NULL;
					GtkMenuItem* _tmp26_ = NULL;
					GtkLabel* _tmp27_ = NULL;
					GtkMenuItem* _tmp28_ = NULL;
					_tmp4_ = _tmp3_;
					if (!_tmp4_) {
						gint _tmp5_ = 0;
						_tmp5_ = i;
						i = _tmp5_ + 1;
					}
					_tmp3_ = FALSE;
					_tmp6_ = i;
					if (!(_tmp6_ < 16)) {
						break;
					}
					_tmp7_ = i;
					if (_tmp7_ < 10) {
						gint _tmp8_ = 0;
						const gchar* _tmp9_ = NULL;
						gchar* _tmp10_ = NULL;
						_tmp8_ = i;
						_tmp9_ = ngettext ("_%d place", "_%d places", (gulong) _tmp8_);
						_tmp10_ = g_strdup (_tmp9_);
						_g_free0 (format);
						format = _tmp10_;
					} else {
						gint _tmp11_ = 0;
						const gchar* _tmp12_ = NULL;
						gchar* _tmp13_ = NULL;
						_tmp11_ = i;
						_tmp12_ = ngettext ("%d place", "%d places", (gulong) _tmp11_);
						_tmp13_ = g_strdup (_tmp12_);
						_g_free0 (format);
						format = _tmp13_;
					}
					_tmp14_ = format;
					_tmp15_ = i;
					_tmp16_ = g_strdup_printf (_tmp14_, _tmp15_);
					text = _tmp16_;
					_tmp17_ = text;
					_tmp18_ = (GtkLabel*) gtk_label_new_with_mnemonic (_tmp17_);
					g_object_ref_sink (_tmp18_);
					label = _tmp18_;
					_tmp19_ = (GtkMenuItem*) gtk_menu_item_new ();
					g_object_ref_sink (_tmp19_);
					item = _tmp19_;
					_tmp20_ = item;
					_tmp21_ = i;
					g_object_set_data_full ((GObject*) _tmp20_, "shiftcount", (gpointer) ((gintptr) _tmp21_), NULL);
					_tmp22_ = item;
					_tmp23_ = label;
					gtk_container_add ((GtkContainer*) _tmp22_, (GtkWidget*) _tmp23_);
					_tmp24_ = self->priv->shift_left_menu;
					_tmp25_ = item;
					gtk_menu_shell_append ((GtkMenuShell*) _tmp24_, (GtkWidget*) _tmp25_);
					_tmp26_ = item;
					g_signal_connect_object (_tmp26_, "activate", (GCallback) _______lambda24__gtk_menu_item_activate, self, 0);
					_tmp27_ = label;
					gtk_widget_show ((GtkWidget*) _tmp27_);
					_tmp28_ = item;
					gtk_widget_show ((GtkWidget*) _tmp28_);
					_g_object_unref0 (item);
					_g_object_unref0 (label);
					_g_free0 (text);
					_g_free0 (format);
				}
			}
		}
	}
	_tmp29_ = button;
	_tmp30_ = self->priv->shift_left_menu;
	math_buttons_popup_button_menu (self, _tmp29_, _tmp30_);
}


static void ______lambda25_ (MathButtons* self, GtkMenuItem* widget) {
	MathEquation* _tmp0_ = NULL;
	GtkMenuItem* _tmp1_ = NULL;
	gconstpointer _tmp2_ = NULL;
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->equation;
	_tmp1_ = widget;
	_tmp2_ = g_object_get_data ((GObject*) _tmp1_, "shiftcount");
	math_equation_shift (_tmp0_, (gint) ((gintptr) _tmp2_));
}


static void _______lambda25__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	______lambda25_ (self, _sender);
}


static void math_buttons_shift_right_cb (MathButtons* self, GtkButton* button) {
	GtkMenu* _tmp0_ = NULL;
	GtkButton* _tmp29_ = NULL;
	GtkMenu* _tmp30_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	_tmp0_ = self->priv->shift_right_menu;
	if (_tmp0_ == NULL) {
		GtkMenu* _tmp1_ = NULL;
		GtkMenu* _tmp2_ = NULL;
		_tmp1_ = (GtkMenu*) gtk_menu_new ();
		g_object_ref_sink (_tmp1_);
		_g_object_unref0 (self->priv->shift_right_menu);
		self->priv->shift_right_menu = _tmp1_;
		_tmp2_ = self->priv->shift_right_menu;
		gtk_menu_set_reserve_toggle_size (_tmp2_, FALSE);
		{
			gint i = 0;
			i = 1;
			{
				gboolean _tmp3_ = FALSE;
				_tmp3_ = TRUE;
				while (TRUE) {
					gboolean _tmp4_ = FALSE;
					gint _tmp6_ = 0;
					gchar* format = NULL;
					gint _tmp7_ = 0;
					gchar* text = NULL;
					const gchar* _tmp14_ = NULL;
					gint _tmp15_ = 0;
					gchar* _tmp16_ = NULL;
					GtkLabel* label = NULL;
					const gchar* _tmp17_ = NULL;
					GtkLabel* _tmp18_ = NULL;
					GtkMenuItem* item = NULL;
					GtkMenuItem* _tmp19_ = NULL;
					GtkMenuItem* _tmp20_ = NULL;
					gint _tmp21_ = 0;
					GtkMenuItem* _tmp22_ = NULL;
					GtkLabel* _tmp23_ = NULL;
					GtkMenu* _tmp24_ = NULL;
					GtkMenuItem* _tmp25_ = NULL;
					GtkMenuItem* _tmp26_ = NULL;
					GtkLabel* _tmp27_ = NULL;
					GtkMenuItem* _tmp28_ = NULL;
					_tmp4_ = _tmp3_;
					if (!_tmp4_) {
						gint _tmp5_ = 0;
						_tmp5_ = i;
						i = _tmp5_ + 1;
					}
					_tmp3_ = FALSE;
					_tmp6_ = i;
					if (!(_tmp6_ < 16)) {
						break;
					}
					_tmp7_ = i;
					if (_tmp7_ < 10) {
						gint _tmp8_ = 0;
						const gchar* _tmp9_ = NULL;
						gchar* _tmp10_ = NULL;
						_tmp8_ = i;
						_tmp9_ = ngettext ("_%d place", "_%d places", (gulong) _tmp8_);
						_tmp10_ = g_strdup (_tmp9_);
						_g_free0 (format);
						format = _tmp10_;
					} else {
						gint _tmp11_ = 0;
						const gchar* _tmp12_ = NULL;
						gchar* _tmp13_ = NULL;
						_tmp11_ = i;
						_tmp12_ = ngettext ("%d place", "%d places", (gulong) _tmp11_);
						_tmp13_ = g_strdup (_tmp12_);
						_g_free0 (format);
						format = _tmp13_;
					}
					_tmp14_ = format;
					_tmp15_ = i;
					_tmp16_ = g_strdup_printf (_tmp14_, _tmp15_);
					text = _tmp16_;
					_tmp17_ = text;
					_tmp18_ = (GtkLabel*) gtk_label_new_with_mnemonic (_tmp17_);
					g_object_ref_sink (_tmp18_);
					label = _tmp18_;
					_tmp19_ = (GtkMenuItem*) gtk_menu_item_new ();
					g_object_ref_sink (_tmp19_);
					item = _tmp19_;
					_tmp20_ = item;
					_tmp21_ = i;
					g_object_set_data_full ((GObject*) _tmp20_, "shiftcount", (gpointer) ((gintptr) (-_tmp21_)), NULL);
					_tmp22_ = item;
					_tmp23_ = label;
					gtk_container_add ((GtkContainer*) _tmp22_, (GtkWidget*) _tmp23_);
					_tmp24_ = self->priv->shift_right_menu;
					_tmp25_ = item;
					gtk_menu_shell_append ((GtkMenuShell*) _tmp24_, (GtkWidget*) _tmp25_);
					_tmp26_ = item;
					g_signal_connect_object (_tmp26_, "activate", (GCallback) _______lambda25__gtk_menu_item_activate, self, 0);
					_tmp27_ = label;
					gtk_widget_show ((GtkWidget*) _tmp27_);
					_tmp28_ = item;
					gtk_widget_show ((GtkWidget*) _tmp28_);
					_g_object_unref0 (item);
					_g_object_unref0 (label);
					_g_free0 (text);
					_g_free0 (format);
				}
			}
		}
	}
	_tmp29_ = button;
	_tmp30_ = self->priv->shift_right_menu;
	math_buttons_popup_button_menu (self, _tmp29_, _tmp30_);
}


static void math_buttons_function_cb (MathButtons* self, GtkWidget* widget) {
	MathFunctionPopup* popup = NULL;
	MathEquation* _tmp0_ = NULL;
	MathFunctionPopup* _tmp1_ = NULL;
	GtkWidget* _tmp2_ = NULL;
	GtkWidget* _tmp3_ = NULL;
	GtkAllocation allocation = {0};
	GtkWidget* _tmp4_ = NULL;
	GtkAllocation _tmp5_ = {0};
	gint x = 0;
	gint y = 0;
	GtkWidget* _tmp6_ = NULL;
	GdkWindow* _tmp7_ = NULL;
	GtkAllocation _tmp8_ = {0};
	gint _tmp9_ = 0;
	GtkAllocation _tmp10_ = {0};
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->equation;
	_tmp1_ = math_function_popup_new (_tmp0_);
	g_object_ref_sink (_tmp1_);
	popup = _tmp1_;
	_tmp2_ = widget;
	_tmp3_ = gtk_widget_get_toplevel (_tmp2_);
	gtk_window_set_transient_for ((GtkWindow*) popup, G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, GTK_TYPE_WINDOW) ? ((GtkWindow*) _tmp3_) : NULL);
	_tmp4_ = widget;
	gtk_widget_get_allocation (_tmp4_, &_tmp5_);
	allocation = _tmp5_;
	_tmp6_ = widget;
	_tmp7_ = gtk_widget_get_window (_tmp6_);
	_tmp8_ = allocation;
	_tmp9_ = _tmp8_.x;
	_tmp10_ = allocation;
	_tmp11_ = _tmp10_.y;
	gdk_window_get_root_coords (_tmp7_, _tmp9_, _tmp11_, &_tmp12_, &_tmp13_);
	x = _tmp12_;
	y = _tmp13_;
	gtk_window_move ((GtkWindow*) popup, x, y);
	gtk_widget_show ((GtkWidget*) popup);
	_g_object_unref0 (popup);
}


static void math_buttons_finc_cb (MathButtons* self, GtkWidget* widget) {
	gchar* name = NULL;
	GtkWidget* _tmp0_ = NULL;
	gconstpointer _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	GtkDialog* dialog = NULL;
	GtkBuilder* _tmp3_ = NULL;
	GObject* _tmp4_ = NULL;
	GtkDialog* _tmp5_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = widget;
	_tmp1_ = g_object_get_data ((GObject*) _tmp0_, "finc-dialog-name");
	_tmp2_ = g_strdup ((const gchar*) _tmp1_);
	name = _tmp2_;
	_tmp3_ = self->priv->financial_ui;
	_tmp4_ = gtk_builder_get_object (_tmp3_, name);
	_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, GTK_TYPE_DIALOG) ? ((GtkDialog*) _tmp4_) : NULL);
	dialog = _tmp5_;
	gtk_dialog_run (dialog);
	gtk_widget_hide ((GtkWidget*) dialog);
	_g_object_unref0 (dialog);
	_g_free0 (name);
}


static void math_buttons_insert_character_code_cb (MathButtons* self, GtkWidget* widget) {
	GtkDialog* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->character_code_dialog;
	gtk_window_present ((GtkWindow*) _tmp0_);
}


static void math_buttons_finc_activate_cb (MathButtons* self, GtkWidget* widget) {
	GtkEntry* next_entry = NULL;
	GtkWidget* _tmp0_ = NULL;
	gconstpointer _tmp1_ = NULL;
	GtkEntry* _tmp2_ = NULL;
	GtkEntry* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = widget;
	_tmp1_ = g_object_get_data ((GObject*) _tmp0_, "next-entry");
	_tmp2_ = _g_object_ref0 ((GtkEntry*) _tmp1_);
	next_entry = _tmp2_;
	_tmp3_ = next_entry;
	if (_tmp3_ == NULL) {
		GtkDialog* dialog = NULL;
		GtkWidget* _tmp4_ = NULL;
		GtkWidget* _tmp5_ = NULL;
		GtkDialog* _tmp6_ = NULL;
		GtkDialog* _tmp7_ = NULL;
		gboolean _tmp8_ = FALSE;
		_tmp4_ = widget;
		_tmp5_ = gtk_widget_get_toplevel (_tmp4_);
		_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, GTK_TYPE_DIALOG) ? ((GtkDialog*) _tmp5_) : NULL);
		dialog = _tmp6_;
		_tmp7_ = dialog;
		_tmp8_ = gtk_widget_is_toplevel ((GtkWidget*) _tmp7_);
		if (_tmp8_) {
			GtkDialog* _tmp9_ = NULL;
			_tmp9_ = dialog;
			gtk_dialog_response (_tmp9_, (gint) GTK_RESPONSE_OK);
			_g_object_unref0 (dialog);
			_g_object_unref0 (next_entry);
			return;
		}
		_g_object_unref0 (dialog);
	} else {
		GtkEntry* _tmp10_ = NULL;
		_tmp10_ = next_entry;
		gtk_widget_grab_focus ((GtkWidget*) _tmp10_);
	}
	_g_object_unref0 (next_entry);
}


static gchar** _vala_array_dup1 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup2 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup3 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup4 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup5 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup6 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup7 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup8 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup9 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup10 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static void math_buttons_finc_response_cb (MathButtons* self, GtkWidget* widget, gint response_id) {
	gint _tmp0_ = 0;
	FinancialDialog function = 0;
	GtkWidget* _tmp1_ = NULL;
	gconstpointer _tmp2_ = NULL;
	gchar** entries = NULL;
	gchar** _tmp3_ = NULL;
	gint entries_length1 = 0;
	gint _entries_size_ = 0;
	FinancialDialog _tmp4_ = 0;
	Number* arg[4] = {0};
	Number* _tmp15_ = NULL;
	Number* _tmp16_ = NULL;
	Number* _tmp17_ = NULL;
	Number* _tmp18_ = NULL;
	Number* _tmp19_[4] = {0};
	GtkEntry* first_entry = NULL;
	GtkBuilder* _tmp37_ = NULL;
	gchar** _tmp38_ = NULL;
	gint _tmp38__length1 = 0;
	const gchar* _tmp39_ = NULL;
	GObject* _tmp40_ = NULL;
	GtkEntry* _tmp41_ = NULL;
	GtkEntry* _tmp42_ = NULL;
	MathEquation* _tmp43_ = NULL;
	FinancialDialog _tmp44_ = 0;
	Number* _tmp45_ = NULL;
	Number* _tmp46_ = NULL;
	Number* _tmp47_ = NULL;
	Number* _tmp48_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = response_id;
	if (_tmp0_ != ((gint) GTK_RESPONSE_OK)) {
		return;
	}
	_tmp1_ = widget;
	_tmp2_ = g_object_get_data ((GObject*) _tmp1_, "finc-function");
	function = (FinancialDialog) ((gint) ((gintptr) _tmp2_));
	_tmp3_ = g_new0 (gchar*, 0 + 1);
	entries = _tmp3_;
	entries_length1 = 0;
	_entries_size_ = entries_length1;
	_tmp4_ = function;
	switch (_tmp4_) {
		case FINANCIAL_DIALOG_CTRM_DIALOG:
		{
			gchar** _tmp5_ = NULL;
			gint _tmp5__length1 = 0;
			_tmp5_ = (MATH_BUTTONS_ctrm_entries != NULL) ? _vala_array_dup1 (MATH_BUTTONS_ctrm_entries, G_N_ELEMENTS (MATH_BUTTONS_ctrm_entries)) : ((gpointer) MATH_BUTTONS_ctrm_entries);
			_tmp5__length1 = G_N_ELEMENTS (MATH_BUTTONS_ctrm_entries);
			entries = (_vala_array_free (entries, entries_length1, (GDestroyNotify) g_free), NULL);
			entries = _tmp5_;
			entries_length1 = _tmp5__length1;
			_entries_size_ = entries_length1;
			break;
		}
		case FINANCIAL_DIALOG_DDB_DIALOG:
		{
			gchar** _tmp6_ = NULL;
			gint _tmp6__length1 = 0;
			_tmp6_ = (MATH_BUTTONS_ddb_entries != NULL) ? _vala_array_dup2 (MATH_BUTTONS_ddb_entries, G_N_ELEMENTS (MATH_BUTTONS_ddb_entries)) : ((gpointer) MATH_BUTTONS_ddb_entries);
			_tmp6__length1 = G_N_ELEMENTS (MATH_BUTTONS_ddb_entries);
			entries = (_vala_array_free (entries, entries_length1, (GDestroyNotify) g_free), NULL);
			entries = _tmp6_;
			entries_length1 = _tmp6__length1;
			_entries_size_ = entries_length1;
			break;
		}
		case FINANCIAL_DIALOG_FV_DIALOG:
		{
			gchar** _tmp7_ = NULL;
			gint _tmp7__length1 = 0;
			_tmp7_ = (MATH_BUTTONS_fv_entries != NULL) ? _vala_array_dup3 (MATH_BUTTONS_fv_entries, G_N_ELEMENTS (MATH_BUTTONS_fv_entries)) : ((gpointer) MATH_BUTTONS_fv_entries);
			_tmp7__length1 = G_N_ELEMENTS (MATH_BUTTONS_fv_entries);
			entries = (_vala_array_free (entries, entries_length1, (GDestroyNotify) g_free), NULL);
			entries = _tmp7_;
			entries_length1 = _tmp7__length1;
			_entries_size_ = entries_length1;
			break;
		}
		case FINANCIAL_DIALOG_GPM_DIALOG:
		{
			gchar** _tmp8_ = NULL;
			gint _tmp8__length1 = 0;
			_tmp8_ = (MATH_BUTTONS_gpm_entries != NULL) ? _vala_array_dup4 (MATH_BUTTONS_gpm_entries, G_N_ELEMENTS (MATH_BUTTONS_gpm_entries)) : ((gpointer) MATH_BUTTONS_gpm_entries);
			_tmp8__length1 = G_N_ELEMENTS (MATH_BUTTONS_gpm_entries);
			entries = (_vala_array_free (entries, entries_length1, (GDestroyNotify) g_free), NULL);
			entries = _tmp8_;
			entries_length1 = _tmp8__length1;
			_entries_size_ = entries_length1;
			break;
		}
		case FINANCIAL_DIALOG_PMT_DIALOG:
		{
			gchar** _tmp9_ = NULL;
			gint _tmp9__length1 = 0;
			_tmp9_ = (MATH_BUTTONS_pmt_entries != NULL) ? _vala_array_dup5 (MATH_BUTTONS_pmt_entries, G_N_ELEMENTS (MATH_BUTTONS_pmt_entries)) : ((gpointer) MATH_BUTTONS_pmt_entries);
			_tmp9__length1 = G_N_ELEMENTS (MATH_BUTTONS_pmt_entries);
			entries = (_vala_array_free (entries, entries_length1, (GDestroyNotify) g_free), NULL);
			entries = _tmp9_;
			entries_length1 = _tmp9__length1;
			_entries_size_ = entries_length1;
			break;
		}
		case FINANCIAL_DIALOG_PV_DIALOG:
		{
			gchar** _tmp10_ = NULL;
			gint _tmp10__length1 = 0;
			_tmp10_ = (MATH_BUTTONS_pv_entries != NULL) ? _vala_array_dup6 (MATH_BUTTONS_pv_entries, G_N_ELEMENTS (MATH_BUTTONS_pv_entries)) : ((gpointer) MATH_BUTTONS_pv_entries);
			_tmp10__length1 = G_N_ELEMENTS (MATH_BUTTONS_pv_entries);
			entries = (_vala_array_free (entries, entries_length1, (GDestroyNotify) g_free), NULL);
			entries = _tmp10_;
			entries_length1 = _tmp10__length1;
			_entries_size_ = entries_length1;
			break;
		}
		case FINANCIAL_DIALOG_RATE_DIALOG:
		{
			gchar** _tmp11_ = NULL;
			gint _tmp11__length1 = 0;
			_tmp11_ = (MATH_BUTTONS_rate_entries != NULL) ? _vala_array_dup7 (MATH_BUTTONS_rate_entries, G_N_ELEMENTS (MATH_BUTTONS_rate_entries)) : ((gpointer) MATH_BUTTONS_rate_entries);
			_tmp11__length1 = G_N_ELEMENTS (MATH_BUTTONS_rate_entries);
			entries = (_vala_array_free (entries, entries_length1, (GDestroyNotify) g_free), NULL);
			entries = _tmp11_;
			entries_length1 = _tmp11__length1;
			_entries_size_ = entries_length1;
			break;
		}
		case FINANCIAL_DIALOG_SLN_DIALOG:
		{
			gchar** _tmp12_ = NULL;
			gint _tmp12__length1 = 0;
			_tmp12_ = (MATH_BUTTONS_sln_entries != NULL) ? _vala_array_dup8 (MATH_BUTTONS_sln_entries, G_N_ELEMENTS (MATH_BUTTONS_sln_entries)) : ((gpointer) MATH_BUTTONS_sln_entries);
			_tmp12__length1 = G_N_ELEMENTS (MATH_BUTTONS_sln_entries);
			entries = (_vala_array_free (entries, entries_length1, (GDestroyNotify) g_free), NULL);
			entries = _tmp12_;
			entries_length1 = _tmp12__length1;
			_entries_size_ = entries_length1;
			break;
		}
		case FINANCIAL_DIALOG_SYD_DIALOG:
		{
			gchar** _tmp13_ = NULL;
			gint _tmp13__length1 = 0;
			_tmp13_ = (MATH_BUTTONS_syd_entries != NULL) ? _vala_array_dup9 (MATH_BUTTONS_syd_entries, G_N_ELEMENTS (MATH_BUTTONS_syd_entries)) : ((gpointer) MATH_BUTTONS_syd_entries);
			_tmp13__length1 = G_N_ELEMENTS (MATH_BUTTONS_syd_entries);
			entries = (_vala_array_free (entries, entries_length1, (GDestroyNotify) g_free), NULL);
			entries = _tmp13_;
			entries_length1 = _tmp13__length1;
			_entries_size_ = entries_length1;
			break;
		}
		case FINANCIAL_DIALOG_TERM_DIALOG:
		{
			gchar** _tmp14_ = NULL;
			gint _tmp14__length1 = 0;
			_tmp14_ = (MATH_BUTTONS_term_entries != NULL) ? _vala_array_dup10 (MATH_BUTTONS_term_entries, G_N_ELEMENTS (MATH_BUTTONS_term_entries)) : ((gpointer) MATH_BUTTONS_term_entries);
			_tmp14__length1 = G_N_ELEMENTS (MATH_BUTTONS_term_entries);
			entries = (_vala_array_free (entries, entries_length1, (GDestroyNotify) g_free), NULL);
			entries = _tmp14_;
			entries_length1 = _tmp14__length1;
			_entries_size_ = entries_length1;
			break;
		}
		default:
		break;
	}
	_tmp15_ = number_new_integer ((gint64) 0);
	_tmp16_ = number_new_integer ((gint64) 0);
	_tmp17_ = number_new_integer ((gint64) 0);
	_tmp18_ = number_new_integer ((gint64) 0);
	_tmp19_[0] = _tmp15_;
	_tmp19_[1] = _tmp16_;
	_tmp19_[2] = _tmp17_;
	_tmp19_[3] = _tmp18_;
	memcpy (arg, _tmp19_, 4 * sizeof (Number*));
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp20_ = FALSE;
			_tmp20_ = TRUE;
			while (TRUE) {
				gboolean _tmp21_ = FALSE;
				gint _tmp23_ = 0;
				gchar** _tmp24_ = NULL;
				gint _tmp24__length1 = 0;
				GtkEntry* entry = NULL;
				GtkBuilder* _tmp25_ = NULL;
				gchar** _tmp26_ = NULL;
				gint _tmp26__length1 = 0;
				gint _tmp27_ = 0;
				const gchar* _tmp28_ = NULL;
				GObject* _tmp29_ = NULL;
				GtkEntry* _tmp30_ = NULL;
				gint _tmp31_ = 0;
				GtkEntry* _tmp32_ = NULL;
				const gchar* _tmp33_ = NULL;
				Number* _tmp34_ = NULL;
				Number* _tmp35_ = NULL;
				GtkEntry* _tmp36_ = NULL;
				_tmp21_ = _tmp20_;
				if (!_tmp21_) {
					gint _tmp22_ = 0;
					_tmp22_ = i;
					i = _tmp22_ + 1;
				}
				_tmp20_ = FALSE;
				_tmp23_ = i;
				_tmp24_ = entries;
				_tmp24__length1 = entries_length1;
				if (!(_tmp23_ < _tmp24__length1)) {
					break;
				}
				_tmp25_ = self->priv->financial_ui;
				_tmp26_ = entries;
				_tmp26__length1 = entries_length1;
				_tmp27_ = i;
				_tmp28_ = _tmp26_[_tmp27_];
				_tmp29_ = gtk_builder_get_object (_tmp25_, _tmp28_);
				_tmp30_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp29_, GTK_TYPE_ENTRY) ? ((GtkEntry*) _tmp29_) : NULL);
				entry = _tmp30_;
				_tmp31_ = i;
				_tmp32_ = entry;
				_tmp33_ = gtk_entry_get_text (_tmp32_);
				_tmp34_ = mp_set_from_string (_tmp33_, 10);
				_number_unref0 (arg[_tmp31_]);
				arg[_tmp31_] = _tmp34_;
				_tmp35_ = arg[_tmp31_];
				_tmp36_ = entry;
				gtk_entry_set_text (_tmp36_, "0");
				_g_object_unref0 (entry);
			}
		}
	}
	_tmp37_ = self->priv->financial_ui;
	_tmp38_ = entries;
	_tmp38__length1 = entries_length1;
	_tmp39_ = _tmp38_[0];
	_tmp40_ = gtk_builder_get_object (_tmp37_, _tmp39_);
	_tmp41_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp40_, GTK_TYPE_ENTRY) ? ((GtkEntry*) _tmp40_) : NULL);
	first_entry = _tmp41_;
	_tmp42_ = first_entry;
	gtk_widget_grab_focus ((GtkWidget*) _tmp42_);
	_tmp43_ = self->priv->equation;
	_tmp44_ = function;
	_tmp45_ = arg[0];
	_tmp46_ = arg[1];
	_tmp47_ = arg[2];
	_tmp48_ = arg[3];
	do_finc_expression (_tmp43_, _tmp44_, _tmp45_, _tmp46_, _tmp47_, _tmp48_);
	_g_object_unref0 (first_entry);
	_vala_array_destroy (arg, 4, (GDestroyNotify) number_unref);
	entries = (_vala_array_free (entries, entries_length1, (GDestroyNotify) g_free), NULL);
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static void math_buttons_character_code_dialog_response_cb (MathButtons* self, GtkWidget* dialog, gint response_id) {
	gchar* text = NULL;
	GtkEntry* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	GtkWidget* _tmp22_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dialog != NULL);
	_tmp0_ = self->priv->character_code_entry;
	_tmp1_ = gtk_entry_get_text (_tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	text = _tmp2_;
	_tmp3_ = response_id;
	if (_tmp3_ == ((gint) GTK_RESPONSE_OK)) {
		Number* x = NULL;
		Number* _tmp4_ = NULL;
		MathEquation* _tmp20_ = NULL;
		Number* _tmp21_ = NULL;
		_tmp4_ = number_new_integer ((gint64) 0);
		x = _tmp4_;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp5_ = FALSE;
				_tmp5_ = TRUE;
				while (TRUE) {
					gboolean _tmp6_ = FALSE;
					const gchar* _tmp8_ = NULL;
					gint _tmp9_ = 0;
					gchar _tmp10_ = '\0';
					Number* _tmp11_ = NULL;
					const gchar* _tmp12_ = NULL;
					gint _tmp13_ = 0;
					gchar _tmp14_ = '\0';
					Number* _tmp15_ = NULL;
					Number* _tmp16_ = NULL;
					Number* _tmp17_ = NULL;
					Number* _tmp18_ = NULL;
					Number* _tmp19_ = NULL;
					_tmp6_ = _tmp5_;
					if (!_tmp6_) {
						gint _tmp7_ = 0;
						_tmp7_ = i;
						i = _tmp7_ + 1;
					}
					_tmp5_ = FALSE;
					_tmp8_ = text;
					_tmp9_ = i;
					_tmp10_ = string_get (_tmp8_, (glong) _tmp9_);
					if (!(_tmp10_ != '\0')) {
						break;
					}
					_tmp11_ = x;
					_tmp12_ = text;
					_tmp13_ = i;
					_tmp14_ = string_get (_tmp12_, (glong) _tmp13_);
					_tmp15_ = number_new_integer ((gint64) _tmp14_);
					_tmp16_ = _tmp15_;
					_tmp17_ = number_add (_tmp11_, _tmp16_);
					_number_unref0 (x);
					x = _tmp17_;
					_number_unref0 (_tmp16_);
					_tmp18_ = x;
					_tmp19_ = number_shift (_tmp18_, 8);
					_number_unref0 (x);
					x = _tmp19_;
				}
			}
		}
		_tmp20_ = self->priv->equation;
		_tmp21_ = x;
		math_equation_insert_number (_tmp20_, _tmp21_);
		_number_unref0 (x);
	}
	_tmp22_ = dialog;
	gtk_widget_hide (_tmp22_);
	_g_free0 (text);
}


static void math_buttons_character_code_dialog_activate_cb (MathButtons* self, GtkWidget* entry) {
	GtkDialog* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (entry != NULL);
	_tmp0_ = self->priv->character_code_dialog;
	math_buttons_character_code_dialog_response_cb (self, (GtkWidget*) _tmp0_, (gint) GTK_RESPONSE_OK);
}


static gboolean math_buttons_character_code_dialog_delete_cb (MathButtons* self, GtkWidget* dialog, GdkEventAny* event) {
	gboolean result = FALSE;
	GtkWidget* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (dialog != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = dialog;
	math_buttons_character_code_dialog_response_cb (self, _tmp0_, (gint) GTK_RESPONSE_CANCEL);
	result = TRUE;
	return result;
}


static gboolean math_buttons_bit_toggle_cb (MathButtons* self, GtkWidget* event_box, GdkEventButton* event) {
	gboolean result = FALSE;
	MathEquation* _tmp0_ = NULL;
	GtkWidget* _tmp1_ = NULL;
	gconstpointer _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event_box != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->equation;
	_tmp1_ = event_box;
	_tmp2_ = g_object_get_data ((GObject*) _tmp1_, "bit_index");
	math_equation_toggle_bit (_tmp0_, (guint) ((gint) ((gintptr) _tmp2_)));
	result = TRUE;
	return result;
}


static void math_buttons_remove_trailing_spaces (MathButtons* self) {
	GtkTextMark* insert_mark = NULL;
	MathEquation* _tmp0_ = NULL;
	GtkTextMark* _tmp1_ = NULL;
	GtkTextMark* _tmp2_ = NULL;
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	MathEquation* _tmp3_ = NULL;
	GtkTextMark* _tmp4_ = NULL;
	GtkTextIter _tmp5_ = {0};
	GtkTextIter _tmp6_ = {0};
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->equation;
	_tmp1_ = gtk_text_buffer_get_insert ((GtkTextBuffer*) _tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	insert_mark = _tmp2_;
	_tmp3_ = self->priv->equation;
	_tmp4_ = insert_mark;
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) _tmp3_, &_tmp5_, _tmp4_);
	end = _tmp5_;
	_tmp6_ = end;
	start = _tmp6_;
	while (TRUE) {
		gboolean _tmp7_ = FALSE;
		gunichar _tmp8_ = 0U;
		gboolean _tmp9_ = FALSE;
		MathEquation* _tmp10_ = NULL;
		_tmp7_ = gtk_text_iter_backward_char (&start);
		if (!_tmp7_) {
			break;
		}
		_tmp8_ = gtk_text_iter_get_char (&start);
		_tmp9_ = g_unichar_isspace (_tmp8_);
		if (!_tmp9_) {
			break;
		}
		_tmp10_ = self->priv->equation;
		gtk_text_buffer_delete ((GtkTextBuffer*) _tmp10_, &start, &end);
	}
	_g_object_unref0 (insert_mark);
}


static void math_buttons_set_superscript_cb (MathButtons* self, GtkButton* widget) {
	GtkToggleButton* button = NULL;
	GtkButton* _tmp0_ = NULL;
	GtkToggleButton* _tmp1_ = NULL;
	GtkToggleButton* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = widget;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, GTK_TYPE_TOGGLE_BUTTON) ? ((GtkToggleButton*) _tmp0_) : NULL);
	button = _tmp1_;
	_tmp2_ = button;
	_tmp3_ = gtk_toggle_button_get_active (_tmp2_);
	if (_tmp3_) {
		MathEquation* _tmp4_ = NULL;
		MathEquation* _tmp5_ = NULL;
		gboolean _tmp6_ = FALSE;
		gboolean _tmp7_ = FALSE;
		_tmp4_ = self->priv->equation;
		math_equation_set_number_mode (_tmp4_, NUMBER_MODE_SUPERSCRIPT);
		_tmp5_ = self->priv->equation;
		_tmp6_ = gtk_text_buffer_get_has_selection ((GtkTextBuffer*) _tmp5_);
		_tmp7_ = _tmp6_;
		if (!_tmp7_) {
			math_buttons_remove_trailing_spaces (self);
		}
	} else {
		MathEquation* _tmp8_ = NULL;
		NumberMode _tmp9_ = 0;
		NumberMode _tmp10_ = 0;
		_tmp8_ = self->priv->equation;
		_tmp9_ = math_equation_get_number_mode (_tmp8_);
		_tmp10_ = _tmp9_;
		if (_tmp10_ == NUMBER_MODE_SUPERSCRIPT) {
			MathEquation* _tmp11_ = NULL;
			_tmp11_ = self->priv->equation;
			math_equation_set_number_mode (_tmp11_, NUMBER_MODE_NORMAL);
		}
	}
	_g_object_unref0 (button);
}


static void math_buttons_set_subscript_cb (MathButtons* self, GtkButton* widget) {
	GtkToggleButton* button = NULL;
	GtkButton* _tmp0_ = NULL;
	GtkToggleButton* _tmp1_ = NULL;
	GtkToggleButton* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = widget;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, GTK_TYPE_TOGGLE_BUTTON) ? ((GtkToggleButton*) _tmp0_) : NULL);
	button = _tmp1_;
	_tmp2_ = button;
	_tmp3_ = gtk_toggle_button_get_active (_tmp2_);
	if (_tmp3_) {
		MathEquation* _tmp4_ = NULL;
		MathEquation* _tmp5_ = NULL;
		gboolean _tmp6_ = FALSE;
		gboolean _tmp7_ = FALSE;
		_tmp4_ = self->priv->equation;
		math_equation_set_number_mode (_tmp4_, NUMBER_MODE_SUBSCRIPT);
		_tmp5_ = self->priv->equation;
		_tmp6_ = gtk_text_buffer_get_has_selection ((GtkTextBuffer*) _tmp5_);
		_tmp7_ = _tmp6_;
		if (!_tmp7_) {
			math_buttons_remove_trailing_spaces (self);
		}
	} else {
		MathEquation* _tmp8_ = NULL;
		NumberMode _tmp9_ = 0;
		NumberMode _tmp10_ = 0;
		_tmp8_ = self->priv->equation;
		_tmp9_ = math_equation_get_number_mode (_tmp8_);
		_tmp10_ = _tmp9_;
		if (_tmp10_ == NUMBER_MODE_SUBSCRIPT) {
			MathEquation* _tmp11_ = NULL;
			_tmp11_ = self->priv->equation;
			math_equation_set_number_mode (_tmp11_, NUMBER_MODE_NORMAL);
		}
	}
	_g_object_unref0 (button);
}


static void math_buttons_number_mode_changed_cb (MathButtons* self) {
	NumberMode mode = 0;
	MathEquation* _tmp0_ = NULL;
	NumberMode _tmp1_ = 0;
	NumberMode _tmp2_ = 0;
	GList* _tmp3_ = NULL;
	GList* _tmp7_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->equation;
	_tmp1_ = math_equation_get_number_mode (_tmp0_);
	_tmp2_ = _tmp1_;
	mode = _tmp2_;
	_tmp3_ = self->priv->superscript_toggles;
	{
		GList* toggle_collection = NULL;
		GList* toggle_it = NULL;
		toggle_collection = _tmp3_;
		for (toggle_it = toggle_collection; toggle_it != NULL; toggle_it = toggle_it->next) {
			GtkToggleButton* _tmp4_ = NULL;
			GtkToggleButton* toggle = NULL;
			_tmp4_ = _g_object_ref0 ((GtkToggleButton*) toggle_it->data);
			toggle = _tmp4_;
			{
				GtkToggleButton* _tmp5_ = NULL;
				NumberMode _tmp6_ = 0;
				_tmp5_ = toggle;
				_tmp6_ = mode;
				gtk_toggle_button_set_active (_tmp5_, _tmp6_ == NUMBER_MODE_SUPERSCRIPT);
				_g_object_unref0 (toggle);
			}
		}
	}
	_tmp7_ = self->priv->subscript_toggles;
	{
		GList* toggle_collection = NULL;
		GList* toggle_it = NULL;
		toggle_collection = _tmp7_;
		for (toggle_it = toggle_collection; toggle_it != NULL; toggle_it = toggle_it->next) {
			GtkToggleButton* _tmp8_ = NULL;
			GtkToggleButton* toggle = NULL;
			_tmp8_ = _g_object_ref0 ((GtkToggleButton*) toggle_it->data);
			toggle = _tmp8_;
			{
				GtkToggleButton* _tmp9_ = NULL;
				NumberMode _tmp10_ = 0;
				_tmp9_ = toggle;
				_tmp10_ = mode;
				gtk_toggle_button_set_active (_tmp9_, _tmp10_ == NUMBER_MODE_SUBSCRIPT);
				_g_object_unref0 (toggle);
			}
		}
	}
}


ButtonMode math_buttons_get_mode (MathButtons* self) {
	ButtonMode result;
	ButtonMode _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_mode;
	result = _tmp0_;
	return result;
}


void math_buttons_set_mode (MathButtons* self, ButtonMode value) {
	ButtonMode _tmp0_ = 0;
	ButtonMode _tmp1_ = 0;
	ButtonMode _tmp2_ = 0;
	ButtonMode _tmp3_ = 0;
	ButtonMode _tmp4_ = 0;
	gboolean _tmp8_ = FALSE;
	ButtonMode _tmp9_ = 0;
	ButtonMode _tmp10_ = 0;
	MathConverter* _tmp13_ = NULL;
	gboolean _tmp14_ = FALSE;
	ButtonMode _tmp15_ = 0;
	ButtonMode _tmp16_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_mode;
	_tmp1_ = value;
	if (_tmp0_ == _tmp1_) {
		return;
	}
	_tmp2_ = value;
	self->priv->_mode = _tmp2_;
	_tmp3_ = math_buttons_get_mode (self);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == BUTTON_MODE_PROGRAMMING) {
		MathEquation* _tmp5_ = NULL;
		gint _tmp6_ = 0;
		_tmp5_ = self->priv->equation;
		_tmp6_ = self->priv->_programming_base;
		math_equation_set_number_base (_tmp5_, _tmp6_);
	} else {
		MathEquation* _tmp7_ = NULL;
		_tmp7_ = self->priv->equation;
		math_equation_set_number_base (_tmp7_, 10);
	}
	math_buttons_load_buttons (self);
	_tmp9_ = math_buttons_get_mode (self);
	_tmp10_ = _tmp9_;
	if (_tmp10_ == BUTTON_MODE_ADVANCED) {
		_tmp8_ = TRUE;
	} else {
		ButtonMode _tmp11_ = 0;
		ButtonMode _tmp12_ = 0;
		_tmp11_ = math_buttons_get_mode (self);
		_tmp12_ = _tmp11_;
		_tmp8_ = _tmp12_ == BUTTON_MODE_FINANCIAL;
	}
	_tmp13_ = self->priv->converter;
	_tmp14_ = _tmp8_;
	gtk_widget_set_visible ((GtkWidget*) _tmp13_, _tmp14_);
	_tmp15_ = math_buttons_get_mode (self);
	_tmp16_ = _tmp15_;
	if (_tmp16_ == BUTTON_MODE_ADVANCED) {
		MathConverter* _tmp17_ = NULL;
		MathConverter* _tmp18_ = NULL;
		MathEquation* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
		gchar* _tmp22_ = NULL;
		MathEquation* _tmp23_ = NULL;
		gchar* _tmp24_ = NULL;
		gchar* _tmp25_ = NULL;
		gchar* _tmp26_ = NULL;
		_tmp17_ = self->priv->converter;
		math_converter_set_category (_tmp17_, NULL);
		_tmp18_ = self->priv->converter;
		_tmp19_ = self->priv->equation;
		_tmp20_ = math_equation_get_source_units (_tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = _tmp21_;
		_tmp23_ = self->priv->equation;
		_tmp24_ = math_equation_get_target_units (_tmp23_);
		_tmp25_ = _tmp24_;
		_tmp26_ = _tmp25_;
		math_converter_set_conversion (_tmp18_, _tmp22_, _tmp26_);
		_g_free0 (_tmp26_);
		_g_free0 (_tmp22_);
	} else {
		ButtonMode _tmp27_ = 0;
		ButtonMode _tmp28_ = 0;
		_tmp27_ = math_buttons_get_mode (self);
		_tmp28_ = _tmp27_;
		if (_tmp28_ == BUTTON_MODE_FINANCIAL) {
			MathConverter* _tmp29_ = NULL;
			MathConverter* _tmp30_ = NULL;
			MathEquation* _tmp31_ = NULL;
			gchar* _tmp32_ = NULL;
			gchar* _tmp33_ = NULL;
			gchar* _tmp34_ = NULL;
			MathEquation* _tmp35_ = NULL;
			gchar* _tmp36_ = NULL;
			gchar* _tmp37_ = NULL;
			gchar* _tmp38_ = NULL;
			_tmp29_ = self->priv->converter;
			math_converter_set_category (_tmp29_, "currency");
			_tmp30_ = self->priv->converter;
			_tmp31_ = self->priv->equation;
			_tmp32_ = math_equation_get_source_currency (_tmp31_);
			_tmp33_ = _tmp32_;
			_tmp34_ = _tmp33_;
			_tmp35_ = self->priv->equation;
			_tmp36_ = math_equation_get_target_currency (_tmp35_);
			_tmp37_ = _tmp36_;
			_tmp38_ = _tmp37_;
			math_converter_set_conversion (_tmp30_, _tmp34_, _tmp38_);
			_g_free0 (_tmp38_);
			_g_free0 (_tmp34_);
		}
	}
	g_object_notify ((GObject *) self, "mode");
}


gint math_buttons_get_programming_base (MathButtons* self) {
	gint result;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_programming_base;
	result = _tmp0_;
	return result;
}


void math_buttons_set_programming_base (MathButtons* self, gint value) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	ButtonMode _tmp3_ = 0;
	ButtonMode _tmp4_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_programming_base;
	_tmp1_ = value;
	if (_tmp0_ == _tmp1_) {
		return;
	}
	_tmp2_ = value;
	self->priv->_programming_base = _tmp2_;
	g_object_notify ((GObject*) self, "programming-base");
	_tmp3_ = math_buttons_get_mode (self);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == BUTTON_MODE_PROGRAMMING) {
		MathEquation* _tmp5_ = NULL;
		gint _tmp6_ = 0;
		_tmp5_ = self->priv->equation;
		_tmp6_ = value;
		math_equation_set_number_base (_tmp5_, _tmp6_);
	}
	g_object_notify ((GObject *) self, "programming-base");
}


static void math_buttons_class_init (MathButtonsClass * klass) {
	math_buttons_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (MathButtonsPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_math_buttons_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_math_buttons_set_property;
	G_OBJECT_CLASS (klass)->finalize = math_buttons_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_BUTTONS_MODE, g_param_spec_enum ("mode", "mode", "mode", TYPE_BUTTON_MODE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_BUTTONS_PROGRAMMING_BASE, g_param_spec_int ("programming-base", "programming-base", "programming-base", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void math_buttons_instance_init (MathButtons * self) {
	self->priv = MATH_BUTTONS_GET_PRIVATE (self);
	self->priv->_programming_base = 10;
	self->priv->active_panel = NULL;
}


static void math_buttons_finalize (GObject* obj) {
	MathButtons * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MATH_BUTTONS, MathButtons);
	_g_object_unref0 (self->priv->equation);
	_g_object_unref0 (self->priv->converter);
	_g_object_unref0 (self->priv->basic_ui);
	_g_object_unref0 (self->priv->advanced_ui);
	_g_object_unref0 (self->priv->financial_ui);
	_g_object_unref0 (self->priv->programming_ui);
	_g_object_unref0 (self->priv->bas_panel);
	_g_object_unref0 (self->priv->adv_panel);
	_g_object_unref0 (self->priv->fin_panel);
	_g_object_unref0 (self->priv->prog_panel);
	_g_object_unref0 (self->priv->active_panel);
	_g_object_unref0 (self->priv->shift_left_menu);
	_g_object_unref0 (self->priv->shift_right_menu);
	__g_list_free__g_object_unref0_0 (self->priv->superscript_toggles);
	__g_list_free__g_object_unref0_0 (self->priv->subscript_toggles);
	_g_object_unref0 (self->priv->base_combo);
	_g_object_unref0 (self->priv->base_label);
	_g_object_unref0 (self->priv->bit_panel);
	__g_list_free__g_object_unref0_0 (self->priv->bit_labels);
	_g_object_unref0 (self->priv->character_code_dialog);
	_g_object_unref0 (self->priv->character_code_entry);
	G_OBJECT_CLASS (math_buttons_parent_class)->finalize (obj);
}


GType math_buttons_get_type (void) {
	static volatile gsize math_buttons_type_id__volatile = 0;
	if (g_once_init_enter (&math_buttons_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MathButtonsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) math_buttons_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MathButtons), 0, (GInstanceInitFunc) math_buttons_instance_init, NULL };
		GType math_buttons_type_id;
		math_buttons_type_id = g_type_register_static (GTK_TYPE_BOX, "MathButtons", &g_define_type_info, 0);
		g_once_init_leave (&math_buttons_type_id__volatile, math_buttons_type_id);
	}
	return math_buttons_type_id__volatile;
}


static void _vala_math_buttons_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	MathButtons * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MATH_BUTTONS, MathButtons);
	switch (property_id) {
		case MATH_BUTTONS_MODE:
		g_value_set_enum (value, math_buttons_get_mode (self));
		break;
		case MATH_BUTTONS_PROGRAMMING_BASE:
		g_value_set_int (value, math_buttons_get_programming_base (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_math_buttons_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	MathButtons * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MATH_BUTTONS, MathButtons);
	switch (property_id) {
		case MATH_BUTTONS_MODE:
		math_buttons_set_mode (self, g_value_get_enum (value));
		break;
		case MATH_BUTTONS_PROGRAMMING_BASE:
		math_buttons_set_programming_base (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



