// -*- c++ -*-
// Generated by gmmproc 2.39.3 -- DO NOT MODIFY!
#ifndef _GIOMM_APPLICATION_H
#define _GIOMM_APPLICATION_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

// -*- Mode: C++; indent-tabs-mode: nil; c-basic-offset: 2 -*-

/* Copyright (C) 2007 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

 
#include <giomm/actiongroup.h>
#include <giomm/actionmap.h>
#include <giomm/applicationcommandline.h>
#include <giomm/file.h>
#include <glibmm/object.h>
#include <glibmm/variant.h>
#include <giomm/dbusconnection.h>
#include <giomm/notification.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GApplication GApplication;
typedef struct _GApplicationClass GApplicationClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gio
{ class Application_Class; } // namespace Gio
namespace Gio
{

/** @addtogroup giommEnums giomm Enums and Flags */

/** 
 *  @var ApplicationFlags APPLICATION_FLAGS_NONE
 *  Default.
 * 
 *  @var ApplicationFlags APPLICATION_IS_SERVICE
 *  Run as a service. In this mode, registrationfails if the service is already running, and the applicationwill initially wait up to 10 seconds for an initial activationmessage to arrive.
 * 
 *  @var ApplicationFlags APPLICATION_IS_LAUNCHER
 *  Don't try to become the primary instance.
 * 
 *  @var ApplicationFlags APPLICATION_HANDLES_OPEN
 *  This application handles opening files (inthe primary instance). Note that this flag only affects the defaultimplementation of local_command_line(), and has no effect ifApplication::HANDLES_COMMAND_LINE is given.See g_application_run() for details.
 * 
 *  @var ApplicationFlags APPLICATION_HANDLES_COMMAND_LINE
 *  This application handles command linearguments (in the primary instance). Note that this flag only affectthe default implementation of local_command_line().See g_application_run() for details.
 * 
 *  @var ApplicationFlags APPLICATION_SEND_ENVIRONMENT
 *  Send the environment of thelaunching process to the primary instance. Set this flag if yourapplication is expected to behave differently depending on certainenvironment variables. For instance, an editor might be expectedto use the <tt>COMMITTER_NAME</tt> environment variablewhen editing a git commit message. The environment is availableto the Application::signal_command_line() signal handler, viag_application_command_line_getenv().
 * 
 *  @var ApplicationFlags APPLICATION_NON_UNIQUE
 *  Make no attempts to do any of the typicalsingle-instance application negotiation, even if the applicationID is given.  The application neither attempts to become theowner of the application ID nor does it check if an existingowner already exists.  Everything occurs in the local process.@newin{2,30}
 * 
 *  @enum ApplicationFlags
 * 
 * Flags used to define the behaviour of a Application.
 * 
 * @newin{2,28}
 * @ingroup giommEnums
 * @par Bitwise operators:
 * <tt>%ApplicationFlags operator|(ApplicationFlags, ApplicationFlags)</tt><br>
 * <tt>%ApplicationFlags operator&(ApplicationFlags, ApplicationFlags)</tt><br>
 * <tt>%ApplicationFlags operator^(ApplicationFlags, ApplicationFlags)</tt><br>
 * <tt>%ApplicationFlags operator~(ApplicationFlags)</tt><br>
 * <tt>%ApplicationFlags& operator|=(ApplicationFlags&, ApplicationFlags)</tt><br>
 * <tt>%ApplicationFlags& operator&=(ApplicationFlags&, ApplicationFlags)</tt><br>
 * <tt>%ApplicationFlags& operator^=(ApplicationFlags&, ApplicationFlags)</tt><br>
 */
enum ApplicationFlags
{
  APPLICATION_FLAGS_NONE = 0x0,
  APPLICATION_IS_SERVICE = (1 << 0),
  APPLICATION_IS_LAUNCHER = (1 << 1),
  APPLICATION_HANDLES_OPEN = (1 << 2),
  APPLICATION_HANDLES_COMMAND_LINE = (1 << 3),
  APPLICATION_SEND_ENVIRONMENT = (1 << 4),
  APPLICATION_NON_UNIQUE = (1 << 5)
};

/** @ingroup giommEnums */
inline ApplicationFlags operator|(ApplicationFlags lhs, ApplicationFlags rhs)
  { return static_cast<ApplicationFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup giommEnums */
inline ApplicationFlags operator&(ApplicationFlags lhs, ApplicationFlags rhs)
  { return static_cast<ApplicationFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup giommEnums */
inline ApplicationFlags operator^(ApplicationFlags lhs, ApplicationFlags rhs)
  { return static_cast<ApplicationFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup giommEnums */
inline ApplicationFlags operator~(ApplicationFlags flags)
  { return static_cast<ApplicationFlags>(~static_cast<unsigned>(flags)); }

/** @ingroup giommEnums */
inline ApplicationFlags& operator|=(ApplicationFlags& lhs, ApplicationFlags rhs)
  { return (lhs = static_cast<ApplicationFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup giommEnums */
inline ApplicationFlags& operator&=(ApplicationFlags& lhs, ApplicationFlags rhs)
  { return (lhs = static_cast<ApplicationFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup giommEnums */
inline ApplicationFlags& operator^=(ApplicationFlags& lhs, ApplicationFlags rhs)
  { return (lhs = static_cast<ApplicationFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }


/** Application - Core application class.
 * An Application is the foundation of an application, unique for a given
 * application identifier. The Application class wraps some low-level
 * platform-specific services and is intended to act as the foundation for
 * higher-level application classes such as Gtk::Application or MxApplication.
 * In general, you should not use this class outside of a higher level
 * framework.
 *
 * One of the core features that Application provides is process uniqueness,
 * in the context of a "session". The session concept is platform-dependent,
 * but corresponds roughly to a graphical desktop login. When your application
 * is launched again, its arguments are passed through platform communication
 * to the already running program. The already running instance of the program
 * is called the <i>primary instance</i>.
 *
 * Before using Application, you must choose an "application identifier". The
 * expected form of an application identifier is very close to that of of a
 * <a href="
 * http://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-names-interface">DBus
 * bus name</a>. Examples include: "com.example.MyApp",
 * "org.example.internal-apps.Calculator". For details on valid application
 * identifiers, see id_is_valid().
 *
 * Application provides convenient life cycle management by maintaining a
 * <i>use count</i> for the primary application instance. The use count can be
 * changed using hold() and release(). If it drops to zero, the application
 * exits.
 *
 * Application also implements the ActionGroup interface and lets you easily
 * export actions by adding them with set_action_group(). When
 * invoking an action by calling Gio::ActionGroup::activate_action() on the
 * application, it is always invoked in the primary instance.
 *
 * There is a number of different entry points into an Application:
 *
 * - via 'Activate' (i.e. just starting the application)
 * - via 'Open' (i.e. opening some files)
 * - via activating an action
 *
 * The signal_startup() signal lets you handle the application initialization
 * for all of these in a single place.
 *
 * See the C API docs for an example.
 *
 * @newin{2,32}
 */

class Application : public Glib::Object, public ActionGroup, public ActionMap
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Application CppObjectType;
  typedef Application_Class CppClassType;
  typedef GApplication BaseObjectType;
  typedef GApplicationClass BaseClassType;

private:  friend class Application_Class;
  static CppClassType application_class_;

private:
  // noncopyable
  Application(const Application&);
  Application& operator=(const Application&);

protected:
  explicit Application(const Glib::ConstructParams& construct_params);
  explicit Application(GApplication* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Application();

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GApplication*       gobj()       { return reinterpret_cast<GApplication*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GApplication* gobj() const { return reinterpret_cast<GApplication*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GApplication* gobj_copy();

private:

  
protected:
  /** Constructs an application instance.
   * If no application ID is given then some features (most notably application uniqueness) will be disabled.
   *
   * @param application_id The application ID.
   * @param flags The application flags.
   */
  explicit Application(const Glib::ustring& application_id = Glib::ustring(), ApplicationFlags flags = APPLICATION_FLAGS_NONE);
  

public:
  /** Creates an application instance.
   * If no application ID is given then some features (most notably application uniqueness) will be disabled.
   *
   * @param application_id The application ID.
   * @param flags The application flags.
   */
  
  static Glib::RefPtr<Application> create(const Glib::ustring& application_id =  Glib::ustring(), ApplicationFlags flags =  APPLICATION_FLAGS_NONE);


  /** Checks if @a application_id is a valid application identifier.
   * 
   * A valid ID is required for calls to g_application_new() and
   * g_application_set_application_id().
   * 
   * For convenience, the restrictions on application identifiers are
   * reproduced here:
   * - Application identifiers must contain only the ASCII characters "[A-Z][a-z][0-9]_-." and must not begin with a digit.
   * - Application identifiers must contain at least one '.' (period) character (and thus at least three elements).
   * - Application identifiers must not begin or end with a '.' (period) character.
   * - Application identifiers must not contain consecutive '.' (period) characters.
   * - Application identifiers must not exceed 255 characters.
   * 
   * @param application_id A potential application identifier.
   * @return <tt>true</tt> if @a application_id is valid.
   */
  static bool id_is_valid(const Glib::ustring& application_id);

  
  /** Gets the unique identifier for @a application.
   * 
   * @newin{2,28}
   * @return The identifier for @a application, owned by @a application.
   */
  Glib::ustring get_id() const;
  
  /** Sets the unique identifier for @a application.
   * 
   * The application id can only be modified if @a application has not yet
   * been registered.
   * 
   * If non-<tt>0</tt>, the application id must be valid.  See
   * g_application_id_is_valid().
   * 
   * @newin{2,28}
   * @param application_id The identifier for @a application.
   */
  void set_id(const Glib::ustring& application_id);


  /** Gets the DBusConnection being used by the application, or <tt>0</tt>.
   * 
   * If Application is using its D-Bus backend then this function will
   * return the DBusConnection being used for uniqueness and
   * communication with the desktop environment and other instances of the
   * application.
   * 
   * If Application is not using D-Bus then this function will return
   * <tt>0</tt>.  This includes the situation where the D-Bus backend would
   * normally be in use but we were unable to connect to the bus.
   * 
   * This function must not be called before the application has been
   * registered.  See g_application_get_is_registered().
   * 
   * @newin{2,34}
   * @return A DBusConnection, or <tt>0</tt>.
   */
  Glib::RefPtr<DBus::Connection> get_dbus_connection();
  
  /** Gets the DBusConnection being used by the application, or <tt>0</tt>.
   * 
   * If Application is using its D-Bus backend then this function will
   * return the DBusConnection being used for uniqueness and
   * communication with the desktop environment and other instances of the
   * application.
   * 
   * If Application is not using D-Bus then this function will return
   * <tt>0</tt>.  This includes the situation where the D-Bus backend would
   * normally be in use but we were unable to connect to the bus.
   * 
   * This function must not be called before the application has been
   * registered.  See g_application_get_is_registered().
   * 
   * @newin{2,34}
   * @return A DBusConnection, or <tt>0</tt>.
   */
  Glib::RefPtr<const DBus::Connection> get_dbus_connection() const;

  
  /** Gets the D-Bus object path being used by the application, or <tt>0</tt>.
   * 
   * If Application is using its D-Bus backend then this function will
   * return the D-Bus object path that Application is using.  If the
   * application is the primary instance then there is an object published
   * at this path.  If the application is not the primary instance then
   * the result of this function is undefined.
   * 
   * If Application is not using D-Bus then this function will return
   * <tt>0</tt>.  This includes the situation where the D-Bus backend would
   * normally be in use but we were unable to connect to the bus.
   * 
   * This function must not be called before the application has been
   * registered.  See g_application_get_is_registered().
   * 
   * @newin{2,34}
   * @return The object path, or <tt>0</tt>.
   */
  Glib::ustring get_dbus_object_path() const;

  
  /** Gets the current inactivity timeout for the application.
   * 
   * This is the amount of time (in milliseconds) after the last call to
   * g_application_release() before the application stops running.
   * 
   * @newin{2,28}
   * @return The timeout, in milliseconds.
   */
  guint get_inactivity_timeout() const;
  
  /** Sets the current inactivity timeout for the application.
   * 
   * This is the amount of time (in milliseconds) after the last call to
   * g_application_release() before the application stops running.
   * 
   * This call has no side effects of its own.  The value set here is only
   * used for next time g_application_release() drops the use count to
   * zero.  Any timeouts currently in progress are not impacted.
   * 
   * @newin{2,28}
   * @param inactivity_timeout The timeout, in milliseconds.
   */
  void set_inactivity_timeout(guint inactivity_timeout);

  
  /** Gets the flags for @a application.
   * 
   * See ApplicationFlags.
   * 
   * @newin{2,28}
   * @return The flags for @a application.
   */
  ApplicationFlags get_flags() const;
  
  /** Sets the flags for @a application.
   * 
   * The flags can only be modified if @a application has not yet been
   * registered.
   * 
   * See ApplicationFlags.
   * 
   * @newin{2,28}
   * @param flags The flags for @a application.
   */
  void set_flags(ApplicationFlags flags);

  
  /** This used to be how actions were associated with a Application.
   * Now there is ActionMap for that.
   * 
   * @newin{2,28}
   * 
   * Deprecated:2.32:Use the ActionMap interface instead.  Never ever
   * mix use of this API with use of ActionMap on the same @a application
   * or things will go very badly wrong.  This function is known to
   * introduce buggy behaviour (ie: signals not emitted on changes to the
   * action group), so you should really use ActionMap instead.
   * @param action_group A ActionGroup, or <tt>0</tt>.
   */
  void set_action_group(const Glib::RefPtr<ActionGroup>& action_group);

  
  /** Checks if @a application is registered.
   * 
   * An application is registered if g_application_register() has been
   * successfully called.
   * 
   * @newin{2,28}
   * @return <tt>true</tt> if @a application is registered.
   */
  bool is_registered() const;
  
  /** Checks if @a application is remote.
   * 
   * If @a application is remote then it means that another instance of
   * application already exists (the 'primary' instance).  Calls to
   * perform actions on @a application will result in the actions being
   * performed by the primary instance.
   * 
   * The value of this property cannot be accessed before
   * g_application_register() has been called.  See
   * g_application_get_is_registered().
   * 
   * @newin{2,28}
   * @return <tt>true</tt> if @a application is remote.
   */
  bool is_remote() const;

  //Renamed from register() because that is a C++ keyword.
  
  /** Attempts registration of the application.
   * 
   * This is the point at which the application discovers if it is the
   * primary instance or merely acting as a remote for an already-existing
   * primary instance.  This is implemented by attempting to acquire the
   * application identifier as a unique bus name on the session bus using
   * GDBus.
   * 
   * If there is no application ID or if APPLICATION_NON_UNIQUE was
   * given, then this process will always become the primary instance.
   * 
   * Due to the internal architecture of GDBus, method calls can be
   * dispatched at any time (even if a main loop is not running).  For
   * this reason, you must ensure that any object paths that you wish to
   * register are registered before calling this function.
   * 
   * If the application has already been registered then <tt>true</tt> is
   * returned with no work performed.
   * 
   * The Application::signal_startup() signal is emitted if registration succeeds
   * and @a application is the primary instance (including the non-unique
   * case).
   * 
   * In the event of an error (such as @a cancellable being cancelled, or a
   * failure to connect to the session bus), <tt>false</tt> is returned and @a error
   * is set appropriately.
   * 
   * @note the return value of this function is not an indicator that this
   * instance is or is not the primary instance of the application.  See
   * g_application_get_is_remote() for that.
   * 
   * @newin{2,28}
   * @param cancellable A Cancellable, or <tt>0</tt>.
   * @return <tt>true</tt> if registration succeeded.
   */
  bool register_application(const Glib::RefPtr<Gio::Cancellable>& cancellable);

  /// A register_application() convenience overload.
  bool register_application();
  

  /** Increases the use count of @a application.
   * 
   * Use this function to indicate that the application has a reason to
   * continue to run.  For example, g_application_hold() is called by GTK+
   * when a toplevel window is on the screen.
   * 
   * To cancel the hold, call g_application_release().
   */
  void hold();
  
  /** Decrease the use count of @a application.
   * 
   * When the use count reaches zero, the application will stop running.
   * 
   * Never call this function except to cancel the effect of a previous
   * call to g_application_hold().
   */
  void release();
  
  /** Activates the application.
   * 
   * In essence, this results in the Application::signal_activate() signal being
   * emitted in the primary instance.
   * 
   * The application must be registered before calling this function.
   * 
   * @newin{2,28}
   */
  void activate();

  typedef std::vector< Glib::RefPtr<File> > type_vec_files;

  /* Opens the given files.
   *
   * In essence, this results in the open signal being emitted
   * in the primary instance.
   *
   * @a hint is simply passed through to the open signal.  It is
   * intended to be used by applications that have multiple modes for
   * opening files (eg: "view" vs "edit", etc).
   *
   * The application must be registered before calling this mwethod
   * and it must have the APPLICATION_HANDLES_OPEN flag set.
   *
   * @param files The files to open. This must be non-empty.
   * @param hint A hint.
   *
   * @newin{2,32}
   */
  void open(const type_vec_files& files, const Glib::ustring& hint = Glib::ustring());
  

  /* Opens the given file.
   *
   * In essence, this results in the open signal being emitted
   * in the primary instance.
   *
   * @a hint is simply passed through to the open signal.  It is
   * intended to be used by applications that have multiple modes for
   * opening files (eg: "view" vs "edit", etc).
   *
   * The application must be registered before calling this mwethod
   * and it must have the APPLICATION_HANDLES_OPEN flag set.
   *
   * @param file The file to open. This must be non-empty.
   * @param hint A hint.
   *
   * @newin{2,32}
   */
  void open(const Glib::RefPtr<Gio::File>& file, const Glib::ustring& hint = Glib::ustring());

  
  /** Runs the application.
   * 
   * This function is intended to be run from main() and its return value
   * is intended to be returned by main(). Although you are expected to pass
   * the @a argc, @a argv parameters from main() to this function, it is possible
   * to pass <tt>0</tt> if @a argv is not available or commandline handling is not
   * required.
   * 
   * First, the local_command_line() virtual function is invoked.
   * This function always runs on the local instance. It gets passed a pointer
   * to a <tt>0</tt>-terminated copy of @a argv and is expected to remove the arguments
   * that it handled (shifting up remaining arguments). See
   * <xref linkend="gapplication-example-cmdline2"/> for an example of
   * parsing @a argv manually. Alternatively, you may use the OptionContext API,
   * after setting <tt>argc = g_strv_length (argv);</tt>.
   * 
   * The last argument to local_command_line() is a pointer to the @a status
   * variable which can used to set the exit status that is returned from
   * g_application_run().
   * 
   * If local_command_line() returns <tt>true</tt>, the command line is expected
   * to be completely handled, including possibly registering as the primary
   * instance, calling g_application_activate() or g_application_open(), etc.
   * 
   * If local_command_line() returns <tt>false</tt> then the application is registered
   * and the Application::signal_command_line() signal is emitted in the primary
   * instance (which may or may not be this instance). The signal handler
   * gets passed a ApplicationCommandLine object that (among other things)
   * contains the remaining commandline arguments that have not been handled
   * by local_command_line().
   * 
   * If the application has the APPLICATION_HANDLES_COMMAND_LINE
   * flag set then the default implementation of local_command_line()
   * always returns <tt>false</tt> immediately, resulting in the commandline
   * always being handled in the primary instance.
   * 
   * Otherwise, the default implementation of local_command_line() tries
   * to do a couple of things that are probably reasonable for most
   * applications.  First, g_application_register() is called to attempt
   * to register the application.  If that works, then the command line
   * arguments are inspected.  If no commandline arguments are given, then
   * g_application_activate() is called.  If commandline arguments are
   * given and the APPLICATION_HANDLES_OPEN flag is set then they
   * are assumed to be filenames and g_application_open() is called.
   * 
   * If you need to handle commandline arguments that are not filenames,
   * and you don't mind commandline handling to happen in the primary
   * instance, you should set APPLICATION_HANDLES_COMMAND_LINE and
   * process the commandline arguments in your Application::signal_command_line()
   * signal handler, either manually or using the OptionContext API.
   * 
   * If you are interested in doing more complicated local handling of the
   * commandline then you should implement your own Application subclass
   * and override local_command_line(). In this case, you most likely want
   * to return <tt>true</tt> from your local_command_line() implementation to
   * suppress the default handling. See
   * <xref linkend="gapplication-example-cmdline2"/> for an example.
   * 
   * If, after the above is done, the use count of the application is zero
   * then the exit status is returned immediately.  If the use count is
   * non-zero then the default main context is iterated until the use count
   * falls to zero, at which point 0 is returned.
   * 
   * If the APPLICATION_IS_SERVICE flag is set, then the service will
   * run for as much as 10 seconds with a use count of zero while waiting
   * for the message that caused the activation to arrive.  After that,
   * if the use count falls to zero the application will exit immediately,
   * except in the case that g_application_set_inactivity_timeout() is in
   * use.
   * 
   * This function sets the prgname (Glib::set_prgname()), if not already set,
   * to the basename of argv[0].  Since 2.38, if APPLICATION_IS_SERVICE
   * is specified, the prgname is set to the application ID.  The main
   * impact of this is is that the wmclass of windows created by Gtk+ will
   * be set accordingly, which helps the window manager determine which
   * application is showing the window.
   * 
   * Since 2.40, applications that are not explicitly flagged as services
   * or launchers (ie: neither APPLICATION_IS_SERVICE or
   * APPLICATION_IS_LAUNCHER are given as flags) will check (from the
   * default handler for local_command_line) if "--gapplication-service"
   * was given in the command line.  If this flag is present then normal
   * commandline processing is interrupted and the
   * APPLICATION_IS_SERVICE flag is set.  This provides a "compromise"
   * solution whereby running an application directly from the commandline
   * will invoke it in the normal way (which can be useful for debugging)
   * while still allowing applications to be D-Bus activated in service
   * mode.  The D-Bus service file should invoke the executable with
   * "--gapplication-service" as the sole commandline argument.  This
   * approach is suitable for use by most graphical applications but
   * should not be used from applications like editors that need precise
   * control over when processes invoked via the commandline will exit and
   * what their exit status will be.
   * 
   * @newin{2,28}
   * @param argc The argc from main() (or 0 if @a argv is <tt>0</tt>).
   * @param argv The argv from main(), or <tt>0</tt>.
   * @return The exit status.
   */
  int run(int argc, char** argv);

  
  /** Immediately quits the application.
   * 
   * Upon return to the mainloop, g_application_run() will return,
   * calling only the 'shutdown' function before doing so.
   * 
   * The hold count is ignored.
   * 
   * The result of calling g_application_run() again after it returns is
   * unspecified.
   * 
   * @newin{2,32}
   */
  void quit();

  
  /** Sets or unsets the default application for the process, as returned
   * by g_application_get_default().
   * 
   * This function does not take its own reference on @a application.  If
   *  @a application is destroyed then the default application will revert
   * back to <tt>0</tt>.
   * 
   * @newin{2,32}
   */
  static void set_default(const Glib::RefPtr<Application>& application);

  /// Unsets any existing default application.
  static void unset_default();

  
  /** Returns the default Application instance for this process.
   * 
   * Normally there is only one Application per process and it becomes
   * the default when it is created.  You can exercise more control over
   * this by using g_application_set_default().
   * 
   * If there is no default application then <tt>0</tt> is returned.
   * 
   * @newin{2,32}
   * @return The default application for this process, or <tt>0</tt>.
   */
  static Glib::RefPtr<Application> get_default();

  
  /** Increases the busy count of @a application.
   * 
   * Use this function to indicate that the application is busy, for instance
   * while a long running operation is pending.
   * 
   * The busy state will be exposed to other processes, so a session shell will
   * use that information to indicate the state to the user (e.g. with a
   * spinner).
   * 
   * To cancel the busy indication, use g_application_unmark_busy().
   * 
   * @newin{2,38}
   */
  void mark_busy();
  
  /** Decreases the busy count of @a application.
   * 
   * When the busy count reaches zero, the new state will be propagated
   * to other processes.
   * 
   * This function must only be called to cancel the effect of a previous
   * call to g_application_mark_busy().
   * 
   * @newin{2,38}
   */
  void unmark_busy();

  
  /** Sends a notification on behalf of @a application to the desktop shell.
   * There is no guarantee that the notification is displayed immediately,
   * or even at all.
   * 
   * Notifications may persist after the application exits. It will be
   * D-Bus-activated when the notification or one of its actions is
   * activated.
   * 
   * Modifying @a notification after this call has no effect. However, the
   * object can be reused for a later call to this function.
   * 
   *  @a id may be any string that uniquely identifies the event for the
   * application. It does not need to be in any special format. For
   * example, "new-message" might be appropriate for a notification about
   * new messages.
   * 
   * If a previous notification was sent with the same @a id, it will be
   * replaced with @a notification and shown again as if it was a new
   * notification. This works even for notifications sent from a previous
   * execution of the application, as long as @a id is the same string.
   * 
   *  @a id may be <tt>0</tt>, but it is impossible to replace or withdraw
   * notifications without an id.
   * 
   * If @a notification is no longer relevant, it can be withdrawn with
   * g_application_withdraw_notification().
   * 
   * @newin{2,40}
   * @param id Id of the notification, or <tt>0</tt>.
   * @param notification The Notification to send.
   */
  void send_notification(const Glib::ustring& id, const Glib::RefPtr<Notification>& notification);

  /// A send_notification() convenience overload.
  void send_notification(const Glib::RefPtr<Notification>& notification);
  
  /** Withdraws a notification that was sent with
   * g_application_send_notification().
   * 
   * This call does nothing if a notification with @a id doesn't exist or
   * the notification was never sent.
   * 
   * This function works even for notifications sent in previous
   * executions of this application, as long @a id is the same as it was for
   * the sent notification.
   * 
   * Note that notifications are dismissed when the user clicks on one
   * of the buttons in a notification or triggers its default action, so
   * there is no need to explicitly withdraw the notification in that case.
   * 
   * @newin{2,40}
   * @param id Id of a previously sent notification.
   */
  void withdraw_notification(const Glib::ustring& id);

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The group of actions that the application exports.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_WriteOnly that allows you to set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_WriteOnly< Glib::RefPtr<ActionGroup> > property_action_group() ;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The unique identifier for the application.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::ustring > property_application_id() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The unique identifier for the application.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::ustring > property_application_id() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Flags specifying the behaviour of the application.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< ApplicationFlags > property_flags() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Flags specifying the behaviour of the application.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< ApplicationFlags > property_flags() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Time (ms) to stay alive after becoming idle.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< guint > property_inactivity_timeout() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Time (ms) to stay alive after becoming idle.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< guint > property_inactivity_timeout() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** If g_application_register() has been called.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_is_registered() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** If this application instance is remote.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_is_remote() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


//#m4 __CONVERSION(`const gchar*', `const Glib::ustring&', `Glib::ustring($3)')
//#m4 __CONVERSION(`GVariant*', `const Glib::VariantBase&', `Glib::wrap($3, true)')

  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%startup()</tt>
   *
   * The signal_startup() signal is emitted on the primary instance immediately
   * after registration. See g_application_register().
   */

  Glib::SignalProxy0< void > signal_startup();

  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%activate()</tt>
   *
   * The signal_activate() signal is emitted on the primary instance when an
   * activation occurs. See g_application_activate().
   */

  Glib::SignalProxy0< void > signal_activate();


  //We wrap the open signal without _WRAP_SIGNAL(), because we need to change its parameters.
  //See bug https://bugzilla.gnome.org/show_bug.cgi?id=637457
  Glib::SignalProxy2< void,  const type_vec_files&, const Glib::ustring& > signal_open();
  

  /**
   * @par Slot Prototype:
   * <tt>int on_my_%command_line(const Glib::RefPtr<ApplicationCommandLine>& command_line)</tt>
   *
   * The signal_command_line() signal is emitted on the primary instance when
   * a commandline is not handled locally. See g_application_run() and
   * the ApplicationCommandLine documentation for more information.
   * @param command_line A ApplicationCommandLine representing the
   * passed commandline.
   * @return An integer that is set as the exit status for the calling
   * process. See g_application_command_line_set_exit_status().
   */

  Glib::SignalProxy1< int,const Glib::RefPtr<ApplicationCommandLine>& > signal_command_line();


protected:
  virtual void on_open(const type_vec_files& files, const Glib::ustring& hint);


    virtual bool local_command_line_vfunc(char**& arguments, int& exit_status);


    virtual void before_emit_vfunc(const Glib::VariantBase& platform_data);

    virtual void after_emit_vfunc(const Glib::VariantBase& platform_data);


  //TODO: File a bug about GVariantBuilder not being registered with the GType system first:
  //_WRAP_VFUNC(void add_platform_data(Glib::VariantBuilder* builder), "add_platform_data")

    virtual void quit_mainloop_vfunc();

    virtual void run_mainloop_vfunc();


private:
  /** This is just a way to call Glib::init() (which calls g_type_init()) before
   * calling application_class_.init(), so that
   * g_application_get_type() will always succeed.
   * See https://bugzilla.gnome.org/show_bug.cgi?id=639925
   */
  const Glib::Class& custom_class_init();


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  /// This is a default handler for the signal signal_startup().
  virtual void on_startup();
  /// This is a default handler for the signal signal_activate().
  virtual void on_activate();
  /// This is a default handler for the signal signal_command_line().
  virtual int on_command_line(const Glib::RefPtr<ApplicationCommandLine>& command_line);


};


} // namespace Gio


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gio::Application
   */
  Glib::RefPtr<Gio::Application> wrap(GApplication* object, bool take_copy = false);
}


#endif /* _GIOMM_APPLICATION_H */

