/* abstract-field-details.c generated by valac 0.22.0.42-1ce8b, the Vala compiler
 * generated from abstract-field-details.vala, do not modify */

/*
 * Copyright (C) 2011 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Marco Barisione <marco.barisione@collabora.co.uk>
 *       Travis Reitter <travis.reitter@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>


#define FOLKS_TYPE_ABSTRACT_FIELD_DETAILS (folks_abstract_field_details_get_type ())
#define FOLKS_ABSTRACT_FIELD_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_ABSTRACT_FIELD_DETAILS, FolksAbstractFieldDetails))
#define FOLKS_ABSTRACT_FIELD_DETAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_ABSTRACT_FIELD_DETAILS, FolksAbstractFieldDetailsClass))
#define FOLKS_IS_ABSTRACT_FIELD_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_ABSTRACT_FIELD_DETAILS))
#define FOLKS_IS_ABSTRACT_FIELD_DETAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_ABSTRACT_FIELD_DETAILS))
#define FOLKS_ABSTRACT_FIELD_DETAILS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_ABSTRACT_FIELD_DETAILS, FolksAbstractFieldDetailsClass))

typedef struct _FolksAbstractFieldDetails FolksAbstractFieldDetails;
typedef struct _FolksAbstractFieldDetailsClass FolksAbstractFieldDetailsClass;
typedef struct _FolksAbstractFieldDetailsPrivate FolksAbstractFieldDetailsPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _FolksAbstractFieldDetails {
	GObject parent_instance;
	FolksAbstractFieldDetailsPrivate * priv;
};

struct _FolksAbstractFieldDetailsClass {
	GObjectClass parent_class;
	gboolean (*equal) (FolksAbstractFieldDetails* self, FolksAbstractFieldDetails* that);
	gboolean (*parameters_equal) (FolksAbstractFieldDetails* self, FolksAbstractFieldDetails* that);
	gboolean (*values_equal) (FolksAbstractFieldDetails* self, FolksAbstractFieldDetails* that);
	guint (*hash) (FolksAbstractFieldDetails* self);
	gconstpointer (*get_value) (FolksAbstractFieldDetails* self);
	void (*set_value) (FolksAbstractFieldDetails* self, gconstpointer value);
	const gchar* (*get_id) (FolksAbstractFieldDetails* self);
	void (*set_id) (FolksAbstractFieldDetails* self, const gchar* value);
	GeeMultiMap* (*get_parameters) (FolksAbstractFieldDetails* self);
	void (*set_parameters) (FolksAbstractFieldDetails* self, GeeMultiMap* value);
};

struct _FolksAbstractFieldDetailsPrivate {
	GType t_type;
	GBoxedCopyFunc t_dup_func;
	GDestroyNotify t_destroy_func;
	gpointer _value;
	gchar* _id;
	GeeMultiMap* _parameters;
};


static gpointer folks_abstract_field_details_parent_class = NULL;

GType folks_abstract_field_details_get_type (void) G_GNUC_CONST;
#define FOLKS_ABSTRACT_FIELD_DETAILS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), FOLKS_TYPE_ABSTRACT_FIELD_DETAILS, FolksAbstractFieldDetailsPrivate))
enum  {
	FOLKS_ABSTRACT_FIELD_DETAILS_DUMMY_PROPERTY,
	FOLKS_ABSTRACT_FIELD_DETAILS_T_TYPE,
	FOLKS_ABSTRACT_FIELD_DETAILS_T_DUP_FUNC,
	FOLKS_ABSTRACT_FIELD_DETAILS_T_DESTROY_FUNC,
	FOLKS_ABSTRACT_FIELD_DETAILS_VALUE,
	FOLKS_ABSTRACT_FIELD_DETAILS_VALUE_TYPE,
	FOLKS_ABSTRACT_FIELD_DETAILS_ID,
	FOLKS_ABSTRACT_FIELD_DETAILS_PARAMETERS
};
#define FOLKS_ABSTRACT_FIELD_DETAILS_PARAM_TYPE "type"
#define FOLKS_ABSTRACT_FIELD_DETAILS_PARAM_TYPE_HOME "home"
#define FOLKS_ABSTRACT_FIELD_DETAILS_PARAM_TYPE_WORK "work"
#define FOLKS_ABSTRACT_FIELD_DETAILS_PARAM_TYPE_OTHER "other"
GeeCollection* folks_abstract_field_details_get_parameter_values (FolksAbstractFieldDetails* self, const gchar* parameter_name);
GeeMultiMap* folks_abstract_field_details_get_parameters (FolksAbstractFieldDetails* self);
void folks_abstract_field_details_add_parameter (FolksAbstractFieldDetails* self, const gchar* parameter_name, const gchar* parameter_value);
void folks_abstract_field_details_set_parameter (FolksAbstractFieldDetails* self, const gchar* parameter_name, const gchar* parameter_value);
void folks_abstract_field_details_extend_parameters (FolksAbstractFieldDetails* self, GeeMultiMap* additional);
void folks_abstract_field_details_remove_parameter_all (FolksAbstractFieldDetails* self, const gchar* parameter_name);
gboolean folks_abstract_field_details_equal (FolksAbstractFieldDetails* self, FolksAbstractFieldDetails* that);
static gboolean folks_abstract_field_details_real_equal (FolksAbstractFieldDetails* self, FolksAbstractFieldDetails* that);
gboolean folks_abstract_field_details_values_equal (FolksAbstractFieldDetails* self, FolksAbstractFieldDetails* that);
gboolean folks_abstract_field_details_parameters_equal (FolksAbstractFieldDetails* self, FolksAbstractFieldDetails* that);
gboolean folks_abstract_field_details_equal_static (FolksAbstractFieldDetails* left, FolksAbstractFieldDetails* right);
static gboolean folks_abstract_field_details_real_parameters_equal (FolksAbstractFieldDetails* self, FolksAbstractFieldDetails* that);
static gboolean folks_abstract_field_details_real_values_equal (FolksAbstractFieldDetails* self, FolksAbstractFieldDetails* that);
gconstpointer folks_abstract_field_details_get_value (FolksAbstractFieldDetails* self);
guint folks_abstract_field_details_hash (FolksAbstractFieldDetails* self);
static guint folks_abstract_field_details_real_hash (FolksAbstractFieldDetails* self);
guint folks_abstract_field_details_hash_static (FolksAbstractFieldDetails* value);
FolksAbstractFieldDetails* folks_abstract_field_details_construct (GType object_type, GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func);
void folks_abstract_field_details_set_value (FolksAbstractFieldDetails* self, gconstpointer value);
GType folks_abstract_field_details_get_value_type (FolksAbstractFieldDetails* self);
const gchar* folks_abstract_field_details_get_id (FolksAbstractFieldDetails* self);
void folks_abstract_field_details_set_id (FolksAbstractFieldDetails* self, const gchar* value);
void folks_abstract_field_details_set_parameters (FolksAbstractFieldDetails* self, GeeMultiMap* value);
static void folks_abstract_field_details_finalize (GObject* obj);
static void _vala_folks_abstract_field_details_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_folks_abstract_field_details_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


/**
   * Get the values for a parameter
   *
   * @param parameter_name the parameter name
   * @return a collection of values for ``parameter_name`` or ``null`` (i.e. no
   * collection) if there are no such parameters.
   *
   * @since 0.6.0
   */
GeeCollection* folks_abstract_field_details_get_parameter_values (FolksAbstractFieldDetails* self, const gchar* parameter_name) {
	GeeCollection* result = NULL;
	GeeMultiMap* _tmp0_ = NULL;
	GeeMultiMap* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	GeeMultiMap* _tmp4_ = NULL;
	GeeMultiMap* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	GeeCollection* _tmp7_ = NULL;
	GeeCollection* _tmp8_ = NULL;
	GeeCollection* _tmp9_ = NULL;
	GeeCollection* _tmp10_ = NULL;
	GeeCollection* _tmp11_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (parameter_name != NULL, NULL);
	_tmp0_ = folks_abstract_field_details_get_parameters (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = parameter_name;
	_tmp3_ = gee_multi_map_contains (_tmp1_, _tmp2_);
	if (_tmp3_ == FALSE) {
		result = NULL;
		return result;
	}
	_tmp4_ = folks_abstract_field_details_get_parameters (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = parameter_name;
	_tmp7_ = gee_multi_map_get (_tmp5_, _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = gee_collection_get_read_only_view (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = _tmp10_;
	_g_object_unref0 (_tmp8_);
	result = _tmp11_;
	return result;
}


/**
   * Add a new value for a parameter.
   *
   * If there is already a parameter called ``parameter_name`` then
   * ``parameter_value`` is added to the existing ones.
   *
   * @param parameter_name the name of the parameter
   * @param parameter_value the value to add
   *
   * @since 0.6.0
   */
void folks_abstract_field_details_add_parameter (FolksAbstractFieldDetails* self, const gchar* parameter_name, const gchar* parameter_value) {
	GeeMultiMap* _tmp0_ = NULL;
	GeeMultiMap* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (parameter_name != NULL);
	g_return_if_fail (parameter_value != NULL);
	_tmp0_ = folks_abstract_field_details_get_parameters (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = parameter_name;
	_tmp3_ = parameter_value;
	gee_multi_map_set (_tmp1_, _tmp2_, _tmp3_);
}


/**
   * Set the value of a parameter.
   *
   * Sets the parameter called ``parameter_name`` to be ``parameter_value``.
   * If there were already parameters with the same name they are replaced.
   *
   * @param parameter_name the name of the parameter
   * @param parameter_value the value to add
   *
   * @since 0.6.0
   */
void folks_abstract_field_details_set_parameter (FolksAbstractFieldDetails* self, const gchar* parameter_name, const gchar* parameter_value) {
	GeeMultiMap* _tmp0_ = NULL;
	GeeMultiMap* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GeeMultiMap* _tmp3_ = NULL;
	GeeMultiMap* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (parameter_name != NULL);
	g_return_if_fail (parameter_value != NULL);
	_tmp0_ = folks_abstract_field_details_get_parameters (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = parameter_name;
	gee_multi_map_remove_all (_tmp1_, _tmp2_);
	_tmp3_ = folks_abstract_field_details_get_parameters (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = parameter_name;
	_tmp6_ = parameter_value;
	gee_multi_map_set (_tmp4_, _tmp5_, _tmp6_);
}


/**
   * Extend the existing parameters.
   *
   * Merge the parameters from ``additional`` into the existing ones.
   *
   * @param additional the parameters to add
   *
   * @since 0.6.0
   */
void folks_abstract_field_details_extend_parameters (FolksAbstractFieldDetails* self, GeeMultiMap* additional) {
	GeeMapIterator* iter = NULL;
	GeeMultiMap* _tmp0_ = NULL;
	GeeMapIterator* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (additional != NULL);
	_tmp0_ = additional;
	_tmp1_ = gee_multi_map_map_iterator (_tmp0_);
	iter = _tmp1_;
	while (TRUE) {
		GeeMapIterator* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		GeeMapIterator* _tmp4_ = NULL;
		gpointer _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		GeeMapIterator* _tmp7_ = NULL;
		gpointer _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		_tmp2_ = iter;
		_tmp3_ = gee_map_iterator_next (_tmp2_);
		if (!_tmp3_) {
			break;
		}
		_tmp4_ = iter;
		_tmp5_ = gee_map_iterator_get_key (_tmp4_);
		_tmp6_ = (gchar*) _tmp5_;
		_tmp7_ = iter;
		_tmp8_ = gee_map_iterator_get_value (_tmp7_);
		_tmp9_ = (gchar*) _tmp8_;
		folks_abstract_field_details_add_parameter (self, _tmp6_, _tmp9_);
		_g_free0 (_tmp9_);
		_g_free0 (_tmp6_);
	}
	_g_object_unref0 (iter);
}


/**
   * Remove all instances of a parameter.
   *
   * @param parameter_name the name of the parameter
   *
   * @since 0.6.0
   */
void folks_abstract_field_details_remove_parameter_all (FolksAbstractFieldDetails* self, const gchar* parameter_name) {
	GeeMultiMap* _tmp0_ = NULL;
	GeeMultiMap* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (parameter_name != NULL);
	_tmp0_ = folks_abstract_field_details_get_parameters (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = parameter_name;
	gee_multi_map_remove_all (_tmp1_, _tmp2_);
}


/**
   * A fairly-strict equality function for {@link AbstractFieldDetails}.
   *
   * This function compares:
   *
   *  * {@link AbstractFieldDetails.value}s
   *  * {@link AbstractFieldDetails.parameters}
   *
   * And does not compare:
   *
   *  * {@link AbstractFieldDetails.id}s
   *
   * See the description of {@link AbstractFieldDetails.values_equal} for
   * details on the value comparison.
   *
   * To check equality not including the parameters, see
   * {@link AbstractFieldDetails.values_equal}.
   *
   * @param that another {@link AbstractFieldDetails}
   *
   * @return whether the elements are equal
   *
   * @see AbstractFieldDetails.parameters_equal
   * @see AbstractFieldDetails.values_equal
   * @since 0.6.0
   */
static gboolean folks_abstract_field_details_real_equal (FolksAbstractFieldDetails* self, FolksAbstractFieldDetails* that) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GType _tmp2_ = 0UL;
	FolksAbstractFieldDetails* _tmp3_ = NULL;
	GType _tmp4_ = 0UL;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp10_ = FALSE;
	g_return_val_if_fail (that != NULL, FALSE);
	_tmp2_ = G_TYPE_FROM_INSTANCE ((GObject*) self);
	_tmp3_ = that;
	_tmp4_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp3_);
	if (_tmp2_ == _tmp4_) {
		FolksAbstractFieldDetails* _tmp5_ = NULL;
		gboolean _tmp6_ = FALSE;
		_tmp5_ = that;
		_tmp6_ = folks_abstract_field_details_values_equal (self, _tmp5_);
		_tmp1_ = _tmp6_;
	} else {
		_tmp1_ = FALSE;
	}
	_tmp7_ = _tmp1_;
	if (_tmp7_) {
		FolksAbstractFieldDetails* _tmp8_ = NULL;
		gboolean _tmp9_ = FALSE;
		_tmp8_ = that;
		_tmp9_ = folks_abstract_field_details_parameters_equal (self, _tmp8_);
		_tmp0_ = _tmp9_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp10_ = _tmp0_;
	result = _tmp10_;
	return result;
}


gboolean folks_abstract_field_details_equal (FolksAbstractFieldDetails* self, FolksAbstractFieldDetails* that) {
	g_return_val_if_fail (self != NULL, FALSE);
	return FOLKS_ABSTRACT_FIELD_DETAILS_GET_CLASS (self)->equal (self, that);
}


/**
   * Same as {@link AbstractFieldDetails.equal}, but static, so we can use
   * libgee 0.8 without an API break.
   *
   * See [[https://bugzilla.gnome.org/show_bug.cgi?id=673918|673918]]
   * This can and should be removed next time we break the API.
   * Note: This uses Gee.EqualDataFunc signature, to avoid having to cast.
   *
   * @param left one {@link AbstractFieldDetails} to compare
   * @param right another {@link AbstractFieldDetails} to compare
   *
   * @return whether the elemants are equal
   *
   * @since 0.9.0
   */
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


gboolean folks_abstract_field_details_equal_static (FolksAbstractFieldDetails* left, FolksAbstractFieldDetails* right) {
	gboolean result = FALSE;
	FolksAbstractFieldDetails* _tmp0_ = NULL;
	FolksAbstractFieldDetails* _tmp1_ = NULL;
	FolksAbstractFieldDetails* left_details = NULL;
	FolksAbstractFieldDetails* _tmp2_ = NULL;
	FolksAbstractFieldDetails* _tmp3_ = NULL;
	FolksAbstractFieldDetails* right_details = NULL;
	FolksAbstractFieldDetails* _tmp4_ = NULL;
	FolksAbstractFieldDetails* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	g_return_val_if_fail (left != NULL, FALSE);
	g_return_val_if_fail (right != NULL, FALSE);
	_tmp0_ = left;
	g_return_val_if_fail (_tmp0_ != NULL, FALSE);
	_tmp1_ = right;
	g_return_val_if_fail (_tmp1_ != NULL, FALSE);
	_tmp2_ = left;
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, FOLKS_TYPE_ABSTRACT_FIELD_DETAILS, FolksAbstractFieldDetails));
	left_details = _tmp3_;
	_tmp4_ = right;
	_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, FOLKS_TYPE_ABSTRACT_FIELD_DETAILS, FolksAbstractFieldDetails));
	right_details = _tmp5_;
	_tmp6_ = folks_abstract_field_details_equal (left_details, right_details);
	result = _tmp6_;
	_g_object_unref0 (right_details);
	_g_object_unref0 (left_details);
	return result;
}


/**
   * An equality function which only considers parameters.
   *
   * This function compares:
   *
   *  * {@link AbstractFieldDetails.parameters}
   *
   * And does not compare:
   *
   *  * {@link AbstractFieldDetails.value}s
   *  * {@link AbstractFieldDetails.id}s
   *
   * @param that another {@link AbstractFieldDetails}
   *
   * @return whether the elements' {@link AbstractFieldDetails.value}s are
   * equal.
   *
   * @see AbstractFieldDetails.equal
   * @see AbstractFieldDetails.values_equal
   * @since 0.6.5
   */
static gboolean folks_abstract_field_details_real_parameters_equal (FolksAbstractFieldDetails* self, FolksAbstractFieldDetails* that) {
	gboolean result = FALSE;
	GeeMultiMap* _tmp0_ = NULL;
	GeeMultiMap* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	FolksAbstractFieldDetails* _tmp4_ = NULL;
	GeeMultiMap* _tmp5_ = NULL;
	GeeMultiMap* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	g_return_val_if_fail (that != NULL, FALSE);
	_tmp0_ = folks_abstract_field_details_get_parameters (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gee_multi_map_get_size (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = that;
	_tmp5_ = folks_abstract_field_details_get_parameters (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = gee_multi_map_get_size (_tmp6_);
	_tmp8_ = _tmp7_;
	if (_tmp3_ != _tmp8_) {
		result = FALSE;
		return result;
	}
	{
		GeeIterator* _param_it = NULL;
		GeeMultiMap* _tmp9_ = NULL;
		GeeMultiMap* _tmp10_ = NULL;
		GeeSet* _tmp11_ = NULL;
		GeeSet* _tmp12_ = NULL;
		GeeIterator* _tmp13_ = NULL;
		GeeIterator* _tmp14_ = NULL;
		_tmp9_ = folks_abstract_field_details_get_parameters (self);
		_tmp10_ = _tmp9_;
		_tmp11_ = gee_multi_map_get_keys (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = gee_iterable_iterator ((GeeIterable*) _tmp12_);
		_tmp14_ = _tmp13_;
		_g_object_unref0 (_tmp12_);
		_param_it = _tmp14_;
		while (TRUE) {
			GeeIterator* _tmp15_ = NULL;
			gboolean _tmp16_ = FALSE;
			gchar* param = NULL;
			GeeIterator* _tmp17_ = NULL;
			gpointer _tmp18_ = NULL;
			FolksAbstractFieldDetails* _tmp19_ = NULL;
			GeeMultiMap* _tmp20_ = NULL;
			GeeMultiMap* _tmp21_ = NULL;
			const gchar* _tmp22_ = NULL;
			gboolean _tmp23_ = FALSE;
			GeeCollection* this_param_values = NULL;
			GeeMultiMap* _tmp24_ = NULL;
			GeeMultiMap* _tmp25_ = NULL;
			GeeCollection* _tmp26_ = NULL;
			GeeCollection* that_param_values = NULL;
			FolksAbstractFieldDetails* _tmp27_ = NULL;
			GeeMultiMap* _tmp28_ = NULL;
			GeeMultiMap* _tmp29_ = NULL;
			GeeCollection* _tmp30_ = NULL;
			GeeCollection* _tmp31_ = NULL;
			gint _tmp32_ = 0;
			gint _tmp33_ = 0;
			GeeCollection* _tmp34_ = NULL;
			gint _tmp35_ = 0;
			gint _tmp36_ = 0;
			_tmp15_ = _param_it;
			_tmp16_ = gee_iterator_next (_tmp15_);
			if (!_tmp16_) {
				break;
			}
			_tmp17_ = _param_it;
			_tmp18_ = gee_iterator_get (_tmp17_);
			param = (gchar*) _tmp18_;
			_tmp19_ = that;
			_tmp20_ = folks_abstract_field_details_get_parameters (_tmp19_);
			_tmp21_ = _tmp20_;
			_tmp22_ = param;
			_tmp23_ = gee_multi_map_contains (_tmp21_, _tmp22_);
			if (!_tmp23_) {
				result = FALSE;
				_g_free0 (param);
				_g_object_unref0 (_param_it);
				return result;
			}
			_tmp24_ = folks_abstract_field_details_get_parameters (self);
			_tmp25_ = _tmp24_;
			_tmp26_ = gee_multi_map_get_values (_tmp25_);
			this_param_values = _tmp26_;
			_tmp27_ = that;
			_tmp28_ = folks_abstract_field_details_get_parameters (_tmp27_);
			_tmp29_ = _tmp28_;
			_tmp30_ = gee_multi_map_get_values (_tmp29_);
			that_param_values = _tmp30_;
			_tmp31_ = this_param_values;
			_tmp32_ = gee_collection_get_size (_tmp31_);
			_tmp33_ = _tmp32_;
			_tmp34_ = that_param_values;
			_tmp35_ = gee_collection_get_size (_tmp34_);
			_tmp36_ = _tmp35_;
			if (_tmp33_ != _tmp36_) {
				result = FALSE;
				_g_object_unref0 (that_param_values);
				_g_object_unref0 (this_param_values);
				_g_free0 (param);
				_g_object_unref0 (_param_it);
				return result;
			}
			{
				GeeIterator* _param_val_it = NULL;
				GeeMultiMap* _tmp37_ = NULL;
				GeeMultiMap* _tmp38_ = NULL;
				GeeCollection* _tmp39_ = NULL;
				GeeCollection* _tmp40_ = NULL;
				GeeIterator* _tmp41_ = NULL;
				GeeIterator* _tmp42_ = NULL;
				_tmp37_ = folks_abstract_field_details_get_parameters (self);
				_tmp38_ = _tmp37_;
				_tmp39_ = gee_multi_map_get_values (_tmp38_);
				_tmp40_ = _tmp39_;
				_tmp41_ = gee_iterable_iterator ((GeeIterable*) _tmp40_);
				_tmp42_ = _tmp41_;
				_g_object_unref0 (_tmp40_);
				_param_val_it = _tmp42_;
				while (TRUE) {
					GeeIterator* _tmp43_ = NULL;
					gboolean _tmp44_ = FALSE;
					gchar* param_val = NULL;
					GeeIterator* _tmp45_ = NULL;
					gpointer _tmp46_ = NULL;
					GeeCollection* _tmp47_ = NULL;
					const gchar* _tmp48_ = NULL;
					gboolean _tmp49_ = FALSE;
					_tmp43_ = _param_val_it;
					_tmp44_ = gee_iterator_next (_tmp43_);
					if (!_tmp44_) {
						break;
					}
					_tmp45_ = _param_val_it;
					_tmp46_ = gee_iterator_get (_tmp45_);
					param_val = (gchar*) _tmp46_;
					_tmp47_ = that_param_values;
					_tmp48_ = param_val;
					_tmp49_ = gee_collection_contains (_tmp47_, _tmp48_);
					if (!_tmp49_) {
						result = FALSE;
						_g_free0 (param_val);
						_g_object_unref0 (_param_val_it);
						_g_object_unref0 (that_param_values);
						_g_object_unref0 (this_param_values);
						_g_free0 (param);
						_g_object_unref0 (_param_it);
						return result;
					}
					_g_free0 (param_val);
				}
				_g_object_unref0 (_param_val_it);
			}
			_g_object_unref0 (that_param_values);
			_g_object_unref0 (this_param_values);
			_g_free0 (param);
		}
		_g_object_unref0 (_param_it);
	}
	result = TRUE;
	return result;
}


gboolean folks_abstract_field_details_parameters_equal (FolksAbstractFieldDetails* self, FolksAbstractFieldDetails* that) {
	g_return_val_if_fail (self != NULL, FALSE);
	return FOLKS_ABSTRACT_FIELD_DETAILS_GET_CLASS (self)->parameters_equal (self, that);
}


/**
   * An equality function which does not consider parameters.
   *
   * Specific classes may override this function to provide "smart" value
   * comparisons (eg, considering the phone number values "+1 555 123 4567" and
   * "123-4567" equal). If you wish to do strict comparisons, simply compare the
   * {@link AbstractFieldDetails.value}s directly.
   *
   * This function compares:
   *
   *  * {@link AbstractFieldDetails.value}s
   *
   * And does not compare:
   *
   *  * {@link AbstractFieldDetails.parameters}
   *  * {@link AbstractFieldDetails.id}s
   *
   * This defaults to string comparison of the
   * {@link AbstractFieldDetails.value}s if the generic type is string;
   * otherwise, direct pointer comparison of the
   * {@link AbstractFieldDetails.value}s.
   *
   * @param that another {@link AbstractFieldDetails}
   *
   * @return whether the elements' {@link AbstractFieldDetails.value}s are
   * equal.
   *
   * @see AbstractFieldDetails.equal
   * @see AbstractFieldDetails.parameters_equal
   * @since 0.6.5
   */
static gboolean folks_abstract_field_details_real_values_equal (FolksAbstractFieldDetails* self, FolksAbstractFieldDetails* that) {
	gboolean result = FALSE;
	GEqualFunc equal_func = NULL;
	GEqualFunc _tmp0_ = NULL;
	gboolean _tmp2_ = FALSE;
	GType _tmp3_ = 0UL;
	FolksAbstractFieldDetails* _tmp4_ = NULL;
	GType _tmp5_ = 0UL;
	gboolean _tmp13_ = FALSE;
	g_return_val_if_fail (that != NULL, FALSE);
	_tmp0_ = g_direct_equal;
	equal_func = _tmp0_;
	if (self->priv->t_type == G_TYPE_STRING) {
		GEqualFunc _tmp1_ = NULL;
		_tmp1_ = g_str_equal;
		equal_func = _tmp1_;
	}
	_tmp3_ = G_TYPE_FROM_INSTANCE ((GObject*) self);
	_tmp4_ = that;
	_tmp5_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp4_);
	if (_tmp3_ != _tmp5_) {
		_tmp2_ = TRUE;
	} else {
		GEqualFunc _tmp6_ = NULL;
		gconstpointer _tmp7_ = NULL;
		gconstpointer _tmp8_ = NULL;
		FolksAbstractFieldDetails* _tmp9_ = NULL;
		gconstpointer _tmp10_ = NULL;
		gconstpointer _tmp11_ = NULL;
		gboolean _tmp12_ = FALSE;
		_tmp6_ = equal_func;
		_tmp7_ = folks_abstract_field_details_get_value (self);
		_tmp8_ = _tmp7_;
		_tmp9_ = that;
		_tmp10_ = folks_abstract_field_details_get_value (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = _tmp6_ (_tmp8_, _tmp11_);
		_tmp2_ = !_tmp12_;
	}
	_tmp13_ = _tmp2_;
	if (_tmp13_) {
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}


gboolean folks_abstract_field_details_values_equal (FolksAbstractFieldDetails* self, FolksAbstractFieldDetails* that) {
	g_return_val_if_fail (self != NULL, FALSE);
	return FOLKS_ABSTRACT_FIELD_DETAILS_GET_CLASS (self)->values_equal (self, that);
}


/**
   * A hash function for the {@link AbstractFieldDetails}.
   *
   * This defaults to a string hash of the
   * {@link AbstractFieldDetails.value} if the generic type is string;
   * otherwise, direct hash of the {@link AbstractFieldDetails.value}.
   *
   * @return the hash value
   *
   * @since 0.6.0
   */
static guint folks_abstract_field_details_real_hash (FolksAbstractFieldDetails* self) {
	guint result = 0U;
	GHashFunc hash_func = NULL;
	GHashFunc _tmp0_ = NULL;
	GHashFunc _tmp2_ = NULL;
	gconstpointer _tmp3_ = NULL;
	gconstpointer _tmp4_ = NULL;
	guint _tmp5_ = 0U;
	_tmp0_ = g_direct_hash;
	hash_func = _tmp0_;
	if (self->priv->t_type == G_TYPE_STRING) {
		GHashFunc _tmp1_ = NULL;
		_tmp1_ = g_str_hash;
		hash_func = _tmp1_;
	}
	_tmp2_ = hash_func;
	_tmp3_ = folks_abstract_field_details_get_value (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp2_ (_tmp4_);
	result = _tmp5_;
	return result;
}


guint folks_abstract_field_details_hash (FolksAbstractFieldDetails* self) {
	g_return_val_if_fail (self != NULL, 0U);
	return FOLKS_ABSTRACT_FIELD_DETAILS_GET_CLASS (self)->hash (self);
}


/**
   * Same as {@link AbstractFieldDetails.hash}, but static, so we can use libgee
   * 0.8 without an API break.
   *
   * See [[https://bugzilla.gnome.org/show_bug.cgi?id=673918|673918]]
   * This can and should be removed next time we break the API.
   * Note: This uses Gee.HashDataFunc signature, to avoid having to cast.
   *
   * @param value the value to hash
   *
   * @return the hash value
   *
   * @since 0.9.0
   */
guint folks_abstract_field_details_hash_static (FolksAbstractFieldDetails* value) {
	guint result = 0U;
	FolksAbstractFieldDetails* _tmp0_ = NULL;
	FolksAbstractFieldDetails* details = NULL;
	FolksAbstractFieldDetails* _tmp1_ = NULL;
	FolksAbstractFieldDetails* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	g_return_val_if_fail (value != NULL, 0U);
	_tmp0_ = value;
	g_return_val_if_fail (_tmp0_ != NULL, 0);
	_tmp1_ = value;
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, FOLKS_TYPE_ABSTRACT_FIELD_DETAILS, FolksAbstractFieldDetails));
	details = _tmp2_;
	_tmp3_ = folks_abstract_field_details_hash (details);
	result = _tmp3_;
	_g_object_unref0 (details);
	return result;
}


FolksAbstractFieldDetails* folks_abstract_field_details_construct (GType object_type, GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func) {
	FolksAbstractFieldDetails * self = NULL;
	self = (FolksAbstractFieldDetails*) g_object_new (object_type, NULL);
	self->priv->t_type = t_type;
	self->priv->t_dup_func = t_dup_func;
	self->priv->t_destroy_func = t_destroy_func;
	return self;
}


gconstpointer folks_abstract_field_details_get_value (FolksAbstractFieldDetails* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return FOLKS_ABSTRACT_FIELD_DETAILS_GET_CLASS (self)->get_value (self);
}


static gconstpointer folks_abstract_field_details_real_get_value (FolksAbstractFieldDetails* base) {
	gconstpointer result;
	FolksAbstractFieldDetails* self;
	gconstpointer _tmp0_ = NULL;
	self = base;
	_tmp0_ = self->priv->_value;
	result = _tmp0_;
	return result;
}


void folks_abstract_field_details_set_value (FolksAbstractFieldDetails* self, gconstpointer value) {
	g_return_if_fail (self != NULL);
	FOLKS_ABSTRACT_FIELD_DETAILS_GET_CLASS (self)->set_value (self, value);
}


static void folks_abstract_field_details_real_set_value (FolksAbstractFieldDetails* base, gconstpointer value) {
	FolksAbstractFieldDetails* self;
	gconstpointer _tmp0_ = NULL;
	gpointer _tmp1_ = NULL;
	self = base;
	_tmp0_ = value;
	_tmp1_ = ((_tmp0_ != NULL) && (self->priv->t_dup_func != NULL)) ? self->priv->t_dup_func ((gpointer) _tmp0_) : ((gpointer) _tmp0_);
	((self->priv->_value == NULL) || (self->priv->t_destroy_func == NULL)) ? NULL : (self->priv->_value = (self->priv->t_destroy_func (self->priv->_value), NULL));
	self->priv->_value = _tmp1_;
	g_object_notify ((GObject *) self, "value");
}


GType folks_abstract_field_details_get_value_type (FolksAbstractFieldDetails* self) {
	GType result;
	g_return_val_if_fail (self != NULL, 0UL);
	result = self->priv->t_type;
	return result;
}


const gchar* folks_abstract_field_details_get_id (FolksAbstractFieldDetails* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return FOLKS_ABSTRACT_FIELD_DETAILS_GET_CLASS (self)->get_id (self);
}


static const gchar* folks_abstract_field_details_real_get_id (FolksAbstractFieldDetails* base) {
	const gchar* result;
	FolksAbstractFieldDetails* self;
	const gchar* _tmp0_ = NULL;
	self = base;
	_tmp0_ = self->priv->_id;
	result = _tmp0_;
	return result;
}


void folks_abstract_field_details_set_id (FolksAbstractFieldDetails* self, const gchar* value) {
	g_return_if_fail (self != NULL);
	FOLKS_ABSTRACT_FIELD_DETAILS_GET_CLASS (self)->set_id (self, value);
}


static void folks_abstract_field_details_real_set_id (FolksAbstractFieldDetails* base, const gchar* value) {
	FolksAbstractFieldDetails* self;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	self = base;
	_tmp1_ = value;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_ = NULL;
		_tmp2_ = value;
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = "";
	}
	_tmp3_ = _tmp0_;
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 (self->priv->_id);
	self->priv->_id = _tmp4_;
	g_object_notify ((GObject *) self, "id");
}


GeeMultiMap* folks_abstract_field_details_get_parameters (FolksAbstractFieldDetails* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return FOLKS_ABSTRACT_FIELD_DETAILS_GET_CLASS (self)->get_parameters (self);
}


static GeeMultiMap* folks_abstract_field_details_real_get_parameters (FolksAbstractFieldDetails* base) {
	GeeMultiMap* result;
	FolksAbstractFieldDetails* self;
	GeeMultiMap* _tmp0_ = NULL;
	self = base;
	_tmp0_ = self->priv->_parameters;
	result = _tmp0_;
	return result;
}


void folks_abstract_field_details_set_parameters (FolksAbstractFieldDetails* self, GeeMultiMap* value) {
	g_return_if_fail (self != NULL);
	FOLKS_ABSTRACT_FIELD_DETAILS_GET_CLASS (self)->set_parameters (self, value);
}


static void folks_abstract_field_details_real_set_parameters (FolksAbstractFieldDetails* base, GeeMultiMap* value) {
	FolksAbstractFieldDetails* self;
	GeeMultiMap* _tmp0_ = NULL;
	self = base;
	_tmp0_ = value;
	if (_tmp0_ == NULL) {
		GeeMultiMap* _tmp1_ = NULL;
		_tmp1_ = self->priv->_parameters;
		gee_multi_map_clear (_tmp1_);
	} else {
		GeeMultiMap* _tmp2_ = NULL;
		GeeMultiMap* _tmp3_ = NULL;
		_tmp2_ = value;
		_tmp3_ = _g_object_ref0 (_tmp2_);
		_g_object_unref0 (self->priv->_parameters);
		self->priv->_parameters = _tmp3_;
	}
	g_object_notify ((GObject *) self, "parameters");
}


static void folks_abstract_field_details_class_init (FolksAbstractFieldDetailsClass * klass) {
	folks_abstract_field_details_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (FolksAbstractFieldDetailsPrivate));
	FOLKS_ABSTRACT_FIELD_DETAILS_CLASS (klass)->equal = folks_abstract_field_details_real_equal;
	FOLKS_ABSTRACT_FIELD_DETAILS_CLASS (klass)->parameters_equal = folks_abstract_field_details_real_parameters_equal;
	FOLKS_ABSTRACT_FIELD_DETAILS_CLASS (klass)->values_equal = folks_abstract_field_details_real_values_equal;
	FOLKS_ABSTRACT_FIELD_DETAILS_CLASS (klass)->hash = folks_abstract_field_details_real_hash;
	FOLKS_ABSTRACT_FIELD_DETAILS_CLASS (klass)->get_value = folks_abstract_field_details_real_get_value;
	FOLKS_ABSTRACT_FIELD_DETAILS_CLASS (klass)->set_value = folks_abstract_field_details_real_set_value;
	FOLKS_ABSTRACT_FIELD_DETAILS_CLASS (klass)->get_id = folks_abstract_field_details_real_get_id;
	FOLKS_ABSTRACT_FIELD_DETAILS_CLASS (klass)->set_id = folks_abstract_field_details_real_set_id;
	FOLKS_ABSTRACT_FIELD_DETAILS_CLASS (klass)->get_parameters = folks_abstract_field_details_real_get_parameters;
	FOLKS_ABSTRACT_FIELD_DETAILS_CLASS (klass)->set_parameters = folks_abstract_field_details_real_set_parameters;
	G_OBJECT_CLASS (klass)->get_property = _vala_folks_abstract_field_details_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_folks_abstract_field_details_set_property;
	G_OBJECT_CLASS (klass)->finalize = folks_abstract_field_details_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_ABSTRACT_FIELD_DETAILS_T_TYPE, g_param_spec_gtype ("t-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_ABSTRACT_FIELD_DETAILS_T_DUP_FUNC, g_param_spec_pointer ("t-dup-func", "dup func", "dup func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_ABSTRACT_FIELD_DETAILS_T_DESTROY_FUNC, g_param_spec_pointer ("t-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	   * The value of the field.
	   *
	   * The value of the field, the exact type and content of which depends on what
	   * the structure is used for.
	   *
	   * @since 0.6.0
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_ABSTRACT_FIELD_DETAILS_VALUE, g_param_spec_pointer ("value", "value", "value", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	/**
	   * The {@link GLib.Type} of the {@link AbstractFieldDetails.value}.
	   *
	   * This is particularly useful for treating collections of different types of
	   * {@link AbstractFieldDetails} in a uniform way without needing to name them
	   * explicitly.
	   *
	   * @since 0.6.5
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_ABSTRACT_FIELD_DETAILS_VALUE_TYPE, g_param_spec_gtype ("value-type", "value-type", "value-type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * A unique ID (if any) for this specific detail.
	   *
	   * This is primarily intended for {@link PersonaStore}s which need to track
	   * specific instances of details (because their backing store is wacky).
	   *
	   * In most cases, this will be an empty string.
	   *
	   * The content of this is opaque to all but the package which set it.
	   *
	   * @since 0.6.5
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_ABSTRACT_FIELD_DETAILS_ID, g_param_spec_string ("id", "id", "id", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * The parameters associated with the value.
	   *
	   * A multi-map of the parameters associated with
	   * {@link Folks.AbstractFieldDetails.value}. The keys are the names of
	   * the parameters, while the values are a list of strings.
	   *
	   * @since 0.6.0
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_ABSTRACT_FIELD_DETAILS_PARAMETERS, g_param_spec_object ("parameters", "parameters", "parameters", GEE_TYPE_MULTI_MAP, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}


static void folks_abstract_field_details_instance_init (FolksAbstractFieldDetails * self) {
	GeeHashMultiMap* _tmp0_ = NULL;
	self->priv = FOLKS_ABSTRACT_FIELD_DETAILS_GET_PRIVATE (self);
	_tmp0_ = gee_hash_multi_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->_parameters = (GeeMultiMap*) _tmp0_;
}


static void folks_abstract_field_details_finalize (GObject* obj) {
	FolksAbstractFieldDetails * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FOLKS_TYPE_ABSTRACT_FIELD_DETAILS, FolksAbstractFieldDetails);
	((self->priv->_value == NULL) || (self->priv->t_destroy_func == NULL)) ? NULL : (self->priv->_value = (self->priv->t_destroy_func (self->priv->_value), NULL));
	_g_free0 (self->priv->_id);
	_g_object_unref0 (self->priv->_parameters);
	G_OBJECT_CLASS (folks_abstract_field_details_parent_class)->finalize (obj);
}


/**
 * Object representing any type of value that can have some vCard-like
 * parameters associated with it.
 *
 * Some contact details, like phone numbers or URLs, can have some
 * extra details associated with them.
 * For instance, a phone number expressed in vcard notation as
 * ``tel;type=work,voice:(111) 555-1234`` would be represented as
 * a AbstractFieldDetails with value "(111) 555-1234" and with parameters
 * ``['type': ('work', 'voice')]``.
 *
 * The parameter name "type" with values "work", "home", or "other" are common
 * amongst most vCard attributes (and thus most AbstractFieldDetails-derived
 * classes). A "type" of "pref" may be used to indicate a preferred
 * {@link AbstractFieldDetails.value} amongst many. See specific classes for
 * information on additional parameters and values specific to that class.
 *
 * See [[http://www.ietf.org/rfc/rfc2426.txt|RFC2426]] for more details on
 * pre-defined parameter names and values.
 *
 * @since 0.6.0
 */
GType folks_abstract_field_details_get_type (void) {
	static volatile gsize folks_abstract_field_details_type_id__volatile = 0;
	if (g_once_init_enter (&folks_abstract_field_details_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksAbstractFieldDetailsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_abstract_field_details_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksAbstractFieldDetails), 0, (GInstanceInitFunc) folks_abstract_field_details_instance_init, NULL };
		GType folks_abstract_field_details_type_id;
		folks_abstract_field_details_type_id = g_type_register_static (G_TYPE_OBJECT, "FolksAbstractFieldDetails", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&folks_abstract_field_details_type_id__volatile, folks_abstract_field_details_type_id);
	}
	return folks_abstract_field_details_type_id__volatile;
}


static void _vala_folks_abstract_field_details_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	FolksAbstractFieldDetails * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FOLKS_TYPE_ABSTRACT_FIELD_DETAILS, FolksAbstractFieldDetails);
	switch (property_id) {
		case FOLKS_ABSTRACT_FIELD_DETAILS_VALUE:
		g_value_set_pointer (value, folks_abstract_field_details_get_value (self));
		break;
		case FOLKS_ABSTRACT_FIELD_DETAILS_VALUE_TYPE:
		g_value_set_gtype (value, folks_abstract_field_details_get_value_type (self));
		break;
		case FOLKS_ABSTRACT_FIELD_DETAILS_ID:
		g_value_set_string (value, folks_abstract_field_details_get_id (self));
		break;
		case FOLKS_ABSTRACT_FIELD_DETAILS_PARAMETERS:
		g_value_set_object (value, folks_abstract_field_details_get_parameters (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_folks_abstract_field_details_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	FolksAbstractFieldDetails * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FOLKS_TYPE_ABSTRACT_FIELD_DETAILS, FolksAbstractFieldDetails);
	switch (property_id) {
		case FOLKS_ABSTRACT_FIELD_DETAILS_VALUE:
		folks_abstract_field_details_set_value (self, g_value_get_pointer (value));
		break;
		case FOLKS_ABSTRACT_FIELD_DETAILS_ID:
		folks_abstract_field_details_set_id (self, g_value_get_string (value));
		break;
		case FOLKS_ABSTRACT_FIELD_DETAILS_PARAMETERS:
		folks_abstract_field_details_set_parameters (self, g_value_get_object (value));
		break;
		case FOLKS_ABSTRACT_FIELD_DETAILS_T_TYPE:
		self->priv->t_type = g_value_get_gtype (value);
		break;
		case FOLKS_ABSTRACT_FIELD_DETAILS_T_DUP_FUNC:
		self->priv->t_dup_func = g_value_get_pointer (value);
		break;
		case FOLKS_ABSTRACT_FIELD_DETAILS_T_DESTROY_FUNC:
		self->priv->t_destroy_func = g_value_get_pointer (value);
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



