/* contacts-avatar-dialog.c generated by valac 0.22.0, the Vala compiler
 * generated from contacts-avatar-dialog.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: t; c-basic-offset: 2; tab-width: 8 -*- */
/*
 * Copyright (C) 2011 Alexander Larsson <alexl@redhat.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <libgnome-desktop/gnome-desktop-thumbnail.h>
#include <um-crop-area.h>
#include <cheese-flash.h>
#include <cheese/cheese-camera-device-monitor.h>
#include <cheese/cheese-widget.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <math.h>
#include <folks/folks.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <glib/gi18n-lib.h>
#include <pango/pango.h>
#include <cheese/cheese-camera-device.h>
#include <cheese/cheese-camera.h>


#define CONTACTS_TYPE_AVATAR_DIALOG (contacts_avatar_dialog_get_type ())
#define CONTACTS_AVATAR_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_AVATAR_DIALOG, ContactsAvatarDialog))
#define CONTACTS_AVATAR_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_AVATAR_DIALOG, ContactsAvatarDialogClass))
#define CONTACTS_IS_AVATAR_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_AVATAR_DIALOG))
#define CONTACTS_IS_AVATAR_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_AVATAR_DIALOG))
#define CONTACTS_AVATAR_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_AVATAR_DIALOG, ContactsAvatarDialogClass))

typedef struct _ContactsAvatarDialog ContactsAvatarDialog;
typedef struct _ContactsAvatarDialogClass ContactsAvatarDialogClass;
typedef struct _ContactsAvatarDialogPrivate ContactsAvatarDialogPrivate;

#define CONTACTS_TYPE_CONTACT (contacts_contact_get_type ())
#define CONTACTS_CONTACT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_CONTACT, ContactsContact))
#define CONTACTS_CONTACT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_CONTACT, ContactsContactClass))
#define CONTACTS_IS_CONTACT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_CONTACT))
#define CONTACTS_IS_CONTACT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_CONTACT))
#define CONTACTS_CONTACT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_CONTACT, ContactsContactClass))

typedef struct _ContactsContact ContactsContact;
typedef struct _ContactsContactClass ContactsContactClass;

#define CONTACTS_TYPE_CONTACT_FRAME (contacts_contact_frame_get_type ())
#define CONTACTS_CONTACT_FRAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_CONTACT_FRAME, ContactsContactFrame))
#define CONTACTS_CONTACT_FRAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_CONTACT_FRAME, ContactsContactFrameClass))
#define CONTACTS_IS_CONTACT_FRAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_CONTACT_FRAME))
#define CONTACTS_IS_CONTACT_FRAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_CONTACT_FRAME))
#define CONTACTS_CONTACT_FRAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_CONTACT_FRAME, ContactsContactFrameClass))

typedef struct _ContactsContactFrame ContactsContactFrame;
typedef struct _ContactsContactFrameClass ContactsContactFrameClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block40Data Block40Data;
typedef struct _ContactsContactPrivate ContactsContactPrivate;

#define CONTACTS_TYPE_STORE (contacts_store_get_type ())
#define CONTACTS_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_STORE, ContactsStore))
#define CONTACTS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_STORE, ContactsStoreClass))
#define CONTACTS_IS_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_STORE))
#define CONTACTS_IS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_STORE))
#define CONTACTS_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_STORE, ContactsStoreClass))

typedef struct _ContactsStore ContactsStore;
typedef struct _ContactsStoreClass ContactsStoreClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block41Data Block41Data;
typedef struct _Block42Data Block42Data;

#define CONTACTS_TYPE_APP (contacts_app_get_type ())
#define CONTACTS_APP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_APP, ContactsApp))
#define CONTACTS_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_APP, ContactsAppClass))
#define CONTACTS_IS_APP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_APP))
#define CONTACTS_IS_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_APP))
#define CONTACTS_APP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_APP, ContactsAppClass))

typedef struct _ContactsApp ContactsApp;
typedef struct _ContactsAppClass ContactsAppClass;
typedef struct _ContactsAppPrivate ContactsAppPrivate;

#define CONTACTS_TYPE_WINDOW (contacts_window_get_type ())
#define CONTACTS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_WINDOW, ContactsWindow))
#define CONTACTS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_WINDOW, ContactsWindowClass))
#define CONTACTS_IS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_WINDOW))
#define CONTACTS_IS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_WINDOW))
#define CONTACTS_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_WINDOW, ContactsWindowClass))

typedef struct _ContactsWindow ContactsWindow;
typedef struct _ContactsWindowClass ContactsWindowClass;
#define _g_bytes_unref0(var) ((var == NULL) ? NULL : (var = (g_bytes_unref (var), NULL)))

struct _ContactsAvatarDialog {
	GtkDialog parent_instance;
	ContactsAvatarDialogPrivate * priv;
};

struct _ContactsAvatarDialogClass {
	GtkDialogClass parent_class;
};

struct _ContactsAvatarDialogPrivate {
	GnomeDesktopThumbnailFactory* thumbnail_factory;
	ContactsContact* contact;
	GtkNotebook* notebook;
	UmCropArea* crop_area;
	GtkGrid* view_grid;
	ContactsContactFrame* main_frame;
	CheeseFlash* flash;
	CheeseCameraDeviceMonitor* camera_monitor;
	CheeseWidget* cheese;
	gint num_cameras;
	GdkPixbuf* new_pixbuf;
};

struct _Block40Data {
	int _ref_count_;
	ContactsAvatarDialog * self;
	GdkPixbuf* avatar_pixbuf;
};

struct _ContactsContact {
	GObject parent_instance;
	ContactsContactPrivate * priv;
	ContactsStore* store;
	gboolean is_main;
	FolksPresenceType presence_type;
	gchar* presence_message;
	gboolean is_phone;
	FolksIndividual* individual;
};

struct _ContactsContactClass {
	GObjectClass parent_class;
};

struct _Block41Data {
	int _ref_count_;
	ContactsAvatarDialog * self;
	GtkFileChooserDialog* chooser;
};

struct _Block42Data {
	int _ref_count_;
	ContactsAvatarDialog * self;
	GtkToolButton* webcam_button;
	ContactsContact* contact;
};

struct _ContactsApp {
	GtkApplication parent_instance;
	ContactsAppPrivate * priv;
	GSettings* settings;
	ContactsStore* contacts_store;
	ContactsWindow* window;
};

struct _ContactsAppClass {
	GtkApplicationClass parent_class;
};


static gpointer contacts_avatar_dialog_parent_class = NULL;
extern ContactsApp* contacts_app_app;

GType contacts_avatar_dialog_get_type (void) G_GNUC_CONST;
GType contacts_contact_get_type (void) G_GNUC_CONST;
GType contacts_contact_frame_get_type (void) G_GNUC_CONST;
#define CONTACTS_AVATAR_DIALOG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CONTACTS_TYPE_AVATAR_DIALOG, ContactsAvatarDialogPrivate))
enum  {
	CONTACTS_AVATAR_DIALOG_DUMMY_PROPERTY
};
#define CONTACTS_AVATAR_DIALOG_main_size 128
#define CONTACTS_AVATAR_DIALOG_icons_size 64
#define CONTACTS_AVATAR_DIALOG_n_columns 6
static GdkPixbuf* contacts_avatar_dialog_scale_pixbuf_for_avatar_use (ContactsAvatarDialog* self, GdkPixbuf* pixbuf);
static ContactsContactFrame* contacts_avatar_dialog_create_frame (ContactsAvatarDialog* self, GdkPixbuf* source_pixbuf);
static Block40Data* block40_data_ref (Block40Data* _data40_);
static void block40_data_unref (void * _userdata_);
ContactsContactFrame* contacts_contact_frame_new (gint size, gboolean with_button);
ContactsContactFrame* contacts_contact_frame_construct (GType object_type, gint size, gboolean with_button);
void contacts_contact_frame_set_pixbuf (ContactsContactFrame* self, GdkPixbuf* a_pixbuf);
static void __lambda58_ (Block40Data* _data40_);
static void contacts_avatar_dialog_selected_pixbuf (ContactsAvatarDialog* self, GdkPixbuf* pixbuf);
static void ___lambda58__contacts_contact_frame_clicked (ContactsContactFrame* _sender, gpointer self);
static ContactsContactFrame* contacts_avatar_dialog_frame_for_persona (ContactsAvatarDialog* self, FolksPersona* persona);
static ContactsContactFrame* contacts_avatar_dialog_frame_for_filename (ContactsAvatarDialog* self, const gchar* filename);
static void contacts_avatar_dialog_update_grid (ContactsAvatarDialog* self);
GType contacts_store_get_type (void) G_GNUC_CONST;
gchar** contacts_utils_get_stock_avatars (int* result_length1);
void contacts_avatar_dialog_update_preview (ContactsAvatarDialog* self, GtkFileChooser* chooser);
static void contacts_avatar_dialog_set_crop_widget (ContactsAvatarDialog* self, GdkPixbuf* pixbuf);
static void contacts_avatar_dialog_select_avatar_file_cb (ContactsAvatarDialog* self);
static Block41Data* block41_data_ref (Block41Data* _data41_);
static void block41_data_unref (void * _userdata_);
static void _contacts_avatar_dialog_update_preview_gtk_file_chooser_update_preview (GtkFileChooser* _sender, gpointer self);
static void __lambda59_ (Block41Data* _data41_, gint response);
static void ___lambda59__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
ContactsAvatarDialog* contacts_avatar_dialog_new (ContactsContact* contact);
ContactsAvatarDialog* contacts_avatar_dialog_construct (GType object_type, ContactsContact* contact);
static Block42Data* block42_data_ref (Block42Data* _data42_);
static void block42_data_unref (void * _userdata_);
GType contacts_app_get_type (void) G_GNUC_CONST;
GType contacts_window_get_type (void) G_GNUC_CONST;
void contacts_contact_keep_widget_uptodate (ContactsContact* self, GtkWidget* w, GtkCallback callback, void* callback_target, GDestroyNotify callback_target_destroy_notify);
static void __lambda60_ (Block42Data* _data42_, GtkWidget* w);
void contacts_contact_frame_set_image (ContactsContactFrame* self, FolksAvatarDetails* details, ContactsContact* contact);
static void ___lambda60__gtk_callback (GtkWidget* widget, gpointer self);
const gchar* contacts_contact_get_display_name (ContactsContact* self);
static void _contacts_avatar_dialog_select_avatar_file_cb_gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static void __lambda61_ (Block42Data* _data42_);
static void ___lambda61__cheese_camera_device_monitor_added (CheeseCameraDeviceMonitor* _sender, CheeseCameraDevice* device, gpointer self);
static void __lambda62_ (Block42Data* _data42_);
static void ___lambda62__cheese_camera_device_monitor_removed (CheeseCameraDeviceMonitor* _sender, const gchar* uuid, gpointer self);
static void __lambda63_ (ContactsAvatarDialog* self, GtkToolButton* button);
static void ___lambda63__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static void __lambda64_ (ContactsAvatarDialog* self, GtkToolButton* button);
static void ___lambda64__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static void __lambda65_ (ContactsAvatarDialog* self, GtkToolButton* button);
static void ___lambda65__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static void __lambda66_ (ContactsAvatarDialog* self, GtkToolButton* button);
static void __lambda67_ (ContactsAvatarDialog* self, GdkPixbuf* pix);
static void ___lambda67__cheese_camera_photo_taken (CheeseCamera* _sender, GdkPixbuf* pixbuf, gpointer self);
static void ___lambda66__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static void __lambda68_ (ContactsAvatarDialog* self, GtkToolButton* button);
static void ___lambda68__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static void __lambda69_ (ContactsAvatarDialog* self, gint response_id);
static void ___lambda69__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
static void contacts_avatar_dialog_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static GdkPixbuf* contacts_avatar_dialog_scale_pixbuf_for_avatar_use (ContactsAvatarDialog* self, GdkPixbuf* pixbuf) {
	GdkPixbuf* result = NULL;
	gint w = 0;
	GdkPixbuf* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint h = 0;
	GdkPixbuf* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gboolean _tmp4_ = FALSE;
	gint _tmp5_ = 0;
	gboolean _tmp7_ = FALSE;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	GdkPixbuf* _tmp18_ = NULL;
	gint _tmp19_ = 0;
	gint _tmp20_ = 0;
	GdkPixbuf* _tmp21_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (pixbuf != NULL, NULL);
	_tmp0_ = pixbuf;
	_tmp1_ = gdk_pixbuf_get_width (_tmp0_);
	w = _tmp1_;
	_tmp2_ = pixbuf;
	_tmp3_ = gdk_pixbuf_get_height (_tmp2_);
	h = _tmp3_;
	_tmp5_ = w;
	if (_tmp5_ <= 128) {
		gint _tmp6_ = 0;
		_tmp6_ = h;
		_tmp4_ = _tmp6_ <= 128;
	} else {
		_tmp4_ = FALSE;
	}
	_tmp7_ = _tmp4_;
	if (_tmp7_) {
		GdkPixbuf* _tmp8_ = NULL;
		GdkPixbuf* _tmp9_ = NULL;
		_tmp8_ = pixbuf;
		_tmp9_ = _g_object_ref0 (_tmp8_);
		result = _tmp9_;
		return result;
	}
	_tmp10_ = w;
	_tmp11_ = h;
	if (_tmp10_ > _tmp11_) {
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
		gdouble _tmp14_ = 0.0;
		_tmp12_ = h;
		_tmp13_ = w;
		_tmp14_ = round ((_tmp12_ * 128.0) / _tmp13_);
		h = (gint) _tmp14_;
		w = 128;
	} else {
		gint _tmp15_ = 0;
		gint _tmp16_ = 0;
		gdouble _tmp17_ = 0.0;
		_tmp15_ = w;
		_tmp16_ = h;
		_tmp17_ = round ((_tmp15_ * 128.0) / _tmp16_);
		w = (gint) _tmp17_;
		h = 128;
	}
	_tmp18_ = pixbuf;
	_tmp19_ = w;
	_tmp20_ = h;
	_tmp21_ = gdk_pixbuf_scale_simple (_tmp18_, _tmp19_, _tmp20_, GDK_INTERP_HYPER);
	result = _tmp21_;
	return result;
}


static Block40Data* block40_data_ref (Block40Data* _data40_) {
	g_atomic_int_inc (&_data40_->_ref_count_);
	return _data40_;
}


static void block40_data_unref (void * _userdata_) {
	Block40Data* _data40_;
	_data40_ = (Block40Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data40_->_ref_count_)) {
		ContactsAvatarDialog * self;
		self = _data40_->self;
		_g_object_unref0 (_data40_->avatar_pixbuf);
		_g_object_unref0 (self);
		g_slice_free (Block40Data, _data40_);
	}
}


static void __lambda58_ (Block40Data* _data40_) {
	ContactsAvatarDialog * self;
	self = _data40_->self;
	contacts_avatar_dialog_selected_pixbuf (self, _data40_->avatar_pixbuf);
}


static void ___lambda58__contacts_contact_frame_clicked (ContactsContactFrame* _sender, gpointer self) {
	__lambda58_ (self);
}


static ContactsContactFrame* contacts_avatar_dialog_create_frame (ContactsAvatarDialog* self, GdkPixbuf* source_pixbuf) {
	ContactsContactFrame* result = NULL;
	Block40Data* _data40_;
	ContactsContactFrame* image_frame = NULL;
	ContactsContactFrame* _tmp0_ = NULL;
	GdkPixbuf* pixbuf = NULL;
	GdkPixbuf* _tmp1_ = NULL;
	GdkPixbuf* _tmp2_ = NULL;
	GdkPixbuf* _tmp3_ = NULL;
	GdkPixbuf* _tmp4_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (source_pixbuf != NULL, NULL);
	_data40_ = g_slice_new0 (Block40Data);
	_data40_->_ref_count_ = 1;
	_data40_->self = g_object_ref (self);
	_tmp0_ = contacts_contact_frame_new (CONTACTS_AVATAR_DIALOG_icons_size, TRUE);
	g_object_ref_sink (_tmp0_);
	image_frame = _tmp0_;
	_tmp1_ = source_pixbuf;
	_tmp2_ = gdk_pixbuf_scale_simple (_tmp1_, CONTACTS_AVATAR_DIALOG_icons_size, CONTACTS_AVATAR_DIALOG_icons_size, GDK_INTERP_HYPER);
	pixbuf = _tmp2_;
	contacts_contact_frame_set_pixbuf (image_frame, pixbuf);
	_tmp3_ = source_pixbuf;
	_tmp4_ = contacts_avatar_dialog_scale_pixbuf_for_avatar_use (self, _tmp3_);
	_data40_->avatar_pixbuf = _tmp4_;
	g_signal_connect_data (image_frame, "clicked", (GCallback) ___lambda58__contacts_contact_frame_clicked, block40_data_ref (_data40_), (GClosureNotify) block40_data_unref, 0);
	result = image_frame;
	_g_object_unref0 (pixbuf);
	block40_data_unref (_data40_);
	_data40_ = NULL;
	return result;
}


static ContactsContactFrame* contacts_avatar_dialog_frame_for_persona (ContactsAvatarDialog* self, FolksPersona* persona) {
	ContactsContactFrame* result = NULL;
	FolksAvatarDetails* details = NULL;
	FolksPersona* _tmp0_ = NULL;
	FolksAvatarDetails* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	FolksAvatarDetails* _tmp3_ = NULL;
	gboolean _tmp7_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (persona != NULL, NULL);
	_tmp0_ = persona;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, FOLKS_TYPE_AVATAR_DETAILS) ? ((FolksAvatarDetails*) _tmp0_) : NULL);
	details = _tmp1_;
	_tmp3_ = details;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		FolksAvatarDetails* _tmp4_ = NULL;
		GLoadableIcon* _tmp5_ = NULL;
		GLoadableIcon* _tmp6_ = NULL;
		_tmp4_ = details;
		_tmp5_ = folks_avatar_details_get_avatar (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp2_ = _tmp6_ == NULL;
	}
	_tmp7_ = _tmp2_;
	if (_tmp7_) {
		result = NULL;
		_g_object_unref0 (details);
		return result;
	}
	{
		GInputStream* stream = NULL;
		FolksAvatarDetails* _tmp8_ = NULL;
		GLoadableIcon* _tmp9_ = NULL;
		GLoadableIcon* _tmp10_ = NULL;
		GInputStream* _tmp11_ = NULL;
		GdkPixbuf* pixbuf = NULL;
		GInputStream* _tmp12_ = NULL;
		GdkPixbuf* _tmp13_ = NULL;
		GdkPixbuf* _tmp14_ = NULL;
		ContactsContactFrame* _tmp15_ = NULL;
		_tmp8_ = details;
		_tmp9_ = folks_avatar_details_get_avatar (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_loadable_icon_load (_tmp10_, 128, NULL, NULL, &_inner_error_);
		stream = _tmp11_;
		if (_inner_error_ != NULL) {
			goto __catch30_g_error;
		}
		_tmp12_ = stream;
		_tmp13_ = gdk_pixbuf_new_from_stream (_tmp12_, NULL, &_inner_error_);
		pixbuf = _tmp13_;
		if (_inner_error_ != NULL) {
			_g_object_unref0 (stream);
			goto __catch30_g_error;
		}
		_tmp14_ = pixbuf;
		_tmp15_ = contacts_avatar_dialog_create_frame (self, _tmp14_);
		result = _tmp15_;
		_g_object_unref0 (pixbuf);
		_g_object_unref0 (stream);
		_g_object_unref0 (details);
		return result;
	}
	goto __finally30;
	__catch30_g_error:
	{
		g_clear_error (&_inner_error_);
		_inner_error_ = NULL;
	}
	__finally30:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (details);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = NULL;
	_g_object_unref0 (details);
	return result;
}


static ContactsContactFrame* contacts_avatar_dialog_frame_for_filename (ContactsAvatarDialog* self, const gchar* filename) {
	ContactsContactFrame* result = NULL;
	ContactsContactFrame* image_frame = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (filename != NULL, NULL);
	image_frame = NULL;
	{
		GdkPixbuf* pixbuf = NULL;
		const gchar* _tmp0_ = NULL;
		GdkPixbuf* _tmp1_ = NULL;
		ContactsContactFrame* _tmp2_ = NULL;
		_tmp0_ = filename;
		_tmp1_ = gdk_pixbuf_new_from_file (_tmp0_, &_inner_error_);
		pixbuf = _tmp1_;
		if (_inner_error_ != NULL) {
			goto __catch31_g_error;
		}
		_tmp2_ = contacts_avatar_dialog_create_frame (self, pixbuf);
		result = _tmp2_;
		_g_object_unref0 (pixbuf);
		_g_object_unref0 (image_frame);
		return result;
	}
	goto __finally31;
	__catch31_g_error:
	{
		g_clear_error (&_inner_error_);
		_inner_error_ = NULL;
	}
	__finally31:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (image_frame);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = image_frame;
	return result;
}


static void contacts_avatar_dialog_selected_pixbuf (ContactsAvatarDialog* self, GdkPixbuf* pixbuf) {
	GdkPixbuf* p = NULL;
	GdkPixbuf* _tmp0_ = NULL;
	GdkPixbuf* _tmp1_ = NULL;
	ContactsContactFrame* _tmp2_ = NULL;
	GdkPixbuf* _tmp3_ = NULL;
	GdkPixbuf* _tmp4_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (pixbuf != NULL);
	_tmp0_ = pixbuf;
	_tmp1_ = gdk_pixbuf_scale_simple (_tmp0_, CONTACTS_AVATAR_DIALOG_main_size, CONTACTS_AVATAR_DIALOG_main_size, GDK_INTERP_HYPER);
	p = _tmp1_;
	_tmp2_ = self->priv->main_frame;
	contacts_contact_frame_set_pixbuf (_tmp2_, p);
	_tmp3_ = pixbuf;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (self->priv->new_pixbuf);
	self->priv->new_pixbuf = _tmp4_;
	_g_object_unref0 (p);
}


static void contacts_avatar_dialog_update_grid (ContactsAvatarDialog* self) {
	gint i = 0;
	gint j = 0;
	gint _tmp20_ = 0;
	gint _tmp22_ = 0;
	gchar** stock_files = NULL;
	gint _tmp27_ = 0;
	gchar** _tmp28_ = NULL;
	gint stock_files_length1 = 0;
	gint _stock_files_size_ = 0;
	gchar** _tmp29_ = NULL;
	gint _tmp29__length1 = 0;
	GtkGrid* _tmp42_ = NULL;
	g_return_if_fail (self != NULL);
	i = 0;
	j = 0;
	{
		GeeIterator* _p_it = NULL;
		ContactsContact* _tmp0_ = NULL;
		FolksIndividual* _tmp1_ = NULL;
		GeeSet* _tmp2_ = NULL;
		GeeSet* _tmp3_ = NULL;
		GeeIterator* _tmp4_ = NULL;
		_tmp0_ = self->priv->contact;
		_tmp1_ = _tmp0_->individual;
		_tmp2_ = folks_individual_get_personas (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
		_p_it = _tmp4_;
		while (TRUE) {
			GeeIterator* _tmp5_ = NULL;
			gboolean _tmp6_ = FALSE;
			FolksPersona* p = NULL;
			GeeIterator* _tmp7_ = NULL;
			gpointer _tmp8_ = NULL;
			ContactsContactFrame* frame = NULL;
			FolksPersona* _tmp9_ = NULL;
			ContactsContactFrame* _tmp10_ = NULL;
			ContactsContactFrame* _tmp11_ = NULL;
			_tmp5_ = _p_it;
			_tmp6_ = gee_iterator_next (_tmp5_);
			if (!_tmp6_) {
				break;
			}
			_tmp7_ = _p_it;
			_tmp8_ = gee_iterator_get (_tmp7_);
			p = (FolksPersona*) _tmp8_;
			_tmp9_ = p;
			_tmp10_ = contacts_avatar_dialog_frame_for_persona (self, _tmp9_);
			frame = _tmp10_;
			_tmp11_ = frame;
			if (_tmp11_ != NULL) {
				GtkGrid* _tmp12_ = NULL;
				ContactsContactFrame* _tmp13_ = NULL;
				gint _tmp14_ = 0;
				gint _tmp15_ = 0;
				gint _tmp16_ = 0;
				gint _tmp17_ = 0;
				_tmp12_ = self->priv->view_grid;
				_tmp13_ = frame;
				_tmp14_ = i;
				_tmp15_ = j;
				gtk_grid_attach (_tmp12_, (GtkWidget*) _tmp13_, _tmp14_, _tmp15_, 1, 1);
				_tmp16_ = i;
				i = _tmp16_ + 1;
				_tmp17_ = i;
				if (_tmp17_ >= CONTACTS_AVATAR_DIALOG_n_columns) {
					gint _tmp18_ = 0;
					gint _tmp19_ = 0;
					_tmp18_ = i;
					i = _tmp18_ - CONTACTS_AVATAR_DIALOG_n_columns;
					_tmp19_ = j;
					j = _tmp19_ + 1;
				}
			}
			_g_object_unref0 (frame);
			_g_object_unref0 (p);
		}
		_g_object_unref0 (_p_it);
	}
	_tmp20_ = i;
	if (_tmp20_ != 0) {
		gint _tmp21_ = 0;
		i = 0;
		_tmp21_ = j;
		j = _tmp21_ + 1;
	}
	_tmp22_ = j;
	if (_tmp22_ != 0) {
		GtkSeparator* s = NULL;
		GtkSeparator* _tmp23_ = NULL;
		GtkGrid* _tmp24_ = NULL;
		GtkSeparator* _tmp25_ = NULL;
		gint _tmp26_ = 0;
		_tmp23_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_HORIZONTAL);
		g_object_ref_sink (_tmp23_);
		s = _tmp23_;
		_tmp24_ = self->priv->view_grid;
		_tmp25_ = s;
		_tmp26_ = j;
		j = _tmp26_ + 1;
		gtk_grid_attach (_tmp24_, (GtkWidget*) _tmp25_, 0, _tmp26_, CONTACTS_AVATAR_DIALOG_n_columns, 1);
		_g_object_unref0 (s);
	}
	_tmp28_ = contacts_utils_get_stock_avatars (&_tmp27_);
	stock_files = _tmp28_;
	stock_files_length1 = _tmp27_;
	_stock_files_size_ = stock_files_length1;
	_tmp29_ = stock_files;
	_tmp29__length1 = stock_files_length1;
	{
		gchar** file_name_collection = NULL;
		gint file_name_collection_length1 = 0;
		gint _file_name_collection_size_ = 0;
		gint file_name_it = 0;
		file_name_collection = _tmp29_;
		file_name_collection_length1 = _tmp29__length1;
		for (file_name_it = 0; file_name_it < _tmp29__length1; file_name_it = file_name_it + 1) {
			gchar* _tmp30_ = NULL;
			gchar* file_name = NULL;
			_tmp30_ = g_strdup (file_name_collection[file_name_it]);
			file_name = _tmp30_;
			{
				ContactsContactFrame* frame = NULL;
				const gchar* _tmp31_ = NULL;
				ContactsContactFrame* _tmp32_ = NULL;
				ContactsContactFrame* _tmp33_ = NULL;
				_tmp31_ = file_name;
				_tmp32_ = contacts_avatar_dialog_frame_for_filename (self, _tmp31_);
				frame = _tmp32_;
				_tmp33_ = frame;
				if (_tmp33_ != NULL) {
					GtkGrid* _tmp34_ = NULL;
					ContactsContactFrame* _tmp35_ = NULL;
					gint _tmp36_ = 0;
					gint _tmp37_ = 0;
					gint _tmp38_ = 0;
					gint _tmp39_ = 0;
					_tmp34_ = self->priv->view_grid;
					_tmp35_ = frame;
					_tmp36_ = i;
					_tmp37_ = j;
					gtk_grid_attach (_tmp34_, (GtkWidget*) _tmp35_, _tmp36_, _tmp37_, 1, 1);
					_tmp38_ = i;
					i = _tmp38_ + 1;
					_tmp39_ = i;
					if (_tmp39_ >= CONTACTS_AVATAR_DIALOG_n_columns) {
						gint _tmp40_ = 0;
						gint _tmp41_ = 0;
						_tmp40_ = i;
						i = _tmp40_ - CONTACTS_AVATAR_DIALOG_n_columns;
						_tmp41_ = j;
						j = _tmp41_ + 1;
					}
				}
				_g_object_unref0 (frame);
				_g_free0 (file_name);
			}
		}
	}
	_tmp42_ = self->priv->view_grid;
	gtk_widget_show_all ((GtkWidget*) _tmp42_);
	stock_files = (_vala_array_free (stock_files, stock_files_length1, (GDestroyNotify) g_free), NULL);
}


void contacts_avatar_dialog_update_preview (ContactsAvatarDialog* self, GtkFileChooser* chooser) {
	gchar* uri = NULL;
	GtkFileChooser* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GtkFileChooser* _tmp26_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (chooser != NULL);
	_tmp0_ = chooser;
	_tmp1_ = gtk_file_chooser_get_preview_uri (_tmp0_);
	uri = _tmp1_;
	_tmp2_ = uri;
	if (_tmp2_ != NULL) {
		GdkPixbuf* pixbuf = NULL;
		GtkImage* preview = NULL;
		GtkFileChooser* _tmp3_ = NULL;
		GtkWidget* _tmp4_ = NULL;
		GtkImage* _tmp5_ = NULL;
		GFile* file = NULL;
		const gchar* _tmp6_ = NULL;
		GFile* _tmp7_ = NULL;
		GtkFileChooser* _tmp20_ = NULL;
		GdkPixbuf* _tmp21_ = NULL;
		GdkPixbuf* _tmp22_ = NULL;
		pixbuf = NULL;
		_tmp3_ = chooser;
		_tmp4_ = gtk_file_chooser_get_preview_widget (_tmp3_);
		_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, GTK_TYPE_IMAGE) ? ((GtkImage*) _tmp4_) : NULL);
		preview = _tmp5_;
		_tmp6_ = uri;
		_tmp7_ = g_file_new_for_uri (_tmp6_);
		file = _tmp7_;
		{
			GFileInfo* file_info = NULL;
			GFile* _tmp8_ = NULL;
			GFileInfo* _tmp9_ = NULL;
			GFileInfo* _tmp10_ = NULL;
			_tmp8_ = file;
			_tmp9_ = g_file_query_info (_tmp8_, G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
			file_info = _tmp9_;
			if (_inner_error_ != NULL) {
				goto __catch32_g_error;
			}
			_tmp10_ = file_info;
			if (_tmp10_ != NULL) {
				gchar* mime_type = NULL;
				GFileInfo* _tmp11_ = NULL;
				const gchar* _tmp12_ = NULL;
				gchar* _tmp13_ = NULL;
				const gchar* _tmp14_ = NULL;
				_tmp11_ = file_info;
				_tmp12_ = g_file_info_get_content_type (_tmp11_);
				_tmp13_ = g_strdup (_tmp12_);
				mime_type = _tmp13_;
				_tmp14_ = mime_type;
				if (_tmp14_ != NULL) {
					GnomeDesktopThumbnailFactory* _tmp15_ = NULL;
					const gchar* _tmp16_ = NULL;
					const gchar* _tmp17_ = NULL;
					GdkPixbuf* _tmp18_ = NULL;
					GdkPixbuf* _tmp19_ = NULL;
					_tmp15_ = self->priv->thumbnail_factory;
					_tmp16_ = uri;
					_tmp17_ = mime_type;
					_tmp18_ = gnome_desktop_thumbnail_factory_generate_thumbnail (_tmp15_, _tmp16_, _tmp17_);
					_tmp19_ = _g_object_ref0 (_tmp18_);
					_g_object_unref0 (pixbuf);
					pixbuf = _tmp19_;
				}
				_g_free0 (mime_type);
			}
			_g_object_unref0 (file_info);
		}
		goto __finally32;
		__catch32_g_error:
		{
			GError* e = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_g_error_free0 (e);
		}
		__finally32:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (file);
			_g_object_unref0 (preview);
			_g_object_unref0 (pixbuf);
			_g_free0 (uri);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp20_ = chooser;
		_tmp21_ = pixbuf;
		gtk_dialog_set_response_sensitive (G_TYPE_CHECK_INSTANCE_TYPE (_tmp20_, GTK_TYPE_DIALOG) ? ((GtkDialog*) _tmp20_) : NULL, (gint) GTK_RESPONSE_ACCEPT, _tmp21_ != NULL);
		_tmp22_ = pixbuf;
		if (_tmp22_ != NULL) {
			GtkImage* _tmp23_ = NULL;
			GdkPixbuf* _tmp24_ = NULL;
			_tmp23_ = preview;
			_tmp24_ = pixbuf;
			gtk_image_set_from_pixbuf (_tmp23_, _tmp24_);
		} else {
			GtkImage* _tmp25_ = NULL;
			_tmp25_ = preview;
			gtk_image_set_from_stock (_tmp25_, "dialog-question", GTK_ICON_SIZE_DIALOG);
		}
		_g_object_unref0 (file);
		_g_object_unref0 (preview);
		_g_object_unref0 (pixbuf);
	}
	_tmp26_ = chooser;
	gtk_file_chooser_set_preview_widget_active (_tmp26_, TRUE);
	_g_free0 (uri);
}


static void contacts_avatar_dialog_set_crop_widget (ContactsAvatarDialog* self, GdkPixbuf* pixbuf) {
	GtkGrid* frame_grid = NULL;
	GtkNotebook* _tmp0_ = NULL;
	GtkWidget* _tmp1_ = NULL;
	GtkGrid* _tmp2_ = NULL;
	UmCropArea* _tmp3_ = NULL;
	UmCropArea* _tmp4_ = NULL;
	UmCropArea* _tmp5_ = NULL;
	UmCropArea* _tmp6_ = NULL;
	UmCropArea* _tmp7_ = NULL;
	UmCropArea* _tmp8_ = NULL;
	GdkPixbuf* _tmp9_ = NULL;
	UmCropArea* _tmp10_ = NULL;
	GtkNotebook* _tmp11_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (pixbuf != NULL);
	_tmp0_ = self->priv->notebook;
	_tmp1_ = gtk_notebook_get_nth_page (_tmp0_, 1);
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, GTK_TYPE_GRID) ? ((GtkGrid*) _tmp1_) : NULL);
	frame_grid = _tmp2_;
	_tmp3_ = (UmCropArea*) um_crop_area_new ();
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->crop_area);
	self->priv->crop_area = _tmp3_;
	_tmp4_ = self->priv->crop_area;
	gtk_widget_set_vexpand ((GtkWidget*) _tmp4_, TRUE);
	_tmp5_ = self->priv->crop_area;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp5_, TRUE);
	_tmp6_ = self->priv->crop_area;
	um_crop_area_set_min_size (_tmp6_, 48, 48);
	_tmp7_ = self->priv->crop_area;
	um_crop_area_set_constrain_aspect (_tmp7_, TRUE);
	_tmp8_ = self->priv->crop_area;
	_tmp9_ = pixbuf;
	um_crop_area_set_picture (_tmp8_, _tmp9_);
	_tmp10_ = self->priv->crop_area;
	gtk_grid_attach (frame_grid, (GtkWidget*) _tmp10_, 0, 0, 1, 1);
	gtk_widget_show_all ((GtkWidget*) frame_grid);
	_tmp11_ = self->priv->notebook;
	gtk_notebook_set_current_page (_tmp11_, 1);
	_g_object_unref0 (frame_grid);
}


static Block41Data* block41_data_ref (Block41Data* _data41_) {
	g_atomic_int_inc (&_data41_->_ref_count_);
	return _data41_;
}


static void block41_data_unref (void * _userdata_) {
	Block41Data* _data41_;
	_data41_ = (Block41Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data41_->_ref_count_)) {
		ContactsAvatarDialog * self;
		self = _data41_->self;
		_g_object_unref0 (_data41_->chooser);
		_g_object_unref0 (self);
		g_slice_free (Block41Data, _data41_);
	}
}


static void _contacts_avatar_dialog_update_preview_gtk_file_chooser_update_preview (GtkFileChooser* _sender, gpointer self) {
	contacts_avatar_dialog_update_preview (self, _sender);
}


static void __lambda59_ (Block41Data* _data41_, gint response) {
	ContactsAvatarDialog * self;
	gint _tmp0_ = 0;
	GtkFileChooserDialog* _tmp22_ = NULL;
	GError * _inner_error_ = NULL;
	self = _data41_->self;
	_tmp0_ = response;
	if (_tmp0_ != ((gint) GTK_RESPONSE_ACCEPT)) {
		GtkFileChooserDialog* _tmp1_ = NULL;
		_tmp1_ = _data41_->chooser;
		gtk_widget_destroy ((GtkWidget*) _tmp1_);
		return;
	}
	{
		GFile* file = NULL;
		GtkFileChooserDialog* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		GFile* _tmp5_ = NULL;
		GFile* _tmp6_ = NULL;
		GFileInputStream* in_stream = NULL;
		GFile* _tmp7_ = NULL;
		GFileInputStream* _tmp8_ = NULL;
		GdkPixbuf* pixbuf = NULL;
		GFileInputStream* _tmp9_ = NULL;
		GdkPixbuf* _tmp10_ = NULL;
		GFileInputStream* _tmp11_ = NULL;
		gboolean _tmp12_ = FALSE;
		GdkPixbuf* _tmp13_ = NULL;
		gint _tmp14_ = 0;
		gboolean _tmp17_ = FALSE;
		_tmp2_ = _data41_->chooser;
		_tmp3_ = gtk_file_chooser_get_uri ((GtkFileChooser*) _tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_file_new_for_uri (_tmp4_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		file = _tmp6_;
		_tmp7_ = file;
		_tmp8_ = g_file_read (_tmp7_, NULL, &_inner_error_);
		in_stream = _tmp8_;
		if (_inner_error_ != NULL) {
			_g_object_unref0 (file);
			goto __catch33_g_error;
		}
		_tmp9_ = in_stream;
		_tmp10_ = gdk_pixbuf_new_from_stream ((GInputStream*) _tmp9_, NULL, &_inner_error_);
		pixbuf = _tmp10_;
		if (_inner_error_ != NULL) {
			_g_object_unref0 (in_stream);
			_g_object_unref0 (file);
			goto __catch33_g_error;
		}
		_tmp11_ = in_stream;
		g_input_stream_close ((GInputStream*) _tmp11_, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (pixbuf);
			_g_object_unref0 (in_stream);
			_g_object_unref0 (file);
			goto __catch33_g_error;
		}
		_tmp13_ = pixbuf;
		_tmp14_ = gdk_pixbuf_get_width (_tmp13_);
		if (_tmp14_ > 128) {
			_tmp12_ = TRUE;
		} else {
			GdkPixbuf* _tmp15_ = NULL;
			gint _tmp16_ = 0;
			_tmp15_ = pixbuf;
			_tmp16_ = gdk_pixbuf_get_height (_tmp15_);
			_tmp12_ = _tmp16_ > 128;
		}
		_tmp17_ = _tmp12_;
		if (_tmp17_) {
			GdkPixbuf* _tmp18_ = NULL;
			_tmp18_ = pixbuf;
			contacts_avatar_dialog_set_crop_widget (self, _tmp18_);
		} else {
			GdkPixbuf* _tmp19_ = NULL;
			GdkPixbuf* _tmp20_ = NULL;
			GdkPixbuf* _tmp21_ = NULL;
			_tmp19_ = pixbuf;
			_tmp20_ = contacts_avatar_dialog_scale_pixbuf_for_avatar_use (self, _tmp19_);
			_tmp21_ = _tmp20_;
			contacts_avatar_dialog_selected_pixbuf (self, _tmp21_);
			_g_object_unref0 (_tmp21_);
		}
		contacts_avatar_dialog_update_grid (self);
		_g_object_unref0 (pixbuf);
		_g_object_unref0 (in_stream);
		_g_object_unref0 (file);
	}
	goto __finally33;
	__catch33_g_error:
	{
		g_clear_error (&_inner_error_);
		_inner_error_ = NULL;
	}
	__finally33:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp22_ = _data41_->chooser;
	gtk_widget_destroy ((GtkWidget*) _tmp22_);
}


static void ___lambda59__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	__lambda59_ (self, response_id);
}


static void contacts_avatar_dialog_select_avatar_file_cb (ContactsAvatarDialog* self) {
	Block41Data* _data41_;
	const gchar* _tmp0_ = NULL;
	GtkWidget* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	GtkFileChooserDialog* _tmp4_ = NULL;
	GtkFileChooserDialog* _tmp5_ = NULL;
	GtkFileChooserDialog* _tmp6_ = NULL;
	GtkImage* preview = NULL;
	GtkImage* _tmp7_ = NULL;
	GtkImage* _tmp8_ = NULL;
	GtkFileChooserDialog* _tmp9_ = NULL;
	GtkImage* _tmp10_ = NULL;
	GtkFileChooserDialog* _tmp11_ = NULL;
	GtkImage* _tmp12_ = NULL;
	GtkFileChooserDialog* _tmp13_ = NULL;
	gchar* folder = NULL;
	const gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	GtkFileChooserDialog* _tmp19_ = NULL;
	GtkFileChooserDialog* _tmp20_ = NULL;
	g_return_if_fail (self != NULL);
	_data41_ = g_slice_new0 (Block41Data);
	_data41_->_ref_count_ = 1;
	_data41_->self = g_object_ref (self);
	_tmp0_ = _ ("Browse for more pictures");
	_tmp1_ = gtk_widget_get_toplevel ((GtkWidget*) self);
	_tmp2_ = _ ("_Cancel");
	_tmp3_ = _ ("_Open");
	_tmp4_ = (GtkFileChooserDialog*) gtk_file_chooser_dialog_new (_tmp0_, G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GTK_TYPE_WINDOW, GtkWindow), GTK_FILE_CHOOSER_ACTION_OPEN, _tmp2_, GTK_RESPONSE_CANCEL, _tmp3_, GTK_RESPONSE_ACCEPT, NULL);
	g_object_ref_sink (_tmp4_);
	_data41_->chooser = _tmp4_;
	_tmp5_ = _data41_->chooser;
	gtk_window_set_modal ((GtkWindow*) _tmp5_, TRUE);
	_tmp6_ = _data41_->chooser;
	gtk_file_chooser_set_local_only ((GtkFileChooser*) _tmp6_, FALSE);
	_tmp7_ = (GtkImage*) gtk_image_new ();
	g_object_ref_sink (_tmp7_);
	preview = _tmp7_;
	_tmp8_ = preview;
	gtk_widget_set_size_request ((GtkWidget*) _tmp8_, 128, -1);
	_tmp9_ = _data41_->chooser;
	_tmp10_ = preview;
	gtk_file_chooser_set_preview_widget ((GtkFileChooser*) _tmp9_, (GtkWidget*) _tmp10_);
	_tmp11_ = _data41_->chooser;
	gtk_file_chooser_set_use_preview_label ((GtkFileChooser*) _tmp11_, FALSE);
	_tmp12_ = preview;
	gtk_widget_show ((GtkWidget*) _tmp12_);
	_tmp13_ = _data41_->chooser;
	g_signal_connect_object ((GtkFileChooser*) _tmp13_, "update-preview", (GCallback) _contacts_avatar_dialog_update_preview_gtk_file_chooser_update_preview, self, 0);
	_tmp14_ = g_get_user_special_dir (G_USER_DIRECTORY_PICTURES);
	_tmp15_ = g_strdup (_tmp14_);
	folder = _tmp15_;
	_tmp16_ = folder;
	if (_tmp16_ != NULL) {
		GtkFileChooserDialog* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
		_tmp17_ = _data41_->chooser;
		_tmp18_ = folder;
		gtk_file_chooser_set_current_folder ((GtkFileChooser*) _tmp17_, _tmp18_);
	}
	_tmp19_ = _data41_->chooser;
	g_signal_connect_data ((GtkDialog*) _tmp19_, "response", (GCallback) ___lambda59__gtk_dialog_response, block41_data_ref (_data41_), (GClosureNotify) block41_data_unref, 0);
	_tmp20_ = _data41_->chooser;
	gtk_window_present ((GtkWindow*) _tmp20_);
	_g_free0 (folder);
	_g_object_unref0 (preview);
	block41_data_unref (_data41_);
	_data41_ = NULL;
}


static Block42Data* block42_data_ref (Block42Data* _data42_) {
	g_atomic_int_inc (&_data42_->_ref_count_);
	return _data42_;
}


static void block42_data_unref (void * _userdata_) {
	Block42Data* _data42_;
	_data42_ = (Block42Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data42_->_ref_count_)) {
		ContactsAvatarDialog * self;
		self = _data42_->self;
		_g_object_unref0 (_data42_->webcam_button);
		_g_object_unref0 (_data42_->contact);
		_g_object_unref0 (self);
		g_slice_free (Block42Data, _data42_);
	}
}


static void __lambda60_ (Block42Data* _data42_, GtkWidget* w) {
	ContactsAvatarDialog * self;
	GtkWidget* _tmp0_ = NULL;
	ContactsContact* _tmp1_ = NULL;
	FolksIndividual* _tmp2_ = NULL;
	ContactsContact* _tmp3_ = NULL;
	self = _data42_->self;
	g_return_if_fail (w != NULL);
	_tmp0_ = w;
	_tmp1_ = _data42_->contact;
	_tmp2_ = _tmp1_->individual;
	_tmp3_ = _data42_->contact;
	contacts_contact_frame_set_image (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, CONTACTS_TYPE_CONTACT_FRAME) ? ((ContactsContactFrame*) _tmp0_) : NULL, (FolksAvatarDetails*) _tmp2_, _tmp3_);
}


static void ___lambda60__gtk_callback (GtkWidget* widget, gpointer self) {
	__lambda60_ (self, widget);
}


static void _contacts_avatar_dialog_select_avatar_file_cb_gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	contacts_avatar_dialog_select_avatar_file_cb (self);
}


static void __lambda61_ (Block42Data* _data42_) {
	ContactsAvatarDialog * self;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	self = _data42_->self;
	_tmp0_ = self->priv->num_cameras;
	self->priv->num_cameras = _tmp0_ + 1;
	_tmp1_ = self->priv->num_cameras;
	gtk_widget_set_sensitive ((GtkWidget*) _data42_->webcam_button, _tmp1_ > 0);
}


static void ___lambda61__cheese_camera_device_monitor_added (CheeseCameraDeviceMonitor* _sender, CheeseCameraDevice* device, gpointer self) {
	__lambda61_ (self);
}


static void __lambda62_ (Block42Data* _data42_) {
	ContactsAvatarDialog * self;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	self = _data42_->self;
	_tmp0_ = self->priv->num_cameras;
	self->priv->num_cameras = _tmp0_ - 1;
	_tmp1_ = self->priv->num_cameras;
	gtk_widget_set_sensitive ((GtkWidget*) _data42_->webcam_button, _tmp1_ > 0);
}


static void ___lambda62__cheese_camera_device_monitor_removed (CheeseCameraDeviceMonitor* _sender, const gchar* uuid, gpointer self) {
	__lambda62_ (self);
}


static void __lambda63_ (ContactsAvatarDialog* self, GtkToolButton* button) {
	GtkNotebook* _tmp0_ = NULL;
	CheeseWidget* _tmp1_ = NULL;
	g_return_if_fail (button != NULL);
	_tmp0_ = self->priv->notebook;
	gtk_notebook_set_current_page (_tmp0_, 2);
	_tmp1_ = self->priv->cheese;
	gtk_widget_show ((GtkWidget*) _tmp1_);
}


static void ___lambda63__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	__lambda63_ (self, _sender);
}


static void __lambda64_ (ContactsAvatarDialog* self, GtkToolButton* button) {
	GdkPixbuf* pix = NULL;
	UmCropArea* _tmp0_ = NULL;
	GdkPixbuf* _tmp1_ = NULL;
	GdkPixbuf* _tmp2_ = NULL;
	GdkPixbuf* _tmp3_ = NULL;
	UmCropArea* _tmp4_ = NULL;
	GtkNotebook* _tmp5_ = NULL;
	g_return_if_fail (button != NULL);
	_tmp0_ = self->priv->crop_area;
	_tmp1_ = um_crop_area_get_picture (_tmp0_);
	pix = _tmp1_;
	_tmp2_ = contacts_avatar_dialog_scale_pixbuf_for_avatar_use (self, pix);
	_tmp3_ = _tmp2_;
	contacts_avatar_dialog_selected_pixbuf (self, _tmp3_);
	_g_object_unref0 (_tmp3_);
	_tmp4_ = self->priv->crop_area;
	gtk_widget_destroy ((GtkWidget*) _tmp4_);
	_tmp5_ = self->priv->notebook;
	gtk_notebook_set_current_page (_tmp5_, 0);
	_g_object_unref0 (pix);
}


static void ___lambda64__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	__lambda64_ (self, _sender);
}


static void __lambda65_ (ContactsAvatarDialog* self, GtkToolButton* button) {
	UmCropArea* _tmp0_ = NULL;
	GtkNotebook* _tmp1_ = NULL;
	g_return_if_fail (button != NULL);
	_tmp0_ = self->priv->crop_area;
	gtk_widget_destroy ((GtkWidget*) _tmp0_);
	_tmp1_ = self->priv->notebook;
	gtk_notebook_set_current_page (_tmp1_, 0);
}


static void ___lambda65__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	__lambda65_ (self, _sender);
}


static void __lambda67_ (ContactsAvatarDialog* self, GdkPixbuf* pix) {
	GdkPixbuf* _tmp0_ = NULL;
	CheeseWidget* _tmp1_ = NULL;
	g_return_if_fail (pix != NULL);
	_tmp0_ = pix;
	contacts_avatar_dialog_set_crop_widget (self, _tmp0_);
	_tmp1_ = self->priv->cheese;
	gtk_widget_hide ((GtkWidget*) _tmp1_);
}


static void ___lambda67__cheese_camera_photo_taken (CheeseCamera* _sender, GdkPixbuf* pixbuf, gpointer self) {
	__lambda67_ (self, pixbuf);
}


static void __lambda66_ (ContactsAvatarDialog* self, GtkToolButton* button) {
	CheeseCamera* camera = NULL;
	CheeseWidget* _tmp0_ = NULL;
	GObject* _tmp1_ = NULL;
	CheeseCamera* _tmp2_ = NULL;
	CheeseFlash* _tmp3_ = NULL;
	CheeseCamera* _tmp4_ = NULL;
	CheeseCamera* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	g_return_if_fail (button != NULL);
	_tmp0_ = self->priv->cheese;
	_tmp1_ = cheese_widget_get_camera (_tmp0_);
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, CHEESE_TYPE_CAMERA) ? ((CheeseCamera*) _tmp1_) : NULL);
	camera = _tmp2_;
	_tmp3_ = self->priv->flash;
	cheese_flash_fire (_tmp3_);
	_tmp4_ = camera;
	g_signal_connect_object (_tmp4_, "photo-taken", (GCallback) ___lambda67__cheese_camera_photo_taken, self, 0);
	_tmp5_ = camera;
	_tmp6_ = cheese_camera_take_photo_pixbuf (_tmp5_);
	if (!_tmp6_) {
		g_warning ("contacts-avatar-dialog.vala:409: Unable to take photo");
	}
	_g_object_unref0 (camera);
}


static void ___lambda66__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	__lambda66_ (self, _sender);
}


static void __lambda68_ (ContactsAvatarDialog* self, GtkToolButton* button) {
	GtkNotebook* _tmp0_ = NULL;
	CheeseWidget* _tmp1_ = NULL;
	g_return_if_fail (button != NULL);
	_tmp0_ = self->priv->notebook;
	gtk_notebook_set_current_page (_tmp0_, 0);
	_tmp1_ = self->priv->cheese;
	gtk_widget_hide ((GtkWidget*) _tmp1_);
}


static void ___lambda68__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	__lambda68_ (self, _sender);
}


static void __lambda69_ (ContactsAvatarDialog* self, gint response_id) {
	gint _tmp0_ = 0;
	GError * _inner_error_ = NULL;
	_tmp0_ = response_id;
	if (_tmp0_ == ((gint) GTK_RESPONSE_CLOSE)) {
		GdkPixbuf* _tmp1_ = NULL;
		_tmp1_ = self->priv->new_pixbuf;
		if (_tmp1_ != NULL) {
			{
				guint8* buffer = NULL;
				gint buffer_length1 = 0;
				gint _buffer_size_ = 0;
				gboolean _tmp2_ = FALSE;
				GdkPixbuf* _tmp3_ = NULL;
				guint8* _tmp4_ = NULL;
				gsize _tmp5_;
				gboolean _tmp6_ = FALSE;
				_tmp3_ = self->priv->new_pixbuf;
				_tmp6_ = gdk_pixbuf_save_to_buffer (_tmp3_, (gchar**) (&_tmp4_), &_tmp5_, "png", &_inner_error_, NULL, NULL);
				buffer = (g_free (buffer), NULL);
				buffer = _tmp4_;
				buffer_length1 = _tmp5_;
				_buffer_size_ = buffer_length1;
				_tmp2_ = _tmp6_;
				if (_inner_error_ != NULL) {
					buffer = (g_free (buffer), NULL);
					goto __catch34_g_error;
				}
				if (_tmp2_) {
					GBytesIcon* icon = NULL;
					guint8* _tmp7_ = NULL;
					gint _tmp7__length1 = 0;
					GBytes* _tmp8_ = NULL;
					GBytes* _tmp9_ = NULL;
					GBytesIcon* _tmp10_ = NULL;
					GBytesIcon* _tmp11_ = NULL;
					GBytesIcon* _tmp12_ = NULL;
					_tmp7_ = buffer;
					_tmp7__length1 = buffer_length1;
					_tmp8_ = g_bytes_new (_tmp7_, _tmp7__length1);
					_tmp9_ = _tmp8_;
					_tmp10_ = (GBytesIcon*) g_bytes_icon_new (_tmp9_);
					_tmp11_ = _tmp10_;
					_g_bytes_unref0 (_tmp9_);
					icon = _tmp11_;
					_tmp12_ = icon;
					g_signal_emit_by_name (self, "set-avatar", (GIcon*) _tmp12_);
					_g_object_unref0 (icon);
				} else {
				}
				buffer = (g_free (buffer), NULL);
			}
			goto __finally34;
			__catch34_g_error:
			{
				g_clear_error (&_inner_error_);
				_inner_error_ = NULL;
			}
			__finally34:
			if (_inner_error_ != NULL) {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
	_g_object_unref0 (self->priv->cheese);
	self->priv->cheese = NULL;
	gtk_widget_destroy ((GtkWidget*) self);
}


static void ___lambda69__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	__lambda69_ (self, response_id);
}


ContactsAvatarDialog* contacts_avatar_dialog_construct (GType object_type, ContactsContact* contact) {
	ContactsAvatarDialog * self = NULL;
	Block42Data* _data42_;
	ContactsContact* _tmp0_ = NULL;
	ContactsContact* _tmp1_ = NULL;
	GnomeDesktopThumbnailFactory* _tmp2_ = NULL;
	ContactsContact* _tmp3_ = NULL;
	ContactsContact* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	ContactsApp* _tmp6_ = NULL;
	ContactsWindow* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	GtkGrid* grid = NULL;
	GtkGrid* _tmp9_ = NULL;
	GtkContainer* container = NULL;
	GtkBox* _tmp10_ = NULL;
	GtkContainer* _tmp11_ = NULL;
	ContactsContactFrame* _tmp12_ = NULL;
	ContactsContact* _tmp13_ = NULL;
	ContactsContactFrame* _tmp14_ = NULL;
	ContactsContactFrame* _tmp15_ = NULL;
	ContactsContactFrame* _tmp16_ = NULL;
	GtkLabel* label = NULL;
	GtkLabel* _tmp17_ = NULL;
	ContactsContact* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
	const gchar* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	gchar* _tmp22_ = NULL;
	GtkFrame* frame = NULL;
	GtkFrame* _tmp23_ = NULL;
	GtkStyleContext* _tmp24_ = NULL;
	GtkNotebook* _tmp25_ = NULL;
	GtkNotebook* _tmp26_ = NULL;
	GtkNotebook* _tmp27_ = NULL;
	GtkGrid* frame_grid = NULL;
	GtkGrid* _tmp28_ = NULL;
	GtkGrid* _tmp29_ = NULL;
	GtkScrolledWindow* scrolled = NULL;
	GtkScrolledWindow* _tmp30_ = NULL;
	GtkGrid* _tmp31_ = NULL;
	GtkGrid* _tmp32_ = NULL;
	GtkGrid* _tmp33_ = NULL;
	GtkToolbar* toolbar = NULL;
	GtkToolbar* _tmp34_ = NULL;
	GtkToolbar* _tmp35_ = NULL;
	GtkStyleContext* _tmp36_ = NULL;
	GtkToolbar* _tmp37_ = NULL;
	GtkToolbar* _tmp38_ = NULL;
	GtkGrid* _tmp39_ = NULL;
	GtkToolbar* _tmp40_ = NULL;
	GtkToolButton* the_add_button = NULL;
	GtkToolButton* _tmp41_ = NULL;
	GtkStyleContext* _tmp42_ = NULL;
	GtkToolbar* _tmp43_ = NULL;
	GtkToolButton* _tmp44_ = NULL;
	GtkStyleContext* _tmp45_ = NULL;
	GtkToolbar* _tmp46_ = NULL;
	CheeseCameraDeviceMonitor* _tmp47_ = NULL;
	CheeseCameraDeviceMonitor* _tmp48_ = NULL;
	CheeseCameraDeviceMonitor* _tmp49_ = NULL;
	CheeseCameraDeviceMonitor* _tmp50_ = NULL;
	GtkGrid* _tmp51_ = NULL;
	GtkNotebook* _tmp52_ = NULL;
	GtkGrid* _tmp53_ = NULL;
	GtkGrid* _tmp54_ = NULL;
	GtkGrid* _tmp55_ = NULL;
	GtkToolbar* _tmp56_ = NULL;
	GtkToolbar* _tmp57_ = NULL;
	GtkStyleContext* _tmp58_ = NULL;
	GtkToolbar* _tmp59_ = NULL;
	GtkToolbar* _tmp60_ = NULL;
	GtkGrid* _tmp61_ = NULL;
	GtkToolbar* _tmp62_ = NULL;
	GtkToolButton* accept_button = NULL;
	GtkToolButton* _tmp63_ = NULL;
	GtkToolButton* _tmp64_ = NULL;
	GtkToolButton* _tmp65_ = NULL;
	GtkStyleContext* _tmp66_ = NULL;
	GtkToolButton* _tmp67_ = NULL;
	GtkToolbar* _tmp68_ = NULL;
	GtkToolButton* _tmp69_ = NULL;
	GtkToolButton* _tmp70_ = NULL;
	GtkToolButton* cancel_button = NULL;
	GtkToolButton* _tmp71_ = NULL;
	GtkToolButton* _tmp72_ = NULL;
	GtkToolButton* _tmp73_ = NULL;
	GtkStyleContext* _tmp74_ = NULL;
	GtkToolButton* _tmp75_ = NULL;
	GtkToolbar* _tmp76_ = NULL;
	GtkToolButton* _tmp77_ = NULL;
	GtkToolButton* _tmp78_ = NULL;
	GtkGrid* _tmp79_ = NULL;
	GtkNotebook* _tmp80_ = NULL;
	GtkGrid* _tmp81_ = NULL;
	GtkGrid* _tmp82_ = NULL;
	GtkGrid* _tmp83_ = NULL;
	CheeseWidget* _tmp84_ = NULL;
	CheeseWidget* _tmp85_ = NULL;
	CheeseWidget* _tmp86_ = NULL;
	CheeseWidget* _tmp87_ = NULL;
	GtkGrid* _tmp88_ = NULL;
	CheeseWidget* _tmp89_ = NULL;
	CheeseFlash* _tmp90_ = NULL;
	GtkToolbar* _tmp91_ = NULL;
	GtkToolbar* _tmp92_ = NULL;
	GtkStyleContext* _tmp93_ = NULL;
	GtkToolbar* _tmp94_ = NULL;
	GtkToolbar* _tmp95_ = NULL;
	GtkGrid* _tmp96_ = NULL;
	GtkToolbar* _tmp97_ = NULL;
	GtkToolButton* _tmp98_ = NULL;
	GtkToolButton* _tmp99_ = NULL;
	GtkToolButton* _tmp100_ = NULL;
	GtkStyleContext* _tmp101_ = NULL;
	GtkToolButton* _tmp102_ = NULL;
	GtkToolbar* _tmp103_ = NULL;
	GtkToolButton* _tmp104_ = NULL;
	GtkToolButton* _tmp105_ = NULL;
	GtkToolButton* _tmp106_ = NULL;
	GtkToolButton* _tmp107_ = NULL;
	GtkToolButton* _tmp108_ = NULL;
	GtkStyleContext* _tmp109_ = NULL;
	GtkToolButton* _tmp110_ = NULL;
	GtkToolbar* _tmp111_ = NULL;
	GtkToolButton* _tmp112_ = NULL;
	GtkToolButton* _tmp113_ = NULL;
	GtkGrid* _tmp114_ = NULL;
	GtkNotebook* _tmp115_ = NULL;
	GtkGrid* _tmp116_ = NULL;
	GtkNotebook* _tmp117_ = NULL;
	g_return_val_if_fail (contact != NULL, NULL);
	_data42_ = g_slice_new0 (Block42Data);
	_data42_->_ref_count_ = 1;
	_tmp0_ = contact;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data42_->contact);
	_data42_->contact = _tmp1_;
	self = (ContactsAvatarDialog*) g_object_new (object_type, NULL);
	_data42_->self = g_object_ref (self);
	_tmp2_ = gnome_desktop_thumbnail_factory_new (GNOME_DESKTOP_THUMBNAIL_SIZE_NORMAL);
	_g_object_unref0 (self->priv->thumbnail_factory);
	self->priv->thumbnail_factory = _tmp2_;
	_tmp3_ = _data42_->contact;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (self->priv->contact);
	self->priv->contact = _tmp4_;
	_tmp5_ = _ ("Select Picture");
	gtk_window_set_title ((GtkWindow*) self, _tmp5_);
	_tmp6_ = contacts_app_app;
	_tmp7_ = _tmp6_->window;
	gtk_window_set_transient_for ((GtkWindow*) self, (GtkWindow*) _tmp7_);
	gtk_window_set_modal ((GtkWindow*) self, TRUE);
	_tmp8_ = _ ("Close");
	gtk_dialog_add_buttons ((GtkDialog*) self, _tmp8_, GTK_RESPONSE_CLOSE, NULL, NULL);
	_tmp9_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp9_);
	grid = _tmp9_;
	gtk_container_set_border_width ((GtkContainer*) grid, (guint) 8);
	gtk_grid_set_column_spacing (grid, (guint) 16);
	_tmp10_ = (GtkBox*) gtk_dialog_get_content_area ((GtkDialog*) self);
	_tmp11_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp10_, GTK_TYPE_CONTAINER) ? ((GtkContainer*) _tmp10_) : NULL);
	container = _tmp11_;
	gtk_container_add (container, (GtkWidget*) grid);
	_tmp12_ = contacts_contact_frame_new (CONTACTS_AVATAR_DIALOG_main_size, FALSE);
	g_object_ref_sink (_tmp12_);
	_g_object_unref0 (self->priv->main_frame);
	self->priv->main_frame = _tmp12_;
	_tmp13_ = _data42_->contact;
	_tmp14_ = self->priv->main_frame;
	contacts_contact_keep_widget_uptodate (_tmp13_, (GtkWidget*) _tmp14_, ___lambda60__gtk_callback, block42_data_ref (_data42_), block42_data_unref);
	_tmp15_ = self->priv->main_frame;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp15_, FALSE);
	_tmp16_ = self->priv->main_frame;
	gtk_grid_attach (grid, (GtkWidget*) _tmp16_, 0, 0, 1, 1);
	_tmp17_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp17_);
	label = _tmp17_;
	_tmp18_ = _data42_->contact;
	_tmp19_ = contacts_contact_get_display_name (_tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = g_markup_printf_escaped ("<span font='16'>%s</span>", _tmp20_);
	_tmp22_ = _tmp21_;
	gtk_label_set_markup (label, _tmp22_);
	_g_free0 (_tmp22_);
	gtk_widget_set_valign ((GtkWidget*) label, GTK_ALIGN_START);
	gtk_widget_set_halign ((GtkWidget*) label, GTK_ALIGN_START);
	gtk_widget_set_hexpand ((GtkWidget*) label, TRUE);
	gtk_widget_set_margin_top ((GtkWidget*) label, 4);
	g_object_set ((GtkMisc*) label, "xalign", 0.0f, NULL);
	gtk_label_set_ellipsize (label, PANGO_ELLIPSIZE_END);
	gtk_grid_attach (grid, (GtkWidget*) label, 1, 0, 1, 1);
	gtk_grid_set_row_spacing (grid, (guint) 11);
	_tmp23_ = (GtkFrame*) gtk_frame_new (NULL);
	g_object_ref_sink (_tmp23_);
	frame = _tmp23_;
	_tmp24_ = gtk_widget_get_style_context ((GtkWidget*) frame);
	gtk_style_context_add_class (_tmp24_, "contacts-avatar-frame");
	gtk_grid_attach (grid, (GtkWidget*) frame, 0, 1, 2, 1);
	_tmp25_ = (GtkNotebook*) gtk_notebook_new ();
	g_object_ref_sink (_tmp25_);
	_g_object_unref0 (self->priv->notebook);
	self->priv->notebook = _tmp25_;
	_tmp26_ = self->priv->notebook;
	gtk_notebook_set_show_tabs (_tmp26_, FALSE);
	_tmp27_ = self->priv->notebook;
	gtk_container_add ((GtkContainer*) frame, (GtkWidget*) _tmp27_);
	_tmp28_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp28_);
	frame_grid = _tmp28_;
	_tmp29_ = frame_grid;
	gtk_orientable_set_orientation ((GtkOrientable*) _tmp29_, GTK_ORIENTATION_VERTICAL);
	_tmp30_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	g_object_ref_sink (_tmp30_);
	scrolled = _tmp30_;
	gtk_scrolled_window_set_policy (scrolled, GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
	gtk_widget_set_vexpand ((GtkWidget*) scrolled, TRUE);
	gtk_widget_set_hexpand ((GtkWidget*) scrolled, TRUE);
	gtk_widget_set_size_request ((GtkWidget*) scrolled, -1, 300);
	_tmp31_ = frame_grid;
	gtk_container_add ((GtkContainer*) _tmp31_, (GtkWidget*) scrolled);
	_tmp32_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp32_);
	_g_object_unref0 (self->priv->view_grid);
	self->priv->view_grid = _tmp32_;
	_tmp33_ = self->priv->view_grid;
	gtk_scrolled_window_add_with_viewport (scrolled, (GtkWidget*) _tmp33_);
	_tmp34_ = (GtkToolbar*) gtk_toolbar_new ();
	g_object_ref_sink (_tmp34_);
	toolbar = _tmp34_;
	_tmp35_ = toolbar;
	_tmp36_ = gtk_widget_get_style_context ((GtkWidget*) _tmp35_);
	gtk_style_context_add_class (_tmp36_, GTK_STYLE_CLASS_INLINE_TOOLBAR);
	_tmp37_ = toolbar;
	gtk_toolbar_set_icon_size (_tmp37_, GTK_ICON_SIZE_MENU);
	_tmp38_ = toolbar;
	gtk_widget_set_vexpand ((GtkWidget*) _tmp38_, FALSE);
	_tmp39_ = frame_grid;
	_tmp40_ = toolbar;
	gtk_container_add ((GtkContainer*) _tmp39_, (GtkWidget*) _tmp40_);
	_tmp41_ = (GtkToolButton*) gtk_tool_button_new (NULL, NULL);
	g_object_ref_sink (_tmp41_);
	the_add_button = _tmp41_;
	gtk_tool_button_set_icon_name (the_add_button, "list-add-symbolic");
	_tmp42_ = gtk_widget_get_style_context ((GtkWidget*) the_add_button);
	gtk_style_context_add_class (_tmp42_, GTK_STYLE_CLASS_RAISED);
	gtk_tool_item_set_is_important ((GtkToolItem*) the_add_button, TRUE);
	_tmp43_ = toolbar;
	gtk_container_add ((GtkContainer*) _tmp43_, (GtkWidget*) the_add_button);
	g_signal_connect_object (the_add_button, "clicked", (GCallback) _contacts_avatar_dialog_select_avatar_file_cb_gtk_tool_button_clicked, self, 0);
	_tmp44_ = (GtkToolButton*) gtk_tool_button_new (NULL, NULL);
	g_object_ref_sink (_tmp44_);
	_data42_->webcam_button = _tmp44_;
	gtk_tool_button_set_icon_name (_data42_->webcam_button, "camera-photo-symbolic");
	_tmp45_ = gtk_widget_get_style_context ((GtkWidget*) _data42_->webcam_button);
	gtk_style_context_add_class (_tmp45_, GTK_STYLE_CLASS_RAISED);
	gtk_tool_item_set_is_important ((GtkToolItem*) _data42_->webcam_button, TRUE);
	gtk_widget_set_sensitive ((GtkWidget*) _data42_->webcam_button, FALSE);
	_tmp46_ = toolbar;
	gtk_container_add ((GtkContainer*) _tmp46_, (GtkWidget*) _data42_->webcam_button);
	_tmp47_ = (CheeseCameraDeviceMonitor*) cheese_camera_device_monitor_new ();
	_g_object_unref0 (self->priv->camera_monitor);
	self->priv->camera_monitor = _tmp47_;
	_tmp48_ = self->priv->camera_monitor;
	g_signal_connect_data (_tmp48_, "added", (GCallback) ___lambda61__cheese_camera_device_monitor_added, block42_data_ref (_data42_), (GClosureNotify) block42_data_unref, 0);
	_tmp49_ = self->priv->camera_monitor;
	g_signal_connect_data (_tmp49_, "removed", (GCallback) ___lambda62__cheese_camera_device_monitor_removed, block42_data_ref (_data42_), (GClosureNotify) block42_data_unref, 0);
	_tmp50_ = self->priv->camera_monitor;
	cheese_camera_device_monitor_coldplug (_tmp50_);
	g_signal_connect_object (_data42_->webcam_button, "clicked", (GCallback) ___lambda63__gtk_tool_button_clicked, self, 0);
	_tmp51_ = frame_grid;
	gtk_widget_show_all ((GtkWidget*) _tmp51_);
	_tmp52_ = self->priv->notebook;
	_tmp53_ = frame_grid;
	gtk_notebook_append_page (_tmp52_, (GtkWidget*) _tmp53_, NULL);
	_tmp54_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp54_);
	_g_object_unref0 (frame_grid);
	frame_grid = _tmp54_;
	_tmp55_ = frame_grid;
	gtk_orientable_set_orientation ((GtkOrientable*) _tmp55_, GTK_ORIENTATION_VERTICAL);
	_tmp56_ = (GtkToolbar*) gtk_toolbar_new ();
	g_object_ref_sink (_tmp56_);
	_g_object_unref0 (toolbar);
	toolbar = _tmp56_;
	_tmp57_ = toolbar;
	_tmp58_ = gtk_widget_get_style_context ((GtkWidget*) _tmp57_);
	gtk_style_context_add_class (_tmp58_, GTK_STYLE_CLASS_INLINE_TOOLBAR);
	_tmp59_ = toolbar;
	gtk_toolbar_set_icon_size (_tmp59_, GTK_ICON_SIZE_MENU);
	_tmp60_ = toolbar;
	gtk_widget_set_vexpand ((GtkWidget*) _tmp60_, FALSE);
	_tmp61_ = frame_grid;
	_tmp62_ = toolbar;
	gtk_grid_attach (_tmp61_, (GtkWidget*) _tmp62_, 0, 1, 1, 1);
	_tmp63_ = (GtkToolButton*) gtk_tool_button_new (NULL, NULL);
	g_object_ref_sink (_tmp63_);
	accept_button = _tmp63_;
	_tmp64_ = accept_button;
	gtk_tool_button_set_icon_name (_tmp64_, "object-select-symbolic");
	_tmp65_ = accept_button;
	_tmp66_ = gtk_widget_get_style_context ((GtkWidget*) _tmp65_);
	gtk_style_context_add_class (_tmp66_, GTK_STYLE_CLASS_RAISED);
	_tmp67_ = accept_button;
	gtk_tool_item_set_is_important ((GtkToolItem*) _tmp67_, TRUE);
	_tmp68_ = toolbar;
	_tmp69_ = accept_button;
	gtk_container_add ((GtkContainer*) _tmp68_, (GtkWidget*) _tmp69_);
	_tmp70_ = accept_button;
	g_signal_connect_object (_tmp70_, "clicked", (GCallback) ___lambda64__gtk_tool_button_clicked, self, 0);
	_tmp71_ = (GtkToolButton*) gtk_tool_button_new (NULL, NULL);
	g_object_ref_sink (_tmp71_);
	cancel_button = _tmp71_;
	_tmp72_ = cancel_button;
	gtk_tool_button_set_icon_name (_tmp72_, "edit-undo-symbolic");
	_tmp73_ = cancel_button;
	_tmp74_ = gtk_widget_get_style_context ((GtkWidget*) _tmp73_);
	gtk_style_context_add_class (_tmp74_, GTK_STYLE_CLASS_RAISED);
	_tmp75_ = cancel_button;
	gtk_tool_item_set_is_important ((GtkToolItem*) _tmp75_, TRUE);
	_tmp76_ = toolbar;
	_tmp77_ = cancel_button;
	gtk_container_add ((GtkContainer*) _tmp76_, (GtkWidget*) _tmp77_);
	_tmp78_ = cancel_button;
	g_signal_connect_object (_tmp78_, "clicked", (GCallback) ___lambda65__gtk_tool_button_clicked, self, 0);
	_tmp79_ = frame_grid;
	gtk_widget_show_all ((GtkWidget*) _tmp79_);
	_tmp80_ = self->priv->notebook;
	_tmp81_ = frame_grid;
	gtk_notebook_append_page (_tmp80_, (GtkWidget*) _tmp81_, NULL);
	_tmp82_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp82_);
	_g_object_unref0 (frame_grid);
	frame_grid = _tmp82_;
	_tmp83_ = frame_grid;
	gtk_orientable_set_orientation ((GtkOrientable*) _tmp83_, GTK_ORIENTATION_VERTICAL);
	_tmp84_ = (CheeseWidget*) cheese_widget_new ();
	g_object_ref_sink (_tmp84_);
	_g_object_unref0 (self->priv->cheese);
	self->priv->cheese = _tmp84_;
	_tmp85_ = self->priv->cheese;
	gtk_widget_set_vexpand ((GtkWidget*) _tmp85_, TRUE);
	_tmp86_ = self->priv->cheese;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp86_, TRUE);
	_tmp87_ = self->priv->cheese;
	gtk_widget_set_no_show_all ((GtkWidget*) _tmp87_, TRUE);
	_tmp88_ = frame_grid;
	_tmp89_ = self->priv->cheese;
	gtk_container_add ((GtkContainer*) _tmp88_, (GtkWidget*) _tmp89_);
	_tmp90_ = (CheeseFlash*) cheese_flash_new ((GtkWidget*) self);
	g_object_ref_sink (_tmp90_);
	_g_object_unref0 (self->priv->flash);
	self->priv->flash = _tmp90_;
	_tmp91_ = (GtkToolbar*) gtk_toolbar_new ();
	g_object_ref_sink (_tmp91_);
	_g_object_unref0 (toolbar);
	toolbar = _tmp91_;
	_tmp92_ = toolbar;
	_tmp93_ = gtk_widget_get_style_context ((GtkWidget*) _tmp92_);
	gtk_style_context_add_class (_tmp93_, GTK_STYLE_CLASS_INLINE_TOOLBAR);
	_tmp94_ = toolbar;
	gtk_toolbar_set_icon_size (_tmp94_, GTK_ICON_SIZE_MENU);
	_tmp95_ = toolbar;
	gtk_widget_set_vexpand ((GtkWidget*) _tmp95_, FALSE);
	_tmp96_ = frame_grid;
	_tmp97_ = toolbar;
	gtk_grid_attach (_tmp96_, (GtkWidget*) _tmp97_, 0, 1, 1, 1);
	_tmp98_ = (GtkToolButton*) gtk_tool_button_new (NULL, NULL);
	g_object_ref_sink (_tmp98_);
	_g_object_unref0 (accept_button);
	accept_button = _tmp98_;
	_tmp99_ = accept_button;
	gtk_tool_button_set_icon_name (_tmp99_, "object-select-symbolic");
	_tmp100_ = accept_button;
	_tmp101_ = gtk_widget_get_style_context ((GtkWidget*) _tmp100_);
	gtk_style_context_add_class (_tmp101_, GTK_STYLE_CLASS_RAISED);
	_tmp102_ = accept_button;
	gtk_tool_item_set_is_important ((GtkToolItem*) _tmp102_, TRUE);
	_tmp103_ = toolbar;
	_tmp104_ = accept_button;
	gtk_container_add ((GtkContainer*) _tmp103_, (GtkWidget*) _tmp104_);
	_tmp105_ = accept_button;
	g_signal_connect_object (_tmp105_, "clicked", (GCallback) ___lambda66__gtk_tool_button_clicked, self, 0);
	_tmp106_ = (GtkToolButton*) gtk_tool_button_new (NULL, NULL);
	g_object_ref_sink (_tmp106_);
	_g_object_unref0 (cancel_button);
	cancel_button = _tmp106_;
	_tmp107_ = cancel_button;
	gtk_tool_button_set_icon_name (_tmp107_, "edit-undo-symbolic");
	_tmp108_ = cancel_button;
	_tmp109_ = gtk_widget_get_style_context ((GtkWidget*) _tmp108_);
	gtk_style_context_add_class (_tmp109_, GTK_STYLE_CLASS_RAISED);
	_tmp110_ = cancel_button;
	gtk_tool_item_set_is_important ((GtkToolItem*) _tmp110_, TRUE);
	_tmp111_ = toolbar;
	_tmp112_ = cancel_button;
	gtk_container_add ((GtkContainer*) _tmp111_, (GtkWidget*) _tmp112_);
	_tmp113_ = cancel_button;
	g_signal_connect_object (_tmp113_, "clicked", (GCallback) ___lambda68__gtk_tool_button_clicked, self, 0);
	_tmp114_ = frame_grid;
	gtk_widget_show_all ((GtkWidget*) _tmp114_);
	_tmp115_ = self->priv->notebook;
	_tmp116_ = frame_grid;
	gtk_notebook_append_page (_tmp115_, (GtkWidget*) _tmp116_, NULL);
	_tmp117_ = self->priv->notebook;
	gtk_notebook_set_current_page (_tmp117_, 0);
	g_signal_connect_object ((GtkDialog*) self, "response", (GCallback) ___lambda69__gtk_dialog_response, self, 0);
	contacts_avatar_dialog_update_grid (self);
	gtk_widget_show_all ((GtkWidget*) grid);
	_g_object_unref0 (cancel_button);
	_g_object_unref0 (accept_button);
	_g_object_unref0 (the_add_button);
	_g_object_unref0 (toolbar);
	_g_object_unref0 (scrolled);
	_g_object_unref0 (frame_grid);
	_g_object_unref0 (frame);
	_g_object_unref0 (label);
	_g_object_unref0 (container);
	_g_object_unref0 (grid);
	block42_data_unref (_data42_);
	_data42_ = NULL;
	return self;
}


ContactsAvatarDialog* contacts_avatar_dialog_new (ContactsContact* contact) {
	return contacts_avatar_dialog_construct (CONTACTS_TYPE_AVATAR_DIALOG, contact);
}


static void contacts_avatar_dialog_class_init (ContactsAvatarDialogClass * klass) {
	contacts_avatar_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ContactsAvatarDialogPrivate));
	G_OBJECT_CLASS (klass)->finalize = contacts_avatar_dialog_finalize;
	g_signal_new ("set_avatar", CONTACTS_TYPE_AVATAR_DIALOG, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, G_TYPE_ICON);
}


static void contacts_avatar_dialog_instance_init (ContactsAvatarDialog * self) {
	self->priv = CONTACTS_AVATAR_DIALOG_GET_PRIVATE (self);
}


static void contacts_avatar_dialog_finalize (GObject* obj) {
	ContactsAvatarDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_TYPE_AVATAR_DIALOG, ContactsAvatarDialog);
	_g_object_unref0 (self->priv->thumbnail_factory);
	_g_object_unref0 (self->priv->contact);
	_g_object_unref0 (self->priv->notebook);
	_g_object_unref0 (self->priv->crop_area);
	_g_object_unref0 (self->priv->view_grid);
	_g_object_unref0 (self->priv->main_frame);
	_g_object_unref0 (self->priv->flash);
	_g_object_unref0 (self->priv->camera_monitor);
	_g_object_unref0 (self->priv->cheese);
	_g_object_unref0 (self->priv->new_pixbuf);
	G_OBJECT_CLASS (contacts_avatar_dialog_parent_class)->finalize (obj);
}


GType contacts_avatar_dialog_get_type (void) {
	static volatile gsize contacts_avatar_dialog_type_id__volatile = 0;
	if (g_once_init_enter (&contacts_avatar_dialog_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ContactsAvatarDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_avatar_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsAvatarDialog), 0, (GInstanceInitFunc) contacts_avatar_dialog_instance_init, NULL };
		GType contacts_avatar_dialog_type_id;
		contacts_avatar_dialog_type_id = g_type_register_static (GTK_TYPE_DIALOG, "ContactsAvatarDialog", &g_define_type_info, 0);
		g_once_init_leave (&contacts_avatar_dialog_type_id__volatile, contacts_avatar_dialog_type_id);
	}
	return contacts_avatar_dialog_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



