/* backend.c generated by valac 0.14.0.1-60fb, the Vala compiler
 * generated from backend.vala, do not modify */

/*
 * Copyright (C) 2010 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Travis Reitter <travis.reitter@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>


#define FOLKS_TYPE_BACKEND (folks_backend_get_type ())
#define FOLKS_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_BACKEND, FolksBackend))
#define FOLKS_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_BACKEND, FolksBackendClass))
#define FOLKS_IS_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_BACKEND))
#define FOLKS_IS_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_BACKEND))
#define FOLKS_BACKEND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_BACKEND, FolksBackendClass))

typedef struct _FolksBackend FolksBackend;
typedef struct _FolksBackendClass FolksBackendClass;
typedef struct _FolksBackendPrivate FolksBackendPrivate;

#define FOLKS_TYPE_PERSONA_STORE (folks_persona_store_get_type ())
#define FOLKS_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_PERSONA_STORE, FolksPersonaStore))
#define FOLKS_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_PERSONA_STORE, FolksPersonaStoreClass))
#define FOLKS_IS_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_PERSONA_STORE))
#define FOLKS_IS_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_PERSONA_STORE))
#define FOLKS_PERSONA_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_PERSONA_STORE, FolksPersonaStoreClass))

typedef struct _FolksPersonaStore FolksPersonaStore;
typedef struct _FolksPersonaStoreClass FolksPersonaStoreClass;

struct _FolksBackend {
	GObject parent_instance;
	FolksBackendPrivate * priv;
};

struct _FolksBackendClass {
	GObjectClass parent_class;
	void (*prepare) (FolksBackend* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*prepare_finish) (FolksBackend* self, GAsyncResult* _res_, GError** error);
	void (*unprepare) (FolksBackend* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*unprepare_finish) (FolksBackend* self, GAsyncResult* _res_, GError** error);
	gboolean (*get_is_prepared) (FolksBackend* self);
	gboolean (*get_is_quiescent) (FolksBackend* self);
	const gchar* (*get_name) (FolksBackend* self);
	GeeMap* (*get_persona_stores) (FolksBackend* self);
};


static gpointer folks_backend_parent_class = NULL;

GType folks_backend_get_type (void) G_GNUC_CONST;
GType folks_persona_store_get_type (void) G_GNUC_CONST;
enum  {
	FOLKS_BACKEND_DUMMY_PROPERTY,
	FOLKS_BACKEND_IS_PREPARED,
	FOLKS_BACKEND_IS_QUIESCENT,
	FOLKS_BACKEND_NAME,
	FOLKS_BACKEND_PERSONA_STORES
};
void folks_backend_prepare (FolksBackend* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_backend_prepare_finish (FolksBackend* self, GAsyncResult* _res_, GError** error);
void folks_backend_unprepare (FolksBackend* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_backend_unprepare_finish (FolksBackend* self, GAsyncResult* _res_, GError** error);
FolksBackend* folks_backend_construct (GType object_type);
gboolean folks_backend_get_is_prepared (FolksBackend* self);
gboolean folks_backend_get_is_quiescent (FolksBackend* self);
const gchar* folks_backend_get_name (FolksBackend* self);
GeeMap* folks_backend_get_persona_stores (FolksBackend* self);
static void _vala_folks_backend_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);


void folks_backend_prepare (FolksBackend* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FOLKS_BACKEND_GET_CLASS (self)->prepare (self, _callback_, _user_data_);
}


void folks_backend_prepare_finish (FolksBackend* self, GAsyncResult* _res_, GError** error) {
	FOLKS_BACKEND_GET_CLASS (self)->prepare_finish (self, _res_, error);
}


void folks_backend_unprepare (FolksBackend* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FOLKS_BACKEND_GET_CLASS (self)->unprepare (self, _callback_, _user_data_);
}


void folks_backend_unprepare_finish (FolksBackend* self, GAsyncResult* _res_, GError** error) {
	FOLKS_BACKEND_GET_CLASS (self)->unprepare_finish (self, _res_, error);
}


FolksBackend* folks_backend_construct (GType object_type) {
	FolksBackend * self = NULL;
	self = (FolksBackend*) g_object_new (object_type, NULL);
	return self;
}


gboolean folks_backend_get_is_prepared (FolksBackend* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return FOLKS_BACKEND_GET_CLASS (self)->get_is_prepared (self);
}


gboolean folks_backend_get_is_quiescent (FolksBackend* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return FOLKS_BACKEND_GET_CLASS (self)->get_is_quiescent (self);
}


const gchar* folks_backend_get_name (FolksBackend* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return FOLKS_BACKEND_GET_CLASS (self)->get_name (self);
}


GeeMap* folks_backend_get_persona_stores (FolksBackend* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return FOLKS_BACKEND_GET_CLASS (self)->get_persona_stores (self);
}


static void folks_backend_class_init (FolksBackendClass * klass) {
	folks_backend_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->get_property = _vala_folks_backend_get_property;
	/**
	   * Whether {@link Backend.prepare} has successfully completed for this
	   * backend.
	   *
	   * @since 0.3.0
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKEND_IS_PREPARED, g_param_spec_boolean ("is-prepared", "is-prepared", "is-prepared", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * Whether the backend has reached a quiescent state. This will happen at some
	   * point after {@link Backend.prepare} has successfully completed for the
	   * backend. A backend is in a quiescent state when all the
	   * {@link PersonaStore}s that it originally knows about have been loaded.
	   *
	   * It's guaranteed that this property's value will only ever change after
	   * {@link Backend.is_prepared} has changed to `true`.
	   *
	   * When {@link Backend.unprepare} is called, this will be reset to `false`.
	   *
	   * @since 0.6.2
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKEND_IS_QUIESCENT, g_param_spec_boolean ("is-quiescent", "is-quiescent", "is-quiescent", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * A unique name for the backend.
	   *
	   * This will be used to identify the backend, and should also be used as the
	   * {@link PersonaStore.type_id} of the {@link PersonaStore}s used by the
	   * backend.
	   *
	   * This is guaranteed to always be available; even before
	   * {@link Backend.prepare} is called.
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKEND_NAME, g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * The {@link PersonaStore}s in use by the backend.
	   *
	   * A backend may expose {@link Persona}s from multiple servers or accounts
	   * (for example), so may have a {@link PersonaStore} for each.
	   *
	   * @since 0.5.1
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKEND_PERSONA_STORES, g_param_spec_object ("persona-stores", "persona-stores", "persona-stores", GEE_TYPE_MAP, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * Emitted when a {@link PersonaStore} is added to the backend.
	   *
	   * This will not be emitted until after {@link Backend.prepare} has been
	   * called.
	   *
	   * @param store the {@link PersonaStore}
	   */
	g_signal_new ("persona_store_added", FOLKS_TYPE_BACKEND, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, FOLKS_TYPE_PERSONA_STORE);
	/**
	   * Emitted when a {@link PersonaStore} is removed from the backend.
	   *
	   * This will not be emitted until after {@link Backend.prepare} has been
	   * called.
	   *
	   * @param store the {@link PersonaStore}
	   */
	g_signal_new ("persona_store_removed", FOLKS_TYPE_BACKEND, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, FOLKS_TYPE_PERSONA_STORE);
}


static void folks_backend_instance_init (FolksBackend * self) {
}


/**
 * A single backend to libfolks, such as Telepathy or evolution-data-server.
 * Each backend provides {@link Persona}s which are aggregated to form
 * {@link Individual}s.
 *
 * After creating a Backend instance, you must connect to the
 * {@link Backend.persona_store_added} and
 * {@link Backend.persona_store_removed} signals, //then// call
 * {@link Backend.prepare}, otherwise a race condition may occur between
 * emission of {@link Backend.persona_store_added} and your code connecting to
 * it.
 */
GType folks_backend_get_type (void) {
	static volatile gsize folks_backend_type_id__volatile = 0;
	if (g_once_init_enter (&folks_backend_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksBackendClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_backend_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksBackend), 0, (GInstanceInitFunc) folks_backend_instance_init, NULL };
		GType folks_backend_type_id;
		folks_backend_type_id = g_type_register_static (G_TYPE_OBJECT, "FolksBackend", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&folks_backend_type_id__volatile, folks_backend_type_id);
	}
	return folks_backend_type_id__volatile;
}


static void _vala_folks_backend_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	FolksBackend * self;
	self = FOLKS_BACKEND (object);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



