/* GTK - The GIMP Toolkit
 *
 * Copyright (C) 2011 Javier Jardón
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library.  If not, see <http://www.gnu.org/licenses/>.
 */


#ifndef __GTK_CONTAINER_PRIVATE_H__
#define __GTK_CONTAINER_PRIVATE_H__

G_BEGIN_DECLS


void     _gtk_container_queue_resize           (GtkContainer *container);
void     _gtk_container_resize_invalidate      (GtkContainer *container);
void     _gtk_container_clear_resize_widgets   (GtkContainer *container);
gchar*   _gtk_container_child_composite_name   (GtkContainer *container,
                                                GtkWidget    *child);
void     _gtk_container_dequeue_resize_handler (GtkContainer *container);
GList *  _gtk_container_focus_sort             (GtkContainer     *container,
                                                GList            *children,
                                                GtkDirectionType  direction,
                                                GtkWidget        *old_focus);
gboolean _gtk_container_get_need_resize        (GtkContainer *container);
void     _gtk_container_set_need_resize        (GtkContainer *container,
                                                gboolean      need_resize);
gboolean _gtk_container_get_reallocate_redraws (GtkContainer *container);


G_END_DECLS

#endif /* __GTK_CONTAINER_PRIVATE_H__ */
