// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKMM_APPCHOOSERBUTTON_H
#define _GTKMM_APPCHOOSERBUTTON_H


#include <glibmm.h>

/* Copyright (C) 2011 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <gtkmm/appchooser.h>
#include <gtkmm/combobox.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkAppChooserButton GtkAppChooserButton;
typedef struct _GtkAppChooserButtonClass GtkAppChooserButtonClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class AppChooserButton_Class; } // namespace Gtk
namespace Gtk
{

//TODO: The AppChooser content-type is not documented properly: https://bugzilla.gnome.org/show_bug.cgi?id=650012

/** A button to launch an application chooser dialog.
 *
 * This widget lets the user select an application. See the GtkAppChooser base class API.
 *
 * The AppChooserButton widget looks like this:
 * @image html appchooserbutton1.png
 *
 * @ingroup Widgets
 *
 * @newin{3,0}
 */

class AppChooserButton
  : public ComboBox,
    public AppChooser
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef AppChooserButton CppObjectType;
  typedef AppChooserButton_Class CppClassType;
  typedef GtkAppChooserButton BaseObjectType;
  typedef GtkAppChooserButtonClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~AppChooserButton();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class AppChooserButton_Class;
  static CppClassType appchooserbutton_class_;

  // noncopyable
  AppChooserButton(const AppChooserButton&);
  AppChooserButton& operator=(const AppChooserButton&);

protected:
  explicit AppChooserButton(const Glib::ConstructParams& construct_params);
  explicit AppChooserButton(GtkAppChooserButton* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  GtkAppChooserButton*       gobj()       { return reinterpret_cast<GtkAppChooserButton*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const GtkAppChooserButton* gobj() const { return reinterpret_cast<GtkAppChooserButton*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  virtual void on_custom_item_activated(const Glib::ustring& item_name);


private:

  
public:

  /** Creates a new app-chooser button for applications that can handle content of the given type.
   *
   * @param content_type The content type to show applications for
   */
    explicit AppChooserButton(const Glib::ustring& content_type);


  void append_separator();
  
  void append_custom_item(const Glib::ustring& name, const Glib::ustring& label, const Glib::RefPtr<Gio::Icon>& icon);
  
  void set_active_custom_item(const Glib::ustring& name);
  
  void set_show_dialog_item(bool setting =  true);
  
  bool get_show_dialog_item() const;
  
  void set_heading(const Glib::ustring& heading);
  
  Glib::ustring get_heading() const;

  
  /**
   * @par Prototype:
   * <tt>void on_my_%custom_item_activated(const Glib::ustring& item_name)</tt>
   */

  Glib::SignalProxy1< void,const Glib::ustring& > signal_custom_item_activated();


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the combobox should include an item that triggers a GtkAppChooserDialog.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_show_dialog_item() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the combobox should include an item that triggers a GtkAppChooserDialog.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_show_dialog_item() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The text to show at the top of the dialog.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Glib::ustring> property_heading() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The text to show at the top of the dialog.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_heading() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


};


} // namespace Gtk


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gtk::AppChooserButton
   */
  Gtk::AppChooserButton* wrap(GtkAppChooserButton* object, bool take_copy = false);
} //namespace Glib


#endif /* _GTKMM_APPCHOOSERBUTTON_H */

