// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GDKMM_PIXBUF_H
#define _GDKMM_PIXBUF_H

#include <gdkmmconfig.h>


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* Copyright (C) 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

// This is for including the config header before any code (such as
// the #ifndef GDKMM_DISABLE_DEPRECATED in deprecated classes) is generated:


#include <vector>

//#include <gdkmm/window.h>
#include <gdkmm/pixbufformat.h>
#include <gdkmm/types.h>
#include <giomm/inputstream.h>
#include <giomm/icon.h>
#include <cairomm/surface.h>
#include <glibmm/error.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GdkPixbuf GdkPixbuf;
typedef struct _GdkPixbufClass GdkPixbufClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gdk
{ class Pixbuf_Class; } // namespace Gdk
namespace Gdk
{

class Window;


/** @addtogroup gdkmmEnums gdkmm Enums and Flags */

/**
 * @ingroup gdkmmEnums
 */
enum Colorspace
{
  COLORSPACE_RGB
};

} // namespace Gdk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gdk::Colorspace> : public Glib::Value_Enum<Gdk::Colorspace>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gdk
{

/**
 * @ingroup gdkmmEnums
 */
enum InterpType
{
  INTERP_NEAREST,
  INTERP_TILES,
  INTERP_BILINEAR,
  INTERP_HYPER
};

} // namespace Gdk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gdk::InterpType> : public Glib::Value_Enum<Gdk::InterpType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gdk
{

/**
 * @ingroup gdkmmEnums
 */
enum PixbufAlphaMode
{
  PIXBUF_ALPHA_BILEVEL,
  PIXBUF_ALPHA_FULL
};

} // namespace Gdk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gdk::PixbufAlphaMode> : public Glib::Value_Enum<Gdk::PixbufAlphaMode>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gdk
{

/**
 * @ingroup gdkmmEnums
 */
enum PixbufRotation
{
  PIXBUF_ROTATE_NONE = 0,
  PIXBUF_ROTATE_COUNTERCLOCKWISE = 90,
  PIXBUF_ROTATE_UPSIDEDOWN = 180,
  PIXBUF_ROTATE_CLOCKWISE = 270
};

} // namespace Gdk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gdk::PixbufRotation> : public Glib::Value_Enum<Gdk::PixbufRotation>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gdk
{


/** Exception class for Gdk::Pixbuf errors.
 */
class PixbufError : public Glib::Error
{
public:
  enum Code
  {
    CORRUPT_IMAGE,
    INSUFFICIENT_MEMORY,
    BAD_OPTION,
    UNKNOWN_TYPE,
    UNSUPPORTED_OPERATION,
    FAILED
  };

  PixbufError(Code error_code, const Glib::ustring& error_message);
  explicit PixbufError(GError* gobject);
  Code code() const;

#ifndef DOXYGEN_SHOULD_SKIP_THIS
private:

  static void throw_func(GError* gobject);

  friend void wrap_init(); // uses throw_func()

  #endif //DOXYGEN_SHOULD_SKIP_THIS
};

} // namespace Gdk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gdk::PixbufError::Code> : public Glib::Value_Enum<Gdk::PixbufError::Code>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gdk
{


class Pixbuf
  : public Glib::Object,
    public Gio::Icon
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Pixbuf CppObjectType;
  typedef Pixbuf_Class CppClassType;
  typedef GdkPixbuf BaseObjectType;
  typedef GdkPixbufClass BaseClassType;

private:  friend class Pixbuf_Class;
  static CppClassType pixbuf_class_;

private:
  // noncopyable
  Pixbuf(const Pixbuf&);
  Pixbuf& operator=(const Pixbuf&);

protected:
  explicit Pixbuf(const Glib::ConstructParams& construct_params);
  explicit Pixbuf(GdkPixbuf* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Pixbuf();

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GdkPixbuf*       gobj()       { return reinterpret_cast<GdkPixbuf*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GdkPixbuf* gobj() const { return reinterpret_cast<GdkPixbuf*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GdkPixbuf* gobj_copy();

private:

  
protected:

  //TODO: Throw an exception when the C function returns NULL?
  /** Transfers image data from a #GdkWindow and converts it to an RGB(A)
   * representation inside a Gdk::Pixbuf. In other words, copies
   * image data from a server-side drawable to a client-side RGB(A) buffer.
   * This allows you to efficiently read individual pixels on the client side.
   *
   * This function will create an RGB pixbuf with 8 bits per channel with
   * the same size specified by the @a width and @a height arguments. The pixbuf
   * will contain an alpha channel if the @a window contains one.
   *
   * If the window is off the screen, then there is no image data in the
   * obscured/offscreen regions to be placed in the pixbuf. The contents of
   * portions of the pixbuf corresponding to the offscreen region are undefined.
   *
   * If the window you're obtaining data from is partially obscured by
   * other windows, then the contents of the pixbuf areas corresponding
   * to the obscured regions are undefined.
   *
   * If the window is not mapped (typically because it's iconified/minimized
   * or not on the current workspace), then an invalid object will be returned.
   *
   * If memory can't be allocated for the return value, an invalid object will be returned
   * instead.
   *
   * @param src Source window.
   * @param src_x Source X coordinate within the window.
   * @param src_y Source Y coordinate within the window.
   * @param width Width in pixels of region to get.
   * @param height Height in pixels of region to get.
   *
   * @newin{2,12}
   */
   Pixbuf(const Glib::RefPtr<Window>& src,
         int src_x, int src_y, int width, int height);
   

   //TODO: Documentation:
   /** @newin{2,30}
    */
   Pixbuf(const Cairo::RefPtr<Cairo::Surface>& src,
         int src_x, int src_y, int width, int height);
   

public:
  typedef sigc::slot<void, const guint8*> SlotDestroyData;

  /** Transfers image data from a #GdkWindow and converts it to an RGB(A)
   * representation inside a Gdk::Pixbuf. In other words, copies
   * image data from a server-side drawable to a client-side RGB(A) buffer.
   * This allows you to efficiently read individual pixels on the client side.
   *
   * This function will create an RGB pixbuf with 8 bits per channel with
   * the same size specified by the @a width and @a height arguments. The pixbuf
   * will contain an alpha channel if the @a window contains one.
   *
   * If the window is off the screen, then there is no image data in the
   * obscured/offscreen regions to be placed in the pixbuf. The contents of
   * portions of the pixbuf corresponding to the offscreen region are undefined.
   *
   * If the window you're obtaining data from is partially obscured by
   * other windows, then the contents of the pixbuf areas corresponding
   * to the obscured regions are undefined.
   *
   * If the window is not mapped (typically because it's iconified/minimized
   * or not on the current workspace), then an invalid object will be returned.
   *
   * If memory can't be allocated for the return value, an invalid object will be returned
   * instead.
   *
   * @param src Source window.
   * @param src_x Source X coordinate within the window.
   * @param src_y Source Y coordinate within the window.
   * @param width Width in pixels of region to get.
   * @param height Height in pixels of region to get.
   *
   * @newin{2,12}
   */
  
  static Glib::RefPtr<Pixbuf> create(const Glib::RefPtr<Window>& src, int src_x, int src_y, int width, int height);


   //TODO: Documentation
   /**
    * @newin{2,30}
    */
  
  static Glib::RefPtr<Pixbuf> create(const Cairo::RefPtr<Cairo::Surface>& src, int src_x, int src_y, int width, int height);


  Glib::RefPtr<Pixbuf> copy() const;

  
  static Glib::RefPtr<Pixbuf> create(Colorspace colorspace, bool has_alpha, int bits_per_sample, int width, int height);

  
  /** 
   * @param src_pixbuf A Gdk::Pixbuf.
   * @param src_x X coord in @a src_pixbuf.
   * @param src_y Y coord in @a src_pixbuf.
   * @param width Width of region in @a src_pixbuf.
   * @param height Height of region in @a src_pixbuf.
   */
  static Glib::RefPtr<Pixbuf> create_subpixbuf(const Glib::RefPtr<Pixbuf>& src_pixbuf, int src_x, int src_y, int width, int height);

  
  /** Creates a new pixbuf by loading an image from a file. The file format is detected automatically.
   * @param filename The path to the pixbuf file.
   *
   * @throw Glib::FileError
   * @throw Gdk::PixbufError
   */
  static Glib::RefPtr<Pixbuf> create_from_file(const std::string& filename);

  
  /** Creates a new pixbuf by loading an image from a file. The file format is detected automatically.
   * The image will be scaled to fit in the requested size.
   * @param filename The path to the pixbuf file.
   * @param width The desired width
   * @param height The desired height
   * @param preserve_aspect_ratio: Whether the image's aspect ratio will be preserved when scaling.
   *
   * @throw Glib::FileError
   * @throw Gdk::PixbufError
   */
  static Glib::RefPtr<Pixbuf> create_from_file(const std::string& filename, int width, int height, bool preserve_aspect_ratio =  true);
   //gdk_pixbuf_new_from_file_at_size() just calls gdk_pixbuf_new_from_file_at_scale().

  /** Creates a new Gdk::Pixbuf out of in-memory image data.
   * Currently only RGB images with 8 bits per sample are supported.
   *
   * @param data %Image data in 8-bit/sample packed format.
   * @param colorspace Colorspace for the image data.
   * @param has_alpha Whether the data has an opacity channel.
   * @param bits_per_sample Number of bits per sample.
   * @param width Width of the image in pixels.
   * @param height Height of the image in pixels.
   * @param rowstride Distance in bytes between rows.
   * @return A newly-created Gdk::Pixbuf object.
   */
  static Glib::RefPtr<Pixbuf> create_from_data(const guint8* data, Colorspace colorspace,
                                               bool has_alpha, int bits_per_sample,
                                               int width, int height, int rowstride);

  /** Creates a new Gdk::Pixbuf out of in-memory image data.
   * Currently only RGB images with 8 bits per sample are supported.
   *
   * @param data %Image data in 8-bit/sample packed format.
   * @param colorspace Colorspace for the image data.
   * @param has_alpha Whether the data has an opacity channel.
   * @param bits_per_sample Number of bits per sample.
   * @param width Width of the image in pixels.
   * @param height Height of the image in pixels.
   * @param rowstride Distance in bytes between rows.
   * @param destroy_slot Slot used to free the data when the pixbuf's
   * reference count drops to zero.
   * @return A newly-created Gdk::Pixbuf object.
   */
  static Glib::RefPtr<Pixbuf> create_from_data(const guint8* data, Colorspace colorspace,
                                               bool has_alpha, int bits_per_sample,
                                               int width, int height, int rowstride,
                                               const SlotDestroyData& destroy_slot);

  
  static Glib::RefPtr<Pixbuf> create_from_xpm_data(const char *const * data);

  
  /** Create a Gdk::Pixbuf from a flat representation that is suitable for
   * storing as inline data in a program.  This is useful if you want to ship a
   * program with images, but don't want to depend on any external files.
   *
   * GTK+ ships with a program called <tt>gdk-pixbuf-csource</tt> which allows
   * for conversion of GdkPixbufs into such a inline representation. In almost
   * all cases, you should pass the <tt>--raw</tt> flag to
   * <tt>gdk-pixbuf-csource</tt>. A sample invocation would be:
   *
   * <tt>gdk-pixbuf-csource --raw --name=myimage_inline myimage.png</tt>
   *
   * For the typical case where the inline pixbuf is read-only static data, you
   * don't need to copy the pixel data unless you intend to write to it, so you
   * can pass <tt>false</tt> for @a copy_pixels. (If you pass <tt>--rle</tt> to
   * <tt>gdk-pixbuf-csource</tt>, a copy will be made even if @a copy_pixels is
   * <tt>false</tt>, so using this option is generally a bad idea.)
   *
   * If you create a pixbuf from const inline data compiled into your program,
   * it's probably safe to ignore errors, since things will always succeed. For
   * non-const inline data, you could get out of memory. For untrusted inline
   * data located at runtime, you could have corrupt inline data in addition.
   *
   * @param data_length Length in bytes of the @a data argument.
   * @param data Byte data containing a serialized GdkPixdata structure.
   * @param copy_pixels Whether to copy the pixel data, or use direct pointers
   * to @a data for the resulting pixbuf.
   * @throw Gdk::PixbufError
   */
  static Glib::RefPtr<Pixbuf> create_from_inline(int data_length, const guint8* data, bool copy_pixels =  false);

  
  static Glib::RefPtr<Pixbuf> create_from_stream(const Glib::RefPtr<Gio::InputStream>& stream, const Glib::RefPtr<Gio::Cancellable>& cancelable);
  static Glib::RefPtr<Pixbuf> create_from_stream(const Glib::RefPtr<Gio::InputStream>& stream);

  
  static Glib::RefPtr<Pixbuf> create_from_stream_at_scale(const Glib::RefPtr<Gio::InputStream>& stream, int width, int height, bool preserve_aspect_ratio, const Glib::RefPtr<Gio::Cancellable>& cancelable);
  static Glib::RefPtr<Pixbuf> create_from_stream_at_scale(const Glib::RefPtr<Gio::InputStream>& stream, int width, int height, bool preserve_aspect_ratio);


  Colorspace get_colorspace() const;

  
  int get_n_channels() const;
  
  bool get_has_alpha() const;
  
  int get_bits_per_sample() const;
  
  guint8* get_pixels() const;
  
  int get_width() const;
  
  int get_height() const;
  
  int get_rowstride() const;

  
  void fill(guint32 pixel);

  /** Saves pixbuf to a file in format @a type.
   * By default, "jpeg", "png", "ico" and "bmp" are possible file formats to
   * save in, but more formats may be installed. The list of all writable
   * formats can be determined by using get_formats() with is_writable().
   *
   * @newin{3,6}
   *
   * @param filename The path of the file to be created.
   * @param type The file type.
   *
   * @throw Glib::FileError
   * @throw Gdk::PixbufError
   */
  void save(const std::string& filename, const Glib::ustring& type) const;

#ifndef GDKMM_DISABLE_DEPRECATED
  /**
   * Same as the const version.
   * @deprecated 3.6: Use the const version instead.
   */
  void save(const std::string& filename, const Glib::ustring& type);
#endif // GDKMM_DISABLE_DEPRECATED

  
  /** Saves pixbuf to a file in format @a type.
   * By default, "jpeg", "png", "ico" and "bmp" are possible file formats to save in, but more formats may be installed.
   * TThe list of all writable formats can be determined by using get_formats() with
   * Gdk::PixbufFormat::is_writable().
   *
   * The @a option_keys and @option_values, if not empty, should contain pairs of strings that modify the save parameters.
   * For example,  "quality", "100".
   *
   * Currently only a few parameters exist. JPEG images can be saved with a "quality" parameter;
   * its value should be in the range [0,100]. Text chunks can be attached to PNG images by specifying parameters of the
   * form "tEXt::key", where key is an ASCII string of length 1-79. The values are UTF-8 encoded strings. ICO images can be
   * saved in depth 16, 24, or 32, by using the "depth" parameter. When the ICO saver is given "x_hot" and "y_hot"
   * parameters, it produces a CUR instead of an ICO.
   *
   * @newin{3,6}
   *
   * @param filename The path of the file to be created.
   * @param type The file type.
   * @param option_keys
   * @param option_values
   *
   * @throw Glib::FileError
   * @throw Gdk::PixbufError
   */
  void save(const std::string& filename, const Glib::ustring& type,
            const std::vector<Glib::ustring>& option_keys,
            const std::vector<Glib::ustring>& option_values) const;

#ifndef GDKMM_DISABLE_DEPRECATED
  /**
   * Same as the const version.
   * @deprecated 3.6: Use the const version instead.
   */
  void save(const std::string& filename, const Glib::ustring& type,
            const std::vector<Glib::ustring>& option_keys,
            const std::vector<Glib::ustring>& option_values);
#endif // GDKMM_DISABLE_DEPRECATED

  
#if 0 //TODO:
  typedef sigc::slot<const char* buf, gsize> SlotSave;

  /** @throws TODO
   */
  void save(const SlotSave& slot, const std::string& type);


  /** A map of option keys to option values.
   */
  typepdef std::map<Glib::ustring, Glib::ustring> SaveValuesMap;

  void save(const SlotSave& slot, const std::string& type, const SaveValuesMap& options);
#endif

/* TODO:
typedef gboolean (*GdkPixbufSaveFunc)   (const gchar *buf,
					 gsize count,
					 GError **error,
					 gpointer data);

gboolean gdk_pixbuf_save_to_callback    (GdkPixbuf  *pixbuf,
					 GdkPixbufSaveFunc save_func,
					 gpointer user_data,
					 const char *type,
					 GError    **error,
					 ...);

gboolean gdk_pixbuf_save_to_callbackv   (GdkPixbuf  *pixbuf,
					 GdkPixbufSaveFunc save_func,
					 gpointer user_data,
					 const char *type,
					 char      **option_keys,
					 char      **option_values,
					 GError    **error);

*/

  /** Saves the pixbuf to a new buffer in format @a type.
   * Note that the buffer is not nul-terminated and may contain embedded nulls.
   * @see save().
   *
   * @newin{3,6}
   *
   * @param buffer This will be set to the address of a new buffer.
   * @param size This will be set to the size of the @a buffer.
   * @param type Currently "jpeg", "png", "ico" or "bmp".
   *
   * @throw Glib::FileError
   * @throw Gdk::PixbufError
   */
  void save_to_buffer(gchar*& buffer, gsize& buffer_size,
                      const Glib::ustring& type = "png") const;

#ifndef GDKMM_DISABLE_DEPRECATED
  /**
   * Same as the const version.
   * @deprecated 3.6: Use the const version instead.
   */
  void save_to_buffer(gchar*& buffer, gsize& buffer_size,
                      const Glib::ustring& type = "png");
#endif // GDKMM_DISABLE_DEPRECATED

  /** Saves the pixbuf to a new buffer in format @a type.
   * Note that the buffer is not nul-terminated and may contain embedded nulls.
   * @see save().
   *
   * @newin{3,6}
   *
   * @param buffer This will be set to the address of a new buffer.
   * @param size This will be set to the size of the @a buffer.
   * @param type Currently "jpeg", "png", "ico" or "bmp".
   *
   * @throw Glib::FileError
   * @throw Gdk::PixbufError
   */
  void save_to_buffer(gchar*& buffer, gsize& buffer_size,
                      const Glib::ustring& type,
                      const std::vector<Glib::ustring>& option_keys,
                      const std::vector<Glib::ustring>& option_values) const;

#ifndef GDKMM_DISABLE_DEPRECATED
  /**
   * Same as the const version.
   * @deprecated 3.6: Use the const version instead.
   */
  void save_to_buffer(gchar*& buffer, gsize& buffer_size,
                      const Glib::ustring& type,
                      const std::vector<Glib::ustring>& option_keys,
                      const std::vector<Glib::ustring>& option_values);
#endif // GDKMM_DISABLE_DEPRECATED

  
  Glib::RefPtr<Gdk::Pixbuf> add_alpha(bool substitute_color, guint8 r, guint8 g, guint8 b) const;

  
  void copy_area(int src_x, int src_y, int width, int height, const Glib::RefPtr<Gdk::Pixbuf>& dest_pixbuf, int dest_x, int dest_y) const;

  
  void saturate_and_pixelate(const Glib::RefPtr<Gdk::Pixbuf>& dest, float saturation, bool pixelate) const;


  void scale(const Glib::RefPtr<Gdk::Pixbuf>& dest, int dest_x, int dest_y, int dest_width, int dest_height, double offset_x, double offset_y, double scale_x, double scale_y, InterpType interp_type) const;

  
  void composite(const Glib::RefPtr<Gdk::Pixbuf>& dest, int dest_x, int dest_y, int dest_width, int dest_height, double offset_x, double offset_y, double scale_x, double scale_y, InterpType interp_type, int overall_alpha) const;

  
  void composite_color(const Glib::RefPtr<Gdk::Pixbuf>& dest, int dest_x, int dest_y, int dest_width, int dest_height, double offset_x, double offset_y, double scale_x, double scale_y, InterpType interp_type, int overall_alpha, int check_x, int check_y, int check_size, guint32 color1, guint32 color2) const;

  
  Glib::RefPtr<Gdk::Pixbuf> scale_simple(int dest_width, int dest_height, InterpType interp_type) const;

  
  Glib::RefPtr<Gdk::Pixbuf> composite_color_simple(int dest_width, int dest_height, InterpType interp_type, int overall_alpha, int check_size, guint32 color1, guint32 color2) const;

  
  Glib::RefPtr<Gdk::Pixbuf> rotate_simple(PixbufRotation angle) const;
  
  Glib::RefPtr<Gdk::Pixbuf> flip(bool horizontal =  true) const;

  //Use Gdk::Drawable::draw_pixbuf() instead of gdk_pixbuf_render_to_drawable(), gdk_pixbuf_render_to_drawable_alpha().
  

  Glib::ustring get_option(const Glib::ustring& key) const;

   //gdk_pixbuf_set_option() is only available when GDK_PIXBUF_ENABLE_BACKEND is defined.

  //This creates a new GdkPixbuf or returns the original with a reference.
  
  Glib::RefPtr<Pixbuf> apply_embedded_orientation();

  /** Obtains the available information about the image formats supported by GdkPixbuf.
   * @result A list of PixbufFormats describing the supported image formats.
   */
  static std::vector<PixbufFormat> get_formats();
  

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The colorspace in which the samples are interpreted.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Colorspace > property_colorspace() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The number of samples per pixel.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< int > property_n_channels() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the pixbuf has an alpha channel.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_has_alpha() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The number of bits per sample.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< int > property_bits_per_sample() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The number of columns of the pixbuf.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< int > property_width() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The number of rows of the pixbuf.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< int > property_height() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The number of bytes between the start of a row and the start of the next row.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< int > property_rowstride() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** A pointer to the pixel data of the pixbuf.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< void* > property_pixels() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Gdk


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gdk::Pixbuf
   */
  Glib::RefPtr<Gdk::Pixbuf> wrap(GdkPixbuf* object, bool take_copy = false);
}


#endif /* _GDKMM_PIXBUF_H */

